<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing KeywordStatisticsSearchResultType
 *
 * Keyword statistics search result.
 * XSD Type: KeywordStatisticsSearchResultType
 */
class KeywordStatisticsSearchResultType extends Type
{

    /**
     * @var string
     */
    protected $keyword = null;

    /**
     * @var integer
     */
    protected $itemHits = null;

    /**
     * @var integer
     */
    protected $size = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getKeyword()
    {
        return $this->keyword;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return KeywordStatisticsSearchResultType
     */
    public function setKeyword($value)
    {
        $this->keyword = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getItemHits()
    {
        return $this->itemHits;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return KeywordStatisticsSearchResultType
     */
    public function setItemHits($value)
    {
        $this->itemHits = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return KeywordStatisticsSearchResultType
     */
    public function setSize($value)
    {
        $this->size = $value;
        return $this;
    }
}
