<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing MailTipsType
 *
 *
 * XSD Type: MailTips
 */
class MailTipsType extends Type
{

    /**
     * @var \garethp\ews\API\Type\EmailAddressType
     */
    protected $recipientAddress = null;

    /**
     * @var string[]
     */
    protected $pendingMailTips = null;

    /**
     * @var \garethp\ews\API\Type\OutOfOfficeMailTipType
     */
    protected $outOfOffice = null;

    /**
     * @var boolean
     */
    protected $mailboxFull = null;

    /**
     * @var string
     */
    protected $customMailTip = null;

    /**
     * @var integer
     */
    protected $totalMemberCount = null;

    /**
     * @var integer
     */
    protected $externalMemberCount = null;

    /**
     * @var integer
     */
    protected $maxMessageSize = null;

    /**
     * @var boolean
     */
    protected $deliveryRestricted = null;

    /**
     * @var boolean
     */
    protected $isModerated = null;

    /**
     * @var boolean
     */
    protected $invalidRecipient = null;

    /**
     * @autogenerated This method is safe to replace
     * @return EmailAddressType
     */
    public function getRecipientAddress()
    {
        return $this->recipientAddress;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType
     * @return MailTipsType
     */
    public function setRecipientAddress(EmailAddressType $value)
    {
        $this->recipientAddress = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return MailTipsType
     */
    public function addPendingMailTips($value)
    {
        if ($this->pendingMailTips === null) {
                        $this->pendingMailTips = array();
        }

        if (!is_array($this->pendingMailTips)) {
            $this->pendingMailTips = array($this->pendingMailTips);
        }

        $this->pendingMailTips[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getPendingMailTips()
    {
        return $this->pendingMailTips;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return MailTipsType
     */
    public function setPendingMailTips(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->pendingMailTips = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return OutOfOfficeMailTipType
     */
    public function getOutOfOffice()
    {
        return $this->outOfOffice;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value OutOfOfficeMailTipType
     * @return MailTipsType
     */
    public function setOutOfOffice(OutOfOfficeMailTipType $value)
    {
        $this->outOfOffice = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isMailboxFull()
    {
        return ((bool) $this->mailboxFull);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getMailboxFull()
    {
        return $this->mailboxFull;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return MailTipsType
     */
    public function setMailboxFull($value)
    {
        $this->mailboxFull = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getCustomMailTip()
    {
        return $this->customMailTip;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return MailTipsType
     */
    public function setCustomMailTip($value)
    {
        $this->customMailTip = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getTotalMemberCount()
    {
        return $this->totalMemberCount;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return MailTipsType
     */
    public function setTotalMemberCount($value)
    {
        $this->totalMemberCount = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getExternalMemberCount()
    {
        return $this->externalMemberCount;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return MailTipsType
     */
    public function setExternalMemberCount($value)
    {
        $this->externalMemberCount = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getMaxMessageSize()
    {
        return $this->maxMessageSize;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return MailTipsType
     */
    public function setMaxMessageSize($value)
    {
        $this->maxMessageSize = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isDeliveryRestricted()
    {
        return ((bool) $this->deliveryRestricted);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getDeliveryRestricted()
    {
        return $this->deliveryRestricted;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return MailTipsType
     */
    public function setDeliveryRestricted($value)
    {
        $this->deliveryRestricted = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isModerated()
    {
        return ((bool) $this->isModerated);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIsModerated()
    {
        return $this->isModerated;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return MailTipsType
     */
    public function setIsModerated($value)
    {
        $this->isModerated = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isInvalidRecipient()
    {
        return ((bool) $this->invalidRecipient);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getInvalidRecipient()
    {
        return $this->invalidRecipient;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return MailTipsType
     */
    public function setInvalidRecipient($value)
    {
        $this->invalidRecipient = $value;
        return $this;
    }
}
