<?php

namespace garethp\ews\API\Type;

/**
 * Class representing PathToExtendedFieldType
 *
 * Represents an extended property. Note that there are only a couple of valid
 * attribute
 *  combinations. Note that all occurances require the PropertyType attribute.
 *
 *  1. (DistinguishedPropertySetId || PropertySetId) + (PropertyName || Property
 * Id)
 *  2. PropertyTag
 * XSD Type: PathToExtendedFieldType
 */
class PathToExtendedFieldType extends BasePathToElementType
{

    /**
     * @var string
     */
    protected $distinguishedPropertySetId = null;

    /**
     * @var string
     */
    protected $propertySetId = null;

    /**
     * @var integer
     */
    protected $propertyTag = null;

    /**
     * @var string
     */
    protected $propertyName = null;

    /**
     * @var integer
     */
    protected $propertyId = null;

    /**
     * @var string
     */
    protected $propertyType = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getDistinguishedPropertySetId()
    {
        return $this->distinguishedPropertySetId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PathToExtendedFieldType
     */
    public function setDistinguishedPropertySetId($value)
    {
        $this->distinguishedPropertySetId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getPropertySetId()
    {
        return $this->propertySetId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PathToExtendedFieldType
     */
    public function setPropertySetId($value)
    {
        $this->propertySetId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getPropertyTag()
    {
        return $this->propertyTag;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return PathToExtendedFieldType
     */
    public function setPropertyTag($value)
    {
        $this->propertyTag = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getPropertyName()
    {
        return $this->propertyName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PathToExtendedFieldType
     */
    public function setPropertyName($value)
    {
        $this->propertyName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getPropertyId()
    {
        return $this->propertyId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return PathToExtendedFieldType
     */
    public function setPropertyId($value)
    {
        $this->propertyId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getPropertyType()
    {
        return $this->propertyType;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PathToExtendedFieldType
     */
    public function setPropertyType($value)
    {
        $this->propertyType = $value;
        return $this;
    }
}
