<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing PeriodType
 *
 *
 * XSD Type: PeriodType
 */
class PeriodType extends Type
{

    /**
     * @var \DateInterval
     */
    protected $bias = null;

    /**
     * @var string
     */
    protected $name = null;

    /**
     * @var string
     */
    protected $id = null;

    /**
     * @autogenerated This method is safe to replace
     * @return \DateInterval
     */
    public function getBias()
    {
        return $this->bias;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateInterval|string
     * @return PeriodType
     */
    public function setBias(\DateInterval|string $value)
    {
        if (is_string($value)) {
            $invert = false;
            if (str_starts_with($value, "-")) {
                $invert = true;
                $value = substr($value, 1);
            }
            $value = new \DateInterval($value);
            $value->invert = $invert;
        }

        $this->bias = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PeriodType
     */
    public function setName($value)
    {
        $this->name = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PeriodType
     */
    public function setId($value)
    {
        $this->id = $value;
        return $this;
    }
}
