<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing PermissionSetType
 *
 * The set of permissions on a folder
 * XSD Type: PermissionSetType
 */
class PermissionSetType extends Type
{

    /**
     * @var \garethp\ews\API\Type\PermissionType[]
     */
    protected $permissions = null;

    /**
     * @var string[]
     */
    protected $unknownEntries = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value PermissionType
     * @return PermissionSetType
     */
    public function addPermissions(PermissionType $value)
    {
        if ($this->permissions === null) {
                        $this->permissions = array();
        }

        if (!is_array($this->permissions)) {
            $this->permissions = array($this->permissions);
        }

        $this->permissions[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return PermissionType[]
     */
    public function getPermissions()
    {
        return $this->permissions;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PermissionType[]|PermissionType
     * @return PermissionSetType
     */
    public function setPermissions(array|PermissionType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->permissions = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PermissionSetType
     */
    public function addUnknownEntries($value)
    {
        if ($this->unknownEntries === null) {
                        $this->unknownEntries = array();
        }

        if (!is_array($this->unknownEntries)) {
            $this->unknownEntries = array($this->unknownEntries);
        }

        $this->unknownEntries[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getUnknownEntries()
    {
        return $this->unknownEntries;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return PermissionSetType
     */
    public function setUnknownEntries(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->unknownEntries = $value;
        return $this;
    }
}
