<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing ProtectionRuleType
 *
 *
 * XSD Type: ProtectionRuleType
 */
class ProtectionRuleType extends Type
{

    /**
     * @var string
     */
    protected $name = null;

    /**
     * @var boolean
     */
    protected $userOverridable = null;

    /**
     * @var integer
     */
    protected $priority = null;

    /**
     * @var \garethp\ews\API\Type\ProtectionRuleConditionType
     */
    protected $condition = null;

    /**
     * @var \garethp\ews\API\Type\ProtectionRuleActionType
     */
    protected $action = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ProtectionRuleType
     */
    public function setName($value)
    {
        $this->name = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isUserOverridable()
    {
        return ((bool) $this->userOverridable);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getUserOverridable()
    {
        return $this->userOverridable;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return ProtectionRuleType
     */
    public function setUserOverridable($value)
    {
        $this->userOverridable = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getPriority()
    {
        return $this->priority;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ProtectionRuleType
     */
    public function setPriority($value)
    {
        $this->priority = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ProtectionRuleConditionType
     */
    public function getCondition()
    {
        return $this->condition;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ProtectionRuleConditionType
     * @return ProtectionRuleType
     */
    public function setCondition(ProtectionRuleConditionType $value)
    {
        $this->condition = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ProtectionRuleActionType
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ProtectionRuleActionType
     * @return ProtectionRuleType
     */
    public function setAction(ProtectionRuleActionType $value)
    {
        $this->action = $value;
        return $this;
    }
}
