<?php

namespace garethp\ews\API\Type;

/**
 * Class representing RecurringTimeTransitionType
 *
 *
 * XSD Type: RecurringTimeTransitionType
 */
class RecurringTimeTransitionType extends TransitionType
{

    /**
     * @var \DateInterval
     */
    protected $timeOffset = null;

    /**
     * @var integer
     */
    protected $month = null;

    /**
     * @autogenerated This method is safe to replace
     * @return \DateInterval
     */
    public function getTimeOffset()
    {
        return $this->timeOffset;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateInterval|string
     * @return RecurringTimeTransitionType
     */
    public function setTimeOffset(\DateInterval|string $value)
    {
        if (is_string($value)) {
            $invert = false;
            if (str_starts_with($value, "-")) {
                $invert = true;
                $value = substr($value, 1);
            }
            $value = new \DateInterval($value);
            $value->invert = $invert;
        }

        $this->timeOffset = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getMonth()
    {
        return $this->month;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return RecurringTimeTransitionType
     */
    public function setMonth($value)
    {
        $this->month = $value;
        return $this;
    }
}
