<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing RuleOperationErrorType
 *
 *
 * XSD Type: RuleOperationErrorType
 */
class RuleOperationErrorType extends Type
{

    /**
     * @var integer
     */
    protected $operationIndex = null;

    /**
     * @var \garethp\ews\API\Type\RuleValidationErrorType[]
     */
    protected $validationErrors = null;

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getOperationIndex()
    {
        return $this->operationIndex;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return RuleOperationErrorType
     */
    public function setOperationIndex($value)
    {
        $this->operationIndex = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RuleValidationErrorType
     * @return RuleOperationErrorType
     */
    public function addValidationErrors(RuleValidationErrorType $value)
    {
        if ($this->validationErrors === null) {
                        $this->validationErrors = array();
        }

        if (!is_array($this->validationErrors)) {
            $this->validationErrors = array($this->validationErrors);
        }

        $this->validationErrors[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return RuleValidationErrorType[]
     */
    public function getValidationErrors()
    {
        return $this->validationErrors;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RuleValidationErrorType[]|RuleValidationErrorType
     * @return RuleOperationErrorType
     */
    public function setValidationErrors(array|RuleValidationErrorType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->validationErrors = $value;
        return $this;
    }
}
