<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing RulePredicateSizeRangeType
 *
 * Size range type used for the WithinSizeRange rule predicate.
 * XSD Type: RulePredicateSizeRangeType
 */
class RulePredicateSizeRangeType extends Type
{

    /**
     * @var integer
     */
    protected $minimumSize = null;

    /**
     * @var integer
     */
    protected $maximumSize = null;

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getMinimumSize()
    {
        return $this->minimumSize;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return RulePredicateSizeRangeType
     */
    public function setMinimumSize($value)
    {
        $this->minimumSize = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getMaximumSize()
    {
        return $this->maximumSize;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return RulePredicateSizeRangeType
     */
    public function setMaximumSize($value)
    {
        $this->maximumSize = $value;
        return $this;
    }
}
