<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing TimeZoneDefinitionType
 *
 *
 * XSD Type: TimeZoneDefinitionType
 */
class TimeZoneDefinitionType extends Type
{

    /**
     * @var string
     */
    protected $id = null;

    /**
     * @var string
     */
    protected $name = null;

    /**
     * @var \garethp\ews\API\Type\PeriodType[]
     */
    protected $periods = null;

    /**
     * @var \garethp\ews\API\Type\ArrayOfTransitionsType[]
     */
    protected $transitionsGroups = null;

    /**
     * @var \garethp\ews\API\Type\ArrayOfTransitionsType
     */
    protected $transitions = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return TimeZoneDefinitionType
     */
    public function setId($value)
    {
        $this->id = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return TimeZoneDefinitionType
     */
    public function setName($value)
    {
        $this->name = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PeriodType
     * @return TimeZoneDefinitionType
     */
    public function addPeriods(PeriodType $value)
    {
        if ($this->periods === null) {
                        $this->periods = array();
        }

        if (!is_array($this->periods)) {
            $this->periods = array($this->periods);
        }

        $this->periods[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return PeriodType[]
     */
    public function getPeriods()
    {
        return $this->periods;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PeriodType[]|PeriodType
     * @return TimeZoneDefinitionType
     */
    public function setPeriods(array|PeriodType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->periods = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ArrayOfTransitionsType
     * @return TimeZoneDefinitionType
     */
    public function addTransitionsGroups(ArrayOfTransitionsType $value)
    {
        if ($this->transitionsGroups === null) {
                        $this->transitionsGroups = array();
        }

        if (!is_array($this->transitionsGroups)) {
            $this->transitionsGroups = array($this->transitionsGroups);
        }

        $this->transitionsGroups[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ArrayOfTransitionsType[]
     */
    public function getTransitionsGroups()
    {
        return $this->transitionsGroups;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ArrayOfTransitionsType[]|ArrayOfTransitionsType
     * @return TimeZoneDefinitionType
     */
    public function setTransitionsGroups(array|ArrayOfTransitionsType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->transitionsGroups = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ArrayOfTransitionsType
     */
    public function getTransitions()
    {
        return $this->transitions;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ArrayOfTransitionsType
     * @return TimeZoneDefinitionType
     */
    public function setTransitions(ArrayOfTransitionsType $value)
    {
        $this->transitions = $value;
        return $this;
    }
}
