<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing WorkingHoursType
 *
 *
 * XSD Type: WorkingHours
 */
class WorkingHoursType extends Type
{

    /**
     * @var \garethp\ews\API\Type\SerializableTimeZoneType
     */
    protected $timeZone = null;

    /**
     * @var \garethp\ews\API\Type\WorkingPeriodType[]
     */
    protected $workingPeriodArray = null;

    /**
     * @autogenerated This method is safe to replace
     * @return SerializableTimeZoneType
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SerializableTimeZoneType
     * @return WorkingHoursType
     */
    public function setTimeZone(SerializableTimeZoneType $value)
    {
        $this->timeZone = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value WorkingPeriodType
     * @return WorkingHoursType
     */
    public function addWorkingPeriodArray(WorkingPeriodType $value)
    {
        if ($this->workingPeriodArray === null) {
                        $this->workingPeriodArray = array();
        }

        if (!is_array($this->workingPeriodArray)) {
            $this->workingPeriodArray = array($this->workingPeriodArray);
        }

        $this->workingPeriodArray[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return WorkingPeriodType[]
     */
    public function getWorkingPeriodArray()
    {
        return $this->workingPeriodArray;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value WorkingPeriodType[]|WorkingPeriodType
     * @return WorkingHoursType
     */
    public function setWorkingPeriodArray(array|WorkingPeriodType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->workingPeriodArray = $value;
        return $this;
    }
}
