<?php
// ===================================================================================================
//                           _  __     _ _
//                          | |/ /__ _| | |_ _  _ _ _ __ _
//                          | ' </ _` | |  _| || | '_/ _` |
//                          |_|\_\__,_|_|\__|\_,_|_| \__,_|
//
// This file is part of the Kaltura Collaborative Media Suite which allows users
// to do with audio, video, and animation what Wiki platforms allow them to do with
// text.
//
// Copyright (C) 2006-2023  Kaltura Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// @ignore
// ===================================================================================================

/**
 * @namespace
 */
namespace Kaltura\Client\Plugin\ScheduleBulkUpload\Type;

/**
 * Represents the Bulk upload job data for CSV bulk upload
 * @package Kaltura
 * @subpackage Client
 */
class BulkUploadScheduleEventCsvJobData extends \Kaltura\Client\Plugin\ScheduleBulkUpload\Type\BulkUploadScheduleEventJobData
{
	public function getKalturaObjectType()
	{
		return 'KalturaBulkUploadScheduleEventCsvJobData';
	}
	
	public function __construct(\SimpleXMLElement $xml = null)
	{
		parent::__construct($xml);
		
		if(is_null($xml))
			return;
		
		if(count($xml->csvVersion))
			$this->csvVersion = (int)$xml->csvVersion;
		if(count($xml->columns))
		{
			if(empty($xml->columns))
				$this->columns = array();
			else
				$this->columns = \Kaltura\Client\ParseUtils::unmarshalArray($xml->columns, "KalturaString");
		}
	}
	/**
	 * The version of the csv file
	 * @var \Kaltura\Client\Plugin\BulkUploadCsv\Enum\BulkUploadCsvVersion
	 * @readonly
	 */
	public $csvVersion = null;

	/**
	 * Array containing CSV headers
	 * @var array<KalturaString>
	 */
	public $columns;

}
