"use strict";
/*
 * Copyright 2013 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// package com.google.zxing.pdf417.decoder;
/**
 * @author Guenther Grau
 */
var Codeword = /** @class */ (function () {
    function Codeword(startX, endX, bucket, value) {
        this.rowNumber = Codeword.BARCODE_ROW_UNKNOWN;
        this.startX = Math.trunc(startX);
        this.endX = Math.trunc(endX);
        this.bucket = Math.trunc(bucket);
        this.value = Math.trunc(value);
    }
    Codeword.prototype.hasValidRowNumber = function () {
        return this.isValidRowNumber(this.rowNumber);
    };
    Codeword.prototype.isValidRowNumber = function (rowNumber) {
        return rowNumber !== Codeword.BARCODE_ROW_UNKNOWN && this.bucket === (rowNumber % 3) * 3;
    };
    Codeword.prototype.setRowNumberAsRowIndicatorColumn = function () {
        this.rowNumber = Math.trunc((Math.trunc(this.value / 30)) * 3 + Math.trunc(this.bucket / 3));
    };
    Codeword.prototype.getWidth = function () {
        return this.endX - this.startX;
    };
    Codeword.prototype.getStartX = function () {
        return this.startX;
    };
    Codeword.prototype.getEndX = function () {
        return this.endX;
    };
    Codeword.prototype.getBucket = function () {
        return this.bucket;
    };
    Codeword.prototype.getValue = function () {
        return this.value;
    };
    Codeword.prototype.getRowNumber = function () {
        return this.rowNumber;
    };
    Codeword.prototype.setRowNumber = function (rowNumber) {
        this.rowNumber = rowNumber;
    };
    //   @Override
    Codeword.prototype.toString = function () {
        return this.rowNumber + '|' + this.value;
    };
    Codeword.BARCODE_ROW_UNKNOWN = -1;
    return Codeword;
}());
exports.default = Codeword;
