<?php
// ===================================================================================================
//                           _  __     _ _
//                          | |/ /__ _| | |_ _  _ _ _ __ _
//                          | ' </ _` | |  _| || | '_/ _` |
//                          |_|\_\__,_|_|\__|\_,_|_| \__,_|
//
// This file is part of the Kaltura Collaborative Media Suite which allows users
// to do with audio, video, and animation what Wiki platfroms allow them to do with
// text.
//
// Copyright (C) 2006-2017  Kaltura Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// @ignore
// ===================================================================================================

/**
 * @namespace
 */
namespace Kaltura\Client\Type;

/**
 * @package Kaltura
 * @subpackage Client
 */
class PostConvertJobData extends \Kaltura\Client\Type\ConvartableJobData
{
	public function getKalturaObjectType()
	{
		return 'KalturaPostConvertJobData';
	}
	
	public function __construct(\SimpleXMLElement $xml = null)
	{
		parent::__construct($xml);
		
		if(is_null($xml))
			return;
		
		if(count($xml->flavorAssetId))
			$this->flavorAssetId = (string)$xml->flavorAssetId;
		if(count($xml->createThumb))
		{
			if(!empty($xml->createThumb))
				$this->createThumb = true;
			else
				$this->createThumb = false;
		}
		if(count($xml->thumbPath))
			$this->thumbPath = (string)$xml->thumbPath;
		if(count($xml->thumbOffset))
			$this->thumbOffset = (int)$xml->thumbOffset;
		if(count($xml->thumbHeight))
			$this->thumbHeight = (int)$xml->thumbHeight;
		if(count($xml->thumbBitrate))
			$this->thumbBitrate = (int)$xml->thumbBitrate;
		if(count($xml->customData))
			$this->customData = (string)$xml->customData;
	}
	/**
	 * 
	 * @var string
	 */
	public $flavorAssetId = null;

	/**
	 * Indicates if a thumbnail should be created
	 * @var bool
	 */
	public $createThumb = null;

	/**
	 * The path of the created thumbnail
	 * @var string
	 */
	public $thumbPath = null;

	/**
	 * The position of the thumbnail in the media file
	 * @var int
	 */
	public $thumbOffset = null;

	/**
	 * The height of the movie, will be used to comapare if this thumbnail is the best we can have
	 * @var int
	 */
	public $thumbHeight = null;

	/**
	 * The bit rate of the movie, will be used to comapare if this thumbnail is the best we can have
	 * @var int
	 */
	public $thumbBitrate = null;

	/**
	 * 
	 * @var string
	 */
	public $customData = null;

}
