<?php

// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.

function prefs_saml_list()
{
    return [
        'saml_auth_enabled' => [
            'name' => tra('Enable SAML Auth'),
            'type' => 'flag',
            'perspective' => false,
            'default' => 'n',
        ],
        'saml_idp_entityid' => [
            'name' => tra('IdP Entity Id'),
            'description' => tra('Identifier of the IdP entity ("Issuer")'),
            'type' => 'text',
            'size' => 50,
            'perspective' => false,
            'default' => '',
        ],
        'saml_idp_sso' => [
            'name' => tra('Single sign-on service URL'),
            'description' => tra('SSO endpoint info of the IdP, the URL target of the IdP where the SP will send the Authentication Request ("SAML 2.0 Endpoint (HTTP)")'),
            'type' => 'text',
            'size' => 50,
            'perspective' => false,
            'default' => '',
        ],
        'saml_idp_slo' => [
            'name' => tra('Single log-out service URL'),
            'description' => tra('SLO endpoint info of the IdP, the URL target of the IdP where the SP will send the SLO Request ("SLO Endpoint (HTTP)")'),
            'type' => 'text',
            'size' => 50,
            'perspective' => false,
            'default' => '',
        ],
        'saml_idp_x509cert' => [
            'name' => tra('X.509 certificate'),
            'description' => tra('Public x509 certificate of the IdP.  ("X.509 certificate")'),
            'type' => 'textarea',
            'perspective' => false,
            'default' => '',
        ],
        'saml_options_autocreate' => [
            'name' => tra('Create user if not registered in Tiki'),
            'description' => tra('Auto-provisioning - if the user doesn\'t exist, Tiki will create a new user with the data provided by the IdP.<br>Review the Mapping section.'),
            'type' => 'flag',
            'perspective' => false,
            'default' => false,
        ],
        'saml_options_sync_group' => [
            'name' => tra('Sync user group with IdP data'),
            'description' => tra('This should be enabled to sync groups with the IdP.'),
            'type' => 'flag',
            'perspective' => false,
            'default' => false,
        ],
        'saml_options_slo' => [
            'name' => tra('Enable Single Logout Service'),
            'description' => tra('The "logout" function logs out the user from the Tiki site, the identity provider and all connected service providers'),
            'type' => 'flag',
            'perspective' => false,
            'default' => false,
        ],
        'saml_options_skip_admin' => [
            'name' => tra('Use Tiki authentication for Admin log-in'),
            'description' => tra('The user “admin” will be authenticated by <b>only</b> using Tiki’s user database. This option has no effect on users other than “admin”.'),
            'type' => 'flag',
            'perspective' => false,
            'default' => 'y',
        ],
        'saml_option_default_group' => [
            'name' => tra('Default group'),
            'description' => tra('When provisioning a new user and not group found, assign that group'),
            'type' => 'text',
            'size' => 20,
            'perspective' => false,
            'default' => 'Registered',
        ],
        'saml_option_account_matcher' => [
            'name' => tra('Account matcher'),
            'description' => tra('Select the field to be used to find the user account. If the "email" field is selected, keep in mind that if users change their email address, then the link with the IdP account will be lost.'),
            'type' => 'list',
            'perspective' => false,
            'options' => [
                'username' => tra('Username'),
                'email' => tra('Email'),
            ],
            'default' => 'email',
        ],
        'saml_option_login_link_text' => [
            'name' => tra('Log-in link text'),
            'description' => tra('The text that appears on the log-in page'),
            'type' => 'text',
            'perspective' => false,
            'default' => 'Log in through SAML2 IdP',
        ],
        'saml_attrmap_username' => [
            'name' => tra('SAML attribute that will be mapped to the Tiki username'),
            'description' => tra('The SAML attribute that will be mapped to the Tiki username.'),
            'type' => 'text',
            'size' => 25,
            'perspective' => false,
            'default' => '',
        ],
        'saml_attrmap_mail' => [
            'name' => tra('SAML attribute that will be mapped to the Tiki email'),
            'description' => tra('The SAML attribute that will be mapped to the Tiki email.'),
            'type' => 'text',
            'size' => 25,
            'perspective' => false,
            'default' => '',
        ],
        'saml_attrmap_group' => [
            'name' => tra('SAML attribute that will be mapped to the Tiki group'),
            'description' => tra('The SAML attribute that will be mapped to the Tiki email. For example the eduPersonAffiliation'),
            'type' => 'text',
            'size' => 25,
            'perspective' => false,
            'default' => '',
        ],
        'saml_groupmap_admins' => [
            'name' => tra('Admins'),
            'description' => tra('Set here the values of the IdP related to the user group info that will be matched with the Admins group.'),
            'type' => 'text',
            'size' => 25,
            'perspective' => false,
            'default' => '',
        ],
        'saml_groupmap_registered' => [
            'name' => tra('Registered'),
            'description' => tra('Set here the values of the IdP related to the user group info that will be matched with the Registered group.'),
            'type' => 'text',
            'size' => 25,
            'perspective' => false,
            'default' => '',
        ],
        'saml_advanced_debug' => [
            'name' => tra('Debug Mode'),
            'description' => tra('Enable debug mode when your are debugging the SAML workflow. Errors and warnings will be showed..'),
            'type' => 'flag',
            'perspective' => false,
            'default' => '',
        ],
        'saml_advanced_strict' => [
            'name' => tra('Strict Mode'),
            'description' => tra('Always enable strict mode on production websites. When strict mode is enabled, then Tiki will reject unsigned or unencrypted messages if it expects them to be signed or encrypted.
               Also Tiki will reject messages that do not strictly follow the SAML standard: Destination, NameId, Conditions . . . are also validated.'),
            'type' => 'flag',
            'perspective' => false,
            'default' => false,
        ],
        'saml_advanced_sp_entity_id' => [
            'name' => tra('Service Provider Entity ID'),
            'description' => tra('Set the Entity ID for the service provider. It is recommended to set as the SP Entity ID the URL where the metadata of the service provider is published. If not provided, the toolkit will use "php-saml" as the SP entityID.'),
            'type' => 'text',
            'perspective' => false,
            'default' => '',
        ],
        'saml_advanced_nameidformat' => [
            'name' => tra('Requested NameIDFormat'),
            'description' => tra('Specifies constraints on the name identifier to be used to represent the requested subject.'),
            'type' => 'list',
            'perspective' => false,
            'options' => [
                'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified' => tra('urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified'),
                'urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress' => tra('urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress'),
                'urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName' => tra('urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName'),
                'urn:oasis:names:tc:SAML:2.0:nameid-format:entity' => tra('urn:oasis:names:tc:SAML:2.0:nameid-format:entity'),
                'urn:oasis:names:tc:SAML:2.0:nameid-format:transient' => tra('urn:oasis:names:tc:SAML:2.0:nameid-format:transient'),
                'urn:oasis:names:tc:SAML:2.0:nameid-format:persistent' => tra('urn:oasis:names:tc:SAML:2.0:nameid-format:persistent'),
                'urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted' => tra('urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted'),
                'urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos' => tra('urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos'),
            ],
            'default' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
        ],
        'saml_advanced_requestedauthncontext' => [
            'name' => tra('Requested AuthnContext'),
            'description' => tra('Authentication context: unselect all to accept any type, otherwise select the valid contexts.'),
            'type' => 'list',
            'perspective' => false,
            'options' => [
                'urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified' => tra('urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified'),
                'urn:oasis:names:tc:SAML:2.0:ac:classes:Password' => tra('urn:oasis:names:tc:SAML:2.0:ac:classes:Password'),
                'urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport' => tra('urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport'),
                'urn:oasis:names:tc:SAML:2.0:ac:classes:X509' => tra('urn:oasis:names:tc:SAML:2.0:ac:classes:X509'),
                'urn:oasis:names:tc:SAML:2.0:ac:classes:Smartcard' => tra('urn:oasis:names:tc:SAML:2.0:ac:classes:Smartcard'),
                'urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos' => tra('urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos'),
                'urn:federation:authentication:windows' => tra('urn:federation:authentication:windows'),
            ],
            'default' => 'urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified',
        ],
        'saml_advanced_idp_lowercase_url_encoding' => [
            'name' => tra('Enable Lowercase URL encoding'),
            'description' => tra('Some IdPs such as ADFS can use lowercase URL encoding, but the plugin expects uppercase URL encoding, so enable it to fix incompatibility issues..'),
            'type' => 'flag',
            'perspective' => false,
            'default' => false,
        ],
        'saml_advanced_nameid_encrypted' => [
            'name' => tra('Encrypt nameID'),
            'type' => 'flag',
            'perspective' => false,
            'default' => false,
        ],
        'saml_advanced_authn_request_signed' => [
            'name' => tra('Sign AuthnRequest'),
            'description' => tra('The samlp:AuthnRequest messages sent by this SP will be signed'),
            'type' => 'flag',
            'perspective' => false,
            'default' => false,
        ],
        'saml_advanced_logout_request_signed' => [
            'name' => tra('Sign LogoutRequest'),
            'description' => tra('The samlp:logoutRequest messages sent by this SP will be signed'),
            'type' => 'flag',
            'perspective' => false,
            'default' => false,
        ],
        'saml_advanced_logout_response_signed' => [
            'name' => tra('Sign LogoutResponse'),
            'description' => tra('The samlp:logoutResponse messages sent by this SP will be signed'),
            'type' => 'flag',
            'perspective' => false,
            'default' => false,
        ],
        'saml_advanced_metadata_signed' => [
            'name' => tra('Sign Metadata'),
            'description' => tra('The Metadata published by this SP will be signed'),
            'type' => 'flag',
            'perspective' => false,
            'default' => false,
        ],
        'saml_advanced_want_message_signed' => [
            'name' => tra('Reject Unsigned Messages'),
            'description' => tra('Reject unsigned samlp:Response, samlp:LogoutRequest and samlp:LogoutResponse received'),
            'type' => 'flag',
            'perspective' => false,
            'default' => false,
        ],
        'saml_advanced_want_assertion_signed' => [
            'name' => tra('Reject Unsigned Assertions'),
            'description' => tra('Reject unsigned saml:Assertion received'),
            'type' => 'flag',
            'perspective' => false,
            'default' => false,
        ],
        'saml_advanced_want_assertion_encrypted' => [
            'name' => tra('Reject Unencrypted Assertions'),
            'description' => tra('Reject unencrypted saml:Assertion received'),
            'type' => 'flag',
            'perspective' => false,
            'default' => false,
        ],
        'saml_advanced_retrieve_parameters_from_server' => [
            'name' => tra('Retrieve Parameters From Server'),
            'description' => tra('Sometimes when the app is behind a firewall or proxy, the query parameters can be modified an this affects the signature validation process on HTTP-Redirect binding. Active this when you noticed signature validation failures, the plugin will try to extract the original query parameters.'),
            'type' => 'flag',
            'perspective' => false,
            'default' => false,
        ],
        'saml_advanced_sp_x509cert' => [
            'name' => tra('Service Provider X.509 certificate'),
            'description' => tra('Public x509 certificate of the SP'),
            'type' => 'textarea',
            'perspective' => false,
            'default' => '',
        ],
        'saml_advanced_sp_privatekey' => [
            'name' => tra('Service Provider Private Key'),
            'description' => tra('Private key of the SP'),
            'type' => 'textarea',
            'perspective' => false,
            'default' => '',
        ],
        'saml_advanced_sign_algorithm' => [
            'name' => tra('Signature Algorithm'),
            'description' => tra('Algorithm that the toolkit will use on the signing process'),
            'type' => 'list',
            'perspective' => false,
            'options' => [
                'http://www.w3.org/2000/09/xmldsig#rsa-sha1' => tra('http://www.w3.org/2000/09/xmldsig#rsa-sha1'),
                'http://www.w3.org/2001/04/xmldsig-more#rsa-sha256' => tra('http://www.w3.org/2001/04/xmldsig-more#rsa-sha256'),
                'http://www.w3.org/2001/04/xmldsig-more#rsa-sha384' => tra('http://www.w3.org/2001/04/xmldsig-more#rsa-sha384'),
                'http://www.w3.org/2001/04/xmldsig-more#rsa-sha512' => tra('http://www.w3.org/2001/04/xmldsig-more#rsa-sha512'),
                'http://www.w3.org/2000/09/xmldsig#dsa-sha1' => tra('http://www.w3.org/2000/09/xmldsig#dsa-sha1'),
            ],
            'default' => 'http://www.w3.org/2000/09/xmldsig#rsa-sha1',
        ],
    ];
}
