define([
    'backbone',
    '../models/email-sequence-trigger',
    'backbone.paginator'
], function(Backbone, StatusModel){

    var EmailSequenceTriggerCollection = Backbone.Paginator.requestPager.extend({
        model: StatusModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/emailsequence/emailsequencetrigger/id/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     100,
            totalPages:  100
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            sequenceId: function(){return this.sequenceId;}
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }

            this.productsData = response.productsData;
            this.limitedAccess = response.limitedAccess;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }
    });

    return EmailSequenceTriggerCollection;
});