import plupload from 'plupload';
import localeMapping from '../../../localizationLanguages';

export default {
    data() {
        return {
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#system-language-import-contacts-data').val(),
            uploaderFolder: '',
            sampleLeadsFileUploader: null,
            uploadPath: '',
        }
    },
    components: {},
    computed: {
        leadsTotalCount() {
            return this.$store.state.leadsImportStore.totalLeadsQuantity;
        },
        leadsImportedCount() {
            return this.$store.state.leadsImportStore.importedLeadsQuantity;
        }
    },
    methods: {

        filesAdded: function (up, files) {
            this.sampleLeadsFileUploader.settings.multipart_params.secureToken = $('#import-contacts-data-config-token').val();
            this.sampleLeadsFileUploader.settings.multipart_params.importType = 'lead';
            this.sampleLeadsFileUploader.settings.multipart_params.isImportContactsData = true;
            this.sampleLeadsFileUploader.start();
            showLoader();
        },

        uploadProgress: function (up, file) {
        },

        fileUploaded: function (up, file, info) {

            let response = jQuery.parseJSON(info.response);
            hideLoader();
            if (response.error == '0') {
                this.$store.commit('setTotalLeadsQuantity', response.responseText.quantity);
                this.importData();
            } else {
                showMessage(response.message, true, 5000);
            }
            $('#progressbar').delay(800).fadeOut();
        },

        handleUploadErrors: function () {
        },

        beforeUpload: function (up, file) {
            this.$store.commit('setTotalLeadsQuantity', 0);
            this.$store.commit('resetImportedLeadsQuantity');
            this.$store.commit('setImportLeadsError', {isError: 0, message: ""});
            this.$store.commit('setErrorLink', {isErrorLink: 0, errorLink: ""});
        },

        getDefaultPluploadOption: function () {
            let options = {
                runtimes: 'html5,flash,html4',
                browse_button: 'upload-file-button',
                container: document.getElementById('upload-file-uploader'),
                max_file_size: '100mb',
                url: $('#website_url').val() + 'plugin/leads/run/uploadLeadsOrganizationsCsv/',
                filters: [
                    {title: "CSV files", extensions: "csv"}
                ],
                multipart_params: {
                    secureToken: '',
                    folder: '',
                    useExtendedConfiguration: 0
                }
            };

            return options;
        },

        async importData() {
            const result = await this.$store.dispatch('importProcedure', {
                'router': this.$router
            });
            if (result.error == '1') {
            } else {
                this.importData();
            }
        }
    },
    async created() {

    },
    async updated() {

    },
    async mounted() {
        let pluploadOptions = this.getDefaultPluploadOption();
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.sampleLeadsFileUploader = new plupload.Uploader(pluploadOptions);
        this.sampleLeadsFileUploader.init();
        this.sampleLeadsFileUploader.bind('BeforeUpload', this.beforeUpload);
        this.sampleLeadsFileUploader.bind('FilesAdded', this.filesAdded);
        this.sampleLeadsFileUploader.bind('UploadProgress', this.uploadProgress);
        this.sampleLeadsFileUploader.bind('FileUploaded', this.fileUploaded);
        this.sampleLeadsFileUploader.bind('Error', this.handleUploadErrors);
    },
}
