import {mapGetters} from 'vuex';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
export default {
    data () {
        return {
            loadedForm: false,
            loadedGrid: false,
            addCustomFieldsGrid: false,
            websiteUrl: $('#website_url').val(),
            customTabFieldType: '',
            customTabName: '',
            customTabLabel: '',
            tabType: '',
            customParams: {},
            customTabId: null,
            localeMapping: localeMapping,
            locale: $('#system-language-custom-fields').val()
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        configDataInfo: function() {
            return this.$store.getters.getConfigDataInfo;
        }
    },
    methods: {
        async deleteConfigItem(id){
            showConfirm(this.$t('message.areYouShure'), async () => {
                const result = await this.$store.dispatch('deleteConfigRecord', {'id': id});
                console.log('deleteTab',result);
                if (result.status === 'error') {
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    showMessage(result.message, false, 2000);
                    const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                    if(result.status === 'error') {

                    } else {
                        this.loadedGrid = true;
                    }
                }
            });
        },
        async addNewTab(e){
            let customTabFieldType = this.customTabFieldType;

            if(customTabFieldType == '') {
                showMessage(this.$t('message.pleaseSelectTabType'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('saveConfigData', {
                'customTabFieldType':this.customTabFieldType,
                'customTabName':this.customTabName.replace(/[^a-zA-Z0-9-_ ]/g, ''),
                'customTabLabel':this.customTabLabel.replace(/[^a-zA-Z0-9'-_ ]/g, '')
            });
            console.log('addNewTab',result);

            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                this.customTabFieldType = '';
                this.customTabName = '';
                this.customTabLabel = '';
                showMessage(result.message, false, 2000);
                const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                if(result.status === 'error') {

                } else {
                    this.loadedGrid = true;
                }
            }
        },
        async updateLabel(id, oldLabel, event) {
            let tabLabel = event.target.value;

            tabLabel = tabLabel.replace(/[^a-zA-Z0-9'-_ ]/g, '');

            if(tabLabel.length < 1) {
                showMessage(this.$t('message.tabLabelNotEmpty'), true, 2000);
                event.target.value = oldLabel;
                return false;
            } else {
                const result = await this.$store.dispatch('updateTabLabel', {'id': id, 'tabLabel': tabLabel});
                console.log('updateTabLabel',result);

                if (result.status === 'error') {
                    event.target.value = oldLabel;
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    event.target.value = tabLabel;
                    showMessage(result.message, false, 2000);
                    return true;
                }
            }
        },
        async editTabCustomFields(id){
            const result = await this.$store.dispatch('getCustomFieldsData', {'id': id});
            console.log('editTabCustomFields', result);
            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                $('#custom-fields-tabs-sortable').sortable({
                    deactivate: this.processDragableCustomFieldsTab
                });
                this.customTabId = id;
                this.loadedGrid = false;
                this.addCustomFieldsGrid = true;

                this.tabType = result.tabType;
                this.customParams = result.customParams;
            }
        },
        backToMainGrid: function () {
            this.addCustomFieldsGrid = false;
            this.loadedGrid = true;
        },
        changeCustomFieldState: function (id) {
            const result = this.$store.dispatch('updateCustomField', {'customTabId': this.customTabId, 'customFieldId': id, 'tabType': this.tabType});

            console.log('updateCustomField', result);
            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            }
        },
        processDragableCustomFieldsTab: function () {
            const resultCustomFieldsData = this.$store.dispatch('setDraggableCustomFieldsData', {'customTabId': this.customTabId});
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
        console.log('created', result);
        if(result.status === 'error') {
            showMessage('Please re-login', true, 3000);
        } else {
            this.loadedForm = true;
        }
        if(result.status === 'error') {

        } else {
            this.loadedGrid = true;
        }
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
