import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import moment from 'moment';
import { isProxy, toRaw } from 'vue';

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            emailSequences:[],
            selectedSequence:0,
            filterAddnewRemoveFlag:'addnew',
            allFilterLeads:0,
            filter:'',
            itemsQuantity:0,
            itemsProcessed:0,
            displayProcessedSequences:false,
        }
    },
    components: {

    },
    computed: {
        ...mapGetters({
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            truncateText: 'truncateText',
            unescapeValue:'unescapeValue',
            checkedItemsData:'getCheckedItems',
            totalFoundItems:'getTotalItemsFound',
            filterData:'getFilterData',
            alphabeticalSort:'alphabeticalSort',
            ucFirstAllText:'ucFirstAllText',
        })
    },
    watch: {

    },
    methods: {
        closeMassAction() {
            this.$store.commit('setActiveMassAction', 0);
        },
        async submitRegularForm()
        {
            let filters = toRaw(this.filterData),
                self = this;

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            if(this.selectedSequence == 0) {
                showMessage(this.$t('message.pleaseChooseEmailSmsSequence'), true, 5000);
                return false;
            }

            if (this.itemsQuantity >= 100) {
                showConfirm(this.$t('message.jobRunInTheBackground'), function(){
                    self.processLeadsSequencesProcedure(0);
                }, function () {

                });
            } else {
                if(this.allFilterLeads) {
                    this.processLeadsSequencesProcedure(0);
                } else {
                    const result = await this.$store.dispatch('assignUnassignEmailSequenceMassAction', {
                        'router': this.$router,
                        'leadEmailSequenceId': this.selectedSequence,
                        'leadIds': Object.keys(this.checkedItemsData).join(','),
                        'filters': filters,
                        'allFilterLeads': this.allFilterLeads,
                        'requestType': this.filterAddnewRemoveFlag,
                        'offset': 0
                    });

                    if(result.error != 1) {
                        showMessage(result.responseText.message, false, 3000);
                        this.closeMassAction();
                    } else {
                        showMessage(result.responseText, true, 5000);
                    }
                }
            }
        },
        async processLeadsSequencesProcedure(offset)
        {
            this.displayProcessedSequences = true;

            let quantity = 0,
                filters = toRaw(this.filterData);

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            const result = await this.$store.dispatch('assignUnassignEmailSequenceMassAction', {
                'router': this.$router,
                'leadEmailSequenceId' : this.selectedSequence,
                'leadIds': Object.keys(this.checkedItemsData).join(','),
                'filters': filters,
                'allFilterLeads': this.allFilterLeads,
                'requestType': this.filterAddnewRemoveFlag,
                'offset': offset
            });

            if (result.error != '1') {
                if(typeof result.responseText.offset !== 'undefined') {
                    quantity = parseInt(result.responseText.leadsCount);
                    this.itemsProcessed = this.itemsProcessed + quantity;
                    await this.processLeadsSequencesProcedure(result.responseText.offset);
                } else {
                    showMessage(result.responseText, false, 3000);
                    this.closeMassAction();
                }
            } else {
                showMessage(result.responseText, true, 5000);
                this.closeMassAction();
            }
        },
        async getEmailSequences()
        {
            const result = await this.$store.dispatch('getEmailSequencesMassAction', {
                'router': this.$router
            });

            if (result.error === 1) {
                showMessage(this.$t('message.smsNoMassActionRecordsFound'), true, 3000);
                this.closeMassAction();
                return false;
            } else {
                this.itemsQuantity = parseInt(Object.keys(this.checkedItemsData).length);
                this.emailSequences = result.emailSequences;
            }
        },
        async countLeads(event)
        {
            let isChecked = event.target.checked;

            if (isChecked === true) {
                this.allFilterLeads = 1;
                let filters = toRaw(this.filterData);

                if (Object.keys(filters).length === 0) {
                    filters = {};
                }

                const result = await this.$store.dispatch('countLeadsMassAction', {
                    'router': this.$router,
                    'filters': filters,
                    'existMobileNumber': 0,
                });

                if(result.error != 1) {
                    this.itemsQuantity = parseInt(result.responseText.quantity);
                }
            } else {
                this.allFilterLeads = 0;
                this.itemsQuantity = parseInt(Object.keys(this.checkedItemsData).length);
            }

        },
        async getInitialData()
        {
            if (Object.keys(this.checkedItemsData).length === 0) {
                showMessage(this.$t('message.pleaseChooseAtLeastOneLead'), true, 3000);
                this.closeMassAction();
            }

            await this.getEmailSequences();

            if (this.itemsQuantity > 0) {
                this.loadedScreen = true;
            }
        },
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.getInitialData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
