
export const getGeneralOpportunitiesScreenData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leadsopportunities/welcomescreen/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'id': payload.id
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                commit('setAdditionalInfo', response.additionalInfo);
                commit('setCurrencyInfo', response.currencyInfo);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getGeneralopportunities = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#opportunities-block', 'opportunities-and-sales-stats-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leadsopportunities/opportunitiesinfo/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'userId':payload.userId,
                'filterDateFrom':payload.filterDateFrom,
                'filterDateTo':payload.filterDateTo,
            }
        }).done(async  function(response){
            hideSpinner('.opportunities-and-sales-stats-spinner');
            if (response.status !== 'error') {
                commit('setOpportunities', response.opportunities);
                commit('setOpportunitiesAdditionalInfo', response.opportunitiesAdditionalInfo);
                commit('setCurrencyInfo', response.currencyInfo);
                commit('setForecastedSales', response.forecastedSales);
                commit('setPipelineSize', response.pipelineSize);
                commit('setUnqualified', response.opportunities.Unqualified);
                commit('setNeedsAssessment', response.opportunities.NeedsAssessment);
                commit('setQualified', response.opportunities.Qualified);
                commit('setMeetingSet', response.opportunities.MeetingSet);
                commit('setMeetingHeld', response.opportunities.MeetingHeld);
                commit('setProposalSent', response.opportunities.ProposalSent);
                commit('setProposalAcknowledged', response.opportunities.ProposalAcknowledged);
                commit('setObjectionsRaised', response.opportunities.ObjectionsRaised);
                commit('setObjectionsOvercame', response.opportunities.ObjectionsOvercame);
                commit('setLost', response.opportunities.Lost);
                commit('setWon', response.opportunities.Won);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const hideOpportunity = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leadsopportunities/hideopportunities/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'opportunityId'     :payload.id,
                'opportunityStageId':payload.opportunityStageId,
                'userId'            :payload.userId,
                'secureToken'       :$('#opportunities-config-token').val(),
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const changeOpportunityStage = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leadsopportunities/opportunitiesinfo/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'opportunityId'     :payload.opportunityId,
                'toDraggableStageId':payload.toDraggableStageId,
                'userId'            :payload.userId,
                'filterDateFrom'    :payload.filterDateFrom,
                'filterDateTo'      :payload.filterDateTo,
                'secureToken'       :$('#opportunities-config-token').val(),
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

























