define([
    'backbone',
    '../models/lead-workflows-config',
    'backbone.paginator'
], function(Backbone, LeadWorkflowModel){

    var LeadWorkflowConfigCollection = Backbone.Paginator.requestPager.extend({
        model: LeadWorkflowModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/leadworkflow/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     10,
            totalPages:  10
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            isGrid: function(){ return this.isGrid; },
            detailedInfo: function(){ return this.detailedInfo; },
            customPaginate: function(){ return this.customPaginate; },
            order: function(){ return this.order; }
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }

            if(this.customPaginate) {
                this.perPage = this.customPaginate;
            }

            this.cronScriptPathAudiences = response.cronScriptPathAudiences;
            this.leadOwners = response.leadOwners;
            this.customerGroups = response.customerGroups;
            this.countryCodes = response.countryCodes;
            this.scorePropertyActions = response.scorePropertyActions;
            this.scoreActions = response.scoreActions;
            this.stages = response.stages;
            this.industries = response.industries;
            this.ruleSetLegends = response.ruleSetLegends;
            this.leadTags = response.leadTags;
            this.userTimezone = response.userTimezone;
            this.currentUserId = response.currentUserId;
            this.userTimezoneOffset = response.userTimezoneOffset;
            this.timezoneOffset = response.timezoneOffset;
            this.leadsPredefinedValues = response.leadsPredefinedValues;
            this.opportunityStages = response.opportunityStages;
            this.opportunityTypes = response.opportunityTypes;
            this.emailSequencies = response.emailSequencies;
            this.emailTemplates = response.emailTemplates;
            this.emailServices = response.emailServices;
            this.limitedAccess = response.limitedAccess;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return LeadWorkflowConfigCollection;
});
