define([
    'backbone',
    '../models/lead-profile-visit',
    'backbone.paginator'
], function(Backbone, LeadProfileVisitModel){

    var LeadsProfileVisitCollection = Backbone.Paginator.requestPager.extend({
        model: LeadProfileVisitModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/leadprofilevisit/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     100,
            totalPages:  100
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            userProfileLogId:function(){return this.userProfileLogId}

        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return LeadsProfileVisitCollection;
});