define([
    'backbone',
    '../collections/leads',
    'text!../templates/paginator.html',
    'text!../templates/callWindow.html',
    'text!../templates/lead-grid-row.html',
    'text!../templates/lead-action-assign-owner.html',
    'text!../templates/lead-action-email-service.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment',
    'chosen',
    'accounting',
    'text!../templates/lead-export-dialog.html',
    'text!../templates/lead-action-email-sequence.html',
    'text!../templates/lead-action-assign-tags.html',
    'text!../templates/lead-merge-dialog.html',
    'text!../templates/mass-delete-dialog.html',
    'text!../templates/mass-delete-and-mark-as-spam-dialog.html',
    'text!../templates/mass-delete-bounced-dialog.html',
    'text!../templates/lead-action-remarketing.html',
    'text!../templates/lead-action-sms-sending.html',
    'text!../templates/validate-emails-dialog.html',
    'tinyMCE',
    'leadshortcode',
    'leadtestsms',
    'placeholder',
    'charlimit'
], function(Backbone,
            LeadsCollection, PaginatorTmpl, CallDialogTmpl, LeadGridRowTmpl, LeadActionAssignOwnerTemplate,
            LeadActionEmailServiceTemplate, i18n, moment, chosen, accounting, leadExportDialog,
            leadActionEmailSequenceTemplate, leadActionAssignTagsTemplate, leadMergeDialog, massDeleteDialog, massDeleteAndMarkAsSpamDialog,
            massDeleteBouncedDialog, leadActionRemarketingTemplate, LeadActionSmsSendingTemplate, validateEmailsDialog,
            tinymce, leadshortcode, leadtestsms, placeholder, charlimit
){

    var LeadsGridView = Backbone.View.extend({
        el: $('#lead-table-block'),
        events: {
            'click a[data-role=delete]': 'deleteLead',
            'click a[data-role=delete-and-mark-as-spam]': 'deleteAndMarkAsSpamLead',
            'click a[data-role=call]': 'callLeadDialog',
            'click a[data-role=email]': 'displayEmailTab',
            'click td.lead-grid-paginator a.page': 'navigate',
            'blur input.lead-edit-attribute': 'editLeadAttribute',
            'change select.lead-edit-attribute': 'editLeadAttribute',
            'change input.check-lead-in-grid': 'checkLeadInGrid',
            'change #leads-mass-action': 'massAction',
            'change input.check-all-leads' :'checkAllInGrid',
            'change select.lead-custom-paginator' :'customPaginate'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        beforeSelectedCampaign: {
            'campaign': ''
        },
        campaignSelectedListsIds: {},
        campaignSelectedListsLabels: {},
        initialize: function(options){
            this.$el.find('#lead-grid-table').unbind();

            if (!_.isEmpty(options)) {
                if (typeof options.filter !== 'undefined') {

                    //clean filters
                    var $el = $('#lead-additional-filters');
                    $el.find('input:text').val('');
                    $el.find('select.filter').val('0').trigger('chosen:updated');
                    $('#lead-filter-by-interaction').val('created_at');
                    $('#lead-filter-by-special-type-existing-client').prop('checked', false);
                    $('#lead-filter-by-special-type-prospect').prop('checked', false);
                    $('#lead-filter-by-special-type-no-email').prop('checked', false);
                    $('#switch-created-date').prop('checked', true);
                    $('#switch-updated-date').prop('checked', false);
                    $('#lead-attribute').val('');
                    $('#lead-search-by-keyword1').prop('checked', true);
                    $('#lead-search-by-keyword2').prop('checked', false);
                    $('#call-duration-filter').removeClass('open').hide();
                    $('#email-sub-type-filter').removeClass('open').hide();
                    $('#range-activity-option').val(0);
                    $('#range-creation-option').val(0);
                    $('#source-utm-value-filter').removeClass('open').hide();
                    $('#campaign-utm-value-filter').removeClass('open').hide();

                    //assign filter values
                    if (typeof options.lead_source_type !== 'undefined') {
                        var sourceTypeEl = $('#lead-filter-by-source-type'),
                            filterBysourceTypeEl = sourceTypeEl.closest('div'),
                            selectedCallType = '';

                        sourceTypeEl.val(options.lead_source_type);

                        if(!_.isUndefined(sourceTypeEl)) {
                            selectedCallType = sourceTypeEl.find(':selected').data('type-name');
                        }

                        if(selectedCallType == 'inbound_call' || selectedCallType == 'outbound_call') {
                            if(filterBysourceTypeEl.hasClass('grid_12')) {
                                filterBysourceTypeEl.removeClass('grid_12').addClass('grid_5');
                            }
                            $('#call-duration-filter').removeClass('close').addClass('open').show();
                        } else {
                            if(filterBysourceTypeEl.hasClass('grid_5')) {
                                filterBysourceTypeEl.removeClass('grid_5').addClass('grid_12');
                            }
                            $('#call-duration-filter').removeClass('open').addClass('close').hide();
                        }
                    }

                    if (typeof options.last_interaction_id !== 'undefined') {
                        var lastInteractionEl = $('#lead-filter-by-last-interaction'),
                            filterByLastInteractionEl = $el.closest('div'),
                            lastInteractionType = '';

                        lastInteractionEl.val(options.last_interaction_id);

                        if(!_.isUndefined(lastInteractionEl)) {
                            lastInteractionType = lastInteractionEl.find(':selected').data('type-name');
                        }

                        if(lastInteractionType == 'outbound_email') {
                            if(filterByLastInteractionEl.hasClass('grid_12')) {
                                filterByLastInteractionEl.removeClass('grid_12').addClass('grid_6');
                            }
                            $('#email-sub-type-filter').removeClass('close').addClass('open').show();
                        } else {
                            if(filterByLastInteractionEl.hasClass('grid_6')) {
                                filterByLastInteractionEl.removeClass('grid_6').addClass('grid_12');
                            }
                            $('#email-sub-type-filter').removeClass('open').addClass('close').hide();
                        }
                    }

                    if (typeof options.created_at_from !== 'undefined') {
                        $('#lead-filter-from-date').val(options.created_at_from);
                    }

                    if (typeof options.created_at_to !== 'undefined') {
                        $('#lead-filter-to-date').val(options.created_at_to);
                    }

                    if (typeof options.customer_group_id !== 'undefined') {
                        $('#lead-filter-by-group').val(options.customer_group_id);
                    }

                    if (typeof options.owner_id !== 'undefined') {
                        $('#lead-filter-by-owner').val(options.owner_id);
                    }
                    if (typeof options.opportunity_owner_id !== 'undefined') {
                        $('#lead-filter-by-opportunity-owner').val(options.opportunity_owner_id);
                    }

                    if (typeof options.total_opportunity_amount_from !== 'undefined') {
                        $('#lead-filter-total-opportunity-amount-from').val(options.total_opportunity_amount_from);
                    }

                    if (typeof options.lead_opportunity_stages !== 'undefined') {
                        $('#lead-filter-opportunity-stage').val(options.lead_opportunity_stages.split(','));
                    }

                    if (typeof options.lead_opportunity_types !== 'undefined') {
                        $('#lead-filter-by-opportunity-type').val(options.lead_opportunity_types.split(','));
                    }

                    if (typeof options.change_stage_date_to !== 'undefined') {
                        $('#lead-filter-opportunity-to-date').val(options.change_stage_date_to);
                        $('#switch-stage-change-date').prop('checked', true);
                    }

                    if (typeof options.change_stage_date_from !== 'undefined') {
                        $('#lead-filter-opportunity-date').val(options.change_stage_date_from);
                        $('#switch-stage-change-date').prop('checked', true);
                    }

                    if (typeof options.expected_date_from !== 'undefined') {
                        $('#lead-filter-opportunity-date').val(options.expected_date_from);
                        $('#switch-expected-date').prop('checked', true);
                    }

                    if (typeof options.expected_date_to !== 'undefined') {
                        $('#lead-filter-opportunity-to-date').val(options.expected_date_to);
                        $('#switch-expected-date').prop('checked', true);
                    }

                    if (typeof options.opportunity_created_at_from !== 'undefined') {
                        $('#lead-filter-opportunity-date').val(options.opportunity_created_at_from);
                        $('#switch-creation-date').prop('checked', true);
                    }

                    if (typeof options.opportunity_created_at_to !== 'undefined') {
                        $('#lead-filter-opportunity-to-date').val(options.opportunity_created_at_to);
                        $('#switch-creation-date').prop('checked', true);
                    }

                    if (typeof options.lead_tag !== 'undefined') {
                        $('#lead-filter-tag').val(options.lead_tag);
                    }

                    if (typeof options.email_sms_sequences !== 'undefined') {
                        $('#lead-filter-by-email-sms-sequence').val(options.email_sms_sequences);

                        if (!_.isNull($('#lead-filter-by-email-sms-sequence').val()) && $('#lead-filter-by-email-sms-sequence').val().length > 0) {
                            $('#email-sequence-sub-filter-block').removeClass('hidden');
                            $('#email-sequence-sub-filter-block-second-part').removeClass('hidden');
                        } else {
                            $('#email-sequence-sub-filter-block').addClass('hidden');
                            $('#email-sequence-sub-filter-block-second-part').addClass('hidden');
                        }

                        if ($('#lead-filter-by-email-sequence-type').val() === 'all') {
                            $('#lead-filter-by-email-sequence-type-action').attr('disabled', 'true');
                            $('#lead-filter-by-email-sequence-type-period').attr('disabled', 'true');
                        } else {
                            $('#lead-filter-by-email-sequence-type-action').removeAttr('disabled');
                            $('#lead-filter-by-email-sequence-type-period').removeAttr('disabled');
                        }
                    }

                    if (typeof options.email_sequence_type !== 'undefined') {
                        $('#lead-filter-by-email-sequence-type').val(options.email_sequence_type);
                    }

                    if (typeof options.email_sms_sequences_type_period !== 'undefined') {
                        $('#lead-filter-by-email-sequence-type-period').val(options.email_sms_sequences_type_period);
                    }

                    if (typeof options.email_sequence_type_action !== 'undefined') {
                        $('#lead-filter-by-email-sequence-type-action').val(options.email_sequence_type_action);
                    }

                    if (typeof options.stage_id !== 'undefined') {
                        $('#lead-filter-by-stage').val(options.stage_id.split(','));
                    }

                    if (typeof options.activity_id !== 'undefined') {
                        $('#lead-filter-by-activity-type').val(options.activity_id.split(','));
                    }

                    if (typeof options.range_options !== 'undefined') {
                        if(options.range_options == 'custom') {
                            options.range_options = 0;
                        }

                        if (typeof options.created_at_from !== 'undefined' && typeof options.created_at_to !== 'undefined') {
                            $('#range-creation-option').val(options.range_options);
                        } else if ( typeof options.next_activity_from !== 'undefined' && typeof options.next_activity_to !== 'undefined') {
                            $('#range-activity-option').val(options.range_options);
                        }
                    }

                    if (typeof options.next_activity_from !== 'undefined') {
                        $('#lead-filter-activity-date').val(options.next_activity_from);
                    }

                    if (typeof options.next_activity_to !== 'undefined') {
                        $('#lead-filter-activity-to-date').val(options.next_activity_to);
                    }

                    if ($('#lead-filter-by-email-sequence-type').val() === 'all') {
                        $('#lead-filter-by-email-sequence-type-action').attr('disabled', 'true');
                        $('#lead-filter-by-email-sequence-type-action').val('all');
                        $('#lead-filter-by-email-sequence-type-period').attr('disabled', 'true');
                    } else {
                        $('#lead-filter-by-email-sequence-type-action').removeAttr('disabled');
                        $('#lead-filter-by-email-sequence-type-period').removeAttr('disabled');
                    }

                    if (typeof options.validated_date_to !== 'undefined') {
                        $('#lead-filter-by-email-validated-to-date').val(options.validated_date_to);
                    }

                    if (typeof options.lead_source_type_and_utm !== 'undefined') {
                        var leadSourceTypeAndUtmIds = options.lead_source_type_and_utm.split(',');
                        $('#lead-filter-by-source-type-and-utm').val(leadSourceTypeAndUtmIds);

                        if(leadSourceTypeAndUtmIds.includes('3')) {
                            $('#source-utm-value-filter').removeClass('close').addClass('open').show();
                        } else {
                            $('#source-utm-value-filter').removeClass('open').addClass('close').hide();
                        }

                        if(leadSourceTypeAndUtmIds.includes('5')) {
                            $('#campaign-utm-value-filter').removeClass('close').addClass('open').show();
                        } else {
                            $('#campaign-utm-value-filter').removeClass('open').addClass('close').hide();
                        }
                    }

                    if (typeof options.lead_utm_source_value_id !== 'undefined') {
                        $('#lead-filter-by-source-utm-value').val(options.lead_utm_source_value_id.split(','));
                    }

                    if (typeof options.lead_utm_campaign_value_id !== 'undefined') {
                        $('#lead-filter-by-campaign-utm-value').val(options.lead_utm_campaign_value_id.split(','));
                    }

                    $el.find('#lead-grid-table').removeClass('hidden');
                }
            }
            this.leads = new LeadsCollection();
            this.leads.isGrid = true;

            this.leads.on('reset', this.renderLeads, this);
            this.leads.on('add', this.renderLeads, this);
            this.leads.on('destroy', this.renderLeads, this);

            var filterFromDate = $('#lead-filter-from-date'),
                filterToDate = $('#lead-filter-to-date'),
                filterActivityFrom = $('#lead-filter-activity-date'),
                filterActivityTo = $('#lead-filter-activity-to-date'),
                filterOpportunityFrom = $('#lead-filter-opportunity-date'),
                filterOpportunityTo = $('#lead-filter-opportunity-to-date'),
                filterValidatedTo = $('#lead-filter-by-email-validated-to-date');

            if (filterFromDate.val()) {
                filterFromDate.val($.datepicker.formatDate('d-M-yy', new Date(filterFromDate.val())));
            }

            if (filterToDate.val()) {
                filterToDate.val($.datepicker.formatDate('d-M-yy', new Date(filterToDate.val())));
            }

            if (filterActivityFrom.val()) {
                filterActivityFrom.val($.datepicker.formatDate('d-M-yy', new Date(filterActivityFrom.val())));
            }

            if (filterActivityTo.val()) {
                filterActivityTo.val($.datepicker.formatDate('d-M-yy', new Date(filterActivityTo.val())));
            }

            if (filterOpportunityFrom.val()) {
                filterOpportunityFrom.val($.datepicker.formatDate('d-M-yy', new Date(filterOpportunityFrom.val())));
            }

            if (filterOpportunityTo.val()) {
                filterOpportunityTo.val($.datepicker.formatDate('d-M-yy', new Date(filterOpportunityTo.val())));
            }

            if (filterValidatedTo.val()) {
                filterValidatedTo.val($.datepicker.formatDate('d-M-yy', new Date(filterValidatedTo.val())));
            }

            filterFromDate.datepicker({
                dateFormat: 'd-M-yy',
                defaultDate: "+1w",
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5",
                onSelect: function(selectedDate){
                    filterToDate.datepicker("option", "minDate", selectedDate);
                }
            });
            filterToDate.datepicker({
                dateFormat: 'd-M-yy',
                defaultDate: "+1w",
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5",
                onSelect: function(selectedDate){
                    filterFromDate.datepicker("option", "maxDate", selectedDate);
                }
            });
            filterActivityFrom.datepicker({
                dateFormat: 'd-M-yy',
                defaultDate: "+1w",
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5",
                //minDate: +1,
                onSelect: function(selectedDate){
                    filterActivityTo.datepicker("option", "minDate", selectedDate);
                }
            });

            filterActivityTo.datepicker({
                dateFormat: 'd-M-yy',
                defaultDate: "+1w",
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5",
                onSelect: function(selectedDate){
                    filterActivityFrom.datepicker("option", "maxDate", selectedDate);
                }
            });

            filterOpportunityFrom.datepicker({
                dateFormat: 'd-M-yy',
                defaultDate: "+1w",
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5",
                onSelect: function(selectedDate){
                    filterOpportunityTo.datepicker("option", "minDate", selectedDate);
                }
            });

            filterOpportunityTo.datepicker({
                dateFormat: 'd-M-yy',
                defaultDate: "+1w",
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5",
                onSelect: function(selectedDate){
                    filterOpportunityFrom.datepicker("option", "maxDate", selectedDate);
                }
            });

            filterValidatedTo.datepicker({
                dateFormat: 'd-M-yy',
                defaultDate: "",
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5"
            });

            $('#lead-filter-by-stage').chosen();
            $('#lead-filter-tag').chosen();
            $('#lead-filter-by-email-sms-sequence').chosen();
            $('#lead-filter-tag-exclude').chosen();
            $('#lead-filter-opportunity-stage').chosen();
            $('#lead-filter-by-activity-type').chosen();
            $('#lead-filter-country-state').chosen();
            $('#lead-filter-by-source-type-and-utm').chosen();
            $('#lead-filter-by-source-utm-value').chosen();
            $('#lead-filter-by-campaign-utm-value').chosen();
        },
        render: function(options){
            if (typeof options !== 'undefined') {
                if (typeof options.resetCheckedLeads !== 'undefined' && options.resetCheckedLeads == '1') {
                    delete this.checkedLeadRows;
                    _.each($('input.check-lead-in-grid'), function (el) {
                        $(el).prop('checked', false);
                    });
                }
            }

            var self = this;

            this.leads.server_api = _.extend(this.leads.server_api, {
                'filter': function() {
                    return {
                        'filter-by': $('input[name=searchByKeyword]:checked').val(),
                        'lead-attribute': $('#lead-attribute').val().replace('&', '*-amp-*'),
                        'range_creation_option': $('#range-creation-option').val(),
                        'activity_id': $('#lead-filter-by-activity-type').val(),
                        'range_activity_option': $('#range-activity-option').val(),
                        'stage_id': $('#lead-filter-by-stage').val(),
                        'customer_group_id':$('#lead-filter-by-group').val(),
                        'lead_source_type': $('#lead-filter-by-source-type').val(),
                        'lead_source': $('#lead-filter-by-source').val(),
                        'owner_id': $('#lead-filter-by-owner').val(),
                        'opportunity_owner_id': $('#lead-filter-by-opportunity-owner').val(),
                        'lead_zip': $('#lead-filter-zip').val(),
                        'lead_country': $('#lead-filter-country').val(),
                        'lead_country_state': $('#lead-filter-country-state').val(),
                        'lead_city': $('#lead-filter-city').val(),
                        'total_opportunity_amount_from': $('#lead-filter-total-opportunity-amount-from').val(),
                        'total_opportunity_amount_to': $('#lead-filter-total-opportunity-amount-to').val(),
                        'special_filter_type': $('input[name=leadFilterBySpecialType]:checked').val(),
                        'created_at': $('#switch-created-date:checked').val(),
                        'last_updated': $('#switch-updated-date:checked').val(),
                        'lead_tags': $('#lead-filter-tag').val(),
                        'email_sms_sequences': $('#lead-filter-by-email-sms-sequence').val(),
                        'lead_tags_exclude': $('#lead-filter-tag-exclude').val(),
                        'lead_opportunity_stages': $('#lead-filter-opportunity-stage').val(),
                        'last_interaction_id':$('#lead-filter-by-last-interaction').val(),
                        'opportunity_type_id':$('#lead-filter-by-opportunity-type').val(),
                        'interaction_value':$('#lead-filter-by-interaction').val(),
                        'lead_task':$('#lead-filter-task').val(),
                        'more_less_call_duration': $('#more-less-call-duration').val(),
                        'call_duration':$('#call-duration').val(),
                        'search_includes_notes': $('#search-includes-notes').val(),
                        'search_includes_custom_lead_fields': $('#search-includes-custom-lead-fields').val(),
                        'expected_at': $('#switch-expected-date:checked').val(),
                        'creation_at': $('#switch-creation-date:checked').val(),
                        'state_change_at': $('#switch-stage-change-date:checked').val(),
                        'lead_score_from': $('#lead-filter-score-from').val(),
                        'lead_score_to': $('#lead-filter-score-to').val(),
                        'total_spent_purchase_amount_from': $('#lead-filter-total-spent-purchase-amount-from').val(),
                        'total_spent_purchase_amount_to': $('#lead-filter-total-spent-purchase-amount-to').val(),
                        'outbound_emails_sub_type': $('#outbound-emails-sub-types').val(),
                        'email_status': $('#lead-filter-by-email-status').val(),
                        'industry_id': $('#lead-filter-by-industry').val(),
                        'custom_params_search': self.getCustomParams(),
                        'custom_organization_params_search': self.getOrganizationCustomParams(),
                        'lead_titles': $('#lead-filter-title').val(),
                        'lead_title_operator': $('#lead-filter-title-operator').val(),
                        'lead_filter_nps_score_operator': $('#lead-filter-nps-score-operator').val(),
                        'nps_score': $('#lead-filter-nps-score').val(),
                        'email_validation_status': $('#lead-filter-by-email-validation').val(),
                        'email_sequence_type':$('#lead-filter-by-email-sequence-type').val(),
                        'email_sequence_type_action':$('#lead-filter-by-email-sequence-type-action').val(),
                        'email_sms_sequences_type_period':$('#lead-filter-by-email-sequence-type-period').val(),
                        'created_at_from' : ($('#lead-filter-from-date').val()) ? $.datepicker.formatDate('yy-mm-dd', new Date($('#lead-filter-from-date').val())): '',
                        'created_at_to': ($('#lead-filter-to-date').val()) ? $.datepicker.formatDate('yy-mm-dd', new Date($('#lead-filter-to-date').val())): '',
                        'next_activity_from': ($('#lead-filter-activity-date').val()) ? $.datepicker.formatDate('yy-mm-dd', new Date($('#lead-filter-activity-date').val())): '',
                        'next_activity_to': ($('#lead-filter-activity-to-date').val()) ? $.datepicker.formatDate('yy-mm-dd', new Date($('#lead-filter-activity-to-date').val())): '',
                        'opportunity_date_from': ($('#lead-filter-opportunity-date').val()) ? $.datepicker.formatDate('yy-mm-dd', new Date($('#lead-filter-opportunity-date').val())): '',
                        'opportunity_date_to': ($('#lead-filter-opportunity-to-date').val()) ? $.datepicker.formatDate('yy-mm-dd', new Date($('#lead-filter-opportunity-to-date').val())): '',
                        'validated_date_to': ($('#lead-filter-by-email-validated-to-date').val()) ? $.datepicker.formatDate('yy-mm-dd', new Date($('#lead-filter-by-email-validated-to-date').val())): '',
                        'lead_source_type_and_utm':$('#lead-filter-by-source-type-and-utm').val(),
                        'lead_utm_source_value_id':$('#lead-filter-by-source-utm-value').val(),
                        'lead_utm_campaign_value_id':$('#lead-filter-by-campaign-utm-value').val(),
                    };
                }
            });
            $('#lead-filter-apply').prop('disabled', false);
            $('#lead-attribute').prop('disabled', false);
            if($('#lead-attribute').val() != '') {
                $('#lead-attribute').focus();
            }
            this.leads.pager();
        },
        getCustomParams: function()
        {
            var customParamsData = [],
                fieldType = '',
                year = '',
                month = '',
                day = '',
                value = '';

            $.each($('#custom-attribute-field-row-block').find('.custom-field-row-block'), function () {
                fieldType = $(this).data('field-type'),
                operator = $(this).find('.field-operator-value').val();

                if (fieldType !== 'date') {
                    customParamsData.push({
                        'name': $(this).data('field-name'),
                        'operator': $(this).find('.field-operator-value').val(),
                        'value': $(this).find('.custom-field-row-value').val(),
                        'type': $(this).data('field-type'),
                        'subtype': $(this).data('field-subtype'),
                        'id': $(this).data('field-id'),
                        'label': $(this).data('field-label')
                    });
                } else {
                    year = $(this).find('.custom-field-row-value-year').val();
                    month = $(this).find('.custom-field-row-value-month').val();
                    day = $(this).find('.custom-field-row-value-day').val();
                    value = JSON.stringify({'year':year, 'month':month, 'day':day});

                    customParamsData.push({
                        'name': $(this).data('field-name'),
                        'operator': $(this).find('.field-operator-value').val(),
                        'value': value,
                        'type': $(this).data('field-type'),
                        'subtype': $(this).data('field-subtype'),
                        'id': $(this).data('field-id'),
                        'label': $(this).data('field-label')
                    });
                }
            });

            return customParamsData;
        },
        getOrganizationCustomParams: function()
        {
            var customParamsData = [],
                fieldType = '',
                year = '',
                month = '',
                day = '',
                value = '';

            $.each($('#custom-organization-attribute-field-row-block').find('.custom-field-row-block'), function () {
                fieldType = $(this).data('field-type'),
                    operator = $(this).find('.field-operator-value').val();

                if (fieldType !== 'date') {
                    customParamsData.push({
                        'name': $(this).data('field-name'),
                        'operator': $(this).find('.field-operator-value').val(),
                        'value': $(this).find('.custom-field-row-value').val(),
                        'type': $(this).data('field-type'),
                        'subtype': $(this).data('field-subtype'),
                        'id': $(this).data('field-id'),
                        'label': $(this).data('field-label')
                    });
                } else {
                    year = $(this).find('.custom-field-row-value-year').val();
                    month = $(this).find('.custom-field-row-value-month').val();
                    day = $(this).find('.custom-field-row-value-day').val();
                    value = JSON.stringify({'year':year, 'month':month, 'day':day});

                    customParamsData.push({
                        'name': $(this).data('field-name'),
                        'operator': $(this).find('.field-operator-value').val(),
                        'value': value,
                        'type': $(this).data('field-type'),
                        'subtype': $(this).data('field-subtype'),
                        'id': $(this).data('field-id'),
                        'label': $(this).data('field-label')
                    });
                }
            });

            return customParamsData;
        },
        renderLeads: function(){
            document.getElementById('lead-grid-table-body').innerHTML = '';
            this.leads.each(this.renderLead, this);
            this.leads.info()['i18n'] = i18n;
            this.$('td.lead-grid-paginator').html(this.templates.paginator(this.leads.information));
            $('.leads-filter-paginator-block').show();
            if(!_.isUndefined(this.leads.customPaginate)) {
                $('.lead-custom-paginator').val(this.leads.customPaginate);
            }
            if (typeof tableResponsive === "function") {
                tableResponsive();
            }
            this.assignTotalOpportunitiesAmount(this.leads.pluck("id"));

            var self = this;
            if (!_.isUndefined(this.checkedLeadRows)) {
                _.each($('input.check-lead-in-grid'), function (el) {
                    if (self.checkedLeadRows.indexOf($(el).data('lead-id')) !== -1) {
                        $(el).prop('checked', true);
                    }
                });
            }

            $('input.check-all-leads').prop('checked', false);

            $(".lead-edit-organization").on("keydown", function(event) {
                if ( event.keyCode === $.ui.keyCode.TAB &&
                    $(this).autocomplete( "instance" ).menu.active) {
                    event.preventDefault();
                }
            }).autocomplete({
                    source: function(request, response) {
                        $.ajax({
                            'url': $('#website_url').val()+'api/leads/leadorganization/',
                            'type':'GET',
                            'dataType':'json',
                            'data': {searchTerm: request.term}
                        }).done(function(responseData){
                            if (!_.isEmpty(responseData)) {
                                response($.map(responseData, function (responseData) {
                                    return {
                                        label: responseData.organization_name,
                                        value: responseData.organization_name
                                    };
                                }));
                            }
                        });
                    },
                    search: function() {

                    },
                    focus: function() {
                        return false;
                    },
                    select: function(event, ui) {

                    },
                    messages: {
                        noResults: '',
                        results: function() {}
                    }
            });

            $(".lead-edit-source").on("keydown", function(event) {
                if ( event.keyCode === $.ui.keyCode.TAB &&
                    $(this).autocomplete("instance").menu.active) {
                    event.preventDefault();
                }
            }).autocomplete({
                source: function(request, response) {
                    $.ajax({
                        'url': $('#website_url').val()+'api/leads/leadsource/',
                        'type':'GET',
                        'dataType':'json',
                        'data': {searchTerm: request.term, 'autocomplete':true}
                    }).done(function(responseData){
                        if (!_.isEmpty(responseData)) {
                            response($.map(responseData, function (responseData) {
                                return {
                                    label: responseData.source_name,
                                    value: responseData.source_name
                                };
                            }));
                        }
                    });
                },
                search: function() {

                },
                focus: function() {
                    return false;
                },
                select: function(event, ui) {

                }
            });
        },
        renderLead: function(leadsData){
            this.leads.customerGroupsData = this.alphabeticalSort(this.leads.customerGroups);
            this.leads.leadStagesData = this.alphabeticalSort(this.leads.leadStages);
            this.leads.leadTypesData = this.alphabeticalSort(this.leads.leadTypes);
            this.$el.find('#lead-grid-table-body').append(_.template(LeadGridRowTmpl, {'leadModel': leadsData,
                'customerGroups': this.leads.customerGroupsData, 'stagesList' : this.leads.leadStagesData, 'leadTypeList': this.leads.leadTypesData, 'interactionParam': this.leads.interactionParam, 'moment':moment, 'i18n': i18n, 'userTimezoneOffset': this.leads.userTimezoneOffset}));

            var desktopMasks = this.leads.desktopMasks,
                desktopCountryCode = leadsData.get('lead_mobile_country_code');

            if (typeof desktopMasks[desktopCountryCode] !== 'undefined') {
                $('#lead-edit-attribute-mobile-'+leadsData.get('id')).mask(desktopMasks[desktopCountryCode].mask_value, {autoclear: false});
            } else {
                $('#lead-edit-attribute-mobile-'+leadsData.get('id')).mask('(999) 999 9999', {autoclear: false});
            }
        },
        customPaginate: function(e) {
            var el = $(e.currentTarget),
                paginationParam = el.val();

            this.leads.customPaginate = paginationParam;
            this.leads.paginator_ui.perPage = paginationParam;

            this.specialPageNavigator(this.leads.firstPage);
        },
        checkAllInGrid: function(e) {
            var allEl = $(e.currentTarget),
                currentState = false,
                self = this;
            if (allEl.is(':checked')) {
                currentState = true;
            }

            _.each($('input.check-lead-in-grid'), function (el) {
                $(el).prop('checked', currentState);
                 if (currentState === true) {
                    if (!_.isUndefined(self.checkedLeadRows)) {
                        self.checkedLeadRows = _.union(self.checkedLeadRows, $(el).data('lead-id'));
                    } else {
                        self.checkedLeadRows = [$(el).data('lead-id')];
                    }
                }  else {
                    if (!_.isUndefined(self.checkedLeadRows)) {
                        var arrayIndex = self.checkedLeadRows.indexOf($(el).data('lead-id'));
                        self.checkedLeadRows.splice(arrayIndex, 1);
                    }
                }
            });
        },
        alphabeticalSort: function(obj){
            // convert object into array
            var sortable=[];
            for(var key in obj)
                if(obj.hasOwnProperty(key))
                    sortable.push([key, obj[key]]); // each item is an array in format [key, value]

            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        },
        checkLeadInGrid:function(e)
        {
            var el = $(e.currentTarget),
                leadId = el.data('lead-id'),
                status = el.is(':checked');

            if (status === true) {
                if (!_.isUndefined(this.checkedLeadRows)) {
                    this.checkedLeadRows = _.union(this.checkedLeadRows, leadId);
                } else {
                    this.checkedLeadRows = [leadId];
                }
            } else {
                if (!_.isUndefined(this.checkedLeadRows)) {
                    var arrayIndex = this.checkedLeadRows.indexOf(leadId);
                    this.checkedLeadRows.splice(arrayIndex, 1);
                }
            }
        },
        massAction: function(e){
            var func = $(e.currentTarget).val()+'Action';

            if (_.isFunction(this[func])) {
                var leads = this.checkedLeadRows,
                    self = this;

                if (!_.isUndefined(leads) && !_.isEmpty(leads)){
                    this[func].call(self, leads);
                }
            }
            $(e.currentTarget).val(0);
        },
        mergeLeadsAction: function()
        {
            var self = this,
                checkedLeads = this.checkedLeadRows.join(','),
                countSelectedLeads = this.checkedLeadRows.length;

            if (countSelectedLeads < 2) {
                showMessage(_.isUndefined(i18n['Please choose at least 2 leads'])?'Please choose at least 2 leads':i18n['Please choose at least 2 leads'], true, 5000);
                return false;
            }

            if (countSelectedLeads > 3) {
                showMessage(_.isUndefined(i18n['You can merge not more than 3 leads at once'])?'You can merge not more than 3 leads at once':i18n['You can merge not more than 3 leads at once'], true, 5000);
                return false;
            }

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/getLeadsInfo/',
                type: 'POST',
                dataType: 'json',
                data: {'checkedLeads':checkedLeads}
            }).done(function(response) {
                if (response.error == '1') {
                    showMessage(_.isUndefined(i18n['Leads have not found'])?'Leads have not found':i18n['Leads have not found'], true, 5000);
                    return false;
                }
                var dialog = _.template(leadMergeDialog, {
                    leadIds: checkedLeads,
                    countSelectedLeads: countSelectedLeads,
                    i18n:i18n,
                    leadsData: response.responseText
                });
                $(dialog).dialog({
                    dialogClass: 'seotoaster',
                    width: '30%',
                    height: '250',
                    resizable: false,
                    draggable: false,
                    open: function(event, ui) {
                        $('#merge-lead-dialog').on('submit',  function(e){
                            e.preventDefault();

                            if (!$('input.merge-lead-el').is(':checked')) {
                                showMessage(_.isUndefined(i18n['Please specify the lead to be merged to ']) ? 'Please specify the lead to be merged to' : i18n['Please specify the lead to be merged to'], true, 5000);
                                return false;
                            }

                            showSpinner('#merge-leads-form', 'merge-leads-stats-spinner dashboard-spinner');

                            var leadMergeToId = $('input.merge-lead-el:checked').data('lead-id-merge-to');

                            $.ajax({
                                url: $('#website_url').val()+'plugin/leads/run/mergeMassLeads/',
                                type: 'POST',
                                dataType: 'json',
                                data:{'secureToken' : $('#lead-grid-token').val(), 'leadIds' : checkedLeads, 'leadMergeToId':leadMergeToId}
                            }).done(function(response){
                                hideSpinner('.merge-leads-stats-spinner');
                                if (response.error == '1') {
                                    showMessage(response.responseText, true, 5000);
                                } else {
                                    showMessage(response.responseText, false, 5000);
                                    $('#merge-lead-dialog').dialog('close');
                                    window.location = $('#website_url').val() + 'dashboard/leads/#lead/' + leadMergeToId
                                }
                            });
                        });
                    },
                    close: function(event, ui){
                        $(this).dialog('close').remove();
                    }
                });

                return false;
            });
        },
        addTagsAction: function () {
            var self = this,
                checkedLeads = this.checkedLeadRows.join(','),
                countSelectedLeads = this.checkedLeadRows.length,
                filters = this.leads.server_api.filter();

            if (!_.isEmpty(this.checkedLeadRows)) {
                $.ajax({
                    url: $('#website_url').val() + 'plugin/leads/run/addTags/leadsIds/' + checkedLeads,
                    type: 'GET',
                    dataType: 'json'

                }).done(function (response) {
                    var tags = self.alphabeticalSort(response.tags),
                        selectedTags = response.selectedTags,
                        emptyTagsMsg = '';

                    if(_.isEmpty(tags)){
                        emptyTagsMsg = _.isUndefined(i18n['You don\'t have any saved tags. Please add tags in global config.']) ? 'You don\'t have any saved tags. Please add tags in global config.' : i18n['You don\'t have any saved tags. Please add tags in global config.'];
                    }

                    var dialog = _.template(leadActionAssignTagsTemplate, {
                        leadIds: checkedLeads,
                        countSelectedLeads: countSelectedLeads,
                        i18n: i18n,
                        tags: tags,
                        selectedTags: selectedTags,
                        emptyTagsMsg: emptyTagsMsg,
                        height: '550'
                    });
                    $(dialog).dialog({
                        dialogClass: 'seotoaster',
                        width: '40%',
                        height: '550',
                        resizable: false,
                        draggable: false,
                        open: function (event, ui) {
                            $('.lead-tags').on('change', function () {
                                if($(this).prop('checked')) {
                                    $('.clear-lead-tags').prop('checked', false);
                                }
                            });

                            $('#addnew').on('click', function () {
                                $('.clear-lead-tags').prop('checked', false);
                                $('input[name=lead-tags]:checked').map(function () {
                                    $(this).prop('checked', false);
                                });
                            });

                            $('#reprocessing').on('click', function () {
                                $('.clear-lead-tags').prop('checked', false);
                                var leadTagsEl = $('input[name=lead-tags]');
                                leadTagsEl.map(function () {
                                    if ($(this).data('original-tag') != '') {
                                        $(this).prop('checked', true);
                                    } else {
                                        $(this).prop('checked', false);
                                    }
                                });
                            });

                            $('.clear-lead-tags').on('change', function () {
                                var leadTagsEl = $('input[name=lead-tags]');
                                if($(this).prop('checked')) {
                                    leadTagsEl.map(function () {
                                        $(this).prop('checked', false);
                                    });
                                } else {
                                    leadTagsEl.map(function () {
                                        if ($(this).data('original-tag') != '') {
                                            $(this).prop('checked', true);
                                        }
                                    });
                                }
                            });

                            var assignLeadTagsText = _.isUndefined(i18n['Assign lead tags']) ? 'Assign lead tags':i18n['Assign lead tags'],
                                totalText = _.isUndefined(i18n['Total'])?'Total':i18n['Total'];

                            if(countSelectedLeads == 1) {
                                var recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'],
                                    title = assignLeadTagsText + ' (' + totalText +' '+ countSelectedLeads +' '+ recordsText +')';

                              $('#assign-tags-dialog').dialog('option', 'title', title);
                            }

                            $('.select-all-records').on('change', function (e) {
                               e.preventDefault();

                               var currentElement = $(e.currentTarget),
                                   title = assignLeadTagsText + ' (' + totalText +' '+ $('#count-selected-leads').val() +' '+ recordsText +')';

                               var dataType = currentElement.data('type');

                               if(dataType == 'selectAllRecords') {
                                   $('#allTagsFilterLeads').prop('checked', false);
                                   if($(this).prop('checked')) {
                                       $.ajax({
                                           url: $('#website_url').val() + 'plugin/leads/run/getAllLeads/allLeads/allLeads',
                                           type: 'GET',
                                           dataType: 'json'
                                       }).done(function (response) {
                                           var countSelectedLeadsQuantity = response.totalRecords;
                                           recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];
                                           if(countSelectedLeadsQuantity == 1) {
                                               recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                           }

                                           title = assignLeadTagsText + ' (' + totalText +' '+ countSelectedLeadsQuantity +' '+ recordsText +')';
                                           $('#assign-tags-dialog').dialog('option', 'title', title);
                                       });
                                   } else {
                                       recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];
                                       if($('#count-selected-leads').val() == 1) {
                                           recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                       }

                                       title = assignLeadTagsText + ' (' + totalText +' '+ $('#count-selected-leads').val() +' '+ recordsText +')';

                                       $('#assign-tags-dialog').dialog('option', 'title', title);
                                   }
                               } else if (dataType == 'allTagsFilterLeads') {
                                   $('#selectAllRecords').prop('checked', false);
                                   if($(this).prop('checked')) {
                                       $.ajax({
                                           url: $('#website_url').val() + 'plugin/leads/run/getAllTagsFilterLeads/allTagsFilterLeads/allTagsFilterLeads',
                                           type: 'POST',
                                           dataType: 'json',
                                           data:{'secureToken':$('#lead-grid-token').val(), 'filters':$.param(filters), 'leadIds' : checkedLeads}
                                       }).done(function (response) {
                                           if(response.error != 1) {
                                               var countSelectedLeadsQuantity = response.totalRecords;

                                               recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];
                                               if(countSelectedLeadsQuantity == 1) {
                                                   recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                               }

                                               title = assignLeadTagsText + ' (' + totalText +' '+ countSelectedLeadsQuantity +' '+ recordsText +')';
                                               $('#assign-tags-dialog').dialog('option', 'title', title);
                                           } else {
                                               $('#assign-tags-dialog').dialog('option', 'title', title);
                                           }
                                       });
                                   } else {
                                       recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];
                                       if($('#count-selected-leads').val() == 1) {
                                           recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                       }

                                       title = assignLeadTagsText + ' (' + totalText +' '+ $('#count-selected-leads').val() +' '+ recordsText +')';

                                       $('#assign-tags-dialog').dialog('option', 'title', title);
                                   }
                               }
                            });

                            $('#assign-tags').on('submit', function (e) {
                                e.preventDefault();
                                var checkedTagsIds = [],
                                    self = this;
                                $('input[name=lead-tags]:checked').map(function () {
                                    checkedTagsIds.push($(this).val());
                                });

                                var tagsFunction = $('input[name=tags-function]:checked').val(),
                                    selectAllRecords = $('#selectAllRecords').prop('checked'),
                                    tagsMsg = '';


                                if(tagsFunction == 'reprocessing'){
                                    tagsMsg = 'Save changes? All tags will be reprocessed!';
                                    if(selectAllRecords) {
                                        tagsMsg = 'Save changes? All tags will be reprocessed for all leads!';
                                    }

                                }

                                if(tagsFunction == 'addnew'){
                                    if(checkedTagsIds.length < 1) {
                                        showMessage(_.isUndefined(i18n['Please select at least one tag'])?'Please select at least one tag':i18n['Please select at least one tag'], true, 3000);
                                        return false;
                                    }

                                    tagsMsg = 'Save changes? Selected tag(s) will be added to lead(s)!';
                                    if(selectAllRecords) {
                                        tagsMsg = 'Save changes? Selected tag(s) will be added for all leads!';
                                    }

                                }

                                function processLeadsTagsProcedure(self ,secureToken ,checkedTagsIds, tagsFunction, offset) {
                                    if(typeof self !== 'undefined') {
                                        $('.lead-tags-list').hide();
                                        $('.lead-tags-progress').show();

                                        $.ajax({
                                            url: $(self).attr('action'),
                                            type: 'POST',
                                            dataType: 'json',
                                            data: {
                                                'secureToken' : $('#lead-grid-token').val(),
                                                'tagsIds'     : checkedTagsIds,
                                                'tagsFunction': tagsFunction,
                                                'offset'      : offset,
                                                'allRecords'  : 1
                                            }
                                        }).done(function (response) {
                                            var currentOffset,
                                                totalRecords,
                                                leadsCount,
                                                processedLeadsCountEl = $('.processed-leads-count'),
                                                processedLeadsCountElData = processedLeadsCountEl.data('processed-leads-count');

                                            if(typeof response.responseText.offset !== 'undefined') {
                                                currentOffset = response.responseText.offset;
                                                totalRecords = response.responseText.totalRecords;
                                                leadsCount = response.responseText.leadsCount;

                                                processedLeadsCountEl.data('processed-leads-count',  processedLeadsCountElData + leadsCount);
                                                processedLeadsCountEl.text(processedLeadsCountElData + leadsCount);
                                                $('.processed-total-records-tags').text(totalRecords);
                                                processLeadsTagsProcedure(self ,secureToken ,checkedTagsIds, tagsFunction, currentOffset);
                                            } else {
                                                showMessage(response.responseText, false, 3000);
                                                $('#assign-tags-dialog').dialog('close');
                                            }
                                        });
                                    }
                                };

                                showConfirm(_.isUndefined(i18n[tagsMsg])?tagsMsg:i18n[tagsMsg], function(){
                                    $('#tmp-tags-ids').val('');

                                    if(selectAllRecords) {
                                        processLeadsTagsProcedure(self, $('#lead-grid-token').val(), checkedTagsIds, tagsFunction, 0);
                                    } else {
                                        var tagsType = '';

                                        if($('#allTagsFilterLeads').prop('checked')) {
                                            tagsType = 'allTagsFilterLeads';
                                        }

                                        $.ajax({
                                            url: $(self).attr('action'),
                                            type: 'POST',
                                            dataType: 'json',
                                            data: {
                                                'secureToken' : $('#lead-grid-token').val(),
                                                'tagsIds'     : checkedTagsIds,
                                                'leadIds'     : checkedLeads,
                                                'tagsFunction': tagsFunction,
                                                'filters'     : $.param(filters),
                                                'tagsType'    : tagsType
                                            }
                                        }).done(function (response) {
                                            showMessage(_.isUndefined(i18n['Done'])?'Done':i18n['Done'], false, 5000);
                                            $('#assign-tags-dialog').dialog('close');
                                        });
                                    }
                                });
                            });
                        },
                        close: function (event, ui) {
                            $(this).dialog('close').remove();
                        }
                    });
                    return false;
                });
            }
            return false;
        },
        emailSequenceAction:function (e) {
            var self = this,
                checkedLeads = this.checkedLeadRows.join(','),
                countSelectedLeads = this.checkedLeadRows.length,
                filters = this.leads.server_api.filter();

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/emailSequence/',
                type: 'GET',
                dataType: 'json'

            }).done(function(response) {
                var emailSequences = self.alphabeticalSort(response.emailSequences);
                var dialog = _.template(leadActionEmailSequenceTemplate, {
                    leadIds: checkedLeads,
                    countSelectedLeads: countSelectedLeads,
                    filters : $.param(filters),
                    i18n:i18n,
                    emailSequences: emailSequences
                });
                $(dialog).dialog({
                    dialogClass: 'seotoaster',
                    width: '30%',
                    height: '220',
                    resizable: false,
                    draggable: false,
                    open: function(event, ui) {
                        var allFilterLeads = 0,
                        recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'],
                        exportLeadsText = _.isUndefined(i18n['Assign/unassign email/sms sequence']) ? 'Assign/unassign email/sms sequence':i18n['Assign/unassign email/sms sequence'],
                        totalText = _.isUndefined(i18n['Total'])?'Total':i18n['Total'],
                        title = '';

                        if(countSelectedLeads == 1) {
                            recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                            title = exportLeadsText + ' (' + totalText +' '+ countSelectedLeads +' '+ recordsText +')';

                            $('#assign-email-sequence-dialog').dialog('option', 'title', title);
                            $('#assign-email-sequence-dialog').data('count-selected-leads', countSelectedLeads);
                        }

                        $('input[type="radio"][name="email-sms-function"]').on('change', function(e){
                            let sequenceMassActionLabel = _.isUndefined(i18n['Unassign email/sms sequence']) ? 'Unassign email/sms sequence' : i18n['Unassign email/sms sequence'];
                            if ($(this).val() === 'addnew') {
                                sequenceMassActionLabel = _.isUndefined(i18n['Assign email/sms sequence']) ? 'Assign email/sms sequence' : i18n['Assign email/sms sequence'];
                            }

                            $('#send-email-sequence-data').val(sequenceMassActionLabel)
                        });

                        $('.allFilterLeads').on('change',  function(e){
                            e.preventDefault();

                            if($('.allFilterLeads').prop('checked')){
                                $.ajax({
                                    url: $('#website_url').val()+'plugin/leads/run/countAllLeads/',
                                    type: 'POST',
                                    dataType: 'json',
                                    data:{'secureToken':$('#lead-grid-token').val(), 'filters':$.param(filters)}
                                }).done(function(response){
                                    if (response.error == '1') {
                                        showMessage(_.isUndefined(i18n['No leads found'])?'No leads found':i18n['No leads found'], true, 5000);
                                    } else {
                                        allFilterLeads = 1;
                                        var countSelectedLeadsQuantity = response.responseText.quantity;

                                        recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];
                                        if(countSelectedLeadsQuantity == 1) {
                                            recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                        }
                                            title = exportLeadsText + ' (' + totalText +' '+ countSelectedLeadsQuantity +' '+ recordsText +')';

                                        $('#assign-email-sequence-dialog').dialog('option', 'title', title);
                                        $('#assign-email-sequence-dialog').data('count-selected-leads', countSelectedLeadsQuantity);
                                    }
                                });
                            }else{
                                allFilterLeads = 0;

                                recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];
                                if(countSelectedLeads == 1) {
                                    recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                }

                                title = exportLeadsText + ' (' + totalText +' '+ countSelectedLeads +' '+ recordsText +')';
                                $('#assign-email-sequence-dialog').dialog('option', 'title', title);
                                $('#assign-email-sequence-dialog').data('count-selected-leads', countSelectedLeads);
                            }
                        })

                        $('#assign-email-sequence').on('submit',  function(e){
                            e.preventDefault();
                            var leadEmailSequenceId = $(this).find('.lead-email-sequences').val(),
                                self = this;

                            if (leadEmailSequenceId == '0')  {
                                showMessage(_.isUndefined(i18n['Please choose email/sms sequence']) ? 'Please choose email/sms sequence' : i18n['Please choose email/sms sequence'], true, 5000);
                                return false;
                            }

                            var emailSmsFunction = $('input[name=email-sms-function]:checked').val();

                            var requestType = 'addnew';

                            if(emailSmsFunction == 'remove'){
                                requestType = 'remove';
                            }

                            if(emailSmsFunction == 'addnew'){
                                requestType = 'addnew';
                            }

                            function processLeadsSequencesProcedure(self, secureToken, leadEmailSequenceId, checkedLeads, filters, allFilterLeads, offset, requestType) {
                                if(typeof self !== 'undefined') {
                                    $('.lead-sequences-progress').show();

                                    $.ajax({
                                        url: $(self).attr('action'),
                                        type: 'POST',
                                        dataType: 'json',
                                        data:{
                                            'secureToken' : secureToken,
                                            'leadEmailSequenceId' : leadEmailSequenceId,
                                            'leadIds' : checkedLeads,
                                            'filters':$.param(filters),
                                            'allFilterLeads': allFilterLeads,
                                            'offset': offset,
                                            'requestType':requestType
                                        }
                                    }).done(function(response){
                                        if (response.error != '1') {
                                            var currentOffset,
                                                totalRecords,
                                                leadsCount,
                                                processedLeadsCountEl = $('.processed-leads-count'),
                                                processedLeadsCountElData = processedLeadsCountEl.data('processed-leads-count');

                                            if(typeof response.responseText.offset !== 'undefined') {
                                                currentOffset = response.responseText.offset;
                                                totalRecords = response.responseText.totalRecords;
                                                leadsCount = response.responseText.leadsCount;

                                                processedLeadsCountEl.data('processed-leads-count',  processedLeadsCountElData + leadsCount);
                                                processedLeadsCountEl.text(processedLeadsCountElData + leadsCount);
                                                $('.processed-total-records-leads').text(totalRecords);
                                                processLeadsSequencesProcedure(self, secureToken, leadEmailSequenceId, checkedLeads, filters, allFilterLeads, currentOffset, requestType);
                                            } else {
                                                showMessage(response.responseText, false, 3000);
                                                $('#assign-email-sequence-dialog').dialog('close');
                                            }
                                        } else {
                                            showMessage(response.responseText, true, 5000);
                                            $('#assign-email-sequence-dialog').dialog('close');
                                        }
                                    });
                                }
                            }

                            let countSelectedLeads = $('#assign-email-sequence-dialog').data('count-selected-leads');

                            if (countSelectedLeads >= 100) {
                                showConfirm(_.isUndefined(i18n['Your job will run in the background.'])?'Your job will run in the background.':i18n['Your job will run in the background.'], function(){
                                    processLeadsSequencesProcedure(self, $('#lead-grid-token').val(), leadEmailSequenceId, checkedLeads, filters, allFilterLeads, 0, requestType);
                                }, function () {

                                });
                            } else {
                                if(allFilterLeads) {
                                    processLeadsSequencesProcedure(self, $('#lead-grid-token').val(), leadEmailSequenceId, checkedLeads, filters, allFilterLeads, 0, requestType);
                                } else {
                                    $.ajax({
                                        url: $(self).attr('action'),
                                        type: 'POST',
                                        dataType: 'json',
                                        data:{'secureToken' : $('#lead-grid-token').val(), 'leadEmailSequenceId' : leadEmailSequenceId, 'leadIds' : checkedLeads, 'filters':$.param(filters), 'allFilterLeads': allFilterLeads,  requestType:requestType}
                                    }).done(function(response){
                                        if (response.error == '1') {
                                            showMessage(response.responseText, true, 5000);
                                        } else {
                                            showMessage(response.responseText.message, false, 3000);
                                            $('#assign-email-sequence-dialog').dialog('close');
                                        }
                                    });
                                }
                            }

                        });
                    },
                    close: function(event, ui){
                        $(this).dialog('close').remove();
                    }
                });

                return false;
            });
        },
        exportLeadsAction: function () {
            var leadIds = this.checkedLeadRows.join(','),
                countSelectedLeads = this.checkedLeadRows.length,
                filters = this.leads.server_api.filter();

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/getExportLeadsTabData/',
                type: 'GET',
                dataType: 'json'

            }).done(function(response) {
                var dialog = _.template(leadExportDialog, {
                    leadIds: leadIds,
                    filters : $.param(filters),
                    countSelectedLeads: countSelectedLeads,
                    i18n:i18n,
                    'defaultConfig': response.responseText.defaultConfig,
                    'additionalLeadsExportConfig': response.responseText.additionalLeadsExportConfig,
                    'additionalLeadsExportCustomParamsConfig': response.responseText.additionalLeadsExportCustomParamsConfig
                });
                $(dialog).dialog({
                    dialogClass: 'seotoaster',
                    width: '75%',
                    height: '750',
                    resizable: false,
                    draggable: false,
                    open: function(event, ui) {
                        var exportLeadsText = _.isUndefined(i18n['Export leads']) ? 'Export leads':i18n['Export leads'],
                            totalText = _.isUndefined(i18n['Total'])?'Total':i18n['Total'],
                            recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'],
                            title = '';

                        if(countSelectedLeads == 1) {
                            exportLeadsText = _.isUndefined(i18n['Export lead']) ? 'Export lead':i18n['Export lead'];
                            recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                        }

                        title = exportLeadsText + ' (' + totalText +' '+ countSelectedLeads +' '+ recordsText +')';
                        $('.export-lead-dialog').dialog('option', 'title', title);

                        $('.allLeads').on('change',  function(e){
                            e.preventDefault();

                            if($('input.allLeads').is(':checked')){
                                $.ajax({
                                    url: $('#website_url').val()+'plugin/leads/run/countAllLeads/',
                                    type: 'POST',
                                    dataType: 'json',
                                    data:{'secureToken':$('#lead-grid-token').val(), 'filters':$.param(filters)}
                                }).done(function(response){
                                    if (response.error == '1') {
                                        showMessage(_.isUndefined(i18n['No leads found'])?'No leads found':i18n['No leads found'], true, 5000);
                                    } else {
                                        var countSelectedLeadsQuantity = response.responseText.quantity;

                                        exportLeadsText = _.isUndefined(i18n['Export leads']) ? 'Export leads':i18n['Export leads'];
                                        recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];

                                        if(countSelectedLeadsQuantity == 1) {
                                            exportLeadsText = _.isUndefined(i18n['Export lead']) ? 'Export lead':i18n['Export lead'];
                                            recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                        }

                                            title = exportLeadsText + ' (' + totalText +' '+ countSelectedLeadsQuantity +' '+ recordsText +')';

                                       $('.export-lead-dialog').dialog('option', 'title', title);
                                    }
                                });
                            }else{
                                exportLeadsText = _.isUndefined(i18n['Export leads']) ? 'Export leads':i18n['Export leads'];
                                recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];

                                if(countSelectedLeads == 1) {
                                    exportLeadsText = _.isUndefined(i18n['Export lead']) ? 'Export lead':i18n['Export lead'];
                                    recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                }

                                title = exportLeadsText + ' (' + totalText +' '+ countSelectedLeads +' '+ recordsText +')';
                                $('.export-lead-dialog').dialog('option', 'title', title);
                            }
                        });

                        $('.custom-param-checkbox').on('change', function(e){
                            e.preventDefault();
                            var checkedCustomParam = $(".custom-param-checkbox").is(':checked');

                            if (checkedCustomParam) {
                                $('#use-custom-params').val(1);
                                $('.disable-custom-params-prefix-visible').show();
                            } else {
                                $('#use-custom-params').val(0);
                                $('.disable-custom-params-prefix-visible').hide();
                                $('.disable-custom-params-prefix').val(0);
                            }
                        });

                        $('.disable-custom-params-prefix').on('change', function(e){
                            e.preventDefault();
                            if($(this).prop('checked')) {
                                $('.info-block').hide();
                            } else {
                                $('.info-block').show();
                            }
                        });

                        $('.info-block').trigger('mouseover');
                    },
                    close: function(event, ui){
                        $(this).dialog('close').remove();
                    }
                });

                return false;
            });
        },
        changeLeadOwnerAction: function()
        {
            var checkedLeads = this.checkedLeadRows.join(','),
                countSelectedLeads = this.checkedLeadRows.length,
                filters = this.leads.server_api.filter();

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/getTaskTabData/',
                type: 'GET',
                dataType: 'json'

            }).done(function(response) {
                var dialog = _.template(LeadActionAssignOwnerTemplate, {
                    leadIds: checkedLeads,
                    countSelectedLeads: countSelectedLeads,
                    i18n:i18n,
                    'leadOwners': response.owners
                });
                $(dialog).dialog({
                    dialogClass: 'seotoaster',
                    width: '30%',
                    height: '200',
                    resizable: false,
                    draggable: false,
                    open: function(event, ui) {
                        var allOwnerFilterLeads = 0;

                        var ownerLeadsText = _.isUndefined(i18n['Assign lead owner']) ? 'Assign lead owner':i18n['Assign lead owner'],
                            totalText = _.isUndefined(i18n['Total'])?'Total':i18n['Total'],
                            recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'],
                            title = '';

                        if(countSelectedLeads == 1) {
                            recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                        }

                        title = ownerLeadsText + ' (' + totalText +' '+ countSelectedLeads +' '+ recordsText +')';
                        $('#assign-lead-owner-dialog').dialog('option', 'title', title);

                        $('.allOwnerFilterLeads').on('change',  function(e){
                            e.preventDefault();

                            if($('.allOwnerFilterLeads').prop('checked')){
                                $.ajax({
                                    url: $('#website_url').val()+'plugin/leads/run/countAllLeads/',
                                    type: 'POST',
                                    dataType: 'json',
                                    data:{'secureToken':$('#lead-grid-token').val(), 'filters':$.param(filters)}
                                }).done(function(response){
                                    if (response.error == '1') {
                                        showMessage(_.isUndefined(i18n['No leads found'])?'No leads found':i18n['No leads found'], true, 5000);
                                    } else {
                                        allOwnerFilterLeads = 1;
                                        var countSelectedLeadsQuantity = response.responseText.quantity;

                                        recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];

                                        if(countSelectedLeadsQuantity == 1) {
                                            recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                        }

                                            title = ownerLeadsText + ' (' + totalText +' '+ countSelectedLeadsQuantity +' '+ recordsText +')';

                                        $('#assign-lead-owner-dialog').dialog('option', 'title', title);
                                    }
                                });
                            }else{
                                allOwnerFilterLeads = 0;

                                recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];

                                if(countSelectedLeads == 1) {
                                    recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                }

                                title = ownerLeadsText + ' (' + totalText +' '+ countSelectedLeads +' '+ recordsText +')';
                                $('#assign-lead-owner-dialog').dialog('option', 'title', title);
                            }
                        });

                        $('#assign-lead-owner').on('submit',  function(e){
                            e.preventDefault();
                            var leadOwnerId = $(this).find('.lead-owners').val();

                            if (leadOwnerId == '0' || leadOwnerId == null)  {
                                showMessage(_.isUndefined(i18n['Please choose lead owner'])?'Please choose lead owner':i18n['Please choose lead owner'], true, 5000);
                                // $('.error').css({'z-index': 10000});
                                return false;
                            }

                            $.ajax({
                                url: $(this).attr('action'),
                                type: 'POST',
                                dataType: 'json',
                                data:{'secureToken':$('#lead-grid-token').val(), 'leadOwnerId': leadOwnerId, 'leadIds':checkedLeads, 'filters':$.param(filters), 'allOwnerFilterLeads': allOwnerFilterLeads}
                            }).done(function(response){
                                if (response.error == '1') {
                                    showMessage(response.responseText, true, 5000);
                                } else {
                                    showMessage(response.responseText, false, 5000);
                                    $('#assign-lead-owner-dialog').dialog('close');
                                }
                            });
                        });
                    },
                    close: function(event, ui){
                        $(this).dialog('close').remove();
                    }
                });

                return false;
            });
        },
        remarketingCampaignsAction: function(e) {
            var checkedLeads = this.checkedLeadRows.join(','),
                customerIds = [1],
                filters = this.leads.server_api.filter(),
                self = this;

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/countAllLeads/',
                type: 'POST',
                dataType: 'json',
                data:{'secureToken':$('#lead-grid-token').val(), 'filters':$.param(filters), 'leadIds' : checkedLeads, 'uniqueEmail': '1', 'advertising': '1'}
            }).done(function(response){
                if (response.error == '1') {
                    showMessage(_.isUndefined(i18n['No leads have been found with email address'])?'No leads have been found with email address':i18n['No leads have been found with email address'], true, 5000);
                } else {
                    var countSelectedLeads = response.responseText.quantity,
                        additionalCountSelectedLeads = response.responseText.additionalQuantity,
                        leadsText = _.isUndefined(i18n['Add/Remove emails to Ad platforms audiences']) ? 'Add/Remove emails to Ad platforms audiences':i18n['Add/Remove emails to Ad platforms audiences'],
                        totalText = _.isUndefined(i18n['Total'])?'Total':i18n['Total'],
                        recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];

                    if(countSelectedLeads == 1) {
                        leadsText = _.isUndefined(i18n['Add/Remove email to Ad platforms audiences']) ? 'Add/Remove email to Ad platforms audiences':i18n['Add/Remove email to Ad platforms audiences'],
                        recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                    }

                    var title = leadsText + ' (' + totalText +' '+ countSelectedLeads +' '+ recordsText +')';

                    var advertisingLists = response.responseText.advertisingList,
                        dialog = _.template(leadActionRemarketingTemplate, {
                            advertisingList:advertisingLists,
                            i18n:i18n,
                            countSelectedLeads: countSelectedLeads,
                            additionalCountSelectedLeads: additionalCountSelectedLeads
                        });

                    self.firstLoad = 1;
                    self.enabledAdvertisingLists = advertisingLists;

                    $(dialog).dialog({
                        width: '36%',
                        height: '585',
                        dialogClass: 'seotoaster',
                        resizable:false,
                        draggable: false,
                        'title': _.isUndefined(i18n['Add/Remove emails to Ad platforms audiences'])?'Add/Remove emails to Ad platforms audiences':i18n['Add/Remove emails to Ad platforms audiences'],
                        open: function(event, ui) {
                            $('#action-remarketing-dialog').dialog('option', 'title', title);

                            var originalLabelMain = _.isUndefined(i18n['records (with an email address) to your campaign list.']) ? 'records (with an email address) to your campaign list.':i18n['records (with an email address) to your campaign list.'],
                                additionalLabelLabelMain = _.isUndefined(i18n['records (with an email address) matching your filter to your campaign list.']) ? 'records (with an email address) matching your filter to your campaign list.':i18n['records (with an email address) matching your filter to your campaign list.'],
                                originalLabelMain2 = _.isUndefined(i18n['records matching your filter']) ? 'records matching your filter':i18n['records matching your filter'],
                                additionalLabelLabelMain2 = _.isUndefined(i18n['selected records']) ? 'selected records':i18n['selected records'];

                            if(countSelectedLeads == 1) {
                                originalLabelMain = _.isUndefined(i18n['record (with an email address) to your campaign list.']) ? 'record (with an email address) to your campaign list.':i18n['record (with an email address) to your campaign list.'];
                                additionalLabelLabelMain = _.isUndefined(i18n['record (with an email address) matching your filter to your campaign list.']) ? 'record (with an email address) matching your filter to your campaign list.':i18n['record (with an email address) matching your filter to your campaign list.'];
                            }

                            if(additionalCountSelectedLeads == 1) {
                                originalLabelMain2 = _.isUndefined(i18n['record matching your filter']) ? 'record matching your filter':i18n['record matching your filter'];
                                additionalLabelLabelMain2 = _.isUndefined(i18n['selected record']) ? 'selected record':i18n['selected record'];
                            }

                            $('.original-label-main').text(originalLabelMain);
                            $('.original-label-main2').text(originalLabelMain2);

                            $('.additional-label-label-main').text(additionalLabelLabelMain);
                            $('.additional-label-additional').text(additionalLabelLabelMain2);

                            $('body').on('change', '#marketing-campaigns', function(e) {
                                e.stopImmediatePropagation();
                                var checkedLeadRows = self.checkedLeadRows.join(','),
                                    checkedListsEl = $("input.subscribe-to-remarketing-list:checked"),
                                    selectedCampaign = $('#marketing-campaigns').val();

                                var audinceListsIds = [],
                                    audinceListsLabels = [];
                                checkedListsEl.each(function() {
                                    var listId = $(this).val(),
                                        listLabel = $(this).data('label');
                                    audinceListsIds.push(listId);
                                    audinceListsLabels.push(listLabel);
                                });

                                self.campaignSelectedListsIds[self.beforeSelectedCampaign.campaign] = audinceListsIds;
                                self.campaignSelectedListsLabels[self.beforeSelectedCampaign.campaign] = audinceListsLabels;

                                if($('#marketing-campaigns').val() !== 'select') {
                                    self.beforeSelectedCampaign.campaign = $('#marketing-campaigns').val();
                                    if($('#marketing-campaigns').val() == 'adwords') {
                                        $('.ad-audience-limit-msg').text(_.isUndefined(i18n['Google Ads throttle their API to a maximum 10k email addition per day.']) ? 'Google Ads throttle their API to a maximum 10k email addition per day.':i18n['Google Ads throttle their API to a maximum 10k email addition per day.']);
                                    } else {
                                        $('.ad-audience-limit-msg').text(_.isUndefined(i18n['FB Ads throttle their API to a maximum 5k email addition per hour.']) ? 'FB Ads throttle their API to a maximum 5k email addition per hour.':i18n['FB Ads throttle their API to a maximum 5k email addition per hour.']);
                                    }
                                } else {
                                    self.beforeSelectedCampaign.campaign = '';
                                    $('.ad-audience-limit-msg').text('');
                                }

                                if ($('#leads-marketing-matching-filter').is(':checked')) {
                                    self.countServiceLeads(self.leads.server_api.filter(), 0, checkedLeadRows, 'remarketingList');
                                    $('.original-label').hide();
                                    $('.additional-label').show();
                                } else {
                                    self.countServiceLeads(self.leads.server_api.filter(), checkedLeadRows, null, 'remarketingList');
                                    $('.original-label').show();
                                    $('.additional-label').hide();
                                }
                                $('#lead-send-remarketing-quantity-block-processing').addClass('hidden');
                                $('#lead-send-remarketing-quantity-processing').text(0);

                                $('#check-all-for-remarketing').addClass('hidden');
                                $('#add-new-lists').addClass('hidden');
                                if (selectedCampaign != 'select') {
                                    $.ajax({
                                        url: $('#website_url').val()+'plugin/leads/run/getAdvertisingService/serviceName/'+selectedCampaign,
                                        type: 'GET',
                                        dataType: 'json'
                                    }).done(function(response) {
                                        if(response.error == 1){
                                            if(response.responseText.message == 'No ad account assigned to this website') {
                                                var googleAdAccount = 'Google Adwords',
                                                    facebookAdAccount = 'Facebook Ad',
                                                    accountName = facebookAdAccount;

                                                if(selectedCampaign == 'adwords') {
                                                    accountName = googleAdAccount;
                                                }

                                                var connectionMessage = (_.isUndefined(i18n['You need first to connect a '+ accountName +' account. Click'])?'You need first to connect a '+ accountName +' account. Click':i18n['You need first to connect a '+ accountName +' account. Click'])
                                                + ' ' + '<a href="' + $('#website_url').val() + '/plugin/leads/run/advertiserAccountConfig/" target="_blank" title="Click to open config" style="text-decoration: underline;">' + (_.isUndefined(i18n['here'])?'here':i18n['here']) +'</a>'
                                                + ' ' + (_.isUndefined(i18n['to access the configuration panel'])?'to access the configuration panel':i18n['to access the configuration panel']);
                                                showMessage(connectionMessage, true, 6000);
                                            } else {
                                                showMessage(_.isUndefined(i18n[response.responseText.message])?response.responseText.message:i18n[response.responseText.message], false, 1000);
                                            }

                                            $('#subscribe-list').remove();
                                            $('#send-to-remarketing').addClass('hidden');
                                            $('#check-all-for-remarketing').addClass('hidden');
                                            $('#add-new-lists').addClass('hidden');
                                            $('.horizontal-line').addClass('hidden');
                                            $('#marketing-campaigns').val('select');
                                            $('.ad-audience-limit-msg').text('');
                                            return false;
                                        }else{
                                            $('#subscribe-list').remove();
                                            var subscribeList = '<div class="grid_12 mt10px scroll" id="subscribe-list" style="height:145px;">',
                                                list = response.responseText.list;

                                            if(list !== null && list.length > 0) {
                                                $.each(list, function(key, listData){
                                                    var isChecked = '';
                                                    if(typeof self.campaignSelectedListsIds[selectedCampaign] !== 'undefined' && self.campaignSelectedListsIds[selectedCampaign].indexOf(listData.id.toString()) !== -1) {
                                                        isChecked = 'checked';
                                                    }
                                                    subscribeList += '<label class="mr30px pointer"> <input type="checkbox" '+ isChecked +' class="subscribe-to-remarketing-list" name="list" value="'+ listData.id +'" data-label="'+ listData.name +'"/><span>'+ listData.name + ' (id: ' + listData.id + ')' + '</span></label>';
                                                });
                                            } else {
                                                subscribeList += (_.isUndefined(i18n['No available lists'])?'No available lists':i18n['No available lists']);
                                            }
                                            subscribeList += '</div>';

                                            $('#marketing-campaigns').after(subscribeList);
                                            $('#send-to-remarketing').removeClass('hidden');
                                            $('#check-all-for-remarketing').removeClass('hidden');
                                            $('#add-new-lists').removeClass('hidden');
                                            $('.horizontal-line').removeClass('hidden');
                                        }
                                    });
                                }else{
                                    $('#send-to-remarketing').addClass('hidden');
                                    $('.horizontal-line').addClass('hidden');
                                    $('#subscribe-list').remove();
                                }
                            });

                            $('#add-list-form-save').on('click', function(e){
                                var account = $("#marketing-campaigns").val(),
                                    listName = $('#list-name').val().replace(/[^a-zA-Z0-9-_ ]/g, '');

                                if(listName != '') {
                                    $('#list-name').val(listName);
                                    showConfirm(_.isUndefined(i18n['Are you sure want add new list?'])?'Are you sure want add new list?':i18n['Are you sure want add new list?'], function(){
                                        $.ajax({
                                            'url': $('#website_url').val() + 'plugin/leads/run/addAdvertiserlist/',
                                            'type': 'POST',
                                            'dataType': 'json',
                                            'data': {
                                                'secureToken' : $('#lead-grid-token').val(),
                                                'listName': listName,
                                                'account': account
                                            }
                                        }).done(function (response) {
                                            hideLoader();
                                            if (response.error == '1') {
                                                showMessage(response.responseText.message, true, 2000);
                                                return false;
                                            } else {
                                                if(typeof response.responseText.listId === 'undefined') {
                                                    showMessage(response.responseText.message, true, 2000);
                                                } else {
                                                    showMessage('(list: '+response.responseText.listId+') created successfully', false, 2000);
                                                    var newList = '<label class="mr30px pointer"> <input type="checkbox" class="subscribe-to-remarketing-list" name="list" value="'+ response.responseText.listId +'" data-label="'+ listName +'"/><span>'+ listName + ' (id: ' + response.responseText.listId + ')' + '</span></label>';
                                                    $('#subscribe-list').prepend(newList);
                                                }

                                                $('#list-name').val('');
                                            }

                                        }).fail(function(response){
                                            hideLoader();
                                            showMessage(_.isUndefined(i18n['Can\'t add list'])?'Can\'t add list':i18n['Can\'t add list'], true, 2000);
                                        });

                                    }, function () {
                                        //$('#list-name').val('');
                                        return false;
                                    });
                                } else {
                                    showMessage(_.isUndefined(i18n['Please enter list name'])?'Please enter list name':i18n['Please enter list name'], true, 2000);
                                }

                                if ($(this).is(':checked')) {
                                    self.countServiceLeads(filters, 0, checkedLeads, 'remarketingList');
                                    $('.original-label').hide();
                                    $('.additional-label').show();
                                } else {
                                    self.countServiceLeads(filters, checkedLeads, null, 'remarketingList');
                                    $('.original-label').show();
                                    $('.additional-label').hide();
                                }
                            });

                            $('body').on('change', '.change-email-remarketing', function(e) {
                                var emailRemarketingFunction = $('input[name=remarketing-function]:checked').val();
                                if(emailRemarketingFunction == 'unassign') {
                                    $('.information-msg').text(_.isUndefined(i18n['To ensure that all emails are removed from your remarketing audience(s), please do not close this window until all records have been processed.']) ? 'To ensure that all emails are removed from your remarketing audience(s), please do not close this window until all records have been processed.':i18n['To ensure that all emails are removed from your remarketing audience(s), please do not close this window until all records have been processed.']);
                                    $('#send-to-remarketing').val(_.isUndefined(i18n['Remove contact(s) from list']) ? 'Remove contact(s) from list':i18n['Remove contact(s) from list']);
                                    $('.original-label1').text(_.isUndefined(i18n['You’re now removing']) ? 'You’re now removing':i18n['You’re now removing']);
                                    $('.original-label2').text(_.isUndefined(i18n['Check this box if you wish to remove ALL']) ? 'Check this box if you wish to remove ALL':i18n['Check this box if you wish to remove ALL']);
                                    $('.additional-label1').text(_.isUndefined(i18n['You’re now removing ALL']) ? 'You’re now removing ALL':i18n['You’re now removing ALL']);
                                    $('.additional-label2').text(_.isUndefined(i18n['Uncheck this box if you wish to remove']) ? 'Uncheck this box if you wish to remove':i18n['Uncheck this box if you wish to remove']);

                                    if(countSelectedLeads == 1) {
                                        $('.send-email-remarketing-quantity').text(_.isUndefined(i18n['contact has been successfully removed']) ? 'contact has been successfully removed':i18n['contact has been successfully removed']);
                                        originalLabelMain = _.isUndefined(i18n['record (with an email address) from your campaign list.']) ? 'record (with an email address) from your campaign list.':i18n['record (with an email address) from your campaign list.'];
                                        additionalLabelLabelMain = _.isUndefined(i18n['record (with an email address) matching your filter from your campaign list.']) ? 'record (with an email address) matching your filter from your campaign list.':i18n['record (with an email address) matching your filter from your campaign list.'];
                                    } else {
                                        $('.send-email-remarketing-quantity').text(_.isUndefined(i18n['contacts have been successfully removed']) ? 'contacts have been successfully removed':i18n['contacts have been successfully removed']);
                                        originalLabelMain = _.isUndefined(i18n['records (with an email address) from your campaign list.']) ? 'records (with an email address) from your campaign list.':i18n['records (with an email address) from your campaign list.'];
                                        additionalLabelLabelMain = _.isUndefined(i18n['records (with an email address) matching your filter from your campaign list.']) ? 'records (with an email address) matching your filter from your campaign list.':i18n['records (with an email address) matching your filter from your campaign list.'];
                                    }

                                } else {
                                    $('.information-msg').text(_.isUndefined(i18n['To ensure that all emails are added to your remarketing audience(s), please do not close this window until all records have been processed.']) ? 'To ensure that all emails are added to your remarketing audience(s), please do not close this window until all records have been processed.':i18n['To ensure that all emails are added to your remarketing audience(s), please do not close this window until all records have been processed.']);
                                    $('#send-to-remarketing').val(_.isUndefined(i18n['Add contact(s) to list']) ? 'Add contact(s) to list':i18n['Add contact(s) to list']);
                                    $('.original-label1').text(_.isUndefined(i18n['You’re now adding']) ? 'You’re now adding':i18n['You’re now adding']);
                                    $('.original-label2').text(_.isUndefined(i18n['Check this box if you wish to add ALL']) ? 'Check this box if you wish to add ALL':i18n['Check this box if you wish to add ALL']);
                                    $('.additional-label1').text(_.isUndefined(i18n['You’re now adding ALL']) ? 'You’re now adding ALL':i18n['You’re now adding ALL']);
                                    $('.additional-label2').text(_.isUndefined(i18n['Uncheck this box if you wish to add']) ? 'Uncheck this box if you wish to add':i18n['Uncheck this box if you wish to add']);

                                    if(countSelectedLeads == 1) {
                                        $('.send-email-remarketing-quantity').text(_.isUndefined(i18n['contact has been successfully added']) ? 'contact has been successfully added':i18n['contact has been successfully added']);
                                        originalLabelMain = _.isUndefined(i18n['record (with an email address) to your campaign list.']) ? 'record (with an email address) to your campaign list.':i18n['record (with an email address) to your campaign list.'];
                                        additionalLabelLabelMain = _.isUndefined(i18n['record (with an email address) matching your filter to your campaign list.']) ? 'record (with an email address) matching your filter to your campaign list.':i18n['record (with an email address) matching your filter to your campaign list.'];
                                    } else {
                                        $('.send-email-remarketing-quantity').text(_.isUndefined(i18n['contacts have been successfully added']) ? 'contacts have been successfully added':i18n['contacts have been successfully added']);
                                        originalLabelMain = _.isUndefined(i18n['records (with an email address) to your campaign list.']) ? 'records (with an email address) to your campaign list.':i18n['records (with an email address) to your campaign list.'];
                                        additionalLabelLabelMain = _.isUndefined(i18n['records (with an email address) matching your filter to your campaign list.']) ? 'records (with an email address) matching your filter to your campaign list.':i18n['records (with an email address) matching your filter to your campaign list.'];
                                    }

                                }

                                $('.original-label-main').text(originalLabelMain);
                                $('.additional-label-label-main').text(additionalLabelLabelMain);

                            });

                            $('#leads-marketing-matching-filter').on('change', function(e){
                                if ($(this).is(':checked')) {
                                    self.countServiceLeads(filters, 0, checkedLeads, 'remarketingList');
                                    $('.original-label').hide();
                                    $('.additional-label').show();
                                } else {
                                    self.countServiceLeads(filters, checkedLeads, null, 'remarketingList');
                                    $('.original-label').show();
                                    $('.additional-label').hide();
                                }
                            });

                            $('#sent-to-remarketing-form').on('submit', function(e){
                                e.preventDefault();
                                $('#lead-send-remarketing-quantity-processing').text(0);
                                $('#check-all-for-remarketing').addClass('hidden');
                                $('#lead-send-remarketing-quantity-block').addClass('hidden');

                                var marketingCampaignsName = $("#marketing-campaigns").val(),
                                    checkedLists = $(this).find("input.subscribe-to-remarketing-list:checked");

                                if(marketingCampaignsName == 'select'){
                                    showMessage(_.isUndefined(i18n['Please choose service'])?'Please choose service':i18n['Please choose service'], true, 5000);
                                    $('#check-all-for-remarketing').removeClass('hidden');
                                    return false;
                                }

                                if(checkedLists.length == 0){
                                    showMessage(_.isUndefined(i18n['Please choose list'])?'Please choose list':i18n['Please choose list'], true, 5000);
                                    $('#check-all-for-remarketing').removeClass('hidden');
                                    return false;
                                }

                                $('#send-to-remarketing').prop('disabled', true);

                                var lists = [];
                                matchingFilter = 0;
                                self.campaignSelectedListsIds[marketingCampaignsName] = [];
                                self.campaignSelectedListsLabels[marketingCampaignsName] = [];

                                var audinceListsIds = [],
                                    audinceListsLabels = [];
                                checkedLists.each(function() {
                                    var listId = $(this).val(),
                                        listLabel = $(this).data('label');
                                    audinceListsIds.push(listId);
                                    audinceListsLabels.push(listLabel);
                                });

                                self.campaignSelectedListsIds[marketingCampaignsName] = audinceListsIds;
                                self.campaignSelectedListsLabels[marketingCampaignsName] = audinceListsLabels;

                                lists['ids'] = self.campaignSelectedListsIds;
                                lists['names'] = self.campaignSelectedListsLabels;

                                if ($('#leads-marketing-matching-filter').is(':checked')) {
                                    matchingFilter = 1;
                                }

                                var remarketingFunction = $('input[name=remarketing-function]:checked').val();
                                var requestType = 'assign';

                                if(remarketingFunction == 'unassign'){
                                    requestType = 'unassign';
                                }

                                if(remarketingFunction == 'assign'){
                                    requestType = 'assign';
                                }

                                self.sendToRemarketingList($(this).attr('action'), marketingCampaignsName, lists, checkedLeads, filters, matchingFilter, 0, [], $('#action-remarketing-dialog').data('count-selected-leads'), requestType);
                            });

                            var firstSelectedService = '';

                            if(self.enabledAdvertisingLists) {
                                var skipEach = false;
                                $.each(self.enabledAdvertisingLists, function(value, listName){
                                    if(typeof listName !== 'undefined' && listName && !skipEach) {
                                        firstSelectedService = value;
                                        skipEach = true;
                                    }
                                });

                                if(self.firstLoad) {
                                    self.firstLoad = 0;
                                    //@todo Enable for load first value in dropdown
                                    //$('#marketing-campaigns').val(firstSelectedService).trigger('change');
                                }
                            }
                        },
                        close: function(event, ui){
                            $(this).dialog('close').remove();
                        }
                    });
                    return false;
                }
            });
        },
        initMmsPicturesUploader: function(allowedUploadData) {
            this.uploadedFiles = [];
            this.maxUploadedFiles = 0;

            var options = {
                runtimes: 'html5,html4',
                browse_button: 'upload-mms-button',
                container: 'uploader-mms-images-block',
                rename         : true,
                max_file_size  : allowedUploadData.fileSize+'mb',
                max_file_count : allowedUploadData.fileUploads,
                url: $('#website_url').val()+'api/leads/leadmms/',
                multipart_params: {
                    secureToken: $('#lead-grid-token').val(),
                    leadId:      this.checkedLeadRows.join(','),
                    mmsMassAction: 1
                },
                multi_selection: false,
                unique_names: false,
            };

            if(_.isUndefined(this.mmsPicturesUploader)) {
                this.mmsPicturesUploader = new plupload.Uploader(options);

                this.mmsPicturesUploader.init();

                this.mmsPicturesUploader.bind('BeforeUpload', _.bind(this.beforeUpload, this));
                this.mmsPicturesUploader.bind('FilesAdded', _.bind(this.filesAdded, this));
                this.mmsPicturesUploader.bind('UploadProgress', _.bind(this.uploadProgress, this));
                this.mmsPicturesUploader.bind('FileUploaded', _.bind(this.fileUploaded, this));
                this.mmsPicturesUploader.bind('Error', _.bind(this.handleUploadErrors, this));
                this.mmsPicturesUploader.bind('UploadComplete', _.bind(this.uploadComplete, this));
            }
        },
        beforeUpload: function(up, file) {
            if(this.maxUploadedFiles >= 10) {
                var extraАile = up.getFile(file.id);
                up.removeFile(extraАile);
                up.stop();
                showMessage((_.isUndefined(i18n['Messages can include up to 10 media files!']) ? 'Messages can include up to 10 media files!' : i18n['Messages can include up to 10 media files!']), true, 500);
            }
        },
        filesAdded: function(up, files) {
            var failedFilesUploadAdditionalFiltered = [];

            if(files.length) {
                _.each(this.failedFilesUploadAdditional, function (fileName, key) {
                    _.each(files, function (fileN, k) {
                        if(fileN.id == key) {
                            failedFilesUploadAdditionalFiltered.push(fileName);
                        }
                    });

                });

                if(failedFilesUploadAdditionalFiltered.length) {
                    this.failedFilesUploadAdditional = failedFilesUploadAdditionalFiltered;
                } else {
                    this.failedFilesUploadAdditional = {};
                }
            }

            this.mmsPicturesUploader.settings.multipart_params.multipleFiles = 0;
            if(files.length > 1) {
                this.mmsPicturesUploader.settings.multipart_params.multipleFiles = 1;
            }
            this.mmsPicturesUploader.settings.multipart_params.generalFileSize = $('.uploaded-mms-size-count').text();
            this.mmsPicturesUploader.settings.multipart_params.secureToken = $('#lead-grid-token').val();
            this.failedFilesUpload = [];
            this.mmsPicturesUploader.start();
        },
        uploadProgress: function(up, file) {

        },
        fileUploaded: function(up, file, info) {
            var response = jQuery.parseJSON(info.response),
                self = this,
                leadIds = this.checkedLeadRows.join(',');

            if (response.error == '0') {
                if(!this.mmsPicturesUploader.settings.multipart_params.multipleFiles) {
                    showMessage(response.message, false, 500);
                }
                var fileEl = '<li><span class="grid_11">'+ file.name +'</span><a class="ticon-remove error icon14 alpha grid_1 delete-uploaded-mms-file" data-role="delete" data-lead-id="'+ leadIds +'" data-file-name="'+ response.fileStoredName +'" data-file-size="'+ file.size +'" href="javascript:;"></a></li>';

                $('#lead-mms-media-files-list').append(fileEl);
                $('.uploaded-mms-size-count').text(parseFloat(response.generalFileSize.toFixed(2)));

                self.uploadedFiles.push(response.fileStoredName);
                self.maxUploadedFiles +=1;

            } else {
                var errorMessage = '';
                if(typeof response.fileName !== 'undefined' && response.fileName != '') {
                    if  (typeof(response.message) == 'object') {
                        for (var i in response.message) {
                            errorMessage += '<li>'+response.message[i]+'</li>';
                        }
                    } else {
                        errorMessage += '<li> ' + (_.isUndefined(i18n['File']) ? 'File' : i18n['File']) + ' \'' + response.fileName + '\' (' + response.message + ')'+'</li>';
                    }
                }

                if(response.type = 'mmsMaxSize') {
                    if(errorMessage != '') {
                        errorMessage + '</br>' + response.message;
                    } else {
                        errorMessage = response.message;
                    }
                }

                self.failedFilesUpload.push(errorMessage);
            }
        },
        handleUploadErrors: function(up, err) {
            var errorMessage = '<li> ' + (_.isUndefined(i18n['File']) ? 'File' : i18n['File']) + ' \'' + (err.file ? err.file.name : "") + '\' (' + err.message + ')'+'</li>';
            this.failedFilesUploadAdditional[err.file.id] = errorMessage;
        },
        uploadComplete: function(up, files) {
            if(files.length) {
                if(this.failedFilesUploadAdditional.length) {
                    var msg = _.isUndefined(i18n['Files uploaded']) ? 'Files uploaded' : i18n['Files uploaded'];
                    msg += ' </br>' +(_.isUndefined(i18n['Except:']) ? 'Except:' : i18n['Except:']) + '</br>';
                    msg += '<ul>';
                    _.each(this.failedFilesUploadAdditional, function (fileName, key) {
                        msg += fileName;
                    });

                    if(this.failedFilesUpload.length) {
                        _.each(this.failedFilesUpload, function (fileName, key) {
                            msg += fileName;
                        });
                    }
                    msg += '</ul>';
                    showMessage(msg, true, 500);
                } else {
                    if(this.failedFilesUpload.length) {
                        if(up.files.length == this.failedFilesUpload.length) {
                            if(up.files.length > 1) {
                                var msg = (_.isUndefined(i18n['Files not uploaded.']) ? 'Files not uploaded.' : i18n['Files not uploaded.']) + '</br>';
                            } else {
                                var msg = (_.isUndefined(i18n['File not uploaded.']) ? 'File not uploaded.' : i18n['File not uploaded.']) + '</br>';
                            }

                            msg += '<ul>';
                            _.each(this.failedFilesUpload, function (fileName, key) {
                                msg += fileName;
                            });
                            msg += '</ul>';

                            showMessage(msg, true, 500);
                        } else if (up.files.length > this.failedFilesUpload.length) {
                            var msg = _.isUndefined(i18n['Files uploaded']) ? 'Files uploaded' : i18n['Files uploaded'];
                            msg += ' </br>' +(_.isUndefined(i18n['Except:']) ? 'Except:' : i18n['Except:']) + '</br>';
                            msg += '<ul>';
                            _.each(this.failedFilesUpload, function (fileName, key) {
                                msg += fileName;
                            });
                            msg += '</ul>';
                            showMessage(msg, true, 500);
                        }
                    } else {
                        showMessage(_.isUndefined(i18n['Files uploaded']) ? 'Files uploaded' : i18n['Files uploaded'], false, 500);
                    }
                }

                this.failedFilesUploadAdditional = {};
                this.mmsPicturesUploader.splice();
            }
        },
        smsSendingAction: function (e) {
            var checkedLeads = this.checkedLeadRows.join(','),
                filters = this.leads.server_api.filter(),
                self = this;

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/countAllLeads/',
                type: 'POST',
                dataType: 'json',
                data:{'secureToken':$('#lead-grid-token').val(), 'filters':$.param(filters), 'leadIds' : checkedLeads, 'existMobileNumber': '1'}
            }).done(function(response){
                if (response.error == '1') {

                    showMessage(_.isUndefined(i18n['No leads have been found with mobile number'])?'No leads have been found with mobile number':i18n['No leads have been found with mobile number'], true, 5000);
                } else {
                    var countSelectedLeads = response.responseText.quantity,
                        additionalCountSelectedLeads = response.responseText.additionalQuantity,
                        exportLeadsText = _.isUndefined(i18n['Send SMS']) ? 'Send SMS':i18n['Send SMS'],
                        totalText = _.isUndefined(i18n['Total'])?'Total':i18n['Total'],
                        recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'],
                        leadGeneralConfigParams = response.responseText.leadGeneralConfigParams;

                    var configSmsLimit = _.isUndefined(i18n['unlimited'])?'unlimited':i18n['unlimited'];
                    if(typeof leadGeneralConfigParams.smsSendingLimit !== 'undefined' && leadGeneralConfigParams.smsSendingLimit != '') {
                        configSmsLimit = leadGeneralConfigParams.smsSendingLimit;
                    }

                    if(countSelectedLeads == 1) {
                        recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                    }

                    var title = exportLeadsText + ' (' + totalText +' '+ countSelectedLeads +' '+ recordsText +')' + ' (' + (_.isUndefined(i18n['Your SMS limit'])?'Your SMS limit':i18n['Your SMS limit']) + ' - ' + configSmsLimit + ')';

                    var dialog = _.template(LeadActionSmsSendingTemplate, {
                        i18n:i18n,
                        countSelectedLeads: countSelectedLeads,
                        additionalCountSelectedLeads: additionalCountSelectedLeads
                    });

                    $(dialog).dialog({
                        width: '50%',
                        height: '470',
                        dialogClass: 'seotoaster',
                        resizable:false,
                        draggable: false,
                        'title': _.isUndefined(i18n['Send SMS'])?'Send SMS':i18n['Send SMS'],
                        open: function(event, ui) {
                            $('.original-label-first-main').show();

                            var originalLabelFirstBlock = _.isUndefined(i18n['You are now sending text messages to']) ? 'You are now sending text messages to':i18n['You are now sending text messages to'],
                                additionalLabelFirstBlock = _.isUndefined(i18n['different leads.']) ? 'different leads.':i18n['different leads.'],
                                originalLabelSecondBlock = _.isUndefined(i18n['Check this box if you wish to send text messages to ALL']) ? 'Check this box if you wish to send text messages to ALL':i18n['Check this box if you wish to send text messages to ALL'],
                                additionalLabelSecondBlock = _.isUndefined(i18n['leads matching your filter']) ? 'leads matching your filter':i18n['leads matching your filter'];

                            if(countSelectedLeads == 1) {
                                originalLabelFirstBlock = _.isUndefined(i18n['You are now sending text message to']) ? 'You are now sending text message to':i18n['You are now sending text message to'],
                                additionalLabelFirstBlock = _.isUndefined(i18n['lead.']) ? 'lead.':i18n['lead.'];
                            }

                            $('.original-label-first-block').text(originalLabelFirstBlock);
                            $('.additional-label-first-block').text(additionalLabelFirstBlock);

                            $('.original-label-second-block').text(originalLabelSecondBlock);
                            $('.additional-label-second-block').text(additionalLabelSecondBlock);

                            $('#action-sms-sending-dialog').dialog('option', 'title', title);

                            tinymce.init({
                                script_url              : $('#website_url').val()+'system/js/external/tinymce/tinymce.gzip.php',
                                selector                : "#lead-sms-textarea",
                                skin                    : 'seotoaster',
                                menubar                 : false,
                                browser_spellcheck      : true,
                                resize                  : false,
                                convert_urls            : false,
                                relative_urls           : false,
                                statusbar               : false,
                                allow_script_urls       : false,
                                force_p_newlines        : false,
                                forced_root_block       : false,
                                entity_encoding         : "raw",
                                plugins                 :  ["fullscreen leadshortcode placeholder charlimit leadtestsms"],
                                toolbar1                : "leadshortcode | fullscreen | spellcheckbtn | leadtestsms",
                                image_advtab            : false,
                                extended_valid_elements : false,
                                setup                   : function(ed){
                                    var keyTime = null;
                                    ed.on('change blur keyup', function(ed, e){
                                        //@see content.js for this function
                                        self.dispatchEditorKeyup(ed, e, keyTime);
                                        this.save();
                                    });

                                    ed.addButton('spellcheckbtn', {
                                        icon: true,
                                        image: $('#website_url').val()+'plugins/leads/web/images/spellcheck.ico',
                                        tooltip: _.isUndefined(i18n['How do I enable spell-check in SeoToaster?'])?'How do I enable spell-check in SeoToaster?':i18n['How do I enable spell-check in SeoToaster?'],
                                        onclick: function() {
                                            window.open('https://www.seotoaster.com/questions-and-answers/crm-faq#lead-spellchecker', '_blank');
                                        }
                                    })
                                }
                            });

                            $('#lead-sms-textarea').html('<span></span>').trigger('keyup');
                            self.tinimce = tinymce;

                            $('#leads-sms-sending-filter').on('change', function(e){
                                if ($(this).is(':checked')) {
                                    self.countSmsSendingLeads(filters, 0, checkedLeads);
                                    $('.original-label').hide();
                                    $('.additional-label').show();
                                } else {
                                    self.countSmsSendingLeads(filters, checkedLeads, null);
                                    $('.original-label').show();
                                    $('.additional-label').hide();
                                }
                            });

                            $('#switch-send-mms').on('change', function(e){
                                if($('.mms-images-block').hasClass('hide')) {
                                    $('.mms-images-block').removeClass('hide').show();
                                    $('#lead-sms-form').removeClass('grid_12').addClass('grid_8');
                                } else {
                                    $('.mms-images-block').addClass('hide').hide();
                                    $('#lead-sms-form').removeClass('grid_8').addClass('grid_12');
                                }
                            });

                            $(document).on('click', '.delete-uploaded-mms-file', function(e){
                                e.preventDefault();

                                var el = $(e.currentTarget),
                                    fileName = el.data('file-name'),
                                    leadId = el.data('lead-id'),
                                    fileSize = el.data('file-size');

                                showConfirm(_.isUndefined(i18n['Are you sure want to delete an uploaded file?'])?'Are you sure want to delete an uploaded file?':i18n['Are you sure want to delete an uploaded file?'], function(){
                                    $.ajax({
                                        'url': $('#website_url').val()+'api/leads/leadmms/leadId/'+leadId+'/fileName/'+fileName+'/fileSize/'+fileSize+'/generalFileSize/'+$('.uploaded-mms-size-count').text()+'/mmsMassAction/1',
                                        'type':'DELETE',
                                        'dataType':'json'
                                    }).done(function(response){
                                        if (response.error === 1) {
                                            showMessage(response.message, true, 5000);
                                        } else {
                                            showMessage(response.message, false, 3000);
                                            _.each(self.uploadedFiles, function (fileName, key) {
                                                if(fileName == response.deletedFile) {
                                                    self.uploadedFiles.splice(key, 1);
                                                    var elToDelete = $('#lead-mms-media-files-list').find("[data-file-name='" + fileName + "']");
                                                    if(elToDelete.length) {
                                                        $(elToDelete).closest('li').remove();
                                                    }
                                                    var generalFileSize = parseFloat(response.generalFileSize.toFixed(2));
                                                    self.maxUploadedFiles -= 1;
                                                    $('.uploaded-mms-size-count').text(generalFileSize);
                                                }
                                            });
                                        }
                                    });
                                });
                            });

                            self.initMmsPicturesUploader({'fileSize': 5, 'fileUploads': 1});

                            $('#lead-send-sms-sending-quantity-block-processing').addClass('hidden');

                            $('#lead-sms-form').on('submit', function(e){
                                e.preventDefault();

                                var testSms = $('#testSms').val();

                                var matchingFilter = 0;
                                if ($('#leads-sms-sending-filter').is(':checked')) {
                                    matchingFilter = 1;
                                }

                                var smsMessage = $('#lead-sms-textarea').val();
                                if(smsMessage == '') {
                                    showMessage(_.isUndefined(i18n['Please enter a message to send'])?'Please enter a message to send':i18n['Please enter a message to send'], true, 3000);
                                    return false;
                                }

                                if(testSms != 1) {
                                    $('#lead-sms-now').prop('disabled', true);
                                }

                                $('#testSms').val(0);

                                $('#lead-send-sms-sending-quantity-processing').text(0);
                                $('#check-all-for-sms-sending').addClass('hidden');
                                $('#lead-send-sms-sending-quantity-block').addClass('hidden');

                                self.sendSms($(this).attr('action'), checkedLeads, filters, matchingFilter, 0, $('#action-sms-sending-dialog').data('count-selected-leads'), smsMessage, [], testSms);
                            });

                            if(parseInt(configSmsLimit) < parseInt(countSelectedLeads)) {
                                $('#lead-sms-now').prop('disabled', true);
                                showMessage(_.isUndefined(i18n['You can\'t send SMS, Your limit has been reached. Please increase "Send SMS limit"'])?'You can\'t send SMS, Your limit has been reached. Please increase "Send SMS limit"':i18n['You can\'t send SMS, Your limit has been reached. Please increase "Send SMS limit"'], true, 3000);
                            }else {
                                $('#lead-sms-now').prop('disabled', false);
                            }
                        },
                        close: function(event, ui){
                            tinymce.remove();
                            $(this).dialog('close').remove();
                        }
                    });
                    return false;
                }
            });
        },
        dispatchEditorKeyup: function(editor, event, keyTime) {
            var keyTimer = keyTime;
            if(keyTimer === null) {
                keyTimer = setTimeout(function() {
                    keyTimer = null;
                }, 1000)
            }
        },
        emailMarketingAction: function(e) {
            var checkedLeads = this.checkedLeadRows.join(','),
                customerIds = [1],
                filters = this.leads.server_api.filter(),
                self = this;

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/countAllLeads/',
                type: 'POST',
                dataType: 'json',
                data:{'secureToken':$('#lead-grid-token').val(), 'filters':$.param(filters), 'leadIds' : checkedLeads, 'uniqueEmail': '1'}
            }).done(function(response){
                if (response.error == '1') {
                    showMessage(_.isUndefined(i18n['No leads have been found with email address'])?'No leads have been found with email address':i18n['No leads have been found with email address'], true, 5000);
                } else {
                   var countSelectedLeads = response.responseText.quantity,
                       additionalCountSelectedLeads = response.responseText.additionalQuantity,
                       exportLeadsText = _.isUndefined(i18n['Add/Remove emails to Email Marketing']) ? 'Add/Remove emails to Email Marketing':i18n['Add/Remove emails to Email Marketing'],
                       totalText = _.isUndefined(i18n['Total'])?'Total':i18n['Total'],
                       recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];

                   if(countSelectedLeads == 1) {
                       exportLeadsText = _.isUndefined(i18n['Add/Remove email to Email Marketing']) ? 'Add/Remove email to Email Marketing':i18n['Add/Remove email to Email Marketing'],
                       recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                   }

                   var title = exportLeadsText + ' (' + totalText +' '+ countSelectedLeads +' '+ recordsText +')';

                    $.ajax({
                        url: $('#website_url').val()+'plugin/leads/run/getEnabledAppsServices/serviceType/email/customers/'+customerIds,
                        type: 'GET',
                        dataType: 'json'

                    }).done(function(response) {
                        if (response.error == 1) {
                            showMessage(_.isUndefined(i18n['No available services']) ? 'No available services': i18n['No available services']);
                            return false;
                        } else {
                            var enabledServices = response.responseText.enabledServices,
                                dialog = _.template(LeadActionEmailServiceTemplate, {
                                    enabledServices:enabledServices,
                                    i18n:i18n,
                                    countSelectedLeads: countSelectedLeads,
                                    additionalCountSelectedLeads: additionalCountSelectedLeads
                                });

                            self.firstLoad = 0;
                            self.enabledServicesList = enabledServices;

                            $(dialog).dialog({
                                width: '30%',
                                height: '530',
                                dialogClass: 'seotoaster',
                                resizable:false,
                                draggable: false,
                                'title': _.isUndefined(i18n['Add/Remove emails to Email Marketing'])?'Add/Remove emails to Email Marketing':i18n['Add/Remove emails to Email Marketing'],
                                open: function(event, ui) {
                                    var originalLabel = _.isUndefined(i18n['records (with an email address) to your mailing list.']) ? 'records (with an email address) to your mailing list.':i18n['records (with an email address) to your mailing list.'],
                                        additionalLabel = _.isUndefined(i18n['records (with an email address) matching your filter to your mailing list.']) ? 'records (with an email address) matching your filter to your mailing list.':i18n['records (with an email address) matching your filter to your mailing list.'],
                                        originalLabel2 = _.isUndefined(i18n['records matching your filter']) ? 'records matching your filter':i18n['records matching your filter'],
                                        additionalLabel2 = _.isUndefined(i18n['selected records']) ? 'selected records':i18n['selected records'];

                                    if(countSelectedLeads == 1) {
                                        originalLabel = _.isUndefined(i18n['record to your mailing list.']) ? 'record to your mailing list.':i18n['record to your mailing list.'];
                                        additionalLabel = _.isUndefined(i18n['record matching your filter to your mailing list.']) ? 'record matching your filter to your mailing list.':i18n['record matching your filter to your mailing list.'];
                                    }

                                    if(additionalCountSelectedLeads == 1) {
                                        originalLabel2 = _.isUndefined(i18n['record matching your filter']) ? 'record matching your filter':i18n['record matching your filter'];
                                        additionalLabel2 = _.isUndefined(i18n['selected record']) ? 'selected record':i18n['selected record'];
                                    }

                                    $('.original-label-main').text(originalLabel);
                                    $('.additional-label-label-main').text(additionalLabel);

                                    $('.original-label-main2').text(originalLabel2);
                                    $('.additional-label-label-main2').text(additionalLabel2);

                                    $('#action-email-service-dialog').dialog('option', 'title', title);
                                    $('body').on('change', '#marketing-services', function(e) {
                                        e.stopImmediatePropagation();
                                        var checkedLeadRows = self.checkedLeadRows.join(',');

                                        if ($('#leads-marketing-matching-filter').is(':checked')) {
                                            self.countServiceLeads(self.leads.server_api.filter(), 0, checkedLeadRows, 'emailList');
                                            $('.original-label').hide();
                                            $('.additional-label').show();
                                        } else {
                                            self.countServiceLeads(self.leads.server_api.filter(), checkedLeadRows, null, 'emailList');
                                            $('.original-label').show();
                                            $('.additional-label').hide();
                                        }
                                        $('#lead-send-email-service-quantity-block').addClass('hidden');
                                        $('#lead-send-email-service-quantity-block-processing').addClass('hidden');
                                        $('#lead-send-email-service-quantity-processing').text(0);
                                        $('#check-all-for-email-service').addClass('hidden');
                                        if ($("#marketing-services").val() != 'select') {
                                            $.ajax({
                                                url: $('#website_url').val()+'plugin/leads/run/getAppsService/serviceName/'+$("#marketing-services").val(),
                                                type: 'GET',
                                                dataType: 'json'

                                            }).done(function(response) {
                                                if(response.error == 1){
                                                    if($('#marketing-services').val() == 'constantContact') {
                                                        if(response.responseText.hasError) {
                                                            showMessage((_.isUndefined(i18n['<p><b>Can not get any data.</b></p> '+response.responseText.message])?'<p><b>Can not get any data.</b></p> '+response.responseText.message:i18n['<p><b>Can not get any data.</b></p> '+response.responseText.message]));
                                                        } else {
                                                            showMessage((_.isUndefined(i18n['<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.'])?'<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.':i18n['<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.']));
                                                        }
                                                    } else {
                                                        showMessage((_.isUndefined(i18n['<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.'])?'<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.':i18n['<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.']), false, 5000);
                                                    }

                                                    $('#subscribe-list').remove();
                                                    $('#send-to-email-service').addClass('hidden');
                                                    $('#check-all-for-email-service').addClass('hidden');
                                                    $('.horizontal-line').addClass('hidden');
                                                    // $('.smoke').css({'z-index': 10000});
                                                    $('#marketing-services').val('select');
                                                    return false;
                                                }else{
                                                    $('#subscribe-list').remove();
                                                    var subscribeList = '<div class="grid_12 mt10px scroll" id="subscribe-list" style="height:145px;">',
                                                        list = self.alphabeticalSort(response.responseText.list);

                                                    if(list.length > 0) {
                                                        $.each(list, function(value, listName){
                                                            subscribeList += '<label class="mr30px pointer"> <input type="checkbox" class="subscribe-to-email-service-list" name="list" value="'+ listName[0] +'" data-label="'+ listName[1] +'"/><span>'+ listName[1] +'</span></label>'
                                                        });
                                                    } else {
                                                        if($('#marketing-services').val() == 'constantContact') {
                                                            if(response.responseText.hasError) {
                                                                subscribeList += (_.isUndefined(i18n['<p><b>Can not get any data.</b></p> '+response.responseText.message])?'<p><b>Can not get any data.</b></p> '+response.responseText.message:i18n['<p><b>Can not get any data.</b></p> '+response.responseText.message]);
                                                                showMessage((_.isUndefined(i18n['<p><b>Can not get any data.</b></p> '+response.responseText.message])?'<p><b>Can not get any data.</b></p> '+response.responseText.message:i18n['<p><b>Can not get any data.</b></p> '+response.responseText.message]));
                                                            } else {
                                                                subscribeList += (_.isUndefined(i18n['<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.'])?'<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.':i18n['<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.']);
                                                                showMessage((_.isUndefined(i18n['<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.'])?'<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.':i18n['<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.']));
                                                            }
                                                        } else {
                                                            subscribeList += (_.isUndefined(i18n['<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.'])?'<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.':i18n['<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.']);
                                                            showMessage((_.isUndefined(i18n['<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.'])?'<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.':i18n['<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.']), false, 5000);
                                                        }
                                                    }

                                                    subscribeList += '</div>';

                                                    $('#email-service-detailed-info').val(response.responseText.detailedInfo);

                                                    $('#marketing-services').after(subscribeList);
                                                    $('#send-to-email-service').removeClass('hidden');
                                                    $('#check-all-for-email-service').removeClass('hidden');
                                                    $('.horizontal-line').removeClass('hidden');
                                                }
                                            });
                                        }else{
                                            $('#send-to-email-service').addClass('hidden');
                                            $('.horizontal-line').addClass('hidden');
                                            $('#subscribe-list').remove();
                                        }
                                    });

                                    $('body').on('change', '.change-email-marketing', function(e) {
                                        var emailMarketingFunction = $('input[name=email-marketing-function]:checked').val();
                                        if(emailMarketingFunction == 'unassign') {
                                            $('.information-msg').text(_.isUndefined(i18n['To ensure that all contacts are removed from your list(s), please do not close this window until all records have been processed.']) ? 'To ensure that all contacts are removed from your list(s), please do not close this window until all records have been processed.':i18n['To ensure that all contacts are removed from your list(s), please do not close this window until all records have been processed.']);
                                            $('#send-to-email-service').val(_.isUndefined(i18n['Remove contact(s) from list']) ? 'Remove contact(s) from list':i18n['Remove contact(s) from list']);
                                            $('.original-label1').text(_.isUndefined(i18n['You’re now removing']) ? 'You’re now removing':i18n['You’re now removing']);
                                            $('.original-label2').text(_.isUndefined(i18n['Check this box if you wish to remove ALL']) ? 'Check this box if you wish to remove ALL':i18n['Check this box if you wish to remove ALL']);
                                            $('.additional-label1').text(_.isUndefined(i18n['You’re now removing ALL']) ? 'You’re now removing ALL':i18n['You’re now removing ALL']);
                                            $('.additional-label2').text(_.isUndefined(i18n['Uncheck this box if you wish to remove']) ? 'Uncheck this box if you wish to remove':i18n['Uncheck this box if you wish to remove']);

                                            if(countSelectedLeads == 1) {
                                                $('.send-email-service-quantity').text(_.isUndefined(i18n['contact has been successfully removed']) ? 'contact has been successfully removed':i18n['contact has been successfully removed']);
                                                originalLabel = _.isUndefined(i18n['record (with an email address) from your mailing list.']) ? 'record (with an email address) from your mailing list.':i18n['record (with an email address) from your mailing list.'];
                                                additionalLabel = _.isUndefined(i18n['record (with an email address) matching your filter from your mailing list.']) ? 'record (with an email address) matching your filter from your mailing list.':i18n['record (with an email address) matching your filter from your mailing list.'];
                                            } else {
                                                $('.send-email-service-quantity').text(_.isUndefined(i18n['contacts have been successfully removed']) ? 'contacts have been successfully removed':i18n['contacts have been successfully removed']);
                                                originalLabel = _.isUndefined(i18n['records (with an email address) from your mailing list.']) ? 'records (with an email address) from your mailing list.':i18n['records (with an email address) from your mailing list.'];
                                                additionalLabel = _.isUndefined(i18n['records (with an email address) matching your filter from your mailing list.']) ? 'records (with an email address) matching your filter from your mailing list.':i18n['records (with an email address) matching your filter from your mailing list.'];
                                            }

                                        } else {
                                            $('.information-msg').text(_.isUndefined(i18n['To ensure that all contacts are added to your list(s), please do not close this window until all records have been processed.']) ? 'To ensure that all contacts are added to your list(s), please do not close this window until all records have been processed.':i18n['To ensure that all contacts are added to your list(s), please do not close this window until all records have been processed.']);
                                            $('#send-to-email-service').val(_.isUndefined(i18n['Add contact(s) to list']) ? 'Add contact(s) to list':i18n['Add contact(s) to list']);
                                            $('.original-label1').text(_.isUndefined(i18n['You’re now adding']) ? 'You’re now adding':i18n['You’re now adding']);
                                            $('.original-label2').text(_.isUndefined(i18n['Check this box if you wish to add ALL']) ? 'Check this box if you wish to add ALL':i18n['Check this box if you wish to add ALL']);
                                            $('.additional-label1').text(_.isUndefined(i18n['You’re now adding ALL']) ? 'You’re now adding ALL':i18n['You’re now adding ALL']);
                                            $('.additional-label2').text(_.isUndefined(i18n['Uncheck this box if you wish to add']) ? 'Uncheck this box if you wish to add':i18n['Uncheck this box if you wish to add']);

                                            if(countSelectedLeads == 1) {
                                                $('.send-email-service-quantity').text(_.isUndefined(i18n['contact has been successfully added']) ? 'contact has been successfully added':i18n['contact has been successfully added']);
                                                originalLabel = _.isUndefined(i18n['record (with an email address) to your mailing list.']) ? 'record (with an email address) to your mailing list.':i18n['record (with an email address) to your mailing list.'];
                                                additionalLabel = _.isUndefined(i18n['record (with an email address) matching your filter to your mailing list.']) ? 'record (with an email address) matching your filter to your mailing list.':i18n['record (with an email address) matching your filter to your mailing list.'];
                                            } else {
                                                $('.send-email-service-quantity').text(_.isUndefined(i18n['contacts have been successfully added']) ? 'contacts have been successfully added':i18n['contacts have been successfully added']);
                                                originalLabel = _.isUndefined(i18n['records (with an email address) to your mailing list.']) ? 'records (with an email address) to your mailing list.':i18n['records (with an email address) to your mailing list.'];
                                                additionalLabel = _.isUndefined(i18n['records (with an email address) matching your filter to your mailing list.']) ? 'records (with an email address) matching your filter to your mailing list.':i18n['records (with an email address) matching your filter to your mailing list.'];
                                            }

                                        }

                                        $('.original-label-main').text(originalLabel);
                                        $('.additional-label-label-main').text(additionalLabel);
                                    });

                                    $('#leads-marketing-matching-filter').on('change', function(e){
                                        if ($(this).is(':checked')) {
                                            self.countServiceLeads(filters, 0, checkedLeads, 'emailList');
                                            $('.original-label').hide();
                                            $('.additional-label').show();
                                        } else {
                                            self.countServiceLeads(filters, checkedLeads, null, 'emailList');
                                            $('.original-label').show();
                                            $('.additional-label').hide();
                                        }
                                    });

                                    $('#sent-to-email-service-form').on('submit', function(e){
                                        e.preventDefault();
                                        $('#lead-send-email-service-quantity-processing').text(0);
                                        $('#check-all-for-email-service').addClass('hidden');
                                        $('#lead-send-email-service-quantity-block').addClass('hidden');

                                        var emailServiceName = $("#marketing-services").val(),
                                            checkedLists = $(this).find("input.subscribe-to-email-service-list:checked");

                                        if(emailServiceName == 'select'){
                                            showMessage(_.isUndefined(i18n['Please choose service'])?'Please choose service':i18n['Please choose service'], true, 5000);
                                            $('#check-all-for-email-service').removeClass('hidden');
                                            return false;
                                        }

                                        if(checkedLists.length == 0){
                                            showMessage(_.isUndefined(i18n['Please choose list'])?'Please choose list':i18n['Please choose list'], true, 5000);
                                            $('#check-all-for-email-service').removeClass('hidden');
                                            return false;
                                        }

                                        var emailMarketingFunction = $('input[name=email-marketing-function]:checked').val();
                                        var requestType = 'assign';

                                        if(emailMarketingFunction == 'unassign'){
                                            requestType = 'unassign';
                                        }

                                        if(emailMarketingFunction == 'assign'){
                                            requestType = 'assign';
                                        }

                                        $('#send-to-email-service').prop('disabled', true);

                                        var lists = [];
                                            matchingFilter = 0;
                                        lists['ids'] = [];
                                        lists['labels'] = [];
                                        checkedLists.each(function() {
                                            lists['ids'].push($(this).val());
                                            lists['labels'].push($(this).data('label'));
                                        });

                                        if ($('#leads-marketing-matching-filter').is(':checked')) {
                                            matchingFilter = 1;
                                        }

                                        self.sendToEmailService($(this).attr('action'), emailServiceName, lists, checkedLeads, filters, matchingFilter, 0, [], $('#action-email-service-dialog').data('count-selected-leads'), requestType);
                                    });

                                    var firstSelectedService = '';

                                    if(self.enabledServicesList) {
                                        var skipEach = false;
                                        $.each(self.enabledServicesList, function(value, listName){
                                            if(typeof listName.status !== 'undefined' && listName.status && !skipEach) {
                                                firstSelectedService = value;
                                                skipEach = true;
                                            }
                                        });

                                        if(self.firstLoad) {
                                            self.firstLoad = 0;

                                            $('#marketing-services').val(firstSelectedService).trigger('change');
                                        }
                                    }
                                },
                                close: function(event, ui){
                                    $(this).dialog('close').remove();
                                }
                            });
                            return false;
                        }

                    });

                }
            });
        },
        countSmsSendingLeads: function (filters, checkedLeads, additionalParams)
        {

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/countAllLeads/',
                type: 'POST',
                dataType: 'json',
                data:{'secureToken':$('#lead-grid-token').val(), 'filters':$.param(filters), 'leadIds' : checkedLeads, 'existMobileNumber': '1', 'additionalParams' : additionalParams}
            }).done(function(response) {
                $('.original-label-first-main').show();
                var leadsText = _.isUndefined(i18n['Send SMS']) ? 'Send SMS':i18n['Send SMS'];

                var countSelectedLeads = response.responseText.quantity,
                    additionalCountSelectedLeads = response.responseText.additionalQuantity,
                    recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'],
                    leadGeneralConfigParams = response.responseText.leadGeneralConfigParams;

                if(countSelectedLeads == 1) {
                    recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                }

                var totalText = _.isUndefined(i18n['Total']) ? 'Total' : i18n['Total'];

                var configSmsLimit = _.isUndefined(i18n['unlimited'])?'unlimited':i18n['unlimited'];
                if(typeof leadGeneralConfigParams.smsSendingLimit !== 'undefined' && leadGeneralConfigParams.smsSendingLimit != '') {
                    configSmsLimit = leadGeneralConfigParams.smsSendingLimit;
                }

                var title = leadsText + ' (' + totalText +' '+ countSelectedLeads +' '+ recordsText +')' + ' (' + (_.isUndefined(i18n['Your SMS limit'])?'Your SMS limit':i18n['Your SMS limit']) + ' - ' + configSmsLimit + ')';

                var originalLabelFirstBlock = _.isUndefined(i18n['You are now sending text messages to']) ? 'You are now sending text messages to':i18n['You are now sending text messages to'],
                    additionalLabelFirstBlock = _.isUndefined(i18n['different leads.']) ? 'different leads.':i18n['different leads.'],
                    originalLabelSecondBlock = _.isUndefined(i18n['Check this box if you wish to send text messages to ALL']) ? 'Check this box if you wish to send text messages to ALL':i18n['Check this box if you wish to send text messages to ALL'],
                    additionalLabelSecondBlock = _.isUndefined(i18n['leads matching your filter']) ? 'leads matching your filter':i18n['leads matching your filter'];

                if(countSelectedLeads == 1) {
                    originalLabelFirstBlock = _.isUndefined(i18n['You are now sending text message to']) ? 'You are now sending text message to':i18n['You are now sending text message to'],
                    additionalLabelFirstBlock = _.isUndefined(i18n['lead.']) ? 'lead.':i18n['lead.'];
                }

                if(additionalCountSelectedLeads == 1) {
                    originalLabelFirstBlock = _.isUndefined(i18n['You are now sending text messages to']) ? 'You are now sending text messages to':i18n['You are now sending text messages to'];
                    additionalLabelFirstBlock = _.isUndefined(i18n['different leads.']) ? 'different leads.':i18n['different leads.'];
                    originalLabelSecondBlock = _.isUndefined(i18n['Uncheck this box if you wish to send text message to']) ? 'Uncheck this box if you wish to send text message to':i18n['Uncheck this box if you wish to send text message to'];
                    additionalLabelSecondBlock = _.isUndefined(i18n['lead']) ? 'lead':i18n['lead'];
                }

                if ($('#leads-sms-sending-filter').is(':checked') && countSelectedLeads > 1) {
                    originalLabelFirstBlock = _.isUndefined(i18n['You are now sending text messages to ALL']) ? 'You are now sending text messages to ALL':i18n['You are now sending text messages to ALL'];
                    additionalLabelFirstBlock = _.isUndefined(i18n['leads matching your filter.']) ? 'leads matching your filter.':i18n['leads matching your filter.'];

                }

                if ($('#leads-sms-sending-filter').is(':checked') && additionalCountSelectedLeads > 1) {
                    originalLabelFirstBlock = _.isUndefined(i18n['You are now sending text messages to ALL']) ? 'You are now sending text messages to ALL':i18n['You are now sending text messages to ALL'];
                    additionalLabelFirstBlock = _.isUndefined(i18n['leads matching your filter.']) ? 'leads matching your filter.':i18n['leads matching your filter.'];
                    originalLabelSecondBlock = _.isUndefined(i18n['Uncheck this box if you wish to send text messages to']) ? 'Uncheck this box if you wish to send text messages to':i18n['Uncheck this box if you wish to send text messages to'];
                    additionalLabelSecondBlock = _.isUndefined(i18n['different leads']) ? 'different leads':i18n['different leads'];
                }


                $('.original-label-first-block').text(originalLabelFirstBlock);
                $('.additional-label-first-block').text(additionalLabelFirstBlock);

                $('.original-label-second-block').text(originalLabelSecondBlock);
                $('.additional-label-second-block').text(additionalLabelSecondBlock);

                $('#action-sms-sending-dialog').data('count-selected-leads', countSelectedLeads);
                $('#action-sms-sending-dialog').dialog('option', 'title', title);

                $('.checked-leads-counter-first-block').text(countSelectedLeads);
                $('.checked-leads-counter-second-block').text(additionalCountSelectedLeads);

                if(parseInt(configSmsLimit) < parseInt(countSelectedLeads)) {
                    $('#lead-sms-now').prop('disabled', true);
                    showMessage(_.isUndefined(i18n['You can\'t send SMS, Your limit has been reached. Please increase "Send SMS limit"'])?'You can\'t send SMS, Your limit has been reached. Please increase "Send SMS limit"':i18n['You can\'t send SMS, Your limit has been reached. Please increase "Send SMS limit"'], true, 3000);
                } else {
                    $('#lead-sms-now').prop('disabled', false);
                }
            });
        },
        sendSms: function(action, checkedLeads, filters, matchingFilter, stepSendSms, countSelectedLeads, smsMessage, uniqueMobilesNumbers, testSms){
            var self = this,
                sendEl = $('#lead-send-sms-sending-quantity-processing'),
                uploadedFiles = '';

            if(!$('.mms-images-block').hasClass('hide') && self.uploadedFiles.length) {
                uploadedFiles = this.uploadedFiles.join(',');
            }

            $.ajax({
                url: action,
                type: 'POST',
                dataType: 'json',
                'data' : {
                    'secureToken': $('#lead-grid-token').val(),
                    'leadIds' : checkedLeads,
                    'filters' : $.param(filters),
                    'matchingFilter': matchingFilter,
                    'stepSendSms' : stepSendSms,
                    'filterQuantity': $('#action-sms-sending-dialog').data('count-selected-leads'),
                    'smsMessage' : smsMessage,
                    'uniqueMobilesNumbers' : uniqueMobilesNumbers,
                    'testSms' : testSms,
                    'mediaFiles' : uploadedFiles
                }
            }).done(function(response) {
                $('#lead-send-sms-sending-quantity-block-processing').removeClass('hidden');
                if(testSms == 1) {
                    $('#lead-sms-now').prop('disabled', false);
                    showMessage(response.responseText.message, false, 5000);
                    $('#check-all-for-sms-sending').removeClass('hidden');
                    $('#lead-send-sms-sending-quantity-block').removeClass('hidden');
                } else {
                    sendEl.text(parseInt(sendEl.text()) + parseInt(response.responseText.quantity));
                    if(response.error == 0){
                        var uniqueMobilesNumbersData = response.responseText.uniqueMobilesNumbers;
                        self.sendSms(action, checkedLeads, filters, matchingFilter, stepSendSms + 1, countSelectedLeads, smsMessage, uniqueMobilesNumbersData);
                    } else {
                        $('#lead-send-sms-sending-quantity-block-processing').addClass('hidden');
                        $('#lead-send-sms-sending-quantity-block').removeClass('hidden');
                        showMessage(response.responseText.message, false, 5000);
                        $('#lead-sms-now').prop('disabled', false);
                        self.tinimce.activeEditor.setContent('');
                        $('#check-all-for-sms-sending').removeClass('hidden');
                        self.deleteMmsMassActionFiles();
                        self.uploadedFiles = [];
                        self.maxUploadedFiles = 0;
                        $('#lead-mms-media-files-list').empty();
                        $('.uploaded-mms-size-count').text('0');
                    }
                }
            }).fail(function(response){
                showMessage(response.responseText, true, 5000);
            });
        },
        deleteMmsMassActionFiles: function () {
            var self = this;
            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/deleteMmsMassActionFiles/',
                type: 'POST',
                dataType: 'json',
                data:{'secureToken':$('#lead-grid-token').val(), 'mediaFiles' : self.uploadedFiles}
            }).done(function(response) {
                if(response.error == 1){
                    //showMessage(response.responseText, true, 5000);
                }
            });
        },
        countServiceLeads: function(filters, checkedLeads, additionalParams, actionEmailType)
        {
            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/countAllLeads/',
                type: 'POST',
                dataType: 'json',
                data:{'secureToken':$('#lead-grid-token').val(), 'filters':$.param(filters), 'leadIds' : checkedLeads, 'uniqueEmail': '1', 'additionalParams' : additionalParams}
            }).done(function(response) {
                var leadsText = '';
                if(actionEmailType == 'emailList') {
                    leadsText = _.isUndefined(i18n['Add/Remove emails to Email Marketing']) ? 'Add/Remove emails to Email Marketing':i18n['Add/Remove emails to Email Marketing'];
                } else if (actionEmailType == 'remarketingList') {
                    leadsText = _.isUndefined(i18n['Add/Remove emails to Ad platforms audiences']) ? 'Add/Remove emails to Ad platforms audiences':i18n['Add/Remove emails to Ad platforms audiences'];
                }

                var countSelectedLeads = response.responseText.quantity,
                    additionalCountSelectedLeads = response.responseText.additionalQuantity,
                    recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];

                if(countSelectedLeads == 1) {
                    if(actionEmailType == 'emailList') {
                        leadsText = _.isUndefined(i18n['Add/Remove email to Email Marketing']) ? 'Add/Remove email to Email Marketing':i18n['Add/Remove email to Email Marketing'];
                    } else if (actionEmailType == 'remarketingList') {
                        leadsText = _.isUndefined(i18n['Add/Remove email to Ad platforms audiences']) ? 'Add/Remove email to Ad platforms audiences':i18n['Add/Remove email to Ad platforms audiences'];
                    }
                    recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                }

                var totalText = _.isUndefined(i18n['Total']) ? 'Total' : i18n['Total'];
                var title = leadsText + ' (' + totalText +' '+ countSelectedLeads +' '+ recordsText +')';

                var originalLabel = _.isUndefined(i18n['records (with an email address) to your mailing list.']) ? 'records (with an email address) to your mailing list.':i18n['records (with an email address) to your mailing list.'],
                    additionalLabel = _.isUndefined(i18n['records (with an email address) matching your filter to your mailing list.']) ? 'records (with an email address) matching your filter to your mailing list.':i18n['records (with an email address) matching your filter to your mailing list.'],
                    originalLabel2 = _.isUndefined(i18n['records matching your filter']) ? 'records matching your filter':i18n['records matching your filter'],
                    additionalLabel2 = _.isUndefined(i18n['selected records']) ? 'selected records':i18n['selected records'];

                    var emailMarketingFunction = $('input[name=email-marketing-function]:checked').val();
                    var emailRemarketingFunction = $('input[name=remarketing-function]:checked').val();

                    if(typeof emailMarketingFunction !== 'undefined' && emailMarketingFunction == 'unassign') {
                        originalLabel = _.isUndefined(i18n['records (with an email address) from your mailing list.']) ? 'records (with an email address) from your mailing list.':i18n['records (with an email address) from your mailing list.'];
                        additionalLabel = _.isUndefined(i18n['records (with an email address) matching your filter from your mailing list.']) ? 'records (with an email address) matching your filter from your mailing list.':i18n['records (with an email address) matching your filter from your mailing list.'];
                    }

                if (actionEmailType == 'remarketingList') {
                    originalLabel = _.isUndefined(i18n['records (with an email address) to your campaign list.']) ? 'records (with an email address) to your campaign list.':i18n['records (with an email address) to your campaign list.'];
                    additionalLabel = _.isUndefined(i18n['records (with an email address) matching your filter to your campaign list.']) ? 'records (with an email address) matching your filter to your campaign list.':i18n['records (with an email address) matching your filter to your campaign list.'];
                    originalLabel2 = _.isUndefined(i18n['records matching your filter']) ? 'records matching your filter':i18n['records matching your filter'];
                    additionalLabel2 = _.isUndefined(i18n['selected records']) ? 'selected records':i18n['selected records'];

                    if(typeof emailRemarketingFunction !== 'undefined' && emailRemarketingFunction == 'unassign') {
                        originalLabel = _.isUndefined(i18n['records (with an email address) from your campaign list.']) ? 'records (with an email address) from your campaign list.':i18n['records (with an email address) from your campaign list.'];
                        additionalLabel = _.isUndefined(i18n['records (with an email address) matching your filter from your campaign list.']) ? 'records (with an email address) matching your filter from your campaign list.':i18n['records (with an email address) matching your filter from your campaign list.'];
                    }
                }

                if(countSelectedLeads == 1) {
                    originalLabel = _.isUndefined(i18n['record (with an email address) to your mailing list.']) ? 'record (with an email address) to your mailing list.':i18n['record (with an email address) to your mailing list.'];
                    additionalLabel = _.isUndefined(i18n['record matching your filter to your mailing list.']) ? 'record matching your filter to your mailing list.':i18n['record matching your filter to your mailing list.'];

                    if(typeof emailMarketingFunction !== 'undefined' && emailMarketingFunction == 'unassign') {
                        originalLabel = _.isUndefined(i18n['record (with an email address) from your mailing list.']) ? 'record (with an email address) from your mailing list.':i18n['record (with an email address) from your mailing list.'];
                        additionalLabel = _.isUndefined(i18n['record matching your filter from your mailing list.']) ? 'record matching your filter from your mailing list.':i18n['record matching your filter from your mailing list.'];
                    }

                    if (actionEmailType == 'remarketingList') {
                        originalLabel = _.isUndefined(i18n['record (with an email address) to your campaign list.']) ? 'record (with an email address) to your campaign list.':i18n['record (with an email address) to your campaign list.'];
                        additionalLabel = _.isUndefined(i18n['record (with an email address) matching your filter to your campaign list.']) ? 'record (with an email address) matching your filter to your campaign list.':i18n['record (with an email address) matching your filter to your campaign list.'];

                        if(typeof emailRemarketingFunction !== 'undefined' && emailRemarketingFunction == 'unassign') {
                            originalLabel = _.isUndefined(i18n['record (with an email address) from your campaign list.']) ? 'record (with an email address) from your campaign list.':i18n['record (with an email address) from your campaign list.'];
                            additionalLabel = _.isUndefined(i18n['record (with an email address) matching your filter from your campaign list.']) ? 'record (with an email address) matching your filter from your campaign list.':i18n['record (with an email address) matching your filter from your campaign list.'];
                        }
                    }
                }

                if(additionalCountSelectedLeads == 1) {
                    originalLabel2 = _.isUndefined(i18n['record matching your filter']) ? 'record matching your filter':i18n['record matching your filter'];
                    additionalLabel2 = _.isUndefined(i18n['selected record']) ? 'selected record':i18n['selected record'];

                    if (actionEmailType == 'remarketingList') {
                        originalLabel2 = _.isUndefined(i18n['record matching your filter']) ? 'record matching your filter':i18n['record matching your filter'];
                        additionalLabel2 = _.isUndefined(i18n['selected record']) ? 'selected record':i18n['selected record'];
                    }
                }

                $('.original-label-main').text(originalLabel);
                $('.additional-label-label-main').text(additionalLabel);

                $('.original-label-main2').text(originalLabel2);
                $('.additional-label-label-main2').text(additionalLabel2);

                if(actionEmailType == 'emailList') {
                    $('#send-to-email-service').data('count-selected-leads', countSelectedLeads);
                    $('#action-email-service-dialog').dialog('option', 'title', title);
                } else if (actionEmailType == 'remarketingList') {
                    $('#send-to-remarketing').data('count-selected-leads', countSelectedLeads);
                    $('#action-remarketing-dialog').dialog('option', 'title', title);
                }

                $('.checked-leads-counter').text(countSelectedLeads);
                $('.additional-checked-leads-counter').text(additionalCountSelectedLeads);
            });
        },
        sendToRemarketingList: function(action, marketingCampaignsName, lists, checkedLeads, filters, matchingFilter, stepToRemarketingListService, accountErrors, countSelectedLeads, requestType){
            var self = this,
                importedEl = $('#lead-send-remarketing-quantity-processing');

            self.beforeSelectedCampaign.campaign = '';
            self.campaignSelectedListsIds = {};
            self.campaignSelectedListsLabels = {};

            $.ajax({
                url: action,
                type: 'POST',
                dataType: 'json',
                'data' : {
                    'secureToken': $('#lead-grid-token').val(),
                    'marketingCampaignsName': marketingCampaignsName,
                    'lists': JSON.stringify(lists['ids']),
                    'listsLabels': JSON.stringify(lists['names']),
                    leadIds:checkedLeads,
                    'filters' : $.param(filters),
                    'matchingFilter': matchingFilter,
                    'stepToRemarketingListService' : stepToRemarketingListService,
                    'accountErrors': accountErrors,
                    'filterQuantity': $('#send-to-remarketing').data('count-selected-leads'),
                    'requestType': requestType
                }
            }).done(function(response) {
                $('#lead-send-remarketing-quantity-block-processing').removeClass('hidden');
                if(response.error == 0){
                    var accountErrors = [];
                    if(response.responseText.accountErrors) {
                        accountErrors = response.responseText.accountErrors;
                    }
                    self.sendToRemarketingList(action, marketingCampaignsName, lists, checkedLeads, filters, matchingFilter, stepToRemarketingListService + 1, accountErrors, countSelectedLeads, requestType);
                } else {
                    $('#lead-send-remarketing-quantity-block-processing').addClass('hidden');
                    if(typeof response.responseText.accountErrors !== 'undefined') {
                        var errorMessage = response.responseText.message,
                            errorInformation = '<p>';

                        $.each(response.responseText.accountErrors, function(value, errorName){
                            $.each(lists.ids, function(lkey, lname){
                                if(lkey != '') {
                                    $.each(lname, function(llkey, llname){
                                        if(typeof errorName[llname] !== 'undefined') {
                                            errorInformation += lkey + ': ' + lists.names[lkey][llkey] + '(' + llname + ') has error: ' + errorName[llname] + '<br />';
                                        }
                                    });
                                }
                            })
                        });

                        errorInformation += '</p>';
                            //downloadErrFileLink = '<a class="btn error fl-right grid_5" href="'+$('#website_url').val()+'plugin/leads/run/downloadFile/?fileName='+response.responseText.errorFileName+'" >'+(_.isUndefined(i18n['Download error log'])?'Download error log':i18n['Download error log'])+'</a>'+ '';
                        if(!response.responseText.accountErrors.length) {
                            if(requestType == 'assign') {
                                showMessage(_.isUndefined(i18n['Added to Ad audience list(s)'])?'Added to Ad audience list(s)':i18n['Added to Ad audience list(s)'], false, 5000);
                            } else {
                                showMessage(_.isUndefined(i18n['Removed from Ad audience list(s)'])?'Removed from Ad audience list(s)':i18n['Removed from Ad audience list(s)'], false, 5000);
                            }
                        } else {
                            showMessage(errorMessage + errorInformation, true, 5000);
                        }
                        //$('#leads-error-btn').empty().show().append(downloadErrFileLink);
                        $('#send-to-remarketing').prop('disabled', false);
                        $('#check-all-for-remarketing').removeClass('hidden');
                        $('#lead-send-remarketing-quantity-block').removeClass('hidden');
                    } else {
                        $('#lead-send-remarketing-quantity-block').removeClass('hidden');
                        if(requestType == 'assign') {
                            showMessage(_.isUndefined(i18n['Added to Ad audience list(s)'])?'Added to Ad audience list(s)':i18n['Added to Ad audience list(s)'], false, 5000);
                        } else {
                            showMessage(_.isUndefined(i18n['Removed from Ad audience list(s)'])?'Removed from Ad audience list(s)':i18n['Removed from Ad audience list(s)'], false, 5000);
                        }
                        $('#send-to-remarketing').prop('disabled', false);
                        $('#check-all-for-remarketing').removeClass('hidden');
                    }
                }
                importedEl.text(parseInt(importedEl.text()) + parseInt(response.responseText.quantity));
            }).fail(function(response){
                showMessage(response.responseJSON.responseText, true, 5000);
            });
        },
        sendToEmailService: function(action, emailServiceName, lists, checkedLeads, filters, matchingFilter, stepSendEmailService, invalidLeads, countSelectedLeads, requestType){
            var self = this,
                importedEl = $('#lead-send-email-service-quantity-processing');
            $.ajax({
                url: action,
                type: 'POST',
                dataType: 'json',
                'data' : {
                    'secureToken': $('#lead-grid-token').val(),
                    'emailServiceName': emailServiceName,
                    'lists': lists['ids'].join(','),
                    'listsLabels': lists['labels'].join(','),
                    leadIds:checkedLeads,
                    'detailedInfo': $('#email-service-detailed-info').val(),
                    'filters' : $.param(filters),
                    'matchingFilter': matchingFilter,
                    'stepSendEmailService' : stepSendEmailService,
                    'invalidLeads': invalidLeads,
                    'filterQuantity': $('#send-to-email-service').data('count-selected-leads'),
                    'requestType': requestType
                }
            }).done(function(response) {
                $('#lead-send-email-service-quantity-block-processing').removeClass('hidden');
                if(response.error == 0){
                    var invalidLeads = [];
                    if(response.responseText.invalidLeads) {
                        invalidLeads = response.responseText.invalidLeads;
                    }
                    self.sendToEmailService(action, emailServiceName, lists, checkedLeads, filters, matchingFilter, stepSendEmailService + 1, invalidLeads, countSelectedLeads, requestType);
                } else {
                    $('#lead-send-email-service-quantity-block-processing').addClass('hidden');
                    if(typeof response.responseText.errorFileName !== 'undefined') {
                        var errorMessage = response.responseText.message,
                            downloadErrFileLink = '<a class="btn error fl-right grid_12" href="'+$('#website_url').val()+'plugin/leads/run/downloadFile/?fileName='+response.responseText.errorFileName+'" >'+(_.isUndefined(i18n['Download error log'])?'Download error log':i18n['Download error log'])+'</a>'+ '';

                        showMessage(errorMessage, true, 5000);
                        $('#leads-error-btn').empty().show().append(downloadErrFileLink);
                    } else {
                        $('#lead-send-email-service-quantity-block').removeClass('hidden');
                        if(requestType == 'assign') {
                            showMessage(_.isUndefined(i18n['Contact(s) added'])?'Contact(s) added':i18n['Contact(s) added'], false, 5000);
                        } else {
                            showMessage(_.isUndefined(i18n['Contact(s) removed'])?'Contact(s) removed':i18n['Contact(s) removed'], false, 5000);
                        }
                        $('#send-to-email-service').prop('disabled', false);
                        $('#check-all-for-email-service').removeClass('hidden');
                    }
                }
                importedEl.text(parseInt(importedEl.text()) + parseInt(response.responseText.quantity));
            }).fail(function(response){
                showMessage(response.responseJSON.responseText, true, 5000);
                // $('.smoke').css({'z-index': 10000});
            });
        },
        assignTotalOpportunitiesAmount: function(leadIds) {
            var self = this,
                dateFrom =  ($('#lead-filter-opportunity-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-filter-opportunity-date').datepicker("getDate")): '',
                dateTo = ($('#lead-filter-opportunity-to-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-filter-opportunity-to-date').datepicker("getDate")): '',
                dateType = '',
                leadOpportunityStages = $('#lead-filter-opportunity-stage').val(),
                leadOpportunityType = $('#lead-filter-by-opportunity-type').val(),
                leadOpportunityOwner = $('#lead-filter-by-opportunity-owner').val();


            if ($('#switch-expected-date').is(':checked')) {
                dateType = 'expected';
            }

            if ($('#switch-creation-date').is(':checked')) {
                dateType = 'created';
            }

            if ($('#switch-stage-change-date').is(':checked')) {
                dateType = 'changed';
            }


            $.get($('#website_url').val()+'api/leads/leadsgridstats/', {'leadIds' : leadIds.join(','), 'dateType': dateType, 'dateFrom':dateFrom, 'dateTo':dateTo, 'leadOpportunityStages':leadOpportunityStages, 'leadOpportunityType':leadOpportunityType, 'leadOpportunityOwner':leadOpportunityOwner }, function(response){
                if (!_.isEmpty(response)) {
                    if (!_.isUndefined(response.totalSpentInfo)) {
                        _.each(response.totalSpentInfo, function (statData, id) {
                            self.$el.find('.lead-row-id-' + id).find('.total-sales-amount').text(accounting.formatMoney(Math.round(parseFloat(statData.total).toFixed(2)), JSON.parse(self.leads.moneyFormat)));
                        });
                    }

                    if (!_.isUndefined(response.totalOpportunitiesInfo)) {
                        _.each(response.totalOpportunitiesInfo, function (opportunityData, id) {
                            if (opportunityData.total !== null) {
                                self.$el.find('.lead-row-id-' + id).find('.total-opportunities-amount').html('<span class="total-opportunities-amount-value">'+accounting.formatMoney(Math.round(opportunityData.total), JSON.parse(self.leads.moneyFormat))+'</span>');
                            }
                        });
                    }
                }
            }, 'json');
        },
        callLeadDialog: function(e) {
            var leadId =  $(e.currentTarget).data('cid'),
                model = this.leads.get(leadId),
                mobile = '',
                mobileCountyCodeValue = '',
                mobileCountyCode = '',
                phone = '',
                phoneCountryCodeValue = '',
                phoneCountryCode = '',
                self = this,
                currentMobilePhone = '',
                currentDesktopPhone = '',
                currentMobileCountryCode = '',
                currentDesktopCountryCode = '',
                currentVoipPhone = '';


                if (!_.isNull(model.get('lead_mobile'))) {
                    mobile = model.get('lead_mobile');
                }
                if (!_.isNull(model.get('lead_mobile_country_code_value'))) {
                    mobileCountyCodeValue = model.get('lead_mobile_country_code_value');
                }
                if (!_.isNull(model.get('lead_mobile_country_code'))) {
                    mobileCountyCode = model.get('lead_mobile_country_code');
                }

                if (!_.isNull(model.get('lead_phone'))) {
                    phone = model.get('lead_phone');
                }
                if (!_.isNull(model.get('lead_phone_country_code_value'))) {
                    phoneCountryCodeValue = model.get('lead_phone_country_code_value');
                }
                if (!_.isNull(model.get('lead_phone_country_code'))) {
                    phoneCountryCode = model.get('lead_phone_country_code');
                }
                if (!_.isNull(this.leads.currnetMobileCountryCode)) {
                    currentMobileCountryCode = this.leads.currnetMobileCountryCode;
                }
                if (!_.isNull(this.leads.currentMobilePhone)) {
                    currentMobilePhone = this.leads.currentMobilePhone;
                }
                if (!_.isNull(this.leads.currentDesktopCountryCode)) {
                    currentDesktopCountryCode = this.leads.currentDesktopCountryCode;
                }
                if (!_.isNull(this.leads.currentDesktopPhone)) {
                    currentDesktopPhone = this.leads.currentDesktopPhone;
                }
                if (!_.isNull(this.leads.currentVoipPhone)) {
                    currentVoipPhone = this.leads.currentVoipPhone;
                }

            var dialog = _.template(CallDialogTmpl, {
                i18n:i18n,
                mobile: mobile,
                phone: phone,
                mobileCountyCodeValue: mobileCountyCodeValue,
                phoneCountryCodeValue: phoneCountryCodeValue,
                mobileCountyCode: mobileCountyCode,
                phoneCountryCode: phoneCountryCode,
                phoneCountryCodes : self.leads.phoneCountryCodes,
                currentMobilePhone : currentMobilePhone,
                currentDesktopPhone: currentDesktopPhone,
                currentVoipPhone: currentVoipPhone,
                leadModel:model
            });

            $(dialog).dialog({
                dialogClass: 'seotoaster',
                buttons: {},
                resizable : false,
                draggable: false,
                height    : 150,
                width     : 1000,
                'title': 'Call to '+model.get('lead_first_name')+' '+model.get('lead_last_name'),
                open: function(event, ui) {
                    var desktopMasks = self.leads.desktopMasks,
                        mobileMasks = self.leads.mobileMasks;

                    if (typeof mobileMasks[mobileCountyCode] !== 'undefined') {
                        $('#call-lead-number').mask(mobileMasks[mobileCountyCode].full_mask_value, {autoclear: false});
                    } else {
                        $('#call-lead-number').mask('(999) 999 9999', {autoclear: false});
                    }

                    if (typeof mobileMasks[currentMobileCountryCode] !== 'undefined') {
                        $('#lead-from-call-mobile').mask(mobileMasks[currentMobileCountryCode].mask_value, {autoclear: false});
                    } else {
                        $('#lead-from-call-mobile').mask('(999) 999 9999', {autoclear: false});
                    }
                    var mobile = _.isUndefined(i18n['Mobile'])?'Mobile':i18n['Mobile'];
                    $('#lead-from-call-mobile-number').text(mobile + ' ' + $('#lead-from-call-mobile').val());

                    if (typeof mobileMasks[currentDesktopCountryCode] !== 'undefined') {
                        $('#lead-from-call-desktop').mask(mobileMasks[currentDesktopCountryCode].mask_value, {autoclear: false});
                    } else {
                        $('#lead-from-call-desktop').mask('(999) 999 9999', {autoclear: false});
                    }
                    var desktop = _.isUndefined(i18n['Desktop'])?'Desktop':i18n['Desktop'];
                    $('#lead-from-call-desktop-number').text(desktop + ' ' + $('#lead-from-call-desktop').val());

                    var voipPhone = _.isUndefined(i18n['VOIP phone'])?'VOIP phone':i18n['VOIP phone'];
                    $('#lead-from-call-voip-phone-number').text(voipPhone + ' ' + $('#lead-from-call-voip-phone').val());

                    $('#call-lead-action').on('click',  function(){
                        $.ajax({
                            url: $('#website_url').val()+'plugin/leads/run/callLead/',
                            type: 'POST',
                            dataType: 'json',
                            data:{
                                'secureToken':$('#lead-grid-token').val(),
                                'lead-call-country-code':$('#lead-phone-mobile-country-codes').val(),
                                'lead-call-number':$('#call-lead-number').val(),
                                'call-from-device-type':$('#call-from-device-type').val(),
                                'leadId':leadId,
                                'i18n' : i18n
                            }
                        }).done(function(response){
                            showMessage(response.responseText, false, 5000);
                            $('#call-lead-dialog').dialog('close');
                        }).fail(function(response){
                            showMessage(response.responseJSON, true, 5000);
                        });
                    });
                    $('#call-device-type').on('change',  function(e){
                         var deviceTypeEl = $(e.currentTarget),
                            deviceType = deviceTypeEl.val(),
                            phoneEl = $('#call-lead-number');

                        if (deviceType === 'mobile') {
                            if (_.isEmpty(mobileCountyCode)) {
                                $('#lead-phone-mobile-country-codes').val('AC');
                            } else {
                                $('#lead-phone-mobile-country-codes').val(mobileCountyCode);
                            }
                            phoneEl.val(mobile);
                            if (typeof mobileMasks[mobileCountyCode] !== 'undefined') {
                                $('#call-lead-number').mask(mobileMasks[mobileCountyCode].full_mask_value, {autoclear: false});
                            } else {
                                $('#call-lead-number').mask('(999) 999 9999', {autoclear: false});
                            }
                        }

                        if (deviceType === 'desktop') {
                            if (_.isEmpty(phoneCountryCode)) {
                                $('#lead-phone-mobile-country-codes').val('AC');
                            } else {
                                $('#lead-phone-mobile-country-codes').val(phoneCountryCode);
                            }
                            phoneEl.val(phone);
                            if (typeof desktopMasks[phoneCountryCode] !== 'undefined') {
                                $('#call-lead-number').mask(desktopMasks[phoneCountryCode].full_mask_value, {autoclear: false});
                            } else {
                                $('#call-lead-number').mask('(999) 999 9999', {autoclear: false});
                            }
                        }
                    });

                    $('#call-from-device-type').on('change',  function(e){
                        var deviceTypeEl = $(e.currentTarget),
                            deviceType = deviceTypeEl.val();

                        $('#call-lead-action').removeClass('grid_8').addClass('grid_12');
                        $('#zoiper-img').hide();

                        if (deviceType === 'voip-phone') {
                            $('#call-lead-action').removeClass('grid_12').addClass('grid_8');
                            $('#zoiper-img').show();
                        }
                    });

                    $('#lead-phone-mobile-country-codes').on('change',  function(e){
                       var countryEl = $(e.currentTarget),
                           chosenCountryCode = countryEl.val(),
                           deviceType = $('#call-device-type').val();

                        if (deviceType === 'mobile') {
                            if (typeof mobileMasks[chosenCountryCode] !== 'undefined') {
                                $('#call-lead-number').mask(mobileMasks[chosenCountryCode].full_mask_value, {autoclear: false});
                            } else {
                                $('#call-lead-number').mask('(999) 999 9999', {autoclear: false});
                            }
                        }

                        if (deviceType === 'desktop') {
                            if (typeof desktopMasks[chosenCountryCode] !== 'undefined') {
                                $('#call-lead-number').mask(desktopMasks[chosenCountryCode].full_mask_value, {autoclear: false});
                            } else {
                                $('#call-lead-number').mask('(999) 999 9999', {autoclear: false});
                            }
                        }
                    });
                },
                close: function(event, ui){
                    $(this).dialog('close').remove();
                }
            });
            return false;
        },
        processMergeLeads: function(mergeToIdParam, mergeBasedOnParam, leadModelParam, attrNameParam, currentAttributeParam) {
            var mergeToId = mergeToIdParam,
                mergeBasedOn = mergeBasedOnParam,
                leadModel = leadModelParam,
                attrName = attrNameParam,
                currentAttribute = currentAttributeParam;

            leadModel.set('mergeRecordWithId', mergeToId);
            leadModel.set('mergeBasedOn', mergeBasedOn);
            leadModel.save(null, {
                success: function (model, response) {
                    window.location = $('#website_url').val() + 'dashboard/leads/#lead/' + mergeToId
                },
                error: function (model, response) {
                    leadModel.set('mergeRecordWithId', '');
                    leadModel.set('mergeBasedOn', '');
                    leadModel.set(attrName, currentAttribute.data('old-value'));
                    showMessage(response.responseJSON, true, 5000);
                    currentAttribute.val(currentAttribute.data('old-value'));
                    return false;
                }
            });
        },
        editLeadAttribute: function(e, lModel)
        {
            var currentAttribute = $(e.currentTarget),
                currentValue = currentAttribute.val(),
                oldValue = currentAttribute.data('old-value'),
                leadId = currentAttribute.data('cid'),
                leadModel = this.leads.get(leadId),
                attrName =  currentAttribute.data('attrName'),
                self = this;

            if (currentValue != oldValue) {
                if(typeof leadModel === 'undefined' && typeof lModel !== 'undefined') {
                    leadModel = lModel;
                }

                leadModel.set(attrName, currentValue);
                leadModel.set('secureToken', $('#lead-grid-token').val());
                leadModel.save(null, {
                    success: function(model, response){
                        if (response.error == '1') {
                            if (typeof response.responseText.duplicatedLeadEmail !== 'undefined') {
                                showConfirm(response.responseText.message + ' ' + (_.isUndefined(i18n['Would you like to merge both records?']) ? 'Would you like to merge both records?' : i18n['Would you like to merge both records?']), function () {
                                    self.processMergeLeads(response.responseText.mergeToId, response.responseText.mergeBasedOn, leadModel, attrName, currentAttribute);
                                }, function () {
                                    leadModel.set(attrName, oldValue);
                                    currentAttribute.val(oldValue);
                                });
                            } else if(typeof response.responseText.duplicatedLeadPhone !== 'undefined') {
                                showConfirm(response.responseText.message + ' ' + (_.isUndefined(i18n['Would you like to merge both records?']) ? 'Would you like to merge both records?' : i18n['Would you like to merge both records?']), function () {
                                    self.processMergeLeads(response.responseText.mergeToId, response.responseText.mergeBasedOn, leadModel, attrName, currentAttribute);
                                }, function () {
                                    leadModel.set(attrName, oldValue);
                                    currentAttribute.val(oldValue);
                                });
                            } else if(typeof response.responseText.duplicatedLeadMobile !== 'undefined') {
                                showConfirm(response.responseText.message + ' ' + (_.isUndefined(i18n['Would you like to merge both records?']) ? 'Would you like to merge both records?' : i18n['Would you like to merge both records?']), function () {
                                    self.processMergeLeads(response.responseText.mergeToId, response.responseText.mergeBasedOn, leadModel, attrName, currentAttribute);
                                }, function () {
                                    leadModel.set(attrName, oldValue);
                                    currentAttribute.val(oldValue);
                                });
                            } else {
                                showMessage(response.responseText.message, true, 5000);
                            }
                        } else {
                            currentAttribute.data('old-value', currentValue);
                            if (attrName === 'lead_source') {
                                if ($.trim(currentValue)) {
                                    self.$el.find('#lead_source_info_' + leadId).removeClass('hidden').attr('title', currentValue);
                                }
                            }
                            showMessage(response.responseText.message, false, 1000);
                        }
                    },
                    error: function(model, response){
                        currentAttribute.val(oldValue);
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }

        },
        deleteLead: function(e){
            var cid = $(e.currentTarget).data('cid'),
                model = this.leads.get(cid),
                self = this;

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model){
                    model.destroy();
                    self.render();
                }
            });
        },
        deleteAndMarkAsSpamLead: function(e){
            var cid = $(e.currentTarget).data('cid'),
                model = this.leads.get(cid),
                self = this;

            showConfirm(_.isUndefined(i18n['Are you sure want to delete and mark lead as spam?'])?'Are you sure want to delete and mark lead as spam?':i18n['Are you sure want to delete and mark lead as spam?'], function(){
                if (model){
                    showSpinner('#lead-grid-table', 'merge-leads-stats-spinner dashboard-spinner');

                    $.ajax({
                        url: $('#website_url').val() + 'api/leads/leads/id/'+cid+'/deleteAndMarkAsSpam/1/',
                        type: 'DELETE',
                        dataType: 'json',
                        data: {}
                    }).done(function (response) {
                        hideSpinner('.merge-leads-stats-spinner');
                        model.destroy();
                        self.render();
                    });
                }
            });
        },
        deleteLeadsAction: function(e){
            var leadIds = this.checkedLeadRows.join(','),
                countSelectedLeads = this.checkedLeadRows.length,
                filters = this.leads.server_api.filter(),
                filterUsed = this.leads.filterUsed,
                self = this;

            var dialog = _.template(massDeleteDialog, {
                leadIds: leadIds,
                filters : $.param(filters),
                filterUsed : filterUsed,
                countSelectedLeads: countSelectedLeads,
                i18n:i18n
            });

            $(dialog).dialog({
                dialogClass: 'seotoaster',
                width: '25%',
                height: '160',
                resizable: false,
                draggable: false,
                open: function (event, ui) {
                    var deleteLeadsText = _.isUndefined(i18n['Delete leads']) ? 'Delete leads' : i18n['Delete leads'],
                        totalText = _.isUndefined(i18n['Total']) ? 'Total' : i18n['Total'],
                        recordsText = _.isUndefined(i18n['records']) ? 'records' : i18n['records'],
                        title = '';

                    $('#delete-leads-form').on('submit', function(e){
                        e.preventDefault();

                        $('.orig-processed').find('.mass-delete-leads-quantity').text(0);
                        $('.end-processed').find('.mass-delete-leads-quantity').text(0);

                        var matchingFilter = 0;

                        if ($('#delete-all-leads-matching-filter').is(':checked')) {
                            matchingFilter = 1;
                        }

                        if (matchingFilter === 1) {
                            $.ajax({
                                url: $('#website_url').val() + 'plugin/leads/run/countAllLeads/',
                                type: 'POST',
                                dataType: 'json',
                                data: {
                                    'secureToken': $('#lead-grid-token').val(),
                                    'filters': $.param(filters)
                                }
                            }).done(function (response) {
                                var countSelectedLeadsResponse = response.responseText.quantity,
                                    leadsLabel = _.isUndefined(i18n['leads'])?'leads':i18n['leads'];

                                if(countSelectedLeadsResponse == 1) {
                                    leadsLabel = _.isUndefined(i18n['lead'])?'lead':i18n['lead'];
                                }

                                showConfirm((_.isUndefined(i18n['Are you sure want to delete']) ? 'Are you sure want to delete' : i18n['Are you sure want to delete']) + ' ' + countSelectedLeadsResponse + ' ' + leadsLabel + '?', function () {
                                    self.massDeleteLeadsRequest($(this).attr('action'), leadIds, filters,  matchingFilter, 0, $('#delete-leads-dialog').data('count-selected-leads'));
                                });
                            });
                        } else {
                            var leadsLabel = _.isUndefined(i18n['leads'])?'leads':i18n['leads'];
                            if(countSelectedLeads == 1) {
                                leadsLabel = _.isUndefined(i18n['lead'])?'lead':i18n['lead'];
                            }

                            showConfirm((_.isUndefined(i18n['Are you sure want to delete']) ? 'Are you sure want to delete' : i18n['Are you sure want to delete']) + ' ' + countSelectedLeads + ' ' + leadsLabel + '?', function () {
                                self.massDeleteLeadsRequest($(this).attr('action'), leadIds, filters,  matchingFilter, 0, $('#delete-leads-dialog').data('count-selected-leads'));
                            });
                        }

                    });

                    $('.allLeads').on('change', function (e) {
                        e.preventDefault();

                        $('#mass-delete-leads-quantity-block').addClass('hidden');

                        $('.orig-processed').find('.mass-delete-leads-quantity').text(0);
                        $('.end-processed').find('.mass-delete-leads-quantity').text(0);

                        if ($('#delete-all-leads-matching-filter').is(':checked')) {
                            $.ajax({
                                url: $('#website_url').val() + 'plugin/leads/run/countAllLeads/',
                                type: 'POST',
                                dataType: 'json',
                                data: {'secureToken': $('#lead-grid-token').val(), 'filters': $.param(filters)}
                            }).done(function (response) {
                                if (response.error == '1') {
                                    showMessage(_.isUndefined(i18n['No leads found']) ? 'No leads found' : i18n['No leads found'], true, 5000);
                                } else {
                                    var countSelectedLeadsQuantity = response.responseText.quantity;

                                    recordsText = _.isUndefined(i18n['records']) ? 'records' : i18n['records'];

                                    if(countSelectedLeadsQuantity == 1) {
                                        recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                        deleteLeadsText = _.isUndefined(i18n['Delete lead']) ? 'Delete lead' : i18n['Delete lead'];
                                    } else {
                                        recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];
                                        deleteLeadsText = _.isUndefined(i18n['Delete leads']) ? 'Delete leads' : i18n['Delete leads'];
                                    }

                                    title = deleteLeadsText + ' (' + totalText + ' ' + countSelectedLeadsQuantity + ' ' + recordsText + ')';

                                    $('.cl-none').text(deleteLeadsText);
                                    $('.delete-leads-dialog').dialog('option', 'title', title);
                                    $('#delete-leads-dialog').data('count-selected-leads', countSelectedLeadsQuantity);
                                }
                            });
                        } else {
                            if(countSelectedLeads == 1) {
                                recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                deleteLeadsText = _.isUndefined(i18n['Delete lead']) ? 'Delete lead' : i18n['Delete lead'];
                            } else {
                                recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];
                                deleteLeadsText = _.isUndefined(i18n['Delete leads']) ? 'Delete leads' : i18n['Delete leads'];
                            }

                            title = deleteLeadsText + ' (' + totalText + ' ' + countSelectedLeads + ' ' + recordsText + ')';
                            $('.cl-none').text(deleteLeadsText);
                            $('.delete-leads-dialog').dialog('option', 'title', title);
                            $('#delete-leads-dialog').data('count-selected-leads', countSelectedLeads);
                        }
                    });

                    if(countSelectedLeads == 1) {
                        recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                        deleteLeadsText = _.isUndefined(i18n['Delete lead']) ? 'Delete lead' : i18n['Delete lead'];
                    }

                    title = deleteLeadsText + ' (' + totalText + ' ' + countSelectedLeads + ' ' + recordsText + ')';
                    $('.cl-none').text(deleteLeadsText);
                    $('.delete-leads-dialog').dialog('option', 'title', title);

                },
                close: function (event, ui) {
                    $(this).dialog('close').remove();
                }
            });
        },
        deleteLeadsAndMarkAsSpamAction: function(e){
            var leadIds = this.checkedLeadRows.join(','),
                countSelectedLeads = this.checkedLeadRows.length,
                filters = this.leads.server_api.filter(),
                filterUsed = this.leads.filterUsed,
                self = this;

            var dialog = _.template(massDeleteAndMarkAsSpamDialog, {
                leadIds: leadIds,
                filters : $.param(filters),
                filterUsed : filterUsed,
                countSelectedLeads: countSelectedLeads,
                i18n:i18n
            });

            $(dialog).dialog({
                dialogClass: 'seotoaster',
                width: '25%',
                height: '175',
                resizable: false,
                draggable: false,
                open: function (event, ui) {
                    var deleteLeadsText = _.isUndefined(i18n['Delete and Mark Leads as Spam']) ? 'Delete and Mark Leads as Spam' : i18n['Delete and Mark Leads as Spam'],
                        totalText = _.isUndefined(i18n['Total']) ? 'Total' : i18n['Total'],
                        recordsText = _.isUndefined(i18n['records']) ? 'records' : i18n['records'],
                        title = '';

                    $('#delete-leads-form').on('submit', function(e){
                        e.preventDefault();

                        $('.orig-processed').find('.mass-delete-leads-quantity').text(0);
                        $('.end-processed').find('.mass-delete-leads-quantity').text(0);

                        var matchingFilter = 0;

                        if ($('#delete-all-leads-matching-filter').is(':checked')) {
                            matchingFilter = 1;
                        }

                        if (matchingFilter === 1) {
                            $.ajax({
                                url: $('#website_url').val() + 'plugin/leads/run/countAllLeads/',
                                type: 'POST',
                                dataType: 'json',
                                data: {
                                    'secureToken': $('#lead-grid-token').val(),
                                    'filters': $.param(filters)
                                }
                            }).done(function (response) {
                                var countSelectedLeadsResponse = response.responseText.quantity,
                                    leadsLabel = _.isUndefined(i18n['leads'])?'leads':i18n['leads'];

                                if(countSelectedLeadsResponse == 1) {
                                    leadsLabel = _.isUndefined(i18n['lead'])?'lead':i18n['lead'];
                                }

                                showConfirm((_.isUndefined(i18n['Are you sure want to delete and mark as spam']) ? 'Are you sure want to delete and mark as spam' : i18n['Are you sure want to delete and mark as spam']) + ' ' + countSelectedLeadsResponse + ' ' + leadsLabel + '?', function () {
                                    showSpinner('#mass-delete-and-mark-as-spam-block', 'mass-delete-and-mark-as-spam-stats-spinner dashboard-spinner');
                                    self.massDeleteLeadsRequest($(this).attr('action'), leadIds, filters,  matchingFilter, 0, $('#delete-leads-dialog').data('count-selected-leads'), null, '1');
                                });
                            });
                        } else {
                            var leadsLabel = _.isUndefined(i18n['leads'])?'leads':i18n['leads'];
                            if(countSelectedLeads == 1) {
                                leadsLabel = _.isUndefined(i18n['lead'])?'lead':i18n['lead'];
                            }

                            showConfirm((_.isUndefined(i18n['Are you sure want to delete and mark as spam']) ? 'Are you sure want to delete and mark as spam' : i18n['Are you sure want to delete and mark as spam']) + ' ' + countSelectedLeads + ' ' + leadsLabel + '?', function () {
                                showSpinner('#mass-delete-and-mark-as-spam-block', 'mass-delete-and-mark-as-spam-stats-spinner dashboard-spinner');
                                self.massDeleteLeadsRequest($(this).attr('action'), leadIds, filters,  matchingFilter, 0, $('#delete-leads-dialog').data('count-selected-leads'), null, '1');
                            });
                        }

                    });

                    $('.allLeads').on('change', function (e) {
                        e.preventDefault();

                        $('#mass-delete-leads-quantity-block').addClass('hidden');

                        $('.orig-processed').find('.mass-delete-leads-quantity').text(0);
                        $('.end-processed').find('.mass-delete-leads-quantity').text(0);

                        if ($('#delete-all-leads-matching-filter').is(':checked')) {
                            $.ajax({
                                url: $('#website_url').val() + 'plugin/leads/run/countAllLeads/',
                                type: 'POST',
                                dataType: 'json',
                                data: {'secureToken': $('#lead-grid-token').val(), 'filters': $.param(filters)}
                            }).done(function (response) {
                                if (response.error == '1') {
                                    showMessage(_.isUndefined(i18n['No leads found']) ? 'No leads found' : i18n['No leads found'], true, 5000);
                                } else {
                                    var countSelectedLeadsQuantity = response.responseText.quantity;

                                    recordsText = _.isUndefined(i18n['records']) ? 'records' : i18n['records'];

                                    if(countSelectedLeadsQuantity == 1) {
                                        recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                        deleteLeadsText = _.isUndefined(i18n['Delete and Mark Lead as Spam']) ? 'Delete and Mark Lead as Spam' : i18n['Delete and Mark Lead as Spam'];
                                    } else {
                                        recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];
                                        deleteLeadsText = _.isUndefined(i18n['Delete and Mark Leads as Spam']) ? 'Delete and Mark Leads as Spam' : i18n['Delete and Mark Leads as Spam'];
                                    }

                                    title = deleteLeadsText + ' (' + totalText + ' ' + countSelectedLeadsQuantity + ' ' + recordsText + ')';
                                    $('.cl-none').text(deleteLeadsText);
                                    $('.delete-leads-dialog').dialog('option', 'title', title);
                                    $('#delete-leads-dialog').data('count-selected-leads', countSelectedLeadsQuantity);
                                }
                            });
                        } else {
                            if(countSelectedLeads == 1) {
                                recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                deleteLeadsText = _.isUndefined(i18n['Delete and Mark Lead as Spam']) ? 'Delete and Mark Lead as Spam' : i18n['Delete and Mark Lead as Spam'];
                            } else {
                                recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];
                                deleteLeadsText = _.isUndefined(i18n['Delete and Mark Leads as Spam']) ? 'Delete and Mark Leads as Spam' : i18n['Delete and Mark Leads as Spam'];
                            }

                            title = deleteLeadsText + ' (' + totalText + ' ' + countSelectedLeads + ' ' + recordsText + ')';
                            $('.cl-none').text(deleteLeadsText);
                            $('.delete-leads-dialog').dialog('option', 'title', title);
                            $('#delete-leads-dialog').data('count-selected-leads', countSelectedLeads);
                        }
                    });

                    if(countSelectedLeads == 1) {
                        recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                        deleteLeadsText = _.isUndefined(i18n['Delete and Mark Lead as Spam']) ? 'Delete and Mark Lead as Spam' : i18n['Delete and Mark Lead as Spam'];
                    }

                    title = deleteLeadsText + ' (' + totalText + ' ' + countSelectedLeads + ' ' + recordsText + ')';
                    $('.delete-leads-dialog').dialog('option', 'title', title);
                    $('.cl-none').text(deleteLeadsText);

                },
                close: function (event, ui) {
                    $(this).dialog('close').remove();
                }
            });
        },
        deleteBouncedAction: function(e){
            var checkedLeads = this.checkedLeadRows.join(','),
                leadIds = checkedLeads,
                countSelectedLeads = this.checkedLeadRows.length,
                filters = this.leads.server_api.filter(),
                self = this;

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/countAllLeads/',
                type: 'POST',
                dataType: 'json',
                data:{'secureToken':$('#lead-grid-token').val(), 'filters':$.param(filters), 'leadIds':leadIds, 'emailStatus': 'bounce', 'ignoreIds':'1'}
            }).done(function(response){
                if (response.error == '1') {
                    showMessage(_.isUndefined(i18n['No leads have been found with bounced email address'])?'No leads have been found with bounced email address':i18n['No leads have been found with bounced email address'], true, 5000);
                } else {
                    var dialog = _.template(massDeleteBouncedDialog, {
                        leadIds: leadIds,
                        filters : $.param(filters),
                        countSelectedLeads: response.responseText.quantity,
                        i18n:i18n
                    });

                    $(dialog).dialog({
                        dialogClass: 'seotoaster',
                        width: '25%',
                        height: '160',
                        resizable: false,
                        draggable: false,
                        open: function (event, ui) {
                            $('#delete-leads-form').on('submit', function(e){
                                e.preventDefault();
                                $('.orig-processed').find('.mass-delete-leads-quantity').text(0);
                                $('.end-processed').find('.mass-delete-leads-quantity').text(0);

                                var matchingFilter = 0;
                                if ($('#delete-all-bounce-matching-filter').is(':checked')) {
                                    matchingFilter = 1;
                                    filters.email_status = 'bounce';
                                }

                                self.massDeleteLeadsRequest($(this).attr('action'), leadIds, filters,  matchingFilter, 0, $('#delete-leads-dialog').data('count-selected-leads'));
                            });

                            $('.allLeads').on('change', function (e) {
                                e.preventDefault();

                                var deleteLeadsText = _.isUndefined(i18n['Delete leads with bounced emails']) ? 'Delete leads with bounced emails' : i18n['Delete leads with bounced emails'],
                                    totalText = _.isUndefined(i18n['Total']) ? 'Total' : i18n['Total'],
                                    recordsText = _.isUndefined(i18n['records']) ? 'records' : i18n['records'],
                                    title = '';

                                $('#mass-delete-leads-quantity-block').addClass('hidden');

                                $('.orig-processed').find('.mass-delete-leads-quantity').text(0);
                                $('.end-processed').find('.mass-delete-leads-quantity').text(0);

                                if ($('#delete-all-bounce-matching-filter').is(':checked')) {
                                    $.ajax({
                                        url: $('#website_url').val() + 'plugin/leads/run/countAllLeads/',
                                        type: 'POST',
                                        dataType: 'json',
                                        data: {'secureToken': $('#lead-grid-token').val(),
                                            'filters': $.param(filters),
                                            'emailStatus': 'bounce'
                                        }
                                    }).done(function (response) {
                                        if (response.error == '1') {
                                            showMessage(_.isUndefined(i18n['No leads found']) ? 'No leads found' : i18n['No leads found'], true, 5000);
                                        } else {
                                            var countSelectedLeadsQuantity = response.responseText.quantity;

                                            if(countSelectedLeadsQuantity == 1) {
                                                recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                            }

                                            title = deleteLeadsText + ' (' + totalText + ' ' + countSelectedLeadsQuantity + ' ' + recordsText + ')';

                                            $('.delete-leads-dialog').dialog('option', 'title', title);
                                            $('#delete-leads-dialog').data('count-selected-leads', countSelectedLeadsQuantity);
                                        }
                                    });
                                } else {
                                    title = deleteLeadsText + ' (' + totalText + ' ' + countSelectedLeads + ' ' + recordsText + ')';
                                    $('.delete-leads-dialog').dialog('option', 'title', title);
                                }
                            });
                        },
                        close: function (event, ui) {
                            $(this).dialog('close').remove();
                        }
                    });

                }
            });
        },
        validateEmailsAction: function(e){
            var leadIds = this.checkedLeadRows.join(','),
                countSelectedLeads = this.checkedLeadRows.length,
                filters = this.leads.server_api.filter(),
                self = this;

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/countAllLeads/',
                type: 'POST',
                dataType: 'json',
                data:{'secureToken':$('#lead-grid-token').val(), 'filters':$.param(filters), 'leadIds' : leadIds, 'uniqueEmail': '1', 'validateEmailBalance':1}
            }).done(function(response) {
                if (response.error == '1') {
                    showMessage(_.isUndefined(i18n['No leads have been found with email address']) ? 'No leads have been found with email address' : i18n['No leads have been found with email address'], true, 5000);
                } else {

                    countSelectedLeads = response.responseText.quantity;

                    var dialog = _.template(validateEmailsDialog, {
                        leadIds: leadIds,
                        filters: $.param(filters),
                        countSelectedLeads: countSelectedLeads,
                        emailValidateBalance: response.responseText.emailValidateBalance,
                        emailBalanceLink: response.responseText.emailBalanceLink,
                        i18n: i18n
                    });

                    $(dialog).dialog({
                        dialogClass: 'seotoaster',
                        width: '30%',
                        minHeight: '200',
                        resizable: false,
                        draggable: false,
                        open: function (event, ui) {
                            var deleteLeadsText = _.isUndefined(i18n['Validate lead emails']) ? 'Validate lead emails' : i18n['Validate lead emails'],
                                totalText = _.isUndefined(i18n['Total']) ? 'Total' : i18n['Total'],
                                recordsText = _.isUndefined(i18n['records']) ? 'records' : i18n['records'],
                                title = '';

                            if(countSelectedLeads == 1) {
                                recordsText = _.isUndefined(i18n['record']) ? 'record' : i18n['record'];
                            }

                            title = deleteLeadsText + ' (' + totalText + ' ' + countSelectedLeads + ' ' + recordsText + ')';
                            $('.validate-emails-dialog').dialog('option', 'title', title);

                            $('#validate-emails-form').on('submit', function (e) {
                                e.preventDefault();
                                $('#validate-email-leads-quantity').text(0);

                                var matchingFilter = 0;

                                if ($('#validate-all-leads-matching-filter').is(':checked')) {
                                    matchingFilter = 1;
                                }

                                $('#send-to-validate-service').prop('disabled', true);

                                let countSelectedLeads = $('#validate-emails-dialog').data('count-selected-leads');

                                if (countSelectedLeads >= 100) {
                                    let requestAction = $(this).attr('action');
                                    showConfirm(_.isUndefined(i18n['Your job will run in the background.'])?'Your job will run in the background.':i18n['Your job will run in the background.'], function(){
                                        self.sendToValidateEmailService(requestAction, leadIds, filters, matchingFilter, 0, $('#validate-emails-dialog').data('count-selected-leads'));
                                    }, function () {
                                        $('#send-to-validate-service').prop('disabled', false);
                                    });
                                } else {
                                    self.sendToValidateEmailService($(this).attr('action'), leadIds, filters, matchingFilter, 0, $('#validate-emails-dialog').data('count-selected-leads'));
                                }
                            });

                            $('.allLeads').on('change', function (e) {
                                e.preventDefault();

                                $('#validate-email-leads-quantity-block').addClass('hidden');
                                $('#validate-email-leads-quantity').text(0);

                                if ($('#validate-all-leads-matching-filter').is(':checked')) {
                                    $.ajax({
                                        url: $('#website_url').val() + 'plugin/leads/run/countAllLeads/',
                                        type: 'POST',
                                        dataType: 'json',
                                        data: {
                                            'secureToken': $('#lead-grid-token').val(),
                                            'filters': $.param(filters),
                                            'uniqueEmail': '1'
                                        }
                                    }).done(function (response) {
                                        if (response.error == '1') {
                                            showMessage(_.isUndefined(i18n['No leads found']) ? 'No leads found' : i18n['No leads found'], true, 5000);
                                        } else {
                                            var countSelectedLeadsQuantity = response.responseText.quantity;

                                            recordsText = _.isUndefined(i18n['records']) ? 'records' : i18n['records'];

                                            if(countSelectedLeadsQuantity == 1) {
                                                recordsText = _.isUndefined(i18n['record']) ? 'record' : i18n['record'];
                                            }
                                                title = deleteLeadsText + ' (' + totalText + ' ' + countSelectedLeadsQuantity + ' ' + recordsText + ')';

                                            $('.validate-emails-dialog').dialog('option', 'title', title);
                                            $('#validate-emails-dialog').data('count-selected-leads', countSelectedLeadsQuantity);
                                        }
                                    });
                                } else {
                                    recordsText = _.isUndefined(i18n['records']) ? 'records' : i18n['records'];

                                    if(countSelectedLeads == 1) {
                                        recordsText = _.isUndefined(i18n['record']) ? 'record' : i18n['record'];
                                    }

                                    title = deleteLeadsText + ' (' + totalText + ' ' + countSelectedLeads + ' ' + recordsText + ')';
                                    $('.validate-emails-dialog').dialog('option', 'title', title);
                                    $('#validate-emails-dialog').data('count-selected-leads', countSelectedLeads);
                                }
                            });
                        },
                        close: function (event, ui) {
                            $(this).dialog('close').remove();
                        }
                    });
                }
            });

        },
        sendToValidateEmailService: function(action, checkedLeads, filters, matchingFilter, stepSendEmailService, countSelectedLeads){
            var self = this,
                validateEmailLeadsEl = $('#validate-email-leads-quantity'),
                importedElBlock = $('#validate-email-leads-quantity-block'),
                balanceEl = $('#email-validate-balance');
            $.ajax({
                url: action,
                type: 'POST',
                dataType: 'json',
                'data' : {'secureToken': $('#lead-grid-token').val(), leadIds:checkedLeads, 'filters' : $.param(filters), 'matchingFilter': matchingFilter, 'stepSendEmailService' : stepSendEmailService, 'filterQuantity': $('#validate-emails-dialog').data('count-selected-leads')}
            }).done(function(response) {
                var validateEmailsFarLabel = _.isUndefined(i18n['emails processed so far']) ? 'emails processed so far':i18n['emails processed so far'];

                if(countSelectedLeads == 1) {
                    validateEmailsFarLabel = _.isUndefined(i18n['email processed so far']) ? 'email processed so far':i18n['email processed so far']
                }

                $('.validate-emails-far-label').text(validateEmailsFarLabel);

                importedElBlock.removeClass('hidden');
                if(response.error == 0){
                    var invalidLeads = [];
                    self.sendToValidateEmailService(action, checkedLeads, filters, matchingFilter, stepSendEmailService + 1, countSelectedLeads);
                } else {
                    if(typeof response.responseText.errorFileName !== 'undefined') {
                        var errorMessage = response.responseText.message,
                            downloadErrFileLink = '<a class="btn error fl-right grid_12" href="'+$('#website_url').val()+'plugin/leads/run/downloadFile/?fileName='+response.responseText.errorFileName+'" >'+(_.isUndefined(i18n['Download error log'])?'Download error log':i18n['Download error log'])+'</a>'+ '';

                        showMessage(errorMessage, true, 5000);
                        $('#leads-error-btn').empty().show().append(downloadErrFileLink);
                    } else {
                        showMessage(response.responseText.message, false, 5000);
                    }

                    $('#send-to-validate-service').prop('disabled', false);
                }
                validateEmailLeadsEl.text(parseInt(validateEmailLeadsEl.text()) + parseInt(response.responseText.quantity));
                if (typeof response.responseText.pointsBalance !== 'undefined') {
                    balanceEl.text(parseInt(response.responseText.pointsBalance));
                }
            }).fail(function(response){
                showMessage(response.responseJSON.responseText, true, 5000);
                $('#send-to-validate-service').prop('disabled', false);
            });
        },
        massDeleteLeadsRequest: function(action, checkedLeads, filters, matchingFilter, step, countSelectedLeads, filterQuantity = null, markAsSpam = 0){
            var self = this,
                origProcessedDeletedEl = $('.orig-processed').find('.mass-delete-leads-quantity'),
                endProcessedDeletedEl = $('.end-processed').find('.mass-delete-leads-quantity'),
                deletedElBlock = $('#mass-delete-leads-quantity-block');
                filterQuantity = filterQuantity === null ? $('#delete-leads-dialog').data('count-selected-leads'):filterQuantity;
            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/deleteMassLeads/',
                type: 'POST',
                dataType: 'json',
                'data' : {'secureToken': $('#lead-grid-token').val(), leadIds:checkedLeads, 'step':step, 'filters' : $.param(filters), 'matchingFilter': matchingFilter, 'filterQuantity': filterQuantity, 'markAsSpam':markAsSpam}
            }).done(function(response) {
                if(countSelectedLeads == 1) {
                    $('.deleted-leads-orig-processed').text((_.isUndefined(i18n['lead processed so far']) ? 'lead processed so far':i18n['lead processed so far']));
                    if (markAsSpam === 0) {
                        $('.deleted-leads-end-processed').text((_.isUndefined(i18n['lead has been deleted']) ? 'lead has been deleted' : i18n['lead has been deleted']));
                    } else {
                        $('.deleted-leads-end-processed').text((_.isUndefined(i18n['lead has been marked as spam and deleted']) ? 'lead has been marked as spam and deleted' : i18n['lead has been marked as spam and deleted']));
                    }
                }
                hideSpinner('.mass-delete-and-mark-as-spam-stats-spinner');

                deletedElBlock.removeClass('hidden');
                if (response.error == 0) {
                    if (filterQuantity === null) {
                        self.massDeleteLeadsRequest(action, checkedLeads, filters, matchingFilter, step + 1, countSelectedLeads, filterQuantity, markAsSpam);
                    } else {
                        self.massDeleteLeadsRequest(action, checkedLeads, filters, matchingFilter, step + 1, countSelectedLeads, filterQuantity, markAsSpam);
                    }
                } else {
                    if(typeof response.responseText.errorFileName !== 'undefined') {
                        var errorMessage = response.responseText.message;
                        showMessage(errorMessage, true, 5000);
                    } else {
                        $('.orig-processed').addClass('hidden');
                        $('.end-processed').removeClass('hidden');
                        $('.matching-filter').hide();
                        $('.cl-none').hide();
                        window.appLeadRouter.LeadMainView.applyFilter();
                    }
                }
                origProcessedDeletedEl.text(parseInt(origProcessedDeletedEl.text()) + parseInt(response.responseText.quantity));
                endProcessedDeletedEl.text(parseInt(endProcessedDeletedEl.text()) + parseInt(response.responseText.quantity));
            }).fail(function(response){
                showMessage(response.responseJSON.responseText, true, 5000);
            });
        },
        specialPageNavigator: function(pageNumber){
            var page = pageNumber;
            if ($.isNumeric(page)){
                this.leads.goTo(page);
            }
        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.leads.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.leads.goTo(this.leads.firstPage);
                        break;
                    case 'last':
                        this.leads.goTo(this.leads.information.lastPage);
                        break;
                    case 'prev':
                        this.leads.requestPreviousPage();
                        break;
                    case 'next':
                        this.leads.requestNextPage();
                        break;
                }
            }
        },
        displayEmailTab: function(e)
        {
            e.preventDefault();

            var leadId = $(e.currentTarget).data('cid'),
                params = {};
            if (!leadId) {
                return false;
            }

            params.openTabName = 'email';
            window.appLeadRouter.leadDetails(leadId, params);

        }
    });

    return LeadsGridView;
});
