define([
    'backbone',
    './organization-grid',
    'moment',
    'text!../templates/filter-lead-organization-custom-params-field-row.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone, OrganizationGridView, moment, LeadOrganizationCustomParamFieldRowTmpl, i18n
){
    var OrganizationsGridView = Backbone.View.extend({
        el: $('#lead-organization-block'),
        events: {
            'click .switch-lead-organization-creation': 'toggleOrganizationCreation',
            'click #lead-organization-filters-switch': 'toggleLeadOrganizationAdditionalFilters',
            'click #lead-organization-filter-apply': 'applyFilter',
            'click #lead-organization-filter-reset': 'resetFilter',
            'click #lead-organization-filter-reset-top': 'resetFilter',
            'click #recently-viewed-switcher': 'showHideRecentlyViewed',
            'click #go-to-lead-organization-profile, a[data-role=lead-organization-detailed-view]': 'showLeadDetailsScreen',
            'submit #lead-organization-filters-form':'applyFilter',
            'change .rangeCreationOptions': 'changePeriod',
            'change #search-includes-notes' : 'focusOrganizationFilterBy',
            'change #search-includes-custom-organization-fields' : 'focusOrganizationFilterBy',
            'click #lead-organization-filter-by-special-type-existing-client, #lead-organization-filter-by-special-type-prospect' : 'displaySpentPurchase',
            'click #add-organization-custom-attribute': 'addOrganizationCustomField',
            'change #organization-custom-attribute-selection': 'selectOrganizationCustomAttribute',
            'click .custom-field-row-delete': 'deleteCustomFieldSearchRow',
            'change select#lead-organization-filter-by-last-interaction': 'lastInteractionInboundEmailFilter',
            'click .clear-input': 'clearInput',
        },
        templates: {},
        initialize: function(options){

        },
        render: function(){

        },
        changePeriod: function(e){
            var el = $(e.currentTarget),
                currentBlock = el.closest('.creation-option-date');

            this.setDateRange(el.val(), currentBlock);
        },
        setDateRange: function(switchValue, currentBlock) {
            var startDate = $('[name="lead-organization-filter-from-date"]', currentBlock),
                endDate = $('[name="lead-organization-filter-to-date"]', currentBlock),
                date = moment($('#user-time').val());

            switch (switchValue) {
                case "1":
                    startDate.datepicker('setDate', date.startOf('day').toDate());
                    endDate.datepicker('setDate', date.endOf('day').toDate());
                    break;
                case "2":
                    startDate.datepicker('setDate', date.subtract(1, 'days').startOf('day').toDate());
                    endDate.datepicker('setDate', date.endOf('day').toDate());
                    break;
                case "3":
                    startDate.datepicker('setDate', date.subtract(7, 'days').startOf('week').toDate());
                    endDate.datepicker('setDate', date.endOf('week').toDate());
                    break;
                case "4":
                    startDate.datepicker('setDate', date.endOf('month').subtract(date.daysInMonth() + 1, 'days').startOf('month').toDate());
                    endDate.datepicker('setDate', date.endOf('month').toDate());
                    break;
                case "5":
                    endDate.datepicker('setDate', date.subtract(0, 'days').endOf('day').toDate());
                    startDate.datepicker('setDate', date.subtract(7, 'days').startOf('day').toDate());
                    break;
                case "6":
                    endDate.datepicker('setDate', date.subtract(0, 'days').endOf('day').toDate());
                    startDate.datepicker('setDate', date.subtract(30, 'days').startOf('day').toDate());
                    break;
                default:
                    startDate.datepicker('setDate', null);
                    endDate.datepicker('setDate', null);
                    break;
            }
        },
        showHideRecentlyViewed: function()
        {
            if ($('#lead-organizations-recently-viewed-block').hasClass('hidden')) {
                $('#lead-organizations-recently-viewed-block').removeClass('hidden');
                $('#lead-organization-additional-filters').addClass('hidden');
            } else {
                $('#lead-organizations-recently-viewed-block').addClass('hidden');
            }

            $('#lead-organization-filters-switch').removeClass('icon-arrow-up2').addClass('icon-arrow-down2');

            if ($('#recently-viewed-switcher').hasClass('icon-arrow-down2')) {
                $('#recently-viewed-switcher').removeClass('icon-arrow-down2').addClass('icon-arrow-up2');
            } else {
                $('#recently-viewed-switcher').removeClass('icon-arrow-up2').addClass('icon-arrow-down2');
            }
        },
        lastInteractionInboundEmailFilter: function (e) {
            e.preventDefault();

            var el = $(e.currentTarget),
                filterByLastInteractionEl = $('#lead-organization-filter-by-last-interaction').closest('div'),
                lastInteractionType = '';

            if (!_.isUndefined(el)) {
                lastInteractionType = el.find(':selected').data('type-name');
            }

            if (lastInteractionType == 'outbound_email') {
                if (filterByLastInteractionEl.hasClass('grid_12')) {
                    filterByLastInteractionEl.removeClass('grid_12').addClass('grid_6');
                }
                $('#email-sub-type-filter').removeClass('close').addClass('open').show();
            } else {
                if (filterByLastInteractionEl.hasClass('grid_6')) {
                    filterByLastInteractionEl.removeClass('grid_6').addClass('grid_12');
                }
                $('#email-sub-type-filter').removeClass('open').addClass('close').hide();
                $('#outbound-emails-sub-types').val(0);
            }
        },
        toggleOrganizationCreation: function(e){
            e.preventDefault();
            $('#lead-organization-form').slideToggle();
            if ($('.switch-lead-organization-creation').hasClass('icon-arrow-down2')) {
                $('.switch-lead-organization-creation').removeClass('icon-arrow-down2').addClass('icon-arrow-up2');
            } else {
                $('.switch-lead-organization-creation').removeClass('icon-arrow-up2').addClass('icon-arrow-down2');
            }
        },
        toggleLeadOrganizationAdditionalFilters: function(){
            if ($("#lead-organization-additional-filters").hasClass('hidden')) {
                $("#lead-organization-additional-filters").removeClass('hidden');
            } else {
                $("#lead-organization-additional-filters").addClass('hidden');
            }

            this.setDateRange($('.rangeCreationOptions').val(), $('.creation-option-date'));
            $('#lead-organizations-recently-viewed-block').addClass('hidden');

            if ($('#lead-organization-filters-switch').hasClass('icon-arrow-down2')) {
                $('#lead-organization-filters-switch').removeClass('icon-arrow-down2').addClass('icon-arrow-up2');
            } else {
                $('#lead-organization-filters-switch').removeClass('icon-arrow-up2').addClass('icon-arrow-down2');
            }

            $('#recently-viewed-switcher').removeClass('icon-arrow-up2').addClass('icon-arrow-down2');
        },
        searchByKeyword: function() {
            var searchIncludesNotesEl = $('#search-includes-notes'),
                searchIncludesCustomOrganizationFields = $('#search-includes-custom-organization-fields');

            if(searchIncludesNotesEl.is(':checked')){
                searchIncludesNotesEl.val(1);
            } else {
                searchIncludesNotesEl.val(0);
            }
            if(searchIncludesCustomOrganizationFields.is(':checked')){
                searchIncludesCustomOrganizationFields.val(1);
            } else {
                searchIncludesCustomOrganizationFields.val(0);
            }
        },
        focusOrganizationFilterBy: function() {
            $('#lead-organization-attribute').focus();
        },
        clearInput: function () {
            $('#lead-organization-filters-form').find('input#lead-organization-attribute').val('').trigger('submit');
        },
        applyFilter: function(e) {
            if(typeof e !== 'undefined'){
                e.preventDefault();
            }

            if(!$('#lead-organization-filter-by-special-type-existing-client').prop('checked')) {
                $('#lead-organization-filter-total-spent-purchase-amount-from').val('');
                $('#lead-organization-filter-total-spent-purchase-amount-to').val('');
            }

            $('#lead-organization-filter-apply').prop('disabled', true);
            $('#lead-organization-attribute').prop('disabled', true);
            this.showLoader();

            this.searchByKeyword();

            this.OrganizationGrid = window.appLeadOrganizationRouter.OrganizationGrid;
            //this.OrganizationGrid = new OrganizationGridView();
            this.OrganizationGrid.organizationsChecked = [];
            this.OrganizationGrid.organizations.currentPage = 0;
            this.OrganizationGrid.organizations.perPage = 10;
            this.OrganizationGrid.render({'resetCheckedOrganizations':'1'});
        },
        showLoader: function () {
            this.$el.find('#organization-grid-table-body').html('<tr><td class="text-center" colspan="14" style="text-align: center;"><img src="' + $('#website_url').val() + 'system/images/spinner-small.gif" border="0" alt="loading..." /></td></tr>');
        },
        resetFilter: function(e){
            e.preventDefault();
            var $filterBlock = $('#lead-organization-additional-filters');
            $filterBlock.find('input:text').val('').end()
                .find('select.filter').val('0').trigger('chosen:updated');
            $('#switch-created-date').prop('checked', true);
            $('#switch-updated-date').prop('checked', false);
            $('#range-creation-option').val(0);
            $('#lead-organization-attribute').val('');
            $('#search-includes-notes').prop('checked', false);
            $('#search-includes-custom-organization-fields').prop('checked', false);
            $('#lead-organization-filter-by-special-type-existing-client').prop('checked', false);
            $('#lead-organization-filter-by-special-type-prospect').prop('checked', false);
            $('#lead-organization-filter-by-special-type-no-email').prop('checked', false);
            $('#spent-purchase-block').hide();
            $('#custom-organization-attribute-field-row-block').empty();
            $('#organization-custom-attribute-selection').val(0);
            $('#lead-organization-filter-by-last-interaction').closest('div').removeClass('grid_6').addClass('grid_12');
            $('#inbound-emails-sub-types').val(0);
            $('#email-sub-type-filter').removeClass('open').hide();
            $('#lead-organization-without-leads').prop('checked', false);
            $('.clear-input').addClass('hidden');

            this.applyFilter();
        },
        displaySpentPurchase: function (e) {
            if($('#lead-organization-filter-by-special-type-existing-client').prop('checked')) {
                $('#spent-purchase-block').show();
            } else {
                $('#spent-purchase-block').hide();
            }
        },
        showLeadDetailsScreen: function(e)
        {
            var organizationId = $(e.currentTarget).data('cid');
            if (!organizationId) {
                return false;
            }
            window.appLeadOrganizationRouter.leadOrganizationDetails(organizationId);
        },
        addOrganizationCustomField: function()
        {
            var fieldName = $('#organization-custom-attribute-selection').val(),
                fieldLabel = $('#organization-custom-attribute-selection').find(':selected').data('field-label'),
                fieldType = $('#organization-custom-attribute-selection').find(':selected').data('field-type'),
                paramId = $('#organization-custom-attribute-selection').find(':selected').data('field-id'),
                fieldKey = fieldType + '-' + fieldName.replace(/\s/g, ''),
                blockFields = false,
                customComparisonOperators = [],
                specialElType = [],
                flagMultiSelect = false,
                placeholder = '',
                yearsList = this.generateCustomParamsYears();

            if(fieldType == 'date') {
                placeholder = 'YYYY-MM-DD';
            }

            if ($('#custom-organization-attribute-field-row-block' + '-' + fieldKey).length == '0') {
                $('#custom-organization-attribute-field-row-block').append(_.template(LeadOrganizationCustomParamFieldRowTmpl, {
                    'fieldKey': fieldKey,
                    'fieldName': fieldName,
                    'fieldLabel': fieldLabel,
                    'fieldType': fieldType,
                    'fieldSubtype': '',
                    'moment': moment,
                    'i18n': i18n,
                    'blockFields': blockFields,
                    'customComparisonOperators': customComparisonOperators,
                    'fieldValue': '',
                    'specialElType': specialElType,
                    'placeholder': placeholder,
                    'paramId':paramId,
                    'yearsList':yearsList
                }));

                if (flagMultiSelect === true) {
                    $('#custom-organization-attribute-field-row-block-' + fieldKey).find('.custom-field-row-value').chosen();
                }
            } else {
                showMessage(_.isUndefined(i18n['Field already exists']) ? 'Field already exists' : i18n['Field already exists'], true, 5000);
            }
        },
        selectOrganizationCustomAttribute: function(e)
        {
            if ($(e.currentTarget).val() != '0') {
                $('#add-organization-custom-attribute').removeClass('hidden');
            } else {
                $('#add-organization-custom-attribute').addClass('hidden');
            }
        },
        deleteCustomFieldSearchRow(e)
        {
            $(e.currentTarget).closest('.form-field-row-block').remove();
        },
        generateCustomParamsYears()
        {
            var max = parseInt(new Date().getFullYear()) +10;
            var min = max - 99;
            var years = [];
            for (var i = max; i >= min; i--) {
                years.push(i);
            }
            return years;
        }
    });

    return OrganizationsGridView;
});
