<?php

class Notifier_Models_Mappers_NotifierNewsMapper extends Application_Model_Mappers_Abstract{

    protected $_dbTable = 'Notifier_Models_Dbtables_NotifierNewsDbtable';

    protected $_model = 'Notifier_Models_Models_NotifierNewsModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data =[
            'token' => $model->getToken(),
            'news_id' => $model->getNewsId(),
            'created_at' => date(Tools_System_Tools::DATE_MYSQL)
        ];

        $notifierSubscription = $this->getByTokenAndNewsId($data['token'], $data['news_id']);
        if (!$notifierSubscription instanceof Notifier_Models_Models_NotifierNewsModel) {
            $id = $this->getDbTable()->insert($data);
            return $model->setId($id);
        }
        return $model;
    }

    public function update($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }

        $where = $this->getDbTable()->getAdapter()->quoteInto('news_id = ?', $model->getNewsId());
        $where .= ' AND '. $this->getDbTable()->getAdapter()->quoteInto('token = ?', $model->getToken());

        return $this->getDbTable()->update(['status' => '1'], $where);
    }

    public function updateStatus($id) {
        if (!empty($id)) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            return $this->getDbTable()->update(['status' => '1', 'sent_at' => date(Tools_System_Tools::DATE_MYSQL)], $where);
        }
        return false;
    }

    public function getByTokenAndNewsId($token, $newsId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('news_id = ?', $newsId);
        $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto('token = ?', $token);
        return $this->_findWhere($where);
    }

    public function getByNewsId($newsId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('news_id = ?', $newsId);
        return $this->fetchAll($where);
    }

    public function fetchWaitingWithNews() {
        $where = $this->getDbTable()->getAdapter()->quoteInto('pnn.status = ?', 0);
        $where .= ' AND news.published=1';
        $select = $this->getDbTable()->getAdapter()->select()->from(
            ['pnn' => 'plugin_notifier_news'],
            ['id' => 'pnn.id', 'newsId' => 'pnn.news_id']
        )
            ->joinLeft(
                ['pns' => 'plugin_notifier_subscriptions'],
                'pnn.token=pns.token',
                ['token' => 'token', 'endpoint' => 'pns.endpoint', 'auth' => 'pns.auth', 'p256dh' => 'pns.p256dh']
            )
            ->joinLeft(
                ['news' => 'plugin_newslog_news'],
                'pnn.news_id=news.id',
                ['metaData' => 'news.metaData']
            )
            ->where($where);

        return $this->getDbTable()->getAdapter()->fetchAll($select);
    }

    public function delete($id)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
        $deleteResult = $this->getDbTable()->delete($where);
        return $deleteResult;
    }

    public function deleteByNewsId($newsId){
        if(!empty($newsId)) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('news_id = ?', $newsId);
            return (bool) $this->getDbTable()->delete($where);
        }

        return null;
    }

}