-- version: 2.2.0

-- 29/09/2014
-- version: 2.2.1
ALTER TABLE `plugin_paypal_transactions` ADD `subscribeStatus` VARCHAR(60) DEFAULT NULL;
ALTER TABLE `plugin_paypal_transactions` ADD `subscribePeriod` INT(10) DEFAULT NULL;
ALTER TABLE `plugin_paypal_transactions` ADD `subscribePeriodType` VARCHAR(50) DEFAULT NULL;
ALTER TABLE `plugin_paypal_transactions` ADD `subscribeQuantity` INT(10) DEFAULT NULL;
ALTER TABLE `plugin_paypal_transactions` ADD `subscribeAmount` DECIMAL(10,4) DEFAULT NULL;
ALTER TABLE `plugin_paypal_transactions` ADD `subscribeDate` VARCHAR(60) DEFAULT NULL;
ALTER TABLE `plugin_paypal_transactions` ADD `subscriptionId` VARCHAR(255) DEFAULT NULL;
ALTER TABLE `plugin_paypal_transactions` ADD `subscriptionDatePayed` VARCHAR(60) DEFAULT NULL;
ALTER TABLE `plugin_paypal_transactions` ADD `subscriptionAmountPayed` VARCHAR(60) DEFAULT NULL;

-- 12/02/2015
-- version: 2.2.2
ALTER TABLE `plugin_paypal_transactions` ADD `emailSent` ENUM('0','1') DEFAULT '0';

-- 12/02/2015
-- version: 2.2.3
ALTER TABLE `plugin_paypal_transactions` ADD `customerEmailSent` ENUM('0','1') DEFAULT '0';

-- 18/12/2015
-- version: 2.2.4
ALTER TABLE `plugin_paypal_transactions`
ADD `refundTransactionId` varchar(128) COLLATE 'utf8_unicode_ci' NULL,
ADD `refundReason` varchar(255) COLLATE 'utf8_unicode_ci' NULL AFTER `refundTransactionId`;

-- 10/06/2016
-- version: 2.3.0
ALTER TABLE `plugin_paypal_transactions` ADD COLUMN `user_set_password` ENUM('0', '1') DEFAULT '0';

-- 27/03/2019
-- version: 2.3.1
CREATE TABLE IF NOT EXISTS `plugin_paypal_recurring_payments` (
`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
`user_id` INT(10) UNSIGNED NOT NULL,
`cart_id` INT(10) UNSIGNED DEFAULT NULL,
`profile_id` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
`status` VARCHAR(50) NOT NULL,
`auto_bill_out_amt` VARCHAR(25) COLLATE utf8_unicode_ci DEFAULT NULL,
`desc` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
`max_failed_payments` SMALLINT(5) DEFAULT '0',
`profile_start_date` TIMESTAMP NOT NULL,
`next_billing_date` TIMESTAMP NOT NULL,
`num_cycles_completed` INT(10) UNSIGNED DEFAULT '0',
`num_cycles_remaining` BIGINT(10) UNSIGNED DEFAULT '0',
`outstanding_balance` DECIMAL (10,2) DEFAULT '0.00',
`failed_payment_count` INT(10) UNSIGNED DEFAULT '0',
`last_payment_date` TIMESTAMP NULL,
`last_payment_amt` DECIMAL (10,2) DEFAULT '0.00',
`trial_amt_paid` DECIMAL (10,2) DEFAULT '0.00',
`regular_amt_paid` DECIMAL (10,2) DEFAULT '0.00',
`aggregate_amt` DECIMAL (10,2) DEFAULT '0.00',
`aggregate_optional_amt` DECIMAL (10,2) DEFAULT '0.00',
`final_payment_due_date` TIMESTAMP NULL,
`timestamp` TIMESTAMP NULL,
`correlation_id` VARCHAR (255) DEFAULT NULL,
`billing_period` VARCHAR (255) DEFAULT NULL,
`billing_frequency` SMALLINT(5) UNSIGNED DEFAULT '0',
`total_billing_cycles` SMALLINT(5) UNSIGNED DEFAULT '0',
`currency_code` CHAR(3) DEFAULT '',
`amt` DECIMAL (10,2) DEFAULT '0.00',
`shipping_amt` DECIMAL (10,2) DEFAULT '0.00',
`tax_amt` DECIMAL (10,2) DEFAULT '0.00',
`regular_billing_period` VARCHAR (255) DEFAULT NULL,
`regular_billing_frequency` SMALLINT(5) UNSIGNED DEFAULT '0',
`regular_total_billing_cycles` SMALLINT(5) UNSIGNED DEFAULT '0',
`regular_currency_code` CHAR(3) DEFAULT '',
`regular_amt` DECIMAL (10,2) DEFAULT '0.00',
`regular_shipping_amt` DECIMAL (10,2) DEFAULT '0.00',
`regular_tax_amt` DECIMAL (10,2) DEFAULT '0.00',
`acct` INT(10) UNSIGNED DEFAULT '0',
`credit_card_type` VARCHAR(255) DEFAULT NULL,
`exp_date` CHAR(6) NOT NULL,
`email` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
`street` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
`city` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
`state` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
`zip` VARCHAR (10) COLLATE utf8_unicode_ci DEFAULT NULL,
`country_code` CHAR (2) DEFAULT NULL,
`country` VARCHAR(255) DEFAULT NULL,
`address_owner` VARCHAR(255) DEFAULT NULL,
`address_status` VARCHAR(255) DEFAULT NULL,
`payer_status` VARCHAR(255) DEFAULT NULL,
PRIMARY KEY (`id`)
) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_unicode_ci;

-- 10/01/2020
-- version: 2.3.2
INSERT IGNORE INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES
('1', 'paypal_recurringpayment', 'Tools_PaypalMailWatchdog'),
('1', 'paypal_recurringcanceled', 'Tools_PaypalMailWatchdog'),
('1', 'paypal_recurringsuspended', 'Tools_PaypalMailWatchdog'),
('1', 'paypal_recurringreactivated', 'Tools_PaypalMailWatchdog'),
('1', 'paypal_recurringfailed', 'Tools_PaypalMailWatchdog');

-- 04/09/2020
-- version: 2.3.3
ALTER TABLE `plugin_paypal_transactions` ADD `partiallyPaid` DECIMAL(10,4) DEFAULT NULL;

-- These alters are always the latest and updated version of the database
UPDATE `plugin` SET `version`='2.3.4' WHERE `name`='paypal';
SELECT version FROM `plugin` WHERE `name` = 'paypal';

