<?php

class Api_Emailtrigger_Emailtriggermms extends Api_Service_Abstract
{


    const MMS_MAX_SIZE = 5;

    /**
     * System response helper
     *
     * @var null
     */
    protected $_responseHelper = null;


    /**
     * @var array Access Control List
     */
    protected $_accessList = array(
        Tools_Security_Acl::ROLE_SUPERADMIN => array(
            'allow' => array('get', 'post', 'put', 'delete')
        ),
        Tools_Security_Acl::ROLE_ADMIN => array(
            'allow' => array('get', 'post', 'put', 'delete')
        ),
        Shopping::ROLE_SALESPERSON => array(
            'allow' => array('get', 'post', 'put', 'delete')
        )
    );

    public function init()
    {
        parent::init();
        $this->_responseHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('response');
    }

    public function getAction()
    {
        $leadId = filter_var($this->_request->getParam('lead_id'), FILTER_SANITIZE_NUMBER_INT);
        $limit = filter_var($this->_request->getParam('limit'), FILTER_SANITIZE_NUMBER_INT);
        $sortOrder = filter_var($this->_request->getParam('order', 'pldoc.id'), FILTER_SANITIZE_STRING);
        $offset = filter_var($this->_request->getParam('offset'), FILTER_SANITIZE_NUMBER_INT);

        if(!empty($leadId)) {
            $leadsDocumentsMapper = Leads_Mapper_LeadsDocumentsMapper::getInstance();

            $where = $leadsDocumentsMapper->getDbTable()->getAdapter()->quoteInto('pldoc.lead_id = ?', $leadId);
            $documentsData = $leadsDocumentsMapper->fetchAllData($where, $sortOrder, $limit, $offset);

            return $documentsData;
        }
    }

    public function postAction()
    {
        $data = filter_var_array($this->getRequest()->getPost(), FILTER_SANITIZE_STRING);
        if (empty($data)) {
            $this->_error();
        }

        if(!Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT)) {
            $this->_error();
        }

        $tokenToValidate = $this->_request->getParam(Tools_System_Tools::CSRF_SECURE_TOKEN, false);
        $valid = Tools_System_Tools::validateToken($tokenToValidate,
            Emailsequence::EMAIL_SEQUENCE_SECURE_TOKEN);
        $translator = Zend_Registry::get('Zend_Translate');
        if (!$valid) {
            $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
            $websiteUrl = $websiteHelper->getUrl();
            $this->_error($translator->translate('Your session has timed-out. Please Log back in '.'<a href="'.$websiteUrl.'go">here</a>'));
        }

        $uploader = new Zend_File_Transfer_Adapter_Http();
        $uploader->clearValidators();
        $uploader->clearFilters();
        $fileInfo = $uploader->getFileInfo();
        if(!empty($fileInfo)) {
            $file = reset($fileInfo);

            if(!empty($file)) {
                $fileSize = round($file['size']/1024/1024,2);
                $generalFileSize = $data['generalFileSize'] + $fileSize;

                if($generalFileSize > self::MMS_MAX_SIZE) {
                    return array('error' => 1, 'type' => 'mmsMaxSize', 'message' => $translator->translate(Emailsequence::TRANSLATION_PREFIX.'Exaggerated maximum file size 5MB! Your uploaded file with size'). ' ' . $fileSize.'MB ' . $translator->translate(Emailsequence::TRANSLATION_PREFIX.'Please convert your file to a small size or upload another.'));
                }

                $storedData = Tools_LeadSmsTools::generateStoredMmsName($file);

                $savePath = Tools_EmailSequenceTools::getFilePath($storedData['fileStoredName'], 'temporary-mms-media');

                if(empty($savePath)) {
                    return array('error' => 1, 'message' => $translator->translate(Emailsequence::TRANSLATION_PREFIX.'Unknown path to save the file or can not create a directory.'));
                }

                $uploader->addFilter('Rename', array(
                    'target' => $savePath,
                    'overwrite' => true
                ));

                $acceptedFileTypes = Tools_EmailSequenceTools::$_acceptedFileTypesMms;
                $acceptedMimeTypes = Tools_EmailSequenceTools::$_acceptedFilesMimeTypesMms;

                //Adding file extension validation
                $uploader->addValidator('Extension', false, $acceptedFileTypes);
                //Adding mime types validation
                $uploader->addValidator('MimeType', true, $acceptedMimeTypes);

                if ($uploader->isUploaded() && $uploader->isValid()) {
                    try {
                        $uploader->receive();

                        return array('error' => 0, 'fileSizeMb' => $fileSize, 'generalFileSize' => $generalFileSize, 'fileStoredName' => $storedData['fileStoredName'], 'fileNameOriginal' => $file['name'], 'message' => $translator->translate(Emailsequence::TRANSLATION_PREFIX.'File uploaded'));

                    } catch (Exceptions_SeotoasterException $e) {
                        $this->_error($e->getMessage());
                    }
                } else {
                    $uploaderErrorMsg =  $uploader->getMessages();
                    return array('error' => 1, 'message' => $uploaderErrorMsg, 'fileName' => $file['name']);
                }
            }
        }
        return array('error' => 1, 'message' => $translator->translate(Emailsequence::TRANSLATION_PREFIX.'File not attached'));
    }

    public function putAction()
    {

    }

    public function deleteAction()
    {
        $fileName = filter_var($this->_request->getParam('fileName'), FILTER_SANITIZE_STRING);
        $fileSize = filter_var($this->_request->getParam('fileSize'), FILTER_SANITIZE_STRING);
        $generalFileSize = $this->_request->getParam('generalFileSize');
        $translator = Zend_Registry::get('Zend_Translate');

        if (empty($fileName)) {
            $this->_error();
        }

        if(!Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT)) {
            $this->_error();
        }

        $mmsDirectoryPath = Tools_EmailSequenceTools::getMmsDirectoryPath('temporary-mms-media');

        if(!empty($mmsDirectoryPath)) {
            $mmsFilePath = $mmsDirectoryPath . DIRECTORY_SEPARATOR . $fileName;

            if (file_exists($mmsFilePath)) {
                if(!empty($fileSize)) {
                    $fileSize = round($fileSize/1024/1024,2);
                    $generalFileSize -= $fileSize;
                }

                if (!Tools_Filesystem_Tools::deleteFile($mmsFilePath)) {
                    return array('error' => 1, 'message' => $translator->translate(Emailsequence::TRANSLATION_PREFIX.'Can not delete file!'));
                }

                return array('error' => 0, 'deletedFile' => $fileName, 'generalFileSize' => $generalFileSize, 'message' => $translator->translate(Emailsequence::TRANSLATION_PREFIX.'Deleted'));
            }
        }

        return array('error' => 1, 'message' => $translator->translate(Emailsequence::TRANSLATION_PREFIX.'Can not delete file!'));
    }

}
