import {mapGetters} from 'vuex';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
export default {
    data () {
        return {
            loadedForm: false,
            loadedGrid: false,
            websiteUrl: $('#website_url').val(),
            selectedUser: '0',
            ipAddresses:'',
            localeMapping: localeMapping,
            locale: $('#system-language-api-config').val()
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        configDataInfo: function() {
            return this.$store.getters.getConfigDataInfo;
        },
        usersList: function() {
            return this.$store.getters.getUsersList;
        }
    },
    methods: {
        async deleteConfigItem(id){
            showConfirm(this.$t('message.areYouShure'), async () => {
                const result = await this.$store.dispatch('deleteConfigRecord', {'id': id});
                if (result.status === 'error') {
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    showMessage(result.message, false, 2000);
                    const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                    if(result.status === 'error') {

                    } else {
                        this.loadedGrid = true;
                    }
                }
            });
        },
        async removeAllTokens(id) {
            showConfirm(this.$t('message.wantToRemoveActoveTokens'), async () => {
                const result = await this.$store.dispatch('deleteAllActiveTokens', {'id': id});
                if (result.status === 'error') {
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    showMessage(result.message, false, 2000);
                    const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                    if(result.status === 'error') {

                    } else {
                        this.loadedGrid = true;
                    }
                }
            });
        },
        async createNewAccess(e){

            if (this.selectedUser == '0') {
                showMessage(this.$t('message.specifyUserName'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('saveConfigData', {'userId': this.selectedUser, 'ipAddresses': this.ipAddresses});


            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                showMessage(result.message, false, 2000);
                const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                if(result.status === 'error') {

                } else {
                    this.loadedGrid = true;
                    this.selectedUser = '0';
                    this.ipAddresses = '';
                }
            }
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
        if(result.status === 'error') {
            showMessage('Please re-login', true, 3000);
        } else {
            this.loadedForm = true;
        }
        if(result.status === 'error') {

        } else {
            this.loadedGrid = true;
        }
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
