import {mapGetters} from 'vuex';
//import lodash from 'lodash';
export default {
    props: ['ownersData'],
    components: {
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            configDataInfo:'getConfigDataInfo',
            additionalInfo: 'getAdditionalInfo'
        }),
    },
    methods: {
        async deleteOwner(id){
            showConfirm(this.$t('message.deleteOwnerMessage'), async () => {
                const result = await this.$store.dispatch('deleteOwner', {
                    'id': id
                });

                if (result.status === 'error') {
                    showMessage(result.message, true, 2000);
                    return false;
                } else {

                    showMessage(result.message, false, 2000);

                    const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router': this.$router});
                    if (result.status === 'error') {

                    } else {
                        if (this.configDataInfo.length > 0) {
                            this.loadedScreen = true;
                        } else {
                            this.$router.push({name: 'index'});
                        }

                    }
                }
            });
        }

    }
}
