define([
    'backbone',
    '../collections/lead-type.js',
    'text!../templates/paginator.html',
    'text!../templates/type-row.html',
    'i18n!../../../nls/config_'+$('#lead-type-leads-config-system-language').val()+'_ln.js'
], function(Backbone,
            LeadsTypeCollection, PaginatorTmpl, LeadTypeRowTmpl, i18n
){

    var LeadTypeGridView = Backbone.View.extend({
        el: $('#lead-type-grid-table'),
        events: {
            'click a[data-role=delete]': 'deleteLeadType',
            'blur .lead-type-edit-attribute'  : 'editLeadType',
            'click td.lead-type-grid-paginator a.page': 'navigate'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options){
            this.leadTypes = new LeadsTypeCollection();
            this.$el =  $('#lead-type-grid-table');
            this.leadTypes.on('reset', this.renderLeadTypes, this);
            this.leadTypes.on('add', this.renderLeadTypes, this);
            this.leadTypes.on('destroy', this.renderLeadTypes, this);
        },
        render: function(){
            this.leadTypes.server_api.excludeSystemValues = 'true';
            this.leadTypes.pager();
        },
        renderLeadTypes: function(){
            this.$el.find('tbody').empty();
            this.leadTypes.each(this.renderLeadType, this);
            this.leadTypes.info()['i18n'] = i18n;
            if((this.leadTypes.length == 0) && (this.leadTypes.currentPage != 0)){
                this.leadTypes.requestPreviousPage();
            }
            this.$('td.lead-type-grid-paginator').html(this.templates.paginator(this.leadTypes.information));
        },
        renderLeadType: function(leadsTypeData){
            this.$el.find('tbody').append(_.template(LeadTypeRowTmpl, {'leadsTypeData': leadsTypeData}));
            return false;
        },
        deleteLeadType: function(e){
            var self = this,
                cid = $(e.currentTarget).data('cid'),
                model = this.leadTypes.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model){
                    model.destroy();
                    $('#default-lead-type option[value="'+ model.get('id') +'"]').remove();
                    self.render();
                }
            });
        },
        editLeadType: function(e)
        {
            var el = $(e.currentTarget),
                currentValue = el.val(),
                oldValue = el.data('old-value'),
                leadTypeId = el.closest('tr').data('lead-type-id'),
                leadTypeModel = this.leadTypes.get(leadTypeId),
                attrName =  el.data('attrName');

            if (currentValue != oldValue) {
                el.data('old-value', currentValue);
                leadTypeModel.set(attrName, currentValue);
                leadTypeModel.set('secureToken', $('#lead-type-secure-token').val());
                leadTypeModel.save(null, {
                    success: function(model, response){
                        $('#default-lead-type option[value="'+ leadTypeId +'"]').text(currentValue);
                        showMessage(response.responseText, false, 5000);
                    },
                    error: function(model, response){
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }

        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.leadTypes.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.leadTypes.goTo(this.leadTypes.firstPage);
                        break;
                    case 'last':
                        this.leadTypes.goTo(this.leadTypes.information.lastPage);
                        break;
                    case 'prev':
                        this.leadTypes.requestPreviousPage();
                        break;
                    case 'next':
                        this.leadTypes.requestNextPage();
                        break;
                }
            }
        }
    });

    return LeadTypeGridView;
});