define([
    'backbone',
    '../collections/lead-opportunity-types.js',
    'text!../templates/paginator.html',
    'text!../templates/opportunity-type-row.html',
    'i18n!../../../nls/config_'+$('#lead-opportunity-type-leads-config-system-language').val()+'_ln.js'
], function(Backbone,
            LeadsOpportunityTypeCollection, PaginatorTmpl, LeadOpportunityTypeRowTmpl, i18n
){

    var LeadOpportunityTypeGridView = Backbone.View.extend({
        el: $('#lead-opportunity-type-grid-table'),
        events: {
            'click a[data-role=delete]': 'deleteOpportunityType',
            'blur .lead-opportunity-type-edit-attribute'  : 'editOpportunityType',
            'click td.lead-opportunity-type-grid-paginator a.page': 'navigate'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options){
            this.opportunityTypes = new LeadsOpportunityTypeCollection();
            this.$el =  $('#lead-opportunity-type-grid-table');
            this.opportunityTypes.on('reset', this.renderOpportunityTypes, this);
            this.opportunityTypes.on('add', this.renderOpportunityTypes, this);
            this.opportunityTypes.on('destroy', this.renderOpportunityTypes, this);
        },
        render: function(){
            this.opportunityTypes.pager();
        },
        renderOpportunityTypes: function(){
            this.$el.find('tbody').empty();
            this.opportunityTypes.each(this.renderOpportunityType, this);
            this.opportunityTypes.info()['i18n'] = i18n;
            if((this.opportunityTypes.length == 0) && (this.opportunityTypes.currentPage != 0)){
                this.opportunityTypes.requestPreviousPage();
            }
            this.$('td.lead-opportunity-type-grid-paginator').html(this.templates.paginator(this.opportunityTypes.information));
        },
        renderOpportunityType: function(leadsOpportunityTypeData){
            this.$el.find('tbody').append(_.template(LeadOpportunityTypeRowTmpl, {'leadsOpportunityTypeData': leadsOpportunityTypeData}));
            return false;
        },
        deleteOpportunityType: function(e){
            var self = this,
                cid = $(e.currentTarget).data('cid'),
                model = this.opportunityTypes.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model){
                    model.destroy();
                    self.render();
                }
            });
        },
        editOpportunityType: function(e)
        {
            var el = $(e.currentTarget),
                currentValue = el.val(),
                oldValue = el.data('old-value'),
                opportunityTypeId = el.closest('tr').data('opportunity-type-id'),
                opportunityTypeModel = this.opportunityTypes.get(opportunityTypeId),
                attrName =  el.data('attrName');

            if (currentValue != oldValue) {
                el.data('old-value', currentValue);
                opportunityTypeModel.set(attrName, currentValue);
                opportunityTypeModel.set('secureToken', $('#opportunity-types-secure-token').val());
                opportunityTypeModel.save(null, {
                    success: function(model, response){
                        showMessage(response.responseText, false, 5000);
                    },
                    error: function(model, response){
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }

        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.opportunityTypes.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.opportunityTypes.goTo(this.opportunityTypes.firstPage);
                        break;
                    case 'last':
                        this.opportunityTypes.goTo(this.opportunityTypes.information.lastPage);
                        break;
                    case 'prev':
                        this.opportunityTypes.requestPreviousPage();
                        break;
                    case 'next':
                        this.opportunityTypes.requestNextPage();
                        break;
                }
            }
        }
    });

    return LeadOpportunityTypeGridView;
});