<?php

class Widgets_Widcard_Widcard extends Widgets_Abstract
{

    const OPTION_READONLY = 'readonly';

    /**
     * Element type text (used for displaying and editing attributes)
     */
    const ELEMENT_TYPE_TEXT = 'text';

    /**
     * System cache flag
     *
     * @var bool
     */
    protected $_cacheable = false;

    /**
     * Flag for edit  param
     *
     * @var bool
     */
    protected $_editable = false;

    /**
     * @var Helpers_Action_Session
     */
    protected $_sessionHelper;

    /**
     * Website url
     *
     * @var null
     */
    protected $_websiteUrl = null;

    /**
     * Website helper
     *
     * @var null
     */
    protected $_websiteHelper = null;

    protected function _init()
    {
        parent::_init();
        $this->_view = new Zend_View(array(
            'scriptPath' => __DIR__ . '/views/'
        ));
        $this->_websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $this->_view->websiteUrl = $this->_websiteHelper->getUrl();
        $this->_websiteUrl = $this->_websiteHelper->getUrl();
        $this->_translator = Zend_Registry::get('Zend_Translate');

        $this->_view->setHelperPath(APPLICATION_PATH . '/views/helpers/');
        $this->_view->addHelperPath('ZendX/JQuery/View/Helper/', 'ZendX_JQuery_View_Helper');
        $this->_view->addScriptPath($this->_websiteHelper->getPath() . 'seotoaster_core/application/views/scripts/');
        // init helpers
        $this->_configHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('config');
        $this->_sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
    }

    /**
     * render widgets
     *
     * @return mixed
     */
    protected function _load()
    {
        $option = strtolower($this->_options[0]);
        $methodName = '_render' . ucfirst($option);
        if (method_exists($this, $methodName)) {
            return $this->$methodName();
        }

        return $this->_translator->translate('method not exists');
    }


    /**
     * Render listing attributes
     *
     * @return string
     * @throws Zend_Exception
     */
    protected function _renderParam()
    {
        if (!empty($this->_options[1])) {
            $registry = Zend_Registry::getInstance();
            $paramName = strtolower(preg_replace('~[^ \w]~', '',
                filter_var($this->_options[1], FILTER_SANITIZE_STRING)));

            if (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_PLUGINS)) {
                $allowed = true;
            } else {
                $allowed = false;
            }

            if (in_array(self::OPTION_READONLY, $this->_options)) {
                $allowed = false;
            }


            if (!$registry->isRegistered('widcardCustomParams')) {
                $params = Widcard_Models_Mappers_WidcardCustomParamsMapper::getInstance()->getCustomParams();
                $registry->set('widcardCustomParams', $params);
            } else {
                $params = $registry->get('widcardCustomParams');
            }

            if (empty($params) && !$allowed) {
                return '';
            } elseif (!empty($params[$paramName]) && !$allowed) {
                return $params[$paramName];
            } elseif (!$allowed) {
                return '';
            }
            $this->_view->paramsData = $params;
            $this->_view->paramName = $paramName;
            $this->_view->paramEditAllowed = $allowed;

            return $this->_view->render('edit-param.phtml');
        }

        return $this->_translator->translate('Please specify widcard param');
    }

    /**
     * Return clear encoded address without staces
     *
     * @return string
     */
    protected function _renderClearAddress()
    {
        $wicAddress = '';
        $configData = Application_Model_Mappers_ConfigMapper::getInstance()->getConfig();

        if(in_array('address1', $this->_options)) {
            if (isset($configData['wicAddress1']) && $configData['wicAddress1'] != '') {
                $wicAddress = $configData['wicAddress1'];
            }
        }

        if(in_array('address2', $this->_options)) {
            if (isset($configData['wicAddress2']) && $configData['wicAddress2'] != '') {
                $wicAddress .= $configData['wicAddress2'];
            }
        }

        if(in_array('city', $this->_options)) {
            if (isset($configData['wicCity']) && $configData['wicCity'] != '') {
                $wicAddress .= ',' . $configData['wicCity'];
            }
        }

        if(in_array('state', $this->_options)) {
            if (isset($configData['wicCountryState']) && $configData['wicCountryState'] != '') {
                $wicAddress .= ',' . $configData['wicCountryState'];
            }
        }

        if(in_array('country', $this->_options)) {
            if (isset($configData['wicOrganizationCountry']) && $configData['wicOrganizationCountry'] != '') {
                $wicAddress .= ',' . $configData['wicOrganizationCountry'];
            }
        }

        if(in_array('zip', $this->_options)) {
            if (isset($configData['wicZip']) && $configData['wicZip'] != '') {
                $wicAddress .= ',' . $configData['wicZip'];
            }
        }

        if ($wicAddress != '') {
            $wicAddress = urlencode($wicAddress);
        }

        return $wicAddress;
    }



}