<?php
class Tools_AppsTools
{
    private static $_reservedListCountriesFields = array(
        'AD',
        'AE',
        'AF',
        'AG',
        'AI',
        'AL',
        'AM',
        'AN',
        'AO',
        'AQ',
        'AR',
        'AS',
        'AT',
        'AU',
        'AW',
        'AX',
        'AZ',
        'BA',
        'BB',
        'BD',
        'BE',
        'BF',
        'BG',
        'BH',
        'BI',
        'BJ',
        'BL',
        'BM',
        'BN',
        'BO',
        'BQ',
        'BR',
        'BS',
        'BT',
        'BV',
        'BW',
        'BY',
        'BZ',
        'CA',
        'CC',
        'CD',
        'CF',
        'CG',
        'CH',
        'CI',
        'CK',
        'CL',
        'CM',
        'CN',
        'CO',
        'CR',
        'CS',
        'CT',
        'CU',
        'CV',
        'CX',
        'CY',
        'CZ',
        'DD',
        'DE',
        'DJ',
        'DK',
        'DM',
        'DO',
        'DZ',
        'EC',
        'EE',
        'EG',
        'EH',
        'ER',
        'ES',
        'ET',
        'FI',
        'FJ',
        'FK',
        'FM',
        'FO',
        'FQ',
        'FR',
        'FX',
        'GA',
        'GB',
        'GD',
        'GE',
        'GF',
        'GG',
        'GH',
        'GI',
        'GL',
        'GM',
        'GN',
        'GP',
        'GQ',
        'GR',
        'GS',
        'GT',
        'GU',
        'GW',
        'GY',
        'HK',
        'HM',
        'HN',
        'HR',
        'HT',
        'HU',
        'ID',
        'IE',
        'IL',
        'IM',
        'IN',
        'IO',
        'IQ',
        'IR',
        'IS',
        'IT',
        'JE',
        'JM',
        'JO',
        'JP',
        'JT',
        'KE',
        'KG',
        'KH',
        'KI',
        'KM',
        'KN',
        'KP',
        'KR',
        'KW',
        'KY',
        'KZ',
        'LA',
        'LB',
        'LC',
        'LI',
        'LK',
        'LR',
        'LS',
        'LT',
        'LU',
        'LV',
        'LY',
        'MA',
        'MC',
        'MD',
        'ME',
        'MF',
        'MG',
        'MH',
        'MI',
        'MK',
        'ML',
        'MM',
        'MN',
        'MO',
        'MP',
        'MQ',
        'MR',
        'MS',
        'MT',
        'MU',
        'MV',
        'MW',
        'MX',
        'MY',
        'MZ',
        'NA',
        'NC',
        'NE',
        'NF',
        'NG',
        'NI',
        'NL',
        'NO',
        'NP',
        'NQ',
        'NR',
        'NT',
        'NU',
        'NZ',
        'OM',
        'PA',
        'PC',
        'PE',
        'PF',
        'PG',
        'PH',
        'PK',
        'PL',
        'PM',
        'PN',
        'PR',
        'PS',
        'PT',
        'PU',
        'PW',
        'PY',
        'PZ',
        'QA',
        'RE',
        'RO',
        'RS',
        'RU',
        'RW',
        'SA',
        'SB',
        'SC',
        'SD',
        'SE',
        'SG',
        'SH',
        'SI',
        'SJ',
        'SK',
        'SL',
        'SM',
        'SN',
        'SO',
        'SR',
        'ST',
        'SV',
        'SY',
        'SZ',
        'TC',
        'TD',
        'TF',
        'TG',
        'TH',
        'TJ',
        'TK',
        'TL',
        'TM',
        'TN',
        'TO',
        'TR',
        'TT',
        'TV',
        'TW',
        'TZ',
        'UA',
        'UG',
        'UM',
        'US',
        'UY',
        'UZ',
        'VA',
        'VC',
        'VD',
        'VE',
        'VG',
        'VI',
        'VN',
        'VU',
        'WF',
        'WK',
        'WS',
        'YD',
        'YE',
        'YT',
        'ZA',
        'ZM',
        'ZW'
    );

    private static $_reservedListWorldStatesData = array(
        '1' => 'AL',
        '2' => 'AK',
        '3' => 'AZ',
        '4' => 'AR',
        '5' => 'CA',
        '6' => 'CO',
        '7' => 'CT',
        '8' => 'DE',
        '9' => 'DC',
        '10' => 'FL',
        '11' => 'GA',
        '12' => 'HI',
        '13' => 'ID',
        '14' => 'IL',
        '15' => 'IN',
        '16' => 'IA',
        '17' => 'KS',
        '18' => 'KY',
        '19' => 'LA',
        '20' => 'ME',
        '21' => 'MD',
        '22' => 'MA',
        '23' => 'MI',
        '24' => 'MN',
        '25' => 'MS',
        '26' => 'MO',
        '27' => 'MT',
        '28' => 'NE',
        '29' => 'NV',
        '30' => 'NH',
        '31' => 'NJ',
        '32' => 'NM',
        '33' => 'NY',
        '34' => 'NC',
        '35' => 'ND',
        '36' => 'OH',
        '37' => 'OK',
        '38' => 'OR',
        '39' => 'PA',
        '40' => 'RI',
        '41' => 'SC',
        '42' => 'SD',
        '43' => 'TN',
        '44' => 'TX',
        '45' => 'UT',
        '46' => 'VT',
        '47' => 'VA',
        '48' => 'WA',
        '49' => 'WV',
        '50' => 'WI',
        '51' => 'WY',
        '52' => 'AB',
        '53' => 'BC',
        '54' => 'MB',
        '55' => 'NB',
        '56' => 'NF',
        '57' => 'NT',
        '58' => 'NS',
        '59' => 'NU',
        '60' => 'ON',
        '61' => 'PE',
        '62' => 'QC',
        '63' => 'SK',
        '64' => 'YT',
        '65' => 'ACT',
        '66' => 'NSW',
        '67' => 'NT',
        '68' => 'QLD',
        '69' => 'SA',
        '70' => 'TAS',
        '71' => 'VIC',
        '72' => 'WA'
    );

    /**
     * Method builds a list of world countries with ISO codes and country name translated to current locale language
     *
     * @return array
     */
    public static function getCountries() {
        $data = array();
        $countriesNames = Zend_Locale::getTranslationList('territory', null, 2);

        $countryList = self::$_reservedListCountriesFields;

        foreach ($countryList as $country){
            $country = array('country' => $country);
            if(!isset($countriesNames[$country['country']])) {
                continue;
            }

            $country['name'] = $countriesNames[$country['country']];
            $data[$country['country']] = $country['name'];
        }

        asort($data);
        return $data;
    }

    /**
     * Get state info by given id
     *
     * @param $stateId
     * @return mixed|null
     */
    public static function getStateById($stateId) {
        if (!is_numeric($stateId)) {
            return null;
        }
        if(array_key_exists($stateId, self::$_reservedListWorldStatesData)) {
            return self::$_reservedListWorldStatesData[$stateId];
        }
        return null;
    }

}