<?php

/**
 * ChecklistMapper.php
 *
 *
 * @method Crm_Mapper_ChecklistMapper   getInstance()   getInstance()   Returns an instance of itself
 * @method Zend_Db_Table    getDbTable()    getDbTable()    Returns an instance of DbTable
 */
class Crm_Mapper_ChecklistMapper extends Application_Model_Mappers_Abstract
{

    protected $_model = 'Crm_Model_ChecklistModel';

    protected $_dbTable = 'Crm_DbTable_ChecklistDbTable';

    /**
     * Save checklist model
     * @param $model Crm_Model_ChecklistModel
     * @return Crm_Model_ChecklistModel
     */
    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            $model = new $this->_model($model);
        }

        $data = array(
            'checklist_status' => $model->getChecklistStatus(),
            'closed_by' => $model->getClosedBy(),
            'checklist_name' => $model->getChecklistName()
        );

        $id = $model->getId();
        if (!empty($id)) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            $model->setId($id);
        }

        return $model;
    }

    /**
     * Find by checklist name
     *
     * @param string $checklistName checklist name
     * @return null
     */
    public function findByName($checklistName)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('checklist_name = ?', $checklistName);
        return  $this->_findWhere($where);
    }


}
