<?php

/**
 * EmailTriggerSettingsMapper.php
 *
 *
 * @method Emailsequence_Models_Mapper_EmailTriggerSettingsMapper   getInstance()   getInstance()   Returns an instance of itself
 * @method Zend_Db_Table    getDbTable()    getDbTable()    Returns an instance of DbTable
 */
class Emailsequence_Models_Mapper_EmailTriggerSettingsMapper extends Application_Model_Mappers_Abstract {

    protected $_dbTable = 'Emailsequence_Models_Dbtables_EmailTriggerSettingsDbtable';

    protected $_model   = 'Emailsequence_Models_Models_EmailTriggerSettingsModel';

    public function save($model) {
        if(!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'cartStatus'         => $model->getCartStatus(),
            'type'               => $model->getType(),
            'period'             => $model->getPeriod(),
            'productsIds'        => $model->getProductsIds(),
            'emailTemplate'      => $model->getEmailTemplate(),
            'emailFrom'          => $model->getEmailFrom(),
            'emailFromLabel'     => $model->getEmailFromLabel(),
            'emailMessage'       => $model->getEmailMessage(),
            'productsRule'       => $model->getProductsRule(),
            'schedulePeriod'     => $model->getSchedulePeriod(),
            'schedulePeriodType' => $model->getSchedulePeriodType(),
            'lagType'            => $model->getLagType(),
            'sequenceOnly'       => $model->getSequenceOnly(),
            'triggerName'        => $model->getTriggerName(),
            'subject'            => $model->getSubject(),
            'preheader'          => $model->getPreheader()
         );

        $id = $model->getId();
        if (!empty($id)) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            $model->setId($id);
        }

        return $model;

    }

    /**
     * Delete by settings id
     *
     * @param int $id settings id
     * @return mixed
     * @throws Exception
     */
    public function deleteCartStatus($id) {
        $where = $this->getDbTable()->getAdapter()->quoteInto("id=?", $id);
        return $this->getDbTable()->delete($where);
    }

    /**
     * @deprecated system version 2.6.0
     *
     * @param Emailsequence_Models_Models_EmailTriggerSettingsModel $model cart status model
     * @param int $id cart status settings id
     * @return mixed
     * @throws Exception
     */
    public function updateCartStatus($model, $id) {
        $data = array(
            'cartStatus'    => $model->getCartStatus(),
            'period'        => $model->getPeriod(),
            'productsIds'   => $model->getProductsIds(),
            'emailTemplate' => $model->getEmailTemplate(),
            'emailFrom'     => $model->getEmailFrom(),
            'emailMessage'  => $model->getEmailMessage(),
            'productsRule'  => $model->getProductsRule()
        );
        $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
        return $this->getDbTable()->update($data, $where);
    }

    /**
     * Select all by id
     *
     * @param int $id settings id
     * @return array|null
     * @throws Exception
     */
    public function selectCartStatusById($id) {
        $where = $this->getDbTable()->getAdapter()->quoteInto("id=?", $id);
        return $this->fetchAll($where);
    }

    /**
     * Select config statuses
     *
     * @param string $cartStatus shopping cart status
     * @param string $periodHours
     * @param array $productsIds product ids
     * @param string $productsRule rule
     * @return array|null
     * @throws Exception
     */
    public function selectCartStatus($cartStatus, $period, $productsIds, $productsRule) {
        $where =  $this->getDbTable()->getAdapter()->quoteInto('cartStatus=?', $cartStatus);
        $where .= ' AND '. $this->getDbTable()->getAdapter()->quoteInto('period=?', $period);
        $where .= ' AND '. $this->getDbTable()->getAdapter()->quoteInto('productsIds=?', $productsIds);
        $where .= ' AND '. $this->getDbTable()->getAdapter()->quoteInto('productsRule=?', $productsRule);
        return $this->fetchAll($where);
    }

    public function getUsedTemplates()
    {
        $where =  $this->getDbTable()->getAdapter()->quoteInto('emailTemplate <> ?', '');
        $where .= ' AND '.  new Zend_Db_Expr('emailTemplate IS NOT NULL');
        $where .= ' AND '.  $this->getDbTable()->getAdapter()->quoteInto('emailTemplate <> ?', '0');
        $select = $this->getDbTable()->getAdapter()->select()
            ->from(array('pcs' => 'plugin_cartstatusemail_settings'), array('emailTemplate', 'emailTemplate'));

        $select->where($where);
        $select->group('emailTemplate');

        return $this->getDbTable()->getAdapter()->fetchPairs($select);
    }

    public function getSequenceNames()
    {
        $select = $this->getDbTable()->getAdapter()->select()
            ->from(array('pcs' => 'plugin_cartstatusemail_settings'),
                array(
                    'id' =>'pes.id',
                    'sequence_name' => 'pes.sequence_name'
                )
            )
            ->join(array('pet' => 'plugin_emailsequence_triggers'), 'pet.trigger_id=pcs.id', array())
            ->join(array('pes' => 'plugin_emailsequence_settings'), 'pes.id=pet.sequence_settings_id', array());

        $select->group('pes.id');
        return $this->getDbTable()->getAdapter()->fetchPairs($select);
    }


    /**
     * @param string $where SQL where clause
     * @param string $order OPTIONAL An SQL ORDER clause.
     * @param int $limit OPTIONAL An SQL LIMIT count.
     * @param int $offset OPTIONAL An SQL LIMIT offset.
     * @param bool $withoutCount flag to get with or without records quantity
     * @param bool $singleRecord flag fetch single record
     * @param string $having mysql having
     *
     * @throws Exception
     * @return array
     */
    public function fetchTriggersData(
        $where = null,
        $order = null,
        $limit = null,
        $offset = null,
        $withoutCount = false,
        $singleRecord = false,
        $having = ''
    ) {
        $select = $this->getDbTable()->getAdapter()->select()
            ->from(array('pcs' => 'plugin_cartstatusemail_settings'),
                array(
                    'pcs.id',
                    'pcs.cartStatus',
                    'pcs.type',
                    'pcs.period',
                    'pcs.productsIds',
                    'pcs.emailTemplate',
                    'pcs.emailFrom',
                    'pcs.emailFromLabel',
                    'pcs.emailMessage',
                    'pcs.productsRule',
                    'pcs.schedulePeriod',
                    'pcs.lagType',
                    'pcs.sequenceOnly',
                    'pcs.triggerName',
                    'pcs.schedulePeriodType',
                    'pcs.subject',
                    'pcs.preheader'
                )
            )
            ->joinLeft(array('pet' => 'plugin_emailsequence_triggers'), 'pet.trigger_id=pcs.id', array())
            ->joinLeft(array('pes' => 'plugin_emailsequence_settings'), 'pes.id=pet.sequence_settings_id', array());

        if (!empty($having)) {
            $select->having($having);
        }

        $select->group('pcs.id');
        if (!empty($order)) {
            $select->order($order);
        }

        if (!empty($where)) {
            $select->where($where);
        }

        $select->limit($limit, $offset);

        if ($singleRecord) {
            $data = $this->getDbTable()->getAdapter()->fetchRow($select);
        } else {
            $data = $this->getDbTable()->getAdapter()->fetchAll($select);
        }

        if ($withoutCount === false) {
            $select->reset(Zend_Db_Select::COLUMNS);
            $select->reset(Zend_Db_Select::FROM);
            $select->reset(Zend_Db_Select::LIMIT_OFFSET);
            $select->reset(Zend_Db_Select::LIMIT_COUNT);

            $count = array('count' => new Zend_Db_Expr('COUNT(DISTINCT(pcs.id))'));

            $select->from(array('pcs' => 'plugin_cartstatusemail_settings'), $count)
                ->joinLeft(array('pet' => 'plugin_emailsequence_triggers'), 'pet.trigger_id=pcs.id', array())
                ->joinLeft(array('pes' => 'plugin_emailsequence_settings'), 'pes.id=pet.sequence_settings_id', array());

            $select =  $this->getDbTable()->getAdapter()->select()
                ->from(
                    array('subres' => $select),
                    array('count' => 'SUM(count)')
                );

            $count = $this->getDbTable()->getAdapter()->fetchRow($select);

            return array(
                'totalRecords' => $count['count'],
                'data' => $data,
                'offset' => $offset,
                'limit' => $limit
            );
        } else {
            return $data;
        }
    }

    public function getMmsBySequence($sequenceId)
    {
        if(!empty($sequenceId)) {
            $where =  $this->getDbTable()->getAdapter()->quoteInto('pehs.sequence_id =?', $sequenceId);

            $select = $this->getDbTable()->getAdapter()->select()->from(array('pehs' => 'plugin_emailsequence_has_mms'),
                array(
                    'mmsFiles' => 'pehs.mms_files',
                    'mmsFilesOriginalNames' => 'pehs.mms_files_original_names',

                ));
            $select->where($where);

            return $this->getDbTable()->getAdapter()->fetchRow($select);
        }

        return false;
    }

}

