import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import { isProxy, toRaw } from 'vue';
export default {
    props: ['leadId'],
    data () {
        return {
            loadedScreen: true,
            locale: $('#dashboard-system-language').val(),
            localeMapping: localeMapping,
            websiteUrl: $('#website_url').val(),
            loadedOpportunityScreen: false,
            filterByOpportunityStage:0,
            opportunityStages:{},
            quoteOwners:{},
            quoteTemplates:{},
            quotesWithoutLeads:[],
            users:{},
            loadedTableScreen:false,
            leadsData:{},
            opportunityCreateOption:{},
            searchable:true,
            duplicateQuoteIds:{},
            quoteTemplatesSearchResults:[],
            assignQuoteTemplates:{},
            assignQuoteIds:{},
            options: [],
            assignQuoteOptions: [],
            quoteTitles:{},
            processingQuoteForm:false,
            assignQuoteProcessing:false
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            formatTimeOnlyWithPartOfTheDay: 'formatTimeOnlyWithPartOfTheDay',
            configDataInfo:'getAdditionalInfoDetailedScreen',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            toCurrency:'toCurrency',
            unescapeValue:'unescapeValue',
            additionalInfo:'getAdditionalInfoOpportunities',
            opportunitiesData: 'getOpportunitiesData',
            leadData:'getDetailedScreenLeadData',
            generalAdditionalInfo:'getAdditionalInfoDetailedScreen',
            filterData:'getOpportunityFilterData',
            isNewOpportunityRow:'isNewOpportunityRow',
            changeFilter: 'getOpportunitiesLogChangeFilter',
        })
    },
    watch: {
        changeFilter (newData, originalData) {
            this.$store.commit('setPaginationData',
                {
                    opportunitiesLog: {
                        currentPage: 1,
                        itemsPerPage: 10,
                        totalItems: 0,
                        visiblePages: 4
                    }
                });

            if (typeof newData.searchData !== 'undefined') {
                if (isProxy(newData.searchData)) {
                    let filterDataObject = {};

                    if (newData.searchData.filterByOpportunityStage !== 'undefined') {
                        filterDataObject['filter-by-opportunity-stage'] = toRaw(newData.searchData.filterByOpportunityStage);
                    }

                    this.searchData = filterDataObject;
                } else {
                    this.searchData = newData.searchData;
                }
            } else {
                this.searchData = '';
            }

            this.$store.commit('setOpportunityFilterData', toRaw(this.searchData));
            this.applyFilter();
        }
    },
    methods: {
        async applyFilter() {

            const result = await this.$store.dispatch('getOpportunityTabData',
                {
                    'router':this.$router,
                    'leadId':this.leadId,
                    'orderBy':'plo.created_at DESC',
                    'filter':this.filterData
                });

            if (result.error === 1) {
                showMessage(result.message, true, 3000);
            } else {
                this.opportunityStages = result.opportunityStages;
                this.quoteOwners = result.quoteOwners;
                this.quoteTemplates = result.quoteTemplates;
                this.quotesWithoutLeads = result.quotesWithoutLeads;
                this.users = result.users;
                this.leadsData = result.leadsData;
                this.loadedTableScreen = true;
                this.loadedOpportunityScreen = true;
                this.getAssignQuoteTemplateOptions();
            }
        },
        async changeDefaultFilter()
        {
            this.prepareFilterData();
            this.applyFilter();
        },
        async prepareFilterData()
        {

            let filterDataObject = {};

            if (this.filterByOpportunityStage !== 'undefined') {
                filterDataObject['filter-by-opportunity-stage'] = toRaw(this.filterByOpportunityStage);
            }

            this.$store.commit('setOpportunityFilterData', filterDataObject);
        },
        async changeQuoteOwner(event, quoteId)
        {
            let quoteOwnerId = event.target.value;

            const result = await this.$store.dispatch('changeQuoteOwner',
                {
                    'router':this.$router,
                    'quoteOwnerId': quoteOwnerId,
                    'quoteId': quoteId
                });
        },
        async removeOpportunity(opportunityId)
        {
            showConfirm(this.$t('message.opportunityTabAttentionYouAreAbout'), async () => {
                const result = await this.$store.dispatch('deleteOpportunity', {
                    'router': this.$router, 'opportunityId': opportunityId
                });

                if (result.error === 1) {
                    showMessage(result.message, true, 2000);
                }

                const resultOp = await this.$store.dispatch('getOpportunityTabData',
                    {
                        'router':this.$router,
                        'leadId':this.leadId,
                        'orderBy':'plo.created_at DESC',
                        'filter':this.filterData,
                        'skipSpinner':true
                    });

                if (resultOp.error === 1) {
                    showMessage(resultOp.message, true, 3000);
                }

            }, async () => {
                return false;
            });
        },
        async removeQuote(quoteId)
        {
            showConfirm(this.$t('message.opportunityTabAreYouSureWantToDeleteQuote'), async () => {
                const result = await this.$store.dispatch('deleteQuote', {
                    'router': this.$router, 'quoteId': quoteId
                });

                if (result.error === 1) {
                    showMessage(result.message, true, 2000);
                }

                const resultOp = await this.$store.dispatch('getOpportunityTabData',
                    {
                        'router':this.$router,
                        'leadId':this.leadId,
                        'orderBy':'plo.created_at DESC',
                        'filter':this.filterData,
                        'skipSpinner':true
                    });

                if (resultOp.error === 1) {
                    showMessage(resultOp.message, true, 3000);
                }

            }, async () => {
                return false;
            });
        },
        changeOpportunityCreateOption(opportunityId, opportunityType)
        {
            this.opportunityCreateOption[opportunityId] = opportunityType;
        },
        removeDuplicatedTemplateId(opportunityId)
        {
            this.duplicateQuoteIds[opportunityId] = '';
        },
        removeAssignQuoteId(opportunityId)
        {
            this.assignQuoteIds[opportunityId] = '';
        },
        changeTemplate(event, opportunityId)
        {
            if (typeof event[0] !== 'undefined') {
                this.duplicateQuoteIds[opportunityId] = event[0].id;
            }
        },
        changeAssignQuoteTemplate(event, opportunityId)
        {
            if (typeof event[0] !== 'undefined') {
                this.assignQuoteIds[opportunityId] = event[0].id;
            }
        },
        getAssignQuoteTemplateOptions(query)
        {
            let quotesWithoutLeads = [];

            Object.values(this.quotesWithoutLeads).forEach(function(quotesWithoutLead) {
                quotesWithoutLeads.push({
                    'id': quotesWithoutLead['id'],
                    'title': quotesWithoutLead['title']
                });
            });

            this.assignQuoteOptions = quotesWithoutLeads;
        },
        assignExistedQuoteOpportunity(opportunityId)
        {
            let assignQuoteId = '';

            if (this.assignQuoteProcessing === true) {
                return false;
            }

            this.assignQuoteProcessing = true;

            if (typeof this.assignQuoteIds[opportunityId] !== 'undefined') {
                assignQuoteId = this.assignQuoteIds[opportunityId];
            }

            if (assignQuoteId === '') {
                showMessage(this.$t('message.opportunityTabPleaseChooseTheQuote'), true, 2000);
                this.assignQuoteProcessing = false;
                return false;
            }

            showConfirm(this.$t('message.opportunityTabAreYouSureWantToAssignExistedQuote'), async () => {
                const result = await this.$store.dispatch('assignExistedQuoteOpportunuty', {
                    'router': this.$router,
                    'leadId': this.leadId,
                    'opportunityId':opportunityId,
                    'quoteId':assignQuoteId
                });

                if (result.error === 1) {
                    showMessage(result.responseText, true, 2000);
                    this.assignQuoteProcessing = false;
                    return false;
                } else {
                    showMessage(this.$t('message.opportunityTabQuoteHasBeenAssigned'), false, 5000);
                    this.assignQuoteProcessing = false;

                    this.assignQuoteIds[opportunityId] = '';
                    if (typeof this.assignQuoteTemplates[opportunityId] !== 'undefined') {
                        delete this.assignQuoteTemplates[opportunityId];
                    }
                    this.assignQuoteOptions = [];

                    const resultOp = await this.$store.dispatch('getOpportunityTabData',
                        {
                            'router':this.$router,
                            'leadId':this.leadId,
                            'orderBy':'plo.created_at DESC',
                            'filter':this.filterData,
                            'skipSpinner':true
                        });

                    if (resultOp.error === 1) {
                        showMessage(resultOp.message, true, 3000);
                    }

                    this.quotesWithoutLeads = resultOp.quotesWithoutLeads;
                    this.getAssignQuoteTemplateOptions();
                }
            }, async () => {
                this.assignQuoteProcessing = false;
                return false;
            });
        },
        async getQuoteTemplateOptions(query)
        {
            if (!query) {
                return false;
            }

            const result = await this.$store.dispatch('getQuoteTemplates', {'router':this.$router, 'searchTerm':query});
            if (result.error == '1') {
                this.options = [];
                return false;
            }

            this.options = result;
        },
        async createNewQuote(opportunityId)
        {
            if (this.processingQuoteForm === true) {
                return false;
            }

            this.processingQuoteForm = true;

            let errorMessage = '',
                isValid = true,
                quoteTitle = '',
                duplicateQuoteId = '',
                opportunityCreateOption = '';

            if (typeof this.quoteTitles[opportunityId] === 'undefined' || !typeof this.quoteTitles[opportunityId]) {
                errorMessage += this.$t('message.opportunityTabPleaseSpecifyQuoteTitle')+ '<br/>';
                this.quoteLabelError = true;
                isValid = false;
            } else {
                quoteTitle = this.quoteTitles[opportunityId];
            }

            if (typeof this.opportunityCreateOption[opportunityId] === 'undefined') {
                opportunityCreateOption = 'create_new_quote';
            } else {
                opportunityCreateOption = this.opportunityCreateOption[opportunityId];
            }

            if (typeof this.duplicateQuoteIds[opportunityId] !== 'undefined') {
                duplicateQuoteId = this.duplicateQuoteIds[opportunityId];
            }

            if (opportunityCreateOption === 'create_quote_duplicate' && (typeof this.duplicateQuoteIds[opportunityId] === 'undefined' || this.duplicateQuoteIds[opportunityId] === '')) {
                showMessage(this.$t('message.opportunityTabPleaseSearchByQuoteTitle'), true, 5000);
                return false;
            }

            if (isValid === false){
                showMessage(errorMessage, true);
                this.processingQuoteForm = false;
                return false;
            }

            const result = await this.$store.dispatch('createQuoteForOpportunity',
                {
                    'router': this.$router,
                    'leadId': this.leadId,
                    'opportunityId': opportunityId,
                    'quoteTitle': quoteTitle,
                    'duplicateQuoteId': duplicateQuoteId,
                });

            if (parseInt(result.error) === 1) {
                if (typeof result.responseText !== 'undefined' && typeof result.responseText.message !== 'undefined') {
                    showMessage(result.responseText.message, true, 5000);
                    this.processingQuoteForm = false;
                    return false;
                } else {
                    showMessage(result.message, true, 5000);
                    this.processingQuoteForm = false;
                    return false;
                }
            } else {
                showMessage(result.responseText.message, false, 5000);
                const resultOp = await this.$store.dispatch('getOpportunityTabData',
                    {
                        'router':this.$router,
                        'leadId':this.leadId,
                        'orderBy':'plo.created_at DESC',
                        'filter':this.filterData,
                        'skipSpinner':true
                    });

                if (resultOp.error === 1) {
                    showMessage(resultOp.message, true, 3000);
                }

                this.resetQuoteForm(opportunityId);
                this.processingQuoteForm = false;
            }
        },
        resetQuoteForm(opportunityId)
        {
            this.opportunityCreateOption[opportunityId] = 'create_new_quote';
            this.quoteTitles[opportunityId] = '';
            this.duplicateQuoteIds[opportunityId] = '';
            if (typeof this.quoteTemplatesSearchResults[opportunityId] !== 'undefined') {
                delete this.quoteTemplatesSearchResults[opportunityId];
            }
        },
        async editOpportunity(opportunityId)
        {
            this.$store.commit('setPreChosenOpportunityId', opportunityId);
            this.$store.commit('setChangeSubTabRemote', {'tabName':'opportunity', 'opportunityId':opportunityId});

            $('body,html').animate({
                scrollTop: $('#lead-detailed-view-config-tabs-tab').offset().top - 300
            }, 1500);
        }

    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.changeDefaultFilter();
    },
    async updated() {
        this.$nextTick(function () {
            window.newOpportunityNameRow = '';
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }

            if (typeof tableResponsive === "function") {
                tableResponsive();
            }
        })
    }
}
