import {mapGetters} from 'vuex';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import { isProxy, toRaw } from 'vue';
import moment from 'moment';
export default {
    props: ['leadId'],
    data () {
        return {
            loadedScreen: true,
            loadedScreenDataExpired: false,
            loadedScreenDataToday: false,
            loadedScreenDataUpcoming: false,
            locale: $('#dashboard-system-language').val(),
            localeMapping: localeMapping,
            websiteUrl: $('#website_url').val(),
            viewItemDetails:{},
            showEmailConversation:{},
            showEmailConversationDetailsList:{},
            showItemDetails:{},
            upcomingSpinnerId:'lead-timeline-upcoming-events-div',
            todaySpinnerId:'lead-timeline-today-div',
            expiredSpinnerId:'lead-timeline-log-div',
            searchData:'',
            filterByActionType:'all',
            filterByType:'',
            filterBySubType:'',
            usersList:[],
            completeTaskTitle:'',
            completeTaskNotificationEmails:'',
            completeTaskId:'',
            completeTaskComment:'',
            showCompleteTaskDialog:false,
            completeTaskCheckbox:[],
            completeTaskIndex:'',
            processingTaskCompletion:false,
            currentMonthOfTimelineRow:'',
            viewMeetingAdditionalItemDetails: {},
            currentCallSid:'',
            currentCallSummary:'',
            currentCallTranscription:'',
            currentCallTranscriptionDetails:'',
            showCallTranscriptDialog:false,
            showCallSummaryDialog:false,
            listOfEmailConversations:[],
            gatewayLabelsList:{},
            activeTimelineType:''
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            formatTimeOnlyWithPartOfTheDay: 'formatTimeOnlyWithPartOfTheDay',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            toCurrency:'toCurrency',
            unescapeValue:'unescapeValue',
            additionalInfo:'getAdditionalInfoTimelineLog',
            changeFilter: 'getTimelineLogChangeFilter',
            timelineLogDataUpcoming: 'getTimelineLogDataUpcoming',
            timelineLogDataToday: 'getTimelineLogDataToday',
            timelineLogDataExpired: 'getTimelineLogDataExpired',
            leadData:'getDetailedScreenLeadData',
            generalAdditionalInfo:'getAdditionalInfoDetailedScreen',
            filterData:'getTimelineFilterData',
            isNewMonthRowTimeline:'isNewMonthRowTimeline',
            showSpinnerTimeilineUpcomingSpinnerId:'getShowSpinnerTimeilineUpcomingSpinnerId',
            showSpinnerTimelineExpiredSpinnerId:'getShowSpinnerTimelineExpiredSpinnerId',
            showSpinnerTimelineTodaySpinnerId:'getShowSpinnerTimelineTodaySpinnerId',
        })
    },
    watch: {
        changeFilter (newData, originalData) {
           this.$store.commit('setPaginationData',
           {
                timelineLog: {
                    currentPage: 1,
                    itemsPerPage: 10,
                    totalItems: 0,
                    visiblePages: 4
                }
           });

            if (typeof newData.searchData !== 'undefined') {
                if (isProxy(newData.searchData)) {
                    let filterDataObject = {},
                        switchFilter = false;

                    if (typeof newData.searchData.switchFilter !== 'undefined') {
                        switchFilter = true;
                    }

                    if (newData.searchData.filterByActionType !== 'undefined') {
                        filterDataObject['filter-by-action-type'] = toRaw(newData.searchData.filterByActionType);
                        if (switchFilter === true) {
                            this.filterByActionType = filterDataObject['filter-by-action-type'];
                        }
                    }

                    if (newData.searchData.filterByType !== 'undefined') {
                        filterDataObject['filter-by-type'] = toRaw(newData.searchData.filterByType);
                        if (switchFilter === true) {
                            this.filterByType = filterDataObject['filter-by-type'];
                        }
                    }

                    if (newData.searchData.filterBySubType !== 'undefined') {
                        filterDataObject['filter-by-sub-type'] = toRaw(newData.searchData.filterBySubType);
                        if (switchFilter === true) {
                            this.filterBySubType = filterDataObject['filter-by-sub-type'];
                        }
                    }

                    this.searchData = filterDataObject;
                } else {
                    this.searchData = newData.searchData;
                }
            } else {
                this.searchData = '';
            }

            this.$store.commit('setTimelineFilterData', toRaw(this.searchData));
            this.applyFilter();
        }
    },
    methods: {
        async applyFilter() {

           this.loadUpcomingTimeLine();
           this.loadTodayTimeLine();
           this.loadExpiredTimeLine();
        },
        async loadUpcomingTimeLine()
        {
            const resultUpcomingLog = await this.$store.dispatch('getTimelineLogData',
                {
                    'router':this.$router,
                    'leadId':this.leadId,
                    'spinnerId': this.upcomingSpinnerId,
                    'timelineType':'upcoming',
                    'organizationId':'',
                    'filter':this.filterData
                });

            if (typeof resultUpcomingLog.status !== 'undefined' && resultUpcomingLog.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.loadedScreenDataUpcoming = true;
                this.usersList = resultUpcomingLog.users;
                this.gatewayLabelsList = resultUpcomingLog.gatewayLabelsList;
            }
        },
        async loadTodayTimeLine()
        {
            const resultTodayLog = await this.$store.dispatch('getTimelineLogData',
                {
                    'router':this.$router,
                    'leadId':this.leadId,
                    'spinnerId': this.todaySpinnerId,
                    'timelineType':'today',
                    'organizationId':'',
                    'filter':this.filterData
                });

            if (typeof resultTodayLog.status !== 'undefined' && resultTodayLog.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.loadedScreenDataToday = true;
                this.usersList = resultTodayLog.users;
                this.gatewayLabelsList = resultTodayLog.gatewayLabelsList;
            }
        },
        async loadExpiredTimeLine()
        {
            const resultExpiredLog = await this.$store.dispatch('getTimelineLogData',
                {
                    'router':this.$router,
                    'leadId':this.leadId,
                    'spinnerId': this.expiredSpinnerId,
                    'timelineType':'',
                    'organizationId':'',
                    'filter':this.filterData
                });

            if (typeof resultExpiredLog.status !== 'undefined' && resultExpiredLog.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.loadedScreenDataExpired = true;
                this.usersList = resultExpiredLog.users;
                this.gatewayLabelsList = resultExpiredLog.gatewayLabelsList;
            }
        },
        async applyFilterData()
        {
            if (this.filterByActionType === 'all') {
                this.filterByType = '';
                this.filterBySubType = '';
            }

            this.$store.commit('setPaginationData',
                {
                    timelineLog: {
                        currentPage: 1,
                        itemsPerPage: 10,
                        totalItems: 0,
                        visiblePages: 4
                    }
                });

            this.prepareFilterData();
            this.applyFilter();
        },
        showHideMeetingAdditionalInfoBlock(itemName)
        {
            if (typeof this.viewMeetingAdditionalItemDetails[itemName] !== 'undefined') {
                if (this.viewMeetingAdditionalItemDetails[itemName] === true) {
                    this.viewMeetingAdditionalItemDetails[itemName] = false;
                } else {
                    this.viewMeetingAdditionalItemDetails[itemName] = true;
                }
            } else {
                this.viewMeetingAdditionalItemDetails[itemName] = true;
            }
        },
        async addMeetingAdditionalInfo(event, meetingLogId, index, type)
        {
            let newValue = event.target.value,
                oldValue = '';

            if (type === 'today') {
                if (typeof this.timelineLogDataToday[index]['meetingAdditionalNotes'] !== 'undefined') {
                    oldValue = this.timelineLogDataToday[index]['meetingAdditionalNotes'];
                }
            }

            if (type === 'expired') {
                if (typeof this.timelineLogDataExpired[index]['meetingAdditionalNotes'] !== 'undefined') {
                    oldValue = this.timelineLogDataExpired[index]['meetingAdditionalNotes'];
                }
            }

            if (newValue === oldValue) {
                return false;
            }

            const result= await this.$store.dispatch('addMeetingCommentLog',
                {
                    'router':this.$router,
                    'meetingLogId':meetingLogId,
                    'additionalContent':newValue,
                });

            if (typeof result.status !== 'undefined' && result.status === 'error') {
                showMessage(result.message, true, 3000);
            } else {
                if (type === 'today') {
                    if (typeof this.timelineLogDataToday[index]['meetingAdditionalNotes'] !== 'undefined') {
                        this.timelineLogDataToday[index]['meetingAdditionalNotes'] = newValue;
                    }
                }

                if (type === 'expired') {
                    if (typeof this.timelineLogDataExpired[index]['meetingAdditionalNotes'] !== 'undefined') {
                        this.timelineLogDataExpired[index]['meetingAdditionalNotes'] = newValue;
                    }
                }

                showMessage(result.responseText, false, 3000);
            }
        },
        async addCallAdditionalInfo(event, callLogId, index, type)
        {
            let newValue = event.target.value,
                oldValue = '';

            if (type === 'today') {
                if (typeof this.timelineLogDataToday[index]['callDetails'] !== 'undefined') {
                    oldValue = this.timelineLogDataToday[index]['callDetails'];
                }
            }

            if (type === 'expired') {
                if (typeof this.timelineLogDataExpired[index]['callDetails'] !== 'undefined') {
                    oldValue = this.timelineLogDataExpired[index]['callDetails'];
                }
            }

            if (newValue === oldValue) {
                return false;
            }

            const result= await this.$store.dispatch('addCallDetailsLog',
                {
                    'router':this.$router,
                    'callLogId':callLogId,
                    'additionalContent':newValue,
                });

            if (typeof result.status !== 'undefined' && result.status === 'error') {
                showMessage(result.message, true, 3000);
            } else {
                if (type === 'today') {
                    if (typeof this.timelineLogDataToday[index]['callDetails'] !== 'undefined') {
                        this.timelineLogDataToday[index]['callDetails'] = newValue;
                    }
                }

                if (type === 'expired') {
                    if (typeof this.timelineLogDataExpired[index]['callDetails'] !== 'undefined') {
                        this.timelineLogDataExpired[index]['callDetails'] = newValue;
                    }
                }

                showMessage(result.responseText, false, 3000);
            }
        },
        async changeMeetingStatus(event, meetingLogId, index, type)
        {
            let newValue = event.target.value,
                oldValue = '',
                additionalMeetingNotes = '',
                oldObject = {};


            if (type === 'today') {
                if (typeof this.timelineLogDataToday[index]['meetingActualStatus'] !== 'undefined') {
                    additionalMeetingNotes = this.timelineLogDataToday[index]['meetingAdditionalNotes'];
                    oldValue = this.timelineLogDataToday[index]['meetingActualStatus'];
                }
            }

            if (type === 'expired') {
                if (typeof this.timelineLogDataExpired[index]['meetingActualStatus'] !== 'undefined') {
                    additionalMeetingNotes = this.timelineLogDataExpired[index]['meetingAdditionalNotes'];
                    oldValue = this.timelineLogDataExpired[index]['meetingActualStatus'];
                }
            }

            if (newValue === 'completed' && additionalMeetingNotes === '') {
                if (type === 'today') {
                     if (typeof this.timelineLogDataToday[index]['meetingActualStatus'] !== 'undefined') {
                         oldObject = Object.assign({}, this.timelineLogDataToday);
                         oldObject[index]['meetingActualStatus'] = oldValue;
                         this.$store.commit('setTimelineLogDataToday', oldObject);
                    }
                }

                if (type === 'expired') {
                    if (typeof this.timelineLogDataExpired[index]['meetingAdditionalNotes'] !== 'undefined') {
                        oldObject = Object.assign({}, this.timelineLogDataExpired);
                        oldObject[index]['meetingActualStatus'] = oldValue;
                        this.$store.commit('setTimelineLogDataExpired', oldObject);
                    }
                }

                showMessage(this.$t('message.timelineTabAddYourMeetingNotesNow'), true, 3000);
                return false;
            }

            const result= await this.$store.dispatch('changeMeetingStatus',
                {
                    'router':this.$router,
                    'meetingLogId':meetingLogId,
                    'status':newValue,
                });

            if (typeof result.status !== 'undefined' && result.status === 'error') {
                showMessage(result.message, true, 3000);
            } else {
                if (type === 'today') {
                    if (typeof this.timelineLogDataToday[index]['meetingActualStatus'] !== 'undefined') {
                        oldObject = Object.assign({}, this.timelineLogDataToday);
                        oldObject[index]['meetingActualStatus'] = newValue;
                        this.$store.commit('setTimelineLogDataToday', oldObject);
                    }
                }

                if (type === 'expired') {
                    if (typeof this.timelineLogDataExpired[index]['meetingActualStatus'] !== 'undefined') {
                        oldObject = Object.assign({}, this.timelineLogDataExpired);
                        oldObject[index]['meetingActualStatus'] = newValue;
                        this.$store.commit('setTimelineLogDataExpired', oldObject);
                    }
                }

                showMessage(result.responseText, false, 3000);
            }
        },
        prepareFilterData()
        {
            let filterDataObject = {};

            if (this.filterByActionType !== 'undefined') {
                filterDataObject['filter-by-action-type'] = toRaw(this.filterByActionType);
            }

            if (this.filterByType !== 'undefined') {
                filterDataObject['filter-by-type'] = toRaw(this.filterByType);
            }

            if (this.filterBySubType !== 'undefined') {
                filterDataObject['filter-by-sub-type'] = toRaw(this.filterBySubType);
            }

            this.$store.commit('setTimelineFilterData', filterDataObject);
        },
        viewDetailsSwitch(itemName)
        {
            if (typeof this.viewItemDetails[itemName] !== 'undefined') {
                if (this.viewItemDetails[itemName] === true) {
                    this.viewItemDetails[itemName] = false;
                } else {
                    this.viewItemDetails[itemName] = true;
                }
            } else {
                this.viewItemDetails[itemName] = true;
            }
        },
        getCallLogLabel(data)
        {
            let callLogLabel = this.$t('message.timelineTabAddCallDetails');

            if (data.callDetails) {
                callLogLabel = this.$t('message.timelineTabViewCallNotes');
            }

            return callLogLabel;
        },
        getCallLogDetails(data)
        {
            let callDetails = ''

            if (data.callDetails) {
                callDetails = data.callDetails;
            }

            return callDetails;
        },
        getCallLogFormattedDate(data)
        {
            let formattedDate ='';

            if (data.callStatus === 'completed' && data.callLink === '') {
                let ms = data.callDuration*1000,
                    date = moment.utc(ms),
                    dateMinutes = date.minutes(),
                    dateSeconds = date.seconds();

                if (dateMinutes != '00') {
                    formattedDate += dateMinutes + ' min ';
                }
                if (dateSeconds != '00') {
                    formattedDate += dateSeconds + ' sec.';
                }
            }

            return formattedDate;
        },
        getVisitFormattedDate(data) {
            let formattedDate = '';


            let ms = data.visitTotalTime * 1000,
                date = moment.utc(ms),
                dateMinutes = date.minutes(),
                dateSeconds = date.seconds();

            if (dateMinutes != '00') {
                formattedDate += dateMinutes + ' min ';
            }
            if (dateSeconds != '00') {
                formattedDate += dateSeconds + ' sec.';
            }


            return formattedDate;
        },
        async viewProfileRecord(leadId, visitId){

            let visitLogId = visitId,
                positionInGridLeadId = leadId,
                visitPageNumber = '';

            const result= await this.$store.dispatch('getLeadProfileRecord',
                {
                    'router':this.$router,
                    'visitLogId':visitLogId,
                    'calculatePositionInGrid':true,
                    'positionInGridLeadId':positionInGridLeadId,
                });

            if (typeof result.status !== 'undefined' && result.status === 'error') {
                showMessage(result.message, true, 3000);
            } else {
                visitPageNumber = result.visitPageNumber;
                this.$store.commit('setChangeMainTabRemote', {'tabName':'profile', 'visitPageNumber':parseInt(visitPageNumber)});
            }
        },
        showHideItemDetails(id)
        {
            if (typeof this.showItemDetails[id] === 'undefined') {
                this.showItemDetails[id] = id;
            } else {
                delete this.showItemDetails[id];
            }
        },
        async filterButtonClick(filterBySubType, filterByType)
        {
            if (this.filterBySubType === filterBySubType && this.filterByType === filterByType) {
                this.filterByType = '';
                this.filterBySubType = '';
            } else {
                this.filterByType = filterByType;
                this.filterBySubType = filterBySubType;
            }

            this.applyFilterData();
        },
        closeCompleteTaskDialog(completeTaskIndex)
        {
            if (this.completeTaskIndex === parseInt(completeTaskIndex)) {
                if (this.activeTimelineType === 'upcoming') {
                    this.timelineLogDataUpcoming[completeTaskIndex]['isTaskCompleted'] = 0;
                }

                if (this.activeTimelineType === 'today') {
                    this.timelineLogDataToday[completeTaskIndex]['isTaskCompleted'] = 0;
                }

                if (this.activeTimelineType === 'expired') {
                    this.timelineLogDataExpired[completeTaskIndex]['isTaskCompleted'] = 0;
                }
            }

            this.showCompleteTaskDialog = false;
        },
        async completeTask(taskId)
        {
            if (this.processingTaskCompletion === true) {
                return false;
            }

            this.processingTaskCompletion = true;

            let additionalComment = this.completeTaskComment,
                notificationEmails = this.completeTaskNotificationEmails.split(','),
                emailValidation = /^(([^<>()\[\]\.,;:\s@\"]+(\.[^<>()\[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i,
                errorStatus = false;

            if (Object.keys(notificationEmails).length === 0) {
                showMessage(this.$t('message.timelineTabPleaseSpecifyEmail'), true, 2000);
                this.processingTaskCompletion = false;
                return false;
            }

            notificationEmails.forEach((email) => {
                let status = emailValidation.test(email);
                if (status === false) {
                    showMessage(this.$t('message.timelineTabPleaseSpecifyValidEmailAddress'), true, 2000);
                    errorStatus = true;
                    this.processingTaskCompletion = false;
                    return false;
                }
            });

            const result = await this.$store.dispatch('changeTaskStatus', {
                'router': this.$router,
                'taskId': taskId,
                'isClosed': 1,
                'additionalComment': additionalComment,
                'notificationEmails': notificationEmails,
                'showSpinner':1
            });

            if (typeof result.error !== 'undefined' && parseInt(result.error) === 1) {
                this.processingTaskCompletion = false;
                return false;
            } else {
                showMessage(result.responseText, false, 2000);
                this.showCompleteTaskDialog = false;
                this.processingTaskCompletion = false;
                this.applyFilter();
            }

        },
        async completeTaskSwitch(event, taskId, index, type) {
            let isClosed = 0,
                additionalComment = '',
                notificationEmails = [],
                self = this;

            if (event.target.checked) {
                isClosed = 1;
            }

            if (isClosed === 1) {
                const result = await this.$store.dispatch('getTaskInfo', {
                    'router':this.$router,
                    'taskId':taskId
                });

                if (typeof result.error !== 'undefined' && parseInt(result.error) === 1) {
                    showMessage(result.responseText, true, false);
                    return false;
                } else {
                    this.showCompleteTaskDialog = true;
                    this.completeTaskId = taskId;
                    this.completeTaskTitle = result.responseText.title;
                    this.completeTaskNotificationEmails = result.responseText.notificationEmails;
                    this.completeTaskIndex = index;
                    this.activeTimelineType = type;
                }
            } else {
                showConfirm(this.$t('message.timelineTabArYouSureWantToReOpenTask'), async () => {
                    const result = await this.$store.dispatch('changeTaskStatus', {
                        'router':this.$router,
                        'taskId':taskId,
                        'additionalComment':additionalComment,
                        'notificationEmails':notificationEmails,
                    });

                    if (typeof result.error !== 'undefined' && parseInt(result.error) === 1) {
                        return false;
                    } else {
                        this.applyFilter();
                    }
                }, async () => {
                    if (type === 'upcoming') {
                        self.timelineLogDataUpcoming[index]['isTaskCompleted'] = 1;
                    }
                    if (type === 'today') {
                        self.timelineLogDataToday[index]['isTaskCompleted'] = 1;
                    }
                    if (type === 'expired') {
                        self.timelineLogDataExpired[index]['isTaskCompleted'] = 1;
                    }

                    self.activeTimelineType = type;
                });
            }
        },
        getRowSubType(callLogSubType)
        {
            if (typeof callLogSubType !== 'undefined' && callLogSubType !== '' && callLogSubType !== null) {
                return '-'+callLogSubType;
            }

            return '';
        },
        getMonthDate(createdAt)
        {
            return moment(createdAt, 'YYYY-MM-DD HH:mm:ss').format('MMMM');
        },
        getMeetingFormattedDate(meetingStartTimeDate)
        {
            if (meetingStartTimeDate !== '' && meetingStartTimeDate !== null) {
                return this.formatOnlyDate(meetingStartTimeDate) + ' at';
            }

            return '';
        },
        async showTranscriptDetails(callLogId, type) {

            const result = await this.$store.dispatch('getLeadCallInfo', {
                'router': this.$router,
                'callLogId': callLogId
            });

            if (typeof result.error !== 'undefined' && parseInt(result.error) === 1) {
                showMessage(result.responseText, true, false);
                return false;
            } else {
                this.currentCallSid = result.responseText.callSid;
                this.currentCallTranscription = result.responseText.callTranscription;
                this.currentCallTranscriptionDetails = result.responseText.callTranscriptionDetails;
                this.currentCallSummary = result.responseText.callSummary;
                if (type === 'summary') {
                    this.showCallSummaryDialog = true;
                } else {
                    this.showCallTranscriptDialog = true;
                }
            }
        },
        isOldFormatChat(additionalContent)
        {
            let eventOldFormat = false,
                eventData = '';

            try {
                eventData = JSON.parse(additionalContent);
            } catch (e) {
                eventOldFormat = true;
            }

            return eventOldFormat;
        },
        isOldFormatExternalEvent(additionalContent)
        {
            let eventOldFormat = false,
                eventData = '';

            try {
                eventData = JSON.parse(additionalContent);
            } catch (e) {
                eventOldFormat = true;
            }

            return eventOldFormat;
        },
        getFormatChatData(additionalContent) {
            let eventOldFormat = false,
                eventData = '';

            try {
                eventData = JSON.parse(additionalContent);
            } catch (e) {
                eventOldFormat = true;
            }

            return eventData;
        },
        closeCallTranscriptDialog()
        {
            this.showCallTranscriptDialog = false;
            this.showCallSummaryDialog = false;
        },
        async getDetailsInfoEmailConversationInfo(emailReplyId)
        {
            if (typeof this.showEmailConversation[emailReplyId] !== 'undefined') {
                if (this.showEmailConversation[emailReplyId] === true) {
                    this.showEmailConversation[emailReplyId] = false;
                } else {
                    await this.detailsInfoEmailConversationInfo(emailReplyId);
                    this.showEmailConversation[emailReplyId] = true;
                }
            } else {
                await this.detailsInfoEmailConversationInfo(emailReplyId);
                this.showEmailConversation[emailReplyId] = true;
            }
        },
        async detailsInfoEmailConversationInfo(emailReplyId)
        {
            const result = await this.$store.dispatch('getEmailConversation', {
                'router': this.$router,
                'emailReplyId': emailReplyId
            });

            if (typeof result.error !== 'undefined' && parseInt(result.error) === 1) {
                showMessage(result.responseText, true, false);
                return false;
            } else {
                this.listOfEmailConversations = result.responseText;
            }
        },
        showEmailConversationDetails(emailMessageId)
        {
            if (typeof this.showEmailConversationDetailsList[emailMessageId] !== 'undefined') {
                if (this.showEmailConversationDetailsList[emailMessageId] === true) {
                    this.showEmailConversationDetailsList[emailMessageId] = false;
                } else {
                    this.showEmailConversationDetailsList[emailMessageId] = true;
                }
            } else {
                this.showEmailConversationDetailsList[emailMessageId] = true;
            }
        },
        getQuoteLink(quoteIsDeleted, quoteLink)
        {
            if (parseInt(quoteIsDeleted) === 0) {
                return this.websiteUrl+quoteLink;
            }

            return 'javascript:;';
        }

    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.$store.commit('setPaginationData', {
            timelineLog: {
                currentPage: 1,
                itemsPerPage: 10,
                totalItems: 0,
                visiblePages: 4
            }
        });

        this.prepareFilterData();
        this.applyFilter();
    },
    async updated() {
        this.$nextTick(function () {
            window.newMonthRowExpiredTimeline = '';
            setTimeout(() => $('._lbox').magnificPopup({type: 'image'}),  100);
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
