export const getGeneralLeadsScreenData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#leads-screen-config-block', 'leads-screen-config-block-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadgridinfo/',
            'type': 'GET',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            hideSpinner('.leads-screen-config-block-spinner');
            if (response.status !== 'error') {
                commit('setConfigDataInfo', response.data);
                commit('setAdditionalInfo', response.additionalInfo);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getLeadGridData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#leads-grid-table-dashboard-table-scroll', 'lead-grid-table-body-spinner dashboard-spinner');

        $.ajax({
            'url': $('#website_url').val()+'api/leads/leads/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'limit': state.pagination.leadGrid.itemsPerPage,
                'offset': (state.pagination.leadGrid.currentPage - 1) * state.pagination.leadGrid.itemsPerPage,
                'filter': payload.searchData,
                'isGrid': 1
            }
        }).done(async  function(response){
            hideSpinner('.lead-grid-table-body-spinner');
            if (response.status !== 'error') {
                let totalRecords = 0;
                if (response.totalRecords !== null) {
                    totalRecords = response.totalRecords;
                }

                commit('setLeadGridInfo', response.data);
                commit('setPaginationData', {leadGrid: {totalItems: totalRecords}});
                commit('setTotalItemsFound', response.totalRecords);
                commit('setLeadGridAdditionalInfo', response.leadGridAdditionalInfo);
                commit('setCurrencyInfo', response.currencyInfo);
                if (typeof payload.updateOppStats !== 'undefined') {
                    commit('setUpdateOppStats', Date.now())
                }
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getLeadOrganization = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadorganization/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'filter': ''
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getLeadOrganizationQuickLead = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadorganization/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'filter': ''
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getLeadEmailQuickLead = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leads/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'email': payload.email
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getLeadByMobileQuickLead = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leads/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'mobileCountryCode': payload.mobileCountryCode,
                'mobile': payload.mobile,
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getByLeadNameZipQuickLead = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leads/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'leadFirstName': payload.leadFirstName,
                'leadLastName': payload.leadLastName,
                'leadZip': payload.leadZip,
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};


export const getLeadFilterDefaultPreset = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-grid-table-body', 'lead-grid-table-body-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadfilterdefaultpreset/',
            'type': 'GET',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            hideSpinner('.lead-grid-table-body-spinner');
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getLeadFilterPreset = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadfilterpreset/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'id': payload.id
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getEmailTemplate = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getEmailDefaultMessage/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'templateId': payload.templateId,
                'leadId': payload.leadId,
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const createQuickNewLead = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leads/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'leadEmail':payload.leadEmail,
                'prefix':payload.prefix,
                'leadFirstName':payload.leadFirstName,
                'leadLastName':payload.leadLastName,
                'leadZip':payload.leadZip,
                'organizationName':payload.organizationName,
                'lead_mobile_country_code':payload.leadMobileCountryCode,
                'leadMobile':payload.leadMobile,
                'leadSource':payload.leadSource,
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({'error' : 1, 'message':response.responseJSON});
        });
    });
};

export const saveFilterPreset = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadfilterpreset/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'filter_preset_type':payload.presetType,
                'filter_preset_name':payload.presetName,
                'is_default':payload.isDefault,
                'access':payload.access,
                'filter_preset_data':payload.presetData,
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const updateFilterPreset = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadfilterpreset/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'secureToken':$('#leads-screen-config-token').val(),
                'filter_preset_type':payload.presetType,
                'filter_preset_name':payload.presetName,
                'is_default':payload.isDefault,
                'access':payload.access,
                'filter_preset_data':payload.presetData,
                'id':payload.id
            })
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const addMeetingCommentLog = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadmeetinglog/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'secureToken':$('#leads-screen-config-token').val(),
                'id':payload.meetingLogId,
                'additional_content':payload.additionalContent,
            })
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ 'error': 1, 'message': response.responseText});
        });
    });
};

export const getLeadCallInfo = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getLeadCallInfo/callLogId/'+payload.callLogId,
            'type': 'GET',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const getEmailConversation = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getEmailConversation/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'emailReplyId':payload.emailReplyId
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const addCallDetailsLog = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadCall/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'secureToken':$('#leads-screen-config-token').val(),
                'id':payload.callLogId,
                'details':payload.additionalContent,
            })
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ 'error': 1, 'message': response.responseText});
        });
    });
};

export const changeMeetingStatus = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadmeetinglog/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'secureToken':$('#leads-screen-config-token').val(),
                'id':payload.meetingLogId,
                'type':'changeStatus',
                'status':payload.status,
            })
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ 'error': 1, 'message': response.responseText});
        });
    });
};

export const deleteLeadFilterPreset = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-additional-filters', 'lead-additional-filters-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadfilterpreset/id/'+payload.id,
            'type': 'DELETE',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            hideSpinner('.lead-additional-filters-spinner');
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getLeadStatsGridData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {

        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadsgridstats/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'dateType':'expected',
                'leadIds':payload.leadIdsString
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                let totalSpentInfo = [],
                    totalOpportunitiesInfo = [];
                if (typeof response.totalSpentInfo !== 'undefined') {
                    totalSpentInfo = response.totalSpentInfo;
                }

                if (typeof response.totalSpentInfo !== 'undefined') {
                    totalOpportunitiesInfo = response.totalOpportunitiesInfo;
                }

                commit('setSalesStats', totalSpentInfo);
                commit('setOpportunitiesStats', totalOpportunitiesInfo);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getLeadDataInfo = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#leads-screen-config-block', 'leads-screen-config-block-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leads/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'id': payload.id,
                'isGrid': 1
            }
        }).done(async  function(response){
            hideSpinner('.leads-screen-config-block-spinner');
            if (response.status !== 'error') {
                commit('setAdditionalInfoDetailedScreen', response.leadGridAdditionalInfo);
                commit('setCurrencyInfo', response.currencyInfo);
                commit('setDetailedScreenLeadData', response.leadData);
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const getLeadNotes = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-notes-list', 'lead-notes-list-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadnotes/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'lead_id': payload.leadId,
                'limit':100
            }
        }).done(async  function(response){
            hideSpinner('.lead-notes-list-spinner');
            if (response.status !== 'error') {
                commit('setNotesSubTabData', response.data);
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const getTaskTabData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-detailed-view-config-tab-task', 'lead-detailed-view-config-tab-task-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getTaskTabData/',
            'type': 'GET',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            hideSpinner('.lead-detailed-view-config-tab-task-spinner');
            if (response.status !== 'error') {
                commit('setTaskSubTabData', response);
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const getCurrentDate = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getCurrentDate/',
            'type': 'GET',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const getUserTimezone = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getUserTimezone/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'userId':payload.userId
            },
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const createMeeting = ({commit, state, dispatch}, payload) => {
    showSpinner('#lead-meeting-detailed-form', 'lead-meeting-detailed-form-spinner dashboard-spinner');
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadmeeting/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'start_time_date': payload.startTimeDate,
                'end_time_date': payload.endTimeDate,
                'location': payload.location,
                'invite_attendees': payload.inviteAttendees,
                'period': payload.period,
                'subject': payload.subject,
                'details': payload.details,
                'google_calendar': payload.googleCalendar,
                'startTime': payload.startTime,
                'endTime': payload.endTime,
                'firstNotification': payload.firstNotification,
                'secondNotification': payload.secondNotification,
                'firstNotificationUnits': payload.firstNotificationUnits,
                'secondNotificationUnits': payload.secondNotificationUnits,
                'sendSms': payload.sendSms,
                'sendNotificationSms': payload.sendNotificationSms,
                'lead_id': payload.leadId,
            }
        }).done(async  function(response){
            hideSpinner('.lead-meeting-detailed-form-spinner');
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1, message:response});
            }
        }).fail(async function(response){
            hideSpinner('.lead-meeting-detailed-form-spinner');
            resolve({ error: 1, message:response.responseJSON});
        });
    });
};

export const createMeetingManual = ({commit, state, dispatch}, payload) => {
    showSpinner('#lead-meeting-detailed-form', 'lead-meeting-detailed-form-spinner dashboard-spinner');
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadmeeting/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'start_time_date': payload.startTimeDate,
                'end_time_date': payload.endTimeDate,
                'location': payload.location,
                'invite_attendees': payload.inviteAttendees,
                'period': payload.period,
                'subject': payload.subject,
                'details': payload.details,
                'startTime': payload.startTime,
                'endTime': payload.endTime,
                'meeting_type': payload.meetingType,
                'manualMeeting': payload.manualMeeting,
                'meetingStatus': payload.meetingStatus,
                'additionalNotes': payload.additionalNotes,
                'lead_id': payload.leadId,
            }
        }).done(async  function(response){
            hideSpinner('.lead-meeting-detailed-form-spinner');
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1, message:response});
            }
        }).fail(async function(response){
            hideSpinner('.lead-meeting-detailed-form-spinner');
            resolve({ error: 1, message:response.responseJSON});
        });
    });
};

export const getEmailTabData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-detailed-view-config-tab-email', 'lead-detailed-view-config-tab-email-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getEmailTabData/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'lead_id':payload.leadId,
                'skipSelectFolder':1
            }
        }).done(async  function(response){
            hideSpinner('.lead-detailed-view-config-tab-email-spinner');
            if (response.status !== 'error') {
                commit('setEmailSubTabData', response);
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const getSmsTabData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-detailed-view-config-tab-sms', 'lead-detailed-view-config-tab-sms-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadsms/',
            'type': 'GET',
            'dataType': 'json',
            'data': {'lead_id':payload.leadId}
        }).done(async  function(response){
            hideSpinner('.lead-detailed-view-config-tab-sms-spinner');
            if (response.status !== 'error') {
                commit('setSmsSubTabData', response);
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const getOpportunitySubTabData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-tab-opportunity-form', 'lead-tab-opportunity-form-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadopportunity/',
            'type': 'GET',
            'dataType': 'json',
            'data': {'lead_id':payload.leadId, 'excludeEmptyOpportunityStages':payload.excludeEmptyOpportunityStages}
        }).done(async  function(response){
            hideSpinner('.lead-tab-opportunity-form-spinner');
            if (response.status !== 'error') {
                commit('setOpportunitySubTabData', response);
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const getLeadCustomSubTabData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        if (!payload.skipSpinner) {
            showSpinner('#lead-detailed-view-config-tab-custom-fields-tabs', 'lead-detailed-view-config-tab-custom-fields-tabs-spinner dashboard-spinner');
        }
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadcustomparams/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'leadId':payload.leadId,
                'grid':true,
                'customTabId':payload.customTabId,
                'count':true,
                'limit':3000,
                'offset':0,
            }
        }).done(async  function(response){
            if (!payload.skipSpinner) {
                hideSpinner('.lead-detailed-view-config-tab-custom-fields-tabs-spinner');
            }
            if (response.status !== 'error') {
                commit('setCustomAttrSubTabData', response.data);
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            if (!payload.skipSpinner) {
                hideSpinner('.lead-detailed-view-config-tab-custom-fields-tabs-spinner');
            }
            resolve({ error: 1});
        });
    });
};

export const createCustomAttribute = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadcustomparams/',
            'type': 'POST',
            'dataType': 'json',
            'data': JSON.stringify({
                'secureToken':$('#leads-screen-config-token').val(),
                'lead_id': payload.leadId,
                'param_value': payload.paramValue,
                'param_id': payload.paramId,
                'param_type': payload.paramType,
            })
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1, 'message':response.responseJSON});
        });
    });
};


export const updateCustomAttribute = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadcustomparams/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'secureToken':$('#leads-screen-config-token').val(),
                'lead_id': payload.leadId,
                'id':payload.id,
                'param_value': payload.paramValue,
                'param_id': payload.paramId,
                'param_type': payload.paramType,
            })
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1, 'message':response.responseJSON});
        });
    });
};


export const getQuoteTemplates = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getQuoteNames/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'searchTerm':payload.searchTerm
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const createNewOpportunity = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-tab-opportunity-form', 'lead-tab-opportunity-form-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadopportunity/id/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'lead_id': payload.leadId,
                'opportunity_stage_id': payload.opportunityStageId,
                'opportunity_value': payload.opportunityValue,
                'created_at': payload.createdAt,
                'expected_close_date': payload.expectedCloseDate,
                'opportunity_name': payload.opportunityName,
                'opportunity_type_id': payload.opportunityTypeId,
                'duplicate_quote_id': payload.duplicateQuoteId
            }
        }).done(async  function(response){
            hideSpinner('.lead-tab-opportunity-form-spinner');
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            hideSpinner('.lead-tab-opportunity-form-spinner');
            resolve({ error: 1, 'message':response.responseJSON});
        });
    });
};

export const updateOpportunity = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-tab-opportunity-form', 'lead-tab-opportunity-form-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadopportunity/id/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'secureToken':$('#leads-screen-config-token').val(),
                'lead_id': payload.leadId,
                'opportunity_stage_id': payload.opportunityStageId,
                'opportunity_value': payload.opportunityValue,
                'created_at': payload.createdAt,
                'expected_close_date': payload.expectedCloseDate,
                'opportunity_name': payload.opportunityName,
                'opportunity_type_id': payload.opportunityTypeId,
                'duplicate_quote_id': payload.duplicateQuoteId,
                'id':payload.opportunityId
            })
        }).done(async  function(response){
            hideSpinner('.lead-tab-opportunity-form-spinner');
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            hideSpinner('.lead-tab-opportunity-form-spinner');
            resolve({ error: 1, 'message':response.responseJSON});
        });
    });
};

export const createQuoteForOpportunity = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-tab-opportunity-quote-form', 'lead-tab-opportunity-quote-form-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadquote/id/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'lead_id': payload.leadId,
                'opportunity_id': payload.opportunityId,
                'quote_title': payload.quoteTitle,
                'duplicate_quote_id': payload.duplicateQuoteId,
            }
        }).done(async  function(response){
            hideSpinner('.lead-tab-opportunity-quote-form-spinner');
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            hideSpinner('.lead-tab-opportunity-quote-form-spinner');
            resolve({ error: 1, 'message':response.responseJSON});
        });
    });
};


export const sendEmailFromEmailTab = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-email-form', 'lead-email-form-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/sendEmail/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'leadId': payload.leadId,
                'lead-email-from': payload.leadEmailFrom,
                'lead-email-to': payload.leadEmailTo,
                'lead-email-bcc-to': payload.leadEmailBccTo,
                'lead-email-subject': payload.leadEmailSubject,
                'lead-email-template': payload.leadEmailTemplate,
                'lead-email-follow-up-sequences': payload.leadEmailFollowUpSequences,
                'emailContent': payload.emailContent,
                'testEmail': payload.testEmail,
            }
        }).done(async  function(response){
            hideSpinner('.lead-email-form-spinner');
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const logManualCall = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-call-form', 'lead-call-form-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/manualCallLead/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'leadId': payload.leadId,
                'call-device-type': payload.callDeviceType,
                'lead-call-country-code': payload.leadCallCountryCode,
                'lead-call-number': payload.leadCallNumber,
                'call-from-device-type': payload.callFromDeviceType,
                'call-notes': payload.callNotes,
                'call-duration-dropdown': payload.callDurationDropdown,
                'call-duration-manual': payload.callDurationManual
            }
        }).done(async  function(response){
            hideSpinner('.lead-call-form-spinner');
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1, 'message':response.responseJSON});
        });
    });
};

export const callLeadSubTab = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-call-form', 'lead-call-form-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/callLead/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'leadId': payload.leadId,
                'call-device-type':payload.callDeviceType,
                'lead-call-country-code':payload.leadCallCountryCode,
                'lead-call-number':payload.leadCallNumber,
                'call-from-device-type': payload.callFromDeviceType,
                'call-notes': payload.callNotes,
                'call-duration-dropdown': payload.callDurationDropdown,
                'call-duration-manual': payload.callDurationManual
            }
        }).done(async  function(response){
            hideSpinner('.lead-call-form-spinner');
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1, 'message':response.responseJSON});
        });
    });
};

export const sendSmsFromEmailTab = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-email-form', 'lead-email-form-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadsms/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'leadId': payload.leadId,
                'call-device-type': payload.callDeviceType,
                'lead-call-country-code': payload.leadCallCountryCode,
                'lead-call-number': payload.leadCallNumber,
                'lead-sms-follow-up-sequences': payload.leadSmsFollowUpSequences,
                'smsContent': payload.smsContent,
                'testSms': payload.testSms,
                'mediaFiles':payload.mediaFiles
            }
        }).done(async  function(response){
            hideSpinner('.lead-email-form-spinner');
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1, 'message':response.responseJSON});
        });
    });
};

export const deleteSmsFile = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        let mmsMassAction = 0;
        if(payload.mmsMassAction) {
            mmsMassAction = 1;
        }

        $.ajax({
            'url':  $('#website_url').val()+'api/leads/leadmms/leadId/'+payload.leadId+'/fileName/'+payload.fileName+'/fileSize/'+payload.fileSize+'/generalFileSize/'+payload.generalFileSize+'/mmsMassAction/'+mmsMassAction,
            'type': 'DELETE',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};


export const loadImages = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-email-images-block', 'lead-email-images-block-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/loadImages/',
            'type': 'POST',
            'dataType': 'json',
            'data': {'folderName':payload.folderName, 'associativeFlag':payload.associativeFlag}
        }).done(async  function(response){
            hideSpinner('.lead-email-images-block-spinner');
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const loadFiles = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/loadFiles/',
            'type': 'POST',
            'dataType': 'json',
            'data': {'folder':payload.folderName, 'associativeFlag':payload.associativeFlag}
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const getTaskInfo = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getTaskInfo/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'taskId': payload.taskId
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1, 'message':response.responseJSON});
        });
    });
};

export const changeTaskStatus = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        if (parseInt(payload.showSpinner) === 1) {
            showSpinner('#lead-timeline-task-completed-dialog-complete-task', 'lead-timeline-task-completed-dialog-complete-task-spinner dashboard-spinner');
        }

        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/changeTaskStatus/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'isClosed':payload.isClosed,
                'taskId':payload.taskId,
                'additionalComment':payload.additionalComment,
                'notificationEmails':payload.notificationEmails,
            }
        }).done(async  function(response){
            if (parseInt(payload.showSpinner) === 1) {
                hideSpinner('.lead-timeline-task-completed-dialog-complete-task-spinner');
            }
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            if (parseInt(payload.showSpinner) === 1) {
                hideSpinner('.lead-timeline-task-completed-dialog-complete-task-spinner');
            }
            resolve({ error: 1});
        });
    });
};

export const createLeadTask = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadtask/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'title': payload.title,
                'user_id': payload.userId,
                'timezone_full': payload.timezoneFull,
                'expired_at': payload.expiredAt,
                'due_date': payload.dueDate,
                'lead_id': payload.leadId,
                'notes': payload.notes,
                'immediate': payload.immediate,
                'immediateEmail': payload.immediateEmail,
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1, message:response});
            }
        }).fail(async function(response){
            resolve({ error: 1, message:response.responseJSON});
        });
    });
};

export const deleteNote = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadnotes/id/'+payload.id,
            'type': 'DELETE',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const addNote = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadnotes/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'lead_id': payload.leadId,
                'note': payload.note,
                'withResult': 1,
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const documentsSubTab = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-documents-body', 'lead-documents-body-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leaddocuments/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'lead_id': payload.leadId,
                'limit': state.pagination.documentsGrid.itemsPerPage,
                'offset': (state.pagination.documentsGrid.currentPage - 1) * state.pagination.documentsGrid.itemsPerPage,
                'count': true
            }
        }).done(async  function(response){
            hideSpinner('.lead-documents-body-spinner');
            if (response.status !== 'error') {
                let totalRecords = 0;
                if (response.totalRecords !== null) {
                    totalRecords = response.totalRecords;
                }

                commit('setDocumentsSubTabData', response.data);
                commit('setPaginationData', {documentsGrid: {totalItems: totalRecords}});
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            hideSpinner('.lead-documents-body-spinner');
            resolve({ error: 1, 'message':response.responseJSON});
        });
    });
};

export const deleteDocument = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leaddocuments/id/'+payload.id,
            'type': 'DELETE',
            'dataType': 'json',
            'data': {}
        }).done(async function(response){
            if (response === null) {
                response = { 'error': 0}
            }
            resolve(response);
        }).fail(async function(response){
            resolve({ 'error': 1, 'message':response.responseJSON});
        });
    });
};


export const validateLeadEmail = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/validateEmail/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'leadId': payload.leadId
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const saveSocialServiceLink = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadhassocialservice/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'secureToken':$('#leads-screen-config-token').val(),
                'lead_id': payload.leadId,
                'service_id': payload.serviceId,
                'service_link': payload.serviceLink,
            })
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};


export const getLeadTag = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadtags/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'id': payload.id,
                'searchByTagName': payload.tagName
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const addNewLeadTag = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadtags/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'lead_id' :payload.leadId,
                'tag_name':payload.tagName,
                'label':payload.label,
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const unAttachTagToLead = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadhastags/lead_id/'+payload.leadId+'/tag_id/'+payload.tagId,
            'type': 'DELETE',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const attachTagToLead = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadhastags/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'lead_id': payload.leadId,
                'tag_id': payload.tagId,
                'secureToken':$('#leads-screen-config-token').val()
            })
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const sendNpsReviewRequestAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/sendNpsReviewRequest/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'leadId' :payload.leadId,
                'sendRequestAgain':payload.sendRequestAgain
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const sendReviewRequestAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/sendReviewRequest/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'leadId' :payload.leadId,
                'sendRequestAgain':payload.sendRequestAgain
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const saveReviewRequestManualAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/saveReviewRequestManual/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'leadId' :payload.leadId,
                'reviewDate':payload.reviewDate,
                'reviewPlatform':payload.reviewPlatform,
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const getLeadOrganizations = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadorganization/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'searchTerm': payload.searchTerm
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getLeadSource = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadsource/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'searchTerm': payload.searchTerm,
                'autocomplete':payload.autocomplete
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getLeadSources = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadsource/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'searchTerm': payload.searchTerm,
                'autocomplete':true
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const assignLeadOwner = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/assignLeadOwner/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'leadIds' :payload.leadIds,
                'leadOwnerId':payload.leadOwnerId
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const updatePreset = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/tablecolumnorder/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'id': payload.id,
                'isDefault': payload.isDefault,
                'secureToken':$('#leads-screen-config-token').val(),
                'tableName':payload.tableName
            })
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const updateParam = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leads/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'id': payload.id,
                'secureToken':$('#leads-screen-config-token').val(),
                'data':payload.data
            })
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ 'error': 1, 'message': response.responseText});
        });
    });
};

export const logRecentlyViewed = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/logLastViewed/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'id' :payload.id,
                'type':payload.type
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const saveColumnTableOrder = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/tablecolumnorder/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'tableName': payload.tableName,
                'tableColumnOrder': payload.tableColumnOrder,
                'applyToAll': payload.applyToAll,
                'secureToken':$('#leads-screen-config-token').val(),
                'presetName' :payload.presetName,
                'presetId' :payload.presetId,
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const deletePreset = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#latest-leads-block', 'latest-leads-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/tablecolumnorder/id/'+payload.id,
            'type': 'DELETE',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            hideSpinner('.latest-leads-spinner');
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const callLead = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#call-window-dialog', 'call-window-dialog-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val() + 'plugin/leads/run/callLead/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' :  $('#leads-screen-config-token').val(),
                'leadId':payload.leadId,
                'lead-call-country-code':payload.leadCallCountryCode,
                'lead-call-number':payload.leadCallNumber,
                'call-from-device-type':payload.callFromDeviceType
            }
        }).done(async function (response) {
            hideSpinner('.call-window-dialog-spinner');
            resolve(response);
        }).fail(async function(response){
            hideSpinner('.call-window-dialog-spinner');
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const sendSms = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        //showSpinner('#lead-sms-form', 'lead-sms-form-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val() + 'plugin/leads/run/sendSms/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' :  $('#leads-screen-config-token').val(),
                'leadIds':payload.leadIds,
                'filters':payload.filters,
                'matchingFilter':payload.matchingFilter,
                'stepSendSms':payload.stepSendSms,
                'filterQuantity':payload.filterQuantity,
                'smsMessage':payload.smsMessage,
                'uniqueMobilesNumbers':payload.uniqueMobilesNumbers,
                'testSms':payload.testSms,
                'mediaFiles':payload.mediaFiles,
                'filterAsArray':payload.filterAsArray
            }
        }).done(async function (response) {
            //hideSpinner('.lead-sms-form-spinner');
            resolve(response);
        }).fail(async function(response){
            //hideSpinner('.lead-sms-form-spinner');
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const countLeadsMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        let uniqueEmail = 0,
            validateEmailBalance = 0,
            additionalParams = 0,
            advertising = 0;

        if(payload.uniqueEmail) {
            uniqueEmail = 1;
        }

        if(payload.validateEmailBalance) {
            validateEmailBalance = 1;
        }

        if(payload.additionalParams) {
            additionalParams = payload.additionalParams;
        }

        if(payload.advertising) {
            advertising = payload.advertising;
        }

        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/countAllLeads/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' :  $('#leads-screen-config-token').val(),
                'filters': payload.filters,
                'leadIds':payload.leadIds,
                'existMobileNumber': payload.existMobileNumber,
                'filterAsArray':1,
                'uniqueEmail':uniqueEmail,
                'validateEmailBalance':validateEmailBalance,
                'additionalParams':additionalParams,
                'advertising':advertising,
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const deleteLead = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-grid-table-block', 'lead-grid-table-block-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leads/id/'+payload.leadId,
            'type': 'DELETE',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            hideSpinner('.lead-grid-table-block-spinner');
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const deleteAndMarkAsSpamLead = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-grid-table-block', 'lead-grid-table-block-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leads/id/'+payload.leadId+'/deleteAndMarkAsSpam/1/',
            'type': 'DELETE',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            hideSpinner('.lead-grid-table-block-spinner');
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};


export const getTimelineLogData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#'+payload.spinnerId, payload.spinnerId+'-spinner dashboard-spinner');

        let limit = 10,
            offset = 0;

        if (payload.timelineType === '') {
            limit = state.pagination.timelineLog.itemsPerPage;
            offset = (state.pagination.timelineLog.currentPage - 1) * state.pagination.timelineLog.itemsPerPage;
            commit('setShowSpinnerTimelineExpiredSpinnerId', true);
        } else if (payload.timelineType === 'today'){
            limit = 10;
            offset = 0;
            commit('setShowSpinnerTimelineTodaySpinnerId', true);
        } else if (payload.timelineType === 'upcoming'){
            limit = 10;
            offset = 0;
            commit('setShowSpinnerTimeilineUpcomingSpinnerId', true);
        }

        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadstimeline/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'limit': limit,
                'offset': offset,
                'filter': payload.filter,
                'count': true,
                'timelineType': payload.timelineType,
                'leadId': payload.leadId,
                'organizationId': payload.organizationId,
            }
        }).done(async  function(response){
            hideSpinner('.'+payload.spinnerId+'-spinner');
            if (response.status !== 'error') {
                let totalRecords = 0;
                if (response.totalRecords !== null) {
                    totalRecords = response.totalRecords;
                }

                if (payload.timelineType === '') {
                    commit('setTimelineLogDataExpired', response.data);
                    commit('setPaginationData', {timelineLog: {totalItems: totalRecords}});
                    commit('setShowSpinnerTimelineExpiredSpinnerId', false);
                }

                if (payload.timelineType === 'today') {
                    commit('setTimelineLogDataToday', response.data);
                    commit('setShowSpinnerTimelineTodaySpinnerId', false);
                }

                if (payload.timelineType === 'upcoming') {
                    commit('setTimelineLogDataUpcoming', response.data);
                    commit('setShowSpinnerTimeilineUpcomingSpinnerId', false);
                }

                resolve(response);
            } else {
                resolve({ 'error': 1, 'message': response.responseText});
            }
        }).fail(async function(response){
            hideSpinner('.'+payload.spinnerId+'-spinner');
            resolve({ 'error': 1, 'message': response.responseText});
        });
    });
};

export const getLeadProfileRecord = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadprofile/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'visitLogId': payload.visitLogId,
                'calculatePositionInGrid': payload.calculatePositionInGrid,
                'positionInGridLeadId': payload.positionInGridLeadId,
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const getLeadProfileVisit = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadprofilevisit/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'userProfileLogId': payload.userProfileLogId,
                'count': true,
                'limit': 100,
                'offset': 0,
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

export const getProfileTabData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        if (payload.spinnerId) {
            showSpinner(payload.spinnerId, 'lead-detailed-view-statistics-tab-profile-spinner dashboard-spinner');
        } else {
            showSpinner('#lead-detailed-view-statistics-tab-profile', 'lead-detailed-view-statistics-tab-profile-spinner dashboard-spinner');
        }

        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadprofile/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'limit': state.pagination.profileLog.itemsPerPage,
                'offset': (state.pagination.profileLog.currentPage - 1) * state.pagination.profileLog.itemsPerPage,
                'leadId': payload.leadId,
                'count': true
            }
        }).done(async  function(response){
            hideSpinner('.lead-detailed-view-statistics-tab-profile-spinner');
            if (response.status !== 'error') {
                let totalRecords = 0;
                if (response.totalRecords !== null) {
                    totalRecords = response.totalRecords;
                }

                commit('setProfileLogData', response.data);
                commit('setPaginationData', {profileLog: {totalItems: totalRecords}});
                commit('setProfileTableOffset', (state.pagination.profileLog.currentPage - 1) * state.pagination.profileLog.itemsPerPage);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            hideSpinner('.lead-detailed-view-statistics-tab-profile-spinner');
            resolve({ error: 1,  'message': response.responseText});
        });
    });
};

export const getOpportunityTabData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        if (!payload.skipSpinner) {
            if (payload.spinnerId) {
                showSpinner(payload.spinnerId, 'lead-detailed-view-statistics-tab-opportunity-spinner dashboard-spinner');
            } else {
                showSpinner('#lead-detailed-view-statistics-tab-opportunity', 'lead-detailed-view-statistics-tab-opportunity-spinner dashboard-spinner');
            }
        }

        $.ajax({
            'url': $('#website_url').val()+'api/leads/opportunitytimeline/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'limit': state.pagination.opportunitiesLog.itemsPerPage,
                'offset': (state.pagination.opportunitiesLog.currentPage - 1) * state.pagination.opportunitiesLog.itemsPerPage,
                'lead_id': payload.leadId,
                'count': true,
                'order':payload.orderBy,
                'filter':payload.filter,
            }
        }).done(async  function(response){
            hideSpinner('.lead-detailed-view-statistics-tab-opportunity-spinner');
            if (response.status !== 'error') {
                let totalRecords = 0;
                if (response.totalRecords !== null) {
                    totalRecords = response.totalRecords;
                }

                commit('setOpportunitiesData', response.data);
                commit('setPaginationData', {opportunitiesLog: {totalItems: totalRecords}});
                resolve(response);
            } else {
                resolve({ error: 1,  'message': ''});
            }
        }).fail(async function(response){
            hideSpinner('.lead-detailed-view-statistics-tab-opportunity-spinner');
            resolve({ error: 1,  'message': response.responseText});
        });
    });
};

export const changeQuoteOwner = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/quote/run/changeQuoteOwner/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'quoteOwnerId':payload.quoteOwnerId,
                'id':payload.quoteId,
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({'error' : 1, 'message':response.responseText});
        });
    });
};

export const assignExistedQuoteOpportunuty = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/assignExistedQuoteOpportunuty/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'quote_id':payload.quoteId,
                'opportunity_id':payload.opportunityId,
                'lead_id':payload.leadId,
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({'error' : 1, 'message':response.responseText});
        });
    });
};

export const deleteOpportunity = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadopportunity/id/'+payload.opportunityId,
            'type': 'DELETE',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            console.log(response.responseJSON);
            resolve({ error: 1,  'message': response.responseJSON});
        });
    });
};

export const deleteQuote = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/quote/quotes/id/'+payload.quoteId,
            'type': 'DELETE',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1,  'message': response.responseJSON});
        });
    });
};

export const deleteIpAddress = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#profile-list-ips', 'profile-list-ips-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadip/leadId/'+payload.leadId+'/ipAddress/'+payload.ipAddress,
            'type': 'DELETE',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            hideSpinner('.profile-list-ips-spinner');
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1,  'message': response.responseText});
        });
    });
};

export const addIpAddress = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadip/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'leadId':payload.leadId,
                'ipAddress':payload.ipAddress,
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({'error' : 1, 'message':response.responseText});
        });
    });
};

export const getLeadProfile = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadprofile/map/true/leadId/'+payload.leadId,
            'type': 'GET',
            'dataType': 'json',
            'data': {
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getLeadEmailSequenceData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-email-sequence-list', 'lead-email-sequence-list-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leademailsequence/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'count':true,
                'limit':100,
                'offset':0,
                'leadId':payload.leadId
            }
        }).done(async  function(response){
            hideSpinner('.lead-email-sequence-list-spinner');
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1,  'message': response.responseText});
        });
    });
};

export const getLeadEmailSequenceLogData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-sequence-log-table-body', 'lead-sequence-log-table-body-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leademailsequencelog/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'count':true,
                'limit':100,
                'offset':0,
                'leadId':payload.leadId,
                'fromYear':payload.fromYear,
                'fromMonth':payload.fromMonth,
            }
        }).done(async  function(response){
            hideSpinner('.lead-sequence-log-table-body-spinner');
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1,  'message': response.responseText});
        });
    });
};

export const deleteLeadEmailSequence = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leademailsequence/lead_id/'+payload.leadId+'/sequence_id/'+payload.sequenceId,
            'type': 'DELETE',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1,  'message': response.responseText});
        });
    });
};

export const addLeadEmailSequence = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leademailsequence/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'sequence_id':payload.sequenceId,
                'lead_id':payload.leadId,
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
             resolve({'error' : 1, 'message':response.responseJSON});
        });
    });
};

export const unsubscribeEmailSequence = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leademailsequence/lead_id/'+payload.leadId+'/sequence_id/'+payload.sequenceId+'/unsubscribeFlag/unsubscribeFlag',
            'type': 'DELETE',
            'dataType': 'json',
            'data': {}
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1,  'message': response.responseText});
        });
    });
};

export const subscribeEmailSequence = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/subscribe',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'leadId':payload.leadId
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({'error' : 1, 'message':response.responseJSON});
        });
    });
};

export const getCurrentMonthAndYearEmailSmsTable = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#lead-sequence-log-table-body', 'lead-sequence-log-table-body-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getCurrentMonthAndYear/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
            }
        }).done(async  function(response){
            hideSpinner('.lead-sequence-log-table-body-spinner');
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1,  'message': response.responseText});
        });
    });
};

export const sendCartStatusQueueEmail = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/sendCartStatusQueueEmail/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'queueId':payload.queueId,
                'secureToken':$('#leads-screen-config-token').val(),
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ error: 1,  'message': response.responseText});
        });
    });
};

export const deleteSequence = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/deleteSequence/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'sequenceId':payload.sequenceId,
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getLeadCustomData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        if (!payload.skipSpinner) {
            showSpinner('#lead-detailed-view-statistics-tab-custom-params', 'lead-detailed-view-statistics-tab-custom-params-spinner dashboard-spinner');
        }
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadcustomparams/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'leadId':payload.leadId,
                'grid':true,
                'customTabId':'',
                'count':true,
                'limit':3000,
                'offset':0,
            }
        }).done(async  function(response){
            if (!payload.skipSpinner) {
                hideSpinner('.lead-detailed-view-statistics-tab-custom-params-spinner');
            }
            if (response.status !== 'error') {
                commit('setCustomAttributesData', response.data);
                resolve(response);
            } else {
                resolve({ error: 1});
            }
        }).fail(async function(response){
            if (!payload.skipSpinner) {
                hideSpinner('.lead-detailed-view-statistics-tab-custom-params-spinner');
            }
            resolve({ error: 1});
        });
    });
};

//Add tags for leads mass-action
export const getLeadTagsMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/addTags/leadsIds/'+ payload.leadIds,
            'type': 'GET',
            'dataType': 'json'
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

//Add tags for leads mass-action
export const getAllLeadsMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getAllLeads/allLeads/allLeads',
            'type': 'GET',
            'dataType': 'json'
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

//Add tags for leads mass-action
export const getAllTagsFilterLeadsMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getAllTagsFilterLeads/allTagsFilterLeads/allTagsFilterLeads',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' :  $('#leads-screen-config-token').val(),
                'leadIds':payload.leadIds,
                'filters':payload.filters,
                'preParseParams':0,
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

//Add tags for leads mass-action
export const addLeadTagsMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        let allRecords = 0;
        if(payload.allRecords) {
            allRecords = 1;
        }

        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/addTags/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' :  $('#leads-screen-config-token').val(),
                'tagsIds':payload.tagsIds,
                'leadIds':payload.leadIds,
                'tagsFunction':payload.tagsFunction,
                'filters':payload.filters,
                'tagsType':payload.tagsType,
                'allRecords':allRecords,
                'offset':payload.offset,
                'preParseParams':0,
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

//Assign/unassign email/sms sequence mass-action
export const getEmailSequencesMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/emailSequence/'+ 'notIdAssoc/1',
            'type': 'GET',
            'dataType': 'json'
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

//Assign/unassign email/sms sequence mass-action
export const assignUnassignEmailSequenceMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/emailSequence/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' :  $('#leads-screen-config-token').val(),
                'leadEmailSequenceId': payload.leadEmailSequenceId,
                'leadIds':payload.leadIds,
                'filters':payload.filters,
                'allFilterLeads':payload.allFilterLeads,
                'requestType':payload.requestType,
                'offset':payload.offset,
                'filterAsArray':1
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

//Change lead owner mass-action
export const getLeadOwnersMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getTaskTabData/',
            'type': 'GET',
            'dataType': 'json'
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

//Change lead owner mass-action
export const assignLeadOwnerMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/assignLeadOwner/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' :  $('#leads-screen-config-token').val(),
                'leadOwnerId': payload.leadOwnerId,
                'leadIds':payload.leadIds,
                'filters':payload.filters,
                'allOwnerFilterLeads':payload.allOwnerFilterLeads,
                'filterAsArray':1
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

//Merge leads mass-action
export const getLeadsDataMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getLeadsInfo/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'checkedLeads':payload.checkedLeads
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

//Merge leads mass-action
export const mergeLeadsMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/mergeMassLeads/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' :  $('#leads-screen-config-token').val(),
                'leadIds':payload.leadIds,
                'leadMergeToId':payload.leadMergeToId,
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

//Export leads mass-action
export const getExportLeadsTabDataMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getExportLeadsTabData/',
            'type': 'GET',
            'dataType': 'json'
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

//Delete leads/Mark as spam mass-action
export const deleteMassLeadsMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        let markAsSpam = 0;
        if(payload.markAsSpam) {
            markAsSpam = 1;
        }

        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/deleteMassLeads/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' :  $('#leads-screen-config-token').val(),
                'leadIds':payload.leadIds,
                'step':payload.step,
                'filters':payload.filters,
                'matchingFilter':payload.matchingFilter,
                'filterQuantity':payload.filterQuantity,
                'filterAsArray':1,
                'markAsSpam':markAsSpam,
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

//Validate lead emails mass-action
export const validateLeadEmailsMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/validateLeadEmails/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' :  $('#leads-screen-config-token').val(),
                'leadIds':payload.leadIds,
                'filters':payload.filters,
                'matchingFilter':payload.matchingFilter,
                'stepSendEmailService':payload.stepSendEmailService,
                'filterQuantity':payload.filterQuantity,
                'filterAsArray':1,
            }
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({'error' : 1, 'message':response.responseJSON.responseText});
        });
    });
};

//Add to/remove from email list mass-action
export const getEnabledAppsServicesMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getEnabledAppsServices/serviceType/email/customers/'+payload.customerIds,
            'type': 'GET',
            'dataType': 'json'
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

//Add to/remove from email list mass-action
export const getAppsServiceMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getAppsService/serviceName/'+payload.serviceName,
            'type': 'GET',
            'dataType': 'json'
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

//Add to/remove from email list mass-action
export const sendToEmailServiceMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'plugin/leads/run/sendToEmailService/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' :  $('#leads-screen-config-token').val(),
                'emailServiceName': payload.emailServiceName,
                'lists': payload.lists,
                'listsLabels': payload.listsLabels,
                'leadIds':payload.leadIds,
                'detailedInfo': payload.detailedInfo,
                'filters':payload.filters,
                'matchingFilter': payload.matchingFilter,
                'stepSendEmailService' : payload.stepSendEmailService,
                'invalidLeads': payload.invalidLeads,
                'filterQuantity': payload.filterQuantity,
                'requestType': payload.requestType,
                'filterAsArray':1,
            }
        }).done(async function (response) {
            resolve(response);
        }).fail(async function(response){
            resolve({'error' : 1, 'message':response.responseJSON.responseText});
        });
    });
};

//Add to/remove from Ad audience list mass-action
export const getAdvertisingServiceMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getAdvertisingService/serviceName/'+payload.serviceName,
            'type': 'GET',
            'dataType': 'json'
        }).done(async  function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ error: 1});
        });
    });
};

//Add to/remove from Ad audience list mass-action
export const addAdvertiserlistMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'plugin/leads/run/addAdvertiserlist/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' :  $('#leads-screen-config-token').val(),
                'listName': payload.listName,
                'account': payload.account,

            }
        }).done(async function (response) {
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

//Add to/remove from Ad audience list mass-action
export const sendToRemarketingListMassAction = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'plugin/leads/run/sendToRemarketingList/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' :  $('#leads-screen-config-token').val(),
                'marketingCampaignsName': payload.marketingCampaignsName,
                'lists': payload.lists,
                'listsLabels': payload.listsLabels,
                'leadIds':payload.leadIds,
                'filters' : payload.filters,
                'matchingFilter': payload.matchingFilter,
                'stepToRemarketingListService' : payload.stepToRemarketingListService,
                'accountErrors': payload.accountErrors,
                'filterQuantity': payload.filterQuantity,
                'requestType': payload.requestType,
                'filterAsArray':1,
            }
        }).done(async function (response) {
            resolve(response);
        }).fail(async function(response){
            resolve({'error' : 1, 'message':response.responseJSON.responseText});
        });
    });
};

export const generateAiEmailReply = ({commit, state, dispatch}, payload) => {
    showSpinner('#lead-email-tab-textarea-block', 'lead-email-tab-textarea-block-spinner dashboard-spinner');

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadaiemailreply/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'leadId':payload.leadId,
                'emailContent':payload.emailContent,
            }
        }).done(async  function(response){
            hideSpinner('.lead-email-tab-textarea-block-spinner');
            resolve(response);
        }).fail(async function(response){
            hideSpinner('.lead-email-tab-textarea-block-spinner');
            resolve({'error' : 1, 'message':response.responseJSON});
        });
    });
};

export const generateAiSentiment = ({commit, state, dispatch}, payload) => {
    showSpinner('#lead-additional-information-sentiment', 'lead-additional-information-sentiment-spinner dashboard-spinner');

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadaisentiment/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken':$('#leads-screen-config-token').val(),
                'leadId':payload.leadId
            }
        }).done(async  function(response){
            hideSpinner('.lead-additional-information-sentiment-spinner');
            resolve(response);
        }).fail(async function(response){
            hideSpinner('.lead-additional-information-sentiment-spinnerr');
            resolve({'error' : 1, 'message':response.responseJSON});
        });
    });
};

