define([
    'backbone',
    '../collections/lead-stage.js',
    'text!../templates/paginator.html',
    'text!../templates/stage-row.html',
    'i18n!../../../nls/config_'+$('#lead-stage-leads-config-system-language').val()+'_ln.js'
], function(Backbone,
            LeadsStageCollection, PaginatorTmpl, StageRowTmpl, i18n
){

    var LeadStageGridView = Backbone.View.extend({
        el: $('#lead-stage-grid-table'),
        events: {
            'click a[data-role=delete]': 'deleteLeadStage',
            'blur .lead-stage-edit-attribute': 'editLeadStage',
            'click td.lead-stage-grid-paginator a.page': 'navigate'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options){
            this.leadStages = new LeadsStageCollection();
            this.$el =  $('#lead-stage-grid-table');
            this.leadStages.on('reset', this.renderLeadStages, this);
            this.leadStages.on('add', this.renderLeadStages, this);
            this.leadStages.on('destroy', this.renderLeadStages, this);
        },
        render: function(){
            this.leadStages.pager();
        },
        renderLeadStages: function(){
            this.$el.find('tbody').empty();
            this.leadStages.each(this.renderLeadStage, this);
            this.leadStages.info()['i18n'] = i18n;
            if((this.leadStages.length == 0) && (this.leadStages.currentPage != 0)){
                this.leadStages.requestPreviousPage();
            }
            this.$('td.lead-stage-grid-paginator').html(this.templates.paginator(this.leadStages.information));
        },
        renderLeadStage: function(leadsStageData){
            this.$el.find('tbody').append(_.template(StageRowTmpl, {'leadsStageData': leadsStageData}));
            return false;
        },
        editLeadStage: function(e){
            var el = $(e.currentTarget),
                currentValue = el.val(),
                oldValue = el.data('old-value'),
                leadStageId = el.closest('tr').data('lead-stage-id'),
                leadStageModel = this.leadStages.get(leadStageId),
                attrName =  el.data('attrName');

            if (currentValue != oldValue) {
                el.data('old-value', currentValue);
                leadStageModel.set(attrName, currentValue);
                leadStageModel.set('secureToken', $('#lead-stage-secure-token').val());
                leadStageModel.save(null, {
                    success: function(model, response){
                        $('#default-lead-stage option[value="'+ leadStageId +'"]').text(currentValue);
                        showMessage(response.responseText, false, 5000);
                    },
                    error: function(model, response){
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }

        },
        deleteLeadStage: function(e){
            var self = this,
                cid = $(e.currentTarget).data('cid'),
                model = this.leadStages.get(cid),
                usedInleads = $(e.currentTarget).data('used-in-leads'),
                defaultLeadStage = $('#default-lead-stage option:selected').val();
            if(cid == defaultLeadStage) {
                showMessage(_.isUndefined(i18n['You can\'t delete default stage!'])?'You can\'t delete default stage!':i18n['You can\'t delete default stage!'], true, 5000);
            } else if(usedInleads == 1) {
                showConfirm(_.isUndefined(i18n['This stage already used in leads! Are you sure want to delete?'])?'This stage already used in leads! Are you sure want to delete?':i18n['This stage already used in leads! Are you sure want to delete?'], function(){
                    if (model){
                        model.destroy();
                        $('#default-lead-stage option[value="'+ model.get('id') +'"]').remove();
                        self.render();
                    }
                });
            } else {
                showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                    if (model){
                        model.destroy();
                        $('#default-lead-stage option[value="'+ model.get('id') +'"]').remove();
                        self.render();
                    }
                });
            }
        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.leadStages.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.leadStages.goTo(this.leadStages.firstPage);
                        break;
                    case 'last':
                        this.leadStages.goTo(this.leadStages.information.lastPage);
                        break;
                    case 'prev':
                        this.leadStages.requestPreviousPage();
                        break;
                    case 'next':
                        this.leadStages.requestNextPage();
                        break;
                }
            }
        }
    });

    return LeadStageGridView;
});