define([
    'backbone',
    '../collections/form-builder',
    'text!../templates/paginator.html',
    'text!../templates/form-builder/form-builder-grid-row.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment'
], function(Backbone,
            FormBuilderCollection, PaginatorTmpl, BuilderDataGridRowTmpl, i18n, moment
){

    var LeadsFormBuilderGridView = Backbone.View.extend({
        el: $('#lead-form-builder-grid-table'),
        events: {
            'click a[data-role=delete]': 'deleteBuild',
            'click td.lead-form-builder-paginator a.page': 'navigate'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options){
            this.$el.unbind();

            this.formBuilderCollection = new FormBuilderCollection();
            this.formBuilderCollection.isGrid = true;

            this.formBuilderCollection.on('reset', this.renderBuilds, this);
            this.formBuilderCollection.on('add', this.renderBuilds, this);
            this.formBuilderCollection.on('destroy', this.renderBuilds, this);
        },
        render: function(){
            this.formBuilderCollection.server_api = _.extend(this.formBuilderCollection.server_api, {
            });
            this.formBuilderCollection.server_api.order = '';
            this.formBuilderCollection.pager();
        },
        renderBuilds: function(){
            this.$el.find('tbody').empty();
            this.formBuilderCollection.each(this.renderBuild, this);
            this.formBuilderCollection.info()['i18n'] = i18n;
            this.$('td.lead-form-builder-paginator').html(this.templates.paginator(this.formBuilderCollection.information));
            if (typeof tableResponsive === "function") {
                tableResponsive();
            }
        },
        renderBuild: function(builderData){
            this.$el.find('tbody').append(_.template(BuilderDataGridRowTmpl, {'builderModel': builderData, 'moment':moment, 'i18n': i18n}));
        },
        alphabeticalSort: function(obj){
            // convert object into array
            var sortable=[];
            for(var key in obj)
                if(obj.hasOwnProperty(key))
                    sortable.push([key, obj[key]]); // each item is an array in format [key, value]

            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        },
        deleteBuild: function(e){
            var cid = $(e.currentTarget).data('cid'),
                model = this.formBuilderCollection.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model) {
                    model.destroy({
                        wait: true,
                        success: function(model, response){

                        },
                        error: function(model, response){
                            showMessage(response.responseJSON, true, 2000);
                        }
                    });
                }
            });
        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.formBuilderCollection.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.formBuilderCollection.goTo(this.formBuilderCollection.firstPage);
                        break;
                    case 'last':
                        this.formBuilderCollection.goTo(this.formBuilderCollection.information.lastPage);
                        break;
                    case 'prev':
                        this.formBuilderCollection.requestPreviousPage();
                        break;
                    case 'next':
                        this.formBuilderCollection.requestNextPage();
                        break;
                }
            }
        }
    });

    return LeadsFormBuilderGridView;
});