define([
    'backbone',
    '../models/lead-email-sequence',
    'backbone.paginator'
], function(Backbone, LeadEmailSequenceModel){

    var LeadEmailSequenceCollection = Backbone.Paginator.requestPager.extend({
        model: LeadEmailSequenceModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/leademailsequence/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     100,
            totalPages:  100
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            leadId:function(){return this.leadId}
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }
            this.sequenceList = response.sequenceList;
            this.subscribeInfo = response.subscribeInfo;
            this.subscribeSmsInfo = response.subscribeSmsInfo;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return LeadEmailSequenceCollection;
});