define([
    'backbone',
    './lead-form',
    './lead-grid',
    './lead-product-list',
    './lead-filter-preset-config',
    './lead-detailed-info',
    '../models/lead',
    './lead-main',
    './lead-recently-viewed',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone,
            LeadFormView, LeadGridView, LeadProductListView, LeadFilterPresetConfig, LeadDetailedView, LeadModel, LeadMainView, LeadRecentlyViewedView, i18n){
    var LeadsRouter = Backbone.Router.extend({

        routes: {
            ''         : 'index',
            'lead/:id' : 'leadDetails',
            'lead/:id/?opportunityId=:id' : 'leadDetailsToOpportunity'
        },
        index: function (){

            //init lead grid data
            $('#lead-block').removeClass('hidden');
            this.LeadForm = new LeadFormView();
            this.LeadForm.render();

            this.LeadGrid = new LeadGridView(this.getParams());
            this.LeadGrid.render();

            this.recentlyViewed = new LeadRecentlyViewedView();
            this.recentlyViewed.render();

            this.LeadForm.$el.on('LeadForm:created', _.bind(this.LeadGrid.render, this.LeadGrid));
            this.LeadGrid.$el.on('LeadStatus:changed', _.bind(this.LeadGrid.render, this.LeadGrid));

            this.leadFilterPreset = new LeadFilterPresetConfig();
            this.leadFilterPreset.render();

            this.LeadMainView = new LeadMainView();
            this.LeadMainView.render();

            //this.LeadProductListView = new LeadProductListView();
            //this.LeadProductListView.render();
        },
        leadDetails: function(leadId, params)
        {
            if (!leadId) {
                return false;
            }

            if(!params){
                params = this.getParams();
            }

            this.leadModel =  new LeadModel();
            this.leadModel.set('id', leadId);
            this.leadModel.fetch({data: { isGrid: true, detailedInfo:true},
                'success': function(leadModel){
                    if(_.isUndefined(leadModel.get('lead_email'))) {
                        window.location.href = window.location.pathname;
                    } else {
                        if(!_.isUndefined(this.leadDetailed)) {
                            this.leadDetailed.$el.unbind();
                        }

                        leadModel.customDataParams = params;
                        $('#lead-organizations-recently-viewed-block').addClass('hidden');
                        this.leadDetailed = new LeadDetailedView(leadModel);
                        window.LeadDetailedView = this.leadDetailed;
                        this.leadDetailed.render();
                        $('#lead-table-block').hide();
                        $('.filters').hide();
                        $('#lead-grid-back-link').removeClass('hidden');
                        $('#lead-block').removeClass('hidden');
                        $('#lead-additional-filters').hide();
                        $('.filter-configuration-elements').addClass('hidden');
                        if (window.location.hash !== '') {
                            $('#lead-grid-back').attr('href', $('#website_url').val()+'dashboard/leads/');
                        }
                        $.post($('#website_url').val()+'plugin/leads/run/logLastViewed/', {'id':leadId, 'secureToken':$('#lead-grid-token').val(), 'type':'lead'}, function(){
                        }, 'json');
                    }
                }
            });
        },
        leadDetailsToOpportunity: function (leadId, opportunityid) {
            if (!leadId) {
                return false;
            }

            if(!opportunityid){
                return false;
            }

            var params = {};
            params.opportunityId = opportunityid;
            window.appLeadRouter.leadDetails(leadId, params);
        },
       getParams:  function () {
            var result = {},
                tmpData = [];
            location.search
                .substr(1)
                .split("&")
                .forEach(function (item) {
                    tmpData = item.split("=");
                    result[decodeURIComponent(tmpData[0])] = decodeURIComponent(tmpData[1]);
                });
            return result;
        },
        leadTooltipInfo: function (param) {
            var equal = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'],
                equalDescription = _.isUndefined(i18n['If you only want to match 1 item, like city, then type in its name, like']) ? 'If you only want to match 1 item, like city, then type in its name, like' : i18n['If you only want to match 1 item, like city, then type in its name, like'],
                notEqual = _.isUndefined(i18n['Not Equal']) ? 'Not Equal' : i18n['Not Equal'],
                notEqualDescription = _.isUndefined(i18n['If you want to match all items except one, then type in the name of the item you want to exclude']) ? 'If you want to match all items except one, then type in the name of the item you want to exclude' : i18n['If you want to match all items except one, then type in the name of the item you want to exclude'],
                contains = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'],
                containsDescription = _.isUndefined(i18n['If you want to match all items containing some specific word, then type in this specific word here']) ? 'If you want to match all items containing some specific word, then type in this specific word here' : i18n['If you want to match all items containing some specific word, then type in this specific word here'],
                any = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'],
                anyDescription = _.isUndefined(i18n['If you want to match any item out of some range, then type in the list of items separated with comma']) ? 'If you want to match any item out of some range, then type in the list of items separated with comma' : i18n['If you want to match any item out of some range, then type in the list of items separated with comma'],
                greaterthan = _.isUndefined(i18n['Greater Than']) ? 'Greater Than' : i18n['Greater Than'],
                greaterthanDescription = _.isUndefined(i18n['Use when you want results that exceed the value you enter']) ? 'Use when you want results that exceed the value you enter' : i18n['Use when you want results that exceed the value you enter'],
                lessthan = _.isUndefined(i18n['Less Than']) ? 'Less Than' : i18n['Less Than'],
                lessthanDescription = _.isUndefined(i18n['Use for results that are less than the value you enter']) ? 'Use for results that are less than the value you enter' : i18n['Use for results that are less than the value you enter'];

            var description = '\'<b>'+equal+'</b>\' - '+equalDescription+' \'Boston\'. <br/>' +
                '\'<b>'+ notEqual +'</b>\' - '+ notEqualDescription +'. <br/>' +
                '\'<b>'+ contains +'</b>\' - '+ containsDescription +'. <br/>' +
                '\'<b>'+ any +'</b>\'- '+ anyDescription +'. <br/>' +
                '\'<b>'+ greaterthan +'</b>\'- '+ greaterthanDescription +'. <br/>' +
                '\'<b>'+ lessthan +'</b>\'- '+ lessthanDescription +'.';

            if(!_.isEmpty(param)){
                if(param == 'equal'){
                    description =  equalDescription +' \'Boston\'.';
                }else if(param == 'notequal'){
                    description = notEqualDescription +'.';
                }else if(param == 'like'){
                    description = containsDescription +'.';
                }else if(param == 'in'){
                    description = anyDescription +'.';
                }else if(param == 'greaterthan'){
                    description = greaterthanDescription +'.';
                }else if(param == 'lessthan'){
                    description = lessthanDescription +'.';
                }
            }

            return description;
        }

    });

    var initialize = function() {
        window.appLeadRouter = new LeadsRouter;
        Backbone.history.start();
    };

    return {
        initialize: initialize
    };
});
