define([
    'backbone',
    '../collections/organizations',
    'text!../templates/paginator.html',
    'text!../templates/lead-organization-row.html',
    'text!../templates/organization-merge-dialog.html',
    'text!../templates/mass-delete-dialog.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment',
    'chosen',
    'accounting',
    'text!../templates/organization-action-email-sequence-dialog.html',
    'text!../templates/organization-action-email-service-dialog.html',
    'text!../templates/organization-action-remarketing.html',
], function(Backbone,
            LeadOrganizationsCollection, PaginatorTmpl, LeadOrganizationRowTmpl, OrganizationMergeDialog, MassDeleteDialog,
            i18n, moment, chosen, accounting, OrganizationActionEmailSequenceTemplate, OrganizationActionEmailServiceTemplate,
            OrganizationActionRemarketingTemplate
){

    var LeadsOrganizationsGridView = Backbone.View.extend({
        el: $('#lead-organization-table-block'),
        events: {
            'click a[data-role=delete]': 'deleteOrganization',
            'click td.lead-organization-grid-paginator a.page': 'navigate',
            'blur input.lead-organization-edit-attribute': 'editOrganizationAttribute',
            'change select.lead-organization-edit-attribute': 'editOrganizationAttribute',
            'change input.check-all-organizations' :'checkAllInGrid',
            'change input.check-organization-in-grid': 'checkOrganizationInGrid',
            'change #organizations-mass-action': 'massAction',
            'change select.organization-custom-paginator' :'customPaginate'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        beforeSelectedCampaign: {
            'campaign': ''
        },
        campaignSelectedListsIds: {},
        campaignSelectedListsLabels: {},
        initialize: function(options){
            this.$el.find('#lead-organization-grid-table').unbind();
            this.organizations = new LeadOrganizationsCollection();
            this.organizations.isGrid = true;

            this.organizations.on('reset', this.renderOrganizations, this);
            this.organizations.on('add', this.renderOrganizations, this);
            this.organizations.on('destroy', this.renderOrganizations, this);

            var filterFromDate = $('#lead-organization-filter-from-date'),
                filterToDate = $('#lead-organization-filter-to-date');

            if (filterFromDate.val()) {
                filterFromDate.val($.datepicker.formatDate('d-M-yy', new Date(filterFromDate.val())));
            }

            if (filterToDate.val()) {
                filterToDate.val($.datepicker.formatDate('d-M-yy', new Date(filterToDate.val())));
            }

            filterFromDate.datepicker({
                dateFormat: 'd-M-yy',
                defaultDate: "+1w",
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5",
                onSelect: function(selectedDate){
                    filterToDate.datepicker("option", "minDate", selectedDate);
                }
            });
            filterToDate.datepicker({
                dateFormat: 'd-M-yy',
                defaultDate: "+1w",
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5",
                onSelect: function(selectedDate){
                    filterFromDate.datepicker("option", "maxDate", selectedDate);
                }
            });

            $('#lead-filter-organization-opportunity-stage').chosen();
            $('#organization-filter-tag').chosen();
            $('#organization-filter-tag-exclude').chosen();
            $('#lead-organization-filter-country-state').chosen();

        },
        render: function(options){
            if (typeof options !== 'undefined') {
                if (typeof options.resetCheckedOrganizations !== 'undefined' && options.resetCheckedOrganizations == '1') {
                    delete this.checkedOrganizationRows;
                    _.each($('input.check-organization-in-grid'), function (el) {
                        $(el).prop('checked', false);
                    });
                }
            }

            var self = this;

            this.organizations.server_api = _.extend(this.organizations.server_api, {
                'filter': function() {
                    return {
                        'lead-organization-attribute': $('#lead-organization-attribute').val().replace('&', '*-amp-*'),
                        'range_creation_option': $('#range-creation-option').val(),
                        'last_interaction_id': $('#lead-organization-filter-by-last-interaction').val(),
                        'customer_group_id':$('#lead-organization-filter-by-group').val(),
                        'industry_id': $('#lead-organization-filter-by-industry').val(),
                        'organization_zip': $('#lead-filter-organization-zip').val(),
                        'organization_country': $('#lead-organization-filter-country').val(),
                        'organization_country_state': $('#lead-organization-filter-country-state').val(),
                        'organization_city': $('#lead-filter-organization-city').val(),
                        'total_opportunity_amount_from': $('#lead-filter-total-opportunity-amount-from').val(),
                        'total_opportunity_amount_to': $('#lead-filter-total-opportunity-amount-to').val(),
                        'last_updated': $('#switch-updated-date:checked').val(),
                        'created_at': $('#switch-created-date:checked').val(),
                        'lead_opportunity_stages': $('#lead-filter-organization-opportunity-stage').val(),
                        'opportunity_type_id':$('#lead-filter-by-opportunity-type').val(),
                        'search_includes_notes': $('#search-includes-notes').val(),
                        'search_includes_custom_organization_fields': $('#search-includes-custom-organization-fields').val(),
                        'lead_score_from':$('#lead-organization-filter-score-from').val(),
                        'lead_score_to':$('#lead-organization-filter-score-to').val(),
                        'special_filter_type': $('input[name=leadOrganizationFilterBySpecialType]:checked').val(),
                        'total_spent_purchase_amount_from': $('#lead-organization-filter-total-spent-purchase-amount-from').val(),
                        'total_spent_purchase_amount_to': $('#lead-organization-filter-total-spent-purchase-amount-to').val(),
                        'custom_organization_params_search': self.getOrganizationCustomParams(),
                        'outbound_emails_sub_type': $('#outbound-emails-sub-types').val(),
                        'organization_tags': $('#organization-filter-tag').val(),
                        'organization_tags_exclude': $('#organization-filter-tag-exclude').val(),
                        'organization_without_leads': ($('#lead-organization-without-leads').is(':checked') ? 1 : 0),
                        'created_at_from' : ($('#lead-organization-filter-from-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-organization-filter-from-date').datepicker("getDate")): '',
                        'created_at_to': ($('#lead-organization-filter-to-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-organization-filter-to-date').datepicker("getDate")): '',
                    };
                }
            });
            $('#lead-organization-filter-apply').prop('disabled', false);
            $('#lead-organization-attribute').prop('disabled', false);
            if($('#lead-organization-attribute').val() != '') {
                $('#lead-organization-attribute').focus();
            }
            this.organizations.pager();
        },
        getOrganizationCustomParams: function()
        {
            var customParamsData = [],
                fieldType = '',
                year = '',
                month = '',
                day = '',
                value = '';

            $.each($('#custom-organization-attribute-field-row-block').find('.custom-field-row-block'), function () {
                var fieldType = $(this).data('field-type'),
                    operator = $(this).find('.field-operator-value').val();

                if (fieldType !== 'date') {
                    customParamsData.push({
                        'name': $(this).data('field-name'),
                        'operator': $(this).find('.field-operator-value').val(),
                        'value': $(this).find('.custom-field-row-value').val(),
                        'type': $(this).data('field-type'),
                        'subtype': $(this).data('field-subtype'),
                        'id': $(this).data('field-id'),
                        'label': $(this).data('field-label')
                    });
                } else {
                    year = $(this).find('.custom-field-row-value-year').val();
                    month = $(this).find('.custom-field-row-value-month').val();
                    day = $(this).find('.custom-field-row-value-day').val();
                    value = JSON.stringify({'year':year, 'month':month, 'day':day});
                    customParamsData.push({
                        'name': $(this).data('field-name'),
                        'operator': $(this).find('.field-operator-value').val(),
                        'value': value,
                        'type': $(this).data('field-type'),
                        'subtype': $(this).data('field-subtype'),
                        'id': $(this).data('field-id'),
                        'label': $(this).data('field-label')
                    });
                }
            });

            return customParamsData;
        },
        renderOrganizations: function(){
            document.getElementById('organization-grid-table-body').innerHTML = '';
            this.organizations.each(this.renderOrganization, this);
            this.organizations.info()['i18n'] = i18n;
            this.$('td.lead-organization-grid-paginator').html(this.templates.paginator(this.organizations.information));
            $('.organizations-filter-paginator-block').show();
            if(!_.isUndefined(this.organizations.customPaginate)) {
                $('.organization-custom-paginator').val(this.organizations.customPaginate);
            }

            this.assignTotalOpportunitiesAmount(this.organizations.pluck("id"));

            var self = this;
            if (!_.isUndefined(this.checkedOrganizationRows)) {
                _.each($('input.check-organization-in-grid'), function (el) {
                    if (self.checkedOrganizationRows.indexOf($(el).data('organization-id')) !== -1) {
                        $(el).prop('checked', true);
                    }
                });
            }

            $('input.check-all-organizations').prop('checked', false);

            $(".lead-edit-organization").on("keydown", function(event) {
                if ( event.keyCode === $.ui.keyCode.TAB &&
                    $(this).autocomplete( "instance" ).menu.active) {
                    event.preventDefault();
                }
            }).autocomplete({
                    source: function(request, response) {
                        $.ajax({
                            'url': $('#website_url').val()+'api/leads/leadorganization/',
                            'type':'GET',
                            'dataType':'json',
                            'data': {searchTerm: request.term}
                        }).done(function(responseData){
                            if (!_.isEmpty(responseData)) {
                                response($.map(responseData, function (responseData) {
                                    return {
                                        label: responseData.organization_name,
                                        value: responseData.organization_name
                                    };
                                }));
                            }
                        });
                    },
                    search: function() {

                    },
                    focus: function() {
                        return false;
                    },
                    select: function(event, ui) {

                    }
            });
        },
        mergeOrganizationsAction: function()
        {
            var self = this,
                checkedOrganizations = this.checkedOrganizationRows.join(','),
                countSelectedOrganizations = this.checkedOrganizationRows.length;

            if (countSelectedOrganizations < 2) {
                showMessage(_.isUndefined(i18n['Please choose at least 2 organizations'])?'Please choose at least 2 organizations':i18n['Please choose at least 2 organizations'], true, 5000);
                return false;
            }

            if (countSelectedOrganizations > 3) {
                showMessage(_.isUndefined(i18n['You can merge not more than 3 organizations at once'])?'You can merge not more than 3 organizations at once':i18n['You can merge not more than 3 organizations at once'], true, 5000);
                return false;
            }

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/getOrganizationsInfo/',
                type: 'POST',
                dataType: 'json',
                data: {'checkedOrganizations':checkedOrganizations}
            }).done(function(response) {
                if (response.error == '1') {
                    showMessage(_.isUndefined(i18n['Organizations have not found'])?'Organizations have not found':i18n['Organizations have not found'], true, 5000);
                    return false;
                }

                var dialog = _.template(OrganizationMergeDialog, {
                    organizationIds: checkedOrganizations,
                    countSelectedOrganizations: countSelectedOrganizations,
                    i18n:i18n,
                    organizationsData: response.responseText
                });
                $(dialog).dialog({
                    dialogClass: 'seotoaster',
                    width: '30%',
                    height: '250',
                    resizable: false,
                    open: function(event, ui) {
                        $('#merge-organization-dialog').on('submit',  function(e){
                            e.preventDefault();

                            // $('.error').css({'z-index': 10000});
                            // $('.ui-dialog').css({'z-index': 99});

                            if (!$('input.merge-organization-el').is(':checked')) {
                                showMessage(_.isUndefined(i18n['Please specify the organization to be merged to ']) ? 'Please specify the organization to be merged to' : i18n['Please specify the organization to be merged to'], true, 5000);
                                return false;
                            }

                            var organizationMergeToId = $('input.merge-organization-el:checked').data('organization-id-merge-to');

                            $.ajax({
                                url: $('#website_url').val()+'plugin/leads/run/mergeMassOrganizations/',
                                type: 'POST',
                                dataType: 'json',
                                data:{'secureToken' :  $('#lead-organization-grid-token').val(), 'organizationIds' : checkedOrganizations, 'organizationMergeToId':organizationMergeToId}
                            }).done(function(response){
                                if (response.error == '1') {
                                    showMessage(response.responseText, true, 5000);
                                } else {
                                    showMessage(response.responseText, false, 5000);
                                    $('#merge-organization-dialog').dialog('close');
                                    window.location = $('#website_url').val() + 'dashboard/organizations/#organization/' + organizationMergeToId
                                }
                            });
                        });
                    },
                    close: function(event, ui){
                        $(this).dialog('close').remove();
                    }
                });

                return false;
            });
        },
        massAction: function(e){
            var func = $(e.currentTarget).val()+'Action';

            if (_.isFunction(this[func])) {
                var organizations = this.checkedOrganizationRows,
                    self = this;
                if (!_.isUndefined(organizations) && !_.isEmpty(organizations)){
                    this[func].call(self, organizations);
                }
            }
            $(e.currentTarget).val(0);
        },
        customPaginate: function(e) {
            var el = $(e.currentTarget),
                paginationParam = el.val();

            this.organizations.customPaginate = paginationParam;
            this.organizations.paginator_ui.perPage = paginationParam;

            this.specialPageNavigator(this.organizations.firstPage);
        },
        checkAllInGrid: function(e) {
            var allEl = $(e.currentTarget),
                currentState = false,
                self = this;
            if (allEl.is(':checked')) {
                currentState = true;
            }

            _.each($('input.check-organization-in-grid'), function (el) {
                $(el).prop('checked', currentState);
                if (currentState === true) {
                    if (!_.isUndefined(self.checkedOrganizationRows)) {
                        self.checkedOrganizationRows = _.union(self.checkedOrganizationRows, $(el).data('organization-id'));
                    } else {
                        self.checkedOrganizationRows = [$(el).data('organization-id')];
                    }
                }  else {
                    if (!_.isUndefined(self.checkedOrganizationRows)) {
                        var arrayIndex = self.checkedOrganizationRows.indexOf($(el).data('organization-id'));
                        self.checkedOrganizationRows.splice(arrayIndex, 1);
                    }
                }
            });
        },
        checkOrganizationInGrid:function(e)
        {
            var el = $(e.currentTarget),
                organizationId = el.data('organization-id'),
                status = el.is(':checked');

            if (status === true) {
                if (!_.isUndefined(this.checkedOrganizationRows)) {
                    this.checkedOrganizationRows = _.union(this.checkedOrganizationRows, organizationId);
                } else {
                    this.checkedOrganizationRows = [organizationId];
                }
            } else {
                if (!_.isUndefined(this.checkedOrganizationRows)) {
                    var arrayIndex = this.checkedOrganizationRows.indexOf(organizationId);
                    this.checkedOrganizationRows.splice(arrayIndex, 1);
                }
            }
        },
        renderOrganization: function(leadsData){
            this.organizations.customerGroupsData = this.alphabeticalSort(this.organizations.customerGroups);
            this.organizations.organizationIndustriesData = this.alphabeticalSort(this.organizations.organizationIndustries);
            this.$el.find('#organization-grid-table-body').append( _.template(LeadOrganizationRowTmpl, {'leadsOrganizationModel': leadsData,
                'customerGroups': this.organizations.customerGroupsData, 'organizationIndustries' : this.organizations.organizationIndustriesData, 'i18n': i18n}));
            var desktopMasks = this.organizations.desktopMasks,
                desktopCountryCode = leadsData.get('organization_phone_country_code');

            if (typeof desktopMasks[desktopCountryCode] !== 'undefined') {
                $('#lead-organization-edit-attribute-phone-'+leadsData.get('id')).mask(desktopMasks[desktopCountryCode].mask_value, {autoclear: false});
            } else {
                $('#lead-organization-edit-attribute-phone-'+leadsData.get('id')).mask('(999) 999 9999', {autoclear: false});
            }
        },
        assignTotalOpportunitiesAmount: function(organizationIds) {
            var self = this;
            $.get($('#website_url').val()+'api/leads/leadsorganizationgridstats/', {'organizationIds' : organizationIds.join(',')}, function(response){
                if (!_.isEmpty(response)) {
                    if (!_.isUndefined(response.totalSpentInfo)) {
                        _.each(response.totalSpentInfo, function (statData, id) {
                            self.$el.find('.organization-row-id-' + id).find('.total-sales-amount').text(accounting.formatMoney(Math.round(parseFloat(statData.total).toFixed(2)), JSON.parse(self.organizations.moneyFormat)));
                        });
                    }

                    if (!_.isUndefined(response.totalOpportunitiesInfo)) {
                        _.each(response.totalOpportunitiesInfo, function (opportunityData, id) {
                            if (opportunityData.total !== null) {
                                self.$el.find('.organization-row-id-' + id).find('.total-opportunities-amount').html('<span class="total-opportunities-amount-value">'+accounting.formatMoney(Math.round(opportunityData.total), JSON.parse(self.organizations.moneyFormat))+'</span>');
                            }
                        });
                    }

                    if (!_.isUndefined(response.interactionInfo) && response.interactionInfo !== '') {
                        console.log(response.interactionInfo);
                        _.each(response.interactionInfo, function (interactionData, id) {
                            self.$el.find('.organization-row-id-' + id).find('.last-interaction-type').text(interactionData.action_type_label);
                            self.$el.find('.organization-row-id-' + id).find('.last-interaction-date').text(moment(interactionData.created_at, 'YYYY-MM-DD HH:mm:ss').format('DD MMMM YYYY'));
                        });
                    }
                }
            }, 'json');
        },
        alphabeticalSort: function(obj){
            // convert object into array
            var sortable=[];
            for(var key in obj)
                if(obj.hasOwnProperty(key))
                    sortable.push([key, obj[key]]); // each item is an array in format [key, value]

            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        },
        editOrganizationAttribute: function(e)
        {
            var currentAttribute = $(e.currentTarget),
                currentValue = currentAttribute.val(),
                oldValue = currentAttribute.data('old-value'),
                organizationId = currentAttribute.data('cid'),
                organizationModel = this.organizations.get(organizationId),
                attrName =  currentAttribute.data('attrName');

            if (currentValue != oldValue) {
                currentAttribute.data('old-value', currentValue);
                organizationModel.set(attrName, currentValue);
                organizationModel.set('secureToken', $('#lead-organization-grid-token').val());
                organizationModel.save(null, {
                    success: function(model, response){
                        showMessage(response.responseText.message, false, 5000);
                    },
                    error: function(model, response){
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }

        },
        deleteOrganization: function(e){
            var cid = $(e.currentTarget).data('cid'),
                model = this.organizations.get(cid),
                self = this;

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model){
                    model.destroy();
                    self.render();
                }
            });
        },
        deleteOrganizationsAction: function(e){
            var organizationIds = this.checkedOrganizationRows.join(','),
                countSelectedOrganizations = this.checkedOrganizationRows.length,
                filters = this.organizations.server_api.filter(),
                filterUsed = this.organizations.filterUsed,
                self = this;

            var dialog = _.template(MassDeleteDialog, {
                organizationIds: organizationIds,
                filters : $.param(filters),
                filterUsed : filterUsed,
                countSelectedOrganizations: countSelectedOrganizations,
                i18n:i18n
            });

            $(dialog).dialog({
                dialogClass: 'seotoaster',
                width: '25%',
                minHeight: '160',
                resizable: false,
                draggable: false,
                open: function (event, ui) {
                    var deleteOrganizationsText = _.isUndefined(i18n['Delete organizations']) ? 'Delete organizations' : i18n['Delete organizations'],
                        totalText = _.isUndefined(i18n['Total']) ? 'Total' : i18n['Total'],
                        recordsText = _.isUndefined(i18n['records']) ? 'records' : i18n['records'],
                        title = '';

                    if(countSelectedOrganizations == 1) {
                        deleteOrganizationsText = _.isUndefined(i18n['Delete organization']) ? 'Delete organization' : i18n['Delete organization'];
                        recordsText = _.isUndefined(i18n['record']) ? 'record' : i18n['record'];
                    }
                    $('.cl-none').text(deleteOrganizationsText);

                    title = deleteOrganizationsText + ' (' + totalText + ' ' + countSelectedOrganizations + ' ' + recordsText + ')';
                    $('#delete-organizations-dialog').dialog('option', 'title', title);

                    $('#delete-organizations-form').on('submit', function(e){
                        e.preventDefault();

                        $('.orig-processed').find('.mass-delete-organizations-quantity').text(0);
                        $('.end-processed').find('.mass-delete-organizations-quantity').text(0);
                        var matchingFilter = 0;

                        if ($('#delete-all-organizations-matching-filter').is(':checked')) {
                            matchingFilter = 1;
                        }

                        if (matchingFilter === 1) {
                            $.ajax({
                                url: $('#website_url').val() + 'plugin/leads/run/countAllOrganizations/',
                                type: 'POST',
                                dataType: 'json',
                                data: {
                                    'secureToken': $('#lead-organization-grid-token').val(),
                                    'filters': $.param(filters)
                                }
                            }).done(function (response) {
                                var countSelectedOrganizationsQuantity = response.responseText.quantity;

                                showConfirm((_.isUndefined(i18n['Are you sure want to delete']) ? 'Are you sure want to delete' : i18n['Are you sure want to delete']) + ' ' + countSelectedOrganizationsQuantity + ' ' + (_.isUndefined(i18n['organizations']) ? 'organizations' : i18n['organizations']) + '?', function () {
                                    self.massDeleteOrganizationsRequest($(this).attr('action'), organizationIds, filters, matchingFilter, 0, $('#delete-organizations-dialog').data('count-selected-organizations'));

                                });
                            });
                        } else {
                            showConfirm((_.isUndefined(i18n['Are you sure want to delete']) ? 'Are you sure want to delete' : i18n['Are you sure want to delete']) + ' ' + countSelectedOrganizations + ' ' + (_.isUndefined(i18n['organization(s)']) ? 'organization(s)' : i18n['organization(s)']) + '?', function () {
                                self.massDeleteOrganizationsRequest($(this).attr('action'), organizationIds, filters, matchingFilter, 0, $('#delete-organizations-dialog').data('count-selected-organizations'));

                            });
                        }
                    });

                    $('.allOrganizations').on('change', function (e) {
                        e.preventDefault();

                        $('#mass-delete-organizations-quantity-block').addClass('hidden');
                        $('.orig-processed').find('.mass-delete-organizations-quantity').text(0);
                        $('.end-processed').find('.mass-delete-organizations-quantity').text(0);

                        if ($('#delete-all-organizations-matching-filter').is(':checked')) {
                            $.ajax({
                                url: $('#website_url').val() + 'plugin/leads/run/countAllOrganizations/',
                                type: 'POST',
                                dataType: 'json',
                                data: {'secureToken': $('#lead-organization-grid-token').val(), 'filters': $.param(filters)}
                            }).done(function (response) {
                                if (response.error == '1') {
                                    showMessage(_.isUndefined(i18n['No organizations found']) ? 'No organizations found' : i18n['No organizations found'], true, 5000);
                                } else {
                                    var countSelectedOrganizationsQuantity = response.responseText.quantity;

                                    deleteOrganizationsText = _.isUndefined(i18n['Delete organizations']) ? 'Delete organizations' : i18n['Delete organizations'];
                                    recordsText = _.isUndefined(i18n['records']) ? 'records' : i18n['records'];

                                    if(countSelectedOrganizationsQuantity == 1) {
                                        deleteOrganizationsText = _.isUndefined(i18n['Delete organization']) ? 'Delete organization' : i18n['Delete organization'];
                                        recordsText = _.isUndefined(i18n['record']) ? 'record' : i18n['record'];
                                    }

                                    title = deleteOrganizationsText + ' (' + totalText + ' ' + countSelectedOrganizationsQuantity + ' ' + recordsText + ')';

                                    $('.cl-none').text(deleteOrganizationsText);
                                    $('.delete-organizations-dialog').dialog('option', 'title', title);
                                    $('#delete-organizations-dialog').data('count-selected-organizations', countSelectedOrganizationsQuantity);
                                }
                            });
                        } else {
                            deleteOrganizationsText = _.isUndefined(i18n['Delete organizations']) ? 'Delete organizations' : i18n['Delete organizations'];
                            recordsText = _.isUndefined(i18n['records']) ? 'records' : i18n['records'];

                            if(countSelectedOrganizations == 1) {
                                deleteOrganizationsText = _.isUndefined(i18n['Delete organization']) ? 'Delete organization' : i18n['Delete organization'];
                                recordsText = _.isUndefined(i18n['record']) ? 'record' : i18n['record'];
                            }

                            title = deleteOrganizationsText + ' (' + totalText + ' ' + countSelectedOrganizations + ' ' + recordsText + ')';
                            $('.cl-none').text(deleteOrganizationsText);
                            $('.delete-organizations-dialog').dialog('option', 'title', title);
                            $('#delete-organizations-dialog').data('count-selected-organizations', countSelectedOrganizations);
                        }
                    });
                },
                close: function (event, ui) {
                    $(this).dialog('close').remove();
                }
            });
        },
        emailSequenceAction:function (e) {
            var self = this,
                checkedOrganizations = this.checkedOrganizationRows.join(','),
                countSelectedOrganizations = this.checkedOrganizationRows.length,
                filters = this.organizations.server_api.filter();

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/emailSequenceOrganization/organizationIds/' + checkedOrganizations,
                type: 'GET',
                dataType: 'json'

            }).done(function(response) {
                var emailSequences = self.alphabeticalSort(response.emailSequences),
                    countOrganizationLeads = response.countOrganizationLeads;

                var dialog = _.template(OrganizationActionEmailSequenceTemplate, {
                    organizationIds: checkedOrganizations,
                    countSelectedOrganizations: countSelectedOrganizations,
                    filters : $.param(filters),
                    i18n:i18n,
                    emailSequences: emailSequences,
                    countOrganizationLeads: countOrganizationLeads
                });
                $(dialog).dialog({
                    dialogClass: 'seotoaster',
                    width: '30%',
                    height: '220',
                    resizable: false,
                    draggable: false,
                    open: function(event, ui) {
                        var allFilterOrganizations = 0;

                        $('.allFilterOrganizations').on('change',  function(e){
                            e.preventDefault();

                            var organizationsText = _.isUndefined(i18n['Assign/unassign email/sms sequence']) ? 'Assign/unassign email/sms sequence':i18n['Assign/unassign email/sms sequence'],
                                totalText = _.isUndefined(i18n['Total'])?'Total':i18n['Total'],
                                recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'],
                                title = '';

                            if($('.allFilterOrganizations').prop('checked')){
                                $.ajax({
                                    url: $('#website_url').val()+'plugin/leads/run/countAllOrganizations/',
                                    type: 'POST',
                                    dataType: 'json',
                                    data:{'secureToken':$('#lead-organization-grid-token').val(), 'filters':$.param(filters), 'usemassaction': 1}
                                }).done(function(response){
                                    if (response.error == '1') {
                                        showMessage(_.isUndefined(i18n['No organizations found'])?'No organizations found':i18n['No organizations found'], true, 5000);
                                    } else {
                                        allFilterOrganizations = 1;
                                        var organizationLeadsCount = response.responseText.quantity,
                                            title = organizationsText + ' (' + totalText +' '+ organizationLeadsCount +' '+ recordsText +')';

                                        $('#assign-email-sequence-dialog').dialog('option', 'title', title);
                                        $('#quantity-all-leads-data').val(organizationLeadsCount);
                                    }
                                });
                            }else{
                                allFilterOrganizations = 0;
                                title = organizationsText + ' (' + totalText +' '+ countOrganizationLeads +' '+ recordsText +')';
                                $('#assign-email-sequence-dialog').dialog('option', 'title', title);
                                $('#quantity-all-leads-data').val(countOrganizationLeads);
                            }
                        })

                        $('#assign-email-sequence').on('submit',  function(e){
                            e.preventDefault();
                            var organizationEmailSequenceId = $(this).find('.organization-email-sequences').val(),
                                self = this;

                            if (organizationEmailSequenceId == '0')  {
                                showMessage(_.isUndefined(i18n['Please choose email/sms sequence']) ? 'Please choose email/sms sequence' : i18n['Please choose email/sms sequence'], true, 5000);
                                return false;
                            }


                            var emailSmsFunction = $('input[name=email-sms-function]:checked').val();

                            var requestType = 'addnew';

                            if(emailSmsFunction == 'remove'){
                                requestType = 'remove';
                            }

                            if(emailSmsFunction == 'addnew'){
                                requestType = 'addnew';
                            }

                            function processOrganizationsSequencesProcedure(self, secureToken, organizationEmailSequenceId, checkedOrganizations, filters, allFilterOrganizations, offset, quantityAllLeadsData, requestType) {
                                if(typeof self !== 'undefined') {
                                    $('.organization-sequences-progress').show();

                                    $.ajax({
                                        url: $(self).attr('action'),
                                        type: 'POST',
                                        dataType: 'json',
                                        data:{
                                            'secureToken' : secureToken,
                                            'organizationEmailSequenceId' : organizationEmailSequenceId,
                                            'organizationIds' : checkedOrganizations,
                                            'filters':$.param(filters),
                                            'allFilterOrganizations': allFilterOrganizations,
                                            'quantityAllLeadsData': quantityAllLeadsData,
                                            'offset': offset,
                                            'requestType':requestType
                                        }
                                    }).done(function(response){
                                        if (response.error != '1') {
                                            var currentOffset,
                                                totalRecords,
                                                leadsIdsCount,
                                                processedOrganizationsCountEl = $('.processed-organizations-count'),
                                                processedOrganizationsElData = processedOrganizationsCountEl.data('processed-organizations-count');

                                            if(typeof response.responseText.offset !== 'undefined') {
                                                currentOffset = response.responseText.offset;
                                                totalRecords = response.responseText.totalRecords;
                                                leadsIdsCount = response.responseText.leadsIdsCount;

                                                processedOrganizationsCountEl.data('processed-organizations-count',  processedOrganizationsElData + leadsIdsCount);
                                                processedOrganizationsCountEl.text(processedOrganizationsElData + leadsIdsCount);
                                                $('.processed-total-records-leads').text(totalRecords);
                                                processOrganizationsSequencesProcedure(self, secureToken, organizationEmailSequenceId, checkedOrganizations, filters, allFilterOrganizations, currentOffset, quantityAllLeadsData, requestType);
                                            } else {
                                                showMessage(response.responseText, false, 3000);
                                                $('#assign-email-sequence-dialog').dialog('close');
                                            }
                                        } else {
                                            showMessage(response.responseText, true, 5000);
                                            $('#assign-email-sequence-dialog').dialog('close');
                                        }
                                    });
                                }
                            }

                            if(allFilterOrganizations) {
                                processOrganizationsSequencesProcedure(self, $('#lead-organization-grid-token').val(), organizationEmailSequenceId, checkedOrganizations, filters, allFilterOrganizations, 0, $('#quantity-all-leads-data').val(), requestType);
                            } else {
                                $.ajax({
                                    url: $(self).attr('action'),
                                    type: 'POST',
                                    dataType: 'json',
                                    data:{
                                        'secureToken' : $('#lead-organization-grid-token').val(),
                                        'organizationEmailSequenceId' : organizationEmailSequenceId,
                                        'organizationIds' : checkedOrganizations,
                                        'filters':$.param(filters),
                                        'allFilterOrganizations': allFilterOrganizations,
                                        requestType:requestType
                                    }
                                }).done(function(response){
                                    if (response.error == '1') {
                                        showMessage(response.responseText, true, 5000);
                                    } else {
                                        showMessage(_.isUndefined(i18n['Done'])?'Done':i18n['Done'], false, 3000);
                                        $('#assign-email-sequence-dialog').dialog('close');
                                    }
                                });
                            }
                        });
                    },
                    close: function(event, ui){
                        $(this).dialog('close').remove();
                    }
                });

                return false;
            });
        },
        emailMarketingAction: function(e) {
            var self = this,
                checkedOrganizations = this.checkedOrganizationRows.join(','),
                customerIds = [1],
                filters = this.organizations.server_api.filter();

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/getEnabledAppsServices/serviceType/email/customers/'+customerIds+'/organizationIds/' + checkedOrganizations,
                type: 'GET',
                dataType: 'json'
            }).done(function(response) {
                if (response.error == 1) {
                    showMessage(_.isUndefined(i18n['No available services']) ? 'No available services': i18n['No available services']);
                    return false;
                } else {
                    var enabledServices = response.responseText.enabledServices,
                        countOrganizationLeads = response.responseText.countOrganizationLeads,
                        additionalCountOrganizationLeads = response.responseText.countOrganizationLeads,
                        dialog = _.template(OrganizationActionEmailServiceTemplate, {
                            enabledServices:enabledServices,
                            i18n:i18n,
                            filters : $.param(filters),
                            countOrganizationLeads: countOrganizationLeads,
                            additionalCountOrganizationLeads: countOrganizationLeads
                        });

                    self.firstLoad = 0;
                    self.enabledServicesList = enabledServices;

                    $(dialog).dialog({
                        width: '30%',
                        height: '535',
                        dialogClass: 'seotoaster',
                        resizable:false,
                        draggable: false,
                        'title': _.isUndefined(i18n['Add/Remove emails to Email Marketing'])?'Add/Remove emails to Email Marketing':i18n['Add/Remove emails to Email Marketing'],
                        open: function(event, ui) {
                            var organizationsText = _.isUndefined(i18n['Add/Remove emails to Email Marketing']) ? 'Add/Remove emails to Email Marketing':i18n['Add/Remove emails to Email Marketing'],
                                recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'],
                                originalLabel = _.isUndefined(i18n['records (with an email address) to your mailing list.']) ? 'records (with an email address) to your mailing list.':i18n['records (with an email address) to your mailing list.'],
                                additionalLabel = _.isUndefined(i18n['records (with an email address) matching your filter to your mailing list.']) ? 'records (with an email address) matching your filter to your mailing list.':i18n['records (with an email address) matching your filter to your mailing list.'],
                                originalLabel2 = _.isUndefined(i18n['records matching your filter']) ? 'records matching your filter':i18n['records matching your filter'],
                                additionalLabel2 = _.isUndefined(i18n['selected records']) ? 'selected records':i18n['selected records'];

                            if(countOrganizationLeads == 1) {
                                organizationsText = _.isUndefined(i18n['Add/Remove email to Email Marketing']) ? 'Add/Remove email to Email Marketing':i18n['Add/Remove email to Email Marketing'];
                                recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                originalLabel = _.isUndefined(i18n['record (with an email address) to your mailing list.']) ? 'record (with an email address) to your mailing list.':i18n['record (with an email address) to your mailing list.'];
                                additionalLabel = _.isUndefined(i18n['record matching your filter to your mailing list.']) ? 'record matching your filter to your mailing list.':i18n['record matching your filter to your mailing list.'];
                            }

                            if(additionalCountOrganizationLeads == 1) {
                                organizationsText = _.isUndefined(i18n['Add/Remove email to Email Marketing']) ? 'Add/Remove email to Email Marketing':i18n['Add/Remove email to Email Marketing'];
                                originalLabel2 = _.isUndefined(i18n['record matching your filter']) ? 'record matching your filter':i18n['record matching your filter'];
                                additionalLabel2 = _.isUndefined(i18n['selected record']) ? 'selected record':i18n['selected record'];
                            }

                            $('.original-label-main').text(originalLabel);
                            $('.additional-label-label-main').text(additionalLabel);

                            $('.original-label-main2').text(originalLabel2);
                            $('.additional-label-label-main2').text(additionalLabel2);

                            var totalText = _.isUndefined(i18n['Total']) ? 'Total' : i18n['Total'];
                            var title = organizationsText + ' (' + totalText +' '+ countOrganizationLeads +' '+ recordsText +')';

                            $('#action-email-service-dialog').dialog('option', 'title', title);

                            $('#marketing-services').on('change',  function(e){
                                e.stopImmediatePropagation();
                                if ($('#organizations-marketing-matching-filter').is(':checked')) {
                                    $('.original-label').hide();
                                    $('.additional-label').show();
                                } else {
                                    $.ajax({
                                        url: $('#website_url').val()+'plugin/leads/run/countAllOrganizations/',
                                        type: 'POST',
                                        dataType: 'json',
                                        data:{
                                            'secureToken':$('#lead-organization-grid-token').val(),
                                            'filters':$.param(filters),
                                            'uniqueEmail': '1',
                                            'usemassaction' : '1'
                                        }
                                    }).done(function(response) {
                                        var countSelectedOrganizations = response.responseText.quantity;
                                        $('#send-to-email-service').data('count-selected-organizations', countSelectedOrganizations);
                                        $('#quantity-all-leads-data').val(response.responseText.organizationLeadsCount);
                                        $('.additional-checked-organizations-counter').text(response.responseText.organizationLeadsCount);

                                        var checkedOrganizationsCounter = $('.checked-organizations-counter').text();
                                        var additionalCheckedOrganizationsCounter = $('.additional-checked-organizations-counter').text();

                                        if(additionalCheckedOrganizationsCounter > 1) {
                                            $('.original-label-main2').text(_.isUndefined(i18n['records matching your filter']) ? 'records matching your filter':i18n['records matching your filter']);
                                        } else {
                                            $('.original-label-main2').text(_.isUndefined(i18n['record matching your filter']) ? 'record matching your filter':i18n['record matching your filter']);
                                        }
                                    });

                                    $('.original-label').show();
                                    $('.additional-label').hide();
                                }
                                $('#organization-send-email-service-quantity-block').addClass('hidden');
                                $('#organization-send-email-service-quantity').text(0);
                                $('#check-all-for-email-service').addClass('hidden');
                                if ($("#marketing-services").val() != 'select') {
                                    $.ajax({
                                        url: $('#website_url').val()+'plugin/leads/run/getAppsService/serviceName/'+$("#marketing-services").val(),
                                        type: 'GET',
                                        dataType: 'json'
                                    }).done(function(response) {
                                        if(response.error == 1){
                                            if($('#marketing-services').val() == 'constantContact') {
                                                if(response.responseText.hasError) {
                                                    showMessage((_.isUndefined(i18n['<p><b>Can not get any data.</b></p> '+response.responseText.message])?'<p><b>Can not get any data.</b></p> '+response.responseText.message:i18n['<p><b>Can not get any data.</b></p> '+response.responseText.message]));
                                                } else {
                                                    showMessage((_.isUndefined(i18n['<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.'])?'<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.':i18n['<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.']));
                                                }
                                            } else {
                                                showMessage((_.isUndefined(i18n['<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.'])?'<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.':i18n['<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.']), false, 5000);
                                            }

                                            $('#subscribe-list').remove();
                                            $('#send-to-email-service').addClass('hidden');
                                            $('#check-all-for-email-service').addClass('hidden');
                                            $('.horizontal-line').addClass('hidden');
                                            $('#marketing-services').val('select');
                                            return false;
                                        }else{
                                            $('#subscribe-list').remove();
                                            var subscribeList = '<div class="grid_12 mt10px scroll" id="subscribe-list" style="height:145px;">',
                                                list = self.alphabeticalSort(response.responseText.list);

                                            if(list.length > 0) {
                                                $.each(list, function(value, listName){
                                                    subscribeList += '<label class="mr30px pointer"> <input type="checkbox" class="subscribe-to-email-service-list" name="list" value="'+ listName[0] +'" data-label="'+ listName[1] +'"/><span>'+ listName[1] +'</span></label>'
                                                });
                                            } else {
                                                if($('#marketing-services').val() == 'constantContact') {
                                                    if(response.responseText.hasError) {
                                                        subscribeList += (_.isUndefined(i18n['<p><b>Can not get any data.</b></p> '+response.responseText.message])?'<p><b>Can not get any data.</b></p> '+response.responseText.message:i18n['<p><b>Can not get any data.</b></p> '+response.responseText.message]);
                                                        showMessage((_.isUndefined(i18n['<p><b>Can not get any data.</b></p> '+response.responseText.message])?'<p><b>Can not get any data.</b></p> '+response.responseText.message:i18n['<p><b>Can not get any data.</b></p> '+response.responseText.message]));
                                                    } else {
                                                        subscribeList += (_.isUndefined(i18n['<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.'])?'<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.':i18n['<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.']);
                                                        showMessage((_.isUndefined(i18n['<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.'])?'<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.':i18n['<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.']));
                                                    }
                                                } else {
                                                    subscribeList += (_.isUndefined(i18n['<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.'])?'<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.':i18n['<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.']);
                                                    showMessage((_.isUndefined(i18n['<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.'])?'<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.':i18n['<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.']), false, 5000);
                                                }
                                            }

                                            subscribeList += '</div>';

                                            $('#email-service-detailed-info').val(response.responseText.detailedInfo);

                                            $('#marketing-services').after(subscribeList);
                                            $('#send-to-email-service').removeClass('hidden');
                                            $('#check-all-for-email-service').removeClass('hidden');
                                            $('.horizontal-line').removeClass('hidden');
                                        }
                                    });
                                }else{
                                    $('#send-to-email-service').addClass('hidden');
                                    $('.horizontal-line').addClass('hidden');
                                    $('#subscribe-list').remove();
                                }
                            });

                            $('body').on('change', '.change-email-marketing', function(e) {
                                var emailMarketingFunction = $('input[name=email-marketing-function]:checked').val();
                                if(emailMarketingFunction == 'unassign') {
                                    $('.information-msg').text(_.isUndefined(i18n['To ensure that all contacts are removed from your list(s), please do not close this window until all records have been processed.']) ? 'To ensure that all contacts are removed from your list(s), please do not close this window until all records have been processed.':i18n['To ensure that all contacts are removed from your list(s), please do not close this window until all records have been processed.']);
                                    $('#send-to-email-service').val(_.isUndefined(i18n['Remove contact(s) from list']) ? 'Remove contact(s) from list':i18n['Remove contact(s) from list']);
                                    $('.original-label1').text(_.isUndefined(i18n['You’re now removing']) ? 'You’re now removing':i18n['You’re now removing']);
                                    $('.original-label2').text(_.isUndefined(i18n['Check this box if you wish to remove ALL']) ? 'Check this box if you wish to remove ALL':i18n['Check this box if you wish to remove ALL']);
                                    $('.additional-label1').text(_.isUndefined(i18n['You’re now removing ALL']) ? 'You’re now removing ALL':i18n['You’re now removing ALL']);
                                    $('.additional-label2').text(_.isUndefined(i18n['Uncheck this box if you wish to remove']) ? 'Uncheck this box if you wish to remove':i18n['Uncheck this box if you wish to remove']);


                                    if(countOrganizationLeads == 1) {
                                        $('.additional-label-label-main').text((_.isUndefined(i18n['record (with an email address) matching your filter from your mailing list.']) ? 'record (with an email address) matching your filter from your mailing list.':i18n['record (with an email address) matching your filter from your mailing list.']));

                                        $('.original-label-main').text(_.isUndefined(i18n['record (with an email address) from your mailing list.']) ? 'record (with an email address) from your mailing list.':i18n['record (with an email address) from your mailing list.']);
                                        $('.send-email-service-quantity').text(_.isUndefined(i18n['contact has been successfully removed']) ? 'contact has been successfully removed':i18n['contact has been successfully removed']);
                                    } else {
                                        $('.additional-label-label-main').text((_.isUndefined(i18n['records (with an email address) matching your filter from your mailing list.']) ? 'records (with an email address) matching your filter from your mailing list.':i18n['records (with an email address) matching your filter from your mailing list.']));

                                        $('.original-label-main').text(_.isUndefined(i18n['records (with an email address) from your mailing list.']) ? 'records (with an email address) from your mailing list.':i18n['records (with an email address) from your mailing list.']);
                                        $('.send-email-service-quantity').text(_.isUndefined(i18n['contacts have been successfully removed']) ? 'contacts have been successfully removed':i18n['contacts have been successfully removed']);
                                    }

                                } else {
                                    $('.information-msg').text(_.isUndefined(i18n['To ensure that all contacts are added to your list(s), please do not close this window until all records have been processed.']) ? 'To ensure that all contacts are added to your list(s), please do not close this window until all records have been processed.':i18n['To ensure that all contacts are added to your list(s), please do not close this window until all records have been processed.']);
                                    $('#send-to-email-service').val(_.isUndefined(i18n['Add contact(s) to list']) ? 'Add contact(s) to list':i18n['Add contact(s) to list']);
                                    $('.original-label1').text(_.isUndefined(i18n['You’re now adding']) ? 'You’re now adding':i18n['You’re now adding']);
                                    $('.original-label2').text(_.isUndefined(i18n['Check this box if you wish to add ALL']) ? 'Check this box if you wish to add ALL':i18n['Check this box if you wish to add ALL']);
                                    $('.additional-label1').text(_.isUndefined(i18n['You’re now adding ALL']) ? 'You’re now adding ALL':i18n['You’re now adding ALL']);
                                    $('.additional-label2').text(_.isUndefined(i18n['Uncheck this box if you wish to add']) ? 'Uncheck this box if you wish to add':i18n['Uncheck this box if you wish to add']);

                                    if(countOrganizationLeads == 1) {
                                        $('.additional-label-label-main').text((_.isUndefined(i18n['record (with an email address) matching your filter to your mailing list.']) ? 'record (with an email address) matching your filter to your mailing list.':i18n['record (with an email address) matching your filter to your mailing list.']));

                                        $('.original-label-main').text(_.isUndefined(i18n['record (with an email address) to your mailing list.']) ? 'record (with an email address) to your mailing list.':i18n['record (with an email address) to your mailing list.']);
                                        $('.send-email-service-quantity').text(_.isUndefined(i18n['contact has been successfully added']) ? 'contact has been successfully added':i18n['contact has been successfully added']);
                                    } else {
                                        $('.additional-label-label-main').text((_.isUndefined(i18n['records (with an email address) matching your filter to your mailing list.']) ? 'records (with an email address) matching your filter to your mailing list.':i18n['records (with an email address) matching your filter to your mailing list.']));

                                        $('.original-label-main').text(_.isUndefined(i18n['records (with an email address) to your mailing list.']) ? 'records (with an email address) to your mailing list.':i18n['records (with an email address) to your mailing list.']);
                                        $('.send-email-service-quantity').text(_.isUndefined(i18n['contacts have been successfully added']) ? 'contacts have been successfully added':i18n['contacts have been successfully added']);
                                    }

                                }
                            });


                            $('#organizations-marketing-matching-filter').on('change', function(e){
                                var additionalOrganizationsCounter = $('#quantity-all-leads-data').val();
                                organizationsText = _.isUndefined(i18n['Add/Remove emails to Email Marketing']) ? 'Add/Remove emails to Email Marketing':i18n['Add/Remove emails to Email Marketing'];
                                totalText = _.isUndefined(i18n['Total']) ? 'Total' : i18n['Total'];
                                recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];

                                if ($(this).is(':checked')) {
                                    var organizationsCounter = $('.checked-organizations-counter').text();

                                    $('.checked-organizations-counter').text(additionalOrganizationsCounter);
                                    $('.additional-checked-organizations-counter').text(organizationsCounter);

                                    var emailMarketingFunction = $('input[name=email-marketing-function]:checked').val();

                                    if(additionalOrganizationsCounter > 1) {
                                        recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];

                                        if(emailMarketingFunction == 'unassign') {
                                            $('.additional-label-label-main').text((_.isUndefined(i18n['records (with an email address) matching your filter from your mailing list.']) ? 'records (with an email address) matching your filter from your mailing list.':i18n['records (with an email address) matching your filter from your mailing list.']));
                                        } else {
                                            $('.additional-label-label-main').text((_.isUndefined(i18n['records (with an email address) matching your filter to your mailing list.']) ? 'records (with an email address) matching your filter to your mailing list.':i18n['records (with an email address) matching your filter to your mailing list.']));
                                        }
                                    } else {
                                        recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                        if(emailMarketingFunction == 'unassign') {
                                            $('.additional-label-label-main').text((_.isUndefined(i18n['record (with an email address) matching your filter from your mailing list.']) ? 'record (with an email address) matching your filter from your mailing list.':i18n['record (with an email address) matching your filter from your mailing list.']));
                                        } else {
                                            $('.additional-label-label-main').text((_.isUndefined(i18n['record (with an email address) matching your filter to your mailing list.']) ? 'record (with an email address) matching your filter to your mailing list.':i18n['record (with an email address) matching your filter to your mailing list.']));
                                        }
                                    }

                                    title = organizationsText + ' (' + totalText +' '+ additionalOrganizationsCounter +' '+ recordsText +')';

                                    $('.original-label').hide();
                                    $('.additional-label').show();
                                } else {
                                    var organizationsCounter = $('.additional-checked-organizations-counter').text();
                                    $('.checked-organizations-counter').text(organizationsCounter);
                                    $('.additional-checked-organizations-counter').text(additionalOrganizationsCounter);

                                    if(additionalOrganizationsCounter > 1) {
                                        recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];
                                        $('.original-label-main2').text((_.isUndefined(i18n['records matching your filter.']) ? 'records matching your filter.':i18n['records matching your filter.']));
                                    } else {
                                        recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                                        $('.original-label-main2').text((_.isUndefined(i18n['record matching your filter.']) ? 'record matching your filter.':i18n['record matching your filter.']));
                                    }

                                    title = organizationsText + ' (' + totalText +' '+ organizationsCounter +' '+ recordsText +')';

                                    $('.original-label').show();
                                    $('.additional-label').hide();
                                }

                                $('#action-email-service-dialog').dialog('option', 'title', title);
                            });

                            $('#sent-to-email-service-form').on('submit', function(e){
                                e.preventDefault();
                                $('#organization-send-email-service-quantity').text(0);

                                var emailServiceName = $("#marketing-services").val(),
                                    checkedLists = $(this).find("input.subscribe-to-email-service-list:checked");

                                if(emailServiceName == 'select'){
                                    showMessage(_.isUndefined(i18n['Please choose service'])?'Please choose service':i18n['Please choose service'], true, 5000);
                                    return false;
                                }

                                if(checkedLists.length == 0){
                                    showMessage(_.isUndefined(i18n['Please choose list'])?'Please choose list':i18n['Please choose list'], true, 5000);
                                    return false;
                                }

                                var emailMarketingFunction = $('input[name=email-marketing-function]:checked').val();
                                var requestType = 'assign';

                                if(emailMarketingFunction == 'unassign'){
                                    requestType = 'unassign';
                                }

                                if(emailMarketingFunction == 'assign'){
                                    requestType = 'assign';
                                }

                                $('#send-to-email-service').prop('disabled', true);

                                var lists = [];
                                matchingFilter = 0;
                                lists['ids'] = [];
                                lists['labels'] = [];
                                checkedLists.each(function() {
                                    lists['ids'].push($(this).val());
                                    lists['labels'].push($(this).data('label'));
                                });

                                if ($('#organizations-marketing-matching-filter').is(':checked')) {
                                    matchingFilter = 1;
                                }

                                self.sendToEmailServiceOrganization($(this).attr('action'), emailServiceName, lists, checkedOrganizations, filters, matchingFilter, 0, [], $('#action-email-service-dialog').data('count-selected-organizations'), requestType);
                            });

                            var firstSelectedService = '';

                            if(self.enabledServicesList) {
                                var skipEach = false;
                                $.each(self.enabledServicesList, function(value, listName){
                                    if(typeof listName.status !== 'undefined' && listName.status && !skipEach) {
                                        firstSelectedService = value;
                                        skipEach = true;
                                    }
                                });

                                if(self.firstLoad) {
                                    self.firstLoad = 0;

                                    $('#marketing-services').val(firstSelectedService).trigger('change');
                                }
                            }
                        },
                        close: function(event, ui){
                            $(this).dialog('close').remove();
                        }
                    });
                    return false;
                }

            });
        },
        remarketingCampaignsAction: function(e) {
            var self = this,
                checkedOrganizations = this.checkedOrganizationRows.join(','),
                customerIds = [1],
                filters = this.organizations.server_api.filter();

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/remarketingOrganization/customers/'+customerIds+'/organizationIds/' + checkedOrganizations +'/advertising/1',
                type: 'GET',
                dataType: 'json'
            }).done(function(response) {
                if (response.error == '1') {
                    showMessage(response.responseText, true, 5000);
                } else {
                    var countSelectedLeads = response.countOrganizationLeads,
                        organizationselectedLeads = response.allOrganizatiosLeadsIdsMachingFilter,
                        organizationsText = _.isUndefined(i18n['Add/Remove emails to Ad platforms audiences']) ? 'Add/Remove emails to Ad platforms audiences':i18n['Add/Remove emails to Ad platforms audiences'],
                        totalText = _.isUndefined(i18n['Total'])?'Total':i18n['Total'],
                        recordsText = _.isUndefined(i18n['records'])?'records':i18n['records'];

                    if(countSelectedLeads == 1) {
                        organizationsText = _.isUndefined(i18n['Add/Remove email to Ad platforms audiences']) ? 'Add/Remove email to Ad platforms audiences':i18n['Add/Remove email to Ad platforms audiences'],
                        recordsText = _.isUndefined(i18n['record'])?'record':i18n['record'];
                    }

                    var title = organizationsText + ' (' + totalText +' '+ countSelectedLeads +' '+ recordsText +')';

                    var advertisingLists = response.advertisingList,
                        dialog = _.template(OrganizationActionRemarketingTemplate, {
                            advertisingList:advertisingLists,
                            i18n:i18n,
                            filters : $.param(filters),
                            countSelectedLeads: countSelectedLeads
                        });

                    self.firstLoad = 1;
                    self.enabledAdvertisingLists = advertisingLists;

                    $(dialog).dialog({
                        width: '36%',
                        height: '600',
                        dialogClass: 'seotoaster',
                        resizable:false,
                        draggable: false,
                        'title': _.isUndefined(i18n['Add/Remove emails to Ad platforms audiences'])?'Add/Remove emails to Ad platforms audiences':i18n['Add/Remove emails to Ad platforms audiences'],
                        open: function(event, ui) {
                            $('#action-remarketing-dialog').dialog('option', 'title', title);

                            var originalLabelMain = _.isUndefined(i18n['records (with an email address) to your campaign list.']) ? 'records (with an email address) to your campaign list.':i18n['records (with an email address) to your campaign list.'],
                                additionalLabelLabelMain = _.isUndefined(i18n['records (with an email address) matching your filter to your campaign list.']) ? 'records (with an email address) matching your filter to your campaign list.':i18n['records (with an email address) matching your filter to your campaign list.'],
                                originalLabelMain2 = _.isUndefined(i18n['records matching your filter']) ? 'records matching your filter':i18n['records matching your filter'],
                                additionalLabelLabelMain2 = _.isUndefined(i18n['selected records']) ? 'selected records':i18n['selected records'];

                            if(countSelectedLeads == 1) {
                                originalLabelMain = _.isUndefined(i18n['record (with an email address) to your campaign list.']) ? 'record (with an email address) to your campaign list.':i18n['record (with an email address) to your campaign list.'];
                                additionalLabelLabelMain = _.isUndefined(i18n['record (with an email address) matching your filter to your campaign list.']) ? 'record (with an email address) matching your filter to your campaign list.':i18n['record (with an email address) matching your filter to your campaign list.'];
                            }

                            $('.original-label-main').text(originalLabelMain);
                            $('.original-label-main2').text(originalLabelMain2);

                            $('.additional-label-label-main').text(additionalLabelLabelMain);
                            $('.additional-label-additional').text(additionalLabelLabelMain2);

                            $('#marketing-campaigns').on('change',  function(e){
                                e.stopImmediatePropagation();
                                var checkedListsEl = $("input.subscribe-to-remarketing-list:checked"),
                                    selectedCampaign = $('#marketing-campaigns').val();

                                var audinceListsIds = [],
                                    audinceListsLabels = [];
                                checkedListsEl.each(function() {
                                    var listId = $(this).val(),
                                        listLabel = $(this).data('label');
                                    audinceListsIds.push(listId);
                                    audinceListsLabels.push(listLabel);
                                });

                                self.campaignSelectedListsIds[self.beforeSelectedCampaign.campaign] = audinceListsIds;
                                self.campaignSelectedListsLabels[self.beforeSelectedCampaign.campaign] = audinceListsLabels;

                                if($('#marketing-campaigns').val() !== 'select') {
                                    self.beforeSelectedCampaign.campaign = $('#marketing-campaigns').val();
                                    if($('#marketing-campaigns').val() == 'adwords') {
                                        $('.ad-audience-limit-msg').text(_.isUndefined(i18n['Google Ads throttle their API to a maximum 10k email addition per day.']) ? 'Google Ads throttle their API to a maximum 10k email addition per day.':i18n['Google Ads throttle their API to a maximum 10k email addition per day.']);
                                    } else {
                                        $('.ad-audience-limit-msg').text(_.isUndefined(i18n['FB Ads throttle their API to a maximum 5k email addition per hour.']) ? 'FB Ads throttle their API to a maximum 5k email addition per hour.':i18n['FB Ads throttle their API to a maximum 5k email addition per hour.']);
                                    }
                                } else {
                                    self.beforeSelectedCampaign.campaign = '';
                                    $('.ad-audience-limit-msg').text('');
                                }

                                $.ajax({
                                    url: $('#website_url').val()+'plugin/leads/run/countAllOrganizations/',
                                    type: 'POST',
                                    dataType: 'json',
                                    data:{
                                        'secureToken':$('#lead-organization-grid-token').val(),
                                        'filters':$.param(filters),
                                        'usemassaction': 1,
                                        'uniqueEmail': 1
                                    }
                                }).done(function(response){
                                    if (response.error == '1') {
                                        showMessage(_.isUndefined(i18n['No organizations found'])?'No organizations found':i18n['No organizations found'], true, 5000);
                                    } else {
                                        var organizationLeadsCount = response.responseText.organizationLeadsCount;
                                        allOrganizationIdsMachingFilter = response.responseText.allOrganizatiosLeadsIdsMachingFilter;
                                        $('.additional-checked-organizations-counter').text(organizationLeadsCount);
                                    }
                                });

                                if ($('#organizations-marketing-matching-filter').is(':checked')) {
                                    $('.original-label').hide();
                                    $('.additional-label').show();
                                } else {
                                    $('.original-label').show();
                                    $('.additional-label').hide();
                                }
                                $('#organization-send-remarketing-quantity-block-processing').addClass('hidden');
                                $('#organization-send-remarketing-quantity-processing').text(0);

                                $('#check-all-for-remarketing').addClass('hidden');
                                $('#add-new-lists').addClass('hidden');
                                if (selectedCampaign != 'select') {
                                    $.ajax({
                                        url: $('#website_url').val()+'plugin/leads/run/getAdvertisingService/serviceName/'+selectedCampaign,
                                        type: 'GET',
                                        dataType: 'json'
                                    }).done(function(response) {
                                        if(response.error == 1){
                                            if(response.responseText.message == 'No ad account assigned to this website') {
                                                var googleAdAccount = 'Google Adwords',
                                                    facebookAdAccount = 'Facebook Ad',
                                                    accountName = facebookAdAccount;

                                                if(selectedCampaign == 'adwords') {
                                                    accountName = googleAdAccount;
                                                }

                                                var connectionMessage = (_.isUndefined(i18n['You need first to connect a '+ accountName +' account. Click'])?'You need first to connect a '+ accountName +' account. Click':i18n['You need first to connect a '+ accountName +' account. Click'])
                                                    + ' ' + '<a href="' + $('#website_url').val() + '/plugin/leads/run/advertiserAccountConfig/" target="_blank" title="Click to open config" style="text-decoration: underline;">' + (_.isUndefined(i18n['here'])?'here':i18n['here']) +'</a>'
                                                    + ' ' + (_.isUndefined(i18n['to access the configuration panel'])?'to access the configuration panel':i18n['to access the configuration panel']);
                                                showMessage(connectionMessage, true, 6000);
                                            } else {
                                                showMessage(_.isUndefined(i18n[response.responseText.message])?response.responseText.message:i18n[response.responseText.message], false, 1000);
                                            }

                                            $('#subscribe-list').remove();
                                            $('#send-to-remarketing').addClass('hidden');
                                            $('#check-all-for-remarketing').addClass('hidden');
                                            $('#add-new-lists').addClass('hidden');
                                            $('.horizontal-line').addClass('hidden');
                                            $('#marketing-campaigns').val('select');
                                            $('.ad-audience-limit-msg').text('');
                                            return false;
                                        }else{
                                            $('#subscribe-list').remove();
                                            var subscribeList = '<div class="grid_12 mt10px scroll" id="subscribe-list" style="height:145px;">',
                                                list = response.responseText.list;

                                            if(list !== null && list.length > 0) {
                                                $.each(list, function(key, listData){
                                                    var isChecked = '';
                                                    if(typeof self.campaignSelectedListsIds[selectedCampaign] !== 'undefined' && self.campaignSelectedListsIds[selectedCampaign].indexOf(listData.id.toString()) !== -1) {
                                                        isChecked = 'checked';
                                                    }
                                                    subscribeList += '<label class="mr30px pointer"> <input type="checkbox" '+ isChecked +' class="subscribe-to-remarketing-list" name="list" value="'+ listData.id +'" data-label="'+ listData.name +'"/><span>'+ listData.name + ' (id: ' + listData.id + ')' + '</span></label>';
                                                });
                                            } else {
                                                subscribeList += (_.isUndefined(i18n['No available lists'])?'No available lists':i18n['No available lists']);
                                            }
                                            subscribeList += '</div>';

                                            $('#marketing-campaigns').after(subscribeList);
                                            $('#send-to-remarketing').removeClass('hidden');
                                            $('#check-all-for-remarketing').removeClass('hidden');
                                            $('#add-new-lists').removeClass('hidden');
                                            $('.horizontal-line').removeClass('hidden');
                                        }
                                    });

                                    $('#send-to-remarketing').data('count-selected-leads', countSelectedLeads);
                                }else{
                                    $('#send-to-remarketing').addClass('hidden');
                                    $('.horizontal-line').addClass('hidden');
                                    $('#subscribe-list').remove();
                                }
                            });

                            $('#add-list-form-save').on('click', function(e){
                                var account = $("#marketing-campaigns").val(),
                                    listName = $('#list-name').val().replace(/[^a-zA-Z0-9-_ ]/g, '');

                                if(listName != '') {
                                    $('#list-name').val(listName);
                                    showConfirm(_.isUndefined(i18n['Are you sure want add new list?'])?'Are you sure want add new list?':i18n['Are you sure want add new list?'], function(){
                                        $.ajax({
                                            'url': $('#website_url').val() + 'plugin/leads/run/addAdvertiserlist/',
                                            'type': 'POST',
                                            'dataType': 'json',
                                            'data': {
                                                'secureToken' : $('#lead-organization-grid-token').val(),
                                                'listName': listName,
                                                'account': account
                                            }
                                        }).done(function (response) {
                                            hideLoader();
                                            if (response.error == '1') {
                                                showMessage(response.responseText.message, true, 2000);
                                                return false;
                                            } else {
                                                if(typeof response.responseText.listId === 'undefined') {
                                                    showMessage(response.responseText.message, true, 2000);
                                                } else {
                                                    showMessage('(list: '+response.responseText.listId+') created successfully', false, 2000);
                                                    var newList = '<label class="mr30px pointer"> <input type="checkbox" class="subscribe-to-remarketing-list" name="list" value="'+ response.responseText.listId +'" data-label="'+ listName +'"/><span>'+ listName + ' (id: ' + response.responseText.listId + ')' + '</span></label>';
                                                    $('#subscribe-list').prepend(newList);
                                                }

                                                $('#list-name').val('');
                                            }

                                        }).fail(function(response){
                                            hideLoader();
                                            showMessage(_.isUndefined(i18n['Can\'t add list'])?'Can\'t add list':i18n['Can\'t add list'], true, 2000);
                                        });

                                    }, function () {
                                        return false;
                                    });
                                } else {
                                    showMessage(_.isUndefined(i18n['Please enter list name'])?'Please enter list name':i18n['Please enter list name'], true, 2000);
                                }
                            });

                            $('body').on('change', '.change-email-remarketing', function(e) {
                                var emailRemarketingFunction = $('input[name=remarketing-function]:checked').val();
                                if(emailRemarketingFunction == 'unassign') {
                                    $('.information-msg').text(_.isUndefined(i18n['To ensure that all emails are removed from your remarketing audience(s), please do not close this window until all records have been processed.']) ? 'To ensure that all emails are removed from your remarketing audience(s), please do not close this window until all records have been processed.':i18n['To ensure that all emails are removed from your remarketing audience(s), please do not close this window until all records have been processed.']);
                                    $('#send-to-remarketing').val(_.isUndefined(i18n['Remove contact(s) from list']) ? 'Remove contact(s) from list':i18n['Remove contact(s) from list']);
                                    $('.original-label1').text(_.isUndefined(i18n['You’re now removing']) ? 'You’re now removing':i18n['You’re now removing']);
                                    $('.original-label2').text(_.isUndefined(i18n['Check this box if you wish to remove ALL']) ? 'Check this box if you wish to remove ALL':i18n['Check this box if you wish to remove ALL']);
                                    $('.additional-label1').text(_.isUndefined(i18n['You’re now removing ALL']) ? 'You’re now removing ALL':i18n['You’re now removing ALL']);
                                    $('.additional-label2').text(_.isUndefined(i18n['Uncheck this box if you wish to remove']) ? 'Uncheck this box if you wish to remove':i18n['Uncheck this box if you wish to remove']);

                                    if(countSelectedLeads == 1) {
                                        $('.send-email-remarketing-quantity').text(_.isUndefined(i18n['contact has been successfully removed']) ? 'contact has been successfully removed':i18n['contact has been successfully removed']);
                                        originalLabelMain = _.isUndefined(i18n['record (with an email address) from your campaign list.']) ? 'record (with an email address) from your campaign list.':i18n['record (with an email address) from your campaign list.'];
                                        additionalLabelLabelMain = _.isUndefined(i18n['record (with an email address) matching your filter from your campaign list.']) ? 'record (with an email address) matching your filter from your campaign list.':i18n['record (with an email address) matching your filter from your campaign list.'];
                                    } else {
                                        $('.send-email-remarketing-quantity').text(_.isUndefined(i18n['contacts have been successfully removed']) ? 'contacts have been successfully removed':i18n['contacts have been successfully removed']);
                                        originalLabelMain = _.isUndefined(i18n['records (with an email address) from your campaign list.']) ? 'records (with an email address) from your campaign list.':i18n['records (with an email address) from your campaign list.'];
                                        additionalLabelLabelMain = _.isUndefined(i18n['records (with an email address) matching your filter from your campaign list.']) ? 'records (with an email address) matching your filter from your campaign list.':i18n['records (with an email address) matching your filter from your campaign list.'];
                                    }

                                } else {
                                    $('.information-msg').text(_.isUndefined(i18n['To ensure that all emails are added to your remarketing audience(s), please do not close this window until all records have been processed.']) ? 'To ensure that all emails are added to your remarketing audience(s), please do not close this window until all records have been processed.':i18n['To ensure that all emails are added to your remarketing audience(s), please do not close this window until all records have been processed.']);
                                    $('#send-to-remarketing').val(_.isUndefined(i18n['Add contact(s) to list']) ? 'Add contact(s) to list':i18n['Add contact(s) to list']);
                                    $('.original-label1').text(_.isUndefined(i18n['You’re now adding']) ? 'You’re now adding':i18n['You’re now adding']);
                                    $('.original-label2').text(_.isUndefined(i18n['Check this box if you wish to add ALL']) ? 'Check this box if you wish to add ALL':i18n['Check this box if you wish to add ALL']);
                                    $('.additional-label1').text(_.isUndefined(i18n['You’re now adding ALL']) ? 'You’re now adding ALL':i18n['You’re now adding ALL']);
                                    $('.additional-label2').text(_.isUndefined(i18n['Uncheck this box if you wish to add']) ? 'Uncheck this box if you wish to add':i18n['Uncheck this box if you wish to add']);

                                    if(countSelectedLeads == 1) {
                                        $('.send-email-remarketing-quantity').text(_.isUndefined(i18n['contact has been successfully added']) ? 'contact has been successfully added':i18n['contact has been successfully added']);
                                        originalLabelMain = _.isUndefined(i18n['record (with an email address) to your campaign list.']) ? 'record (with an email address) to your campaign list.':i18n['record (with an email address) to your campaign list.'];
                                        additionalLabelLabelMain = _.isUndefined(i18n['record (with an email address) matching your filter to your campaign list.']) ? 'record (with an email address) matching your filter to your campaign list.':i18n['record (with an email address) matching your filter to your campaign list.'];
                                    } else {
                                        $('.send-email-remarketing-quantity').text(_.isUndefined(i18n['contacts have been successfully added']) ? 'contacts have been successfully added':i18n['contacts have been successfully added']);
                                        originalLabelMain = _.isUndefined(i18n['records (with an email address) to your campaign list.']) ? 'records (with an email address) to your campaign list.':i18n['records (with an email address) to your campaign list.'];
                                        additionalLabelLabelMain = _.isUndefined(i18n['records (with an email address) matching your filter to your campaign list.']) ? 'records (with an email address) matching your filter to your campaign list.':i18n['records (with an email address) matching your filter to your campaign list.'];
                                    }
                                }

                                $('.original-label-main').text(originalLabelMain);
                                $('.additional-label-label-main').text(additionalLabelLabelMain);
                            });

                            $('#organizations-marketing-matching-filter').on('change', function(e){
                                var checkedOrganizationsCounter = $('.checked-organizations-counter').text();
                                var additionalCheckedOrganizationsCounter = $('.additional-checked-organizations-counter').text();

                                if ($(this).is(':checked')) {
                                    $('#send-to-remarketing').data('count-selected-leads', additionalCheckedOrganizationsCounter);
                                    $('.checked-organizations-counter').text(additionalCheckedOrganizationsCounter);
                                    $('.additional-checked-organizations-counter').text(checkedOrganizationsCounter);

                                    $('.original-label').hide();
                                    $('.additional-label').show();

                                    if(additionalCheckedOrganizationsCounter > 1) {
                                        $('.additional-label-label-main').text(_.isUndefined(i18n['records (with an email address) to your campaign list.']) ? 'records (with an email address) to your campaign list.':i18n['records (with an email address) to your campaign list.']);
                                        title = organizationsText + ' (' + totalText +' '+ additionalCheckedOrganizationsCounter +' '+ (_.isUndefined(i18n['records'])?'records':i18n['records']) +')';
                                    } else {
                                        $('.additional-label-label-main').text(_.isUndefined(i18n['record (with an email address) to your campaign list.']) ? 'record (with an email address) to your campaign list.':i18n['record (with an email address) to your campaign list.']);
                                        title = organizationsText + ' (' + totalText +' '+ additionalCheckedOrganizationsCounter +' '+ (_.isUndefined(i18n['record'])?'record':i18n['record']) +')';
                                    }

                                    if(checkedOrganizationsCounter > 1) {
                                        $('.additional-label-label-main2').text(_.isUndefined(i18n['selected records']) ? 'selected records':i18n['selected records']);
                                    } else {
                                        $('.additional-label-label-main2').text(_.isUndefined(i18n['selected record']) ? 'selected record':i18n['selected record']);
                                    }
                                    $('#action-remarketing-dialog').dialog('option', 'title', title);
                                } else {
                                    $('#send-to-remarketing').data('count-selected-leads', checkedOrganizationsCounter);
                                    $('.original-label').show();
                                    $('.additional-label').hide();
                                    $('.checked-organizations-counter').text(additionalCheckedOrganizationsCounter);
                                    $('.additional-checked-organizations-counter').text(checkedOrganizationsCounter);
                                    if(additionalCheckedOrganizationsCounter > 1) {
                                        title = organizationsText + ' (' + totalText +' '+ additionalCheckedOrganizationsCounter +' '+ (_.isUndefined(i18n['records'])?'records':i18n['records']) +')';
                                    } else {
                                        title = organizationsText + ' (' + totalText +' '+ additionalCheckedOrganizationsCounter +' '+ (_.isUndefined(i18n['record'])?'record':i18n['record']) +')';
                                    }
                                    $('#action-remarketing-dialog').dialog('option', 'title', title);
                                }
                            });

                            $('#sent-to-remarketing-form').on('submit', function(e){
                                e.preventDefault();
                                $('#organization-send-remarketing-quantity-processing').text(0);
                                $('#check-all-for-remarketing').addClass('hidden');
                                $('#organization-send-remarketing-quantity-block').addClass('hidden');

                                var marketingCampaignsName = $("#marketing-campaigns").val(),
                                    checkedLists = $(this).find("input.subscribe-to-remarketing-list:checked");

                                if(marketingCampaignsName == 'select'){
                                    showMessage(_.isUndefined(i18n['Please choose service'])?'Please choose service':i18n['Please choose service'], true, 5000);
                                    $('#check-all-for-remarketing').removeClass('hidden');
                                    return false;
                                }

                                if(checkedLists.length == 0){
                                    showMessage(_.isUndefined(i18n['Please choose list'])?'Please choose list':i18n['Please choose list'], true, 5000);
                                    $('#check-all-for-remarketing').removeClass('hidden');
                                    return false;
                                }

                                $('#send-to-remarketing').prop('disabled', true);

                                var lists = [];
                                var matchingFilter = 0;
                                self.campaignSelectedListsIds[marketingCampaignsName] = [];
                                self.campaignSelectedListsLabels[marketingCampaignsName] = [];

                                var audinceListsIds = [],
                                    audinceListsLabels = [];
                                checkedLists.each(function() {
                                    var listId = $(this).val(),
                                        listLabel = $(this).data('label');
                                    audinceListsIds.push(listId);
                                    audinceListsLabels.push(listLabel);
                                });

                                self.campaignSelectedListsIds[marketingCampaignsName] = audinceListsIds;
                                self.campaignSelectedListsLabels[marketingCampaignsName] = audinceListsLabels;

                                lists['ids'] = self.campaignSelectedListsIds;
                                lists['names'] = self.campaignSelectedListsLabels;

                                if ($('#organizations-marketing-matching-filter').is(':checked')) {
                                    matchingFilter = 1;
                                }

                                var remarketingFunction = $('input[name=remarketing-function]:checked').val();
                                var requestType = 'assign';

                                if(remarketingFunction == 'unassign'){
                                    requestType = 'unassign';
                                }

                                if(remarketingFunction == 'assign'){
                                    requestType = 'assign';
                                }

                                if ($('#organizations-marketing-matching-filter').is(':checked')) {
                                    organizationselectedLeads = allOrganizationIdsMachingFilter;
                                }

                                self.sendToRemarketingList($(this).attr('action'), marketingCampaignsName, lists, organizationselectedLeads.join(','), filters, matchingFilter, 0, [], $('#send-to-remarketing').data('count-selected-leads'), requestType);
                            });

                            var firstSelectedService = '';

                            if(self.enabledAdvertisingLists) {
                                var skipEach = false;
                                $.each(self.enabledAdvertisingLists, function(value, listName){
                                    if(typeof listName !== 'undefined' && listName && !skipEach) {
                                        firstSelectedService = value;
                                        skipEach = true;
                                    }
                                });

                                if(self.firstLoad) {
                                    self.firstLoad = 0;
                                }
                            }
                        },
                        close: function(event, ui){
                            $(this).dialog('close').remove();
                        }
                    });
                    return false;
                }
            });

        },
        sendToRemarketingList: function(action, marketingCampaignsName, lists, organizationselectedLeads, filters, matchingFilter, stepToRemarketingListService, accountErrors, countSelectedLeads, requestType){
            var self = this,
                importedEl = $('#organization-send-remarketing-quantity-processing');

            self.beforeSelectedCampaign.campaign = '';
            self.campaignSelectedListsIds = {};
            self.campaignSelectedListsLabels = {};

            $.ajax({
                url: action,
                type: 'POST',
                dataType: 'json',
                'data' : {
                    'secureToken': $('#lead-organization-grid-token').val(),
                    'marketingCampaignsName': marketingCampaignsName,
                    'lists': JSON.stringify(lists['ids']),
                    'listsLabels': JSON.stringify(lists['names']),
                    leadIds:organizationselectedLeads,
                    //'filters' : $.param(filters),
                    'matchingFilter': matchingFilter,
                    'stepToRemarketingListService' : stepToRemarketingListService,
                    'accountErrors': accountErrors,
                    'filterQuantity': $('#send-to-remarketing').data('count-selected-leads'),
                    'requestType': requestType,
                    'gridType': 'organizations'
                }
            }).done(function(response) {
                $('#organization-send-remarketing-quantity-block-processing').removeClass('hidden');
                if(response.error == 0){
                    var accountErrors = [];
                    if(response.responseText.accountErrors) {
                        accountErrors = response.responseText.accountErrors;
                    }
                    self.sendToRemarketingList(action, marketingCampaignsName, lists, organizationselectedLeads, filters, matchingFilter, stepToRemarketingListService + 1, accountErrors, countSelectedLeads, requestType);
                } else {
                    $('#organization-send-remarketing-quantity-block-processing').addClass('hidden');
                    if(typeof response.responseText.accountErrors !== 'undefined') {
                        var errorMessage = response.responseText.message,
                            errorInformation = '<p>';

                        $.each(response.responseText.accountErrors, function(value, errorName){
                            $.each(lists.ids, function(lkey, lname){
                                if(lkey != '') {
                                    $.each(lname, function(llkey, llname){
                                        if(typeof errorName[llname] !== 'undefined') {
                                            errorInformation += lkey + ': ' + lists.names[lkey][llkey] + '(' + llname + ') has error: ' + errorName[llname] + '<br />';
                                        }
                                    });
                                }
                            })
                        });

                        errorInformation += '</p>';
                        if(!response.responseText.accountErrors.length) {
                            if(requestType == 'assign') {
                                showMessage(_.isUndefined(i18n['Added to Ad audience list(s)'])?'Added to Ad audience list(s)':i18n['Added to Ad audience list(s)'], false, 5000);
                            } else {
                                showMessage(_.isUndefined(i18n['Removed from Ad audience list(s)'])?'Removed from Ad audience list(s)':i18n['Removed from Ad audience list(s)'], false, 5000);
                            }
                        } else {
                            showMessage(errorMessage + errorInformation, true, 5000);
                        }
                        $('#send-to-remarketing').prop('disabled', false);
                        $('#check-all-for-remarketing').removeClass('hidden');
                        $('#organization-send-remarketing-quantity-block').removeClass('hidden');
                    } else {
                        $('#organization-send-remarketing-quantity-block').removeClass('hidden');
                        if(requestType == 'assign') {
                            showMessage(_.isUndefined(i18n['Added to Ad audience list(s)'])?'Added to Ad audience list(s)':i18n['Added to Ad audience list(s)'], false, 5000);
                        } else {
                            showMessage(_.isUndefined(i18n['Removed from Ad audience list(s)'])?'Removed from Ad audience list(s)':i18n['Removed from Ad audience list(s)'], false, 5000);
                        }
                        $('#send-to-remarketing').prop('disabled', false);
                        $('#check-all-for-remarketing').removeClass('hidden');
                    }
                }
                importedEl.text(parseInt(importedEl.text()) + parseInt(response.responseText.quantity));
            }).fail(function(response){
                showMessage(response.responseJSON.responseText, true, 5000);
            });
        },
        sendToEmailServiceOrganization: function(action, emailServiceName, lists, checkedOrganizations, filters, matchingFilter, stepSendEmailService, invalidLeads, countSelectedOrganizations, requestType){
            var self = this,
                importedEl = $('#organization-send-email-service-quantity'),
                importedElBlock = $('#organization-send-email-service-quantity-block');
            $.ajax({
                url: action,
                type: 'POST',
                dataType: 'json',
                'data' : {
                    'secureToken': $('#lead-organization-grid-token').val(),
                    'emailServiceName': emailServiceName,
                    'lists': lists['ids'].join(','),
                    'listsLabels': lists['labels'].join(','),
                    'organizationIds':checkedOrganizations,
                    'detailedInfo': $('#email-service-detailed-info').val(),
                    'filters' : $.param(filters),
                    'matchingFilter': matchingFilter,
                    'stepSendEmailService' : stepSendEmailService,
                    'invalidLeads': invalidLeads,
                    'filterQuantity': $('#send-to-email-service').data('count-selected-organizations'),
                    'requestType': requestType
                }
            }).done(function(response) {
                importedElBlock.removeClass('hidden');
                if(response.error == 0){
                    var invalidLeads = [];
                    if(response.responseText.invalidLeads) {
                        invalidLeads = response.responseText.invalidLeads;
                    }
                    self.sendToEmailServiceOrganization(action, emailServiceName, lists, checkedOrganizations, filters, matchingFilter, stepSendEmailService + 1, invalidLeads, countSelectedOrganizations, requestType);
                } else {
                    if(typeof response.responseText.errorFileName !== 'undefined') {
                        var errorMessage = response.responseText.message,
                            downloadErrFileLink = '<a class="btn error fl-right grid_12" href="'+$('#website_url').val()+'plugin/leads/run/downloadFile/?fileName='+response.responseText.errorFileName+'" >'+(_.isUndefined(i18n['Download error log'])?'Download error log':i18n['Download error log'])+'</a>'+ '';

                        showMessage(errorMessage, true, 5000);
                        $('#leads-error-btn').empty().show().append(downloadErrFileLink);
                    } else {
                        if(requestType == 'assign') {
                            showMessage(_.isUndefined(i18n['Contact(s) added'])?'Contact(s) added':i18n['Contact(s) added'], false, 5000);
                        } else {
                            showMessage(_.isUndefined(i18n['Contact(s) removed'])?'Contact(s) removed':i18n['Contact(s) removed'], false, 5000);
                        }
                        $('#send-to-email-service').prop('disabled', false);
                    }
                }
                importedEl.text(parseInt(importedEl.text()) + parseInt(response.responseText.quantity));
            }).fail(function(response){
                showMessage(response.responseJSON.responseText, true, 5000);
            });
        },
        massDeleteOrganizationsRequest: function(action, checkedOrganizations, filters, matchingFilter, step, countSelectedOrganizations, filterQuantity = null){
            var self = this,
                origProcessedDeletedEl = $('.orig-processed').find('.mass-delete-organizations-quantity'),
                endProcessedDeletedEl = $('.end-processed').find('.mass-delete-organizations-quantity'),
                deletedElBlock = $('#mass-delete-organizations-quantity-block');
            filterQuantity = filterQuantity === null ? $('#delete-organizations-dialog').data('count-selected-organizations'):filterQuantity;
            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/deleteMassOrganizations/',
                type: 'POST',
                dataType: 'json',
                'data' : {'secureToken': $('#lead-organization-grid-token').val(), organizationIds:checkedOrganizations, 'step':step, 'filters' : $.param(filters), 'matchingFilter': matchingFilter, 'filterQuantity': filterQuantity}
            }).done(function(response) {
                if(countSelectedOrganizations == 1) {
                    $('.deleted-organizations-orig-processed').text((_.isUndefined(i18n['organization processed so far']) ? 'organization processed so far':i18n['organization processed so far']));
                    $('.deleted-organizations-end-processed').text((_.isUndefined(i18n['organization has been deleted']) ? 'organization has been deleted' : i18n['organization has been deleted']));
                }

                deletedElBlock.removeClass('hidden');
                if (response.error == 0) {
                    if (filterQuantity === null) {
                        self.massDeleteOrganizationsRequest(action, checkedOrganizations, filters, matchingFilter, step + 1, countSelectedOrganizations);
                    } else {
                        self.massDeleteOrganizationsRequest(action, checkedOrganizations, filters, matchingFilter, step + 1, countSelectedOrganizations, filterQuantity);
                    }
                } else {
                    if(typeof response.responseText.errorFileName !== 'undefined') {
                        var errorMessage = response.responseText.message;
                        showMessage(errorMessage, true, 5000);
                    } else {
                        $('.orig-processed').addClass('hidden');
                        $('.end-processed').removeClass('hidden');
                        $('.matching-filter').hide();
                        $('.cl-none').hide();
                        window.appLeadOrganizationRouter.OrganizationMainView.applyFilter();
                    }
                }
                origProcessedDeletedEl.text(parseInt(origProcessedDeletedEl.text()) + parseInt(response.responseText.quantity));
                endProcessedDeletedEl.text(parseInt(endProcessedDeletedEl.text()) + parseInt(response.responseText.quantity));
            }).fail(function(response){
                showMessage(response.responseJSON.responseText, true, 5000);
            });
        },
        specialPageNavigator: function(pageNumber){
            var page = pageNumber;
            if ($.isNumeric(page)){
                this.organizations.goTo(page);
            }
        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.organizations.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.organizations.goTo(this.organizations.firstPage);
                        break;
                    case 'last':
                        this.organizations.goTo(this.organizations.information.lastPage);
                        break;
                    case 'prev':
                        this.organizations.requestPreviousPage();
                        break;
                    case 'next':
                        this.organizations.requestNextPage();
                        break;
                }
            }
        }
    });

    return LeadsOrganizationsGridView;
});
