<?php
/**
 * Text only widget
 *
 */
class Widgets_Textonly_Textonly extends Widgets_WebbuilderWidget {
    /**
     * Unique separator for show-more in content
     */

    const TEXT_SEPARATOR = '#show-more#';

    /**
     * Enable show-more in container
     */

    const SHOW_MORE = 'show-more';

    /**
     * Disable html tags
     */

    const DENY = 'deny';



   	protected function _load(){
        // get container by its name
        $name      = Webbuilder_Tools_Misc::toHash($this->_options[0] . __CLASS__);
        $pageId    = (end($this->_options) == 'static') ? 0 : $this->_toasterOptions['id'];
        $type      = ($pageId) ? Application_Model_Models_Container::TYPE_REGULARCONTENT : Application_Model_Models_Container::TYPE_STATICCONTENT;
        $container = Application_Model_Mappers_ContainerMapper::getInstance()->findByName($name, $pageId, $type);
        $content = ($container instanceof Application_Model_Models_Container) ? $container->getContent() : '';
        $showMoreOption = array_search(self::SHOW_MORE, $this->_options);

        if($type === Application_Model_Models_Container::TYPE_REGULARCONTENT && $showMoreOption !== false && $container){
            $len = strlen(self::TEXT_SEPARATOR);
            $textButton = $this->_translator->translate('show more...');
            $textButtonFloat = $this->_translator->translate('read less');
            $numbersSymbols = 0;
            $denyShowMore = false;
            $separatorExistence = mb_strpos(html_entity_decode($container->getContent(), ENT_COMPAT, 'UTF-8'), self::TEXT_SEPARATOR, 0, 'UTF-8');

            if(!empty($this->_options[$showMoreOption+1])){
                $buttonParams = $this->_options[$showMoreOption+1];
                $buttonParams = explode('|',$buttonParams);
                $textButton = $buttonParams[0];
                $textButtonFloat = $buttonParams[1];
            }
            $textButton = '<span class="text-only-show-more-widget-button-show"><a href="#" title="'.$textButton.'">'. $textButton . '</a></span>';
            $textButtonFloat = '<span class="text-only-show-more-widget-button-less"><a href="#" title="'. $textButtonFloat .'">'. $textButtonFloat . '</a></span>';

            $denyTags = array_search(self::DENY , $this->_options);
            $clearContent = '';
            if($denyTags !== false){
                $clearContent = strip_tags($container->getContent());
            }

            if(!empty($this->_options[$showMoreOption+2])){
                $numbersSymbols = (int)$this->_options[$showMoreOption+2];
            }
            $contentLen = mb_strlen(html_entity_decode($clearContent, ENT_COMPAT, 'UTF-8'),'UTF-8');
            $separatorExistenceClearContent = mb_strpos(html_entity_decode($clearContent, ENT_COMPAT, 'UTF-8'), self::TEXT_SEPARATOR, 0, 'UTF-8') + $len;
            if($separatorExistence !== false){
                if(!empty($clearContent)){
                    if($separatorExistenceClearContent >= $contentLen){
                        $denyShowMore = true;
                        $clearContent = str_replace(self::TEXT_SEPARATOR, ' ', $clearContent);
                    }
                    $container->setContent($clearContent);
                }
                $contentOpenPart = mb_substr(html_entity_decode($container->getContent(), ENT_COMPAT, 'UTF-8'), 0, mb_strpos(html_entity_decode($container->getContent(),ENT_COMPAT, 'UTF-8'), self::TEXT_SEPARATOR, 0, 'UTF-8'), 'UTF-8');
                $contentClosePart = mb_substr(html_entity_decode($container->getContent(), ENT_COMPAT, 'UTF-8'),mb_strpos(html_entity_decode($container->getContent(),ENT_COMPAT, 'UTF-8'), self::TEXT_SEPARATOR, 0, 'UTF-8') + $len, null, 'UTF-8');
            }else{
                if(!empty($clearContent)){
                    $container->setContent($clearContent);
                }
                $contentOpenPart = mb_substr(html_entity_decode($container->getContent(), ENT_COMPAT, 'UTF-8'), 0, $numbersSymbols, 'UTF-8');
                $contentClosePart = mb_substr(html_entity_decode($container->getContent(), ENT_COMPAT, 'UTF-8'), $numbersSymbols, null, 'UTF-8');

                if($numbersSymbols > $contentLen){
                    $denyShowMore = true;
                }
            }
            if(!empty($content)){
                $showMoreFirstPart = '<span class="text-only-show-more-widget-open">'.$contentOpenPart.'</span>';
                $showMoreLastPart = '<div class="text-only-show-more-content">'.$showMoreFirstPart.$textButton.'<span class="text-only-show-more-widget-close">'.$contentClosePart.' '.$textButtonFloat.'</span></div>';


                if(($separatorExistence !== false || $numbersSymbols) && (!$denyShowMore)){
                    $content = $showMoreLastPart;
                }
            }
        }
        if ($showMoreOption !== false){
            $this->_view->showMoreflag = true;
        }

        if(empty($content) && in_array(Widgets_Content_Content::DEFAULT_CONTENT, $this->_options)){
            $optionKey = array_search(Widgets_Content_Content::DEFAULT_CONTENT, $this->_options);
            if(isset($this->_options[$optionKey+1])){
                $defaultText = filter_var($this->_options[$optionKey+1], FILTER_SANITIZE_STRING);
            }
            if(!empty($defaultText)){
                $content = $defaultText;
            }
        }

        // assign view variables
        $this->_view->content = $content;
        $this->_view->container = $name;
        $this->_view->pageId    = $pageId;
        return $this->_view->render('textonly.phtml');
	}
}
