
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `una1400`
--

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_cmts`
--

CREATE TABLE `bx_persons_cmts` (
  `cmt_id` int(11) NOT NULL AUTO_INCREMENT,
  `cmt_parent_id` int(11) NOT NULL DEFAULT '0',
  `cmt_vparent_id` int(11) NOT NULL DEFAULT '0',
  `cmt_object_id` int(11) NOT NULL DEFAULT '0',
  `cmt_author_id` int(11) NOT NULL DEFAULT '0',
  `cmt_level` int(11) NOT NULL DEFAULT '0',
  `cmt_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cmt_mood` tinyint(4) NOT NULL DEFAULT '0',
  `cmt_rate` int(11) NOT NULL DEFAULT '0',
  `cmt_rate_count` int(11) NOT NULL DEFAULT '0',
  `cmt_time` int(11) unsigned NOT NULL DEFAULT '0',
  `cmt_replies` int(11) NOT NULL DEFAULT '0',
  `cmt_pinned` int(11) NOT NULL DEFAULT '0',
  `cmt_cf` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`cmt_id`),
  KEY `cmt_object_id` (`cmt_object_id`,`cmt_parent_id`),
  FULLTEXT KEY `search_fields` (`cmt_text`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_cmts_notes`
--

CREATE TABLE `bx_persons_cmts_notes` (
  `cmt_id` int(11) NOT NULL AUTO_INCREMENT,
  `cmt_parent_id` int(11) NOT NULL DEFAULT '0',
  `cmt_vparent_id` int(11) NOT NULL DEFAULT '0',
  `cmt_object_id` int(11) NOT NULL DEFAULT '0',
  `cmt_author_id` int(11) NOT NULL DEFAULT '0',
  `cmt_level` int(11) NOT NULL DEFAULT '0',
  `cmt_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cmt_mood` tinyint(4) NOT NULL DEFAULT '0',
  `cmt_rate` int(11) NOT NULL DEFAULT '0',
  `cmt_rate_count` int(11) NOT NULL DEFAULT '0',
  `cmt_time` int(11) unsigned NOT NULL DEFAULT '0',
  `cmt_replies` int(11) NOT NULL DEFAULT '0',
  `cmt_pinned` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cmt_id`),
  KEY `cmt_object_id` (`cmt_object_id`,`cmt_parent_id`),
  FULLTEXT KEY `search_fields` (`cmt_text`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_data`
--

CREATE TABLE `bx_persons_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `author` int(10) unsigned NOT NULL,
  `added` int(11) NOT NULL,
  `changed` int(11) NOT NULL,
  `picture` int(11) NOT NULL,
  `cover` int(11) NOT NULL,
  `cover_data` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fullname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `gender` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `labels` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `location` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `views` int(11) NOT NULL DEFAULT '0',
  `rate` float NOT NULL DEFAULT '0',
  `votes` int(11) NOT NULL DEFAULT '0',
  `score` int(11) NOT NULL DEFAULT '0',
  `sc_up` int(11) NOT NULL DEFAULT '0',
  `sc_down` int(11) NOT NULL DEFAULT '0',
  `favorites` int(11) NOT NULL DEFAULT '0',
  `comments` int(11) NOT NULL DEFAULT '0',
  `reports` int(11) NOT NULL DEFAULT '0',
  `featured` int(11) NOT NULL DEFAULT '0',
  `allow_view_to` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '3',
  `allow_post_to` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '5',
  `allow_contact_to` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '3',
  `settings` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `search_fields` (`fullname`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_favorites_track`
--

CREATE TABLE `bx_persons_favorites_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id` (`object_id`,`author_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_meta_keywords`
--

CREATE TABLE `bx_persons_meta_keywords` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(10) unsigned NOT NULL,
  `keyword` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `object_id` (`object_id`),
  KEY `keyword` (`keyword`(250))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_meta_locations`
--

CREATE TABLE `bx_persons_meta_locations` (
  `object_id` int(10) unsigned NOT NULL,
  `lat` double NOT NULL,
  `lng` double NOT NULL,
  `country` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `street` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `street_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`object_id`),
  KEY `country_state_city` (`country`,`state`(8),`city`(8))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_meta_mentions`
--

CREATE TABLE `bx_persons_meta_mentions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(10) unsigned NOT NULL,
  `profile_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `object_id` (`object_id`),
  KEY `profile_id` (`profile_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_pictures`
--

CREATE TABLE `bx_persons_pictures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profile_id` int(10) unsigned NOT NULL,
  `remote_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` bigint(20) NOT NULL,
  `dimensions` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `added` int(11) NOT NULL,
  `modified` int(11) NOT NULL,
  `private` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `remote_id` (`remote_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_pictures_resized`
--

CREATE TABLE `bx_persons_pictures_resized` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profile_id` int(10) unsigned NOT NULL,
  `remote_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` bigint(20) NOT NULL,
  `added` int(11) NOT NULL,
  `modified` int(11) NOT NULL,
  `private` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `remote_id` (`remote_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_reports`
--

CREATE TABLE `bx_persons_reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_reports_track`
--

CREATE TABLE `bx_persons_reports_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `author_nip` int(11) unsigned NOT NULL DEFAULT '0',
  `type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` int(11) NOT NULL DEFAULT '0',
  `checked_by` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `report` (`object_id`,`author_nip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_scores`
--

CREATE TABLE `bx_persons_scores` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `count_up` int(11) NOT NULL DEFAULT '0',
  `count_down` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_scores_track`
--

CREATE TABLE `bx_persons_scores_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `author_nip` int(11) unsigned NOT NULL DEFAULT '0',
  `type` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `date` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `vote` (`object_id`,`author_nip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_skills`
--

CREATE TABLE `bx_persons_skills` (
  `skill_id` int(11) NOT NULL AUTO_INCREMENT,
  `skill_name` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content_id` int(11) NOT NULL,
  PRIMARY KEY (`skill_id`),
  KEY `content_id` (`content_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_views_track`
--

CREATE TABLE `bx_persons_views_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `viewer_id` int(11) NOT NULL DEFAULT '0',
  `viewer_nip` int(11) unsigned NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id` (`object_id`,`viewer_id`,`viewer_nip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_votes`
--

CREATE TABLE `bx_persons_votes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `count` int(11) NOT NULL DEFAULT '0',
  `sum` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bx_persons_votes_track`
--

CREATE TABLE `bx_persons_votes_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `author_nip` int(11) unsigned NOT NULL DEFAULT '0',
  `value` tinyint(4) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `vote` (`object_id`,`author_nip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_accounts`
--

CREATE TABLE `sys_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `profile_id` int(10) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_confirmed` tinyint(4) NOT NULL DEFAULT '0',
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone_confirmed` tinyint(4) NOT NULL DEFAULT '0',
  `receive_updates` tinyint(4) NOT NULL DEFAULT '1',
  `receive_news` tinyint(4) NOT NULL DEFAULT '1',
  `password` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password_changed` int(11) NOT NULL DEFAULT '0',
  `salt` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `role` tinyint(4) NOT NULL DEFAULT '1',
  `lang_id` int(10) unsigned NOT NULL DEFAULT '0',
  `added` int(11) NOT NULL DEFAULT '0',
  `changed` int(11) NOT NULL DEFAULT '0',
  `logged` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `referred` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `login_attempts` tinyint(4) NOT NULL DEFAULT '0',
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  `active` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`(191)),
  KEY `added` (`added`),
  KEY `logged` (`logged`),
  KEY `profile_id` (`profile_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `sys_accounts`
--

INSERT INTO `sys_accounts` VALUES
(1, 1, '[[admin_username]]', '[[admin_email]]', 1, '', 0, 1, 1, '[[admin_pass]]', 0, '[[salt]]', 3, 1, [[timestamp]], 0, [[timestamp]], '[[clientip]]', '', 0, 0, 0),
(2, 0, 'Robot', '', 0, '', 0, 0, 0, '', 0, '', 3, 0, [[timestamp]], 0, 0, '', '', 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `sys_accounts_password`
--

CREATE TABLE `sys_accounts_password` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) NOT NULL,
  `password` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password_changed` int(11) NOT NULL DEFAULT '0',
  `salt` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_acl_actions`
--

CREATE TABLE `sys_acl_actions` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `AdditionalParamName` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Desc` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Countable` tinyint(4) NOT NULL DEFAULT '0',
  `DisabledForLevels` int(10) unsigned NOT NULL DEFAULT '3',
  PRIMARY KEY (`ID`),
  FULLTEXT KEY `ModuleAndName` (`Module`,`Name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=44 ;

--
-- Dumping data for table `sys_acl_actions`
--

INSERT INTO `sys_acl_actions` VALUES
(1, 'system', 'connect', NULL, '_sys_acl_action_connect', '', 1, 3),
(2, 'system', 'vote', NULL, '_sys_acl_action_vote', '', 1, 0),
(3, 'system', 'vote_view', NULL, '_sys_acl_action_vote_view', '', 1, 0),
(4, 'system', 'vote_view_voters', NULL, '_sys_acl_action_vote_view_voters', '', 1, 0),
(5, 'system', 'report', NULL, '_sys_acl_action_report', '', 1, 0),
(6, 'system', 'report_view', NULL, '_sys_acl_action_report_view', '', 0, 0),
(7, 'system', 'favorite', NULL, '_sys_acl_action_favorite', '', 1, 0),
(8, 'system', 'favorite_view', NULL, '_sys_acl_action_favorite_view', '', 0, 0),
(9, 'system', 'feature', NULL, '_sys_acl_action_feature', '', 0, 0),
(10, 'system', 'view_view', NULL, '_sys_acl_action_view_view', '', 0, 0),
(11, 'system', 'view_view_viewers_own', NULL, '_sys_acl_action_view_view_viewers_own', '', 0, 0),
(12, 'system', 'comments post', NULL, '_sys_acl_action_comments_post', '', 1, 0),
(13, 'system', 'comments edit own', NULL, '_sys_acl_action_comments_edit_own', '', 0, 3),
(14, 'system', 'comments remove own', NULL, '_sys_acl_action_comments_remove_own', '', 1, 3),
(15, 'system', 'comments edit all', NULL, '_sys_acl_action_comments_edit_all', '', 1, 3),
(16, 'system', 'comments remove all', NULL, '_sys_acl_action_comments_remove_all', '', 1, 3),
(17, 'system', 'comments remove in own content', NULL, '_sys_acl_action_comments_remove_in_own_content', '', 1, 3),
(18, 'system', 'comments remove in group context', NULL, '_sys_acl_action_comments_remove_in_group_context', '', 1, 3),
(19, 'system', 'comments pin', NULL, '_sys_acl_action_comments_pin', '', 1, 3),
(20, 'system', 'create account', NULL, '_sys_acl_action_create_account', '_sys_acl_action_create_account_desc', 0, 2147483646),
(21, 'system', 'delete account', NULL, '_sys_acl_action_delete_account', '_sys_acl_action_delete_account_desc', 0, 1),
(22, 'system', 'set acl level', NULL, '_sys_acl_action_set_acl_level', '_sys_acl_action_set_acl_level_desc', 0, 3),
(23, 'system', 'set badge', NULL, '_sys_acl_action_set_badge', '_sys_acl_action_set_badge_desc', 0, 3),
(24, 'system', 'set acl as privacy', NULL, '_sys_acl_action_set_acl_as_privacy', '_sys_acl_action_set_acl_as_privacy_desc', 0, 3),
(25, 'system', 'set form fields privacy', NULL, '_sys_acl_action_set_form_fields_privacy', '_sys_acl_action_set_form_fields_privacy_desc', 0, 3),
(26, 'system', 'chart view', NULL, '_sys_acl_action_chart_view', '_sys_acl_action_chart_view_desc', 0, 3),
(27, 'system', 'post links', NULL, '_sys_acl_action_post_links', '_sys_acl_action_post_links_desc', 0, 0),
(28, 'system', 'use macros', NULL, '_sys_acl_action_use_macros', '_sys_acl_action_use_macros_desc', 0, 0),
(29, 'system', 'switch to any profile', NULL, '_sys_acl_action_switch_to_any_profile', '_sys_acl_action_switch_to_any_profile_desc', 0, 0),
(30, 'system', 'show membership levels in privacy groups', NULL, '_sys_acl_action_show_membership_levels_in_privacy_groups', '_sys_acl_action_show_membership_levels_in_privacy_groups_desc', 0, 0),
(31, 'system', 'show membership private info', NULL, '_sys_acl_action_show_membership_private_info', '_sys_acl_action_show_membership_private_info_desc', 0, 0),
(32, 'system', 'wiki add block', NULL, '_sys_acl_action_add_block', '', 0, 1),
(33, 'system', 'wiki edit block', NULL, '_sys_acl_action_edit_block', '', 0, 0),
(34, 'system', 'wiki translate block', NULL, '_sys_acl_action_translate_block', '', 0, 0),
(35, 'system', 'wiki delete version', NULL, '_sys_acl_action_delete_version', '', 0, 1),
(36, 'system', 'wiki delete block', NULL, '_sys_acl_action_delete_block', '', 0, 1),
(37, 'system', 'wiki history', NULL, '_sys_acl_action_history', '', 0, 0),
(38, 'system', 'wiki unsafe', NULL, '_sys_acl_action_unsafe', '', 0, 0),
(39, 'bx_persons', 'create entry', NULL, '_bx_persons_acl_action_create_profile', '', 1, 1),
(40, 'bx_persons', 'delete entry', NULL, '_bx_persons_acl_action_delete_profile', '', 1, 1),
(41, 'bx_persons', 'view entry', NULL, '_bx_persons_acl_action_view_profile', '', 1, 0),
(42, 'bx_persons', 'edit any entry', NULL, '_bx_persons_acl_action_edit_any_profile', '', 1, 3),
(43, 'bx_persons', 'delete any entry', NULL, '_bx_persons_acl_action_delete_any_profile', '', 1, 3);

-- --------------------------------------------------------

--
-- Table structure for table `sys_acl_actions_track`
--

CREATE TABLE `sys_acl_actions_track` (
  `IDAction` int(10) unsigned NOT NULL DEFAULT '0',
  `IDMember` int(10) unsigned NOT NULL DEFAULT '0',
  `ActionsLeft` int(10) unsigned NOT NULL DEFAULT '0',
  `ValidSince` datetime DEFAULT NULL,
  PRIMARY KEY (`IDAction`,`IDMember`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sys_acl_levels`
--

CREATE TABLE `sys_acl_levels` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Icon` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `Description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Active` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `Purchasable` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `Removable` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `QuotaSize` bigint(20) NOT NULL,
  `QuotaNumber` int(11) NOT NULL,
  `QuotaMaxFileSize` bigint(20) NOT NULL,
  `Order` int(11) NOT NULL DEFAULT '0',
  `PasswordExpired` int(11) NOT NULL DEFAULT '0',
  `PasswordExpiredNotify` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Name` (`Name`),
  FULLTEXT KEY `Description` (`Description`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=10 ;

--
-- Dumping data for table `sys_acl_levels`
--

INSERT INTO `sys_acl_levels` VALUES
(1, '_adm_prm_txt_level_unauthenticated', 'user bx-def-font-color', '', 'yes', 'no', 'no', 0, 0, 0, 1, 0, 0),
(2, '_adm_prm_txt_level_account', 'user col-green1', '', 'yes', 'no', 'no', 0, 0, 0, 2, 0, 0),
(3, '_adm_prm_txt_level_standard', 'user col-red1', '', 'yes', 'no', 'no', 0, 0, 0, 3, 0, 0),
(4, '_adm_prm_txt_level_unconfirmed', 'user bx-def-font-color', '', 'yes', 'no', 'no', 0, 0, 0, 4, 0, 0),
(5, '_adm_prm_txt_level_pending', 'user bx-def-font-color', '', 'yes', 'no', 'no', 0, 0, 0, 5, 0, 0),
(6, '_adm_prm_txt_level_suspended', 'user bx-def-font-color', '', 'yes', 'no', 'no', 0, 0, 0, 6, 0, 0),
(7, '_adm_prm_txt_level_moderator', 'user-secret col-blue3', '', 'yes', 'no', 'no', 0, 0, 0, 7, 0, 0),
(8, '_adm_prm_txt_level_administrator', 'user-secret col-blue3', '', 'yes', 'no', 'no', 0, 0, 0, 8, 0, 0),
(9, '_adm_prm_txt_level_premium', 'user col-red3', '', 'yes', 'yes', 'no', 0, 0, 0, 9, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `sys_acl_levels_members`
--

CREATE TABLE `sys_acl_levels_members` (
  `IDMember` int(10) unsigned NOT NULL DEFAULT '0',
  `IDLevel` int(10) unsigned NOT NULL DEFAULT '0',
  `DateStarts` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `DateExpires` datetime DEFAULT NULL,
  `State` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `TransactionID` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`IDMember`,`IDLevel`,`DateStarts`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sys_acl_matrix`
--

CREATE TABLE `sys_acl_matrix` (
  `IDLevel` int(10) unsigned NOT NULL DEFAULT '0',
  `IDAction` int(10) unsigned NOT NULL DEFAULT '0',
  `AllowedCount` int(10) unsigned DEFAULT NULL,
  `AllowedPeriodLen` int(10) unsigned DEFAULT NULL,
  `AllowedPeriodStart` datetime DEFAULT NULL,
  `AllowedPeriodEnd` datetime DEFAULT NULL,
  `AdditionalParamValue` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`IDLevel`,`IDAction`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `sys_acl_matrix`
--

INSERT INTO `sys_acl_matrix` VALUES
(3, 1, NULL, NULL, NULL, NULL, NULL),
(7, 1, NULL, NULL, NULL, NULL, NULL),
(8, 1, NULL, NULL, NULL, NULL, NULL),
(9, 1, NULL, NULL, NULL, NULL, NULL),
(3, 2, NULL, NULL, NULL, NULL, NULL),
(7, 2, NULL, NULL, NULL, NULL, NULL),
(8, 2, NULL, NULL, NULL, NULL, NULL),
(9, 2, NULL, NULL, NULL, NULL, NULL),
(1, 3, NULL, NULL, NULL, NULL, NULL),
(2, 3, NULL, NULL, NULL, NULL, NULL),
(3, 3, NULL, NULL, NULL, NULL, NULL),
(4, 3, NULL, NULL, NULL, NULL, NULL),
(5, 3, NULL, NULL, NULL, NULL, NULL),
(7, 3, NULL, NULL, NULL, NULL, NULL),
(8, 3, NULL, NULL, NULL, NULL, NULL),
(9, 3, NULL, NULL, NULL, NULL, NULL),
(3, 4, NULL, NULL, NULL, NULL, NULL),
(7, 4, NULL, NULL, NULL, NULL, NULL),
(8, 4, NULL, NULL, NULL, NULL, NULL),
(9, 4, NULL, NULL, NULL, NULL, NULL),
(3, 5, NULL, NULL, NULL, NULL, NULL),
(7, 5, NULL, NULL, NULL, NULL, NULL),
(8, 5, NULL, NULL, NULL, NULL, NULL),
(9, 5, NULL, NULL, NULL, NULL, NULL),
(7, 6, NULL, NULL, NULL, NULL, NULL),
(8, 6, NULL, NULL, NULL, NULL, NULL),
(3, 7, NULL, NULL, NULL, NULL, NULL),
(7, 7, NULL, NULL, NULL, NULL, NULL),
(8, 7, NULL, NULL, NULL, NULL, NULL),
(9, 7, NULL, NULL, NULL, NULL, NULL),
(1, 8, NULL, NULL, NULL, NULL, NULL),
(2, 8, NULL, NULL, NULL, NULL, NULL),
(3, 8, NULL, NULL, NULL, NULL, NULL),
(4, 8, NULL, NULL, NULL, NULL, NULL),
(5, 8, NULL, NULL, NULL, NULL, NULL),
(7, 8, NULL, NULL, NULL, NULL, NULL),
(8, 8, NULL, NULL, NULL, NULL, NULL),
(9, 8, NULL, NULL, NULL, NULL, NULL),
(7, 9, NULL, NULL, NULL, NULL, NULL),
(8, 9, NULL, NULL, NULL, NULL, NULL),
(1, 10, NULL, NULL, NULL, NULL, NULL),
(2, 10, NULL, NULL, NULL, NULL, NULL),
(3, 10, NULL, NULL, NULL, NULL, NULL),
(4, 10, NULL, NULL, NULL, NULL, NULL),
(5, 10, NULL, NULL, NULL, NULL, NULL),
(7, 10, NULL, NULL, NULL, NULL, NULL),
(8, 10, NULL, NULL, NULL, NULL, NULL),
(9, 10, NULL, NULL, NULL, NULL, NULL),
(7, 11, NULL, NULL, NULL, NULL, NULL),
(8, 11, NULL, NULL, NULL, NULL, NULL),
(3, 12, NULL, NULL, NULL, NULL, NULL),
(7, 12, NULL, NULL, NULL, NULL, NULL),
(8, 12, NULL, NULL, NULL, NULL, NULL),
(9, 12, NULL, NULL, NULL, NULL, NULL),
(3, 13, NULL, NULL, NULL, NULL, NULL),
(7, 13, NULL, NULL, NULL, NULL, NULL),
(8, 13, NULL, NULL, NULL, NULL, NULL),
(9, 13, NULL, NULL, NULL, NULL, NULL),
(3, 14, NULL, NULL, NULL, NULL, NULL),
(7, 14, NULL, NULL, NULL, NULL, NULL),
(8, 14, NULL, NULL, NULL, NULL, NULL),
(9, 14, NULL, NULL, NULL, NULL, NULL),
(7, 15, NULL, NULL, NULL, NULL, NULL),
(8, 15, NULL, NULL, NULL, NULL, NULL),
(7, 16, NULL, NULL, NULL, NULL, NULL),
(8, 16, NULL, NULL, NULL, NULL, NULL),
(7, 17, NULL, NULL, NULL, NULL, NULL),
(8, 17, NULL, NULL, NULL, NULL, NULL),
(7, 18, NULL, NULL, NULL, NULL, NULL),
(8, 18, NULL, NULL, NULL, NULL, NULL),
(7, 19, NULL, NULL, NULL, NULL, NULL),
(8, 19, NULL, NULL, NULL, NULL, NULL),
(1, 20, NULL, NULL, NULL, NULL, NULL),
(2, 21, NULL, NULL, NULL, NULL, NULL),
(3, 21, NULL, NULL, NULL, NULL, NULL),
(4, 21, NULL, NULL, NULL, NULL, NULL),
(5, 21, NULL, NULL, NULL, NULL, NULL),
(7, 21, NULL, NULL, NULL, NULL, NULL),
(8, 21, NULL, NULL, NULL, NULL, NULL),
(9, 21, NULL, NULL, NULL, NULL, NULL),
(8, 22, NULL, NULL, NULL, NULL, NULL),
(8, 23, NULL, NULL, NULL, NULL, NULL),
(8, 24, NULL, NULL, NULL, NULL, NULL),
(2, 25, NULL, NULL, NULL, NULL, NULL),
(3, 25, NULL, NULL, NULL, NULL, NULL),
(4, 25, NULL, NULL, NULL, NULL, NULL),
(5, 25, NULL, NULL, NULL, NULL, NULL),
(7, 25, NULL, NULL, NULL, NULL, NULL),
(8, 25, NULL, NULL, NULL, NULL, NULL),
(9, 25, NULL, NULL, NULL, NULL, NULL),
(8, 26, NULL, NULL, NULL, NULL, NULL),
(3, 27, NULL, NULL, NULL, NULL, NULL),
(7, 27, NULL, NULL, NULL, NULL, NULL),
(8, 27, NULL, NULL, NULL, NULL, NULL),
(9, 27, NULL, NULL, NULL, NULL, NULL),
(7, 28, NULL, NULL, NULL, NULL, NULL),
(8, 28, NULL, NULL, NULL, NULL, NULL),
(8, 29, NULL, NULL, NULL, NULL, NULL),
(8, 30, NULL, NULL, NULL, NULL, NULL),
(7, 31, NULL, NULL, NULL, NULL, NULL),
(8, 31, NULL, NULL, NULL, NULL, NULL),
(2, 39, NULL, NULL, NULL, NULL, NULL),
(3, 39, NULL, NULL, NULL, NULL, NULL),
(4, 39, NULL, NULL, NULL, NULL, NULL),
(5, 39, NULL, NULL, NULL, NULL, NULL),
(7, 39, NULL, NULL, NULL, NULL, NULL),
(8, 39, NULL, NULL, NULL, NULL, NULL),
(9, 39, NULL, NULL, NULL, NULL, NULL),
(2, 40, NULL, NULL, NULL, NULL, NULL),
(3, 40, NULL, NULL, NULL, NULL, NULL),
(4, 40, NULL, NULL, NULL, NULL, NULL),
(5, 40, NULL, NULL, NULL, NULL, NULL),
(7, 40, NULL, NULL, NULL, NULL, NULL),
(8, 40, NULL, NULL, NULL, NULL, NULL),
(9, 40, NULL, NULL, NULL, NULL, NULL),
(1, 41, NULL, NULL, NULL, NULL, NULL),
(2, 41, NULL, NULL, NULL, NULL, NULL),
(3, 41, NULL, NULL, NULL, NULL, NULL),
(4, 41, NULL, NULL, NULL, NULL, NULL),
(5, 41, NULL, NULL, NULL, NULL, NULL),
(7, 41, NULL, NULL, NULL, NULL, NULL),
(8, 41, NULL, NULL, NULL, NULL, NULL),
(9, 41, NULL, NULL, NULL, NULL, NULL),
(7, 42, NULL, NULL, NULL, NULL, NULL),
(8, 42, NULL, NULL, NULL, NULL, NULL),
(8, 43, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `sys_agents_assistants`
--

CREATE TABLE `sys_agents_assistants` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `model_id` int(11) NOT NULL DEFAULT '0',
  `profile_id` int(11) NOT NULL DEFAULT '0',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `prompt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ai_vs_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ai_asst_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `added` int(11) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '0',
  `hidden` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_agents_assistants_chats`
--

CREATE TABLE `sys_agents_assistants_chats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` tinyint(4) NOT NULL DEFAULT '1',
  `assistant_id` int(11) NOT NULL DEFAULT '0',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `message_id` int(11) NOT NULL DEFAULT '0',
  `messages` int(11) NOT NULL DEFAULT '0',
  `added` int(11) NOT NULL DEFAULT '0',
  `ai_thread_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ai_file_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `stored` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_agents_assistants_chats_messages`
--

CREATE TABLE `sys_agents_assistants_chats_messages` (
  `cmt_id` int(11) NOT NULL AUTO_INCREMENT,
  `cmt_parent_id` int(11) NOT NULL DEFAULT '0',
  `cmt_vparent_id` int(11) NOT NULL DEFAULT '0',
  `cmt_object_id` int(11) NOT NULL DEFAULT '0',
  `cmt_author_id` int(11) NOT NULL DEFAULT '0',
  `cmt_level` int(11) NOT NULL DEFAULT '0',
  `cmt_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cmt_mood` tinyint(4) NOT NULL DEFAULT '0',
  `cmt_rate` int(11) NOT NULL DEFAULT '0',
  `cmt_rate_count` int(11) NOT NULL DEFAULT '0',
  `cmt_time` int(11) unsigned NOT NULL DEFAULT '0',
  `cmt_replies` int(11) NOT NULL DEFAULT '0',
  `cmt_pinned` int(11) NOT NULL DEFAULT '0',
  `cmt_cf` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`cmt_id`),
  KEY `cmt_object_id` (`cmt_object_id`,`cmt_parent_id`),
  FULLTEXT KEY `search_fields` (`cmt_text`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_agents_assistants_files`
--

CREATE TABLE `sys_agents_assistants_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `assistant_id` int(11) NOT NULL DEFAULT '0',
  `added` int(11) NOT NULL DEFAULT '0',
  `ai_file_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ai_file_size` int(11) NOT NULL DEFAULT '0',
  `ai_file_status` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'in_progress',
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_agents_automators`
--

CREATE TABLE `sys_agents_automators` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `model_id` int(11) NOT NULL DEFAULT '0',
  `profile_id` int(11) NOT NULL DEFAULT '0',
  `type` enum('event','scheduler','webhook') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'event',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `alert_unit` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alert_action` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message_id` int(11) NOT NULL DEFAULT '0',
  `code` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `added` int(11) unsigned NOT NULL DEFAULT '0',
  `messages` int(11) NOT NULL DEFAULT '0',
  `status` enum('auto','manual','ready') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'auto',
  `active` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_agents_automators_assistants`
--

CREATE TABLE `sys_agents_automators_assistants` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `automator_id` int(11) NOT NULL DEFAULT '0',
  `assistant_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_agents_automators_helpers`
--

CREATE TABLE `sys_agents_automators_helpers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `automator_id` int(11) NOT NULL DEFAULT '0',
  `helper_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_agents_automators_messages`
--

CREATE TABLE `sys_agents_automators_messages` (
  `cmt_id` int(11) NOT NULL AUTO_INCREMENT,
  `cmt_parent_id` int(11) NOT NULL DEFAULT '0',
  `cmt_vparent_id` int(11) NOT NULL DEFAULT '0',
  `cmt_object_id` int(11) NOT NULL DEFAULT '0',
  `cmt_author_id` int(11) NOT NULL DEFAULT '0',
  `cmt_level` int(11) NOT NULL DEFAULT '0',
  `cmt_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cmt_mood` tinyint(4) NOT NULL DEFAULT '0',
  `cmt_rate` int(11) NOT NULL DEFAULT '0',
  `cmt_rate_count` int(11) NOT NULL DEFAULT '0',
  `cmt_time` int(11) unsigned NOT NULL DEFAULT '0',
  `cmt_replies` int(11) NOT NULL DEFAULT '0',
  `cmt_pinned` int(11) NOT NULL DEFAULT '0',
  `cmt_cf` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`cmt_id`),
  KEY `cmt_object_id` (`cmt_object_id`,`cmt_parent_id`),
  FULLTEXT KEY `search_fields` (`cmt_text`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_agents_automators_providers`
--

CREATE TABLE `sys_agents_automators_providers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `automator_id` int(11) NOT NULL DEFAULT '0',
  `provider_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_agents_helpers`
--

CREATE TABLE `sys_agents_helpers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `model_id` int(11) NOT NULL DEFAULT '0',
  `profile_id` int(11) NOT NULL DEFAULT '0',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `prompt` text COLLATE utf8mb4_unicode_ci,
  `added` int(11) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_agents_models`
--

CREATE TABLE `sys_agents_models` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `key` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `for_asst` tinyint(4) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `hidden` tinyint(4) NOT NULL DEFAULT '0',
  `class_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `sys_agents_models`
--

INSERT INTO `sys_agents_models` VALUES
(1, 'gpt-3.5-turbo', 'GPT-3.5-TURBO', '', '{"call":{"temperature":0.1}}', 0, 1, 0, 'BxDolAIModelGpt35', ''),
(2, 'gpt-4o', 'GPT-4.O', '', '{"call":{},"assistants":{"event_init":"asst_HcEyaghqWZefkAyoEML40joY","event":"asst_wqaXtKjcsBKceMtJ2NxID2LT","scheduler_init":"asst_kEbDH1hUy2Y45nOKk9jaSTB8","scheduler":"asst_M6zOv4osQwZmRItaiYptjjOS","webhook_init":"asst_sSkOblPyXmYovS5IiEiVW17n","webhook":"asst_w7F3RiylJfdDEb9Eaa4RvO1q"}}', 1, 1, 0, 'BxDolAIModelGpt40', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_agents_providers`
--

CREATE TABLE `sys_agents_providers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_id` int(11) NOT NULL DEFAULT '0',
  `profile_id` int(11) NOT NULL DEFAULT '0',
  `added` int(11) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_agents_providers_values`
--

CREATE TABLE `sys_agents_providers_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `provider_id` int(11) NOT NULL DEFAULT '0',
  `option_id` int(11) NOT NULL DEFAULT '0',
  `value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `value` (`provider_id`,`option_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_agents_provider_options`
--

CREATE TABLE `sys_agents_provider_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `provider_type_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `extra` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `check_type` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `check_params` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `check_error` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `order` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `sys_agents_provider_options`
--

INSERT INTO `sys_agents_provider_options` VALUES
(1, 1, 'shf_adm_shop_domain', 'text', '_sys_agents_pvd_opt_cpt_shop_domain', '_sys_agents_pvd_opt_dsc_shop_domain', '', '', '', '', 1),
(2, 1, 'shf_adm_access_token', 'text', '_sys_agents_pvd_opt_cpt_access_token', '_sys_agents_pvd_opt_dsc_access_token', '', '', '', '', 2),
(3, 1, 'shf_adm_secret_key', 'text', '_sys_agents_pvd_opt_cpt_secret_key', '_sys_agents_pvd_opt_dsc_secret_key', '', '', '', '', 3),
(4, 1, 'shf_adm_webhook_url', 'value', '_sys_agents_pvd_opt_cpt_webhook_url', '_sys_agents_pvd_opt_dsc_webhook_url', '', '', '', '', 4);

-- --------------------------------------------------------

--
-- Table structure for table `sys_agents_provider_types`
--

CREATE TABLE `sys_agents_provider_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_prefix` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `active` tinyint(4) NOT NULL DEFAULT '0',
  `order` tinyint(4) NOT NULL DEFAULT '0',
  `class_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_agents_provider_types`
--

INSERT INTO `sys_agents_provider_types` VALUES
(1, 'shopify_admin', '_sys_agents_pvd_cpt_shopify_admin', 'shf_adm_', 1, 1, 'BxDolAIProviderShopifyAdmin', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_alerts`
--

CREATE TABLE `sys_alerts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `unit` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `action` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'none',
  `handler_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `alert_handler` (`unit`,`action`,`handler_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=77 ;

--
-- Dumping data for table `sys_alerts`
--

INSERT INTO `sys_alerts` VALUES
(1, 'system', 'save_setting', 1),
(2, 'sys_images_custom', 'file_deleted', 2),
(3, 'system', 'save_setting', 3),
(4, 'system', 'save_setting', 4),
(5, 'system', 'installed', 5),
(6, 'sys_profiles_friends', 'connection_added', 6),
(7, 'sys_profiles_friends', 'connection_removed', 6),
(8, 'sys_cmts_images', 'file_deleted', 7),
(9, 'system', 'change_logo', 8),
(10, 'system', 'change_logo_dark', 8),
(11, 'system', 'change_mark', 8),
(12, 'system', 'change_mark_dark', 8),
(13, 'system', 'get_object', 8),
(14, 'system', 'get_layout_images', 8),
(15, 'system', 'save_setting', 8),
(16, 'profile', 'unit', 8),
(17, 'system', 'save_setting', 9),
(18, 'sys_profiles_friends', 'connection_added', 9),
(19, 'bx_timeline', 'post_common', 9),
(20, 'bx_persons_pictures', 'file_deleted', 9),
(21, 'bx_persons', 'timeline_view', 9),
(22, 'bx_persons', 'timeline_post', 9),
(23, 'bx_persons', 'timeline_delete', 9),
(24, 'bx_persons', 'timeline_comment', 9),
(25, 'bx_persons', 'timeline_vote', 9),
(26, 'bx_persons', 'timeline_score', 9),
(27, 'bx_persons', 'timeline_report', 9),
(28, 'bx_persons', 'timeline_repost', 9),
(29, 'bx_persons', 'timeline_pin', 9),
(30, 'bx_persons', 'timeline_promote', 9),
(31, 'bx_persons_pictures_resized', 'file_deleted', 10),
(32, 'bx_persons_pictures', 'file_deleted', 11),
(33, 'bx_persons_pictures_resized', 'file_deleted', 12),
(34, 'bx_persons_pictures', 'file_deleted', 13),
(35, 'bx_persons_pictures_resized', 'file_deleted', 14),
(36, 'bx_persons_pictures', 'file_deleted', 15),
(37, 'bx_persons_pictures_resized', 'file_deleted', 16),
(38, 'bx_persons_pictures', 'file_deleted', 17),
(39, 'bx_persons_pictures_resized', 'file_deleted', 18),
(40, 'bx_persons_pictures', 'file_deleted', 19),
(41, 'bx_persons_pictures_resized', 'file_deleted', 20),
(42, 'bx_persons_pictures', 'file_deleted', 21),
(43, 'bx_persons_pictures_resized', 'file_deleted', 22),
(44, 'bx_persons_pictures', 'file_deleted', 23),
(45, 'bx_persons_pictures_resized', 'file_deleted', 24),
(46, 'bx_persons_pictures', 'file_deleted', 25),
(47, 'sys_images_resized', 'file_deleted', 26),
(48, 'sys_images', 'file_deleted', 27),
(49, 'sys_images_resized', 'file_deleted', 28),
(50, 'sys_images', 'file_deleted', 29),
(51, 'sys_images_resized', 'file_deleted', 30),
(52, 'sys_images', 'file_deleted', 31),
(53, 'sys_images_resized', 'file_deleted', 32),
(54, 'sys_images', 'file_deleted', 33),
(55, 'sys_images_resized', 'file_deleted', 34),
(56, 'sys_images', 'file_deleted', 35),
(57, 'sys_images_resized', 'file_deleted', 36),
(58, 'sys_images', 'file_deleted', 37),
(59, 'sys_images_resized', 'file_deleted', 38),
(60, 'sys_images', 'file_deleted', 39),
(61, 'sys_images_resized', 'file_deleted', 40),
(62, 'sys_images', 'file_deleted', 41),
(63, 'sys_images_resized', 'file_deleted', 42),
(64, 'sys_images', 'file_deleted', 43),
(65, 'sys_images_resized', 'file_deleted', 44),
(66, 'sys_images', 'file_deleted', 45),
(67, 'sys_images_resized', 'file_deleted', 46),
(68, 'sys_images', 'file_deleted', 47),
(69, 'sys_cmts_images_preview', 'file_deleted', 48),
(70, 'sys_cmts_images', 'file_deleted', 49),
(71, 'sys_images_resized', 'file_deleted', 50),
(72, 'sys_images_custom', 'file_deleted', 51),
(73, 'sys_images_editor_resized', 'file_deleted', 52),
(74, 'sys_images_editor', 'file_deleted', 53),
(75, 'sys_wiki_images_resized', 'file_deleted', 54),
(76, 'sys_wiki_files', 'file_deleted', 55);

-- --------------------------------------------------------

--
-- Table structure for table `sys_alerts_cache_triggers`
--

CREATE TABLE `sys_alerts_cache_triggers` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `unit` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `action` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cache_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_alerts_cache_triggers`
--

INSERT INTO `sys_alerts_cache_triggers` VALUES
(1, 'sys_profiles_subscriptions', 'connection_added', 'menu_sys_profile_stats_profile-stats-subscribed-me_{content}_{_hash}.php');

-- --------------------------------------------------------

--
-- Table structure for table `sys_alerts_handlers`
--

CREATE TABLE `sys_alerts_handlers` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `class` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `service_call` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=56 ;

--
-- Dumping data for table `sys_alerts_handlers`
--

INSERT INTO `sys_alerts_handlers` VALUES
(1, 'sys_studio_settings_save_design', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:28:"alert_response_settings_save";s:6:"params";a:0:{}s:5:"class";s:25:"TemplStudioDesignServices";}', 1),
(2, 'sys_settings_sys_images_custom_file_deleted', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:45:"alert_response_sys_images_custom_file_deleted";s:6:"params";a:0:{}s:5:"class";s:27:"TemplStudioSettingsServices";}', 1),
(3, 'sys_settings_change_kands', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:27:"alert_response_change_kands";s:6:"params";a:0:{}s:5:"class";s:27:"TemplStudioSettingsServices";}', 1),
(4, 'sys_settings_storage_change', '', '', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:37:"alert_response_process_storage_change";s:5:"class";s:13:"TemplServices";}', 1),
(5, 'sys_installed', '', '', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_process_installed";s:5:"class";s:13:"TemplServices";}', 1),
(6, 'sys_connections', '', '', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:26:"alert_response_connections";s:5:"class";s:23:"TemplServiceConnections";}', 1),
(7, 'sys_cmts_sys_cmts_images_file_deleted', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:43:"alert_response_sys_cmts_images_file_deleted";s:6:"params";a:0:{}s:5:"class";s:17:"TemplCmtsServices";}', 1),
(8, 'bx_artificer', 'BxArtificerAlertsResponse', 'modules/boonex/artificer/classes/BxArtificerAlertsResponse.php', '', 1),
(9, 'bx_persons', 'BxPersonsAlertsResponse', 'modules/boonex/persons/classes/BxPersonsAlertsResponse.php', '', 1),
(10, 'sys_image_transcoder_local_file_delete_bx_persons_icon', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:15:"bx_persons_icon";}s:5:"class";s:18:"TemplImageServices";}', 1),
(11, 'sys_image_transcoder_orig_file_delete_bx_persons_icon', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:15:"bx_persons_icon";}s:5:"class";s:18:"TemplImageServices";}', 1),
(12, 'sys_image_transcoder_local_file_delete_bx_persons_thumb', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:16:"bx_persons_thumb";}s:5:"class";s:18:"TemplImageServices";}', 1),
(13, 'sys_image_transcoder_orig_file_delete_bx_persons_thumb', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:16:"bx_persons_thumb";}s:5:"class";s:18:"TemplImageServices";}', 1),
(14, 'sys_image_transcoder_local_file_delete_bx_persons_avatar', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:17:"bx_persons_avatar";}s:5:"class";s:18:"TemplImageServices";}', 1),
(15, 'sys_image_transcoder_orig_file_delete_bx_persons_avatar', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:17:"bx_persons_avatar";}s:5:"class";s:18:"TemplImageServices";}', 1),
(16, 'sys_image_transcoder_local_file_delete_bx_persons_avatar_big', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:21:"bx_persons_avatar_big";}s:5:"class";s:18:"TemplImageServices";}', 1),
(17, 'sys_image_transcoder_orig_file_delete_bx_persons_avatar_big', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:21:"bx_persons_avatar_big";}s:5:"class";s:18:"TemplImageServices";}', 1),
(18, 'sys_image_transcoder_local_file_delete_bx_persons_picture', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:18:"bx_persons_picture";}s:5:"class";s:18:"TemplImageServices";}', 1),
(19, 'sys_image_transcoder_orig_file_delete_bx_persons_picture', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:18:"bx_persons_picture";}s:5:"class";s:18:"TemplImageServices";}', 1),
(20, 'sys_image_transcoder_local_file_delete_bx_persons_cover', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:16:"bx_persons_cover";}s:5:"class";s:18:"TemplImageServices";}', 1),
(21, 'sys_image_transcoder_orig_file_delete_bx_persons_cover', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:16:"bx_persons_cover";}s:5:"class";s:18:"TemplImageServices";}', 1),
(22, 'sys_image_transcoder_local_file_delete_bx_persons_cover_thumb', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:22:"bx_persons_cover_thumb";}s:5:"class";s:18:"TemplImageServices";}', 1),
(23, 'sys_image_transcoder_orig_file_delete_bx_persons_cover_thumb', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:22:"bx_persons_cover_thumb";}s:5:"class";s:18:"TemplImageServices";}', 1),
(24, 'sys_image_transcoder_local_file_delete_bx_persons_gallery', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:18:"bx_persons_gallery";}s:5:"class";s:18:"TemplImageServices";}', 1),
(25, 'sys_image_transcoder_orig_file_delete_bx_persons_gallery', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:18:"bx_persons_gallery";}s:5:"class";s:18:"TemplImageServices";}', 1),
(26, 'sys_image_transcoder_local_file_delete_sys_image_resize', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:16:"sys_image_resize";}s:5:"class";s:18:"TemplImageServices";}', 1),
(27, 'sys_image_transcoder_orig_file_delete_sys_image_resize', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:16:"sys_image_resize";}s:5:"class";s:18:"TemplImageServices";}', 1),
(28, 'sys_image_transcoder_local_file_delete_sys_icon_apple', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:14:"sys_icon_apple";}s:5:"class";s:18:"TemplImageServices";}', 1),
(29, 'sys_image_transcoder_orig_file_delete_sys_icon_apple', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:14:"sys_icon_apple";}s:5:"class";s:18:"TemplImageServices";}', 1),
(30, 'sys_image_transcoder_local_file_delete_sys_icon_android', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:16:"sys_icon_android";}s:5:"class";s:18:"TemplImageServices";}', 1),
(31, 'sys_image_transcoder_orig_file_delete_sys_icon_android', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:16:"sys_icon_android";}s:5:"class";s:18:"TemplImageServices";}', 1),
(32, 'sys_image_transcoder_local_file_delete_sys_icon_android_splash', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:23:"sys_icon_android_splash";}s:5:"class";s:18:"TemplImageServices";}', 1),
(33, 'sys_image_transcoder_orig_file_delete_sys_icon_android_splash', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:23:"sys_icon_android_splash";}s:5:"class";s:18:"TemplImageServices";}', 1),
(34, 'sys_image_transcoder_local_file_delete_sys_icon_facebook', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:17:"sys_icon_facebook";}s:5:"class";s:18:"TemplImageServices";}', 1),
(35, 'sys_image_transcoder_orig_file_delete_sys_icon_facebook', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:17:"sys_icon_facebook";}s:5:"class";s:18:"TemplImageServices";}', 1),
(36, 'sys_image_transcoder_local_file_delete_sys_icon_favicon', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:16:"sys_icon_favicon";}s:5:"class";s:18:"TemplImageServices";}', 1),
(37, 'sys_image_transcoder_orig_file_delete_sys_icon_favicon', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:16:"sys_icon_favicon";}s:5:"class";s:18:"TemplImageServices";}', 1),
(38, 'sys_image_transcoder_local_file_delete_sys_cover', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:9:"sys_cover";}s:5:"class";s:18:"TemplImageServices";}', 1),
(39, 'sys_image_transcoder_orig_file_delete_sys_cover', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:9:"sys_cover";}s:5:"class";s:18:"TemplImageServices";}', 1),
(40, 'sys_image_transcoder_local_file_delete_sys_cover_unit_profile', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:22:"sys_cover_unit_profile";}s:5:"class";s:18:"TemplImageServices";}', 1),
(41, 'sys_image_transcoder_orig_file_delete_sys_cover_unit_profile', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:22:"sys_cover_unit_profile";}s:5:"class";s:18:"TemplImageServices";}', 1),
(42, 'sys_image_transcoder_local_file_delete_sys_cover_preview', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:17:"sys_cover_preview";}s:5:"class";s:18:"TemplImageServices";}', 1),
(43, 'sys_image_transcoder_orig_file_delete_sys_cover_preview', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:17:"sys_cover_preview";}s:5:"class";s:18:"TemplImageServices";}', 1),
(44, 'sys_image_transcoder_local_file_delete_sys_builder_page_preview', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:24:"sys_builder_page_preview";}s:5:"class";s:18:"TemplImageServices";}', 1),
(45, 'sys_image_transcoder_orig_file_delete_sys_builder_page_preview', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:24:"sys_builder_page_preview";}s:5:"class";s:18:"TemplImageServices";}', 1),
(46, 'sys_image_transcoder_local_file_delete_sys_builder_page_embed', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:22:"sys_builder_page_embed";}s:5:"class";s:18:"TemplImageServices";}', 1),
(47, 'sys_image_transcoder_orig_file_delete_sys_builder_page_embed', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:22:"sys_builder_page_embed";}s:5:"class";s:18:"TemplImageServices";}', 1),
(48, 'sys_image_transcoder_local_file_delete_sys_cmts_images_preview', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:23:"sys_cmts_images_preview";}s:5:"class";s:18:"TemplImageServices";}', 1),
(49, 'sys_image_transcoder_orig_file_delete_sys_cmts_images_preview', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:23:"sys_cmts_images_preview";}s:5:"class";s:18:"TemplImageServices";}', 1),
(50, 'sys_image_transcoder_local_file_delete_sys_custom_images', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:17:"sys_custom_images";}s:5:"class";s:18:"TemplImageServices";}', 1),
(51, 'sys_image_transcoder_orig_file_delete_sys_custom_images', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:17:"sys_custom_images";}s:5:"class";s:18:"TemplImageServices";}', 1),
(52, 'sys_image_transcoder_local_file_delete_sys_images_editor', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:17:"sys_images_editor";}s:5:"class";s:18:"TemplImageServices";}', 1),
(53, 'sys_image_transcoder_orig_file_delete_sys_images_editor', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:17:"sys_images_editor";}s:5:"class";s:18:"TemplImageServices";}', 1),
(54, 'sys_image_transcoder_local_file_delete_sys_wiki_images_preview', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:32:"alert_response_file_delete_local";s:6:"params";a:1:{i:0;s:23:"sys_wiki_images_preview";}s:5:"class";s:18:"TemplImageServices";}', 1),
(55, 'sys_image_transcoder_orig_file_delete_sys_wiki_images_preview', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"alert_response_file_delete_orig";s:6:"params";a:1:{i:0;s:23:"sys_wiki_images_preview";}s:5:"class";s:18:"TemplImageServices";}', 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_api_keys`
--

CREATE TABLE `sys_api_keys` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_api_origins`
--

CREATE TABLE `sys_api_origins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_audit`
--

CREATE TABLE `sys_audit` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `added` int(11) NOT NULL,
  `profile_id` int(10) NOT NULL,
  `profile_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_id` int(10) NOT NULL,
  `content_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_info_object` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `context_profile_id` int(10) NOT NULL,
  `context_profile_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_lang_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_lang_key_params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `extras` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_background_jobs`
--

CREATE TABLE `sys_background_jobs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `added` int(11) unsigned NOT NULL DEFAULT '0',
  `priority` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `service_call` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'awaiting',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_badges`
--

CREATE TABLE `sys_badges` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `added` int(11) NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `icon` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `fontcolor` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `is_icon_only` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_badges2objects`
--

CREATE TABLE `sys_badges2objects` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `badge_id` int(11) NOT NULL,
  `object_id` int(11) NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `added` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `badge_object` (`object_id`,`badge_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_categories`
--

CREATE TABLE `sys_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `author` int(11) NOT NULL,
  `added` int(11) NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('active','hidden') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_categories2objects`
--

CREATE TABLE `sys_categories2objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_cmts_ids`
--

CREATE TABLE `sys_cmts_ids` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `system_id` int(11) NOT NULL DEFAULT '0',
  `cmt_id` int(11) NOT NULL DEFAULT '0',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `rate` float NOT NULL DEFAULT '0',
  `votes` int(11) NOT NULL DEFAULT '0',
  `rrate` float NOT NULL DEFAULT '0',
  `rvotes` int(11) NOT NULL DEFAULT '0',
  `score` int(11) NOT NULL DEFAULT '0',
  `sc_up` int(11) NOT NULL DEFAULT '0',
  `sc_down` int(11) NOT NULL DEFAULT '0',
  `reports` int(11) NOT NULL DEFAULT '0',
  `status_admin` enum('active','hidden','pending') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  UNIQUE KEY `system_cmt_id` (`system_id`,`cmt_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_cmts_images`
--

CREATE TABLE `sys_cmts_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profile_id` int(10) unsigned NOT NULL,
  `remote_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` bigint(20) NOT NULL,
  `dimensions` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `added` int(11) NOT NULL,
  `modified` int(11) NOT NULL,
  `private` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `remote_id` (`remote_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_cmts_images2entries`
--

CREATE TABLE `sys_cmts_images2entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `system_id` int(11) NOT NULL DEFAULT '0',
  `cmt_id` int(11) NOT NULL DEFAULT '0',
  `image_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image` (`system_id`,`cmt_id`,`image_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_cmts_images_preview`
--

CREATE TABLE `sys_cmts_images_preview` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profile_id` int(10) unsigned NOT NULL,
  `remote_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` bigint(20) NOT NULL,
  `added` int(11) NOT NULL,
  `modified` int(11) NOT NULL,
  `private` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `remote_id` (`remote_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_cmts_meta_keywords`
--

CREATE TABLE `sys_cmts_meta_keywords` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(10) unsigned NOT NULL,
  `keyword` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `object_id` (`object_id`),
  KEY `keyword` (`keyword`(250))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_cmts_meta_mentions`
--

CREATE TABLE `sys_cmts_meta_mentions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(10) unsigned NOT NULL,
  `profile_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `object_id` (`object_id`),
  KEY `profile_id` (`profile_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_cmts_reactions`
--

CREATE TABLE `sys_cmts_reactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `reaction` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `count` int(11) NOT NULL DEFAULT '0',
  `sum` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reaction` (`object_id`,`reaction`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_cmts_reactions_track`
--

CREATE TABLE `sys_cmts_reactions_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `author_nip` int(11) unsigned NOT NULL DEFAULT '0',
  `reaction` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` tinyint(4) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `vote` (`object_id`,`author_nip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_cmts_reports`
--

CREATE TABLE `sys_cmts_reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_cmts_reports_track`
--

CREATE TABLE `sys_cmts_reports_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `author_nip` int(11) unsigned NOT NULL DEFAULT '0',
  `type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` int(11) NOT NULL DEFAULT '0',
  `checked_by` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `report` (`object_id`,`author_nip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_cmts_scores`
--

CREATE TABLE `sys_cmts_scores` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `count_up` int(11) NOT NULL DEFAULT '0',
  `count_down` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_cmts_scores_track`
--

CREATE TABLE `sys_cmts_scores_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `author_nip` int(11) unsigned NOT NULL DEFAULT '0',
  `type` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `date` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `vote` (`object_id`,`author_nip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_cmts_votes`
--

CREATE TABLE `sys_cmts_votes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `count` int(11) NOT NULL DEFAULT '0',
  `sum` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_cmts_votes_track`
--

CREATE TABLE `sys_cmts_votes_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `author_nip` int(11) unsigned NOT NULL DEFAULT '0',
  `value` tinyint(4) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `vote` (`object_id`,`author_nip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_content_info_grids`
--

CREATE TABLE `sys_content_info_grids` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `grid_object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `grid_field_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `condition` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `selection` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `grid_object` (`grid_object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `sys_content_info_grids`
--

INSERT INTO `sys_content_info_grids` VALUES
(1, 'bx_persons', 'bx_persons_administration', 'td`.`id', '', ''),
(2, 'bx_persons', 'bx_persons_common', 'td`.`id', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_cron_jobs`
--

CREATE TABLE `sys_cron_jobs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `time` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '*',
  `class` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `service_call` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ts` int(11) NOT NULL,
  `timing` float NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=13 ;

--
-- Dumping data for table `sys_cron_jobs`
--

INSERT INTO `sys_cron_jobs` VALUES
(1, 'pruning', '0 0 * * *', 'BxDolCronPruning', 'inc/classes/BxDolCronPruning.php', '', 0, 0),
(2, 'sys_acl', '0 0 * * *', 'BxDolCronAcl', 'inc/classes/BxDolCronAcl.php', '', 0, 0),
(3, 'sys_account', '0 0 * * *', 'BxDolCronAccount', 'inc/classes/BxDolCronAccount.php', '', 0, 0),
(4, 'sys_profile', '0 0 * * *', 'BxDolCronProfile', 'inc/classes/BxDolCronProfile.php', '', 0, 0),
(5, 'sys_upgrade', '0 3 * * *', 'BxDolCronUpgradeCheck', 'inc/classes/BxDolCronUpgradeCheck.php', '', 0, 0),
(6, 'sys_upgrade_modules', '30 2 * * *', 'BxDolCronUpgradeModulesCheck', 'inc/classes/BxDolCronUpgradeModulesCheck.php', '', 0, 0),
(7, 'sys_storage', '* * * * *', 'BxDolCronStorage', 'inc/classes/BxDolCronStorage.php', '', 0, 0),
(8, 'sys_transcoder', '* * * * *', 'BxDolCronTranscoder', 'inc/classes/BxDolCronTranscoder.php', '', 0, 0),
(9, 'sys_queue_email', '* * * * *', 'BxDolCronQueueEmail', 'inc/classes/BxDolCronQueueEmail.php', '', 0, 0),
(10, 'sys_queue_push', '* * * * *', 'BxDolCronQueuePush', 'inc/classes/BxDolCronQueuePush.php', '', 0, 0),
(11, 'sys_audit_clean', '* * * * *', 'BxDolCronAudit', 'inc/classes/BxDolCronAudit.php', '', 0, 0),
(12, 'sys_background_jobs', '* * * * *', 'BxDolCronBackgroundJobs', 'inc/classes/BxDolCronBackgroundJobs.php', '', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `sys_email_templates`
--

CREATE TABLE `sys_email_templates` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `NameSystem` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Body` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=25 ;

--
-- Dumping data for table `sys_email_templates`
--

INSERT INTO `sys_email_templates` VALUES
(1, 'system', '_sys_et_txt_name_system_admin_email', 't_AdminEmail', '_sys_et_txt_subject_admin_email', '_sys_et_txt_body_admin_email'),
(2, 'system', '_sys_et_txt_name_system_confirmation', 't_Confirmation', '_sys_et_txt_subject_confirmation', '_sys_et_txt_body_confirmation'),
(3, 'system', '_sys_et_txt_name_system_forgot', 't_Forgot', '_sys_et_txt_subject_forgot', '_sys_et_txt_body_forgot'),
(4, 'system', '_sys_et_txt_name_system_mem_expiration', 't_MemExpiration', '_sys_et_txt_subject_mem_expiration', '_sys_et_txt_body_mem_expiration'),
(5, 'system', '_sys_et_txt_name_system_mem_changed', 't_MemChanged', '_sys_et_txt_subject_mem_changed', '_sys_et_txt_body_mem_changed'),
(6, 'system', '_sys_et_txt_name_system_mem_prolonged', 't_MemProlonged', '_sys_et_txt_subject_mem_prolonged', '_sys_et_txt_body_mem_prolonged'),
(7, 'system', '_sys_et_txt_name_system_comment_replied', 't_CommentReplied', '_sys_et_txt_subject_comment_replied', '_sys_et_txt_body_comment_replied'),
(8, 'system', '_sys_et_txt_name_system_reported', 't_Reported', '_sys_et_txt_subject_system_reported', '_sys_et_txt_body_system_reported'),
(9, 'system', '_sys_et_txt_name_system_delayed_module_uninstall', 't_DelayedModuleUninstall', '_sys_et_txt_subject_delayed_module_uninstall', '_sys_et_txt_body_delayed_module_uninstall'),
(10, 'system', '_sys_et_txt_name_system_account', 't_Account', '_sys_et_txt_subject_account', '_sys_et_txt_body_account'),
(11, 'system', '_sys_et_txt_name_system_account_password_expired', 't_AccountPasswordExpired', '_sys_et_txt_subject_account_password_expired', '_sys_et_txt_body_account_password_expired'),
(12, 'system', '_sys_et_txt_name_system_pruning', 't_Pruning', '_sys_et_txt_subject_pruning', '_sys_et_txt_body_pruning'),
(13, 'system', '_sys_et_txt_name_profile_change_status_active', 't_ChangeStatusActive', '_sys_et_txt_subject_profile_change_status_active', '_sys_et_txt_body_profile_change_status_active'),
(14, 'system', '_sys_et_txt_name_profile_change_status_suspended', 't_ChangeStatusSuspended', '_sys_et_txt_subject_profile_change_status_suspended', '_sys_et_txt_body_profile_change_status_suspended'),
(15, 'system', '_sys_et_txt_name_profile_change_status_pending', 't_ChangeStatusPending', '_sys_et_txt_subject_profile_change_status_pending', '_sys_et_txt_body_profile_change_status_pending'),
(16, 'system', '_sys_et_txt_name_upgrade_failed', 't_UpgradeFailed', '_sys_et_txt_subject_upgrade_failed', '_sys_et_txt_body_upgrade_failed'),
(17, 'system', '_sys_et_txt_name_upgrade_modules_failed', 't_UpgradeModulesFailed', '_sys_et_txt_subject_upgrade_modules_failed', '_sys_et_txt_body_upgrade_modules_failed'),
(18, 'system', '_sys_et_txt_name_upgrade_success', 't_UpgradeSuccess', '_sys_et_txt_subject_upgrade_success', '_sys_et_txt_body_upgrade_success'),
(19, 'system', '_sys_et_txt_name_upgrade_modules_success', 't_UpgradeModulesSuccess', '_sys_et_txt_subject_upgrade_modules_success', '_sys_et_txt_body_upgrade_modules_success'),
(20, 'system', '_sys_et_txt_name_bg_operation_failed', 't_BgOperationFailed', '_sys_et_txt_subject_bg_operation_failed', '_sys_et_txt_body_bg_operation_failed'),
(21, 'system', '_sys_et_txt_name_account_change_status_activate', 't_ChangeStatusAccountActivate', '_sys_et_txt_subject_account_change_status_activate', '_sys_et_txt_body_account_change_status_activate'),
(22, 'system', '_sys_et_txt_name_account_change_status_suspended', 't_ChangeStatusAccountSuspend', '_sys_et_txt_subject_account_change_status_suspended', '_sys_et_txt_body_account_change_status_suspended'),
(23, 'system', '_sys_et_txt_name_manage_approve', 't_ManageApprove', '_sys_et_txt_subject_manage_approve', '_sys_et_txt_body_manage_approve'),
(24, 'bx_persons', '_bx_persons_email_friend_request', 'bx_persons_friend_request', '_bx_persons_email_friend_request_subject', '_bx_persons_email_friend_request_body');

-- --------------------------------------------------------

--
-- Table structure for table `sys_embeded_data`
--

CREATE TABLE `sys_embeded_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `added` int(11) DEFAULT NULL,
  `theme` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_files`
--

CREATE TABLE `sys_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profile_id` int(10) unsigned NOT NULL,
  `remote_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` bigint(20) NOT NULL,
  `added` int(11) NOT NULL,
  `modified` int(11) NOT NULL,
  `private` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `remote_id` (`remote_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_form_displays`
--

CREATE TABLE `sys_form_displays` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `display_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `view_mode` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `object_display_name` (`object`,`display_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=41 ;

--
-- Dumping data for table `sys_form_displays`
--

INSERT INTO `sys_form_displays` VALUES
(1, 'sys_login', 'system', 'sys_login', '_sys_form_display_login', 0),
(2, 'sys_login_step2', 'system', 'sys_login', '_sys_form_display_login_step2', 0),
(3, 'sys_login_step3', 'system', 'sys_login', '_sys_form_display_login_step3', 0),
(4, 'sys_account_create', 'system', 'sys_account', '_sys_form_display_account_create', 0),
(5, 'sys_account_settings_email', 'system', 'sys_account', '_sys_form_display_account_settings_email', 0),
(6, 'sys_account_settings_pwd', 'system', 'sys_account', '_sys_form_display_account_settings_password', 0),
(7, 'sys_account_settings_info', 'system', 'sys_account', '_sys_form_display_account_settings_info', 0),
(8, 'sys_account_settings_del_account', 'system', 'sys_account', '_sys_form_display_account_settings_delete', 0),
(9, 'sys_profile_cf_set', 'system', 'sys_profile', '_sys_form_display_profile_cf_set', 0),
(10, 'sys_profile_cf_manage', 'system', 'sys_profile', '_sys_form_display_profile_cf_manage', 0),
(11, 'sys_forgot_password', 'system', 'sys_forgot_password', '_sys_form_display_forgot_password', 0),
(12, 'sys_forgot_password_reset', 'system', 'sys_forgot_password', '_sys_form_display_forgot_password_reset', 0),
(13, 'sys_confirm_phone_set_phone', 'system', 'sys_confirm_phone', '_sys_form_display_confirm_phone_set_phone', 0),
(14, 'sys_confirm_phone_confirmation', 'system', 'sys_confirm_phone', '_sys_form_display_confirm_phone_confirmation', 0),
(15, 'sys_confirm_email', 'system', 'sys_confirm_email', '_sys_form_display_confirm_email', 0),
(16, 'sys_unsubscribe_updates', 'system', 'sys_unsubscribe', '_sys_form_display_unsubscribe_updates', 0),
(17, 'sys_unsubscribe_news', 'system', 'sys_unsubscribe', '_sys_form_display_unsubscribe_news', 0),
(18, 'sys_comment_post', 'system', 'sys_comment', '_sys_form_display_comment_post', 0),
(19, 'sys_comment_edit', 'system', 'sys_comment', '_sys_form_display_comment_edit', 0),
(20, 'sys_agents_comment_post', 'system', 'sys_agents_comment', '_sys_form_display_agents_comment_post', 0),
(21, 'sys_review_post', 'system', 'sys_review', '_sys_form_review_display_post', 0),
(22, 'sys_review_edit', 'system', 'sys_review', '_sys_form_review_display_edit', 0),
(23, 'sys_report_post', 'system', 'sys_report', '_sys_form_display_report_post', 0),
(24, 'sys_favorite_add', 'system', 'sys_favorite', '_sys_form_display_favorite_add', 0),
(25, 'sys_favorite_list_edit', 'system', 'sys_favorite', '_sys_form_display_favorite_list_edit', 0),
(26, 'sys_privacy_group_custom_members', 'system', 'sys_privacy_group_custom', '_sys_form_display_ps_gc_members', 0),
(27, 'sys_privacy_group_custom_memberships', 'system', 'sys_privacy_group_custom', '_sys_form_display_ps_gc_memberships', 0),
(28, 'sys_labels_select', 'system', 'sys_labels', '_sys_form_labels_display_select', 0),
(29, 'sys_wiki_edit', 'system', 'sys_wiki', '_sys_form_display_wiki_edit', 0),
(30, 'sys_wiki_translate', 'system', 'sys_wiki', '_sys_form_display_wiki_translate', 0),
(31, 'sys_manage_approve', 'system', 'sys_manage', '_sys_form_display_manage_approve', 0),
(32, 'sys_acl_set', 'system', 'sys_acl', '_sys_form_display_acl_set', 0),
(33, 'bx_person_add', 'bx_persons', 'bx_person', '_bx_persons_form_profile_display_add', 0),
(34, 'bx_person_delete', 'bx_persons', 'bx_person', '_bx_persons_form_profile_display_delete', 0),
(35, 'bx_person_edit', 'bx_persons', 'bx_person', '_bx_persons_form_profile_display_edit', 0),
(36, 'bx_person_edit_cover', 'bx_persons', 'bx_person', '_bx_persons_form_profile_display_edit_cover', 0),
(37, 'bx_person_view', 'bx_persons', 'bx_person', '_bx_persons_form_profile_display_view', 1),
(38, 'bx_person_view_full', 'bx_persons', 'bx_person', '_bx_persons_form_profile_display_view_full', 1),
(39, 'bx_person_skills', 'bx_persons', 'bx_person_skills', '_bx_persons_skills_form_profile_display_add', 0),
(40, 'bx_person_skills_view', 'bx_persons', 'bx_person_skills', '_bx_persons_skills_form_profile_display_view', 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_form_display_inputs`
--

CREATE TABLE `sys_form_display_inputs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `display_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `input_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `visible_for_levels` int(11) NOT NULL DEFAULT '2147483647',
  `active` tinyint(4) NOT NULL DEFAULT '0',
  `order` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `display_input` (`display_name`,`input_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=247 ;

--
-- Dumping data for table `sys_form_display_inputs`
--

INSERT INTO `sys_form_display_inputs` VALUES
(1, 'sys_login', 'role', 2147483647, 1, 1),
(2, 'sys_login', 'relocate', 2147483647, 1, 2),
(3, 'sys_login', 'ID', 2147483647, 1, 3),
(4, 'sys_login', 'Password', 2147483647, 1, 4),
(5, 'sys_login', 'rememberMe', 2147483647, 1, 5),
(6, 'sys_login', 'submit_text', 2147483647, 1, 6),
(7, 'sys_login', 'login', 2147483647, 1, 7),
(8, 'sys_login_step2', 'phone', 2147483647, 1, 1),
(9, 'sys_login_step2', 'do_sendsms', 2147483647, 1, 2),
(10, 'sys_login_step2', 'relocate', 2147483647, 1, 3),
(11, 'sys_login_step3', 'code', 2147483647, 1, 1),
(12, 'sys_login_step3', 'do_checkcode', 2147483647, 1, 2),
(13, 'sys_login_step3', 'back', 2147483647, 1, 3),
(14, 'sys_login_step3', 'relocate', 2147483647, 1, 4),
(15, 'sys_account_create', 'name', 2147483647, 1, 1),
(16, 'sys_account_create', 'email', 2147483647, 1, 2),
(17, 'sys_account_create', 'phone', 2147483647, 0, 3),
(18, 'sys_account_create', 'password', 2147483647, 1, 4),
(19, 'sys_account_create', 'receive_news', 2147483647, 1, 5),
(20, 'sys_account_create', 'do_publish', 2147483647, 1, 6),
(21, 'sys_account_create', 'agreement', 2147483647, 0, 7),
(22, 'sys_account_settings_email', 'email', 2147483647, 1, 1),
(23, 'sys_account_settings_email', 'password_current', 2147483647, 1, 2),
(24, 'sys_account_settings_email', 'receive_updates', 2147483647, 1, 3),
(25, 'sys_account_settings_email', 'receive_news', 2147483647, 1, 4),
(26, 'sys_account_settings_email', 'do_submit', 2147483647, 1, 5),
(27, 'sys_account_settings_pwd', 'password_current', 2147483647, 1, 1),
(28, 'sys_account_settings_pwd', 'password', 2147483647, 1, 2),
(29, 'sys_account_settings_pwd', 'password_confirm', 2147483647, 1, 3),
(30, 'sys_account_settings_pwd', 'do_submit', 2147483647, 1, 4),
(31, 'sys_account_settings_del_account', 'delete_content', 2147483647, 1, 0),
(32, 'sys_account_settings_del_account', 'delete_confirm', 2147483647, 1, 1),
(33, 'sys_account_settings_del_account', 'password_current', 2147483647, 1, 2),
(34, 'sys_account_settings_del_account', 'do_submit', 2147483647, 1, 3),
(35, 'sys_account_settings_info', 'name', 2147483647, 1, 1),
(36, 'sys_account_settings_info', 'do_submit', 2147483647, 1, 2),
(37, 'sys_profile_cf_set', 'cfw_value', 2147483647, 1, 1),
(38, 'sys_profile_cf_set', 'do_submit', 2147483647, 1, 2),
(39, 'sys_profile_cf_manage', 'cfu_items', 2147483647, 1, 1),
(40, 'sys_profile_cf_manage', 'cfu_locked', 2147483647, 1, 2),
(41, 'sys_profile_cf_manage', 'controls', 2147483647, 1, 3),
(42, 'sys_profile_cf_manage', 'do_submit', 2147483647, 1, 4),
(43, 'sys_profile_cf_manage', 'do_cancel', 2147483647, 1, 5),
(44, 'sys_forgot_password', 'email', 2147483647, 1, 1),
(45, 'sys_forgot_password', 'phone', 2147483647, 1, 2),
(46, 'sys_forgot_password', 'captcha', 2147483647, 1, 3),
(47, 'sys_forgot_password', 'do_submit', 2147483647, 1, 4),
(48, 'sys_forgot_password_reset', 'key', 2147483647, 1, 1),
(49, 'sys_forgot_password_reset', 'password', 2147483647, 1, 2),
(50, 'sys_forgot_password_reset', 'captcha', 2147483647, 1, 3),
(51, 'sys_forgot_password_reset', 'do_submit', 2147483647, 1, 4),
(52, 'sys_confirm_email', 'code', 2147483647, 1, 1),
(53, 'sys_confirm_email', 'do_submit', 2147483647, 1, 2),
(54, 'sys_confirm_phone_set_phone', 'phone', 2147483647, 1, 1),
(55, 'sys_confirm_phone_set_phone', 'do_sendsms', 2147483647, 1, 2),
(56, 'sys_confirm_phone_confirmation', 'code', 2147483647, 1, 1),
(57, 'sys_confirm_phone_confirmation', 'do_submit', 2147483647, 1, 2),
(58, 'sys_unsubscribe_updates', 'id', 2147483647, 1, 1),
(59, 'sys_unsubscribe_updates', 'code', 2147483647, 1, 2),
(60, 'sys_unsubscribe_updates', 'receive_updates', 2147483647, 1, 3),
(61, 'sys_unsubscribe_updates', 'do_submit', 2147483647, 1, 4),
(62, 'sys_unsubscribe_news', 'id', 2147483647, 1, 1),
(63, 'sys_unsubscribe_news', 'code', 2147483647, 1, 2),
(64, 'sys_unsubscribe_news', 'receive_news', 2147483647, 1, 3),
(65, 'sys_unsubscribe_news', 'do_submit', 2147483647, 1, 4),
(66, 'sys_comment_post', 'sys', 2147483647, 1, 1),
(67, 'sys_comment_post', 'id', 2147483647, 1, 2),
(68, 'sys_comment_post', 'action', 2147483647, 1, 3),
(69, 'sys_comment_post', 'cmt_id', 2147483647, 0, 4),
(70, 'sys_comment_post', 'cmt_parent_id', 2147483647, 1, 5),
(71, 'sys_comment_post', 'cmt_text', 2147483647, 1, 6),
(72, 'sys_comment_post', 'cmt_cf', 2147483647, 1, 7),
(73, 'sys_comment_post', 'cmt_submit', 2147483647, 1, 8),
(74, 'sys_comment_post', 'cmt_image', 2147483647, 1, 9),
(75, 'sys_comment_edit', 'sys', 2147483647, 1, 1),
(76, 'sys_comment_edit', 'id', 2147483647, 1, 2),
(77, 'sys_comment_edit', 'action', 2147483647, 1, 3),
(78, 'sys_comment_edit', 'cmt_id', 2147483647, 1, 4),
(79, 'sys_comment_edit', 'cmt_parent_id', 2147483647, 1, 5),
(80, 'sys_comment_edit', 'cmt_text', 2147483647, 1, 6),
(81, 'sys_comment_edit', 'cmt_cf', 2147483647, 1, 7),
(82, 'sys_comment_edit', 'cmt_controls', 2147483647, 1, 8),
(83, 'sys_comment_edit', 'cmt_submit', 2147483647, 1, 9),
(84, 'sys_comment_edit', 'cmt_cancel', 2147483647, 1, 10),
(85, 'sys_comment_edit', 'cmt_image', 2147483647, 1, 11),
(86, 'sys_agents_comment_post', 'sys', 2147483647, 1, 1),
(87, 'sys_agents_comment_post', 'id', 2147483647, 1, 2),
(88, 'sys_agents_comment_post', 'action', 2147483647, 1, 3),
(89, 'sys_agents_comment_post', 'cmt_parent_id', 2147483647, 1, 4),
(90, 'sys_agents_comment_post', 'cmt_text', 2147483647, 1, 5),
(91, 'sys_agents_comment_post', 'cmt_submit', 2147483647, 1, 6),
(92, 'sys_agents_comment_post', 'cmt_image', 2147483647, 1, 7),
(93, 'sys_review_post', 'sys', 2147483647, 1, 1),
(94, 'sys_review_post', 'id', 2147483647, 1, 2),
(95, 'sys_review_post', 'action', 2147483647, 1, 3),
(96, 'sys_review_post', 'cmt_id', 2147483647, 0, 4),
(97, 'sys_review_post', 'cmt_parent_id', 2147483647, 1, 5),
(98, 'sys_review_post', 'cmt_text', 2147483647, 1, 6),
(99, 'sys_review_post', 'cmt_mood', 2147483647, 1, 7),
(100, 'sys_review_post', 'cmt_cf', 2147483647, 1, 9),
(101, 'sys_review_post', 'cmt_submit', 2147483647, 1, 10),
(102, 'sys_review_post', 'cmt_image', 2147483647, 1, 11),
(103, 'sys_review_edit', 'sys', 2147483647, 1, 1),
(104, 'sys_review_edit', 'id', 2147483647, 1, 2),
(105, 'sys_review_edit', 'action', 2147483647, 1, 3),
(106, 'sys_review_edit', 'cmt_id', 2147483647, 1, 4),
(107, 'sys_review_edit', 'cmt_parent_id', 2147483647, 1, 5),
(108, 'sys_review_edit', 'cmt_text', 2147483647, 1, 6),
(109, 'sys_review_edit', 'cmt_mood', 2147483647, 1, 7),
(110, 'sys_review_edit', 'cmt_cf', 2147483647, 1, 9),
(111, 'sys_review_edit', 'cmt_submit', 2147483647, 1, 10),
(112, 'sys_review_edit', 'cmt_image', 2147483647, 1, 11),
(113, 'sys_report_post', 'sys', 2147483647, 1, 1),
(114, 'sys_report_post', 'object_id', 2147483647, 1, 2),
(115, 'sys_report_post', 'action', 2147483647, 1, 3),
(116, 'sys_report_post', 'id', 2147483647, 0, 4),
(117, 'sys_report_post', 'type', 2147483647, 1, 5),
(118, 'sys_report_post', 'text', 2147483647, 1, 6),
(119, 'sys_report_post', 'submit', 2147483647, 1, 7),
(120, 'sys_favorite_add', 'sys', 2147483647, 1, 1),
(121, 'sys_favorite_add', 'object_id', 2147483647, 1, 2),
(122, 'sys_favorite_add', 'action', 2147483647, 1, 3),
(123, 'sys_favorite_add', 'id', 2147483647, 0, 4),
(124, 'sys_favorite_add', 'list', 2147483647, 1, 5),
(125, 'sys_favorite_add', 'new_list', 2147483647, 1, 6),
(126, 'sys_favorite_add', 'title', 2147483647, 1, 7),
(127, 'sys_favorite_add', 'allow_view_favorite_list_to', 2147483647, 1, 8),
(128, 'sys_favorite_add', 'submit', 2147483647, 1, 9),
(129, 'sys_favorite_list_edit', 'sys', 2147483647, 1, 1),
(130, 'sys_favorite_list_edit', 'list_id', 2147483647, 1, 2),
(131, 'sys_favorite_list_edit', 'object_id', 2147483647, 1, 3),
(132, 'sys_favorite_list_edit', 'action', 2147483647, 1, 4),
(133, 'sys_favorite_list_edit', 'title', 2147483647, 1, 5),
(134, 'sys_favorite_list_edit', 'allow_view_favorite_list_to', 2147483647, 1, 6),
(135, 'sys_favorite_list_edit', 'submit', 2147483647, 1, 7),
(136, 'sys_privacy_group_custom_members', 'profile_id', 2147483647, 1, 1),
(137, 'sys_privacy_group_custom_members', 'content_id', 2147483647, 1, 2),
(138, 'sys_privacy_group_custom_members', 'object', 2147483647, 1, 3),
(139, 'sys_privacy_group_custom_members', 'action', 2147483647, 1, 4),
(140, 'sys_privacy_group_custom_members', 'group_id', 2147483647, 1, 5),
(141, 'sys_privacy_group_custom_members', 'search', 2147483647, 1, 6),
(142, 'sys_privacy_group_custom_members', 'list', 2147483647, 1, 7),
(143, 'sys_privacy_group_custom_members', 'controls', 2147483647, 1, 8),
(144, 'sys_privacy_group_custom_members', 'do_submit', 2147483647, 1, 9),
(145, 'sys_privacy_group_custom_members', 'do_cancel', 2147483647, 1, 10),
(146, 'sys_privacy_group_custom_memberships', 'profile_id', 2147483647, 1, 1),
(147, 'sys_privacy_group_custom_memberships', 'content_id', 2147483647, 1, 2),
(148, 'sys_privacy_group_custom_memberships', 'object', 2147483647, 1, 3),
(149, 'sys_privacy_group_custom_memberships', 'action', 2147483647, 1, 4),
(150, 'sys_privacy_group_custom_memberships', 'group_id', 2147483647, 1, 5),
(151, 'sys_privacy_group_custom_memberships', 'memberships', 2147483647, 1, 6),
(152, 'sys_privacy_group_custom_memberships', 'controls', 2147483647, 1, 7),
(153, 'sys_privacy_group_custom_memberships', 'do_submit', 2147483647, 1, 8),
(154, 'sys_privacy_group_custom_memberships', 'do_cancel', 2147483647, 1, 9),
(155, 'sys_labels_select', 'name', 2147483647, 1, 1),
(156, 'sys_labels_select', 'action', 2147483647, 1, 2),
(157, 'sys_labels_select', 'search', 2147483647, 1, 3),
(158, 'sys_labels_select', 'list', 2147483647, 1, 4),
(159, 'sys_labels_select', 'list_context', 2147483647, 1, 5),
(160, 'sys_labels_select', 'controls', 2147483647, 1, 6),
(161, 'sys_labels_select', 'do_submit', 2147483647, 1, 7),
(162, 'sys_labels_select', 'do_cancel', 2147483647, 1, 8),
(163, 'sys_wiki_edit', 'block_id', 2147483647, 1, 1),
(164, 'sys_wiki_edit', 'language', 2147483647, 1, 2),
(165, 'sys_wiki_edit', 'content', 2147483647, 1, 3),
(166, 'sys_wiki_edit', 'files', 2147483647, 1, 4),
(167, 'sys_wiki_edit', 'notes', 2147483647, 1, 5),
(168, 'sys_wiki_edit', 'do_submit', 2147483647, 1, 6),
(169, 'sys_wiki_edit', 'close', 2147483647, 1, 7),
(170, 'sys_wiki_edit', 'buttons', 2147483647, 1, 8),
(171, 'sys_wiki_translate', 'block_id', 2147483647, 1, 1),
(172, 'sys_wiki_translate', 'content_main', 2147483647, 1, 2),
(173, 'sys_wiki_translate', 'language', 2147483647, 1, 3),
(174, 'sys_wiki_translate', 'content', 2147483647, 1, 4),
(175, 'sys_wiki_translate', 'files', 2147483647, 1, 5),
(176, 'sys_wiki_translate', 'notes', 2147483647, 1, 6),
(177, 'sys_wiki_translate', 'do_submit', 2147483647, 1, 7),
(178, 'sys_wiki_translate', 'close', 2147483647, 1, 8),
(179, 'sys_wiki_translate', 'buttons', 2147483647, 1, 9),
(180, 'sys_manage_approve', 'content_id', 2147483647, 1, 1),
(181, 'sys_manage_approve', 'notes', 2147483647, 1, 2),
(182, 'sys_manage_approve', 'controls', 2147483647, 1, 3),
(183, 'sys_manage_approve', 'do_send', 2147483647, 1, 4),
(184, 'sys_manage_approve', 'do_submit', 2147483647, 1, 5),
(185, 'sys_manage_approve', 'do_cancel', 2147483647, 1, 6),
(186, 'sys_acl_set', 'profile_id', 2147483647, 1, 1),
(187, 'sys_acl_set', 'card', 2147483647, 1, 2),
(188, 'sys_acl_set', 'level_id', 2147483647, 1, 3),
(189, 'sys_acl_set', 'duration', 2147483647, 1, 4),
(190, 'sys_acl_set', 'controls', 2147483647, 1, 5),
(191, 'sys_acl_set', 'do_submit', 2147483647, 1, 6),
(192, 'sys_acl_set', 'do_cancel', 2147483647, 1, 7),
(193, 'bx_person_add', 'picture', 2147483647, 1, 1),
(194, 'bx_person_add', 'gender', 2147483647, 1, 2),
(195, 'bx_person_add', 'birthday', 2147483647, 1, 3),
(196, 'bx_person_add', 'fullname', 2147483647, 1, 4),
(197, 'bx_person_add', 'last_name', 2147483647, 0, 5),
(198, 'bx_person_add', 'description', 2147483647, 1, 6),
(199, 'bx_person_add', 'location', 2147483647, 1, 7),
(200, 'bx_person_add', 'allow_view_to', 2147483647, 1, 8),
(201, 'bx_person_add', 'allow_post_to', 2147483647, 1, 9),
(202, 'bx_person_add', 'allow_contact_to', 2147483647, 1, 10),
(203, 'bx_person_add', 'do_submit', 2147483647, 1, 11),
(204, 'bx_person_delete', 'cover', 2147483647, 0, 0),
(205, 'bx_person_delete', 'picture', 2147483647, 0, 0),
(206, 'bx_person_delete', 'delete_confirm', 2147483647, 1, 0),
(207, 'bx_person_delete', 'do_submit', 2147483647, 1, 1),
(208, 'bx_person_delete', 'fullname', 2147483647, 0, 2),
(209, 'bx_person_edit', 'picture', 2147483647, 1, 1),
(210, 'bx_person_edit', 'gender', 2147483647, 1, 2),
(211, 'bx_person_edit', 'birthday', 2147483647, 1, 3),
(212, 'bx_person_edit', 'fullname', 2147483647, 1, 4),
(213, 'bx_person_edit', 'last_name', 2147483647, 0, 5),
(214, 'bx_person_edit', 'description', 2147483647, 1, 6),
(215, 'bx_person_edit', 'location', 2147483647, 1, 7),
(216, 'bx_person_edit', 'allow_view_to', 2147483647, 1, 8),
(217, 'bx_person_edit', 'allow_post_to', 2147483647, 1, 9),
(218, 'bx_person_edit', 'allow_contact_to', 2147483647, 1, 10),
(219, 'bx_person_edit', 'do_submit', 2147483647, 1, 11),
(220, 'bx_person_edit_cover', 'delete_confirm', 2147483647, 0, 1),
(221, 'bx_person_edit_cover', 'fullname', 2147483647, 0, 2),
(222, 'bx_person_edit_cover', 'picture', 2147483647, 0, 3),
(223, 'bx_person_edit_cover', 'cover', 2147483647, 1, 7),
(224, 'bx_person_edit_cover', 'do_submit', 2147483647, 1, 8),
(225, 'bx_person_view', 'gender', 2147483647, 1, 1),
(226, 'bx_person_view', 'birthday', 2147483647, 1, 2),
(227, 'bx_person_view', 'fullname', 2147483647, 1, 3),
(228, 'bx_person_view', 'last_name', 2147483647, 0, 4),
(229, 'bx_person_view', 'profile_email', 192, 1, 5),
(230, 'bx_person_view', 'profile_status', 192, 1, 6),
(231, 'bx_person_view', 'profile_ip', 192, 1, 7),
(232, 'bx_person_view', 'profile_last_active', 192, 1, 8),
(233, 'bx_person_view', 'added', 192, 1, 9),
(234, 'bx_person_view', 'changed', 192, 1, 10),
(235, 'bx_person_view', 'friends_count', 2147483647, 1, 11),
(236, 'bx_person_view', 'followers_count', 2147483647, 1, 12),
(237, 'bx_person_view_full', 'gender', 2147483647, 1, 1),
(238, 'bx_person_view_full', 'birthday', 2147483647, 1, 2),
(239, 'bx_person_view_full', 'fullname', 2147483647, 1, 3),
(240, 'bx_person_view_full', 'last_name', 2147483647, 0, 4),
(241, 'bx_person_view_full', 'description', 2147483647, 0, 5),
(242, 'bx_person_view_full', 'profile_email', 192, 1, 6),
(243, 'bx_person_view_full', 'profile_status', 192, 1, 7),
(244, 'bx_person_view_full', 'profile_last_active', 192, 1, 8),
(245, 'bx_person_skills', 'skill_name', 2147483647, 1, 1),
(246, 'bx_person_skills_view', 'skill_name', 2147483647, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_form_fields_ids`
--

CREATE TABLE `sys_form_fields_ids` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_form` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_id` int(11) NOT NULL DEFAULT '0',
  `author_id` int(10) NOT NULL DEFAULT '0',
  `nested_content_id` int(10) NOT NULL DEFAULT '0',
  `rate` float NOT NULL DEFAULT '0',
  `votes` int(11) NOT NULL DEFAULT '0',
  `rrate` float NOT NULL DEFAULT '0',
  `rvotes` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `system_form_fields_id` (`object_form`,`content_id`,`nested_content_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_form_fields_reaction`
--

CREATE TABLE `sys_form_fields_reaction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `reaction` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `count` int(11) NOT NULL DEFAULT '0',
  `sum` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reaction` (`object_id`,`reaction`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_form_fields_reaction_track`
--

CREATE TABLE `sys_form_fields_reaction_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `author_nip` int(11) unsigned NOT NULL DEFAULT '0',
  `reaction` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` tinyint(4) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `vote` (`object_id`,`author_nip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_form_fields_votes`
--

CREATE TABLE `sys_form_fields_votes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `count` int(11) NOT NULL DEFAULT '0',
  `sum` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_form_fields_votes_track`
--

CREATE TABLE `sys_form_fields_votes_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `author_nip` int(11) unsigned NOT NULL DEFAULT '0',
  `value` tinyint(4) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `vote` (`object_id`,`author_nip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_form_inputs`
--

CREATE TABLE `sys_form_inputs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `values` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked` tinyint(4) NOT NULL DEFAULT '0',
  `type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `caption_system` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `info` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `help` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(4) NOT NULL DEFAULT '0',
  `unique` tinyint(4) NOT NULL DEFAULT '0',
  `collapsed` tinyint(4) NOT NULL DEFAULT '0',
  `html` tinyint(4) NOT NULL DEFAULT '0',
  `privacy` tinyint(4) NOT NULL DEFAULT '0',
  `rateable` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `attrs` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `attrs_tr` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `attrs_wrapper` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `checker_func` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `checker_params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `checker_error` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `db_pass` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `db_params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `editable` tinyint(4) NOT NULL DEFAULT '1',
  `deletable` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `display_name` (`object`,`name`(127))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=162 ;

--
-- Dumping data for table `sys_form_inputs`
--

INSERT INTO `sys_form_inputs` VALUES
(1, 'sys_login', 'system', 'role', '1', '', 0, 'hidden', '_sys_form_login_input_caption_system_role', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(2, 'sys_login', 'system', 'relocate', '', '', 0, 'hidden', '_sys_form_login_input_caption_system_relocate', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(3, 'sys_login', 'system', 'ID', '', '', 0, 'text', '_sys_form_login_input_caption_system_id', '_sys_form_login_input_email', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(4, 'sys_login', 'system', 'Password', '', '', 0, 'password', '_sys_form_login_input_caption_system_password', '_sys_form_login_input_password', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(5, 'sys_login', 'system', 'rememberMe', '1', '', 0, 'switcher', '_sys_form_login_input_caption_system_remember_me', '_sys_form_login_input_remember_me', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(6, 'sys_login', 'system', 'login', '_sys_form_login_input_submit', '', 0, 'submit', '_sys_form_login_input_caption_system_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(7, 'sys_login', 'system', 'submit_text', '', '', 0, 'custom', '_sys_form_login_input_caption_system_submit_text', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(8, 'sys_login', 'system', 'phone', '', '', 0, 'text', '_sys_form_login_input_caption_system_phone', '_sys_form_login_input_phone', '_sys_form_login_input_phone_info', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'PhoneExist', '', '_sys_form_login_input_phone_error_format', 'Xss', '', 1, 0),
(9, 'sys_login', 'system', 'code', '', '', 0, 'text', '_sys_form_login_input_caption_system_code', '_sys_form_login_input_code', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'CodeExist', '', '_sys_form_login_input_code_error_empty', 'Xss', '', 0, 0),
(10, 'sys_login', 'system', 'back', '', '', 0, 'value', '_sys_form_login_input_caption_system_back', '_sys_form_login_input_back', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Xss', '', 0, 0),
(11, 'sys_login', 'system', 'do_checkcode', '_sys_form_login_input_checkcode', '', 0, 'submit', '_sys_form_login_input_caption_system_checkcode', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(12, 'sys_login', 'system', 'do_sendsms', '_sys_form_login_input_sendsms', '', 0, 'submit', '_sys_form_login_input_caption_system_sendsms', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(13, 'sys_account', 'system', 'email', '', '', 0, 'text', '_sys_form_login_input_caption_system_email', '_sys_form_account_input_email', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'EmailUniq', '', '_sys_form_account_input_email_error', 'Xss', '', 0, 0),
(14, 'sys_account', 'system', 'phone', '', '', 0, 'text', '_sys_form_login_input_caption_system_phone', '_sys_form_login_input_phone', '_sys_form_login_input_phone_info', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'PhoneExist', '', '_sys_form_login_input_phone_error_format', 'Xss', '', 1, 0),
(15, 'sys_account', 'system', 'password', '', '', 0, 'password', '_sys_form_login_input_caption_system_password', '_sys_form_account_input_password', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'Password', 'a:1:{s:4:"preg";s:38:"~^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d).{8,}~";}', '_sys_form_account_input_password_error', '', '', 0, 0),
(16, 'sys_account', 'system', 'password_confirm', '', '', 0, 'password', '_sys_form_login_input_caption_system_password_confirm', '_sys_form_account_input_password_confirm', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'PasswordConfirm', '', '_sys_form_account_input_password_confirm_error', '', '', 0, 0),
(17, 'sys_account', 'system', 'do_submit', '_sys_form_account_input_submit', '', 0, 'submit', '_sys_form_login_input_caption_system_do_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(18, 'sys_account', 'system', 'do_publish', '_sys_form_account_input_publish', '', 0, 'submit', '_sys_form_login_input_caption_system_do_publish', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(19, 'sys_account', 'system', 'name', '', '', 0, 'text', '_sys_form_login_input_caption_system_name', '_sys_form_account_input_name', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'ProfileName', '', '_sys_form_account_input_name_error', 'Xss', '', 1, 0),
(20, 'sys_account', 'system', 'captcha', '', '', 0, 'captcha', '_sys_form_login_input_caption_system_captcha', '_sys_form_account_input_captcha', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'Captcha', '', '_sys_form_account_input_captcha_error', '', '', 1, 0),
(21, 'sys_account', 'system', 'password_current', '', '', 0, 'password', '_sys_form_login_input_caption_system_password_current', '_sys_form_account_input_password_current', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'PasswordCurrent', '', '_sys_form_account_input_password_current_error', '', '', 0, 0),
(22, 'sys_account', 'system', 'delete_content', '1', '', 0, 'hidden', '_sys_form_login_input_caption_system_delete_content', '', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(23, 'sys_account', 'system', 'delete_confirm', '1', '', 0, 'checkbox', '_sys_form_login_input_caption_system_delete_confirm', '_sys_form_account_input_delete_confirm', '_sys_form_account_input_delete_confirm_info', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'Avail', '', '_sys_form_account_input_delete_confirm_error', '', '', 0, 0),
(24, 'sys_account', 'system', 'receive_updates', '1', '', 1, 'switcher', '_sys_form_login_input_caption_system_receive_updates', '_sys_form_account_input_receive_updates', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(25, 'sys_account', 'system', 'receive_news', '1', '', 1, 'switcher', '_sys_form_login_input_caption_system_receive_news', '_sys_form_account_input_receive_news', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 1, 0),
(26, 'sys_account', 'system', 'agreement', '', '', 0, 'custom', '_sys_form_login_input_caption_system_agreement', '_sys_form_account_input_agreement', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(27, 'sys_profile', 'system', 'cfw_value', '', '#!sys_content_filter', 0, 'checkbox_set', '_sys_form_profile_input_sys_cfw_value', '_sys_form_profile_input_cfw_value', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Set', '', 1, 0),
(28, 'sys_profile', 'system', 'cfu_items', '', '#!sys_content_filter', 0, 'checkbox_set', '_sys_form_profile_input_sys_cfu_items', '_sys_form_profile_input_cfu_items', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Set', '', 1, 0),
(29, 'sys_profile', 'system', 'cfu_locked', '1', '', 0, 'switcher', '_sys_form_profile_input_sys_cfu_locked', '_sys_form_profile_input_cfu_locked', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 1, 0),
(30, 'sys_profile', 'system', 'controls', '', 'do_submit,do_cancel', 0, 'input_set', '', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(31, 'sys_profile', 'system', 'do_submit', '_sys_form_profile_input_do_submit', '', 0, 'submit', '_sys_form_profile_input_sys_do_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(32, 'sys_profile', 'system', 'do_cancel', '_sys_form_profile_input_do_cancel', '', 0, 'button', '_sys_form_profile_input_sys_do_cancel', '', '', '', '', 0, 0, 0, 0, 0, '', 'a:2:{s:5:"class";s:22:"bx-def-margin-sec-left";s:7:"onclick";s:45:"$(''.bx-popup-applied:visible'').dolPopupHide()";}', '', '', '', '', '', '', '', 0, 0),
(33, 'sys_forgot_password', 'system', 'key', '', '', 0, 'hidden', '_sys_form_forgot_password_input_caption_system_key', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(34, 'sys_forgot_password', 'system', 'password', '', '', 0, 'password', '_sys_form_forgot_password_input_caption_system_password_reset', '_sys_form_forgot_password_input_caption_password_reset', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'Preg', 'a:1:{s:4:"preg";s:38:"~^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d).{8,}~";}', '_sys_form_account_input_password_error', 'Xss', '', 1, 0),
(35, 'sys_forgot_password', 'system', 'email', '', '', 0, 'text', '_sys_form_forgot_password_input_caption_system_email', '_sys_form_forgot_password_input_email', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'EmailExistOrEmpty', '', '_sys_form_account_input_email_error', 'Xss', '', 0, 0),
(36, 'sys_forgot_password', 'system', 'phone', '', '', 0, 'text', '_sys_form_forgot_password_input_caption_system_phone', '_sys_form_forgot_password_input_phone', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'PhoneExistOrEmpty', '', '_sys_form_account_input_phone_error', 'Xss', '', 0, 0),
(37, 'sys_forgot_password', 'system', 'captcha', '', '', 0, 'captcha', '_sys_form_login_input_caption_system_captcha', '_sys_form_account_input_captcha', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'Captcha', '', '_sys_form_account_input_captcha_error', '', '', 1, 0),
(38, 'sys_forgot_password', 'system', 'do_submit', '_sys_form_forgot_password_input_submit', '', 0, 'submit', '_sys_form_forgot_password_input_caption_system_do_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(39, 'sys_confirm_email', 'system', 'code', '', '', 0, 'text', '_sys_form_confirm_email_input_caption_system_code', '_sys_form_confirm_email_input_code', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'CodeExist', '', '_sys_form_confirm_email_input_code_error', 'Xss', '', 0, 0),
(40, 'sys_confirm_email', 'system', 'do_submit', '_sys_form_confirm_email_input_submit', '', 0, 'submit', '_sys_form_confirm_email_input_caption_system_do_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(41, 'sys_confirm_phone', 'system', 'phone', '', '', 0, 'text', '_sys_form_confirm_phone_input_caption_system_phone', '_sys_form_confirm_phone_input_phone', '_sys_form_confirm_phone_input_phone_info', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'PhoneUniq', '', '_sys_form_confirm_phone_input_phone_error_format', 'Xss', '', 1, 0),
(42, 'sys_confirm_phone', 'system', 'code', '', '', 0, 'text', '_sys_form_confirm_phone_input_caption_system_code', '_sys_form_confirm_phone_confirmation_input_code', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'CodeExist', '', '_sys_form_confirm_phone_input_code_error_empty', 'Xss', '', 0, 0),
(43, 'sys_confirm_phone', 'system', 'do_submit', '_sys_form_confirm_phone_input_submit', '', 0, 'submit', '_sys_form_confirm_phone_input_caption_system_do_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(44, 'sys_confirm_phone', 'system', 'do_sendsms', '_sys_form_confirm_phone_input_sendsms', '', 0, 'submit', '_sys_form_confirm_phone_input_caption_system_do_sendsms', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(45, 'sys_unsubscribe', 'system', 'id', '', '', 0, 'hidden', '_sys_form_unsubscribe_input_caption_system_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(46, 'sys_unsubscribe', 'system', 'code', '', '', 0, 'hidden', '_sys_form_unsubscribe_input_caption_system_code', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(47, 'sys_unsubscribe', 'system', 'receive_updates', '1', '', 0, 'switcher', '_sys_form_unsubscribe_input_caption_system_receive_updates', '_sys_form_unsubscribe_input_receive_updates', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(48, 'sys_unsubscribe', 'system', 'receive_news', '1', '', 0, 'switcher', '_sys_form_unsubscribe_input_caption_system_receive_news', '_sys_form_unsubscribe_input_receive_news', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(49, 'sys_unsubscribe', 'system', 'do_submit', '_sys_form_unsubscribe_input_submit', '', 0, 'submit', '_sys_form_unsubscribe_input_caption_system_do_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(50, 'sys_comment', 'system', 'sys', '', '', 0, 'hidden', '_sys_form_comment_input_caption_system_sys', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(51, 'sys_comment', 'system', 'id', '', '', 0, 'hidden', '_sys_form_comment_input_caption_system_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(52, 'sys_comment', 'system', 'action', '', '', 0, 'hidden', '_sys_form_comment_input_caption_system_action', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(53, 'sys_comment', 'system', 'cmt_id', '', '', 0, 'hidden', '_sys_form_comment_input_caption_system_cmt_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(54, 'sys_comment', 'system', 'cmt_parent_id', '', '', 0, 'hidden', '_sys_form_comment_input_caption_system_cmt_parent_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(55, 'sys_comment', 'system', 'cmt_text', '', '', 0, 'textarea', '_sys_form_comment_input_caption_system_cmt_text', '', '', '', '', 0, 0, 0, 3, 0, '', 'a:1:{s:12:"autocomplete";s:3:"off";}', '', '', '', '', '', 'XssHtml', '', 1, 0),
(56, 'sys_comment', 'system', 'cmt_anonymous', '', '', 0, 'switcher', '_sys_form_input_sys_anonymous', '_sys_form_input_anonymous', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(57, 'sys_comment', 'system', 'cmt_image', 'a:1:{i:0;s:14:"sys_cmts_html5";}', 'a:1:{s:14:"sys_cmts_html5";s:25:"_sys_uploader_html5_title";}', 0, 'files', '_sys_form_comment_input_caption_system_cmt_image', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(58, 'sys_comment', 'system', 'cmt_cf', '', '#!sys_content_filter', 0, 'select', '_sys_form_entry_input_sys_cf', '_sys_form_entry_input_cf', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(59, 'sys_comment', 'system', 'cmt_controls', '', 'cmt_submit,cmt_cancel', 0, 'input_set', '', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(60, 'sys_comment', 'system', 'cmt_cancel', '_sys_form_comment_input_cancel', '', 0, 'button', '_sys_form_comment_input_caption_system_cmt_cancel', '', '', '', '', 0, 0, 0, 0, 0, '', 'a:1:{s:5:"class";s:22:"bx-def-margin-sec-left";}', '', '', '', '', '', '', '', 0, 0),
(61, 'sys_comment', 'system', 'cmt_submit', '_sys_form_comment_input_submit', '', 0, 'submit', '_sys_form_comment_input_caption_system_cmt_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(62, 'sys_agents_comment', 'system', 'sys', '', '', 0, 'hidden', '_sys_form_agents_comment_input_caption_system_sys', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(63, 'sys_agents_comment', 'system', 'id', '', '', 0, 'hidden', '_sys_form_agents_comment_input_caption_system_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(64, 'sys_agents_comment', 'system', 'action', '', '', 0, 'hidden', '_sys_form_agents_comment_input_caption_system_action', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(65, 'sys_agents_comment', 'system', 'cmt_parent_id', '', '', 0, 'hidden', '_sys_form_agents_comment_input_caption_system_cmt_parent_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(66, 'sys_agents_comment', 'system', 'cmt_text', '', '', 0, 'textarea', '_sys_form_agents_comment_input_caption_system_cmt_text', '', '', '', '', 0, 0, 0, 3, 0, '', 'a:1:{s:12:"autocomplete";s:3:"off";}', '', '', '', '', '', 'XssHtml', '', 1, 0),
(67, 'sys_agents_comment', 'system', 'cmt_image', 'a:1:{i:0;s:14:"sys_cmts_html5";}', 'a:1:{s:14:"sys_cmts_html5";s:25:"_sys_uploader_html5_title";}', 0, 'files', '_sys_form_agents_comment_input_caption_system_cmt_image', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(68, 'sys_agents_comment', 'system', 'cmt_submit', '_sys_form_agents_comment_input_caption_cmt_submit', '', 0, 'submit', '_sys_form_agents_comment_input_caption_system_cmt_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(69, 'sys_review', 'system', 'sys', '', '', 0, 'hidden', '_sys_form_review_input_caption_system_sys', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(70, 'sys_review', 'system', 'id', '', '', 0, 'hidden', '_sys_form_review_input_caption_system_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(71, 'sys_review', 'system', 'action', '', '', 0, 'hidden', '_sys_form_review_input_caption_system_action', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(72, 'sys_review', 'system', 'cmt_id', '', '', 0, 'hidden', '_sys_form_review_input_caption_system_cmt_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(73, 'sys_review', 'system', 'cmt_parent_id', '', '', 0, 'hidden', '_sys_form_review_input_caption_system_cmt_parent_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(74, 'sys_review', 'system', 'cmt_text', '', '', 0, 'textarea', '_sys_form_review_input_caption_system_cmt_text', '', '', '', '', 0, 0, 0, 3, 0, '', 'a:1:{s:12:"autocomplete";s:3:"off";}', '', '', 'Length', 'a:2:{s:3:"min";i:1;s:3:"max";i:5000;}', '_Please enter n1-n2 characters', 'XssHtml', '', 1, 0),
(75, 'sys_review', 'system', 'cmt_mood', '', '', 0, 'custom', '_sys_form_review_input_caption_system_cmt_mood', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 1, 0),
(76, 'sys_review', 'system', 'cmt_anonymous', '', '', 0, 'switcher', '_sys_form_input_sys_anonymous', '_sys_form_input_anonymous', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(77, 'sys_review', 'system', 'cmt_image', 'a:1:{i:0;s:14:"sys_cmts_html5";}', 'a:1:{s:14:"sys_cmts_html5";s:25:"_sys_uploader_html5_title";}', 0, 'files', '_sys_form_review_input_caption_system_cmt_image', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(78, 'sys_review', 'system', 'cmt_cf', '', '#!sys_content_filter', 0, 'select', '_sys_form_entry_input_sys_cf', '_sys_form_entry_input_cf', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(79, 'sys_review', 'system', 'cmt_submit', '_sys_form_review_input_submit', '', 0, 'submit', '_sys_form_review_input_caption_system_cmt_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(80, 'sys_report', 'system', 'sys', '', '', 0, 'hidden', '_sys_form_report_input_caption_system_sys', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(81, 'sys_report', 'system', 'object_id', '', '', 0, 'hidden', '_sys_form_report_input_caption_system_object_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(82, 'sys_report', 'system', 'action', '', '', 0, 'hidden', '_sys_form_report_input_caption_system_action', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(83, 'sys_report', 'system', 'id', '', '', 0, 'hidden', '_sys_form_report_input_caption_system_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(84, 'sys_report', 'system', 'type', '', '#!sys_report_types', 0, 'select', '_sys_form_report_input_caption_system_type', '_sys_form_report_input_caption_type', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'Avail', '', '_Please select value', 'Xss', '', 1, 0),
(85, 'sys_report', 'system', 'text', '', '', 0, 'textarea', '_sys_form_report_input_caption_system_text', '_sys_form_report_input_caption_text', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Xss', '', 1, 0),
(86, 'sys_report', 'system', 'submit', '_sys_form_report_input_caption_submit', '', 0, 'submit', '_sys_form_report_input_caption_system_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(87, 'sys_favorite', 'system', 'sys', '', '', 0, 'hidden', '_sys_form_favorite_input_caption_system_sys', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(88, 'sys_favorite', 'system', 'list_id', '', '', 0, 'hidden', '_sys_form_favorite_input_caption_system_list_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(89, 'sys_favorite', 'system', 'object_id', '', '', 0, 'hidden', '_sys_form_favorite_input_caption_system_object_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(90, 'sys_favorite', 'system', 'action', '', '', 0, 'hidden', '_sys_form_favorite_input_caption_system_action', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(91, 'sys_favorite', 'system', 'id', '', '', 0, 'hidden', '_sys_form_favorite_input_caption_system_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(92, 'sys_favorite', 'system', 'list', '', '#!sys_report_types', 0, 'checkbox_set', '_sys_form_favorite_input_caption_system_list', '_sys_form_favorite_input_caption_list', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'Avail', '', '_Please select value', 'Xss', '', 1, 0),
(93, 'sys_favorite', 'system', 'new_list', '_sys_form_favorite_input_caption_button_new_list', '', 0, 'button', '', '', '', '', '', 0, 0, 0, 0, 0, '', 'a:1:{s:7:"onclick";s:29:"{js_object}.showNewList(this)";}', '', '', '', '', '', 'Xss', '', 1, 0),
(94, 'sys_favorite', 'system', 'title', '', '', 0, 'text', '_sys_form_favorite_input_caption_system_title', '_sys_form_favorite_input_caption_title', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(95, 'sys_favorite', 'system', 'allow_view_favorite_list_to', '', '', 0, 'custom', '_sys_form_favorite_input_caption_system_allow_view_to', '_sys_form_favorite_input_caption_allow_view_to', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Xss', '', 1, 0),
(96, 'sys_favorite', 'system', 'submit', '_sys_form_favorite_input_caption_submit', '', 0, 'submit', '_sys_form_favorite_input_caption_system_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(97, 'sys_privacy_group_custom', 'system', 'profile_id', '', '', 0, 'hidden', '_sys_form_ps_gc_input_caption_system_profile_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(98, 'sys_privacy_group_custom', 'system', 'content_id', '', '', 0, 'hidden', '_sys_form_ps_gc_input_caption_system_content_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(99, 'sys_privacy_group_custom', 'system', 'object', '', '', 0, 'hidden', '_sys_form_ps_gc_input_caption_system_object', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Xss', '', 0, 0),
(100, 'sys_privacy_group_custom', 'system', 'action', '', '', 0, 'hidden', '_sys_form_ps_gc_input_caption_system_action', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(101, 'sys_privacy_group_custom', 'system', 'group_id', '', '', 0, 'hidden', '_sys_form_ps_gc_input_caption_system_group_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(102, 'sys_privacy_group_custom', 'system', 'search', '', '', 0, 'custom', '_sys_form_ps_gc_input_caption_system_search', '_sys_form_ps_gc_input_caption_search', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(103, 'sys_privacy_group_custom', 'system', 'list', '', '', 0, 'custom', '_sys_form_ps_gc_input_caption_system_list', '_sys_form_ps_gc_input_caption_list', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(104, 'sys_privacy_group_custom', 'system', 'memberships', '', '', 0, 'checkbox_set', '_sys_form_ps_gc_input_caption_system_memberships', '_sys_form_ps_gc_input_caption_memberships', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(105, 'sys_privacy_group_custom', 'system', 'controls', '', 'do_submit,do_cancel', 0, 'input_set', '', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(106, 'sys_privacy_group_custom', 'system', 'do_submit', '_sys_form_ps_gc_input_caption_do_submit', '', 0, 'submit', '_sys_form_ps_gc_input_caption_system_do_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(107, 'sys_privacy_group_custom', 'system', 'do_cancel', '_sys_form_ps_gc_input_caption_do_cancel', '', 0, 'button', '_sys_form_ps_gc_input_caption_system_do_cancel', '', '', '', '', 0, 0, 0, 0, 0, '', 'a:2:{s:7:"onclick";s:45:"$(''.bx-popup-applied:visible'').dolPopupHide()";s:5:"class";s:22:"bx-def-margin-sec-left";}', '', '', '', '', '', '', '', 0, 0),
(108, 'sys_labels', 'system', 'name', '', '', 0, 'hidden', '_sys_form_labels_input_caption_system_name', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(109, 'sys_labels', 'system', 'action', '', '', 0, 'hidden', '_sys_form_labels_input_caption_system_action', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(110, 'sys_labels', 'system', 'search', '', '', 0, 'custom', '_sys_form_labels_input_caption_system_search', '_sys_form_labels_input_caption_search', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(111, 'sys_labels', 'system', 'list', '', '', 0, 'custom', '_sys_form_labels_input_caption_system_list', '_sys_form_labels_input_caption_list', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(112, 'sys_labels', 'system', 'list_context', '', '', 0, 'custom', '_sys_form_labels_input_caption_system_list_context', '_sys_form_labels_input_caption_list_context', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(113, 'sys_labels', 'system', 'controls', '', 'do_submit,do_cancel', 0, 'input_set', '', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(114, 'sys_labels', 'system', 'do_submit', '_sys_form_labels_input_caption_do_submit', '', 0, 'submit', '_sys_form_labels_input_caption_system_do_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(115, 'sys_labels', 'system', 'do_cancel', '_sys_form_labels_input_caption_do_cancel', '', 0, 'button', '_sys_form_labels_input_caption_system_do_cancel', '', '', '', '', 0, 0, 0, 0, 0, '', 'a:2:{s:7:"onclick";s:45:"$(''.bx-popup-applied:visible'').dolPopupHide()";s:5:"class";s:22:"bx-def-margin-sec-left";}', '', '', '', '', '', '', '', 0, 0),
(116, 'sys_wiki', 'system', 'block_id', '', '', 0, 'hidden', '', '_sys_form_wiki_input_caption_block_id', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(117, 'sys_wiki', 'system', 'language', '', '', 0, 'radio_set', '', '_sys_form_wiki_input_caption_lang', '_sys_form_wiki_input_caption_lang_info', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Xss', '', 1, 0),
(118, 'sys_wiki', 'system', 'content_main', '', '', 0, 'custom', '', '_sys_form_wiki_input_caption_content_main', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(119, 'sys_wiki', 'system', 'content', '', '', 0, 'textarea', '', '_sys_form_wiki_input_caption_content', '_sys_form_wiki_input_caption_content_info', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Xss', '', 1, 0),
(120, 'sys_wiki', 'system', 'notes', '', '', 0, 'text', '', '_sys_form_wiki_input_caption_notes', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Xss', '', 1, 0),
(121, 'sys_wiki', 'system', 'files', 'a:1:{i:0;s:9:"sys_html5";}', 'a:1:{s:9:"sys_html5";s:25:"_sys_uploader_html5_title";}', 0, 'files', '', '_sys_form_wiki_input_caption_files', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(122, 'sys_wiki', 'system', 'do_submit', '_sys_submit', '', 0, 'submit', '_sys_form_wiki_input_caption_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(123, 'sys_wiki', 'system', 'close', '_sys_close', '', 0, 'reset', '_sys_form_wiki_input_caption_close', '', '', '', '', 0, 0, 0, 0, 0, '', 'a:2:{s:7:"onclick";s:46:"$(''.bx-popup-applied:visible'').dolPopupHide();";s:5:"class";s:22:"bx-def-margin-sec-left";}', '', '', '', '', '', '', '', 1, 0),
(124, 'sys_wiki', 'system', 'buttons', '', 'do_submit,close', 0, 'input_set', '_sys_form_wiki_buttons', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(125, 'sys_manage', 'system', 'content_id', '', '', 0, 'hidden', '', '_sys_form_manage_input_sys_content_id', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(126, 'sys_manage', 'system', 'notes', '', '', 0, 'textarea', '_sys_form_manage_input_sys_notes', '_sys_form_manage_input_notes', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Xss', '', 1, 0),
(127, 'sys_manage', 'system', 'controls', '', 'do_send,do_submit,do_cancel', 0, 'input_set', '', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(128, 'sys_manage', 'system', 'do_send', '_sys_form_manage_input_do_send', '', 0, 'submit', '_sys_form_manage_input_sys_do_send', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(129, 'sys_manage', 'system', 'do_submit', '_sys_form_manage_input_do_submit', '', 0, 'submit', '_sys_form_manage_input_sys_do_submit', '', '', '', '', 0, 0, 0, 0, 0, '', 'a:1:{s:5:"class";s:22:"bx-def-margin-sec-left";}', '', '', '', '', '', '', '', 0, 0),
(130, 'sys_manage', 'system', 'do_cancel', '_sys_form_manage_input_do_cancel', '', 0, 'button', '_sys_form_manage_input_sys_do_cancel', '', '', '', '', 0, 0, 0, 0, 0, '', 'a:2:{s:5:"class";s:22:"bx-def-margin-sec-left";s:7:"onclick";s:45:"$(''.bx-popup-applied:visible'').dolPopupHide()";}', '', '', '', '', '', '', '', 0, 0),
(131, 'sys_acl', 'system', 'profile_id', '', '', 0, 'hidden', '_sys_form_acl_input_sys_profile_id', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(132, 'sys_acl', 'system', 'card', '', '', 0, 'hidden', '_sys_form_acl_input_sys_card', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 0, 0),
(133, 'sys_acl', 'system', 'level_id', '', '', 0, 'radio_set', '_sys_form_acl_input_sys_level_id', '_sys_form_acl_input_level_id', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 1, 0),
(134, 'sys_acl', 'system', 'duration', '', '', 0, 'text', '_sys_form_acl_input_sys_duration', '_sys_form_acl_input_duration', '_sys_form_acl_input_duration_inf', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Int', '', 1, 0),
(135, 'sys_acl', 'system', 'controls', '', 'do_submit,do_cancel', 0, 'input_set', '', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(136, 'sys_acl', 'system', 'do_submit', '_sys_form_acl_input_do_submit', '', 0, 'submit', '_sys_form_acl_input_sys_do_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 0, 0),
(137, 'sys_acl', 'system', 'do_cancel', '_sys_form_acl_input_do_cancel', '', 0, 'button', '_sys_form_acl_input_sys_do_cancel', '', '', '', '', 0, 0, 0, 0, 0, '', 'a:2:{s:5:"class";s:22:"bx-def-margin-sec-left";s:7:"onclick";s:65:"$(this).parents(''.bx-popup-applied:visible:first'').dolPopupHide()";}', '', '', '', '', '', '', '', 0, 0),
(138, 'bx_person', 'bx_persons', 'allow_view_to', '3', '', 0, 'custom', '_bx_persons_form_profile_input_sys_allow_view_to', '_bx_persons_form_profile_input_allow_view_to', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(139, 'bx_person', 'bx_persons', 'allow_post_to', '5', '', 0, 'custom', '_bx_persons_form_profile_input_sys_allow_post_to', '_bx_persons_form_profile_input_allow_post_to', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(140, 'bx_person', 'bx_persons', 'allow_contact_to', '3', '', 0, 'custom', '_bx_persons_form_profile_input_sys_allow_contact_to', '_bx_persons_form_profile_input_allow_contact_to', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(141, 'bx_person', 'bx_persons', 'delete_confirm', '1', '', 0, 'checkbox', '_bx_persons_form_profile_input_sys_delete_confirm', '_bx_persons_form_profile_input_delete_confirm', '_bx_persons_form_profile_input_delete_confirm_info', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'Avail', '', '_bx_persons_form_profile_input_delete_confirm_error', '', '', 1, 0),
(142, 'bx_person', 'bx_persons', 'do_submit', '_bx_persons_form_profile_input_submit', '', 0, 'submit', '_bx_persons_form_profile_input_sys_do_submit', '', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(143, 'bx_person', 'bx_persons', 'description', '', '', 0, 'textarea', '_bx_persons_form_profile_input_sys_desc', '_bx_persons_form_profile_input_desc', '', '', '', 0, 0, 0, 1, 0, '', '', '', '', '', '', '', 'XssHtml', '', 1, 1),
(144, 'bx_person', 'bx_persons', 'fullname', '', '', 0, 'text', '_bx_persons_form_profile_input_sys_fullname', '_bx_persons_form_profile_input_fullname', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'ProfileName', '', '_bx_persons_form_profile_input_fullname_err', 'Xss', '', 1, 0),
(145, 'bx_person', 'bx_persons', 'last_name', '', '', 0, 'text', '_bx_persons_form_profile_input_sys_last_name', '_bx_persons_form_profile_input_last_name', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Xss', '', 1, 0),
(146, 'bx_person', 'bx_persons', 'cover', 'a:1:{i:0;s:21:"bx_persons_cover_crop";}', 'a:1:{s:21:"bx_persons_cover_crop";s:24:"_sys_uploader_crop_title";}', 0, 'files', '_bx_persons_form_profile_input_sys_cover', '_bx_persons_form_profile_input_cover', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(147, 'bx_person', 'bx_persons', 'picture', 'a:1:{i:0;s:23:"bx_persons_picture_crop";}', 'a:1:{s:23:"bx_persons_picture_crop";s:24:"_sys_uploader_crop_title";}', 0, 'files', '_bx_persons_form_profile_input_sys_picture', '_bx_persons_form_profile_input_picture', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '_bx_persons_form_profile_input_picture_err', '', '', 1, 0),
(148, 'bx_person', 'bx_persons', 'location', '', '', 0, 'location', '_sys_form_input_sys_location', '_sys_form_input_location', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(149, 'bx_person', 'bx_persons', 'birthday', '0', '', 0, 'datepicker', '_bx_persons_form_profile_input_sys_birthday', '_bx_persons_form_profile_input_birthday', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'date_range', 'a:3:{s:3:"min";i:18;s:3:"max";i:99;s:8:"required";b:0;}', '_bx_persons_form_profile_input_birthday_err', 'Date', '', 1, 0),
(150, 'bx_person', 'bx_persons', 'gender', '', '#!Sex', 0, 'select', '_bx_persons_form_profile_input_sys_gender', '_bx_persons_form_profile_input_gender', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Xss', '', 1, 0),
(151, 'bx_person', 'bx_persons', 'profile_email', '', '', 0, 'text', '_bx_persons_form_profile_input_sys_profile_email', '_bx_persons_form_profile_input_profile_email', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Xss', '', 0, 0),
(152, 'bx_person', 'bx_persons', 'profile_status', '', '', 0, 'text', '_bx_persons_form_profile_input_sys_profile_status', '_bx_persons_form_profile_input_profile_status', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Xss', '', 0, 0),
(153, 'bx_person', 'bx_persons', 'profile_ip', '', '', 0, 'text', '_bx_persons_form_profile_input_sys_profile_ip', '_bx_persons_form_profile_input_profile_ip', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Xss', '', 0, 0),
(154, 'bx_person', 'bx_persons', 'profile_last_active', '', '', 0, 'text', '_bx_persons_form_profile_input_sys_profile_last_active', '_bx_persons_form_profile_input_profile_last_active', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', 'Xss', '', 0, 0),
(155, 'bx_person', 'bx_persons', 'labels', '', '', 0, 'custom', '_sys_form_input_sys_labels', '_sys_form_input_labels', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(156, 'bx_person', 'bx_persons', 'skills', 'bx_person_skills', '', 0, 'nested_form', '_bx_persons_form_profile_input_sys_skills', '_bx_persons_form_profile_input_skills', '', '', '', 0, 0, 0, 0, 0, 'sys_form_fields_votes', '', '', '', '', '', '', '', '', 1, 0),
(157, 'bx_person', 'bx_persons', 'added', '', '', 0, 'datetime', '_bx_persons_form_profile_input_sys_date_added', '_bx_persons_form_profile_input_date_added', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(158, 'bx_person', 'bx_persons', 'changed', '', '', 0, 'datetime', '_bx_persons_form_profile_input_sys_date_changed', '_bx_persons_form_profile_input_date_changed', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(159, 'bx_person', 'bx_persons', 'friends_count', '', '', 0, 'text', '_bx_persons_form_profile_input_sys_friends_count', '_bx_persons_form_profile_input_friends_count', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(160, 'bx_person', 'bx_persons', 'followers_count', '', '', 0, 'text', '_bx_persons_form_profile_input_sys_followers_count', '_bx_persons_form_profile_input_followers_count', '', '', '', 0, 0, 0, 0, 0, '', '', '', '', '', '', '', '', '', 1, 0),
(161, 'bx_person_skills', 'bx_persons', 'skill_name', '', '', 0, 'text', '_bx_persons_skills_form_profile_input_sys_skill_name', '_bx_persons_skills_form_profile_input_skill_name', '', '', '', 1, 0, 0, 0, 0, '', '', '', '', 'Avail', '', '_bx_persons_skills_form_profile_input_skill_name_err', 'Xss', '', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `sys_form_inputs_privacy`
--

CREATE TABLE `sys_form_inputs_privacy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `input_id` int(11) unsigned NOT NULL DEFAULT '0',
  `author_id` int(11) unsigned NOT NULL DEFAULT '0',
  `allow_view_to` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '3',
  PRIMARY KEY (`id`),
  UNIQUE KEY `input` (`input_id`,`author_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_form_pre_lists`
--

CREATE TABLE `sys_form_pre_lists` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `use_for_sets` tinyint(4) unsigned NOT NULL DEFAULT '1',
  `extendable` tinyint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`(191)),
  FULLTEXT KEY `ModuleAndKey` (`module`,`key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=11 ;

--
-- Dumping data for table `sys_form_pre_lists`
--

INSERT INTO `sys_form_pre_lists` VALUES
(1, 'system', 'Country', '_adm_form_txt_pre_lists_country', 0, 1),
(2, 'system', 'Sex', '_adm_form_txt_pre_lists_sex', 1, 1),
(3, 'system', 'Language', '_adm_form_txt_pre_lists_language', 0, 1),
(4, 'system', 'Currency', '_adm_form_txt_pre_lists_currency', 0, 1),
(5, 'system', 'sys_report_types', '_sys_pre_lists_report_types', 0, 0),
(6, 'system', 'sys_vote_reactions', '_sys_pre_lists_vote_reactions', 0, 0),
(7, 'system', 'sys_relations', '_sys_pre_lists_relations', 0, 1),
(8, 'system', 'sys_content_filter', '_sys_pre_lists_content_filter', 1, 0),
(9, 'system', 'sys_studio_widget_types', '_sys_pre_lists_studio_widget_types', 0, 0),
(10, 'system', 'sys_colors', '_sys_pre_lists_colors', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `sys_form_pre_values`
--

CREATE TABLE `sys_form_pre_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Order` int(10) unsigned NOT NULL DEFAULT '0',
  `LKey` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `LKey2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `KeyAndValue` (`Key`,`Value`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=364 ;

--
-- Dumping data for table `sys_form_pre_values`
--

INSERT INTO `sys_form_pre_values` VALUES
(1, 'Country', 'AF', 1, '__Afghanistan', '', ''),
(2, 'Country', 'AX', 2, '__Aland_Islands', '', ''),
(3, 'Country', 'AL', 3, '__Albania', '', ''),
(4, 'Country', 'DZ', 4, '__Algeria', '', ''),
(5, 'Country', 'AS', 5, '__American Samoa', '', ''),
(6, 'Country', 'AD', 6, '__Andorra', '', ''),
(7, 'Country', 'AO', 7, '__Angola', '', ''),
(8, 'Country', 'AI', 8, '__Anguilla', '', ''),
(9, 'Country', 'AQ', 9, '__Antarctica', '', ''),
(10, 'Country', 'AG', 10, '__Antigua and Barbuda', '', ''),
(11, 'Country', 'AR', 11, '__Argentina', '', ''),
(12, 'Country', 'AM', 12, '__Armenia', '', ''),
(13, 'Country', 'AW', 13, '__Aruba', '', ''),
(14, 'Country', 'AU', 14, '__Australia', '', ''),
(15, 'Country', 'AT', 15, '__Austria', '', ''),
(16, 'Country', 'AZ', 16, '__Azerbaijan', '', ''),
(17, 'Country', 'BH', 17, '__Bahrain', '', ''),
(18, 'Country', 'BD', 18, '__Bangladesh', '', ''),
(19, 'Country', 'BB', 19, '__Barbados', '', ''),
(20, 'Country', 'BY', 20, '__Belarus', '', ''),
(21, 'Country', 'BE', 21, '__Belgium', '', ''),
(22, 'Country', 'BZ', 22, '__Belize', '', ''),
(23, 'Country', 'BJ', 23, '__Benin', '', ''),
(24, 'Country', 'BM', 24, '__Bermuda', '', ''),
(25, 'Country', 'BT', 25, '__Bhutan', '', ''),
(26, 'Country', 'BO', 26, '__Bolivia', '', ''),
(27, 'Country', 'BA', 27, '__Bosnia and Herzegovina', '', ''),
(28, 'Country', 'BW', 28, '__Botswana', '', ''),
(29, 'Country', 'BV', 29, '__Bouvet Island', '', ''),
(30, 'Country', 'BR', 30, '__Brazil', '', ''),
(31, 'Country', 'IO', 31, '__British Indian Ocean Territory', '', ''),
(32, 'Country', 'VG', 32, '__British Virgin Islands', '', ''),
(33, 'Country', 'BN', 33, '__Brunei Darussalam', '', ''),
(34, 'Country', 'BG', 34, '__Bulgaria', '', ''),
(35, 'Country', 'BF', 35, '__Burkina Faso', '', ''),
(36, 'Country', 'MM', 36, '__Burma', '', ''),
(37, 'Country', 'BI', 37, '__Burundi', '', ''),
(38, 'Country', 'KH', 38, '__Cambodia', '', ''),
(39, 'Country', 'CM', 39, '__Cameroon', '', ''),
(40, 'Country', 'CA', 40, '__Canada', '', ''),
(41, 'Country', 'CV', 41, '__Cape Verde', '', ''),
(42, 'Country', 'KY', 42, '__Cayman Islands', '', ''),
(43, 'Country', 'CF', 43, '__Central African Republic', '', ''),
(44, 'Country', 'TD', 44, '__Chad', '', ''),
(45, 'Country', 'CL', 45, '__Chile', '', ''),
(46, 'Country', 'CN', 46, '__China', '', ''),
(47, 'Country', 'CX', 47, '__Christmas Island', '', ''),
(48, 'Country', 'CC', 48, '__Cocos (Keeling) Islands', '', ''),
(49, 'Country', 'CO', 49, '__Colombia', '', ''),
(50, 'Country', 'KM', 50, '__Comoros', '', ''),
(51, 'Country', 'CD', 51, '__Congo, Democratic Republic of the', '', ''),
(52, 'Country', 'CG', 52, '__Congo, Republic of the', '', ''),
(53, 'Country', 'CK', 53, '__Cook Islands', '', ''),
(54, 'Country', 'CR', 54, '__Costa Rica', '', ''),
(55, 'Country', 'CI', 55, '__Cote d''Ivoire', '', ''),
(56, 'Country', 'HR', 56, '__Croatia', '', ''),
(57, 'Country', 'CU', 57, '__Cuba', '', ''),
(58, 'Country', 'CY', 58, '__Cyprus', '', ''),
(59, 'Country', 'CZ', 59, '__Czech Republic', '', ''),
(60, 'Country', 'DK', 60, '__Denmark', '', ''),
(61, 'Country', 'DJ', 61, '__Djibouti', '', ''),
(62, 'Country', 'DM', 62, '__Dominica', '', ''),
(63, 'Country', 'DO', 63, '__Dominican Republic', '', ''),
(64, 'Country', 'TL', 64, '__East Timor', '', ''),
(65, 'Country', 'EC', 65, '__Ecuador', '', ''),
(66, 'Country', 'EG', 66, '__Egypt', '', ''),
(67, 'Country', 'SV', 67, '__El Salvador', '', ''),
(68, 'Country', 'GQ', 68, '__Equatorial Guinea', '', ''),
(69, 'Country', 'ER', 69, '__Eritrea', '', ''),
(70, 'Country', 'EE', 70, '__Estonia', '', ''),
(71, 'Country', 'ET', 71, '__Ethiopia', '', ''),
(72, 'Country', 'FK', 72, '__Falkland Islands (Islas Malvinas)', '', ''),
(73, 'Country', 'FO', 73, '__Faroe Islands', '', ''),
(74, 'Country', 'FJ', 74, '__Fiji', '', ''),
(75, 'Country', 'FI', 75, '__Finland', '', ''),
(76, 'Country', 'FR', 76, '__France', '', ''),
(77, 'Country', 'GF', 77, '__French Guiana', '', ''),
(78, 'Country', 'PF', 78, '__French Polynesia', '', ''),
(79, 'Country', 'TF', 79, '__French Southern and Antarctic Lands', '', ''),
(80, 'Country', 'GA', 80, '__Gabon', '', ''),
(81, 'Country', 'GE', 81, '__Georgia', '', ''),
(82, 'Country', 'DE', 82, '__Germany', '', ''),
(83, 'Country', 'GH', 83, '__Ghana', '', ''),
(84, 'Country', 'GI', 84, '__Gibraltar', '', ''),
(85, 'Country', 'GR', 85, '__Greece', '', ''),
(86, 'Country', 'GL', 86, '__Greenland', '', ''),
(87, 'Country', 'GD', 87, '__Grenada', '', ''),
(88, 'Country', 'GP', 88, '__Guadeloupe', '', ''),
(89, 'Country', 'GU', 89, '__Guam', '', ''),
(90, 'Country', 'GT', 90, '__Guatemala', '', ''),
(91, 'Country', 'GG', 91, '__Guernsey', '', ''),
(92, 'Country', 'GN', 92, '__Guinea', '', ''),
(93, 'Country', 'GW', 93, '__Guinea-Bissau', '', ''),
(94, 'Country', 'GY', 94, '__Guyana', '', ''),
(95, 'Country', 'HT', 95, '__Haiti', '', ''),
(96, 'Country', 'HM', 96, '__Heard Island and McDonald Islands', '', ''),
(97, 'Country', 'VA', 97, '__Holy See (Vatican City)', '', ''),
(98, 'Country', 'HN', 98, '__Honduras', '', ''),
(99, 'Country', 'HK', 99, '__Hong Kong (SAR)', '', ''),
(100, 'Country', 'HU', 100, '__Hungary', '', ''),
(101, 'Country', 'IS', 101, '__Iceland', '', ''),
(102, 'Country', 'IN', 102, '__India', '', ''),
(103, 'Country', 'ID', 103, '__Indonesia', '', ''),
(104, 'Country', 'IR', 104, '__Iran', '', ''),
(105, 'Country', 'IQ', 105, '__Iraq', '', ''),
(106, 'Country', 'IE', 106, '__Ireland', '', ''),
(107, 'Country', 'IM', 107, '__Isle_of_Man', '', ''),
(108, 'Country', 'IL', 108, '__Israel', '', ''),
(109, 'Country', 'IT', 109, '__Italy', '', ''),
(110, 'Country', 'JM', 110, '__Jamaica', '', ''),
(111, 'Country', 'JP', 111, '__Japan', '', ''),
(112, 'Country', 'JE', 112, '__Jersey', '', ''),
(113, 'Country', 'JO', 113, '__Jordan', '', ''),
(114, 'Country', 'KZ', 114, '__Kazakhstan', '', ''),
(115, 'Country', 'KE', 115, '__Kenya', '', ''),
(116, 'Country', 'KI', 116, '__Kiribati', '', ''),
(117, 'Country', 'KP', 117, '__Korea, North', '', ''),
(118, 'Country', 'KR', 118, '__Korea, South', '', ''),
(119, 'Country', 'KW', 119, '__Kuwait', '', ''),
(120, 'Country', 'KG', 120, '__Kyrgyzstan', '', ''),
(121, 'Country', 'LA', 121, '__Laos', '', ''),
(122, 'Country', 'LV', 122, '__Latvia', '', ''),
(123, 'Country', 'LB', 123, '__Lebanon', '', ''),
(124, 'Country', 'LS', 124, '__Lesotho', '', ''),
(125, 'Country', 'LR', 125, '__Liberia', '', ''),
(126, 'Country', 'LY', 126, '__Libya', '', ''),
(127, 'Country', 'LI', 127, '__Liechtenstein', '', ''),
(128, 'Country', 'LT', 128, '__Lithuania', '', ''),
(129, 'Country', 'LU', 129, '__Luxembourg', '', ''),
(130, 'Country', 'MO', 130, '__Macao', '', ''),
(131, 'Country', 'MK', 131, '__Macedonia, The Former Yugoslav Republic of', '', ''),
(132, 'Country', 'MG', 132, '__Madagascar', '', ''),
(133, 'Country', 'MW', 133, '__Malawi', '', ''),
(134, 'Country', 'MY', 134, '__Malaysia', '', ''),
(135, 'Country', 'MV', 135, '__Maldives', '', ''),
(136, 'Country', 'ML', 136, '__Mali', '', ''),
(137, 'Country', 'MT', 137, '__Malta', '', ''),
(138, 'Country', 'MH', 138, '__Marshall Islands', '', ''),
(139, 'Country', 'MQ', 139, '__Martinique', '', ''),
(140, 'Country', 'MR', 140, '__Mauritania', '', ''),
(141, 'Country', 'MU', 141, '__Mauritius', '', ''),
(142, 'Country', 'YT', 142, '__Mayotte', '', ''),
(143, 'Country', 'MX', 143, '__Mexico', '', ''),
(144, 'Country', 'FM', 144, '__Micronesia, Federated States of', '', ''),
(145, 'Country', 'MD', 145, '__Moldova', '', ''),
(146, 'Country', 'MC', 146, '__Monaco', '', ''),
(147, 'Country', 'MN', 147, '__Mongolia', '', ''),
(148, 'Country', 'ME', 148, '__Montenegro', '', ''),
(149, 'Country', 'MS', 149, '__Montserrat', '', ''),
(150, 'Country', 'MA', 150, '__Morocco', '', ''),
(151, 'Country', 'MZ', 151, '__Mozambique', '', ''),
(152, 'Country', 'NA', 152, '__Namibia', '', ''),
(153, 'Country', 'NR', 153, '__Nauru', '', ''),
(154, 'Country', 'NP', 154, '__Nepal', '', ''),
(155, 'Country', 'NL', 155, '__Netherlands', '', ''),
(156, 'Country', 'AN', 156, '__Netherlands Antilles', '', ''),
(157, 'Country', 'NC', 157, '__New Caledonia', '', ''),
(158, 'Country', 'NZ', 158, '__New Zealand', '', ''),
(159, 'Country', 'NI', 159, '__Nicaragua', '', ''),
(160, 'Country', 'NE', 160, '__Niger', '', ''),
(161, 'Country', 'NG', 161, '__Nigeria', '', ''),
(162, 'Country', 'NU', 162, '__Niue', '', ''),
(163, 'Country', 'NF', 163, '__Norfolk Island', '', ''),
(164, 'Country', 'MP', 164, '__Northern Mariana Islands', '', ''),
(165, 'Country', 'NO', 165, '__Norway', '', ''),
(166, 'Country', 'OM', 166, '__Oman', '', ''),
(167, 'Country', 'PK', 167, '__Pakistan', '', ''),
(168, 'Country', 'PW', 168, '__Palau', '', ''),
(169, 'Country', 'PS', 169, '__Palestinian Territory, Occupied', '', ''),
(170, 'Country', 'PA', 170, '__Panama', '', ''),
(171, 'Country', 'PG', 171, '__Papua New Guinea', '', ''),
(172, 'Country', 'PY', 172, '__Paraguay', '', ''),
(173, 'Country', 'PE', 173, '__Peru', '', ''),
(174, 'Country', 'PH', 174, '__Philippines', '', ''),
(175, 'Country', 'PN', 175, '__Pitcairn Islands', '', ''),
(176, 'Country', 'PL', 176, '__Poland', '', ''),
(177, 'Country', 'PT', 177, '__Portugal', '', ''),
(178, 'Country', 'PR', 178, '__Puerto Rico', '', ''),
(179, 'Country', 'QA', 179, '__Qatar', '', ''),
(180, 'Country', 'RE', 180, '__Reunion', '', ''),
(181, 'Country', 'RO', 181, '__Romania', '', ''),
(182, 'Country', 'RU', 182, '__Russia', '', ''),
(183, 'Country', 'RW', 183, '__Rwanda', '', ''),
(184, 'Country', 'SH', 184, '__Saint Helena', '', ''),
(185, 'Country', 'KN', 185, '__Saint Kitts and Nevis', '', ''),
(186, 'Country', 'LC', 186, '__Saint Lucia', '', ''),
(187, 'Country', 'PM', 187, '__Saint Pierre and Miquelon', '', ''),
(188, 'Country', 'VC', 188, '__Saint Vincent and the Grenadines', '', ''),
(189, 'Country', 'BL', 189, '__Saint_Barthelemy', '', ''),
(190, 'Country', 'MF', 190, '__Saint_Martin_French_part', '', ''),
(191, 'Country', 'WS', 191, '__Samoa', '', ''),
(192, 'Country', 'SM', 192, '__San Marino', '', ''),
(193, 'Country', 'ST', 193, '__Sao Tome and Principe', '', ''),
(194, 'Country', 'SA', 194, '__Saudi Arabia', '', ''),
(195, 'Country', 'SN', 195, '__Senegal', '', ''),
(196, 'Country', 'RS', 196, '__Serbia', '', ''),
(197, 'Country', 'SC', 197, '__Seychelles', '', ''),
(198, 'Country', 'SL', 198, '__Sierra Leone', '', ''),
(199, 'Country', 'SG', 199, '__Singapore', '', ''),
(200, 'Country', 'SK', 200, '__Slovakia', '', ''),
(201, 'Country', 'SI', 201, '__Slovenia', '', ''),
(202, 'Country', 'SB', 202, '__Solomon Islands', '', ''),
(203, 'Country', 'SO', 203, '__Somalia', '', ''),
(204, 'Country', 'ZA', 204, '__South Africa', '', ''),
(205, 'Country', 'GS', 205, '__South Georgia and the South Sandwich Islands', '', ''),
(206, 'Country', 'ES', 206, '__Spain', '', ''),
(207, 'Country', 'LK', 207, '__Sri Lanka', '', ''),
(208, 'Country', 'SD', 208, '__Sudan', '', ''),
(209, 'Country', 'SR', 209, '__Suriname', '', ''),
(210, 'Country', 'SJ', 210, '__Svalbard', '', ''),
(211, 'Country', 'SZ', 211, '__Swaziland', '', ''),
(212, 'Country', 'SE', 212, '__Sweden', '', ''),
(213, 'Country', 'CH', 213, '__Switzerland', '', ''),
(214, 'Country', 'SY', 214, '__Syria', '', ''),
(215, 'Country', 'TW', 215, '__Taiwan', '', ''),
(216, 'Country', 'TJ', 216, '__Tajikistan', '', ''),
(217, 'Country', 'TZ', 217, '__Tanzania', '', ''),
(218, 'Country', 'TH', 218, '__Thailand', '', ''),
(219, 'Country', 'BS', 219, '__The Bahamas', '', ''),
(220, 'Country', 'GM', 220, '__The Gambia', '', ''),
(221, 'Country', 'TG', 221, '__Togo', '', ''),
(222, 'Country', 'TK', 222, '__Tokelau', '', ''),
(223, 'Country', 'TO', 223, '__Tonga', '', ''),
(224, 'Country', 'TT', 224, '__Trinidad and Tobago', '', ''),
(225, 'Country', 'TN', 225, '__Tunisia', '', ''),
(226, 'Country', 'TR', 226, '__Turkey', '', ''),
(227, 'Country', 'TM', 227, '__Turkmenistan', '', ''),
(228, 'Country', 'TC', 228, '__Turks and Caicos Islands', '', ''),
(229, 'Country', 'TV', 229, '__Tuvalu', '', ''),
(230, 'Country', 'UG', 230, '__Uganda', '', ''),
(231, 'Country', 'UA', 231, '__Ukraine', '', ''),
(232, 'Country', 'AE', 232, '__United Arab Emirates', '', ''),
(233, 'Country', 'GB', 233, '__United Kingdom', '', ''),
(234, 'Country', 'US', 234, '__United States', '', ''),
(235, 'Country', 'UM', 235, '__United States Minor Outlying Islands', '', ''),
(236, 'Country', 'UY', 236, '__Uruguay', '', ''),
(237, 'Country', 'UZ', 237, '__Uzbekistan', '', ''),
(238, 'Country', 'VU', 238, '__Vanuatu', '', ''),
(239, 'Country', 'VE', 239, '__Venezuela', '', ''),
(240, 'Country', 'VN', 240, '__Vietnam', '', ''),
(241, 'Country', 'VI', 241, '__Virgin Islands', '', ''),
(242, 'Country', 'WF', 242, '__Wallis and Futuna', '', ''),
(243, 'Country', 'EH', 243, '__Western Sahara', '', ''),
(244, 'Country', 'YE', 244, '__Yemen', '', ''),
(245, 'Country', 'ZM', 245, '__Zambia', '', ''),
(246, 'Country', 'ZW', 246, '__Zimbabwe', '', ''),
(247, 'Sex', '', 1, '_sys_not_specified', '', ''),
(248, 'Sex', '1', 2, '_Male', '_LookinMale', ''),
(249, 'Sex', '2', 3, '_Female', '_LookinFemale', ''),
(250, 'Language', '1', 1, '__English', '', ''),
(251, 'Language', '2', 2, '__Afrikaans', '', ''),
(252, 'Language', '3', 3, '__Arabic', '', ''),
(253, 'Language', '4', 4, '__Bulgarian', '', ''),
(254, 'Language', '5', 5, '__Burmese', '', ''),
(255, 'Language', '6', 6, '__Cantonese', '', ''),
(256, 'Language', '7', 7, '__Croatian', '', ''),
(257, 'Language', '8', 8, '__Danish', '', ''),
(258, 'Language', '9', 9, '__Dutch', '', ''),
(259, 'Language', '10', 10, '__Esperanto', '', ''),
(260, 'Language', '11', 11, '__Estonian', '', ''),
(261, 'Language', '12', 12, '__Finnish', '', ''),
(262, 'Language', '13', 13, '__French', '', ''),
(263, 'Language', '14', 14, '__German', '', ''),
(264, 'Language', '15', 15, '__Greek', '', ''),
(265, 'Language', '16', 16, '__Gujrati', '', ''),
(266, 'Language', '17', 17, '__Hebrew', '', ''),
(267, 'Language', '18', 18, '__Hindi', '', ''),
(268, 'Language', '19', 19, '__Hungarian', '', ''),
(269, 'Language', '20', 20, '__Icelandic', '', ''),
(270, 'Language', '21', 21, '__Indian', '', ''),
(271, 'Language', '22', 22, '__Indonesian', '', ''),
(272, 'Language', '23', 23, '__Italian', '', ''),
(273, 'Language', '24', 24, '__Japanese', '', ''),
(274, 'Language', '25', 25, '__Korean', '', ''),
(275, 'Language', '26', 26, '__Latvian', '', ''),
(276, 'Language', '27', 27, '__Lithuanian', '', ''),
(277, 'Language', '28', 28, '__Malay', '', ''),
(278, 'Language', '29', 29, '__Mandarin', '', ''),
(279, 'Language', '30', 30, '__Marathi', '', ''),
(280, 'Language', '31', 31, '__Moldovian', '', ''),
(281, 'Language', '32', 32, '__Nepalese', '', ''),
(282, 'Language', '33', 33, '__Norwegian', '', ''),
(283, 'Language', '34', 34, '__Persian', '', ''),
(284, 'Language', '35', 35, '__Polish', '', ''),
(285, 'Language', '36', 36, '__Portuguese', '', ''),
(286, 'Language', '37', 37, '__Punjabi', '', ''),
(287, 'Language', '38', 38, '__Romanian', '', ''),
(288, 'Language', '39', 39, '__Russian', '', ''),
(289, 'Language', '40', 40, '__Serbian', '', ''),
(290, 'Language', '41', 41, '__Spanish', '', ''),
(291, 'Language', '42', 42, '__Swedish', '', ''),
(292, 'Language', '43', 43, '__Tagalog', '', ''),
(293, 'Language', '44', 44, '__Taiwanese', '', ''),
(294, 'Language', '45', 45, '__Tamil', '', ''),
(295, 'Language', '46', 46, '__Telugu', '', ''),
(296, 'Language', '47', 47, '__Thai', '', ''),
(297, 'Language', '48', 48, '__Tongan', '', ''),
(298, 'Language', '49', 49, '__Turkish', '', ''),
(299, 'Language', '50', 50, '__Ukrainian', '', ''),
(300, 'Language', '51', 51, '__Urdu', '', ''),
(301, 'Language', '52', 52, '__Vietnamese', '', ''),
(302, 'Language', '53', 53, '__Visayan', '', ''),
(303, 'Currency', 'AUD', 1, '__AUD', '', 'a:1:{s:4:"sign";s:6:"A&#36;";}'),
(304, 'Currency', 'CAD', 2, '__CAD', '', 'a:1:{s:4:"sign";s:6:"C&#36;";}'),
(305, 'Currency', 'EUR', 3, '__EUR', '', 'a:1:{s:4:"sign";s:7:"&#8364;";}'),
(306, 'Currency', 'GBP', 4, '__GBP', '', 'a:1:{s:4:"sign";s:6:"&#163;";}'),
(307, 'Currency', 'USD', 5, '__USD', '', 'a:1:{s:4:"sign";s:5:"&#36;";}'),
(308, 'Currency', 'YEN', 6, '__YEN', '', 'a:1:{s:4:"sign";s:6:"&#165;";}'),
(309, 'sys_report_types', 'spam', 1, '_sys_pre_lists_report_types_spam', '', ''),
(310, 'sys_report_types', 'scam', 2, '_sys_pre_lists_report_types_scam', '', ''),
(311, 'sys_report_types', 'fraud', 3, '_sys_pre_lists_report_types_fraud', '', ''),
(312, 'sys_report_types', 'nude', 4, '_sys_pre_lists_report_types_nude', '', ''),
(313, 'sys_report_types', 'other', 5, '_sys_pre_lists_report_types_other', '', ''),
(314, 'sys_vote_reactions', 'like', 1, '_sys_pre_lists_vote_reactions_like', '', 'a:7:{s:3:"use";s:5:"emoji";s:5:"emoji";s:4:"?";s:4:"icon";s:12:"fa-thumbs-up";s:5:"image";s:904:"<svg aria-hidden="true" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M6.633 10.5c.806 0 1.533-.446 2.031-1.08a9.041 9.041 0 012.861-2.4c.723-.384 1.35-.956 1.653-1.715a4.498 4.498 0 00.322-1.672V3a.75.75 0 01.75-.75A2.25 2.25 0 0116.5 4.5c0 1.152-.26 2.243-.723 3.218-.266.558.107 1.282.725 1.282h3.126c1.026 0 1.945.694 2.054 1.715.045.422.068.85.068 1.285a11.95 11.95 0 01-2.649 7.521c-.388.482-.987.729-1.605.729H13.48c-.483 0-.964-.078-1.423-.23l-3.114-1.04a4.501 4.501 0 00-1.423-.23H5.904M14.25 9h2.25M5.904 18.75c.083.205.173.405.27.602.197.4-.078.898-.523.898h-.908c-.889 0-1.713-.518-1.972-1.368a12 12 0 01-.521-3.507c0-1.553.295-3.036.831-4.398C3.387 10.203 4.167 9.75 5 9.75h1.053c.472 0 .745.556.5.96a8.958 8.958 0 00-1.302 4.665c0 1.194.232 2.333.654 3.375z" stroke-linecap="round" stroke-linejoin="round"></path></svg>";s:5:"color";s:20:"sys-colored col-gray";s:6:"weight";s:1:"1";s:7:"default";a:2:{s:5:"title";s:37:"_sys_pre_lists_vote_reactions_default";s:4:"icon";s:8:"fa-smile";}}'),
(315, 'sys_vote_reactions', 'love', 2, '_sys_pre_lists_vote_reactions_love', '', 'a:6:{s:3:"use";s:5:"emoji";s:5:"emoji";s:4:"?";s:4:"icon";s:8:"fa-heart";s:5:"image";s:499:"<svg aria-hidden="true" fill="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M11.645 20.91l-.007-.003-.022-.012a15.247 15.247 0 01-.383-.218 25.18 25.18 0 01-4.244-3.17C4.688 15.36 2.25 12.174 2.25 8.25 2.25 5.322 4.714 3 7.688 3A5.5 5.5 0 0112 5.052 5.5 5.5 0 0116.313 3c2.973 0 5.437 2.322 5.437 5.25 0 3.925-2.438 7.111-4.739 9.256a25.175 25.175 0 01-4.244 3.17 15.247 15.247 0 01-.383.219l-.022.012-.007.004-.003.001a.752.752 0 01-.704 0l-.003-.001z"></path></svg>";s:5:"color";s:20:"sys-colored col-red1";s:6:"weight";s:1:"1";}'),
(316, 'sys_vote_reactions', 'joy', 3, '_sys_pre_lists_vote_reactions_joy', '', 'a:6:{s:3:"use";s:5:"emoji";s:5:"emoji";s:4:"?";s:4:"icon";s:15:"fa-laugh-squint";s:5:"image";s:789:"<svg aria-hidden="true" fill="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path clip-rule="evenodd" d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25zm-2.625 6c-.54 0-.828.419-.936.634a1.96 1.96 0 00-.189.866c0 .298.059.605.189.866.108.215.395.634.936.634.54 0 .828-.419.936-.634.13-.26.189-.568.189-.866 0-.298-.059-.605-.189-.866-.108-.215-.395-.634-.936-.634zm4.314.634c.108-.215.395-.634.936-.634.54 0 .828.419.936.634.13.26.189.568.189.866 0 .298-.059.605-.189.866-.108.215-.395.634-.936.634-.54 0-.828-.419-.936-.634a1.96 1.96 0 01-.189-.866c0-.298.059-.605.189-.866zm2.023 6.828a.75.75 0 10-1.06-1.06 3.75 3.75 0 01-5.304 0 .75.75 0 00-1.06 1.06 5.25 5.25 0 007.424 0z" fill-rule="evenodd"></path></svg>";s:5:"color";s:20:"sys-colored col-red3";s:6:"weight";s:1:"1";}'),
(317, 'sys_vote_reactions', 'surprise', 4, '_sys_pre_lists_vote_reactions_surprise', '', 'a:6:{s:3:"use";s:5:"emoji";s:5:"emoji";s:4:"?";s:4:"icon";s:11:"fa-surprise";s:5:"image";s:551:"<svg aria-hidden="true" fill="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M9.375 3a1.875 1.875 0 000 3.75h1.875v4.5H3.375A1.875 1.875 0 011.5 9.375v-.75c0-1.036.84-1.875 1.875-1.875h3.193A3.375 3.375 0 0112 2.753a3.375 3.375 0 015.432 3.997h3.943c1.035 0 1.875.84 1.875 1.875v.75c0 1.036-.84 1.875-1.875 1.875H12.75v-4.5h1.875a1.875 1.875 0 10-1.875-1.875V6.75h-1.5V4.875C11.25 3.839 10.41 3 9.375 3zM11.25 12.75H3v6.75a2.25 2.25 0 002.25 2.25h6v-9zM12.75 12.75v9h6.75a2.25 2.25 0 002.25-2.25v-6.75h-9z"></path></svg>";s:5:"color";s:20:"sys-colored col-red3";s:6:"weight";s:1:"1";}'),
(318, 'sys_vote_reactions', 'sadness', 5, '_sys_pre_lists_vote_reactions_sadness', '', 'a:6:{s:3:"use";s:5:"emoji";s:5:"emoji";s:4:"?";s:4:"icon";s:11:"fa-sad-tear";s:5:"image";s:736:"<svg aria-hidden="true" fill="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path clip-rule="evenodd" d="M16.5 4.478v.227a48.816 48.816 0 013.878.512.75.75 0 11-.256 1.478l-.209-.035-1.005 13.07a3 3 0 01-2.991 2.77H8.084a3 3 0 01-2.991-2.77L4.087 6.66l-.209.035a.75.75 0 01-.256-1.478A48.567 48.567 0 017.5 4.705v-.227c0-1.564 1.213-2.9 2.816-2.951a52.662 52.662 0 013.369 0c1.603.051 2.815 1.387 2.815 2.951zm-6.136-1.452a51.196 51.196 0 013.273 0C14.39 3.05 15 3.684 15 4.478v.113a49.488 49.488 0 00-6 0v-.113c0-.794.609-1.428 1.364-1.452zm-.355 5.945a.75.75 0 10-1.5.058l.347 9a.75.75 0 101.499-.058l-.346-9zm5.48.058a.75.75 0 10-1.498-.058l-.347 9a.75.75 0 001.5.058l.345-9z" fill-rule="evenodd"></path></svg>";s:5:"color";s:20:"sys-colored col-red3";s:6:"weight";s:1:"1";}'),
(319, 'sys_vote_reactions', 'anger', 6, '_sys_pre_lists_vote_reactions_anger', '', 'a:6:{s:3:"use";s:5:"emoji";s:5:"emoji";s:4:"?";s:4:"icon";s:8:"fa-angry";s:5:"image";s:858:"<svg aria-hidden="true" fill="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path clip-rule="evenodd" d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25zm-2.625 6c-.54 0-.828.419-.936.634a1.96 1.96 0 00-.189.866c0 .298.059.605.189.866.108.215.395.634.936.634.54 0 .828-.419.936-.634.13-.26.189-.568.189-.866 0-.298-.059-.605-.189-.866-.108-.215-.395-.634-.936-.634zm4.314.634c.108-.215.395-.634.936-.634.54 0 .828.419.936.634.13.26.189.568.189.866 0 .298-.059.605-.189.866-.108.215-.395.634-.936.634-.54 0-.828-.419-.936-.634a1.96 1.96 0 01-.189-.866c0-.298.059-.605.189-.866zm-4.34 7.964a.75.75 0 01-1.061-1.06 5.236 5.236 0 013.73-1.538 5.236 5.236 0 013.695 1.538.75.75 0 11-1.061 1.06 3.736 3.736 0 00-2.639-1.098 3.736 3.736 0 00-2.664 1.098z" fill-rule="evenodd"></path></svg>";s:5:"color";s:20:"sys-colored col-red3";s:6:"weight";s:1:"1";}'),
(320, 'sys_relations', '1', 1, '_sys_pre_lists_relations_husband', '', 'a:1:{i:0;s:1:"2";}'),
(321, 'sys_relations', '2', 2, '_sys_pre_lists_relations_wife', '', 'a:1:{i:0;s:1:"1";}'),
(322, 'sys_relations', '3', 3, '_sys_pre_lists_relations_father', '', 'a:2:{i:0;s:1:"5";i:1;s:1:"6";}'),
(323, 'sys_relations', '4', 4, '_sys_pre_lists_relations_mother', '', 'a:2:{i:0;s:1:"5";i:1;s:1:"6";}'),
(324, 'sys_relations', '5', 5, '_sys_pre_lists_relations_son', '', 'a:2:{i:0;s:1:"3";i:1;s:1:"4";}'),
(325, 'sys_relations', '6', 6, '_sys_pre_lists_relations_daughter', '', 'a:2:{i:0;s:1:"3";i:1;s:1:"4";}'),
(326, 'sys_relations', '7', 7, '_sys_pre_lists_relations_brother', '', 'a:2:{i:0;s:1:"7";i:1;s:1:"8";}'),
(327, 'sys_relations', '8', 8, '_sys_pre_lists_relations_sister', '', 'a:2:{i:0;s:1:"7";i:1;s:1:"8";}'),
(328, 'sys_content_filter', '1', 1, '_sys_pre_lists_content_filter_g', '', ''),
(329, 'sys_content_filter', '2', 2, '_sys_pre_lists_content_filter_pg', '', ''),
(330, 'sys_content_filter', '3', 3, '_sys_pre_lists_content_filter_pg13', '', ''),
(331, 'sys_content_filter', '4', 4, '_sys_pre_lists_content_filter_r', '', ''),
(332, 'sys_content_filter', '5', 5, '_sys_pre_lists_content_filter_x', '', ''),
(333, 'sys_studio_widget_types', '', 1, '_sys_pre_lists_studio_widget_types_library', '', 'a:1:{s:4:"icon";s:15:"lmi-library.svg";}'),
(334, 'sys_studio_widget_types', 'appearance', 2, '_sys_pre_lists_studio_widget_types_appearance', '', 'a:1:{s:4:"icon";s:18:"lmi-appearance.svg";}'),
(335, 'sys_studio_widget_types', 'structure', 3, '_sys_pre_lists_studio_widget_types_structure', '', 'a:1:{s:4:"icon";s:17:"lmi-structure.svg";}'),
(336, 'sys_studio_widget_types', 'content', 4, '_sys_pre_lists_studio_widget_types_content', '', 'a:1:{s:4:"icon";s:15:"lmi-content.svg";}'),
(337, 'sys_studio_widget_types', 'users', 5, '_sys_pre_lists_studio_widget_types_users', '', 'a:1:{s:4:"icon";s:13:"lmi-users.svg";}'),
(338, 'sys_studio_widget_types', 'configuration', 6, '_sys_pre_lists_studio_widget_types_configuration', '', 'a:1:{s:4:"icon";s:21:"lmi-configuration.svg";}'),
(339, 'sys_studio_widget_types', 'extensions', 7, '_sys_pre_lists_studio_widget_types_extensions', '', 'a:1:{s:4:"icon";s:18:"lmi-extensions.svg";}'),
(340, 'sys_studio_widget_types', 'integrations', 8, '_sys_pre_lists_studio_widget_types_integrations', '', 'a:1:{s:4:"icon";s:20:"lmi-integrations.svg";}'),
(341, 'sys_studio_widget_types', 'favorites', 9, '_sys_pre_lists_studio_widget_types_favorites', '', 'a:1:{s:4:"icon";s:17:"lmi-favorites.svg";}'),
(342, 'sys_colors', 'slate-600', 2, '_sys_pre_lists_color_slate', '', ''),
(343, 'sys_colors', 'gray-600', 3, '_sys_pre_lists_color_gray', '', ''),
(344, 'sys_colors', 'zinc-600', 4, '_sys_pre_lists_color_zinc', '', ''),
(345, 'sys_colors', 'neutral-600', 5, '_sys_pre_lists_color_neutral', '', ''),
(346, 'sys_colors', 'stone-600', 6, '_sys_pre_lists_color_stone', '', ''),
(347, 'sys_colors', 'red-600', 7, '_sys_pre_lists_color_red', '', ''),
(348, 'sys_colors', 'orange-600', 8, '_sys_pre_lists_color_orange', '', ''),
(349, 'sys_colors', 'amber-600', 9, '_sys_pre_lists_color_amber', '', ''),
(350, 'sys_colors', 'yellow-600', 10, '_sys_pre_lists_color_yellow', '', ''),
(351, 'sys_colors', 'lime-600', 11, '_sys_pre_lists_color_lime', '', ''),
(352, 'sys_colors', 'green-600', 12, '_sys_pre_lists_color_green', '', ''),
(353, 'sys_colors', 'emerald-600', 13, '_sys_pre_lists_color_emerald', '', ''),
(354, 'sys_colors', 'teal-600', 14, '_sys_pre_lists_color_teal', '', ''),
(355, 'sys_colors', 'cyan-600', 15, '_sys_pre_lists_color_cyan', '', ''),
(356, 'sys_colors', 'sky-600', 16, '_sys_pre_lists_color_sky', '', ''),
(357, 'sys_colors', 'blue-600', 17, '_sys_pre_lists_color_blue', '', ''),
(358, 'sys_colors', 'indigo-600', 18, '_sys_pre_lists_color_indigo', '', ''),
(359, 'sys_colors', 'violet-600', 19, '_sys_pre_lists_color_violet', '', ''),
(360, 'sys_colors', 'purple-600', 20, '_sys_pre_lists_color_purple', '', ''),
(361, 'sys_colors', 'fuchsia-600', 21, '_sys_pre_lists_color_fuchsia', '', ''),
(362, 'sys_colors', 'pink-600', 22, '_sys_pre_lists_color_pink', '', ''),
(363, 'sys_colors', 'rose-600', 23, '_sys_pre_lists_color_rose', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_grid_actions`
--

CREATE TABLE `sys_grid_actions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('bulk','single','independent') COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon_only` tinyint(4) NOT NULL DEFAULT '0',
  `confirm` tinyint(4) NOT NULL DEFAULT '1',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `order` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object_name_type` (`object`,`type`,`name`(123))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=132 ;

--
-- Dumping data for table `sys_grid_actions`
--

INSERT INTO `sys_grid_actions` VALUES
(1, 'sys_studio_lang_keys', 'bulk', 'delete', '_adm_pgt_btn_delete', '', 0, 1, 1, 1),
(2, 'sys_studio_lang_keys', 'single', 'edit', '', 'pencil-alt', 0, 0, 1, 1),
(3, 'sys_studio_lang_keys', 'single', 'delete', '', 'remove', 0, 1, 1, 2),
(4, 'sys_studio_lang_keys', 'independent', 'add', '_adm_pgt_btn_add_new_key', '', 0, 0, 1, 1),
(5, 'sys_studio_lang_etemplates', 'single', 'edit', '', 'pencil-alt', 0, 0, 1, 1),
(6, 'sys_studio_acl', 'independent', 'add', '_adm_prm_btn_add_level', '', 0, 0, 1, 1),
(7, 'sys_studio_acl', 'single', 'edit', '', 'pencil-alt', 0, 0, 1, 1),
(8, 'sys_studio_acl', 'single', 'delete', '', 'remove', 0, 1, 1, 2),
(9, 'sys_studio_acl_actions', 'single', 'options', '', 'cog', 0, 0, 1, 1),
(10, 'sys_studio_nav_menus', 'independent', 'add', '_adm_nav_btn_menus_create', '', 0, 0, 1, 1),
(11, 'sys_studio_nav_menus', 'single', 'edit', '', 'pencil-alt', 0, 0, 1, 1),
(12, 'sys_studio_nav_menus', 'single', 'delete', '', 'remove', 0, 1, 1, 2),
(13, 'sys_studio_nav_sets', 'independent', 'add', '_adm_nav_btn_sets_create', '', 0, 0, 1, 1),
(14, 'sys_studio_nav_sets', 'single', 'edit', '', 'pencil-alt', 0, 0, 1, 1),
(15, 'sys_studio_nav_sets', 'single', 'delete', '', 'remove', 0, 1, 1, 2),
(16, 'sys_studio_nav_items', 'independent', 'import', '_adm_nav_btn_items_gl_import', '', 0, 0, 1, 1),
(17, 'sys_studio_nav_items', 'independent', 'add', '_adm_nav_btn_items_gl_create', '', 0, 0, 1, 2),
(18, 'sys_studio_nav_items', 'single', 'edit', '', 'pencil-alt', 0, 0, 1, 1),
(19, 'sys_studio_nav_items', 'single', 'delete', '', 'remove', 0, 1, 1, 2),
(20, 'sys_studio_nav_items', 'single', 'show_to', '_adm_nav_btn_items_gl_visible', '', 0, 0, 1, 3),
(21, 'sys_studio_nav_import', 'single', 'import', '', 'plus', 0, 0, 1, 1),
(22, 'sys_studio_nav_import', 'bulk', 'done', '_adm_nav_btn_items_done', '', 0, 0, 1, 1),
(23, 'sys_studio_forms', 'single', 'edit', '', 'pencil-alt', 0, 0, 1, 1),
(24, 'sys_studio_forms_displays', 'single', 'edit', '', 'pencil-alt', 0, 0, 1, 1),
(25, 'sys_studio_forms_fields', 'single', 'edit', '', 'pencil-alt', 0, 0, 1, 1),
(26, 'sys_studio_forms_fields', 'single', 'delete', '', 'remove', 0, 1, 1, 2),
(27, 'sys_studio_forms_fields', 'single', 'show_to', '_adm_form_btn_fields_visible', '', 0, 0, 1, 3),
(28, 'sys_studio_forms_fields', 'independent', 'add', '_adm_form_btn_fields_create', '', 0, 0, 1, 1),
(29, 'sys_studio_forms_pre_lists', 'independent', 'add', '_adm_form_btn_pre_lists_create', '', 0, 0, 1, 1),
(30, 'sys_studio_forms_pre_lists', 'single', 'edit', '', 'pencil-alt', 0, 0, 1, 1),
(31, 'sys_studio_forms_pre_lists', 'single', 'delete', '', 'remove', 0, 1, 1, 2),
(32, 'sys_studio_forms_pre_values', 'independent', 'add', '_adm_form_btn_pre_values_create', '', 0, 0, 1, 1),
(33, 'sys_studio_forms_pre_values', 'single', 'edit', '', 'pencil-alt', 0, 0, 1, 1),
(34, 'sys_studio_forms_pre_values', 'single', 'delete', '', 'remove', 0, 1, 1, 2),
(35, 'sys_studio_forms_pre_values', 'bulk', 'delete', '_adm_form_btn_pre_values_delete', '', 0, 1, 1, 1),
(36, 'sys_studio_search_forms', 'single', 'edit', '', 'pencil-alt', 0, 0, 1, 1),
(37, 'sys_studio_search_forms_fields', 'single', 'edit', '', 'pencil-alt', 0, 0, 1, 1),
(38, 'sys_studio_search_forms_fields', 'independent', 'reset', '_adm_form_btn_search_forms_fields_reset', '', 0, 0, 1, 1),
(39, 'sys_studio_search_forms_sortable_fields', 'independent', 'reset', '_adm_form_btn_search_forms_sortable_fields_reset', '', 0, 0, 1, 1),
(40, 'sys_studio_labels', 'independent', 'back', '_adm_form_btn_labels_back', '', 0, 0, 1, 1),
(41, 'sys_studio_labels', 'independent', 'add', '_adm_form_btn_labels_add', '', 0, 0, 1, 2),
(42, 'sys_studio_labels', 'single', 'edit', '', 'pencil-alt', 0, 0, 1, 1),
(43, 'sys_studio_labels', 'single', 'delete', '', 'remove', 0, 1, 1, 2),
(44, 'sys_studio_categories', 'bulk', 'delete', '_adm_form_btn_categories_delete', '', 0, 1, 1, 1),
(45, 'sys_studio_categories', 'single', 'edit', '', 'pencil-alt', 0, 0, 1, 1),
(46, 'sys_studio_categories', 'single', 'delete', '', 'remove', 0, 1, 1, 2),
(47, 'sys_studio_categories', 'independent', 'add', '_adm_form_btn_categories_add', '', 0, 0, 1, 1),
(48, 'sys_studio_groups_roles', 'independent', 'add', '_adm_rl_btn_role_add', '', 0, 0, 1, 1),
(49, 'sys_studio_groups_roles', 'single', 'edit', '_adm_rl_btn_role_edit', 'pencil-alt', 0, 0, 1, 1),
(50, 'sys_studio_groups_roles', 'single', 'delete', '_adm_rl_btn_role_delete', 'remove', 0, 1, 1, 3),
(51, 'sys_badges_administration', 'bulk', 'delete', '_adm_form_btn_badges_delete', '', 0, 1, 1, 1),
(52, 'sys_badges_administration', 'single', 'edit', '', 'pencil-alt', 0, 0, 1, 1),
(53, 'sys_badges_administration', 'single', 'delete', '', 'remove', 0, 1, 1, 2),
(54, 'sys_badges_administration', 'single', 'delete_icon', '', '', 0, 1, 1, 3),
(55, 'sys_badges_administration', 'independent', 'add', '_adm_form_btn_badges_add', '', 0, 0, 1, 1),
(56, 'sys_reports_administration', 'single', 'check_in', '_adm_form_btn_reports_check_in', 'lock-open', 1, 0, 1, 1),
(57, 'sys_reports_administration', 'single', 'check_out', '_adm_form_btn_reports_check_out', 'lock', 1, 0, 1, 2),
(58, 'sys_reports_administration', 'single', 'audit', '_adm_form_btn_reports_audit', 'history', 1, 0, 1, 3),
(59, 'sys_studio_roles', 'independent', 'add', '_adm_rl_btn_role_add', '', 0, 0, 1, 1),
(60, 'sys_studio_roles', 'single', 'edit', '_adm_rl_btn_role_edit', 'pencil-alt', 1, 0, 1, 1),
(61, 'sys_studio_roles', 'single', 'delete', '_adm_rl_btn_role_delete', 'remove', 1, 1, 1, 2),
(62, 'sys_cmts_administration', 'bulk', 'delete', '_sys_cmts_administration_grid_action_title_adm_delete', '', 0, 1, 1, 1),
(63, 'sys_cmts_administration', 'single', 'delete', '_sys_cmts_administration_grid_action_title_adm_delete', 'remove', 1, 1, 1, 1),
(64, 'sys_studio_strg_files', 'bulk', 'delete', '_adm_strg_btn_delete', '', 0, 1, 1, 1),
(65, 'sys_studio_strg_files', 'single', 'download', '_adm_strg_btn_download', 'download', 1, 0, 1, 1),
(66, 'sys_studio_strg_files', 'single', 'delete', '_adm_strg_btn_delete', 'remove', 1, 1, 1, 2),
(67, 'sys_studio_strg_files', 'independent', 'add', '_adm_strg_btn_add', '', 0, 0, 1, 1),
(68, 'sys_studio_strg_images', 'bulk', 'delete', '_adm_strg_btn_delete', '', 0, 1, 1, 1),
(69, 'sys_studio_strg_images', 'single', 'download', '_adm_strg_btn_download', 'download', 1, 0, 1, 1),
(70, 'sys_studio_strg_images', 'single', 'resize', '_adm_strg_btn_resize', 'compress', 1, 0, 1, 2),
(71, 'sys_studio_strg_images', 'single', 'delete', '_adm_strg_btn_delete', 'remove', 1, 1, 1, 3),
(72, 'sys_studio_strg_images', 'independent', 'add', '_adm_strg_btn_add', '', 0, 0, 1, 1),
(73, 'sys_grid_connections', 'single', 'accept', '_sys_accept', '', 0, 0, 1, 1),
(74, 'sys_grid_connections', 'single', 'delete', '', 'remove', 0, 1, 1, 2),
(75, 'sys_grid_connections', 'single', 'add_friend', '_sys_add_friend', 'plus', 0, 0, 1, 3),
(76, 'sys_grid_connections_requests', 'single', 'accept', '_sys_accept', '', 0, 0, 1, 1),
(77, 'sys_grid_connections_requests', 'single', 'delete', '', 'remove', 0, 1, 1, 2),
(78, 'sys_grid_subscriptions', 'single', 'subscribe', '_sys_subscribe', 'check', 0, 0, 1, 1),
(79, 'sys_grid_subscriptions', 'single', 'delete', '', 'remove', 0, 1, 1, 2),
(80, 'sys_grid_subscribed_me', 'single', 'subscribe', '_sys_subscribe', 'check', 0, 0, 1, 1),
(81, 'sys_grid_relations', 'single', 'delete', '_Delete', 'remove', 1, 1, 1, 1),
(82, 'sys_grid_related_me', 'single', 'confirm', '_sys_confirm', 'check-circle', 1, 0, 1, 1),
(83, 'sys_grid_related_me', 'single', 'decline', '_sys_decline', 'times-circle', 1, 1, 1, 2),
(84, 'sys_grid_related_me', 'single', 'add', '_sys_add_relation', 'plus-circle', 1, 0, 1, 3),
(85, 'sys_grid_related_me', 'single', 'delete', '_Delete', 'remove', 1, 1, 1, 4),
(86, 'sys_queues', 'single', 'clear', '', 'eraser', 0, 1, 1, 1),
(87, 'sys_studio_api_origins', 'single', 'delete', '_Delete', 'remove', 1, 1, 1, 1),
(88, 'sys_studio_api_origins', 'independent', 'add', '_adm_form_btn_field_add', '', 0, 0, 1, 1),
(89, 'sys_studio_api_keys', 'single', 'delete', '_Delete', 'remove', 1, 1, 1, 1),
(90, 'sys_studio_api_keys', 'independent', 'add', '_adm_form_btn_field_add', '', 0, 0, 1, 1),
(91, 'sys_studio_agents_automators', 'bulk', 'delete', '_Delete', '', 0, 1, 1, 1),
(92, 'sys_studio_agents_automators', 'single', 'tune', '_sys_agents_automators_btn_tune', '', 0, 0, 1, 1),
(93, 'sys_studio_agents_automators', 'single', 'edit', '_Edit', 'pencil-alt', 1, 0, 1, 2),
(94, 'sys_studio_agents_automators', 'single', 'delete', '_Delete', 'remove', 1, 1, 1, 3),
(95, 'sys_studio_agents_automators', 'independent', 'add', '_sys_agents_automators_btn_add', '', 0, 0, 1, 1),
(96, 'sys_studio_agents_helpers', 'independent', 'add', '_sys_agents_helpers_btn_add', '', 0, 0, 1, 1),
(97, 'sys_studio_agents_helpers', 'single', 'tune', '_sys_agents_helpers_btn_tune', '', 0, 0, 1, 1),
(98, 'sys_studio_agents_helpers', 'single', 'edit', '_Edit', 'pencil-alt', 1, 0, 1, 2),
(99, 'sys_studio_agents_helpers', 'single', 'delete', '_Delete', 'remove', 1, 1, 1, 3),
(100, 'sys_studio_agents_helpers', 'bulk', 'delete', '_Delete', '', 0, 1, 1, 1),
(101, 'sys_studio_agents_assistants', 'independent', 'add', '_sys_agents_assistants_btn_add', '', 0, 0, 1, 1),
(102, 'sys_studio_agents_assistants', 'single', 'chats', '_sys_agents_assistants_btn_chats', 'comments', 1, 0, 1, 1),
(103, 'sys_studio_agents_assistants', 'single', 'files', '_sys_agents_assistants_btn_files', 'folder', 1, 0, 1, 2),
(104, 'sys_studio_agents_assistants', 'single', 'codes', '_sys_agents_assistants_btn_codes', 'code', 1, 0, 1, 3),
(105, 'sys_studio_agents_assistants', 'single', 'edit', '_Edit', 'pencil-alt', 1, 0, 1, 4),
(106, 'sys_studio_agents_assistants', 'single', 'delete', '_Delete', 'remove', 1, 1, 1, 5),
(107, 'sys_studio_agents_assistants', 'bulk', 'delete', '_Delete', '', 0, 1, 1, 1),
(108, 'sys_studio_agents_assistants_chats', 'independent', 'add', '_sys_agents_assistants_chats_btn_add', '', 0, 0, 1, 1),
(109, 'sys_studio_agents_assistants_chats', 'single', 'chat', '_sys_agents_assistants_chats_btn_chat', '', 0, 0, 1, 1),
(110, 'sys_studio_agents_assistants_chats', 'single', 'store', '_sys_agents_assistants_chats_btn_store', 'download', 1, 1, 1, 2),
(111, 'sys_studio_agents_assistants_chats', 'single', 'unstore', '_sys_agents_assistants_chats_btn_unstore', 'upload', 1, 1, 1, 3),
(112, 'sys_studio_agents_assistants_chats', 'single', 'edit', '_Edit', 'pencil-alt', 1, 0, 1, 4),
(113, 'sys_studio_agents_assistants_chats', 'single', 'delete', '_Delete', 'remove', 1, 1, 1, 5),
(114, 'sys_studio_agents_assistants_chats', 'bulk', 'delete', '_Delete', '', 0, 1, 1, 1),
(115, 'sys_studio_agents_assistants_files', 'independent', 'add', '_sys_agents_assistants_files_btn_add', '', 0, 0, 1, 1),
(116, 'sys_studio_agents_assistants_files', 'independent', 'sync', '_sys_agents_assistants_files_btn_sync', '', 0, 0, 1, 2),
(117, 'sys_studio_agents_assistants_files', 'single', 'delete', '_sys_agents_assistants_files_btn_delete', 'remove', 1, 1, 1, 1),
(118, 'sys_studio_agents_providers', 'independent', 'add', '_sys_agents_providers_btn_add', '', 0, 0, 1, 1),
(119, 'sys_studio_agents_providers', 'single', 'info', '_sys_agents_providers_btn_info', 'info', 1, 0, 1, 1),
(120, 'sys_studio_agents_providers', 'single', 'edit', '_sys_agents_providers_btn_edit', 'pencil-alt', 1, 0, 1, 2),
(121, 'sys_studio_agents_providers', 'single', 'delete', '_sys_agents_providers_btn_delete', 'remove', 1, 1, 1, 3),
(122, 'sys_studio_agents_providers', 'bulk', 'delete', '_sys_agents_providers_btn_delete', '', 0, 1, 1, 1),
(123, 'bx_persons_administration', 'bulk', 'set_acl_level', '_bx_persons_grid_action_title_adm_set_acl_level', '', 0, 0, 1, 1),
(124, 'bx_persons_administration', 'bulk', 'delete_with_content', '_bx_persons_grid_action_title_adm_delete_with_content', '', 0, 1, 1, 2),
(125, 'bx_persons_administration', 'bulk', 'clear_reports', '_bx_persons_grid_action_title_adm_clear_reports', '', 0, 1, 1, 3),
(126, 'bx_persons_administration', 'single', 'set_acl_level', '_bx_persons_grid_action_title_adm_set_acl_level', 'certificate', 1, 0, 1, 1),
(127, 'bx_persons_administration', 'single', 'settings', '_bx_persons_grid_action_title_adm_more_actions', 'cog', 1, 0, 1, 2),
(128, 'bx_persons_administration', 'single', 'audit_content', '_bx_persons_grid_action_title_adm_audit_content', 'search', 1, 0, 1, 3),
(129, 'bx_persons_administration', 'single', 'audit_profile', '_bx_persons_grid_action_title_adm_audit_profile', 'search-location', 1, 0, 1, 4),
(130, 'bx_persons_common', 'bulk', 'delete_with_content', '_bx_persons_grid_action_title_adm_delete_with_content', '', 0, 1, 1, 1),
(131, 'bx_persons_common', 'single', 'settings', '_bx_persons_grid_action_title_adm_more_actions', 'cog', 1, 0, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_grid_fields`
--

CREATE TABLE `sys_grid_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `width` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translatable` tinyint(4) NOT NULL DEFAULT '0',
  `chars_limit` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `hidden_on` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `order` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object_name` (`object`,`name`(127))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=243 ;

--
-- Dumping data for table `sys_grid_fields`
--

INSERT INTO `sys_grid_fields` VALUES
(1, 'sys_studio_lang_keys', 'checkbox', 'Select', '1%', 0, 0, '', '', 1),
(2, 'sys_studio_lang_keys', 'key', '_adm_pgt_txt_key', '24%', 0, 20, '', '', 2),
(3, 'sys_studio_lang_keys', 'module', '_adm_pgt_txt_module', '15%', 0, 12, '', '', 3),
(4, 'sys_studio_lang_keys', 'string', '_adm_pgt_txt_text', '30%', 0, 30, '', '', 4),
(5, 'sys_studio_lang_keys', 'languages', '_adm_pgt_txt_languages', '10%', 0, 0, '', '', 5),
(6, 'sys_studio_lang_keys', 'actions', '', '20%', 0, 0, '', '', 6),
(7, 'sys_studio_lang_etemplates', 'NameSystem', '_adm_pgt_txt_etemplates_gl_name_system', '60%', 1, 58, '', '', 1),
(8, 'sys_studio_lang_etemplates', 'Module', '_adm_pgt_txt_etemplates_gl_module', '20%', 0, 18, '', '', 2),
(9, 'sys_studio_lang_etemplates', 'actions', '', '20%', 0, 0, '', '', 3),
(10, 'sys_studio_roles', 'order', '', '1%', 0, 0, '', '', 1),
(11, 'sys_studio_roles', 'switcher', '', '5%', 0, 0, '', '', 2),
(12, 'sys_studio_roles', 'title', '_adm_rl_txt_title', '24%', 1, 0, '', '', 3),
(13, 'sys_studio_roles', 'description', '_adm_rl_txt_description', '35%', 1, 32, '', '', 4),
(14, 'sys_studio_roles', 'actions_list', '_adm_rl_txt_actions', '15%', 0, 0, '', '', 5),
(15, 'sys_studio_roles', 'actions', '', '20%', 0, 0, '', '', 6),
(16, 'sys_studio_roles_actions', 'switcher', '', '10%', 0, 0, '', '', 1),
(17, 'sys_studio_roles_actions', 'title', '_adm_rl_txt_title', '40%', 1, 32, '', '', 2),
(18, 'sys_studio_roles_actions', 'description', '_adm_rl_txt_description', '50%', 1, 48, '', '', 3),
(19, 'sys_studio_acl', 'Order', '', '1%', 0, 0, '', '', 1),
(20, 'sys_studio_acl', 'switcher', '_adm_prm_txt_enable', '5%', 0, 0, '', '', 2),
(21, 'sys_studio_acl', 'Icon', '_adm_prm_txt_icon', '5%', 0, 0, '', '', 3),
(22, 'sys_studio_acl', 'Name', '_adm_prm_txt_title', '29%', 1, 15, '', '', 4),
(23, 'sys_studio_acl', 'ActionsList', '_adm_prm_txt_actions', '10%', 0, 0, '', '', 5),
(24, 'sys_studio_acl', 'QuotaSize', '_adm_prm_txt_storage', '10%', 0, 0, '', '', 6),
(25, 'sys_studio_acl', 'QuotaMaxFileSize', '_adm_prm_txt_max_file_size', '10%', 0, 0, '', '', 7),
(26, 'sys_studio_acl', 'QuotaNumber', '_adm_prm_txt_max_files', '10%', 0, 0, '', '', 8),
(27, 'sys_studio_acl', 'actions', '', '20%', 0, 0, '', '', 9),
(28, 'sys_studio_acl_actions', 'switcher', '_adm_prm_txt_enable', '10%', 0, 0, '', '', 1),
(29, 'sys_studio_acl_actions', 'Title', '_adm_prm_txt_title', '25%', 1, 25, '', '', 2),
(30, 'sys_studio_acl_actions', 'Module', '_adm_prm_txt_module', '20%', 0, 18, '', '', 3),
(31, 'sys_studio_acl_actions', 'Desc', '_adm_prm_txt_description', '25%', 0, 25, '', '', 4),
(32, 'sys_studio_acl_actions', 'actions', '', '20%', 0, 0, '', '', 5),
(33, 'sys_studio_nav_menus', 'switcher', '', '10%', 0, 0, '', '', 1),
(34, 'sys_studio_nav_menus', 'title', '_adm_nav_txt_menus_gl_title', '17%', 0, 15, '', '', 2),
(35, 'sys_studio_nav_menus', 'set_title', '_adm_nav_txt_menus_gl_set_title', '17%', 1, 15, '', '', 3),
(36, 'sys_studio_nav_menus', 'items', '_adm_nav_txt_menus_gl_items', '10%', 0, 8, '', '', 4),
(37, 'sys_studio_nav_menus', 'template_title', '_adm_nav_txt_menus_gl_template_title', '17%', 1, 15, '', '', 5),
(38, 'sys_studio_nav_menus', 'module', '_adm_nav_txt_menus_gl_module', '12%', 0, 10, '', '', 6),
(39, 'sys_studio_nav_menus', 'actions', '', '17%', 0, 0, '', '', 7),
(40, 'sys_studio_nav_sets', 'title', '_adm_nav_txt_sets_gl_title', '50%', 1, 48, '', '', 1),
(41, 'sys_studio_nav_sets', 'module', '_adm_nav_txt_sets_gl_module', '15%', 0, 13, '', '', 2),
(42, 'sys_studio_nav_sets', 'items', '_adm_nav_txt_sets_gl_items', '15%', 0, 13, '', '', 3),
(43, 'sys_studio_nav_sets', 'actions', '', '20%', 0, 0, '', '', 4),
(44, 'sys_studio_nav_items', 'order', '', '1%', 0, 0, '', '', 1),
(45, 'sys_studio_nav_items', 'switcher', '', '9%', 0, 0, '', '', 2),
(46, 'sys_studio_nav_items', 'icon', '_adm_nav_txt_items_gl_icon', '5%', 0, 0, '', '', 3),
(47, 'sys_studio_nav_items', 'title_system', '_adm_nav_txt_items_gl_title_system', '23%', 1, 23, '', '', 4),
(48, 'sys_studio_nav_items', 'link', '_adm_nav_txt_items_gl_link', '23%', 0, 23, '', '', 5),
(49, 'sys_studio_nav_items', 'module', '_adm_nav_txt_items_gl_module', '12%', 0, 12, '', '', 6),
(50, 'sys_studio_nav_items', 'visible_for_levels', '_adm_nav_txt_items_gl_visible', '10%', 0, 10, '', '', 7),
(51, 'sys_studio_nav_items', 'actions', '', '17%', 0, 0, '', '', 8),
(52, 'sys_studio_nav_import', 'icon', '_adm_nav_txt_items_gl_icon', '10%', 0, 0, '', '', 1),
(53, 'sys_studio_nav_import', 'title_system', '_adm_nav_txt_items_gl_title_system', '30%', 1, 28, '', '', 2),
(54, 'sys_studio_nav_import', 'link', '_adm_nav_txt_items_gl_link', '25%', 0, 23, '', '', 3),
(55, 'sys_studio_nav_import', 'module', '_adm_nav_txt_items_gl_module', '15%', 0, 13, '', '', 4),
(56, 'sys_studio_nav_import', 'actions', '', '20%', 0, 0, '', '', 5),
(57, 'sys_studio_forms', 'switcher', '', '10%', 0, 0, '', '', 1),
(58, 'sys_studio_forms', 'title', '_adm_form_txt_forms_gl_title', '40%', 1, 38, '', '', 2),
(59, 'sys_studio_forms', 'module', '_adm_form_txt_forms_gl_module', '15%', 0, 13, '', '', 3),
(60, 'sys_studio_forms', 'displays', '_adm_form_txt_forms_gl_displays', '15%', 0, 13, '', '', 4),
(61, 'sys_studio_forms', 'actions', '', '20%', 0, 0, '', '', 5),
(62, 'sys_studio_forms_displays', 'display_title', '_adm_form_txt_displays_gl_title', '30%', 1, 48, '', '', 1),
(63, 'sys_studio_forms_displays', 'module', '_adm_form_txt_displays_gl_module', '13%', 0, 11, '', '', 2),
(64, 'sys_studio_forms_displays', 'form_title', '_adm_form_txt_displays_gl_form', '24%', 1, 22, '', '', 3),
(65, 'sys_studio_forms_displays', 'fields', '_adm_form_txt_displays_gl_fields', '13%', 0, 11, '', '', 4),
(66, 'sys_studio_forms_displays', 'actions', '', '20%', 0, 0, '', '', 5),
(67, 'sys_studio_forms_fields', 'order', '', '1%', 0, 0, '', '', 1),
(68, 'sys_studio_forms_fields', 'switcher', '', '9%', 0, 0, '', '', 2),
(69, 'sys_studio_forms_fields', 'type', '_adm_form_txt_fields_type', '5%', 0, 0, '', '', 3),
(70, 'sys_studio_forms_fields', 'caption_system', '_adm_form_txt_fields_caption_system', '40%', 1, 38, '', '', 4),
(71, 'sys_studio_forms_fields', 'module', '_adm_form_txt_fields_module', '15%', 0, 13, '', '', 5),
(72, 'sys_studio_forms_fields', 'visible_for_levels', '_adm_form_txt_fields_visible', '10%', 0, 10, '', '', 6),
(73, 'sys_studio_forms_fields', 'actions', '', '20%', 0, 0, '', '', 7),
(74, 'sys_studio_forms_pre_lists', 'title', '_adm_form_txt_pre_lists_gl_title', '45%', 1, 50, '', '', 1),
(75, 'sys_studio_forms_pre_lists', 'values', '_adm_form_txt_pre_lists_gl_values', '12%', 0, 10, '', '', 2),
(76, 'sys_studio_forms_pre_lists', 'module', '_adm_form_txt_pre_lists_gl_module', '13%', 0, 11, '', '', 3),
(77, 'sys_studio_forms_pre_lists', 'use_for_sets', '_adm_form_txt_pre_lists_gl_use_for_sets', '10%', 0, 8, '', '', 4),
(78, 'sys_studio_forms_pre_lists', 'actions', '', '20%', 0, 0, '', '', 5),
(79, 'sys_studio_forms_pre_values', 'checkbox', '', '1%', 0, 0, '', '', 1),
(80, 'sys_studio_forms_pre_values', 'order', '', '1%', 0, 0, '', '', 2),
(81, 'sys_studio_forms_pre_values', 'LKey', '_adm_form_txt_pre_values_gl_lkey', '78%', 1, 75, '', '', 3),
(82, 'sys_studio_forms_pre_values', 'actions', '', '20%', 0, 0, '', '', 4),
(83, 'sys_studio_search_forms', 'switcher', '', '10%', 0, 0, '', '', 1),
(84, 'sys_studio_search_forms', 'title', '_adm_form_txt_search_forms_title', '35%', 1, 38, '', '', 2),
(85, 'sys_studio_search_forms', 'module', '_adm_form_txt_search_forms_module', '15%', 0, 13, '', '', 3),
(86, 'sys_studio_search_forms', 'fields', '_adm_form_txt_search_forms_fields', '10%', 0, 13, '', '', 4),
(87, 'sys_studio_search_forms', 'sortable_fields', '_adm_form_txt_search_forms_sortable_fields', '10%', 0, 13, '', '', 5),
(88, 'sys_studio_search_forms', 'actions', '', '20%', 0, 0, '', '', 6),
(89, 'sys_studio_search_forms_fields', 'order', '', '1%', 0, 0, '', '', 1),
(90, 'sys_studio_search_forms_fields', 'switcher', '', '9%', 0, 0, '', '', 2),
(91, 'sys_studio_search_forms_fields', 'type', '_adm_form_txt_search_forms_fields_type', '15%', 0, 0, '', '', 3),
(92, 'sys_studio_search_forms_fields', 'caption', '_adm_form_txt_search_forms_fields_caption', '40%', 1, 38, '', '', 4),
(93, 'sys_studio_search_forms_fields', 'search_type', '_adm_form_txt_search_forms_fields_search_type', '15%', 0, 0, '', '', 5),
(94, 'sys_studio_search_forms_fields', 'actions', '', '20%', 0, 0, '', '', 6),
(95, 'sys_studio_search_forms_sortable_fields', 'order', '', '1%', 0, 0, '', '', 1),
(96, 'sys_studio_search_forms_sortable_fields', 'switcher', '', '9%', 0, 0, '', '', 2),
(97, 'sys_studio_search_forms_sortable_fields', 'caption', '_adm_form_txt_search_forms_sortable_fields_caption', '50%', 1, 38, '', '', 3),
(98, 'sys_studio_search_forms_sortable_fields', 'direction', '_adm_form_txt_search_forms_sortable_fields_direction', '40%', 0, 0, '', '', 4),
(99, 'sys_studio_labels', 'order', '', '1%', 0, 0, '', '', 1),
(100, 'sys_studio_labels', 'value', '_adm_form_txt_labels_value', '70%', 0, 38, '', '', 2),
(101, 'sys_studio_labels', 'items', '_adm_form_txt_labels_items', '10%', 0, 0, '', '', 3),
(102, 'sys_studio_labels', 'actions', '', '19%', 0, 0, '', '', 4),
(103, 'sys_studio_categories', 'checkbox', '_sys_select', '2%', 0, 0, '', '', 1),
(104, 'sys_studio_categories', 'switcher', '_adm_prm_txt_enable', '8%', 0, 0, '', '', 2),
(105, 'sys_studio_categories', 'value', '_adm_form_txt_categories_value', '25%', 0, 35, '', '', 3),
(106, 'sys_studio_categories', 'module', '_adm_form_txt_categories_module', '15%', 0, 35, '', '', 4),
(107, 'sys_studio_categories', 'author', '_adm_form_txt_categories_author', '15%', 0, 35, '', '', 5),
(108, 'sys_studio_categories', 'added', '_adm_form_txt_categories_added', '15%', 1, 25, '', '', 6),
(109, 'sys_studio_categories', 'actions', '', '20%', 0, 0, '', '', 7),
(110, 'sys_studio_groups_roles', 'order', '', '2%', 0, 0, '', '', 1),
(111, 'sys_studio_groups_roles', 'LKey', '_adm_rl_txt_title', '40%', 1, 0, '', '', 2),
(112, 'sys_studio_groups_roles', 'actions_list', '_adm_rl_txt_actions', '10%', 0, 35, '', '', 3),
(113, 'sys_studio_groups_roles', 'actions', '', '48%', 0, 0, '', '', 4),
(114, 'sys_audit_administration', 'added', '_adm_form_txt_audit_added', '15%', 1, 25, '', '', 1),
(115, 'sys_audit_administration', 'profile_id', '_adm_form_txt_audit_profile', '15%', 1, 25, '', '', 2),
(116, 'sys_audit_administration', 'content_id', '_adm_form_txt_audit_content', '20%', 1, 25, '', '', 3),
(117, 'sys_audit_administration', 'author_id', '_adm_form_txt_audit_author_content', '10%', 1, 25, '', '', 4),
(118, 'sys_audit_administration', 'content_module', '_adm_form_txt_audit_module', '10%', 1, 25, '', '', 5),
(119, 'sys_audit_administration', 'context_profile_id', '_adm_pgt_txt_audit_context', '15%', 1, 25, '', '', 6),
(120, 'sys_audit_administration', 'action_lang_key', '_adm_pgt_txt_audit_action', '15%', 1, 25, '', '', 7),
(121, 'sys_badges_administration', 'checkbox', '_sys_select', '2%', 0, 0, '', '', 1),
(122, 'sys_badges_administration', 'view', '_adm_form_txt_badges_view', '15%', 1, 0, '', '', 2),
(123, 'sys_badges_administration', 'module', '_adm_form_txt_badges_module', '15%', 1, 25, '', '', 3),
(124, 'sys_badges_administration', 'text', '_adm_pgt_txt_badges_text', '28%', 1, 35, '', '', 4),
(125, 'sys_badges_administration', 'icon', '_adm_pgt_txt_badges_icon', '20%', 1, 0, '', '', 5),
(126, 'sys_badges_administration', 'actions', '', '20%', 0, 0, '', '', 6),
(127, 'sys_reports_administration', 'object', '_adm_form_txt_reports_object', '10%', 1, 25, '', '', 1),
(128, 'sys_reports_administration', 'author', '_adm_form_txt_reports_author', '10%', 1, 25, '', '', 2),
(129, 'sys_reports_administration', 'type', '_adm_form_txt_reports_type', '10%', 1, 25, '', '', 3),
(130, 'sys_reports_administration', 'text', '_adm_form_txt_reports_text', '10%', 1, 25, '', '', 4),
(131, 'sys_reports_administration', 'date', '_adm_form_txt_reports_date', '10%', 1, 25, '', '', 5),
(132, 'sys_reports_administration', 'status', '_adm_form_txt_reports_status', '10%', 1, 25, '', '', 6),
(133, 'sys_reports_administration', 'checked_by', '_adm_form_txt_reports_checked_by', '10%', 1, 25, '', '', 7),
(134, 'sys_reports_administration', 'notes', '_adm_form_txt_reports_notes', '10%', 1, 25, '', '', 8),
(135, 'sys_reports_administration', 'comments', '_adm_form_txt_reports_comments', '10%', 1, 25, '', '', 8),
(136, 'sys_reports_administration', 'actions', '', '10%', 0, 0, '', '', 9),
(137, 'sys_cmts_administration', 'checkbox', '_sys_select', '2%', 0, 0, '', '', 1),
(138, 'sys_cmts_administration', 'switcher', '_sys_cmts_administration_grid_column_title_adm_active', '8%', 0, 0, '', '', 2),
(139, 'sys_cmts_administration', 'reports', '_sys_txt_reports_title', '5%', 0, 0, '', '', 3),
(140, 'sys_cmts_administration', 'cmt_module', '_sys_cmts_administration_grid_column_title_adm_cmt_module', '10%', 0, 25, '', '', 4),
(141, 'sys_cmts_administration', 'cmt_text', '_sys_cmts_administration_grid_column_title_adm_cmt_text', '30%', 0, 25, '', '', 5),
(142, 'sys_cmts_administration', 'cmt_time', '_sys_cmts_administration_grid_column_title_adm_cmt_time', '10%', 1, 25, '', '', 6),
(143, 'sys_cmts_administration', 'cmt_author_id', '_sys_cmts_administration_grid_column_title_adm_cmt_author_id', '15%', 0, 25, '', '', 7),
(144, 'sys_cmts_administration', 'actions', '', '20%', 0, 0, '', '', 8),
(145, 'sys_studio_strg_files', 'checkbox', '', '1%', 0, 0, '', '', 1),
(146, 'sys_studio_strg_files', 'file_name', '_adm_strg_txt_file_name', '24%', 0, 25, '', '', 2),
(147, 'sys_studio_strg_files', 'path', '_adm_strg_txt_path', '25%', 0, 0, '', '', 3),
(148, 'sys_studio_strg_files', 'mime_type', '_adm_strg_txt_mime_type', '15%', 0, 15, '', '', 4),
(149, 'sys_studio_strg_files', 'added', '_adm_strg_txt_added', '10%', 0, 10, '', '', 5),
(150, 'sys_studio_strg_files', 'actions', '', '25%', 0, 0, '', '', 6),
(151, 'sys_studio_strg_images', 'checkbox', '', '1%', 0, 0, '', '', 1),
(152, 'sys_studio_strg_images', 'file_name', '_adm_strg_txt_file_name', '24%', 0, 25, '', '', 2),
(153, 'sys_studio_strg_images', 'path', '_adm_strg_txt_path', '25%', 0, 0, '', '', 3),
(154, 'sys_studio_strg_images', 'mime_type', '_adm_strg_txt_mime_type', '15%', 0, 15, '', '', 4),
(155, 'sys_studio_strg_images', 'added', '_adm_strg_txt_added', '10%', 0, 10, '', '', 5),
(156, 'sys_studio_strg_images', 'actions', '', '25%', 0, 0, '', '', 6),
(157, 'sys_grid_connections', 'name', '_sys_name', '40%', 0, 0, '', '', 1),
(158, 'sys_grid_connections', 'info', '', '30%', 0, 0, '', '1', 2),
(159, 'sys_grid_connections', 'actions', '', '30%', 0, 0, '', '', 3),
(160, 'sys_grid_connections_requests', 'name', '_sys_name', '40%', 0, 0, '', '', 1),
(161, 'sys_grid_connections_requests', 'info', '', '30%', 0, 0, '', '1', 2),
(162, 'sys_grid_connections_requests', 'actions', '', '30%', 0, 0, '', '', 3),
(163, 'sys_grid_subscriptions', 'name', '_sys_name', '70%', 0, 0, '', '', 1),
(164, 'sys_grid_subscriptions', 'actions', '', '30%', 0, 0, '', '', 2),
(165, 'sys_grid_subscribed_me', 'name', '_sys_name', '70%', 0, 0, '', '', 1),
(166, 'sys_grid_subscribed_me', 'actions', '', '30%', 0, 0, '', '', 2),
(167, 'sys_grid_relations', 'name', '_sys_name', '40%', 0, 0, '', '', 1),
(168, 'sys_grid_relations', 'relation', '_sys_relation', '15%', 0, 0, '', '', 2),
(169, 'sys_grid_relations', 'mutual', '_sys_status', '15%', 0, 0, '', '', 3),
(170, 'sys_grid_relations', 'actions', '', '30%', 0, 0, '', '', 4),
(171, 'sys_grid_related_me', 'name', '_sys_name', '40%', 0, 0, '', '', 1),
(172, 'sys_grid_related_me', 'relation', '_sys_relation', '15%', 0, 0, '', '', 2),
(173, 'sys_grid_related_me', 'mutual', '_sys_status', '15%', 0, 0, '', '', 3),
(174, 'sys_grid_related_me', 'actions', '', '30%', 0, 0, '', '', 4),
(175, 'sys_queues', 'name', '_Name', '40%', 1, 0, '', '', 1),
(176, 'sys_queues', 'all', '_all', '20%', 0, 0, '', '', 2),
(177, 'sys_queues', 'failed', '_Failed', '20%', 0, 0, '', '', 3),
(178, 'sys_queues', 'actions', '', '20%', 0, 0, '', '', 4),
(179, 'sys_studio_api_origins', 'order', '', '1%', 0, 0, '', '', 1),
(180, 'sys_studio_api_origins', 'url', '_sys_txt_url', '80%', 0, 0, '', '', 2),
(181, 'sys_studio_api_origins', 'actions', '', '19%', 0, 0, '', '', 3),
(182, 'sys_studio_api_keys', 'order', '', '1%', 0, 0, '', '', 1),
(183, 'sys_studio_api_keys', 'title', '_Name', '40%', 0, 0, '', '', 2),
(184, 'sys_studio_api_keys', 'key', '_sys_txt_api_key', '40%', 0, 0, '', '', 3),
(185, 'sys_studio_api_keys', 'actions', '', '19%', 0, 0, '', '', 4),
(186, 'sys_studio_agents_automators', 'checkbox', '', '2%', 0, 0, '', '', 1),
(187, 'sys_studio_agents_automators', 'switcher', '_sys_agents_automators_txt_active', '8%', 0, 0, '', '', 2),
(188, 'sys_studio_agents_automators', 'name', '_sys_agents_automators_txt_name', '10%', 0, 0, '', '', 3),
(189, 'sys_studio_agents_automators', 'type', '_sys_agents_automators_txt_type', '8%', 0, 0, '', '', 4),
(190, 'sys_studio_agents_automators', 'model_id', '_sys_agents_automators_txt_model_id', '8%', 0, 0, '', '', 5),
(191, 'sys_studio_agents_automators', 'profile_id', '_sys_agents_automators_txt_profile_id', '10%', 0, 0, '', '', 6),
(192, 'sys_studio_agents_automators', 'message_id', '_sys_agents_automators_txt_message_id', '14%', 0, 32, '', '', 7),
(193, 'sys_studio_agents_automators', 'messages', '_sys_agents_automators_txt_messages', '10%', 0, 0, '', '', 8),
(194, 'sys_studio_agents_automators', 'added', '_sys_agents_automators_txt_added', '5%', 0, 0, '', '', 9),
(195, 'sys_studio_agents_automators', 'status', '_sys_agents_automators_txt_status', '5%', 0, 0, '', '', 10),
(196, 'sys_studio_agents_automators', 'actions', '', '20%', 0, 0, '', '', 11),
(197, 'sys_studio_agents_helpers', 'checkbox', '', '2%', 0, 0, '', '', 1),
(198, 'sys_studio_agents_helpers', 'switcher', '_sys_agents_helpers_txt_active', '8%', 0, 0, '', '', 2),
(199, 'sys_studio_agents_helpers', 'name', '_sys_agents_helpers_txt_name', '15%', 0, 0, '', '', 3),
(200, 'sys_studio_agents_helpers', 'model_id', '_sys_agents_helpers_txt_model_id', '10%', 0, 0, '', '', 5),
(201, 'sys_studio_agents_helpers', 'profile_id', '_sys_agents_helpers_txt_profile_id', '10%', 0, 0, '', '', 6),
(202, 'sys_studio_agents_helpers', 'prompt', '_sys_agents_helpers_txt_prompt', '25%', 0, 32, '', '', 7),
(203, 'sys_studio_agents_helpers', 'added', '_sys_agents_helpers_txt_added', '10%', 0, 0, '', '', 8),
(204, 'sys_studio_agents_helpers', 'actions', '', '20%', 0, 0, '', '', 9),
(205, 'sys_studio_agents_assistants', 'checkbox', '', '2%', 0, 0, '', '', 1),
(206, 'sys_studio_agents_assistants', 'switcher', '_sys_agents_assistants_txt_active', '8%', 0, 0, '', '', 2),
(207, 'sys_studio_agents_assistants', 'name', '_sys_agents_assistants_txt_name', '15%', 0, 0, '', '', 3),
(208, 'sys_studio_agents_assistants', 'model_id', '_sys_agents_assistants_txt_model_id', '10%', 0, 0, '', '', 5),
(209, 'sys_studio_agents_assistants', 'profile_id', '_sys_agents_assistants_txt_profile_id', '10%', 0, 0, '', '', 6),
(210, 'sys_studio_agents_assistants', 'prompt', '_sys_agents_assistants_txt_prompt', '25%', 0, 32, '', '', 7),
(211, 'sys_studio_agents_assistants', 'added', '_sys_agents_assistants_txt_added', '10%', 0, 0, '', '', 8),
(212, 'sys_studio_agents_assistants', 'actions', '', '20%', 0, 0, '', '', 9),
(213, 'sys_studio_agents_assistants_chats', 'checkbox', '', '2%', 0, 0, '', '', 1),
(214, 'sys_studio_agents_assistants_chats', 'name', '_sys_agents_assistants_chats_txt_name', '18%', 0, 0, '', '', 2),
(215, 'sys_studio_agents_assistants_chats', 'type', '_sys_agents_assistants_chats_txt_type', '5%', 0, 0, '', '', 3),
(216, 'sys_studio_agents_assistants_chats', 'description', '_sys_agents_assistants_chats_txt_description', '25%', 0, 16, '', '', 4),
(217, 'sys_studio_agents_assistants_chats', 'messages', '_sys_agents_assistants_chats_txt_messages', '10%', 0, 0, '', '', 5),
(218, 'sys_studio_agents_assistants_chats', 'added', '_sys_agents_assistants_chats_txt_added', '15%', 0, 0, '', '', 6),
(219, 'sys_studio_agents_assistants_chats', 'stored', '_sys_agents_assistants_chats_txt_stored', '15%', 0, 0, '', '', 7),
(220, 'sys_studio_agents_assistants_chats', 'actions', '', '20%', 0, 0, '', '', 8),
(221, 'sys_studio_agents_assistants_files', 'name', '_sys_agents_assistants_files_txt_name', '35%', 0, 32, '', '', 1),
(222, 'sys_studio_agents_assistants_files', 'size', '_sys_agents_assistants_files_txt_size', '15%', 0, 0, '', '', 2),
(223, 'sys_studio_agents_assistants_files', 'status', '_sys_agents_assistants_files_txt_status', '15%', 0, 0, '', '', 3),
(224, 'sys_studio_agents_assistants_files', 'added', '_sys_agents_assistants_files_txt_added', '15%', 0, 0, '', '', 4),
(225, 'sys_studio_agents_assistants_files', 'actions', '', '20%', 0, 0, '', '', 5),
(226, 'sys_studio_agents_providers', 'checkbox', '_sys_select', '2%', 0, 0, '', '', 1),
(227, 'sys_studio_agents_providers', 'switcher', '_sys_agents_providers_txt_active', '8%', 0, 0, '', '', 2),
(228, 'sys_studio_agents_providers', 'name', '_sys_agents_providers_txt_provider_name', '30%', 0, 32, '', '', 3),
(229, 'sys_studio_agents_providers', 'provider_type', '_sys_agents_providers_txt_provider_type', '20%', 1, 16, '', '', 4),
(230, 'sys_studio_agents_providers', 'added', '_sys_agents_providers_txt_added', '20%', 0, 0, '', '', 5),
(231, 'sys_studio_agents_providers', 'actions', '', '20%', 0, 0, '', '', 6),
(232, 'bx_persons_administration', 'checkbox', '_sys_select', '2%', 0, 0, '', '', 1),
(233, 'bx_persons_administration', 'switcher', '_bx_persons_grid_column_title_adm_active', '8%', 0, 0, '', '', 2),
(234, 'bx_persons_administration', 'reports', '_sys_txt_reports_title', '5%', 0, 0, '', '', 3),
(235, 'bx_persons_administration', 'fullname', '_bx_persons_grid_column_title_adm_fullname', '25%', 0, 0, '', '', 4),
(236, 'bx_persons_administration', 'last_online', '_bx_persons_grid_column_title_adm_last_online', '20%', 1, 25, '', '', 5),
(237, 'bx_persons_administration', 'account', '_bx_persons_grid_column_title_adm_account', '20%', 0, 25, '', '', 6),
(238, 'bx_persons_administration', 'actions', '', '20%', 0, 0, '', '', 7),
(239, 'bx_persons_common', 'checkbox', '_sys_select', '2%', 0, 0, '', '', 1),
(240, 'bx_persons_common', 'fullname', '_bx_persons_grid_column_title_adm_fullname', '48%', 0, 0, '', '', 2),
(241, 'bx_persons_common', 'last_online', '_bx_persons_grid_column_title_adm_last_online', '30%', 1, 25, '', '', 3),
(242, 'bx_persons_common', 'actions', '', '20%', 0, 0, '', '', 4);

-- --------------------------------------------------------

--
-- Table structure for table `sys_iframely_data`
--

CREATE TABLE `sys_iframely_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `added` int(11) DEFAULT NULL,
  `theme` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_images`
--

CREATE TABLE `sys_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profile_id` int(10) unsigned NOT NULL,
  `remote_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` bigint(20) NOT NULL,
  `added` int(11) NOT NULL,
  `modified` int(11) NOT NULL,
  `private` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `remote_id` (`remote_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_images_custom`
--

CREATE TABLE `sys_images_custom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profile_id` int(10) unsigned NOT NULL,
  `remote_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` bigint(20) NOT NULL,
  `added` int(11) NOT NULL,
  `modified` int(11) NOT NULL,
  `private` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `remote_id` (`remote_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_images_editor`
--

CREATE TABLE `sys_images_editor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profile_id` int(10) unsigned NOT NULL,
  `remote_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` bigint(20) NOT NULL,
  `added` int(11) NOT NULL,
  `modified` int(11) NOT NULL,
  `private` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `remote_id` (`remote_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_images_editor_resized`
--

CREATE TABLE `sys_images_editor_resized` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profile_id` int(10) unsigned NOT NULL,
  `remote_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` bigint(20) NOT NULL,
  `added` int(11) NOT NULL,
  `modified` int(11) NOT NULL,
  `private` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `remote_id` (`remote_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_images_resized`
--

CREATE TABLE `sys_images_resized` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profile_id` int(10) unsigned NOT NULL,
  `remote_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` bigint(20) NOT NULL,
  `added` int(11) NOT NULL,
  `modified` int(11) NOT NULL,
  `private` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `remote_id` (`remote_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_injections`
--

CREATE TABLE `sys_injections` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `page_index` int(11) NOT NULL DEFAULT '0',
  `key` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` enum('text','service') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `replace` tinyint(4) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `sys_injections`
--

INSERT INTO `sys_injections` VALUES
(1, 'update_cache', 150, 'injection_head', 'service', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:17:"get_cache_updater";s:6:"params";a:0:{}s:5:"class";s:19:"TemplStudioLauncher";}', 0, 1),
(2, 'sys_head', 0, 'injection_head', 'text', '', 0, 1),
(3, 'sys_body_class', 0, 'injection_body_class', 'service', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:13:"get_injection";s:6:"params";a:1:{i:0;s:10:"body_class";}s:5:"class";s:21:"TemplTemplateServices";}', 0, 1),
(4, 'sys_body', 0, 'injection_footer', 'text', '', 0, 1),
(5, 'bx_artificer_head', 0, 'injection_head', 'service', 'a:3:{s:6:"module";s:12:"bx_artificer";s:6:"method";s:14:"include_css_js";s:6:"params";a:1:{i:0;s:4:"head";}}', 0, 1),
(6, 'bx_artificer_footer', 0, 'injection_footer', 'service', 'a:3:{s:6:"module";s:12:"bx_artificer";s:6:"method";s:14:"include_css_js";s:6:"params";a:1:{i:0;s:6:"footer";}}', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_injections_admin`
--

CREATE TABLE `sys_injections_admin` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `page_index` int(11) NOT NULL DEFAULT '0',
  `key` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` enum('text','service') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `replace` tinyint(4) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_keys`
--

CREATE TABLE `sys_keys` (
  `key` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `expire` int(11) NOT NULL,
  `salt` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sys_labels`
--

CREATE TABLE `sys_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` int(11) NOT NULL DEFAULT '0',
  `level` int(11) NOT NULL DEFAULT '0',
  `order` int(11) NOT NULL DEFAULT '0',
  `value` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `value` (`value`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_localization_categories`
--

CREATE TABLE `sys_localization_categories` (
  `ID` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Name` (`Name`(191))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `sys_localization_categories`
--

INSERT INTO `sys_localization_categories` VALUES
(1, 'System'),
(2, 'Custom'),
(3, 'BoonEx English'),
(4, 'Boonex Artificer Template'),
(5, 'Persons');

-- --------------------------------------------------------

--
-- Table structure for table `sys_localization_keys`
--

CREATE TABLE `sys_localization_keys` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IDCategory` int(6) unsigned NOT NULL DEFAULT '0',
  `Key` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Key` (`Key`(191)),
  FULLTEXT KEY `KeyFilter` (`Key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4446 ;

--
-- Dumping data for table `sys_localization_keys`
--

INSERT INTO `sys_localization_keys` VALUES
(1, 1, '_ADM_PROFILE_SEND_MSG'),
(2, 1, '_ATT_ACTIVE_E'),
(3, 1, '_ATT_APPROVAL_E'),
(4, 1, '_ATT_REJECTED_E'),
(5, 1, '_ATT_SUSPENDED_E'),
(6, 1, '_ATT_UNCONFIRMED_E'),
(7, 1, '_Access denied'),
(8, 1, '_access_denied_page_title'),
(9, 1, '_access_denied_page_content'),
(10, 1, '_Action'),
(11, 1, '_all'),
(12, 1, '_Allowed Since'),
(13, 1, '_Allowed Until'),
(14, 1, '_Allowed actions'),
(15, 1, '_anonymous'),
(16, 1, '_anonymous_f'),
(17, 1, '_Apply'),
(18, 1, '_apps'),
(19, 1, '_Are_you_sure'),
(20, 1, '_Auth type'),
(21, 1, '_by_author'),
(22, 1, '_Basic'),
(23, 1, '_CONTACT_H'),
(24, 1, '_CONTACT_H1'),
(25, 1, '_Can not delete comments with replies'),
(26, 1, '_Cancel'),
(27, 1, '_Content'),
(28, 1, '_Contents'),
(29, 1, '_Count'),
(30, 1, '_DELETE_SUCCESS'),
(31, 1, '_DELETE_TEXT'),
(32, 1, '_Date'),
(33, 1, '_Delete'),
(34, 1, '_Delete account'),
(35, 1, '_Description'),
(36, 1, '_EXPLANATION_H'),
(37, 1, '_Edit'),
(38, 1, '_Email'),
(39, 1, '_Email sent failed'),
(40, 1, '_Empty'),
(41, 1, '_Enter_value_here'),
(42, 1, '_Error'),
(43, 1, '_Failed'),
(44, 1, '_favorite_counter'),
(45, 1, '_favorite_do_favorite'),
(46, 1, '_favorite_do_unfavorite'),
(47, 1, '_favorite_do_favorite_by'),
(48, 1, '_favorite_err_cannot_perform_action'),
(49, 1, '_favorite_err_duplicate_favorite'),
(50, 1, '_favorite_err_not_enabled'),
(51, 1, '_feature_do_feature'),
(52, 1, '_feature_do_unfeature'),
(53, 1, '_feature_err_cannot_perform_action'),
(54, 1, '_feature_err_duplicate_feature'),
(55, 1, '_feature_err_not_enabled'),
(56, 1, '_Female'),
(57, 1, '_free'),
(58, 1, '_From'),
(59, 1, '_Filters'),
(60, 1, '_Header'),
(61, 1, '_Incorrect Captcha'),
(62, 1, '_Incorrect Email'),
(63, 1, '_Info'),
(64, 1, '_Keyword'),
(65, 1, '_lifetime'),
(66, 1, '_LookinFemale'),
(67, 1, '_LookinMale'),
(68, 1, '_MEMBERSHIP_EXPIRES_IN_DAYS'),
(69, 1, '_MEMBERSHIP_EXPIRES_NEVER'),
(70, 1, '_MEMBERSHIP_EXPIRES_TODAY'),
(71, 1, '_MEMBERSHIP_STANDARD'),
(72, 1, '_MEMBERSHIP_UPGRADE_FROM_STANDARD'),
(73, 1, '_Male'),
(74, 1, '_Manage'),
(75, 1, '_Member'),
(76, 1, '_Member Login'),
(77, 1, '_Message text'),
(78, 1, '_N_point'),
(79, 1, '_N_points'),
(80, 1, '_Name'),
(81, 1, '_Name is required'),
(82, 1, '_never'),
(83, 1, '_No'),
(84, 1, '_None'),
(85, 1, '_No actions allowed for this membership'),
(86, 1, '_No such comment'),
(87, 1, '_Ok'),
(88, 1, '_order_asc'),
(89, 1, '_order_desc'),
(90, 1, '_Period'),
(91, 1, '_Please Wait'),
(92, 1, '_Please enter n1-n2 characters'),
(93, 1, '_Please enter characters'),
(94, 1, '_Please select value'),
(95, 1, '_polls_from'),
(96, 1, '_Preview'),
(97, 1, '_report_comment'),
(98, 1, '_report_comment_with_note'),
(99, 1, '_report_comment_check_in'),
(100, 1, '_report_comment_check_out'),
(101, 1, '_report_status_new'),
(102, 1, '_report_status_check_in'),
(103, 1, '_report_status_check_out'),
(104, 1, '_report_status_all'),
(105, 1, '_report_counter'),
(106, 1, '_report_n_reports'),
(107, 1, '_report_do_report'),
(108, 1, '_report_do_report_with_sample'),
(109, 1, '_report_do_unreport'),
(110, 1, '_report_do_unreport_confirm'),
(111, 1, '_report_do_report_by'),
(112, 1, '_report_err_cannot_perform_action'),
(113, 1, '_report_err_duplicate_report'),
(114, 1, '_report_err_not_enabled'),
(115, 1, '_report_err_wrong_type'),
(116, 1, '_report_reported_as'),
(117, 1, '_report_reported_by'),
(118, 1, '_report_comments_count'),
(119, 1, '_RSS_Feed_Title_Common'),
(120, 1, '_RSS_Feed_Title_Profile'),
(121, 1, '_Rate'),
(122, 1, '_Read'),
(123, 1, '_Read more'),
(124, 1, '_Reset'),
(125, 1, '_Search'),
(126, 1, '_search_in_all_section'),
(127, 1, '_Section'),
(128, 1, '_Select_one'),
(129, 1, '_Select_all'),
(130, 1, '_Show'),
(131, 1, '_Sorry, your IP been banned'),
(132, 1, '_Subject'),
(133, 1, '_Submit'),
(134, 1, '_Success'),
(135, 1, '_Times allowed'),
(136, 1, '_Title'),
(137, 1, '_To'),
(138, 1, '_unlimited'),
(139, 1, '_VIEW_MEMBERSHIP_ACTIONS'),
(140, 1, '_View'),
(141, 1, '_Yes'),
(142, 1, '_Your email'),
(143, 1, '_Your name'),
(144, 1, '__Afghanistan'),
(145, 1, '__Afrikaans'),
(146, 1, '__Aland_Islands'),
(147, 1, '__Albania'),
(148, 1, '__Algeria'),
(149, 1, '__American Samoa'),
(150, 1, '__Andorra'),
(151, 1, '__Angola'),
(152, 1, '__Anguilla'),
(153, 1, '__Antarctica'),
(154, 1, '__Antigua and Barbuda'),
(155, 1, '__Arabic'),
(156, 1, '__Argentina'),
(157, 1, '__Armenia'),
(158, 1, '__Aruba'),
(159, 1, '__Australia'),
(160, 1, '__Austria'),
(161, 1, '__Azerbaijan'),
(162, 1, '__Bahrain'),
(163, 1, '__Bangladesh'),
(164, 1, '__Barbados'),
(165, 1, '__Belarus'),
(166, 1, '__Belgium'),
(167, 1, '__Belize'),
(168, 1, '__Benin'),
(169, 1, '__Bermuda'),
(170, 1, '__Bhutan'),
(171, 1, '__Bolivia'),
(172, 1, '__Bosnia and Herzegovina'),
(173, 1, '__Botswana'),
(174, 1, '__Bouvet Island'),
(175, 1, '__Brazil'),
(176, 1, '__British Indian Ocean Territory'),
(177, 1, '__British Virgin Islands'),
(178, 1, '__Brunei Darussalam'),
(179, 1, '__Bulgaria'),
(180, 1, '__Bulgarian'),
(181, 1, '__Burkina Faso'),
(182, 1, '__Burma'),
(183, 1, '__Burmese'),
(184, 1, '__Burundi'),
(185, 1, '__Cambodia'),
(186, 1, '__Cameroon'),
(187, 1, '__Canada'),
(188, 1, '__Cantonese'),
(189, 1, '__Cape Verde'),
(190, 1, '__Cayman Islands'),
(191, 1, '__Central African Republic'),
(192, 1, '__Chad'),
(193, 1, '__Chile'),
(194, 1, '__China'),
(195, 1, '__Christmas Island'),
(196, 1, '__Cocos (Keeling) Islands'),
(197, 1, '__Colombia'),
(198, 1, '__Comoros'),
(199, 1, '__Congo, Democratic Republic of the'),
(200, 1, '__Congo, Republic of the'),
(201, 1, '__Cook Islands'),
(202, 1, '__Costa Rica'),
(203, 1, '__Cote d''Ivoire'),
(204, 1, '__Croatia'),
(205, 1, '__Croatian'),
(206, 1, '__Cuba'),
(207, 1, '__Cyprus'),
(208, 1, '__Czech Republic'),
(209, 1, '__Danish'),
(210, 1, '__Denmark'),
(211, 1, '__Djibouti'),
(212, 1, '__Dominica'),
(213, 1, '__Dominican Republic'),
(214, 1, '__Dutch'),
(215, 1, '__East Timor'),
(216, 1, '__Ecuador'),
(217, 1, '__Egypt'),
(218, 1, '__El Salvador'),
(219, 1, '__English'),
(220, 1, '__Equatorial Guinea'),
(221, 1, '__Eritrea'),
(222, 1, '__Esperanto'),
(223, 1, '__Estonia'),
(224, 1, '__Estonian'),
(225, 1, '__Ethiopia'),
(226, 1, '__Falkland Islands (Islas Malvinas)'),
(227, 1, '__Faroe Islands'),
(228, 1, '__Fiji'),
(229, 1, '__Finland'),
(230, 1, '__Finnish'),
(231, 1, '__France'),
(232, 1, '__French'),
(233, 1, '__French Guiana'),
(234, 1, '__French Polynesia'),
(235, 1, '__French Southern and Antarctic Lands'),
(236, 1, '__Gabon'),
(237, 1, '__Georgia'),
(238, 1, '__German'),
(239, 1, '__Germany'),
(240, 1, '__Ghana'),
(241, 1, '__Gibraltar'),
(242, 1, '__Greece'),
(243, 1, '__Greek'),
(244, 1, '__Greenland'),
(245, 1, '__Grenada'),
(246, 1, '__Guadeloupe'),
(247, 1, '__Guam'),
(248, 1, '__Guatemala'),
(249, 1, '__Guernsey'),
(250, 1, '__Guinea'),
(251, 1, '__Guinea-Bissau'),
(252, 1, '__Gujrati'),
(253, 1, '__Guyana'),
(254, 1, '__Haiti'),
(255, 1, '__Heard Island and McDonald Islands'),
(256, 1, '__Hebrew'),
(257, 1, '__Hindi'),
(258, 1, '__Holy See (Vatican City)'),
(259, 1, '__Honduras'),
(260, 1, '__Hong Kong (SAR)'),
(261, 1, '__Hungarian'),
(262, 1, '__Hungary'),
(263, 1, '__Iceland'),
(264, 1, '__Icelandic'),
(265, 1, '__India'),
(266, 1, '__Indonesia'),
(267, 1, '__Indonesian'),
(268, 1, '__Iran'),
(269, 1, '__Iraq'),
(270, 1, '__Ireland'),
(271, 1, '__Isle_of_Man'),
(272, 1, '__Israel'),
(273, 1, '__Italian'),
(274, 1, '__Italy'),
(275, 1, '__Jamaica'),
(276, 1, '__Japan'),
(277, 1, '__Japanese'),
(278, 1, '__Jersey'),
(279, 1, '__Jordan'),
(280, 1, '__Kazakhstan'),
(281, 1, '__Kenya'),
(282, 1, '__Kiribati'),
(283, 1, '__Korea, North'),
(284, 1, '__Korea, South'),
(285, 1, '__Korean'),
(286, 1, '__Kuwait'),
(287, 1, '__Kyrgyzstan'),
(288, 1, '__Laos'),
(289, 1, '__Latvia'),
(290, 1, '__Latvian'),
(291, 1, '__Lebanon'),
(292, 1, '__Lesotho'),
(293, 1, '__Liberia'),
(294, 1, '__Libya'),
(295, 1, '__Liechtenstein'),
(296, 1, '__Lithuania'),
(297, 1, '__Lithuanian'),
(298, 1, '__Luxembourg'),
(299, 1, '__Macao'),
(300, 1, '__Macedonia, The Former Yugoslav Republic of'),
(301, 1, '__Madagascar'),
(302, 1, '__Malawi'),
(303, 1, '__Malay'),
(304, 1, '__Malaysia'),
(305, 1, '__Maldives'),
(306, 1, '__Mali'),
(307, 1, '__Malta'),
(308, 1, '__Mandarin'),
(309, 1, '__Marathi'),
(310, 1, '__Marshall Islands'),
(311, 1, '__Martinique'),
(312, 1, '__Mauritania'),
(313, 1, '__Mauritius'),
(314, 1, '__Mayotte'),
(315, 1, '__Mexico'),
(316, 1, '__Micronesia, Federated States of'),
(317, 1, '__Moldova'),
(318, 1, '__Moldovian'),
(319, 1, '__Monaco'),
(320, 1, '__Mongolia'),
(321, 1, '__Montenegro'),
(322, 1, '__Montserrat'),
(323, 1, '__Morocco'),
(324, 1, '__Mozambique'),
(325, 1, '__Namibia'),
(326, 1, '__Nauru'),
(327, 1, '__Nepal'),
(328, 1, '__Nepalese'),
(329, 1, '__Netherlands'),
(330, 1, '__Netherlands Antilles'),
(331, 1, '__New Caledonia'),
(332, 1, '__New Zealand'),
(333, 1, '__Nicaragua'),
(334, 1, '__Niger'),
(335, 1, '__Nigeria'),
(336, 1, '__Niue'),
(337, 1, '__Norfolk Island'),
(338, 1, '__Northern Mariana Islands'),
(339, 1, '__Norway'),
(340, 1, '__Norwegian'),
(341, 1, '__Oman'),
(342, 1, '__Pakistan'),
(343, 1, '__Palau'),
(344, 1, '__Palestinian Territory, Occupied'),
(345, 1, '__Panama'),
(346, 1, '__Papua New Guinea'),
(347, 1, '__Paraguay'),
(348, 1, '__Persian'),
(349, 1, '__Peru'),
(350, 1, '__Philippines'),
(351, 1, '__Pitcairn Islands'),
(352, 1, '__Poland'),
(353, 1, '__Polish'),
(354, 1, '__Portugal'),
(355, 1, '__Portuguese'),
(356, 1, '__Puerto Rico'),
(357, 1, '__Punjabi'),
(358, 1, '__Qatar'),
(359, 1, '__Reunion'),
(360, 1, '__Romania'),
(361, 1, '__Romanian'),
(362, 1, '__Russia'),
(363, 1, '__Russian'),
(364, 1, '__Rwanda'),
(365, 1, '__Saint Helena'),
(366, 1, '__Saint Kitts and Nevis'),
(367, 1, '__Saint Lucia'),
(368, 1, '__Saint Pierre and Miquelon'),
(369, 1, '__Saint Vincent and the Grenadines'),
(370, 1, '__Saint_Barthelemy'),
(371, 1, '__Saint_Martin_French_part'),
(372, 1, '__Samoa'),
(373, 1, '__San Marino'),
(374, 1, '__Sao Tome and Principe'),
(375, 1, '__Saudi Arabia'),
(376, 1, '__Senegal'),
(377, 1, '__Serbia'),
(378, 1, '__Serbian'),
(379, 1, '__Seychelles'),
(380, 1, '__Sierra Leone'),
(381, 1, '__Singapore'),
(382, 1, '__Slovakia'),
(383, 1, '__Slovenia'),
(384, 1, '__Solomon Islands'),
(385, 1, '__Somalia'),
(386, 1, '__South Africa'),
(387, 1, '__South Georgia and the South Sandwich Islands'),
(388, 1, '__Spain'),
(389, 1, '__Spanish'),
(390, 1, '__Sri Lanka'),
(391, 1, '__Sudan'),
(392, 1, '__Suriname'),
(393, 1, '__Svalbard'),
(394, 1, '__Swaziland'),
(395, 1, '__Sweden'),
(396, 1, '__Swedish'),
(397, 1, '__Switzerland'),
(398, 1, '__Syria'),
(399, 1, '__Tagalog'),
(400, 1, '__Taiwan'),
(401, 1, '__Taiwanese'),
(402, 1, '__Tajikistan'),
(403, 1, '__Tamil'),
(404, 1, '__Tanzania'),
(405, 1, '__Telugu'),
(406, 1, '__Thai'),
(407, 1, '__Thailand'),
(408, 1, '__The Bahamas'),
(409, 1, '__The Gambia'),
(410, 1, '__Togo'),
(411, 1, '__Tokelau'),
(412, 1, '__Tonga'),
(413, 1, '__Tongan'),
(414, 1, '__Trinidad and Tobago'),
(415, 1, '__Tunisia'),
(416, 1, '__Turkey'),
(417, 1, '__Turkish'),
(418, 1, '__Turkmenistan'),
(419, 1, '__Turks and Caicos Islands'),
(420, 1, '__Tuvalu'),
(421, 1, '__Uganda'),
(422, 1, '__Ukraine'),
(423, 1, '__Ukrainian'),
(424, 1, '__United Arab Emirates'),
(425, 1, '__United Kingdom'),
(426, 1, '__United States'),
(427, 1, '__United States Minor Outlying Islands'),
(428, 1, '__Urdu'),
(429, 1, '__Uruguay'),
(430, 1, '__Uzbekistan'),
(431, 1, '__Vanuatu'),
(432, 1, '__Venezuela'),
(433, 1, '__Vietnam'),
(434, 1, '__Vietnamese'),
(435, 1, '__Virgin Islands'),
(436, 1, '__Visayan'),
(437, 1, '__Wallis and Futuna'),
(438, 1, '__Western Sahara'),
(439, 1, '__Yemen'),
(440, 1, '__Zambia'),
(441, 1, '__Zimbabwe'),
(442, 1, '__AUD'),
(443, 1, '__CAD'),
(444, 1, '__EUR'),
(445, 1, '__GBP'),
(446, 1, '__USD'),
(447, 1, '__YEN'),
(448, 1, '_adm_act_err_failed_page_loading'),
(449, 1, '_adm_action_cpt_checkout'),
(450, 1, '_adm_action_cpt_delete_all'),
(451, 1, '_adm_action_cpt_see_all'),
(452, 1, '_adm_admtools_Audit'),
(453, 1, '_adm_admtools_Current_level'),
(454, 1, '_adm_admtools_Desired_level'),
(455, 1, '_adm_admtools_Executable'),
(456, 1, '_adm_admtools_Non_Executable'),
(457, 1, '_adm_admtools_Non_Writable'),
(458, 1, '_adm_admtools_Not_Exists'),
(459, 1, '_adm_admtools_Path'),
(460, 1, '_adm_admtools_Permissions'),
(461, 1, '_adm_admtools_Writable'),
(462, 1, '_adm_admtools_title'),
(463, 1, '_adm_block_cpt_categories'),
(464, 1, '_adm_block_cpt_category'),
(465, 1, '_adm_block_cpt_checkout'),
(466, 1, '_adm_block_cpt_checkout_by_vendor_ccode'),
(467, 1, '_adm_block_cpt_checkout_by_vendor_csign'),
(468, 1, '_adm_block_cpt_downloaded_modules'),
(469, 1, '_adm_block_cpt_downloaded_updates'),
(470, 1, '_adm_block_cpt_featured'),
(471, 1, '_adm_block_cpt_goodies'),
(472, 1, '_adm_block_cpt_latest'),
(473, 1, '_adm_block_cpt_modules_upload'),
(474, 1, '_adm_block_cpt_popular'),
(475, 1, '_adm_block_cpt_purchases'),
(476, 1, '_adm_block_cpt_search'),
(477, 1, '_adm_block_cpt_space'),
(478, 1, '_adm_block_cpt_tag'),
(479, 1, '_adm_block_cpt_tags'),
(480, 1, '_adm_block_cpt_updates'),
(481, 1, '_adm_block_cpt_versions'),
(482, 1, '_adm_bp_btn_add_block'),
(483, 1, '_adm_bp_btn_block_add'),
(484, 1, '_adm_bp_btn_block_cancel'),
(485, 1, '_adm_bp_btn_block_delete'),
(486, 1, '_adm_bp_btn_block_save'),
(487, 1, '_adm_bp_btn_create_new'),
(488, 1, '_adm_bp_btn_delete'),
(489, 1, '_adm_bp_btn_page_apply'),
(490, 1, '_adm_bp_btn_page_cancel'),
(491, 1, '_adm_bp_btn_page_create'),
(492, 1, '_adm_bp_btn_settings'),
(493, 1, '_adm_bp_btn_view_page'),
(494, 1, '_adm_bp_cpt_type_custom'),
(495, 1, '_adm_bp_cpt_type_modules'),
(496, 1, '_adm_bp_cpt_type_system'),
(497, 1, '_adm_bp_dsc_block_content_image_file'),
(498, 1, '_adm_bp_dsc_block_content_lang'),
(499, 1, '_adm_bp_dsc_block_content_raw'),
(500, 1, '_adm_bp_dsc_block_content_rss_length'),
(501, 1, '_adm_bp_dsc_block_content_rss_url'),
(502, 1, '_adm_bp_dsc_block_content_empty'),
(503, 1, '_adm_bp_dsc_block_title'),
(504, 1, '_adm_bp_dsc_block_visible_for_levels'),
(505, 1, '_adm_bp_dsc_page_cache_lifetime'),
(506, 1, '_adm_bp_dsc_page_inj_footer'),
(507, 1, '_adm_bp_dsc_page_inj_head'),
(508, 1, '_adm_bp_dsc_page_meta_description'),
(509, 1, '_adm_bp_dsc_page_meta_keywords'),
(510, 1, '_adm_bp_dsc_page_meta_robots'),
(511, 1, '_adm_bp_dsc_page_title'),
(512, 1, '_adm_bp_dsc_page_title_system'),
(513, 1, '_adm_bp_dsc_page_uri'),
(514, 1, '_adm_bp_dsc_page_url'),
(515, 1, '_adm_bp_dsc_page_visible_for_levels'),
(516, 1, '_adm_bp_err_block_added'),
(517, 1, '_adm_bp_err_block_delete'),
(518, 1, '_adm_bp_err_block_designbox'),
(519, 1, '_adm_bp_err_block_edit'),
(520, 1, '_adm_bp_err_block_not_deletable'),
(521, 1, '_adm_bp_err_block_not_found'),
(522, 1, '_adm_bp_err_block_title'),
(523, 1, '_adm_bp_err_cannot_process_action'),
(524, 1, '_adm_bp_err_nothing_changed'),
(525, 1, '_adm_bp_err_page_create'),
(526, 1, '_adm_bp_err_page_delete'),
(527, 1, '_adm_bp_err_page_layout'),
(528, 1, '_adm_bp_err_page_title'),
(529, 1, '_adm_bp_err_page_title_system'),
(530, 1, '_adm_bp_err_page_uri'),
(531, 1, '_adm_bp_err_page_visible_for_levels'),
(532, 1, '_adm_bp_err_save'),
(533, 1, '_adm_bp_mi_page_cache'),
(534, 1, '_adm_bp_mi_page_cover'),
(535, 1, '_adm_bp_mi_page_injections'),
(536, 1, '_adm_bp_mi_page_layout'),
(537, 1, '_adm_bp_mi_page_options'),
(538, 1, '_adm_bp_mi_page_seo'),
(539, 1, '_adm_bp_mi_page_visibility'),
(540, 1, '_adm_bp_scs_save'),
(541, 1, '_adm_bp_txt_block_active'),
(542, 1, '_adm_bp_txt_block_active_api'),
(543, 1, '_adm_bp_txt_block_async'),
(544, 1, '_adm_bp_txt_block_cache_lifetime'),
(545, 1, '_adm_bp_txt_block_content_attachments_html'),
(546, 1, '_adm_bp_txt_block_content_image_align'),
(547, 1, '_adm_bp_txt_block_content_image_align_center'),
(548, 1, '_adm_bp_txt_block_content_image_align_empty'),
(549, 1, '_adm_bp_txt_block_content_image_align_left'),
(550, 1, '_adm_bp_txt_block_content_image_align_right'),
(551, 1, '_adm_bp_txt_block_content_image_file'),
(552, 1, '_adm_bp_txt_block_content_lang'),
(553, 1, '_adm_bp_txt_block_content_menu'),
(554, 1, '_adm_bp_txt_block_content_menu_empty'),
(555, 1, '_adm_bp_txt_block_content_raw'),
(556, 1, '_adm_bp_txt_block_content_rss_length'),
(557, 1, '_adm_bp_txt_block_content_rss_url'),
(558, 1, '_adm_bp_txt_block_content_service_method'),
(559, 1, '_adm_bp_txt_block_content_service_module'),
(560, 1, '_adm_bp_txt_block_content_empty'),
(561, 1, '_adm_bp_txt_block_designbox'),
(562, 1, '_adm_bp_txt_block_designbox_empty'),
(563, 1, '_adm_bp_txt_block_class'),
(564, 1, '_adm_bp_txt_block_help'),
(565, 1, '_adm_bp_txt_block_hidden_on'),
(566, 1, '_adm_bp_txt_block_hidden_on_phone'),
(567, 1, '_adm_bp_txt_block_hidden_on_tablet'),
(568, 1, '_adm_bp_txt_block_hidden_on_desktop'),
(569, 1, '_adm_bp_txt_block_hidden_on_mobile'),
(570, 1, '_adm_bp_txt_block_selected'),
(571, 1, '_adm_bp_txt_block_submenu'),
(572, 1, '_adm_bp_txt_block_tabs'),
(573, 1, '_adm_bp_txt_block_title'),
(574, 1, '_adm_bp_txt_block_visible_for'),
(575, 1, '_adm_bp_txt_block_visible_for_all'),
(576, 1, '_adm_bp_txt_block_visible_for_levels'),
(577, 1, '_adm_bp_txt_block_visible_for_selected'),
(578, 1, '_adm_bp_txt_create_popup'),
(579, 1, '_adm_bp_txt_edit_block_popup'),
(580, 1, '_adm_bp_txt_new_block_popup'),
(581, 1, '_adm_bp_txt_page_cache_lifetime'),
(582, 1, '_adm_bp_txt_page_cover'),
(583, 1, '_adm_bp_txt_page_cover_image'),
(584, 1, '_adm_bp_txt_page_cover_title'),
(585, 1, '_adm_bp_txt_page_cover_0'),
(586, 1, '_adm_bp_txt_page_cover_1'),
(587, 1, '_adm_bp_txt_page_cover_2'),
(588, 1, '_adm_bp_txt_page_cover_3'),
(589, 1, '_adm_bp_txt_page_inj_footer'),
(590, 1, '_adm_bp_txt_page_inj_head'),
(591, 1, '_adm_bp_txt_page_layout'),
(592, 1, '_adm_bp_txt_page_layout_empty'),
(593, 1, '_adm_bp_txt_page_meta_description'),
(594, 1, '_adm_bp_txt_page_meta_keywords'),
(595, 1, '_adm_bp_txt_page_meta_title'),
(596, 1, '_adm_bp_txt_page_meta_robots'),
(597, 1, '_adm_bp_txt_page_submenu'),
(598, 1, '_adm_bp_dsc_page_submenu'),
(599, 1, '_adm_bp_txt_page_title'),
(600, 1, '_adm_bp_txt_page_title_system'),
(601, 1, '_adm_bp_txt_page_type_id'),
(602, 1, '_adm_bp_dsc_page_type_id'),
(603, 1, '_adm_bp_txt_page_uri'),
(604, 1, '_adm_bp_txt_page_url'),
(605, 1, '_adm_bp_txt_page_visible_for_levels'),
(606, 1, '_adm_bp_txt_page_sticky_columns'),
(607, 1, '_adm_bp_txt_select_page'),
(608, 1, '_adm_bp_txt_settings_popup'),
(609, 1, '_adm_bp_txt_visible_for'),
(610, 1, '_adm_bp_wrn_page_delete'),
(611, 1, '_adm_bp_wrn_page_block_delete'),
(612, 1, '_adm_bp_txt_inactive_blocks'),
(613, 1, '_adm_btn_cancel_submit'),
(614, 1, '_adm_btn_checkout_submit'),
(615, 1, '_adm_btn_delete_submit'),
(616, 1, '_adm_btn_designer_submit'),
(617, 1, '_adm_btn_download_submit'),
(618, 1, '_adm_btn_install_submit'),
(619, 1, '_adm_btn_installed_submit'),
(620, 1, '_adm_btn_login_submit'),
(621, 1, '_adm_btn_queued_submit'),
(622, 1, '_adm_btn_settings_export'),
(623, 1, '_adm_btn_settings_import'),
(624, 1, '_adm_btn_settings_save'),
(625, 1, '_adm_btn_settings_mix_create'),
(626, 1, '_adm_btn_settings_mix_import'),
(627, 1, '_adm_btn_settings_mix_export'),
(628, 1, '_adm_btn_settings_mix_delete'),
(629, 1, '_adm_btn_settings_mix_hide'),
(630, 1, '_adm_btn_settings_mix_publish'),
(631, 1, '_adm_btn_store_search'),
(632, 1, '_adm_dbd_btn_update'),
(633, 1, '_adm_dbd_txt_available'),
(634, 1, '_adm_dbd_txt_installed'),
(635, 1, '_adm_dbd_txt_updated'),
(636, 1, '_adm_dbd_msg_upgrade_started'),
(637, 1, '_adm_dbd_txt_su_database'),
(638, 1, '_adm_dbd_txt_su_system'),
(639, 1, '_adm_dbd_txt_su_system_media'),
(640, 1, '_adm_dbd_txt_c_select'),
(641, 1, '_adm_dbd_txt_c_clear_all'),
(642, 1, '_adm_dbd_txt_c_db'),
(643, 1, '_adm_dbd_txt_c_clear_db'),
(644, 1, '_adm_dbd_txt_c_template'),
(645, 1, '_adm_dbd_txt_c_clear_template'),
(646, 1, '_adm_dbd_txt_c_css'),
(647, 1, '_adm_dbd_txt_c_clear_css'),
(648, 1, '_adm_dbd_txt_c_less'),
(649, 1, '_adm_dbd_txt_c_clear_less'),
(650, 1, '_adm_dbd_txt_c_clear_purifier'),
(651, 1, '_adm_dbd_txt_c_js'),
(652, 1, '_adm_dbd_txt_c_clear_js'),
(653, 1, '_adm_dbd_txt_c_clear_custom'),
(654, 1, '_adm_dbd_txt_c_opcache'),
(655, 1, '_adm_dbd_txt_c_clear_opcache'),
(656, 1, '_adm_dbd_err_c_clean_failed'),
(657, 1, '_adm_dbd_err_c_clean_unsupported'),
(658, 1, '_adm_dbd_msg_c_clean_success'),
(659, 1, '_adm_dbd_msg_c_all_disabled'),
(660, 1, '_adm_dsn_cnf_uninstall'),
(661, 1, '_adm_dsg_btn_delete'),
(662, 1, '_adm_dsg_btn_make_default'),
(663, 1, '_adm_dsg_dsc_alt_text'),
(664, 1, '_adm_dsg_dsc_splash_warning'),
(665, 1, '_adm_dsg_err_cannot_process_action'),
(666, 1, '_adm_dsg_err_deactivate_default'),
(667, 1, '_adm_dsg_err_last_active'),
(668, 1, '_adm_dsg_err_make_default'),
(669, 1, '_adm_dsg_err_remove_old_cover'),
(670, 1, '_adm_dsg_err_remove_old_icon'),
(671, 1, '_adm_dsg_err_save'),
(672, 1, '_adm_dsg_err_save_changes'),
(673, 1, '_adm_dsg_scs_save'),
(674, 1, '_adm_dsg_txt_logo_redefinition'),
(675, 1, '_adm_dsg_txt_alt_text'),
(676, 1, '_adm_dsg_txt_cover_common'),
(677, 1, '_adm_dsg_txt_cover_unit_profile'),
(678, 1, '_adm_dsg_txt_cover_disabled'),
(679, 1, '_adm_dsg_txt_splash_enabled'),
(680, 1, '_adm_dsg_txt_default'),
(681, 1, '_adm_dsg_txt_icon'),
(682, 1, '_adm_dsg_txt_icon_svg'),
(683, 1, '_adm_dsg_txt_icon_apple'),
(684, 1, '_adm_dsg_txt_icon_android'),
(685, 1, '_adm_dsg_txt_icon_android_splash'),
(686, 1, '_adm_dsg_txt_upload_cover_common'),
(687, 1, '_adm_dsg_txt_upload_cover_unit_profile'),
(688, 1, '_adm_dsg_txt_upload_icon'),
(689, 1, '_adm_dsg_txt_upload_icon_inf'),
(690, 1, '_adm_dsg_txt_upload_icon_svg'),
(691, 1, '_adm_dsg_txt_upload_icon_svg_inf'),
(692, 1, '_adm_dsg_txt_upload_icon_apple'),
(693, 1, '_adm_dsg_txt_upload_icon_apple_inf'),
(694, 1, '_adm_dsg_txt_upload_icon_android'),
(695, 1, '_adm_dsg_txt_upload_icon_android_inf'),
(696, 1, '_adm_dsg_txt_upload_icon_android_splash'),
(697, 1, '_adm_dsg_txt_upload_icon_android_splash_inf'),
(698, 1, '_adm_dsg_txt_upload_logo'),
(699, 1, '_adm_dsg_txt_upload_logo_dark'),
(700, 1, '_adm_dsg_txt_upload_logo_inline'),
(701, 1, '_adm_dsg_txt_upload_mark'),
(702, 1, '_adm_dsg_txt_upload_mark_dark'),
(703, 1, '_adm_dsg_txt_upload_mark_inline'),
(704, 1, '_adm_dsg_txt_inj_head'),
(705, 1, '_adm_dsg_txt_inj_head_inf'),
(706, 1, '_adm_dsg_txt_inj_body'),
(707, 1, '_adm_dsg_txt_inj_body_inf'),
(708, 1, '_adm_err_cannot_process_action'),
(709, 1, '_adm_err_modules_already_disabled'),
(710, 1, '_adm_err_modules_already_enabled'),
(711, 1, '_adm_err_modules_already_installed'),
(712, 1, '_adm_err_modules_already_uninstalled'),
(713, 1, '_adm_err_modules_cannot_add_to_cart'),
(714, 1, '_adm_err_modules_cannot_checkout_empty_vendor'),
(715, 1, '_adm_err_modules_cannot_delete_from_cart'),
(716, 1, '_adm_err_modules_cannot_remove_package'),
(717, 1, '_adm_err_modules_cannot_subscribe'),
(718, 1, '_adm_err_modules_module_not_found'),
(719, 1, '_adm_err_modules_module_not_match'),
(720, 1, '_adm_err_modules_module_not_installed'),
(721, 1, '_adm_err_modules_module_was_modified'),
(722, 1, '_adm_err_modules_pending_uninstall'),
(723, 1, '_adm_err_modules_pending_uninstall_already'),
(724, 1, '_adm_err_modules_process_action_failed'),
(725, 1, '_adm_err_modules_wrong_dependency_disable'),
(726, 1, '_adm_err_modules_wrong_dependency_install'),
(727, 1, '_adm_err_modules_wrong_dependency_uninstall'),
(728, 1, '_adm_err_modules_wrong_mysql_query'),
(729, 1, '_adm_err_modules_wrong_mysql_query_msg'),
(730, 1, '_adm_err_modules_wrong_permissions_change'),
(731, 1, '_adm_err_modules_wrong_permissions_check'),
(732, 1, '_adm_err_modules_wrong_permissions_msg'),
(733, 1, '_adm_err_modules_wrong_version'),
(734, 1, '_adm_err_modules_wrong_version_script'),
(735, 1, '_adm_err_modules_wrong_version_script_update'),
(736, 1, '_adm_err_oauth_cannot_get_token'),
(737, 1, '_adm_err_oauth_cannot_read_answer'),
(738, 1, '_adm_err_oauth_empty_key_secret'),
(739, 1, '_adm_err_operation_failed'),
(740, 1, '_adm_form_btn_displays_cancel'),
(741, 1, '_adm_form_btn_displays_edit'),
(742, 1, '_adm_form_btn_displays_save'),
(743, 1, '_adm_form_btn_field_add'),
(744, 1, '_adm_form_btn_field_cancel'),
(745, 1, '_adm_form_btn_field_delete'),
(746, 1, '_adm_form_btn_field_edit'),
(747, 1, '_adm_form_btn_field_save'),
(748, 1, '_adm_form_btn_fields_create'),
(749, 1, '_adm_form_btn_fields_visible'),
(750, 1, '_adm_form_btn_forms_cancel'),
(751, 1, '_adm_form_btn_forms_edit'),
(752, 1, '_adm_form_btn_forms_save'),
(753, 1, '_adm_form_btn_categories_cancel'),
(754, 1, '_adm_form_btn_categories_submit'),
(755, 1, '_adm_form_btn_labels_add'),
(756, 1, '_adm_form_btn_labels_back'),
(757, 1, '_adm_form_btn_labels_cancel'),
(758, 1, '_adm_form_btn_labels_submit'),
(759, 1, '_adm_form_btn_badges_add'),
(760, 1, '_adm_form_btn_badges_delete'),
(761, 1, '_adm_form_btn_categories_add'),
(762, 1, '_adm_form_btn_categories_delete'),
(763, 1, '_adm_form_btn_pre_lists_add'),
(764, 1, '_adm_form_btn_pre_lists_cancel'),
(765, 1, '_adm_form_btn_pre_lists_create'),
(766, 1, '_adm_form_btn_pre_lists_delete'),
(767, 1, '_adm_form_btn_pre_lists_edit'),
(768, 1, '_adm_form_btn_pre_lists_save'),
(769, 1, '_adm_form_btn_pre_values_add'),
(770, 1, '_adm_form_btn_pre_values_cancel'),
(771, 1, '_adm_form_btn_pre_values_delete'),
(772, 1, '_adm_form_btn_pre_values_create'),
(773, 1, '_adm_form_btn_pre_values_delete_item'),
(774, 1, '_adm_form_btn_pre_values_edit_item'),
(775, 1, '_adm_form_btn_reports_check_in'),
(776, 1, '_adm_form_btn_reports_check_out'),
(777, 1, '_adm_form_btn_reports_audit'),
(778, 1, '_adm_form_btn_reports_hide'),
(779, 1, '_adm_form_btn_reports_unhide'),
(780, 1, '_adm_form_btn_search_forms_edit'),
(781, 1, '_adm_form_btn_search_forms_fields_edit'),
(782, 1, '_adm_form_btn_search_forms_fields_reset'),
(783, 1, '_adm_form_btn_search_forms_sortable_fields_reset'),
(784, 1, '_adm_form_btn_search_forms_save'),
(785, 1, '_adm_form_btn_search_forms_cancel'),
(786, 1, '_adm_form_dsc_displays_title'),
(787, 1, '_adm_form_dsc_field_attrs_max'),
(788, 1, '_adm_form_dsc_field_attrs_min'),
(789, 1, '_adm_form_dsc_field_attrs_src'),
(790, 1, '_adm_form_dsc_field_attrs_step'),
(791, 1, '_adm_form_dsc_field_caption'),
(792, 1, '_adm_form_dsc_field_caption_block_header'),
(793, 1, '_adm_form_dsc_field_caption_system'),
(794, 1, '_adm_form_dsc_field_checker_error_captcha'),
(795, 1, '_adm_form_dsc_field_checker_params_preg'),
(796, 1, '_adm_form_dsc_field_collapsed'),
(797, 1, '_adm_form_dsc_field_html'),
(798, 1, '_adm_form_dsc_field_icon'),
(799, 1, '_adm_form_dsc_field_info'),
(800, 1, '_adm_form_dsc_field_help'),
(801, 1, '_adm_form_dsc_field_privacy'),
(802, 1, '_adm_form_dsc_field_rateable'),
(803, 1, '_adm_form_dsc_field_required'),
(804, 1, '_adm_form_dsc_field_unique'),
(805, 1, '_adm_form_dsc_field_value_button'),
(806, 1, '_adm_form_dsc_field_value_checkbox'),
(807, 1, '_adm_form_dsc_field_value_reset'),
(808, 1, '_adm_form_dsc_field_value_submit'),
(809, 1, '_adm_form_dsc_field_visible_for_levels'),
(810, 1, '_adm_form_dsc_field_db_pass'),
(811, 1, '_adm_form_dsc_forms_title'),
(812, 1, '_adm_form_dsc_pre_lists_title'),
(813, 1, '_adm_form_dsc_pre_values_empty'),
(814, 1, '_adm_form_dsc_pre_values_lkey'),
(815, 1, '_adm_form_dsc_search_forms_fields_search_type'),
(816, 1, '_adm_form_dsc_search_forms_title'),
(817, 1, '_adm_form_err_cannot_process_action'),
(818, 1, '_adm_form_err_displays_edit'),
(819, 1, '_adm_form_err_displays_title'),
(820, 1, '_adm_form_err_field_add'),
(821, 1, '_adm_form_err_field_add_already_exists'),
(822, 1, '_adm_form_err_field_add_not_allowed'),
(823, 1, '_adm_form_err_field_select_nested_form'),
(824, 1, '_adm_form_err_field_caption'),
(825, 1, '_adm_form_err_field_caption_system'),
(826, 1, '_adm_form_err_field_checker_error'),
(827, 1, '_adm_form_err_field_checker_func'),
(828, 1, '_adm_form_err_field_checker_params_length_max'),
(829, 1, '_adm_form_err_field_checker_params_length_min'),
(830, 1, '_adm_form_err_field_checker_params_preg'),
(831, 1, '_adm_form_err_field_edit'),
(832, 1, '_adm_form_err_field_show_to'),
(833, 1, '_adm_form_err_field_value_doublerange'),
(834, 1, '_adm_form_err_field_value_number'),
(835, 1, '_adm_form_err_field_values'),
(836, 1, '_adm_form_err_forms_edit'),
(837, 1, '_adm_form_err_forms_title'),
(838, 1, '_adm_form_err_labels_add'),
(839, 1, '_adm_form_err_labels_edit'),
(840, 1, '_adm_form_err_labels_value'),
(841, 1, '_adm_form_err_missing_params'),
(842, 1, '_adm_form_err_pre_lists_create'),
(843, 1, '_adm_form_err_pre_lists_edit'),
(844, 1, '_adm_form_err_pre_lists_title'),
(845, 1, '_adm_form_err_pre_values_create'),
(846, 1, '_adm_form_err_pre_values_create_forbidden'),
(847, 1, '_adm_form_err_pre_values_delete'),
(848, 1, '_adm_form_err_pre_values_edit'),
(849, 1, '_adm_form_err_pre_values_lkey'),
(850, 1, '_adm_form_err_search_forms_essential'),
(851, 1, '_adm_form_err_search_forms_fields_edit'),
(852, 1, '_adm_from_err_search_forms_fields_reset'),
(853, 1, '_adm_from_err_search_forms_sortable_fields_reset'),
(854, 1, '_adm_form_err_search_forms_edit'),
(855, 1, '_adm_form_err_search_forms_title'),
(856, 1, '_adm_form_txt_all_modules'),
(857, 1, '_adm_form_txt_confirm_delete'),
(858, 1, '_adm_form_txt_audit_added'),
(859, 1, '_adm_form_txt_audit_profile'),
(860, 1, '_adm_form_txt_audit_content'),
(861, 1, '_adm_form_txt_audit_module'),
(862, 1, '_adm_form_txt_audit_author_content'),
(863, 1, '_adm_pgt_txt_audit_context'),
(864, 1, '_adm_pgt_txt_audit_action'),
(865, 1, '_adm_form_txt_badges_text'),
(866, 1, '_adm_form_txt_badges_view'),
(867, 1, '_adm_form_txt_badges_fontcolor'),
(868, 1, '_adm_form_txt_badges_color'),
(869, 1, '_adm_form_dsc_badges_color'),
(870, 1, '_adm_form_txt_badges_is_icon_only'),
(871, 1, '_adm_form_txt_badges_btn_current_icon_image_delete'),
(872, 1, '_adm_form_txt_badges_icon'),
(873, 1, '_adm_form_txt_badges_icon_image'),
(874, 1, '_adm_form_txt_badges_icon_image_new'),
(875, 1, '_adm_form_txt_badges_icon_image_old'),
(876, 1, '_adm_form_dsc_badges_icon'),
(877, 1, '_adm_form_dsc_badges_items_icon_image_current'),
(878, 1, '_adm_form_dsc_badges_icon_image'),
(879, 1, '_adm_form_dsc_badges_icon_image_current'),
(880, 1, '_adm_form_err_badges_icon'),
(881, 1, '_adm_form_err_badges_icon_image'),
(882, 1, '_adm_form_err_badges_icon_image_remove'),
(883, 1, '_adm_form_btn_badges_submit'),
(884, 1, '_adm_form_btn_badges_cancel'),
(885, 1, '_adm_form_txt_badges_added'),
(886, 1, '_adm_form_txt_badges_module'),
(887, 1, '_adm_form_txt_badges_add_popup'),
(888, 1, '_adm_form_txt_badges_edit_popup'),
(889, 1, '_adm_pgt_txt_badges_text'),
(890, 1, '_adm_pgt_txt_badges_icon'),
(891, 1, '_adm_form_txt_reports_object'),
(892, 1, '_adm_form_txt_reports_author'),
(893, 1, '_adm_form_txt_reports_type'),
(894, 1, '_adm_form_txt_reports_text'),
(895, 1, '_adm_form_txt_reports_date'),
(896, 1, '_adm_form_txt_reports_status'),
(897, 1, '_adm_form_txt_reports_checked_by'),
(898, 1, '_adm_form_txt_reports_notes'),
(899, 1, '_adm_form_txt_reports_comments'),
(900, 1, '_adm_form_txt_reports_action'),
(901, 1, '_adm_form_txt_displays_edit_popup'),
(902, 1, '_adm_form_txt_displays_gl_fields'),
(903, 1, '_adm_form_txt_displays_gl_form'),
(904, 1, '_adm_form_txt_displays_gl_module'),
(905, 1, '_adm_form_txt_displays_gl_title'),
(906, 1, '_adm_form_txt_displays_manage_fields'),
(907, 1, '_adm_form_txt_displays_title'),
(908, 1, '_adm_form_txt_field_add_popup'),
(909, 1, '_adm_form_txt_field_attrs_max'),
(910, 1, '_adm_form_txt_field_attrs_min'),
(911, 1, '_adm_form_txt_field_attrs_src'),
(912, 1, '_adm_form_txt_field_attrs_step'),
(913, 1, '_adm_form_txt_field_caption'),
(914, 1, '_adm_form_txt_field_caption_system'),
(915, 1, '_adm_form_txt_field_checked'),
(916, 1, '_adm_form_txt_field_checked_switcher'),
(917, 1, '_adm_form_txt_field_checker_avail'),
(918, 1, '_adm_form_txt_field_checker_captcha'),
(919, 1, '_adm_form_txt_field_checker_custom'),
(920, 1, '_adm_form_txt_field_checker_date'),
(921, 1, '_adm_form_txt_field_checker_date_range'),
(922, 1, '_adm_form_txt_field_checker_date_time'),
(923, 1, '_adm_form_txt_field_checker_email'),
(924, 1, '_adm_form_txt_field_checker_empty'),
(925, 1, '_adm_form_txt_field_checker_error'),
(926, 1, '_adm_form_txt_field_checker_func'),
(927, 1, '_adm_form_txt_field_checker_func_info_custom'),
(928, 1, '_adm_form_txt_field_checker_length'),
(929, 1, '_adm_form_txt_field_checker_location'),
(930, 1, '_adm_form_txt_field_checker_no_spam'),
(931, 1, '_adm_form_txt_field_checker_params_length_max'),
(932, 1, '_adm_form_txt_field_checker_params_length_min'),
(933, 1, '_adm_form_txt_field_checker_params_required'),
(934, 1, '_adm_form_txt_field_checker_params_preg'),
(935, 1, '_adm_form_txt_field_checker_preg'),
(936, 1, '_adm_form_txt_field_collapsed'),
(937, 1, '_adm_form_txt_field_edit_popup'),
(938, 1, '_adm_form_txt_field_html'),
(939, 1, '_adm_form_txt_field_html_full'),
(940, 1, '_adm_form_txt_field_html_mini'),
(941, 1, '_adm_form_txt_field_html_none'),
(942, 1, '_adm_form_txt_field_html_standard'),
(943, 1, '_adm_form_txt_field_icon'),
(944, 1, '_adm_form_txt_field_icon_preview'),
(945, 1, '_adm_form_txt_field_info'),
(946, 1, '_adm_form_txt_field_help'),
(947, 1, '_adm_form_txt_field_module'),
(948, 1, '_adm_form_txt_field_name'),
(949, 1, '_adm_form_txt_field_object'),
(950, 1, '_adm_form_txt_field_privacy'),
(951, 1, '_adm_form_txt_field_rateable'),
(952, 1, '_adm_form_txt_field_rateable_value_non'),
(953, 1, '_adm_form_txt_field_rateable_value_votes'),
(954, 1, '_adm_form_txt_field_rateable_value_reactions'),
(955, 1, '_adm_form_txt_field_required'),
(956, 1, '_adm_form_txt_field_select_nested_form'),
(957, 1, '_adm_form_txt_field_show_to_popup'),
(958, 1, '_adm_form_txt_field_type_block_end'),
(959, 1, '_adm_form_txt_field_type_block_header'),
(960, 1, '_adm_form_txt_field_type_button'),
(961, 1, '_adm_form_txt_field_type_captcha'),
(962, 1, '_adm_form_txt_field_type_checkbox'),
(963, 1, '_adm_form_txt_field_type_checkbox_set'),
(964, 1, '_adm_form_txt_field_type_custom'),
(965, 1, '_adm_form_txt_field_type_datepicker'),
(966, 1, '_adm_form_txt_field_type_dateselect'),
(967, 1, '_adm_form_txt_field_type_datepicker_range'),
(968, 1, '_adm_form_txt_field_type_datepicker_range_age'),
(969, 1, '_adm_form_txt_field_type_datetime'),
(970, 1, '_adm_form_txt_field_type_datetime_range'),
(971, 1, '_adm_form_txt_field_type_datetime_range_age'),
(972, 1, '_adm_form_txt_field_type_display'),
(973, 1, '_adm_form_txt_field_type_doublerange'),
(974, 1, '_adm_form_txt_field_type_file'),
(975, 1, '_adm_form_txt_field_type_files'),
(976, 1, '_adm_form_txt_field_type_hidden'),
(977, 1, '_adm_form_txt_field_type_image'),
(978, 1, '_adm_form_txt_field_type_input_set'),
(979, 1, '_adm_form_txt_field_type_location'),
(980, 1, '_adm_form_txt_field_type_location_radius'),
(981, 1, '_adm_form_txt_field_type_number'),
(982, 1, '_adm_form_txt_field_type_price'),
(983, 1, '_adm_form_txt_field_type_password'),
(984, 1, '_adm_form_txt_field_type_radio_set'),
(985, 1, '_adm_form_txt_field_type_reset'),
(986, 1, '_adm_form_txt_field_type_select'),
(987, 1, '_adm_form_txt_field_type_select_multiple'),
(988, 1, '_adm_form_txt_field_type_slider'),
(989, 1, '_adm_form_txt_field_type_submit'),
(990, 1, '_adm_form_txt_field_type_switcher'),
(991, 1, '_adm_form_txt_field_type_text'),
(992, 1, '_adm_form_txt_field_type_text_range'),
(993, 1, '_adm_form_txt_field_type_text_auto'),
(994, 1, '_adm_form_txt_field_type_textarea'),
(995, 1, '_adm_form_txt_field_type_time'),
(996, 1, '_adm_form_txt_field_type_value'),
(997, 1, '_adm_form_txt_field_type_nested_form'),
(998, 1, '_adm_form_txt_field_unique'),
(999, 1, '_adm_form_txt_field_value_button'),
(1000, 1, '_adm_form_txt_field_value_checkbox'),
(1001, 1, '_adm_form_txt_field_value_custom_text'),
(1002, 1, '_adm_form_txt_field_value_default'),
(1003, 1, '_adm_form_txt_field_value_files'),
(1004, 1, '_adm_form_txt_field_value_select_value'),
(1005, 1, '_adm_form_txt_field_values'),
(1006, 1, '_adm_form_txt_field_values_manage'),
(1007, 1, '_adm_form_txt_field_values_select_list'),
(1008, 1, '_adm_form_txt_field_visible_for'),
(1009, 1, '_adm_form_txt_field_visible_for_all'),
(1010, 1, '_adm_form_txt_field_visible_for_levels'),
(1011, 1, '_adm_form_txt_field_visible_for_selected'),
(1012, 1, '_adm_form_txt_field_db_pass'),
(1013, 1, '_adm_form_txt_field_db_pass_date'),
(1014, 1, '_adm_form_txt_field_db_pass_date_ts'),
(1015, 1, '_adm_form_txt_field_db_pass_date_utc'),
(1016, 1, '_adm_form_txt_field_db_pass_date_time'),
(1017, 1, '_adm_form_txt_field_db_pass_date_time_ts'),
(1018, 1, '_adm_form_txt_field_db_pass_date_time_utc'),
(1019, 1, '_adm_form_txt_field_db_pass_select_value'),
(1020, 1, '_adm_form_txt_fields_caption_system'),
(1021, 1, '_adm_form_txt_fields_manage_visibility'),
(1022, 1, '_adm_form_txt_fields_module'),
(1023, 1, '_adm_form_txt_fields_type'),
(1024, 1, '_adm_form_txt_fields_visible'),
(1025, 1, '_adm_form_txt_forms_edit_popup'),
(1026, 1, '_adm_form_txt_forms_gl_displays'),
(1027, 1, '_adm_form_txt_forms_gl_module'),
(1028, 1, '_adm_form_txt_forms_gl_title'),
(1029, 1, '_adm_form_txt_forms_manage_displays'),
(1030, 1, '_adm_form_txt_forms_n_displays'),
(1031, 1, '_adm_form_txt_forms_n_fields'),
(1032, 1, '_adm_form_txt_forms_title'),
(1033, 1, '_adm_form_txt_labels_add_popup'),
(1034, 1, '_adm_form_txt_labels_edit_popup'),
(1035, 1, '_adm_form_txt_labels_items'),
(1036, 1, '_adm_form_txt_labels_manage_items'),
(1037, 1, '_adm_form_txt_labels_n_items'),
(1038, 1, '_adm_form_txt_labels_parent'),
(1039, 1, '_adm_form_txt_labels_parent_empty'),
(1040, 1, '_adm_form_txt_labels_grandparent_label'),
(1041, 1, '_adm_form_txt_labels_parent_label'),
(1042, 1, '_adm_form_txt_labels_sibling_labels'),
(1043, 1, '_adm_form_txt_labels_value'),
(1044, 1, '_adm_form_txt_categories_author'),
(1045, 1, '_adm_form_txt_categories_added'),
(1046, 1, '_adm_form_txt_categories_module'),
(1047, 1, '_adm_form_txt_categories_value'),
(1048, 1, '_adm_form_txt_categories_add_popup'),
(1049, 1, '_adm_form_txt_categories_edit_popup'),
(1050, 1, '_adm_form_err_categories_value'),
(1051, 1, '_adm_form_txt_pre_lists_country'),
(1052, 1, '_adm_form_txt_pre_lists_create_popup'),
(1053, 1, '_adm_form_txt_pre_lists_edit_popup'),
(1054, 1, '_adm_form_txt_pre_lists_gl_module'),
(1055, 1, '_adm_form_txt_pre_lists_gl_title'),
(1056, 1, '_adm_form_txt_pre_lists_gl_use_for_sets'),
(1057, 1, '_adm_form_txt_pre_lists_gl_values'),
(1058, 1, '_adm_form_txt_pre_lists_language'),
(1059, 1, '_adm_form_txt_pre_lists_currency'),
(1060, 1, '_adm_form_txt_pre_lists_manage_values'),
(1061, 1, '_adm_form_txt_pre_lists_n_values'),
(1062, 1, '_adm_form_txt_pre_lists_no'),
(1063, 1, '_adm_form_txt_pre_lists_sex'),
(1064, 1, '_adm_form_txt_pre_lists_title'),
(1065, 1, '_adm_form_txt_pre_lists_yes'),
(1066, 1, '_adm_form_txt_pre_values_create_popup'),
(1067, 1, '_adm_form_txt_pre_values_edit_popup'),
(1068, 1, '_adm_form_txt_pre_values_empty'),
(1069, 1, '_adm_form_txt_pre_values_gl_lkey'),
(1070, 1, '_adm_form_txt_pre_values_lkey'),
(1071, 1, '_adm_form_txt_search_forms_edit_popup'),
(1072, 1, '_adm_form_txt_search_forms_fields'),
(1073, 1, '_adm_form_txt_search_forms_sortable_fields'),
(1074, 1, '_adm_form_txt_search_forms_fields_type'),
(1075, 1, '_adm_form_txt_search_forms_fields_caption'),
(1076, 1, '_adm_form_txt_search_forms_fields_info'),
(1077, 1, '_adm_form_txt_search_forms_fields_search_type'),
(1078, 1, '_adm_form_txt_search_forms_fields_select_object'),
(1079, 1, '_adm_form_txt_search_forms_fields_edit_popup'),
(1080, 1, '_adm_form_txt_search_forms_sortable_fields_caption'),
(1081, 1, '_adm_form_txt_search_forms_sortable_fields_direction'),
(1082, 1, '_adm_form_txt_search_forms_manage_fields'),
(1083, 1, '_adm_form_txt_search_forms_module'),
(1084, 1, '_adm_form_txt_search_forms_n_fields'),
(1085, 1, '_adm_form_txt_search_forms_title'),
(1086, 1, '_adm_form_txt_select_display'),
(1087, 1, '_adm_form_txt_select_form'),
(1088, 1, '_adm_form_txt_select_list'),
(1089, 1, '_adm_from_err_field_delete'),
(1090, 1, '_adm_from_err_pre_lists_delete'),
(1091, 1, '_adm_ipbl_Date_of_finish'),
(1092, 1, '_adm_ipbl_IP_Role'),
(1093, 1, '_adm_ipbl_Stored_members_caption'),
(1094, 1, '_adm_ipbl_Type0_desc'),
(1095, 1, '_adm_ipbl_Type1_desc'),
(1096, 1, '_adm_ipbl_Type2_desc'),
(1097, 1, '_adm_ipbl_sample'),
(1098, 1, '_adm_lang_cnf_uninstall'),
(1099, 1, '_adm_lmi_cpt_actions'),
(1100, 1, '_adm_lmi_cpt_api_config'),
(1101, 1, '_adm_lmi_cpt_assistants'),
(1102, 1, '_adm_lmi_cpt_automators'),
(1103, 1, '_adm_lmi_cpt_helpers'),
(1104, 1, '_adm_lmi_cpt_badges'),
(1105, 1, '_adm_lmi_cpt_categories'),
(1106, 1, '_adm_lmi_cpt_checkout'),
(1107, 1, '_adm_lmi_cpt_cover'),
(1108, 1, '_adm_lmi_cpt_search'),
(1109, 1, '_adm_lmi_cpt_search_forms'),
(1110, 1, '_adm_lmi_cpt_search_fields'),
(1111, 1, '_adm_lmi_cpt_search_sortable_fields'),
(1112, 1, '_adm_lmi_cpt_splash'),
(1113, 1, '_adm_lmi_cpt_displays'),
(1114, 1, '_adm_lmi_cpt_downloaded'),
(1115, 1, '_adm_lmi_cpt_etemplates_text'),
(1116, 1, '_adm_lmi_cpt_etemplates_html'),
(1117, 1, '_adm_lmi_cpt_featured'),
(1118, 1, '_adm_lmi_cpt_fields'),
(1119, 1, '_adm_lmi_cpt_files'),
(1120, 1, '_adm_lmi_cpt_forms'),
(1121, 1, '_adm_lmi_cpt_general'),
(1122, 1, '_adm_lmi_cpt_goodies'),
(1123, 1, '_adm_lmi_cpt_icon'),
(1124, 1, '_adm_lmi_cpt_injections'),
(1125, 1, '_adm_lmi_cpt_images'),
(1126, 1, '_adm_lmi_cpt_items'),
(1127, 1, '_adm_lmi_cpt_keys'),
(1128, 1, '_adm_lmi_cpt_pgt_settings'),
(1129, 1, '_adm_lmi_cpt_pgt_keys'),
(1130, 1, '_adm_lmi_cpt_labels'),
(1131, 1, '_adm_lmi_cpt_latest'),
(1132, 1, '_adm_lmi_cpt_levels'),
(1133, 1, '_adm_lmi_cpt_logo'),
(1134, 1, '_adm_lmi_cpt_menus'),
(1135, 1, '_adm_lmi_cpt_origins'),
(1136, 1, '_adm_lmi_cpt_pre_lists'),
(1137, 1, '_adm_lmi_cpt_pre_values'),
(1138, 1, '_adm_lmi_cpt_providers'),
(1139, 1, '_adm_lmi_cpt_popular'),
(1140, 1, '_adm_lmi_cpt_purchases'),
(1141, 1, '_adm_lmi_cpt_pwa'),
(1142, 1, '_adm_lmi_cpt_ractions'),
(1143, 1, '_adm_lmi_cpt_reports'),
(1144, 1, '_adm_lmi_cpt_rlevels'),
(1145, 1, '_adm_lmi_cpt_sets'),
(1146, 1, '_adm_lmi_cpt_settings'),
(1147, 1, '_adm_lmi_cpt_updates'),
(1148, 1, '_adm_mobile_page_homepage'),
(1149, 1, '_adm_mobile_page_profile'),
(1150, 1, '_adm_mod_cnf_uninstall'),
(1151, 1, '_adm_mod_err_cannot_process_action'),
(1152, 1, '_adm_mod_err_only_admin_can_perform_operations_with_modules'),
(1153, 1, '_adm_mod_err_process_operation_failed'),
(1154, 1, '_adm_mod_msg_process_operation_scheduled'),
(1155, 1, '_adm_msg_modules_success_added_to_cart'),
(1156, 1, '_adm_msg_modules_success_checkouted'),
(1157, 1, '_adm_msg_modules_success_delete'),
(1158, 1, '_adm_msg_modules_success_disable'),
(1159, 1, '_adm_msg_modules_success_enable'),
(1160, 1, '_adm_msg_modules_success_install'),
(1161, 1, '_adm_msg_modules_success_uninstall'),
(1162, 1, '_adm_msg_oauth_need_authorize'),
(1163, 1, '_adm_msg_oauth_non_owner_logged'),
(1164, 1, '_adm_nav_btn_current_icon_image_delete'),
(1165, 1, '_adm_nav_btn_items_add'),
(1166, 1, '_adm_nav_btn_items_cancel'),
(1167, 1, '_adm_nav_btn_items_delete'),
(1168, 1, '_adm_nav_btn_items_done'),
(1169, 1, '_adm_nav_btn_items_edit'),
(1170, 1, '_adm_nav_btn_items_gl_create'),
(1171, 1, '_adm_nav_btn_items_gl_import'),
(1172, 1, '_adm_nav_btn_items_gl_visible'),
(1173, 1, '_adm_nav_btn_items_import'),
(1174, 1, '_adm_nav_btn_items_save'),
(1175, 1, '_adm_nav_btn_menus_add'),
(1176, 1, '_adm_nav_btn_menus_cancel'),
(1177, 1, '_adm_nav_btn_menus_create'),
(1178, 1, '_adm_nav_btn_menus_delete'),
(1179, 1, '_adm_nav_btn_menus_edit'),
(1180, 1, '_adm_nav_btn_menus_save'),
(1181, 1, '_adm_nav_btn_sets_add'),
(1182, 1, '_adm_nav_btn_sets_cancel'),
(1183, 1, '_adm_nav_btn_sets_create'),
(1184, 1, '_adm_nav_btn_sets_delete'),
(1185, 1, '_adm_nav_btn_sets_edit'),
(1186, 1, '_adm_nav_dsc_items_icon'),
(1187, 1, '_adm_nav_dsc_items_icon_image'),
(1188, 1, '_adm_nav_dsc_items_icon_image_current'),
(1189, 1, '_adm_nav_dsc_items_link'),
(1190, 1, '_adm_nav_dsc_items_onclick'),
(1191, 1, '_adm_nav_dsc_items_parent_id'),
(1192, 1, '_adm_nav_dsc_items_submenu'),
(1193, 1, '_adm_nav_dsc_items_target'),
(1194, 1, '_adm_nav_dsc_items_title'),
(1195, 1, '_adm_nav_dsc_items_title_system'),
(1196, 1, '_adm_nav_dsc_items_visible_for_levels'),
(1197, 1, '_adm_nav_dsc_menus_persistent'),
(1198, 1, '_adm_nav_dsc_menus_set_name'),
(1199, 1, '_adm_nav_dsc_menus_set_title'),
(1200, 1, '_adm_nav_dsc_menus_style'),
(1201, 1, '_adm_nav_dsc_menus_title'),
(1202, 1, '_adm_nav_dsc_sets_title'),
(1203, 1, '_adm_nav_err_cannot_process_action'),
(1204, 1, '_adm_nav_err_items_create'),
(1205, 1, '_adm_nav_err_items_delete'),
(1206, 1, '_adm_nav_err_items_edit'),
(1207, 1, '_adm_nav_err_items_icon'),
(1208, 1, '_adm_nav_err_items_icon_image'),
(1209, 1, '_adm_nav_err_items_icon_image_remove'),
(1210, 1, '_adm_nav_err_items_import'),
(1211, 1, '_adm_nav_err_items_link'),
(1212, 1, '_adm_nav_err_items_onclick'),
(1213, 1, '_adm_nav_err_items_show_to'),
(1214, 1, '_adm_nav_err_menus_create'),
(1215, 1, '_adm_nav_err_menus_delete'),
(1216, 1, '_adm_nav_err_menus_edit'),
(1217, 1, '_adm_nav_err_menus_set_name'),
(1218, 1, '_adm_nav_err_menus_set_title'),
(1219, 1, '_adm_nav_err_menus_style'),
(1220, 1, '_adm_nav_err_menus_title'),
(1221, 1, '_adm_nav_err_missing_params'),
(1222, 1, '_adm_nav_err_sets_create'),
(1223, 1, '_adm_nav_err_sets_delete'),
(1224, 1, '_adm_nav_err_sets_delete_used'),
(1225, 1, '_adm_nav_err_sets_edit'),
(1226, 1, '_adm_nav_err_sets_title'),
(1227, 1, '_adm_nav_txt_all_modules'),
(1228, 1, '_adm_nav_txt_items_collapsed'),
(1229, 1, '_adm_nav_txt_items_create_popup'),
(1230, 1, '_adm_nav_txt_items_edit_popup'),
(1231, 1, '_adm_nav_txt_items_gl_icon'),
(1232, 1, '_adm_nav_txt_items_gl_link'),
(1233, 1, '_adm_nav_txt_items_gl_link_custom'),
(1234, 1, '_adm_nav_txt_items_gl_link_menu'),
(1235, 1, '_adm_nav_txt_items_gl_link_subitems'),
(1236, 1, '_adm_nav_txt_items_gl_module'),
(1237, 1, '_adm_nav_txt_items_gl_title_system'),
(1238, 1, '_adm_nav_txt_items_gl_visible'),
(1239, 1, '_adm_nav_txt_items_icon'),
(1240, 1, '_adm_nav_txt_items_icon_image'),
(1241, 1, '_adm_nav_txt_items_icon_image_new'),
(1242, 1, '_adm_nav_txt_items_icon_image_old'),
(1243, 1, '_adm_nav_txt_items_import_popup'),
(1244, 1, '_adm_nav_txt_items_link'),
(1245, 1, '_adm_nav_txt_items_onclick'),
(1246, 1, '_adm_nav_txt_items_parent_id'),
(1247, 1, '_adm_nav_txt_items_parent_id_empty'),
(1248, 1, '_adm_nav_txt_items_primary'),
(1249, 1, '_adm_nav_txt_items_active_api'),
(1250, 1, '_adm_nav_txt_items_show_to_popup'),
(1251, 1, '_adm_nav_txt_items_submenu'),
(1252, 1, '_adm_nav_txt_items_submenu_empty'),
(1253, 1, '_adm_nav_txt_items_submenu_popup'),
(1254, 1, '_adm_nav_txt_items_target'),
(1255, 1, '_adm_nav_txt_items_target_blank'),
(1256, 1, '_adm_nav_txt_items_target_self'),
(1257, 1, '_adm_nav_txt_items_title'),
(1258, 1, '_adm_nav_txt_items_title_system'),
(1259, 1, '_adm_nav_txt_items_visible_for'),
(1260, 1, '_adm_nav_txt_items_visible_for_all'),
(1261, 1, '_adm_nav_txt_items_visible_for_levels'),
(1262, 1, '_adm_nav_txt_items_visible_for_selected'),
(1263, 1, '_adm_nav_txt_manage_items'),
(1264, 1, '_adm_nav_txt_manage_visibility'),
(1265, 1, '_adm_nav_txt_menus_create_popup'),
(1266, 1, '_adm_nav_txt_menus_edit_popup'),
(1267, 1, '_adm_nav_txt_menus_gl_items'),
(1268, 1, '_adm_nav_txt_menus_gl_module'),
(1269, 1, '_adm_nav_txt_menus_gl_set_title'),
(1270, 1, '_adm_nav_txt_menus_gl_template_title'),
(1271, 1, '_adm_nav_txt_menus_gl_title'),
(1272, 1, '_adm_nav_txt_menus_persistent'),
(1273, 1, '_adm_nav_txt_menus_set_name'),
(1274, 1, '_adm_nav_txt_menus_set_name_new'),
(1275, 1, '_adm_nav_txt_menus_set_name_select'),
(1276, 1, '_adm_nav_txt_menus_set_title'),
(1277, 1, '_adm_nav_txt_menus_style'),
(1278, 1, '_adm_nav_txt_menus_style_select'),
(1279, 1, '_adm_nav_txt_menus_title'),
(1280, 1, '_adm_nav_txt_n_items'),
(1281, 1, '_adm_nav_txt_select_set'),
(1282, 1, '_adm_nav_txt_sets_create_popup'),
(1283, 1, '_adm_nav_txt_sets_edit_popup'),
(1284, 1, '_adm_nav_txt_sets_gl_items'),
(1285, 1, '_adm_nav_txt_sets_gl_module'),
(1286, 1, '_adm_nav_txt_sets_gl_title'),
(1287, 1, '_adm_nav_txt_sets_title'),
(1288, 1, '_adm_nav_txt_block_hidden_on'),
(1289, 1, '_adm_nav_txt_block_hidden_on_phone'),
(1290, 1, '_adm_nav_txt_block_hidden_on_tablet'),
(1291, 1, '_adm_nav_txt_block_hidden_on_desktop'),
(1292, 1, '_adm_nav_txt_block_hidden_on_mobile'),
(1293, 1, '_adm_nav_txt_block_hidden_on_pt'),
(1294, 1, '_adm_nav_txt_block_hidden_on_col'),
(1295, 1, '_adm_nav_txt_block_hidden_on_col_thin'),
(1296, 1, '_adm_nav_txt_block_hidden_on_col_half'),
(1297, 1, '_adm_nav_txt_block_hidden_on_col_wide'),
(1298, 1, '_adm_nav_txt_block_hidden_on_col_full'),
(1299, 1, '_adm_page_cpt_api'),
(1300, 1, '_adm_page_cpt_agents'),
(1301, 1, '_adm_page_cpt_audit'),
(1302, 1, '_adm_page_cpt_badges'),
(1303, 1, '_adm_page_cpt_builder_forms'),
(1304, 1, '_adm_page_cpt_builder_menus'),
(1305, 1, '_adm_page_cpt_builder_mobile'),
(1306, 1, '_adm_page_cpt_builder_pages'),
(1307, 1, '_adm_page_cpt_builder_permissions'),
(1308, 1, '_adm_page_cpt_builder_roles'),
(1309, 1, '_adm_page_cpt_dashboard'),
(1310, 1, '_adm_page_cpt_designer'),
(1311, 1, '_adm_page_cpt_home'),
(1312, 1, '_adm_page_cpt_login'),
(1313, 1, '_adm_page_cpt_polyglot'),
(1314, 1, '_adm_page_cpt_settings'),
(1315, 1, '_adm_page_cpt_storages'),
(1316, 1, '_adm_page_cpt_store'),
(1317, 1, '_adm_pgt_btn_add_new_key'),
(1318, 1, '_adm_pgt_btn_delete'),
(1319, 1, '_adm_pgt_btn_delete_title'),
(1320, 1, '_adm_pgt_btn_edit_title'),
(1321, 1, '_adm_pgt_btn_etemplates_cancel'),
(1322, 1, '_adm_pgt_btn_etemplates_gl_edit_title'),
(1323, 1, '_adm_pgt_btn_etemplates_save'),
(1324, 1, '_adm_pgt_btn_nkp_close'),
(1325, 1, '_adm_pgt_btn_nkp_create'),
(1326, 1, '_adm_pgt_btn_nkp_save'),
(1327, 1, '_adm_pgt_dsc_etemplates_body'),
(1328, 1, '_adm_pgt_dsc_etemplates_name_system'),
(1329, 1, '_adm_pgt_dsc_etemplates_subject'),
(1330, 1, '_adm_pgt_err_cannot_process_action'),
(1331, 1, '_adm_pgt_err_cannot_recompile_lang'),
(1332, 1, '_adm_pgt_err_cannot_restore_lang'),
(1333, 1, '_adm_pgt_err_create_key'),
(1334, 1, '_adm_pgt_err_create_key_empty_fields'),
(1335, 1, '_adm_pgt_err_deactivate_default'),
(1336, 1, '_adm_pgt_err_etemplates_body'),
(1337, 1, '_adm_pgt_err_etemplates_edit'),
(1338, 1, '_adm_pgt_err_etemplates_name_system'),
(1339, 1, '_adm_pgt_err_etemplates_subject'),
(1340, 1, '_adm_pgt_err_last_active'),
(1341, 1, '_adm_pgt_err_save'),
(1342, 1, '_adm_pgt_scs_recompiled'),
(1343, 1, '_adm_pgt_scs_restored'),
(1344, 1, '_adm_pgt_txt_all_modules'),
(1345, 1, '_adm_pgt_txt_etemplates_body'),
(1346, 1, '_adm_pgt_txt_etemplates_edit_popup'),
(1347, 1, '_adm_pgt_txt_etemplates_gl_module'),
(1348, 1, '_adm_pgt_txt_etemplates_gl_name_system'),
(1349, 1, '_adm_pgt_txt_etemplates_name_system'),
(1350, 1, '_adm_pgt_txt_etemplates_subject'),
(1351, 1, '_adm_pgt_txt_key'),
(1352, 1, '_adm_pgt_txt_keyword'),
(1353, 1, '_adm_pgt_txt_languages'),
(1354, 1, '_adm_pgt_txt_module'),
(1355, 1, '_adm_pgt_txt_nkp_add_popup'),
(1356, 1, '_adm_pgt_txt_nkp_edit_popup'),
(1357, 1, '_adm_pgt_txt_nkp_key_name'),
(1358, 1, '_adm_pgt_txt_nkp_module'),
(1359, 1, '_adm_pgt_txt_text'),
(1360, 1, '_adm_pgt_txt_et_c_content'),
(1361, 1, '_adm_pgt_txt_et_hf_inf'),
(1362, 1, '_adm_pgt_btn_et_hf_submit'),
(1363, 1, '_adm_pgt_scs_et_hf_save'),
(1364, 1, '_adm_pgt_err_et_hf_save'),
(1365, 1, '_adm_pgt_err_et_hf_save_unsubscribe'),
(1366, 1, '_adm_prm_btn_actions_cancel'),
(1367, 1, '_adm_prm_btn_actions_options'),
(1368, 1, '_adm_prm_btn_actions_save'),
(1369, 1, '_adm_prm_btn_add_level'),
(1370, 1, '_adm_prm_btn_add_price'),
(1371, 1, '_adm_prm_btn_level_add'),
(1372, 1, '_adm_prm_btn_level_cancel'),
(1373, 1, '_adm_prm_btn_level_delete'),
(1374, 1, '_adm_prm_btn_level_edit'),
(1375, 1, '_adm_prm_btn_level_save'),
(1376, 1, '_adm_prm_btn_price_add'),
(1377, 1, '_adm_prm_btn_price_cancel'),
(1378, 1, '_adm_prm_btn_price_delete'),
(1379, 1, '_adm_prm_btn_price_edit'),
(1380, 1, '_adm_prm_btn_price_save'),
(1381, 1, '_adm_prm_dsc_actions_avail'),
(1382, 1, '_adm_prm_dsc_actions_number'),
(1383, 1, '_adm_prm_dsc_actions_reset'),
(1384, 1, '_adm_prm_dsc_level_description'),
(1385, 1, '_adm_prm_dsc_level_icon'),
(1386, 1, '_adm_prm_dsc_level_icon_image'),
(1387, 1, '_adm_prm_dsc_level_name'),
(1388, 1, '_adm_prm_dsc_level_quota_max_file_size'),
(1389, 1, '_adm_prm_dsc_level_quota_number'),
(1390, 1, '_adm_prm_dsc_level_password_expired'),
(1391, 1, '_adm_prm_dsc_level_password_expired_notify'),
(1392, 1, '_adm_prm_dsc_level_quota_size'),
(1393, 1, '_adm_prm_dsc_price_add_days'),
(1394, 1, '_adm_prm_err_action_edit'),
(1395, 1, '_adm_prm_err_level_create'),
(1396, 1, '_adm_prm_err_level_delete');
INSERT INTO `sys_localization_keys` VALUES
(1397, 1, '_adm_prm_err_level_edit'),
(1398, 1, '_adm_prm_err_level_icon'),
(1399, 1, '_adm_prm_err_level_icon_image'),
(1400, 1, '_adm_prm_err_level_icon_image_remove'),
(1401, 1, '_adm_prm_err_level_id'),
(1402, 1, '_adm_prm_err_level_name'),
(1403, 1, '_adm_prm_err_level_quota_max_file_size'),
(1404, 1, '_adm_prm_err_level_quota_number'),
(1405, 1, '_adm_prm_err_level_password_expired'),
(1406, 1, '_adm_prm_err_level_password_expired_notify'),
(1407, 1, '_adm_prm_err_level_quota_size'),
(1408, 1, '_adm_prm_err_price_create'),
(1409, 1, '_adm_prm_err_price_duplicate'),
(1410, 1, '_adm_prm_err_price_update'),
(1411, 1, '_adm_prm_txt_actions'),
(1412, 1, '_adm_prm_txt_actions_avail_end'),
(1413, 1, '_adm_prm_txt_actions_avail_start'),
(1414, 1, '_adm_prm_txt_actions_number'),
(1415, 1, '_adm_prm_txt_actions_options_popup'),
(1416, 1, '_adm_prm_txt_actions_reset'),
(1417, 1, '_adm_prm_txt_all_modules'),
(1418, 1, '_adm_prm_txt_description'),
(1419, 1, '_adm_prm_txt_enable'),
(1420, 1, '_adm_prm_txt_icon'),
(1421, 1, '_adm_prm_txt_level_account'),
(1422, 1, '_adm_prm_txt_level_actions_copy'),
(1423, 1, '_adm_prm_txt_level_administrator'),
(1424, 1, '_adm_prm_txt_level_create_popup'),
(1425, 1, '_adm_prm_txt_level_description'),
(1426, 1, '_adm_prm_txt_level_edit_popup'),
(1427, 1, '_adm_prm_txt_level_icon'),
(1428, 1, '_adm_prm_txt_level_icon_image'),
(1429, 1, '_adm_prm_txt_level_icon_image_new'),
(1430, 1, '_adm_prm_txt_level_icon_image_old'),
(1431, 1, '_adm_prm_txt_level_moderator'),
(1432, 1, '_adm_prm_txt_level_name'),
(1433, 1, '_adm_prm_txt_level_pending'),
(1434, 1, '_adm_prm_txt_level_premium'),
(1435, 1, '_adm_prm_txt_level_quota_max_file_size'),
(1436, 1, '_adm_prm_txt_level_quota_number'),
(1437, 1, '_adm_prm_txt_level_password_expired'),
(1438, 1, '_adm_prm_txt_level_password_expired_notify'),
(1439, 1, '_adm_prm_txt_level_quota_size'),
(1440, 1, '_adm_prm_txt_level_standard'),
(1441, 1, '_adm_prm_txt_level_suspended'),
(1442, 1, '_adm_prm_txt_level_unauthenticated'),
(1443, 1, '_adm_prm_txt_level_unconfirmed'),
(1444, 1, '_adm_prm_txt_manage_actions'),
(1445, 1, '_adm_prm_txt_max_file_size'),
(1446, 1, '_adm_prm_txt_max_files'),
(1447, 1, '_adm_prm_txt_module'),
(1448, 1, '_adm_prm_txt_n_actions'),
(1449, 1, '_adm_prm_txt_price'),
(1450, 1, '_adm_prm_txt_price_add_days'),
(1451, 1, '_adm_prm_txt_price_add_popup'),
(1452, 1, '_adm_prm_txt_price_add_price'),
(1453, 1, '_adm_prm_txt_price_edit_popup'),
(1454, 1, '_adm_prm_txt_select_level'),
(1455, 1, '_adm_prm_txt_storage'),
(1456, 1, '_adm_prm_txt_term'),
(1457, 1, '_adm_prm_txt_title'),
(1458, 1, '_adm_prm_txt_visibility_items_anyone'),
(1459, 1, '_adm_prm_txt_visibility_items_n_user_levels'),
(1460, 1, '_adm_prm_txt_visibility_items_nobody'),
(1461, 1, '_adm_rl_btn_role_add'),
(1462, 1, '_adm_rl_btn_role_edit'),
(1463, 1, '_adm_rl_btn_role_delete'),
(1464, 1, '_adm_rl_err_cannot_process_action'),
(1465, 1, '_adm_rl_err_role_create'),
(1466, 1, '_adm_rl_err_role_edit'),
(1467, 1, '_adm_rl_err_role_delete'),
(1468, 1, '_adm_rl_err_role_id'),
(1469, 1, '_adm_rl_txt_actions'),
(1470, 1, '_adm_rl_txt_description'),
(1471, 1, '_adm_rl_txt_manage_actions'),
(1472, 1, '_adm_rl_txt_n_actions'),
(1473, 1, '_adm_rl_txt_select_role'),
(1474, 1, '_adm_rl_txt_title'),
(1475, 1, '_adm_rl_txt_role_create_popup'),
(1476, 1, '_adm_rl_txt_role_edit_popup'),
(1477, 1, '_adm_rl_txt_role_master'),
(1478, 1, '_adm_rl_txt_role_master_dsc'),
(1479, 1, '_adm_rl_txt_role_operator'),
(1480, 1, '_adm_rl_txt_role_operator_dsc'),
(1481, 1, '_adm_rl_txt_action_manage_roles'),
(1482, 1, '_adm_rl_txt_action_manage_roles_dsc'),
(1483, 1, '_adm_rl_txt_action_manage_apps'),
(1484, 1, '_adm_rl_txt_action_manage_apps_dsc'),
(1485, 1, '_adm_rl_txt_action_use_appearance'),
(1486, 1, '_adm_rl_txt_action_use_appearance_dsc'),
(1487, 1, '_adm_rl_txt_action_use_structure'),
(1488, 1, '_adm_rl_txt_action_use_structure_dsc'),
(1489, 1, '_adm_rl_txt_action_use_content'),
(1490, 1, '_adm_rl_txt_action_use_content_dsc'),
(1491, 1, '_adm_rl_txt_action_use_users'),
(1492, 1, '_adm_rl_txt_action_use_users_dsc'),
(1493, 1, '_adm_rl_txt_action_use_configuration'),
(1494, 1, '_adm_rl_txt_action_use_configuration_dsc'),
(1495, 1, '_adm_rl_txt_action_use_extensions'),
(1496, 1, '_adm_rl_txt_action_use_extensions_dsc'),
(1497, 1, '_adm_rl_txt_action_use_integrations'),
(1498, 1, '_adm_rl_txt_action_use_integrations_dsc'),
(1499, 1, '_adm_rl_txt_role_title'),
(1500, 1, '_adm_rl_err_role_title'),
(1501, 1, '_adm_rl_txt_role_description'),
(1502, 1, '_adm_rl_txt_role_actions_copy'),
(1503, 1, '_adm_rl_btn_role_create'),
(1504, 1, '_adm_rl_btn_role_cancel'),
(1505, 1, '_adm_rl_btn_role_save'),
(1506, 1, '_adm_scs_operation_done'),
(1507, 1, '_adm_stg_cpt_category_account'),
(1508, 1, '_adm_stg_cpt_category_acl'),
(1509, 1, '_adm_stg_cpt_category_audit'),
(1510, 1, '_adm_stg_cpt_category_notifications'),
(1511, 1, '_adm_stg_cpt_category_notifications_push'),
(1512, 1, '_adm_stg_cpt_category_cache'),
(1513, 1, '_adm_stg_cpt_category_general'),
(1514, 1, '_adm_stg_cpt_category_hidden'),
(1515, 1, '_adm_stg_cpt_category_languages'),
(1516, 1, '_adm_stg_cpt_category_permalinks'),
(1517, 1, '_adm_stg_cpt_category_security'),
(1518, 1, '_adm_stg_cpt_category_site_settings'),
(1519, 1, '_adm_stg_cpt_category_storage'),
(1520, 1, '_adm_stg_cpt_category_system'),
(1521, 1, '_adm_stg_cpt_category_templates'),
(1522, 1, '_adm_stg_cpt_category_sms'),
(1523, 1, '_adm_stg_cpt_category_location'),
(1524, 1, '_adm_stg_cpt_category_social_settings'),
(1525, 1, '_adm_stg_cpt_category_api_general'),
(1526, 1, '_adm_stg_cpt_category_api_layout'),
(1527, 1, '_adm_stg_cpt_category_agents_general'),
(1528, 1, '_adm_stg_cpt_category_agents_usage'),
(1529, 1, '_adm_stg_cpt_option_client_image_resize_width'),
(1530, 1, '_adm_stg_cpt_option_client_image_resize_height'),
(1531, 1, '_adm_stg_cpt_option_currency_code'),
(1532, 1, '_adm_stg_err_option_currency_code'),
(1533, 1, '_adm_stg_cpt_option_currency_sign'),
(1534, 1, '_adm_stg_err_option_currency_sign'),
(1535, 1, '_adm_stg_cpt_option_enable_gd'),
(1536, 1, '_adm_stg_cpt_option_enable_notification_account'),
(1537, 1, '_adm_stg_cpt_option_enable_notification_pruning'),
(1538, 1, '_adm_stg_cpt_option_expire_notification_days'),
(1539, 1, '_adm_stg_cpt_option_expire_notify_once'),
(1540, 1, '_adm_stg_cpt_option_lang_default'),
(1541, 1, '_adm_stg_cpt_option_lang_subst_from_en'),
(1542, 1, '_adm_stg_cpt_option_permalinks_modules'),
(1543, 1, '_adm_stg_cpt_option_permalinks_pages'),
(1544, 1, '_adm_stg_cpt_option_permalinks_storage'),
(1545, 1, '_adm_stg_cpt_option_permalinks_seo_links'),
(1546, 1, '_adm_stg_cpt_option_permalinks_seo_links_redirects'),
(1547, 1, '_adm_stg_cpt_option_site_email'),
(1548, 1, '_adm_stg_inf_option_site_email'),
(1549, 1, '_adm_stg_cpt_option_site_email_notify'),
(1550, 1, '_adm_stg_inf_option_site_email_notify'),
(1551, 1, '_adm_stg_cpt_option_site_email_html_template_header'),
(1552, 1, '_adm_stg_cpt_option_site_email_html_template_footer'),
(1553, 1, '_adm_stg_cpt_option_site_login_social_compact'),
(1554, 1, '_adm_stg_cpt_option_site_title'),
(1555, 1, '_adm_stg_inf_option_site_title'),
(1556, 1, '_adm_stg_cpt_option_site_tour_home'),
(1557, 1, '_adm_stg_inf_option_site_tour_home'),
(1558, 1, '_adm_stg_cpt_option_site_tour_studio'),
(1559, 1, '_adm_stg_inf_option_site_tour_studio'),
(1560, 1, '_adm_stg_cpt_option_smart_app_banner'),
(1561, 1, '_adm_stg_inf_option_smart_app_banner'),
(1562, 1, '_adm_stg_cpt_option_smart_app_banner_ios_app_id'),
(1563, 1, '_adm_stg_inf_option_smart_app_banner_ios_app_id'),
(1564, 1, '_adm_stg_cpt_option_sys_account_activation_letter'),
(1565, 1, '_adm_stg_cpt_option_sys_account_confirmation_type'),
(1566, 1, '_adm_stg_cpt_option_sys_account_hide_unconfirmed_accounts'),
(1567, 1, '_adm_stg_cpt_option_sys_account_2fa_enable'),
(1568, 1, '_adm_stg_cpt_option_sys_account_2fa_lifetime'),
(1569, 1, '_adm_stg_cpt_option_sys_account_autoapproval'),
(1570, 1, '_adm_stg_cpt_option_sys_account_auto_profile_creation'),
(1571, 1, '_adm_stg_cpt_option_sys_account_online_time'),
(1572, 1, '_adm_stg_err_option_sys_account_online_time'),
(1573, 1, '_adm_stg_cpt_option_sys_account_default_profile_type'),
(1574, 1, '_adm_stg_cpt_option_sys_account_limit_profiles_number'),
(1575, 1, '_adm_stg_cpt_option_sys_account_limit_incorrect_login_attempts'),
(1576, 1, '_adm_stg_cpt_option_sys_account_reset_password_key_lifetime'),
(1577, 1, '_adm_stg_cpt_option_sys_account_reset_password_redirect'),
(1578, 1, '_adm_stg_cpt_option_sys_account_disable_login_form'),
(1579, 1, '_adm_stg_cpt_option_sys_account_disable_join_form'),
(1580, 1, '_adm_stg_cpt_option_sys_allow_plus_in_email'),
(1581, 1, '_adm_stg_cpt_option_sys_accounts_pruning'),
(1582, 1, '_adm_stg_cpt_option_sys_accounts_pruning_interval'),
(1583, 1, '_adm_stg_cpt_option_sys_accounts_password_log_count'),
(1584, 1, '_adm_stg_cpt_option_sys_accounts_force_password_change_after_expiration'),
(1585, 1, '_adm_stg_cpt_option_sys_lock_from_unauthenticated'),
(1586, 1, '_adm_stg_cpt_option_sys_lock_from_unauthenticated_exceptions'),
(1587, 1, '_adm_stg_cpt_option_value_sys_account_pruning_no_login_delete'),
(1588, 1, '_adm_stg_cpt_option_value_sys_account_pruning_no_login_suspend'),
(1589, 1, '_adm_stg_cpt_option_value_sys_account_pruning_no_confirm_delete'),
(1590, 1, '_adm_stg_cpt_option_value_sys_account_pruning_no_profile_delete'),
(1591, 1, '_adm_stg_cpt_option_value_sys_account_reset_password_redirect_home'),
(1592, 1, '_adm_stg_cpt_option_value_sys_account_reset_password_redirect_profile'),
(1593, 1, '_adm_stg_cpt_option_value_sys_account_reset_password_redirect_profile_edit'),
(1594, 1, '_adm_stg_cpt_option_value_sys_account_reset_password_redirect_custom'),
(1595, 1, '_adm_stg_cpt_option_sys_account_reset_password_redirect_custom'),
(1596, 1, '_adm_stg_cpt_option_sys_account_switch_to_profile_redirect'),
(1597, 1, '_adm_stg_cpt_option_sys_account_switch_to_profile_redirect_custom'),
(1598, 1, '_adm_stg_cpt_option_sys_account_remember_me'),
(1599, 1, '_adm_stg_cpt_option_value_sys_account_switch_to_profile_redirect_back'),
(1600, 1, '_adm_stg_cpt_option_value_sys_account_switch_to_profile_redirect_home'),
(1601, 1, '_adm_stg_cpt_option_value_sys_account_switch_to_profile_redirect_profile'),
(1602, 1, '_adm_stg_cpt_option_value_sys_account_switch_to_profile_redirect_custom'),
(1603, 1, '_adm_stg_cpt_option_sys_acl_expire_notification_days'),
(1604, 1, '_adm_stg_cpt_option_sys_acl_expire_notify_once'),
(1605, 1, '_adm_stg_cpt_option_sys_add_nofollow'),
(1606, 1, '_adm_stg_cpt_option_sys_audit_enable'),
(1607, 1, '_adm_stg_cpt_option_sys_audit_max_records'),
(1608, 1, '_adm_stg_cpt_option_sys_audit_days_before_expire'),
(1609, 1, '_adm_stg_cpt_option_sys_audit_acl_levels'),
(1610, 1, '_adm_stg_cpt_option_sys_autoupdate_force_modified_files'),
(1611, 1, '_adm_stg_inf_option_sys_autoupdate_force_modified_files'),
(1612, 1, '_adm_stg_cpt_option_sys_autoupdate'),
(1613, 1, '_adm_stg_inf_option_sys_autoupdate'),
(1614, 1, '_adm_stg_cpt_option_sys_cache_memcache_host'),
(1615, 1, '_adm_stg_cpt_option_sys_cache_memcache_port'),
(1616, 1, '_adm_stg_cpt_option_sys_captcha_default'),
(1617, 1, '_adm_stg_cpt_option_sys_cf_enable'),
(1618, 1, '_adm_stg_cpt_option_sys_cf_enable_comments'),
(1619, 1, '_adm_stg_cpt_option_sys_cf_prohibited'),
(1620, 1, '_adm_stg_cpt_option_sys_cf_unauthenticated'),
(1621, 1, '_adm_stg_cpt_option_sys_confirmation_before_redirect'),
(1622, 1, '_adm_stg_cpt_option_sys_email_attachable_email_templates'),
(1623, 1, '_adm_stg_cpt_option_sys_db_cache_enable'),
(1624, 1, '_adm_stg_cpt_option_sys_db_cache_engine'),
(1625, 1, '_adm_stg_cpt_option_sys_default_payment'),
(1626, 1, '_adm_stg_cpt_option_sys_editor_default'),
(1627, 1, '_adm_stg_cpt_option_sys_player_default'),
(1628, 1, '_adm_stg_cpt_option_sys_player_default_quality'),
(1629, 1, '_adm_stg_cpt_option_sys_pt_default_visitor'),
(1630, 1, '_adm_stg_cpt_option_sys_pt_default_member'),
(1631, 1, '_adm_stg_cpt_option_sys_form_lpc_enable'),
(1632, 1, '_adm_stg_cpt_option_sys_format_date'),
(1633, 1, '_adm_stg_cpt_option_sys_format_datetime'),
(1634, 1, '_adm_stg_cpt_option_sys_format_time'),
(1635, 1, '_adm_stg_cpt_option_sys_format_timeago'),
(1636, 1, '_adm_stg_cpt_option_sys_format_input_24h'),
(1637, 1, '_adm_stg_cpt_option_sys_ftp_dir'),
(1638, 1, '_adm_stg_cpt_option_sys_ftp_login'),
(1639, 1, '_adm_stg_cpt_option_sys_ftp_password'),
(1640, 1, '_adm_stg_cpt_option_sys_cron_time'),
(1641, 1, '_adm_stg_cpt_option_sys_update_time'),
(1642, 1, '_adm_stg_cpt_option_sys_upgrade_channel'),
(1643, 1, '_adm_stg_cpt_option_sys_live_updates_interval'),
(1644, 1, '_adm_stg_cpt_option_sys_location_field_default'),
(1645, 1, '_adm_stg_cpt_option_sys_location_map_default'),
(1646, 1, '_adm_stg_cpt_option_sys_location_map_zoom_default'),
(1647, 1, '_adm_stg_cpt_option_sys_location_leaflet_provider'),
(1648, 1, '_adm_stg_cpt_option_sys_location_normalize_names'),
(1649, 1, '_adm_stg_cpt_option_sys_maps_api_key'),
(1650, 1, '_adm_stg_cpt_option_sys_embed_default'),
(1651, 1, '_adm_stg_cpt_option_sys_embedly_api_key'),
(1652, 1, '_adm_stg_cpt_option_sys_embedly_api_pattern'),
(1653, 1, '_adm_stg_cpt_option_sys_iframely_api_key'),
(1654, 1, '_adm_stg_cpt_option_sys_eq_time'),
(1655, 1, '_adm_stg_cpt_option_sys_eq_send_per_start'),
(1656, 1, '_adm_stg_cpt_option_sys_eq_send_per_start_to_recipient'),
(1657, 1, '_adm_stg_cpt_option_sys_oauth_key'),
(1658, 1, '_adm_stg_cpt_option_sys_oauth_secret'),
(1659, 1, '_adm_stg_cpt_option_sys_page_cache_enable'),
(1660, 1, '_adm_stg_cpt_option_sys_page_cache_engine'),
(1661, 1, '_adm_stg_cpt_option_sys_pb_cache_enable'),
(1662, 1, '_adm_stg_cpt_option_sys_pb_cache_engine'),
(1663, 1, '_adm_stg_cpt_option_sys_per_page_search_keyword_single'),
(1664, 1, '_adm_stg_inf_option_sys_per_page_search_keyword_single'),
(1665, 1, '_adm_stg_cpt_option_sys_per_page_search_keyword_plural'),
(1666, 1, '_adm_stg_inf_option_sys_per_page_search_keyword_plural'),
(1667, 1, '_adm_stg_cpt_option_sys_push_default'),
(1668, 1, '_adm_stg_cpt_option_sys_push_onesignal_app_id'),
(1669, 1, '_adm_stg_cpt_option_sys_push_onesignal_rest_api'),
(1670, 1, '_adm_stg_cpt_option_sys_push_onesignal_short_name'),
(1671, 1, '_adm_stg_cpt_option_sys_push_onesignal_safari_id'),
(1672, 1, '_adm_stg_cpt_option_sys_push_queue_time'),
(1673, 1, '_adm_stg_cpt_option_sys_push_queue_send_per_start'),
(1674, 1, '_adm_stg_cpt_option_sys_push_queue_send_per_start_to_recipient'),
(1675, 1, '_adm_stg_cpt_option_sys_sms_default'),
(1676, 1, '_adm_stg_cpt_option_sys_sms_twilio_sid'),
(1677, 1, '_adm_stg_cpt_option_sys_sms_twilio_token'),
(1678, 1, '_adm_stg_cpt_option_sys_sms_twilio_from_number'),
(1679, 1, '_adm_stg_cpt_option_sys_nominatim_server'),
(1680, 1, '_adm_stg_cpt_option_sys_nominatim_email'),
(1681, 1, '_adm_stg_cpt_option_sys_recaptcha_key_private'),
(1682, 1, '_adm_stg_cpt_option_sys_recaptcha_key_public'),
(1683, 1, '_adm_stg_cpt_option_sys_redirect_after_account_added'),
(1684, 1, '_adm_stg_cpt_option_sys_redirect_after_email_confirmation'),
(1685, 1, '_adm_stg_cpt_option_sys_relations_enable'),
(1686, 1, '_adm_stg_cpt_option_sys_relations'),
(1687, 1, '_adm_stg_cpt_option_sys_revision'),
(1688, 1, '_adm_stg_cpt_option_sys_security_form_token_enable'),
(1689, 1, '_adm_stg_cpt_option_sys_security_form_token_lifetime'),
(1690, 1, '_adm_stg_cpt_option_sys_security_impact_threshold_block'),
(1691, 1, '_adm_stg_cpt_option_sys_security_impact_threshold_log'),
(1692, 1, '_adm_stg_cpt_option_sys_security_block_content_after_n_reports'),
(1693, 1, '_adm_stg_cpt_option_sys_site_logo_aspect_ratio'),
(1694, 1, '_adm_stg_cpt_option_sys_storage_default'),
(1695, 1, '_adm_stg_cpt_option_sys_storage_s3_access_key'),
(1696, 1, '_adm_stg_cpt_option_sys_storage_s3_bucket'),
(1697, 1, '_adm_stg_cpt_option_sys_storage_s3_domain'),
(1698, 1, '_adm_stg_cpt_option_sys_storage_s3_secret_key'),
(1699, 1, '_adm_stg_cpt_option_sys_storage_s3_endpoint'),
(1700, 1, '_adm_stg_cpt_option_sys_storage_s3_sig_ver'),
(1701, 1, '_adm_stg_cpt_option_sys_storage_s3_region'),
(1702, 1, '_adm_stg_cpt_option_sys_storage_s3_amz_iam_role'),
(1703, 1, '_adm_stg_cpt_option_sys_storage_s3_acl_enable'),
(1704, 1, '_adm_stg_cpt_option_sys_storage_s3_force_auth_urls'),
(1705, 1, '_adm_stg_cpt_option_sys_template_cache_image_enable'),
(1706, 1, '_adm_stg_cpt_option_sys_template_cache_image_max_size'),
(1707, 1, '_adm_stg_cpt_option_sys_template_cache_image_max_size_err'),
(1708, 1, '_adm_stg_cpt_option_sys_template_cache_compress_enable'),
(1709, 1, '_adm_stg_cpt_option_sys_template_cache_css_enable'),
(1710, 1, '_adm_stg_cpt_option_sys_template_cache_enable'),
(1711, 1, '_adm_stg_cpt_option_sys_template_cache_engine'),
(1712, 1, '_adm_stg_cpt_option_sys_template_cache_js_enable'),
(1713, 1, '_adm_stg_cpt_option_sys_template_cache_minify_css_enable'),
(1714, 1, '_adm_stg_cpt_option_sys_template_cache_minify_js_enable'),
(1715, 1, '_adm_stg_cpt_option_sys_transcoder_queue_storage'),
(1716, 1, '_adm_stg_cpt_option_sys_live_search_limit'),
(1717, 1, '_adm_stg_inf_option_sys_live_search_limit'),
(1718, 1, '_adm_stg_cpt_option_sys_profiles_search_limit'),
(1719, 1, '_adm_stg_inf_option_sys_profiles_search_limit'),
(1720, 1, '_adm_stg_cpt_option_sys_session_lifetime_in_min'),
(1721, 1, '_adm_stg_cpt_option_sys_session_auth'),
(1722, 1, '_adm_stg_cpt_option_sys_default_curl_timeout'),
(1723, 1, '_adm_stg_cpt_option_sys_default_socket_timeout'),
(1724, 1, '_adm_stg_cpt_option_sys_ssl_allow_untrusted'),
(1725, 1, '_adm_stg_cpt_option_sys_csp_frame_ancestors'),
(1726, 1, '_adm_stg_cpt_option_sys_x_frame_options'),
(1727, 1, '_adm_stg_cpt_option_sys_samesite_cookies'),
(1728, 1, '_adm_stg_cpt_option_sys_notify_to_approve_by_role'),
(1729, 1, '_adm_stg_cpt_option_sys_fixed_header'),
(1730, 1, '_adm_stg_cpt_option_sys_css_media_classes'),
(1731, 1, '_adm_stg_cpt_option_sys_css_tailwind_default'),
(1732, 1, '_adm_stg_cpt_option_sys_css_icons_default'),
(1733, 1, '_adm_stg_cpt_option_sys_files_ext_images'),
(1734, 1, '_adm_stg_cpt_option_sys_files_ext_video'),
(1735, 1, '_adm_stg_cpt_option_sys_files_ext_imagevideo'),
(1736, 1, '_adm_stg_cpt_option_sys_files_ext_dangerous'),
(1737, 1, '_adm_stg_cpt_option_sys_files_ext_audio'),
(1738, 1, '_adm_stg_cpt_option_template'),
(1739, 1, '_adm_stg_err_option_template'),
(1740, 1, '_adm_stg_cpt_option_use_like_operator'),
(1741, 1, '_adm_stg_cpt_option_sys_quill_insert_as_plain_text'),
(1742, 1, '_adm_stg_cpt_option_sys_quill_allow_empty_tags'),
(1743, 1, '_adm_stg_cpt_option_sys_quill_allowed_tags_mini'),
(1744, 1, '_adm_stg_cpt_option_sys_quill_allowed_tags_standard'),
(1745, 1, '_adm_stg_cpt_option_sys_quill_allowed_tags_full'),
(1746, 1, '_adm_stg_cpt_option_sys_quill_toolbar_mini'),
(1747, 1, '_adm_stg_cpt_option_sys_quill_toolbar_standard'),
(1748, 1, '_adm_stg_cpt_option_sys_quill_toolbar_full'),
(1749, 1, '_adm_stg_cpt_option_sys_metatags_hashtags_only'),
(1750, 1, '_adm_stg_cpt_option_sys_metatags_hashtags_max'),
(1751, 1, '_adm_stg_cpt_option_sys_metatags_mentions_max'),
(1752, 1, '_adm_stg_cpt_option_sys_attach_links_max'),
(1753, 1, '_adm_stg_cpt_option_sys_enable_post_to_context_for_privacy'),
(1754, 1, '_adm_stg_cpt_option_sys_hide_post_to_context_for_privacy'),
(1755, 1, '_adm_stg_cpt_option_sys_treat_cxt_in_cxt_as_cnt'),
(1756, 1, '_adm_stg_cpt_option_sys_check_fan_in_parent_context'),
(1757, 1, '_adm_stg_cpt_option_sys_search_keyword_min_len'),
(1758, 1, '_adm_stg_cpt_option_sys_profile_bot'),
(1759, 1, '_adm_stg_inf_option_sys_profile_bot'),
(1760, 1, '_adm_stg_cpt_option_sys_logs_storage_default'),
(1761, 1, '_adm_stg_cpt_option_sys_vote_reactions_quick_mode'),
(1762, 1, '_adm_stg_cpt_option_sys_cmts_enable_auto_approve'),
(1763, 1, '_adm_stg_cpt_option_sys_create_post_form_preloading_list'),
(1764, 1, '_adm_stg_inf_option_sys_create_post_form_preloading_list'),
(1765, 1, '_adm_stg_cpt_option_sys_a2a_enable'),
(1766, 1, '_adm_stg_cpt_option_sys_a2a_code'),
(1767, 1, '_adm_stg_cpt_option_sys_api_enable'),
(1768, 1, '_adm_stg_cpt_option_sys_api_access_by_origin'),
(1769, 1, '_adm_stg_cpt_option_sys_api_access_by_key'),
(1770, 1, '_adm_stg_cpt_option_sys_api_access_unsafe_services'),
(1771, 1, '_adm_stg_cpt_option_sys_api_config'),
(1772, 1, '_adm_stg_cpt_option_sys_api_cookie_path'),
(1773, 1, '_adm_stg_cpt_option_sys_api_cookie_secure'),
(1774, 1, '_adm_stg_cpt_option_sys_api_cookie_samesite'),
(1775, 1, '_adm_stg_cpt_option_sys_api_menu_top'),
(1776, 1, '_adm_stg_cpt_option_sys_api_comments_flat'),
(1777, 1, '_adm_stg_cpt_option_sys_api_search_sections'),
(1778, 1, '_adm_stg_cpt_option_sys_api_extended_units'),
(1779, 1, '_adm_stg_cpt_option_sys_api_conn_in_prof_units'),
(1780, 1, '_adm_stg_cpt_option_sys_api_url_root_email'),
(1781, 1, '_adm_stg_cpt_option_sys_api_url_root_push'),
(1782, 1, '_adm_stg_cpt_option_sys_agents_api_key'),
(1783, 1, '_adm_stg_cpt_option_sys_agents_model'),
(1784, 1, '_adm_stg_cpt_option_sys_agents_profile'),
(1785, 1, '_adm_stg_cpt_option_sys_agents_asst_chats_trans_del'),
(1786, 1, '_adm_stg_cpt_option_sys_agents_sa'),
(1787, 1, '_adm_stg_cpt_option_sys_agents_lsa'),
(1788, 1, '_adm_stg_cpt_option_sys_agents_aba'),
(1789, 1, '_adm_stg_cpt_option_sys_viewport_meta_tag'),
(1790, 1, '_adm_stg_cpt_category_pwa_manifest'),
(1791, 1, '_adm_stg_cpt_option_sys_pwa_manifest_name'),
(1792, 1, '_adm_stg_cpt_option_sys_pwa_manifest_short_name'),
(1793, 1, '_adm_stg_cpt_option_sys_pwa_manifest_description'),
(1794, 1, '_adm_stg_cpt_option_sys_pwa_manifest_background_color'),
(1795, 1, '_adm_stg_cpt_option_sys_pwa_manifest_theme_color'),
(1796, 1, '_adm_stg_cpt_category_pwa_sw'),
(1797, 1, '_adm_stg_cpt_option_sys_pwa_sw_enable'),
(1798, 1, '_adm_stg_cpt_option_sys_pwa_sw_cache'),
(1799, 1, '_adm_stg_cpt_option_sys_pwa_sw_offline'),
(1800, 1, '_adm_stg_cpt_category_sockets'),
(1801, 1, '_adm_stg_cpt_option_sys_sockets_type'),
(1802, 1, '_adm_stg_cpt_option_sys_sockets_url'),
(1803, 1, '_adm_stg_cpt_option_sys_sockets_app_id'),
(1804, 1, '_adm_stg_cpt_option_sys_sockets_key'),
(1805, 1, '_adm_stg_cpt_option_sys_sockets_secret'),
(1806, 1, '_adm_stg_cpt_option_sys_sockets_type_sys_sockets_disabled'),
(1807, 1, '_adm_stg_cpt_option_sys_sockets_type_sys_sockets_soketi'),
(1808, 1, '_adm_stg_cpt_option_sys_std_show_header_left'),
(1809, 1, '_adm_stg_cpt_option_sys_std_show_header_left_search'),
(1810, 1, '_adm_stg_cpt_option_sys_std_show_header_center'),
(1811, 1, '_adm_stg_cpt_option_sys_std_show_header_right'),
(1812, 1, '_adm_stg_cpt_option_sys_std_show_header_right_search'),
(1813, 1, '_adm_stg_cpt_option_sys_std_show_header_right_site'),
(1814, 1, '_adm_stg_cpt_option_sys_std_show_launcher_left'),
(1815, 1, '_adm_stg_cpt_option_sys_embed_microlink_key'),
(1816, 1, '_adm_stg_cpt_type_system'),
(1817, 1, '_adm_stg_scs_save'),
(1818, 1, '_adm_stg_err_save_error_message'),
(1819, 1, '_adm_stg_err_cannot_perform'),
(1820, 1, '_adm_stg_err_mix_already_exists'),
(1821, 1, '_adm_stg_txt_import_popup'),
(1822, 1, '_adm_stg_msg_imported'),
(1823, 1, '_adm_stg_err_import_wrong_format'),
(1824, 1, '_adm_stg_txt_create_mix_popup'),
(1825, 1, '_adm_stg_txt_import_mix_popup'),
(1826, 1, '_adm_stg_txt_mix_dark'),
(1827, 1, '_adm_stg_txt_mix_duplicate'),
(1828, 1, '_adm_stg_txt_mix_duplicate_inf'),
(1829, 1, '_adm_stg_txt_mix_title'),
(1830, 1, '_adm_stg_txt_mix_title_inf'),
(1831, 1, '_adm_stg_txt_mix_title_err'),
(1832, 1, '_adm_stg_txt_mix_system'),
(1833, 1, '_adm_stg_err_remove_old_image'),
(1834, 1, '_adm_str_cpt_files_file'),
(1835, 1, '_adm_str_cpt_files_version'),
(1836, 1, '_adm_str_err_cannot_connect_to_ftp'),
(1837, 1, '_adm_str_err_cannot_unzip_package'),
(1838, 1, '_adm_str_err_cannot_write'),
(1839, 1, '_adm_str_err_destination_not_valid'),
(1840, 1, '_adm_str_err_download_failed'),
(1841, 1, '_adm_str_err_files_copy_failed'),
(1842, 1, '_adm_str_err_no_ftp_info'),
(1843, 1, '_adm_str_err_no_product_info'),
(1844, 1, '_adm_str_err_wrong_package_format'),
(1845, 1, '_adm_str_err_zip_not_available'),
(1846, 1, '_adm_str_msg_download_scheduled'),
(1847, 1, '_adm_str_msg_download_and_install_scheduled'),
(1848, 1, '_adm_str_msg_download_successfully'),
(1849, 1, '_adm_str_msg_download_and_install_successfully'),
(1850, 1, '_adm_str_txt_discount_csign'),
(1851, 1, '_adm_str_txt_items_by'),
(1852, 1, '_adm_str_txt_or'),
(1853, 1, '_adm_str_txt_per_week'),
(1854, 1, '_adm_str_txt_per_week_short'),
(1855, 1, '_adm_str_txt_per_month'),
(1856, 1, '_adm_str_txt_per_month_short'),
(1857, 1, '_adm_str_txt_per_year'),
(1858, 1, '_adm_str_txt_per_year_short'),
(1859, 1, '_adm_str_txt_price_free'),
(1860, 1, '_adm_str_txt_price_recurring'),
(1861, 1, '_adm_str_txt_price_single'),
(1862, 1, '_adm_str_txt_pv_category'),
(1863, 1, '_adm_str_txt_pv_created'),
(1864, 1, '_adm_str_txt_pv_description'),
(1865, 1, '_adm_str_txt_pv_discount'),
(1866, 1, '_adm_str_txt_pv_discount_off_csign'),
(1867, 1, '_adm_str_txt_pv_price'),
(1868, 1, '_adm_str_txt_pv_rent'),
(1869, 1, '_adm_str_txt_pv_stats'),
(1870, 1, '_adm_str_txt_pv_stats_votes'),
(1871, 1, '_adm_str_txt_pv_stats_reviews'),
(1872, 1, '_adm_str_txt_pv_stats_views'),
(1873, 1, '_adm_str_txt_pv_tags'),
(1874, 1, '_adm_str_txt_pv_title'),
(1875, 1, '_adm_str_txt_pv_updated'),
(1876, 1, '_adm_str_txt_pv_vendor'),
(1877, 1, '_adm_str_txt_pv_version'),
(1878, 1, '_adm_str_txt_pv_version_mask'),
(1879, 1, '_adm_str_txt_update_from_to'),
(1880, 1, '_adm_strg_err_cannot_process_action'),
(1881, 1, '_adm_strg_err_files_delete'),
(1882, 1, '_adm_strg_msg_files_delete'),
(1883, 1, '_adm_strg_err_images_delete'),
(1884, 1, '_adm_strg_msg_images_delete'),
(1885, 1, '_adm_strg_err_images_resize'),
(1886, 1, '_adm_strg_txt_file_name'),
(1887, 1, '_adm_strg_txt_path'),
(1888, 1, '_adm_strg_txt_mime_type'),
(1889, 1, '_adm_strg_txt_added'),
(1890, 1, '_adm_strg_btn_delete'),
(1891, 1, '_adm_strg_btn_add'),
(1892, 1, '_adm_strg_btn_cancel'),
(1893, 1, '_adm_strg_btn_done'),
(1894, 1, '_adm_strg_btn_download'),
(1895, 1, '_adm_strg_btn_resize'),
(1896, 1, '_adm_strg_txt_files_add_popup'),
(1897, 1, '_adm_strg_txt_images_add_popup'),
(1898, 1, '_adm_strg_txt_images_resize_popup'),
(1899, 1, '_adm_strg_txt_size_mime_type'),
(1900, 1, '_adm_strg_txt_width'),
(1901, 1, '_adm_strg_err_width'),
(1902, 1, '_adm_strg_txt_height'),
(1903, 1, '_adm_strg_err_height'),
(1904, 1, '_adm_tmi_cpt_account'),
(1905, 1, '_adm_tmi_cpt_assistant'),
(1906, 1, '_adm_tmi_cpt_site'),
(1907, 1, '_adm_tmi_cpt_search'),
(1908, 1, '_adm_tmi_cpt_scheme'),
(1909, 1, '_adm_tmi_cpt_tour'),
(1910, 1, '_adm_tmi_cpt_launcher'),
(1911, 1, '_adm_txt_active_api'),
(1912, 1, '_adm_txt_assistant_popup_title'),
(1913, 1, '_adm_txt_confirm_cancel'),
(1914, 1, '_adm_txt_confirm_ok'),
(1915, 1, '_adm_txt_forgot_password'),
(1916, 1, '_adm_txt_form_view_missing'),
(1917, 1, '_adm_txt_login_password'),
(1918, 1, '_adm_txt_login_password_placeholder'),
(1919, 1, '_adm_txt_login_email'),
(1920, 1, '_adm_txt_login_email_placeholder'),
(1921, 1, '_adm_txt_login_title'),
(1922, 1, '_adm_txt_login_subtitle'),
(1923, 1, '_adm_txt_module_custom'),
(1924, 1, '_adm_txt_module_skeletons'),
(1925, 1, '_adm_txt_module_system'),
(1926, 1, '_adm_txt_modules_check_dependencies'),
(1927, 1, '_adm_txt_modules_check_module_exists'),
(1928, 1, '_adm_txt_modules_check_module_matches'),
(1929, 1, '_adm_txt_modules_check_module_hash'),
(1930, 1, '_adm_txt_modules_check_module_version'),
(1931, 1, '_adm_txt_modules_check_script_version'),
(1932, 1, '_adm_txt_modules_clear_db_cache'),
(1933, 1, '_adm_txt_modules_clear_template_cache'),
(1934, 1, '_adm_txt_modules_delete'),
(1935, 1, '_adm_txt_modules_disable'),
(1936, 1, '_adm_txt_modules_discontinued'),
(1937, 1, '_adm_txt_modules_enable'),
(1938, 1, '_adm_txt_modules_executable'),
(1939, 1, '_adm_txt_modules_execute_sql'),
(1940, 1, '_adm_txt_modules_ftp_access'),
(1941, 1, '_adm_txt_modules_install'),
(1942, 1, '_adm_txt_modules_install_language'),
(1943, 1, '_adm_txt_modules_login'),
(1944, 1, '_adm_txt_modules_market'),
(1945, 1, '_adm_txt_modules_move_sources'),
(1946, 1, '_adm_txt_modules_operation_update'),
(1947, 1, '_adm_txt_modules_package_module'),
(1948, 1, '_adm_txt_modules_package_to_upload'),
(1949, 1, '_adm_txt_modules_params_used'),
(1950, 1, '_adm_txt_modules_password'),
(1951, 1, '_adm_txt_modules_process_action_success'),
(1952, 1, '_adm_txt_modules_process_connections'),
(1953, 1, '_adm_txt_modules_process_deleted_profiles'),
(1954, 1, '_adm_txt_modules_process_menu_triggers'),
(1955, 1, '_adm_txt_modules_process_page_triggers'),
(1956, 1, '_adm_txt_modules_process_storages'),
(1957, 1, '_adm_txt_modules_process_failed'),
(1958, 1, '_adm_txt_modules_process_success'),
(1959, 1, '_adm_txt_modules_process_esearches'),
(1960, 1, '_adm_txt_modules_register_transcoders'),
(1961, 1, '_adm_txt_modules_unregister_transcoders'),
(1962, 1, '_adm_txt_modules_show_conclusion'),
(1963, 1, '_adm_txt_modules_show_introduction'),
(1964, 1, '_adm_txt_modules_update_files'),
(1965, 1, '_adm_txt_modules_update_relations'),
(1966, 1, '_adm_txt_modules_update_relations_for_all'),
(1967, 1, '_adm_txt_modules_update_languages'),
(1968, 1, '_adm_txt_modules_update_latest'),
(1969, 1, '_adm_txt_modules_update_text'),
(1970, 1, '_adm_txt_modules_updates'),
(1971, 1, '_adm_txt_modules_upload'),
(1972, 1, '_adm_txt_modules_writable'),
(1973, 1, '_adm_txt_pca_active'),
(1974, 1, '_adm_txt_pca_bookmark'),
(1975, 1, '_adm_txt_pca_featured'),
(1976, 1, '_adm_txt_pca_rearrange'),
(1977, 1, '_adm_txt_remember_me'),
(1978, 1, '_adm_txt_select_module'),
(1979, 1, '_adm_txt_settings'),
(1980, 1, '_adm_txt_show_actions'),
(1981, 1, '_adm_txt_show_help'),
(1982, 1, '_adm_txt_show_help_content_empty'),
(1983, 1, '_adm_txt_uninstall'),
(1984, 1, '_adm_wgt_cpt_api'),
(1985, 1, '_adm_wgt_cpt_agents'),
(1986, 1, '_adm_wgt_cpt_audit'),
(1987, 1, '_adm_wgt_cpt_badges'),
(1988, 1, '_adm_wgt_cpt_builder_forms'),
(1989, 1, '_adm_wgt_cpt_builder_menus'),
(1990, 1, '_adm_wgt_cpt_builder_pages'),
(1991, 1, '_adm_wgt_cpt_builder_permissions'),
(1992, 1, '_adm_wgt_cpt_builder_roles'),
(1993, 1, '_adm_wgt_cpt_dashboard'),
(1994, 1, '_adm_wgt_cpt_designer'),
(1995, 1, '_adm_wgt_cpt_polyglot'),
(1996, 1, '_adm_wgt_cpt_settings'),
(1997, 1, '_adm_wgt_cpt_storages'),
(1998, 1, '_adm_wgt_cpt_store'),
(1999, 1, '_cmt_err_not_enabled'),
(2000, 1, '_cmt_block_comments_title'),
(2001, 1, '_cmt_browse_all'),
(2002, 1, '_cmt_browse_friends'),
(2003, 1, '_cmt_browse_head'),
(2004, 1, '_cmt_browse_popular'),
(2005, 1, '_cmt_browse_subscriptions'),
(2006, 1, '_cmt_browse_tail'),
(2007, 1, '_cmt_display_flat'),
(2008, 1, '_cmt_display_threaded'),
(2009, 1, '_cmt_err_cannot_perform_action'),
(2010, 1, '_cmt_msg_login_required'),
(2011, 1, '_cmt_page_view_header'),
(2012, 1, '_cmt_page_view_title'),
(2013, 1, '_cmt_page_view_title_author'),
(2014, 1, '_cmt_page_view_title_content'),
(2015, 1, '_cmt_download_attached_file'),
(2016, 1, '_cmt_view_attached_image'),
(2017, 1, '_cmt_load_more_comments_head'),
(2018, 1, '_cmt_load_more_comments_tail'),
(2019, 1, '_cmt_load_more_comments_popular'),
(2020, 1, '_cmt_load_more_replies_head'),
(2021, 1, '_cmt_load_more_replies_tail'),
(2022, 1, '_cmt_load_more_replies_popular'),
(2023, 1, '_cmt_txt_new_content'),
(2024, 1, '_cmt_txt_link_show'),
(2025, 1, '_cmt_txt_link_reply'),
(2026, 1, '_cmt_txt_added_sample'),
(2027, 1, '_cmt_txt_or'),
(2028, 1, '_cmt_txt_pinned'),
(2029, 1, '_cmt_txt_sample_comment_single'),
(2030, 1, '_cmt_txt_sample_comment_single_with_article'),
(2031, 1, '_cmt_txt_sample_reaction_single'),
(2032, 1, '_cmt_txt_sample_reply_to'),
(2033, 1, '_cmt_txt_sample_score_up_single'),
(2034, 1, '_cmt_txt_sample_score_down_single'),
(2035, 1, '_cmt_txt_sample_vote_single'),
(2036, 1, '_cmt_txt_added_sample_custom'),
(2037, 1, '_cmt_txt_n_comments'),
(2038, 1, '_cmt_txt_do'),
(2039, 1, '_cmt_txt_counter'),
(2040, 1, '_cmt_txt_counter_empty'),
(2041, 1, '_cmt_txt_min_form_placeholder'),
(2042, 1, '_cmt_txt_note_approve_pending'),
(2043, 1, '_cmt_nts_popup_view_title'),
(2044, 1, '_cmt_nts_popup_view_title_rc'),
(2045, 1, '_cmt_rvw_block_rating_title'),
(2046, 1, '_cmt_rvw_block_reviews_title'),
(2047, 1, '_cmt_rvw_txt_min_form_placeholder'),
(2048, 1, '_cmt_rvw_txt_sample_comment_single'),
(2049, 1, '_cmt_rvw_txt_sample_reaction_single'),
(2050, 1, '_cmt_rvw_txt_sample_score_up_single'),
(2051, 1, '_cmt_rvw_txt_sample_score_down_single'),
(2052, 1, '_cmt_rvw_txt_sample_vote_single'),
(2053, 1, '_cmt_rvw_txt_empty'),
(2054, 1, '_cmt_rvw_txt_do'),
(2055, 1, '_copyright'),
(2056, 1, '_delete'),
(2057, 1, '_error occured'),
(2058, 1, '_from'),
(2059, 1, '_hidden_comment'),
(2060, 1, '_in_reply_to'),
(2061, 1, '_in_reply_to_x'),
(2062, 1, '_item'),
(2063, 1, '_items'),
(2064, 1, '_member_banned'),
(2065, 1, '_message_subject'),
(2066, 1, '_mma_comments_edit_own'),
(2067, 1, '_mma_comments_post'),
(2068, 1, '_mma_comments_remove_own'),
(2069, 1, '_mma_comments_vote'),
(2070, 1, '_mma_get_other_members_emails'),
(2071, 1, '_mma_send_greetings'),
(2072, 1, '_mma_send_messages'),
(2073, 1, '_mma_view_profiles'),
(2074, 1, '_mma_vote'),
(2075, 1, '_month_next'),
(2076, 1, '_month_prev'),
(2077, 1, '_no limit'),
(2078, 1, '_powered_by'),
(2079, 1, '_see_more'),
(2080, 1, '_show_replacement'),
(2081, 1, '_sys_accept'),
(2082, 1, '_sys_accounts'),
(2083, 1, '_sys_access_denied_to_private_content'),
(2084, 1, '_sys_actions'),
(2085, 1, '_sys_active'),
(2086, 1, '_sys_account_settings_email_successfully_submitted'),
(2087, 1, '_sys_account_settings_pwd_successfully_submitted'),
(2088, 1, '_sys_account_settings_info_successfully_submitted'),
(2089, 1, '_sys_acc_confirmation_type_none'),
(2090, 1, '_sys_acc_confirmation_type_email'),
(2091, 1, '_sys_acc_confirmation_type_phone'),
(2092, 1, '_sys_acc_confirmation_type_email_and_phone'),
(2093, 1, '_sys_acc_confirmation_type_email_or_phone'),
(2094, 1, '_sys_acl_action_account'),
(2095, 1, '_sys_acl_action_chart_view'),
(2096, 1, '_sys_acl_action_chart_view_desc'),
(2097, 1, '_sys_acl_action_comments_edit_all'),
(2098, 1, '_sys_acl_action_comments_edit_own'),
(2099, 1, '_sys_acl_action_comments_pin'),
(2100, 1, '_sys_acl_action_comments_post'),
(2101, 1, '_sys_acl_action_comments_remove_all'),
(2102, 1, '_sys_acl_action_comments_remove_in_own_content'),
(2103, 1, '_sys_acl_action_comments_remove_in_group_context'),
(2104, 1, '_sys_acl_action_comments_remove_own'),
(2105, 1, '_sys_acl_action_connect'),
(2106, 1, '_sys_acl_action_create_account'),
(2107, 1, '_sys_acl_action_create_account_desc'),
(2108, 1, '_sys_acl_action_delete_account'),
(2109, 1, '_sys_acl_action_delete_account_desc'),
(2110, 1, '_sys_acl_action_every_period'),
(2111, 1, '_sys_acl_action_favorite'),
(2112, 1, '_sys_acl_action_favorite_view'),
(2113, 1, '_sys_acl_action_feature'),
(2114, 1, '_sys_acl_action_view_view'),
(2115, 1, '_sys_acl_action_view_view_viewers_own'),
(2116, 1, '_sys_acl_action_limit_reached'),
(2117, 1, '_sys_acl_action_not_allowed'),
(2118, 1, '_sys_acl_action_not_allowed_after'),
(2119, 1, '_sys_acl_action_not_allowed_before'),
(2120, 1, '_sys_acl_action_pending'),
(2121, 1, '_sys_acl_action_post_links'),
(2122, 1, '_sys_acl_action_post_links_desc'),
(2123, 1, '_sys_acl_action_use_macros'),
(2124, 1, '_sys_acl_action_use_macros_desc'),
(2125, 1, '_sys_acl_action_set_acl_level'),
(2126, 1, '_sys_acl_action_set_acl_level_desc'),
(2127, 1, '_sys_acl_action_show_membership_levels_in_privacy_groups'),
(2128, 1, '_sys_acl_action_show_membership_levels_in_privacy_groups_desc'),
(2129, 1, '_sys_acl_action_show_membership_private_info'),
(2130, 1, '_sys_acl_action_show_membership_private_info_desc'),
(2131, 1, '_sys_acl_action_set_badge'),
(2132, 1, '_sys_acl_action_set_badge_desc'),
(2133, 1, '_sys_acl_action_switch_to_any_profile'),
(2134, 1, '_sys_acl_action_switch_to_any_profile_desc'),
(2135, 1, '_sys_acl_action_set_acl_as_privacy'),
(2136, 1, '_sys_acl_action_set_acl_as_privacy_desc'),
(2137, 1, '_sys_acl_action_set_form_fields_privacy'),
(2138, 1, '_sys_acl_action_set_form_fields_privacy_desc'),
(2139, 1, '_sys_acl_action_suspended'),
(2140, 1, '_sys_acl_action_unauthenticated'),
(2141, 1, '_sys_acl_action_unconfirmed'),
(2142, 1, '_sys_acl_action_vote'),
(2143, 1, '_sys_acl_action_vote_view'),
(2144, 1, '_sys_acl_action_vote_view_voters'),
(2145, 1, '_sys_acl_action_report'),
(2146, 1, '_sys_acl_action_report_view'),
(2147, 1, '_sys_acl_action_add_block'),
(2148, 1, '_sys_acl_action_edit_block'),
(2149, 1, '_sys_acl_action_translate_block'),
(2150, 1, '_sys_acl_action_delete_version'),
(2151, 1, '_sys_acl_action_delete_block'),
(2152, 1, '_sys_acl_action_history'),
(2153, 1, '_sys_acl_action_unsafe'),
(2154, 1, '_sys_acl_start'),
(2155, 1, '_sys_acl_expire'),
(2156, 1, '_sys_acl_expire_never'),
(2157, 1, '_sys_acl_state'),
(2158, 1, '_sys_acl_state_trial'),
(2159, 1, '_sys_agents_form_field_err_enter'),
(2160, 1, '_sys_agents_form_field_err_select'),
(2161, 1, '_sys_agents_automators_txt_active'),
(2162, 1, '_sys_agents_automators_txt_name'),
(2163, 1, '_sys_agents_automators_txt_type'),
(2164, 1, '_sys_agents_automators_txt_alert_unit'),
(2165, 1, '_sys_agents_automators_txt_alert_action'),
(2166, 1, '_sys_agents_automators_txt_scheduler_time'),
(2167, 1, '_sys_agents_automators_txt_model_id'),
(2168, 1, '_sys_agents_automators_txt_profile_id'),
(2169, 1, '_sys_agents_automators_txt_message_id'),
(2170, 1, '_sys_agents_automators_txt_messages'),
(2171, 1, '_sys_agents_automators_txt_code'),
(2172, 1, '_sys_agents_automators_txt_added'),
(2173, 1, '_sys_agents_automators_txt_status'),
(2174, 1, '_sys_agents_automators_btn_add'),
(2175, 1, '_sys_agents_automators_btn_tune'),
(2176, 1, '_sys_agents_automators_btn_approve'),
(2177, 1, '_sys_agents_automators_popup_add'),
(2178, 1, '_sys_agents_automators_popup_edit'),
(2179, 1, '_sys_agents_automators_field_name'),
(2180, 1, '_sys_agents_automators_field_model_id'),
(2181, 1, '_sys_agents_automators_field_profile_id'),
(2182, 1, '_sys_agents_automators_field_profile_id_inf'),
(2183, 1, '_sys_agents_automators_field_type'),
(2184, 1, '_sys_agents_automators_field_type_event'),
(2185, 1, '_sys_agents_automators_field_type_scheduler'),
(2186, 1, '_sys_agents_automators_field_type_webhook'),
(2187, 1, '_sys_agents_automators_field_alert_unit'),
(2188, 1, '_sys_agents_automators_field_alert_action'),
(2189, 1, '_sys_agents_automators_field_scheduler_time'),
(2190, 1, '_sys_agents_automators_field_providers'),
(2191, 1, '_sys_agents_automators_field_providers_add'),
(2192, 1, '_sys_agents_automators_field_helpers'),
(2193, 1, '_sys_agents_automators_field_helpers_add'),
(2194, 1, '_sys_agents_automators_field_assistants'),
(2195, 1, '_sys_agents_automators_field_assistants_add'),
(2196, 1, '_sys_agents_automators_field_message'),
(2197, 1, '_sys_agents_automators_field_message_err'),
(2198, 1, '_sys_agents_automators_field_status_auto'),
(2199, 1, '_sys_agents_automators_field_status_manual'),
(2200, 1, '_sys_agents_automators_field_status_ready'),
(2201, 1, '_sys_agents_automators_err_event_not_found'),
(2202, 1, '_sys_agents_automators_err_cannot_get_code'),
(2203, 1, '_sys_agents_automators_txt_eval_response'),
(2204, 1, '_sys_agents_providers_txt_active'),
(2205, 1, '_sys_agents_providers_txt_provider_name'),
(2206, 1, '_sys_agents_providers_txt_provider_type'),
(2207, 1, '_sys_agents_providers_txt_added'),
(2208, 1, '_sys_agents_providers_btn_add'),
(2209, 1, '_sys_agents_providers_btn_info'),
(2210, 1, '_sys_agents_providers_btn_edit'),
(2211, 1, '_sys_agents_providers_btn_delete'),
(2212, 1, '_sys_agents_providers_popup_add'),
(2213, 1, '_sys_agents_providers_popup_edit'),
(2214, 1, '_sys_agents_providers_popup_view'),
(2215, 1, '_sys_agents_providers_field_type_id'),
(2216, 1, '_sys_agents_providers_field_type_id_err'),
(2217, 1, '_sys_agents_providers_field_name'),
(2218, 1, '_sys_agents_pvd_cpt_shopify_admin'),
(2219, 1, '_sys_agents_pvd_opt_cpt_active'),
(2220, 1, '_sys_agents_pvd_opt_dsc_active'),
(2221, 1, '_sys_agents_pvd_opt_cpt_shop_domain'),
(2222, 1, '_sys_agents_pvd_opt_dsc_shop_domain'),
(2223, 1, '_sys_agents_pvd_opt_cpt_access_token'),
(2224, 1, '_sys_agents_pvd_opt_dsc_access_token'),
(2225, 1, '_sys_agents_pvd_opt_cpt_secret_key'),
(2226, 1, '_sys_agents_pvd_opt_dsc_secret_key'),
(2227, 1, '_sys_agents_pvd_opt_cpt_webhook_url'),
(2228, 1, '_sys_agents_pvd_opt_dsc_webhook_url'),
(2229, 1, '_sys_agents_helpers_txt_active'),
(2230, 1, '_sys_agents_helpers_txt_name'),
(2231, 1, '_sys_agents_helpers_txt_model_id'),
(2232, 1, '_sys_agents_helpers_txt_profile_id'),
(2233, 1, '_sys_agents_helpers_txt_prompt'),
(2234, 1, '_sys_agents_helpers_txt_added'),
(2235, 1, '_sys_agents_helpers_btn_add'),
(2236, 1, '_sys_agents_helpers_btn_tune'),
(2237, 1, '_sys_agents_helpers_field_name'),
(2238, 1, '_sys_agents_helpers_field_model_id'),
(2239, 1, '_sys_agents_helpers_field_profile_id'),
(2240, 1, '_sys_agents_helpers_field_profile_id_inf'),
(2241, 1, '_sys_agents_helpers_field_description'),
(2242, 1, '_sys_agents_helpers_field_prompt'),
(2243, 1, '_sys_agents_helpers_field_prompt_err'),
(2244, 1, '_sys_agents_helpers_field_message'),
(2245, 1, '_sys_agents_helpers_field_message_err'),
(2246, 1, '_sys_agents_helpers_field_result'),
(2247, 1, '_sys_agents_helpers_popup_add'),
(2248, 1, '_sys_agents_helpers_popup_edit'),
(2249, 1, '_sys_agents_assistants_txt_active'),
(2250, 1, '_sys_agents_assistants_txt_name'),
(2251, 1, '_sys_agents_assistants_txt_model_id'),
(2252, 1, '_sys_agents_assistants_txt_profile_id'),
(2253, 1, '_sys_agents_assistants_txt_prompt'),
(2254, 1, '_sys_agents_assistants_txt_added'),
(2255, 1, '_sys_agents_assistants_txt_assistant'),
(2256, 1, '_sys_agents_assistants_txt_codes_onclick'),
(2257, 1, '_sys_agents_assistants_txt_codes_button'),
(2258, 1, '_sys_agents_assistants_txt_add_knowledge'),
(2259, 1, '_sys_agents_assistants_txt_ask'),
(2260, 1, '_sys_agents_assistants_btn_add'),
(2261, 1, '_sys_agents_assistants_btn_chats'),
(2262, 1, '_sys_agents_assistants_btn_files'),
(2263, 1, '_sys_agents_assistants_btn_codes'),
(2264, 1, '_sys_agents_assistants_field_name'),
(2265, 1, '_sys_agents_assistants_field_model_id'),
(2266, 1, '_sys_agents_assistants_field_profile_id'),
(2267, 1, '_sys_agents_assistants_field_profile_id_inf'),
(2268, 1, '_sys_agents_assistants_field_description'),
(2269, 1, '_sys_agents_assistants_field_prompt'),
(2270, 1, '_sys_agents_assistants_field_prompt_err'),
(2271, 1, '_sys_agents_assistants_field_result'),
(2272, 1, '_sys_agents_assistants_popup_add'),
(2273, 1, '_sys_agents_assistants_popup_edit'),
(2274, 1, '_sys_agents_assistants_chats_txt_name'),
(2275, 1, '_sys_agents_assistants_chats_txt_type'),
(2276, 1, '_sys_agents_assistants_chats_txt_type_1'),
(2277, 1, '_sys_agents_assistants_chats_txt_type_10'),
(2278, 1, '_sys_agents_assistants_chats_txt_description'),
(2279, 1, '_sys_agents_assistants_chats_txt_messages'),
(2280, 1, '_sys_agents_assistants_chats_txt_added'),
(2281, 1, '_sys_agents_assistants_chats_txt_stored'),
(2282, 1, '_sys_agents_assistants_chats_txt_chat'),
(2283, 1, '_sys_agents_assistants_chats_btn_add'),
(2284, 1, '_sys_agents_assistants_chats_btn_chat'),
(2285, 1, '_sys_agents_assistants_chats_btn_store'),
(2286, 1, '_sys_agents_assistants_chats_btn_unstore'),
(2287, 1, '_sys_agents_assistants_chats_field_name'),
(2288, 1, '_sys_agents_assistants_chats_field_description'),
(2289, 1, '_sys_agents_assistants_chats_popup_add'),
(2290, 1, '_sys_agents_assistants_chats_popup_edit'),
(2291, 1, '_sys_agents_assistants_chats_msg_loading'),
(2292, 1, '_sys_agents_assistants_chats_err_no_response'),
(2293, 1, '_sys_agents_assistants_files_txt_name'),
(2294, 1, '_sys_agents_assistants_files_txt_size'),
(2295, 1, '_sys_agents_assistants_files_txt_status'),
(2296, 1, '_sys_agents_assistants_files_txt_status_in_progress'),
(2297, 1, '_sys_agents_assistants_files_txt_status_completed'),
(2298, 1, '_sys_agents_assistants_files_txt_status_failed'),
(2299, 1, '_sys_agents_assistants_files_txt_status_cancelled'),
(2300, 1, '_sys_agents_assistants_files_txt_added'),
(2301, 1, '_sys_agents_assistants_files_btn_add'),
(2302, 1, '_sys_agents_assistants_files_btn_sync'),
(2303, 1, '_sys_agents_assistants_files_btn_delete'),
(2304, 1, '_sys_agents_assistants_files_field_file'),
(2305, 1, '_sys_agents_assistants_files_popup_add'),
(2306, 1, '_sys_agents_assistants_field_kwg_type'),
(2307, 1, '_sys_agents_assistants_field_kwg_type_text'),
(2308, 1, '_sys_agents_assistants_field_kwg_type_faq'),
(2309, 1, '_sys_agents_assistants_field_kwg_text'),
(2310, 1, '_sys_agents_assistants_field_kwg_faq_q'),
(2311, 1, '_sys_agents_assistants_field_kwg_faq_a'),
(2312, 1, '_sys_agents_assistants_popup_add_knowledge'),
(2313, 1, '_sys_agents_assistants_popup_ask'),
(2314, 1, '_sys_agents_assistants_msg_knowledge_added'),
(2315, 1, '_sys_audit_content_info_popup_title'),
(2316, 1, '_sys_audit_action_edit_content'),
(2317, 1, '_sys_audit_action_add_content'),
(2318, 1, '_sys_audit_action_detete_content'),
(2319, 1, '_sys_audit_action_edit_comment'),
(2320, 1, '_sys_audit_action_add_comment'),
(2321, 1, '_sys_audit_action_delete_comment'),
(2322, 1, '_sys_audit_action_feature'),
(2323, 1, '_sys_audit_action_unfeature'),
(2324, 1, '_sys_audit_action_resolve'),
(2325, 1, '_sys_audit_action_group_to_admins'),
(2326, 1, '_sys_audit_action_group_from_admins'),
(2327, 1, '_sys_audit_action_group_role_changed'),
(2328, 1, '_sys_audit_action_group_join_request_accepted'),
(2329, 1, '_sys_audit_action_account_change_role_to_3'),
(2330, 1, '_sys_audit_action_account_change_role_to_1'),
(2331, 1, '_sys_audit_action_account_unlock'),
(2332, 1, '_sys_audit_action_account_login'),
(2333, 1, '_sys_audit_action_account_failed_login_attempt'),
(2334, 1, '_sys_audit_action_account_logout'),
(2335, 1, '_sys_audit_action_account_reset_password'),
(2336, 1, '_sys_audit_action_account_resend_confirmation_email'),
(2337, 1, '_sys_audit_action_account_deleted_with_content'),
(2338, 1, '_sys_audit_action_account_deleted'),
(2339, 1, '_sys_audit_action_account_email_changed'),
(2340, 1, '_sys_audit_action_account_activated'),
(2341, 1, '_sys_audit_action_account_suspended'),
(2342, 1, '_sys_audit_action_content_enabled'),
(2343, 1, '_sys_audit_action_content_disabled'),
(2344, 1, '_sys_audit_action_set_membership'),
(2345, 1, '_sys_audit_action_set_status_approve'),
(2346, 1, '_sys_audit_action_set_status_active'),
(2347, 1, '_sys_audit_action_set_status_disapprove'),
(2348, 1, '_sys_audit_action_set_status_suspended'),
(2349, 1, '_sys_audit_action_report'),
(2350, 1, '_sys_audit_action_report_comment'),
(2351, 1, '_sys_audit_action_lock'),
(2352, 1, '_sys_audit_action_unlock'),
(2353, 1, '_sys_audit_action_stick'),
(2354, 1, '_sys_audit_action_unstick'),
(2355, 1, '_sys_audit_action_promote'),
(2356, 1, '_sys_audit_action_unpromote'),
(2357, 1, '_sys_add_friend'),
(2358, 1, '_sys_add_relation'),
(2359, 1, '_sys_adm_installed'),
(2360, 1, '_sys_admin_apply'),
(2361, 1, '_sys_admin_filter'),
(2362, 1, '_sys_audit_filter_profile_select'),
(2363, 1, '_sys_audit_filter_action_select'),
(2364, 1, '_sys_audit_cron_jobs'),
(2365, 1, '_sys_audit_cron_jobs_exec_time'),
(2366, 1, '_sys_audit_header_manual_audit'),
(2367, 1, '_sys_audit_header_requirements'),
(2368, 1, '_sys_audit_header_site_optimization'),
(2369, 1, '_sys_audit_header_site_setup'),
(2370, 1, '_sys_audit_mail_sending'),
(2371, 1, '_sys_audit_msg_apache_module_fail'),
(2372, 1, '_sys_audit_msg_cron_jobs'),
(2373, 1, '_sys_audit_msg_optimization_fail'),
(2374, 1, '_sys_audit_msg_optimization_warn'),
(2375, 1, '_sys_audit_msg_x_based_cache_engine'),
(2376, 1, '_sys_audit_msg_ffmpeg'),
(2377, 1, '_sys_audit_msg_hardware_requirements'),
(2378, 1, '_sys_audit_msg_mail_send_failed'),
(2379, 1, '_sys_audit_msg_mail_sending'),
(2380, 1, '_sys_audit_msg_mail_sent'),
(2381, 1, '_sys_audit_msg_manual_audit'),
(2382, 1, '_sys_audit_msg_must_be'),
(2383, 1, '_sys_audit_msg_optimization_apache_module'),
(2384, 1, '_sys_audit_msg_permissions'),
(2385, 1, '_sys_audit_msg_php_accelerator_missing'),
(2386, 1, '_sys_audit_msg_php_setup_inefficient'),
(2387, 1, '_sys_audit_msg_serverside_compression'),
(2388, 1, '_sys_audit_msg_should_be'),
(2389, 1, '_sys_audit_msg_userside_caching'),
(2390, 1, '_sys_audit_msg_value_checking_failed'),
(2391, 1, '_sys_audit_msg_version_is_incompatible'),
(2392, 1, '_sys_audit_msg_version_is_outdated'),
(2393, 1, '_sys_audit_permissions'),
(2394, 1, '_sys_audit_php_accelerator'),
(2395, 1, '_sys_audit_php_setup'),
(2396, 1, '_sys_audit_section_hardware'),
(2397, 1, '_sys_audit_section_os'),
(2398, 1, '_sys_audit_section_webserver'),
(2399, 1, '_sys_audit_serverside_compression'),
(2400, 1, '_sys_audit_title_fail'),
(2401, 1, '_sys_audit_title_ok'),
(2402, 1, '_sys_audit_title_undef'),
(2403, 1, '_sys_audit_title_warn'),
(2404, 1, '_sys_audit_userside_caching'),
(2405, 1, '_sys_audit_version'),
(2406, 1, '_sys_audit_version_script'),
(2407, 1, '_sys_block_type_custom'),
(2408, 1, '_sys_block_type_html'),
(2409, 1, '_sys_block_type_image'),
(2410, 1, '_sys_block_type_lang'),
(2411, 1, '_sys_block_type_creative'),
(2412, 1, '_sys_block_type_bento_grid'),
(2413, 1, '_sys_block_type_menu'),
(2414, 1, '_sys_block_type_raw'),
(2415, 1, '_sys_block_type_rss'),
(2416, 1, '_sys_block_type_wiki'),
(2417, 1, '_sys_block_type_service'),
(2418, 1, '_sys_block_types_custom'),
(2419, 1, '_sys_block_types_skeletons'),
(2420, 1, '_sys_block_types_system'),
(2421, 1, '_sys_cmts'),
(2422, 1, '_sys_cmts_administration_grid_column_title_adm_active'),
(2423, 1, '_sys_cmts_administration_grid_column_title_adm_cmt_module'),
(2424, 1, '_sys_cmts_administration_grid_column_title_adm_cmt_text'),
(2425, 1, '_sys_cmts_administration_grid_column_title_adm_cmt_time'),
(2426, 1, '_sys_cmts_administration_grid_column_title_adm_cmt_author_id'),
(2427, 1, '_sys_cmts_administration_grid_action_title_adm_delete'),
(2428, 1, '_sys_chart_growth_object'),
(2429, 1, '_sys_chart_growth_date_from'),
(2430, 1, '_sys_chart_growth_date_to'),
(2431, 1, '_sys_chart_accounts_growth'),
(2432, 1, '_sys_chart_accounts_growth_speed'),
(2433, 1, '_sys_close'),
(2434, 1, '_sys_confirm'),
(2435, 1, '_sys_confirmed'),
(2436, 1, '_sys_conn_err_connection_already_exists'),
(2437, 1, '_sys_conn_err_connection_does_not_exists'),
(2438, 1, '_sys_conn_err_connection_is_awaiting_confirmation'),
(2439, 1, '_sys_conn_err_input_data_is_not_defined'),
(2440, 1, '_sys_conn_msg_success'),
(2441, 1, '_sys_connect_information'),
(2442, 1, '_sys_connect_error_join_unavailable'),
(2443, 1, '_sys_connect_profile_error_info'),
(2444, 1, '_sys_connect_state_invalid'),
(2445, 1, '_sys_connect_adm_stg_cpt_category_general'),
(2446, 1, '_sys_connect_option_redirect'),
(2447, 1, '_sys_connect_option_module'),
(2448, 1, '_sys_connect_option_confirm_email'),
(2449, 1, '_sys_connect_option_approve'),
(2450, 1, '_sys_connect_option_privacy'),
(2451, 1, '_sys_currency'),
(2452, 1, '_sys_decline'),
(2453, 1, '_sys_designbox_0'),
(2454, 1, '_sys_designbox_1'),
(2455, 1, '_sys_designbox_10'),
(2456, 1, '_sys_designbox_11'),
(2457, 1, '_sys_designbox_13'),
(2458, 1, '_sys_designbox_14'),
(2459, 1, '_sys_designbox_2'),
(2460, 1, '_sys_designbox_3'),
(2461, 1, '_sys_designbox_4'),
(2462, 1, '_sys_done'),
(2463, 1, '_sys_et_txt_about_us'),
(2464, 1, '_sys_et_txt_body_admin_email'),
(2465, 1, '_sys_et_txt_body_comment_replied'),
(2466, 1, '_sys_et_txt_body_system_reported'),
(2467, 1, '_sys_et_txt_body_confirmation'),
(2468, 1, '_sys_et_txt_body_delayed_module_uninstall'),
(2469, 1, '_sys_et_txt_body_forgot'),
(2470, 1, '_sys_et_txt_body_mem_changed'),
(2471, 1, '_sys_et_txt_body_mem_prolonged'),
(2472, 1, '_sys_et_txt_body_mem_expiration'),
(2473, 1, '_sys_et_txt_body_profile_change_status_active'),
(2474, 1, '_sys_et_txt_body_profile_change_status_pending'),
(2475, 1, '_sys_et_txt_body_profile_change_status_suspended'),
(2476, 1, '_sys_et_txt_body_account_change_status_activate'),
(2477, 1, '_sys_et_txt_body_account_change_status_suspended'),
(2478, 1, '_sys_et_txt_body_account');
INSERT INTO `sys_localization_keys` VALUES
(2479, 1, '_sys_et_txt_body_account_password_expired'),
(2480, 1, '_sys_et_txt_body_pruning'),
(2481, 1, '_sys_et_txt_body_upgrade_failed'),
(2482, 1, '_sys_et_txt_body_upgrade_modules_failed'),
(2483, 1, '_sys_et_txt_body_upgrade_success'),
(2484, 1, '_sys_et_txt_body_upgrade_modules_success'),
(2485, 1, '_sys_et_txt_body_bg_operation_failed'),
(2486, 1, '_sys_et_txt_body_manage_approve'),
(2487, 1, '_sys_et_txt_body_modules_upgrade_success'),
(2488, 1, '_sys_et_txt_body_modules_upgrade_failed'),
(2489, 1, '_sys_et_txt_name_system_admin_email'),
(2490, 1, '_sys_et_txt_name_system_comment_replied'),
(2491, 1, '_sys_et_txt_name_system_reported'),
(2492, 1, '_sys_et_txt_name_system_confirmation'),
(2493, 1, '_sys_et_txt_name_system_delayed_module_uninstall'),
(2494, 1, '_sys_et_txt_name_system_forgot'),
(2495, 1, '_sys_et_txt_name_system_mem_changed'),
(2496, 1, '_sys_et_txt_name_system_mem_prolonged'),
(2497, 1, '_sys_et_txt_name_system_mem_expiration'),
(2498, 1, '_sys_et_txt_name_profile_change_status_active'),
(2499, 1, '_sys_et_txt_name_profile_change_status_pending'),
(2500, 1, '_sys_et_txt_name_profile_change_status_suspended'),
(2501, 1, '_sys_et_txt_name_account_change_status_activate'),
(2502, 1, '_sys_et_txt_name_account_change_status_suspended'),
(2503, 1, '_sys_et_txt_name_manage_approve'),
(2504, 1, '_sys_et_txt_name_system_account'),
(2505, 1, '_sys_et_txt_name_system_account_password_expired'),
(2506, 1, '_sys_et_txt_name_system_pruning'),
(2507, 1, '_sys_et_txt_name_upgrade_failed'),
(2508, 1, '_sys_et_txt_name_upgrade_modules_failed'),
(2509, 1, '_sys_et_txt_name_upgrade_success'),
(2510, 1, '_sys_et_txt_name_upgrade_modules_success'),
(2511, 1, '_sys_et_txt_name_bg_operation_failed'),
(2512, 1, '_sys_et_txt_subject_admin_email'),
(2513, 1, '_sys_et_txt_subject_comment_replied'),
(2514, 1, '_sys_et_txt_subject_system_reported'),
(2515, 1, '_sys_et_txt_subject_confirmation'),
(2516, 1, '_sys_et_txt_subject_delayed_module_uninstall'),
(2517, 1, '_sys_et_txt_subject_forgot'),
(2518, 1, '_sys_et_txt_subject_mem_changed'),
(2519, 1, '_sys_et_txt_subject_mem_prolonged'),
(2520, 1, '_sys_et_txt_subject_mem_expiration'),
(2521, 1, '_sys_et_txt_subject_profile_change_status_active'),
(2522, 1, '_sys_et_txt_subject_profile_change_status_pending'),
(2523, 1, '_sys_et_txt_subject_profile_change_status_suspended'),
(2524, 1, '_sys_et_txt_subject_account_change_status_activate'),
(2525, 1, '_sys_et_txt_subject_account_change_status_suspended'),
(2526, 1, '_sys_et_txt_subject_manage_approve'),
(2527, 1, '_sys_et_txt_subject_account'),
(2528, 1, '_sys_et_txt_subject_account_password_expired'),
(2529, 1, '_sys_et_txt_subject_pruning'),
(2530, 1, '_sys_et_txt_subject_upgrade_failed'),
(2531, 1, '_sys_et_txt_subject_upgrade_modules_failed'),
(2532, 1, '_sys_et_txt_subject_upgrade_success'),
(2533, 1, '_sys_et_txt_subject_upgrade_modules_success'),
(2534, 1, '_sys_et_txt_subject_bg_operation_failed'),
(2535, 1, '_sys_et_txt_unsubscribe'),
(2536, 1, '_sys_file_handlers_ms_viewer'),
(2537, 1, '_sys_file_handlers_google_viewer'),
(2538, 1, '_sys_file_handlers_images_viewer'),
(2539, 1, '_sys_file_handlers_code_viewer'),
(2540, 1, '_sys_file_handlers_sounds_viewer'),
(2541, 1, '_sys_file_handlers_videos_viewer'),
(2542, 1, '_sys_form_account'),
(2543, 1, '_sys_form_account_input_agreement'),
(2544, 1, '_sys_form_account_input_agreement_value'),
(2545, 1, '_sys_form_account_input_captcha'),
(2546, 1, '_sys_form_account_input_captcha_error'),
(2547, 1, '_sys_form_account_input_captcha_label_text_image'),
(2548, 1, '_sys_form_account_input_captcha_label_text_audio'),
(2549, 1, '_sys_form_account_input_captcha_action_refresh'),
(2550, 1, '_sys_form_account_input_captcha_action_title_refresh'),
(2551, 1, '_sys_form_account_input_captcha_action_audio'),
(2552, 1, '_sys_form_account_input_captcha_action_title_audio'),
(2553, 1, '_sys_form_account_input_captcha_action_image'),
(2554, 1, '_sys_form_account_input_captcha_action_title_image'),
(2555, 1, '_sys_form_account_input_captcha_action_help'),
(2556, 1, '_sys_form_account_input_captcha_action_title_help'),
(2557, 1, '_sys_form_account_input_delete_confirm'),
(2558, 1, '_sys_form_account_input_delete_confirm_wo_content'),
(2559, 1, '_sys_form_account_input_delete_confirm_error'),
(2560, 1, '_sys_form_account_input_delete_confirm_info'),
(2561, 1, '_sys_form_account_input_email'),
(2562, 1, '_sys_form_account_input_email_error'),
(2563, 1, '_sys_form_account_input_email_uniq_error'),
(2564, 1, '_sys_form_account_input_email_uniq_error_loggedin'),
(2565, 1, '_sys_form_account_input_phone_uniq_error_loggedin'),
(2566, 1, '_sys_form_account_input_name'),
(2567, 1, '_sys_form_account_input_name_error'),
(2568, 1, '_sys_form_account_input_password'),
(2569, 1, '_sys_form_account_input_password_confirm'),
(2570, 1, '_sys_form_account_input_password_confirm_error'),
(2571, 1, '_sys_form_account_input_password_current'),
(2572, 1, '_sys_form_account_input_password_error_old_used'),
(2573, 1, '_sys_form_account_input_password_current_error'),
(2574, 1, '_sys_form_account_input_password_error'),
(2575, 1, '_sys_form_account_input_receive_news'),
(2576, 1, '_sys_form_account_input_receive_updates'),
(2577, 1, '_sys_form_account_input_submit'),
(2578, 1, '_sys_form_account_input_publish'),
(2579, 1, '_sys_form_agents_comment'),
(2580, 1, '_sys_form_display_agents_comment_post'),
(2581, 1, '_sys_form_agents_comment_input_caption_system_action'),
(2582, 1, '_sys_form_agents_comment_input_caption_system_cmt_image'),
(2583, 1, '_sys_form_agents_comment_input_caption_system_cmt_parent_id'),
(2584, 1, '_sys_form_agents_comment_input_caption_system_cmt_submit'),
(2585, 1, '_sys_form_agents_comment_input_caption_cmt_submit'),
(2586, 1, '_sys_form_agents_comment_input_caption_system_cmt_text'),
(2587, 1, '_sys_form_agents_comment_input_caption_system_id'),
(2588, 1, '_sys_form_agents_comment_input_caption_system_sys'),
(2589, 1, '_sys_form_checkbox_value_off'),
(2590, 1, '_sys_form_checkbox_value_on'),
(2591, 1, '_sys_form_input_caption_author'),
(2592, 1, '_sys_form_comment'),
(2593, 1, '_sys_form_comment_input_caption_cmt_author_id'),
(2594, 1, '_sys_form_comment_input_caption_cmt_text'),
(2595, 1, '_sys_form_comment_input_caption_system_action'),
(2596, 1, '_sys_form_comment_input_caption_system_cmt_author_id'),
(2597, 1, '_sys_form_comment_input_caption_system_cmt_cancel'),
(2598, 1, '_sys_form_comment_input_caption_system_cmt_id'),
(2599, 1, '_sys_form_comment_input_caption_system_cmt_image'),
(2600, 1, '_sys_form_comment_input_caption_system_cmt_parent_id'),
(2601, 1, '_sys_form_comment_input_caption_system_cmt_submit'),
(2602, 1, '_sys_form_comment_input_caption_system_cmt_text'),
(2603, 1, '_sys_form_comment_input_caption_system_id'),
(2604, 1, '_sys_form_comment_input_caption_system_sys'),
(2605, 1, '_sys_form_comment_input_cancel'),
(2606, 1, '_sys_form_comment_input_submit'),
(2607, 1, '_sys_form_confirm_email'),
(2608, 1, '_sys_form_confirm_email_input_caption_system_code'),
(2609, 1, '_sys_form_confirm_email_input_caption_system_do_submit'),
(2610, 1, '_sys_form_confirm_email_input_code'),
(2611, 1, '_sys_form_confirm_email_input_code_error'),
(2612, 1, '_sys_form_confirm_email_input_submit'),
(2613, 1, '_sys_form_confirm_phone'),
(2614, 1, '_sys_form_confirm_phone_input_caption_system_phone'),
(2615, 1, '_sys_form_confirm_phone_input_phone'),
(2616, 1, '_sys_form_confirm_phone_input_phone_info'),
(2617, 1, '_sys_form_confirm_phone_input_phone_error_format'),
(2618, 1, '_sys_form_confirm_phone_input_phone_error_not_unique'),
(2619, 1, '_sys_form_confirm_phone_input_caption_system_code'),
(2620, 1, '_sys_form_confirm_phone_confirmation_input_code'),
(2621, 1, '_sys_form_confirm_phone_input_submit'),
(2622, 1, '_sys_form_confirm_phone_input_caption_system_do_submit'),
(2623, 1, '_sys_form_confirm_phone_input_sendsms'),
(2624, 1, '_sys_form_confirm_phone_input_caption_system_do_sendsms'),
(2625, 1, '_sys_form_confirm_phone_input_code_error_empty'),
(2626, 1, '_sys_form_confirm_phone_input_code_error_invalid'),
(2627, 1, '_sys_form_account_input_phone_error'),
(2628, 1, '_sys_form_display_account_create'),
(2629, 1, '_sys_form_display_account_settings_delete'),
(2630, 1, '_sys_form_display_account_settings_email'),
(2631, 1, '_sys_form_display_account_settings_info'),
(2632, 1, '_sys_form_display_account_settings_password'),
(2633, 1, '_sys_form_display_comment_edit'),
(2634, 1, '_sys_form_display_comment_post'),
(2635, 1, '_sys_form_display_confirm_email'),
(2636, 1, '_sys_form_display_confirm_phone_set_phone'),
(2637, 1, '_sys_form_display_confirm_phone_confirmation'),
(2638, 1, '_sys_form_display_forgot_password'),
(2639, 1, '_sys_form_display_forgot_password_reset'),
(2640, 1, '_sys_form_display_login'),
(2641, 1, '_sys_form_display_login_step2'),
(2642, 1, '_sys_form_display_login_step3'),
(2643, 1, '_sys_form_display_report_post'),
(2644, 1, '_sys_form_display_unsubscribe_news'),
(2645, 1, '_sys_form_display_unsubscribe_updates'),
(2646, 1, '_sys_form_forgot_password'),
(2647, 1, '_sys_form_forgot_password_email_not_recognized'),
(2648, 1, '_sys_form_forgot_password_phone_not_recognized'),
(2649, 1, '_sys_form_forgot_password_phone_error_format'),
(2650, 1, '_sys_form_forgot_password_phone_and_email_empty_error'),
(2651, 1, '_sys_form_forgot_password_input_caption_system_do_submit'),
(2652, 1, '_sys_form_forgot_password_input_caption_system_email'),
(2653, 1, '_sys_form_forgot_password_input_caption_system_key'),
(2654, 1, '_sys_form_forgot_password_input_caption_system_password'),
(2655, 1, '_sys_form_forgot_password_input_caption_password'),
(2656, 1, '_sys_form_forgot_password_input_caption_system_password_reset'),
(2657, 1, '_sys_form_forgot_password_input_caption_password_reset'),
(2658, 1, '_sys_form_forgot_password_input_email'),
(2659, 1, '_sys_form_forgot_password_input_caption_system_phone'),
(2660, 1, '_sys_form_forgot_password_input_phone'),
(2661, 1, '_sys_form_forgot_password_input_submit'),
(2662, 1, '_sys_form_input_age'),
(2663, 1, '_sys_form_input_sys_location'),
(2664, 1, '_sys_form_input_location'),
(2665, 1, '_sys_form_input_location_radius_label'),
(2666, 1, '_sys_form_input_nested_form_button_add_new_item'),
(2667, 1, '_sys_form_input_nested_form_button_delete_item'),
(2668, 1, '_sys_form_input_sys_anonymous'),
(2669, 1, '_sys_form_input_anonymous'),
(2670, 1, '_sys_form_input_sys_labels'),
(2671, 1, '_sys_form_input_labels'),
(2672, 1, '_sys_form_input_labels_placeholder'),
(2673, 1, '_sys_form_input_password_show'),
(2674, 1, '_sys_form_input_password_hide'),
(2675, 1, '_sys_form_labels'),
(2676, 1, '_sys_form_labels_display_select'),
(2677, 1, '_sys_form_labels_input_caption_system_name'),
(2678, 1, '_sys_form_labels_input_caption_system_action'),
(2679, 1, '_sys_form_labels_input_caption_system_search'),
(2680, 1, '_sys_form_labels_input_caption_search'),
(2681, 1, '_sys_form_labels_input_caption_system_list'),
(2682, 1, '_sys_form_labels_input_caption_list'),
(2683, 1, '_sys_form_labels_input_caption_system_list_context'),
(2684, 1, '_sys_form_labels_input_caption_list_context'),
(2685, 1, '_sys_form_labels_input_caption_do_submit'),
(2686, 1, '_sys_form_labels_input_caption_system_do_submit'),
(2687, 1, '_sys_form_labels_input_caption_do_cancel'),
(2688, 1, '_sys_form_labels_input_caption_system_do_cancel'),
(2689, 1, '_sys_form_login'),
(2690, 1, '_sys_form_login_input_caption_system_agreement'),
(2691, 1, '_sys_form_login_input_caption_system_captcha'),
(2692, 1, '_sys_form_login_input_caption_system_checkcode'),
(2693, 1, '_sys_form_login_input_caption_system_code'),
(2694, 1, '_sys_form_login_input_caption_system_back'),
(2695, 1, '_sys_form_login_input_caption_system_delete_confirm'),
(2696, 1, '_sys_form_login_input_caption_system_delete_content'),
(2697, 1, '_sys_form_login_input_caption_system_do_submit'),
(2698, 1, '_sys_form_login_input_caption_system_do_publish'),
(2699, 1, '_sys_form_login_input_caption_system_email'),
(2700, 1, '_sys_form_login_input_caption_system_id'),
(2701, 1, '_sys_form_login_input_caption_system_name'),
(2702, 1, '_sys_form_login_input_caption_system_password'),
(2703, 1, '_sys_form_login_input_caption_system_password_confirm'),
(2704, 1, '_sys_form_login_input_caption_system_phone'),
(2705, 1, '_sys_form_login_input_caption_system_password_current'),
(2706, 1, '_sys_form_login_input_caption_system_receive_news'),
(2707, 1, '_sys_form_login_input_caption_system_receive_updates'),
(2708, 1, '_sys_form_login_input_caption_system_relocate'),
(2709, 1, '_sys_form_login_input_caption_system_remember_me'),
(2710, 1, '_sys_form_login_input_caption_system_role'),
(2711, 1, '_sys_form_login_input_caption_system_sendsms'),
(2712, 1, '_sys_form_login_input_caption_system_submit'),
(2713, 1, '_sys_form_login_input_caption_system_submit_text'),
(2714, 1, '_sys_form_login_input_agreement_value'),
(2715, 1, '_sys_form_login_input_code'),
(2716, 1, '_sys_form_login_input_back'),
(2717, 1, '_sys_form_login_input_checkcode'),
(2718, 1, '_sys_form_login_input_email'),
(2719, 1, '_sys_form_login_input_password'),
(2720, 1, '_sys_form_login_input_phone'),
(2721, 1, '_sys_form_login_input_phone_info'),
(2722, 1, '_sys_form_login_input_remember_me'),
(2723, 1, '_sys_form_login_input_sendsms'),
(2724, 1, '_sys_form_login_input_submit'),
(2725, 1, '_sys_form_login_input_code_error_empty'),
(2726, 1, '_sys_form_login_input_phone_error_format'),
(2727, 1, '_sys_form_login_input_phone_error_not_unique'),
(2728, 1, '_sys_form_login_input_code_error_invalid'),
(2729, 1, '_sys_form_manage'),
(2730, 1, '_sys_form_display_manage_approve'),
(2731, 1, '_sys_form_manage_input_sys_content_id'),
(2732, 1, '_sys_form_manage_input_sys_notes'),
(2733, 1, '_sys_form_manage_input_notes'),
(2734, 1, '_sys_form_manage_input_sys_do_send'),
(2735, 1, '_sys_form_manage_input_do_send'),
(2736, 1, '_sys_form_manage_input_sys_do_submit'),
(2737, 1, '_sys_form_manage_input_do_submit'),
(2738, 1, '_sys_form_manage_input_do_submit_approve'),
(2739, 1, '_sys_form_manage_input_sys_do_cancel'),
(2740, 1, '_sys_form_manage_input_do_cancel'),
(2741, 1, '_sys_form_acl'),
(2742, 1, '_sys_form_display_acl_set'),
(2743, 1, '_sys_form_popup_acl_set'),
(2744, 1, '_sys_form_acl_input_sys_level_id'),
(2745, 1, '_sys_form_acl_input_level_id'),
(2746, 1, '_sys_form_acl_input_sys_duration'),
(2747, 1, '_sys_form_acl_input_duration'),
(2748, 1, '_sys_form_acl_input_duration_inf'),
(2749, 1, '_sys_form_acl_input_sys_do_submit'),
(2750, 1, '_sys_form_acl_input_do_submit'),
(2751, 1, '_sys_form_acl_input_sys_do_cancel'),
(2752, 1, '_sys_form_acl_input_do_cancel'),
(2753, 1, '_sys_form_entry_input_sys_cf'),
(2754, 1, '_sys_form_entry_input_cf'),
(2755, 1, '_sys_form_paceholder_profiles_suggestions'),
(2756, 1, '_sys_form_profile'),
(2757, 1, '_sys_form_display_profile_cf_set'),
(2758, 1, '_sys_form_display_profile_cf_manage'),
(2759, 1, '_sys_form_profile_input_sys_cfw_value'),
(2760, 1, '_sys_form_profile_input_cfw_value'),
(2761, 1, '_sys_form_profile_input_sys_cfu_items'),
(2762, 1, '_sys_form_profile_input_cfu_items'),
(2763, 1, '_sys_form_profile_input_sys_cfu_locked'),
(2764, 1, '_sys_form_profile_input_cfu_locked'),
(2765, 1, '_sys_form_profile_input_sys_do_submit'),
(2766, 1, '_sys_form_profile_input_do_submit'),
(2767, 1, '_sys_form_profile_input_sys_do_cancel'),
(2768, 1, '_sys_form_profile_input_do_cancel'),
(2769, 1, '_sys_profile_cf_set_successfully_submitted'),
(2770, 1, '_sys_profile_cf_manage_successfully_submitted'),
(2771, 1, '_sys_profile_cf_manage_popup'),
(2772, 1, '_sys_form_ps_group_custom'),
(2773, 1, '_sys_form_display_ps_gc_members'),
(2774, 1, '_sys_form_display_ps_gc_memberships'),
(2775, 1, '_sys_form_ps_gc_input_caption_system_profile_id'),
(2776, 1, '_sys_form_ps_gc_input_caption_system_content_id'),
(2777, 1, '_sys_form_ps_gc_input_caption_system_object'),
(2778, 1, '_sys_form_ps_gc_input_caption_system_action'),
(2779, 1, '_sys_form_ps_gc_input_caption_system_group_id'),
(2780, 1, '_sys_form_ps_gc_input_caption_system_search'),
(2781, 1, '_sys_form_ps_gc_input_caption_search'),
(2782, 1, '_sys_form_ps_gc_input_caption_system_list'),
(2783, 1, '_sys_form_ps_gc_input_caption_list'),
(2784, 1, '_sys_form_ps_gc_input_caption_system_memberships'),
(2785, 1, '_sys_form_ps_gc_input_caption_memberships'),
(2786, 1, '_sys_form_ps_gc_input_caption_system_do_submit'),
(2787, 1, '_sys_form_ps_gc_input_caption_do_submit'),
(2788, 1, '_sys_form_ps_gc_input_caption_system_do_cancel'),
(2789, 1, '_sys_form_ps_gc_input_caption_do_cancel'),
(2790, 1, '_sys_form_favorite'),
(2791, 1, '_sys_form_display_favorite_add'),
(2792, 1, '_sys_form_display_favorite_list_edit'),
(2793, 1, '_sys_form_favorite_input_caption_system_sys'),
(2794, 1, '_sys_form_favorite_input_caption_system_list_id'),
(2795, 1, '_sys_form_favorite_input_caption_system_object_id'),
(2796, 1, '_sys_form_favorite_input_caption_system_action'),
(2797, 1, '_sys_form_favorite_input_caption_system_id'),
(2798, 1, '_sys_form_favorite_input_caption_system_list'),
(2799, 1, '_sys_form_favorite_input_caption_list'),
(2800, 1, '_sys_form_favorite_input_caption_system_title'),
(2801, 1, '_sys_form_favorite_input_caption_title'),
(2802, 1, '_sys_form_favorite_input_caption_system_allow_view_to'),
(2803, 1, '_sys_form_favorite_input_caption_allow_view_to'),
(2804, 1, '_sys_form_favorite_input_caption_submit'),
(2805, 1, '_sys_form_favorite_input_caption_system_submit'),
(2806, 1, '_sys_form_favorite_input_caption_button_new_list'),
(2807, 1, '_sys_form_favorite_list_title_count'),
(2808, 1, '_sys_form_favorite_list_title_created'),
(2809, 1, '_sys_form_favorite_list_title_updated'),
(2810, 1, '_sys_form_favorite_list_title_visibility'),
(2811, 1, '_sys_txt_default_favorite_list'),
(2812, 1, '_sys_form_report'),
(2813, 1, '_sys_form_report_input_caption_submit'),
(2814, 1, '_sys_form_report_input_caption_text'),
(2815, 1, '_sys_form_report_input_caption_type'),
(2816, 1, '_sys_form_report_input_caption_system_action'),
(2817, 1, '_sys_form_report_input_caption_system_object_id'),
(2818, 1, '_sys_form_report_input_caption_system_id'),
(2819, 1, '_sys_form_report_input_caption_system_submit'),
(2820, 1, '_sys_form_report_input_caption_system_text'),
(2821, 1, '_sys_form_report_input_caption_system_type'),
(2822, 1, '_sys_form_report_input_caption_system_sys'),
(2823, 1, '_sys_form_review'),
(2824, 1, '_sys_form_review_display_edit'),
(2825, 1, '_sys_form_review_display_post'),
(2826, 1, '_sys_form_review_input_caption_cmt_author_id'),
(2827, 1, '_sys_form_review_input_caption_cmt_text'),
(2828, 1, '_sys_form_review_input_caption_system_action'),
(2829, 1, '_sys_form_review_input_caption_system_cmt_author_id'),
(2830, 1, '_sys_form_review_input_caption_system_cmt_id'),
(2831, 1, '_sys_form_review_input_caption_system_cmt_image'),
(2832, 1, '_sys_form_review_input_caption_system_cmt_parent_id'),
(2833, 1, '_sys_form_review_input_caption_system_cmt_submit'),
(2834, 1, '_sys_form_review_input_caption_system_cmt_text'),
(2835, 1, '_sys_form_review_input_caption_system_cmt_mood'),
(2836, 1, '_sys_form_review_input_caption_system_id'),
(2837, 1, '_sys_form_review_input_caption_system_sys'),
(2838, 1, '_sys_form_review_input_submit'),
(2839, 1, '_sys_form_unsubscribe'),
(2840, 1, '_sys_form_unsubscribe_input_caption_system_code'),
(2841, 1, '_sys_form_unsubscribe_input_caption_system_do_submit'),
(2842, 1, '_sys_form_unsubscribe_input_caption_system_id'),
(2843, 1, '_sys_form_unsubscribe_input_caption_system_receive_news'),
(2844, 1, '_sys_form_unsubscribe_input_caption_system_receive_updates'),
(2845, 1, '_sys_form_unsubscribe_input_receive_news'),
(2846, 1, '_sys_form_unsubscribe_input_receive_updates'),
(2847, 1, '_sys_form_unsubscribe_input_submit'),
(2848, 1, '_sys_form_err_not_unique_value'),
(2849, 1, '_sys_form_txt_select_file'),
(2850, 1, '_sys_form_wiki'),
(2851, 1, '_sys_form_display_wiki_edit'),
(2852, 1, '_sys_form_display_wiki_translate'),
(2853, 1, '_sys_form_wiki_input_caption_block_id'),
(2854, 1, '_sys_form_wiki_input_caption_lang'),
(2855, 1, '_sys_form_wiki_input_caption_lang_info'),
(2856, 1, '_sys_form_wiki_input_caption_lang_err'),
(2857, 1, '_sys_form_wiki_input_caption_content'),
(2858, 1, '_sys_form_wiki_input_caption_content_info'),
(2859, 1, '_sys_form_wiki_input_caption_content_main'),
(2860, 1, '_sys_form_wiki_input_caption_notes'),
(2861, 1, '_sys_form_wiki_input_caption_submit'),
(2862, 1, '_sys_form_wiki_input_caption_close'),
(2863, 1, '_sys_form_wiki_input_caption_files'),
(2864, 1, '_sys_form_wiki_buttons'),
(2865, 1, '_sys_format_size_b'),
(2866, 1, '_sys_format_size_gb'),
(2867, 1, '_sys_format_size_kb'),
(2868, 1, '_sys_format_size_mb'),
(2869, 1, '_sys_format_size_tb'),
(2870, 1, '_sys_grid_confirmation'),
(2871, 1, '_sys_grid_delete_failed'),
(2872, 1, '_sys_grid_search'),
(2873, 1, '_sys_grid_total_count'),
(2874, 1, '_sys_grid_txt_account_manager'),
(2875, 1, '_sys_inst_conf_desc'),
(2876, 1, '_sys_inst_conf_desc_admin_email'),
(2877, 1, '_sys_inst_conf_desc_admin_pwd'),
(2878, 1, '_sys_inst_conf_desc_admin_username'),
(2879, 1, '_sys_inst_conf_desc_db_host'),
(2880, 1, '_sys_inst_conf_desc_db_name'),
(2881, 1, '_sys_inst_conf_desc_db_port'),
(2882, 1, '_sys_inst_conf_desc_db_pwd'),
(2883, 1, '_sys_inst_conf_desc_db_sock'),
(2884, 1, '_sys_inst_conf_desc_db_user'),
(2885, 1, '_sys_inst_conf_desc_db_engine'),
(2886, 1, '_sys_inst_conf_desc_language'),
(2887, 1, '_sys_inst_conf_desc_profiles'),
(2888, 1, '_sys_inst_conf_desc_oauth_key_secret'),
(2889, 1, '_sys_inst_conf_desc_path_to_binary'),
(2890, 1, '_sys_inst_conf_desc_root_dir'),
(2891, 1, '_sys_inst_conf_desc_site_email'),
(2892, 1, '_sys_inst_conf_desc_site_title'),
(2893, 1, '_sys_inst_conf_desc_site_url'),
(2894, 1, '_sys_inst_conf_desc_template'),
(2895, 1, '_sys_inst_conf_error'),
(2896, 1, '_sys_inst_conf_field_admin_email'),
(2897, 1, '_sys_inst_conf_field_admin_pwd'),
(2898, 1, '_sys_inst_conf_field_admin_username'),
(2899, 1, '_sys_inst_conf_field_db_host'),
(2900, 1, '_sys_inst_conf_field_db_name'),
(2901, 1, '_sys_inst_conf_field_db_port'),
(2902, 1, '_sys_inst_conf_field_db_pwd'),
(2903, 1, '_sys_inst_conf_field_db_sock'),
(2904, 1, '_sys_inst_conf_field_db_user'),
(2905, 1, '_sys_inst_conf_field_db_engine'),
(2906, 1, '_sys_inst_conf_field_language'),
(2907, 1, '_sys_inst_conf_field_profiles'),
(2908, 1, '_sys_inst_conf_field_oauth_key'),
(2909, 1, '_sys_inst_conf_field_oauth_secret'),
(2910, 1, '_sys_inst_conf_field_path_to_binary'),
(2911, 1, '_sys_inst_conf_field_root_dir'),
(2912, 1, '_sys_inst_conf_field_site_email'),
(2913, 1, '_sys_inst_conf_field_site_title'),
(2914, 1, '_sys_inst_conf_field_site_url'),
(2915, 1, '_sys_inst_conf_field_template'),
(2916, 1, '_sys_inst_conf_found'),
(2917, 1, '_sys_inst_conf_no_example'),
(2918, 1, '_sys_inst_conf_not_found'),
(2919, 1, '_sys_inst_conf_section_db_config'),
(2920, 1, '_sys_inst_conf_section_link_with_market'),
(2921, 1, '_sys_inst_conf_section_modules'),
(2922, 1, '_sys_inst_conf_section_paths'),
(2923, 1, '_sys_inst_conf_section_site_info'),
(2924, 1, '_sys_inst_continue'),
(2925, 1, '_sys_inst_finish'),
(2926, 1, '_sys_inst_help_finish'),
(2927, 1, '_sys_inst_help_permissions'),
(2928, 1, '_sys_inst_help_site_config'),
(2929, 1, '_sys_inst_hosting_fails'),
(2930, 1, '_sys_inst_hosting_warnings'),
(2931, 1, '_sys_inst_msg_admin_account_not_found'),
(2932, 1, '_sys_inst_msg_db_err_connect'),
(2933, 1, '_sys_inst_msg_db_err_select'),
(2934, 1, '_sys_inst_msg_file_read_failed'),
(2935, 1, '_sys_inst_msg_file_write_failed'),
(2936, 1, '_sys_inst_msg_finish'),
(2937, 1, '_sys_inst_msg_finish_cron_jobs'),
(2938, 1, '_sys_inst_msg_finish_delete_install_folder'),
(2939, 1, '_sys_inst_msg_finish_goto_studio'),
(2940, 1, '_sys_inst_msg_form_error'),
(2941, 1, '_sys_inst_msg_module_error'),
(2942, 1, '_sys_inst_msg_permissions_wrong'),
(2943, 1, '_sys_inst_msg_remove_install'),
(2944, 1, '_sys_inst_msg_script_isnt_installed'),
(2945, 1, '_sys_inst_refresh'),
(2946, 1, '_sys_inst_server_audit'),
(2947, 1, '_sys_inst_site_config'),
(2948, 1, '_sys_inst_start_installation'),
(2949, 1, '_sys_inst_title'),
(2950, 1, '_sys_layout_1_column'),
(2951, 1, '_sys_layout_1_column_thin'),
(2952, 1, '_sys_layout_1_column_half'),
(2953, 1, '_sys_layout_1_column_wiki'),
(2954, 1, '_sys_layout_2_columns'),
(2955, 1, '_sys_layout_3_columns'),
(2956, 1, '_sys_layout_bar_left'),
(2957, 1, '_sys_layout_bar_content_bar'),
(2958, 1, '_sys_layout_bar_right'),
(2959, 1, '_sys_layout_bottom_area_2_columns'),
(2960, 1, '_sys_layout_top_area_2_columns'),
(2961, 1, '_sys_layout_top_area_3_columns'),
(2962, 1, '_sys_layout_top_area_bar_left'),
(2963, 1, '_sys_layout_top_area_bar_content_bar'),
(2964, 1, '_sys_layout_top_area_bar_right'),
(2965, 1, '_sys_layout_topbottom_area_2_columns'),
(2966, 1, '_sys_layout_topbottom_area_bar_left'),
(2967, 1, '_sys_layout_topbottom_area_bar_right'),
(2968, 1, '_sys_layout_topbottom_area_col1_col3_col2'),
(2969, 1, '_sys_layout_topbottom_area_col1_col5'),
(2970, 1, '_sys_layout_topbottom_area_col2_col5_col3'),
(2971, 1, '_sys_loading'),
(2972, 1, '_sys_location_country'),
(2973, 1, '_sys_location_country_city'),
(2974, 1, '_sys_location_country_city_street'),
(2975, 1, '_sys_location_determining'),
(2976, 1, '_sys_location_geolocation_not_supported_by_browser'),
(2977, 1, '_sys_location_undefined'),
(2978, 1, '_sys_location_map_google_static'),
(2979, 1, '_sys_location_map_leaflet'),
(2980, 1, '_sys_location_field_google'),
(2981, 1, '_sys_location_field_plain'),
(2982, 1, '_sys_location_field_label'),
(2983, 1, '_sys_location_ph_number'),
(2984, 1, '_sys_location_ph_street'),
(2985, 1, '_sys_location_ph_city'),
(2986, 1, '_sys_location_ph_state'),
(2987, 1, '_sys_location_ph_zip'),
(2988, 1, '_sys_location_status_undef'),
(2989, 1, '_sys_location_status_ok'),
(2990, 1, '_sys_location_status_fail'),
(2991, 1, '_sys_log_debug'),
(2992, 1, '_sys_log_sms'),
(2993, 1, '_sys_log_push'),
(2994, 1, '_sys_log_payments'),
(2995, 1, '_sys_log_cron_jobs'),
(2996, 1, '_sys_log_transcoder'),
(2997, 1, '_sys_macros_malformed'),
(2998, 1, '_sys_macros_unsafe'),
(2999, 1, '_sys_macros_output_not_displayable'),
(3000, 1, '_sys_macros_method_or_class_not_found'),
(3001, 1, '_sys_macros_required_args_missing'),
(3002, 1, '_sys_macros_too_many_args'),
(3003, 1, '_sys_manage_popup_approve_title'),
(3004, 1, '_sys_manage_txt_approved'),
(3005, 1, '_sys_manage_txt_sent'),
(3006, 1, '_sys_manage_err_cannot_perform_action'),
(3007, 1, '_sys_menu_item_title_about'),
(3008, 1, '_sys_menu_item_title_copyright'),
(3009, 1, '_sys_menu_item_title_privacy'),
(3010, 1, '_sys_menu_item_title_search'),
(3011, 1, '_sys_menu_item_title_switch_language'),
(3012, 1, '_sys_menu_item_title_switch_language_mask'),
(3013, 1, '_sys_menu_item_title_switch_template'),
(3014, 1, '_sys_menu_item_title_switch_template_mask'),
(3015, 1, '_sys_menu_item_title_terms'),
(3016, 1, '_sys_menu_item_title_account_menu'),
(3017, 1, '_sys_menu_item_title_account_profile_context'),
(3018, 1, '_sys_menu_item_title_account_dashboard'),
(3019, 1, '_sys_menu_item_title_account_dashboard_administration'),
(3020, 1, '_sys_menu_item_title_account_settings'),
(3021, 1, '_sys_menu_item_title_account_settings_delete'),
(3022, 1, '_sys_menu_item_title_account_settings_email'),
(3023, 1, '_sys_menu_item_title_account_settings_info'),
(3024, 1, '_sys_menu_item_title_account_settings_pwd'),
(3025, 1, '_sys_menu_item_title_profile_settings_cfilter'),
(3026, 1, '_sys_menu_item_title_add_content'),
(3027, 1, '_sys_menu_item_title_cart'),
(3028, 1, '_sys_menu_item_title_cmts_administration'),
(3029, 1, '_sys_menu_item_title_audit_administration'),
(3030, 1, '_sys_menu_item_title_cmts_item_delete'),
(3031, 1, '_sys_menu_item_title_cmts_item_edit'),
(3032, 1, '_sys_menu_item_title_cmts_item_pin'),
(3033, 1, '_sys_menu_item_title_cmts_item_unpin'),
(3034, 1, '_sys_menu_item_title_cmts_item_quote'),
(3035, 1, '_sys_menu_item_title_cmts_item_reaction'),
(3036, 1, '_sys_menu_item_title_cmts_item_reply'),
(3037, 1, '_sys_menu_item_title_cmts_item_score'),
(3038, 1, '_sys_menu_item_title_cmts_item_vote'),
(3039, 1, '_sys_menu_item_title_cmts_item_more'),
(3040, 1, '_sys_menu_item_title_connections'),
(3041, 1, '_sys_menu_item_title_dashboard'),
(3042, 1, '_sys_menu_item_title_home'),
(3043, 1, '_sys_menu_item_title_invoices'),
(3044, 1, '_sys_menu_item_title_logout'),
(3045, 1, '_sys_menu_item_title_more'),
(3046, 1, '_sys_menu_item_title_more_auto'),
(3047, 1, '_sys_menu_item_title_orders'),
(3048, 1, '_sys_menu_item_title_profile'),
(3049, 1, '_sys_menu_item_title_set_acl_level'),
(3050, 1, '_sys_menu_item_title_set_badges'),
(3051, 1, '_sys_menu_item_title_studio'),
(3052, 1, '_sys_menu_item_title_subscriptions'),
(3053, 1, '_sys_menu_item_title_social_sharing_facebook'),
(3054, 1, '_sys_menu_item_title_social_sharing_twitter'),
(3055, 1, '_sys_menu_item_title_social_sharing_pinterest'),
(3056, 1, '_sys_menu_item_title_social_sharing_linked_in'),
(3057, 1, '_sys_menu_item_title_system_social_sharing_linked_in'),
(3058, 1, '_sys_menu_item_title_social_sharing_whatsapp'),
(3059, 1, '_sys_menu_item_title_system_social_sharing_whatsapp'),
(3060, 1, '_sys_menu_item_title_sm_in_reply_to'),
(3061, 1, '_sys_menu_item_title_sm_author'),
(3062, 1, '_sys_menu_item_title_sm_date'),
(3063, 1, '_sys_menu_item_title_sm_category'),
(3064, 1, '_sys_menu_item_title_sm_tags'),
(3065, 1, '_sys_menu_item_title_sm_views'),
(3066, 1, '_sys_menu_item_title_sm_votes'),
(3067, 1, '_sys_menu_item_title_sm_scores'),
(3068, 1, '_sys_menu_item_title_sm_rating'),
(3069, 1, '_sys_menu_item_title_sm_comments'),
(3070, 1, '_sys_menu_item_title_sm_actions'),
(3071, 1, '_sys_menu_item_title_sm_befriend'),
(3072, 1, '_sys_menu_item_title_sm_befriend_sent'),
(3073, 1, '_sys_menu_item_title_sm_befriend_confirm'),
(3074, 1, '_sys_menu_item_title_sm_unfriend'),
(3075, 1, '_sys_menu_item_title_sm_unfriend_cancel'),
(3076, 1, '_sys_menu_item_title_sm_unfriend_reject'),
(3077, 1, '_sys_menu_item_title_sm_join_paid'),
(3078, 1, '_sys_menu_item_title_sm_join'),
(3079, 1, '_sys_menu_item_title_sm_join_confirm'),
(3080, 1, '_sys_menu_item_title_sm_leave'),
(3081, 1, '_sys_menu_item_title_sm_leave_cancel'),
(3082, 1, '_sys_menu_item_title_sm_leave_reject'),
(3083, 1, '_sys_menu_item_title_sm_nl'),
(3084, 1, '_sys_menu_item_title_sm_subscribe'),
(3085, 1, '_sys_menu_item_title_sm_unsubscribe'),
(3086, 1, '_sys_menu_item_title_sm_friends'),
(3087, 1, '_sys_menu_item_title_sm_friends_mutual'),
(3088, 1, '_sys_menu_item_title_sm_members'),
(3089, 1, '_sys_menu_item_title_sm_membership'),
(3090, 1, '_sys_menu_item_title_sm_subscribers'),
(3091, 1, '_sys_menu_item_title_sm_relations'),
(3092, 1, '_sys_menu_item_title_sm_country'),
(3093, 1, '_sys_menu_item_title_sm_country_city'),
(3094, 1, '_sys_menu_item_title_sm_ignore'),
(3095, 1, '_sys_menu_item_title_vm_membership'),
(3096, 1, '_sys_menu_item_title_vm_badges'),
(3097, 1, '_sys_menu_item_title_system_about'),
(3098, 1, '_sys_menu_item_title_system_copyright'),
(3099, 1, '_sys_menu_item_title_system_privacy'),
(3100, 1, '_sys_menu_item_title_system_switch_language'),
(3101, 1, '_sys_menu_item_title_system_switch_template'),
(3102, 1, '_sys_menu_item_title_system_terms'),
(3103, 1, '_sys_menu_item_title_system_account_menu'),
(3104, 1, '_sys_menu_item_title_system_account_profile_context'),
(3105, 1, '_sys_menu_item_title_system_account_dashboard'),
(3106, 1, '_sys_menu_item_title_system_account_dashboard_administration'),
(3107, 1, '_sys_menu_item_title_system_account_dashboard_content'),
(3108, 1, '_sys_menu_item_title_account_dashboard_content'),
(3109, 1, '_sys_menu_item_title_system_account_dashboard_reports'),
(3110, 1, '_sys_menu_item_title_account_dashboard_reports'),
(3111, 1, '_sys_menu_item_title_system_account_dashboard_audit'),
(3112, 1, '_sys_menu_item_title_account_dashboard_audit'),
(3113, 1, '_sys_menu_item_title_system_ap_profile_active'),
(3114, 1, '_sys_menu_item_title_system_ap_profile_notifications'),
(3115, 1, '_sys_menu_item_title_system_ap_profile_switcher'),
(3116, 1, '_sys_menu_item_title_system_ap_profile_create'),
(3117, 1, '_sys_menu_item_title_system_account_settings'),
(3118, 1, '_sys_menu_item_title_system_account_settings_delete'),
(3119, 1, '_sys_menu_item_title_system_account_settings_email'),
(3120, 1, '_sys_menu_item_title_system_account_settings_info'),
(3121, 1, '_sys_menu_item_title_system_account_settings_pwd'),
(3122, 1, '_sys_menu_item_title_system_profile_settings_cfilter'),
(3123, 1, '_sys_menu_item_title_system_add_content'),
(3124, 1, '_sys_menu_item_title_system_apps'),
(3125, 1, '_sys_menu_item_title_system_cart'),
(3126, 1, '_sys_menu_item_title_system_cmts_administration'),
(3127, 1, '_sys_menu_item_title_system_audit_administration'),
(3128, 1, '_sys_menu_item_title_system_cmts_item_delete'),
(3129, 1, '_sys_menu_item_title_system_cmts_item_edit'),
(3130, 1, '_sys_menu_item_title_system_cmts_item_pin'),
(3131, 1, '_sys_menu_item_title_system_cmts_item_unpin'),
(3132, 1, '_sys_menu_item_title_system_cmts_item_quote'),
(3133, 1, '_sys_menu_item_title_system_cmts_item_reaction'),
(3134, 1, '_sys_menu_item_title_system_cmts_item_reply'),
(3135, 1, '_sys_menu_item_title_system_cmts_item_report'),
(3136, 1, '_sys_menu_item_title_system_cmts_item_score'),
(3137, 1, '_sys_menu_item_title_system_cmts_item_vote'),
(3138, 1, '_sys_menu_item_title_system_cmts_item_more'),
(3139, 1, '_sys_menu_item_title_system_connections'),
(3140, 1, '_sys_menu_item_title_system_dashboard'),
(3141, 1, '_sys_menu_item_title_system_home'),
(3142, 1, '_sys_menu_item_title_system_invoices'),
(3143, 1, '_sys_menu_item_title_system_login'),
(3144, 1, '_sys_menu_item_title_system_logout'),
(3145, 1, '_sys_menu_item_title_system_main_menu'),
(3146, 1, '_sys_menu_item_title_system_member_avatar'),
(3147, 1, '_sys_menu_item_title_system_member_followings'),
(3148, 1, '_sys_menu_item_title_system_member_menu'),
(3149, 1, '_sys_menu_item_title_system_more'),
(3150, 1, '_sys_menu_item_title_system_more_auto'),
(3151, 1, '_sys_menu_item_title_system_orders'),
(3152, 1, '_sys_menu_item_title_system_powered_by'),
(3153, 1, '_sys_menu_item_title_system_profile'),
(3154, 1, '_sys_menu_item_title_system_public_menu'),
(3155, 1, '_sys_menu_item_title_system_search'),
(3156, 1, '_sys_menu_item_title_system_set_acl_level'),
(3157, 1, '_sys_menu_item_title_system_set_badges'),
(3158, 1, '_sys_menu_item_title_system_studio'),
(3159, 1, '_sys_menu_item_title_system_subscriptions'),
(3160, 1, '_sys_menu_title_view_actions'),
(3161, 1, '_sys_menu_set_title_view_actions'),
(3162, 1, '_sys_menu_item_title_system_va_approve'),
(3163, 1, '_sys_menu_item_title_system_va_comment'),
(3164, 1, '_sys_menu_item_title_system_va_view'),
(3165, 1, '_sys_menu_item_title_system_va_vote'),
(3166, 1, '_sys_menu_item_title_system_va_score'),
(3167, 1, '_sys_menu_item_title_system_va_favorite'),
(3168, 1, '_sys_menu_item_title_system_va_feature'),
(3169, 1, '_sys_menu_item_title_system_va_reaction'),
(3170, 1, '_sys_menu_item_title_system_va_repost'),
(3171, 1, '_sys_menu_item_title_system_va_repost_with_text'),
(3172, 1, '_sys_menu_item_title_system_va_repost_to_context'),
(3173, 1, '_sys_menu_item_title_system_va_report'),
(3174, 1, '_sys_menu_item_title_system_va_notes'),
(3175, 1, '_sys_menu_item_title_system_va_audit'),
(3176, 1, '_sys_menu_item_title_system_va_more_auto'),
(3177, 1, '_sys_menu_item_title_va_approve'),
(3178, 1, '_sys_menu_item_title_va_notes'),
(3179, 1, '_sys_menu_item_title_va_audit'),
(3180, 1, '_sys_menu_item_title_va_more_auto'),
(3181, 1, '_sys_menu_item_title_va_more_auto_empty'),
(3182, 1, '_sys_menu_item_title_social_sharing'),
(3183, 1, '_sys_menu_item_title_system_social_sharing'),
(3184, 1, '_sys_menu_item_title_system_social_sharing_facebook'),
(3185, 1, '_sys_menu_item_title_system_social_sharing_twitter'),
(3186, 1, '_sys_menu_item_title_system_social_sharing_pinterest'),
(3187, 1, '_sys_menu_item_title_system_sm_in_reply_to'),
(3188, 1, '_sys_menu_item_title_system_sm_author'),
(3189, 1, '_sys_menu_item_title_system_sm_date'),
(3190, 1, '_sys_menu_item_title_system_sm_category'),
(3191, 1, '_sys_menu_item_title_system_sm_tags'),
(3192, 1, '_sys_menu_item_title_system_sm_views'),
(3193, 1, '_sys_menu_item_title_system_sm_votes'),
(3194, 1, '_sys_menu_item_title_system_sm_scores'),
(3195, 1, '_sys_menu_item_title_system_sm_rating'),
(3196, 1, '_sys_menu_item_title_system_sm_comments'),
(3197, 1, '_sys_menu_item_title_system_sm_actions'),
(3198, 1, '_sys_menu_item_title_system_sm_befriend'),
(3199, 1, '_sys_menu_item_title_system_sm_unfriend'),
(3200, 1, '_sys_menu_item_title_system_sm_join_paid'),
(3201, 1, '_sys_menu_item_title_system_sm_join'),
(3202, 1, '_sys_menu_item_title_system_sm_leave'),
(3203, 1, '_sys_menu_item_title_system_sm_nl'),
(3204, 1, '_sys_menu_item_title_system_sm_subscribe'),
(3205, 1, '_sys_menu_item_title_system_sm_unsubscribe'),
(3206, 1, '_sys_menu_item_title_system_sm_friends'),
(3207, 1, '_sys_menu_item_title_system_sm_friends_mutual'),
(3208, 1, '_sys_menu_item_title_system_sm_members'),
(3209, 1, '_sys_menu_item_title_system_sm_membership'),
(3210, 1, '_sys_menu_item_title_system_sm_subscribers'),
(3211, 1, '_sys_menu_item_title_system_sm_relations'),
(3212, 1, '_sys_menu_item_title_system_sm_country'),
(3213, 1, '_sys_menu_item_title_system_sm_country_city'),
(3214, 1, '_sys_menu_item_title_system_sm_ignore'),
(3215, 1, '_sys_menu_item_title_system_sm_ignore_befriend'),
(3216, 1, '_sys_menu_item_title_system_sm_ignore_subscribe'),
(3217, 1, '_sys_menu_item_title_system_vm_membership'),
(3218, 1, '_sys_menu_item_title_system_vm_badges'),
(3219, 1, '_sys_menu_set_title_account_dashboard'),
(3220, 1, '_sys_menu_set_title_account_dashboard_manage_tools'),
(3221, 1, '_sys_menu_set_title_account_settings'),
(3222, 1, '_sys_menu_set_title_account_popup'),
(3223, 1, '_sys_menu_set_title_account_notifications'),
(3224, 1, '_sys_menu_set_title_add_content'),
(3225, 1, '_sys_menu_set_title_dashboard_content_manage'),
(3226, 1, '_sys_menu_set_title_dashboard_reports_manage'),
(3227, 1, '_sys_menu_set_title_add_profile'),
(3228, 1, '_sys_menu_set_title_cmts_item_actions'),
(3229, 1, '_sys_menu_set_title_cmts_item_counters'),
(3230, 1, '_sys_menu_set_title_cmts_item_manage'),
(3231, 1, '_sys_menu_set_title_cmts_item_meta'),
(3232, 1, '_sys_menu_set_title_switch_language'),
(3233, 1, '_sys_menu_set_title_switch_template'),
(3234, 1, '_sys_menu_set_title_sys_social_sharing'),
(3235, 1, '_sys_menu_set_title_footer'),
(3236, 1, '_sys_menu_set_title_profile_create_links'),
(3237, 1, '_sys_menu_set_title_profile_followings'),
(3238, 1, '_sys_menu_set_title_profile_stats'),
(3239, 1, '_sys_menu_set_title_site'),
(3240, 1, '_sys_menu_set_title_application'),
(3241, 1, '_sys_menu_set_title_panel'),
(3242, 1, '_sys_menu_set_title_homepage'),
(3243, 1, '_sys_menu_set_title_toolbar_member'),
(3244, 1, '_sys_menu_set_title_toolbar_site'),
(3245, 1, '_sys_menu_set_title_snippet_meta'),
(3246, 1, '_sys_menu_template_title_add_content'),
(3247, 1, '_sys_menu_template_title_block_submenu_hor'),
(3248, 1, '_sys_menu_template_title_block_submenu_ver'),
(3249, 1, '_sys_menu_template_title_buttons_hor'),
(3250, 1, '_sys_menu_template_title_buttons_icon_hor'),
(3251, 1, '_sys_menu_template_title_buttons_ver'),
(3252, 1, '_sys_menu_template_title_floating_blocks'),
(3253, 1, '_sys_menu_template_title_floating_blocks_wide'),
(3254, 1, '_sys_menu_template_title_floating_blocks_big'),
(3255, 1, '_sys_menu_template_title_floating_blocks_dash'),
(3256, 1, '_sys_menu_template_title_footer'),
(3257, 1, '_sys_menu_template_title_hor'),
(3258, 1, '_sys_menu_template_title_inline'),
(3259, 1, '_sys_menu_template_title_inline_sbtn'),
(3260, 1, '_sys_menu_template_title_interactive'),
(3261, 1, '_sys_menu_template_title_interactive_vertical'),
(3262, 1, '_sys_menu_template_title_empty'),
(3263, 1, '_sys_menu_template_title_main'),
(3264, 1, '_sys_menu_template_title_main_submenu'),
(3265, 1, '_sys_menu_template_title_main_submenu_more_auto'),
(3266, 1, '_sys_menu_template_title_panel'),
(3267, 1, '_sys_menu_template_title_main_in_panel'),
(3268, 1, '_sys_menu_template_title_multilevel'),
(3269, 1, '_sys_menu_template_title_toolbar'),
(3270, 1, '_sys_menu_template_title_ver'),
(3271, 1, '_sys_menu_template_title_ver_lite'),
(3272, 1, '_sys_menu_template_title_account_notifications'),
(3273, 1, '_sys_menu_template_title_account_popup'),
(3274, 1, '_sys_menu_template_title_custom_hor'),
(3275, 1, '_sys_menu_template_title_custom_ver'),
(3276, 1, '_sys_menu_template_title_profile_followings'),
(3277, 1, '_sys_menu_template_title_vertical_more_less'),
(3278, 1, '_sys_menu_template_title_profile_stats'),
(3279, 1, '_sys_menu_title_account_dashboard'),
(3280, 1, '_sys_menu_title_account_dashboard_manage_tools'),
(3281, 1, '_sys_menu_title_account_notifications'),
(3282, 1, '_sys_menu_title_account_popup'),
(3283, 1, '_sys_menu_title_account_settings'),
(3284, 1, '_sys_menu_title_add_content'),
(3285, 1, '_sys_menu_title_add_profile'),
(3286, 1, '_sys_menu_title_add_profile_vertical'),
(3287, 1, '_sys_menu_title_cmts_item_actions'),
(3288, 1, '_sys_menu_title_cmts_item_counters'),
(3289, 1, '_sys_menu_title_cmts_item_manage'),
(3290, 1, '_sys_menu_title_cmts_item_meta'),
(3291, 1, '_sys_menu_title_footer'),
(3292, 1, '_sys_menu_title_main'),
(3293, 1, '_sys_menu_title_main_in_panel'),
(3294, 1, '_sys_menu_title_application'),
(3295, 1, '_sys_menu_title_homepage'),
(3296, 1, '_sys_menu_title_homepage_submenu'),
(3297, 1, '_sys_menu_set_title_homepage_submenu'),
(3298, 1, '_sys_menu_item_title_system_explore'),
(3299, 1, '_sys_menu_item_title_explore'),
(3300, 1, '_sys_menu_item_title_system_updates'),
(3301, 1, '_sys_menu_item_title_updates'),
(3302, 1, '_sys_menu_item_title_system_trends'),
(3303, 1, '_sys_menu_item_title_trends'),
(3304, 1, '_sys_menu_title_profiles_create'),
(3305, 1, '_sys_menu_title_profile_followings'),
(3306, 1, '_sys_menu_title_profile_stats'),
(3307, 1, '_sys_menu_title_tags_cloud'),
(3308, 1, '_sys_menu_title_rss'),
(3309, 1, '_sys_menu_title_set_acl_level'),
(3310, 1, '_sys_menu_title_set_badges'),
(3311, 1, '_sys_menu_title_social_sharing'),
(3312, 1, '_sys_menu_title_create_post'),
(3313, 1, '_sys_menu_title_dashboard_content_manage'),
(3314, 1, '_sys_menu_title_dashboard_reports_manage'),
(3315, 1, '_sys_menu_title_add_relation'),
(3316, 1, '_sys_menu_title_panel'),
(3317, 1, '_sys_menu_title_submenu'),
(3318, 1, '_sys_menu_title_toolbar_member'),
(3319, 1, '_sys_menu_title_toolbar_site'),
(3320, 1, '_sys_menu_title_switch_language_popup'),
(3321, 1, '_sys_menu_title_switch_language_inline'),
(3322, 1, '_sys_menu_title_switch_template'),
(3323, 1, '_sys_menu_title_snippet_meta'),
(3324, 1, '_sys_menu_title_vote_reactions_do'),
(3325, 1, '_sys_menu_title_wiki'),
(3326, 1, '_sys_menu_set_title_sys_wiki'),
(3327, 1, '_sys_menu_item_title_wiki_edit'),
(3328, 1, '_sys_menu_item_title_wiki_delete_version'),
(3329, 1, '_sys_menu_item_title_wiki_delete_block'),
(3330, 1, '_sys_menu_item_title_wiki_translate'),
(3331, 1, '_sys_menu_item_title_wiki_history'),
(3332, 1, '_sys_menu_title_favorite_list'),
(3333, 1, '_sys_menu_set_title_sys_favorite_list'),
(3334, 1, '_sys_menu_item_title_favorite_list_edit'),
(3335, 1, '_sys_menu_item_title_wiki_favorite_list_delete'),
(3336, 1, '_sys_menu_dashboard_manage_tools_addon_counter1_caption_default'),
(3337, 1, '_sys_menu_dashboard_manage_tools_addon_counter1_caption_profile_default'),
(3338, 1, '_sys_menu_dashboard_manage_tools_addon_counter2_caption_default'),
(3339, 1, '_sys_menu_title_studio_account_popup'),
(3340, 1, '_sys_menu_set_title_studio_account_popup'),
(3341, 1, '_sys_menu_item_title_system_sa_account'),
(3342, 1, '_sys_menu_item_title_sa_account'),
(3343, 1, '_sys_menu_item_title_system_sa_site'),
(3344, 1, '_sys_menu_item_title_sa_site'),
(3345, 1, '_sys_menu_item_title_system_sa_edit'),
(3346, 1, '_sys_menu_item_title_sa_edit'),
(3347, 1, '_sys_menu_item_title_system_sa_language'),
(3348, 1, '_sys_menu_item_title_sa_language'),
(3349, 1, '_sys_menu_item_title_sa_scheme_auto'),
(3350, 1, '_sys_menu_item_title_sa_scheme_light'),
(3351, 1, '_sys_menu_item_title_sa_scheme_dark'),
(3352, 1, '_sys_menu_item_title_system_sa_logout'),
(3353, 1, '_sys_menu_item_title_sa_logout'),
(3354, 1, '_sys_menu_item_title_inherited'),
(3355, 1, '_sys_menu_item_title_disabled'),
(3356, 1, '_sys_menu_title_con_submenu'),
(3357, 1, '_sys_menu_set_title_con_submenu'),
(3358, 1, '_sys_menu_item_title_con_friends'),
(3359, 1, '_sys_menu_item_title_con_friend_requests'),
(3360, 1, '_sys_menu_item_title_con_friend_requested'),
(3361, 1, '_sys_menu_item_title_con_following'),
(3362, 1, '_sys_menu_item_title_con_followers'),
(3363, 1, '_sys_menu_item_title_recom_friends'),
(3364, 1, '_sys_menu_item_title_recom_subscriptions'),
(3365, 1, '_sys_metatags_mention_added'),
(3366, 1, '_sys_mobile_friends'),
(3367, 1, '_sys_mobile_info'),
(3368, 1, '_sys_mobile_mail'),
(3369, 1, '_sys_mobile_profile_contact'),
(3370, 1, '_sys_mobile_profile_friends'),
(3371, 1, '_sys_mobile_profile_info'),
(3372, 1, '_sys_mobile_search'),
(3373, 1, '_sys_mobile_status'),
(3374, 1, '_sys_name'),
(3375, 1, '_sys_added'),
(3376, 1, '_sys_next'),
(3377, 1, '_sys_notification_account'),
(3378, 1, '_sys_no_menu'),
(3379, 1, '_sys_no_async'),
(3380, 1, '_sys_not_available'),
(3381, 1, '_sys_not_specified'),
(3382, 1, '_sys_on'),
(3383, 1, '_sys_off'),
(3384, 1, '_sys_pages'),
(3385, 1, '_sys_page_content_ph_loading_indicator'),
(3386, 1, '_sys_page_content_ph_text'),
(3387, 1, '_sys_page_content_ph_image'),
(3388, 1, '_sys_page_content_ph_create_post'),
(3389, 1, '_sys_page_content_ph_profile_units'),
(3390, 1, '_sys_page_content_ph_text_units_list'),
(3391, 1, '_sys_page_content_ph_text_units_gallery'),
(3392, 1, '_sys_page_block_title_about'),
(3393, 1, '_sys_page_block_title_account_profile_create'),
(3394, 1, '_sys_page_block_title_account_profile_switcher'),
(3395, 1, '_sys_page_block_title_account_settings_delete'),
(3396, 1, '_sys_page_block_title_account_settings_email'),
(3397, 1, '_sys_page_block_title_account_settings_info'),
(3398, 1, '_sys_page_block_title_account_settings_menu'),
(3399, 1, '_sys_page_block_title_account_settings_pwd'),
(3400, 1, '_sys_page_block_title_profile_settings_cfilter'),
(3401, 1, '_sys_page_block_title_add_content'),
(3402, 1, '_sys_page_block_title_chart_growth'),
(3403, 1, '_sys_page_block_title_chart_stats'),
(3404, 1, '_sys_page_block_title_cmts_administration'),
(3405, 1, '_sys_page_block_title_audit_administration'),
(3406, 1, '_sys_page_block_title_confirm_email'),
(3407, 1, '_sys_page_block_title_confirm_phone'),
(3408, 1, '_sys_page_block_title_create_account'),
(3409, 1, '_sys_page_block_title_sys_author'),
(3410, 1, '_sys_page_block_title_author'),
(3411, 1, '_sys_page_block_title_sys_ask_aqssistant'),
(3412, 1, '_sys_page_block_title_ask_aqssistant'),
(3413, 1, '_sys_page_block_title_sys_recom_friends'),
(3414, 1, '_sys_page_block_title_recom_friends'),
(3415, 1, '_sys_page_block_title_sys_recom_subscriptions'),
(3416, 1, '_sys_page_block_title_recom_subscriptions'),
(3417, 1, '_sys_page_block_title_sys_create_post'),
(3418, 1, '_sys_page_block_title_create_post'),
(3419, 1, '_sys_page_block_title_sys_create_post_context'),
(3420, 1, '_sys_page_block_title_create_post_context'),
(3421, 1, '_sys_page_block_title_sys_create_post_public'),
(3422, 1, '_sys_page_block_title_create_post_public'),
(3423, 1, '_sys_page_block_title_dashboard'),
(3424, 1, '_sys_page_block_title_homepage_menu'),
(3425, 1, '_sys_page_block_title_homepage_splash'),
(3426, 1, '_sys_page_block_title_forgot_password'),
(3427, 1, '_sys_page_block_title_search_keyword_form'),
(3428, 1, '_sys_page_block_title_search_keyword_result'),
(3429, 1, '_sys_page_block_title_membership_stats'),
(3430, 1, '_sys_page_block_system_title_login'),
(3431, 1, '_sys_page_block_system_title_login_step2'),
(3432, 1, '_sys_page_block_system_title_login_step3'),
(3433, 1, '_sys_page_block_system_title_login_only'),
(3434, 1, '_sys_page_block_title_dashboard_content'),
(3435, 1, '_sys_page_block_title_dashboard_audit'),
(3436, 1, '_sys_page_block_title_dashboard_reports'),
(3437, 1, '_sys_page_block_title_system_cmts_view'),
(3438, 1, '_sys_page_block_title_system_cmts_view_author'),
(3439, 1, '_sys_page_block_title_system_cmts_view_content'),
(3440, 1, '_sys_page_block_title_system_cmts_administration'),
(3441, 1, '_sys_page_block_title_system_audit_administration'),
(3442, 1, '_sys_page_block_title_logout'),
(3443, 1, '_sys_page_block_title_login'),
(3444, 1, '_sys_page_block_title_login_step2'),
(3445, 1, '_sys_page_block_title_login_step3'),
(3446, 1, '_sys_page_block_title_manage_tools'),
(3447, 1, '_sys_page_block_title_privacy'),
(3448, 1, '_sys_page_block_title_profile_stats'),
(3449, 1, '_sys_page_block_title_profile_avatar'),
(3450, 1, '_sys_page_block_title_profile_menu'),
(3451, 1, '_sys_page_block_title_profile_followings'),
(3452, 1, '_sys_page_block_title_profile_membership'),
(3453, 1, '_sys_page_block_title_unsubscribe_news'),
(3454, 1, '_sys_page_block_title_unsubscribe_notifications'),
(3455, 1, '_sys_page_block_title_std_dash_version'),
(3456, 1, '_sys_page_block_title_std_dash_space'),
(3457, 1, '_sys_page_block_title_std_dash_host_tools'),
(3458, 1, '_sys_page_block_title_std_dash_cache'),
(3459, 1, '_sys_page_block_title_std_dash_queues'),
(3460, 1, '_sys_page_block_title_terms'),
(3461, 1, '_sys_page_block_title_sys_std_site_submenu'),
(3462, 1, '_sys_page_block_title_std_site_submenu'),
(3463, 1, '_sys_page_block_title_wiki_pages_list'),
(3464, 1, '_sys_page_block_title_wiki_page_contents'),
(3465, 1, '_sys_page_lang_block_about'),
(3466, 1, '_sys_page_lang_block_terms'),
(3467, 1, '_sys_page_lang_block_privacy'),
(3468, 1, '_sys_page_title_about'),
(3469, 1, '_sys_page_title_account_profile_switcher'),
(3470, 1, '_sys_page_title_account_settings_delete'),
(3471, 1, '_sys_page_title_account_settings_email'),
(3472, 1, '_sys_page_title_account_settings_info'),
(3473, 1, '_sys_page_title_account_settings_pwd'),
(3474, 1, '_sys_page_title_profile_settings_cfilter'),
(3475, 1, '_sys_page_title_add_content'),
(3476, 1, '_sys_page_title_cmts_administration'),
(3477, 1, '_sys_page_title_audit_administration'),
(3478, 1, '_sys_page_title_confirm_email'),
(3479, 1, '_sys_page_title_confirm_phone'),
(3480, 1, '_sys_page_title_create_account'),
(3481, 1, '_sys_page_title_dashboard'),
(3482, 1, '_sys_page_title_forgot_password'),
(3483, 1, '_sys_page_title_forgot_password_reset'),
(3484, 1, '_sys_page_title_home'),
(3485, 1, '_sys_page_title_logout'),
(3486, 1, '_sys_page_title_login'),
(3487, 1, '_sys_page_title_login_step2'),
(3488, 1, '_sys_page_title_login_step3'),
(3489, 1, '_sys_page_title_privacy'),
(3490, 1, '_sys_page_title_explore'),
(3491, 1, '_sys_page_title_updates'),
(3492, 1, '_sys_page_title_trends'),
(3493, 1, '_sys_page_title_terms'),
(3494, 1, '_sys_page_title_system_about'),
(3495, 1, '_sys_page_title_system_account_profile_switcher'),
(3496, 1, '_sys_page_title_system_account_settings_delete'),
(3497, 1, '_sys_page_title_system_account_settings_email'),
(3498, 1, '_sys_page_title_system_account_settings_info'),
(3499, 1, '_sys_page_title_system_account_settings_pwd'),
(3500, 1, '_sys_page_title_system_profile_settings_cfilter'),
(3501, 1, '_sys_page_title_system_add_content'),
(3502, 1, '_sys_page_title_system_cmts_view'),
(3503, 1, '_sys_page_title_system_cmts_administration'),
(3504, 1, '_sys_page_title_system_audit_administration'),
(3505, 1, '_sys_page_title_system_confirm_email'),
(3506, 1, '_sys_page_title_system_confirm_phone'),
(3507, 1, '_sys_page_title_system_create_account'),
(3508, 1, '_sys_page_title_system_dashboard'),
(3509, 1, '_sys_page_title_system_dashboard_content');
INSERT INTO `sys_localization_keys` VALUES
(3510, 1, '_sys_page_title_dashboard_content'),
(3511, 1, '_sys_page_title_system_dashboard_reports'),
(3512, 1, '_sys_page_title_dashboard_reports'),
(3513, 1, '_sys_page_title_system_dashboard_audit'),
(3514, 1, '_sys_page_title_dashboard_audit'),
(3515, 1, '_sys_page_title_system_forgot_password'),
(3516, 1, '_sys_page_title_system_search_keyword'),
(3517, 1, '_sys_page_title_search_keyword'),
(3518, 1, '_sys_page_title_system_home'),
(3519, 1, '_sys_page_title_system_login'),
(3520, 1, '_sys_page_title_system_login_step2'),
(3521, 1, '_sys_page_title_system_login_step3'),
(3522, 1, '_sys_page_title_system_privacy'),
(3523, 1, '_sys_page_title_sys_explore'),
(3524, 1, '_sys_page_title_sys_updates'),
(3525, 1, '_sys_page_title_sys_trends'),
(3526, 1, '_sys_page_title_system_terms'),
(3527, 1, '_sys_page_title_system_unsubscribe_news'),
(3528, 1, '_sys_page_title_system_unsubscribe_notifications'),
(3529, 1, '_sys_page_title_system_studio_dashboard'),
(3530, 1, '_sys_page_title_unsubscribe_news'),
(3531, 1, '_sys_page_title_unsubscribe_notifications'),
(3532, 1, '_sys_page_title_studio_dashboard'),
(3533, 1, '_sys_page_title_wiki_pages_list'),
(3534, 1, '_sys_page_title_wiki_page_contents'),
(3535, 1, '_sys_page_title_system_con_friends'),
(3536, 1, '_sys_page_title_con_friends'),
(3537, 1, '_sys_page_block_title_con_friends'),
(3538, 1, '_sys_page_title_system_con_friend_requests'),
(3539, 1, '_sys_page_title_con_friend_requests'),
(3540, 1, '_sys_page_block_title_con_friend_requests'),
(3541, 1, '_sys_page_title_system_con_friend_requested'),
(3542, 1, '_sys_page_title_con_friend_requested'),
(3543, 1, '_sys_page_block_title_con_friend_requested'),
(3544, 1, '_sys_page_title_system_con_following'),
(3545, 1, '_sys_page_title_con_following'),
(3546, 1, '_sys_page_block_title_con_following'),
(3547, 1, '_sys_page_title_system_con_followers'),
(3548, 1, '_sys_page_title_con_followers'),
(3549, 1, '_sys_page_block_title_con_followers'),
(3550, 1, '_sys_page_title_system_recom_friends'),
(3551, 1, '_sys_page_title_recom_friends'),
(3552, 1, '_sys_page_title_system_recom_subscriptions'),
(3553, 1, '_sys_page_title_recom_subscriptions'),
(3554, 1, '_sys_page_type_application'),
(3555, 1, '_sys_page_type_default'),
(3556, 1, '_sys_page_type_standard'),
(3557, 1, '_sys_page_type_wo_hf'),
(3558, 1, '_sys_paginate_info'),
(3559, 1, '_sys_paginate_total'),
(3560, 1, '_sys_paginate_view_all'),
(3561, 1, '_sys_payments_err_no_payments'),
(3562, 1, '_sys_payments_err_not_accept_payments'),
(3563, 1, '_sys_please_select'),
(3564, 1, '_sys_pre_lists_colors'),
(3565, 1, '_sys_pre_lists_color_slate'),
(3566, 1, '_sys_pre_lists_color_gray'),
(3567, 1, '_sys_pre_lists_color_zinc'),
(3568, 1, '_sys_pre_lists_color_neutral'),
(3569, 1, '_sys_pre_lists_color_stone'),
(3570, 1, '_sys_pre_lists_color_red'),
(3571, 1, '_sys_pre_lists_color_orange'),
(3572, 1, '_sys_pre_lists_color_amber'),
(3573, 1, '_sys_pre_lists_color_yellow'),
(3574, 1, '_sys_pre_lists_color_lime'),
(3575, 1, '_sys_pre_lists_color_green'),
(3576, 1, '_sys_pre_lists_color_emerald'),
(3577, 1, '_sys_pre_lists_color_teal'),
(3578, 1, '_sys_pre_lists_color_cyan'),
(3579, 1, '_sys_pre_lists_color_sky'),
(3580, 1, '_sys_pre_lists_color_blue'),
(3581, 1, '_sys_pre_lists_color_indigo'),
(3582, 1, '_sys_pre_lists_color_violet'),
(3583, 1, '_sys_pre_lists_color_purple'),
(3584, 1, '_sys_pre_lists_color_fuchsia'),
(3585, 1, '_sys_pre_lists_color_pink'),
(3586, 1, '_sys_pre_lists_color_rose'),
(3587, 1, '_sys_pre_lists_content_filter'),
(3588, 1, '_sys_pre_lists_content_filter_g'),
(3589, 1, '_sys_pre_lists_content_filter_pg'),
(3590, 1, '_sys_pre_lists_content_filter_pg13'),
(3591, 1, '_sys_pre_lists_content_filter_r'),
(3592, 1, '_sys_pre_lists_content_filter_x'),
(3593, 1, '_sys_pre_lists_relations'),
(3594, 1, '_sys_pre_lists_relations_husband'),
(3595, 1, '_sys_pre_lists_relations_wife'),
(3596, 1, '_sys_pre_lists_relations_father'),
(3597, 1, '_sys_pre_lists_relations_mother'),
(3598, 1, '_sys_pre_lists_relations_son'),
(3599, 1, '_sys_pre_lists_relations_daughter'),
(3600, 1, '_sys_pre_lists_relations_brother'),
(3601, 1, '_sys_pre_lists_relations_sister'),
(3602, 1, '_sys_pre_lists_report_types'),
(3603, 1, '_sys_pre_lists_report_types_spam'),
(3604, 1, '_sys_pre_lists_report_types_scam'),
(3605, 1, '_sys_pre_lists_report_types_fraud'),
(3606, 1, '_sys_pre_lists_report_types_nude'),
(3607, 1, '_sys_pre_lists_report_types_other'),
(3608, 1, '_sys_pre_lists_vote_reactions'),
(3609, 1, '_sys_pre_lists_vote_reactions_default'),
(3610, 1, '_sys_pre_lists_vote_reactions_like'),
(3611, 1, '_sys_pre_lists_vote_reactions_love'),
(3612, 1, '_sys_pre_lists_vote_reactions_joy'),
(3613, 1, '_sys_pre_lists_vote_reactions_surprise'),
(3614, 1, '_sys_pre_lists_vote_reactions_sadness'),
(3615, 1, '_sys_pre_lists_vote_reactions_anger'),
(3616, 1, '_sys_pre_lists_studio_widget_types'),
(3617, 1, '_sys_pre_lists_studio_widget_types_library'),
(3618, 1, '_sys_pre_lists_studio_widget_types_appearance'),
(3619, 1, '_sys_pre_lists_studio_widget_types_structure'),
(3620, 1, '_sys_pre_lists_studio_widget_types_content'),
(3621, 1, '_sys_pre_lists_studio_widget_types_users'),
(3622, 1, '_sys_pre_lists_studio_widget_types_configuration'),
(3623, 1, '_sys_pre_lists_studio_widget_types_extensions'),
(3624, 1, '_sys_pre_lists_studio_widget_types_integrations'),
(3625, 1, '_sys_pre_lists_studio_widget_types_favorites'),
(3626, 1, '_sys_profile_sample_single'),
(3627, 1, '_sys_profile_with_type'),
(3628, 1, '_sys_profile_friend_request_added'),
(3629, 1, '_sys_profile_friendship_added'),
(3630, 1, '_sys_profile_subscription_added'),
(3631, 1, '_sys_profile_status_active'),
(3632, 1, '_sys_profile_status_pending'),
(3633, 1, '_sys_profile_status_suspended'),
(3634, 1, '_sys_profile_storage_quota_size'),
(3635, 1, '_sys_profile_storage_quota_number'),
(3636, 1, '_sys_private'),
(3637, 1, '_sys_privacy_forms_input_allow_view_to'),
(3638, 1, '_sys_privacy_groups_acl'),
(3639, 1, '_sys_pruning_db'),
(3640, 1, '_sys_pruning_files'),
(3641, 1, '_sys_ps_group_title_memberships_selected'),
(3642, 1, '_sys_ps_group_title_custom'),
(3643, 1, '_sys_ps_group_title_followers'),
(3644, 1, '_sys_ps_group_title_friends'),
(3645, 1, '_sys_ps_group_title_friends_selected'),
(3646, 1, '_sys_ps_group_title_relations'),
(3647, 1, '_sys_ps_group_title_relations_selected'),
(3648, 1, '_sys_ps_group_title_me_only'),
(3649, 1, '_sys_ps_group_title_members'),
(3650, 1, '_sys_ps_group_title_public'),
(3651, 1, '_sys_ps_group_title_participants'),
(3652, 1, '_sys_ps_group_title_closed'),
(3653, 1, '_sys_ps_group_title_secret'),
(3654, 1, '_sys_ps_group_title_unknown'),
(3655, 1, '_sys_ps_ferr_incorrect_gc_not_allowed'),
(3656, 1, '_sys_ps_ferr_incorrect_gc_owner'),
(3657, 1, '_sys_ps_ferr_incorrect_select'),
(3658, 1, '_sys_ps_space_title_friend'),
(3659, 1, '_sys_push_notification_request'),
(3660, 1, '_sys_push_notification_request_yes'),
(3661, 1, '_sys_push_notification_request_no'),
(3662, 1, '_sys_read_more'),
(3663, 1, '_sys_relation'),
(3664, 1, '_sys_request_module_not_found_cpt'),
(3665, 1, '_sys_request_module_not_found_cnt'),
(3666, 1, '_sys_request_page_not_found_cpt'),
(3667, 1, '_sys_request_page_not_found_cnt'),
(3668, 1, '_sys_request_method_not_found_cpt'),
(3669, 1, '_sys_request_method_not_found_cnt'),
(3670, 1, '_sys_score_counter'),
(3671, 1, '_sys_score_counter_empty'),
(3672, 1, '_sys_score_n_score'),
(3673, 1, '_sys_score_do_up'),
(3674, 1, '_sys_score_do_down'),
(3675, 1, '_sys_score_do_by'),
(3676, 1, '_sys_score_err_not_enabled'),
(3677, 1, '_sys_score_err_duplicate_vote'),
(3678, 1, '_sys_search_main_title'),
(3679, 1, '_sys_select'),
(3680, 1, '_sys_send'),
(3681, 1, '_sys_search_placeholder'),
(3682, 1, '_sys_search_or_ask_placeholder'),
(3683, 1, '_sys_show_less'),
(3684, 1, '_sys_show_more'),
(3685, 1, '_sys_spam_detected'),
(3686, 1, '_sys_spam_detected_contact'),
(3687, 1, '_sys_splash_btn_start'),
(3688, 1, '_sys_splash_err_domain_incorrect'),
(3689, 1, '_sys_splash_err_domain_is_used'),
(3690, 1, '_sys_splash_err_service_not_available'),
(3691, 1, '_sys_splash_inp_placeholder'),
(3692, 1, '_sys_splash_inp_postfix'),
(3693, 1, '_sys_splash_slogan'),
(3694, 1, '_sys_status'),
(3695, 1, '_sys_status_awaiting'),
(3696, 1, '_sys_status_failed'),
(3697, 1, '_sys_status_pending'),
(3698, 1, '_sys_status_suspended'),
(3699, 1, '_sys_storage_err_db'),
(3700, 1, '_sys_storage_err_engine_add'),
(3701, 1, '_sys_storage_err_engine_get'),
(3702, 1, '_sys_storage_err_file_not_found'),
(3703, 1, '_sys_storage_err_file_too_big'),
(3704, 1, '_sys_storage_err_filesystem_perm'),
(3705, 1, '_sys_storage_err_no_file'),
(3706, 1, '_sys_storage_err_no_input_method'),
(3707, 1, '_sys_storage_err_object_quota_exceeded'),
(3708, 1, '_sys_storage_err_permission_denied'),
(3709, 1, '_sys_storage_err_site_quota_exceeded'),
(3710, 1, '_sys_storage_err_unlink'),
(3711, 1, '_sys_storage_err_user_quota_exceeded'),
(3712, 1, '_sys_storage_err_wrong_ext'),
(3713, 1, '_sys_storage_files'),
(3714, 1, '_sys_storage_invalid_file'),
(3715, 1, '_sys_storage_restriction_ext_all_allowed'),
(3716, 1, '_sys_storage_restriction_ext_all_denied'),
(3717, 1, '_sys_storage_restriction_ext_allowed'),
(3718, 1, '_sys_storage_restriction_ext_denied'),
(3719, 1, '_sys_storage_restriction_size'),
(3720, 1, '_sys_switch_profile'),
(3721, 1, '_sys_submit'),
(3722, 1, '_sys_subscribe'),
(3723, 1, '_sys_template_mixed_mask'),
(3724, 1, '_sys_tour_launcher_welcome_title'),
(3725, 1, '_sys_tour_launcher_welcome_txt'),
(3726, 1, '_sys_tour_launcher_apps_title'),
(3727, 1, '_sys_tour_launcher_apps_txt'),
(3728, 1, '_sys_tour_launcher_designer_title'),
(3729, 1, '_sys_tour_launcher_designer_txt'),
(3730, 1, '_sys_tour_launcher_accounts_title'),
(3731, 1, '_sys_tour_launcher_accounts_txt'),
(3732, 1, '_sys_tour_launcher_dashboard_title'),
(3733, 1, '_sys_tour_launcher_dashboard_txt'),
(3734, 1, '_sys_tour_launcher_builder_page_title'),
(3735, 1, '_sys_tour_launcher_builder_page_txt'),
(3736, 1, '_sys_tour_launcher_builder_permissions_title'),
(3737, 1, '_sys_tour_launcher_builder_permissions_txt'),
(3738, 1, '_sys_tour_launcher_builder_forms_title'),
(3739, 1, '_sys_tour_launcher_builder_forms_txt'),
(3740, 1, '_sys_tour_launcher_builder_menus_title'),
(3741, 1, '_sys_tour_launcher_builder_menus_txt'),
(3742, 1, '_sys_tour_launcher_polyglot_title'),
(3743, 1, '_sys_tour_launcher_polyglot_txt'),
(3744, 1, '_sys_tour_launcher_reorganize_title'),
(3745, 1, '_sys_tour_launcher_reorganize_txt'),
(3746, 1, '_sys_tour_launcher_favourites_title'),
(3747, 1, '_sys_tour_launcher_favourites_txt'),
(3748, 1, '_sys_tour_launcher_add_apps_title'),
(3749, 1, '_sys_tour_launcher_add_apps_txt'),
(3750, 1, '_sys_tour_homepage_welcome_title'),
(3751, 1, '_sys_tour_homepage_welcome_txt'),
(3752, 1, '_sys_tour_homepage_account_menu_title'),
(3753, 1, '_sys_tour_homepage_account_menu_txt'),
(3754, 1, '_sys_txt_api_key'),
(3755, 1, '_sys_txt_access_denied'),
(3756, 1, '_sys_txt_account_pending'),
(3757, 1, '_sys_txt_account_profile_context_change_suggestion'),
(3758, 1, '_sys_txt_account_profile_context_change_to_another_suggestion'),
(3759, 1, '_sys_txt_account_profile_context_changed_success'),
(3760, 1, '_sys_txt_account_suspended'),
(3761, 1, '_sys_txt_account_unconfirmed_email'),
(3762, 1, '_sys_txt_account_unconfirmed_phone'),
(3763, 1, '_sys_txt_account_profile_system'),
(3764, 1, '_sys_txt_account_need_to_change_password'),
(3765, 1, '_sys_txt_account_cannot_delete'),
(3766, 1, '_sys_txt_account_deletion_scheduled'),
(3767, 1, '_sys_txt_captcha_not_available'),
(3768, 1, '_sys_txt_categories_button_caption_add'),
(3769, 1, '_sys_txt_categories_button_caption_addnew'),
(3770, 1, '_sys_txt_change_image'),
(3771, 1, '_sys_txt_cmt_loading'),
(3772, 1, '_sys_txt_confirm_email_already_confirmed'),
(3773, 1, '_sys_txt_confirm_email_desc'),
(3774, 1, '_sys_txt_confirm_email_error_occured'),
(3775, 1, '_sys_txt_confirm_email_sent'),
(3776, 1, '_sys_txt_confirm_email_sent_failed'),
(3777, 1, '_sys_txt_confirm_email_success'),
(3778, 1, '_sys_txt_confirm_phone_already_confirmed'),
(3779, 1, '_sys_txt_confirm_phone_set_phone_error_occured'),
(3780, 1, '_sys_txt_confirm_phone_send_sms_error_occured'),
(3781, 1, '_sys_txt_confirm_phone_sms_text'),
(3782, 1, '_sys_txt_confirm_phone_confirm_success'),
(3783, 1, '_sys_txt_confirm_phone_set_phone_desc_set_phone'),
(3784, 1, '_sys_txt_confirm_phone_set_phone_desc_phone_confirmation'),
(3785, 1, '_sys_txt_create_post_placeholder'),
(3786, 1, '_sys_txt_err_attach_links'),
(3787, 1, '_sys_txt_current_picture'),
(3788, 1, '_sys_txt_data_successfully_submitted'),
(3789, 1, '_sys_txt_delete'),
(3790, 1, '_sys_txt_discard'),
(3791, 1, '_sys_txt_empty'),
(3792, 1, '_sys_txt_error_account_creation'),
(3793, 1, '_sys_txt_error_account_delete'),
(3794, 1, '_sys_txt_error_account_is_not_defined'),
(3795, 1, '_sys_txt_error_account_update'),
(3796, 1, '_sys_txt_error_entry_creation'),
(3797, 1, '_sys_txt_error_entry_delete'),
(3798, 1, '_sys_txt_error_entry_is_not_defined'),
(3799, 1, '_sys_txt_error_entry_update'),
(3800, 1, '_sys_txt_error_occured'),
(3801, 1, '_sys_txt_error_profile_is_not_defined'),
(3802, 1, '_sys_txt_error_profile_update'),
(3803, 1, '_sys_txt_err_sound_not_transcoded_yet'),
(3804, 1, '_sys_txt_forms_unknown_field_err'),
(3805, 1, '_sys_txt_field_created'),
(3806, 1, '_sys_txt_field_updated'),
(3807, 1, '_sys_txt_forgot_pasword'),
(3808, 1, '_sys_txt_forgot_pasword_check_email'),
(3809, 1, '_sys_txt_forgot_pasword_check_phone'),
(3810, 1, '_sys_txt_forgot_pasword_desc'),
(3811, 1, '_sys_txt_forgot_pasword_by_both_desc'),
(3812, 1, '_sys_txt_forgot_pasword_by_phone_desc'),
(3813, 1, '_sys_txt_forgot_pasword_email_send_failed'),
(3814, 1, '_sys_txt_forgot_pasword_error_occured'),
(3815, 1, '_sys_txt_forgot_pasword_sms_text'),
(3816, 1, '_sys_txt_forgot_pasword_logged_in'),
(3817, 1, '_sys_txt_form_entry_input_picture_copy'),
(3818, 1, '_sys_txt_form_entry_input_picture_delete'),
(3819, 1, '_sys_txt_form_entry_input_picture_insert'),
(3820, 1, '_sys_txt_form_entry_input_picture_pic_url'),
(3821, 1, '_sys_txt_form_entry_input_picture_use_as_thumb'),
(3822, 1, '_sys_txt_form_submission_error'),
(3823, 1, '_sys_txt_form_submission_error_csrf_expired'),
(3824, 1, '_sys_txt_homepage_cover'),
(3825, 1, '_sys_txt_login_2fa_description'),
(3826, 1, '_sys_txt_login_2fa_sms_text'),
(3827, 1, '_sys_txt_login_2fa_sms_error_occured'),
(3828, 1, '_sys_txt_join_description_action'),
(3829, 1, '_sys_txt_login_description_action'),
(3830, 1, '_sys_txt_login_error'),
(3831, 1, '_sys_txt_login_locked'),
(3832, 1, '_sys_txt_following_counter'),
(3833, 1, '_sys_txt_followers_counter'),
(3834, 1, '_sys_txt_friends_counter'),
(3835, 1, '_sys_txt_login_invalid_role'),
(3836, 1, '_sys_txt_my_profiles'),
(3837, 1, '_sys_txt_switch_profiles'),
(3838, 1, '_sys_txt_new_picture'),
(3839, 1, '_sys_txt_not_found'),
(3840, 1, '_sys_txt_no_picture_uploaded'),
(3841, 1, '_sys_txt_no_title'),
(3842, 1, '_sys_txt_n_by'),
(3843, 1, '_sys_txt_n_friends'),
(3844, 1, '_sys_txt_n_mutual_friends'),
(3845, 1, '_sys_txt_one_mutual_friend'),
(3846, 1, '_sys_txt_powered_by'),
(3847, 1, '_sys_txt_report_status_0'),
(3848, 1, '_sys_txt_report_status_1'),
(3849, 1, '_sys_txt_report_status_2'),
(3850, 1, '_sys_txt_report_status_3'),
(3851, 1, '_sys_txt_reset_pasword_success'),
(3852, 1, '_sys_txt_reset_pasword_error_invalid_key'),
(3853, 1, '_sys_txt_reset_pasword_error_not_found'),
(3854, 1, '_sys_txt_reset_pasword_error_occured'),
(3855, 1, '_sys_txt_splash_btn_join'),
(3856, 1, '_sys_txt_splash_slide01_title'),
(3857, 1, '_sys_txt_splash_slide01_desc'),
(3858, 1, '_sys_txt_splash_slide02_txt'),
(3859, 1, '_sys_txt_splash_slide03_txt'),
(3860, 1, '_sys_txt_splash_slide04_txt'),
(3861, 1, '_sys_txt_splash_title'),
(3862, 1, '_sys_txt_splash_slogan'),
(3863, 1, '_sys_txt_splash_login'),
(3864, 1, '_sys_txt_splash_join'),
(3865, 1, '_sys_txt_splash_connect'),
(3866, 1, '_sys_txt_splash_connect_text'),
(3867, 1, '_sys_txt_splash_share'),
(3868, 1, '_sys_txt_splash_share_text'),
(3869, 1, '_sys_txt_splash_create'),
(3870, 1, '_sys_txt_splash_create_text'),
(3871, 1, '_sys_txt_switch_profile_context'),
(3872, 1, '_sys_txt_unsubscribe_email_settings_update_success'),
(3873, 1, '_sys_txt_unsubscribe_error_occured'),
(3874, 1, '_sys_txt_unsubscribe_info'),
(3875, 1, '_sys_txt_unsubscribe_wrong_link'),
(3876, 1, '_sys_txt_url'),
(3877, 1, '_sys_txt_user_n'),
(3878, 1, '_sys_txt_reports_title'),
(3879, 1, '_sys_txt_reports_grid_view_notes'),
(3880, 1, '_sys_txt_share_popup_header'),
(3881, 1, '_sys_txt_share_popup_url'),
(3882, 1, '_sys_txt_share_popup_copy_to_clipboard_text'),
(3883, 1, '_sys_txt_share_popup_embeded_code'),
(3884, 1, '_sys_txt_search_sort_by'),
(3885, 1, '_sys_txt_search_sort_by_default'),
(3886, 1, '_sys_unconfirmed'),
(3887, 1, '_sys_upgrade_conclusion'),
(3888, 1, '_sys_upgrade_db_and_files_versions_different'),
(3889, 1, '_sys_upgrade_files_checksum_failed'),
(3890, 1, '_sys_upgrade_files_checksum_failed_too_many'),
(3891, 1, '_sys_upgrade_files_checksum_failed_too_many_module'),
(3892, 1, '_sys_upgrade_get_version_info_failed'),
(3893, 1, '_sys_upgrade_modules_upgrade_first'),
(3894, 1, '_sys_upgrade_patch_checksum_failed'),
(3895, 1, '_sys_upgrade_patch_download_failed'),
(3896, 1, '_sys_upgrade_patch_invalid'),
(3897, 1, '_sys_upgrade_patch_unpack_failed'),
(3898, 1, '_sys_uploader_button_name_single'),
(3899, 1, '_sys_uploader_close'),
(3900, 1, '_sys_uploader_confirm_close_popup'),
(3901, 1, '_sys_uploader_confirm_leaving_page'),
(3902, 1, '_sys_uploader_crop_button_name'),
(3903, 1, '_sys_uploader_crop_rotate_left'),
(3904, 1, '_sys_uploader_crop_rotate_right'),
(3905, 1, '_sys_uploader_crop_submit_button'),
(3906, 1, '_sys_uploader_crop_title'),
(3907, 1, '_sys_uploader_crop_err_upload'),
(3908, 1, '_sys_uploader_crop_wrong_ext'),
(3909, 1, '_sys_uploader_err_msg'),
(3910, 1, '_sys_uploader_html5_button_name'),
(3911, 1, '_sys_uploader_html5_drop_area'),
(3912, 1, '_sys_uploader_html5_shoose_file'),
(3913, 1, '_sys_uploader_html5_title'),
(3914, 1, '_sys_uploader_html5_default_message'),
(3915, 1, '_sys_uploader_html5_file_is_too_big'),
(3916, 1, '_sys_uploader_html5_number_of_files_exceeded'),
(3917, 1, '_sys_uploader_html5_invalid_file_type'),
(3918, 1, '_sys_uploader_simple_attach_one_more_file'),
(3919, 1, '_sys_uploader_simple_button_name'),
(3920, 1, '_sys_uploader_simple_submit_button'),
(3921, 1, '_sys_uploader_record_video_button_name'),
(3922, 1, '_sys_uploader_record_video_submit_button'),
(3923, 1, '_sys_uploader_record_video_title'),
(3924, 1, '_sys_uploader_record_video_start_button'),
(3925, 1, '_sys_uploader_record_video_stop_button'),
(3926, 1, '_sys_uploader_record_video_mb'),
(3927, 1, '_sys_uploader_record_video_switch_camera'),
(3928, 1, '_sys_uploader_upload_canceled'),
(3929, 1, '_sys_uploader_camera_capture_failed'),
(3930, 1, '_sys_uploader_unsupported_browser'),
(3931, 1, '_sys_uploader_image_reposition'),
(3932, 1, '_sys_uploader_image_reposition_save'),
(3933, 1, '_sys_uploader_image_reposition_cancel'),
(3934, 1, '_sys_uploader_image_upload'),
(3935, 1, '_sys_uploader_image_reposition_info'),
(3936, 1, '_sys_edit_profile'),
(3937, 1, '_sys_exit'),
(3938, 1, '_sys_warn'),
(3939, 1, '_sys_x_days'),
(3940, 1, '_to'),
(3941, 1, '_top'),
(3942, 1, '_uknown'),
(3943, 1, '_undefined'),
(3944, 1, '_view_counter'),
(3945, 1, '_view_do_view'),
(3946, 1, '_view_do_view_by'),
(3947, 1, '_view_do_view_by_counter'),
(3948, 1, '_view_n_views'),
(3949, 1, '_vote_counter'),
(3950, 1, '_vote_do_like'),
(3951, 1, '_vote_do_unlike'),
(3952, 1, '_vote_do_by'),
(3953, 1, '_vote_do_by_reactions'),
(3954, 1, '_vote_do_by_x_reaction'),
(3955, 1, '_vote_do_by_summary'),
(3956, 1, '_vote_err_not_enabled'),
(3957, 1, '_vote_err_duplicate_vote'),
(3958, 1, '_vote_n_votes'),
(3959, 1, '_week_fri'),
(3960, 1, '_week_mon'),
(3961, 1, '_week_sat'),
(3962, 1, '_week_sun'),
(3963, 1, '_week_thu'),
(3964, 1, '_week_tue'),
(3965, 1, '_week_wed'),
(3966, 1, '_sys_option_labels'),
(3967, 1, '_sys_option_per_page_browse_showcase'),
(3968, 1, '_sys_option_per_page_browse_recommended'),
(3969, 1, '_sys_javascript_requred'),
(3970, 1, '_sys_wiki_system_title'),
(3971, 1, '_sys_wiki_error_page_exists'),
(3972, 1, '_sys_wiki_error_no_rev'),
(3973, 1, '_sys_wiki_error_no_revs'),
(3974, 1, '_sys_wiki_error_missing_wiki_object'),
(3975, 1, '_sys_wiki_error_action_not_allowed'),
(3976, 1, '_sys_wiki_error_incorrect_page_uri'),
(3977, 1, '_sys_wiki_error_no_such_lang'),
(3978, 1, '_sys_wiki_error_occured'),
(3979, 1, '_sys_wiki_view_rev'),
(3980, 1, '_sys_wiki_lang_mask'),
(3981, 1, '_sys_wiki_lang_mask_warn'),
(3982, 1, '_sys_wiki_lang_missing'),
(3983, 1, '_sys_wiki_revisions_deleted'),
(3984, 1, '_sys_wiki_confirm_block_deletion'),
(3985, 1, '_sys_wiki_block_deleted'),
(3986, 1, '_sys_wiki_add_block'),
(3987, 1, '_sys_wiki_add_page'),
(3988, 1, '_sys_wiki_add_page_text'),
(3989, 1, '_sys_wiki_no_missing_translations'),
(3990, 1, '_sys_wiki_all_translations_up_to_date'),
(3991, 1, '_sys_wiki_title_title'),
(3992, 1, '_sys_wiki_title_lang_missing'),
(3993, 1, '_sys_wiki_title_lang_outated'),
(3994, 1, '_sys_wiki_title_author'),
(3995, 1, '_sys_wiki_title_content'),
(3996, 1, '_sys_wiki_title_time'),
(3997, 1, '_sys_wiki_orig'),
(3998, 1, '_sys_wiki_copy'),
(3999, 1, '_sys_wiki_open_in_editor'),
(4000, 1, '_sys_wiki_external_editor_references_comment'),
(4001, 1, '_adm_lmi_cpt_groups_roles'),
(4002, 1, '_adm_form_txt_groups_roles_add_popup'),
(4003, 1, '_adm_form_txt_groups_role_value'),
(4004, 1, '_adm_form_txt_groups_role_value_err'),
(4005, 1, '_adm_form_txt_groups_roles_edit_popup'),
(4006, 1, '_adm_form_txt_groups_role_manage_fans'),
(4007, 1, '_adm_form_txt_groups_role_manage_roles'),
(4008, 1, '_adm_form_txt_groups_role_edit'),
(4009, 1, '_adm_form_txt_groups_role_invite'),
(4010, 1, '_adm_form_txt_groups_role_change_cover'),
(4011, 1, '_adm_form_txt_groups_role_post'),
(4012, 1, '_adm_form_txt_groups_role_edit_any'),
(4013, 1, '_adm_form_txt_groups_role_delete_any'),
(4014, 1, '_adm_form_txt_groups_role_pin'),
(4015, 1, '_sys_txt_quill_tooltip_bold'),
(4016, 1, '_sys_txt_quill_tooltip_italic'),
(4017, 1, '_sys_txt_quill_tooltip_underline'),
(4018, 1, '_sys_txt_quill_tooltip_clean'),
(4019, 1, '_sys_txt_quill_tooltip_list_ordered'),
(4020, 1, '_sys_txt_quill_tooltip_list_bullet'),
(4021, 1, '_sys_txt_quill_tooltip_indent_1'),
(4022, 1, '_sys_txt_quill_tooltip_indent_2'),
(4023, 1, '_sys_txt_quill_tooltip_blockquote'),
(4024, 1, '_sys_txt_quill_tooltip_direction'),
(4025, 1, '_sys_txt_quill_tooltip_script_sub'),
(4026, 1, '_sys_txt_quill_tooltip_script_super'),
(4027, 1, '_sys_txt_quill_tooltip_link'),
(4028, 1, '_sys_txt_quill_tooltip_image'),
(4029, 1, '_sys_txt_quill_tooltip_code_block'),
(4030, 1, '_sys_txt_quill_tooltip_color'),
(4031, 1, '_sys_txt_quill_tooltip_background'),
(4032, 1, '_sys_txt_quill_tooltip_align'),
(4033, 1, '_sys_txt_quill_tooltip_header'),
(4034, 1, '_sys_txt_quill_tooltip_embed'),
(4035, 1, '_sys_txt_quill_tooltip_embed_popup_header'),
(4036, 1, '_sys_txt_quill_tooltip_link_popup_header'),
(4037, 1, '_sys_queue_emails'),
(4038, 1, '_sys_queue_push'),
(4039, 1, '_sys_queue_transcoding'),
(4040, 1, '_sys_queue_storage'),
(4041, 1, '_sys_page_title_redirect'),
(4042, 1, '_sys_page_block_title_redirect'),
(4043, 1, '_sys_redirect_confirmation'),
(4044, 1, '_sys_redirect_confirmation_harmful'),
(4045, 1, '_sys_leave_page_confirmation'),
(4046, 3, '_bx_eng_wgt_cpt'),
(4047, 3, '_bx_eng_stg_cpt_type'),
(4048, 3, '_bx_eng_stg_cpt_category_system'),
(4049, 2, '_sys_module_en'),
(4050, 4, '_bx_artificer_wgt_cpt'),
(4051, 4, '_bx_artificer_stg_cpt_type'),
(4052, 4, '_bx_artificer_stg_cpt_category_system'),
(4053, 4, '_bx_artificer_stg_cpt_option_switcher_name'),
(4054, 4, '_bx_artificer_stg_cpt_option_page_width'),
(4055, 4, '_bx_artificer_stg_cpt_option_header_stretched'),
(4056, 4, '_bx_artificer_stg_cpt_option_header_search'),
(4057, 4, '_bx_artificer_stg_cpt_option_color_scheme'),
(4058, 4, '_bx_artificer_stg_cpt_option_color_scheme_auto'),
(4059, 4, '_bx_artificer_stg_cpt_option_color_scheme_light_only'),
(4060, 4, '_bx_artificer_stg_cpt_option_color_scheme_dark_only'),
(4061, 4, '_bx_artificer_stg_cpt_option_use_htmx'),
(4062, 4, '_bx_artificer_stg_cpt_category_styles_custom'),
(4063, 4, '_bx_artificer_stg_cpt_option_styles_custom'),
(4064, 4, '_bx_artificer_stg_cpt_option_images_custom'),
(4065, 4, '_bx_artificer_stg_cpt_option_images_custom_inf'),
(4066, 4, '_bx_artificer_page_block_title_splash'),
(4067, 4, '_bx_artificer_page_block_title_splash_lite'),
(4068, 4, '_bx_artificer_lmi_cpt_styles'),
(4069, 4, '_bx_artificer_menu_template_title_sidebar_site'),
(4070, 4, '_bx_artificer_menu_title_sidebar_site'),
(4071, 4, '_bx_artificer_txt_close_sidebar'),
(4072, 4, '_bx_artificer_txt_color_scheme_light'),
(4073, 4, '_bx_artificer_txt_color_scheme_dark'),
(4074, 4, '_bx_artificer_txt_color_scheme_system'),
(4075, 4, '_bx_artificer_txt_splash_welcome_l1'),
(4076, 4, '_bx_artificer_txt_splash_welcome_l2'),
(4077, 4, '_bx_artificer_txt_splash_welcome_l3'),
(4078, 4, '_bx_artificer_txt_splash_welcome_l4'),
(4079, 4, '_bx_artificer_txt_splash_welcome_a1'),
(4080, 4, '_bx_artificer_txt_splash_welcome_a2'),
(4081, 4, '_bx_artificer_txt_splash_stats_l1'),
(4082, 4, '_bx_artificer_txt_splash_stats_l2'),
(4083, 4, '_bx_artificer_txt_splash_stats_c1'),
(4084, 4, '_bx_artificer_txt_splash_stats_c2'),
(4085, 4, '_bx_artificer_txt_splash_stats_c3'),
(4086, 4, '_bx_artificer_txt_splash_login_title'),
(4087, 4, '_bx_artificer_txt_splash_login_join'),
(4088, 4, '_bx_artificer_txt_splash_login_agreement'),
(4089, 2, '_sys_module_artificer'),
(4090, 5, '_bx_persons'),
(4091, 5, '_bx_persons_cmts'),
(4092, 5, '_bx_persons_option_autoapproval'),
(4093, 5, '_bx_persons_option_default_acl_level'),
(4094, 5, '_bx_persons_option_enable_profile_activation_letter'),
(4095, 5, '_bx_persons_option_redirect_aadd'),
(4096, 5, '_bx_persons_option_redirect_aadd_profile'),
(4097, 5, '_bx_persons_option_redirect_aadd_last'),
(4098, 5, '_bx_persons_option_redirect_aadd_custom'),
(4099, 5, '_bx_persons_option_redirect_aadd_homepage'),
(4100, 5, '_bx_persons_option_redirect_aadd_custom_url'),
(4101, 5, '_bx_persons_option_activation_on'),
(4102, 5, '_bx_persons_option_activation_add'),
(4103, 5, '_bx_persons_option_activation_edit'),
(4104, 5, '_bx_persons_option_activation_off'),
(4105, 5, '_bx_persons_option_num_connections_quick'),
(4106, 5, '_bx_persons_option_per_page_browse'),
(4107, 5, '_bx_persons_option_num_rss'),
(4108, 5, '_bx_persons_option_searchable_fields'),
(4109, 5, '_bx_persons_option_public_subscriptions'),
(4110, 5, '_bx_persons_option_public_subscribed_me'),
(4111, 5, '_bx_persons_form_profile'),
(4112, 5, '_bx_persons_form_profile_display_add'),
(4113, 5, '_bx_persons_form_profile_display_edit'),
(4114, 5, '_bx_persons_form_profile_display_edit_cover'),
(4115, 5, '_bx_persons_form_profile_display_delete'),
(4116, 5, '_bx_persons_form_profile_display_view'),
(4117, 5, '_bx_persons_form_profile_display_view_full'),
(4118, 5, '_bx_persons_form_profile_input_sys_do_submit'),
(4119, 5, '_bx_persons_form_profile_input_submit'),
(4120, 5, '_bx_persons_form_profile_input_sys_allow_view_to'),
(4121, 5, '_bx_persons_form_profile_input_allow_view_to'),
(4122, 5, '_bx_persons_form_profile_input_sys_allow_post_to'),
(4123, 5, '_bx_persons_form_profile_input_allow_post_to'),
(4124, 5, '_bx_persons_form_profile_input_sys_allow_contact_to'),
(4125, 5, '_bx_persons_form_profile_input_allow_contact_to'),
(4126, 5, '_bx_persons_form_profile_input_sys_fullname'),
(4127, 5, '_bx_persons_form_profile_input_fullname'),
(4128, 5, '_bx_persons_form_profile_input_sys_last_name'),
(4129, 5, '_bx_persons_form_profile_input_last_name'),
(4130, 5, '_bx_persons_form_profile_input_fullname_err'),
(4131, 5, '_bx_persons_form_profile_input_sys_desc'),
(4132, 5, '_bx_persons_form_profile_input_desc'),
(4133, 5, '_bx_persons_form_profile_input_sys_picture'),
(4134, 5, '_bx_persons_form_profile_input_picture'),
(4135, 5, '_bx_persons_form_profile_input_picture_err'),
(4136, 5, '_bx_persons_form_profile_input_picture_search'),
(4137, 5, '_bx_persons_form_profile_input_online_search'),
(4138, 5, '_bx_persons_form_profile_input_sys_cover'),
(4139, 5, '_bx_persons_form_profile_input_cover'),
(4140, 5, '_bx_persons_form_profile_input_sys_delete_confirm'),
(4141, 5, '_bx_persons_form_profile_input_delete_confirm'),
(4142, 5, '_bx_persons_form_profile_input_delete_confirm_info'),
(4143, 5, '_bx_persons_form_profile_input_delete_confirm_error'),
(4144, 5, '_bx_persons_form_profile_input_sys_birthday'),
(4145, 5, '_bx_persons_form_profile_input_birthday_err'),
(4146, 5, '_bx_persons_form_profile_input_birthday'),
(4147, 5, '_bx_persons_form_profile_input_sys_gender'),
(4148, 5, '_bx_persons_form_profile_input_gender'),
(4149, 5, '_bx_persons_form_profile_input_sys_profile_email'),
(4150, 5, '_bx_persons_form_profile_input_profile_email'),
(4151, 5, '_bx_persons_form_profile_input_sys_profile_status'),
(4152, 5, '_bx_persons_form_profile_input_profile_status'),
(4153, 5, '_bx_persons_form_profile_input_sys_profile_ip'),
(4154, 5, '_bx_persons_form_profile_input_profile_ip'),
(4155, 5, '_bx_persons_form_profile_input_sys_profile_last_active'),
(4156, 5, '_bx_persons_form_profile_input_profile_last_active'),
(4157, 5, '_bx_persons_form_profile_input_sys_skills'),
(4158, 5, '_bx_persons_form_profile_input_skills'),
(4159, 5, '_bx_persons_form_profile_input_sys_date_added'),
(4160, 5, '_bx_persons_form_profile_input_date_added'),
(4161, 5, '_bx_persons_form_profile_input_sys_date_changed'),
(4162, 5, '_bx_persons_form_profile_input_date_changed'),
(4163, 5, '_bx_persons_form_profile_input_sys_friends_count'),
(4164, 5, '_bx_persons_form_profile_input_friends_count'),
(4165, 5, '_bx_persons_form_profile_input_sys_followers_count'),
(4166, 5, '_bx_persons_form_profile_input_followers_count'),
(4167, 5, '_bx_persons_skills_form_profile'),
(4168, 5, '_bx_persons_skills_form_profile_display_add'),
(4169, 5, '_bx_persons_skills_form_profile_display_view'),
(4170, 5, '_bx_persons_skills_form_profile_input_sys_skill_name'),
(4171, 5, '_bx_persons_skills_form_profile_input_skill_name'),
(4172, 5, '_bx_persons_skills_form_profile_input_skill_name_err'),
(4173, 5, '_bx_persons_acl_action_create_profile'),
(4174, 5, '_bx_persons_acl_action_delete_profile'),
(4175, 5, '_bx_persons_acl_action_view_profile'),
(4176, 5, '_bx_persons_acl_action_edit_any_profile'),
(4177, 5, '_bx_persons_acl_action_delete_any_profile'),
(4178, 5, '_bx_persons_page_title_sys_create_profile'),
(4179, 5, '_bx_persons_page_title_create_profile'),
(4180, 5, '_bx_persons_page_title_sys_edit_profile'),
(4181, 5, '_bx_persons_page_title_edit_profile'),
(4182, 5, '_bx_persons_page_title_sys_edit_profile_cover'),
(4183, 5, '_bx_persons_page_title_edit_profile_cover'),
(4184, 5, '_bx_persons_page_title_sys_delete_profile'),
(4185, 5, '_bx_persons_page_title_delete_profile'),
(4186, 5, '_bx_persons_page_title_sys_view_profile'),
(4187, 5, '_bx_persons_page_title_sys_view_profile_closed'),
(4188, 5, '_bx_persons_page_title_view_profile'),
(4189, 5, '_bx_persons_page_title_browse'),
(4190, 5, '_bx_persons_page_title_browse_featured'),
(4191, 5, '_bx_persons_page_title_browse_active'),
(4192, 5, '_bx_persons_page_title_browse_online'),
(4193, 5, '_bx_persons_page_title_browse_recent'),
(4194, 5, '_bx_persons_page_title_browse_connections'),
(4195, 5, '_bx_persons_page_title_browse_connections_mutual'),
(4196, 5, '_bx_persons_page_title_browse_familiar'),
(4197, 5, '_bx_persons_page_title_browse_favorites'),
(4198, 5, '_bx_persons_page_title_browse_by_acl'),
(4199, 5, '_bx_persons_page_title_browse_by_cmts'),
(4200, 5, '_bx_persons_page_title_sys_profile_favorites'),
(4201, 5, '_bx_persons_page_title_profile_favorites'),
(4202, 5, '_bx_persons_page_title_sys_profile_friends'),
(4203, 5, '_bx_persons_page_title_profile_friends'),
(4204, 5, '_bx_persons_page_title_sys_friend_requests'),
(4205, 5, '_bx_persons_page_title_friend_requests'),
(4206, 5, '_bx_persons_page_title_sys_profile_subscriptions'),
(4207, 5, '_bx_persons_page_title_profile_subscriptions'),
(4208, 5, '_bx_persons_page_title_sys_profile_relations'),
(4209, 5, '_bx_persons_page_title_profile_relations'),
(4210, 5, '_bx_persons_page_title_sys_profile_comments'),
(4211, 5, '_bx_persons_page_title_profile_comments'),
(4212, 5, '_bx_persons_page_title_sys_profile_info'),
(4213, 5, '_bx_persons_page_title_profile_info'),
(4214, 5, '_bx_persons_page_title_sys_recent'),
(4215, 5, '_bx_persons_page_title_recent'),
(4216, 5, '_bx_persons_page_title_sys_manage'),
(4217, 5, '_bx_persons_page_title_sys_manage_administration'),
(4218, 5, '_bx_persons_page_title_manage'),
(4219, 5, '_bx_persons_page_title_sys_active'),
(4220, 5, '_bx_persons_page_title_active'),
(4221, 5, '_bx_persons_page_title_sys_online'),
(4222, 5, '_bx_persons_page_title_online'),
(4223, 5, '_bx_persons_page_title_sys_entries_search'),
(4224, 5, '_bx_persons_page_title_entries_search'),
(4225, 5, '_bx_persons_page_block_title_profile_private'),
(4226, 5, '_bx_persons_page_block_title_choose_type'),
(4227, 5, '_bx_persons_page_block_title_create_profile'),
(4228, 5, '_bx_persons_page_block_title_edit_profile'),
(4229, 5, '_bx_persons_page_block_title_edit_profile_cover'),
(4230, 5, '_bx_persons_page_block_title_delete_profile'),
(4231, 5, '_bx_persons_page_block_title_profile_all_actions'),
(4232, 5, '_bx_persons_page_block_title_profile_info_link'),
(4233, 5, '_bx_persons_page_block_title_profile_info'),
(4234, 5, '_bx_persons_page_block_title_system_profile_info'),
(4235, 5, '_bx_persons_page_block_title_profile_membership'),
(4236, 5, '_bx_persons_page_block_title_system_profile_membership'),
(4237, 5, '_bx_persons_page_block_title_profile_description'),
(4238, 5, '_bx_persons_page_block_title_profile_favorites'),
(4239, 5, '_bx_persons_page_block_title_system_profile_favorites'),
(4240, 5, '_bx_persons_page_block_title_profile_friends_link'),
(4241, 5, '_bx_persons_page_block_title_profile_friends'),
(4242, 5, '_bx_persons_page_block_title_profile_friends_mutual'),
(4243, 5, '_bx_persons_page_block_title_system_profile_friends'),
(4244, 5, '_bx_persons_page_block_title_friend_requests_link'),
(4245, 5, '_bx_persons_page_block_title_system_friend_requests'),
(4246, 5, '_bx_persons_page_block_title_profile_location'),
(4247, 5, '_bx_persons_page_block_title_system_profile_subscriptions'),
(4248, 5, '_bx_persons_page_block_title_profile_subscriptions'),
(4249, 5, '_bx_persons_page_block_title_system_profile_subscribed_me'),
(4250, 5, '_bx_persons_page_block_title_profile_subscribed_me'),
(4251, 5, '_bx_persons_page_block_title_system_profile_relations'),
(4252, 5, '_bx_persons_page_block_title_profile_relations'),
(4253, 5, '_bx_persons_page_block_title_system_profile_related_me'),
(4254, 5, '_bx_persons_page_block_title_profile_related_me'),
(4255, 5, '_bx_persons_page_block_title_profile_comments'),
(4256, 5, '_bx_persons_page_block_title_entry_reports'),
(4257, 5, '_bx_persons_page_block_title_profile_comments_link'),
(4258, 5, '_bx_persons_page_block_title_featured_profiles'),
(4259, 5, '_bx_persons_page_block_title_profile_actions'),
(4260, 5, '_bx_persons_page_block_title_profile_calendar'),
(4261, 5, '_bx_persons_page_block_title_latest_profiles'),
(4262, 5, '_bx_persons_page_block_title_system_manage'),
(4263, 5, '_bx_persons_page_block_title_system_manage_administration'),
(4264, 5, '_bx_persons_page_block_title_manage'),
(4265, 5, '_bx_persons_page_block_title_sys_active_profiles'),
(4266, 5, '_bx_persons_page_block_title_active_profiles'),
(4267, 5, '_bx_persons_page_block_title_online_profiles'),
(4268, 5, '_bx_persons_page_block_title_sys_familiar_profiles'),
(4269, 5, '_bx_persons_page_block_title_familiar_profiles'),
(4270, 5, '_bx_persons_page_block_title_search_form'),
(4271, 5, '_bx_persons_page_block_title_search_results'),
(4272, 5, '_bx_persons_page_block_title_search_form_cmts'),
(4273, 5, '_bx_persons_page_block_title_search_results_cmts'),
(4274, 5, '_bx_persons_page_block_title_sys_featured_entries_view_showcase'),
(4275, 5, '_bx_persons_page_block_title_featured_entries_view_showcase'),
(4276, 5, '_bx_persons_page_block_title_sys_recommended_entries_view_showcase'),
(4277, 5, '_bx_persons_page_block_title_recommended_entries_view_showcase'),
(4278, 5, '_bx_persons_page_block_title_sys_active_entries_view_showcase'),
(4279, 5, '_bx_persons_page_block_title_active_entries_view_showcase'),
(4280, 5, '_bx_persons_page_block_title_sys_cover_block'),
(4281, 5, '_bx_persons_page_block_title_cover_block'),
(4282, 5, '_bx_persons_menu_title_submenu'),
(4283, 5, '_bx_persons_menu_set_title_submenu'),
(4284, 5, '_bx_persons_menu_set_title_view_profile_actions'),
(4285, 5, '_bx_persons_menu_title_view_profile_actions'),
(4286, 5, '_bx_persons_menu_set_title_view_profile_actions_more'),
(4287, 5, '_bx_persons_menu_title_view_profile_actions_more'),
(4288, 5, '_bx_persons_menu_title_view_profile_meta'),
(4289, 5, '_bx_persons_menu_set_title_view_profile_meta'),
(4290, 5, '_bx_persons_menu_set_title_view_profile_submenu'),
(4291, 5, '_bx_persons_menu_title_view_profile_submenu'),
(4292, 5, '_bx_persons_menu_set_title_manage_tools'),
(4293, 5, '_bx_persons_menu_title_manage_tools'),
(4294, 5, '_bx_persons_menu_item_title_system_delete_with_content'),
(4295, 5, '_bx_persons_menu_item_title_delete_with_content'),
(4296, 5, '_bx_persons_menu_item_title_system_clear_reports'),
(4297, 5, '_bx_persons_menu_item_title_clear_reports'),
(4298, 5, '_bx_persons_menu_item_title_system_manage_cf'),
(4299, 5, '_bx_persons_menu_item_title_manage_cf'),
(4300, 5, '_bx_persons_menu_item_title_system_edit_cover'),
(4301, 5, '_bx_persons_menu_item_title_edit_cover'),
(4302, 5, '_bx_persons_menu_item_title_system_edit_profile'),
(4303, 5, '_bx_persons_menu_item_title_edit_profile'),
(4304, 5, '_bx_persons_menu_item_title_system_delete_profile'),
(4305, 5, '_bx_persons_menu_item_title_delete_profile'),
(4306, 5, '_bx_persons_menu_item_title_system_delete_account'),
(4307, 5, '_bx_persons_menu_item_title_delete_account'),
(4308, 5, '_bx_persons_menu_item_title_system_delete_account_content'),
(4309, 5, '_bx_persons_menu_item_title_delete_account_content'),
(4310, 5, '_bx_persons_menu_item_title_system_profile_type'),
(4311, 5, '_bx_persons_menu_item_title_profile_type'),
(4312, 5, '_bx_persons_menu_item_title_system_create_profile'),
(4313, 5, '_bx_persons_menu_item_title_create_profile'),
(4314, 5, '_bx_persons_menu_item_title_system_view_profile_friends'),
(4315, 5, '_bx_persons_menu_item_title_view_profile_friends'),
(4316, 5, '_bx_persons_menu_item_title_system_view_profile_relations'),
(4317, 5, '_bx_persons_menu_item_title_view_profile_relations'),
(4318, 5, '_bx_persons_menu_item_title_system_view_profile_subscriptions'),
(4319, 5, '_bx_persons_menu_item_title_view_profile_subscriptions'),
(4320, 5, '_bx_persons_menu_item_title_system_view_profile_comments'),
(4321, 5, '_bx_persons_menu_item_title_view_profile_comments'),
(4322, 5, '_bx_persons_menu_item_title_system_view_profile_info'),
(4323, 5, '_bx_persons_menu_item_title_view_profile_info'),
(4324, 5, '_bx_persons_menu_item_title_system_view_profile_view'),
(4325, 5, '_bx_persons_menu_item_title_view_profile_view'),
(4326, 5, '_bx_persons_menu_item_title_system_view_profile_more_auto'),
(4327, 5, '_bx_persons_menu_item_title_view_profile_more_auto'),
(4328, 5, '_bx_persons_menu_item_title_system_befriend'),
(4329, 5, '_bx_persons_menu_item_title_befriend'),
(4330, 5, '_bx_persons_menu_item_title_befriend_sent'),
(4331, 5, '_bx_persons_menu_item_title_befriend_confirm'),
(4332, 5, '_bx_persons_menu_item_title_system_unfriend'),
(4333, 5, '_bx_persons_menu_item_title_unfriend'),
(4334, 5, '_bx_persons_menu_item_title_unfriend_cancel_request'),
(4335, 5, '_bx_persons_menu_item_title_unfriend_reject_request'),
(4336, 5, '_bx_persons_menu_item_title_system_subscribe'),
(4337, 5, '_bx_persons_menu_item_title_subscribe'),
(4338, 5, '_bx_persons_menu_item_title_system_unsubscribe'),
(4339, 5, '_bx_persons_menu_item_title_unsubscribe'),
(4340, 5, '_bx_persons_menu_item_title_system_relation_add'),
(4341, 5, '_bx_persons_menu_item_title_relation_add'),
(4342, 5, '_bx_persons_menu_item_title_system_relation_delete'),
(4343, 5, '_bx_persons_menu_item_title_relation_delete'),
(4344, 5, '_bx_persons_menu_item_title_system_more_actions'),
(4345, 5, '_bx_persons_menu_item_title_more_actions'),
(4346, 5, '_bx_persons_menu_item_title_system_friends'),
(4347, 5, '_bx_persons_menu_item_title_friends'),
(4348, 5, '_bx_persons_menu_item_title_system_relations'),
(4349, 5, '_bx_persons_menu_item_title_relations'),
(4350, 5, '_bx_persons_menu_item_title_system_friend_requests'),
(4351, 5, '_bx_persons_menu_item_title_friend_requests'),
(4352, 5, '_bx_persons_menu_item_title_system_manage_my_profiles'),
(4353, 5, '_bx_persons_menu_item_title_manage_my_profiles'),
(4354, 5, '_bx_persons_menu_item_title_system_favorites'),
(4355, 5, '_bx_persons_menu_item_title_favorites'),
(4356, 5, '_bx_persons_menu_item_title_system_subscriptions'),
(4357, 5, '_bx_persons_menu_item_title_subscriptions'),
(4358, 5, '_bx_persons_menu_item_title_system_subscribed_me'),
(4359, 5, '_bx_persons_menu_item_title_subscribed_me'),
(4360, 5, '_bx_persons_menu_item_title_system_related_me'),
(4361, 5, '_bx_persons_menu_item_title_related_me'),
(4362, 5, '_bx_persons_menu_item_title_system_followings'),
(4363, 5, '_bx_persons_menu_item_title_followings'),
(4364, 5, '_bx_persons_menu_item_title_system_entries_recent'),
(4365, 5, '_bx_persons_menu_item_title_entries_recent'),
(4366, 5, '_bx_persons_menu_item_title_system_entries_search'),
(4367, 5, '_bx_persons_menu_item_title_entries_search'),
(4368, 5, '_bx_persons_menu_item_title_system_entries_manage'),
(4369, 5, '_bx_persons_menu_item_title_entries_manage'),
(4370, 5, '_bx_persons_menu_item_title_system_entries_home'),
(4371, 5, '_bx_persons_menu_item_title_entries_home'),
(4372, 5, '_bx_persons_menu_item_title_system_admt_persons'),
(4373, 5, '_bx_persons_menu_item_title_admt_persons'),
(4374, 5, '_bx_persons_menu_item_title_manage_my'),
(4375, 5, '_bx_persons_menu_item_title_manage_all'),
(4376, 5, '_bx_persons_menu_item_title_system_entries_active'),
(4377, 5, '_bx_persons_menu_item_title_entries_active'),
(4378, 5, '_bx_persons_menu_item_title_system_entries_online'),
(4379, 5, '_bx_persons_menu_item_title_entries_online'),
(4380, 5, '_bx_persons_grid_filter_item_title_adm_select_one_filter1'),
(4381, 5, '_bx_persons_grid_filter_item_title_adm_select_one_filter2'),
(4382, 5, '_bx_persons_grid_filter_item_title_adm_active'),
(4383, 5, '_bx_persons_grid_filter_item_title_adm_pending'),
(4384, 5, '_bx_persons_grid_filter_item_title_adm_suspended'),
(4385, 5, '_bx_persons_grid_filter_item_title_adm_unconfirmed'),
(4386, 5, '_bx_persons_grid_column_title_adm_active'),
(4387, 5, '_bx_persons_grid_column_title_adm_fullname'),
(4388, 5, '_bx_persons_grid_column_title_adm_last_online'),
(4389, 5, '_bx_persons_grid_column_title_adm_account'),
(4390, 5, '_bx_persons_grid_action_title_adm_delete_with_content'),
(4391, 5, '_bx_persons_grid_action_title_adm_clear_reports'),
(4392, 5, '_bx_persons_grid_action_title_adm_set_acl_level'),
(4393, 5, '_bx_persons_grid_action_title_adm_more_actions'),
(4394, 5, '_bx_persons_grid_action_title_adm_audit_content'),
(4395, 5, '_bx_persons_grid_action_title_adm_audit_profile'),
(4396, 5, '_bx_persons_grid_action_title_adm_manage_cf'),
(4397, 5, '_bx_persons_grid_action_err_delete'),
(4398, 5, '_bx_persons_grid_txt_account_manager'),
(4399, 5, '_bx_persons_chart_growth'),
(4400, 5, '_bx_persons_chart_growth_speed'),
(4401, 5, '_bx_persons_search_extended'),
(4402, 5, '_bx_persons_search_extended_cmts'),
(4403, 5, '_bx_persons_alert_action_profile_cover_changed'),
(4404, 5, '_bx_persons_alert_action_profile_picture_changed'),
(4405, 5, '_bx_persons_txt_account_pending'),
(4406, 5, '_bx_persons_txt_account_pending_moderation'),
(4407, 5, '_bx_persons_txt_account_suspended'),
(4408, 5, '_bx_persons_txt_account_suspended_moderation'),
(4409, 5, '_bx_persons_txt_N_friends'),
(4410, 5, '_bx_persons_txt_ntfs_timeline_post_common'),
(4411, 5, '_bx_persons_txt_sample_single'),
(4412, 5, '_bx_persons_txt_sample_comment_single'),
(4413, 5, '_bx_persons_txt_sample_vote_single'),
(4414, 5, '_bx_persons_txt_sample_score_up_single'),
(4415, 5, '_bx_persons_txt_sample_score_down_single'),
(4416, 5, '_bx_persons_txt_sample_pp_single'),
(4417, 5, '_bx_persons_txt_sample_pp_single_with_article'),
(4418, 5, '_bx_persons_txt_sample_pc_single'),
(4419, 5, '_bx_persons_txt_sample_pc_single_with_article'),
(4420, 5, '_bx_persons_txt_sample_pi_action'),
(4421, 5, '_bx_persons_txt_sample_pi_action_user'),
(4422, 5, '_bx_persons_email_friend_request'),
(4423, 5, '_bx_persons_email_friend_request_subject'),
(4424, 5, '_bx_persons_email_friend_request_body'),
(4425, 2, '_sys_module_persons'),
(4426, 2, '_bx_persons_form_profile_input_gender_[[timestamp]]'),
(4427, 2, '_sys_form_input_gender_info_[[timestamp]]'),
(4428, 2, '_bx_persons_form_profile_input_birthday_[[timestamp]]'),
(4429, 2, '_sys_form_input_birthday_info_[[timestamp]]'),
(4430, 2, '_bx_persons_form_profile_input_fullname_[[timestamp]]'),
(4431, 2, '_sys_form_input_fullname_info_[[timestamp]]'),
(4432, 2, '_bx_persons_form_profile_input_desc_[[timestamp]]'),
(4433, 2, '_sys_form_input_description_info_[[timestamp]]'),
(4434, 2, '_sys_form_input_location_[[timestamp]]'),
(4435, 2, '_sys_form_input_location_info_[[timestamp]]'),
(4436, 2, '_bx_persons_form_profile_input_online_search_[[timestamp]]'),
(4437, 2, '_sys_form_input_online_info_[[timestamp]]'),
(4438, 2, '_bx_persons_form_profile_input_picture_search_[[timestamp]]'),
(4439, 2, '_sys_form_input_picture_info_[[timestamp]]'),
(4440, 2, '_sys_form_comment_input_caption_cmt_author_id_[[timestamp]]'),
(4441, 2, '_sys_form_input_cmt_author_id_info_[[timestamp]]'),
(4442, 2, '_sys_form_comment_input_caption_cmt_text_[[timestamp]]'),
(4443, 2, '_sys_form_input_cmt_text_info_[[timestamp]]'),
(4444, 2, '_sys_form_entry_input_cf_[[timestamp]]'),
(4445, 2, '_sys_form_input_cmt_cf_info_[[timestamp]]');

-- --------------------------------------------------------

--
-- Table structure for table `sys_localization_languages`
--

CREATE TABLE `sys_localization_languages` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Flag` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Direction` enum('LTR','RTL') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'LTR',
  `LanguageCountry` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Name` (`Name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_localization_languages`
--

INSERT INTO `sys_localization_languages` VALUES
(1, 'en', 'gb', 'English', 'LTR', '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_localization_strings`
--

CREATE TABLE `sys_localization_strings` (
  `IDKey` int(10) unsigned NOT NULL DEFAULT '0',
  `IDLanguage` int(10) unsigned NOT NULL DEFAULT '0',
  `String` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`IDKey`,`IDLanguage`),
  FULLTEXT KEY `String` (`String`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `sys_localization_strings`
--

INSERT INTO `sys_localization_strings` VALUES
(1, 1, 'Message was successfully sent.'),
(2, 1, 'You are a full-featured member of our community. You can, however, suspend your profile to become temporarily unavailable for others.'),
(3, 1, 'Your profile activation is in progress. Usually it takes up to 24 hours. Thank you for your patience.'),
(4, 1, 'Your profile was rejected by the system administrator because it contains illegal information or is missing some information. If you have any questions, please, <a target=_blank href="contact.php">contact us</a>, and don''t forget to specify your profile ID.'),
(5, 1, 'Your profile is temporarily out of {0} system services. You can activate it <a target=_blank href="change_status.php">here</a>. If you have any questions, please <a target=_blank href="contact.php">contact the administrators</a>.'),
(6, 1, 'You will need to follow the link supplied in the e-mail to get your account submitted for approval. <br />Send me <a target=_blank href="activation_email.php">confirmation e-mail</a>.'),
(7, 1, 'Access denied'),
(8, 1, 'Page Not Available'),
(9, 1, 'Sorry, this content is no longer available. It may have been removed or is not accessible due to violation of our terms of service.'),
(10, 1, 'Action'),
(11, 1, 'All'),
(12, 1, 'Allowed Since'),
(13, 1, 'Allowed Until'),
(14, 1, 'Allowed actions'),
(15, 1, 'anonymous'),
(16, 1, 'anonymous ({0})'),
(17, 1, 'Apply'),
(18, 1, 'Apps'),
(19, 1, 'Are you sure?'),
(20, 1, 'Auth type'),
(21, 1, 'by'),
(22, 1, 'Basic'),
(23, 1, 'Contact us'),
(24, 1, 'Contact'),
(25, 1, 'Cannot delete comments with replies'),
(26, 1, 'Cancel'),
(27, 1, 'Content'),
(28, 1, 'Contents'),
(29, 1, 'Count'),
(30, 1, 'You account was successfully deleted'),
(31, 1, 'All your content will be deleted. Are you sure you want to delete your account?'),
(32, 1, 'Date'),
(33, 1, 'Delete'),
(34, 1, 'Delete account'),
(35, 1, 'Description'),
(36, 1, 'Explanation'),
(37, 1, 'Edit'),
(38, 1, 'Email'),
(39, 1, 'Email send failed'),
(40, 1, 'Empty'),
(41, 1, 'Please, enter a value here'),
(42, 1, 'Error'),
(43, 1, 'Failed'),
(44, 1, '{0}'),
(45, 1, 'Favorite'),
(46, 1, 'Unfavorite'),
(47, 1, 'Favorited by'),
(48, 1, 'Cannot perform the action.'),
(49, 1, 'You already favorited this item.'),
(50, 1, 'The feature is not available right now. Please, try again later.'),
(51, 1, 'Feature'),
(52, 1, 'Unfeature'),
(53, 1, 'Cannot perform the action.'),
(54, 1, 'The item was already added in featured list.'),
(55, 1, 'The feature is not available right now. Please, try again later.'),
(56, 1, 'Woman'),
(57, 1, 'free'),
(58, 1, 'From'),
(59, 1, 'Filters'),
(60, 1, 'Header'),
(61, 1, 'Incorrect Captcha'),
(62, 1, 'Incorrect Email'),
(63, 1, 'Info'),
(64, 1, 'Keyword'),
(65, 1, 'lifetime'),
(66, 1, 'Woman'),
(67, 1, 'Man'),
(68, 1, 'expires: in {0} day(s)'),
(69, 1, 'expires: never'),
(70, 1, 'expires: today at {0}. (Server time: {1})'),
(71, 1, 'You are a standard member.'),
(72, 1, ''),
(73, 1, 'Man'),
(74, 1, 'Manage'),
(75, 1, 'Member'),
(76, 1, 'Login'),
(77, 1, 'Message text'),
(78, 1, '<span>{0}</span> plus'),
(79, 1, '<span>{0}</span> pluses'),
(80, 1, 'Name'),
(81, 1, 'Name is required'),
(82, 1, 'never'),
(83, 1, 'No'),
(84, 1, 'None'),
(85, 1, 'No actions allowed for this membership'),
(86, 1, 'No such comment'),
(87, 1, 'OK'),
(88, 1, 'asc'),
(89, 1, 'desc'),
(90, 1, 'Period'),
(91, 1, 'Please Wait'),
(92, 1, 'Please enter {0}-{1} characters'),
(93, 1, 'Please enter some number of characters'),
(94, 1, 'Please select a value from the list'),
(95, 1, 'Polls from: {0}'),
(96, 1, 'Preview'),
(97, 1, 'reported as ''{0}'''),
(98, 1, 'reported as ''{0}'' with a note: {1}'),
(99, 1, 'check-in'),
(100, 1, 'check-out'),
(101, 1, 'New'),
(102, 1, 'In process'),
(103, 1, 'Processed'),
(104, 1, 'All'),
(105, 1, '{0}'),
(106, 1, '{0} reports'),
(107, 1, 'Report'),
(108, 1, 'Report {0}'),
(109, 1, 'Cancel report'),
(110, 1, 'Are you sure, you want to cancel your report?'),
(111, 1, 'Reported by'),
(112, 1, 'Cannot perform action.'),
(113, 1, 'You already reported this item.'),
(114, 1, 'The feature is not available right now. Please, try again later.'),
(115, 1, 'Wrong report type.'),
(116, 1, 'Reported as '),
(117, 1, 'Reported by '),
(118, 1, 'Comments ({0})'),
(119, 1, '{0} RSS'),
(120, 1, '{0}''s Recent {1}'),
(121, 1, 'Rate'),
(122, 1, 'Read'),
(123, 1, 'Read more'),
(124, 1, 'Reset'),
(125, 1, 'Search'),
(126, 1, 'Search in all sections'),
(127, 1, 'Section'),
(128, 1, 'Select one...'),
(129, 1, 'Select all'),
(130, 1, 'Show'),
(131, 1, 'Sorry, your IP has been banned'),
(132, 1, 'Subject'),
(133, 1, 'Submit'),
(134, 1, 'Success'),
(135, 1, 'Times allowed'),
(136, 1, 'Title'),
(137, 1, 'to'),
(138, 1, 'unlimited'),
(139, 1, 'View Allowed Actions'),
(140, 1, 'View'),
(141, 1, 'Yes'),
(142, 1, 'Your email'),
(143, 1, 'Your name'),
(144, 1, 'Afghanistan'),
(145, 1, 'Afrikaans'),
(146, 1, 'Aland Islands'),
(147, 1, 'Albania'),
(148, 1, 'Algeria'),
(149, 1, 'American Samoa'),
(150, 1, 'Andorra'),
(151, 1, 'Angola'),
(152, 1, 'Anguilla'),
(153, 1, 'Antarctica'),
(154, 1, 'Antigua and Barbuda'),
(155, 1, 'Arabic'),
(156, 1, 'Argentina'),
(157, 1, 'Armenia'),
(158, 1, 'Aruba'),
(159, 1, 'Australia'),
(160, 1, 'Austria'),
(161, 1, 'Azerbaijan'),
(162, 1, 'Bahrain'),
(163, 1, 'Bangladesh'),
(164, 1, 'Barbados'),
(165, 1, 'Belarus'),
(166, 1, 'Belgium'),
(167, 1, 'Belize'),
(168, 1, 'Benin'),
(169, 1, 'Bermuda'),
(170, 1, 'Bhutan'),
(171, 1, 'Bolivia'),
(172, 1, 'Bosnia and Herzegovina'),
(173, 1, 'Botswana'),
(174, 1, 'Bouvet Island'),
(175, 1, 'Brazil'),
(176, 1, 'British Indian Ocean Territory'),
(177, 1, 'British Virgin Islands'),
(178, 1, 'Brunei'),
(179, 1, 'Bulgaria'),
(180, 1, 'Bulgarian'),
(181, 1, 'Burkina Faso'),
(182, 1, 'Burma'),
(183, 1, 'Burmese'),
(184, 1, 'Burundi'),
(185, 1, 'Cambodia'),
(186, 1, 'Cameroon'),
(187, 1, 'Canada'),
(188, 1, 'Cantonese'),
(189, 1, 'Cape Verde'),
(190, 1, 'Cayman Islands'),
(191, 1, 'Central African Republic'),
(192, 1, 'Chad'),
(193, 1, 'Chile'),
(194, 1, 'China'),
(195, 1, 'Christmas Island'),
(196, 1, 'Cocos (Keeling) Islands'),
(197, 1, 'Colombia'),
(198, 1, 'Comoros'),
(199, 1, 'Congo, Democratic Republic of the'),
(200, 1, 'Congo, Republic of the'),
(201, 1, 'Cook Islands'),
(202, 1, 'Costa Rica'),
(203, 1, 'Cote d''Ivoire'),
(204, 1, 'Croatia'),
(205, 1, 'Croatian'),
(206, 1, 'Cuba'),
(207, 1, 'Cyprus'),
(208, 1, 'Czech Republic'),
(209, 1, 'Danish'),
(210, 1, 'Denmark'),
(211, 1, 'Djibouti'),
(212, 1, 'Dominica'),
(213, 1, 'Dominican Republic'),
(214, 1, 'Dutch'),
(215, 1, 'East Timor'),
(216, 1, 'Ecuador'),
(217, 1, 'Egypt'),
(218, 1, 'El Salvador'),
(219, 1, 'English'),
(220, 1, 'Equatorial Guinea'),
(221, 1, 'Eritrea'),
(222, 1, 'Esperanto'),
(223, 1, 'Estonia'),
(224, 1, 'Estonian'),
(225, 1, 'Ethiopia'),
(226, 1, 'Falkland Islands (Islas Malvinas)'),
(227, 1, 'Faroe Islands'),
(228, 1, 'Fiji'),
(229, 1, 'Finland'),
(230, 1, 'Finnish'),
(231, 1, 'France'),
(232, 1, 'French'),
(233, 1, 'French Guiana'),
(234, 1, 'French Polynesia'),
(235, 1, 'French Southern and Antarctic Lands'),
(236, 1, 'Gabon'),
(237, 1, 'Georgia'),
(238, 1, 'German'),
(239, 1, 'Germany'),
(240, 1, 'Ghana'),
(241, 1, 'Gibraltar'),
(242, 1, 'Greece'),
(243, 1, 'Greek'),
(244, 1, 'Greenland'),
(245, 1, 'Grenada'),
(246, 1, 'Guadeloupe'),
(247, 1, 'Guam'),
(248, 1, 'Guatemala'),
(249, 1, 'Guernsey'),
(250, 1, 'Guinea'),
(251, 1, 'Guinea-Bissau'),
(252, 1, 'Gujrati'),
(253, 1, 'Guyana'),
(254, 1, 'Haiti'),
(255, 1, 'Heard Island and McDonald Islands'),
(256, 1, 'Hebrew'),
(257, 1, 'Hindi'),
(258, 1, 'Holy See (Vatican City)'),
(259, 1, 'Honduras'),
(260, 1, 'Hong Kong (SAR)'),
(261, 1, 'Hungarian'),
(262, 1, 'Hungary'),
(263, 1, 'Iceland'),
(264, 1, 'Icelandic'),
(265, 1, 'India'),
(266, 1, 'Indonesia'),
(267, 1, 'Indonesian'),
(268, 1, 'Iran'),
(269, 1, 'Iraq'),
(270, 1, 'Ireland'),
(271, 1, 'Isle of Man'),
(272, 1, 'Israel'),
(273, 1, 'Italian'),
(274, 1, 'Italy'),
(275, 1, 'Jamaica'),
(276, 1, 'Japan'),
(277, 1, 'Japanese'),
(278, 1, 'Jersey'),
(279, 1, 'Jordan'),
(280, 1, 'Kazakhstan'),
(281, 1, 'Kenya'),
(282, 1, 'Kiribati'),
(283, 1, 'Korea, North'),
(284, 1, 'Korea, South'),
(285, 1, 'Korean'),
(286, 1, 'Kuwait'),
(287, 1, 'Kyrgyzstan'),
(288, 1, 'Laos'),
(289, 1, 'Latvia'),
(290, 1, 'Latvian'),
(291, 1, 'Lebanon'),
(292, 1, 'Lesotho'),
(293, 1, 'Liberia'),
(294, 1, 'Libya'),
(295, 1, 'Liechtenstein'),
(296, 1, 'Lithuania'),
(297, 1, 'Lithuanian'),
(298, 1, 'Luxembourg'),
(299, 1, 'Macao'),
(300, 1, 'Macedonia, The Former Yugoslav Republic of'),
(301, 1, 'Madagascar'),
(302, 1, 'Malawi'),
(303, 1, 'Malay'),
(304, 1, 'Malaysia'),
(305, 1, 'Maldives'),
(306, 1, 'Mali'),
(307, 1, 'Malta'),
(308, 1, 'Mandarin'),
(309, 1, 'Marathi'),
(310, 1, 'Marshall Islands'),
(311, 1, 'Martinique'),
(312, 1, 'Mauritania'),
(313, 1, 'Mauritius'),
(314, 1, 'Mayotte'),
(315, 1, 'Mexico'),
(316, 1, 'Micronesia, Federated States of'),
(317, 1, 'Moldova'),
(318, 1, 'Moldovian'),
(319, 1, 'Monaco'),
(320, 1, 'Mongolia'),
(321, 1, 'Montenegro'),
(322, 1, 'Montserrat'),
(323, 1, 'Morocco'),
(324, 1, 'Mozambique'),
(325, 1, 'Namibia'),
(326, 1, 'Nauru'),
(327, 1, 'Nepal'),
(328, 1, 'Nepalese'),
(329, 1, 'Netherlands'),
(330, 1, 'Netherlands Antilles'),
(331, 1, 'New Caledonia'),
(332, 1, 'New Zealand'),
(333, 1, 'Nicaragua'),
(334, 1, 'Niger'),
(335, 1, 'Nigeria'),
(336, 1, 'Niue'),
(337, 1, 'Norfolk Island'),
(338, 1, 'Northern Mariana Islands'),
(339, 1, 'Norway'),
(340, 1, 'Norwegian'),
(341, 1, 'Oman'),
(342, 1, 'Pakistan'),
(343, 1, 'Palau'),
(344, 1, 'Palestinian Territory, Occupied'),
(345, 1, 'Panama'),
(346, 1, 'Papua New Guinea'),
(347, 1, 'Paraguay'),
(348, 1, 'Persian'),
(349, 1, 'Peru'),
(350, 1, 'Philippines'),
(351, 1, 'Pitcairn Islands'),
(352, 1, 'Poland'),
(353, 1, 'Polish'),
(354, 1, 'Portugal'),
(355, 1, 'Portuguese'),
(356, 1, 'Puerto Rico'),
(357, 1, 'Punjabi'),
(358, 1, 'Qatar'),
(359, 1, 'Reunion'),
(360, 1, 'Romania'),
(361, 1, 'Romanian'),
(362, 1, 'Russia'),
(363, 1, 'Russian'),
(364, 1, 'Rwanda'),
(365, 1, 'Saint Helena'),
(366, 1, 'Saint Kitts and Nevis'),
(367, 1, 'Saint Lucia'),
(368, 1, 'Saint Pierre and Miquelon'),
(369, 1, 'Saint Vincent and the Grenadines'),
(370, 1, 'Saint Barthelemy'),
(371, 1, 'Saint Martin (French part)'),
(372, 1, 'Samoa'),
(373, 1, 'San Marino'),
(374, 1, 'Sao Tome and Principe'),
(375, 1, 'Saudi Arabia'),
(376, 1, 'Senegal'),
(377, 1, 'Serbia'),
(378, 1, 'Serbian'),
(379, 1, 'Seychelles'),
(380, 1, 'Sierra Leone'),
(381, 1, 'Singapore'),
(382, 1, 'Slovakia'),
(383, 1, 'Slovenia'),
(384, 1, 'Solomon Islands'),
(385, 1, 'Somalia'),
(386, 1, 'South Africa'),
(387, 1, 'South Georgia and the South Sandwich Islands'),
(388, 1, 'Spain'),
(389, 1, 'Spanish'),
(390, 1, 'Sri Lanka'),
(391, 1, 'Sudan'),
(392, 1, 'Suriname'),
(393, 1, 'Svalbard'),
(394, 1, 'Swaziland'),
(395, 1, 'Sweden'),
(396, 1, 'Swedish'),
(397, 1, 'Switzerland'),
(398, 1, 'Syria'),
(399, 1, 'Tagalog'),
(400, 1, 'Taiwan'),
(401, 1, 'Taiwanese'),
(402, 1, 'Tajikistan'),
(403, 1, 'Tamil'),
(404, 1, 'Tanzania'),
(405, 1, 'Telugu'),
(406, 1, 'Thai'),
(407, 1, 'Thailand'),
(408, 1, 'The Bahamas'),
(409, 1, 'The Gambia'),
(410, 1, 'Togo'),
(411, 1, 'Tokelau'),
(412, 1, 'Tonga'),
(413, 1, 'Tongan'),
(414, 1, 'Trinidad and Tobago'),
(415, 1, 'Tunisia'),
(416, 1, 'Turkey'),
(417, 1, 'Turkish'),
(418, 1, 'Turkmenistan'),
(419, 1, 'Turks and Caicos Islands'),
(420, 1, 'Tuvalu'),
(421, 1, 'Uganda'),
(422, 1, 'Ukraine'),
(423, 1, 'Ukrainian'),
(424, 1, 'United Arab Emirates'),
(425, 1, 'United Kingdom'),
(426, 1, 'United States'),
(427, 1, 'United States Minor Outlying Islands'),
(428, 1, 'Urdu'),
(429, 1, 'Uruguay'),
(430, 1, 'Uzbekistan'),
(431, 1, 'Vanuatu'),
(432, 1, 'Venezuela'),
(433, 1, 'Vietnam'),
(434, 1, 'Vietnamese'),
(435, 1, 'Virgin Islands'),
(436, 1, 'Visayan'),
(437, 1, 'Wallis and Futuna'),
(438, 1, 'Western Sahara'),
(439, 1, 'Yemen'),
(440, 1, 'Zambia'),
(441, 1, 'Zimbabwe'),
(442, 1, 'AUD'),
(443, 1, 'CAD'),
(444, 1, 'EUR'),
(445, 1, 'GBP'),
(446, 1, 'USD'),
(447, 1, 'YEN'),
(448, 1, 'Cannot load the page'),
(449, 1, 'Checkout'),
(450, 1, 'Delete All'),
(451, 1, 'See All'),
(452, 1, 'Audit'),
(453, 1, 'Current status'),
(454, 1, 'Desired status'),
(455, 1, 'Executable'),
(456, 1, 'Not executable'),
(457, 1, 'Not writable'),
(458, 1, 'Not exists'),
(459, 1, 'Path'),
(460, 1, 'Permissions'),
(461, 1, 'Writable'),
(462, 1, 'Admin Tools'),
(463, 1, 'Categories'),
(464, 1, 'Category: {0}'),
(465, 1, 'Checkout'),
(466, 1, 'Products from {0} ({1} {2})'),
(467, 1, 'Products from {0} ({1}{2})'),
(468, 1, 'Modules'),
(469, 1, 'Updates'),
(470, 1, 'Featured'),
(471, 1, 'Storefront'),
(472, 1, 'Latest'),
(473, 1, 'Add New Module'),
(474, 1, 'Popular'),
(475, 1, 'Purchases'),
(476, 1, 'Search'),
(477, 1, 'Space Usage'),
(478, 1, 'Hashtag: {0}'),
(479, 1, 'Hashtags'),
(480, 1, 'Updates'),
(481, 1, 'Versions'),
(482, 1, 'Add Blocks'),
(483, 1, 'Add to Page'),
(484, 1, 'Cancel'),
(485, 1, 'Delete'),
(486, 1, 'Save'),
(487, 1, 'Add New Page'),
(488, 1, 'Delete'),
(489, 1, 'Apply'),
(490, 1, 'Cancel'),
(491, 1, 'Create'),
(492, 1, 'Settings'),
(493, 1, 'View Page'),
(494, 1, 'Custom Pages'),
(495, 1, 'Modules'),
(496, 1, 'System Pages'),
(497, 1, 'The image will be displayed in block'),
(498, 1, 'Enter the content in accordance with the selected language'),
(499, 1, 'Enter HTML content here'),
(500, 1, 'Enter a number of displayed items here'),
(501, 1, 'Enter URL to RSS resource here'),
(502, 1, 'Leave empty to use default one'),
(503, 1, 'Short name for the block, visible in block header.'),
(504, 1, 'Select user levels that can see this block'),
(505, 1, 'Store page in cache for this number of seconds'),
(506, 1, 'Just before BODY tag'),
(507, 1, 'In HEAD tag'),
(508, 1, 'Use 10-50 words to tell search engines what the page is about.'),
(509, 1, 'Use 5-10 keywords, separated by comma, associated with page content.'),
(510, 1, 'Standard commands for search engine robots. Example: noindex, nofollow.'),
(511, 1, 'Page title displayed in page header. Use at least 3 characters.'),
(512, 1, 'Page name, displayed in studio only.'),
(513, 1, 'Page address used after ''youdomain.com/page/''. It must be unique and it can not be changed later.'),
(514, 1, 'Page link to access the page.'),
(515, 1, 'Select user levels that can see this page'),
(516, 1, 'Cannot add block(s)'),
(517, 1, 'Cannot delete block'),
(518, 1, 'Select a layout box for the block'),
(519, 1, 'Cannot update block'),
(520, 1, 'The requested block cannot be deleted.'),
(521, 1, 'The requested block cannot be found.'),
(522, 1, 'Enter title, more than 3 characters'),
(523, 1, 'Cannot process action. It does not have an associated handler.'),
(524, 1, 'Nothing was changed or an error occurred.'),
(525, 1, 'Cannot create the page.'),
(526, 1, 'Cannot delete the page.'),
(527, 1, 'Please, select a page layout.'),
(528, 1, 'A title with at least 3 characters is required.'),
(529, 1, 'A name with at least 3 characters is required.'),
(530, 1, 'A unique URL with at least 3 characters is required.'),
(531, 1, 'Visibility setting are determined by custom code or not applicable here.'),
(532, 1, 'Cannot save or nothing was changed.'),
(533, 1, 'Cache'),
(534, 1, 'Cover'),
(535, 1, 'Injections'),
(536, 1, 'Layout'),
(537, 1, 'Options'),
(538, 1, 'SEO'),
(539, 1, 'Visibility'),
(540, 1, 'The changes were successfully saved'),
(541, 1, 'Active'),
(542, 1, 'Active (for App)'),
(543, 1, 'Asynchronous Mode'),
(544, 1, 'Block Cache Lifetime (in seconds)'),
(545, 1, 'Attachments'),
(546, 1, 'Alignment'),
(547, 1, 'center'),
(548, 1, 'Select alignment...'),
(549, 1, 'left'),
(550, 1, 'right'),
(551, 1, 'Image'),
(552, 1, 'Content'),
(553, 1, 'Menu'),
(554, 1, 'Select menu...'),
(555, 1, 'Content'),
(556, 1, 'Length'),
(557, 1, 'URL'),
(558, 1, 'Method'),
(559, 1, 'Module'),
(560, 1, 'Placeholder text for empty block'),
(561, 1, 'Block Layout'),
(562, 1, 'Select layout...'),
(563, 1, 'CSS Class'),
(564, 1, 'Help'),
(565, 1, 'Hidden on'),
(566, 1, 'phone'),
(567, 1, 'tablet'),
(568, 1, 'desktop'),
(569, 1, 'mobile app'),
(570, 1, 'blocks selected'),
(571, 1, 'Block submenu'),
(572, 1, 'Use ''tabs'' based block submenu'),
(573, 1, 'Title'),
(574, 1, 'Visible For'),
(575, 1, 'Anyone'),
(576, 1, 'Select Levels'),
(577, 1, 'Selected levels'),
(578, 1, 'Create New Page'),
(579, 1, 'Edit "{0}" Block'),
(580, 1, 'Add New Block'),
(581, 1, 'Cache'),
(582, 1, 'Cover'),
(583, 1, 'Custom Cover'),
(584, 1, 'Custom Title'),
(585, 1, 'Disabled'),
(586, 1, 'Enabled for all'),
(587, 1, 'Enabled for visitors only'),
(588, 1, 'Enabled for members only'),
(589, 1, 'In Footer'),
(590, 1, 'In Head'),
(591, 1, 'Layout'),
(592, 1, 'Select Layout...'),
(593, 1, 'Page (Meta) Description'),
(594, 1, 'Keywords'),
(595, 1, 'Page (Meta) Title'),
(596, 1, 'Meta Robots'),
(597, 1, 'Submenu'),
(598, 1, 'Page submenu can be selected here'),
(599, 1, 'Title'),
(600, 1, 'System Name'),
(601, 1, 'Type'),
(602, 1, 'Page display type. Default value can be changed in Studio -> Designer -> Settings.'),
(603, 1, 'URL'),
(604, 1, 'Link'),
(605, 1, 'Select Levels'),
(606, 1, 'Enable sticky blocks'),
(607, 1, 'Select Page...'),
(608, 1, 'Settings'),
(609, 1, 'Visible for {0}'),
(610, 1, 'Are you sure you want to delete the page?'),
(611, 1, 'Are you sure you want to delete the block?'),
(612, 1, 'Inactive Blocks'),
(613, 1, 'Cancel'),
(614, 1, 'Checkout'),
(615, 1, 'Delete'),
(616, 1, 'Submit'),
(617, 1, 'Download'),
(618, 1, 'Install'),
(619, 1, 'Installed'),
(620, 1, 'Sign in'),
(621, 1, 'Queued'),
(622, 1, 'Export'),
(623, 1, 'Import'),
(624, 1, 'Save'),
(625, 1, 'Add New Mix'),
(626, 1, 'Import'),
(627, 1, 'Export'),
(628, 1, 'Delete'),
(629, 1, 'Hide'),
(630, 1, 'Publish'),
(631, 1, 'Search'),
(632, 1, 'Update'),
(633, 1, 'Available:'),
(634, 1, 'Installed:'),
(635, 1, 'Updated:'),
(636, 1, 'Site will be upgraded within a minute.<br />Don''t forget to <a href="{0}store.php?page=updates">check for modules updates</a> after that.'),
(637, 1, 'Database'),
(638, 1, 'System'),
(639, 1, 'System Media'),
(640, 1, 'Select...'),
(641, 1, 'Clear all caches'),
(642, 1, 'DB'),
(643, 1, 'Clear DB cache'),
(644, 1, 'Template'),
(645, 1, 'Clear Template cache'),
(646, 1, 'CSS'),
(647, 1, 'Clear CSS cache'),
(648, 1, 'LESS'),
(649, 1, 'Clear LESS cache'),
(650, 1, 'Clear Purifier cache'),
(651, 1, 'JavaScript'),
(652, 1, 'Clear JavaScript cache'),
(653, 1, 'Clear Custom cache'),
(654, 1, 'Opcache'),
(655, 1, 'Clear Opcache'),
(656, 1, 'Failed to clear cache'),
(657, 1, 'Cache clearing is unsupported'),
(658, 1, 'Cache was successfully cleared'),
(659, 1, 'All caches are disabled'),
(660, 1, '<h3>Uninstall "{0}" template?</h3><p>Uninstalling "{0}" template will also delete all of its data. Do you want to continue?</p>'),
(661, 1, 'Delete'),
(662, 1, 'Make Default'),
(663, 1, 'Serves as "ALT" text for logo image. Used as a logo when no logo image is uploaded.'),
(664, 1, 'Note, that improper use of HTML may break the site layout.'),
(665, 1, 'Cannot process action. It does not have an associated handler.'),
(666, 1, 'You cannot deactivate template which was selected as Default'),
(667, 1, 'You need to have at least one active template.'),
(668, 1, 'Cannot make the template default.'),
(669, 1, 'Cannot remove current cover image.'),
(670, 1, 'Cannot remove current icon.'),
(671, 1, 'Cannot save: '),
(672, 1, 'Cannot save changes.'),
(673, 1, 'The changes were successfully saved'),
(674, 1, 'Note. All logo parameters can be overwritten in currently active Template app.'),
(675, 1, 'Logo Text'),
(676, 1, 'Default pages cover'),
(677, 1, 'Default profile unit cover'),
(678, 1, 'Disable pages covers'),
(679, 1, 'Enable splash page'),
(680, 1, 'default'),
(681, 1, 'Favicon (32x32)'),
(682, 1, 'SVG icon with light/dark styles'),
(683, 1, 'Apple devices icon (180x180)'),
(684, 1, 'Android devices icon (192×192)'),
(685, 1, 'Android devices splash (512×512)'),
(686, 1, 'Upload new common pages cover'),
(687, 1, 'Upload new profile unit cover'),
(688, 1, 'favicon.ico'),
(689, 1, 'single 32×32 ico image file is recommended'),
(690, 1, 'SVG icon'),
(691, 1, 'svg image with dark and light styles embedded is recommended'),
(692, 1, 'Apple devices icon'),
(693, 1, 'padding and background color is recommended for this image'),
(694, 1, 'Android devices icon'),
(695, 1, 'for Android home screen'),
(696, 1, 'Android devices splash'),
(697, 1, 'for Android splash screen'),
(698, 1, 'Logo Image'),
(699, 1, 'Logo Image (for Dark mode)'),
(700, 1, 'Logo Image (inline, low priority)'),
(701, 1, 'Mark Image'),
(702, 1, 'Mark Image (for Dark mode)'),
(703, 1, 'Mark Image (inline, low priority)'),
(704, 1, '&lt;HEAD&gt; injection'),
(705, 1, 'Code to insert before closing HEAD tag'),
(706, 1, '&lt;BODY&gt; injection'),
(707, 1, 'Code to insert before closing BODY tag'),
(708, 1, 'Cannot process action. It does not have an associated handler.'),
(709, 1, 'The module is already disabled.'),
(710, 1, 'The module is already enabled.'),
(711, 1, 'The module was already installed.'),
(712, 1, 'The module was already uninstalled.'),
(713, 1, 'Cannot add the product to shopping cart.'),
(714, 1, 'Cannot checkout. The vendor is unknown.'),
(715, 1, 'Cannot delete the product(s) from shopping cart.'),
(716, 1, 'Cannot remove package.'),
(717, 1, 'Cannot initialize the subscription.'),
(718, 1, 'Module not found'),
(719, 1, 'Update is not suitable for this module.'),
(720, 1, 'Module not installed'),
(721, 1, 'Module was modified'),
(722, 1, 'Module uninstall was postponed. Module will be uninstalled automatically after all its files are deleted.'),
(723, 1, 'Module is pending uninstall already.'),
(724, 1, 'An error occurred. Contact with module''s vendor'),
(725, 1, 'Failed to disable. The module has the following dependent modules. At least you need to disable them first.'),
(726, 1, 'The following modules should be installed and activated first:'),
(727, 1, 'Failed to uninstall. The module has the following dependent modules. You need to uninstall them first.'),
(728, 1, 'There are errors in the following MySQL queries:'),
(729, 1, 'Error: {0}'),
(730, 1, 'Unable to change permissions automatically. You need to manually change them for the following files and folders and try again:'),
(731, 1, 'You need to change permissions for the following files and folders:'),
(732, 1, '{0} - {1}'),
(733, 1, 'The module has incompatible version'),
(734, 1, 'The module is not compatible with your version of UNA'),
(735, 1, 'The new version of {0} module isn''t compatible with your version of UNA. Please upgrade UNA first (Studio &gt; Dashboard &gt; Version) and then try to upgrade the module.'),
(736, 1, 'Cannot connect to <b>UNA</b>. Please try again later.'),
(737, 1, 'Cannot get a valid answer from <b>UNA</b>. Please try again later.'),
(738, 1, 'You need to enter Key and Secret provided by <b>UNA</b> in Settings -> General.'),
(739, 1, 'Operation failed. Please report.'),
(740, 1, 'Cancel'),
(741, 1, 'Edit display'),
(742, 1, 'Save'),
(743, 1, 'Add'),
(744, 1, 'Cancel'),
(745, 1, 'Delete field'),
(746, 1, 'Edit field'),
(747, 1, 'Save'),
(748, 1, 'Add New Field'),
(749, 1, 'Visible For'),
(750, 1, 'Cancel'),
(751, 1, 'Edit form'),
(752, 1, 'Save'),
(753, 1, 'Cancel'),
(754, 1, 'Submit'),
(755, 1, 'Add'),
(756, 1, 'Back'),
(757, 1, 'Cancel'),
(758, 1, 'Submit'),
(759, 1, 'Add new badge'),
(760, 1, 'Delete'),
(761, 1, 'Add'),
(762, 1, 'Delete'),
(763, 1, 'Add'),
(764, 1, 'Cancel'),
(765, 1, 'Add New List'),
(766, 1, 'Delete List'),
(767, 1, 'Edit List'),
(768, 1, 'Save'),
(769, 1, 'Add'),
(770, 1, 'Cancel'),
(771, 1, 'Delete'),
(772, 1, 'Add New Item'),
(773, 1, 'Delete Item'),
(774, 1, 'Edit Item'),
(775, 1, 'Check in'),
(776, 1, 'Check out'),
(777, 1, 'Audit'),
(778, 1, 'Hide'),
(779, 1, 'Unhide'),
(780, 1, 'Edit search form'),
(781, 1, 'Edit search field'),
(782, 1, 'Reset'),
(783, 1, 'Reset'),
(784, 1, 'Save'),
(785, 1, 'Cancel'),
(786, 1, 'Name of the form display mode. Displayed in Studio only.'),
(787, 1, 'Enter numeric value'),
(788, 1, 'Enter numeric value'),
(789, 1, 'Enter correct image URL'),
(790, 1, 'Enter numeric value'),
(791, 1, 'Item name displayed on site'),
(792, 1, 'Title for the group of fields'),
(793, 1, 'Field title, displayed in Studio only.'),
(794, 1, 'Error message to display if text doesn''t match with text on the image'),
(795, 1, 'Use standard <a href="http://en.wikipedia.org/wiki/Regular_expression" target="_blank">regular expression</a>. Example: #^[A-Za-z0-9]{3,16}$#'),
(796, 1, 'Pack down the group of this field by default'),
(797, 1, 'Select type of HTML editor'),
(798, 1, 'You may use font icon, SVG or Emoji code here'),
(799, 1, 'Enter field description (optional)'),
(800, 1, 'Enter help information for the field (optional)'),
(801, 1, 'Check it if privacy settings can be changed for the field'),
(802, 1, 'Make this field rateable'),
(803, 1, 'Check it if the field should have value'),
(804, 1, 'Check it if the field should have unique value'),
(805, 1, 'Enter button title here'),
(806, 1, 'Send this data if checkbox is checked and form is submitted'),
(807, 1, 'Button title (this button type is used to reset the form to its default state)'),
(808, 1, 'Button title (this button type is used to send in the form data)'),
(809, 1, 'Select user levels that can see this menu item'),
(810, 1, 'Select how field''s data will be processed before saving in the database'),
(811, 1, 'Name of the form. Displayed in Studio only.'),
(812, 1, 'List Name for Studio use only'),
(813, 1, 'You can use it for items like "Please select..." which can''t be submitted.'),
(814, 1, 'Item name displayed on site'),
(815, 1, 'The type of control element in search form'),
(816, 1, 'Name of the search form. Displayed in Studio only.'),
(817, 1, 'Cannot process action. It does not have an associated handler.'),
(818, 1, 'Cannot update display'),
(819, 1, 'Enter title, more than 3 characters'),
(820, 1, 'Cannot add new field'),
(821, 1, 'Field with similar name already exists'),
(822, 1, 'Fields cannot be added in this form'),
(823, 1, 'Nested form must be selected.'),
(824, 1, 'A name with at least 3 characters is required.'),
(825, 1, 'A name with at least 3 characters is required.'),
(826, 1, 'You need to enter error message'),
(827, 1, 'Check Function should be selected'),
(828, 1, 'Enter Max Value, non-zero integer number'),
(829, 1, 'Enter Min Value, non-zero integer number'),
(830, 1, 'Enter valid regular expression'),
(831, 1, 'Cannot update field'),
(832, 1, 'Cannot update field'),
(833, 1, 'Default value should be empty or looks like 12-23'),
(834, 1, 'Use numeric characters only'),
(835, 1, 'You need to select a data set from the list.'),
(836, 1, 'Cannot update form'),
(837, 1, 'Enter name, more than 3 characters'),
(838, 1, 'Cannot add label'),
(839, 1, 'Cannot update label'),
(840, 1, 'Label should have unique non-empty value.'),
(841, 1, 'The required parameters are missing.'),
(842, 1, 'Cannot add list'),
(843, 1, 'Cannot update list'),
(844, 1, 'Enter title, more than 3 characters'),
(845, 1, 'Cannot add item'),
(846, 1, 'This list is already used. It''s impossible to add non-numeric, or less than 1, or more than {0} values in it.'),
(847, 1, 'Cannot delete item'),
(848, 1, 'Cannot update item'),
(849, 1, 'Enter title, more than one character'),
(850, 1, 'The field is essential. Please fill in.'),
(851, 1, 'Cannot update the search form field.'),
(852, 1, 'Cannot reset the search form.'),
(853, 1, 'Cannot reset the search form.'),
(854, 1, 'Cannot update the selected search form.'),
(855, 1, 'Enter name, more than 3 characters'),
(856, 1, 'All Modules'),
(857, 1, 'Are you sure you want to delete this field? It will be deleted from all Displays! You may just turn it off instead.'),
(858, 1, 'Added'),
(859, 1, 'Profile'),
(860, 1, 'Content'),
(861, 1, 'Module'),
(862, 1, 'Content''s author'),
(863, 1, 'Context'),
(864, 1, 'Action'),
(865, 1, 'Text'),
(866, 1, 'View'),
(867, 1, 'Foreground color'),
(868, 1, 'Color'),
(869, 1, 'Color'),
(870, 1, 'Show icon only'),
(871, 1, 'Delete'),
(872, 1, 'Icon'),
(873, 1, ''),
(874, 1, ''),
(875, 1, 'Current Icon'),
(876, 1, 'You may use: 1) font icon, 2) Inline SVG code, 3) Emoji'),
(877, 1, ''),
(878, 1, 'or upload a small image to be displayed near the link.'),
(879, 1, 'No icon uploaded. Text is used in menu item.'),
(880, 1, 'You need to enter font icon name here.'),
(881, 1, 'Cannot process image: '),
(882, 1, 'Cannot remove icon image: '),
(883, 1, 'Submit'),
(884, 1, 'Cancel'),
(885, 1, 'Added'),
(886, 1, 'Module'),
(887, 1, 'Add New Badge'),
(888, 1, 'Edit "{0}" badge'),
(889, 1, 'Text'),
(890, 1, 'Icon'),
(891, 1, 'Object'),
(892, 1, 'Author'),
(893, 1, 'Type'),
(894, 1, 'Text'),
(895, 1, 'Date'),
(896, 1, 'Status'),
(897, 1, 'Checked By'),
(898, 1, 'Notes'),
(899, 1, 'Comments'),
(900, 1, 'Actions'),
(901, 1, 'Edit "{0}" Display'),
(902, 1, 'Fields'),
(903, 1, 'Form'),
(904, 1, 'Module'),
(905, 1, 'System Name'),
(906, 1, 'Manage fields'),
(907, 1, 'System Name'),
(908, 1, 'Add New Field'),
(909, 1, 'Max Value'),
(910, 1, 'Min Value'),
(911, 1, 'Image Source'),
(912, 1, 'Step'),
(913, 1, 'Title'),
(914, 1, 'System Title'),
(915, 1, 'Checked by default'),
(916, 1, 'Enabled by default'),
(917, 1, 'Data Availability (something must be entered) '),
(918, 1, 'Captcha (check for correct security image text input)'),
(919, 1, 'Custom check'),
(920, 1, 'Date (check for correct date format)'),
(921, 1, 'Age''s range'),
(922, 1, 'Date and Time (check for correct date and time format)'),
(923, 1, 'E-mail (correct email address format)'),
(924, 1, 'Select...'),
(925, 1, 'Error message if check failed'),
(926, 1, 'Check for'),
(927, 1, 'Note. It''s not recommended to edit this field without absolute necessity.'),
(928, 1, 'Data Length (limit amount of characters)'),
(929, 1, 'Location Data (check for correct location data)'),
(930, 1, 'Spam-Free (check if input is SPAM-free)'),
(931, 1, 'Max Value'),
(932, 1, 'Min Value'),
(933, 1, 'Required'),
(934, 1, 'Expression'),
(935, 1, 'Regular Expression (something specific must be entered)'),
(936, 1, 'Collapsed'),
(937, 1, 'Edit "{0}" Field'),
(938, 1, 'HTML Editor'),
(939, 1, 'Full'),
(940, 1, 'Mini'),
(941, 1, 'No Editor'),
(942, 1, 'Standard'),
(943, 1, 'Icon'),
(944, 1, 'Current Icon'),
(945, 1, 'Description'),
(946, 1, 'Help'),
(947, 1, 'Module'),
(948, 1, 'Name'),
(949, 1, 'Form'),
(950, 1, 'Privacy'),
(951, 1, 'Rateable'),
(952, 1, 'Non-rateable'),
(953, 1, 'Use votes'),
(954, 1, 'Use reactions'),
(955, 1, 'Mandatory'),
(956, 1, 'Select nested form'),
(957, 1, 'Show "{0}" form field to: '),
(958, 1, 'block end'),
(959, 1, 'block header'),
(960, 1, 'button'),
(961, 1, 'captcha'),
(962, 1, 'checkbox'),
(963, 1, 'checkbox set'),
(964, 1, 'custom'),
(965, 1, 'date'),
(966, 1, 'date select'),
(967, 1, 'date range'),
(968, 1, 'age range'),
(969, 1, 'date time'),
(970, 1, 'date time range'),
(971, 1, 'age range'),
(972, 1, 'Type'),
(973, 1, 'double range slider'),
(974, 1, 'file'),
(975, 1, 'files'),
(976, 1, 'hidden'),
(977, 1, 'image'),
(978, 1, 'input set'),
(979, 1, 'location'),
(980, 1, 'location radius'),
(981, 1, 'number'),
(982, 1, 'price'),
(983, 1, 'password'),
(984, 1, 'radio set'),
(985, 1, 'reset'),
(986, 1, 'select'),
(987, 1, 'select (multiple)'),
(988, 1, 'slider'),
(989, 1, 'submit'),
(990, 1, 'switcher'),
(991, 1, 'text'),
(992, 1, 'text (range)'),
(993, 1, 'auto text'),
(994, 1, 'textarea'),
(995, 1, 'time'),
(996, 1, 'info'),
(997, 1, 'nested form'),
(998, 1, 'Unique'),
(999, 1, 'Title'),
(1000, 1, 'Value'),
(1001, 1, 'Custom text'),
(1002, 1, 'Default value'),
(1003, 1, 'Enabled uploaders'),
(1004, 1, 'Select value...'),
(1005, 1, 'Values'),
(1006, 1, 'Manage values'),
(1007, 1, 'Select list...'),
(1008, 1, 'Visible For'),
(1009, 1, 'Anyone'),
(1010, 1, 'Select Levels'),
(1011, 1, 'Selected levels'),
(1012, 1, 'Process data as'),
(1013, 1, 'Date'),
(1014, 1, 'Date as Unix Timestamp'),
(1015, 1, 'UTC Date as Unix Timestamp'),
(1016, 1, 'Date/time'),
(1017, 1, 'Date/time as Unix Timestamp'),
(1018, 1, 'UTC Date/time as Unix Timestamp'),
(1019, 1, 'Select value...'),
(1020, 1, 'System Name'),
(1021, 1, 'Manage visibility settings'),
(1022, 1, 'Module'),
(1023, 1, 'Type'),
(1024, 1, 'Visible For'),
(1025, 1, 'Edit "{0}" Form'),
(1026, 1, 'Displays'),
(1027, 1, 'Module'),
(1028, 1, 'System Name'),
(1029, 1, 'Manage displays'),
(1030, 1, '{0} displays'),
(1031, 1, '{0} fields'),
(1032, 1, 'System Name'),
(1033, 1, 'Add label'),
(1034, 1, 'Edit "{0}" label'),
(1035, 1, 'Items'),
(1036, 1, 'Manage child labels'),
(1037, 1, '{0} items'),
(1038, 1, 'Parent'),
(1039, 1, 'No Parent'),
(1040, 1, 'Grandparent Label'),
(1041, 1, 'Parent Label'),
(1042, 1, 'Sibling Labels'),
(1043, 1, 'Label'),
(1044, 1, 'Author'),
(1045, 1, 'Added'),
(1046, 1, 'Module'),
(1047, 1, 'Value'),
(1048, 1, 'Add category'),
(1049, 1, 'Edit "{0}" category'),
(1050, 1, 'Category should have unique non-empty value.'),
(1051, 1, 'Country'),
(1052, 1, 'Add New List'),
(1053, 1, 'Edit "{0}" List'),
(1054, 1, 'Module'),
(1055, 1, 'System Name'),
(1056, 1, 'Use For Sets'),
(1057, 1, 'Values'),
(1058, 1, 'Language'),
(1059, 1, 'Currency'),
(1060, 1, 'Manage values'),
(1061, 1, '{0} items'),
(1062, 1, 'No'),
(1063, 1, 'Sex'),
(1064, 1, 'System Name'),
(1065, 1, 'Yes'),
(1066, 1, 'Add New Item'),
(1067, 1, 'Edit "{0}" Item'),
(1068, 1, 'Use empty value for this item'),
(1069, 1, 'Title'),
(1070, 1, 'Title'),
(1071, 1, 'Edit "{0}" Search Form'),
(1072, 1, 'Fields'),
(1073, 1, 'Sortable Fields'),
(1074, 1, 'Type'),
(1075, 1, 'Caption'),
(1076, 1, 'Description'),
(1077, 1, 'Search Type'),
(1078, 1, 'Select Form...'),
(1079, 1, 'Edit "{0}" Search Field'),
(1080, 1, 'Caption'),
(1081, 1, 'Direction'),
(1082, 1, 'Manage fields'),
(1083, 1, 'Module'),
(1084, 1, '{0} fields'),
(1085, 1, 'System Name'),
(1086, 1, 'Select Display...'),
(1087, 1, 'Select Form...'),
(1088, 1, 'Select List...'),
(1089, 1, 'Cannot delete field'),
(1090, 1, 'Cannot delete list'),
(1091, 1, 'Expiration date'),
(1092, 1, 'IP Role'),
(1093, 1, 'Stored Logged Members IPs'),
(1094, 1, 'IP List Type is 0 : disabled'),
(1095, 1, 'IP List Type is 1 : All IPs allowed except listed'),
(1096, 1, 'IP List Type is 2 : All IPs blocked except listed'),
(1097, 1, 'sample'),
(1098, 1, '<h3>Uninstall "{0}" language?</h3><p>Uninstalling "{0}" language will also delete all of its data. Do you want to continue?</p>'),
(1099, 1, 'Actions'),
(1100, 1, 'Configuration'),
(1101, 1, 'Assistants'),
(1102, 1, 'Automators'),
(1103, 1, 'Helpers'),
(1104, 1, 'Badges'),
(1105, 1, 'Categories'),
(1106, 1, 'Checkout {checkout_counter}'),
(1107, 1, 'Covers'),
(1108, 1, 'Search'),
(1109, 1, 'Search Forms'),
(1110, 1, 'Search Fields'),
(1111, 1, 'Search Sortable Fields'),
(1112, 1, 'Welcome page'),
(1113, 1, 'Displays'),
(1114, 1, 'Downloaded'),
(1115, 1, 'Email Texts'),
(1116, 1, 'Email Template'),
(1117, 1, 'Featured'),
(1118, 1, 'Fields'),
(1119, 1, 'Files'),
(1120, 1, 'Forms'),
(1121, 1, 'General'),
(1122, 1, 'Storefront'),
(1123, 1, 'Site Icon'),
(1124, 1, 'Injections'),
(1125, 1, 'Images'),
(1126, 1, 'Items'),
(1127, 1, 'Keys'),
(1128, 1, 'i18n Settings'),
(1129, 1, 'Text Keys'),
(1130, 1, 'Labels'),
(1131, 1, 'Latest'),
(1132, 1, 'Levels'),
(1133, 1, 'Logo'),
(1134, 1, 'Menus'),
(1135, 1, 'Origins'),
(1136, 1, 'Data Lists'),
(1137, 1, 'Data Items'),
(1138, 1, 'Providers'),
(1139, 1, 'Popular'),
(1140, 1, 'Purchases'),
(1141, 1, 'Progressive Web App'),
(1142, 1, 'Actions'),
(1143, 1, 'Reports'),
(1144, 1, 'Levels'),
(1145, 1, 'Sets'),
(1146, 1, 'Settings'),
(1147, 1, 'Updates'),
(1148, 1, 'Homepage'),
(1149, 1, 'Profile'),
(1150, 1, '<h3>Uninstall "{0}" module?</h3><p>Uninstalling "{0}" module will also delete all of its data. Do you want to continue?</p>'),
(1151, 1, 'Cannot process action. It does not have an associated handler.'),
(1152, 1, 'Only admin can perform operations with modules'),
(1153, 1, 'Cannot {0} module from "{1}" directory'),
(1154, 1, 'Operation was scheduled and will be performed in a few minutes. Please wait.'),
(1155, 1, 'The product was successfully added to shopping cart.'),
(1156, 1, 'The payment was successfully accepted and should be processed automatically in a few minutes. Then the purchased product(s) will be available in Apps -> Purchases. If it doesn''t happen for some reason, please contact product''s vendor with your payment details.'),
(1157, 1, 'The package was deleted successfully'),
(1158, 1, 'The package was disabled successfully'),
(1159, 1, 'The package was enabled successfully'),
(1160, 1, 'The package was installed successfully'),
(1161, 1, 'The package was uninstalled successfully'),
(1162, 1, 'You need to to login into your <b>UNA</b> account to get data. Click <a href="{0}">here</a> to login.'),
(1163, 1, 'WARNING: You are logged in to an <a href="{0}">UNA.IO</a> account which is different from the account that generated UNA Key & Secret for your domain.'),
(1164, 1, 'Delete'),
(1165, 1, 'Add'),
(1166, 1, 'Cancel'),
(1167, 1, 'Delete item'),
(1168, 1, 'Done'),
(1169, 1, 'Edit item'),
(1170, 1, 'Add New Item'),
(1171, 1, 'Import Items'),
(1172, 1, 'Visible For'),
(1173, 1, 'Import item'),
(1174, 1, 'Save'),
(1175, 1, 'Add'),
(1176, 1, 'Cancel'),
(1177, 1, 'Add New Menu'),
(1178, 1, 'Delete Menu'),
(1179, 1, 'Edit Menu'),
(1180, 1, 'Save'),
(1181, 1, 'Add'),
(1182, 1, 'Cancel'),
(1183, 1, 'Add New Set'),
(1184, 1, 'Delete set'),
(1185, 1, 'Edit set'),
(1186, 1, 'You may use font icon, SVG or Emoji code here'),
(1187, 1, 'or upload a small image to be displayed near the link.'),
(1188, 1, 'No icon uploaded. Text is used in menu item.'),
(1189, 1, 'Enter the link URL'),
(1190, 1, 'Enter a correct JavaScript code for the link'),
(1191, 1, 'Use it to create multilevel menu inside one menu. Leave empty for one level menus.'),
(1192, 1, 'Select if you want the link to use another menu as submenu.'),
(1193, 1, 'Select if you want the link to open as a new page or within current page.'),
(1194, 1, 'Link name displayed in site menus. Use at least 3 characters.'),
(1195, 1, 'Item name, displayed in Studio only.'),
(1196, 1, 'Select user levels that can see this menu item'),
(1197, 1, 'Number of persistent menu items. Applicable for menus with ''Auto More'' mechanism only.'),
(1198, 1, 'Assign a Set of menu Items'),
(1199, 1, 'Descriptive name displayed in Studio only. Use at least 3 characters.'),
(1200, 1, 'Select presentation style - the way this menu will be displayed on site'),
(1201, 1, 'Descriptive name displayed in Studio only. Use at least 3 characters.'),
(1202, 1, 'Descriptive name displayed in Studio only. Use at least 3 characters.'),
(1203, 1, 'Cannot process action. It does not have an associated handler.'),
(1204, 1, 'Cannot create item'),
(1205, 1, 'Cannot delete item'),
(1206, 1, 'Cannot update item'),
(1207, 1, 'You need to enter font icon name here.'),
(1208, 1, 'Cannot process image: '),
(1209, 1, 'Cannot remove icon image: '),
(1210, 1, 'Cannot import item(s)'),
(1211, 1, 'You need to enter item URL'),
(1212, 1, 'You need to enter item OnClick'),
(1213, 1, 'Cannot update item'),
(1214, 1, 'Cannot create menu'),
(1215, 1, 'Cannot delete menu'),
(1216, 1, 'Cannot update menu'),
(1217, 1, 'Please, assign a Set.'),
(1218, 1, 'A unique title with at least 3 characters is required.'),
(1219, 1, 'Please, select a presentation style.'),
(1220, 1, 'A title with at least 3 characters is required.'),
(1221, 1, 'The required parameters are missing.'),
(1222, 1, 'Cannot create set'),
(1223, 1, 'Cannot delete set'),
(1224, 1, 'Set can''t be deleted because it is in use'),
(1225, 1, 'Cannot update set'),
(1226, 1, 'A title with at least 3 characters is required.'),
(1227, 1, 'All Modules'),
(1228, 1, 'Collapsed'),
(1229, 1, 'Add New Item'),
(1230, 1, 'Edit {0} Item'),
(1231, 1, 'Icon'),
(1232, 1, 'URL'),
(1233, 1, 'Custom Action'),
(1234, 1, 'Menu:'),
(1235, 1, 'Subitems:'),
(1236, 1, 'Module'),
(1237, 1, 'System Name'),
(1238, 1, 'Visible For'),
(1239, 1, 'Icon'),
(1240, 1, ''),
(1241, 1, ''),
(1242, 1, 'Current Icon'),
(1243, 1, 'Import Items'),
(1244, 1, 'URL'),
(1245, 1, 'OnClick'),
(1246, 1, 'Parent Item'),
(1247, 1, 'No Parent Item'),
(1248, 1, 'Primary'),
(1249, 1, 'Active (for App)'),
(1250, 1, 'Show "{0}" menu item to: '),
(1251, 1, 'Submenu'),
(1252, 1, 'No Submenu'),
(1253, 1, 'Show submenu in popup'),
(1254, 1, 'Target'),
(1255, 1, 'New Page'),
(1256, 1, 'Same Page'),
(1257, 1, 'Title'),
(1258, 1, 'System Name'),
(1259, 1, 'Visible For'),
(1260, 1, 'Anyone'),
(1261, 1, 'Select Levels'),
(1262, 1, 'Selected levels'),
(1263, 1, 'Manage items'),
(1264, 1, 'Manage visibility settings'),
(1265, 1, 'Add New Menu'),
(1266, 1, 'Edit "{0}" Menu'),
(1267, 1, 'Items'),
(1268, 1, 'Module'),
(1269, 1, 'Set'),
(1270, 1, 'Style'),
(1271, 1, 'System Name'),
(1272, 1, 'Persistent items'),
(1273, 1, 'Set'),
(1274, 1, 'Create New'),
(1275, 1, 'Select Set...'),
(1276, 1, 'Set Title'),
(1277, 1, 'Style'),
(1278, 1, 'Select Style...'),
(1279, 1, 'System Name'),
(1280, 1, '{0} items'),
(1281, 1, 'Select Set...'),
(1282, 1, 'Add New Set'),
(1283, 1, 'Edit "{0}" Set'),
(1284, 1, 'Items'),
(1285, 1, 'Module'),
(1286, 1, 'System Name'),
(1287, 1, 'System Name'),
(1288, 1, 'Hidden on'),
(1289, 1, 'phone'),
(1290, 1, 'tablet'),
(1291, 1, 'desktop'),
(1292, 1, 'mobile app'),
(1293, 1, 'Hidden for page type'),
(1294, 1, 'Hidden for column'),
(1295, 1, 'Thin'),
(1296, 1, 'Half'),
(1297, 1, 'Wide'),
(1298, 1, 'Full'),
(1299, 1, 'API'),
(1300, 1, 'Agents'),
(1301, 1, 'Audit'),
(1302, 1, 'Badges'),
(1303, 1, 'Forms'),
(1304, 1, 'Navigation'),
(1305, 1, 'Mobile Builder'),
(1306, 1, 'Pages'),
(1307, 1, 'Permissions'),
(1308, 1, 'Roles'),
(1309, 1, 'Dashboard'),
(1310, 1, 'Designer'),
(1311, 1, 'Studio'),
(1312, 1, 'Login'),
(1313, 1, 'Polyglot'),
(1314, 1, 'Settings'),
(1315, 1, 'Storage'),
(1316, 1, 'Apps'),
(1317, 1, 'Create New Key'),
(1318, 1, 'Delete'),
(1319, 1, 'Delete key'),
(1320, 1, 'Edit key'),
(1321, 1, 'Cancel'),
(1322, 1, 'Edit template'),
(1323, 1, 'Save'),
(1324, 1, 'Close'),
(1325, 1, 'Create'),
(1326, 1, 'Save'),
(1327, 1, 'Body of a message'),
(1328, 1, 'Name of the template. Displayed in Studio only.'),
(1329, 1, 'Subject of a message'),
(1330, 1, 'Cannot process action. It does not have an associated handler.'),
(1331, 1, 'Cannot recompile language(s).'),
(1332, 1, 'Cannot restore language(s).'),
(1333, 1, 'Cannot create key'),
(1334, 1, 'You need to fill in the form.'),
(1335, 1, 'You cannot deactivate language which was selected as Default'),
(1336, 1, 'Enter body'),
(1337, 1, 'Cannot update template'),
(1338, 1, 'Enter name, more than 3 characters'),
(1339, 1, 'Enter subject'),
(1340, 1, 'You need to have at least one active language.'),
(1341, 1, 'Cannot save changes'),
(1342, 1, 'Language(s) was successfully recompiled.'),
(1343, 1, 'Language(s) was successfully restored.'),
(1344, 1, 'All Modules'),
(1345, 1, 'Body'),
(1346, 1, 'Edit "{0}" Template'),
(1347, 1, 'Module'),
(1348, 1, 'System Title'),
(1349, 1, 'System Name'),
(1350, 1, 'Subject'),
(1351, 1, 'Key'),
(1352, 1, 'Keyword...'),
(1353, 1, 'Languages'),
(1354, 1, 'Module'),
(1355, 1, 'Create New Key'),
(1356, 1, 'Edit "{0}" Key'),
(1357, 1, 'Key Name'),
(1358, 1, 'Module'),
(1359, 1, 'Text'),
(1360, 1, 'Message itself will be here.'),
(1361, 1, 'Note, that improper use of HTML may break the email message''s layout. Also make sure that {unsubscribe} marker presents in at least one of the templates (header and/or footer).'),
(1362, 1, 'Submit'),
(1363, 1, 'The changes were successfully saved.'),
(1364, 1, 'Cannot save changes.'),
(1365, 1, 'Cannot save changes, because {unsubscribe} marker was removed from both templates, header and footer.'),
(1366, 1, 'Cancel'),
(1367, 1, 'Edit options'),
(1368, 1, 'Save'),
(1369, 1, 'Add New Level'),
(1370, 1, 'Add New Pricing Option'),
(1371, 1, 'Add Level'),
(1372, 1, 'Cancel'),
(1373, 1, 'Delete level'),
(1374, 1, 'Edit level'),
(1375, 1, 'Save'),
(1376, 1, 'Add'),
(1377, 1, 'Cancel'),
(1378, 1, 'Delete pricing option'),
(1379, 1, 'Edit pricing option'),
(1380, 1, 'Save'),
(1381, 1, 'Leave it blank if the action is always available'),
(1382, 1, 'Leave it blank for unlimited actions'),
(1383, 1, 'In hours. Leave it blank if you don''t want to reset counter'),
(1384, 1, 'Brief overview of terms and advantages of this level.'),
(1385, 1, 'You may use font icon here'),
(1386, 1, 'or upload an image.'),
(1387, 1, 'Short name for the membership level (i.e Premium, Gold, Newcomer, etc.)'),
(1388, 1, 'Limit max file size for user with this level across all modules (0 - unlimited, other system limits may apply).'),
(1389, 1, 'Limit  amount of files a user with this level can upload (0 - unlimited).'),
(1390, 1, 'Period after which the password must be changed, in days (0 - unlimited).'),
(1391, 1, 'The period for which the notification of an expired password will be sent, in days (0 - unlimited).'),
(1392, 1, 'Limit how much space can be used by user with this level across all modules (0 - unlimited).'),
(1393, 1, 'Use 0 for life-time'),
(1394, 1, 'Cannot update membership action''s options'),
(1395, 1, 'Cannot create membership level'),
(1396, 1, 'Cannot delete membership level'),
(1397, 1, 'Cannot update membership level'),
(1398, 1, 'You need to enter font icon name here.'),
(1399, 1, 'Cannot upload icon: '),
(1400, 1, 'Cannot remove icon'),
(1401, 1, 'Membership levels limit is reached.'),
(1402, 1, 'You need to enter name(3, 100) for all languages'),
(1403, 1, 'You need to enter a numeric value, leave 0 for unlimited'),
(1404, 1, 'You need to enter a numeric value, leave 0 for unlimited'),
(1405, 1, 'You need to enter a numeric value, leave 0 for unlimited'),
(1406, 1, 'You need to enter a numeric value, leave 0 for unlimited'),
(1407, 1, 'You need to enter a numeric value, leave 0 for unlimited'),
(1408, 1, 'Cannot create pricing option'),
(1409, 1, 'The similar pricing option already exists for this level.'),
(1410, 1, 'Cannot update pricing option'),
(1411, 1, 'Actions'),
(1412, 1, 'This action is available until'),
(1413, 1, 'This action is available since'),
(1414, 1, 'Number of allowed actions'),
(1415, 1, 'Edit "{0}" Action'),
(1416, 1, 'Number of actions is reset every'),
(1417, 1, 'All Modules'),
(1418, 1, 'Description'),
(1419, 1, 'Enable'),
(1420, 1, 'Icon'),
(1421, 1, 'Account'),
(1422, 1, 'Copy actions from'),
(1423, 1, 'Administrator'),
(1424, 1, 'Add New Level'),
(1425, 1, 'Description'),
(1426, 1, 'Edit "{0}" Level'),
(1427, 1, 'Icon'),
(1428, 1, ''),
(1429, 1, ''),
(1430, 1, 'Current Icon'),
(1431, 1, 'Moderator'),
(1432, 1, 'Title'),
(1433, 1, 'Pending'),
(1434, 1, 'Premium'),
(1435, 1, 'Max File Size Limit(Mb)'),
(1436, 1, 'Max Files Limit'),
(1437, 1, 'Password Expired'),
(1438, 1, 'Password Expired Notify'),
(1439, 1, 'Storage Limit(Mb)'),
(1440, 1, 'Standard'),
(1441, 1, 'Suspended'),
(1442, 1, 'Unauthenticated'),
(1443, 1, 'Unconfirmed'),
(1444, 1, 'Manage actions'),
(1445, 1, 'Max File Size'),
(1446, 1, 'Max Files'),
(1447, 1, 'Module'),
(1448, 1, '{0} actions'),
(1449, 1, 'Price'),
(1450, 1, 'Number of days'),
(1451, 1, 'Add New Pricing Option'),
(1452, 1, 'Price'),
(1453, 1, 'Edit "{0} days" Pricing Option'),
(1454, 1, 'Select Level'),
(1455, 1, 'Storage'),
(1456, 1, 'Term'),
(1457, 1, 'Title'),
(1458, 1, 'Anyone'),
(1459, 1, '{0} User Levels'),
(1460, 1, 'Nobody'),
(1461, 1, 'Add New Role'),
(1462, 1, 'Edit this role'),
(1463, 1, 'Delete this role'),
(1464, 1, 'Cannot process action. It does not have an associated handler.'),
(1465, 1, 'Cannot create role'),
(1466, 1, 'Cannot update role'),
(1467, 1, 'Cannot delete role'),
(1468, 1, 'Roles limit is reached.'),
(1469, 1, 'Actions'),
(1470, 1, 'Description'),
(1471, 1, 'Manage actions'),
(1472, 1, '{0} actions'),
(1473, 1, 'Select Role'),
(1474, 1, 'Title'),
(1475, 1, 'Add New Role'),
(1476, 1, 'Edit "{0}" Role'),
(1477, 1, 'Master'),
(1478, 1, ''),
(1479, 1, 'Operator'),
(1480, 1, ''),
(1481, 1, 'Manage Roles'),
(1482, 1, ''),
(1483, 1, 'Manage Apps'),
(1484, 1, ''),
(1485, 1, 'Use ''Appearance'' apps'),
(1486, 1, ''),
(1487, 1, 'Use ''Structure'' apps'),
(1488, 1, ''),
(1489, 1, 'Use ''Content'' apps'),
(1490, 1, ''),
(1491, 1, 'Use ''Users'' apps'),
(1492, 1, ''),
(1493, 1, 'Use ''Configuration'' apps'),
(1494, 1, ''),
(1495, 1, 'Use ''Extensions'' apps'),
(1496, 1, ''),
(1497, 1, 'Use ''Integrations'' apps'),
(1498, 1, ''),
(1499, 1, 'Title'),
(1500, 1, 'You need to enter name(3, 100) for all languages'),
(1501, 1, 'Description'),
(1502, 1, 'Copy actions from'),
(1503, 1, 'Create'),
(1504, 1, 'Cancel'),
(1505, 1, 'Save'),
(1506, 1, ''),
(1507, 1, 'Account'),
(1508, 1, 'ACL'),
(1509, 1, 'Audit'),
(1510, 1, 'Notifications'),
(1511, 1, 'Push Notifications'),
(1512, 1, 'Cache'),
(1513, 1, 'System'),
(1514, 1, 'Hidden'),
(1515, 1, 'Languages'),
(1516, 1, 'Permalinks'),
(1517, 1, 'Security'),
(1518, 1, 'General'),
(1519, 1, 'Storage'),
(1520, 1, 'System'),
(1521, 1, 'Templates'),
(1522, 1, 'SMS Sending'),
(1523, 1, 'Location'),
(1524, 1, 'Social'),
(1525, 1, 'General'),
(1526, 1, 'Layout'),
(1527, 1, 'General'),
(1528, 1, 'Usage'),
(1529, 1, 'Image width to resize before upload (0 - disable)'),
(1530, 1, 'Image height to resize before upload (0 - disable)'),
(1531, 1, 'Currency code (for checkout system)'),
(1532, 1, 'Cannot be empty.'),
(1533, 1, 'Currency sign (for display purposes only)'),
(1534, 1, 'Cannot be empty.'),
(1535, 1, 'Use GD library for image processing'),
(1536, 1, 'Notify about new accounts'),
(1537, 1, 'Notify about pruning results'),
(1538, 1, 'Number of days before membership expiration to notify members ( -1 = after expiration )'),
(1539, 1, 'Notify members about membership expiration only once (every day otherwise)'),
(1540, 1, 'Default Language'),
(1541, 1, 'Substitute (during compilation) missing translations with english ones'),
(1542, 1, 'Enable friendly permalinks for Modules'),
(1543, 1, 'Enable friendly permalinks for Pages'),
(1544, 1, 'Enable friendly permalinks for local Storage'),
(1545, 1, 'Enable SEO links'),
(1546, 1, 'Enable redirect from regular to SEO links'),
(1547, 1, 'Operator email'),
(1548, 1, 'Email address to receive critical system notifications.'),
(1549, 1, '"From" email'),
(1550, 1, 'Email address used as "sender" in transactional emails.'),
(1551, 1, 'Email template header'),
(1552, 1, 'Email template footer'),
(1553, 1, 'Enable compact view for social login'),
(1554, 1, 'Community name'),
(1555, 1, 'The default name used to refer to your site in site texts, meta tags, emails and notifications.'),
(1556, 1, 'User Tour'),
(1557, 1, 'You can edit steps and content of the User Tour <a href="/studio/polyglot.php?page=keys">here</a>.'),
(1558, 1, 'Studio Tour'),
(1559, 1, 'You can edit steps and content of the Studio Tour <a href="/studio/polyglot.php?page=keys">here</a>.'),
(1560, 1, 'Smart App Banner'),
(1561, 1, ''),
(1562, 1, 'iOS app ID for Smart App Banner'),
(1563, 1, ''),
(1564, 1, 'Enable account activation letter'),
(1565, 1, 'Account is confirmed when'),
(1566, 1, 'Hide profiles which have unconfirmed account'),
(1567, 1, 'Enable 2 Factor Authentication'),
(1568, 1, '2FA code lifetime, in seconds (0 - send code upon each login)'),
(1569, 1, 'Automatic account activation after creation'),
(1570, 1, 'Automatic profile creation from account name'),
(1571, 1, 'Online status timeframe (minutes)'),
(1572, 1, 'You need to enter a value greater than zero.'),
(1573, 1, 'Default profile type'),
(1574, 1, 'Limit number of profiles (0 - no limit)'),
(1575, 1, 'Max number of logins attempts (0 - no limit)'),
(1576, 1, 'Reset password key lifetime (in seconds)'),
(1577, 1, 'Redirect after reset password to'),
(1578, 1, 'Disable login form'),
(1579, 1, 'Disable join form'),
(1580, 1, 'Allow to use plus sign ("+") in email address'),
(1581, 1, 'Accounts pruning'),
(1582, 1, 'Accounts pruning period (in days)'),
(1583, 1, 'Number of stored old passwords  (0 = do not store)'),
(1584, 1, 'Force password change after password expiration'),
(1585, 1, 'Lock site from unauthenticated users'),
(1586, 1, 'Comma separated list of pages URIs, which are avalilable for unauthenticated users'),
(1587, 1, 'Delete accounts with no login within N days'),
(1588, 1, 'Suspend accounts with no login within N days'),
(1589, 1, 'Delete accounts which didn''t confirm email within N days'),
(1590, 1, 'Delete accounts which didn''t created any profiles within N days'),
(1591, 1, 'Home page'),
(1592, 1, 'View profile page'),
(1593, 1, 'Edit profile page'),
(1594, 1, 'Custom page'),
(1595, 1, 'URL for ''Custom Page'' redirect'),
(1596, 1, 'Redirect after profile switch to'),
(1597, 1, 'URL for ''Custom Page'' redirect'),
(1598, 1, 'Default value for ''Remember me'' feature'),
(1599, 1, 'Current page'),
(1600, 1, 'Home page'),
(1601, 1, 'View profile page'),
(1602, 1, 'Custom page'),
(1603, 1, 'Number of days before membership expiration to notify members (-1 = after expiration)'),
(1604, 1, 'Notify members about membership expiration only once (every day otherwise)'),
(1605, 1, 'Add "nofollow" attribute for external links'),
(1606, 1, 'Enable');
INSERT INTO `sys_localization_strings` VALUES
(1607, 1, 'Number of log records'),
(1608, 1, 'Delete logs older than (days)'),
(1609, 1, 'Enable for levels'),
(1610, 1, 'Force Automatic Updates'),
(1611, 1, 'Update core system and modules even if modified files are detected.'),
(1612, 1, 'Automatic System Updates'),
(1613, 1, 'Try to update core  system and modules automatically.'),
(1614, 1, 'Memcached server host'),
(1615, 1, 'Memcached server port'),
(1616, 1, 'Default Сaptcha'),
(1617, 1, 'Enable content filters'),
(1618, 1, 'Enable content filters for comments'),
(1619, 1, 'Prohibited content'),
(1620, 1, 'Content visible to unauthenticated users'),
(1621, 1, 'Ask user confirmation before redirecting user to the external site'),
(1622, 1, 'Attachable email templates list'),
(1623, 1, 'Enable DB cache'),
(1624, 1, 'DB cache engine (other than File option may require custom server setup)'),
(1625, 1, 'Payment module'),
(1626, 1, 'Default HTML editor'),
(1627, 1, 'Default Player'),
(1628, 1, 'Default video quality'),
(1629, 1, 'Default page type for visitor'),
(1630, 1, 'Default page type for member'),
(1631, 1, 'Enable leave page confirmation for pages with forms'),
(1632, 1, '<a target="_blank" href="https://momentjs.com/docs/#/displaying/format/">Date Format</a>'),
(1633, 1, '<a target="_blank" href="https://momentjs.com/docs/#/displaying/format/">Date And Time Format</a>'),
(1634, 1, '<a target="_blank" href="https://momentjs.com/docs/#/displaying/format/">Time Format</a>'),
(1635, 1, 'Use ''time ago'' format for dates less than this number of seconds'),
(1636, 1, 'Use 24h Format For Calendar Input'),
(1637, 1, 'Path to the script on FTP server'),
(1638, 1, 'FTP server login'),
(1639, 1, 'FTP server password'),
(1640, 1, 'Last cron execution time'),
(1641, 1, 'Last update'),
(1642, 1, 'Update channel'),
(1643, 1, 'Live updates interval (in milliseconds)'),
(1644, 1, 'Location field provider'),
(1645, 1, 'Location map provider'),
(1646, 1, 'Location map zoom'),
(1647, 1, 'Leaflet tile layers provider'),
(1648, 1, 'Normalize geographic names'),
(1649, 1, 'Google Maps API key'),
(1650, 1, 'Embeds provider'),
(1651, 1, 'Embed.ly API key (fill in to use instead of Iframely)'),
(1652, 1, 'Embed.ly API pattern (fill in to use instead of Iframely)'),
(1653, 1, 'Iframely API key'),
(1654, 1, 'Email queue execution flag'),
(1655, 1, 'Number of messages to send from mail queue per run'),
(1656, 1, 'Number of messages to send from mail queue per run to the same recipient'),
(1657, 1, 'UNA account key'),
(1658, 1, 'UNA account secret'),
(1659, 1, 'Enable Page cache'),
(1660, 1, 'Page cache engine (other than File option may require custom server setup)'),
(1661, 1, 'Enable page blocks cache'),
(1662, 1, 'Page blocks cache engine (other than File option may require custom server setup)'),
(1663, 1, 'Keyword Search Results'),
(1664, 1, 'Set the maximum number of results displayed per page in Keyword Search'),
(1665, 1, 'Site Search Results'),
(1666, 1, 'Set the maximum number of results displayed per page in Site Search'),
(1667, 1, 'Provider'),
(1668, 1, 'OneSignal: App ID'),
(1669, 1, 'OneSignal: REST API Key'),
(1670, 1, 'OneSignal: Short name (required only for http sites. It must match the Subdomain you entered on the Web Push settings on the OneSignal dashboard)'),
(1671, 1, 'OneSignal: Apple Safari Web ID on the Web Push settings'),
(1672, 1, 'Push queue execution flag'),
(1673, 1, 'Number of messages to send from Push queue per run'),
(1674, 1, 'Number of messages to send from Push queue per run to some recipient'),
(1675, 1, 'Provider'),
(1676, 1, 'Twilio: Account SID'),
(1677, 1, 'Twilio: Auth token'),
(1678, 1, 'Twilio: Default ''From'' number for SMS'),
(1679, 1, 'Nominatim server URL'),
(1680, 1, 'Nominatim email to identify requests'),
(1681, 1, 'reCAPTCHA/hCaptcha private key'),
(1682, 1, 'reCAPTCHA/hCaptcha public key'),
(1683, 1, 'Redirect after account creation to'),
(1684, 1, 'Redirect after email confirmation to'),
(1685, 1, 'Enable relationships'),
(1686, 1, 'Allow relationships between'),
(1687, 1, 'Revision number'),
(1688, 1, 'Enable CSRF token in forms'),
(1689, 1, 'CSRF token lifetime in seconds(0 - do not track time)'),
(1690, 1, 'Total security impact threshold to send report and block aggressor'),
(1691, 1, 'Total security impact threshold to send report'),
(1692, 1, 'Block content after N reports (0 - do not block)'),
(1693, 1, 'Logo aspect ratio'),
(1694, 1, 'Default storage engine (other than Local may require custom/additional setup)'),
(1695, 1, 'AWS access key'),
(1696, 1, 'AWS bucket'),
(1697, 1, 'AWS custom domain (require custom DNS setup)'),
(1698, 1, 'AWS secret key'),
(1699, 1, 'Endpoint (specify if other than Amazon, such as storage.googleapis.com, s3.wasabisys.com)'),
(1700, 1, 'Signature version (only S3v4alt storage supports both v2 and v4)'),
(1701, 1, 'Region (for signature v4 only)'),
(1702, 1, 'Authenticate using Amazon  IAM Role (S3v4alt storage only)'),
(1703, 1, 'Enable ACLs (S3v4alt storage only)'),
(1704, 1, 'Force authenticated URLs for specific storages'),
(1705, 1, 'Enable cache for images'),
(1706, 1, 'Cached image max size (in Kb)'),
(1707, 1, 'Use non-empty value less or equal to 10kb. Big values make no sense.'),
(1708, 1, 'Enable compression for JS/CSS files(cache should be enabled)'),
(1709, 1, 'Enable cache for CSS files'),
(1710, 1, 'Enable cache for HTML files'),
(1711, 1, 'Template cache engine (other than FileHtml option may require custom server setup)'),
(1712, 1, 'Enable cache for JS files'),
(1713, 1, 'Enable lessening for CSS files (cache should be enabled)'),
(1714, 1, 'Enable lessening for JS files (cache should be enabled)'),
(1715, 1, 'Remote video transcoding (requires special setup)'),
(1716, 1, 'Live Search Results'),
(1717, 1, 'Set the maximum number of results displayed in Live Search suggestion box.'),
(1718, 1, 'Profile Search Results'),
(1719, 1, 'Set the maximum number of results displayed per page in Profile Search.'),
(1720, 1, 'Session lifetime (min)'),
(1721, 1, 'Session authentication'),
(1722, 1, 'cURL - default timeout'),
(1723, 1, 'HTTP context read timeout (in seconds, -1 - unlimit)'),
(1724, 1, 'cURL - trust unsigned certificates or not verified hosts'),
(1725, 1, '''Content-Security-Policy: frame-ancestors'' header value'),
(1726, 1, '''X-Frame-Options'' header value (Off - don''t send this header)'),
(1727, 1, 'SameSite value for sensitive cookies'),
(1728, 1, 'Notify context member with necessary role to approve content in the context'),
(1729, 1, 'Fixed header'),
(1730, 1, 'CSS @media intervals'),
(1731, 1, 'Active Tailwind build'),
(1732, 1, 'Active Icons set'),
(1733, 1, 'Allowed extensions for image''s files'),
(1734, 1, 'Allowed extensions for video files'),
(1735, 1, 'Allowed extensions for image and video files'),
(1736, 1, 'Disallowed extensions for files'),
(1737, 1, 'Allowed extensions for audio files'),
(1738, 1, 'Default Template'),
(1739, 1, 'Template cannot be empty and must have a valid name.'),
(1740, 1, 'Use operator LIKE for search (recommended for small content)'),
(1741, 1, 'Quill - paste as plain text'),
(1742, 1, 'Quill - allow empty tags'),
(1743, 1, 'Quill - allowed formats for mini editor'),
(1744, 1, 'Quill - allowed formats for standard editor'),
(1745, 1, 'Quill - allowed formats for full editor'),
(1746, 1, 'Quill buttons for mini editor'),
(1747, 1, 'Quill buttons for standard editor'),
(1748, 1, 'Quill buttons for full editor'),
(1749, 1, 'Filter out labels from hashtag suggestion list'),
(1750, 1, 'Max number of hashtags per post'),
(1751, 1, 'Max number of mentions per post'),
(1752, 1, 'Max number of attached links per post (0 - no limit)'),
(1753, 1, 'Allow to post to context using Privacy field'),
(1754, 1, 'Hide post to context for modules in Privacy field'),
(1755, 1, 'Treat context posted in context as content'),
(1756, 1, 'Only parent group(space, event, etc) members can join'),
(1757, 1, 'Keyword min length in site search'),
(1758, 1, 'System Bot profile'),
(1759, 1, 'Choose profile which will be used as an author of system actions.'),
(1760, 1, 'Default logs storage'),
(1761, 1, 'Enable ''Quick Reactions'' mode - vote with default reaction when clicked'),
(1762, 1, 'Auto approve a comment after creation'),
(1763, 1, 'Asynchronous forms preload in "Create Post" block'),
(1764, 1, ''),
(1765, 1, 'Use Add2Any code instead of default sharing menu'),
(1766, 1, 'Add2Any code'),
(1767, 1, 'Enable API'),
(1768, 1, 'Allow access by origin'),
(1769, 1, 'Allow access with API key'),
(1770, 1, 'Access to unsafe services'),
(1771, 1, ''),
(1772, 1, 'Cookies path'),
(1773, 1, 'Secure cookies'),
(1774, 1, 'Cookies SameSite attribute'),
(1775, 1, 'Top Menu'),
(1776, 1, 'Flat comments'),
(1777, 1, 'Search sections'),
(1778, 1, 'Use extended units'),
(1779, 1, 'Use connections lists in profiles/groups units'),
(1780, 1, 'Site main URL in email notifications'),
(1781, 1, 'Site main URL in push notifications'),
(1782, 1, 'Default API key'),
(1783, 1, 'Default model'),
(1784, 1, 'Profile'),
(1785, 1, 'Auto delete transient chats everyday'),
(1786, 1, 'Assistant for Studio'),
(1787, 1, 'Assistant for Live search'),
(1788, 1, 'Assistant for ''Ask AI'' block'),
(1789, 1, 'Viewport meta tag'),
(1790, 1, 'Manifest'),
(1791, 1, 'Name'),
(1792, 1, 'Short name'),
(1793, 1, 'Description'),
(1794, 1, 'Background color'),
(1795, 1, 'Theme color'),
(1796, 1, 'Service Worker'),
(1797, 1, 'Enable'),
(1798, 1, 'URLs to cache on install (each in new line)'),
(1799, 1, 'Offline page'),
(1800, 1, 'Sockets server'),
(1801, 1, 'Type'),
(1802, 1, 'Url'),
(1803, 1, 'App id'),
(1804, 1, 'App key'),
(1805, 1, 'App secret'),
(1806, 1, 'Disabled'),
(1807, 1, 'Soketi'),
(1808, 1, 'Studio: Show header left area'),
(1809, 1, 'Studio: Show search in header left'),
(1810, 1, 'Studio: Show header center area'),
(1811, 1, 'Studio: Show header right area'),
(1812, 1, 'Studio: Show search in header right'),
(1813, 1, 'Studio: Show ''site'' link in header'),
(1814, 1, 'Studio: Show left area with menu in Launcher'),
(1815, 1, 'Studio: Microlink API key for embeds processing'),
(1816, 1, 'Global'),
(1817, 1, 'Settings were successfully saved'),
(1818, 1, 'Error in ''{0}'': {1}'),
(1819, 1, 'Cannot perform the action.'),
(1820, 1, 'Mix with the same name already exists.'),
(1821, 1, 'Import Settings'),
(1822, 1, 'Import finished. {0} items were processed.'),
(1823, 1, 'Wrong file format.'),
(1824, 1, 'Add New Mix'),
(1825, 1, 'Import Mix'),
(1826, 1, 'Dark mode'),
(1827, 1, 'Duplicate from'),
(1828, 1, 'Use ''None'' to duplicate System values'),
(1829, 1, 'Mix Title'),
(1830, 1, 'Create a <b>_sys_template_mixed_[template_name]_[mix_name]</b> language key in Polyglot to customise the publicly-displayed name. <b>[template_name]</b> and <b>[mix_name]</b> are in lowercase, underscore instead of space.'),
(1831, 1, 'Title is essential. Please, fill in this field.'),
(1832, 1, 'System'),
(1833, 1, 'Cannot remove current image.'),
(1834, 1, 'File'),
(1835, 1, 'Version'),
(1836, 1, 'Cannot connect to FTP server. Please check FTP access details in Settings -> General.'),
(1837, 1, 'Cannot unarchive ZIP package.'),
(1838, 1, 'Cannot save downloaded file.'),
(1839, 1, 'Destination FTP folder doesn''t look like a valid the script root folder.'),
(1840, 1, 'Download failed. Please report.'),
(1841, 1, 'File transfer failed, please check write permissions.'),
(1842, 1, 'FTP access info was not specified. You may enter it via Settings -> General.'),
(1843, 1, 'Cannot load product info. Try again later.'),
(1844, 1, 'Wrong package format.'),
(1845, 1, 'ZIP library is not available.'),
(1846, 1, 'Download was scheduled, in a few minutes downloaded package will be available to install via Apps &gt; Downloaded'),
(1847, 1, 'Download and subsequent installation were scheduled, it may take a few minutes'),
(1848, 1, 'Download was successfully finished, you may install it via Apps &gt; Downloaded'),
(1849, 1, 'Download and subsequent installation were successfully finished'),
(1850, 1, '({0}{1} for Premium)'),
(1851, 1, 'item(s) by'),
(1852, 1, 'or'),
(1853, 1, 'week'),
(1854, 1, 'wk'),
(1855, 1, 'month'),
(1856, 1, 'mo'),
(1857, 1, 'year'),
(1858, 1, 'yr'),
(1859, 1, 'Free'),
(1860, 1, '{0}{1}/{2}'),
(1861, 1, '{0}{1}'),
(1862, 1, 'Category'),
(1863, 1, 'Created'),
(1864, 1, 'Description'),
(1865, 1, 'Discount'),
(1866, 1, '{0}% ({1}{2}) off for Premium'),
(1867, 1, 'Price'),
(1868, 1, 'Rent'),
(1869, 1, 'Stats'),
(1870, 1, '{0} votes'),
(1871, 1, '{0} reviews'),
(1872, 1, '{0} views'),
(1873, 1, 'Tags'),
(1874, 1, 'Title'),
(1875, 1, 'Updated'),
(1876, 1, 'Vendor'),
(1877, 1, 'Version'),
(1878, 1, '{0} ({1} is available)'),
(1879, 1, '{0} - {1}'),
(1880, 1, 'Cannot process action. It does not have an associated handler.'),
(1881, 1, 'Cannot delete file(s).'),
(1882, 1, 'Files were queued for deletion. They will be deleted a little bit later.'),
(1883, 1, 'Cannot delete image(s).'),
(1884, 1, 'Images were queued for deletion. They will be deleted a little bit later.'),
(1885, 1, 'Cannot resize image.'),
(1886, 1, 'Name'),
(1887, 1, 'URL'),
(1888, 1, 'Type'),
(1889, 1, 'Date'),
(1890, 1, 'Delete'),
(1891, 1, 'Add'),
(1892, 1, 'Cancel'),
(1893, 1, 'Done'),
(1894, 1, 'Download'),
(1895, 1, 'Resize'),
(1896, 1, 'Add File'),
(1897, 1, 'Add Image'),
(1898, 1, 'Resize Image'),
(1899, 1, '{0}x{1}, {2}'),
(1900, 1, 'Width'),
(1901, 1, 'Width is essential. Please, fill in this field.'),
(1902, 1, 'Height'),
(1903, 1, 'Height is essential. Please, fill in this field.'),
(1904, 1, 'Menu'),
(1905, 1, 'Assistant'),
(1906, 1, 'Go To Site'),
(1907, 1, 'Search...'),
(1908, 1, 'Color Scheme'),
(1909, 1, 'Tour'),
(1910, 1, 'Launcher'),
(1911, 1, 'Available in App'),
(1912, 1, 'How can I help?'),
(1913, 1, 'Cancel'),
(1914, 1, 'OK'),
(1915, 1, 'Forgot password?'),
(1916, 1, 'missing'),
(1917, 1, 'Password'),
(1918, 1, 'your password'),
(1919, 1, 'Email address'),
(1920, 1, 'operator@example.com'),
(1921, 1, 'Login'),
(1922, 1, 'Enter your email and password to login to Studio.'),
(1923, 1, 'Custom'),
(1924, 1, 'Skeletons'),
(1925, 1, 'System'),
(1926, 1, 'Check module dependencies:'),
(1927, 1, 'Check module for existence:'),
(1928, 1, 'Check module to match:'),
(1929, 1, 'Check module hash:'),
(1930, 1, 'Check module version:'),
(1931, 1, 'Check the script version for compatibility:'),
(1932, 1, 'Clear database cache:'),
(1933, 1, 'Clear template cache:'),
(1934, 1, 'Delete'),
(1935, 1, 'Disable'),
(1936, 1, 'You have an unsupported UNA app installed. The "<a href=''{0}''>{1}</a>" app is no longer receiving updates and is not compatible with latest version of UNA CMS.'),
(1937, 1, 'Enable'),
(1938, 1, 'Executable'),
(1939, 1, 'Changing database:'),
(1940, 1, 'FTP access'),
(1941, 1, 'Install'),
(1942, 1, 'Install language:'),
(1943, 1, 'Login'),
(1944, 1, 'UNA Market'),
(1945, 1, 'Move source files:'),
(1946, 1, 'Installation of update <b>{0}</b> from {1} up to {2}'),
(1947, 1, 'Module'),
(1948, 1, 'Package to upload'),
(1949, 1, 'A module with similar unique parameters is already installed.'),
(1950, 1, 'Password'),
(1951, 1, 'Done'),
(1952, 1, 'Process connections:'),
(1953, 1, 'Process deleted profiles:'),
(1954, 1, 'Process menu triggers:'),
(1955, 1, 'Process page triggers:'),
(1956, 1, 'Process storages:'),
(1957, 1, 'Failed'),
(1958, 1, 'Done'),
(1959, 1, 'Process search forms:'),
(1960, 1, 'Register transcoders:'),
(1961, 1, 'Unregister transcoders:'),
(1962, 1, 'Conclusion from vendor:'),
(1963, 1, 'Introduction from vendor:'),
(1964, 1, 'Update files:'),
(1965, 1, 'Update relations:'),
(1966, 1, 'Update relations for all dependent modules:'),
(1967, 1, 'Update languages:'),
(1968, 1, 'You have the most current version.'),
(1969, 1, 'New version {0} is available.'),
(1970, 1, 'Available Updates'),
(1971, 1, 'Add New Module'),
(1972, 1, 'Writable'),
(1973, 1, 'Active'),
(1974, 1, 'Bookmark'),
(1975, 1, 'Featured'),
(1976, 1, 'Move to'),
(1977, 1, 'Remember me'),
(1978, 1, 'Select Module...'),
(1979, 1, 'Settings'),
(1980, 1, 'Actions'),
(1981, 1, 'Help'),
(1982, 1, 'Help is not available'),
(1983, 1, 'Uninstall'),
(1984, 1, 'API'),
(1985, 1, 'Agents'),
(1986, 1, 'Audit'),
(1987, 1, 'Badges'),
(1988, 1, 'Forms'),
(1989, 1, 'Navigation'),
(1990, 1, 'Pages'),
(1991, 1, 'Permissions'),
(1992, 1, 'Roles'),
(1993, 1, 'Dashboard'),
(1994, 1, 'Designer'),
(1995, 1, 'Polyglot'),
(1996, 1, 'Settings'),
(1997, 1, 'Storage'),
(1998, 1, 'App Store'),
(1999, 1, 'The feature is not available right now. Please, try again later.'),
(2000, 1, 'Comments ({0})'),
(2001, 1, 'All'),
(2002, 1, 'Friends'),
(2003, 1, 'Oldest'),
(2004, 1, 'Popular'),
(2005, 1, 'Subscriptions'),
(2006, 1, 'Newest'),
(2007, 1, 'Flat'),
(2008, 1, 'Threaded'),
(2009, 1, 'Cannot perform action. Please report.'),
(2010, 1, '<a href="{0}">Login</a> or <a href="{1}">Join</a> to comment.'),
(2011, 1, 'Comment to ''{object_title}'''),
(2012, 1, 'Comment to <a href="{object_url}">{object_title}</a>'),
(2013, 1, 'Comment author'),
(2014, 1, 'Comment content'),
(2015, 1, 'Download file'),
(2016, 1, 'View image'),
(2017, 1, 'See newer comments...'),
(2018, 1, 'See older comments...'),
(2019, 1, 'See more comments...'),
(2020, 1, 'See newer replies...'),
(2021, 1, 'See older replies...'),
(2022, 1, 'See more replies...'),
(2023, 1, 'New content'),
(2024, 1, 'Show'),
(2025, 1, 'Reply'),
(2026, 1, 'added a new comment'),
(2027, 1, 'or'),
(2028, 1, 'Pinned comment'),
(2029, 1, 'comment'),
(2030, 1, 'a comment'),
(2031, 1, '''{0}'' reaction to comment'),
(2032, 1, 'reply to comment'),
(2033, 1, 'score up vote to comment'),
(2034, 1, 'score down vote to comment'),
(2035, 1, 'vote to comment'),
(2036, 1, 'Added <a href="{sample_url}">{sample}</a> to <a href="{psample_url}">{psample}</a>'),
(2037, 1, '{0} comments'),
(2038, 1, 'Comment'),
(2039, 1, '{0}'),
(2040, 1, 'Comment'),
(2041, 1, '{0}, leave your comment here.'),
(2042, 1, 'Comment will be published as soon as it''s approved by moderator'),
(2043, 1, 'Notes'),
(2044, 1, 'Report''s Comments'),
(2045, 1, 'Reviews Rating'),
(2046, 1, 'Reviews ({0})'),
(2047, 1, '{0}, leave your review here.'),
(2048, 1, 'review'),
(2049, 1, '''{0}'' reaction to review'),
(2050, 1, 'score up vote to review'),
(2051, 1, 'score down vote to review'),
(2052, 1, 'vote to review'),
(2053, 1, 'No reviews yet'),
(2054, 1, 'Review'),
(2055, 1, '&copy; {0} Company'),
(2056, 1, 'delete'),
(2057, 1, 'Error occurred'),
(2058, 1, 'from'),
(2059, 1, 'Comment by <b>{0}</b> is hidden.'),
(2060, 1, 'In reply to'),
(2061, 1, 'In reply to {0}'),
(2062, 1, 'item'),
(2063, 1, 'items'),
(2064, 1, 'Sorry, you''ve been banned'),
(2065, 1, 'Message subject'),
(2066, 1, 'comments edit own'),
(2067, 1, 'comments post'),
(2068, 1, 'comments remove own'),
(2069, 1, 'comments vote'),
(2070, 1, 'get other members emails'),
(2071, 1, 'send greetings'),
(2072, 1, 'send messages'),
(2073, 1, 'view profiles'),
(2074, 1, 'vote'),
(2075, 1, 'Next Month'),
(2076, 1, 'Previous Month'),
(2077, 1, 'no limit'),
(2078, 1, 'Powered by'),
(2079, 1, 'See more...'),
(2080, 1, 'Show'),
(2081, 1, 'Accept'),
(2082, 1, 'Accounts'),
(2083, 1, 'Access denied. This is private content.'),
(2084, 1, 'Actions'),
(2085, 1, 'Active'),
(2086, 1, 'Email settings were successfully saved'),
(2087, 1, 'Password was successfully changed'),
(2088, 1, 'Account settings were successfully saved'),
(2089, 1, 'No confirmation'),
(2090, 1, 'email is confirmed'),
(2091, 1, 'phone is confirmed'),
(2092, 1, 'email and phone are confirmed'),
(2093, 1, 'email or phone is confirmed'),
(2094, 1, 'You haven''t created any profiles, so you can''t ''{1}''.'),
(2095, 1, 'View charts'),
(2096, 1, 'View statistical charts'),
(2097, 1, 'Comments Edit All'),
(2098, 1, 'Comments Edit Own'),
(2099, 1, 'Comments Pin'),
(2100, 1, 'Comments Post'),
(2101, 1, 'Comments Remove All'),
(2102, 1, 'Comments Remove All In Own Content'),
(2103, 1, 'Comments Remove All In Context for Context''s admins'),
(2104, 1, 'Comments Remove Own'),
(2105, 1, 'Connect (befriend, follow, etc)'),
(2106, 1, 'Create Account'),
(2107, 1, 'It make sense for guests only, you can temporary disable it or set limit by time for example.'),
(2108, 1, 'Delete Account'),
(2109, 1, 'Delete account also deletes account''s content.'),
(2110, 1, ' every {4} hours, new period begins {8}'),
(2111, 1, 'Favorite'),
(2112, 1, 'View favorites'),
(2113, 1, 'Feature'),
(2114, 1, 'View views'),
(2115, 1, 'View viewers for own content'),
(2116, 1, 'You have reached your limit for now. Your current membership ({2}) allows you to {1} no more than {3} times'),
(2117, 1, 'Your current membership ({2}) doesn''t allow you to ''{1}''.'),
(2118, 1, 'Your current membership ({2}) stopped to allow you to ''{1}'' {5}.'),
(2119, 1, 'Your current membership ({2}) will allow you to ''{1}'' {6}.'),
(2120, 1, 'You are currently not an active member. Please, ask the site <a href="mailto:{7}">administrator</a> to make you an active member so you would be able to <b>{1}</b>.'),
(2121, 1, 'Post links'),
(2122, 1, 'Post links in text and textarea form fields'),
(2123, 1, 'Use Macros'),
(2124, 1, 'Use special constructions to insert dynamic content almost anywhere'),
(2125, 1, 'Set membership level'),
(2126, 1, 'Set membership level for profiles'),
(2127, 1, 'Use membership level(s) in privacy fields'),
(2128, 1, 'Allow to limit access by membership level(s) in privacy fields'),
(2129, 1, 'Show membership private info'),
(2130, 1, 'Show membership private info'),
(2131, 1, 'Set badge'),
(2132, 1, 'Set badge for content'),
(2133, 1, 'Switch to any profile'),
(2134, 1, 'Allow switch to any profile'),
(2135, 1, 'Choose membership level as privacy'),
(2136, 1, 'Choose membership level as privacy in add content forms'),
(2137, 1, 'Set form fields privacy'),
(2138, 1, 'Allow to set privacy for form fields'),
(2139, 1, 'You can''t ''{1}'' because your profile was suspended, if you don''t know why - try to send message to <a href="mailto:{7}">administrator</a>.'),
(2140, 1, 'Not logged in users can''t ''{1}''.'),
(2141, 1, 'You didn''t confirm your profile. Please check your email with profile activation link. Unconfirmed members can''t <b>{1}</b>.'),
(2142, 1, 'Vote'),
(2143, 1, 'View votes'),
(2144, 1, 'View voters'),
(2145, 1, 'Report'),
(2146, 1, 'View reports'),
(2147, 1, 'Wiki: Add Block'),
(2148, 1, 'Wiki: Edit Block'),
(2149, 1, 'Wiki: Translate Block'),
(2150, 1, 'Wiki: Delete Version'),
(2151, 1, 'Wiki: Delete Block'),
(2152, 1, 'Wiki: History'),
(2153, 1, 'Wiki: Unsafe HTML'),
(2154, 1, 'Started: '),
(2155, 1, 'Expires: '),
(2156, 1, 'never'),
(2157, 1, 'State: '),
(2158, 1, 'Trial'),
(2159, 1, 'This field is essential. Please enter something here.'),
(2160, 1, 'This field is essential. Please select something here.'),
(2161, 1, 'Active'),
(2162, 1, 'Name'),
(2163, 1, 'Type'),
(2164, 1, 'Unit'),
(2165, 1, 'Action'),
(2166, 1, 'Time'),
(2167, 1, 'Model'),
(2168, 1, 'Profile'),
(2169, 1, 'Prompt'),
(2170, 1, 'Messages'),
(2171, 1, 'Code'),
(2172, 1, 'Added'),
(2173, 1, 'Status'),
(2174, 1, 'Add'),
(2175, 1, 'Tune'),
(2176, 1, 'Approve'),
(2177, 1, 'Add automator'),
(2178, 1, 'Edit automator'),
(2179, 1, 'Name'),
(2180, 1, 'Model'),
(2181, 1, 'Profile'),
(2182, 1, 'Leave empty to use default.'),
(2183, 1, 'Type'),
(2184, 1, 'Event'),
(2185, 1, 'Scheduler'),
(2186, 1, 'Webhook'),
(2187, 1, 'Event Type'),
(2188, 1, 'Event Action'),
(2189, 1, 'Scheduler Time'),
(2190, 1, 'Providers'),
(2191, 1, 'Add'),
(2192, 1, 'Helpers'),
(2193, 1, 'Add'),
(2194, 1, 'Assistants'),
(2195, 1, 'Add'),
(2196, 1, 'Prompt'),
(2197, 1, 'Prompt is essential. Please type something here.'),
(2198, 1, 'Auto'),
(2199, 1, 'Manual'),
(2200, 1, 'Ready'),
(2201, 1, 'Event isn''t found, please rephrase your prompt.'),
(2202, 1, 'Can''t generate code, please rephrase your prompt.'),
(2203, 1, 'Response:<br />'),
(2204, 1, 'Active'),
(2205, 1, 'Name'),
(2206, 1, 'Type'),
(2207, 1, 'Added'),
(2208, 1, 'Add Provider'),
(2209, 1, 'Info'),
(2210, 1, 'Edit'),
(2211, 1, 'Delete'),
(2212, 1, 'Add provider'),
(2213, 1, 'Edit provider'),
(2214, 1, 'View provider'),
(2215, 1, 'Type'),
(2216, 1, 'Type is essential. Please select a value.'),
(2217, 1, 'Name'),
(2218, 1, 'Shopify (Admin API)'),
(2219, 1, 'Active'),
(2220, 1, 'Activate(Deactivate) source'),
(2221, 1, 'Shop domain'),
(2222, 1, ''),
(2223, 1, 'Access token'),
(2224, 1, ''),
(2225, 1, 'Secret key'),
(2226, 1, ''),
(2227, 1, 'Webhook URL'),
(2228, 1, ''),
(2229, 1, 'Active'),
(2230, 1, 'Name'),
(2231, 1, 'Model'),
(2232, 1, 'Profile'),
(2233, 1, 'Prompt'),
(2234, 1, 'Added'),
(2235, 1, 'Add Helper'),
(2236, 1, 'Tune'),
(2237, 1, 'Name'),
(2238, 1, 'Model'),
(2239, 1, 'Profile'),
(2240, 1, 'Leave empty to use default.'),
(2241, 1, 'Description'),
(2242, 1, 'Prompt'),
(2243, 1, 'Prompt is essential. Please type something here.'),
(2244, 1, 'Message'),
(2245, 1, 'Message is essential. Please type something here.'),
(2246, 1, 'Result'),
(2247, 1, 'Add helper'),
(2248, 1, 'Edit helper'),
(2249, 1, 'Active'),
(2250, 1, 'Name'),
(2251, 1, 'Model'),
(2252, 1, 'Profile'),
(2253, 1, 'Prompt'),
(2254, 1, 'Added'),
(2255, 1, 'Assistant'),
(2256, 1, 'onClick code for a link'),
(2257, 1, 'Button HTML code'),
(2258, 1, 'Add knowledge'),
(2259, 1, 'Ask'),
(2260, 1, 'Add Assistant'),
(2261, 1, 'Chats'),
(2262, 1, 'Files'),
(2263, 1, 'Get codes'),
(2264, 1, 'Name'),
(2265, 1, 'Model'),
(2266, 1, 'Profile'),
(2267, 1, 'Leave empty to use default.'),
(2268, 1, 'Description'),
(2269, 1, 'Prompt'),
(2270, 1, 'Prompt is essential. Please type something here.'),
(2271, 1, 'Result'),
(2272, 1, 'Add assistant'),
(2273, 1, 'Edit assistant'),
(2274, 1, 'Name'),
(2275, 1, 'Type'),
(2276, 1, 'Permanent'),
(2277, 1, 'Transient'),
(2278, 1, 'Description'),
(2279, 1, 'Messages'),
(2280, 1, 'Added'),
(2281, 1, 'Stored'),
(2282, 1, 'Chat'),
(2283, 1, 'Add Chat'),
(2284, 1, 'Chat'),
(2285, 1, 'Store for future usage'),
(2286, 1, 'Remove from store'),
(2287, 1, 'Name'),
(2288, 1, 'Description'),
(2289, 1, 'Add chat'),
(2290, 1, 'Edit chat'),
(2291, 1, 'I''m thinking. Please wait.'),
(2292, 1, 'Cannot get response'),
(2293, 1, 'Name'),
(2294, 1, 'Size'),
(2295, 1, 'Status'),
(2296, 1, 'In progress'),
(2297, 1, 'Completed'),
(2298, 1, 'Failed'),
(2299, 1, 'Cancelled'),
(2300, 1, 'Added'),
(2301, 1, 'Add File'),
(2302, 1, 'Sync'),
(2303, 1, 'Delete file'),
(2304, 1, 'File'),
(2305, 1, 'Add File'),
(2306, 1, 'Type'),
(2307, 1, 'Text'),
(2308, 1, 'Question with answer'),
(2309, 1, 'Text'),
(2310, 1, 'Question'),
(2311, 1, 'Answer'),
(2312, 1, 'Add Knowledge'),
(2313, 1, 'Ask Assistant'),
(2314, 1, 'Knowledge was added.'),
(2315, 1, 'Information'),
(2316, 1, 'Content edited'),
(2317, 1, 'Content added'),
(2318, 1, 'Content removed'),
(2319, 1, 'Comment edited'),
(2320, 1, 'Comment added'),
(2321, 1, 'Comment removed'),
(2322, 1, 'Featured'),
(2323, 1, 'Unfeatured'),
(2324, 1, 'Marked as resolved'),
(2325, 1, 'Added to group admins'),
(2326, 1, 'Removed from group admins'),
(2327, 1, 'Group role was changed'),
(2328, 1, 'Join request accepted'),
(2329, 1, 'Made operator'),
(2330, 1, 'Unmade operator'),
(2331, 1, 'Unlocked'),
(2332, 1, 'Login'),
(2333, 1, 'Failed login attempt'),
(2334, 1, 'Logout'),
(2335, 1, 'Password reseted'),
(2336, 1, 'Confirmation email re-sended'),
(2337, 1, 'Removed with content'),
(2338, 1, 'Removed'),
(2339, 1, 'Email changed'),
(2340, 1, 'Activated'),
(2341, 1, 'Suspended'),
(2342, 1, 'Enabled'),
(2343, 1, 'Disabled'),
(2344, 1, 'Membership set'),
(2345, 1, 'Approved'),
(2346, 1, 'Activated'),
(2347, 1, 'Disapproved'),
(2348, 1, 'Suspended'),
(2349, 1, 'Reported'),
(2350, 1, 'Comment Reported'),
(2351, 1, 'Locked'),
(2352, 1, 'Unlocked'),
(2353, 1, 'Sticked'),
(2354, 1, 'Unsticked'),
(2355, 1, 'Promoted'),
(2356, 1, 'Unpromoted'),
(2357, 1, 'Add friend'),
(2358, 1, 'Add relationship'),
(2359, 1, 'Installed'),
(2360, 1, 'Apply'),
(2361, 1, 'Filter:'),
(2362, 1, 'Select Profile'),
(2363, 1, 'Select Action'),
(2364, 1, 'Cron jobs'),
(2365, 1, 'Last cron jobs execution'),
(2366, 1, 'Manual Server Audit'),
(2367, 1, 'Requirements'),
(2368, 1, 'Site optimization'),
(2369, 1, 'Site setup'),
(2370, 1, 'Mail sending'),
(2371, 1, 'you will need to install {0} for Apache'),
(2372, 1, '<pre class="code">{0}</pre> if you are unsure if output is correct then <a href="#manual_audit">manual server audit</a> may be required'),
(2373, 1, 'please enable this cache in Studio &gt; Settings &gt; Cache'),
(2374, 1, 'installing PHP accelerator will speed-up file cache'),
(2375, 1, ' ({0} based cache engine)'),
(2376, 1, '<pre class="code">{0}</pre>if you don''t know if output is correct then <a href="#manual_audit">manual server audit</a> may be required.'),
(2377, 1, 'Hardware requirements can not be determined automatically - <a href="#manual_audit">manual server audit</a> may be required.'),
(2378, 1, 'mail send failed'),
(2379, 1, '<span id="bx-sys-adm-audit-test-email"><a href="javascript:void(0);" onclick="bx_sys_adm_audit_test_email()">click here</a> to send test email</span>'),
(2380, 1, 'test mail was send, please check {0} mailbox'),
(2381, 1, '<p>\nSome things can not be determined automatically, manual server audit is required to check it. \nIf you don''t know how to do it by yourself you can submit <a target="_blank" href="mailto:support@una.io?subject=Server Audit Request">Server Audit Request</a>.\n</p>'),
(2382, 1, 'must be {0} {1}'),
(2383, 1, 'To apply this optimization you need to have <b>{0}</b> - {1}'),
(2384, 1, 'please <a href="javascript:void(0);" onclick="oBxDolStudioDashboard.permissions()">click here</a> to find out if permissions are correct.'),
(2385, 1, 'The script can be much faster if you install some PHP accelerator'),
(2386, 1, 'your PHP setup maybe very inefficient, <a href="javascript:void(0)" onclick="bx_sys_adm_audit_phpinfo()">please check it for sure</a> and try to switch to mod_php, apache dso module or FastCGI'),
(2387, 1, '\ncan be checked <a href="#manual_audit">manually</a> or in "Page Speed" tool build-in into browser.<br />\nIf it is not enabled then please consider implement this optimization, since it improve perceived site speed and save the bandwidth.<br />{0}'),
(2388, 1, 'should be {0} {1}'),
(2389, 1, '\n<a href="{0}">click here to check it in Google Page Speed</a><br />\nIf it is not enabled then please consider implement this optimization, since it improve perceived site speed and save the bandwidth.<br />{1}'),
(2390, 1, 'value checking failed'),
(2391, 1, 'your version is incompatible with UNA, must be at least {0}'),
(2392, 1, 'your version is outdated, upgrade to the latest {0} maybe required'),
(2393, 1, 'Files and folders permissions'),
(2394, 1, 'PHP accelerator'),
(2395, 1, 'PHP setup'),
(2396, 1, 'Hardware'),
(2397, 1, 'OS'),
(2398, 1, 'Web-server'),
(2399, 1, 'Server-side content compression'),
(2400, 1, 'FAIL'),
(2401, 1, 'OK'),
(2402, 1, 'UNDEFINED'),
(2403, 1, 'WARNING'),
(2404, 1, 'User-side caching for static content'),
(2405, 1, 'version'),
(2406, 1, 'UNA version'),
(2407, 1, 'custom'),
(2408, 1, 'html'),
(2409, 1, 'image'),
(2410, 1, 'lang'),
(2411, 1, 'creative'),
(2412, 1, 'bento grid'),
(2413, 1, 'menu'),
(2414, 1, 'raw'),
(2415, 1, 'rss'),
(2416, 1, 'wiki'),
(2417, 1, 'service'),
(2418, 1, 'Custom'),
(2419, 1, 'Skeletons'),
(2420, 1, 'System'),
(2421, 1, 'Comments'),
(2422, 1, 'Active'),
(2423, 1, 'Module'),
(2424, 1, 'Text'),
(2425, 1, 'Added'),
(2426, 1, 'Author'),
(2427, 1, 'Delete'),
(2428, 1, 'Display'),
(2429, 1, 'From'),
(2430, 1, 'To'),
(2431, 1, 'Accounts: Growth'),
(2432, 1, 'Accounts: Growth Speed'),
(2433, 1, 'Close'),
(2434, 1, 'Confirm'),
(2435, 1, 'Confirmed'),
(2436, 1, 'Connection already exists'),
(2437, 1, 'Connection doesn''t exist'),
(2438, 1, 'Connection request is awaiting confirmation'),
(2439, 1, 'Input data isn''t defined'),
(2440, 1, 'Operation has beed successfully completed'),
(2441, 1, 'Configuration info'),
(2442, 1, 'Sorry but join is unavailable now. Please try again later.'),
(2443, 1, 'Can''t define your profile information'),
(2444, 1, 'State parameter isn''t matching'),
(2445, 1, 'General'),
(2446, 1, 'Redirect page after first sign in'),
(2447, 1, 'Module to create profile in'),
(2448, 1, 'Always confirm emails when joined using this module'),
(2449, 1, 'Always approve profiles when joined using this module'),
(2450, 1, 'Default privacy for created profiles'),
(2451, 1, '{0} {1}'),
(2452, 1, 'Decline'),
(2453, 1, 'Content'),
(2454, 1, 'Content + Title + Background'),
(2455, 1, 'Content + Padding'),
(2456, 1, 'Content + Title + Background + Padding'),
(2457, 1, 'Content + Background + Padding'),
(2458, 1, 'Content + Title + Padding'),
(2459, 1, 'Empty box'),
(2460, 1, 'Content + Background'),
(2461, 1, 'Content + Title'),
(2462, 1, 'Done'),
(2463, 1, 'About us'),
(2464, 1, '{email_header}\n<p>Message from <a href="{site_url}">{site_name}</a> admin:</p>\n<p> </p>\n<p>{MessageText}</p>\n<p> </p>\n{email_footer}'),
(2465, 1, '{email_header}\n<p>User {sender_display_name} posted reply to your comment: </p>\n<p> </p>\n<p>{reply_text}</p>\n<p> </p>\n<p>View and reply here: <a href="{page_url}">{page_title}</a>.</p>\n<p> </p>\n{email_footer}'),
(2466, 1, '{email_header}\n<p>New <b>{report_type}</b> report received:</p>\n<p> </p>\n<p>{report_text}</p>\n<p> </p>\n<p><a href="{report_url}">View report</a>.</p>\n<p> </p>\n{email_footer}'),
(2467, 1, '{email_header}\n<p>Hello {name} ({email}),</p>\n<p>Please confirm your email address by clicking the link below:</p>\n<p> </p>\n<p><a href="{conf_link}">{conf_link}</a></p>\n<p> </p>\n<p>or use the code:</p>\n<p><span class="h3">{conf_code}</span></p>\n<p> </p>\n{email_footer}'),
(2468, 1, '{email_header}\n<p>Module: <b>{Module}</b></p>\n<p>Uninstallation result: {Result}</p>\n<p> </p>\n<p>{Message}</p>\n<p> </p>\n{email_footer}'),
(2469, 1, '{email_header}\n<p>Hello {name} ({email})</p>,\n<p>Click the link below to reset your password, please:</p>\n<p> </p>\n<p><a href="{forgot_password_url}">Reset my password</a>.</p>\n<p> </p>\n{email_footer}'),
(2470, 1, '{email_header}\n<p><b>{profile_name}</b> profile membership level is now <b>{membership_level}</b>.</p>\n<p> </p>\n{email_footer}'),
(2471, 1, '{email_header}\n<p><b>{profile_name}</b> profile membership level (<b>{membership_level}</b>) was prolonged.</p>\n<p> </p>\n{email_footer}'),
(2472, 1, '{email_header}\n<p>Your {membership_name} membership will expire in {expire_days} days (-1 means already expired).</p>\n<p>Click the link below to renew your membership:</p>\n<p> </p>\n<p><a href="{page_url}">Renew my membership</a></p>\n<p> </p>\n{email_footer}'),
(2473, 1, '{email_header}\n<p>Your {site_name} account details:</p>\n<p> </p>\n<p>Name: {account_name}</p>\n<p>Email: {account_email}</p>\n<p>URL: <a href="{site_url}">{site_url}</a></p>\n<p></p>\n{email_footer}'),
(2474, 1, '{email_header}\n<p>Your profile is pending review. We will send you the review result shortly.</p>\n<p> </p>\n{email_footer}'),
(2475, 1, '{email_header}\n<p>Your profile is currently suspended.</p>\n<p> </p>\n{email_footer}'),
(2476, 1, '{email_header}\n<p>Your account and all your related profiles are currently activated.</p>\n<p></p>\n{email_footer}'),
(2477, 1, '{email_header}\n<p>Your account and all your related profiles are currently suspended.</p>\n<p> </p>\n{email_footer}'),
(2478, 1, '{email_header}\n<p>{account_output}</p>\n{email_footer}'),
(2479, 1, '{email_header}\n<p>Your password will expire {expired_date}</p>\n<p>Please, sign-in and change password</p>\n{email_footer}'),
(2480, 1, '{email_header}\n<p>{pruning_output}</p>\n{email_footer}'),
(2481, 1, '{email_header}\n<p>Upgrade failed due to the following error:</p>\n<p> </p>\n<p>{error_msg}</p>\n<p> </p>\n{email_footer}'),
(2482, 1, '{email_header}\n<p>The following errors appeared during modules upgrade:</p>\n<p> </p>\n<p>{conclusion}</p>\n<p> </p>\n{email_footer}'),
(2483, 1, '{email_header}\n<p>Site was successfully upgraded to {new_version}.</p>\n<p>Please go to <b>Studio &gt; App Store &gt; Updates</b> to check for modules updates.</p>\n<p> </p>\n{conclusion}\n<p> </p>\n{email_footer}'),
(2484, 1, '{email_header}\n<p>The following modules were successfully upgraded.</p>\n<p> </p>\n{conclusion}\n<p> </p>\n{email_footer}'),
(2485, 1, '{email_header}\n<p>Background operation failed with the following message.</p>\n<p> </p>\n{conclusion}\n<p> </p>\n{email_footer}'),
(2486, 1, '{email_header}\n<p>Moderation team has a question for you about ''{content_title}'':</p>\n<p> </p>\n<p>{notes}</p>\n<p> </p>\n{email_footer}'),
(2487, 1, '<b>{0}</b> module: up to {1} version.<br />'),
(2488, 1, '<b>{0}</b> module: {1}<br />'),
(2489, 1, 'Message sending from the Admin Panel'),
(2490, 1, 'The letter is sent to members whose comment was replied'),
(2491, 1, 'New report notification'),
(2492, 1, 'Profile e-mail confirmation message'),
(2493, 1, 'Delayed module uninstall notification'),
(2494, 1, 'Reset password message'),
(2495, 1, 'The letter is sent to members whose membership level was changed'),
(2496, 1, 'The letter is sent to members whose membership level was prolonged'),
(2497, 1, 'Membership expiration letter sent to members whose membership level expires'),
(2498, 1, 'Profile status changed to active'),
(2499, 1, 'Profile status changed to pending'),
(2500, 1, 'Profile status changed to suspended'),
(2501, 1, 'Account status changed to active'),
(2502, 1, 'Account status changed to suspended'),
(2503, 1, 'Approve: Contact content''s author'),
(2504, 1, 'New Accounts'),
(2505, 1, 'Password will expire'),
(2506, 1, 'Pruning result'),
(2507, 1, 'Upgrade failed'),
(2508, 1, 'Modules upgrade failed'),
(2509, 1, 'Site upgrade success'),
(2510, 1, 'Modules upgrade success'),
(2511, 1, 'Background operation failed'),
(2512, 1, 'Message from <SiteName> Admin: <MessageSubject>'),
(2513, 1, 'User {sender_display_name} replied to your comment.'),
(2514, 1, 'New report notification'),
(2515, 1, 'Confirm your email address'),
(2516, 1, 'Delayed {Module} module uninstall: {Result}'),
(2517, 1, 'Reset your password'),
(2518, 1, 'Your membership level was changed'),
(2519, 1, 'Your membership level was prolonged'),
(2520, 1, 'Your membership is about to expire'),
(2521, 1, 'Profile activated'),
(2522, 1, 'Profile pending review'),
(2523, 1, 'Profile suspended'),
(2524, 1, 'Account activated'),
(2525, 1, 'Account suspended'),
(2526, 1, 'Approvement. A question about ''{content_title}''.'),
(2527, 1, '{site_name} {account_count} accounts created yesterday'),
(2528, 1, 'Your password will expire soon'),
(2529, 1, '{site_name} pruning result'),
(2530, 1, '{site_name} upgrade failed'),
(2531, 1, 'Modules upgrade failed on {site_name}'),
(2532, 1, '{site_name} upgrade success'),
(2533, 1, 'Modules upgrade success on {site_name}'),
(2534, 1, 'Background operation failed'),
(2535, 1, 'Unsubscribe'),
(2536, 1, 'Microsoft Office Viewer'),
(2537, 1, 'Google Viewer'),
(2538, 1, 'Images Viewer'),
(2539, 1, 'Code Viewer'),
(2540, 1, 'Sounds Player'),
(2541, 1, 'Videos Player'),
(2542, 1, 'Account'),
(2543, 1, ''),
(2544, 1, 'By signing up, you agree to the <a href="{0}">Terms of Service</a> and <a href="{1}">Privacy Policy</a>.'),
(2545, 1, 'Security Image'),
(2546, 1, 'Security image input failed. Please, try again.'),
(2547, 1, 'Type the text:'),
(2548, 1, 'Type the text you hear:'),
(2549, 1, 'refresh'),
(2550, 1, 'Get another CAPTCHA'),
(2551, 1, 'audio'),
(2552, 1, 'Get an audio CAPTCHA'),
(2553, 1, 'image'),
(2554, 1, 'Get an image CAPTCHA'),
(2555, 1, 'help'),
(2556, 1, 'Get Help'),
(2557, 1, 'I''m sure that I want to delete the account and data.'),
(2558, 1, 'I''m sure that I want to delete the account.'),
(2559, 1, 'Please check this checkbox if you really want to delete account.'),
(2560, 1, 'This action can not be undone.'),
(2561, 1, 'Email'),
(2562, 1, 'Email is not valid'),
(2563, 1, 'This email address is already registered. Please, use <a href="{0}">Forgot password</a> to restore access to your account.'),
(2564, 1, 'This email is already used by someone.'),
(2565, 1, 'This phone number is already used by someone.'),
(2566, 1, 'Account name'),
(2567, 1, 'Account name is mandatory and and cannot start with @'),
(2568, 1, 'Create a password'),
(2569, 1, 'Confirm a password'),
(2570, 1, 'Password confirmation failed'),
(2571, 1, 'Current Password'),
(2572, 1, 'This password has already been used before, use a different one'),
(2573, 1, 'Current password isn''t correct, please enter password you are using to login to this site.'),
(2574, 1, 'The password must at least 8 characters long and contain at least 1 uppercase letter, 1 lowercase letter and 1 digit.'),
(2575, 1, 'Receive Newsletters'),
(2576, 1, 'Receive Site Updates'),
(2577, 1, 'Submit'),
(2578, 1, 'Create'),
(2579, 1, 'Agents: Message'),
(2580, 1, 'Agents: Message Send'),
(2581, 1, 'Action'),
(2582, 1, 'Image'),
(2583, 1, 'Parent ID'),
(2584, 1, 'Send'),
(2585, 1, 'Send'),
(2586, 1, 'Text'),
(2587, 1, 'Object ID'),
(2588, 1, 'Object Type'),
(2589, 1, 'No'),
(2590, 1, 'Yes'),
(2591, 1, 'Author'),
(2592, 1, 'Comment'),
(2593, 1, 'Author'),
(2594, 1, 'Text'),
(2595, 1, 'Action'),
(2596, 1, 'Author'),
(2597, 1, 'Cancel'),
(2598, 1, 'Comment ID'),
(2599, 1, 'Image'),
(2600, 1, 'Parent ID'),
(2601, 1, 'Post'),
(2602, 1, 'Text'),
(2603, 1, 'Object ID'),
(2604, 1, 'Object Type'),
(2605, 1, 'Cancel'),
(2606, 1, 'Post'),
(2607, 1, 'Email Confirmation'),
(2608, 1, 'Verification Code'),
(2609, 1, 'Submit'),
(2610, 1, 'Verification Code'),
(2611, 1, 'Verification code is invalid or expired, please login to your account and resend verification email.'),
(2612, 1, 'Submit'),
(2613, 1, 'Phone Confirmation'),
(2614, 1, 'Phone'),
(2615, 1, 'Phone'),
(2616, 1, 'Enter your phone with country code'),
(2617, 1, 'Wrong phone number, allowed digits only and start from ''+'''),
(2618, 1, 'This phone is already used by someone.'),
(2619, 1, 'Code'),
(2620, 1, 'Code'),
(2621, 1, 'Submit'),
(2622, 1, 'Submit'),
(2623, 1, 'Send SMS'),
(2624, 1, 'Send SMS'),
(2625, 1, 'Cannot be empty.'),
(2626, 1, 'Wrong verification code. Please, repeat code or <a href="{0}">change the phone number and repeat from the beginning</a>.'),
(2627, 1, 'Phone is not valid'),
(2628, 1, 'Create Account'),
(2629, 1, 'Delete Account'),
(2630, 1, 'Email Settings'),
(2631, 1, 'Edit Account'),
(2632, 1, 'Change Password'),
(2633, 1, 'Comment Edit Form'),
(2634, 1, 'Comment Post Form'),
(2635, 1, 'Email Confirmation'),
(2636, 1, 'Set phone'),
(2637, 1, 'Phone confirmation'),
(2638, 1, 'Forgot Password'),
(2639, 1, 'Reset Password'),
(2640, 1, 'Log in'),
(2641, 1, 'Log in - step 2'),
(2642, 1, 'Log in - step 3'),
(2643, 1, 'Report From Post'),
(2644, 1, 'Unsubscribe From Newsletters'),
(2645, 1, 'Unsubscribe From Updates'),
(2646, 1, 'Forgot Password'),
(2647, 1, 'This email doesn''t belong to any account. Please make sure that it is typed correctly.'),
(2648, 1, 'This phone doesn''t belong to any account. Please make sure that it is typed correctly.'),
(2649, 1, 'Wrong phone number, allowed digits only and start from ''+'''),
(2650, 1, 'Please, fill phone or email field'),
(2651, 1, 'Submit'),
(2652, 1, 'Email'),
(2653, 1, 'Key'),
(2654, 1, 'Password'),
(2655, 1, 'Password'),
(2656, 1, 'Password'),
(2657, 1, 'Type your new password'),
(2658, 1, 'Email'),
(2659, 1, 'Phone'),
(2660, 1, 'Phone'),
(2661, 1, 'Submit'),
(2662, 1, 'Age'),
(2663, 1, 'Location'),
(2664, 1, 'Location'),
(2665, 1, 'Radius (in km)'),
(2666, 1, 'Add new item'),
(2667, 1, 'Delete item'),
(2668, 1, 'Post as anonymous'),
(2669, 1, 'Post as anonymous'),
(2670, 1, 'Labels'),
(2671, 1, 'Labels'),
(2672, 1, 'Add Label'),
(2673, 1, 'Show password'),
(2674, 1, 'Hide password'),
(2675, 1, 'Labels'),
(2676, 1, 'Select labels display'),
(2677, 1, 'Name'),
(2678, 1, 'Action'),
(2679, 1, 'Search'),
(2680, 1, 'Search'),
(2681, 1, 'List'),
(2682, 1, 'or select from general labels'),
(2683, 1, 'List from contexts'),
(2684, 1, 'from contexts'' labels'),
(2685, 1, 'Submit'),
(2686, 1, 'Submit'),
(2687, 1, 'Cancel'),
(2688, 1, 'Cancel'),
(2689, 1, 'Log in'),
(2690, 1, 'Agreement'),
(2691, 1, 'Captcha'),
(2692, 1, 'Submit'),
(2693, 1, 'Code from SMS'),
(2694, 1, 'Resend SMS code'),
(2695, 1, 'Confirm Delete'),
(2696, 1, 'Delete with Content'),
(2697, 1, 'Submit'),
(2698, 1, 'Sign up'),
(2699, 1, 'Email'),
(2700, 1, 'ID'),
(2701, 1, 'Account name'),
(2702, 1, 'Password'),
(2703, 1, 'Confirm Password'),
(2704, 1, 'Phone'),
(2705, 1, 'Current Password'),
(2706, 1, 'Receive News'),
(2707, 1, 'Receive Updates'),
(2708, 1, 'Relocate'),
(2709, 1, 'Remember me'),
(2710, 1, 'Role'),
(2711, 1, 'Send SMS'),
(2712, 1, 'Submit'),
(2713, 1, 'Submit Text'),
(2714, 1, 'By logging in, you agree to the <a href="{0}">Terms of Service</a> and <a href="{1}">Privacy Policy</a>.'),
(2715, 1, 'Code from SMS'),
(2716, 1, 'You didn''t receive an SMS? <a href="{0}">Send SMS again</a>.'),
(2717, 1, 'Submit'),
(2718, 1, 'Email'),
(2719, 1, 'Password'),
(2720, 1, 'Phone'),
(2721, 1, 'Enter your phone with country code'),
(2722, 1, 'Remember me'),
(2723, 1, 'Send SMS'),
(2724, 1, 'Log in'),
(2725, 1, 'Cannot be empty.'),
(2726, 1, 'Wrong phone number, allowed digits only and start from ''+'''),
(2727, 1, 'This phone is already used by someone.'),
(2728, 1, 'Wrong verification code. Please, repeat code or <a href="{0}">change the phone number and repeat from the beginning</a>.'),
(2729, 1, 'Manage form'),
(2730, 1, 'Manage form: Approve'),
(2731, 1, 'Content ID'),
(2732, 1, 'Notes'),
(2733, 1, 'Notes'),
(2734, 1, 'Send'),
(2735, 1, 'Send'),
(2736, 1, 'Submit'),
(2737, 1, 'Submit'),
(2738, 1, 'Approve'),
(2739, 1, 'Cancel'),
(2740, 1, 'Cancel'),
(2741, 1, 'ACL form'),
(2742, 1, 'ACL form: Set'),
(2743, 1, 'Set Membership'),
(2744, 1, 'Level'),
(2745, 1, 'Level'),
(2746, 1, 'Duration'),
(2747, 1, 'Duration'),
(2748, 1, 'In days. Leave empty for lifetime'),
(2749, 1, 'Submit'),
(2750, 1, 'Submit'),
(2751, 1, 'Cancel'),
(2752, 1, 'Cancel'),
(2753, 1, 'Content Filter'),
(2754, 1, 'Select audience'),
(2755, 1, 'Type name here...'),
(2756, 1, 'Profile'),
(2757, 1, 'Configure Content Filter'),
(2758, 1, 'Manage Content Filter'),
(2759, 1, 'Content Filter Value'),
(2760, 1, 'Show me a content marked with'),
(2761, 1, 'Content Filter Items'),
(2762, 1, 'Available content filter categories'),
(2763, 1, 'Lock Content Filter'),
(2764, 1, 'Lock content filter categories'),
(2765, 1, 'Submit'),
(2766, 1, 'Submit'),
(2767, 1, 'Cancel'),
(2768, 1, 'Cancel'),
(2769, 1, 'Content Filter was successfully updated'),
(2770, 1, 'Content Filter was successfully updated'),
(2771, 1, 'Manage Content Filter'),
(2772, 1, 'Privacy: Custom group'),
(2773, 1, 'Privacy: Profiles based custom group display'),
(2774, 1, 'Privacy: Memberships based custom group display'),
(2775, 1, 'Profile ID'),
(2776, 1, 'Content ID'),
(2777, 1, 'Object'),
(2778, 1, 'Action'),
(2779, 1, 'Group ID'),
(2780, 1, 'Search'),
(2781, 1, 'Search'),
(2782, 1, 'List'),
(2783, 1, 'or select'),
(2784, 1, 'Memberships List'),
(2785, 1, 'Select'),
(2786, 1, 'Submit'),
(2787, 1, 'Submit'),
(2788, 1, 'Cancel'),
(2789, 1, 'Cancel'),
(2790, 1, 'Favorite'),
(2791, 1, 'Add to favorite list'),
(2792, 1, 'Edit favorite list'),
(2793, 1, 'Object Type'),
(2794, 1, 'List Id'),
(2795, 1, 'Object ID'),
(2796, 1, 'Action'),
(2797, 1, 'System ID'),
(2798, 1, 'Add to list'),
(2799, 1, 'Add to list'),
(2800, 1, 'Title'),
(2801, 1, 'Title'),
(2802, 1, 'Visibility'),
(2803, 1, 'Visibility'),
(2804, 1, 'Save'),
(2805, 1, 'Submit'),
(2806, 1, '<i class="sys-icon folder-plus"></i>'),
(2807, 1, 'Number of videos'),
(2808, 1, 'Created'),
(2809, 1, 'Updated'),
(2810, 1, 'Visibility'),
(2811, 1, 'Default'),
(2812, 1, 'Report'),
(2813, 1, 'Post'),
(2814, 1, 'Report Text'),
(2815, 1, 'Report Type'),
(2816, 1, 'Action'),
(2817, 1, 'Object ID'),
(2818, 1, 'Report ID'),
(2819, 1, 'Post Report'),
(2820, 1, 'Report Text'),
(2821, 1, 'Report Type'),
(2822, 1, 'Object Type'),
(2823, 1, 'Review'),
(2824, 1, 'Review Edit Form'),
(2825, 1, 'Review Post Form'),
(2826, 1, 'Author'),
(2827, 1, 'Text'),
(2828, 1, 'Action'),
(2829, 1, 'Author'),
(2830, 1, 'ID'),
(2831, 1, 'Image'),
(2832, 1, 'Parent ID'),
(2833, 1, 'Post'),
(2834, 1, 'Text'),
(2835, 1, 'Rating'),
(2836, 1, 'Object ID'),
(2837, 1, 'Object Type'),
(2838, 1, 'Post'),
(2839, 1, 'Unsubscribe'),
(2840, 1, 'Security Code'),
(2841, 1, 'Submit'),
(2842, 1, 'Account ID'),
(2843, 1, 'Receive Newsletters'),
(2844, 1, 'Receive Site Updates'),
(2845, 1, 'Receive Newsletters'),
(2846, 1, 'Receive Site Updates'),
(2847, 1, 'Submit'),
(2848, 1, 'The field should have unique value'),
(2849, 1, 'Select a file'),
(2850, 1, 'Wiki'),
(2851, 1, 'Wiki Edit'),
(2852, 1, 'Wiki Translate'),
(2853, 1, 'Block ID'),
(2854, 1, 'Language'),
(2855, 1, '★ - main(original) language, red - outdated or missing translation'),
(2856, 1, 'Please select value'),
(2857, 1, 'Content'),
(2858, 1, 'Markdown syntax and macros are supported.'),
(2859, 1, 'Main(original) Content'),
(2860, 1, 'Notes'),
(2861, 1, 'Submit'),
(2862, 1, 'Close'),
(2863, 1, 'Images'),
(2864, 1, 'Buttons'),
(2865, 1, '{0} bytes'),
(2866, 1, '{0} GB'),
(2867, 1, '{0} KB'),
(2868, 1, '{0} MB'),
(2869, 1, '{0} TB'),
(2870, 1, 'Are you sure?'),
(2871, 1, 'Delete failed'),
(2872, 1, 'Search...'),
(2873, 1, 'Сount: {0}'),
(2874, 1, 'Redirect to manage account.'),
(2875, 1, '{0}{1}<br />Example: {2}'),
(2876, 1, 'Admin user e-mail address.'),
(2877, 1, 'Admin user password here.'),
(2878, 1, 'Admin user name here.'),
(2879, 1, 'Your MySQL database host name here.'),
(2880, 1, 'Your MySQL database name here.'),
(2881, 1, 'Leave blank or specify custom MySQL database host port number.'),
(2882, 1, 'Your MySQL database password here.'),
(2883, 1, 'Leave blank or specify MySQL database socket path.'),
(2884, 1, 'Your MySQL database user name with read/write access.'),
(2885, 1, 'MySQL database engine, some DB engines may require custom MYSQL configuration.'),
(2886, 1, 'Language to install by default.'),
(2887, 1, 'Profiles module to install by default.'),
(2888, 1, '<a target="_blank" href="http://www.una.io/page/kands-manage">Get UNA Key & Secret</a>'),
(2889, 1, 'If ''{0}'' binary doesn''t exist, you need to install <a target="_blank" href="http://www.imagemagick.org/">ImageMagick</a>.'),
(2890, 1, 'Path to directory where UNA files are stored.'),
(2891, 1, 'Email to send site messages from.'),
(2892, 1, 'The name of your site.'),
(2893, 1, 'Your site URL here (slash at the end is required).'),
(2894, 1, 'Template to install by default.'),
(2895, 1, 'Please, input valid data here.'),
(2896, 1, 'Admin e-mail'),
(2897, 1, 'Admin password'),
(2898, 1, 'Admin user name'),
(2899, 1, 'Database host name'),
(2900, 1, 'Database name'),
(2901, 1, 'Database host port number'),
(2902, 1, 'Database password'),
(2903, 1, 'Database socket path'),
(2904, 1, 'Database user'),
(2905, 1, 'Database engine'),
(2906, 1, 'Language'),
(2907, 1, 'Profiles'),
(2908, 1, 'UNA key'),
(2909, 1, 'UNA secret'),
(2910, 1, 'Path to ''{0}'' binary'),
(2911, 1, 'Site directory'),
(2912, 1, 'Site e-mail'),
(2913, 1, 'Site title'),
(2914, 1, 'Site URL'),
(2915, 1, 'Template'),
(2916, 1, '<span style="color:green">Found</span>'),
(2917, 1, 'no example'),
(2918, 1, '<span style="color:red">Not found</span>'),
(2919, 1, 'DB config'),
(2920, 1, 'Link with UNA market'),
(2921, 1, 'Modules'),
(2922, 1, 'Site paths'),
(2923, 1, 'Site info'),
(2924, 1, 'Continue'),
(2925, 1, 'Installation has been successfully completed'),
(2926, 1, 'Help with cron jobs'),
(2927, 1, 'Setting permissions help'),
(2928, 1, 'Creating database help'),
(2929, 1, 'Your hosting doesn''t meet minimal requirements:'),
(2930, 1, 'Your hosting setup has some warnings, for the complete report go to <a href="?action=audit">server audit page</a>.'),
(2931, 1, 'Admin account wasn''t found by email - {0}'),
(2932, 1, 'Database connect failed'),
(2933, 1, 'Database select failed'),
(2934, 1, 'File read failed: {0}'),
(2935, 1, 'File write failed: {0}'),
(2936, 1, 'But some additional manual steps are required:'),
(2937, 1, 'Setup the following cron jobs command:'),
(2938, 1, 'Remove <b>/install/</b> folder from the script root folder.'),
(2939, 1, '<a href="{0}studio/">Go to Studio</a> to add additional modules and customize the site.'),
(2940, 1, 'Please fix form errors.'),
(2941, 1, '{0} - {1}'),
(2942, 1, 'Some files or folders rights aren''t correct, please set necessary permissions then click "Continue".');
INSERT INTO `sys_localization_strings` VALUES
(2943, 1, 'Please, remove INSTALL directory from your server and reload this page to activate your site.<br />After deletion you can safely go <a href="../studio/">to the site Studio</a> to add additional modules and customize the site.'),
(2944, 1, 'Script isn''t installed'),
(2945, 1, 'Refresh'),
(2946, 1, 'Server audit'),
(2947, 1, 'Site configuration'),
(2948, 1, 'Start installation'),
(2949, 1, 'UNA {0} Installation'),
(2950, 1, '1 column'),
(2951, 1, '1 column (thin)'),
(2952, 1, '1 column (half)'),
(2953, 1, '1 column (wiki)'),
(2954, 1, '2 columns'),
(2955, 1, '3 columns'),
(2956, 1, 'With left bar'),
(2957, 1, 'With left and right bars'),
(2958, 1, 'With right bar'),
(2959, 1, 'Bottom area with 2 columns at top'),
(2960, 1, 'Top area with 2 columns'),
(2961, 1, 'Top area with 3 columns'),
(2962, 1, 'Top area with left bar'),
(2963, 1, 'Top area with left and right bars'),
(2964, 1, 'Top area with right bar'),
(2965, 1, 'Top&bottom areas with 2 columns in the middle'),
(2966, 1, 'Top&bottom areas with left bar in the middle'),
(2967, 1, 'Top&bottom areas with right bar in the middle'),
(2968, 1, 'Top&bottom areas with 3 columns (1:3:2) in the middle'),
(2969, 1, 'Top&bottom areas with 2 columns (1:5) in the middle'),
(2970, 1, 'Top&bottom areas with 3 columns (2:5:3) in the middle'),
(2971, 1, 'Loading...'),
(2972, 1, '<i class="sys-icon location-arrow"></i> {0}'),
(2973, 1, '<i class="sys-icon location-arrow"></i> {2}, {1}, {0}'),
(2974, 1, '<i class="sys-icon location-arrow"></i> {4} {3}, {2}, {1}, {0} '),
(2975, 1, 'Determining location...'),
(2976, 1, 'Geolocation is not supported by this browser'),
(2977, 1, 'Location undefined'),
(2978, 1, 'Google Maps (Static)'),
(2979, 1, 'Leaflet (various free map providers)'),
(2980, 1, 'Google autocomplete for addresses'),
(2981, 1, 'Plain address fields with Nominatim OSM geocoding'),
(2982, 1, 'Show location'),
(2983, 1, 'Number'),
(2984, 1, 'Street'),
(2985, 1, 'City / District'),
(2986, 1, 'State / Province'),
(2987, 1, 'Postal Code'),
(2988, 1, 'Address is undefined'),
(2989, 1, 'Address found'),
(2990, 1, 'Address not found'),
(2991, 1, 'System: debug'),
(2992, 1, 'System: SMS'),
(2993, 1, 'System: PUSH'),
(2994, 1, 'System: Payments'),
(2995, 1, 'System: Cron jobs'),
(2996, 1, 'System: Transcoder'),
(2997, 1, 'Error: malformed macros'),
(2998, 1, 'Error: unsafe macros'),
(2999, 1, 'Error: output isn''t displayable'),
(3000, 1, 'Error: no such macros'),
(3001, 1, 'Error: required arguments are missing'),
(3002, 1, 'Error: too many arguments'),
(3003, 1, 'Approve'),
(3004, 1, 'The content was approved.'),
(3005, 1, 'Message was sent.'),
(3006, 1, 'Cannot perform the action. Please report.'),
(3007, 1, 'About'),
(3008, 1, 'Copyright'),
(3009, 1, 'Privacy'),
(3010, 1, 'Search'),
(3011, 1, 'Language'),
(3012, 1, '{1} {0}'),
(3013, 1, 'Design'),
(3014, 1, '{0}'),
(3015, 1, 'Terms'),
(3016, 1, '{member_display_name}'),
(3017, 1, 'Profiles'),
(3018, 1, 'Dashboard'),
(3019, 1, 'Administration'),
(3020, 1, 'Settings'),
(3021, 1, 'Delete'),
(3022, 1, 'Email'),
(3023, 1, 'Account'),
(3024, 1, 'Password'),
(3025, 1, 'Content Filter'),
(3026, 1, 'Add...'),
(3027, 1, 'Shopping Cart'),
(3028, 1, 'Comments'),
(3029, 1, 'Audit'),
(3030, 1, 'Delete'),
(3031, 1, 'Edit'),
(3032, 1, 'Pin'),
(3033, 1, 'Unpin'),
(3034, 1, 'Quote'),
(3035, 1, ''),
(3036, 1, 'Reply'),
(3037, 1, ''),
(3038, 1, ''),
(3039, 1, ''),
(3040, 1, 'Connections'),
(3041, 1, 'Dash'),
(3042, 1, 'Home'),
(3043, 1, 'Invoices'),
(3044, 1, 'Sign out'),
(3045, 1, 'More'),
(3046, 1, ''),
(3047, 1, 'Orders'),
(3048, 1, 'Profile'),
(3049, 1, 'Set membership'),
(3050, 1, 'Set badges'),
(3051, 1, 'Studio'),
(3052, 1, 'Subscriptions'),
(3053, 1, 'Share in Facebook'),
(3054, 1, 'Share in Twitter'),
(3055, 1, 'Share in Pinterest'),
(3056, 1, 'Share in LinkedIn'),
(3057, 1, 'Share in LinkedIn'),
(3058, 1, 'Share in Whatsapp'),
(3059, 1, 'Share in Whatsapp'),
(3060, 1, 'In reply to'),
(3061, 1, 'Author'),
(3062, 1, 'Date'),
(3063, 1, 'Category'),
(3064, 1, 'Tags'),
(3065, 1, 'Views'),
(3066, 1, 'Votes'),
(3067, 1, 'Votes (for/against)'),
(3068, 1, 'Rating'),
(3069, 1, 'Comments'),
(3070, 1, 'Actions'),
(3071, 1, 'Add friend'),
(3072, 1, 'Add friend (requested)'),
(3073, 1, 'Accept friend request'),
(3074, 1, 'Remove friend'),
(3075, 1, 'Cancel friend request'),
(3076, 1, 'Reject friend request'),
(3077, 1, 'Pay & Join'),
(3078, 1, 'Join'),
(3079, 1, 'Accept join request'),
(3080, 1, 'Leave'),
(3081, 1, 'Cancel join request'),
(3082, 1, 'Reject join request'),
(3083, 1, 'New line'),
(3084, 1, 'Follow'),
(3085, 1, 'Unfollow'),
(3086, 1, '{0} friends'),
(3087, 1, '{0} mutual friends'),
(3088, 1, '{0} members'),
(3089, 1, 'Membership'),
(3090, 1, '{0} followers'),
(3091, 1, '{0} relations'),
(3092, 1, 'Country'),
(3093, 1, 'Country and City'),
(3094, 1, 'Remove'),
(3095, 1, 'Membership'),
(3096, 1, 'Badges'),
(3097, 1, 'About'),
(3098, 1, 'Copyright'),
(3099, 1, 'Privacy'),
(3100, 1, 'Language'),
(3101, 1, 'Template'),
(3102, 1, 'Terms'),
(3103, 1, 'Account'),
(3104, 1, 'Profiles'),
(3105, 1, 'Dashboard'),
(3106, 1, 'Administration'),
(3107, 1, 'Content'),
(3108, 1, 'Content'),
(3109, 1, 'Reports'),
(3110, 1, 'Reports'),
(3111, 1, 'Audit'),
(3112, 1, 'Audit'),
(3113, 1, 'Active Profile'),
(3114, 1, 'Notifications Menu'),
(3115, 1, 'Profile Switcher'),
(3116, 1, 'Create Profile'),
(3117, 1, 'Settings'),
(3118, 1, 'Delete'),
(3119, 1, 'Email'),
(3120, 1, 'Account'),
(3121, 1, 'Password'),
(3122, 1, 'Content Filter'),
(3123, 1, 'Add Content'),
(3124, 1, 'Apps'),
(3125, 1, 'Shopping Cart'),
(3126, 1, 'Comments'),
(3127, 1, 'Audit'),
(3128, 1, 'Delete'),
(3129, 1, 'Edit'),
(3130, 1, 'Pin'),
(3131, 1, 'Unpin'),
(3132, 1, 'Quote'),
(3133, 1, 'Reaction'),
(3134, 1, 'Reply'),
(3135, 1, 'Report'),
(3136, 1, 'Score'),
(3137, 1, 'Plus'),
(3138, 1, 'More'),
(3139, 1, 'Connections'),
(3140, 1, 'Dashboard'),
(3141, 1, 'Home'),
(3142, 1, 'Invoices'),
(3143, 1, 'Log in'),
(3144, 1, 'Log out'),
(3145, 1, 'Main Menu'),
(3146, 1, 'Member Avatar'),
(3147, 1, 'Member Following'),
(3148, 1, 'Member Menu'),
(3149, 1, 'More'),
(3150, 1, 'More'),
(3151, 1, 'Orders'),
(3152, 1, 'Powered By'),
(3153, 1, 'Profile'),
(3154, 1, 'Public Menu'),
(3155, 1, 'Search'),
(3156, 1, 'Set membership'),
(3157, 1, 'Set badges'),
(3158, 1, 'Studio'),
(3159, 1, 'Subscriptions'),
(3160, 1, 'View Actions'),
(3161, 1, 'View Actions'),
(3162, 1, 'Approve'),
(3163, 1, 'Comment'),
(3164, 1, 'View'),
(3165, 1, 'Vote (for)'),
(3166, 1, 'Vote (for/against)'),
(3167, 1, 'Favorite'),
(3168, 1, 'Feature'),
(3169, 1, 'Reaction'),
(3170, 1, 'Repost'),
(3171, 1, 'Repost with Text'),
(3172, 1, 'Repost to Context'),
(3173, 1, 'Report'),
(3174, 1, 'Notes'),
(3175, 1, 'Audit'),
(3176, 1, 'More'),
(3177, 1, 'Approve'),
(3178, 1, 'Notes'),
(3179, 1, 'Audit'),
(3180, 1, 'More'),
(3181, 1, ''),
(3182, 1, 'Share'),
(3183, 1, 'Share'),
(3184, 1, 'Share in Facebook'),
(3185, 1, 'Share in Twitter'),
(3186, 1, 'Share in Pinterest'),
(3187, 1, 'In reply to'),
(3188, 1, 'Author'),
(3189, 1, 'Date'),
(3190, 1, 'Category'),
(3191, 1, 'Tags'),
(3192, 1, 'Views'),
(3193, 1, 'Votes'),
(3194, 1, 'Votes (for/against)'),
(3195, 1, 'Rating'),
(3196, 1, 'Comments'),
(3197, 1, 'Actions'),
(3198, 1, 'Add Friend'),
(3199, 1, 'Remove Friend'),
(3200, 1, 'Pay & Join'),
(3201, 1, 'Join'),
(3202, 1, 'Leave'),
(3203, 1, 'New Line'),
(3204, 1, 'Follow'),
(3205, 1, 'Unfollow'),
(3206, 1, 'Friends'),
(3207, 1, 'Mutual Friends'),
(3208, 1, 'Members'),
(3209, 1, 'Membership'),
(3210, 1, 'Followers'),
(3211, 1, 'Relations'),
(3212, 1, 'Country'),
(3213, 1, 'Country and City'),
(3214, 1, 'Ignore Recommendation'),
(3215, 1, 'Ignore Recommendation: Befriend'),
(3216, 1, 'Ignore Recommendation: Subscribe'),
(3217, 1, 'Membership'),
(3218, 1, 'Badges'),
(3219, 1, 'Account Dashboard'),
(3220, 1, 'Account Dashboard Manage Tools'),
(3221, 1, 'Account Settings'),
(3222, 1, 'Account Popup'),
(3223, 1, 'Account Notifications'),
(3224, 1, 'Add Content'),
(3225, 1, 'Content Manage'),
(3226, 1, 'Reports Manage'),
(3227, 1, 'Add Profile'),
(3228, 1, 'Comment Actions'),
(3229, 1, 'Comment Сounters'),
(3230, 1, 'Manage Comment'),
(3231, 1, 'Comment Meta Info'),
(3232, 1, 'Switch Language'),
(3233, 1, 'Switch Template'),
(3234, 1, 'Social Sharing'),
(3235, 1, 'Footer'),
(3236, 1, 'Create Profile Links'),
(3237, 1, 'Followed Contexts'),
(3238, 1, 'Profile Stats'),
(3239, 1, 'Site'),
(3240, 1, 'Application'),
(3241, 1, 'Panel'),
(3242, 1, 'Content modules'),
(3243, 1, 'Toolbar Member'),
(3244, 1, 'Toolbar Site'),
(3245, 1, 'Snippet Meta Info'),
(3246, 1, 'Add Content Menu'),
(3247, 1, 'Horizontal Block Submenu'),
(3248, 1, 'Vertical Block Submenu'),
(3249, 1, 'Horizontal Buttons'),
(3250, 1, 'Horizontal Buttons (icons only)'),
(3251, 1, 'Vertical Buttons'),
(3252, 1, 'Floating Blocks'),
(3253, 1, 'Wide Floating Blocks with Notifications'),
(3254, 1, 'Floating Blocks Big'),
(3255, 1, 'Floating Blocks with icons & captions'),
(3256, 1, 'Footer Links'),
(3257, 1, 'Horizontal Links'),
(3258, 1, 'Inline'),
(3259, 1, 'Inline (''special'' buttons)'),
(3260, 1, 'Interactive Horizontal Links'),
(3261, 1, 'Interactive Vertical Links'),
(3262, 1, 'Empty Menu'),
(3263, 1, 'Site Navigation Menu'),
(3264, 1, 'Site Navigation Submenu'),
(3265, 1, 'Site Navigation Submenu (with Auto More)'),
(3266, 1, 'Site Panel Menu'),
(3267, 1, 'Site Navigation Menu in Panel'),
(3268, 1, 'Multilevel Menu'),
(3269, 1, 'Toolbar Buttons'),
(3270, 1, 'Vertical Links'),
(3271, 1, 'Vertical Links (lite)'),
(3272, 1, 'Account notifications'),
(3273, 1, 'Account popup'),
(3274, 1, 'Horizontal menu with custom items'),
(3275, 1, 'Vertical menu with custom items'),
(3276, 1, 'Profile Following Menu'),
(3277, 1, 'Vertical menu with more/less'),
(3278, 1, 'Profile Stats Menu'),
(3279, 1, 'Account Dashboard Menu'),
(3280, 1, 'Account Dashboard Manage Tools Menu'),
(3281, 1, 'Account Notifications'),
(3282, 1, 'Account Popup'),
(3283, 1, 'Account Settings Menu'),
(3284, 1, 'Add Content Menu'),
(3285, 1, 'Add Profile Menu'),
(3286, 1, 'Add Profile Menu (vertical)'),
(3287, 1, 'Comment Actions'),
(3288, 1, 'Comment Counters'),
(3289, 1, 'Manage Comment'),
(3290, 1, 'Comment Meta Info'),
(3291, 1, 'Footer Links'),
(3292, 1, 'Site Navigation'),
(3293, 1, 'Site Navigation in Panel'),
(3294, 1, 'Application Navigation'),
(3295, 1, 'Homepage Menu'),
(3296, 1, 'Homepage Submenu'),
(3297, 1, 'Homepage Submenu'),
(3298, 1, 'Explore'),
(3299, 1, 'Explore'),
(3300, 1, 'Updates'),
(3301, 1, 'Updates'),
(3302, 1, 'Trends'),
(3303, 1, 'Trends'),
(3304, 1, 'Create Profiles'),
(3305, 1, 'Profile Following'),
(3306, 1, 'Profile Stats'),
(3307, 1, 'Tags Cloud'),
(3308, 1, 'RSS'),
(3309, 1, 'ACL Levels'),
(3310, 1, 'Badges'),
(3311, 1, 'Social Sharing'),
(3312, 1, 'Create Post Menu'),
(3313, 1, 'Dashboard content manage'),
(3314, 1, 'Dashboard reports manage'),
(3315, 1, 'Add Relationship Menu'),
(3316, 1, 'Site Panel'),
(3317, 1, 'Site Submenu'),
(3318, 1, 'Member Toolbar'),
(3319, 1, 'Site Toolbar'),
(3320, 1, 'Language Switcher (popup)'),
(3321, 1, 'Language Switch (inline)'),
(3322, 1, 'Switch Template'),
(3323, 1, 'Snippet Meta Info'),
(3324, 1, 'Do Reaction Vote'),
(3325, 1, 'Wiki'),
(3326, 1, 'Wiki'),
(3327, 1, 'Edit'),
(3328, 1, 'Delete Version'),
(3329, 1, 'Delete Block'),
(3330, 1, 'Translate'),
(3331, 1, 'History'),
(3332, 1, 'Favorite list'),
(3333, 1, 'Favorite list'),
(3334, 1, 'Edit'),
(3335, 1, 'Delete'),
(3336, 1, 'hidden'),
(3337, 1, 'unapproved'),
(3338, 1, 'reported'),
(3339, 1, 'Account Popup (Studio)'),
(3340, 1, 'Account Popup (Studio)'),
(3341, 1, 'Account'),
(3342, 1, '{member_display_name}'),
(3343, 1, 'Go To Site'),
(3344, 1, 'Go To Site'),
(3345, 1, 'Manage Apps'),
(3346, 1, 'Manage Apps'),
(3347, 1, 'Language'),
(3348, 1, 'Language'),
(3349, 1, 'System'),
(3350, 1, 'Light Mode'),
(3351, 1, 'Dark Mode'),
(3352, 1, 'Sign out'),
(3353, 1, 'Sign out'),
(3354, 1, 'Inherited'),
(3355, 1, 'Disabled'),
(3356, 1, 'Connections'),
(3357, 1, 'Connections'),
(3358, 1, 'All Friends'),
(3359, 1, 'Friend Requests'),
(3360, 1, 'Sent Friend Requests'),
(3361, 1, 'Following'),
(3362, 1, 'Followers'),
(3363, 1, 'Friend Suggestions'),
(3364, 1, 'Who to follow'),
(3365, 1, '<b class="bx-ntfs-content-profile">{owner_name}</b> mentioned <b class="bx-ntfs-content-entry">{entry_caption}</b>'),
(3366, 1, 'Friends'),
(3367, 1, 'Info'),
(3368, 1, 'Messages'),
(3369, 1, 'Contact'),
(3370, 1, 'Friends'),
(3371, 1, 'Profile Info'),
(3372, 1, 'Search'),
(3373, 1, 'Status'),
(3374, 1, 'Name'),
(3375, 1, 'Added'),
(3376, 1, 'Next'),
(3377, 1, 'Accounts created in the last 24 hours:'),
(3378, 1, 'No menu'),
(3379, 1, 'Asynchronous mode disabled'),
(3380, 1, 'n/a'),
(3381, 1, 'Not Specified'),
(3382, 1, 'on'),
(3383, 1, 'off'),
(3384, 1, 'Pages'),
(3385, 1, 'With loading indicator'),
(3386, 1, 'With text placeholder'),
(3387, 1, 'With image placeholder'),
(3388, 1, 'With create post placeholder'),
(3389, 1, 'With profile units placeholder'),
(3390, 1, 'With text units list placeholder'),
(3391, 1, 'With text units gallery placeholder'),
(3392, 1, 'About'),
(3393, 1, 'Create a profile...'),
(3394, 1, 'Use site as ...'),
(3395, 1, 'Delete Account'),
(3396, 1, 'Email Settings'),
(3397, 1, 'Edit Account'),
(3398, 1, 'Account Settings'),
(3399, 1, 'Change Password'),
(3400, 1, 'Content Filter'),
(3401, 1, 'Add Content'),
(3402, 1, 'Growth Charts'),
(3403, 1, 'Content'),
(3404, 1, 'Manage Comments'),
(3405, 1, 'Audit'),
(3406, 1, 'Email Confirmation'),
(3407, 1, 'Phone Confirmation'),
(3408, 1, 'Sign up'),
(3409, 1, 'Author'),
(3410, 1, 'Author'),
(3411, 1, 'Ask AI'),
(3412, 1, 'Ask AI'),
(3413, 1, 'Recommended Friends'),
(3414, 1, 'Friend Suggestions'),
(3415, 1, 'Recommended Subscriptions'),
(3416, 1, 'Who to follow'),
(3417, 1, 'Create Post'),
(3418, 1, 'Add new...'),
(3419, 1, 'Create Post (Context)'),
(3420, 1, 'Add new...'),
(3421, 1, 'Create Post (Public)'),
(3422, 1, 'Add new...'),
(3423, 1, 'Dashboard'),
(3424, 1, 'Content modules menu'),
(3425, 1, 'Splash'),
(3426, 1, 'Forgot Password'),
(3427, 1, 'Search Form'),
(3428, 1, 'Search Result'),
(3429, 1, 'Membership Limits'),
(3430, 1, 'Log in with Sign up link'),
(3431, 1, 'Log in - step2'),
(3432, 1, 'Log in - step3'),
(3433, 1, 'Log in'),
(3434, 1, 'Dashboard - Content'),
(3435, 1, 'Dashboard - Audit'),
(3436, 1, 'Dashboard - Reports'),
(3437, 1, 'View Comment'),
(3438, 1, 'Comment Author'),
(3439, 1, 'Commented Content'),
(3440, 1, 'Manage Comments'),
(3441, 1, 'Audit'),
(3442, 1, 'Log out'),
(3443, 1, 'Log in'),
(3444, 1, 'Log in - step 2'),
(3445, 1, 'Log in - step 3'),
(3446, 1, 'Manage'),
(3447, 1, 'Privacy Policy'),
(3448, 1, 'Profile stats'),
(3449, 1, 'Profile avatar'),
(3450, 1, 'Profile menu'),
(3451, 1, 'Profile followings'),
(3452, 1, 'Membership'),
(3453, 1, 'Unsubscribe From Site Newsletters'),
(3454, 1, 'Unsubscribe From Site Notifications'),
(3455, 1, 'Version'),
(3456, 1, 'Space Usage'),
(3457, 1, 'Host Tools'),
(3458, 1, 'Cache'),
(3459, 1, 'Queues'),
(3460, 1, 'Terms of Service'),
(3461, 1, 'Site submenu'),
(3462, 1, 'Site submenu'),
(3463, 1, 'Pages List'),
(3464, 1, 'Page Contents'),
(3465, 1, 'This site is powered by UNA. The rest is a mystery.'),
(3466, 1, 'Our terms of use.'),
(3467, 1, 'Our privacy policy.'),
(3468, 1, 'About'),
(3469, 1, 'My Profiles'),
(3470, 1, 'Delete Account'),
(3471, 1, 'Email Settings'),
(3472, 1, 'Edit Account'),
(3473, 1, 'Change Password'),
(3474, 1, 'Content Filter'),
(3475, 1, 'Add Content'),
(3476, 1, 'Manage Comments'),
(3477, 1, 'Audit'),
(3478, 1, 'Email Confirmation'),
(3479, 1, 'Phone Confirmation'),
(3480, 1, 'Sign up'),
(3481, 1, 'Dashboard'),
(3482, 1, 'Forgot Password'),
(3483, 1, 'Choose New Password'),
(3484, 1, '{site_title} :: Homepage'),
(3485, 1, 'Log out'),
(3486, 1, 'Log in'),
(3487, 1, 'Log in - step 2'),
(3488, 1, 'Log in - step 3'),
(3489, 1, 'Privacy Policy'),
(3490, 1, 'Explore'),
(3491, 1, 'Updates'),
(3492, 1, 'Trends'),
(3493, 1, 'Terms of Service'),
(3494, 1, 'About'),
(3495, 1, 'My Profiles'),
(3496, 1, 'Delete Account'),
(3497, 1, 'Email Settings'),
(3498, 1, 'Edit Account'),
(3499, 1, 'Change Password'),
(3500, 1, 'Content Filter'),
(3501, 1, 'Add Content'),
(3502, 1, 'View Comment'),
(3503, 1, 'Manage Comments'),
(3504, 1, 'Audit'),
(3505, 1, 'Email Confirmation'),
(3506, 1, 'Phone Confirmation'),
(3507, 1, 'Sign up'),
(3508, 1, 'Dashboard'),
(3509, 1, 'Dashboard - Content'),
(3510, 1, 'Content'),
(3511, 1, 'Dashboard - Reports'),
(3512, 1, 'Reports'),
(3513, 1, 'Dashboard - Audit'),
(3514, 1, 'Audit'),
(3515, 1, 'Forgot Password'),
(3516, 1, 'Search by Keyword'),
(3517, 1, 'Search by Keyword'),
(3518, 1, 'Homepage'),
(3519, 1, 'Log in'),
(3520, 1, 'Log in - step 2'),
(3521, 1, 'Log in - step 3'),
(3522, 1, 'Privacy Policy'),
(3523, 1, 'Explore'),
(3524, 1, 'Updates'),
(3525, 1, 'Trends'),
(3526, 1, 'Terms of Service'),
(3527, 1, 'Unsubscribe From Newsletters'),
(3528, 1, 'Unsubscribe From Notifications'),
(3529, 1, 'Studio Dashboard'),
(3530, 1, 'Unsubscribe From Site Newsletters'),
(3531, 1, 'Unsubscribe From Site Notifications'),
(3532, 1, 'Studio Dashboard'),
(3533, 1, 'Subpage: Pages List'),
(3534, 1, 'Subpage: Page Contents'),
(3535, 1, 'Connections: Friends'),
(3536, 1, 'Friends'),
(3537, 1, 'Friends'),
(3538, 1, 'Connections: Friend Requests'),
(3539, 1, 'Friend Requests'),
(3540, 1, 'Friend Requests'),
(3541, 1, 'Connections: Sent Friend Requests'),
(3542, 1, 'Sent Friend Requests'),
(3543, 1, 'Sent Friend Requests'),
(3544, 1, 'Connections: Following'),
(3545, 1, 'Following'),
(3546, 1, 'Following'),
(3547, 1, 'Connections: Followers'),
(3548, 1, 'Followers'),
(3549, 1, 'Followers'),
(3550, 1, 'Recommendations: Friends'),
(3551, 1, 'Friend Suggestions'),
(3552, 1, 'Recommendations: Subscriptions'),
(3553, 1, 'Who to follow'),
(3554, 1, 'Application'),
(3555, 1, 'Default'),
(3556, 1, 'Standard'),
(3557, 1, 'Without header/footer'),
(3558, 1, '{0}-{1}'),
(3559, 1, '{0}-{1} of {2}'),
(3560, 1, 'View All'),
(3561, 1, 'There is no installed payment processing module.'),
(3562, 1, 'You need to activate at least one payment provider. You may do it via My Account menu -> Settings page -> <a href="{0}">Payments</a> tab.'),
(3563, 1, 'Please select...'),
(3564, 1, 'Colors'),
(3565, 1, 'Slate'),
(3566, 1, 'Gray'),
(3567, 1, 'Zinc'),
(3568, 1, 'Neutral'),
(3569, 1, 'Stone'),
(3570, 1, 'Red'),
(3571, 1, 'Orange'),
(3572, 1, 'Amber'),
(3573, 1, 'Yellow'),
(3574, 1, 'Lime'),
(3575, 1, 'Green'),
(3576, 1, 'Emerald'),
(3577, 1, 'Teal'),
(3578, 1, 'Cyan'),
(3579, 1, 'Sky'),
(3580, 1, 'Blue'),
(3581, 1, 'Indigo'),
(3582, 1, 'Violet'),
(3583, 1, 'Purple'),
(3584, 1, 'Fuchsia'),
(3585, 1, 'Pink'),
(3586, 1, 'Rose'),
(3587, 1, 'Content filter'),
(3588, 1, 'G'),
(3589, 1, 'PG'),
(3590, 1, 'PG-13'),
(3591, 1, 'R'),
(3592, 1, 'X'),
(3593, 1, 'Relationships'),
(3594, 1, 'husband'),
(3595, 1, 'wife'),
(3596, 1, 'father'),
(3597, 1, 'mother'),
(3598, 1, 'son'),
(3599, 1, 'daughter'),
(3600, 1, 'brother'),
(3601, 1, 'sister'),
(3602, 1, 'Report Types'),
(3603, 1, 'spam'),
(3604, 1, 'scam'),
(3605, 1, 'fraud'),
(3606, 1, 'nude'),
(3607, 1, 'other'),
(3608, 1, 'Reactions'),
(3609, 1, 'React'),
(3610, 1, 'Like'),
(3611, 1, 'Love'),
(3612, 1, 'Haha'),
(3613, 1, 'Wow'),
(3614, 1, 'Sad'),
(3615, 1, 'Angry'),
(3616, 1, 'App Types'),
(3617, 1, 'Apps Library'),
(3618, 1, 'Appearance'),
(3619, 1, 'Structure'),
(3620, 1, 'Content'),
(3621, 1, 'Users'),
(3622, 1, 'Configuration'),
(3623, 1, 'Extensions'),
(3624, 1, 'Integrations'),
(3625, 1, 'Favorites'),
(3626, 1, 'profile'),
(3627, 1, '{0} ({1})'),
(3628, 1, '<b class="bx-ntfs-content-profile">{owner_name}</b> befriended <b class="bx-ntfs-content-entry">{entry_caption}</b>'),
(3629, 1, 'Now <b class="bx-ntfs-content-profile">{owner_name}</b> and <b class="bx-ntfs-content-entry">{entry_caption}</b> are friends'),
(3630, 1, '<b class="bx-ntfs-content-profile">{owner_name}</b> followed <b class="bx-ntfs-content-entry">{entry_caption}</b>'),
(3631, 1, 'Active'),
(3632, 1, 'Pending'),
(3633, 1, 'Suspended'),
(3634, 1, 'Storage'),
(3635, 1, 'Number of files'),
(3636, 1, 'Private'),
(3637, 1, 'Visibility'),
(3638, 1, 'Membership Levels'),
(3639, 1, '<h3>Database pruning:</h3>\n        <ul>\n            <li><b>{0}</b> deleted expired membership levels</li>\n            <li><b>{1}</b> deleted expired sessions</li>\n            <li><b>{2}</b> deleted expired keys</li>\n            <li><b>{3}</b> deleted expired storage tokens</li>\n            <li><b>{4}</b> deleted outdated transcoded images</li>\n            <li><b>{5}</b> deleted/suspended accounts</li>\n            <li><b>{6}</b> deleted view tracks</li>\n            <li><b>{7}</b> deleted vote tracks</li>\n            <li><b>{8}</b> deleted score tracks</li>\n            <li><b>{9}</b> deleted favorite tracks</li>\n            <li><b>{10}</b> deleted report tracks</li>\n        </ul>'),
(3640, 1, '<h3>Files pruning:</h3>\n        <ul>\n            <li><b>{0}</b> total</li>\n            <li><b>{1}</b> deleted</li>\n        </ul>'),
(3641, 1, 'Specific membership levels...'),
(3642, 1, 'Custom'),
(3643, 1, 'Followers'),
(3644, 1, 'Friends'),
(3645, 1, 'Specific friends...'),
(3646, 1, 'Relationships'),
(3647, 1, 'Specific relationships...'),
(3648, 1, 'Only me'),
(3649, 1, 'Members'),
(3650, 1, 'Public'),
(3651, 1, 'Participants'),
(3652, 1, 'Closed'),
(3653, 1, 'Secret'),
(3654, 1, 'Unknown'),
(3655, 1, 'Custom privacy groups aren''t allowed.'),
(3656, 1, 'You are not an owner of the content.'),
(3657, 1, 'You need to select some value'),
(3658, 1, 'friend'),
(3659, 1, 'Would you like to get notifications from {0}?'),
(3660, 1, 'Yes'),
(3661, 1, 'No, thanks'),
(3662, 1, 'Continue reading "{0}"'),
(3663, 1, 'Relationship'),
(3664, 1, 'Module was not found'),
(3665, 1, 'Module({0}) was not found'),
(3666, 1, 'Page was not found'),
(3667, 1, 'Page({0}) was not found in module({1})'),
(3668, 1, 'Method was not found'),
(3669, 1, 'Method({0}) was not found in module({1})'),
(3670, 1, '{0}'),
(3671, 1, 'Vote'),
(3672, 1, '{0} score'),
(3673, 1, 'Up'),
(3674, 1, 'Down'),
(3675, 1, 'Voted by'),
(3676, 1, 'The feature is not available right now. Please, try again later.'),
(3677, 1, 'Duplicate vote'),
(3678, 1, 'Search Home'),
(3679, 1, 'Select'),
(3680, 1, 'Send'),
(3681, 1, 'Search...'),
(3682, 1, 'Search or ask...'),
(3683, 1, 'Show less'),
(3684, 1, 'Show more'),
(3685, 1, 'Your activity triggered automated block'),
(3686, 1, 'Your activity triggered automated block, please contact us to investigate: {0}'),
(3687, 1, 'Start'),
(3688, 1, 'Domain is essential. Please, fill in this field, for example, my-first-site.'),
(3689, 1, 'The domain name is already used. Try to select another one.'),
(3690, 1, 'The service is currently not available. Try it later, please.'),
(3691, 1, 'site address'),
(3692, 1, '.online.me'),
(3693, 1, 'The easiest way to create your own social website.'),
(3694, 1, 'Status'),
(3695, 1, 'awaiting'),
(3696, 1, 'failed'),
(3697, 1, 'pending'),
(3698, 1, 'suspended'),
(3699, 1, 'database error'),
(3700, 1, 'error occurred'),
(3701, 1, 'error occurred'),
(3702, 1, 'file not found'),
(3703, 1, 'file is too big'),
(3704, 1, 'permissions error'),
(3705, 1, 'no file to upload'),
(3706, 1, 'so such input method available'),
(3707, 1, 'quota exceeded'),
(3708, 1, 'permission denied'),
(3709, 1, 'quota exceeded'),
(3710, 1, 'file deletion failed'),
(3711, 1, 'user quota exceeded'),
(3712, 1, 'wrong file extension'),
(3713, 1, 'file(s)'),
(3714, 1, 'file is invalid'),
(3715, 1, 'Wow, files of all types are allowed!'),
(3716, 1, 'Sorry, adding all file types is currently restricted.'),
(3717, 1, 'Please, upload only files of these types: {0}'),
(3718, 1, 'You may upload any types of files except for {0}'),
(3719, 1, 'Maximum file size limit is {0}'),
(3720, 1, 'Switch profile'),
(3721, 1, 'Submit'),
(3722, 1, 'Follow'),
(3723, 1, '{0} ({1})'),
(3724, 1, 'Welcome to UNA Studio!'),
(3725, 1, 'Studio is where you customise your site; add and manage apps; control languages and design; set membership levels and permissions; build pages and navigation, and a lot more. You are now in Studio Launcher.'),
(3726, 1, 'Add and manage Apps'),
(3727, 1, 'Apps are modules, languages, tools, templates - all the bits and pieces that make your site unique. You can download and install Apps and they will appear in Studio Launcher. Apps add and change functionality of your site.'),
(3728, 1, 'Start making your site special'),
(3729, 1, 'Designer is the best place to start customisation. Change the site logo, choose design template and manage the “Cover Page”. Your site now shows Cover Page to all guest visitors. You can either customise it to turn it off to display a full homepage with content of your choice.'),
(3730, 1, 'You are more than Admin'),
(3731, 1, 'UNA content and profiles are controlled by Admins and Moderators right on the site front-end, so you don’t have to worry about that in Studio. You do need to appoint your Admins and Moderators, though. And this is where you do it. If you also want to be the site Admin, just create your profile use “Set Membership” to upgrade it.'),
(3732, 1, 'One look and you know it'),
(3733, 1, 'Dashboard gives a quick overview of the site status. UNA version, space usage, hosting tools and cache.  Different Apps will add their blocks to Dashboard.'),
(3734, 1, 'Build your site the way you want it'),
(3735, 1, 'Pages allow you to edit the site by rearranging, adding and removing blocks on site pages. You can even create new custom pages of different types. You can also control visibility settings, SEO data, cacheing and page layouts.'),
(3736, 1, 'Define who can do what'),
(3737, 1, 'Create and edit Membership Levels and associated Actions permissions.'),
(3738, 1, 'Form and re-form your forms'),
(3739, 1, 'Forms builder is a powerful tool that allows deep customisation of site database and forms. You can create and manage data lists, form fields and even display types (like Add/Edit/Delete). Your Forms will define the structure and theme of the site.'),
(3740, 1, 'Show them around'),
(3741, 1, 'Add and manage site navigation menus. You can edit links, re-order them, add new ones, change icons and control visibility according to membership permissions.'),
(3742, 1, 'Speak their language'),
(3743, 1, '"If you talk to a man in a language he understands, that goes to his head. If you talk to him in his language, that goes to his heart." Polyglot allows you to set site language and data format, edit site texts in all installed languages and even translate email templates.'),
(3744, 1, 'Move the Apps around'),
(3745, 1, 'Activate reorganisation mode to rearrange Apps in Launcher or delete inactive ones altogether.'),
(3746, 1, 'Choose wisely'),
(3747, 1, 'Your Studio may have hundreds of installed Apps. Choose the ones you access most often and use the Star to bring them up.'),
(3748, 1, 'Now DO add new Apps!'),
(3749, 1, 'UNA comes with only a handful of core Apps. Choose, download and install Apps to add profiles types, modules, system tools, plugins, languages and design templates. You can activate and deactivate installed Apps. UNA is super-modular and incredibly flexible, letting you choose your own combination of functionality, settings and database structure to make the social site of your dreams real. Even without changing anything you will have the perfectly functioning social site!'),
(3750, 1, 'This is the Homepage'),
(3751, 1, 'At first there isn''t much here. Install more Apps via Studio, add more blocks via Studio > Pages > Homepage, create profiles, appoint admins, post some content and your site will come alive!'),
(3752, 1, 'Get to know your Account Menu'),
(3753, 1, 'Add and manage profiles, check notifications, access account settings. Admins and Moderators can use it to access Dash with links to site content and profiles management.'),
(3754, 1, 'API Key'),
(3755, 1, 'Access denied'),
(3756, 1, 'Your account is pending approval, please wait until it is activated.'),
(3757, 1, 'This is your profile, you can <a href="{0}">change your current profile</a> to this profile'),
(3758, 1, 'You can <a href="{0}">change your current profile</a> to this profile'),
(3759, 1, 'Current profile has been successfully changed to: <b>{0}</b>'),
(3760, 1, 'Your account is suspended.'),
(3761, 1, 'Your email address is unconfirmed. Please, check your email ({1}) for a confirmation letter and click email confirmation link or use confirmation code (6 digit) to <a href="{2}">confirm your email</a>. Can''t find the letter? Check your SPAM folder or <a href="{0}">send the verification letter again</a>.'),
(3762, 1, 'Your phone is unconfirmed. Please, confirm it on <a href="{0}">verification page</a>.'),
(3763, 1, 'Please <a href="{0}">create a profile</a> to start using the site.'),
(3764, 1, 'Your password has been expired. Please <a href="{0}">change your password</a>.'),
(3765, 1, 'Cannot delete the only Operator account'),
(3766, 1, 'Account deletion was scheduled and would be done in a few minutes.'),
(3767, 1, 'CAPTCHA not available'),
(3768, 1, 'Add'),
(3769, 1, 'Create own category'),
(3770, 1, 'Change Picture'),
(3771, 1, 'Loading...'),
(3772, 1, 'Your email address is already confirmed.'),
(3773, 1, 'Please enter confirmation code which was sent to your email address, or just click confirmation link in the same email message.'),
(3774, 1, 'Error occurred, please try to login to your account and resend verification email.'),
(3775, 1, 'Email verification letter was sent, please check your inbox.'),
(3776, 1, 'Error occurred, please report error to site administrator.'),
(3777, 1, 'You email address was successfully confirmed.'),
(3778, 1, 'Your phone is already confirmed.'),
(3779, 1, 'Error occurred, please try to login to your account and repeat verification.'),
(3780, 1, 'Error occurred, please report error to site administrator.'),
(3781, 1, 'Your phone''s verification code is {0}.'),
(3782, 1, 'Your phone number has been confirmed.'),
(3783, 1, 'Please enter a phone number for sending verification SMS.'),
(3784, 1, 'Please enter verification code from the SMS.'),
(3785, 1, 'Write here, {0}...'),
(3786, 1, 'The maximum allowed number of attached links has been reached.'),
(3787, 1, 'Current Picture'),
(3788, 1, 'Done'),
(3789, 1, 'Delete'),
(3790, 1, 'Discard'),
(3791, 1, 'Empty'),
(3792, 1, 'Account creation failed'),
(3793, 1, 'Account delete failed'),
(3794, 1, 'Account is not defined'),
(3795, 1, 'Account update failed'),
(3796, 1, 'Entry creation error'),
(3797, 1, 'Entry delete failed'),
(3798, 1, 'Requested resource doesn''t exist'),
(3799, 1, 'Entry update failed'),
(3800, 1, 'Error Occurred'),
(3801, 1, 'Profile is not defined'),
(3802, 1, 'Profile update failed'),
(3803, 1, 'Sound file isn''t transcoded yet'),
(3804, 1, '''{0}'' field is unknown'),
(3805, 1, 'Created:'),
(3806, 1, 'Updated:'),
(3807, 1, 'Forgot password?'),
(3808, 1, 'Email was sent, please follow instructions in the email message.'),
(3809, 1, 'SMS was sent, please follow instructions in the SMS.'),
(3810, 1, 'Enter your account email address to get a password-reset link.'),
(3811, 1, 'Enter your account email address or phone to get a password-reset link.'),
(3812, 1, 'Enter your account phone to get a password-reset link.'),
(3813, 1, 'Email send failed, please try again later.'),
(3814, 1, 'Error occurred, please report error to the site administrator.'),
(3815, 1, 'Click the link below to reset your password {0}'),
(3816, 1, 'You are already logged in. If you still wish to reset your password, please log out first and then initiate the password recovery process.'),
(3817, 1, 'Copy URL'),
(3818, 1, 'Delete'),
(3819, 1, 'Insert to Post'),
(3820, 1, 'Attachment URL:'),
(3821, 1, 'Use as Thumbnail'),
(3822, 1, 'Incorrect info. Please, check your inputs and try to submit again.'),
(3823, 1, 'Token expired. Please try again.'),
(3824, 1, 'Unity is strength... when there is teamwork and collaboration, wonderful things can be achieved.<br /><button class="bx-btn bx-hide-when-logged-in bx-def-margin-top" onclick="document.location=''{0}''">Join Now!</button>'),
(3825, 1, 'Two-factor authentication is enabled, please specify the phone number to send verification code to.'),
(3826, 1, 'Your verification code is {0}.'),
(3827, 1, 'An error occurred, please report error to the site administrator.'),
(3828, 1, 'Log in'),
(3829, 1, 'Create New Account'),
(3830, 1, 'Entered email or password is incorrect. Please try again.'),
(3831, 1, 'Your account is locked and needs to be unlocked using <a href="{0}">forgot password page</a>.'),
(3832, 1, 'Following: {0}'),
(3833, 1, 'Followers: {0}'),
(3834, 1, 'Friends: {0}'),
(3835, 1, 'Access denied'),
(3836, 1, 'Create a new profile'),
(3837, 1, 'Switch to'),
(3838, 1, 'New Picture'),
(3839, 1, 'Not found'),
(3840, 1, 'No picture uploaded'),
(3841, 1, 'No title'),
(3842, 1, '{0} by'),
(3843, 1, '{0} friends'),
(3844, 1, '{0} mutual friends'),
(3845, 1, '<a href="{0}">{1}</a> mutual friend'),
(3846, 1, 'Powered by UNA Community Management System'),
(3847, 1, 'New'),
(3848, 1, 'In-process'),
(3849, 1, 'Processed'),
(3850, 1, 'Hided'),
(3851, 1, 'Your password was reset. You are welcome to login to your account.'),
(3852, 1, 'Reset password link was expired or already used. Please <a href="{0}">try again</a>.'),
(3853, 1, 'Account with specified email wasn''t found. Please <a href="{0}">try again</a>.'),
(3854, 1, 'Error occurred, please <a href="{0}">try again</a>.'),
(3855, 1, 'Join Now'),
(3856, 1, 'Connect with people that share your passion.'),
(3857, 1, 'Stories, ideas, photos, videos, questions, jokes, discussions, anything.<br />Follow inspiring people and inspire your followers.'),
(3858, 1, '"Pull up a chair. Take a taste.<br />Come join us. Life is so endlessly<br />delicious."'),
(3859, 1, '"The only way to have a friend is to be one."'),
(3860, 1, 'Already one of us?'),
(3861, 1, 'Connect. Share. Create.'),
(3862, 1, 'Join our community now to connect with like-minded people, share exciting news and create inspiring content.'),
(3863, 1, 'Login'),
(3864, 1, 'Join'),
(3865, 1, 'Connect'),
(3866, 1, 'Find like-minded people, make new friends, follow interesting authors and stay in touch anywhere.'),
(3867, 1, 'Share'),
(3868, 1, 'Bring up the latest news, share interesting articles, exciting websites, cool photos and awesome videos.'),
(3869, 1, 'Create'),
(3870, 1, 'Build your social profile, post status updates, write notes, create polls and upload media albums.'),
(3871, 1, 'Switch'),
(3872, 1, 'Your email preferences have been updated.'),
(3873, 1, 'Error occurred, please login to your account and update email references there or contact site administrator to unsubscribe you manually.'),
(3874, 1, 'Update email preferences for <b>{0}</b>'),
(3875, 1, 'Unsubscribe link is wrong.'),
(3876, 1, 'URL'),
(3877, 1, 'User #{0}'),
(3878, 1, 'Reports'),
(3879, 1, 'View notes'),
(3880, 1, 'Share'),
(3881, 1, 'URL'),
(3882, 1, 'Click for copy to the clipboard'),
(3883, 1, 'Embeded code'),
(3884, 1, 'Sort by'),
(3885, 1, 'Default'),
(3886, 1, 'Unconfirmed'),
(3887, 1, '<h3>Important info:</h3><p>{0}</p>'),
(3888, 1, 'Database and files versions are different, probably previous patch wasn''t applied correctly.'),
(3889, 1, 'Can''t apply upgrade because the following files were modified: {0}'),
(3890, 1, 'Can''t apply upgrade because too many files({0}%) were modified'),
(3891, 1, 'Can''t apply upgrade because too many files({0}%) were modified in {1} module'),
(3892, 1, 'Get version info failed, please check internet connection on the web-server or web-server firewall'),
(3893, 1, 'You have outdated modules. Upgrade them first in Studio &gt; App Store &gt; Updates.'),
(3894, 1, 'Downloaded patch file checksum is invalid'),
(3895, 1, 'Patch download failed, or downloaded file can''t be saved'),
(3896, 1, 'Invalid patch, it can''t be applied to your version or incorrect files structure in the patch.'),
(3897, 1, 'Patch unpack failed'),
(3898, 1, 'Upload File'),
(3899, 1, 'Close'),
(3900, 1, 'Oh no! Are you sure? This may discard uploading files, seriously.'),
(3901, 1, 'Upload is in progress! Stay cool and don''t close this page, or it will cut off half-way.'),
(3902, 1, 'Upload and Crop'),
(3903, 1, 'Rotate Left'),
(3904, 1, 'Rotate Right'),
(3905, 1, 'Upload'),
(3906, 1, 'Crop Image'),
(3907, 1, 'Error Uploading.'),
(3908, 1, 'Wrong file extension, only images with the following extensions are allowed: jpg, jpeg, png, gif.'),
(3909, 1, 'Oops! An error occurred with {0} file: {1}'),
(3910, 1, 'Multiple Upload'),
(3911, 1, 'Drag and Drop files here to upload'),
(3912, 1, 'Select a file'),
(3913, 1, 'Multiple Upload'),
(3914, 1, 'Drop files here to upload or click here to select files'),
(3915, 1, 'File is too big - {{filesize}} MB, max filesize is {{maxFilesize}} MB.'),
(3916, 1, 'You can not upload any more files.'),
(3917, 1, 'You can''t upload files of this type.'),
(3918, 1, '+ Add more files'),
(3919, 1, 'Simple Upload'),
(3920, 1, 'Upload'),
(3921, 1, 'Record'),
(3922, 1, 'Upload'),
(3923, 1, 'Record Video'),
(3924, 1, 'Start Recording'),
(3925, 1, 'Stop Recording'),
(3926, 1, 'Mb'),
(3927, 1, 'Switch camera'),
(3928, 1, 'Too bad. Upload canceled.'),
(3929, 1, 'We were unable to initialize your camera.'),
(3930, 1, 'Your browser doesn''t support video recording. You can try <strong>Google Chrome</strong> or <strong>Mozilla FireFox</strong> instead.'),
(3931, 1, 'Change position'),
(3932, 1, 'Save'),
(3933, 1, 'Cancel'),
(3934, 1, 'Upload new'),
(3935, 1, 'Drag to reposition'),
(3936, 1, 'Edit profile'),
(3937, 1, 'Exit'),
(3938, 1, 'warning'),
(3939, 1, '{0} days'),
(3940, 1, 'to'),
(3941, 1, 'Top'),
(3942, 1, 'unknown'),
(3943, 1, 'undefined'),
(3944, 1, '{0}'),
(3945, 1, 'View'),
(3946, 1, 'Viewed by'),
(3947, 1, '{0} views'),
(3948, 1, '{0} views'),
(3949, 1, '{0}'),
(3950, 1, 'Like'),
(3951, 1, 'Like'),
(3952, 1, 'Liked by'),
(3953, 1, 'Reacted by'),
(3954, 1, '"{0}" by'),
(3955, 1, 'All'),
(3956, 1, 'The feature is not available right now. Please, try again later.'),
(3957, 1, 'Duplicate vote'),
(3958, 1, '{0} votes'),
(3959, 1, 'Friday'),
(3960, 1, 'Monday'),
(3961, 1, 'Saturday'),
(3962, 1, 'Sunday'),
(3963, 1, 'Thursday'),
(3964, 1, 'Tuesday'),
(3965, 1, 'Wednesday'),
(3966, 1, 'Labels'),
(3967, 1, 'Number of items in showcase view'),
(3968, 1, 'Number of items in recommended view'),
(3969, 1, 'This site requires JavaScript! Please, enable it in the browser!'),
(3970, 1, 'System WIKI'),
(3971, 1, 'Page with such name({0}) already exists'),
(3972, 1, 'There is no {0} revision exist for {1} language'),
(3973, 1, 'There are no revisions available for this block'),
(3974, 1, 'Wiki object ({0}) wasn''t found'),
(3975, 1, 'Wiki object ({1}) action ({0}) isn''t allowed'),
(3976, 1, '"{0}" isn''t correct page URI'),
(3977, 1, 'No sucn language'),
(3978, 1, 'Error occured (code:{0})'),
(3979, 1, 'Version <b>{0}</b> by <a href="{1}">{2}</a>, {3}'),
(3980, 1, '{0} {1} <span class="bx-def-font-grayed bx-def-font-small">{2}</span>'),
(3981, 1, '{0} {1} <span class="bx-def-font-small" style="color:red;">{2}</span>'),
(3982, 1, 'missing'),
(3983, 1, '{0} revisions were deleted'),
(3984, 1, 'Are you sure you want to permanently delete this block with all revisions and translations?'),
(3985, 1, 'Block was successfully deleted'),
(3986, 1, 'Add Block'),
(3987, 1, 'Add Page'),
(3988, 1, 'Such wiki page doesn''t exists.'),
(3989, 1, 'No missing translations for {0} language.'),
(3990, 1, 'All translations are up to date for {0} language.'),
(3991, 1, 'Page'),
(3992, 1, 'Missing Lang'),
(3993, 1, 'Outdated Lang'),
(3994, 1, '{0} author'),
(3995, 1, '{0} content'),
(3996, 1, '{0} updated'),
(3997, 1, 'Orig.'),
(3998, 1, 'Copy to clipboard'),
(3999, 1, 'Open in editor'),
(4000, 1, 'NOTE: don''t modify this comment and lines below'),
(4001, 1, 'Roles'),
(4002, 1, 'Create role'),
(4003, 1, 'Role name'),
(4004, 1, 'Role name is required'),
(4005, 1, 'Edit role'),
(4006, 1, 'Manage fans'),
(4007, 1, 'Manage roles'),
(4008, 1, 'Edit'),
(4009, 1, 'Invite'),
(4010, 1, 'Change cover'),
(4011, 1, 'Post'),
(4012, 1, 'Edit any entry'),
(4013, 1, 'Delete any entry'),
(4014, 1, 'Pin entry'),
(4015, 1, 'Add bold text <cmd+b>'),
(4016, 1, 'Add italic text <cmd+i>'),
(4017, 1, 'Add underline text <cmd+u>'),
(4018, 1, 'Clear format'),
(4019, 1, 'Numbered list'),
(4020, 1, 'Bulleted list'),
(4021, 1, 'Decrease indent'),
(4022, 1, 'Increase indent'),
(4023, 1, 'Add blockquote'),
(4024, 1, 'Text direction'),
(4025, 1, 'Subscript'),
(4026, 1, 'Superscript'),
(4027, 1, 'Insert a link'),
(4028, 1, 'Insert an image'),
(4029, 1, 'Add code'),
(4030, 1, 'Select a text color'),
(4031, 1, 'Select a background color'),
(4032, 1, 'Text alignment'),
(4033, 1, 'Select the text style'),
(4034, 1, 'Insert an embed'),
(4035, 1, 'Paste an URL for embed'),
(4036, 1, 'Paste an URL'),
(4037, 1, 'Emails'),
(4038, 1, 'PUSH'),
(4039, 1, 'Video transcoding'),
(4040, 1, 'Files storage'),
(4041, 1, 'Redirect Confirmation'),
(4042, 1, 'Confirm redirect'),
(4043, 1, '<div class="bx-def-font-h2 bx-def-margin-sec-bottom">You''re going to a link outside {1}</div><div class="bx-def-font-small">Link: {0}</div><div class="bx-def-margin-sec-top">Are you sure you want to follow this link?</div>'),
(4044, 1, '<div class="bx-def-font-h2 bx-def-margin-sec-bottom">You''re going to a potentially <b>harmful</b> link {1}</div><div class="bx-def-font-small">Link: {0}</div><div class="bx-def-margin-sec-top">Are you sure you want to follow this link?</div>'),
(4045, 1, '<div class="bx-def-font-h2">Leave the page?</div><div class="bx-def-margin-sec-top">If you do it, your changes will not be saved.</div>'),
(4046, 1, 'English'),
(4047, 1, 'English'),
(4048, 1, 'General'),
(4049, 1, 'English'),
(4050, 1, 'Artificer'),
(4051, 1, 'Artificer'),
(4052, 1, 'General'),
(4053, 1, 'Name in Template Switcher'),
(4054, 1, 'Page Width'),
(4055, 1, 'Stretched Header'),
(4056, 1, 'Enable floating search bar'),
(4057, 1, 'Color Scheme'),
(4058, 1, 'Auto with switcher'),
(4059, 1, 'Light mode only'),
(4060, 1, 'Dark mode only'),
(4061, 1, 'Use HTMX in Top menu and Page submenu (experimental)'),
(4062, 1, 'Custom Styles'),
(4063, 1, 'Custom Styles'),
(4064, 1, 'Custom Images'),
(4065, 1, 'Each line represents an image. Line format: <b>name</b> => <b>value</b> => <b>type</b> => <b>class</b><br />Where <b>type</b> and/or <b>class</b> may be omitted. Available types are <b>ic</b> - icon (Font Awesome), <b>im</b> - image (file name or URL), <b>sc</b> - source code (SVG).<br />Don''t forget to clear template cache (if it''s enabled) to see the changes.'),
(4066, 1, 'Splash'),
(4067, 1, 'Explore'),
(4068, 1, 'Styles'),
(4069, 1, 'Site Sidebar Navigation'),
(4070, 1, 'Site Sidebar Navigation'),
(4071, 1, 'Close sidebar'),
(4072, 1, 'Light'),
(4073, 1, 'Dark'),
(4074, 1, 'System'),
(4075, 1, 'Welcome to'),
(4076, 1, 'the community'),
(4077, 1, 'The best social media network for people to connect, collaborate, share content and inspire each other.'),
(4078, 1, 'Powered by <a class="font-medium underline" href="https://una.io">UNA Community Management System</a>.'),
(4079, 1, 'Create Account'),
(4080, 1, 'Login'),
(4081, 1, 'We rise by helping others'),
(4082, 1, 'Make new friends, follow interesting creators and stay in touch with your community.'),
(4083, 1, 'members'),
(4084, 1, 'posts'),
(4085, 1, 'comments'),
(4086, 1, 'Log in to your account'),
(4087, 1, 'Create New Account'),
(4088, 1, 'By logging in, you agree to our <a href="{0}" class="font-medium text-gray-900 dark:text-white hover:underline">Terms of use</a> and <a href="{1}" class="dark:text-white font-medium text-gray-900 hover:underline">Privacy policy</a>.'),
(4089, 1, 'Artificer'),
(4090, 1, 'Persons'),
(4091, 1, 'Persons'' Comments'),
(4092, 1, 'Activate all persons automatically'),
(4093, 1, 'Default member''s level to assign after person''s profile creation'),
(4094, 1, 'Enable profile activation letter'),
(4095, 1, 'Redirect after person''s profile creation to'),
(4096, 1, 'Profile Page'),
(4097, 1, 'Last Page'),
(4098, 1, 'Custom Page'),
(4099, 1, 'Homepage'),
(4100, 1, 'URL for ''Custom Page'' redirect'),
(4101, 1, 'After creation & after editing'),
(4102, 1, 'After creation only'),
(4103, 1, 'After editing only'),
(4104, 1, 'Manual activation'),
(4105, 1, 'Number of items in friends block'),
(4106, 1, 'Number of items per page'),
(4107, 1, 'Number of items in RSS feed'),
(4108, 1, 'Searchable fields for keyword search'),
(4109, 1, 'Public following list'),
(4110, 1, 'Public followers list'),
(4111, 1, 'Persons'),
(4112, 1, 'Add Person'),
(4113, 1, 'Edit Person'),
(4114, 1, 'Edit Cover'),
(4115, 1, 'Delete Person'),
(4116, 1, 'View Person'),
(4117, 1, 'Full View Person'),
(4118, 1, 'Submit'),
(4119, 1, 'Submit'),
(4120, 1, 'Visible to'),
(4121, 1, 'Visible to'),
(4122, 1, 'Who can post to my profile'),
(4123, 1, 'Who can post to my profile'),
(4124, 1, 'Who can contact me'),
(4125, 1, 'Who can contact me'),
(4126, 1, 'Name'),
(4127, 1, 'Name'),
(4128, 1, 'Last Name'),
(4129, 1, 'Last Name'),
(4130, 1, 'Profile name is mandatory and and cannot start with @'),
(4131, 1, 'Description'),
(4132, 1, 'Description'),
(4133, 1, 'Profile Picture'),
(4134, 1, 'Upload a profile picture'),
(4135, 1, 'Profile picture is mandatory.'),
(4136, 1, 'With photo'),
(4137, 1, 'Online only'),
(4138, 1, 'Cover Picture'),
(4139, 1, 'Upload New Cover Picture'),
(4140, 1, 'Delete confirmation'),
(4141, 1, 'I am sure I want to delete this profile'),
(4142, 1, 'This action can not be undone.'),
(4143, 1, 'Please check this checkbox if you really want to delete your profile.'),
(4144, 1, 'Birthday'),
(4145, 1, 'Age between 18 and 99'),
(4146, 1, 'Birthday'),
(4147, 1, 'Gender'),
(4148, 1, 'Gender'),
(4149, 1, 'Email'),
(4150, 1, 'Email'),
(4151, 1, 'Status'),
(4152, 1, 'Status'),
(4153, 1, 'IP'),
(4154, 1, 'IP'),
(4155, 1, 'Last account activity'),
(4156, 1, 'Last account activity'),
(4157, 1, 'Skills'),
(4158, 1, 'Skills'),
(4159, 1, 'Added'),
(4160, 1, 'Added'),
(4161, 1, 'Updated'),
(4162, 1, 'Updated'),
(4163, 1, 'Friends count'),
(4164, 1, 'Friends count'),
(4165, 1, 'Followers count'),
(4166, 1, 'Followers count'),
(4167, 1, 'Skills'),
(4168, 1, 'Add Skill'),
(4169, 1, 'View Skill'),
(4170, 1, 'Name'),
(4171, 1, 'Name'),
(4172, 1, 'This information is essential. Please, fill in this field.'),
(4173, 1, 'Create Person''s Profile'),
(4174, 1, 'Delete Person''s Profile'),
(4175, 1, 'View Person''s Profile'),
(4176, 1, 'Edit Any Person''s Profile'),
(4177, 1, 'Delete Any Person''s Profile'),
(4178, 1, 'Create a Profile - Person'),
(4179, 1, 'Create a Profile - Person'),
(4180, 1, 'Edit Profile'),
(4181, 1, 'Edit Profile'),
(4182, 1, 'Edit Cover'),
(4183, 1, 'Edit Cover'),
(4184, 1, 'Delete Profile'),
(4185, 1, 'Delete Profile'),
(4186, 1, 'View Profile'),
(4187, 1, 'View Profile with Limited Visibility'),
(4188, 1, '{display_name}'),
(4189, 1, 'People'),
(4190, 1, 'Featured People'),
(4191, 1, 'Active People'),
(4192, 1, 'Online People'),
(4193, 1, 'New People'),
(4194, 1, '{0} connections'),
(4195, 1, '{0} and {1} mutual connections'),
(4196, 1, 'People You May Know'),
(4197, 1, '{0} favorites'),
(4198, 1, '{0} People'),
(4199, 1, 'People''s Comments'),
(4200, 1, 'Favorite persons'),
(4201, 1, 'Favorite persons'),
(4202, 1, 'Friends'),
(4203, 1, 'Friends'),
(4204, 1, 'Friend Requests'),
(4205, 1, 'Friend Requests'),
(4206, 1, 'Following'),
(4207, 1, 'Following & Followers'),
(4208, 1, 'Relationships'),
(4209, 1, 'Relationships'),
(4210, 1, 'Comments'),
(4211, 1, 'Comments'),
(4212, 1, 'Profile Info'),
(4213, 1, 'Info about {display_name}'),
(4214, 1, 'New People'),
(4215, 1, 'New People'),
(4216, 1, 'Manage Own People'),
(4217, 1, 'Manage All People'),
(4218, 1, 'Manage People'),
(4219, 1, 'Active People'),
(4220, 1, 'Active People'),
(4221, 1, 'Online People'),
(4222, 1, 'Online People'),
(4223, 1, 'Search'),
(4224, 1, 'Search'),
(4225, 1, 'Private Profile'),
(4226, 1, 'Choose Profile Type'),
(4227, 1, 'Create a Profile - Person'),
(4228, 1, 'Edit Profile'),
(4229, 1, 'Edit Cover'),
(4230, 1, 'Delete Profile'),
(4231, 1, 'All Actions'),
(4232, 1, 'About <a href="{profile_link}">{display_name}</a>'),
(4233, 1, 'Info'),
(4234, 1, 'Info'),
(4235, 1, 'Membership'),
(4236, 1, 'Membership'),
(4237, 1, 'Description'),
(4238, 1, 'Favorite persons'),
(4239, 1, 'Favorite persons'),
(4240, 1, 'Friends of <a href="{profile_link}">{display_name}</a>'),
(4241, 1, 'Friends'),
(4242, 1, 'Mutual Friends'),
(4243, 1, 'Friends'),
(4244, 1, 'Friend Requests for <a href="{profile_link}">{display_name}</a>'),
(4245, 1, 'Friend Requests'),
(4246, 1, 'Location'),
(4247, 1, 'Following'),
(4248, 1, 'Following'),
(4249, 1, 'Followers'),
(4250, 1, 'Followers'),
(4251, 1, 'Relationships'),
(4252, 1, 'Relationships'),
(4253, 1, 'Relationships with Me'),
(4254, 1, 'Relationships with Me'),
(4255, 1, 'Comments'),
(4256, 1, 'Reports'),
(4257, 1, 'Comments to <a href="{entry_link}">{title}</a>'),
(4258, 1, 'Featured People'),
(4259, 1, 'Actions'),
(4260, 1, 'Calendar'),
(4261, 1, 'New People'),
(4262, 1, 'Manage Own People'),
(4263, 1, 'Manage All People'),
(4264, 1, 'Manage People'),
(4265, 1, 'Active People'),
(4266, 1, 'Active People'),
(4267, 1, 'Online People'),
(4268, 1, 'Familiar People'),
(4269, 1, 'People You May Know'),
(4270, 1, 'Search Form'),
(4271, 1, 'Search Results'),
(4272, 1, 'Comments Search Form'),
(4273, 1, 'Comments Search Results'),
(4274, 1, 'Featured People (Showcase View)'),
(4275, 1, 'Featured People'),
(4276, 1, 'Recommended People (Showcase View)'),
(4277, 1, 'Recommended People'),
(4278, 1, 'Active People (Showcase View)'),
(4279, 1, 'Active People'),
(4280, 1, 'Cover'),
(4281, 1, 'Cover'),
(4282, 1, 'Persons Submenu'),
(4283, 1, 'Persons Submenu'),
(4284, 1, 'Person Actions'),
(4285, 1, 'Person Actions'),
(4286, 1, 'Person More Actions'),
(4287, 1, 'Person More Actions'),
(4288, 1, 'Person Meta'),
(4289, 1, 'Person Meta'),
(4290, 1, 'View Person Submenu'),
(4291, 1, 'View Person Submenu'),
(4292, 1, 'Manage Tools Submenu'),
(4293, 1, 'Manage Tools Submenu'),
(4294, 1, 'Delete with Data'),
(4295, 1, 'Delete with Data'),
(4296, 1, 'Clear reports'),
(4297, 1, 'Clear reports'),
(4298, 1, 'Manage audience'),
(4299, 1, 'Manage audience'),
(4300, 1, 'Edit Cover'),
(4301, 1, 'Edit Cover'),
(4302, 1, 'Edit Person'),
(4303, 1, 'Edit Profile'),
(4304, 1, 'Delete Profile and Data'),
(4305, 1, 'Delete Profile and Data'),
(4306, 1, 'Delete Account'),
(4307, 1, 'Delete Account'),
(4308, 1, 'Delete Account and Data'),
(4309, 1, 'Delete Account and Data'),
(4310, 1, 'Person'),
(4311, 1, 'Person'),
(4312, 1, 'Person'),
(4313, 1, 'Person'),
(4314, 1, 'Friends'),
(4315, 1, 'Friends'),
(4316, 1, 'Relationships'),
(4317, 1, 'Relationships'),
(4318, 1, 'Following'),
(4319, 1, 'Following'),
(4320, 1, 'Comments'),
(4321, 1, 'Comments'),
(4322, 1, 'Info'),
(4323, 1, 'Info'),
(4324, 1, 'Profile'),
(4325, 1, 'Profile'),
(4326, 1, 'More'),
(4327, 1, 'More'),
(4328, 1, 'Add friend'),
(4329, 1, 'Add friend'),
(4330, 1, 'Add friend (requested)'),
(4331, 1, 'Accept friend request'),
(4332, 1, 'Unfriend'),
(4333, 1, 'Unfriend'),
(4334, 1, 'Cancel friend request'),
(4335, 1, 'Reject friend request'),
(4336, 1, 'Follow'),
(4337, 1, 'Follow'),
(4338, 1, 'Unfollow'),
(4339, 1, 'Unfollow'),
(4340, 1, 'Add Relationship'),
(4341, 1, 'Add Relationship'),
(4342, 1, 'Remove Relationship'),
(4343, 1, 'Remove Relationship'),
(4344, 1, 'More Actions'),
(4345, 1, ''),
(4346, 1, 'Friends'),
(4347, 1, 'Friends'),
(4348, 1, 'Relationships'),
(4349, 1, 'Relationships'),
(4350, 1, 'Friend requests number'),
(4351, 1, 'Friend requests'),
(4352, 1, 'My profiles'),
(4353, 1, 'Profiles'),
(4354, 1, 'Favorite Persons'),
(4355, 1, 'Favorite persons'),
(4356, 1, 'Following'),
(4357, 1, 'Following'),
(4358, 1, 'Followers'),
(4359, 1, 'Followers'),
(4360, 1, 'Relationships with Me'),
(4361, 1, 'Relationships with Me'),
(4362, 1, 'Persons'),
(4363, 1, 'Persons'),
(4364, 1, 'New'),
(4365, 1, 'New'),
(4366, 1, 'Search'),
(4367, 1, 'Search'),
(4368, 1, 'Manage'),
(4369, 1, 'Manage'),
(4370, 1, 'Persons'),
(4371, 1, 'People'),
(4372, 1, 'Profiles'),
(4373, 1, 'Profiles'),
(4374, 1, 'My Profiles'),
(4375, 1, 'All Profiles'),
(4376, 1, 'Active'),
(4377, 1, 'Active'),
(4378, 1, 'Online'),
(4379, 1, 'Online'),
(4380, 1, 'All Statuses'),
(4381, 1, 'All'),
(4382, 1, 'Active'),
(4383, 1, 'Pending'),
(4384, 1, 'Suspended'),
(4385, 1, 'Unconfirmed'),
(4386, 1, 'Active'),
(4387, 1, 'Name'),
(4388, 1, 'Last Logged'),
(4389, 1, 'Account'),
(4390, 1, 'Delete With Content'),
(4391, 1, 'Clear reports'),
(4392, 1, 'Set Membership'),
(4393, 1, 'More Actions'),
(4394, 1, 'Audit actions with profile');
INSERT INTO `sys_localization_strings` VALUES
(4395, 1, 'Audit profile actions'),
(4396, 1, 'Manage audience'),
(4397, 1, 'Cannot delete the selected person(s).'),
(4398, 1, 'Redirect to manage account.'),
(4399, 1, 'Persons: Growth'),
(4400, 1, 'Persons: Growth Speed'),
(4401, 1, 'Persons Search'),
(4402, 1, 'Persons Comments Search'),
(4403, 1, 'cover changed'),
(4404, 1, 'picture changed'),
(4405, 1, 'This profile is pending approval, please wait until it is activated.'),
(4406, 1, 'This <a href="{0}">profile</a> is pending approval.'),
(4407, 1, 'This profile is suspended.'),
(4408, 1, 'This <a href="{0}">profile</a> is suspended.'),
(4409, 1, '{0} friends'),
(4410, 1, 'New post <b class="bx-ntfs-content-entry">{subentry_sample}</b> in <b class="bx-ntfs-content-profile">{owner_name}</b> profile timeline'),
(4411, 1, 'person'),
(4412, 1, 'comment to person'),
(4413, 1, 'vote to person'),
(4414, 1, 'score up vote to person'),
(4415, 1, 'score down vote to person'),
(4416, 1, 'profile picture'),
(4417, 1, 'a profile picture'),
(4418, 1, 'profile cover'),
(4419, 1, 'a profile cover'),
(4420, 1, 'changed {0}'),
(4421, 1, '{0} changed {1}'),
(4422, 1, 'Friend request'),
(4423, 1, 'Friendship Request'),
(4424, 1, '{email_header}\n<p><a href="{SenderUrl}">{SenderDisplayName}</a> wants to be friends with you. <a href="{FriendsLink}">Respond</a>.</p>\n{email_footer}'),
(4425, 1, 'Persons'),
(4426, 1, 'Gender'),
(4427, 1, ''),
(4428, 1, 'Birthday'),
(4429, 1, ''),
(4430, 1, 'Name'),
(4431, 1, ''),
(4432, 1, 'Description'),
(4433, 1, ''),
(4434, 1, 'Location'),
(4435, 1, ''),
(4436, 1, 'Online only'),
(4437, 1, ''),
(4438, 1, 'With photo'),
(4439, 1, ''),
(4440, 1, 'Author'),
(4441, 1, ''),
(4442, 1, 'Text'),
(4443, 1, ''),
(4444, 1, 'Select audience'),
(4445, 1, '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_menu_items`
--

CREATE TABLE `sys_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `set_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_system` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `onclick` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `addon` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `addon_cache` tinyint(4) NOT NULL DEFAULT '0',
  `markers` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `submenu_object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `submenu_popup` tinyint(4) NOT NULL DEFAULT '0',
  `visible_for_levels` int(11) NOT NULL DEFAULT '2147483647',
  `visibility_custom` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `hidden_on` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hidden_on_cxt` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hidden_on_pt` int(11) NOT NULL DEFAULT '0',
  `hidden_on_col` int(11) NOT NULL DEFAULT '0',
  `config_api` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `primary` tinyint(4) NOT NULL DEFAULT '0',
  `collapsed` tinyint(4) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `active_api` tinyint(4) NOT NULL DEFAULT '0',
  `copyable` tinyint(4) NOT NULL DEFAULT '1',
  `editable` tinyint(4) NOT NULL DEFAULT '1',
  `order` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=185 ;

--
-- Dumping data for table `sys_menu_items`
--

INSERT INTO `sys_menu_items` VALUES
(1, 0, 'sys_site', 'system', 'home', '_sys_menu_item_title_system_home', '_sys_menu_item_title_home', '', '', '', 'home col-gray', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 1),
(2, 0, 'sys_site', 'system', 'about', '_sys_menu_item_title_system_about', '_sys_menu_item_title_about', 'page.php?i=about', '', '', 'info-circle col-blue3-dark', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 2),
(3, 0, 'sys_site', 'system', 'search', '_sys_menu_item_title_system_search', '_sys_menu_item_title_search', 'javascript:void(0);', 'bx_menu_slide_inline(''#bx-sliding-menu-search'', this, ''site'');', '', 'search', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 3),
(4, 0, 'sys_site', 'system', 'more-auto', '_sys_menu_item_title_system_more_auto', '_sys_menu_item_title_more_auto', 'javascript:void(0)', '', '', 'ellipsis-v', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 9999),
(5, 0, 'sys_site_panel', 'system', 'member-avatar', '_sys_menu_item_title_system_member_avatar', '', '', '', '', '', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 1),
(6, 0, 'sys_site_panel', 'system', 'public-menu', '_sys_menu_item_title_system_public_menu', '', '', '', '', '', '', 0, '', 'sys_site_in_panel', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 2),
(7, 0, 'sys_site_panel', 'system', 'member-menu', '_sys_menu_item_title_system_member_menu', '', '', '', '', '', '', 0, '', 'sys_profile_stats', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 3),
(8, 0, 'sys_site_panel', 'system', 'member-followings', '_sys_menu_item_title_system_member_followings', '', '', '', '', '', '', 0, '', 'sys_profile_followings', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 4),
(9, 0, 'sys_application', 'system', 'home', '_sys_menu_item_title_system_home', '_sys_menu_item_title_home', '', '', '', 'home col-gray-dark', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 1),
(10, 0, 'sys_application', 'system', 'about', '_sys_menu_item_title_system_about', '_sys_menu_item_title_about', 'page.php?i=about', '', '', 'info-circle col-blue3-dark', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 2),
(11, 0, 'sys_application', 'system', 'more-auto', '_sys_menu_item_title_system_more_auto', '_sys_menu_item_title_more_auto', 'javascript:void(0)', '', '', 'ellipsis-v', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 9999),
(12, 0, 'sys_homepage_submenu', 'system', 'home', '_sys_menu_item_title_system_home', '_sys_menu_item_title_home', '', '', '', 'bolt', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 1, 1, 1),
(13, 0, 'sys_homepage_submenu', 'system', 'explore', '_sys_menu_item_title_system_explore', '_sys_menu_item_title_explore', 'page.php?i=explore', '', '', 'compass ', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 1, 1, 2),
(14, 0, 'sys_homepage_submenu', 'system', 'updates', '_sys_menu_item_title_system_updates', '_sys_menu_item_title_updates', 'page.php?i=updates', '', '', 'fire', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 1, 1, 3),
(15, 0, 'sys_homepage_submenu', 'system', 'trends', '_sys_menu_item_title_system_trends', '_sys_menu_item_title_trends', 'page.php?i=trends', '', '', 'hashtag', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 1, 1, 4),
(16, 0, 'sys_footer', 'system', 'about', '_sys_menu_item_title_system_about', '_sys_menu_item_title_about', 'page.php?i=about', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 1),
(17, 0, 'sys_footer', 'system', 'terms', '_sys_menu_item_title_system_terms', '_sys_menu_item_title_terms', 'page.php?i=terms', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 2),
(18, 0, 'sys_footer', 'system', 'privacy', '_sys_menu_item_title_system_privacy', '_sys_menu_item_title_privacy', 'page.php?i=privacy', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 3),
(19, 0, 'sys_footer', 'system', 'switch_language', '_sys_menu_item_title_system_switch_language', '_sys_menu_item_title_switch_language', 'javascript:void(0);', 'bx_menu_popup(''sys_switch_language_popup'', window);', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 4),
(20, 0, 'sys_footer', 'system', 'switch_template', '_sys_menu_item_title_system_switch_template', '_sys_menu_item_title_switch_template', 'javascript:void(0);', 'bx_menu_popup(''sys_switch_template'', window);', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 5),
(21, 0, 'sys_footer', 'system', 'copyright', '_sys_menu_item_title_system_copyright', '_sys_menu_item_title_copyright', 'javascript:void(0)', 'on_copyright_click()', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 6),
(22, 0, 'sys_footer', 'system', 'powered_by', '_sys_menu_item_title_system_powered_by', '', 'https://una.io', '', '_blank', '<svg width="167" height="28" viewBox="0 0 167 28" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.54 18.5C9.43733 18.5 9.358 18.472 9.302 18.416C9.246 18.3507 9.218 18.2713 9.218 18.178V9.036C9.218 8.93333 9.246 8.854 9.302 8.798C9.358 8.73267 9.43733 8.7 9.54 8.7H13.096C13.7867 8.7 14.384 8.812 14.888 9.036C15.4013 9.26 15.798 9.596 16.078 10.044C16.358 10.4827 16.498 11.0333 16.498 11.696C16.498 12.3587 16.358 12.9093 16.078 13.348C15.798 13.7867 15.4013 14.118 14.888 14.342C14.384 14.566 13.7867 14.678 13.096 14.678H10.618V18.178C10.618 18.2713 10.5853 18.3507 10.52 18.416C10.464 18.472 10.3847 18.5 10.282 18.5H9.54ZM10.604 13.502H13.026C13.7167 13.502 14.2347 13.348 14.58 13.04C14.9253 12.732 15.098 12.284 15.098 11.696C15.098 11.1173 14.93 10.6693 14.594 10.352C14.258 10.0347 13.7353 9.876 13.026 9.876H10.604V13.502ZM20.9047 18.64C20.1954 18.64 19.6027 18.5047 19.1267 18.234C18.6507 17.9633 18.2867 17.59 18.0347 17.114C17.7827 16.6287 17.6427 16.078 17.6147 15.462C17.6054 15.3033 17.6007 15.1027 17.6007 14.86C17.6007 14.608 17.6054 14.4073 17.6147 14.258C17.6427 13.6327 17.7827 13.082 18.0347 12.606C18.2961 12.13 18.6647 11.7567 19.1407 11.486C19.6167 11.2153 20.2047 11.08 20.9047 11.08C21.6047 11.08 22.1927 11.2153 22.6687 11.486C23.1447 11.7567 23.5087 12.13 23.7607 12.606C24.0221 13.082 24.1667 13.6327 24.1947 14.258C24.2041 14.4073 24.2087 14.608 24.2087 14.86C24.2087 15.1027 24.2041 15.3033 24.1947 15.462C24.1667 16.078 24.0267 16.6287 23.7747 17.114C23.5227 17.59 23.1587 17.9633 22.6827 18.234C22.2067 18.5047 21.6141 18.64 20.9047 18.64ZM20.9047 17.562C21.4834 17.562 21.9454 17.38 22.2907 17.016C22.6361 16.6427 22.8227 16.1013 22.8507 15.392C22.8601 15.252 22.8647 15.0747 22.8647 14.86C22.8647 14.6453 22.8601 14.468 22.8507 14.328C22.8227 13.6187 22.6361 13.082 22.2907 12.718C21.9454 12.3447 21.4834 12.158 20.9047 12.158C20.3261 12.158 19.8594 12.3447 19.5047 12.718C19.1594 13.082 18.9774 13.6187 18.9587 14.328C18.9494 14.468 18.9447 14.6453 18.9447 14.86C18.9447 15.0747 18.9494 15.252 18.9587 15.392C18.9774 16.1013 19.1594 16.6427 19.5047 17.016C19.8594 17.38 20.3261 17.562 20.9047 17.562ZM27.7024 18.5C27.581 18.5 27.4877 18.472 27.4224 18.416C27.357 18.3507 27.301 18.262 27.2544 18.15L25.2664 11.654C25.2477 11.6073 25.2384 11.5607 25.2384 11.514C25.2384 11.43 25.2664 11.36 25.3224 11.304C25.3877 11.248 25.4577 11.22 25.5324 11.22H26.1484C26.251 11.22 26.3304 11.248 26.3864 11.304C26.4424 11.36 26.4797 11.4113 26.4984 11.458L28.0524 16.736L29.7184 11.514C29.737 11.4487 29.7744 11.3833 29.8304 11.318C29.8957 11.2527 29.989 11.22 30.1104 11.22H30.5864C30.7077 11.22 30.801 11.2527 30.8664 11.318C30.9317 11.3833 30.969 11.4487 30.9784 11.514L32.6444 16.736L34.1984 11.458C34.2077 11.4113 34.2404 11.36 34.2964 11.304C34.3524 11.248 34.4317 11.22 34.5344 11.22H35.1504C35.2344 11.22 35.3044 11.248 35.3604 11.304C35.4164 11.36 35.4444 11.43 35.4444 11.514C35.4444 11.5607 35.435 11.6073 35.4164 11.654L33.4284 18.15C33.4004 18.262 33.349 18.3507 33.2744 18.416C33.209 18.472 33.111 18.5 32.9804 18.5H32.4344C32.313 18.5 32.2104 18.472 32.1264 18.416C32.0517 18.3507 32.0004 18.262 31.9724 18.15L30.3484 13.138L28.7244 18.15C28.687 18.262 28.631 18.3507 28.5564 18.416C28.4817 18.472 28.379 18.5 28.2484 18.5H27.7024ZM39.7016 18.64C38.7402 18.64 37.9749 18.346 37.4056 17.758C36.8362 17.1607 36.5236 16.3487 36.4676 15.322C36.4582 15.2007 36.4536 15.0467 36.4536 14.86C36.4536 14.664 36.4582 14.5053 36.4676 14.384C36.5049 13.7213 36.6589 13.1427 36.9296 12.648C37.2002 12.144 37.5689 11.7567 38.0356 11.486C38.5116 11.2153 39.0669 11.08 39.7016 11.08C40.4109 11.08 41.0036 11.2293 41.4796 11.528C41.9649 11.8267 42.3336 12.2513 42.5856 12.802C42.8376 13.3527 42.9636 13.9967 42.9636 14.734V14.972C42.9636 15.0747 42.9309 15.154 42.8656 15.21C42.8096 15.266 42.7349 15.294 42.6416 15.294H37.7976C37.7976 15.3033 37.7976 15.322 37.7976 15.35C37.7976 15.378 37.7976 15.4013 37.7976 15.42C37.8162 15.8027 37.9002 16.162 38.0496 16.498C38.1989 16.8247 38.4136 17.0907 38.6936 17.296C38.9736 17.5013 39.3096 17.604 39.7016 17.604C40.0376 17.604 40.3176 17.5527 40.5416 17.45C40.7656 17.3473 40.9476 17.2353 41.0876 17.114C41.2276 16.9833 41.3209 16.8853 41.3676 16.82C41.4516 16.6987 41.5169 16.6287 41.5636 16.61C41.6102 16.582 41.6849 16.568 41.7876 16.568H42.4596C42.5529 16.568 42.6276 16.596 42.6836 16.652C42.7489 16.6987 42.7769 16.7687 42.7676 16.862C42.7582 17.002 42.6836 17.1747 42.5436 17.38C42.4036 17.576 42.2029 17.772 41.9416 17.968C41.6802 18.164 41.3629 18.3273 40.9896 18.458C40.6162 18.5793 40.1869 18.64 39.7016 18.64ZM37.7976 14.328H41.6336V14.286C41.6336 13.866 41.5542 13.4927 41.3956 13.166C41.2462 12.8393 41.0269 12.5827 40.7376 12.396C40.4482 12.2 40.1029 12.102 39.7016 12.102C39.3002 12.102 38.9549 12.2 38.6656 12.396C38.3856 12.5827 38.1709 12.8393 38.0216 13.166C37.8722 13.4927 37.7976 13.866 37.7976 14.286V14.328ZM44.9596 18.5C44.8662 18.5 44.7869 18.472 44.7216 18.416C44.6656 18.3507 44.6376 18.2713 44.6376 18.178V11.556C44.6376 11.4627 44.6656 11.3833 44.7216 11.318C44.7869 11.2527 44.8662 11.22 44.9596 11.22H45.6036C45.6969 11.22 45.7762 11.2527 45.8416 11.318C45.9069 11.3833 45.9396 11.4627 45.9396 11.556V12.172C46.1262 11.8547 46.3829 11.6167 46.7096 11.458C47.0362 11.2993 47.4282 11.22 47.8856 11.22H48.4456C48.5389 11.22 48.6136 11.2527 48.6696 11.318C48.7256 11.374 48.7536 11.4487 48.7536 11.542V12.116C48.7536 12.2093 48.7256 12.284 48.6696 12.34C48.6136 12.396 48.5389 12.424 48.4456 12.424H47.6056C47.1016 12.424 46.7049 12.5733 46.4156 12.872C46.1262 13.1613 45.9816 13.558 45.9816 14.062V18.178C45.9816 18.2713 45.9489 18.3507 45.8836 18.416C45.8182 18.472 45.7389 18.5 45.6456 18.5H44.9596ZM52.7172 18.64C51.7559 18.64 50.9905 18.346 50.4212 17.758C49.8519 17.1607 49.5392 16.3487 49.4832 15.322C49.4739 15.2007 49.4692 15.0467 49.4692 14.86C49.4692 14.664 49.4739 14.5053 49.4832 14.384C49.5205 13.7213 49.6745 13.1427 49.9452 12.648C50.2159 12.144 50.5845 11.7567 51.0512 11.486C51.5272 11.2153 52.0825 11.08 52.7172 11.08C53.4265 11.08 54.0192 11.2293 54.4952 11.528C54.9805 11.8267 55.3492 12.2513 55.6012 12.802C55.8532 13.3527 55.9792 13.9967 55.9792 14.734V14.972C55.9792 15.0747 55.9465 15.154 55.8812 15.21C55.8252 15.266 55.7505 15.294 55.6572 15.294H50.8132C50.8132 15.3033 50.8132 15.322 50.8132 15.35C50.8132 15.378 50.8132 15.4013 50.8132 15.42C50.8319 15.8027 50.9159 16.162 51.0652 16.498C51.2145 16.8247 51.4292 17.0907 51.7092 17.296C51.9892 17.5013 52.3252 17.604 52.7172 17.604C53.0532 17.604 53.3332 17.5527 53.5572 17.45C53.7812 17.3473 53.9632 17.2353 54.1032 17.114C54.2432 16.9833 54.3365 16.8853 54.3832 16.82C54.4672 16.6987 54.5325 16.6287 54.5792 16.61C54.6259 16.582 54.7005 16.568 54.8032 16.568H55.4752C55.5685 16.568 55.6432 16.596 55.6992 16.652C55.7645 16.6987 55.7925 16.7687 55.7832 16.862C55.7739 17.002 55.6992 17.1747 55.5592 17.38C55.4192 17.576 55.2185 17.772 54.9572 17.968C54.6959 18.164 54.3785 18.3273 54.0052 18.458C53.6319 18.5793 53.2025 18.64 52.7172 18.64ZM50.8132 14.328H54.6492V14.286C54.6492 13.866 54.5699 13.4927 54.4112 13.166C54.2619 12.8393 54.0425 12.5827 53.7532 12.396C53.4639 12.2 53.1185 12.102 52.7172 12.102C52.3159 12.102 51.9705 12.2 51.6812 12.396C51.4012 12.5827 51.1865 12.8393 51.0372 13.166C50.8879 13.4927 50.8132 13.866 50.8132 14.286V14.328ZM60.3132 18.64C59.7999 18.64 59.3565 18.5513 58.9832 18.374C58.6099 18.1873 58.3019 17.94 58.0592 17.632C57.8259 17.3147 57.6485 16.9553 57.5272 16.554C57.4152 16.1527 57.3499 15.728 57.3312 15.28C57.3219 15.1307 57.3172 14.9907 57.3172 14.86C57.3172 14.7293 57.3219 14.5893 57.3312 14.44C57.3499 14.0013 57.4152 13.5813 57.5272 13.18C57.6485 12.7787 57.8259 12.4193 58.0592 12.102C58.3019 11.7847 58.6099 11.5373 58.9832 11.36C59.3565 11.1733 59.7999 11.08 60.3132 11.08C60.8639 11.08 61.3212 11.178 61.6852 11.374C62.0492 11.57 62.3479 11.8127 62.5812 12.102V8.882C62.5812 8.78867 62.6092 8.714 62.6652 8.658C62.7305 8.59267 62.8099 8.56 62.9032 8.56H63.5752C63.6685 8.56 63.7432 8.59267 63.7992 8.658C63.8645 8.714 63.8972 8.78867 63.8972 8.882V18.178C63.8972 18.2713 63.8645 18.3507 63.7992 18.416C63.7432 18.472 63.6685 18.5 63.5752 18.5H62.9452C62.8425 18.5 62.7632 18.472 62.7072 18.416C62.6512 18.3507 62.6232 18.2713 62.6232 18.178V17.59C62.3899 17.8887 62.0865 18.1407 61.7132 18.346C61.3399 18.542 60.8732 18.64 60.3132 18.64ZM60.6072 17.506C61.0739 17.506 61.4472 17.3987 61.7272 17.184C62.0072 16.9693 62.2172 16.6987 62.3572 16.372C62.4972 16.036 62.5719 15.6953 62.5812 15.35C62.5905 15.2007 62.5952 15.0233 62.5952 14.818C62.5952 14.6033 62.5905 14.4213 62.5812 14.272C62.5719 13.9453 62.4925 13.6233 62.3432 13.306C62.2032 12.9887 61.9885 12.7273 61.6992 12.522C61.4192 12.3167 61.0552 12.214 60.6072 12.214C60.1312 12.214 59.7532 12.3213 59.4732 12.536C59.1932 12.7413 58.9925 13.0167 58.8712 13.362C58.7499 13.698 58.6799 14.062 58.6612 14.454C58.6519 14.7247 58.6519 14.9953 58.6612 15.266C58.6799 15.658 58.7499 16.0267 58.8712 16.372C58.9925 16.708 59.1932 16.9833 59.4732 17.198C59.7532 17.4033 60.1312 17.506 60.6072 17.506ZM73.009 18.64C72.449 18.64 71.9823 18.542 71.609 18.346C71.2357 18.1407 70.937 17.8887 70.713 17.59V18.178C70.713 18.2713 70.6803 18.3507 70.615 18.416C70.559 18.472 70.4843 18.5 70.391 18.5H69.747C69.6537 18.5 69.5743 18.472 69.509 18.416C69.453 18.3507 69.425 18.2713 69.425 18.178V8.882C69.425 8.78867 69.453 8.714 69.509 8.658C69.5743 8.59267 69.6537 8.56 69.747 8.56H70.419C70.5217 8.56 70.601 8.59267 70.657 8.658C70.713 8.714 70.741 8.78867 70.741 8.882V12.102C70.9743 11.8127 71.273 11.57 71.637 11.374C72.0103 11.178 72.4677 11.08 73.009 11.08C73.5317 11.08 73.975 11.1733 74.339 11.36C74.7123 11.5373 75.0157 11.7847 75.249 12.102C75.4917 12.4193 75.6737 12.7787 75.795 13.18C75.9163 13.5813 75.9817 14.0013 75.991 14.44C76.0003 14.5893 76.005 14.7293 76.005 14.86C76.005 14.9907 76.0003 15.1307 75.991 15.28C75.9817 15.728 75.9163 16.1527 75.795 16.554C75.6737 16.9553 75.4917 17.3147 75.249 17.632C75.0157 17.94 74.7123 18.1873 74.339 18.374C73.975 18.5513 73.5317 18.64 73.009 18.64ZM72.715 17.506C73.2003 17.506 73.5783 17.4033 73.849 17.198C74.129 16.9833 74.3297 16.708 74.451 16.372C74.5723 16.0267 74.6423 15.658 74.661 15.266C74.6703 14.9953 74.6703 14.7247 74.661 14.454C74.6423 14.062 74.5723 13.698 74.451 13.362C74.3297 13.0167 74.129 12.7413 73.849 12.536C73.5783 12.3213 73.2003 12.214 72.715 12.214C72.2763 12.214 71.9123 12.3167 71.623 12.522C71.3337 12.7273 71.1143 12.9887 70.965 13.306C70.825 13.6233 70.7503 13.9453 70.741 14.272C70.7317 14.4213 70.727 14.6033 70.727 14.818C70.727 15.0233 70.7317 15.2007 70.741 15.35C70.7597 15.6953 70.8343 16.036 70.965 16.372C71.105 16.6987 71.315 16.9693 71.595 17.184C71.8843 17.3987 72.2577 17.506 72.715 17.506ZM78.7377 21.16C78.6631 21.16 78.5977 21.132 78.5417 21.076C78.4857 21.02 78.4577 20.9547 78.4577 20.88C78.4577 20.8427 78.4624 20.8053 78.4717 20.768C78.4811 20.7307 78.4997 20.684 78.5277 20.628L79.6057 18.066L76.9317 11.752C76.8851 11.64 76.8617 11.5607 76.8617 11.514C76.8617 11.43 76.8897 11.36 76.9457 11.304C77.0017 11.248 77.0717 11.22 77.1557 11.22H77.8417C77.9351 11.22 78.0097 11.2433 78.0657 11.29C78.1217 11.3367 78.1591 11.3927 78.1777 11.458L80.3057 16.554L82.4897 11.458C82.5177 11.3927 82.5551 11.3367 82.6017 11.29C82.6577 11.2433 82.7371 11.22 82.8397 11.22H83.4977C83.5817 11.22 83.6517 11.248 83.7077 11.304C83.7637 11.36 83.7917 11.4253 83.7917 11.5C83.7917 11.5467 83.7684 11.6307 83.7217 11.752L79.7457 20.922C79.7177 20.9873 79.6757 21.0433 79.6197 21.09C79.5731 21.1367 79.4984 21.16 79.3957 21.16H78.7377Z" fill="#478293"/><path d="M96.9739 9.94545C98.0069 8.91955 99.4297 8.28571 101.001 8.28571C101.165 8.28571 101.327 8.29263 101.488 8.3062C101.643 8.31927 101.784 8.2133 101.818 8.0616C102.142 6.60877 103.205 5.43424 104.591 4.95157C104.72 4.9065 104.733 4.71896 104.606 4.66953C103.487 4.23711 102.272 4 101.001 4C99.531 4 98.1355 4.317 96.8786 4.88633C96.7782 4.93184 96.7148 5.03261 96.7148 5.14291V9.84251C96.7148 9.97411 96.8806 10.0382 96.9739 9.94545Z" fill="#3E6B7C"/><path d="M106.937 22.0478C106.844 22.1164 106.715 22.0493 106.715 21.9337V14C106.715 13.8359 106.708 13.6733 106.694 13.5127C106.681 13.3578 106.787 13.2165 106.939 13.1827C108.392 12.8581 109.566 11.796 110.049 10.4098C110.094 10.2804 110.282 10.2671 110.331 10.395C110.763 11.5134 111.001 12.729 111.001 14C111.001 17.3 109.402 20.2266 106.937 22.0478Z" fill="#3E6B7C"/><path d="M108.857 8.99996C108.857 10.5779 107.578 11.8571 106 11.8571C104.422 11.8571 103.143 10.5779 103.143 8.99996C103.143 7.42201 104.422 6.14282 106 6.14282C107.578 6.14282 108.857 7.42201 108.857 8.99996Z" fill="#F97016"/><path d="M91.9516 17.5902C91.9065 17.7196 91.719 17.7329 91.6695 17.605C91.2371 16.4866 91 15.271 91 14C91 10.7001 92.5984 7.77346 95.0633 5.95217C95.1562 5.88354 95.2857 5.95082 95.2857 6.06629V14C95.2857 14.1642 95.2927 14.3267 95.3062 14.4873C95.3193 14.6422 95.2133 14.7835 95.0616 14.8174C93.6088 15.1419 92.4343 16.204 91.9516 17.5902Z" fill="#3E6B7C"/><path d="M105.122 23.1137C105.222 23.0682 105.286 22.9674 105.286 22.8572V18.1575C105.286 18.0259 105.12 17.9619 105.027 18.0546C103.994 19.0805 102.571 19.7143 101 19.7143C100.836 19.7143 100.673 19.7075 100.513 19.6939C100.358 19.6807 100.217 19.7867 100.183 19.9385C99.8581 21.3913 98.796 22.5657 97.4098 23.0484C97.2803 23.0936 97.2671 23.281 97.3949 23.3304C98.5133 23.7629 99.729 24 101 24C102.47 24 103.865 23.683 105.122 23.1137Z" fill="#3E6B7C"/><path d="M98.8569 19C98.8569 20.578 97.5777 21.8571 95.9997 21.8571C94.4218 21.8571 93.1426 20.578 93.1426 19C93.1426 17.422 94.4218 16.1428 95.9997 16.1428C97.5777 16.1428 98.8569 17.422 98.8569 19Z" fill="#F97016"/><path d="M128.5 14C128.5 16.4853 126.485 18.5 124 18.5C121.515 18.5 119.5 16.4853 119.5 14V8.75C119.5 8.33579 119.164 8 118.75 8C118.336 8 118 8.33579 118 8.75V14C118 17.3137 120.686 20 124 20C127.314 20 130 17.3137 130 14V8.75C130 8.33579 129.664 8 129.25 8C128.836 8 128.5 8.33579 128.5 8.75V14Z" fill="#3E6B7C"/><path d="M142.5 14V19.25C142.5 19.6642 142.836 20 143.25 20C143.664 20 144 19.6642 144 19.25V14C144 10.6863 141.314 8 138 8C134.686 8 132 10.6863 132 14V19.25C132 19.6642 132.336 20 132.75 20C133.164 20 133.5 19.6642 133.5 19.25V14C133.5 11.5147 135.515 9.5 138 9.5C140.485 9.5 142.5 11.5147 142.5 14Z" fill="#3E6B7C"/><path fill-rule="evenodd" clip-rule="evenodd" d="M156.5 17.9687V19.25C156.5 19.6642 156.836 20 157.25 20V20C157.664 20 158 19.6642 158 19.25V14C158 10.6863 155.314 8 152 8C148.686 8 146 10.6863 146 14C146 17.3137 148.686 20 152 20C153.792 20 155.401 19.2144 156.5 17.9687ZM156.5 14C156.5 16.4853 154.485 18.5 152 18.5C149.515 18.5 147.5 16.4853 147.5 14C147.5 11.5147 149.515 9.5 152 9.5C154.485 9.5 156.5 11.5147 156.5 14Z" fill="#3E6B7C"/><rect x="0.5" y="0.5" width="166" height="27" rx="7.5" stroke="#478293"/></svg>', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 9999),
(23, 0, 'sys_toolbar_site', 'system', 'main-menu', '_sys_menu_item_title_system_main_menu', '', 'javascript:void(0);', 'bx_menu_slide_inline(''#bx-sliding-menu-sys_site'', this, ''site'');', '', 'bars', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 1),
(24, 0, 'sys_toolbar_site', 'system', 'search', '_sys_menu_item_title_system_search', '', 'javascript:void(0);', 'bx_menu_slide_inline(''#bx-sliding-menu-search'', this, ''site'');', '', 'search', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 2),
(25, 0, 'sys_toolbar_member', 'system', 'add-content', '_sys_menu_item_title_system_add_content', '', 'javascript:void(0);', 'bx_menu_slide_inline(''#bx-sliding-menu-sys_add_content'', this, ''site'');', '', 'plus', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 0),
(26, 0, 'sys_toolbar_member', 'system', 'apps', '_sys_menu_item_title_system_apps', '', 'javascript:void(0);', '', '', 'qrcode', '', 0, '', '', 0, 2147483646, '', '', '', 3, 0, '', 0, 0, 1, 0, 1, 1, 0),
(27, 0, 'sys_toolbar_member', 'system', 'account', '_sys_menu_item_title_system_account_menu', '_sys_menu_item_title_account_menu', 'javascript:void(0);', 'bx_menu_slide_inline(''#bx-sliding-menu-account'', this, ''site'');', '', 'user', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:21:"profile_notifications";s:5:"class";s:20:"TemplServiceProfiles";}', 0, '', 'sys_account_popup', 1, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 1),
(28, 0, 'sys_toolbar_member', 'system', 'login', '_sys_menu_item_title_system_login', '', 'page.php?i=login', '', '', 'user', '', 0, '', '', 0, 1, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 2),
(29, 0, 'sys_account_popup', 'system', 'profile-active', '_sys_menu_item_title_system_ap_profile_active', '', '', '', '', '', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 1),
(30, 0, 'sys_account_popup', 'system', 'profile-notifications', '_sys_menu_item_title_system_ap_profile_notifications', '', '', '', '', '', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 2),
(31, 0, 'sys_account_popup', 'system', 'profile-switcher', '_sys_menu_item_title_system_ap_profile_switcher', '', '', '', '', '', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 3),
(32, 0, 'sys_account_popup', 'system', 'profile-create', '_sys_menu_item_title_system_ap_profile_create', '', '', '', '', '', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 4),
(33, 0, 'sys_account_notifications', 'system', 'dashboard', '_sys_menu_item_title_system_dashboard', '_sys_menu_item_title_dashboard', 'page.php?i=dashboard', '', '', 'tachometer-alt', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 1),
(34, 0, 'sys_account_notifications', 'system', 'profile', '_sys_menu_item_title_system_profile', '_sys_menu_item_title_profile', '{member_url}', '', '', 'user', '', 0, '', '', 0, 2147483644, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 2),
(35, 0, 'sys_account_notifications', 'system', 'account-settings', '_sys_menu_item_title_system_account_settings', '_sys_menu_item_title_account_settings', 'page.php?i=account-settings-email', '', '', 'cog', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 3),
(36, 0, 'sys_account_notifications', 'system', 'add-content', '_sys_menu_item_title_system_add_content', '_sys_menu_item_title_add_content', 'javascript:void(0);', 'bx_menu_slide_inline(''#bx-sliding-menu-sys_add_content'', $(''#bx-menu-toolbar-item-add-content a'').get(0), ''site'');', '', 'plus', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 4),
(37, 0, 'sys_account_notifications', 'system', 'studio', '_sys_menu_item_title_system_studio', '_sys_menu_item_title_studio', '{studio_url}', '', '', 'wrench', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 5),
(38, 0, 'sys_account_notifications', 'system', 'cart', '_sys_menu_item_title_system_cart', '_sys_menu_item_title_cart', 'cart.php', '', '', 'cart-plus col-red3', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:20:"get_cart_items_count";s:6:"params";a:0:{}s:5:"class";s:21:"TemplPaymentsServices";}', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 6),
(39, 0, 'sys_account_notifications', 'system', 'orders', '_sys_menu_item_title_system_orders', '_sys_menu_item_title_orders', 'orders.php', '', '', 'cart-arrow-down col-green3', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:16:"get_orders_count";s:6:"params";a:1:{i:0;s:3:"new";}s:5:"class";s:21:"TemplPaymentsServices";}', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 0, 0, 1, 1, 7),
(40, 0, 'sys_account_notifications', 'system', 'invoices', '_sys_menu_item_title_system_invoices', '_sys_menu_item_title_invoices', 'invoices.php', '', '', 'file-invoice col-green3', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:18:"get_invoices_count";s:6:"params";a:1:{i:0;s:6:"unpaid";}s:5:"class";s:21:"TemplPaymentsServices";}', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 0, 0, 1, 1, 8),
(41, 0, 'sys_account_notifications', 'system', 'logout', '_sys_menu_item_title_system_logout', '_sys_menu_item_title_logout', 'page.php?i=logout', '', '', 'sign-out-alt', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 9999),
(42, 0, 'sys_account_settings', 'system', 'account-profile-switcher', '_sys_menu_item_title_system_account_profile_context', '_sys_menu_item_title_account_profile_context', 'page.php?i=account-profile-switcher', '', '', 'user', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 1),
(43, 0, 'sys_account_settings', 'system', 'account-settings-info', '_sys_menu_item_title_system_account_settings_info', '_sys_menu_item_title_account_settings_info', 'page.php?i=account-settings-info', '', '', 'info-circle', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 2),
(44, 0, 'sys_account_settings', 'system', 'account-settings-email', '_sys_menu_item_title_system_account_settings_email', '_sys_menu_item_title_account_settings_email', 'page.php?i=account-settings-email', '', '', 'envelope', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 3),
(45, 0, 'sys_account_settings', 'system', 'account-settings-password', '_sys_menu_item_title_system_account_settings_pwd', '_sys_menu_item_title_account_settings_pwd', 'page.php?i=account-settings-password', '', '', 'key', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 4),
(46, 0, 'sys_account_settings', 'system', 'profile-settings-cfilter', '_sys_menu_item_title_system_profile_settings_cfilter', '_sys_menu_item_title_profile_settings_cfilter', 'page.php?i=profile-settings-cfilter', '', '', 'filter', '', 0, '', '', 0, 2147483646, 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:18:"is_enabled_cfilter";s:6:"params";a:0:{}s:5:"class";s:20:"TemplServiceProfiles";}', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 5),
(47, 0, 'sys_account_settings', 'system', 'account-settings-delete', '_sys_menu_item_title_system_account_settings_delete', '_sys_menu_item_title_account_settings_delete', 'page.php?i=account-settings-delete', '', '', 'remove', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 9999),
(48, 0, 'sys_account_dashboard', 'system', 'dashboard', '_sys_menu_item_title_system_account_dashboard', '_sys_menu_item_title_account_dashboard', 'page.php?i=dashboard', '', '', 'tachometer-alt', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 1),
(49, 0, 'sys_account_dashboard', 'system', 'dashboard-subscriptions', '_sys_menu_item_title_system_subscriptions', '_sys_menu_item_title_subscriptions', 'subscriptions.php', '', '', 'credit-card col-blue3', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 2),
(50, 0, 'sys_account_dashboard', 'system', 'dashboard-orders', '_sys_menu_item_title_system_orders', '_sys_menu_item_title_orders', 'orders.php', '', '', 'cart-arrow-down col-green3', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 3),
(51, 0, 'sys_account_dashboard', 'system', 'dashboard-invoices', '_sys_menu_item_title_system_invoices', '_sys_menu_item_title_invoices', 'invoices.php', '', '', 'file-invoice col-green3', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 4),
(52, 0, 'sys_account_dashboard', 'system', 'dashboard-content', '_sys_menu_item_title_system_account_dashboard_content', '_sys_menu_item_title_account_dashboard_content', 'page.php?i=dashboard-content', '', '', 'copy', '', 0, '', '', 0, 192, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 5),
(53, 0, 'sys_account_dashboard', 'system', 'dashboard-reports', '_sys_menu_item_title_system_account_dashboard_reports', '_sys_menu_item_title_account_dashboard_reports', 'page.php?i=dashboard-reports', '', '', 'exclamation-circle', '', 0, '', '', 0, 192, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 6),
(54, 0, 'sys_account_dashboard', 'system', 'dashboard-audit', '_sys_menu_item_title_system_account_dashboard_audit', '_sys_menu_item_title_account_dashboard_audit', 'page.php?i=dashboard-audit', '', '', 'history', '', 0, '', '', 0, 192, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 7),
(55, 0, 'sys_cmts_item_manage', 'system', 'item-pin', '_sys_menu_item_title_system_cmts_item_pin', '_sys_menu_item_title_cmts_item_pin', 'javascript:void(0)', 'javascript:{js_object}.cmtPin(this, {content_id}, 1)', '_self', 'thumbtack', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 0),
(56, 0, 'sys_cmts_item_manage', 'system', 'item-unpin', '_sys_menu_item_title_system_cmts_item_unpin', '_sys_menu_item_title_cmts_item_unpin', 'javascript:void(0)', 'javascript:{js_object}.cmtPin(this, {content_id}, 0)', '_self', 'thumbtack', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 0),
(57, 0, 'sys_cmts_item_manage', 'system', 'item-report', '_sys_menu_item_title_system_cmts_item_report', '', 'javascript:void(0)', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 0),
(58, 0, 'sys_cmts_item_manage', 'system', 'item-edit', '_sys_menu_item_title_system_cmts_item_edit', '_sys_menu_item_title_cmts_item_edit', 'javascript:void(0)', 'javascript:{js_object}.cmtEdit(this, {content_id})', '_self', 'pencil-alt', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 0),
(59, 0, 'sys_cmts_item_manage', 'system', 'item-delete', '_sys_menu_item_title_system_cmts_item_delete', '_sys_menu_item_title_cmts_item_delete', 'javascript:void(0)', 'javascript:{js_object}.cmtRemove(this, {content_id})', '_self', 'remove', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 0),
(60, 0, 'sys_cmts_item_actions', 'system', 'item-vote', '_sys_menu_item_title_system_cmts_item_vote', '_sys_menu_item_title_cmts_item_vote', 'javascript:void(0)', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 0),
(61, 0, 'sys_cmts_item_actions', 'system', 'item-reaction', '_sys_menu_item_title_system_cmts_item_reaction', '_sys_menu_item_title_cmts_item_reaction', 'javascript:void(0)', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 1),
(62, 0, 'sys_cmts_item_actions', 'system', 'item-score', '_sys_menu_item_title_system_cmts_item_score', '_sys_menu_item_title_cmts_item_score', 'javascript:void(0)', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 2),
(63, 0, 'sys_cmts_item_actions', 'system', 'item-reply', '_sys_menu_item_title_system_cmts_item_reply', '_sys_menu_item_title_cmts_item_reply', 'javascript:void(0)', 'javascript:{reply_onclick}', '_self', 'reply', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 3),
(64, 0, 'sys_cmts_item_actions', 'system', 'item-quote', '_sys_menu_item_title_system_cmts_item_quote', '_sys_menu_item_title_cmts_item_quote', 'javascript:void(0)', 'javascript:{quote_onclick}', '_self', 'quote-right', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 4),
(65, 0, 'sys_cmts_item_actions', 'system', 'item-more', '_sys_menu_item_title_system_cmts_item_more', '_sys_menu_item_title_cmts_item_more', 'javascript:void(0)', 'bx_menu_popup(''sys_cmts_item_manage'', this, {''id'':''sys_cmts_item_manage_{cmt_system}_{cmt_id}'', ''removeOnClose'':1}, {cmt_system:''{cmt_system}'', cmt_object_id:{cmt_object_id}, cmt_id:{cmt_id}});', '', 'ellipsis-h', '', 0, '', 'sys_cmts_item_manage', 1, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 5),
(66, 0, 'sys_cmts_item_counters', 'system', 'item-vote', '_sys_menu_item_title_system_cmts_item_vote', '', 'javascript:void(0)', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 0),
(67, 0, 'sys_cmts_item_counters', 'system', 'item-reaction', '_sys_menu_item_title_system_cmts_item_reaction', '', 'javascript:void(0)', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 1),
(68, 0, 'sys_cmts_item_counters', 'system', 'item-score', '_sys_menu_item_title_system_cmts_item_score', '', 'javascript:void(0)', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 2),
(69, 0, 'sys_cmts_item_meta', 'system', 'author', '_sys_menu_item_title_system_sm_author', '_sys_menu_item_title_sm_author', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 0),
(70, 0, 'sys_cmts_item_meta', 'system', 'in-reply-to', '_sys_menu_item_title_system_sm_in_reply_to', '_sys_menu_item_title_sm_in_reply_to', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 1),
(71, 0, 'sys_cmts_item_meta', 'system', 'date', '_sys_menu_item_title_system_sm_date', '_sys_menu_item_title_sm_date', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 2),
(72, 0, 'sys_cmts_item_meta', 'system', 'membership', '_sys_menu_item_title_system_sm_membership', '_sys_menu_item_title_sm_membership', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 3),
(73, 0, 'sys_social_sharing', 'system', 'social-sharing-facebook', '_sys_menu_item_title_system_social_sharing_facebook', '_sys_menu_item_title_social_sharing_facebook', 'https://www.facebook.com/sharer/sharer.php?u={url_encoded}', '', '_blank', 'fab facebook-f', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 1),
(74, 0, 'sys_social_sharing', 'system', 'social-sharing-twitter', '_sys_menu_item_title_system_social_sharing_twitter', '_sys_menu_item_title_social_sharing_twitter', 'https://twitter.com/share?url={url_encoded}', '', '_blank', 'fab twitter', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 2),
(75, 0, 'sys_social_sharing', 'system', 'social-sharing-pinterest', '_sys_menu_item_title_system_social_sharing_pinterest', '_sys_menu_item_title_social_sharing_pinterest', 'http://pinterest.com/pin/create/button/?url={url_encoded}&media={img_url_encoded}&description={title_encoded}', '', '_blank', 'fab pinterest', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 3),
(76, 0, 'sys_social_sharing', 'system', 'social-sharing-linked_in', '_sys_menu_item_title_system_social_sharing_linked_in', '_sys_menu_item_title_social_sharing_linked_in', 'https://www.linkedin.com/shareArticle?mini=true&url={url_encoded}', '', '_blank', 'fab linkedin', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 4),
(77, 0, 'sys_social_sharing', 'system', 'social-sharing-whatsapp', '_sys_menu_item_title_system_social_sharing_whatsapp', '_sys_menu_item_title_social_sharing_whatsapp', 'https://wa.me/?text={url_encoded}', '', '_blank', 'fab whatsapp', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 5),
(78, 0, 'sys_account_dashboard_manage_tools', 'system', 'cmts-administration', '_sys_menu_item_title_system_cmts_administration', '_sys_menu_item_title_cmts_administration', 'page.php?i=cmts-administration', '', '', 'comments', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:27:"get_menu_addon_manage_tools";s:5:"class";s:17:"TemplCmtsServices";}', 0, '', '', 0, 192, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 1),
(79, 0, 'sys_account_dashboard_manage_tools', 'system', 'audit-administration', '_sys_menu_item_title_system_audit_administration', '_sys_menu_item_title_audit_administration', 'page.php?i=audit-administration', '', '', 'history', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:27:"get_menu_addon_manage_tools";s:5:"class";s:18:"TemplAuditServices";}', 0, '', '', 0, 192, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 2),
(80, 0, 'sys_dashboard_content_manage', 'system', 'cmts', '_sys_menu_item_title_system_cmts_administration', '_sys_menu_item_title_cmts_administration', 'page.php?i=dashboard-content&module=cmts', '', '', '', '', 0, '', '', 0, 192, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 1),
(81, 0, 'sys_profile_stats', 'system', 'profile-stats-profile', '_sys_menu_item_title_system_profile', '_sys_menu_item_title_profile', '{member_url}', '', '', 'user', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:27:"get_menu_addon_profile_edit";s:6:"params";a:0:{}s:5:"class";s:20:"TemplServiceProfiles";}', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 0),
(82, 0, 'sys_profile_stats', 'system', 'friend-suggestions', '_sys_menu_item_title_system_connections', '_sys_menu_item_title_connections', 'page.php?i=friend-suggestions', '', '', 'users', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"get_unconfirmed_connections_num";s:6:"params";a:1:{i:0;s:20:"sys_profiles_friends";}s:5:"class";s:23:"TemplServiceConnections";}', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 1),
(83, 0, 'sys_wiki', 'system', 'edit', '', '_sys_menu_item_title_wiki_edit', '', '', '', 'edit', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 1),
(84, 0, 'sys_wiki', 'system', 'delete-version', '', '_sys_menu_item_title_wiki_delete_version', '', '', '', 'times', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 2),
(85, 0, 'sys_wiki', 'system', 'delete-block', '', '_sys_menu_item_title_wiki_delete_block', '', '', '', 'times-circle', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 3),
(86, 0, 'sys_wiki', 'system', 'translate', '', '_sys_menu_item_title_wiki_translate', '', '', '', 'language', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 4),
(87, 0, 'sys_wiki', 'system', 'history', '', '_sys_menu_item_title_wiki_history', '', '', '', 'history', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 5),
(88, 0, 'sys_favorite_list', 'system', 'edit', '', '_sys_menu_item_title_favorite_list_edit', 'javascript:void(0)', 'javascript:{js_object}.cmtEdit(this, {list_id})', '', 'edit', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 1),
(89, 0, 'sys_favorite_list', 'system', 'delete', '', '_sys_menu_item_title_wiki_favorite_list_delete', 'javascript:void(0)', 'javascript:{js_object}.cmtDelete(this, {list_id})', '', 'times', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 2),
(90, 0, 'sys_con_submenu', 'system', 'friends', '', '_sys_menu_item_title_con_friends', 'page.php?i=friends', '', '', '', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:21:"profile_friends_count";s:5:"class";s:20:"TemplServiceProfiles";}', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 1),
(91, 0, 'sys_con_submenu', 'system', 'friend-suggestions', '', '_sys_menu_item_title_recom_friends', 'page.php?i=friend-suggestions', '', '', '', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:36:"profile_recommendation_friends_count";s:5:"class";s:20:"TemplServiceProfiles";}', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 2),
(92, 0, 'sys_con_submenu', 'system', 'friend-requests', '', '_sys_menu_item_title_con_friend_requests', 'page.php?i=friend-requests', '', '', '', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:30:"profile_friends_requests_count";s:5:"class";s:20:"TemplServiceProfiles";}', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 3),
(93, 0, 'sys_con_submenu', 'system', 'sent-friend-requests', '', '_sys_menu_item_title_con_friend_requested', 'page.php?i=sent-friend-requests', '', '', '', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:35:"profile_sent_friends_requests_count";s:5:"class";s:20:"TemplServiceProfiles";}', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 4),
(94, 0, 'sys_con_submenu', 'system', 'follow-suggestions', '', '_sys_menu_item_title_recom_subscriptions', 'page.php?i=follow-suggestions', '', '', '', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:38:"profile_recommendation_following_count";s:5:"class";s:20:"TemplServiceProfiles";}', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 5),
(95, 0, 'sys_con_submenu', 'system', 'followers', '', '_sys_menu_item_title_con_followers', 'page.php?i=followers', '', '', '', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:23:"profile_followers_count";s:5:"class";s:20:"TemplServiceProfiles";}', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 6),
(96, 0, 'sys_con_submenu', 'system', 'following', '', '_sys_menu_item_title_con_following', 'page.php?i=following', '', '', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:23:"profile_following_count";s:6:"params";a:2:{i:0;i:0;i:1;b:1;}s:5:"class";s:20:"TemplServiceProfiles";}', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 7),
(97, 0, 'sys_studio_account_popup', 'system', 'account', '_sys_menu_item_title_system_sa_account', '_sys_menu_item_title_sa_account', '{member_url}', '', '', 'ami-account.svg', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 0, 1),
(98, 0, 'sys_studio_account_popup', 'system', 'site', '_sys_menu_item_title_system_sa_site', '_sys_menu_item_title_sa_site', '{url_root}', '', '', 'ami-site.svg', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 0, 2),
(99, 0, 'sys_studio_account_popup', 'system', 'edit', '_sys_menu_item_title_system_sa_edit', '_sys_menu_item_title_sa_edit', 'javascript:void(0)', '{js_object}.clickEdit(this);', '', 'ami-edit.svg', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 0, 3),
(100, 0, 'sys_studio_account_popup', 'system', 'language', '_sys_menu_item_title_system_sa_language', '_sys_menu_item_title_sa_language', 'javascript:void(0)', 'bx_menu_popup(''sys_switch_language_popup'', window);', '', 'ami-language.svg', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 0, 4),
(101, 0, 'sys_studio_account_popup', 'system', 'logout', '_sys_menu_item_title_system_sa_logout', '_sys_menu_item_title_sa_logout', '{url_root}logout.php', '{js_object}.clickLogout(this);', '', 'ami-logout.svg', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 0, 5),
(102, 0, 'sys_site', 'bx_persons', 'persons-home', '_bx_persons_menu_item_title_system_entries_home', '_bx_persons_menu_item_title_entries_home', 'page.php?i=persons-home', '', '', 'user col-blue3', '', 0, '', 'bx_persons_submenu', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 4),
(103, 0, 'sys_homepage', 'bx_persons', 'persons-home', '_bx_persons_menu_item_title_system_entries_home', '_bx_persons_menu_item_title_entries_home', 'page.php?i=persons-home', '', '', 'user col-blue3', '', 0, '', 'bx_persons_submenu', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 1),
(104, 0, 'sys_add_profile_links', 'bx_persons', 'create-persons-profile', '_bx_persons_menu_item_title_system_create_profile', '_bx_persons_menu_item_title_create_profile', 'page.php?i=create-persons-profile', '', '', 'user col-blue3', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 1),
(105, 0, 'bx_persons_view_actions', 'bx_persons', 'profile-friend-add', '_bx_persons_menu_item_title_system_befriend', '{title_add_friend}', 'javascript:void(0)', 'bx_conn_action(this, ''sys_profiles_friends'', ''add'', ''{profile_id}'')', '', 'user-plus', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 10),
(106, 0, 'bx_persons_view_actions', 'bx_persons', 'profile-friend-remove', '_bx_persons_menu_item_title_system_unfriend', '{title_remove_friend}', 'javascript:void(0)', 'bx_conn_action(this, ''sys_profiles_friends'', ''remove'', ''{profile_id}'')', '', 'user-times', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 11),
(107, 0, 'bx_persons_view_actions', 'bx_persons', 'profile-relation-add', '_bx_persons_menu_item_title_system_relation_add', '_bx_persons_menu_item_title_relation_add', 'javascript:void(0)', 'bx_menu_popup(''sys_add_relation'', window, {}, {profile_id: {profile_id}});', '', 'sync', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 15),
(108, 0, 'bx_persons_view_actions', 'bx_persons', 'profile-relation-remove', '_bx_persons_menu_item_title_system_relation_delete', '_bx_persons_menu_item_title_relation_delete', 'javascript:void(0)', 'bx_conn_action(this, ''sys_profiles_relations'', ''remove'', ''{profile_id}'')', '', 'sync', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 16),
(109, 0, 'bx_persons_view_actions', 'bx_persons', 'profile-subscribe-add', '_bx_persons_menu_item_title_system_subscribe', '_bx_persons_menu_item_title_subscribe', 'javascript:void(0)', 'bx_conn_action(this, ''sys_profiles_subscriptions'', ''add'', ''{profile_id}'')', '', 'check', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 20),
(110, 0, 'bx_persons_view_actions', 'bx_persons', 'profile-subscribe-remove', '_bx_persons_menu_item_title_system_unsubscribe', '_bx_persons_menu_item_title_unsubscribe', 'javascript:void(0)', 'bx_conn_action(this, ''sys_profiles_subscriptions'', ''remove'', ''{profile_id}'')', '', 'check', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 21),
(111, 0, 'bx_persons_view_actions', 'bx_persons', 'profile-set-acl-level', '_sys_menu_item_title_system_set_acl_level', '_sys_menu_item_title_set_acl_level', 'javascript:void(0)', 'bx_menu_popup(''sys_set_acl_level'', window, {id:{value:''sys_acl_set_{profile_id}'', force:true}, closeOnOuterClick: false, removeOnClose: true, displayMode: ''box'', cssClass: ''''}, {profile_id: {profile_id}});', '', 'certificate', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 30),
(112, 0, 'bx_persons_view_actions', 'bx_persons', 'profile-set-badges', '_sys_menu_item_title_system_set_badges', '_sys_menu_item_title_set_badges', 'javascript:void(0)', 'bx_menu_popup(''sys_set_badges'', window, {}, {module: ''bx_persons'', content_id: {content_id}});', '', 'check-circle', '', 0, '', '', 0, 192, 'a:2:{s:6:"module";s:10:"bx_persons";s:6:"method";s:19:"is_badges_avaliable";}', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 30),
(113, 0, 'bx_persons_view_actions', 'bx_persons', 'profile-actions-more', '_bx_persons_menu_item_title_system_more_actions', '_bx_persons_menu_item_title_more_actions', 'javascript:void(0)', 'bx_menu_popup(''bx_persons_view_actions_more'', this, {}, {profile_id:{profile_id}});', '', 'cog', '', 0, '', 'bx_persons_view_actions_more', 1, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 9999),
(114, 0, 'bx_persons_view_actions_more', 'bx_persons', 'notes', '_sys_menu_item_title_system_va_notes', '_sys_menu_item_title_va_notes', 'javascript:void(0)', 'javascript:bx_get_notes(this,  ''{module_uri}'', {content_id});', '', 'exclamation-triangle', '', 0, '', '', 0, 192, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 10),
(115, 0, 'bx_persons_view_actions_more', 'bx_persons', 'audit', '_sys_menu_item_title_system_va_audit', '_sys_menu_item_title_va_audit', 'page.php?i=dashboard-audit&module=bx_persons&content_id={content_id}', '', '', 'history', '', 0, '', '', 0, 192, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 20),
(116, 0, 'bx_persons_view_actions_more', 'bx_persons', 'edit-persons-profile', '_bx_persons_menu_item_title_system_edit_profile', '_bx_persons_menu_item_title_edit_profile', 'page.php?i=edit-persons-profile&id={content_id}', '', '', 'pencil-alt', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 30),
(117, 0, 'bx_persons_view_actions_more', 'bx_persons', 'delete-persons-profile', '_bx_persons_menu_item_title_system_delete_profile', '_bx_persons_menu_item_title_delete_profile', 'page.php?i=delete-persons-profile&id={content_id}', '', '', 'remove', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 40),
(118, 0, 'bx_persons_view_actions_more', 'bx_persons', 'delete-persons-account', '_bx_persons_menu_item_title_system_delete_account', '_bx_persons_menu_item_title_delete_account', 'page.php?i=account-settings-delete&id={account_id}&content=0', '', '', 'user-times', '', 0, '', '', 0, 128, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 50),
(119, 0, 'bx_persons_view_actions_more', 'bx_persons', 'delete-persons-account-content', '_bx_persons_menu_item_title_system_delete_account_content', '_bx_persons_menu_item_title_delete_account_content', 'page.php?i=account-settings-delete&id={account_id}&content=1', '', '', 'trash', '', 0, '', '', 0, 128, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 60),
(120, 0, 'bx_persons_view_actions_all', 'bx_persons', 'profile-friend-add', '_bx_persons_menu_item_title_system_befriend', '', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 10),
(121, 0, 'bx_persons_view_actions_all', 'bx_persons', 'profile-friend-remove', '_bx_persons_menu_item_title_system_unfriend', '', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 20),
(122, 0, 'bx_persons_view_actions_all', 'bx_persons', 'profile-relation-add', '_bx_persons_menu_item_title_system_relation_add', '', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 23),
(123, 0, 'bx_persons_view_actions_all', 'bx_persons', 'profile-relation-remove', '_bx_persons_menu_item_title_system_relation_delete', '', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 27);
INSERT INTO `sys_menu_items` VALUES
(124, 0, 'bx_persons_view_actions_all', 'bx_persons', 'profile-subscribe-add', '_bx_persons_menu_item_title_system_subscribe', '', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 30),
(125, 0, 'bx_persons_view_actions_all', 'bx_persons', 'profile-subscribe-remove', '_bx_persons_menu_item_title_system_unsubscribe', '', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 40),
(126, 0, 'bx_persons_view_actions_all', 'bx_persons', 'profile-set-acl-level', '_sys_menu_item_title_system_set_acl_level', '', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 50),
(127, 0, 'bx_persons_view_actions_all', 'bx_persons', 'profile-set-badges', '_sys_menu_item_title_system_set_badges', '', '', '', '', '', '', 0, '', '', 0, 192, 'a:2:{s:6:"module";s:10:"bx_persons";s:6:"method";s:19:"is_badges_avaliable";}', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 60),
(128, 0, 'bx_persons_view_actions_all', 'bx_persons', 'comment', '_sys_menu_item_title_system_va_comment', '', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 200),
(129, 0, 'bx_persons_view_actions_all', 'bx_persons', 'view', '_sys_menu_item_title_system_va_view', '', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 210),
(130, 0, 'bx_persons_view_actions_all', 'bx_persons', 'vote', '_sys_menu_item_title_system_va_vote', '', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 215),
(131, 0, 'bx_persons_view_actions_all', 'bx_persons', 'score', '_sys_menu_item_title_system_va_score', '', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 220),
(132, 0, 'bx_persons_view_actions_all', 'bx_persons', 'favorite', '_sys_menu_item_title_system_va_favorite', '', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 230),
(133, 0, 'bx_persons_view_actions_all', 'bx_persons', 'feature', '_sys_menu_item_title_system_va_feature', '', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 240),
(134, 0, 'bx_persons_view_actions_all', 'bx_persons', 'report', '_sys_menu_item_title_system_va_report', '', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 250),
(135, 0, 'bx_persons_view_actions_all', 'bx_persons', 'more-auto', '_sys_menu_item_title_system_va_more_auto', '_sys_menu_item_title_va_more_auto', 'javascript:void(0)', '', '', 'ellipsis-v', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 9999),
(136, 0, 'bx_persons_view_meta', 'bx_persons', 'membership', '_sys_menu_item_title_system_vm_membership', '_sys_menu_item_title_vm_membership', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 10),
(137, 0, 'bx_persons_view_meta', 'bx_persons', 'badges', '_sys_menu_item_title_system_vm_badges', '_sys_menu_item_title_vm_badges', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 20),
(138, 0, 'bx_persons_view_meta', 'bx_persons', 'friends', '_sys_menu_item_title_system_sm_friends', '_sys_menu_item_title_sm_friends', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 23),
(139, 0, 'bx_persons_view_meta', 'bx_persons', 'subscribers', '_sys_menu_item_title_system_sm_subscribers', '_sys_menu_item_title_sm_subscribers', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 25),
(140, 0, 'bx_persons_view_meta', 'bx_persons', 'relations', '_sys_menu_item_title_system_sm_relations', '_sys_menu_item_title_sm_relations', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 27),
(141, 0, 'bx_persons_view_meta', 'bx_persons', 'views', '_sys_menu_item_title_system_sm_views', '_sys_menu_item_title_sm_views', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 30),
(142, 0, 'bx_persons_view_meta', 'bx_persons', 'votes', '_sys_menu_item_title_system_sm_votes', '_sys_menu_item_title_sm_votes', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 40),
(143, 0, 'bx_persons_view_meta', 'bx_persons', 'comments', '_sys_menu_item_title_system_sm_comments', '_sys_menu_item_title_sm_comments', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 50),
(144, 0, 'bx_persons_submenu', 'bx_persons', 'persons-home', '_bx_persons_menu_item_title_system_entries_recent', '_bx_persons_menu_item_title_entries_recent', 'page.php?i=persons-home', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 1),
(145, 0, 'bx_persons_submenu', 'bx_persons', 'persons-active', '_bx_persons_menu_item_title_system_entries_active', '_bx_persons_menu_item_title_entries_active', 'page.php?i=persons-active', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 2),
(146, 0, 'bx_persons_submenu', 'bx_persons', 'persons-online', '_bx_persons_menu_item_title_system_entries_online', '_bx_persons_menu_item_title_entries_online', 'page.php?i=persons-online', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 3),
(147, 0, 'bx_persons_submenu', 'bx_persons', 'persons-search', '_bx_persons_menu_item_title_system_entries_search', '_bx_persons_menu_item_title_entries_search', 'page.php?i=persons-search', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 4),
(148, 0, 'bx_persons_submenu', 'bx_persons', 'persons-manage', '_bx_persons_menu_item_title_system_entries_manage', '_bx_persons_menu_item_title_entries_manage', 'page.php?i=persons-manage', '', '', '', '', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 1, 1, 5),
(149, 0, 'bx_persons_view_submenu', 'bx_persons', 'view-persons-profile', '_bx_persons_menu_item_title_system_view_profile_view', '_bx_persons_menu_item_title_view_profile_view', 'page.php?i=view-persons-profile&id={content_id}', '', '', 'user col-blue3', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 1),
(150, 0, 'bx_persons_view_submenu', 'bx_persons', 'persons-profile-info', '_bx_persons_menu_item_title_system_view_profile_info', '_bx_persons_menu_item_title_view_profile_info', 'page.php?i=persons-profile-info&id={content_id}', '', '', 'info-circle col-gray', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 2),
(151, 0, 'bx_persons_view_submenu', 'bx_persons', 'persons-profile-friends', '_bx_persons_menu_item_title_system_view_profile_friends', '_bx_persons_menu_item_title_view_profile_friends', 'page.php?i=persons-profile-friends&profile_id={profile_id}', '', '', 'users col-blue3', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 3),
(152, 0, 'bx_persons_view_submenu', 'bx_persons', 'persons-profile-relations', '_bx_persons_menu_item_title_system_view_profile_relations', '_bx_persons_menu_item_title_view_profile_relations', 'page.php?i=persons-profile-relations&profile_id={profile_id}', '', '', 'sync col-blue3', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 4),
(153, 0, 'bx_persons_view_submenu', 'bx_persons', 'persons-profile-subscriptions', '_bx_persons_menu_item_title_system_view_profile_subscriptions', '_bx_persons_menu_item_title_view_profile_subscriptions', 'page.php?i=persons-profile-subscriptions&profile_id={profile_id}', '', '', 'check col-blue3', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 5),
(154, 0, 'bx_persons_view_submenu', 'bx_persons', 'persons-profile-comments', '_bx_persons_menu_item_title_system_view_profile_comments', '_bx_persons_menu_item_title_view_profile_comments', 'page.php?i=persons-profile-comments&id={content_id}', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 6),
(155, 0, 'bx_persons_view_submenu', 'bx_persons', 'more-auto', '_bx_persons_menu_item_title_system_view_profile_more_auto', '_bx_persons_menu_item_title_view_profile_more_auto', 'javascript:void(0)', '', '', 'ellipsis-v', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 9999),
(156, 0, 'bx_persons_snippet_meta', 'bx_persons', 'friends-mutual', '_sys_menu_item_title_system_sm_friends_mutual', '_sys_menu_item_title_sm_friends_mutual', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', 'all!recom_friends', 0, 0, '', 0, 0, 1, 0, 0, 1, 0),
(157, 0, 'bx_persons_snippet_meta', 'bx_persons', 'date', '_sys_menu_item_title_system_sm_date', '_sys_menu_item_title_sm_date', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 1),
(158, 0, 'bx_persons_snippet_meta', 'bx_persons', 'tags', '_sys_menu_item_title_system_sm_tags', '_sys_menu_item_title_sm_tags', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 2),
(159, 0, 'bx_persons_snippet_meta', 'bx_persons', 'views', '_sys_menu_item_title_system_sm_views', '_sys_menu_item_title_sm_views', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 3),
(160, 0, 'bx_persons_snippet_meta', 'bx_persons', 'comments', '_sys_menu_item_title_system_sm_comments', '_sys_menu_item_title_sm_comments', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 4),
(161, 0, 'bx_persons_snippet_meta', 'bx_persons', 'friends', '_sys_menu_item_title_system_sm_friends', '_sys_menu_item_title_sm_friends', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', 'recom_friends,recom_subscriptions', 0, 0, '', 0, 0, 1, 0, 0, 1, 5),
(162, 0, 'bx_persons_snippet_meta', 'bx_persons', 'subscribers', '_sys_menu_item_title_system_sm_subscribers', '_sys_menu_item_title_sm_subscribers', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', 'recom_friends', 0, 0, '', 0, 0, 1, 0, 0, 1, 6),
(163, 0, 'bx_persons_snippet_meta', 'bx_persons', 'membership', '_sys_menu_item_title_system_sm_membership', '_sys_menu_item_title_sm_membership', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 7),
(164, 0, 'bx_persons_snippet_meta', 'bx_persons', 'nl', '_sys_menu_item_title_system_sm_nl', '_sys_menu_item_title_sm_nl', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 8),
(165, 0, 'bx_persons_snippet_meta', 'bx_persons', 'befriend', '_sys_menu_item_title_system_sm_befriend', '_sys_menu_item_title_sm_befriend', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', 'recom_subscriptions', 0, 0, '', 0, 0, 1, 0, 0, 1, 9),
(166, 0, 'bx_persons_snippet_meta', 'bx_persons', 'unfriend', '_sys_menu_item_title_system_sm_unfriend', '_sys_menu_item_title_sm_unfriend', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', 'recom_friends,recom_subscriptions', 0, 0, '', 0, 0, 1, 0, 0, 1, 10),
(167, 0, 'bx_persons_snippet_meta', 'bx_persons', 'subscribe', '_sys_menu_item_title_system_sm_subscribe', '_sys_menu_item_title_sm_subscribe', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', 'recom_friends', 0, 0, '', 0, 0, 1, 0, 0, 1, 11),
(168, 0, 'bx_persons_snippet_meta', 'bx_persons', 'unsubscribe', '_sys_menu_item_title_system_sm_unsubscribe', '_sys_menu_item_title_sm_unsubscribe', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', 'recom_friends,recom_subscriptions', 0, 0, '', 0, 0, 1, 0, 0, 1, 12),
(169, 0, 'bx_persons_snippet_meta', 'bx_persons', 'ignore-befriend', '_sys_menu_item_title_system_sm_ignore_befriend', '_sys_menu_item_title_sm_ignore', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', 'all!recom_friends', 0, 0, '', 0, 0, 1, 0, 0, 1, 13),
(170, 0, 'bx_persons_snippet_meta', 'bx_persons', 'ignore-subscribe', '_sys_menu_item_title_system_sm_ignore_subscribe', '_sys_menu_item_title_sm_ignore', '', '', '', '', '', 0, '', '', 0, 2147483647, '', '', 'all!recom_subscriptions', 0, 0, '', 0, 0, 1, 0, 0, 1, 14),
(171, 0, 'sys_account_notifications', 'bx_persons', 'notifications-friend-requests', '_bx_persons_menu_item_title_system_friends', '_bx_persons_menu_item_title_friends', 'page.php?i=persons-profile-friends&profile_id={member_id}', '', '', 'users col-blue3', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"get_unconfirmed_connections_num";s:6:"params";a:1:{i:0;s:20:"sys_profiles_friends";}s:5:"class";s:23:"TemplServiceConnections";}', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 7),
(172, 0, 'sys_account_notifications', 'bx_persons', 'notifications-relation-requests', '_bx_persons_menu_item_title_system_relations', '_bx_persons_menu_item_title_relations', 'page.php?i=persons-profile-relations&profile_id={member_id}', '', '', 'sync col-blue3', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"get_unconfirmed_connections_num";s:6:"params";a:1:{i:0;s:22:"sys_profiles_relations";}s:5:"class";s:23:"TemplServiceConnections";}', 0, '', '', 0, 2147483646, 'a:2:{s:6:"module";s:10:"bx_persons";s:6:"method";s:19:"is_enable_relations";}', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 8),
(173, 0, 'sys_profile_stats', 'bx_persons', 'profile-stats-friend-requests', '_bx_persons_menu_item_title_system_friend_requests', '_bx_persons_menu_item_title_friend_requests', 'page.php?i=persons-profile-friends&profile_id={member_id}', '', '', 'users col-blue3', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:31:"get_unconfirmed_connections_num";s:6:"params";a:1:{i:0;s:20:"sys_profiles_friends";}s:5:"class";s:23:"TemplServiceConnections";}', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 2),
(174, 0, 'sys_profile_stats', 'bx_persons', 'profile-stats-manage-profiles', '_bx_persons_menu_item_title_system_manage_my_profiles', '_bx_persons_menu_item_title_manage_my_profiles', 'page.php?i=persons-manage', '', '_self', 'users col-blue3', 'a:2:{s:6:"module";s:10:"bx_persons";s:6:"method";s:41:"get_menu_addon_manage_tools_profile_stats";}', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 3),
(175, 0, 'sys_profile_stats', 'bx_persons', 'profile-stats-favorite-persons', '_bx_persons_menu_item_title_system_favorites', '_bx_persons_menu_item_title_favorites', 'page.php?i=persons-profile-favorites&profile_id={member_id}', '', '', 'star col-blue3', 'a:2:{s:6:"module";s:10:"bx_persons";s:6:"method";s:38:"get_menu_addon_favorites_profile_stats";}', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 4),
(176, 0, 'sys_profile_stats', 'bx_persons', 'profile-stats-subscriptions', '_bx_persons_menu_item_title_system_subscriptions', '_bx_persons_menu_item_title_subscriptions', 'page.php?i=persons-profile-subscriptions&profile_id={member_id}#subscriptions', '', '_self', 'rss col-blue3', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:25:"get_connected_content_num";s:6:"params";a:1:{i:0;s:26:"sys_profiles_subscriptions";}s:5:"class";s:23:"TemplServiceConnections";}', 0, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 5),
(177, 0, 'sys_profile_stats', 'bx_persons', 'profile-stats-subscribed-me', '_bx_persons_menu_item_title_system_subscribed_me', '_bx_persons_menu_item_title_subscribed_me', 'page.php?i=persons-profile-subscriptions&profile_id={member_id}#subscribers', '', '_self', 'rss col-blue3', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:28:"get_connected_initiators_num";s:6:"params";a:1:{i:0;s:26:"sys_profiles_subscriptions";}s:5:"class";s:23:"TemplServiceConnections";}', 1, '', '', 0, 2147483646, '', '', '', 0, 0, '', 0, 0, 0, 0, 0, 1, 6),
(178, 0, 'sys_profile_stats', 'bx_persons', 'profile-stats-relations', '_bx_persons_menu_item_title_system_relations', '_bx_persons_menu_item_title_relations', 'page.php?i=persons-profile-relations&profile_id={member_id}#relations', '', '_self', 'sync col-blue3', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:25:"get_connected_content_num";s:6:"params";a:3:{i:0;s:22:"sys_profiles_relations";i:1;i:0;i:2;i:1;}s:5:"class";s:23:"TemplServiceConnections";}', 0, '', '', 0, 2147483646, 'a:2:{s:6:"module";s:10:"bx_persons";s:6:"method";s:19:"is_enable_relations";}', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 7),
(179, 0, 'sys_profile_stats', 'bx_persons', 'profile-stats-related-me', '_bx_persons_menu_item_title_system_related_me', '_bx_persons_menu_item_title_related_me', 'page.php?i=persons-profile-relations&profile_id={member_id}#related-me', '', '_self', 'sync col-blue3', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:28:"get_connected_initiators_num";s:6:"params";a:3:{i:0;s:22:"sys_profiles_relations";i:1;i:0;i:2;i:1;}s:5:"class";s:23:"TemplServiceConnections";}', 0, '', '', 0, 2147483646, 'a:2:{s:6:"module";s:10:"bx_persons";s:6:"method";s:19:"is_enable_relations";}', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 8),
(180, 0, 'sys_profile_followings', 'bx_persons', 'persons', '_bx_persons_menu_item_title_system_followings', '_bx_persons_menu_item_title_followings', 'javascript:void(0)', '', '_self', 'users col-blue3', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 1),
(181, 0, 'bx_persons_menu_manage_tools', 'bx_persons', 'clear-reports', '_bx_persons_menu_item_title_system_clear_reports', '_bx_persons_menu_item_title_clear_reports', 'javascript:void(0)', 'javascript:{js_object}.onClickClearReports({content_id});', '_self', 'eraser', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 1),
(182, 0, 'bx_persons_menu_manage_tools', 'bx_persons', 'manage-cf', '_bx_persons_menu_item_title_system_manage_cf', '_bx_persons_menu_item_title_manage_cf', 'javascript:void(0)', 'javascript:{js_object}.onClickManageCf({content_id});', '_self', 'filter', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 6),
(183, 0, 'bx_persons_menu_manage_tools', 'bx_persons', 'delete-with-content', '_bx_persons_menu_item_title_system_delete_with_content', '_bx_persons_menu_item_title_delete_with_content', 'javascript:void(0)', 'javascript:{js_object}.onClickDeleteWithContent({content_id});', '_self', 'far trash-alt', '', 0, '', '', 0, 2147483647, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 99),
(184, 0, 'sys_account_dashboard_manage_tools', 'bx_persons', 'persons-administration', '_bx_persons_menu_item_title_system_admt_persons', '_bx_persons_menu_item_title_admt_persons', 'page.php?i=persons-administration', '', '_self', 'user', 'a:2:{s:6:"module";s:10:"bx_persons";s:6:"method";s:27:"get_menu_addon_manage_tools";}', 0, '', '', 0, 192, '', '', '', 0, 0, '', 0, 0, 1, 0, 0, 1, 3);

-- --------------------------------------------------------

--
-- Table structure for table `sys_menu_sets`
--

CREATE TABLE `sys_menu_sets` (
  `set_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `deletable` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`set_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `sys_menu_sets`
--

INSERT INTO `sys_menu_sets` VALUES
('sys_site', 'system', '_sys_menu_set_title_site', 0),
('sys_application', 'system', '_sys_menu_set_title_application', 0),
('sys_homepage', 'system', '_sys_menu_set_title_homepage', 0),
('sys_homepage_submenu', 'system', '_sys_menu_set_title_homepage_submenu', 0),
('sys_site_panel', 'system', '_sys_menu_set_title_panel', 0),
('sys_footer', 'system', '_sys_menu_set_title_footer', 0),
('sys_toolbar_site', 'system', '_sys_menu_set_title_toolbar_site', 0),
('sys_toolbar_member', 'system', '_sys_menu_set_title_toolbar_member', 0),
('sys_account_popup', 'system', '_sys_menu_set_title_account_popup', 0),
('sys_account_notifications', 'system', '_sys_menu_set_title_account_notifications', 0),
('sys_add_content_links', 'system', '_sys_menu_set_title_add_content', 0),
('sys_dashboard_content_manage', 'system', '_sys_menu_set_title_dashboard_content_manage', 0),
('sys_dashboard_reports_manage', 'system', '_sys_menu_set_title_dashboard_reports_manage', 0),
('sys_add_profile_links', 'system', '_sys_menu_set_title_add_profile', 0),
('sys_account_dashboard', 'system', '_sys_menu_set_title_account_dashboard', 0),
('sys_account_dashboard_manage_tools', 'system', '_sys_menu_set_title_account_dashboard_manage_tools', 0),
('sys_account_settings', 'system', '_sys_menu_set_title_account_settings', 0),
('sys_profiles_create', 'system', '_sys_menu_set_title_profile_create_links', 0),
('sys_profile_stats', 'system', '_sys_menu_set_title_profile_stats', 0),
('sys_profile_followings', 'system', '_sys_menu_set_title_profile_followings', 0),
('sys_cmts_item_manage', 'system', '_sys_menu_set_title_cmts_item_manage', 0),
('sys_cmts_item_actions', 'system', '_sys_menu_set_title_cmts_item_actions', 0),
('sys_cmts_item_counters', 'system', '_sys_menu_set_title_cmts_item_counters', 0),
('sys_cmts_item_meta', 'system', '_sys_menu_set_title_cmts_item_meta', 0),
('sys_switch_language', 'system', '_sys_menu_set_title_switch_language', 0),
('sys_switch_template', 'system', '_sys_menu_set_title_switch_template', 0),
('sys_social_sharing', 'system', '_sys_menu_set_title_sys_social_sharing', 0),
('sys_wiki', 'system', '_sys_menu_set_title_sys_wiki', 0),
('sys_favorite_list', 'system', '_sys_menu_set_title_sys_favorite_list', 0),
('sys_con_submenu', 'system', '_sys_menu_set_title_con_submenu', 0),
('sys_studio_account_popup', 'system', '_sys_menu_set_title_studio_account_popup', 0),
('bx_persons_view_actions', 'bx_persons', '_bx_persons_menu_set_title_view_profile_actions', 0),
('bx_persons_view_actions_more', 'bx_persons', '_bx_persons_menu_set_title_view_profile_actions_more', 0),
('bx_persons_view_actions_all', 'bx_persons', '_sys_menu_set_title_view_actions', 0),
('bx_persons_view_meta', 'bx_persons', '_bx_persons_menu_set_title_view_profile_meta', 0),
('bx_persons_submenu', 'bx_persons', '_bx_persons_menu_set_title_submenu', 0),
('bx_persons_view_submenu', 'bx_persons', '_bx_persons_menu_set_title_view_profile_submenu', 0),
('bx_persons_snippet_meta', 'bx_persons', '_sys_menu_set_title_snippet_meta', 0),
('bx_persons_menu_manage_tools', 'bx_persons', '_bx_persons_menu_set_title_manage_tools', 0);

-- --------------------------------------------------------

--
-- Table structure for table `sys_menu_templates`
--

CREATE TABLE `sys_menu_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1625 ;

--
-- Dumping data for table `sys_menu_templates`
--

INSERT INTO `sys_menu_templates` VALUES
(1, 'menu_empty.html', '_sys_menu_template_title_empty', 1),
(2, 'menu_footer.html', '_sys_menu_template_title_footer', 0),
(3, 'menu_horizontal.html', '_sys_menu_template_title_hor', 1),
(4, 'menu_vertical_lite.html', '_sys_menu_template_title_ver_lite', 1),
(5, 'menu_toolbar.html', '_sys_menu_template_title_toolbar', 0),
(6, 'menu_vertical.html', '_sys_menu_template_title_ver', 1),
(7, 'menu_floating_blocks.html', '_sys_menu_template_title_floating_blocks', 1),
(8, 'menu_main_submenu.html', '_sys_menu_template_title_main_submenu', 0),
(9, 'menu_buttons_hor.html', '_sys_menu_template_title_buttons_hor', 1),
(10, 'menu_inline.html', '_sys_menu_template_title_inline', 1),
(11, 'menu_interactive_vertical.html', '_sys_menu_template_title_interactive_vertical', 0),
(12, 'menu_account_popup.html', '_sys_menu_template_title_account_popup', 0),
(13, 'menu_account_notifications.html', '_sys_menu_template_title_account_notifications', 0),
(14, 'menu_floating_blocks_big.html', '_sys_menu_template_title_floating_blocks_big', 1),
(15, 'menu_custom_hor.html', '_sys_menu_template_title_custom_hor', 0),
(16, 'menu_buttons_ver.html', '_sys_menu_template_title_buttons_ver', 1),
(17, 'menu_inline_sbtn.html', '_sys_menu_template_title_inline_sbtn', 1),
(18, 'menu_main_submenu_more_auto.html', '_sys_menu_template_title_main_submenu_more_auto', 0),
(19, 'menu_floating_blocks_wide.html', '_sys_menu_template_title_floating_blocks_wide', 0),
(20, 'menu_custom_ver.html', '_sys_menu_template_title_custom_ver', 0),
(21, 'menu_vertical_more_less.html', '_sys_menu_template_title_vertical_more_less', 0),
(22, 'menu_interactive.html', '_sys_menu_template_title_interactive', 0),
(23, 'menu_buttons_icon_hor.html', '_sys_menu_template_title_buttons_icon_hor', 1),
(24, 'menu_floating_blocks_dash.html', '_sys_menu_template_title_floating_blocks_dash', 0),
(25, 'menu_block_submenu_hor.html', '_sys_menu_template_title_block_submenu_hor', 1),
(26, 'menu_block_submenu_ver.html', '_sys_menu_template_title_block_submenu_ver', 1),
(27, 'menu_profile_followings.html', '_sys_menu_template_title_profile_followings', 0),
(28, 'menu_main.html', '_sys_menu_template_title_main', 0),
(29, 'menu_add_content.html', '_sys_menu_template_title_add_content', 0),
(30, 'menu_panel.html', '_sys_menu_template_title_panel', 0),
(31, 'menu_main_in_panel.html', '_sys_menu_template_title_main_in_panel', 0),
(32, 'menu_multilevel.html', '_sys_menu_template_title_multilevel', 1),
(1624, 'menu_sidebar_site.html', '_bx_artificer_menu_template_title_sidebar_site', 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_modules`
--

CREATE TABLE `sys_modules` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'module',
  `subtypes` int(11) unsigned NOT NULL DEFAULT '0',
  `name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `vendor` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `help_url` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `uri` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `class_prefix` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `db_prefix` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lang_category` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `dependencies` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `date` int(11) unsigned NOT NULL DEFAULT '0',
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `pending_uninstall` tinyint(4) NOT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `updated` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `uri` (`uri`),
  UNIQUE KEY `class_prefix` (`class_prefix`),
  UNIQUE KEY `db_prefix` (`db_prefix`),
  UNIQUE KEY `path` (`path`(191))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `sys_modules`
--

INSERT INTO `sys_modules` VALUES
(1, 'module', 0, 'system', 'System', 'UNA, Inc', '14.0.0', '', '', 'system', 'Bx', 'sys_', 'System', '', [[timestamp]], 1, 0, '', 0),
(2, 'language', 0, 'bx_en', 'English', 'UNA INC', '14.0.9', 'http://feed.una.io/?section={module_name}', 'boonex/english/', 'en', 'BxEng', 'bx_eng_', 'BoonEx English', '', [[timestamp]], 1, 0, '', 0),
(3, 'template', 0, 'bx_artificer', 'Artificer', 'UNA INC', '14.0.9', 'http://feed.una.io/?section={module_name}', 'boonex/artificer/', 'artificer', 'BxArtificer', 'bx_artificer_', 'Boonex Artificer Template', '', [[timestamp]], 1, 0, '', 0),
(4, 'module', 2, 'bx_persons', 'Persons', 'UNA INC', '14.0.6', 'http://feed.una.io/?section={module_name}', 'boonex/persons/', 'persons', 'BxPersons', 'bx_persons_', 'Persons', '', [[timestamp]], 1, 0, '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `sys_modules_file_tracks`
--

CREATE TABLE `sys_modules_file_tracks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `module_id` int(11) unsigned NOT NULL DEFAULT '0',
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hash` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2277 ;

--
-- Dumping data for table `sys_modules_file_tracks`
--

INSERT INTO `sys_modules_file_tracks` VALUES
(1, 2, 'data/langs/system/en.xml', 'fe267f5efa05e8d75beb5a2d08e1352f'),
(2, 2, 'template/images/icons/std-icon.svg', '13174038a8def9a0608d5e9aecfd7744'),
(3, 3, 'classes/BxArtificerAlertsResponse.php', '8ded87de8989c371c53a1dead42fadc2'),
(4, 3, 'classes/BxArtificerConfig.php', '01084aab48fe3de81cc6cb7903c6e5a0'),
(5, 3, 'classes/BxArtificerDb.php', '4ad43ddccea64b2a78ee52e2210824f9'),
(6, 3, 'classes/BxArtificerModule.php', 'dd6706b2e6b79c2e7cf35e2d1c13cc81'),
(7, 3, 'classes/BxArtificerStudioOptions.php', '3732ceec20e34693b6b400494f7adc71'),
(8, 3, 'classes/BxArtificerStudioPage.php', '277e37163dd858d62d60976bd91eefd2'),
(9, 3, 'classes/BxArtificerTemplate.php', 'ce88a89d7d0a876a4d424ce1f943284d'),
(10, 3, 'data/template/bx_files/css/main.css', 'ced3dcd4914401d53a6e37b988530199'),
(11, 3, 'data/template/bx_forum/comment_attachments.html', 'b28f6e5a8b62483a97c24dd93acb5d3e'),
(12, 3, 'data/template/bx_forum/css/main.css', '11f34155323401b17399fb05eda999f0'),
(13, 3, 'data/template/bx_forum/menu_custom_hor_bx_forum_snippet_meta_main.html', '3e01dbbf7db40e02fa851fba1222cc55'),
(14, 3, 'data/template/bx_forum/participants.html', 'f44bd1a01a6f19f94f4047c9a048b151'),
(15, 3, 'data/template/bx_forum/score_do_vote_label.html', 'c8caf28cc63a98ace4e133780b2fbd5f'),
(16, 3, 'data/template/bx_forum/unit.html', '17cb4c4161660afd024b5463b00f574d'),
(17, 3, 'data/template/bx_forum/unit_gallery.html', 'd291a0818c11f88980a10f5ed40ab6fe'),
(18, 3, 'data/template/bx_market/attachments.html', 'ab0b666098da39d10cd0fae8c6299fbe'),
(19, 3, 'data/template/bx_market/css/forms.css', '3f86ab3a3cb6dfe31b515314ab10a69a'),
(20, 3, 'data/template/bx_market/css/main.css', '51ccb0c09cc3165f519481e7d5ff4b83'),
(21, 3, 'data/template/bx_notifications/css/view.css', '120b9e54ef82aac83094b52ae275fc05'),
(22, 3, 'data/template/bx_notifications/menu_custom_ver.html', '7e04f0ed34f571643b9cb9b69674624c'),
(23, 3, 'data/template/bx_notifications/menu_preview.html', '21dcd401fa2bdccc1d4afb2f846c4de9'),
(24, 3, 'data/template/bx_organizations/cover.html', '2b6d7f33ec201d68a5499f93798968c0'),
(25, 3, 'data/template/bx_organizations/unit.html', 'cf9f768b7bb192d3b12c8c4bae475c01'),
(26, 3, 'data/template/bx_persons/css/main.css', 'dbee97fd0bb11b1ea05e5dc639a2cab7'),
(27, 3, 'data/template/bx_polls/css/forms.css', 'd7342b1a4a6978329204720551b45a12'),
(28, 3, 'data/template/bx_polls/css/main.css', '9c38a2c4bd715f3fb79d0c4b015d8fc4'),
(29, 3, 'data/template/bx_shopify/entry-buy.html', '0512cdbe57731eacb22690095b6ad843'),
(30, 3, 'data/template/bx_snipcart/sct_button.html', 'c4435c7647ddf377d938979e92fce299'),
(31, 3, 'data/template/bx_timeline/comments.html', '4e00af65e955d78ba17b89827011e939'),
(32, 3, 'data/template/bx_timeline/css/view.css', 'fe77a7a55d7ae1a2990b9aa8976c1a16'),
(33, 3, 'data/template/bx_timeline/item_outline.html', 'c7e6c61c3ecc5b4cdb6c73d214c4295c'),
(34, 3, 'data/template/bx_timeline/item_timeline.html', '7cfb2709ee438e8eb2279b1f257edb6e'),
(35, 3, 'data/template/bx_timeline/menu_custom_hor.html', '524bf054a6d8a84a56da9bc7bdd07df7'),
(36, 3, 'data/template/bx_timeline/menu_custom_hor_bx_timeline_menu_item_actions.html', '2db70de4c62b024466aff008db97e274'),
(37, 3, 'data/template/bx_timeline/menu_custom_item_bx_timeline_menu_view.html', '419bc9896d1840bcfa1055ef0b7ff979'),
(38, 3, 'data/template/bx_timeline/menu_custom_item_hor.html', '49f23a504c9dd714085a273c3fd5bf77'),
(39, 3, 'data/template/bx_timeline/menu_custom_item_ver.html', '7649d75664d592d92e61e5d3da195357'),
(40, 3, 'data/template/bx_timeline/menu_custom_ver.html', '199fb843d88dcf06dd79c183c635392f'),
(41, 3, 'data/template/bx_timeline/menu_custom_ver_bx_timeline_menu_feeds.html', '7e04f0ed34f571643b9cb9b69674624c'),
(42, 3, 'data/template/bx_timeline/menu_custom_ver_bx_timeline_menu_item_manage.html', '2d7a45ffdfd6934f2f7a1d1ab98c3b19'),
(43, 3, 'data/template/bx_timeline/menu_feeds.html', '1c0319e9a3f0dd4f290c291506bfe31f'),
(44, 3, 'data/template/bx_timeline/menu_feeds_subitems.html', 'd6a4e9041d8a784a5f773265884ad0c2'),
(45, 3, 'data/template/bx_timeline/menu_vertical_bx_timeline_menu_item_share.html', 'f5f59247fa7294c8acce05209cfad3bb'),
(46, 3, 'data/template/mod_general/css/forms.css', '8f6559cd35713d6c7fdbd1c1fb5dbdd3'),
(47, 3, 'data/template/mod_general/css/main.css', '628cfd5b6896caf93c69380333cc7534'),
(48, 3, 'data/template/mod_groups/cover.html', '5f8326126e579ba942056a5ab2ad8277'),
(49, 3, 'data/template/mod_groups/cover_block.html', '57e3e125b44d76bb8bd3221e3f10aa72'),
(50, 3, 'data/template/mod_groups/css/main.css', 'e19d520b2871d1a57ea1ef8852e63f21'),
(51, 3, 'data/template/mod_profile/cover.html', '34c492c8bc6b9c5d09243ec132086939'),
(52, 3, 'data/template/mod_profile/cover_block.html', 'a10e3159009de7e5236c68d2f4118f18'),
(53, 3, 'data/template/mod_profile/css/main.css', '87619df79a51d61d1cc09432527a012c'),
(54, 3, 'data/template/mod_profile/menu_custom_actions.html', '1d678922229124c30361bc3a019401ee'),
(55, 3, 'data/template/mod_profile/menu_custom_item_actions.html', 'b36ede9d649f9f6e325e18d020b69aea'),
(56, 3, 'data/template/mod_text/author.html', '4690d1853ae5f31a92c9b6f665e04d88'),
(57, 3, 'data/template/mod_text/css/forms.css', '1c636c97baf50fd59b83beace9625870'),
(58, 3, 'data/template/mod_text/css/main.css', '4e08fe3532d78f568dfca62cbfe6060f'),
(59, 3, 'data/template/mod_text/css/polls.css', '96535f603fff695e1a23a975f88a8981'),
(60, 3, 'data/template/mod_text/menu_custom_actions.html', '098deae0479689a322bba9ed6c9ee8d5'),
(61, 3, 'data/template/mod_text/menu_custom_item_actions.html', 'd89de8fad84796fea6dbf2c36ae640a7'),
(62, 3, 'data/template/system/block_join.html', 'f29dc4ddaa0004fb56bc9a5780738492'),
(63, 3, 'data/template/system/block_login.html', '874925aa3a3f4fb96da897345190dee1'),
(64, 3, 'data/template/system/cover.html', '3c3d0322aa64d38afef529bea436bae3'),
(65, 3, 'data/template/system/cover_home.html', '1d089b47de8dac2995043426bdd3ca4f'),
(66, 3, 'data/template/system/css/common.css', 'f4c4aa3ddff2b8f861beec6da872d9a6'),
(67, 3, 'data/template/system/css/cover.css', '92a4237a88652ed466d28ed716137c45'),
(68, 3, 'data/template/system/css/default.less', '436c99a4af14a41499820f88df6f0c05'),
(69, 3, 'data/template/system/css/editor.less', '83003fa702cb6ff037819e319dccec05'),
(70, 3, 'data/template/system/css/forms.css', '7fe45c2291ac4b5b419e7cb8e9c9bdec'),
(71, 3, 'data/template/system/css/general.css', '0eeeeec8d8bdc94f2a765f8408f7c172'),
(72, 3, 'data/template/system/css/label.css', 'c8c0e4f458f9b675f4a0f49d445e8de6'),
(73, 3, 'data/template/system/css/media-phone.css', '73054f2815106d5a1bce1867f12452fa'),
(74, 3, 'data/template/system/css/media-tablet.css', '10888f5caa0eda700898979a9036e203'),
(75, 3, 'data/template/system/css/menu-sidebar.css', '6db866b555e16f78915d9930de0145dd'),
(76, 3, 'data/template/system/css/menu.css', 'c73808206fe3698e03e9456b5cc1b5c0'),
(77, 3, 'data/template/system/css/paginate.css', '7d4699de85870a7f88b5be5eda43f798'),
(78, 3, 'data/template/system/images/cover-default-dark.svg', '1a2ace8a745d8552746b8accab9807d0'),
(79, 3, 'data/template/system/images/cover-default.svg', '8ddd9944ef24da2058639e7fcea019ba'),
(80, 3, 'data/template/system/images/cover-homepage.svg', '2dae8db052883c27bc440df947c33954'),
(81, 3, 'data/template/system/images/cover.svg', '2772a63a2dfe1c5bdcf4c0645d94a9c0'),
(82, 3, 'data/template/system/images/logo-dark-generic.svg', 'db30ee9b2d17dee4aed1d765c3cf3708'),
(83, 3, 'data/template/system/images/logo-generic.svg', 'db30ee9b2d17dee4aed1d765c3cf3708'),
(84, 3, 'data/template/system/images/mark-dark-generic.svg', '579338d955296ca2172975efe986d83f'),
(85, 3, 'data/template/system/images/mark-generic.svg', '579338d955296ca2172975efe986d83f'),
(86, 3, 'data/template/system/logo_main.html', '3aa7b295d29c671e5be54ec58ad082de'),
(87, 3, 'data/template/system/map_profile_active.html', '2e21748ad6a0b3700da87a0978e80b71'),
(88, 3, 'data/template/system/menu_account_popup.html', '927cf134ebedf388d0bfb3f871075216'),
(89, 3, 'data/template/system/menu_add_content.html', '43d52ae758ba54e9b2ff23fcd0f86eea'),
(90, 3, 'data/template/system/menu_custom_hor_sys_cmts_item_actions.html', '225bc499d6871fc854699920499bec84'),
(91, 3, 'data/template/system/menu_custom_hor_sys_cmts_item_meta.html', '54c071fd8a3e0d7c3e4bff0a5d020464'),
(92, 3, 'data/template/system/menu_custom_item.html', '6047aa52befa583582aa71a1bdef880e'),
(93, 3, 'data/template/system/menu_custom_item_sys_cmts_item_actions.html', '11623cbe15352fc18c64e109706d6c06'),
(94, 3, 'data/template/system/menu_custom_item_sys_cmts_item_manage.html', '94fa48f88e10c78cfab5f1260ca240d3'),
(95, 3, 'data/template/system/menu_custom_item_sys_create_post.html', '498b86bb431ac9ef1b39a606ca003067'),
(96, 3, 'data/template/system/menu_custom_ver_sys_cmts_item_manage.html', 'f82ee2fa161cc4bee3be9e0437d01517'),
(97, 3, 'data/template/system/menu_floating_blocks.html', '22fd0f55847a6479f31c1ed953b07a45'),
(98, 3, 'data/template/system/menu_floating_blocks_big.html', '2967a2807d1094b2cedf956f2be72cb0'),
(99, 3, 'data/template/system/menu_floating_blocks_dash.html', '6b11909b77147af11028377a1b249f16'),
(100, 3, 'data/template/system/menu_floating_blocks_wide.html', '72392a4c2ee8b4c1a5b396e3e58ab6a3'),
(101, 3, 'data/template/system/menu_footer.html', '3d680674d106fd271ffc2e813f7c5baa'),
(102, 3, 'data/template/system/menu_horizontal.html', '5dee1ac6e3a550af49cfe613dc726fcd'),
(103, 3, 'data/template/system/menu_interactive.html', 'e3efbc57b7f158a83e430c94e0e5f27b'),
(104, 3, 'data/template/system/menu_main.html', 'fed0230950bcd048fd5b1471459a3f50'),
(105, 3, 'data/template/system/menu_main_inline.html', 'b8b240e0796519cd468aeaf43aeec91f'),
(106, 3, 'data/template/system/menu_main_popup.html', '990f3a0eaf3e4c224bb58bbc4995f701'),
(107, 3, 'data/template/system/menu_main_submenu.html', '0e805c40a826276078362a42fbb62495'),
(108, 3, 'data/template/system/menu_main_submenu_more_auto.html', 'bc52862a864217d88b596f825bc5b488'),
(109, 3, 'data/template/system/menu_meta_item.html', '6f9ebfae56b2793d229f714ae1de053a'),
(110, 3, 'data/template/system/menu_panel.html', '69e1f4fb18a222eef6403bcd93468cc7'),
(111, 3, 'data/template/system/menu_profile_followings.html', '147317cf2037c5375948dd1e7c500842'),
(112, 3, 'data/template/system/menu_profile_followings_subitems.html', '5eee3661f754295578510fd931b49237'),
(113, 3, 'data/template/system/menu_sidebar_site.html', '31d98b4a16cfb544c4a79ce61db1abaa'),
(114, 3, 'data/template/system/menu_toolbar.html', '16ad92824f9456a8ade8cb18773d3dc0'),
(115, 3, 'data/template/system/menu_vertical.html', 'ebe75d006fb20f1d4f5729401d44e40e'),
(116, 3, 'data/template/system/menu_vertical_lite.html', '73e85c4493f5353d270e226c340eb031'),
(117, 3, 'data/template/system/menu_vertical_more_less.html', 'af6049e1219214bf8426a5267ae11e22'),
(118, 3, 'data/template/system/popup_box.html', '71407494d4bc0b304c69433c140b6ce5'),
(119, 3, 'data/template/system/profile_avatar.html', '106dcf11a469c1590544a3e44669c9ff'),
(120, 3, 'data/template/system/profile_stats.html', 'ea5945350e464c5d5e80412e8d59fa0f'),
(121, 3, 'data/template/system/pt_application.html', '7583cddc2cfe01e087f97381144d4d2e'),
(122, 3, 'data/template/system/scripts/BxTemplCmtsMenuUnitMeta.php', '4d835e268187d9d31456cec59164413d'),
(123, 3, 'data/template/system/scripts/BxTemplConfig.php', '5183d6f7ec0b87eceb678a94cf1a07bf'),
(124, 3, 'data/template/system/scripts/BxTemplFormView.php', 'a37af29ad9c2a9ed9eae2fe9e36937ac'),
(125, 3, 'data/template/system/scripts/BxTemplFunctions.php', 'bdc5619d2e16cf227571f8b6b5047023'),
(126, 3, 'data/template/system/scripts/BxTemplMenu.php', 'd014aafa99dcc1eff3b6dc2b300b58a6'),
(127, 3, 'data/template/system/scripts/BxTemplMenuAccountNotifications.php', '0d7abb753ec4e930f1fde6ddc87d71da'),
(128, 3, 'data/template/system/scripts/BxTemplMenuAccountPopup.php', '69bbf8532c9d218b351f057435854596'),
(129, 3, 'data/template/system/scripts/BxTemplMenuCustom.php', '725ef0ae0c683beed2ecd80f0896d91b'),
(130, 3, 'data/template/system/scripts/BxTemplMenuSidebarSite.php', '2c40c8705167138255d5ccdf78029863'),
(131, 3, 'data/template/system/scripts/BxTemplMenuSite.php', '113a306e112d2f02ba8bce4a11af42da'),
(132, 3, 'data/template/system/scripts/BxTemplMenuToolbar.php', 'ac0ec910456b0b170683c80d0ded96e4'),
(133, 3, 'data/template/system/scripts/BxTemplName.php', 'cbe897e046bf93d87de25c9628d01699'),
(134, 3, 'data/template/system/scripts/BxTemplPage.php', '07bc96391eef7128a1a69ac3f8b34707'),
(135, 3, 'data/template/system/scripts/BxTemplPageHome.php', '6b15e6059e5cf7b0745bad3335686ce6'),
(136, 3, 'data/template/system/scripts/BxTemplSearch.php', 'be42aac2ffa1f350b993470a7bcc9502'),
(137, 3, 'data/template/system/scripts/BxTemplSearchResult.php', '1bd5dc591dead6f6e62bfa8765544dfe'),
(138, 3, 'data/template/system/scripts/BxTemplServiceProfiles.php', '4a9e96a7627817ce092a603057b580f4'),
(139, 3, 'data/template/system/search.html', 'd8beaaab972166e8a1c6dc4bbbd64105'),
(140, 3, 'data/template/system/search_pages_results_live.html', 'e1bb93b3b44f03c07aa373060716de0d'),
(141, 3, 'data/template/system/search_result.html', '255cbbc5f71352ed9c3e1bc44d2b297e'),
(142, 3, 'data/template/system/sidebar_account.html', 'c6728c959f6f20f77ae7eb86dd92d8ca'),
(143, 3, 'data/template/system/sidebar_site.html', 'bbd9967de4b19df74c8f349ed45608ab'),
(144, 3, 'data/template/system/_block_explore.html', '0e7e7010f845ab0dc902cc0af3c43d4a'),
(145, 3, 'data/template/system/_block_splash.html', '5e4600d452396dcbc7102fa1a2afd8f6'),
(146, 3, 'data/template/system/_header_js_custom.html', 'd30dbd2a8510794c41738989a43df971'),
(147, 3, 'data/template/system/_header_js_spinner.html', 'd46b43d231c328fdf38f670f7d8bdd25'),
(148, 3, 'data/template/system/_header_meta.html', '4a82b74bf57c8f6aca8cd66c9cd7da1c'),
(149, 3, 'js/menu_site.js', 'ad1c008f379217409b029365be9e5d9a'),
(150, 3, 'js/sidebar.js', '127b6936b7d1c80ee4997770ff30a8f6'),
(151, 3, 'js/utils.js', '76677cd403b20012c1f113c994927595'),
(152, 3, 'template/color_scheme_switcher.html', '4b6ac5c86c8d5edf36eac9d2ce0ce091'),
(153, 3, 'template/css/main.css', 'dcf6ff605403ef3e45d3110afc669526'),
(154, 3, 'template/header.html', '9488ea1ef7bbd3073128547c2a2482bf'),
(155, 3, 'template/images/icons/std-icon.svg', '807c313eb3032d99afdfd27bcb020b7a'),
(156, 4, 'classes/BxPersonsAlertsResponse.php', '298a284ff0c25187d93e5f25f14ed0cf'),
(157, 4, 'classes/BxPersonsCmts.php', '12c30432ec9957a3e838686bb947294f'),
(158, 4, 'classes/BxPersonsCmtsSearchResult.php', 'f7287d75c600c829f470340e032bf105'),
(159, 4, 'classes/BxPersonsConfig.php', '22c4d1901ee2abe734868d5d2e6f0706'),
(160, 4, 'classes/BxPersonsDb.php', '770dc7bda9d0832ac0359c015e5e972d'),
(161, 4, 'classes/BxPersonsFavorite.php', 'f6694dab2fe6aaf6e35453af7fb9ab52'),
(162, 4, 'classes/BxPersonsFormEntry.php', '69c4778c0660f8d26de39f4bb905543f'),
(163, 4, 'classes/BxPersonsFormsEntryHelper.php', '6247e941005df3e5f68bf4e431e2b2bb'),
(164, 4, 'classes/BxPersonsGridAdministration.php', '0e22e91dfe1094b3a0105517723a7ca2'),
(165, 4, 'classes/BxPersonsGridCommon.php', 'ee0ccc0c0fb82e2b85dfc0580185291d'),
(166, 4, 'classes/BxPersonsMenuManageTools.php', '286071cba87bafa3ce0c61b9b268a0a1'),
(167, 4, 'classes/BxPersonsMenuSnippetMeta.php', '0764b200ba0fa4a914a4648f62650357'),
(168, 4, 'classes/BxPersonsMenuView.php', '9c39e07d2b9ca95cd8e270108091c1a2'),
(169, 4, 'classes/BxPersonsMenuViewActions.php', 'f3c13c2f34fc8716340b0a28a41c283c'),
(170, 4, 'classes/BxPersonsMenuViewActionsAll.php', 'b080a755586d511ae8aec9cab88062ab'),
(171, 4, 'classes/BxPersonsMenuViewMeta.php', 'f59035dd79f2bf0a7ca44eb65b6cc64a'),
(172, 4, 'classes/BxPersonsModule.php', '7ed6b3fd0818969b04fd365582219f74'),
(173, 4, 'classes/BxPersonsPageBrowse.php', '452c04eaa409b2b39a918c0ad51f4bd9'),
(174, 4, 'classes/BxPersonsPageEntry.php', 'f38f2746ebaf8380eabf6ea0e4714c28'),
(175, 4, 'classes/BxPersonsPrivacy.php', '1d5d1c02bc30feee8035d4b65da6c55e'),
(176, 4, 'classes/BxPersonsPrivacyContact.php', '9d1063e7b1ba37b7d0208b0a7e0ddd4b'),
(177, 4, 'classes/BxPersonsPrivacyPost.php', '227e0e8aff2456514b14264b9160ec4c'),
(178, 4, 'classes/BxPersonsReport.php', '40ad301471d8bccc664109a2af432f21'),
(179, 4, 'classes/BxPersonsSearchResult.php', '0c9a7d86591b6b57ca74cf6d0e63c1cb'),
(180, 4, 'classes/BxPersonsTemplate.php', 'd08a94cdd88566da09c2b7cbf2591b43'),
(181, 4, 'classes/BxPersonsUploaderCoverCrop.php', 'd5bd673ac4408c594099f590668e53c5'),
(182, 4, 'classes/BxPersonsUploaderPictureCrop.php', '57f103d8dc4ce2d78918fab1fc04fb29'),
(183, 4, 'classes/BxPersonsVote.php', '960b0816783c1f3325b2dd3a003a07cd'),
(184, 4, 'js/manage_tools.js', '58644208f4ac221fa342269a32dc9da5'),
(185, 4, 'request.php', '4d164a855bc5923c9d382e929db953ea'),
(186, 4, 'template/images/icons/std-icon.svg', '42970957dcf8650b3e72d7884eb20a43'),
(187, 4, 'template/images/no-picture.png', '4cc485f6b9e5723df5baf0bb08bae9ae'),
(188, 4, 'template/images/no-picture.svg', 'ef6d574ee3d6ea596dff9a2561e2e5d8'),
(189, 0, 'inc/classes/BxDol.php', 'c5953b783a03956bf569f4218a6605da'),
(190, 0, 'inc/classes/BxDolAccount.php', 'ed325bff601de3fbe2fb8870217e0a55'),
(191, 0, 'inc/classes/BxDolAccountQuery.php', '0e1155b5b25d61e36ca88e6b1e6b0416'),
(192, 0, 'inc/classes/BxDolAcl.php', '7f6fb66c37ea196ee613518f2ae761e2'),
(193, 0, 'inc/classes/BxDolAclQuery.php', '9e0c4d52e1a94aa0e35195aa7b2180ae'),
(194, 0, 'inc/classes/BxDolAI.php', '3ee2f6bc8833adc8eb03f52988bfa400'),
(195, 0, 'inc/classes/BxDolAIAssistant.php', 'a3b295c524739f1645830397b8d1431f'),
(196, 0, 'inc/classes/BxDolAIModel.php', '862f5def2fa6b31b1f84fbf083d46322'),
(197, 0, 'inc/classes/BxDolAIModelGpt35.php', '4dca5a6e937cbd92b20f98ea3905250b'),
(198, 0, 'inc/classes/BxDolAIModelGpt40.php', 'c98de3803e87291e3c4e0eb293f286fd'),
(199, 0, 'inc/classes/BxDolAIProvider.php', '377e5f9bee8ff257f7ee753ab3f6df0c'),
(200, 0, 'inc/classes/BxDolAIProviderShopifyAdmin.php', 'fd36df83dcfde6b816b2c094a68f62b2'),
(201, 0, 'inc/classes/BxDolAIQuery.php', 'b651f53cffa8695c4aab39cb0fc1a40c'),
(202, 0, 'inc/classes/BxDolAlerts.php', 'ada414ebbffa725be0703e1728273ed8'),
(203, 0, 'inc/classes/BxDolApiQuery.php', 'aefa764fc73d0fba51056cb5f4bf23f2'),
(204, 0, 'inc/classes/BxDolAuditGrid.php', '96f9102166fe1b03570c485752cabafb'),
(205, 0, 'inc/classes/BxDolAuditQuery.php', '7c5b48d5ac02c38d297ec302c2ed5758'),
(206, 0, 'inc/classes/BxDolBackgroundJobs.php', '1ccdc003a3a4982d38bfc8f443da6eb4'),
(207, 0, 'inc/classes/BxDolBackgroundJobsQuery.php', '8e850bd751eaa0b1ca914ed7fd995481'),
(208, 0, 'inc/classes/BxDolBadges.php', '2a9ba110157bdc0eed48fdb8e2df3b98'),
(209, 0, 'inc/classes/BxDolBadgesQuery.php', 'f742c4a318299f7b6ae3a6b5315e1c2d'),
(210, 0, 'inc/classes/BxDolBan.php', '77e7f160a7748260f3f477937b768646'),
(211, 0, 'inc/classes/BxDolCache.php', '301d26cc3fede812dba5ae3f8637c330'),
(212, 0, 'inc/classes/BxDolCacheAPC.php', '53ad879f1523f84a6f39fa223ecaf6f7'),
(213, 0, 'inc/classes/BxDolCacheFile.php', '0382e300155d7685c7978818e50fe493'),
(214, 0, 'inc/classes/BxDolCacheFileHtml.php', '9db935753b9757df176e270115e25e53'),
(215, 0, 'inc/classes/BxDolCacheMemcache.php', '702fce8b9daf5f9ebff7e409d68dbbe1'),
(216, 0, 'inc/classes/BxDolCacheUtilities.php', '289cd94b66a05f9ddc9822e40f0b5dd9'),
(217, 0, 'inc/classes/BxDolCacheXCache.php', '172bf6927b8424a4a62bd6d9b1900869'),
(218, 0, 'inc/classes/BxDolCalendar.php', 'cd5c5e89dfde5e09376cf4d288eb2da7'),
(219, 0, 'inc/classes/BxDolCaptcha.php', '2cb4a39584d7538dbb727284d721ed1a'),
(220, 0, 'inc/classes/BxDolCaptchaQuery.php', '2f8c3f044b72f018b92d2e1668dc8f5b'),
(221, 0, 'inc/classes/BxDolCategories.php', 'c893d46d65711796c2721388cb644290'),
(222, 0, 'inc/classes/BxDolCategoriesQuery.php', 'c62a2266986806442979ad55fe0d1623'),
(223, 0, 'inc/classes/BxDolCategory.php', 'aaccc54f90c742768fc4f0df00cb2682'),
(224, 0, 'inc/classes/BxDolCategoryQuery.php', 'a9cd5449f724a5a7d65b7383acd30f5e'),
(225, 0, 'inc/classes/BxDolChart.php', 'c7eb17cbdf561a70458c1b2adb0d401d'),
(226, 0, 'inc/classes/BxDolChartGrowth.php', 'b92a050c5b9d97db09dc221e384fcc24'),
(227, 0, 'inc/classes/BxDolChartGrowthSpeed.php', '555ab7885d9401739b120166f357c6de'),
(228, 0, 'inc/classes/BxDolChartQuery.php', '9147e0277dc4e4416a0007740233f10a'),
(229, 0, 'inc/classes/BxDolCmts.php', '0104abee0de24e72bb34c05518163e93'),
(230, 0, 'inc/classes/BxDolCmtsGridAdministration.php', 'da206c0b10c3c857c409a6c8ae6426c0'),
(231, 0, 'inc/classes/BxDolCmtsNotes.php', '2d93ec138e5a2ed3f80888c77d8b4c3b'),
(232, 0, 'inc/classes/BxDolCmtsQuery.php', '6e456149f437efd0a480e9f501771819'),
(233, 0, 'inc/classes/BxDolCmtsReviews.php', 'c89f2643c63f54212c0c774d28008ea3'),
(234, 0, 'inc/classes/BxDolCmtsReviewsQuery.php', '0ea63e3f2ef3e7e52b024da290f663ba'),
(235, 0, 'inc/classes/BxDolCmtsScore.php', '09b7ff7543f9805a0f35883b0ac3cb83'),
(236, 0, 'inc/classes/BxDolCmtsVoteLikes.php', '25973c22df5ca7a395b452b1eac8c353'),
(237, 0, 'inc/classes/BxDolCmtsVoteReactions.php', '3d4c85cf5aaf967dd39d4e0ee31d30d2'),
(238, 0, 'inc/classes/BxDolConnection.php', '41f66e8ab353a64b676e9581ccc5babd'),
(239, 0, 'inc/classes/BxDolConnectionQuery.php', 'f605a35e69e23166b3d0af0046b51bbd'),
(240, 0, 'inc/classes/BxDolContentFilter.php', '30881b837e4ad2e044a22646920bb9ee'),
(241, 0, 'inc/classes/BxDolContentInfo.php', '40e2667c9cfc66e36796f2d2daedc615'),
(242, 0, 'inc/classes/BxDolContentInfoCmts.php', '3ecc2c5a411511f1816f62c1e1a5a7e0'),
(243, 0, 'inc/classes/BxDolCover.php', 'a32706c2b7001d30d04305134eb98f80'),
(244, 0, 'inc/classes/BxDolCron.php', 'a656ab516495004d29a499f4d42f6d43'),
(245, 0, 'inc/classes/BxDolCronAccount.php', '18c50eac27bdbafae220063bf485cb52'),
(246, 0, 'inc/classes/BxDolCronAcl.php', '52b9a12ba66cc2e58dab58310f576e47'),
(247, 0, 'inc/classes/BxDolCronAudit.php', 'f28d9cf561abd4bf7db41a11150b7b23'),
(248, 0, 'inc/classes/BxDolCronBackgroundJobs.php', '5f6fc96e2313c015fcbc96acb1c2b867'),
(249, 0, 'inc/classes/BxDolCronProfile.php', 'a3702de2185b4f1cc449b78393728232'),
(250, 0, 'inc/classes/BxDolCronPruning.php', '9066fd0276a78c16fb6692250a79605f'),
(251, 0, 'inc/classes/BxDolCronQuery.php', '8c4de7cad30aad55785787480515c2fe'),
(252, 0, 'inc/classes/BxDolCronQueueEmail.php', '175c46cf8b49dc83fe940edeb3f457c7'),
(253, 0, 'inc/classes/BxDolCronQueuePush.php', 'eeffce21894bcbd7710883ee1182b9fe'),
(254, 0, 'inc/classes/BxDolCronStorage.php', 'c14deccf8a888a500baa275cfb65f895'),
(255, 0, 'inc/classes/BxDolCronTranscoder.php', '679f8cb946944dff06e68c5a578fa32b'),
(256, 0, 'inc/classes/BxDolCronUpgradeCheck.php', '3169047b2ccbb621add450098ef639a7'),
(257, 0, 'inc/classes/BxDolCronUpgradeModulesCheck.php', '66cf88117b768c73c4a5ed9cbf50eb4b'),
(258, 0, 'inc/classes/BxDolDb.php', '71312b204b641d30e642f24fd89adad1'),
(259, 0, 'inc/classes/BxDolDesigns.php', '385286221abd66a698780ffd9ed21293'),
(260, 0, 'inc/classes/BxDolEditor.php', '08fdad7ce1b6620aaa0e73f99a3704eb'),
(261, 0, 'inc/classes/BxDolEditorQuery.php', 'fb75af9780bb530e263c19e9060a58b9'),
(262, 0, 'inc/classes/BxDolEmailTemplates.php', '37a81b451965d294ba1f8fa4ba120402'),
(263, 0, 'inc/classes/BxDolEmailTemplatesQuery.php', 'cbee46d71ac980204636246e4c3cfa31'),
(264, 0, 'inc/classes/BxDolEmbed.php', '702141a9d63cdd5dbc18c470403bac65'),
(265, 0, 'inc/classes/BxDolEmbedQuery.php', '55e773c2ab0ce344223f7a61fb7e16be'),
(266, 0, 'inc/classes/BxDolFactory.php', '0cd402333c0dc55d3b190692e0894221'),
(267, 0, 'inc/classes/BxDolFactoryObject.php', '48547fced8b46c2a204e29cbaedad56f'),
(268, 0, 'inc/classes/BxDolFactoryObjectQuery.php', 'eb82222ae526d214b0b958c3b3bf828f'),
(269, 0, 'inc/classes/BxDolFavorite.php', '8087dbb482173f98b8b9173298ff3423'),
(270, 0, 'inc/classes/BxDolFavoriteQuery.php', '1a17e1b7b2ec83608b33c85f9b7081ca'),
(271, 0, 'inc/classes/BxDolFeature.php', 'e7a2e847c517aaa3e2ff19b962d12fc5'),
(272, 0, 'inc/classes/BxDolFeatureQuery.php', '1c7315ab932d4bc7d5447a9d6c2aac2b'),
(273, 0, 'inc/classes/BxDolFile.php', '07b814709225b07ca5625094d382f1b3'),
(274, 0, 'inc/classes/BxDolFileHandler.php', '4d7ff9c4cc8518db5a84bc52dc1b96e5'),
(275, 0, 'inc/classes/BxDolFileHandlerQuery.php', 'b36b1b4d8a12b4695441c24b7a81bbb5'),
(276, 0, 'inc/classes/BxDolForm.php', '974091355e3c82de46b7d9c1ac0e9568'),
(277, 0, 'inc/classes/BxDolFormNested.php', '28591708912be64827ec85f5265c50eb'),
(278, 0, 'inc/classes/BxDolFormNestedGhost.php', 'cd5d77a32cfb665467c0b01a93cea492'),
(279, 0, 'inc/classes/BxDolFormQuery.php', '889890f31693bb4ae865e50360769bdc'),
(280, 0, 'inc/classes/BxDolFtp.php', '57c5fd52cee197c43da948aa992c1504'),
(281, 0, 'inc/classes/BxDolGrid.php', 'd04f572f8e39e42647c1bc8b4a754ce5'),
(282, 0, 'inc/classes/BxDolGridConnectionIn.php', '26398ced931375033490f5da3a31221b'),
(283, 0, 'inc/classes/BxDolGridConnectionOut.php', '1d7299a27660680359643978eb5e644f'),
(284, 0, 'inc/classes/BxDolGridConnections.php', '88972c198003c1cbc147f7b3e882adc2'),
(285, 0, 'inc/classes/BxDolGridConnectionsRequests.php', 'e0dc662185d38bd20523a1718d06a90f'),
(286, 0, 'inc/classes/BxDolGridQuery.php', 'b957722643bef283d03c09a1210e0922'),
(287, 0, 'inc/classes/BxDolGridQueues.php', '79ed16c9131bd94de61964e56016f9c8'),
(288, 0, 'inc/classes/BxDolGridRelatedMe.php', 'fc299354f32b490cfbeb921445ce91d6'),
(289, 0, 'inc/classes/BxDolGridRelations.php', '0f426e5610f61e5c4753cbc10289bd5d'),
(290, 0, 'inc/classes/BxDolGridSubscribedMe.php', 'c0520244f0d012a77051a84d6ea33202'),
(291, 0, 'inc/classes/BxDolGridSubscriptions.php', '5ccb16e8870fb6bff0ebd7bdbd160736'),
(292, 0, 'inc/classes/BxDolGzip.php', '335dce28a39c60415272298af999d5a2'),
(293, 0, 'inc/classes/BxDolHTMLPurifierFilterAddBxLinksClass.php', 'ccd174545474f9e04e5a3d4ffc4c284f'),
(294, 0, 'inc/classes/BxDolHTMLPurifierFilterEmbed.php', '0ea2c18d12c7651ac649c5ecd25f8785'),
(295, 0, 'inc/classes/BxDolHTMLPurifierFilterLocalIframe.php', 'd0a90b494e366e918acf2bd6ebb96a0d'),
(296, 0, 'inc/classes/BxDolHTMLPurifierFilterYouTube.php', '78872e1ecdd3f89c2971f36949f529bf'),
(297, 0, 'inc/classes/BxDolHTMLPurifierFilterYoutubeIframe.php', 'bdeffa1a7433f226310ad9292f9705fa'),
(298, 0, 'inc/classes/BxDolImageResize.php', '0d13385c73ab9fe0d8be3f1789a62b31'),
(299, 0, 'inc/classes/BxDolInformer.php', '724aff39117286a76b3632cd14fe5c2d'),
(300, 0, 'inc/classes/BxDolIO.php', '7a598218fc27b562ca09bba10fb15cac'),
(301, 0, 'inc/classes/BxDolInstallerHasher.php', '3b6e86fde4ab94e93c4729677966a324'),
(302, 0, 'inc/classes/BxDolInstallerUtils.php', 'b4c8cd76c7746fd09a8fcb08f744765e'),
(303, 0, 'inc/classes/BxDolKey.php', '1612e21eb22dad48fbe5cb8d14811828'),
(304, 0, 'inc/classes/BxDolKeyQuery.php', 'ec2fd44a1afd96ea93bca989e8e1ab8b'),
(305, 0, 'inc/classes/BxDolLabel.php', '2025c169b008b4ef547170e5836a0843'),
(306, 0, 'inc/classes/BxDolLabelQuery.php', '32e325a7f7e84d3d06bd38e293cd166f'),
(307, 0, 'inc/classes/BxDolLanguages.php', 'ef54eae7477200d8ff4a387938d46683'),
(308, 0, 'inc/classes/BxDolLanguagesQuery.php', 'f34b1b97b0491000c62133cdabdd7713'),
(309, 0, 'inc/classes/BxDolLiveUpdates.php', '4a238d0d14debff868f3451a327017e0'),
(310, 0, 'inc/classes/BxDolLiveUpdatesQuery.php', 'b0b66a0f76a0fd6a28b55958ccf3f5cc'),
(311, 0, 'inc/classes/BxDolLocationField.php', 'b83f89c4c04c6311fd7bddcb6dd4e1a6'),
(312, 0, 'inc/classes/BxDolLocationFieldGoogle.php', 'f4bfb875cf8959dd6f92d9d73da9cb24'),
(313, 0, 'inc/classes/BxDolLocationFieldNominatim.php', '2beb4b2abf6c59a564b281c58456a381'),
(314, 0, 'inc/classes/BxDolLocationFieldQuery.php', '82884a86279437d1517103fd5fd0ce9e'),
(315, 0, 'inc/classes/BxDolLocationMap.php', 'e3ed77e2c4d8c8d9e83e78519ec0cac7'),
(316, 0, 'inc/classes/BxDolLocationMapGoogleStatic.php', 'fbecba0cb46599abb7101eb16fdb4dd0'),
(317, 0, 'inc/classes/BxDolLocationMapLeaflet.php', '8fd219a0eaf9dfab338151901945dba4'),
(318, 0, 'inc/classes/BxDolLocationMapQuery.php', 'dacf24f9d2f581fb2d5956c4c67b9e9d'),
(319, 0, 'inc/classes/BxDolLog.php', '3a20256cdad9fc44bd3e5182c96f0c83'),
(320, 0, 'inc/classes/BxDolLogs.php', 'af7c191df2f0e20ce6ffa1b80c215d35'),
(321, 0, 'inc/classes/BxDolLogsQuery.php', '4a2feebb784da39fd773fe3f332113a6'),
(322, 0, 'inc/classes/BxDolLogsStorageFolder.php', '1b1dcf51c2ddd2032d3f02bce7710b73'),
(323, 0, 'inc/classes/BxDolLogsStoragePHPLog.php', '31fb7499f72f6789e7c42f046f47a300'),
(324, 0, 'inc/classes/BxDolLogsStorageSTDErr.php', '9b117e7ac36a665bfaab0e123010fda1'),
(325, 0, 'inc/classes/BxDolMenu.php', '7c5a178606da1f147a4a34bb2ec96b10'),
(326, 0, 'inc/classes/BxDolMenuQuery.php', '6b016bcabc156391a4ca111347743016'),
(327, 0, 'inc/classes/BxDolMetatags.php', '1ce24d92e4b7ec6babf01a84ff998e93'),
(328, 0, 'inc/classes/BxDolMetatagsQuery.php', '0209ad071ae87ce05bea09f72bbdf08e'),
(329, 0, 'inc/classes/BxDolMinify.php', 'a1ea7475b891bb6c6c78bb99ae818c4f'),
(330, 0, 'inc/classes/BxDolModule.php', 'dd300c0f604958516a11d8b21dc96fb8'),
(331, 0, 'inc/classes/BxDolModuleConfig.php', 'b4bee77d35f98b7668d6c3a24f0c7e9e'),
(332, 0, 'inc/classes/BxDolModuleDb.php', 'c2a20410e18d7fb59dd1cc46f672a9a7'),
(333, 0, 'inc/classes/BxDolModuleProxy.php', '11c2cd856d5389670f1c4d7b31b35bb3'),
(334, 0, 'inc/classes/BxDolModuleQuery.php', '30450ecc29bb04a01196f9c9da4f479e'),
(335, 0, 'inc/classes/BxDolModuleTemplate.php', 'e6235aee8922213ec458b68e340cbf1d'),
(336, 0, 'inc/classes/BxDolObject.php', 'c4da3fc7e815518c2a2d7780ed981e0a'),
(337, 0, 'inc/classes/BxDolObjectQuery.php', '5dd4a61ac969a4a98230fea37b717848'),
(338, 0, 'inc/classes/BxDolPage.php', 'df910225b84c59936699d787c83b2672'),
(339, 0, 'inc/classes/BxDolPageQuery.php', 'c5922be2a0bd01555894e9950670ab54'),
(340, 0, 'inc/classes/BxDolPaginate.php', 'e77fe1f10d0a2dfa90fb72937bb8187e'),
(341, 0, 'inc/classes/BxDolPayments.php', 'eb68dd8f78ffd2bea625b8d300e0c54f'),
(342, 0, 'inc/classes/BxDolPaymentsQuery.php', '75f74e925e021cd2e46e24e35e7dccfb'),
(343, 0, 'inc/classes/BxDolPermalinks.php', '413a21cb51161c7731bc61a0aebb8dd7'),
(344, 0, 'inc/classes/BxDolPlayer.php', '416a5d26eb063dec8133f3838c837e78'),
(345, 0, 'inc/classes/BxDolPlayerQuery.php', 'c1525b6148eb09d813773c769e371fcb'),
(346, 0, 'inc/classes/BxDolPreloader.php', 'ac5217727d81e27db216a0a98c02491f'),
(347, 0, 'inc/classes/BxDolPreloaderQuery.php', 'db168ff876395ce3bb6aa02c1d37375e'),
(348, 0, 'inc/classes/BxDolPrivacy.php', '735496a5111e97337d31ee5f9df8c3fe'),
(349, 0, 'inc/classes/BxDolPrivacyQuery.php', '89369d940e0d52155dab1203442b4f31'),
(350, 0, 'inc/classes/BxDolProfile.php', '90f96561adffbb6de1572013ceca7e54'),
(351, 0, 'inc/classes/BxDolProfileAnonymous.php', '30ed99dc904c9c15b90756a84f96f305'),
(352, 0, 'inc/classes/BxDolProfileForms.php', '73f87bb6b0eb0b1f4e5e820d226735b3'),
(353, 0, 'inc/classes/BxDolProfileQuery.php', 'e980fead09e48f80cc417ca67de5f429'),
(354, 0, 'inc/classes/BxDolProfileUndefined.php', 'f165e815fd19d06dfeee92cd38a611e9'),
(355, 0, 'inc/classes/BxDolPush.php', '299e05c214a90022d49c8f7f14210c7d'),
(356, 0, 'inc/classes/BxDolPushOneSignal.php', '15104167c915716c0f5b7b7ce8602e06'),
(357, 0, 'inc/classes/BxDolPushQuery.php', 'b4b28b1e35e8bda0b27bcff13414285a'),
(358, 0, 'inc/classes/BxDolQueue.php', 'b89463e56ec7306228cd88da323eb9c9'),
(359, 0, 'inc/classes/BxDolQueueEmail.php', 'c795752a4236c5c537e02b3137f65030'),
(360, 0, 'inc/classes/BxDolQueueEmailQuery.php', '3b2feccc7993e3ee8381220b6e66f0d4'),
(361, 0, 'inc/classes/BxDolQueuePush.php', '8a89a072128a3367c8e195f7d6348f48'),
(362, 0, 'inc/classes/BxDolQueuePushQuery.php', 'e84a535faf89f35224f2f003c928e5ef'),
(363, 0, 'inc/classes/BxDolQueueQuery.php', '30126be9c8a691aaa61274d838bd708f'),
(364, 0, 'inc/classes/BxDolRecommendation.php', '4cad11459fa397a002cd9b908a77f85b'),
(365, 0, 'inc/classes/BxDolRecommendationProfile.php', '9a5ee3c11e18ee717e5b9baf6d51f6de'),
(366, 0, 'inc/classes/BxDolRecommendationQuery.php', 'b988a47afaf262066203683796b2f410'),
(367, 0, 'inc/classes/BxDolRelation.php', 'af833cee576aed850e509b665bec5cd2'),
(368, 0, 'inc/classes/BxDolRelationQuery.php', '7f7c67552604ac1fc895cbaeee55ce87'),
(369, 0, 'inc/classes/BxDolReport.php', '3aa24dd43eb6ce02e7edeba78e4badb8'),
(370, 0, 'inc/classes/BxDolReportQuery.php', 'defc28f28b4f4ba6f0205ec3bdb11126'),
(371, 0, 'inc/classes/BxDolRequest.php', '8c74f87987f8d6810b84415eb011a3f7'),
(372, 0, 'inc/classes/BxDolRewriteRulesQuery.php', '8f0c7cb11602f3964ec5a259c2e80c35'),
(373, 0, 'inc/classes/BxDolRss.php', '10b06bf933d52c6739579fc0cdb6717e'),
(374, 0, 'inc/classes/BxDolRssBoonEx.php', 'efc16cf4c05ebe218eaef7e639d87055'),
(375, 0, 'inc/classes/BxDolRssFactory.php', '3c6d7accd63e6d6e52579d27899acb63'),
(376, 0, 'inc/classes/BxDolRssPageBlock.php', 'b6b8fc93f643ba1811ebc9df85ceed34'),
(377, 0, 'inc/classes/BxDolRssQuery.php', '54074823ac370a9c17362276371b7704'),
(378, 0, 'inc/classes/BxDolScore.php', 'ea64c7f379eb05802462f30b26b0c7dd'),
(379, 0, 'inc/classes/BxDolScoreQuery.php', '14f12fcbbf0ab8337fe6cfe133cf4a5f'),
(380, 0, 'inc/classes/BxDolSearch.php', 'e93d53003f61b7e28160d83bee610464'),
(381, 0, 'inc/classes/BxDolSearchExtended.php', '89f667257566911854ddc691e653b7c7'),
(382, 0, 'inc/classes/BxDolSearchExtendedQuery.php', 'b7c9418ef1a67cd2dc9a4cd91c9dc751'),
(383, 0, 'inc/classes/BxDolService.php', '2c234b1b6effbde441080734784ce649'),
(384, 0, 'inc/classes/BxDolSession.php', 'd2e9b03dcc5be078f1df7e20eb18bf6b'),
(385, 0, 'inc/classes/BxDolSessionQuery.php', '058dfdad40a0b71b39d87772825597bd'),
(386, 0, 'inc/classes/BxDolSms.php', '5d52d7dc9f51f4654cc7db3791deb29b'),
(387, 0, 'inc/classes/BxDolSmsQuery.php', '0c5d4f52dedec8fa1c219ef1b9b4dfae'),
(388, 0, 'inc/classes/BxDolSmsTwilio.php', '9f722cdef2146e3ace9ca3020d2e3395'),
(389, 0, 'inc/classes/BxDolSockets.php', '698d10c510f71c2059ef64508f787db8'),
(390, 0, 'inc/classes/BxDolSocketsSoketi.php', '82dc53702e5e6e3ef441e2c09563ca94'),
(391, 0, 'inc/classes/BxDolStorage.php', 'd78ecb31740cec44c3c7f16f8da58a8b'),
(392, 0, 'inc/classes/BxDolStorageLocal.php', '2f8cede2f6c8126822063498c29bb250'),
(393, 0, 'inc/classes/BxDolStorageQuery.php', '72cf750c78382f37d06b17ad86f01e18'),
(394, 0, 'inc/classes/BxDolStorageS3.php', 'b8534646f4922e71103cdb2a86a489db'),
(395, 0, 'inc/classes/BxDolStorageS3v4.php', '32c67dc9edb836609ce975518f3a813f'),
(396, 0, 'inc/classes/BxDolStorageS3v4alt.php', '254e2f48bb811a13551155ede17f49c8'),
(397, 0, 'inc/classes/BxDolTemplate.php', '1c8cc19eadc16a6e795f06d5735a84bc'),
(398, 0, 'inc/classes/BxDolTranscoder.php', '2b8946daa26c009bae49b81c6aab74b9'),
(399, 0, 'inc/classes/BxDolTranscoderAudio.php', '7b1ccd37e8cbc590b0ffd50eb2d08db0'),
(400, 0, 'inc/classes/BxDolTranscoderAudioQuery.php', '6d4d11bd091940627b84bd590ced1592'),
(401, 0, 'inc/classes/BxDolTranscoderImage.php', 'ea2292fd405a527084db105bb4143f1c'),
(402, 0, 'inc/classes/BxDolTranscoderImageQuery.php', 'e2a3f462b52c7d523c8ebc1bb79824c3'),
(403, 0, 'inc/classes/BxDolTranscoderProxy.php', 'aef7c6aba42cb9beaaa74084ac9f1080'),
(404, 0, 'inc/classes/BxDolTranscoderQuery.php', '3c020b05f06bd611b27d244d7b3d3085'),
(405, 0, 'inc/classes/BxDolTranscoderVideo.php', 'f6f87292dd31deff0b94c2ecc09b9163'),
(406, 0, 'inc/classes/BxDolTranscoderVideoQuery.php', '0302aa8603d96448b491a4ccfa5107e5'),
(407, 0, 'inc/classes/BxDolUpgrader.php', '5cc3fd3c34b89df54b1370d4d4c165de'),
(408, 0, 'inc/classes/BxDolUploader.php', '5251e288e01bb502a9d3340219203695'),
(409, 0, 'inc/classes/BxDolUploaderQuery.php', '3037248853da0ab5295f14510e0c311c'),
(410, 0, 'inc/classes/BxDolView.php', 'df959b1a409904de9534bff4b0ad71b3'),
(411, 0, 'inc/classes/BxDolViewQuery.php', '2ac23a55cdb6c482c9c7a26aabc4f441'),
(412, 0, 'inc/classes/BxDolVote.php', 'ee20d617f63cfbb6b25b409338469987'),
(413, 0, 'inc/classes/BxDolVoteLikes.php', 'cc7ae271f01e6a952cd731e0327ccbff'),
(414, 0, 'inc/classes/BxDolVoteLikesQuery.php', 'b7a942473d50609f9cc7ddc740c83106'),
(415, 0, 'inc/classes/BxDolVoteQuery.php', '7d386c4214b0c6fc8cdb34987c9b0eeb'),
(416, 0, 'inc/classes/BxDolVoteReactions.php', '8a69e0b706003433901b98426b2198b6'),
(417, 0, 'inc/classes/BxDolVoteReactionsQuery.php', '7dc0aa7dda2037f3a30943f83f5963ef'),
(418, 0, 'inc/classes/BxDolVoteStars.php', '9404c7620482d7039a0e2d8df6f4916b'),
(419, 0, 'inc/classes/BxDolVoteStarsQuery.php', '237b016a8493c28e1242bf5bda6ddb37'),
(420, 0, 'inc/classes/BxDolWiki.php', '875dc84b775829759b0f413bc45d3b23'),
(421, 0, 'inc/classes/BxDolWikiQuery.php', 'c94e8e496f871d29c3e23b90afcdd593'),
(422, 0, 'inc/classes/BxDolXmlParser.php', '72f1cb9372d19265e2647342dbd08b0c'),
(423, 0, 'inc/design.inc.php', 'e0fc0ecb0341d9ef57fae1bbcb35a18d'),
(424, 0, 'inc/js/classes/BxDolAuditManageTools.js', '13ec05a739a4995371b553f680ef9671'),
(425, 0, 'inc/js/classes/BxDolCategories.js', 'd93f20b34454243695d846cf901b1150'),
(426, 0, 'inc/js/classes/BxDolChartGrowth.js', '73377789136b2230e2e0b32c6a9d7408'),
(427, 0, 'inc/js/classes/BxDolCmts.js', 'cd35bf6da14720e64399337123448fe3'),
(428, 0, 'inc/js/classes/BxDolCmtsManageTools.js', '624888a5f6636c44f2e518978ab9286b'),
(429, 0, 'inc/js/classes/BxDolCmtsReviews.js', '3108379c7a3fb262f01384db3837c723'),
(430, 0, 'inc/js/classes/BxDolConnection.js', 'd97e8c56a3c0a0789fa67df4df9adae8'),
(431, 0, 'inc/js/classes/BxDolCreatePost.js', '5549b1cc01ce569ee89371e406275082'),
(432, 0, 'inc/js/classes/BxDolFavorite.js', '3552328cca983515ab43a1992caadb16'),
(433, 0, 'inc/js/classes/BxDolFeature.js', 'ee059061b1a17cfcc3fcdc975c20b23c'),
(434, 0, 'inc/js/classes/BxDolForm.js', '0df14b62da6cd7d7fa966d325e565db9'),
(435, 0, 'inc/js/classes/BxDolGrid.js', 'dd5f57b2fa588ec4fc66d03510f5b23e'),
(436, 0, 'inc/js/classes/BxDolLabel.js', 'cc4d12c61cc16baf18c7974e5d18aada'),
(437, 0, 'inc/js/classes/BxDolLiveUpdates.js', 'b525076c328fec57d450d616d2001dd1'),
(438, 0, 'inc/js/classes/BxDolMenuMoreAuto.js', 'be9dc3b7237b768fdce9d592eed73193'),
(439, 0, 'inc/js/classes/BxDolNestedForm.js', '68286984f7ec073bf7efedb4dd36fa37'),
(440, 0, 'inc/js/classes/BxDolPage.js', '640219e74dea1649e476aec7dd2e812c'),
(441, 0, 'inc/js/classes/BxDolPrivacy.js', '57ff1903121c78f9bd4258bb21d824dc'),
(442, 0, 'inc/js/classes/BxDolPushOneSignal.js', '5ff6eaa5e5ce7aa7e3890ebce772d0b3'),
(443, 0, 'inc/js/classes/BxDolReport.js', 'e9dccb5d0ddb51bae541c4666d0fbe5d'),
(444, 0, 'inc/js/classes/BxDolReportsManageTools.js', '7d371a5780c4aef8c651df7fd616bccc'),
(445, 0, 'inc/js/classes/BxDolScore.js', '5242421d4b85287d226637468d420567'),
(446, 0, 'inc/js/classes/BxDolSockets.js', '4b89d229152e5910f90e5fdd573e5864'),
(447, 0, 'inc/js/classes/BxDolUploader.js', 'dda355c90b406a8887049935f80ee364'),
(448, 0, 'inc/js/classes/BxDolView.js', 'fc6ba9556b0a0b961359758fc5bd31e8'),
(449, 0, 'inc/js/classes/BxDolVote.js', '094a9606895c0c8be70f6ade59e6ba4c'),
(450, 0, 'inc/js/classes/BxDolVoteLikes.js', '225327f8e21cbd6960f633f8852ea6ce'),
(451, 0, 'inc/js/classes/BxDolVoteReactions.js', '654f80dab5c1de96515f7aee96504e65'),
(452, 0, 'inc/js/classes/BxDolVoteStars.js', 'e0a5a02fc7fb5fbae3dee0d8c57033e5'),
(453, 0, 'inc/js/classes/BxDolWiki.js', 'e16947b0f336bb5bfefda6f0c478c431'),
(454, 0, 'inc/js/editor.quill.js', '582e19d7aa08e114e2f7b8be99dc8057'),
(455, 0, 'inc/js/embed.js', '6ab068773271254b0cf0a3c3b680409a'),
(456, 0, 'inc/js/functions.js', '15b01d91875b1fc5b4c8fcc13f074e4e'),
(457, 0, 'inc/js/jquery.anim.js', 'a558d86791de1d35dde8d706279569d9'),
(458, 0, 'inc/js/jquery.dolConverLinks.js', 'b80a5c6e854f64ef7595eab419f9f84c'),
(459, 0, 'inc/js/jquery.dolPopup.js', 'f77ed494ee1541f4dc9c872d1f3b1178'),
(460, 0, 'inc/js/jquery.dolRSSFeed.js', 'f6f1d70b0c9adeab82ee01748c71114a'),
(461, 0, 'inc/js/jquery.webForms.js', '07f32710fb663a3b34908f46f066e437'),
(462, 0, 'inc/js/popper.js', 'e8d8f98a70a447478b44a5402232e59d'),
(463, 0, 'inc/params.inc.php', 'f8688633f1f9741a5b1e8f744f22f29c'),
(464, 0, 'inc/profiles.inc.php', 'a4e9590a0d25ec097f348eb0ddc39a43'),
(465, 0, 'inc/utils.inc.php', '0a33651b98b7d7d47c779703607e201f'),
(466, 0, 'inc/version.inc.php', '11fced9f2d965ad496b7289836b2bec4'),
(467, 0, 'modules/base/connect/classes/BxBaseModConnectAlerts.php', '7250d6c896111ef01924042a86b25d77'),
(468, 0, 'modules/base/connect/classes/BxBaseModConnectConfig.php', '7c4199866f305e92d4eb0e88c5583435'),
(469, 0, 'modules/base/connect/classes/BxBaseModConnectDb.php', 'f70275854cbea40ac1f4d205fd7f2dfb'),
(470, 0, 'modules/base/connect/classes/BxBaseModConnectModule.php', '6b22a3c512f50ae2f18cdb22f1183696'),
(471, 0, 'modules/base/connect/classes/BxBaseModConnectTemplate.php', '3100eb2492fc2b46cb551e8c11c20ef5'),
(472, 0, 'modules/base/files/classes/BxBaseModFilesDb.php', 'e7aa91a05c72f99c4b6de0547cb670a7'),
(473, 0, 'modules/base/files/classes/BxBaseModFilesFormEntry.php', '4164a6219a35df28536cb17577c4b8f8'),
(474, 0, 'modules/base/files/classes/BxBaseModFilesFormsEntryHelper.php', 'c9f1f846c65d8b5d61cb12917c019d7c'),
(475, 0, 'modules/base/files/classes/BxBaseModFilesFormUpload.php', '5829ddf53efa8b62efc3b0c21d1c68af'),
(476, 0, 'modules/base/files/classes/BxBaseModFilesModule.php', '650261aeb979f656889a429a7dcdb015'),
(477, 0, 'modules/base/files/classes/BxBaseModFilesPrivacy.php', '2d447308c02ec34fab8432e174307ead'),
(478, 0, 'modules/base/files/classes/BxBaseModFilesUploaderHTML5.php', '2c012a4f62eed3eedca412920240e30c'),
(479, 0, 'modules/base/general/classes/BxBaseModGeneralAlertsResponse.php', 'b9f6966b2077bec8eaaacdd7aa34c717'),
(480, 0, 'modules/base/general/classes/BxBaseModGeneralCmtsSearchResult.php', '5cedbb1d410c4793b7d8c8b716b635b6'),
(481, 0, 'modules/base/general/classes/BxBaseModGeneralConfig.php', '84361705014cb09263435c76f85dd041'),
(482, 0, 'modules/base/general/classes/BxBaseModGeneralDb.php', '7242b2f9dcdb781b0df2233d7420a2c7'),
(483, 0, 'modules/base/general/classes/BxBaseModGeneralFormEntry.php', '8a1ec5ef01ae21242b85ece850139011'),
(484, 0, 'modules/base/general/classes/BxBaseModGeneralFormsEntryHelper.php', 'f24d31ce33c8a2acdefb9ea6134c299b'),
(485, 0, 'modules/base/general/classes/BxBaseModGeneralGridAdministration.php', '0973ff522c895cb139e1fa51ada047ff'),
(486, 0, 'modules/base/general/classes/BxBaseModGeneralInstaller.php', '16b1cb67a8da1aab2ae93b8ba120d9f1'),
(487, 0, 'modules/base/general/classes/BxBaseModGeneralMenuManageTools.php', 'f9db6eb1318aa0d06cb48663ff3f92f8'),
(488, 0, 'modules/base/general/classes/BxBaseModGeneralMenuSnippetMeta.php', 'a6197f4692f4e4322a5f4375c13a352b'),
(489, 0, 'modules/base/general/classes/BxBaseModGeneralMenuSubmenuMoreAuto.php', '1b80f8071a2c194a71870d7dd546d1b2'),
(490, 0, 'modules/base/general/classes/BxBaseModGeneralMenuView.php', '93dd0dfecab64c50e9c9274be4916283'),
(491, 0, 'modules/base/general/classes/BxBaseModGeneralMenuViewActions.php', '1ebd47f632c544fd78721dee1c13e80e'),
(492, 0, 'modules/base/general/classes/BxBaseModGeneralModule.php', '69b3e27a96bcf19533063185da7ed5dc'),
(493, 0, 'modules/base/general/classes/BxBaseModGeneralPageBrowse.php', '4cb1b5b462971fabd5b9fd2579f0667f'),
(494, 0, 'modules/base/general/classes/BxBaseModGeneralPageEntry.php', 'efea7c69edba3725d59c78e24dacfea5'),
(495, 0, 'modules/base/general/classes/BxBaseModGeneralPageListEntry.php', 'bf92e644e29f768dd7c6cfa8fd18ff32'),
(496, 0, 'modules/base/general/classes/BxBaseModGeneralRequest.php', '2b5b32719de023c3be3e7b89ae41d3b2'),
(497, 0, 'modules/base/general/classes/BxBaseModGeneralSearchResult.php', 'c07defd47f464d9fc1dd7356ff0ab80e'),
(498, 0, 'modules/base/general/classes/BxBaseModGeneralTemplate.php', 'f41a24d860244b12f21b44c5121e29da'),
(499, 0, 'modules/base/general/js/forms.js', 'bf5a95d7a35e4a263a62c7469a91ce3b'),
(500, 0, 'modules/base/general/js/showcase.js', 'f13f3eb0f962b3ac19c0a5c4e71996cf'),
(501, 0, 'modules/base/general/template/attachments.html', 'ec108a413e6dbfde5ff960b2b6849559'),
(502, 0, 'modules/base/general/template/attachment_sound.html', '55efa8fc6295ca28f098f2fa7ebd840d'),
(503, 0, 'modules/base/general/template/badges.html', '23f0c4c1ae30ee52ff795bcaca470f18'),
(504, 0, 'modules/base/general/template/breadcrumb.html', 'd3b6e9403871e8d54c4cfc462627ac60'),
(505, 0, 'modules/base/general/template/browse_quick.html', '87e84baddd18c91e689b74a24ffa5d26'),
(506, 0, 'modules/base/general/template/browsing_filters.html', '06efbaf9699d16cc04ff2da65fdff39c'),
(507, 0, 'modules/base/general/template/category_list_inline.html', 'f27535d73f50a86dbae3196ef403bde5'),
(508, 0, 'modules/base/general/template/comments-item.html', 'da7b8129faef55140dd2c17c1dfdbe9a'),
(509, 0, 'modules/base/general/template/context.html', '33fbf6e6d46e784796c8cb274b3812ea'),
(510, 0, 'modules/base/general/template/css/categories.css', 'c6ad146094c1539f9090ef25d782e69f'),
(511, 0, 'modules/base/general/template/css/forms.css', 'b573602128a17c8d8da4632a0419211d'),
(512, 0, 'modules/base/general/template/css/main.css', 'bce37719842c06408ab01f1bc4215094'),
(513, 0, 'modules/base/general/template/css/manage_tools.css', 'd41d8cd98f00b204e9800998ecf8427e'),
(514, 0, 'modules/base/general/template/entry-all-actions.html', '76f8585b09b90aea463fc49f2daba5fc'),
(515, 0, 'modules/base/general/template/entry-info.html', '350e2573f975d3bec2ad25cdc44781c6'),
(516, 0, 'modules/base/general/template/entry-location.html', '4f83fb27d3796b108e309a69b48cbb5f'),
(517, 0, 'modules/base/general/template/entry-share.html', '644c0dc2f716c56a9a36a747527ac449'),
(518, 0, 'modules/base/general/template/favorite-list-info.html', '03d38c6b3a72ae2cf344d229af74cd1b'),
(519, 0, 'modules/base/general/template/favorite-lists.html', '28acb92412d5c98eaf2a26a137e3746b'),
(520, 0, 'modules/base/general/template/form_categories.html', '42ab795a3342e344f24d9278cd21eb2f'),
(521, 0, 'modules/base/general/template/image_tweak.html', 'b0e4ca4ed6222b4a5e4d86a522dd353f'),
(522, 0, 'modules/base/general/template/labels_breadcrumbs.html', '9afb6373b67c2250e8da6b9eaf8504e8'),
(523, 0, 'modules/base/general/template/labels_tree.html', '4510c64c1cdd6486f4abfc7a6cc51526'),
(524, 0, 'modules/base/general/template/link.html', 'abdf015b661dca88d07fe43f4a997b74'),
(525, 0, 'modules/base/general/template/unit_live_search.html', '2b9b7ff3bb3e9ad8e353f7c1c76743aa'),
(526, 0, 'modules/base/general/template/uploader_button_html5_attach.html', 'fbe3f9e21009cc54ed9f0f4f99323ac3'),
(527, 0, 'modules/base/general/template/uploader_cover.html', '4c9ed6b7369eba72424ec527e7bd3d32'),
(528, 0, 'modules/base/general/template/uploader_progress.html', '82f2d9a52f4afb5839f7f1f78f621ea4'),
(529, 0, 'modules/base/groups/classes/BxBaseModGroupsAlertsResponse.php', '74adbeb1489ce372094f2a81b682d095'),
(530, 0, 'modules/base/groups/classes/BxBaseModGroupsCmts.php', 'f2e2b4d03ed4bddde81a4c3b6b664f47'),
(531, 0, 'modules/base/groups/classes/BxBaseModGroupsConfig.php', 'afd56c07cdb164400aefa2fcb3aeab5b'),
(532, 0, 'modules/base/groups/classes/BxBaseModGroupsConnectionFans.php', '47384af06ab54ba5d3a2de90e9083b42'),
(533, 0, 'modules/base/groups/classes/BxBaseModGroupsCronPruning.php', 'a6ef9475ff110d10c2fd2ed04d9460fb'),
(534, 0, 'modules/base/groups/classes/BxBaseModGroupsCronPublishing.php', '6ee75efa840690632a543e9c8f4171c4'),
(535, 0, 'modules/base/groups/classes/BxBaseModGroupsDb.php', 'b147f0704b5bd85d089ccaaf7e2ee76f'),
(536, 0, 'modules/base/groups/classes/BxBaseModGroupsFormEntry.php', '9c7bb1475d6ff4fa1377c9e6c1530a09'),
(537, 0, 'modules/base/groups/classes/BxBaseModGroupsFormPrice.php', '00f60b6ac46f56b05ab5bee09800f0c0'),
(538, 0, 'modules/base/groups/classes/BxBaseModGroupsFormQuestion.php', 'ca6224ae749b943f26f768c56eea1634'),
(539, 0, 'modules/base/groups/classes/BxBaseModGroupsFormsEntryHelper.php', '9460a90c8fc4747105cba14117bd919e'),
(540, 0, 'modules/base/groups/classes/BxBaseModGroupsGridAdministration.php', '812021c2f602dae53d341246aa711cc2'),
(541, 0, 'modules/base/groups/classes/BxBaseModGroupsGridBans.php', '95996559cfcfc407872b553e550f4521'),
(542, 0, 'modules/base/groups/classes/BxBaseModGroupsGridCommon.php', '7b4c27972bfc13117585152c60fcac2b'),
(543, 0, 'modules/base/groups/classes/BxBaseModGroupsGridConnections.php', '3df526945509a033b24644bd4f5f6b3d'),
(544, 0, 'modules/base/groups/classes/BxBaseModGroupsGridInvites.php', '4d8f9e9b8815896c50fa6072d66c3554'),
(545, 0, 'modules/base/groups/classes/BxBaseModGroupsGridPrices.php', '0607550737d3ec96fee4e78fc4802d89'),
(546, 0, 'modules/base/groups/classes/BxBaseModGroupsGridPricesManage.php', 'c1b0b621cd9042880dfeaa7595078864'),
(547, 0, 'modules/base/groups/classes/BxBaseModGroupsGridPricesView.php', '68d401e830180acc6454af6196215c0c'),
(548, 0, 'modules/base/groups/classes/BxBaseModGroupsGridQuestionsManage.php', 'a2347344d3a7d8c574b09b81d8360834'),
(549, 0, 'modules/base/groups/classes/BxBaseModGroupsInstaller.php', '5c9eb98309c4879575cf2b68436e1549'),
(550, 0, 'modules/base/groups/classes/BxBaseModGroupsMenuManageTools.php', '0ad711c4dc71a2330ba35a5f76f29e6c'),
(551, 0, 'modules/base/groups/classes/BxBaseModGroupsMenuSnippetMeta.php', '6f6f7a4aa0dc00c5aa353d702495b30a'),
(552, 0, 'modules/base/groups/classes/BxBaseModGroupsMenuView.php', '4477841636671d372eef0a7e85feb278'),
(553, 0, 'modules/base/groups/classes/BxBaseModGroupsMenuViewActions.php', 'eb5cb168f6b20847f0285bc62c54e367'),
(554, 0, 'modules/base/groups/classes/BxBaseModGroupsMenuViewActionsAll.php', 'f7356f25b62aeb948141960359564106'),
(555, 0, 'modules/base/groups/classes/BxBaseModGroupsMenuViewMeta.php', '1dad264ba27d2a5c155aa8911ea643f0'),
(556, 0, 'modules/base/groups/classes/BxBaseModGroupsModule.php', 'f730d7b8ef54502d4c212bd8637fa103'),
(557, 0, 'modules/base/groups/classes/BxBaseModGroupsPageBrowse.php', '88c0eef372b00da6c602afe99a8e9296'),
(558, 0, 'modules/base/groups/classes/BxBaseModGroupsPageEntry.php', 'e62cb1750a5c3f5412f0f6e9dcaff25a'),
(559, 0, 'modules/base/groups/classes/BxBaseModGroupsPageJoinedEntries.php', 'fa933461c6c451b6688c398fd99206d9'),
(560, 0, 'modules/base/groups/classes/BxBaseModGroupsPageListEntry.php', 'a8cf7440fd9dc93f470be91cd47361a4'),
(561, 0, 'modules/base/groups/classes/BxBaseModGroupsPrivacy.php', '76c474e394259eb66792d44ff9dfac8c'),
(562, 0, 'modules/base/groups/classes/BxBaseModGroupsPrivacyNotifications.php', '7a695f21ae2fd2506f4e397f887e1a26'),
(563, 0, 'modules/base/groups/classes/BxBaseModGroupsPrivacyPost.php', '5889cdef1bd684e39a281ef53c2aca9e'),
(564, 0, 'modules/base/groups/classes/BxBaseModGroupsRecommendationFans.php', '828c016926b899a55f882b2fc7c2b485'),
(565, 0, 'modules/base/groups/classes/BxBaseModGroupsSearchResult.php', '232fe379ea6559ea025ad0263adf6303'),
(566, 0, 'modules/base/groups/classes/BxBaseModGroupsTemplate.php', '78c99f2b6b298ef6fe1115e58291fce0'),
(567, 0, 'modules/base/groups/classes/BxBaseModGroupsUploaderCoverCrop.php', 'a351321f08d0194055b2b522e7dd3803'),
(568, 0, 'modules/base/groups/classes/BxBaseModGroupsUploaderPictureCrop.php', '53cf2370ea1aa1ce806d7e05cfbd3a94'),
(569, 0, 'modules/base/groups/js/entry.js', 'd96efbbdbcef2f30d2ab4dc5c38062a4'),
(570, 0, 'modules/base/groups/js/invite_popup.js', 'efdd6fcdda0c24e41ecfeb5bf9d8d2a7'),
(571, 0, 'modules/base/groups/js/main.js', '67bb617cad4853a2f130f2855d8f87e8'),
(572, 0, 'modules/base/groups/js/manage_tools.js', '3498905342caf8be5a5a175eb8182ec4'),
(573, 0, 'modules/base/groups/js/prices.js', '251919f99f6a45736bccbb0d53c7b910'),
(574, 0, 'modules/base/groups/template/cover_block.html', '23c77682791e16cc7255ab4b0f3abef4'),
(575, 0, 'modules/base/groups/template/css/main.css', 'c5c419538866e364fa703535a47b0ac9'),
(576, 0, 'modules/base/groups/template/css/prices.css', 'b2c2e346e98610a945a08ab8a2bb0d68');
INSERT INTO `sys_modules_file_tracks` VALUES
(577, 0, 'modules/base/groups/template/popup_invite.html', 'd16987f7622d2b334370fe32f8845e9e'),
(578, 0, 'modules/base/groups/template/popup_price.html', '542fca56b1a0859a9e2f335bf2b2b8ea'),
(579, 0, 'modules/base/groups/template/popup_qnr_answers.html', 'e53035fb684c2a176abf890fc98f6ec0'),
(580, 0, 'modules/base/groups/template/popup_qnr_question.html', '59116ae076a37d9f8f0ad7688bcd3183'),
(581, 0, 'modules/base/groups/template/popup_qnr_questionnaire.html', '09df72bd14591e49d571d25362b0d647'),
(582, 0, 'modules/base/groups/template/set_role_popup.html', '9adbda9799bd84180cdc8c72fb2b88f7'),
(583, 0, 'modules/base/groups/template/unit.html', '8eaadd9c709021dfe9677e0a97fbd1dd'),
(584, 0, 'modules/base/groups/template/unit_live_search.html', '12c2ca6ca04649e0f9ee17d396178935'),
(585, 0, 'modules/base/groups/template/unit_meta_item.html', 'a74a47348a0fbdab37081566a0bbd4ed'),
(586, 0, 'modules/base/groups/template/unit_with_cover_showcase.html', '7ef7a77f7bd0691ac50ac1035555b525'),
(587, 0, 'modules/base/notifications/classes/BxBaseModNotificationsConfig.php', '770a24d123fc06c6e5b0762071e02403'),
(588, 0, 'modules/base/notifications/classes/BxBaseModNotificationsDb.php', '8a55d7e17138392ea25031b8e9200be0'),
(589, 0, 'modules/base/notifications/classes/BxBaseModNotificationsInstaller.php', 'ab39f0b418e4cb0d19043b8d3dabba88'),
(590, 0, 'modules/base/notifications/classes/BxBaseModNotificationsModule.php', '1574ff35f7ee65faada014ef9d53c159'),
(591, 0, 'modules/base/notifications/classes/BxBaseModNotificationsPrivacy.php', 'cc28cc23c55a37cf5ff1c95b6bf54be5'),
(592, 0, 'modules/base/notifications/classes/BxBaseModNotificationsResponse.php', '857945fce98b7848d2255bc313344069'),
(593, 0, 'modules/base/notifications/classes/BxBaseModNotificationsSearchResult.php', 'a2dff138a5e305b9cc6290dbb49b9186'),
(594, 0, 'modules/base/notifications/classes/BxBaseModNotificationsStudioPage.php', 'e8c63ca8061c20098719800e0c6f1d1c'),
(595, 0, 'modules/base/notifications/classes/BxBaseModNotificationsTemplate.php', 'e0bbe1e0706498615541fcbef685b1c9'),
(596, 0, 'modules/base/notifications/template/unit.html', 'd41d8cd98f00b204e9800998ecf8427e'),
(597, 0, 'modules/base/notifications/template/unit_live_search.html', '75ca98eeba38bef91de759c8d8292904'),
(598, 0, 'modules/base/notifications/template/unit_private.html', '66fdde727dc9dd2c8829fa14c4f4f5e6'),
(599, 0, 'modules/base/payment/classes/BxBaseModPaymentCart.php', 'c0848491a02a72a839143f6b62f1fe1b'),
(600, 0, 'modules/base/payment/classes/BxBaseModPaymentCommissions.php', 'a13320a63dbdab912c76a1486090bcab'),
(601, 0, 'modules/base/payment/classes/BxBaseModPaymentConfig.php', 'aa43b0283691ac9f9bbaf51850432137'),
(602, 0, 'modules/base/payment/classes/BxBaseModPaymentDb.php', 'cda6f648072d6ee25a01f1a4c03ae547'),
(603, 0, 'modules/base/payment/classes/BxBaseModPaymentDetails.php', '4e129063130bc24ff3c82399fecd07ee'),
(604, 0, 'modules/base/payment/classes/BxBaseModPaymentGridCarts.php', '070ab077c95a02394b59bdd2a5787e1c'),
(605, 0, 'modules/base/payment/classes/BxBaseModPaymentGridCommissions.php', '833629624fd102765bb7a77a7998d285'),
(606, 0, 'modules/base/payment/classes/BxBaseModPaymentGridInvoices.php', '7889a5de7f3884895e1b1dd80a8a0944'),
(607, 0, 'modules/base/payment/classes/BxBaseModPaymentGridOrders.php', 'c4c70353812d79212da600afea9910a2'),
(608, 0, 'modules/base/payment/classes/BxBaseModPaymentGridProviders.php', '62bee7b8d1510877f2e621ee43085f40'),
(609, 0, 'modules/base/payment/classes/BxBaseModPaymentGridTransactions.php', '3bf698204cf3556fb4b0feae895ec241'),
(610, 0, 'modules/base/payment/classes/BxBaseModPaymentInstaller.php', '0737307090ce5e829bc4817a9028a3c9'),
(611, 0, 'modules/base/payment/classes/BxBaseModPaymentJoin.php', '6b1f6556574436632243106a1344330e'),
(612, 0, 'modules/base/payment/classes/BxBaseModPaymentModule.php', 'f1b2db8e4df472dc20e8b5dba9bbc8b3'),
(613, 0, 'modules/base/payment/classes/BxBaseModPaymentOrders.php', 'afc5d363d30fe851fa1aa780a0c18346'),
(614, 0, 'modules/base/payment/classes/BxBaseModPaymentPage.php', 'a27c2bc1151b8370b3df6f761d61b0e2'),
(615, 0, 'modules/base/payment/classes/BxBaseModPaymentProvider.php', '855f505e78418da195f0e26edbf0b844'),
(616, 0, 'modules/base/payment/classes/BxBaseModPaymentSubscriptions.php', '7088593964823675e9b65cf77c7cb8e9'),
(617, 0, 'modules/base/payment/classes/BxBaseModPaymentTemplate.php', 'e7f483a4d9444047799686c8f5bde145'),
(618, 0, 'modules/base/payment/template/center.html', '99c5dfe4405725895f43ddf2a3459962'),
(619, 0, 'modules/base/profile/classes/BxBaseModProfileAlertsResponse.php', '824df32341348bb7ef2246d9bcfbea7d'),
(620, 0, 'modules/base/profile/classes/BxBaseModProfileCmts.php', '6af6da08235f4e518dd49b10eca7b275'),
(621, 0, 'modules/base/profile/classes/BxBaseModProfileConfig.php', 'c5617ae3da07591db0ff378fcddeefba'),
(622, 0, 'modules/base/profile/classes/BxBaseModProfileDb.php', '5be0f7dc03f1bda70f4fbb3895457c32'),
(623, 0, 'modules/base/profile/classes/BxBaseModProfileFormEntry.php', '0729ab114d734227649c6dd99f30f766'),
(624, 0, 'modules/base/profile/classes/BxBaseModProfileFormsEntryHelper.php', 'ee29af68ff5120c9a9f479fc72db7fc8'),
(625, 0, 'modules/base/profile/classes/BxBaseModProfileGridAdministration.php', '43fb776d71d6406a61cdbaf4032eddb6'),
(626, 0, 'modules/base/profile/classes/BxBaseModProfileGridCommon.php', '4a984a360539809065fc5188b5cbce2b'),
(627, 0, 'modules/base/profile/classes/BxBaseModProfileInstaller.php', '1443a2ead3ae8e8b2bea7920416f0426'),
(628, 0, 'modules/base/profile/classes/BxBaseModProfileMenuManageTools.php', 'b9a54f5054da5068756b9abb4f7b3166'),
(629, 0, 'modules/base/profile/classes/BxBaseModProfileMenuSnippetMeta.php', 'f2908f0094f73103de46260b655d4d63'),
(630, 0, 'modules/base/profile/classes/BxBaseModProfileMenuView.php', '5bb3ac83088a656c11fd33052e1401d2'),
(631, 0, 'modules/base/profile/classes/BxBaseModProfileMenuViewActions.php', '8f113a689c4fefe844ae3535c0dd7fc3'),
(632, 0, 'modules/base/profile/classes/BxBaseModProfileMenuViewActionsAll.php', '75d46a22fe21a20db013f7b9f2d78151'),
(633, 0, 'modules/base/profile/classes/BxBaseModProfileMenuViewMeta.php', '401fb7263d6747295a1ac591a5853742'),
(634, 0, 'modules/base/profile/classes/BxBaseModProfileModule.php', 'd6b67adc72ace243ab6c7b702e9a42d2'),
(635, 0, 'modules/base/profile/classes/BxBaseModProfilePageBrowse.php', 'e0c6e66d7ef8a4e2ecd41b590becd6d5'),
(636, 0, 'modules/base/profile/classes/BxBaseModProfilePageEntry.php', 'f29a0460a586ac900ca0649ec10dc425'),
(637, 0, 'modules/base/profile/classes/BxBaseModProfilePageListEntry.php', '2b88729ae6907f4e9ca16db73e08e02d'),
(638, 0, 'modules/base/profile/classes/BxBaseModProfilePrivacy.php', '6483444ae06447884480085a551c0659'),
(639, 0, 'modules/base/profile/classes/BxBaseModProfilePrivacyContact.php', '12c0e79c81e8bfc129497b254007b557'),
(640, 0, 'modules/base/profile/classes/BxBaseModProfilePrivacyPost.php', '84ee54ff6a9708e073359bdd580675b8'),
(641, 0, 'modules/base/profile/classes/BxBaseModProfileRequest.php', 'f0e310c5d98becca7dab5eed791132c5'),
(642, 0, 'modules/base/profile/classes/BxBaseModProfileSearchResult.php', '89d37aa2fe3556cdf7a58e08100dd625'),
(643, 0, 'modules/base/profile/classes/BxBaseModProfileTemplate.php', 'c4ec97f183f5f078151c02fed70d98c8'),
(644, 0, 'modules/base/profile/classes/BxBaseModProfileUploaderCoverCrop.php', 'e0eae1864a92353209b3441302e478c4'),
(645, 0, 'modules/base/profile/classes/BxBaseModProfileUploaderPictureCrop.php', '512263220098676dc46dad52fe8bd509'),
(646, 0, 'modules/base/profile/classes/BxBaseModProfileVote.php', '21a7ba0924541c6ac6007e9fd35d21f6'),
(647, 0, 'modules/base/profile/template/account_link.html', '4d795597c6e1e7956cad9de46a78e9e0'),
(648, 0, 'modules/base/profile/template/cover.html', '837b52035214d142c0239d1ced91df8d'),
(649, 0, 'modules/base/profile/template/cover_block.html', '391aeb17311b03b052541467f94c69df'),
(650, 0, 'modules/base/profile/template/css/forms.css', '3769835d5717087fc8e844e2af7d8227'),
(651, 0, 'modules/base/profile/template/css/main.css', 'bd24b6ac8c54c204cb87e417258586d9'),
(652, 0, 'modules/base/profile/template/embed.html', 'd0800cd24105b3aaf7ed84e0cfc83acf'),
(653, 0, 'modules/base/profile/template/entry-text.html', 'f0a61d8143ff71c9cbf805e552561f62'),
(654, 0, 'modules/base/profile/template/form_ghost_template.html', '380f8d6493b766998300702c12cf7765'),
(655, 0, 'modules/base/profile/template/image_popup.html', '1b82605f8a6b1c93ddcaff9b5d83674f'),
(656, 0, 'modules/base/profile/template/menu_custom_actions.html', '56d04d482c184b0f5c220b1554decf0b'),
(657, 0, 'modules/base/profile/template/menu_custom_item_actions.html', 'e90ea23fd4e647e909b03b1bd877b763'),
(658, 0, 'modules/base/profile/template/menu_main_submenu.html', '514f296f60afeb8208613e68040982c2'),
(659, 0, 'modules/base/profile/template/name_link.html', 'abdf015b661dca88d07fe43f4a997b74'),
(660, 0, 'modules/base/profile/template/picture_preview.html', '794666d00a084d4a0ff946168f8a9bc9'),
(661, 0, 'modules/base/profile/template/search_extended_results.html', '49e49ace78ef5c25991892000f433102'),
(662, 0, 'modules/base/profile/template/set_acl_popup.html', 'e4e912e3785f4ec32ae8e3b25e182d5e'),
(663, 0, 'modules/base/profile/template/unit.html', '084c428bec19ef06d2697955fa3a74f5'),
(664, 0, 'modules/base/profile/template/unit_ext.html', '9af08294c9e940bc00f5793a387c4147'),
(665, 0, 'modules/base/profile/template/unit_live_search.html', '8bb2d8f75cc69108583bf9d69b14366f'),
(666, 0, 'modules/base/profile/template/unit_meta_item.html', '1c0d4c6dcc363f84743675de6905e4b7'),
(667, 0, 'modules/base/profile/template/unit_with_cover.html', 'f8d336390234524a05ed45c71ea30599'),
(668, 0, 'modules/base/profile/template/unit_with_cover_showcase.html', 'f6fec2ceab23671eb4a8445d583e9841'),
(669, 0, 'modules/base/profile/template/unit_wo_cover.html', 'cf9f768b7bb192d3b12c8c4bae475c01'),
(670, 0, 'modules/base/profile/template/unit_wo_info.html', '54f835ee0693dad0ec320f29ea0fc92a'),
(671, 0, 'modules/base/profile/template/unit_wo_info_links.html', 'c026d0cc5ec76a8c701803b2e0487b5d'),
(672, 0, 'modules/base/profile/template/unit_wo_info_showcase.html', 'b6f08b1529b4bd27425311c10a38d6c1'),
(673, 0, 'modules/base/profile/template/unit_wo_links.html', '6542d5b6bc265653bcc76b9a30189fb6'),
(674, 0, 'modules/base/profile/template/uploader_form_crop_cover.html', 'f378c246a40c4e8618af3c62062fac0e'),
(675, 0, 'modules/base/template/classes/BxBaseModTemplateAlertsResponse.php', '86e4654fd6f8c1aee1d6dc8bf4a46706'),
(676, 0, 'modules/base/template/classes/BxBaseModTemplateConfig.php', '422896ea503dfaf0456f53079b3fa4cc'),
(677, 0, 'modules/base/template/classes/BxBaseModTemplateDb.php', '74f0a0754cc6e459c8e5aedacd9b5ee4'),
(678, 0, 'modules/base/template/classes/BxBaseModTemplateInstaller.php', '2aeabfa73111820be0b30ce0a21a9746'),
(679, 0, 'modules/base/template/classes/BxBaseModTemplateModule.php', '4f4f27c5a5e34b10b147157de9b98e73'),
(680, 0, 'modules/base/template/js/sidebar.js', '4fb312e79878226601d7dae41580c83a'),
(681, 0, 'modules/base/text/classes/BxBaseModTextAlertsResponse.php', 'ac05e678d1e9bf7f2207b36c6b47887b'),
(682, 0, 'modules/base/text/classes/BxBaseModTextConfig.php', 'bd504538a60cbb0f7ab07543c2a20560'),
(683, 0, 'modules/base/text/classes/BxBaseModTextDb.php', '5bcb1ede95b10fab78e6adb435fd121b'),
(684, 0, 'modules/base/text/classes/BxBaseModTextFormEntry.php', '07e4f82b6abfbd00f2fdcbc2631c49ed'),
(685, 0, 'modules/base/text/classes/BxBaseModTextFormPoll.php', '71a4b5825d05278dd230fbac6b189f5a'),
(686, 0, 'modules/base/text/classes/BxBaseModTextFormsEntryHelper.php', '87d0a05a7f90ff2dcfb8695ed7b4869a'),
(687, 0, 'modules/base/text/classes/BxBaseModTextGridAdministration.php', '4f151a16b32a1cf67f3dfbbbe4c10bba'),
(688, 0, 'modules/base/text/classes/BxBaseModTextGridCommon.php', 'a30bb2dfc3e5d32fe9564c22a30769f4'),
(689, 0, 'modules/base/text/classes/BxBaseModTextInstaller.php', 'b1658d25766fec49b973f2600991e264'),
(690, 0, 'modules/base/text/classes/BxBaseModTextMenu.php', '7a771b999f5587c9ce676aca3817c773'),
(691, 0, 'modules/base/text/classes/BxBaseModTextMenuAttachments.php', '6060c252533b30a8e4cd1199003a580f'),
(692, 0, 'modules/base/text/classes/BxBaseModTextMenuManageTools.php', '1d53c902d5ec3e534a8132f25bb36929'),
(693, 0, 'modules/base/text/classes/BxBaseModTextMenuSnippetMeta.php', '173127dfeb4689f6c85f8dd10ab9ab91'),
(694, 0, 'modules/base/text/classes/BxBaseModTextMenuView.php', '978d8f18fb60b4daff046f2fbc12cd7c'),
(695, 0, 'modules/base/text/classes/BxBaseModTextMenuViewActions.php', '38e9588cb3664aea1f679a7ea23d5ff4'),
(696, 0, 'modules/base/text/classes/BxBaseModTextModule.php', '3f502189d43f5c8f2e4180c880334ed4'),
(697, 0, 'modules/base/text/classes/BxBaseModTextPageAuthor.php', 'c4791f3b80dff1ce3a6cf54b1bf9f626'),
(698, 0, 'modules/base/text/classes/BxBaseModTextPageBrowse.php', 'f6934708ec54bf8a4d0978dfc9741e8d'),
(699, 0, 'modules/base/text/classes/BxBaseModTextPageEntry.php', 'ff3f7da51a990cb7224fdc4a4f9afbf3'),
(700, 0, 'modules/base/text/classes/BxBaseModTextPageListEntry.php', '581306d9074a57299762d6f1e92feb31'),
(701, 0, 'modules/base/text/classes/BxBaseModTextRequest.php', '3a61c0335e989a91351996a4fd948af5'),
(702, 0, 'modules/base/text/classes/BxBaseModTextSearchResult.php', 'e0dfc25e0686b7cdea9d8a0a70b8e0ff'),
(703, 0, 'modules/base/text/classes/BxBaseModTextTemplate.php', '47fdef9aad47274f7b26e503772fbd85'),
(704, 0, 'modules/base/text/classes/BxBaseModTextUploaderHTML5.php', 'a2ccd615b44ac747757e0f1179095c0e'),
(705, 0, 'modules/base/text/classes/BxBaseModTextUploaderHTML5Attach.php', 'b30e78c41c8e6012f2f5a1824b4ab4cd'),
(706, 0, 'modules/base/text/classes/BxBaseModTextUploaderRecordVideo.php', '32b2442bb31cf084ca5e17ab7948ebce'),
(707, 0, 'modules/base/text/classes/BxBaseModTextUploaderRecordVideoAttach.php', '27dcb84db74cca242b13bcdbbb985f6d'),
(708, 0, 'modules/base/text/classes/BxBaseModTextVotePollAnswers.php', 'fd7ca9ba0c54d7b93ee7edd673a9c561'),
(709, 0, 'modules/base/text/js/links.js', '0d9d5c2aac9faf2ea177932b3cc2a17f'),
(710, 0, 'modules/base/text/js/manage_tools.js', '5d834b7ae41a80220a71a6ed0b7bfa5f'),
(711, 0, 'modules/base/text/js/polls.js', '1530885f95b13a945b9b14e47ed4672f'),
(712, 0, 'modules/base/text/template/attach_link_form.html', 'af7e5ce6f173a6e7109291290b9b4645'),
(713, 0, 'modules/base/text/template/attach_link_form_field.html', 'f9cfd9768f26df4dab46cbf3192c4dac'),
(714, 0, 'modules/base/text/template/attach_link_item.html', 'b524b682a173c63e8a90b0ea16e74076'),
(715, 0, 'modules/base/text/template/author.html', '11d368515b614f2c8d34ee0a2529d1a3'),
(716, 0, 'modules/base/text/template/css/forms.css', '166c22078b61aac0986ceff21632a851'),
(717, 0, 'modules/base/text/template/css/links.css', '7c341a0dcb88f8a882acce9687ea3d2e'),
(718, 0, 'modules/base/text/template/css/main-media-phone.css', '9999ef47a67d716fbf55a07873012533'),
(719, 0, 'modules/base/text/template/css/main.css', 'a8a664d6866eda0f932a274b95ffbb0b'),
(720, 0, 'modules/base/text/template/css/polls.css', 'd56d17aec0637d96241783430198f1d4'),
(721, 0, 'modules/base/text/template/entry-text.html', '6c1736236bc7f432228f24391ae004dc'),
(722, 0, 'modules/base/text/template/form_ghost_template.html', '5642d515f517ba99ed5a8cfb2d3f0c54'),
(723, 0, 'modules/base/text/template/form_ghost_template_cover.html', '4dfe1775e59eddda0e58b915f47f7557'),
(724, 0, 'modules/base/text/template/form_ghost_template_file.html', 'b3351706eff912cba002cca04913aed3'),
(725, 0, 'modules/base/text/template/form_ghost_template_sound.html', 'eaa2b488a1f337ebd98195ea36400806'),
(726, 0, 'modules/base/text/template/form_ghost_template_video.html', '880b300a99625ad1487b8bffd67311cf'),
(727, 0, 'modules/base/text/template/link_embed_common.html', '614608e543c82719859fc8fbe13b9fdf'),
(728, 0, 'modules/base/text/template/link_embed_provider.html', 'a304d589b4a1c4046a42059b78d4e509'),
(729, 0, 'modules/base/text/template/media-exif-value.html', '965b45097642f1cb739ad734a7b9d169'),
(730, 0, 'modules/base/text/template/media-exif.html', 'c617f18fce42a23d561d508d9f63c00e'),
(731, 0, 'modules/base/text/template/menu_custom_actions.html', '56d04d482c184b0f5c220b1554decf0b'),
(732, 0, 'modules/base/text/template/menu_custom_item_actions.html', 'e90ea23fd4e647e909b03b1bd877b763'),
(733, 0, 'modules/base/text/template/poll_answer_ve_block.html', '45ff9602bca6dd326a5eacd4d84a7cf1'),
(734, 0, 'modules/base/text/template/poll_form.html', '682d2d557bd37d8ebb78d891c1fced25'),
(735, 0, 'modules/base/text/template/poll_form_answers.html', '62e255e790e277dd264b6c9bf40e7da0'),
(736, 0, 'modules/base/text/template/poll_form_field.html', '268f9d9621d83a35e07810a5eb721669'),
(737, 0, 'modules/base/text/template/poll_item.html', '7d1faac919eaf9db95c8f6744f4cba69'),
(738, 0, 'modules/base/text/template/poll_items.html', 'ef6e0c7890289b24e25b7fa80e6b1ca1'),
(739, 0, 'modules/base/text/template/poll_items_embed.html', 'e8d48e44191a46f49ae26eed27c46e38'),
(740, 0, 'modules/base/text/template/poll_items_showcase.html', '882feb0588098c3626cd92a24bb6127d'),
(741, 0, 'modules/base/text/template/poll_item_answers.html', 'e8e432f7e549a82588868b516953825b'),
(742, 0, 'modules/base/text/template/poll_item_results.html', '98184bede09075fc6d29d82742231e45'),
(743, 0, 'modules/base/text/template/title_link.html', 'abdf015b661dca88d07fe43f4a997b74'),
(744, 0, 'modules/base/text/template/unit.html', '724bf26c78c3a168f6d9580a07f3c73e'),
(745, 0, 'modules/base/text/template/unit_full.html', '7ef7a77f7bd0691ac50ac1035555b525'),
(746, 0, 'modules/base/text/template/unit_full_private.html', '4b32685cea6ae1d924589116e83a59ae'),
(747, 0, 'modules/base/text/template/unit_gallery.html', '0f56e904bb76357bb517548dfcdf4e9b'),
(748, 0, 'modules/base/text/template/unit_gallery_private.html', 'f8e1356f59ebe7d18d0fb3b8b295ba2f'),
(749, 0, 'modules/base/text/template/unit_live_search.html', 'b8b102ac1a872cb4e0c607f773f11619'),
(750, 0, 'modules/base/text/template/unit_private.html', '67843775fabdbf090d1604a05fa7e797'),
(751, 0, 'modules/base/text/template/unit_showcase.html', '7d58197e9983b13b7e02cf34eea16ff5'),
(752, 0, 'modules/base/text/template/uploader_button_record_video_attach.html', 'd41d8cd98f00b204e9800998ecf8427e'),
(753, 0, 'periodic/cron.php', '158d7ac777d421c48419887ae219b4de'),
(754, 0, 'studio/agents.php', 'df73eb94250f87729b6e1147bb91008d'),
(755, 0, 'studio/ajax.php', '5d8a77f2086ebead3681d748e54b4bd6'),
(756, 0, 'studio/api.php', 'bef2d12eb103393c316573c5faf13af2'),
(757, 0, 'studio/audit.php', 'fe119b72ff5778142f31b1762e880005'),
(758, 0, 'studio/badges.php', '222065bfbed429b1e0a0d37127578ccb'),
(759, 0, 'studio/builders.php', '177d0badfe21e241a5d164eb66985e43'),
(760, 0, 'studio/builder_forms.php', '6bdf66e9a51218ca0904429ffc08e2a3'),
(761, 0, 'studio/builder_menu.php', 'a851399902df7e7067ea4e5b70ce3f76'),
(762, 0, 'studio/builder_page.php', 'c0f14883e1868d2e809083e661118d37'),
(763, 0, 'studio/builder_permissions.php', '2de4a76fcf50343801ddfae9d7708713'),
(764, 0, 'studio/builder_roles.php', 'ae64f5164c79224bc896ea113aa2f721'),
(765, 0, 'studio/classes/BxDolStudioAgents.php', '4af558fa984d5ff2bfc65d61580538ae'),
(766, 0, 'studio/classes/BxDolStudioAgentsAssistants.php', '776e3153d02664f75fbf2b30e59b1e01'),
(767, 0, 'studio/classes/BxDolStudioAgentsAsstChats.php', '07d4f838907dd7ccc4f30020db7cf2dc'),
(768, 0, 'studio/classes/BxDolStudioAgentsAsstChatsCmts.php', '4bd04a3d86c1a4ba74269887234b6c83'),
(769, 0, 'studio/classes/BxDolStudioAgentsAsstFiles.php', '115332d6c0e32651655422098f2be971'),
(770, 0, 'studio/classes/BxDolStudioAgentsAutomators.php', 'de2bd9dd0b7fac9a901d37f9ee9fbd2e'),
(771, 0, 'studio/classes/BxDolStudioAgentsAutomatorsCmts.php', '269bb16b9a9750bf5566b563f9b9082c'),
(772, 0, 'studio/classes/BxDolStudioAgentsHelpers.php', 'ac8d934133373e286664bc30d919bc0e'),
(773, 0, 'studio/classes/BxDolStudioAgentsProviders.php', '042358d6eec4741548e5b00a2376f3c3'),
(774, 0, 'studio/classes/BxDolStudioAgentsQuery.php', '9d4500ca0cf85745d4ca58b090aac24c'),
(775, 0, 'studio/classes/BxDolStudioAPI.php', '7b0d37bfc4132c522773f783e2dd5ec1'),
(776, 0, 'studio/classes/BxDolStudioApiKeys.php', '2d09847bd79c6df48375942e987e41d8'),
(777, 0, 'studio/classes/BxDolStudioApiOrigins.php', 'e7bb9741ec656a9bb8a0bab544dcfe28'),
(778, 0, 'studio/classes/BxDolStudioAudit.php', '014ec211b659f42fb278e52b502fb43d'),
(779, 0, 'studio/classes/BxDolStudioBadges.php', 'bdd679e905b8e9a05efe131930c66018'),
(780, 0, 'studio/classes/BxDolStudioBadgesGrid.php', '85461329802d29fd16707dbeb681193d'),
(781, 0, 'studio/classes/BxDolStudioBuilderPage.php', '566aaa94ffe14cc7d2b8eb936d363ce2'),
(782, 0, 'studio/classes/BxDolStudioBuilderPageQuery.php', '93eaae522a006c794f25bfa2945ca4ab'),
(783, 0, 'studio/classes/BxDolStudioCart.php', 'f8e673e58228e77e958842e212b07800'),
(784, 0, 'studio/classes/BxDolStudioDashboard.php', '44b088c0478c9749dc83c4e6d3dc9ef4'),
(785, 0, 'studio/classes/BxDolStudioDashboardQuery.php', '0cf227c97ea24510448e3d6eb55f33c2'),
(786, 0, 'studio/classes/BxDolStudioDesign.php', '2040cd1931da057a06438c4b96a46996'),
(787, 0, 'studio/classes/BxDolStudioDesigner.php', '5899580261ee39fd9da12822766e79d1'),
(788, 0, 'studio/classes/BxDolStudioDesignerQuery.php', '744689d27477bf239846e56d8e0b0b7c'),
(789, 0, 'studio/classes/BxDolStudioDesigns.php', 'bcea79c934029879085ca6f530679e4b'),
(790, 0, 'studio/classes/BxDolStudioDesignsQuery.php', '819a07cd08022b97672d4e6fd0f2ecd3'),
(791, 0, 'studio/classes/BxDolStudioForm.php', 'd1aae6472f6d153f200780e0e18b05c4'),
(792, 0, 'studio/classes/BxDolStudioForms.php', '0afb0268ddbd545cc82898b0e812194d'),
(793, 0, 'studio/classes/BxDolStudioFormsCategories.php', 'f5342abf292318a2dabd56ecafeffe86'),
(794, 0, 'studio/classes/BxDolStudioFormsDisplays.php', '1ed5334dbb2c1c586b202f8d7128ebb4'),
(795, 0, 'studio/classes/BxDolStudioFormsField.php', 'd942be2bbc22f408a5753abff0b1f3ba'),
(796, 0, 'studio/classes/BxDolStudioFormsFields.php', '08cbfff4e4151c3ec4050e29d77d0586'),
(797, 0, 'studio/classes/BxDolStudioFormsForms.php', 'f54eb3be5c60d5a9b29b171d6413ace7'),
(798, 0, 'studio/classes/BxDolStudioFormsGroupsRoles.php', '6ff582ac5e2e601981c052e02378ccc7'),
(799, 0, 'studio/classes/BxDolStudioFormsLabels.php', '0f10c3988c4380d1867c31635eb38b83'),
(800, 0, 'studio/classes/BxDolStudioFormsPreLists.php', 'c81c73b915893371456f40d9598ff369'),
(801, 0, 'studio/classes/BxDolStudioFormsPreValues.php', 'dcde9f1653cc0266bc6dd8ba693b3294'),
(802, 0, 'studio/classes/BxDolStudioFormsQuery.php', '8355ba2f3f07dc3dd89033d0b5494256'),
(803, 0, 'studio/classes/BxDolStudioFormsSearchFields.php', '7ee2f6b1e2508a4b1b43e8edb88a5089'),
(804, 0, 'studio/classes/BxDolStudioFormsSearchForms.php', '3ec6aefeecaf97bb5d8f89507648ab2b'),
(805, 0, 'studio/classes/BxDolStudioGrid.php', 'f8745b2a67b4964036b1a8acbbc099ea'),
(806, 0, 'studio/classes/BxDolStudioGridStorages.php', '0154dfdba81432b23e9e9aeafb191419'),
(807, 0, 'studio/classes/BxDolStudioInstaller.php', '3e18ca320db22c5241bb437bebd86fae'),
(808, 0, 'studio/classes/BxDolStudioInstallerQuery.php', '8b62f9d1f123639da0f3cbcf31ebacbe'),
(809, 0, 'studio/classes/BxDolStudioInstallerUtils.php', 'da3181b8fc0a16246c209f5a02f9779c'),
(810, 0, 'studio/classes/BxDolStudioJson.php', '5df2c7a618082674927871f182065004'),
(811, 0, 'studio/classes/BxDolStudioLanguage.php', '234dab449de5cda08ed6f789616eea1e'),
(812, 0, 'studio/classes/BxDolStudioLanguages.php', 'e0322be8ed6609b0a08dbc81af8a2cbe'),
(813, 0, 'studio/classes/BxDolStudioLanguagesQuery.php', 'c0b8c37e4fb7d366c97d8213de3d5575'),
(814, 0, 'studio/classes/BxDolStudioLanguagesUtils.php', '6fb56059373491f55c4fe8d131318169'),
(815, 0, 'studio/classes/BxDolStudioLanguagesUtilsQuery.php', '79175cbad230582df8b967bd05190d31'),
(816, 0, 'studio/classes/BxDolStudioLauncher.php', '15075140bae69c49b220eeaccbe91d6a'),
(817, 0, 'studio/classes/BxDolStudioMenu.php', '94a1376633c532c000d343db38449e99'),
(818, 0, 'studio/classes/BxDolStudioMenuAccountPopup.php', 'f00a1d3506551a2d43e28d3cde49ae56'),
(819, 0, 'studio/classes/BxDolStudioMenuTop.php', 'ab3a020d7742042901911d550d09d73c'),
(820, 0, 'studio/classes/BxDolStudioModule.php', 'fe36bda072fe5b096a0185957696777d'),
(821, 0, 'studio/classes/BxDolStudioModules.php', 'bfb6fc803ca68970e49aa0da62291d12'),
(822, 0, 'studio/classes/BxDolStudioModulesQuery.php', 'a2d192dbe78fac5a0c3a31e85df14ae0'),
(823, 0, 'studio/classes/BxDolStudioNavigation.php', '5476e99b191ef2a84dac1fa1b300a25b'),
(824, 0, 'studio/classes/BxDolStudioNavigationImport.php', '19331d1d014e41453dea394272c20193'),
(825, 0, 'studio/classes/BxDolStudioNavigationItems.php', '44b0db57d2dac82d197632b3ee56b481'),
(826, 0, 'studio/classes/BxDolStudioNavigationMenus.php', '1b27312f1dd94c777697ebc279342473'),
(827, 0, 'studio/classes/BxDolStudioNavigationQuery.php', 'dc0efb15a4fdec1f4ced06b492f473f7'),
(828, 0, 'studio/classes/BxDolStudioNavigationSets.php', '98b91d43a4dea574e178feedbd35e882'),
(829, 0, 'studio/classes/BxDolStudioOAuth.php', '332148b6178c35d16ebc9c96ddfd0311'),
(830, 0, 'studio/classes/BxDolStudioOAuthLib.php', 'c98d0fbde999735c1b3d8cdbc34d0d57'),
(831, 0, 'studio/classes/BxDolStudioOAuthOAuth1.php', '57842b839082884a1288381932d391c6'),
(832, 0, 'studio/classes/BxDolStudioOAuthOAuth2.php', '924111158f0c26f811ec97a638ee9b85'),
(833, 0, 'studio/classes/BxDolStudioOAuthPlugin.php', '574bed66cbb8f76833a937dd990412d0'),
(834, 0, 'studio/classes/BxDolStudioOptions.php', '90f57f2994572b44c81d04c887d061b2'),
(835, 0, 'studio/classes/BxDolStudioOptionsApi.php', 'ff292b262e4b389dd4ded2de0717530c'),
(836, 0, 'studio/classes/BxDolStudioOptionsQuery.php', 'bef2dead8255ec1c10a40f7a74d3cbea'),
(837, 0, 'studio/classes/BxDolStudioPage.php', '1390949c26f531c6cd5e7c53185aff93'),
(838, 0, 'studio/classes/BxDolStudioPageQuery.php', '83c2aa1fd4c042a5761f916e502ad556'),
(839, 0, 'studio/classes/BxDolStudioPermissions.php', 'b5efffc519e06f13d2a30502891e85b7'),
(840, 0, 'studio/classes/BxDolStudioPermissionsActions.php', 'c7a62311b816a60e96f875c6ce035ad1'),
(841, 0, 'studio/classes/BxDolStudioPermissionsLevels.php', 'ccb757cd776a2f23bb30eac44e6ec229'),
(842, 0, 'studio/classes/BxDolStudioPermissionsQuery.php', 'f4f9f4ed3f6ef98be53a9724916de109'),
(843, 0, 'studio/classes/BxDolStudioPolyglot.php', 'fce3dffa867d01f9ecdef2860f8d4c07'),
(844, 0, 'studio/classes/BxDolStudioPolyglotEtemplates.php', '6704512b349700edc8bd725c39376eff'),
(845, 0, 'studio/classes/BxDolStudioPolyglotKeys.php', 'd03d2745dfcd00c693bd28b346e90742'),
(846, 0, 'studio/classes/BxDolStudioPolyglotQuery.php', 'a94c3795e15e7addb8670502e6417531'),
(847, 0, 'studio/classes/BxDolStudioRoles.php', '1bf24af4174418b486dac2d50caf5c80'),
(848, 0, 'studio/classes/BxDolStudioRolesActions.php', 'c6a7c481d5b610cc486148ca182f8cc2'),
(849, 0, 'studio/classes/BxDolStudioRolesLevels.php', '98cb2446be0150258e0979c15c72d5df'),
(850, 0, 'studio/classes/BxDolStudioRolesQuery.php', 'b0f56da3771a5cf1fd466ca3d4196cc1'),
(851, 0, 'studio/classes/BxDolStudioRolesUtils.php', '3ef27c643cff3c2725574894d71dc942'),
(852, 0, 'studio/classes/BxDolStudioRssModuleHelp.php', '318ee5363ab23e7865c8cab5b0bba4b4'),
(853, 0, 'studio/classes/BxDolStudioRssPageHelp.php', 'e726bbb595d8136d04bee13ca6033ee9'),
(854, 0, 'studio/classes/BxDolStudioSettings.php', '39081b7f8ce3128e974a600d4e3bff9e'),
(855, 0, 'studio/classes/BxDolStudioSettingsQuery.php', 'b705c452831547313061da9ce7941014'),
(856, 0, 'studio/classes/BxDolStudioStorages.php', '0e45bee365e4b80e99b44b761a40c133'),
(857, 0, 'studio/classes/BxDolStudioStoragesFiles.php', '6376c7521420cc71a662bde0158e17c7'),
(858, 0, 'studio/classes/BxDolStudioStoragesImages.php', '307bf15820be784ce903c343e0b7b08f'),
(859, 0, 'studio/classes/BxDolStudioStoragesQuery.php', '10e270069e8e8cf25748509e7679d51b'),
(860, 0, 'studio/classes/BxDolStudioStore.php', '997a93277a1be72d1da7bba9edbae088'),
(861, 0, 'studio/classes/BxDolStudioStoreQuery.php', '9eaeb2c5a3a972d46889ef8202a26b65'),
(862, 0, 'studio/classes/BxDolStudioTemplate.php', '7141d5f81c49ec46cb7da6c939d63eae'),
(863, 0, 'studio/classes/BxDolStudioTools.php', 'b21f2f31222ee277e69a737c61ea9dc1'),
(864, 0, 'studio/classes/BxDolStudioToolsAudit.php', 'bc5118c72c9c9342769bdd97de7c9ece'),
(865, 0, 'studio/classes/BxDolStudioUpdater.php', '1ba904c95b0410907c4fd709732f1066'),
(866, 0, 'studio/classes/BxDolStudioUtils.php', '74247c20fd9012e568ba6fd10c59b2a2'),
(867, 0, 'studio/classes/BxDolStudioWidget.php', '1aeb53c95bed3ff7d54cee6d6be137f5'),
(868, 0, 'studio/classes/BxDolStudioWidgets.php', '7682fa7b36252d4fc502b3fd7d24eab2'),
(869, 0, 'studio/classes/BxDolStudioWidgetsQuery.php', 'f10012ed45dd528959f8b0f1c7df7133'),
(870, 0, 'studio/dashboard.php', '2496d9623f265838ac3b6f225557f7ec'),
(871, 0, 'studio/design.php', '6459e0de83a7d6a639391143d5f430ac'),
(872, 0, 'studio/designer.php', '49a98ac5ee3957897e060d6c4f3b7339'),
(873, 0, 'studio/inc/utils.inc.php', '42cd6e1cb7f0602469cc6a3213e7816f'),
(874, 0, 'studio/index.php', 'f97ca3f02af303923c2d6e5c562c60f7'),
(875, 0, 'studio/js/agents.js', 'fcc97c8ba16f9d93514bac4f14b4e0e0'),
(876, 0, 'studio/js/builder_page.js', 'ef079aa9b4493b8fcae089edb189a175'),
(877, 0, 'studio/js/dashboard.js', '79bf5340f02922eac7a44ee0ab645151'),
(878, 0, 'studio/js/design.js', 'c2c9268d87be38e7dc6045a82a926e44'),
(879, 0, 'studio/js/designer.js', '5e2b315d8f9193728213110759010a1f'),
(880, 0, 'studio/js/forms.js', '41b80a36c86274d373586eb7ae666663'),
(881, 0, 'studio/js/forms_badges.js', '795c5a1e9148e0b36e0caa9175c43923'),
(882, 0, 'studio/js/forms_categories.js', 'b61a2374173077024fe1a5b6560a7c01'),
(883, 0, 'studio/js/forms_displays.js', 'ed0f6885dab289de478cd13c0cd8d22a'),
(884, 0, 'studio/js/forms_fields.js', 'c3c214e6aef37a5024dc10c2d85869c7'),
(885, 0, 'studio/js/forms_forms.js', '9a9fbefabef11a3ccdc6ca92c7ffa4bf'),
(886, 0, 'studio/js/forms_groups_roles.js', 'ebbe8444c9c431d7cc9367ddfb08d8e1'),
(887, 0, 'studio/js/forms_lists.js', '6e3b270a73d50956344bf51e4c0dfad8'),
(888, 0, 'studio/js/forms_search_fields.js', '05e4eca753ec6861922c2791c2b1a03a'),
(889, 0, 'studio/js/forms_search_forms.js', 'a052160344e1fce01d5ebf9f16e96b96'),
(890, 0, 'studio/js/forms_sortable_fields.js', '8435e42761965928daf250b60eb573ee'),
(891, 0, 'studio/js/forms_values.js', '8d7aef44f1dca06ae0e0b212b35ba3c9'),
(892, 0, 'studio/js/language.js', '9bd33c68d2e2a8d6c67b67bb9801d221'),
(893, 0, 'studio/js/launcher.js', '9c5a24af2a6ccf1b204bb94ad1620015'),
(894, 0, 'studio/js/login.js', 'a65ed47fd9b88548b0e0463aeddc71e7'),
(895, 0, 'studio/js/menu_top.js', '26bacb9a595d73504cf69fd3e496bc71'),
(896, 0, 'studio/js/module.js', 'ca83e00695aa5df779ec81ef5e7d31bc'),
(897, 0, 'studio/js/navigation_import.js', '10ea8cc0f1dc304db960bc9b9d52c5a0'),
(898, 0, 'studio/js/navigation_items.js', 'ad508f7201b9528bdae431bb9d17f894'),
(899, 0, 'studio/js/navigation_menus.js', '0d73fd0ff15d7973ecadc2e2ef6ae644'),
(900, 0, 'studio/js/navigation_sets.js', '65883efba1e1af49410461c3e17ea5cc'),
(901, 0, 'studio/js/options.js', '2997f839380bfc1c71efb9df5547b45c'),
(902, 0, 'studio/js/page.js', 'b24e02daf07888718567847ba783e3b6'),
(903, 0, 'studio/js/permissions.js', 'c5850d337ad7ca80d06960479a04a65f'),
(904, 0, 'studio/js/permissions_actions.js', '617cc4639810d8652c165cc8ca9f3397'),
(905, 0, 'studio/js/permissions_levels.js', 'c3fd661730e253aed671a37c23baf134'),
(906, 0, 'studio/js/permissions_prices.js', '1cb8cf91a90cb98403cd3b58a4d44c3a'),
(907, 0, 'studio/js/polyglot.js', '283186e5c86faee123d34efaaac1ced6'),
(908, 0, 'studio/js/polyglot_etemplates.js', '8b34b07370408a9bdfe9752c8ffe0346'),
(909, 0, 'studio/js/polyglot_keys.js', '54d8f1bdc13a53b03ffeefe6a787871c'),
(910, 0, 'studio/js/roles.js', '618e4e3de2a604f91ddd8903b3943364'),
(911, 0, 'studio/js/roles_actions.js', '380f13a3104468cf8353f8b18727e48b'),
(912, 0, 'studio/js/roles_levels.js', 'b851ef6e58e3ba75777ce263c47f535f'),
(913, 0, 'studio/js/settings.js', '9f49952d0ad9e6b85335d8daca4c75d6'),
(914, 0, 'studio/js/store.js', 'ebee36b2d91084abf80f2523f7c44190'),
(915, 0, 'studio/language.php', '3e3d00820f7308c7542332d234d60bc1'),
(916, 0, 'studio/launcher.php', '375e6def9806346bad7f7f8e51b45f88'),
(917, 0, 'studio/module.php', '8af83547a38db46f90ca0b43ebfeb9d1'),
(918, 0, 'studio/options.php', 'de962872d4c5a688721ee50bf64de011'),
(919, 0, 'studio/polyglot.php', 'a68c1a6969d774968a21fd3198f292a3'),
(920, 0, 'studio/settings.php', 'b7c24ccdba9ba57548755517e5bf329a'),
(921, 0, 'studio/storages.php', '2d963801093fe017b23edc3d16a92f6e'),
(922, 0, 'studio/store.php', 'b49bdf4e19fe21dc73400d87d0ad2637'),
(923, 0, 'studio/template/agents_assistant_codes.html', '3ea72469c6a4523ccf61f2c267ba3a26'),
(924, 0, 'studio/template/agents_assistant_info.html', '4bfc2c14978b71e4d2bff518e54e4a93'),
(925, 0, 'studio/template/agents_automator_form.html', 'f60830e35a489ddcad62ea74abdcddba'),
(926, 0, 'studio/template/agents_automator_form_assistants.html', '589152ced503f31f0b10fd35981087f2'),
(927, 0, 'studio/template/agents_automator_form_helpers.html', '2c413be8ea23a5ce920b86f38e24c5da'),
(928, 0, 'studio/template/agents_automator_form_providers.html', '63b68aa1a0ead9898c9957b3b332ef92'),
(929, 0, 'studio/template/agents_automator_info.html', 'd96ef40ad87a91979796cf0594439285'),
(930, 0, 'studio/template/agents_comment_content.html', 'f6dcae610205bb1dce84264660d73864'),
(931, 0, 'studio/template/agents_provider_form.html', 'e8795499f2da1fbe10ee7243096c9b29'),
(932, 0, 'studio/template/audit.html', '84666223aa9fe46bad572e207d167703'),
(933, 0, 'studio/template/badges.html', '84666223aa9fe46bad572e207d167703'),
(934, 0, 'studio/template/block_caption.html', 'ed1225495f8eca7a900ea94da96fe8d6'),
(935, 0, 'studio/template/block_panel_bottom.html', '415e594a13c5fa0b9ed90581d1b894d0'),
(936, 0, 'studio/template/block_panel_top.html', 'f7ebb8cdf8925c9aa477371d59de83fa'),
(937, 0, 'studio/template/bp_add_block.html', '75af45ea24e15820dd702b11a846b9a8'),
(938, 0, 'studio/template/bp_add_block_form.html', 'c6cddc3715bbf53c0bb545ade46f4195'),
(939, 0, 'studio/template/bp_add_page.html', '72ccd484501f20b5dba1a173dd856542'),
(940, 0, 'studio/template/bp_blocks.html', '6e9191013d52b32f198e836b163b478d'),
(941, 0, 'studio/template/bp_blocks_list.html', '031562f5ea5c152b94b4476d46f5de56'),
(942, 0, 'studio/template/bp_block_panel_top.html', '49b72b5f6e2b6820946fc533f026c501'),
(943, 0, 'studio/template/bp_block_skeleton_creative.html', 'd4346b07420a6c8d43806e416646ddc0'),
(944, 0, 'studio/template/bp_cell.html', '1aadd011a7a90155a5d6d57e8c20642f'),
(945, 0, 'studio/template/bp_edit_page.html', 'b090be529bcb66271f8e0b4763126ec2'),
(946, 0, 'studio/template/bp_edit_page_form.html', 'f6516c2c02a55fc218e22c67b39c0fda'),
(947, 0, 'studio/template/bp_fgt_attachments.html', '76ce42a024d9854b2245abccf6316097'),
(948, 0, 'studio/template/bp_layouts.html', '598102de911c5dafca0e130d1535f26d'),
(949, 0, 'studio/template/breadcrumb.html', '9c6f426ccf20b5153556f7a2ff02aced'),
(950, 0, 'studio/template/builder_block.html', '43c92ba897eee96a778b23d0034a5757'),
(951, 0, 'studio/template/builder_page.html', '83b403cb350f3d0365eadfdca0a973dc'),
(952, 0, 'studio/template/css/agents.css', 'ede8094bab8ea47285e0f17d1028d7f7'),
(953, 0, 'studio/template/css/badges.css', 'fa65d8059f389acda10fed3255ccfac9'),
(954, 0, 'studio/template/css/builder.css', 'e34fed78bb0af237d27f05c0ff920ae0'),
(955, 0, 'studio/template/css/builder_forms.css', '588581cb8ca4ba5268f60b9027be8edc'),
(956, 0, 'studio/template/css/builder_page.css', '57f014e77838705f8ff5817f54e50416'),
(957, 0, 'studio/template/css/common.less', 'cd0a722972ba4f702931241cd49220b6'),
(958, 0, 'studio/template/css/cover.css', 'a3c65b393f722e3008f2e00a69e53e87'),
(959, 0, 'studio/template/css/dashboard.css', '72f2c86bb1e9103588d4130bb27100af'),
(960, 0, 'studio/template/css/default.less', 'b5816b2eb49f9a93bbb3cc84beb92fe1'),
(961, 0, 'studio/template/css/designer.css', 'de66d65a50c118a663f462692c4678c8'),
(962, 0, 'studio/template/css/forms.css', 'e0e70800ecf6176ae4c945c6b15d7ea1'),
(963, 0, 'studio/template/css/general.css', 'ece7caad24cfa74d03bb8d5e01945bc3'),
(964, 0, 'studio/template/css/grid.css', 'ecbb80f03d8cddfc6b169a6d642d388c'),
(965, 0, 'studio/template/css/launcher.css', '7a2bf56c1dad55bfef38fc13404c4628'),
(966, 0, 'studio/template/css/login.css', 'b9671e05fb5fdc964f7e92f8cdf2de9e'),
(967, 0, 'studio/template/css/menu.css', '73ed4e75e6c1b6419f54fae67f7ebdb0'),
(968, 0, 'studio/template/css/menu_top.css', '40f6762ba8ff7a42f31b204922c5a17f'),
(969, 0, 'studio/template/css/module.css', 'c202ec4f7f043c592486e8a1fb8fa0b8'),
(970, 0, 'studio/template/css/navigation.css', 'fe7649efb7ff0c1868ce8f215997e5ae'),
(971, 0, 'studio/template/css/options.css', '32764492a9da2b456f9d421641dbff1f'),
(972, 0, 'studio/template/css/page-media-desktop.css', 'd16c65b2b5d8c20a6bd12b35859adc96'),
(973, 0, 'studio/template/css/page-media-tablet.css', '65e63b28b2afc8480908264349df8e84'),
(974, 0, 'studio/template/css/page.css', '45295f5813be2e1759268f9c8894fecf'),
(975, 0, 'studio/template/css/page_columns.css', '38be23b12f58013d128fc71b3dfba843'),
(976, 0, 'studio/template/css/permissions.css', 'ef1e4a875882f0a043c87f7804927a3e'),
(977, 0, 'studio/template/css/polyglot.css', '8a69cd7676a486bd9c0dbd9373944d0e'),
(978, 0, 'studio/template/css/roles.css', '88931b1bb54948ba8a209ad940a57afb'),
(979, 0, 'studio/template/css/settings.css', 'a55d8090c398850390be6a562b2d3cdc'),
(980, 0, 'studio/template/css/storages.css', '305986ead492a3b96f1955d7a91f0ea9'),
(981, 0, 'studio/template/css/store-media-desktop.css', 'cd8cbe34df468cf39eab754f1f0aa332'),
(982, 0, 'studio/template/css/store-media-tablet.css', '7be4a9519530886e7ff4545c7bbae2c7'),
(983, 0, 'studio/template/css/store.css', 'ff3b4d06443038c69ce9de37fdda3c4b'),
(984, 0, 'studio/template/css/uploaders.css', 'd45dd64ed9c8a8431279df31ee4c318d'),
(985, 0, 'studio/template/dbd_cache.html', '709ac060eb0b80133612fb5bd861db0a'),
(986, 0, 'studio/template/dbd_htools.html', '8565502fb68c14691d36a60cb6ba2653'),
(987, 0, 'studio/template/dbd_space.html', '74f1d64c4763cac3d2150e28263b4e74'),
(988, 0, 'studio/template/dbd_versions.html', '359f2f3f366f8c86e58d8c77e1b3f3eb'),
(989, 0, 'studio/template/default.html', '0c15a6450605e389b6403086c3137f9a'),
(990, 0, 'studio/template/design.html', '84666223aa9fe46bad572e207d167703'),
(991, 0, 'studio/template/designbox_11.html', '4555177c10e208b67c1270993576580d'),
(992, 0, 'studio/template/designer.html', '84666223aa9fe46bad572e207d167703'),
(993, 0, 'studio/template/dsn_action_result.html', '275f4cd78b35d9368661418fc2b9ed47'),
(994, 0, 'studio/template/dsn_confirm.html', 'b648ace34b57e8ae02e8dd6f38861cc1'),
(995, 0, 'studio/template/dsn_page_caption.html', '652590cc376abec94f5d08ff38048d2e'),
(996, 0, 'studio/template/dsr_cover.html', 'bae9ff72d7a23c6dcf883ffb6cd59466'),
(997, 0, 'studio/template/dsr_cover_preview.html', '2c2d8064175c09cce645df63e437ab44'),
(998, 0, 'studio/template/dsr_cover_preview_page.html', 'e1c740351fc02ffcd3f917e717426466'),
(999, 0, 'studio/template/dsr_cover_preview_unit_profile.html', 'a9418e9b5b74005e3f43985210f03b0b'),
(1000, 0, 'studio/template/dsr_icon.html', 'b0e18075390ed46e98f0c98ea39b73eb'),
(1001, 0, 'studio/template/dsr_icon_preview.html', 'c044d53c15643c07aede4e571d353f30'),
(1002, 0, 'studio/template/dsr_injections.html', 'e63385af2a7ac460457b9a6e4db98e7a'),
(1003, 0, 'studio/template/dsr_logo.html', '226388ee7e87a663a09785680de07003'),
(1004, 0, 'studio/template/dsr_splash.html', 'eefc016dfa417ba0b5a65cb9c9d80f2f'),
(1005, 0, 'studio/template/forms.html', '9bcc33f1e8eb2af480306d362a319e1a'),
(1006, 0, 'studio/template/forms_audit.html', 'e9bc03c6b25ca4efee3956b68619fba3'),
(1007, 0, 'studio/template/forms_badges.html', '5f257eea3e3536e4b07f9516826807ba'),
(1008, 0, 'studio/template/forms_categories.html', 'e161d84c71d84324062a35def4f62ced'),
(1009, 0, 'studio/template/forms_displays.html', '38b3c335cdbe5c875d34a5f22709b93d'),
(1010, 0, 'studio/template/forms_fields.html', 'd10bd78213e7acc8f8b1079364a0c6df'),
(1011, 0, 'studio/template/forms_forms.html', '08a69d4b7602999d943abafd944caac7'),
(1012, 0, 'studio/template/forms_groups_roles.html', '561b13bd3e88b7ed701ebea9bb1c2f8f'),
(1013, 0, 'studio/template/forms_labels.html', 'ed867128450e182565961ec4b731b786'),
(1014, 0, 'studio/template/forms_lists.html', 'edb179b6d6d688e9e3498560c75bf87f'),
(1015, 0, 'studio/template/forms_search_fields.html', 'ec6ddbb581cbd56df88f3b1fd654a5aa'),
(1016, 0, 'studio/template/forms_search_forms.html', '68e86094862bcb42e8376ebdf0c6e493'),
(1017, 0, 'studio/template/forms_select.html', 'd1b40169d84015bbc483ac488285f99a'),
(1018, 0, 'studio/template/forms_values.html', 'c19d572b73e719a56a89a1b0bdc277bd'),
(1019, 0, 'studio/template/form_add_badge.html', '7648aae82851d9f7c310b236ec644a7d'),
(1020, 0, 'studio/template/form_add_category.html', '0df7ea24c92d409684ed959622bdb8f4'),
(1021, 0, 'studio/template/form_add_display.html', '5c3bd2662f4535231762bd2b2838a7d0'),
(1022, 0, 'studio/template/form_add_field.html', '0d780808a6b6f356a6f42a50d557fb45'),
(1023, 0, 'studio/template/form_add_form.html', 'ea0991e97aeaa1b3070148e32a728e33'),
(1024, 0, 'studio/template/form_add_groups_role.html', '7a31eec39c001a8034f840c977b22563'),
(1025, 0, 'studio/template/form_add_label.html', '1ebb4cc29c0707ccd47706430b41bdfa'),
(1026, 0, 'studio/template/form_add_list.html', 'c56c7c5f2aceddf10dff0c78e37351b1'),
(1027, 0, 'studio/template/form_add_search_field.html', '3dc0630d7ec94e3dff3ec063e26ab4f2'),
(1028, 0, 'studio/template/form_add_search_form.html', 'dde64bfa3bd1b9df338db9ed9e64b86e'),
(1029, 0, 'studio/template/form_add_value.html', 'c132a1c632306377244f1ecc6acb1bb3'),
(1030, 0, 'studio/template/form_ghost_template.html', 'f24b9a0b209ba2a58f094cdf24518556'),
(1031, 0, 'studio/template/form_input_translation.html', '0e5c43e69b16eb1d8b3bec1987dd7333'),
(1032, 0, 'studio/template/form_input_wrapper.html', '31533b24de1cc9dec752c90ad8914c4d'),
(1033, 0, 'studio/template/form_row_standard.html', 'fd0deb984847082e542936b2b5112884'),
(1034, 0, 'studio/template/form_view_row.html', 'bdbfb2e7ec8df60551997ff49270b14a'),
(1035, 0, 'studio/template/form_view_translatable.html', 'f71b25baa3390fdd5176329f5a270cd0'),
(1036, 0, 'studio/template/form_view_translator.html', '3bcc93a6491566be38be1a3050a8f254'),
(1037, 0, 'studio/template/images/bx-std-bg-lf-main.png', '671ca457c101a03ba7653d2aac45fe48'),
(1038, 0, 'studio/template/images/bx-std-bg-list-item.png', 'fc0815c96fb98bcfb366620ccfbb2017'),
(1039, 0, 'studio/template/images/bx-std-bg-main-image.jpg', 'bfde681b7d428c5bf88bbeab5e10e54c'),
(1040, 0, 'studio/template/images/bx-std-bg-widget-notice.png', '5c78be17a0591d068be90aaa79b558ca'),
(1041, 0, 'studio/template/images/bx-std-off.png', 'dee8d95239070fc7a4f95e90ed6b769f'),
(1042, 0, 'studio/template/images/bx-std-on.png', 'b899a1e78a93b3d1ad6d676a7a0cf4fa'),
(1043, 0, 'studio/template/images/bx-std-spacer.gif', '18b3b970eb07b30bd8fe644ea2c85f1e'),
(1044, 0, 'studio/template/images/bx-std-widget-bg-cover.png', '2cfe00ec52955fe89cef48314f7cb44d'),
(1045, 0, 'studio/template/images/bx-std-widget-cover-disabled.png', '0c1b070223dac152e1752f3ed7e3c033'),
(1046, 0, 'studio/template/images/dbd_version.svg', '3b293b3b61947deba376f992e4e3d3b2'),
(1047, 0, 'studio/template/images/icons/ami-account.svg', 'a6c0024a761c2dbd178bf3743fec5faf'),
(1048, 0, 'studio/template/images/icons/ami-edit.svg', '1a8483124ed13709aef01fb007522cbe'),
(1049, 0, 'studio/template/images/icons/ami-language.svg', '8d104ea83ce83581b352616c36e9dec0'),
(1050, 0, 'studio/template/images/icons/ami-logout.svg', '9540bfb4fab648c33e25993eb2209909'),
(1051, 0, 'studio/template/images/icons/ami-site.svg', 'ae98c852381a962202ba44f0fb5f0f6d'),
(1052, 0, 'studio/template/images/icons/api.svg', 'a340ef9ab449a1fe82348d54e3571433'),
(1053, 0, 'studio/template/images/icons/bc-arrow.svg', 'de76d67f21eb973be34647c8f08483dc'),
(1054, 0, 'studio/template/images/icons/bc-home.svg', '70623dcb57c54a6839ab1664d8f18a78'),
(1055, 0, 'studio/template/images/icons/cross.png', '4e5f7f15465123132332289081462691'),
(1056, 0, 'studio/template/images/icons/db-ht-fail.svg', '3d42ad1bfda77635e575c7ddc2576a15'),
(1057, 0, 'studio/template/images/icons/db-ht-ok.svg', 'a29d2029fafc5f5ff3493807fe8c5396'),
(1058, 0, 'studio/template/images/icons/db-ht-undef.svg', '5c2fba671cc410786426f84f1ea5b5fa'),
(1059, 0, 'studio/template/images/icons/db-ht-warn.svg', '84981db6a489f0e0372ab6bbbda85e9f'),
(1060, 0, 'studio/template/images/icons/db-vi-available.svg', '759c62d3d97ed9d8971aaecd0ef4cc31'),
(1061, 0, 'studio/template/images/icons/db-vi-installed.svg', 'a29d2029fafc5f5ff3493807fe8c5396'),
(1062, 0, 'studio/template/images/icons/db-vi-updated.svg', '9e08a10f6daed334d1c0e90e699b12ca'),
(1063, 0, 'studio/template/images/icons/document--pencil.png', 'd0497796cb174481519ef0100723c799'),
(1064, 0, 'studio/template/images/icons/equalizer.png', '91f6b30f8da31881280a1c484b249c35'),
(1065, 0, 'studio/template/images/icons/gi-add.svg', 'b078a00bf4918449ec157d82f2b7a181'),
(1066, 0, 'studio/template/images/icons/gi-export.svg', '7112989aa0a0e70f6ee4611de58f5ac5'),
(1067, 0, 'studio/template/images/icons/gi-settings.svg', '4559a17ea0ea36767ff5bdb3403fc470'),
(1068, 0, 'studio/template/images/icons/lmi-appearance.svg', '9907d7e29d67aa113ae1a8def7667724'),
(1069, 0, 'studio/template/images/icons/lmi-configuration.svg', '7c3200bada471e7a99efc5de6f406c7a'),
(1070, 0, 'studio/template/images/icons/lmi-content.svg', 'cf812b804c74e97440ab84d3f9bf167a'),
(1071, 0, 'studio/template/images/icons/lmi-extensions.svg', 'a0d953fbf3b1aeb7cf9448f06e0e8bef'),
(1072, 0, 'studio/template/images/icons/lmi-favorites.svg', '4a49f7706cf10d2e83c151f690ffafbc'),
(1073, 0, 'studio/template/images/icons/lmi-integrations.svg', 'd907fd320163a4378b2c26c117087dbc'),
(1074, 0, 'studio/template/images/icons/lmi-library.svg', '36b327817869032beffa9cd868ef5442'),
(1075, 0, 'studio/template/images/icons/lmi-structure.svg', '44e33574920fcf33c5cea7c911ad26d3'),
(1076, 0, 'studio/template/images/icons/lmi-users.svg', 'a4c60c37152da1664ad77b36c3849975'),
(1077, 0, 'studio/template/images/icons/mi-agt-assistants.svg', '00c9f7129d89d73e7efbfe5386519acf'),
(1078, 0, 'studio/template/images/icons/mi-agt-automators.svg', '57524e4359092383a8de2ad5f5d20c32'),
(1079, 0, 'studio/template/images/icons/mi-agt-helpers.svg', 'df7cbeba093b97d8d197cf95deb16d53'),
(1080, 0, 'studio/template/images/icons/mi-agt-providers.svg', '950713a2b12772a61573bd90c038e46b'),
(1081, 0, 'studio/template/images/icons/mi-agt-settings.svg', '7093ce6783c6f705d934446021dfbd8f'),
(1082, 0, 'studio/template/images/icons/mi-aud-reports.svg', '1bfb15eb719d35a6d8b5219dead2dca5'),
(1083, 0, 'studio/template/images/icons/mi-aud-settings.svg', '2c79cd94360bb6536d9d6b85789eba76'),
(1084, 0, 'studio/template/images/icons/mi-bdg-badges.svg', 'b72771ba10ed65efd2c96eb4bb94348c'),
(1085, 0, 'studio/template/images/icons/mi-bp-custom.svg', '2cba30e554109b677da83f5f462b2df5'),
(1086, 0, 'studio/template/images/icons/mi-bp-system.svg', '07ab1d2c16a7d89476f80ae1c6ffec64'),
(1087, 0, 'studio/template/images/icons/mi-cog.svg', '3f79ff572fee32f7f01fda9e44c6839d'),
(1088, 0, 'studio/template/images/icons/mi-dsg-cover.svg', '017fe844a149d306c0c14b7a02535d3c'),
(1089, 0, 'studio/template/images/icons/mi-dsg-general.svg', '7fd016f289afca14eb698fd617c5bedb'),
(1090, 0, 'studio/template/images/icons/mi-dsg-icon.svg', '39948312ed3e6b83aec892ffeab203c4'),
(1091, 0, 'studio/template/images/icons/mi-dsg-injections.svg', '69dad30619ba9ee1e29e06cd296c9d94'),
(1092, 0, 'studio/template/images/icons/mi-dsg-logo.svg', 'aa6e9a7887529ea819d87496b6a4b345'),
(1093, 0, 'studio/template/images/icons/mi-dsg-pwa.svg', 'a627cd501d3ad728aa2f67ef48f04cdd'),
(1094, 0, 'studio/template/images/icons/mi-dsg-settings.svg', '439116f6371fc6538fcb55eb67343785'),
(1095, 0, 'studio/template/images/icons/mi-dsg-splash.svg', '841b02c7175005c4bed1737ab0624a2a'),
(1096, 0, 'studio/template/images/icons/mi-frm-categories.svg', '8ba7337d59a031f28dcc254e89c104ec'),
(1097, 0, 'studio/template/images/icons/mi-frm-displays.svg', '0838fde638a829a8bc6e9e32a459b47d'),
(1098, 0, 'studio/template/images/icons/mi-frm-fields.svg', '873555c20e96ef0506e7a953307e8cb7'),
(1099, 0, 'studio/template/images/icons/mi-frm-forms.svg', '39e48cc589e14dd0ffb1534d2edf5a25'),
(1100, 0, 'studio/template/images/icons/mi-frm-groles.svg', '17050e8c4e94ec584665ceab70a93e93'),
(1101, 0, 'studio/template/images/icons/mi-frm-labels.svg', 'e51952b9ed2a8aad390fc4be3d8418a9'),
(1102, 0, 'studio/template/images/icons/mi-frm-plists.svg', 'dbba14b1e04b76e50ddd5ff3933a5c85'),
(1103, 0, 'studio/template/images/icons/mi-frm-pvalues.svg', '2ed16aba4dd0bf95aea39695ae72092d'),
(1104, 0, 'studio/template/images/icons/mi-frm-sfields.svg', '5b6fa6e90c5f7d669135f8889196fdcf'),
(1105, 0, 'studio/template/images/icons/mi-frm-sforms.svg', '91b8f083b636e9a9c0af8171d8ba3d5f'),
(1106, 0, 'studio/template/images/icons/mi-frm-ssfields.svg', '3a1d2a73678ba70075ca6133c0539076'),
(1107, 0, 'studio/template/images/icons/mi-nav-items.svg', '952e42672a798877c51c56876a852c2e'),
(1108, 0, 'studio/template/images/icons/mi-nav-menus.svg', '59aa71811d4ee26fae6e5f857c416a1f'),
(1109, 0, 'studio/template/images/icons/mi-nav-sets.svg', '2ed16aba4dd0bf95aea39695ae72092d'),
(1110, 0, 'studio/template/images/icons/mi-pgt-etemplates-html.svg', 'd32d3e81857d1d02606969169dfcc6f8'),
(1111, 0, 'studio/template/images/icons/mi-pgt-etemplates-text.svg', 'ecbd5266dcd4f1d7a8d8348a68d89283'),
(1112, 0, 'studio/template/images/icons/mi-pgt-keys.svg', '7dce08a29e709203e96864eee806fde9'),
(1113, 0, 'studio/template/images/icons/mi-pgt-settings.svg', '2e397b78eafc53666f5211baf0354462'),
(1114, 0, 'studio/template/images/icons/mi-prm-actions.svg', 'e3cf0e80484eab58ac0e8515dfbf2b43'),
(1115, 0, 'studio/template/images/icons/mi-prm-levels.svg', '22ec812071d2bfdc16876015fbabe8dc'),
(1116, 0, 'studio/template/images/icons/mi-qrcode.svg', 'f3cdc282522d6ae5df2a4151ed6912e9'),
(1117, 0, 'studio/template/images/icons/mi-stg-files.svg', '2e397b78eafc53666f5211baf0354462'),
(1118, 0, 'studio/template/images/icons/mi-stg-images.svg', '4286f808537ce9a27ade6a538493674b'),
(1119, 0, 'studio/template/images/icons/mi-str-categories.svg', '8ba7337d59a031f28dcc254e89c104ec'),
(1120, 0, 'studio/template/images/icons/mi-str-checkout.svg', '3006ffaffaea139e234b17e8b0b498bb'),
(1121, 0, 'studio/template/images/icons/mi-str-downloaded.svg', 'a02bfc46e894db19e805879c52e3d43f'),
(1122, 0, 'studio/template/images/icons/mi-str-featured.svg', '52fc19dc3f8fa623517f09b1d98ec212'),
(1123, 0, 'studio/template/images/icons/mi-str-home.svg', '0ce4222383f0cc3089dab02579db1363'),
(1124, 0, 'studio/template/images/icons/mi-str-latest.svg', '2b0a527664b9e378874c28ca49f663f8'),
(1125, 0, 'studio/template/images/icons/mi-str-popular.svg', 'ce5a531d707bfd5bc38a0c4cbbae3835'),
(1126, 0, 'studio/template/images/icons/mi-str-purchases.svg', '337b93767a5ba7de16668e844852b100'),
(1127, 0, 'studio/template/images/icons/mi-str-search.svg', 'f9287987f44ec44e597535b180ed4302'),
(1128, 0, 'studio/template/images/icons/mi-str-updates.svg', 'fb005702eac39189820dc51eec8103ac');
INSERT INTO `sys_modules_file_tracks` VALUES
(1129, 0, 'studio/template/images/icons/mi-wrench.svg', '34dfd7de14e96d4fb49eac933d81b8d5'),
(1130, 0, 'studio/template/images/icons/tables__plus.png', '5fae36e82b955e5c7563fc15abb15bd9'),
(1131, 0, 'studio/template/images/icons/tmi-account.svg', 'f3ab0cba402111ed44b6c9d066d3ffcd'),
(1132, 0, 'studio/template/images/icons/tmi-actions.svg', '5d2ec26903ab94c3cb883321764a5675'),
(1133, 0, 'studio/template/images/icons/tmi-assistant.svg', '04a678d4ec2d7fc3538d672fcd8042ff'),
(1134, 0, 'studio/template/images/icons/tmi-help.svg', 'd03b9ed074a06bd94b8802379fa6ed37'),
(1135, 0, 'studio/template/images/icons/tmi-scheme-auto.svg', '7f68e2f8f86cdaa05a59626b9f0d2dc7'),
(1136, 0, 'studio/template/images/icons/tmi-scheme-dark.svg', 'af6a283bd7178ca4e598ef89cf184bbb'),
(1137, 0, 'studio/template/images/icons/tmi-scheme-light.svg', '5f99855ddb54e0b0f882440f3e9d9642'),
(1138, 0, 'studio/template/images/icons/tmi-search.svg', '2d6c2b45fce24426a20adf3e5fe1ed9b'),
(1139, 0, 'studio/template/images/icons/tmi-site.svg', '1757ee6be106ee14995ae220a5d4c15f'),
(1140, 0, 'studio/template/images/icons/ui-block_end.png', '5f5360041f3179295eb7f3e8a8962037'),
(1141, 0, 'studio/template/images/icons/ui-block_header.png', '5f5360041f3179295eb7f3e8a8962037'),
(1142, 0, 'studio/template/images/icons/ui-button.png', 'ab715806213c6da0e5312fb8a91d1069'),
(1143, 0, 'studio/template/images/icons/ui-captcha.png', '330f323936abae02d909beb8f504d8d9'),
(1144, 0, 'studio/template/images/icons/ui-checkbox.png', '25f4289274e586310f7cbb24c9c5c6c9'),
(1145, 0, 'studio/template/images/icons/ui-checkbox_set.png', 'ca257e25f74cbd59a47de9cb4e2af769'),
(1146, 0, 'studio/template/images/icons/ui-custom.png', '9503cb94a90398cc9848c1c8bb1b443e'),
(1147, 0, 'studio/template/images/icons/ui-datepicker.png', '52383e1c59718a1b17e69f6681ddfbb4'),
(1148, 0, 'studio/template/images/icons/ui-datepicker_range.png', '5ae528bfbed2a0d58286060cf14363dd'),
(1149, 0, 'studio/template/images/icons/ui-datepicker_range_age.png', 'a59d37be7f798ab14535a7079149a2e7'),
(1150, 0, 'studio/template/images/icons/ui-datetime.png', '52383e1c59718a1b17e69f6681ddfbb4'),
(1151, 0, 'studio/template/images/icons/ui-datetime_range.png', '5ae528bfbed2a0d58286060cf14363dd'),
(1152, 0, 'studio/template/images/icons/ui-datetime_range_age.png', 'a59d37be7f798ab14535a7079149a2e7'),
(1153, 0, 'studio/template/images/icons/ui-doublerange.png', 'a59d37be7f798ab14535a7079149a2e7'),
(1154, 0, 'studio/template/images/icons/ui-file.png', '4095446dc53cb3cddd200b519c39245d'),
(1155, 0, 'studio/template/images/icons/ui-files.png', 'c0821c448d0aff9b01ecd1642a8e4679'),
(1156, 0, 'studio/template/images/icons/ui-hidden.png', '15f30bb2c8b40faff47bf18f1f992941'),
(1157, 0, 'studio/template/images/icons/ui-image.png', 'cd7d4148806c40c67fe036cb71d1aae0'),
(1158, 0, 'studio/template/images/icons/ui-input_set.png', '70153b82536f66f44f37409e92523f31'),
(1159, 0, 'studio/template/images/icons/ui-location.png', '3df72499f232da9508b0d9a4d6c1d62f'),
(1160, 0, 'studio/template/images/icons/ui-location_radius.png', '3df72499f232da9508b0d9a4d6c1d62f'),
(1161, 0, 'studio/template/images/icons/ui-nested_form.png', 'ca5783a1d3e7bd619d8756332d7eb619'),
(1162, 0, 'studio/template/images/icons/ui-number.png', 'fcbf05e954a109b54400475baffa90f1'),
(1163, 0, 'studio/template/images/icons/ui-password.png', 'cecadf88925307a82a7c68842c114a80'),
(1164, 0, 'studio/template/images/icons/ui-radio_set.png', '407d11914a9bcd10985083ae07b1f84f'),
(1165, 0, 'studio/template/images/icons/ui-reset.png', 'ab715806213c6da0e5312fb8a91d1069'),
(1166, 0, 'studio/template/images/icons/ui-select.png', '51d2748802216bff7841196886879964'),
(1167, 0, 'studio/template/images/icons/ui-select_multiple.png', '30f323b86f99f3e69f1794ad2ba7dbdb'),
(1168, 0, 'studio/template/images/icons/ui-slider.png', 'e75095752dde848823757312f127ebcd'),
(1169, 0, 'studio/template/images/icons/ui-submit.png', 'ab715806213c6da0e5312fb8a91d1069'),
(1170, 0, 'studio/template/images/icons/ui-switcher.png', 'ae8ed9a9705842f5e6729091779982ca'),
(1171, 0, 'studio/template/images/icons/ui-text.png', '13aed94bf273a5f52fbc865c4907b0a4'),
(1172, 0, 'studio/template/images/icons/ui-textarea.png', '829c4604dc85b0cde26b781fdb941a8d'),
(1173, 0, 'studio/template/images/icons/ui-text_auto.png', '765ea20566499441e360eec79cbe403c'),
(1174, 0, 'studio/template/images/icons/ui-text_range.png', 'a59d37be7f798ab14535a7079149a2e7'),
(1175, 0, 'studio/template/images/icons/ui-time.png', '488b527241579408b4b45157f1ea9768'),
(1176, 0, 'studio/template/images/icons/ui-value.png', 'c4133b556912087d6b064dad60df98cc'),
(1177, 0, 'studio/template/images/icons/wi-act-settings.svg', '7c0ee183c84aa1382748c06eded91189'),
(1178, 0, 'studio/template/images/icons/wi-act-uninstall.svg', '6e4eccc4ad01d147fe3618664c600886'),
(1179, 0, 'studio/template/images/icons/wi-agents.svg', '74959837a59c1c53b1e2be4ea37de989'),
(1180, 0, 'studio/template/images/icons/wi-api.svg', '0dff95876114029e020a4a47e68109d5'),
(1181, 0, 'studio/template/images/icons/wi-audit.svg', '1317a4b0b51c666247eded0c8329b626'),
(1182, 0, 'studio/template/images/icons/wi-badges.svg', 'da60d4bf2d0dadbaeed4b3065fc2d0be'),
(1183, 0, 'studio/template/images/icons/wi-bld-forms.svg', '5f512d690ac2fe7fad29a9fbab3114b4'),
(1184, 0, 'studio/template/images/icons/wi-bld-navigation.svg', 'e89316f0f62d56f7235292afc06d3ba3'),
(1185, 0, 'studio/template/images/icons/wi-bld-pages.svg', '981be7056c0a46947412ece4eebebf64'),
(1186, 0, 'studio/template/images/icons/wi-bld-permissions.svg', 'e58d3cf47bd27741f27353f193222340'),
(1187, 0, 'studio/template/images/icons/wi-bld-roles.svg', '2c017f37fe3ca42fd03464f01803467c'),
(1188, 0, 'studio/template/images/icons/wi-dashboard.svg', '0903cfb3ff2ff36a223c368124738b53'),
(1189, 0, 'studio/template/images/icons/wi-designer.svg', '03a0f274c49d9bd09401a7a3b581b89a'),
(1190, 0, 'studio/template/images/icons/wi-empty.png', 'afcd11bad2e5b197fe46e27c82b3106e'),
(1191, 0, 'studio/template/images/icons/wi-home.svg', '8d535ef607c52aa77fed4714d2ea35a9'),
(1192, 0, 'studio/template/images/icons/wi-polyglot.svg', '25ece4504f8d3258e27f470eb8223e35'),
(1193, 0, 'studio/template/images/icons/wi-settings.svg', '7191fbbf91f9449741b4e1216ec705f1'),
(1194, 0, 'studio/template/images/icons/wi-storages.svg', '3a9f75162c22e85db910d4d6f4266ef3'),
(1195, 0, 'studio/template/images/icons/wi-store.svg', '244289c42494d9fd780fa12775464310'),
(1196, 0, 'studio/template/images/loading.gif', 'd99b2f52091f4f397f49e791575a5c0c'),
(1197, 0, 'studio/template/item_icon_preview.html', 'e1ca14ee9f9080fb53021b4213e279d3'),
(1198, 0, 'studio/template/language.html', '9bcc33f1e8eb2af480306d362a319e1a'),
(1199, 0, 'studio/template/lang_action_result.html', '6f53787e5a73fef7e952ee8f17fa511a'),
(1200, 0, 'studio/template/lang_confirm.html', '869b6997857f461797ae97f906819df5'),
(1201, 0, 'studio/template/lang_page_caption.html', 'eda9a94f9a7232ea7bc8872de6122dcc'),
(1202, 0, 'studio/template/launcher.html', '051ffad441a33b010a8eb25ef47edc34'),
(1203, 0, 'studio/template/launcher_browser.html', '48a0275202de3cb50c39b44898b8bae1'),
(1204, 0, 'studio/template/launcher_cache_updater.html', 'a6695391a507cf78ac967b8c74213528'),
(1205, 0, 'studio/template/launcher_tour.html', '3d95a5d923dedf71b70a2944fa83ebbb'),
(1206, 0, 'studio/template/layout_1_column_wiki.html', '8094e83e02ed649a165ffe4d10615e10'),
(1207, 0, 'studio/template/login.html', 'f74c55d931387a6aab1ca41e3ec2c092'),
(1208, 0, 'studio/template/login_form.html', '715b6e5ce7ed43d9b5dc5f922aa9f42d'),
(1209, 0, 'studio/template/menu_launcher_browser.html', 'f2b6fe5412b64d54c69fd2a62a209127'),
(1210, 0, 'studio/template/menu_side.html', '079e237843c7e80fe1520aeb9643ab11'),
(1211, 0, 'studio/template/menu_side_counter.html', 'b579d0a5a71f3848f16f386f8ee84903'),
(1212, 0, 'studio/template/menu_top.html', '37aa7d661c1c4f4b74ef7b76df8dc697'),
(1213, 0, 'studio/template/menu_top_center.html', 'bb95c37c094df1482eaf92547ff468c7'),
(1214, 0, 'studio/template/menu_top_toolbar.html', '794209422d7dd0f9f63e7ee3768d8575'),
(1215, 0, 'studio/template/module.html', '9bcc33f1e8eb2af480306d362a319e1a'),
(1216, 0, 'studio/template/mod_action_result_step.html', 'acc6badc7f258969b7523ee070893985'),
(1217, 0, 'studio/template/mod_page_caption.html', 'f7fd10b5aa8c79dddef07f9993b43ef3'),
(1218, 0, 'studio/template/mod_popup_confirm_uninstall.html', '094fd66d2092039fd618dc6698fec89a'),
(1219, 0, 'studio/template/mod_popup_settings.html', '4e48476acfac752d3faf45c344cfdb9a'),
(1220, 0, 'studio/template/navigation.html', '9bcc33f1e8eb2af480306d362a319e1a'),
(1221, 0, 'studio/template/nav_add_item.html', 'a42cc54972a5cdb91532ecba4ddff093'),
(1222, 0, 'studio/template/nav_add_menu.html', '53fd94dd9f7c0abe88eeb1846b8250a4'),
(1223, 0, 'studio/template/nav_add_set.html', '18665258d87a898f7837f0917cd3ce81'),
(1224, 0, 'studio/template/nav_import.html', '5e6b54d37c1800fbfb725a0c48ae073b'),
(1225, 0, 'studio/template/nav_import_item.html', '5d73b08979c07f37c7525f4b64ca0b11'),
(1226, 0, 'studio/template/nav_items.html', '80670bd5fac22226ffaf0d40dfe98bda'),
(1227, 0, 'studio/template/options.html', 'cee2c3e5201314dc3591a4bd9b14db1a'),
(1228, 0, 'studio/template/nav_menus.html', 'b530b34dc6cd8ac75d546f09c6ceef45'),
(1229, 0, 'studio/template/nav_sets.html', '04b939af9c28ec31b9849fc1d93f1a2d'),
(1230, 0, 'studio/template/options_create_mix.html', '5b480901466c273e45e8c199266bd383'),
(1231, 0, 'studio/template/options_import_mix.html', '4ba752288df8402c6db8787eb6933fe6'),
(1232, 0, 'studio/template/options_manage_popup.html', 'bf1b4107ba661039015be1b0dc824be9'),
(1233, 0, 'studio/template/page_150.html', 'd4066e94e972832264b4cba33bc816ed'),
(1234, 0, 'studio/template/page_2.html', 'e904985dba2d8801449f9676d5846e8f'),
(1235, 0, 'studio/template/page_3.html', '9be516fe1c88834d879cf5cdd82fa259'),
(1236, 0, 'studio/template/page_4.html', 'bd62fb9efdedd83f53384a0e3d47a557'),
(1237, 0, 'studio/template/page_action_result.html', 'ab436bfa222b39edd6e980417bb11179'),
(1238, 0, 'studio/template/page_block.html', 'c334dc7b8227aad7b7ce5918d96215bb'),
(1239, 0, 'studio/template/page_blocks_line.html', 'd4acb4402b44db3b03e3a5ef433e73e9'),
(1240, 0, 'studio/template/page_breadcrumb.html', '9af9ad9659d3e716238157880cb4ee64'),
(1241, 0, 'studio/template/page_caption_actions.html', '9bcc33f1e8eb2af480306d362a319e1a'),
(1242, 0, 'studio/template/page_caption_assistant.html', '1032102382ea42512d4239fcbe9ce14d'),
(1243, 0, 'studio/template/page_caption_help.html', '521ecf6d0272b668336c04eee70a6c8f'),
(1244, 0, 'studio/template/page_content_2_col.html', '5cc65ce48a156fb54ece41f32ca408a0'),
(1245, 0, 'studio/template/page_menu.html', 'ba90db5892a7b388747f97ebb0eda5ee'),
(1246, 0, 'studio/template/page_not_found.html', 'df6445f05cb61bcfc5bcddf2a75195ef'),
(1247, 0, 'studio/template/permissions.html', '0be0c1d2e1549083a15a709c89bdf5dc'),
(1248, 0, 'studio/template/pgt_etemplates.html', '4c1956988d0bf92ae0fd47d895e3be96'),
(1249, 0, 'studio/template/pgt_etemplates_creative_fld.html', '44701cd298bf2eadf787cc6b747d34dd'),
(1250, 0, 'studio/template/pgt_etemplates_creative_frm.html', '96b609c5cceebb9be5638e9d5f111030'),
(1251, 0, 'studio/template/pgt_etemplates_hf.html', '96b609c5cceebb9be5638e9d5f111030'),
(1252, 0, 'studio/template/pgt_keys.html', '71beb0decd0a57e22349620179858aa3'),
(1253, 0, 'studio/template/pgt_new_etemplate.html', '8753b4d43ffad8dfcf0a5005144b85cb'),
(1254, 0, 'studio/template/pgt_new_key.html', '8498bef888db7c0d06eec8cc4bb3b5fa'),
(1255, 0, 'studio/template/polyglot.html', '84666223aa9fe46bad572e207d167703'),
(1256, 0, 'studio/template/prm_actions.html', '9ca78a6f42986e44e035733066e2781b'),
(1257, 0, 'studio/template/prm_add_level.html', '1cb656dd1808fd5c4cd62e85fb606408'),
(1258, 0, 'studio/template/prm_add_price.html', '9b83df4ab3ee3b067586ecd4011a7e1f'),
(1259, 0, 'studio/template/prm_edit_option.html', 'b84aa246b505d3d8e5367c10610c536c'),
(1260, 0, 'studio/template/prm_levels.html', '1562dffd903f3f08a901b9cb8b9dd29a'),
(1261, 0, 'studio/template/prm_prices.html', '8eea2f5afbafbc8d39bd88e2474a5a9d'),
(1262, 0, 'studio/template/rl_role.html', 'df0e8128ceaf6a6fffdba2617cd4c65b'),
(1263, 0, 'studio/template/rl_roles_actions.html', 'c73c04bfeb344d9a744e941fef4c8d9e'),
(1264, 0, 'studio/template/rl_roles_levels.html', 'bd91643a1b14c47244e90c598a4bd634'),
(1265, 0, 'studio/template/roles.html', '5b2e193437b72dc8a4a2c8f7f714baf1'),
(1266, 0, 'studio/template/scripts/BxBaseStudioAgents.php', 'e01ab70444da002e910f98b861055696'),
(1267, 0, 'studio/template/scripts/BxBaseStudioAgentsAssistants.php', '50830129379dd3b180e8579cc2d60d27'),
(1268, 0, 'studio/template/scripts/BxBaseStudioAgentsAsstChats.php', '22dd09b1aad3c3bf619962b01a3caf8e'),
(1269, 0, 'studio/template/scripts/BxBaseStudioAgentsAsstFiles.php', 'a6c1e0858767b68bd032ab39bcc9f057'),
(1270, 0, 'studio/template/scripts/BxBaseStudioAgentsAutomators.php', 'e8d9b52d336576963f84d0ad9bb3b408'),
(1271, 0, 'studio/template/scripts/BxBaseStudioAgentsHelpers.php', '41815c48ff10ae5c1d27456d7ad08b2f'),
(1272, 0, 'studio/template/scripts/BxBaseStudioAgentsProviders.php', 'ab658c938b0775e6e769b62678726a45'),
(1273, 0, 'studio/template/scripts/BxBaseStudioAPI.php', '890edde364cf83f230095d3023963122'),
(1274, 0, 'studio/template/scripts/BxBaseStudioAudit.php', 'c699099fce4a449cc095ccaa36ade0d2'),
(1275, 0, 'studio/template/scripts/BxBaseStudioBadges.php', 'f1b400ad073f679981d8e924805d940d'),
(1276, 0, 'studio/template/scripts/BxBaseStudioBadgesGrid.php', '22ae57f367bf579bcb9cd7d623d68802'),
(1277, 0, 'studio/template/scripts/BxBaseStudioBuilderPage.php', 'b6a330d826029350387396fdc085e58b'),
(1278, 0, 'studio/template/scripts/BxBaseStudioBuilderPageUploaderHTML5.php', 'e89f7b75d3636cc2f20a17f00c5b50a1'),
(1279, 0, 'studio/template/scripts/BxBaseStudioConfig.php', '3a0ed5c549b2befba18904fd59e8e7d9'),
(1280, 0, 'studio/template/scripts/BxBaseStudioDashboard.php', 'e31802f663b85e4db26484991c968428'),
(1281, 0, 'studio/template/scripts/BxBaseStudioDesign.php', '6327e7a20f12c4d46b78c8bd748ec490'),
(1282, 0, 'studio/template/scripts/BxBaseStudioDesigner.php', '8af2a3724813d3d786dcb37556a0d971'),
(1283, 0, 'studio/template/scripts/BxBaseStudioDesigns.php', '142c8b5209bf30e99b1acada2f898ef0'),
(1284, 0, 'studio/template/scripts/BxBaseStudioDesignServices.php', 'c537c86ab7334df63eec1898f5056bf0'),
(1285, 0, 'studio/template/scripts/BxBaseStudioForms.php', '53a83642b3480999488e838419d88e20'),
(1286, 0, 'studio/template/scripts/BxBaseStudioFormsCategories.php', '36ae8f017da0463b640070655a015474'),
(1287, 0, 'studio/template/scripts/BxBaseStudioFormsDisplays.php', 'c8bae8d7b584cd7ab4f2193b7ddb7b03'),
(1288, 0, 'studio/template/scripts/BxBaseStudioFormsField.php', 'bd831cdea25fcae4de6c0a644085f917'),
(1289, 0, 'studio/template/scripts/BxBaseStudioFormsFields.php', 'bbfe3601b046a7aa31f06e6467ee10d3'),
(1290, 0, 'studio/template/scripts/BxBaseStudioFormsForms.php', '87003f07b5d812c49e85c74dee54373e'),
(1291, 0, 'studio/template/scripts/BxBaseStudioFormsGroupsRoles.php', 'd8b45802025bc3f3c010c120a8007424'),
(1292, 0, 'studio/template/scripts/BxBaseStudioFormsLabels.php', '230991ae2a3ced62e7fddee64f0b2ff4'),
(1293, 0, 'studio/template/scripts/BxBaseStudioFormsPreLists.php', '6f48ebfdce91686b9c14c5c46249b0ea'),
(1294, 0, 'studio/template/scripts/BxBaseStudioFormsPreValues.php', '1606a3307e24f025325077e3b3bfe4ac'),
(1295, 0, 'studio/template/scripts/BxBaseStudioFormsSearchFields.php', '57fcd86186206579083ad1b38448f541'),
(1296, 0, 'studio/template/scripts/BxBaseStudioFormsSearchForms.php', '4291119e3f681bd4dad4d6dcef550762'),
(1297, 0, 'studio/template/scripts/BxBaseStudioFormsSearchSortableFields.php', 'e34073d60728ca431974274463e296ce'),
(1298, 0, 'studio/template/scripts/BxBaseStudioFormView.php', '401a5eaa7038aaaaa7566adb96e5603b'),
(1299, 0, 'studio/template/scripts/BxBaseStudioFunctions.php', '40d2c39d0f2b31bdccb1ed3d0c55a435'),
(1300, 0, 'studio/template/scripts/BxBaseStudioGrid.php', 'dc004182b25e0b33290676a248225fa3'),
(1301, 0, 'studio/template/scripts/BxBaseStudioGridNavigation.php', '69bd61c3eea37dc787d730dd309ff339'),
(1302, 0, 'studio/template/scripts/BxBaseStudioGridStorages.php', '2c5c9d17cff305578d0b1bdabd198c83'),
(1303, 0, 'studio/template/scripts/BxBaseStudioLanguage.php', 'e7c9cba33fc41f725f3ef0d2dda1264f'),
(1304, 0, 'studio/template/scripts/BxBaseStudioLanguages.php', 'bd7f2444f0648d6a4bfebd02d566b93d'),
(1305, 0, 'studio/template/scripts/BxBaseStudioLauncher.php', '3713c72a3857e83d286b88272ba04485'),
(1306, 0, 'studio/template/scripts/BxBaseStudioMenu.php', '78f2df4c414e5d5412a5f59eb88a3e5d'),
(1307, 0, 'studio/template/scripts/BxBaseStudioMenuAccountPopup.php', 'e74a27bc05c3b061f15586c0fd4da2ea'),
(1308, 0, 'studio/template/scripts/BxBaseStudioMenuTop.php', '66e40acecf597f7524ed3e635e8bc160'),
(1309, 0, 'studio/template/scripts/BxBaseStudioModule.php', '79d47c613897d8aa71d3a508f760fe0c'),
(1310, 0, 'studio/template/scripts/BxBaseStudioModules.php', 'd37fd2002d20dc376048544effa6eb24'),
(1311, 0, 'studio/template/scripts/BxBaseStudioNavigation.php', '9f59b8e8c215179f2d67bee5eeb1be4e'),
(1312, 0, 'studio/template/scripts/BxBaseStudioNavigationImport.php', 'f6aa2d24553e6013a9a2488807845081'),
(1313, 0, 'studio/template/scripts/BxBaseStudioNavigationItems.php', '60836f7519b145a849a9e15297909b49'),
(1314, 0, 'studio/template/scripts/BxBaseStudioNavigationMenus.php', 'c38a60c4d155dd19f7d971a7f143d205'),
(1315, 0, 'studio/template/scripts/BxBaseStudioNavigationSets.php', 'd40d337e59dd94042f068549c7a4fc37'),
(1316, 0, 'studio/template/scripts/BxBaseStudioOptions.php', '7c7b51478218fd1acf85d8b05a310e86'),
(1317, 0, 'studio/template/scripts/BxBaseStudioOptionsApi.php', '909f4027252b158a5fe9a3727d8de2dc'),
(1318, 0, 'studio/template/scripts/BxBaseStudioPage.php', '25e7656988b9211d9f988132413f9c25'),
(1319, 0, 'studio/template/scripts/BxBaseStudioPermissions.php', 'b7ce781358d9998d77ac37182ffe0158'),
(1320, 0, 'studio/template/scripts/BxBaseStudioPermissionsActions.php', '83d50dbe0031d4037a0b8c2fca46b90f'),
(1321, 0, 'studio/template/scripts/BxBaseStudioPermissionsLevels.php', '1eb9106268c6003f56a3d9aa6fe70d08'),
(1322, 0, 'studio/template/scripts/BxBaseStudioPolyglot.php', '415a90cbe722a136b18e9b339a7e05d5'),
(1323, 0, 'studio/template/scripts/BxBaseStudioPolyglotEtemplates.php', 'f50ffe8aeb933eb74fa7924d8e5689a4'),
(1324, 0, 'studio/template/scripts/BxBaseStudioPolyglotKeys.php', '683e64fac75c5f5fb34be4dbc587a4a8'),
(1325, 0, 'studio/template/scripts/BxBaseStudioRoles.php', '3c31b73c9ab277ecdc12a63b382bcbb9'),
(1326, 0, 'studio/template/scripts/BxBaseStudioRolesActions.php', '1f833974330b821310e0a8b1b41bd83e'),
(1327, 0, 'studio/template/scripts/BxBaseStudioRolesLevels.php', '4930002f7f9bfef311a7eeb5f2198ccb'),
(1328, 0, 'studio/template/scripts/BxBaseStudioSettings.php', '566eba2528f1ce73c66de7fa2f80d19a'),
(1329, 0, 'studio/template/scripts/BxBaseStudioSettingsServices.php', 'be3217fd82dd6e24ca8a95fc2ed04d63'),
(1330, 0, 'studio/template/scripts/BxBaseStudioSettingsUploaderHTML5.php', 'bdd92902cf18103ef63478650f3c87c2'),
(1331, 0, 'studio/template/scripts/BxBaseStudioStorages.php', '00af8139ffbeaa033e91e75dab999850'),
(1332, 0, 'studio/template/scripts/BxBaseStudioStoragesFiles.php', 'fafdc6b100d298d55c0486c69c8c9e40'),
(1333, 0, 'studio/template/scripts/BxBaseStudioStoragesImages.php', 'fd44ce1c3736e4db856f3f1ee3b5d6ce'),
(1334, 0, 'studio/template/scripts/BxBaseStudioStore.php', 'bbb8531111e0cecf1f2cabd285c51ab0'),
(1335, 0, 'studio/template/scripts/BxBaseStudioUploaderCropCover.php', 'd59d3b545cbeb4024f8bfdda89debaff'),
(1336, 0, 'studio/template/scripts/BxBaseStudioWidget.php', '7861608aaf75d6b5e055aba5d3b06448'),
(1337, 0, 'studio/template/scripts/BxBaseStudioWidgets.php', '2f12016e50823eefaf89e43508d80055'),
(1338, 0, 'studio/template/scripts_templ/BxTemplStudioAgents.php', '76f3a01a2e11caf3d0efea3ec3bb0bc0'),
(1339, 0, 'studio/template/scripts_templ/BxTemplStudioAgentsAssistants.php', 'ce4659baf19ec53f83818344ea181e14'),
(1340, 0, 'studio/template/scripts_templ/BxTemplStudioAgentsAsstChats.php', 'deb58ea65c5302aea9c9d824cf1ca0ef'),
(1341, 0, 'studio/template/scripts_templ/BxTemplStudioAgentsAsstFiles.php', '9357fc43f58a5b0bb2869655e2e0b241'),
(1342, 0, 'studio/template/scripts_templ/BxTemplStudioAgentsAutomators.php', '599e7c952f7423bada203f6cecce2a66'),
(1343, 0, 'studio/template/scripts_templ/BxTemplStudioAgentsHelpers.php', 'b02be688032cf7c8b5bb7a07032d2604'),
(1344, 0, 'studio/template/scripts_templ/BxTemplStudioAgentsProviders.php', '539cf3b4d95165e6bc0dfd1a90377fe4'),
(1345, 0, 'studio/template/scripts_templ/BxTemplStudioAPI.php', '0dd323141774cf384ef3360c6d4ebc2a'),
(1346, 0, 'studio/template/scripts_templ/BxTemplStudioAudit.php', '05b7cff53f0b5bebe3954575c73baf01'),
(1347, 0, 'studio/template/scripts_templ/BxTemplStudioAuditGrid.php', '1d0d035a7bf90e237f88a123d0ff6a5b'),
(1348, 0, 'studio/template/scripts_templ/BxTemplStudioBadges.php', '6c34ba79e82241a8509d7f15e292937b'),
(1349, 0, 'studio/template/scripts_templ/BxTemplStudioBadgesGrid.php', '5817f6ca13dc7b725c2d78b9e4ef0d28'),
(1350, 0, 'studio/template/scripts_templ/BxTemplStudioBuilderPage.php', '168553a663e2afba8e02b1efaa8c4149'),
(1351, 0, 'studio/template/scripts_templ/BxTemplStudioBuilderPageUploaderHTML5.php', 'ccc90f2da587aedd68ca30116c102405'),
(1352, 0, 'studio/template/scripts_templ/BxTemplStudioConfig.php', '05075e70ab25ff6b1b9e8c3055d50a26'),
(1353, 0, 'studio/template/scripts_templ/BxTemplStudioDashboard.php', 'f07892e2686b540347f6dba87fc5dbbe'),
(1354, 0, 'studio/template/scripts_templ/BxTemplStudioDesign.php', '83bcae08ac32b7af4f6bdfecbb3bd984'),
(1355, 0, 'studio/template/scripts_templ/BxTemplStudioDesigner.php', 'c29c3eaf3aac18469e48febc36b63a42'),
(1356, 0, 'studio/template/scripts_templ/BxTemplStudioDesigns.php', '3b08a47c9df3f2e8512be29633d33fce'),
(1357, 0, 'studio/template/scripts_templ/BxTemplStudioDesignServices.php', '20cc1085b27454e2470ad8cfde04eda5'),
(1358, 0, 'studio/template/scripts_templ/BxTemplStudioForms.php', '1a48891d5464d96b39d03f553724e1d9'),
(1359, 0, 'studio/template/scripts_templ/BxTemplStudioFormsCategories.php', '76b0bc4953c736030a619847bd248b2d'),
(1360, 0, 'studio/template/scripts_templ/BxTemplStudioFormsDisplays.php', '850081cfe79eeb3cf2648ad2b640c010'),
(1361, 0, 'studio/template/scripts_templ/BxTemplStudioFormsField.php', '107e64c3ce773a900eb8d86f6c5e281e'),
(1362, 0, 'studio/template/scripts_templ/BxTemplStudioFormsFields.php', 'b109582ef3f80d9fd466b8f6a19ada71'),
(1363, 0, 'studio/template/scripts_templ/BxTemplStudioFormsForms.php', '23d99f377db08de4d03392b24a77cc7f'),
(1364, 0, 'studio/template/scripts_templ/BxTemplStudioFormsGroupsRoles.php', '4e0bca229aaff1e73fb14b134be002c5'),
(1365, 0, 'studio/template/scripts_templ/BxTemplStudioFormsLabels.php', '3e66eb1afa680438fa697ffc8b5b9f63'),
(1366, 0, 'studio/template/scripts_templ/BxTemplStudioFormsPreLists.php', '39d83aac08a622e30c872ac0cdf5d221'),
(1367, 0, 'studio/template/scripts_templ/BxTemplStudioFormsPreValues.php', 'a094295b7cacfb5a72e11e835d201502'),
(1368, 0, 'studio/template/scripts_templ/BxTemplStudioFormsSearchFields.php', 'a2e0f54658dae4492cda6ef6179be75c'),
(1369, 0, 'studio/template/scripts_templ/BxTemplStudioFormsSearchForms.php', '29c8e969d56b002cc6f9203ebff14fe8'),
(1370, 0, 'studio/template/scripts_templ/BxTemplStudioFormsSearchSortableFields.php', '9b94c65951ac2b5d5232e4a6fc5f5bff'),
(1371, 0, 'studio/template/scripts_templ/BxTemplStudioFormView.php', 'd632ec8866a1c7f8516b9db8a4d96ede'),
(1372, 0, 'studio/template/scripts_templ/BxTemplStudioFunctions.php', '6b5b7bd4d371a5f8badafe6f20aa51fe'),
(1373, 0, 'studio/template/scripts_templ/BxTemplStudioGrid.php', '88da7a7642c0930d0d44450c98f922db'),
(1374, 0, 'studio/template/scripts_templ/BxTemplStudioGridNavigation.php', '770bcba0d28e989e16194263bb21f92d'),
(1375, 0, 'studio/template/scripts_templ/BxTemplStudioGridStorages.php', '3a7c5766d1439ad505a6eacc8ea3f7aa'),
(1376, 0, 'studio/template/scripts_templ/BxTemplStudioLanguage.php', 'b95feff3526bb1b0f8d7e4ffb5234a82'),
(1377, 0, 'studio/template/scripts_templ/BxTemplStudioLanguages.php', '8232c8b446995848c9c9da8a7baf9a2d'),
(1378, 0, 'studio/template/scripts_templ/BxTemplStudioLauncher.php', 'e885607a1ae10563cffcf7ff858c3681'),
(1379, 0, 'studio/template/scripts_templ/BxTemplStudioMenu.php', 'ea92f594885374d68660e26899d7a1ed'),
(1380, 0, 'studio/template/scripts_templ/BxTemplStudioMenuAccountPopup.php', '08911d46b8d391057094a4214af93db6'),
(1381, 0, 'studio/template/scripts_templ/BxTemplStudioMenuTop.php', '1ed73e65394d634939d0e47029fbe5eb'),
(1382, 0, 'studio/template/scripts_templ/BxTemplStudioModule.php', 'eabdd89dad0e01f903df323b67858b0b'),
(1383, 0, 'studio/template/scripts_templ/BxTemplStudioModules.php', 'd21ac1e88ac20fe18a3a1240ab64bca9'),
(1384, 0, 'studio/template/scripts_templ/BxTemplStudioNavigation.php', '6937c66ba4aeadacd1e9a6a6d0349f94'),
(1385, 0, 'studio/template/scripts_templ/BxTemplStudioNavigationImport.php', 'afbfba0fefa2c9f3bf27ff3b95596d31'),
(1386, 0, 'studio/template/scripts_templ/BxTemplStudioNavigationItems.php', '34a52b7016c9a8428cc751708aa1fe10'),
(1387, 0, 'studio/template/scripts_templ/BxTemplStudioNavigationMenus.php', '48a4bb61db66895aad222e4ed2406e54'),
(1388, 0, 'studio/template/scripts_templ/BxTemplStudioNavigationSets.php', 'fef77dfd9e40ae5b2b203920b66f7871'),
(1389, 0, 'studio/template/scripts_templ/BxTemplStudioOptions.php', '2b177e0b1e7aaa3dfb1ddf987e5f423c'),
(1390, 0, 'studio/template/scripts_templ/BxTemplStudioOptionsApi.php', '0e9a1daa9503f1e73dee6a29ac130ef2'),
(1391, 0, 'studio/template/scripts_templ/BxTemplStudioPage.php', '2fee33c751d3433a0fc0cd0acd1d6267'),
(1392, 0, 'studio/template/scripts_templ/BxTemplStudioPermissions.php', 'b066f6e5c45bce7700e0473842168cae'),
(1393, 0, 'studio/template/scripts_templ/BxTemplStudioPermissionsActions.php', '337c7e81a8eee6d655ca603bdb62ac9a'),
(1394, 0, 'studio/template/scripts_templ/BxTemplStudioPermissionsLevels.php', '6bd431f7cf67145158c30b3cdea8d162'),
(1395, 0, 'studio/template/scripts_templ/BxTemplStudioPolyglot.php', 'f3fc20365e6f94ec62ba1118a636c2bb'),
(1396, 0, 'studio/template/scripts_templ/BxTemplStudioPolyglotEtemplates.php', 'cbbe35f64aec4ecd664ca5dc1148838c'),
(1397, 0, 'studio/template/scripts_templ/BxTemplStudioPolyglotKeys.php', '508a3ab7334acf72413031ae35601afa'),
(1398, 0, 'studio/template/scripts_templ/BxTemplStudioRoles.php', '5cbf6b53c98aa273f217c3555a7a5ee9'),
(1399, 0, 'studio/template/scripts_templ/BxTemplStudioRolesActions.php', 'b854ae92c019e856353c1031d769ef02'),
(1400, 0, 'studio/template/scripts_templ/BxTemplStudioRolesLevels.php', '35285f897a035be12cbd9ab1a5fd1f2c'),
(1401, 0, 'studio/template/scripts_templ/BxTemplStudioSettings.php', '10b848b61e500812dd46ebc9f8cbe299'),
(1402, 0, 'studio/template/scripts_templ/BxTemplStudioSettingsServices.php', '61fedf427a98577e4a2fcf7a0d68efb5'),
(1403, 0, 'studio/template/scripts_templ/BxTemplStudioSettingsUploaderHTML5.php', 'b2612d55da942b85dcf8e5a68deea3dd'),
(1404, 0, 'studio/template/scripts_templ/BxTemplStudioStorages.php', 'cad6313f5ef93ea184d1ee2c92a25347'),
(1405, 0, 'studio/template/scripts_templ/BxTemplStudioStoragesFiles.php', '67286ee1759efe0e9e92c88e645d89b9'),
(1406, 0, 'studio/template/scripts_templ/BxTemplStudioStoragesImages.php', '4393dc6b52250ada99d0f14c17c194bd'),
(1407, 0, 'studio/template/scripts_templ/BxTemplStudioStore.php', '270b3c1693594e6c230aa37966ecec89'),
(1408, 0, 'studio/template/scripts_templ/BxTemplStudioUploaderCropCover.php', '1753da21147a323b9b3df0a6055b675d'),
(1409, 0, 'studio/template/scripts_templ/BxTemplStudioWidget.php', '6fb23c76d416b692f9fca59e843d4292'),
(1410, 0, 'studio/template/scripts_templ/BxTemplStudioWidgets.php', '117f2761e01435825f7f7b323127a142'),
(1411, 0, 'studio/template/storages.html', '9bcc33f1e8eb2af480306d362a319e1a'),
(1412, 0, 'studio/template/store.html', '17b3409ca9843aa4b52000fae6e8de6b'),
(1413, 0, 'studio/template/strg_add_files.html', 'c0e8ab14f92ba7b0db8b8b7bce6ac137'),
(1414, 0, 'studio/template/strg_add_images.html', 'c0e8ab14f92ba7b0db8b8b7bce6ac137'),
(1415, 0, 'studio/template/strg_files.html', '9bcc33f1e8eb2af480306d362a319e1a'),
(1416, 0, 'studio/template/strg_images.html', 'c346ccbc34ebd370540141c52225646d'),
(1417, 0, 'studio/template/strg_resize_images_form.html', 'bd7a7f9063c69564e46095ae7fed12c3'),
(1418, 0, 'studio/template/strg_resize_images_result.html', 'd459b6b77890e3f8d80bfc334b2f0eb8'),
(1419, 0, 'studio/template/str_lbl_categories.html', 'bf44e471e7417872c4d8bb47d30b63d1'),
(1420, 0, 'studio/template/str_lbl_tags.html', '3ce1d31dc648c5725b2d991d8516d8c8'),
(1421, 0, 'studio/template/str_notification.html', 'bc59391de9276438299aaa41953a9d87'),
(1422, 0, 'studio/template/str_products.html', 'b4cb34ee72190d85404db9426033e256'),
(1423, 0, 'studio/template/str_product_v1.html', '2fe71dcda379ce37fd98e5543a5096e4'),
(1424, 0, 'studio/template/str_product_v2.html', 'c5c0075d836a531a74be0691672b3a40'),
(1425, 0, 'studio/template/str_product_view.html', '049b0d6880ca0985b25dbfb5de3ba822'),
(1426, 0, 'studio/template/str_search.html', 'c8d2f901a94068744865542c5566c0ff'),
(1427, 0, 'studio/template/str_update_v1.html', 'b11e8e6ee86e003844eaf006c74b39b6'),
(1428, 0, 'studio/template/str_update_v2.html', 'cc2be3897072b44dddc68b5f5530fc3e'),
(1429, 0, 'studio/template/str_vote_stars.html', '623e19f70974ff81d54e03ddb4aba6c9'),
(1430, 0, 'studio/template/templates.html', 'e448ff1259ff7368ee1b462346f5302c'),
(1431, 0, 'studio/template/uploader_form_crop_cover.html', '92d644a27ad58806f083319326a724c0'),
(1432, 0, 'studio/template/widget.html', 'ca552c1903d87963afa7bb9ecbee707b'),
(1433, 0, 'studio/template/widgets.html', 'e2381534b39b38b56f307cd11d4f6b2b'),
(1434, 0, 'studio/template/widgets_page.html', '7a01cb81999d1c36e710005f3f5ab565'),
(1435, 0, 'studio/template/_footer.html', '5e59894bebde2638eb6de9184228f87e'),
(1436, 0, 'studio/template/_header.html', 'a2047c237ce13b499b4b1180e54bbd6c'),
(1437, 0, 'studio/template/_sub_footer.html', '392097dcd1ed63d3c0b3f85bd963bf34'),
(1438, 0, 'studio/template/_sub_header.html', '74b5e62ca24cf0ff34552abd025b6856'),
(1439, 0, 'template/account_link.html', '95baccae789fb7441153638fb3e156dd'),
(1440, 0, 'template/account_unit.html', '485d7b1a8ae54e458caebd9895e42b3c'),
(1441, 0, 'template/account_unit_wo_info.html', '122b2f89d760955e3c3bfe4b03857c17'),
(1442, 0, 'template/account_unit_wo_info_links.html', 'ac087b9ee982488f701076c7be799eca'),
(1443, 0, 'template/acl_membership.html', '5d27ae9877cba17d73e83f646a56f49b'),
(1444, 0, 'template/acl_set.html', '35c969f98e6c1a7d9b095f32d8414462'),
(1445, 0, 'template/adminActionsPanel.html', 'a2ca785016fa9c171a354e6ba81a028d'),
(1446, 0, 'template/adminFilterPanel.html', '8c1202f2b978bb7766a5a158dba6ef3c'),
(1447, 0, 'template/agents_comment_actions_assistant.html', '1c8173ec629b7ca6e872e51bfe69c131'),
(1448, 0, 'template/agents_comment_actions_automator.html', '8a316cff5a5e985ae9f7f619528d948a'),
(1449, 0, 'template/agents_comment_content.html', 'f6dcae610205bb1dce84264660d73864'),
(1450, 0, 'template/agents_comment_loading.html', '34d277e3e0d1e17f3e3ff6961ccada0f'),
(1451, 0, 'template/agents_form.html', '1427dbb919965f9abecfb4617285a937'),
(1452, 0, 'template/agents_popup.html', 'c1405baf9e72a9a0f7e82dcb18460f13'),
(1453, 0, 'template/auth.html', '509543b4b8025ef6c0b808f1a6aaac2b'),
(1454, 0, 'template/author.html', '3293476fd13636367fb0a98401f6c866'),
(1455, 0, 'template/author_desc.html', '0a5b1e96f2efc87c1440209a52fbaff6'),
(1456, 0, 'template/author_link.html', '4f0a6593ee6aa0ba280d2c6e6203a2fd'),
(1457, 0, 'template/badge.html', '33f54f34286563cd73ad9024272dcee4'),
(1458, 0, 'template/block_async_create_post.html', '7a5ba9eaa01d148c33ff6255b139261c'),
(1459, 0, 'template/block_async_image.html', '80367d2e43d7cd0dfe36346e6f2ade87'),
(1460, 0, 'template/block_async_loading_indicator.html', '6b26490c9f6ccbdcd00537b5ef690ab5'),
(1461, 0, 'template/block_async_profile_units.html', '000c341ac8395df82ba09fde1cba739a'),
(1462, 0, 'template/block_async_text.html', 'f20411bae1e4e4890ecca40ff1d98c2c'),
(1463, 0, 'template/block_async_text_units_gallery.html', '92ac5b3de54b311576a0c36e55a1c480'),
(1464, 0, 'template/block_async_text_units_list.html', 'ca44f80b5e79c9b411f698114b352544'),
(1465, 0, 'template/block_creative.html', '04c9c73d4f493c2cd00074045b80755b'),
(1466, 0, 'template/block_join.html', '3e5fa65d63b21b883bd760d53c9ebb47'),
(1467, 0, 'template/block_login.html', '84bd23e09d8aecf294c95bb782f95460'),
(1468, 0, 'template/calendar.html', '9d965e9002faa464ad7d5bd5aed1b849'),
(1469, 0, 'template/calendar_compact.html', '6fb4e936a0d735871cbbc30459e5db1e'),
(1470, 0, 'template/category_list.html', 'a239818455b170e780693295965c5efa'),
(1471, 0, 'template/category_list_multi.html', '0d73ecca4a85bbc5c0e89e57b32699b5'),
(1472, 0, 'template/chart_growth.html', 'b02759bcd8d37fbcfa169ae4bb20f716'),
(1473, 0, 'template/chart_stats.html', '353b93ee0d50afe97e97ae4eda747fb1'),
(1474, 0, 'template/comment.html', 'ba1f074ed4730d14faf832fb5b5f484f'),
(1475, 0, 'template/comments_block.html', 'e1386c95a476086aa40ef6aa5ae14d98'),
(1476, 0, 'template/comments_controls.html', 'f4ac004c3f5afb69ed4cae8a675e2675'),
(1477, 0, 'template/comments_lu_button.html', 'de25a438d63a7c1597fcff5d2d397c04'),
(1478, 0, 'template/comments_lu_notifications.html', '0a1f14a375ac81ab3b6b58459869ba92'),
(1479, 0, 'template/comments_photoswipe.html', '3e1d21380278d1f61b6fedd186bfeb5f'),
(1480, 0, 'template/comments_uploader_bs.html', 'dd681b1101646ded5ca0264275f248a8'),
(1481, 0, 'template/comments_uploader_nfw.html', 'a87e65536b10f5a5a69d4b4d4f90c070'),
(1482, 0, 'template/comment_actions.html', '691a3f41ee1e33fc4ad42581059dfaaa'),
(1483, 0, 'template/comment_attachments.html', '4321b56af7eeacf29ce86dfbe5d9e0ce'),
(1484, 0, 'template/comment_block.html', '4caf04bae33df85731806b1dfb5749c0'),
(1485, 0, 'template/comment_content.html', '6b3d84db8fccf322fff8e44cb81ae4c3'),
(1486, 0, 'template/comment_counter.html', '110aef0c00afab5bcdbaec078be32cdb'),
(1487, 0, 'template/comment_do_comment_label.html', 'a2ac40cf4c80850cb1ff8b8bbf5a8176'),
(1488, 0, 'template/comment_element_block.html', '315366d9fd701a65247c309c6c83b490'),
(1489, 0, 'template/comment_element_inline.html', 'c45076d274a2967fe375737762e30a6e'),
(1490, 0, 'template/comment_empty.html', '002196332119aa16fe7ee4bd20eaee68'),
(1491, 0, 'template/comment_hidden.html', '0d448f2265667dd174e027193fe447d4'),
(1492, 0, 'template/comment_live_search.html', '2461fa1dd31d92e39e482d65dc056035'),
(1493, 0, 'template/comment_more.html', 'ed823c2ee49c538d7f46a8fdeac64e1b'),
(1494, 0, 'template/comment_quote.html', 'c097ef37486b89b4449f8e24d2eaef89'),
(1495, 0, 'template/comment_reply_box.html', '47cb72a1b746e7dbd95fd8e5ed25be81'),
(1496, 0, 'template/comment_reply_to.html', 'd9f45c8d6e8c9235a4b1fef3aff5a0ce'),
(1497, 0, 'template/comment_search.html', '222d6235f6086e6c3049a2df8cbeaf22'),
(1498, 0, 'template/connected_by_list.html', 'fcbee83ba8b1c5a9d54a5a85c1fea8ed'),
(1499, 0, 'template/connections_list.html', '1fa62ab3625a4ec3f52bdc9526c89453'),
(1500, 0, 'template/connection_counter.html', '1673c88a3733a01603307b37efec7068'),
(1501, 0, 'template/connection_counter_label.html', 'df649ed16479f43022fa0ec31861718c'),
(1502, 0, 'template/content_filter_manage_popup.html', 'b13540c7f642ef7cd70ae260594215f9'),
(1503, 0, 'template/cover.html', '3335df1e6ca3e3c17cbdd4621ff932f6'),
(1504, 0, 'template/cover_empty.html', '1a8d9b406f9deaa716feeceb213585a9'),
(1505, 0, 'template/cover_home.html', '98d1343767f2f528754132056b110a7b'),
(1506, 0, 'template/create_post_form.html', '0622c6baf1594c549d6265f85fc530e6'),
(1507, 0, 'template/css/account.css', 'e00ca6d6a2c90ca926dcb7056c9525c1'),
(1508, 0, 'template/css/acl.css', 'a534fd5321ec7cbc6a2f4e9b77970da2'),
(1509, 0, 'template/css/auth.css', '228d36b6a5306751b1a9fbd42e6845a0'),
(1510, 0, 'template/css/chart.css', '3a2414c54784fbb3b675dee403e31f7a'),
(1511, 0, 'template/css/cmts.css', '994788ee852f2b221ca903e6d58ff5b6'),
(1512, 0, 'template/css/cmts_manage_tools.css', 'c1feb422f24f94ee6cf01d61b7892c26'),
(1513, 0, 'template/css/colors.css', '6da2b5c1cd87418a0a19f130878882f5'),
(1514, 0, 'template/css/common.css', '2a9ba56344bf0c17cf10deeb9966b8d5'),
(1515, 0, 'template/css/connection.css', '055e0927399de33aa4c8dbd7a425bc54'),
(1516, 0, 'template/css/cover.css', 'e7fb2daa2f6eae4f420447104e36d848'),
(1517, 0, 'template/css/default.less', '43f80fefa0c9c7d5b3932f19a004a89c'),
(1518, 0, 'template/css/editor.less', 'aa81cf6236b9b7cd27774e5c0ae9479b'),
(1519, 0, 'template/css/editor.quill.css', '43a2582a4d545e93e0a7a5afcf4321b4'),
(1520, 0, 'template/css/editor_snow.quill.css', '0e3c87bc76818d1845b579b15e259111'),
(1521, 0, 'template/css/embed.css', 'dc587b7f043abed183667c2045fe18c7'),
(1522, 0, 'template/css/favorite.css', 'd41d8cd98f00b204e9800998ecf8427e'),
(1523, 0, 'template/css/feature.css', 'd41d8cd98f00b204e9800998ecf8427e'),
(1524, 0, 'template/css/file_handler.css', '8d6c7865071dfa548bccc0bbb52c9de6'),
(1525, 0, 'template/css/forms.css', '5544d65465aca5d3f5bb24273cedcba6'),
(1526, 0, 'template/css/fullcalendar.css', 'b9f5d2d576b7c5d2d745f8d97fb70432'),
(1527, 0, 'template/css/general.css', 'e509fe4dd643030fcb207dfd5d8c1d48'),
(1528, 0, 'template/css/grid.css', 'f7e7512e09bdd826170cbc591730c6ae'),
(1529, 0, 'template/css/homepage.css', '68b329da9893e34099c7d8ad5cb9c940'),
(1530, 0, 'template/css/icons.css', 'fbceae9775e26538d3cd9d02449d13cb'),
(1531, 0, 'template/css/informer.css', '2b5e4ddc5bcc94d1ce98d45e6f744bc4'),
(1532, 0, 'template/css/jquery-ui/images/ui-bg_glass_55_fbf9ee_1x400.png', '4aef8cb4f7d1cd52ccc8ab4fdf8350c7'),
(1533, 0, 'template/css/jquery-ui/images/ui-bg_glass_65_ffffff_1x400.png', '192e4a7125e06873eade6b182f9ac16f'),
(1534, 0, 'template/css/jquery-ui/images/ui-bg_glass_75_dadada_1x400.png', 'c4d9ba72a815e72ae0e251bb831cf826'),
(1535, 0, 'template/css/jquery-ui/images/ui-bg_glass_75_e6e6e6_1x400.png', '721f544897a687d73864aa09e1f2f035'),
(1536, 0, 'template/css/jquery-ui/images/ui-bg_glass_95_fef1ec_1x400.png', '719a6a0dff6def47019ff4f43dcd20c1'),
(1537, 0, 'template/css/jquery-ui/images/ui-bg_highlight-soft_75_cccccc_1x100.png', '355b3cbdb6d3c5c2980758f35dd5eed3'),
(1538, 0, 'template/css/jquery-ui/images/ui-icons_222222_256x240.png', '423b356c07e72d21fb063e8cccc0e8f6'),
(1539, 0, 'template/css/jquery-ui/images/ui-icons_2e83ff_256x240.png', '9ece85c0469b63da41fc98c8c51b05f9'),
(1540, 0, 'template/css/jquery-ui/images/ui-icons_454545_256x240.png', 'd1af6388a139619ca77ab8dbb0ed35f8'),
(1541, 0, 'template/css/jquery-ui/images/ui-icons_888888_256x240.png', '24a6ae671d0fab236cf03260ee6515f6'),
(1542, 0, 'template/css/jquery-ui/images/ui-icons_cd0a0a_256x240.png', 'ee5af03bd9d0031d07b940b2a8733c8e'),
(1543, 0, 'template/css/jquery-ui/jquery-ui.min.css', 'fe01dcaa38437501d2ce188c7feb8726'),
(1544, 0, 'template/css/label.css', 'd7d6d031c1898aa95ea6519795703b06'),
(1545, 0, 'template/css/location_map_google_static.css', '4e7ad9754d69f7497600e807cd54da4b'),
(1546, 0, 'template/css/location_map_leaflet.css', 'b0ccf7516b6a5f578cfe4c4d7c8e066d'),
(1547, 0, 'template/css/manage_tools.css', '44d3bee7123cc9b0251df620867fe2a5'),
(1548, 0, 'template/css/media-desktop.css', 'f43aeb37a2d071af1896c06145d96038'),
(1549, 0, 'template/css/media-phone.css', '4d25d36b802c4953d9cea0d7a1464556'),
(1550, 0, 'template/css/media-print.css', '59afa8d053d8aa7d01752eee71c749d8'),
(1551, 0, 'template/css/media-tablet.css', '74048a293e19bc88e2acae451529a71e'),
(1552, 0, 'template/css/menu.css', 'f4650b50392a450e082fc75538a28167'),
(1553, 0, 'template/css/metatags.css', '4a6e35a36c1ae2449aa9b37c6355c78a'),
(1554, 0, 'template/css/oembed.css', 'f293c39cb25f545ea4c3e9842fbb9021'),
(1555, 0, 'template/css/page_layouts.css', '087b7b466f0e70199583713284458cb6'),
(1556, 0, 'template/css/paginate.css', '9e44fd881051dc0228f82efe0c4be4b7'),
(1557, 0, 'template/css/privacy.css', '38f24f64e2294d9b93443b787b759131'),
(1558, 0, 'template/css/report.css', '29beffe28b68e9fd8428bda64c8c5444'),
(1559, 0, 'template/css/rss.css', 'f841dbce12ec8d5dee51ae7c57100d9f'),
(1560, 0, 'template/css/score.css', '70bd7820d8296496fba068f43904e934'),
(1561, 0, 'template/css/search_extended.css', '5acd85d16c918db50728e377c51c9fd4'),
(1562, 0, 'template/css/tailwind.css', '489bd8e0bf18bc22c2263d7db91f6820'),
(1563, 0, 'template/css/uploaders.css', '8f520544d54c08ce321205a404f6d913'),
(1564, 0, 'template/css/view.css', '7d73e64ce7e21001a6bb5936515d4bd6'),
(1565, 0, 'template/css/vote.css', '73494520cba982a5a10e33dce54742ab'),
(1566, 0, 'template/css/wiki.css', '25ea1820e366a55b684b7f1972e630c0'),
(1567, 0, 'template/css/_mixins.less', '873127d498ddce23dbc60b34bc408975'),
(1568, 0, 'template/css/_remixins.less', 'f68baef1e9b20dd767d1a908c23ae687'),
(1569, 0, 'template/default.html', '0c15a6450605e389b6403086c3137f9a'),
(1570, 0, 'template/designbox_0.html', '58e649dbe2e5e6972db2a305f2771783'),
(1571, 0, 'template/designbox_1.html', '4ad339ac153c95ce97dcffb24bdad8f3'),
(1572, 0, 'template/designbox_10.html', 'e825965ab4594ed9520c87410405d77d'),
(1573, 0, 'template/designbox_11.html', '39264b8cb2f112e81f0a258393045689'),
(1574, 0, 'template/designbox_13.html', '0e6118628d2a3dcb6a666887a5c8bdb9'),
(1575, 0, 'template/designbox_14.html', '8d9f8c05b0a23244cdf0689bdaf3efb8'),
(1576, 0, 'template/designbox_2.html', 'c507fadb4282a1cc8acd2098fe5653ab'),
(1577, 0, 'template/designbox_3.html', '1baeb5e6f872d9736f959830c2db7493'),
(1578, 0, 'template/designbox_4.html', '43d3767b44ce4d1bf7a9e72eb908af62'),
(1579, 0, 'template/designbox_container.html', 'd0618b20bb09e0d68a73d4ea0ed7f72c'),
(1580, 0, 'template/designbox_help.html', '6e25a8be8e31db86e878fce400b509d4'),
(1581, 0, 'template/designbox_help_popup.html', 'd149236a7193c6f2635c9cd5b35e249f'),
(1582, 0, 'template/designbox_menu.html', 'ccbbc6d63e2b9fe428330b002b983955'),
(1583, 0, 'template/designbox_menu_1.html', 'd90aab0e5395032164c1077dfdf4eb5d'),
(1584, 0, 'template/designbox_menu_2.html', '3baa29e7a4333bde9aea361ccbf87166'),
(1585, 0, 'template/designbox_menu_button.html', '1125c042274530663a980a4ea69f5544'),
(1586, 0, 'template/designbox_menu_popup.html', '4469bc5c87c356be3c450eabe4e0c993'),
(1587, 0, 'template/designbox_share_popup.html', '5d1c451493b58d8f461cd9c96df8f26b'),
(1588, 0, 'template/embed.html', 'eda0e88f613f0c9c0f65e3e1577cbe44'),
(1589, 0, 'template/embed_card.html', '38a36e9b2327face83421dbc695f37f2'),
(1590, 0, 'template/embed_embedly_integration.html', '6b91c00b2bade11352763d07ae05ad2d'),
(1591, 0, 'template/embed_embedly_link.html', 'e22bc5bf78d96b442d47a966e2143eec'),
(1592, 0, 'template/embed_iframely_integration.html', 'af5da092c27e52619fef7c2d5bda3a03'),
(1593, 0, 'template/embed_iframely_link.html', '23e464e79b7fabe321f06e659fb408d6'),
(1594, 0, 'template/embed_oembed_integration.html', 'ea309ed438908478f62bf7d976ed12f5'),
(1595, 0, 'template/embed_oembed_link.html', '142a5412e2d9a2f16a64ca084a7aa285'),
(1596, 0, 'template/embed_system_link.html', '0f62810a5d26d9be29ca52a08fa29b13'),
(1597, 0, 'template/et_account.html', '732cc00d97bf671cf53eeb8e0e8acc8b'),
(1598, 0, 'template/favorite_by_list.html', 'b7f1112936a64e52f53942ef12e560e9'),
(1599, 0, 'template/favorite_do_favorite_label.html', '718426de0c11a915623147945b074d5d'),
(1600, 0, 'template/favorite_do_favorite_popup.html', '9d683bc1f487c5f0ac3836f9e26fbaf0'),
(1601, 0, 'template/favorite_edit_favorite_list.html', '7156ef8537c6a246df58e41a2ca3164f'),
(1602, 0, 'template/favorite_element_block.html', '9f99004ee328bfd72de97f51570e5ced'),
(1603, 0, 'template/favorite_element_inline.html', '7ba2a46ed9ab34d1ba05d972c9e466a4'),
(1604, 0, 'template/feature_do_feature_label.html', '718426de0c11a915623147945b074d5d'),
(1605, 0, 'template/feature_element_block.html', '8817cf15be4203ccedcf47d4d773f009'),
(1606, 0, 'template/feature_element_inline.html', '678f67f1b0f51ebea1ba312068840c1e'),
(1607, 0, 'template/fonts/fa-brands-400.eot', '592643a83b8541edc52063d84c468700'),
(1608, 0, 'template/fonts/fa-brands-400.svg', '1d5619cd804367cefe6da2d79289218a'),
(1609, 0, 'template/fonts/fa-brands-400.ttf', '513aa607d398efaccc559916c3431403'),
(1610, 0, 'template/fonts/fa-brands-400.woff', '1a575a4138e5f366474f0e7c5bd614a5'),
(1611, 0, 'template/fonts/fa-brands-400.woff2', 'ed311c7a0ade9a75bb3ebf5a7670f31d'),
(1612, 0, 'template/fonts/fa-regular-400.eot', 'b0e2db3b634d1bc3928e127458d993d8'),
(1613, 0, 'template/fonts/fa-regular-400.svg', 'c5d109be8edd3de0f60eb472bd9ef691'),
(1614, 0, 'template/fonts/fa-regular-400.ttf', '766913e6c0088ab8c9f73e18b4127bc4'),
(1615, 0, 'template/fonts/fa-regular-400.woff', 'd1d7e3b4c219fde0f7376c6facfd7149'),
(1616, 0, 'template/fonts/fa-regular-400.woff2', 'b91d376b8d7646d671cd820950d5f7f1'),
(1617, 0, 'template/fonts/fa-solid-900.eot', '0c6bfc668a72935760178f91327aed3a'),
(1618, 0, 'template/fonts/fa-solid-900.svg', '37bc7099f6f1ba80236164f22e905837'),
(1619, 0, 'template/fonts/fa-solid-900.ttf', 'b9625119ce4300f0ef890a8f3234c773'),
(1620, 0, 'template/fonts/fa-solid-900.woff', 'd745348d289b149026921f197929a893'),
(1621, 0, 'template/fonts/fa-solid-900.woff2', 'd824df7eb2e268626a2dd9a6a741ac4e'),
(1622, 0, 'template/file_handler_code.html', '96c4ca02b8fe619ce31674496547438c'),
(1623, 0, 'template/file_handler_iframe.html', '51a032027192ddf5f0133d4d26b68d47'),
(1624, 0, 'template/file_handler_img.html', '2105ff960a10c57a9ad8f83c5dbb3a05'),
(1625, 0, 'template/file_handler_sound.html', 'd13070327ff20d6a3abd3ba270dfc650'),
(1626, 0, 'template/file_handler_video.html', 'f320018988e32e31a239eec2277bceb4'),
(1627, 0, 'template/footer.html', 'fbfec6b265ff0c7e2368de4974eeb3eb'),
(1628, 0, 'template/form_field_button.html', '7158183f9e11cf37950df1dd112cf94d'),
(1629, 0, 'template/form_field_custom_suggestions.html', '770f9c3e54a4bda23da37171ab5556d7'),
(1630, 0, 'template/form_field_custom_suggestions_js.html', 'eaee6914850c9408b40ee27848d372c4'),
(1631, 0, 'template/form_field_help_popup.html', '1b2f98d874709f3b4066bfdb7c8fa422'),
(1632, 0, 'template/form_field_labels_view.html', '9870e365ed7c4418c2e8735386cd1af5'),
(1633, 0, 'template/form_field_location_radius.html', 'e6a17034a3e41c2c13cd7479ab33d1d9'),
(1634, 0, 'template/form_field_nested_form.html', 'a7739e2885cdfd4bbea82b6758f48b13'),
(1635, 0, 'template/form_field_nested_form_wrapper.html', '6736f0c5b4248662fa127a94de13d6f4'),
(1636, 0, 'template/form_field_option_info.html', 'b39931924006417520d3cd065ee283dd'),
(1637, 0, 'template/form_field_password.html', '13e60e8efa2e9ff1d8645322c1d6cfc0'),
(1638, 0, 'template/form_field_price.html', '8f433a6e13f53d6f8a8c6d4a92ee0ba5'),
(1639, 0, 'template/form_field_privacy.html', 'ca63493c723a5c0026e1cb8621f3c3bd'),
(1640, 0, 'template/form_field_privacy_popup.html', 'ec783ce6256f69bd2e9c4a744ef4b373'),
(1641, 0, 'template/form_field_section_title.html', '9cf7a4ace201a005b6854087a53e2686'),
(1642, 0, 'template/form_field_select.html', '6baf0eb2285db9c973d025c8d08b2b13'),
(1643, 0, 'template/form_field_standard.html', 'b8eb939e1584e3096c489f9107ed7474'),
(1644, 0, 'template/form_field_switcher.html', 'a98c47b58d8d55aee95c34be97e76be5'),
(1645, 0, 'template/form_field_textarea.html', 'f9c5767effc9608d700027a9e228b1f1'),
(1646, 0, 'template/form_field_uploader.html', '0aefad701ba52c8ac27f9d63bf6b7ba5'),
(1647, 0, 'template/form_input_wrapper.html', '31533b24de1cc9dec752c90ad8914c4d'),
(1648, 0, 'template/form_row_custom.html', 'ff080ee10a9dd994dddaa346c7e73e7d'),
(1649, 0, 'template/form_row_standard.html', 'e3d14553daef0df3cae4398b41afcdab'),
(1650, 0, 'template/form_view_nested_row.html', '1c9c3c622a17e5eb895fe4b4a0a70949'),
(1651, 0, 'template/form_view_rateable_row.html', 'ce40bcf4926308348e7e6e8c396c499d'),
(1652, 0, 'template/form_view_row.html', '616e8df3fa70bb8c794adb76d943d02c'),
(1653, 0, 'template/grid.html', 'd19b1ddcbbd1163638cd4c048d0f0d35'),
(1654, 0, 'template/homepage_tour.html', '4327ac4f6b044fc890ffe4c42f0bb82d'),
(1655, 0, 'template/icon_emoji.html', 'da270d2f16a2a4c7e63d5a754cc156fe'),
(1656, 0, 'template/images/account.svg', '7199b9ce5ac8ea223b101853b1f3221c'),
(1657, 0, 'template/images/acl-account.png', '1be3658f1ea6980c78fe24716cb2442b'),
(1658, 0, 'template/images/acl-administrator.png', 'b7317536c5f7bd190fbbff80a7ef1534'),
(1659, 0, 'template/images/acl-moderator.png', '04cc662fabef08a9702fd46af32351eb'),
(1660, 0, 'template/images/acl-non-member.png', '7fbba5cba0a839cd9042c9bd9b744261'),
(1661, 0, 'template/images/acl-pending.png', '65672a25e770a45fa0c4cb3395feaee4'),
(1662, 0, 'template/images/acl-premium.png', '72457f20abf7d5fa49b42c65cf30f986'),
(1663, 0, 'template/images/acl-standard.png', '58bb5000be079f59b4a387a34de7a5db'),
(1664, 0, 'template/images/acl-suspended.png', '65672a25e770a45fa0c4cb3395feaee4'),
(1665, 0, 'template/images/acl-unconfirmed.png', '65672a25e770a45fa0c4cb3395feaee4'),
(1666, 0, 'template/images/cover-homepage.svg', '2dae8db052883c27bc440df947c33954'),
(1667, 0, 'template/images/cover.svg', '2010a1a7192d84f543dbf84d520cf723'),
(1668, 0, 'template/images/cover01.jpg', '560b8c8fa101c669b6f878a31ff461cc'),
(1669, 0, 'template/images/cover01.mp4', '7de113515cecc86b3eda5ee3ed5cb87c'),
(1670, 0, 'template/images/cover01.webm', '3e3a5ffc328371977fcc4fd82f78cd9b'),
(1671, 0, 'template/images/cover02-2x.jpg', 'cd1b58bf2cf833ee2cf0e02fb0862f1f'),
(1672, 0, 'template/images/cover02.jpg', '56bfc3bd1dabe1edd88f0c01fdaa1f5a'),
(1673, 0, 'template/images/cover03.jpg', 'ab51b523f128104c81d32036606c411f'),
(1674, 0, 'template/images/icons/apple-touch-icon.png', 'c1c8840ccbba5c020dff162beaa0cdcb'),
(1675, 0, 'template/images/icons/clock.png', '6e11bcef26219676a9e8340d8384db8d'),
(1676, 0, 'template/images/icons/facebook-icon.png', '08f9ee8331476e308e22e27dc963ff58'),
(1677, 0, 'template/images/icons/favicon.svg', 'f01728874c25597ca6c033d3e27d3cf8'),
(1678, 0, 'template/images/icons/grid-drag-handle.png', '059555f64fda208f1be81aa29dcb2d54'),
(1679, 0, 'template/images/icons/mime-type-any.png', '430ed86c97a469a37884072233232fe5'),
(1680, 0, 'template/images/icons/mime-type-any.svg', '24a458becc67049b097246b2f0ea7aca'),
(1681, 0, 'template/images/icons/mime-type-archive.png', 'a20397f7e3a35de41ff98473c0cfc657'),
(1682, 0, 'template/images/icons/mime-type-archive.svg', '66df9b7acea8e6dd3edc7815cc761917'),
(1683, 0, 'template/images/icons/mime-type-audio.png', '346ff1620878153297e0e190ddae335e'),
(1684, 0, 'template/images/icons/mime-type-audio.svg', 'ff382067e98673937571f81dc93281ad'),
(1685, 0, 'template/images/icons/mime-type-document.png', '76a4c4f4d732d232e9b5380145c484c4'),
(1686, 0, 'template/images/icons/mime-type-document.svg', 'f210446150ab5ac9dd6e3deb635ac57e'),
(1687, 0, 'template/images/icons/mime-type-image.png', 'b3f25a8c50bcc525d9f511e9ecb275b6'),
(1688, 0, 'template/images/icons/mime-type-image.svg', '3bcd40713492ca78d5adfcc45fd84fe6'),
(1689, 0, 'template/images/icons/mime-type-png.png', '60e9e3a0ad26f7c2457783cbcc5b5b24'),
(1690, 0, 'template/images/icons/mime-type-png.svg', '853f8226d1293330c2dbbeb1747fc3e2');
INSERT INTO `sys_modules_file_tracks` VALUES
(1691, 0, 'template/images/icons/mime-type-presentation.png', '80e36f899f765d9dfc5f95c115a7e3b6'),
(1692, 0, 'template/images/icons/mime-type-presentation.svg', '18f3cdadfd9fd968b35b8b4390bd6c3f'),
(1693, 0, 'template/images/icons/mime-type-psd.png', '84407ac34111651508d8e94ab7154472'),
(1694, 0, 'template/images/icons/mime-type-psd.svg', '3bcd40713492ca78d5adfcc45fd84fe6'),
(1695, 0, 'template/images/icons/mime-type-spreadsheet.png', 'fdf629c9f0277af4471a50273a174970'),
(1696, 0, 'template/images/icons/mime-type-spreadsheet.svg', 'd61062946a043c98cd8e0465da99e741'),
(1697, 0, 'template/images/icons/mime-type-vector.png', '618785907d0532291efe9c5b306c28b9'),
(1698, 0, 'template/images/icons/mime-type-vector.svg', '6ed856a3e206d085b0f1f9613f32cd91'),
(1699, 0, 'template/images/icons/mime-type-video.png', '46e467de611711114e9fab3d78187f0d'),
(1700, 0, 'template/images/icons/mime-type-video.svg', '0891f53f353087a603c7614729a2fad6'),
(1701, 0, 'template/images/icons/spacer.gif', '18b3b970eb07b30bd8fe644ea2c85f1e'),
(1702, 0, 'template/images/icons/una.svg', '7633debb848db4e7c5833ca2476f2762'),
(1703, 0, 'template/images/layout_1_column.png', 'edaa03ccf84e313fa2f326d8ae06cf08'),
(1704, 0, 'template/images/layout_1_column_half.png', '659003ac23415cd61fbe0078889e4e1c'),
(1705, 0, 'template/images/layout_1_column_thin.png', '3045bfcbbdcb6faa678365f610d3bd03'),
(1706, 0, 'template/images/layout_1_column_wiki.png', 'cdb95130abc8859381ece76668803114'),
(1707, 0, 'template/images/layout_2_columns.png', 'b3198220095e339fac5ae22bab8c52ce'),
(1708, 0, 'template/images/layout_3_columns.png', '7fe7f1db787d7303016ba69761c9f09c'),
(1709, 0, 'template/images/layout_bar_content_bar.png', '1b04738b7f4643b99633ac0a2e9f959b'),
(1710, 0, 'template/images/layout_bar_left.png', 'bf945802efb809a93cd3b2997c0225f9'),
(1711, 0, 'template/images/layout_bar_right.png', '82b7088739a17bded6887f9838625186'),
(1712, 0, 'template/images/layout_bottom_area_2_columns.png', 'aeaa022cc89db3bc1dc4ce63f74dcbd7'),
(1713, 0, 'template/images/layout_topbottom_area_2_columns.png', '252516f780df30cbf802b26279b23957'),
(1714, 0, 'template/images/layout_topbottom_area_bar_left.png', 'ca9d3119840dc521aec8803f7e94e934'),
(1715, 0, 'template/images/layout_topbottom_area_bar_right.png', '8bfd0624e741d533b46c75dd14b3b6a7'),
(1716, 0, 'template/images/layout_topbottom_area_col1_col3_col2.png', '74eab8630d15299d3fe2f4ce449be8a8'),
(1717, 0, 'template/images/layout_topbottom_area_col1_col5.png', '4feb701b8c4adb88cb957974306a012a'),
(1718, 0, 'template/images/layout_topbottom_area_col2_col5_col3.png', 'd47136d0e01a9295544b4866b56301a3'),
(1719, 0, 'template/images/layout_top_area_2_columns.png', '9c365c17f232345f7193fbb79b24ec25'),
(1720, 0, 'template/images/layout_top_area_3_columns.png', 'cf7e217ba0c965bd13b026ed3dc2633e'),
(1721, 0, 'template/images/layout_top_area_bar_content_bar.png', '07564e4212fa56a4428404cf25763d01'),
(1722, 0, 'template/images/layout_top_area_bar_left.png', '4ab89add7159f615c333d25165b98246'),
(1723, 0, 'template/images/layout_top_area_bar_right.png', '192d23f2bcb9e3f4b83b905f9566a952'),
(1724, 0, 'template/images/loading-spinner.gif', '2da0807814ad64841cd597c4e8a653d1'),
(1725, 0, 'template/images/spacer.gif', '18b3b970eb07b30bd8fe644ea2c85f1e'),
(1726, 0, 'template/images/spl-icon-connect.json', '50dcd3ece683a3804bb380d98bf4e3ea'),
(1727, 0, 'template/images/spl-icon-create.json', 'a68447d9192f58a20af8cc2a84f04e64'),
(1728, 0, 'template/images/spl-icon-share.json', '690eaf8a9bee8001a6b82f2a3558b767'),
(1729, 0, 'template/images/spl-image-main.svg', 'c5ff6bf9a28c2fc85594bf8b8fce3b63'),
(1730, 0, 'template/images/splash.png', '74eaf93b8138204c31c7889674f77416'),
(1731, 0, 'template/images/video-na.png', '3fd8b38579654f94789a090fa2363cb7'),
(1732, 0, 'template/informer.html', 'b063ee75fa2fdca1b298c58ea7aa46d0'),
(1733, 0, 'template/label_browse.html', '58a68df14cfd25ee67db794405f66d6b'),
(1734, 0, 'template/label_browse_level.html', 'aecc95fdcd3945125acea83ea169efaa'),
(1735, 0, 'template/label_select_field.html', '763be0a1b135c599f63bc527539c5e4e'),
(1736, 0, 'template/label_select_field_item.html', '2b3326490f4938474faa429637568721'),
(1737, 0, 'template/label_select_list.html', '2ec949a7905d5f925eccec7de26fa02f'),
(1738, 0, 'template/label_select_list_level.html', '2775bbc2fba7a24d41edf411b17f0ebb'),
(1739, 0, 'template/label_select_popup.html', '31381ef39a655fbeea5fb28d5c138b8b'),
(1740, 0, 'template/layout_1_column.html', 'a2287bacebb57d4b4bac9de4cc190210'),
(1741, 0, 'template/layout_1_column_half.html', '6dadb4adcb82bd5fd3f1d171e34fefc8'),
(1742, 0, 'template/layout_1_column_thin.html', 'acd2fccaabcc1079058b7174a1e551e8'),
(1743, 0, 'template/layout_1_column_wiki.html', '749f25463cf7748d45660720dc66fc2f'),
(1744, 0, 'template/layout_2_columns.html', '5f89fc6b90d88117e11211eb43f0acfe'),
(1745, 0, 'template/layout_3_columns.html', 'e9e2aae5a91dbd9a3ba15eb1bbf78269'),
(1746, 0, 'template/layout_bar_content_bar.html', '78c908ec5baddb88241402766b16bd61'),
(1747, 0, 'template/layout_bar_left.html', '07373dfba037f87a68e25873773dc6f6'),
(1748, 0, 'template/layout_bar_right.html', 'b414386f476e5beeed1177b728d49027'),
(1749, 0, 'template/layout_bottom_area_2_columns.html', '68a2baf707e172f5ded4cd0827a4cad5'),
(1750, 0, 'template/layout_topbottom_area_2_columns.html', '93501266a99175bddcf7bea9ee5bd6e2'),
(1751, 0, 'template/layout_topbottom_area_bar_left.html', '149a2895846e7906295fce52e7301cbf'),
(1752, 0, 'template/layout_topbottom_area_bar_right.html', 'bd1a98d2ed8cf6570afff02c0c3bc478'),
(1753, 0, 'template/layout_topbottom_area_col1_col3_col2.html', 'ad9f5b7f595884193c59e4bfd391fe71'),
(1754, 0, 'template/layout_topbottom_area_col1_col5.html', '88b94b734a724c1a8b603767a032c1ad'),
(1755, 0, 'template/layout_topbottom_area_col2_col5_col3.html', 'd95ffa1a386e43f8753ed29242ade2d2'),
(1756, 0, 'template/layout_top_area_2_columns.html', 'aec06fac02f814471e8def1120fff34d'),
(1757, 0, 'template/layout_top_area_3_columns.html', '252173822132ad5c11bae140f66cae1c'),
(1758, 0, 'template/layout_top_area_bar_content_bar.html', '8dab73e36823288bc92101ad87feffef'),
(1759, 0, 'template/layout_top_area_bar_left.html', '8efb00e9b38ce94df35f5999033cc3aa'),
(1760, 0, 'template/layout_top_area_bar_right.html', '9d4fa5c22abbfe3a2c57553506a7a51d'),
(1761, 0, 'template/location_field_google.html', '5fd3ee2b572baf0ff409e887e2e6171e'),
(1762, 0, 'template/location_field_plain.html', '3a8bdea3887261880089555519ae27d3'),
(1763, 0, 'template/location_field_plain_auto.html', '3377af2e63b8fc4b91ea07273a525dd3'),
(1764, 0, 'template/location_map_google_static.html', '6718aee1733310c6523a8384da1b6eb5'),
(1765, 0, 'template/location_map_leaflet.html', '1d834608e373bb87a7e199b4e80a5f9c'),
(1766, 0, 'template/logo_main.html', '31f213e1da477fae5c0697aca038a31a'),
(1767, 0, 'template/map_profile_active.html', '586d99f2d6a605254025e1cddd7442ba'),
(1768, 0, 'template/map_profile_create.html', 'b4870714e7ce754a300a816eb1c84d2f'),
(1769, 0, 'template/map_profile_notifications.html', '2f395f79e545eaeab30ffe3830c695f7'),
(1770, 0, 'template/menu_account_notifications.html', '653a1a6c12ceb39ebc6bd689bf72dd71'),
(1771, 0, 'template/menu_account_popup.html', '46db276eec5b88818225611689becc73'),
(1772, 0, 'template/menu_add_content.html', '551fd6cff6307f66e2db11d3a8420191'),
(1773, 0, 'template/menu_apps.html', '17208b64eed2f5b2e22f6a88f3eaaa67'),
(1774, 0, 'template/menu_block_submenu_hor.html', '4baac096995f92c6fee182e0aca7fe11'),
(1775, 0, 'template/menu_block_submenu_ver.html', 'cc26704496d1921138f23f7442809044'),
(1776, 0, 'template/menu_buttons_hor.html', '2155bf2d8aff76193068bbff7b9be36e'),
(1777, 0, 'template/menu_buttons_hor_item.html', 'b79a22400939c75d84366bd88577a55c'),
(1778, 0, 'template/menu_buttons_icon_hor.html', 'c825cfc0dd4aa0bfda01bf2e247905df'),
(1779, 0, 'template/menu_buttons_icon_hor_item.html', '6e8ace7ee71b212512967c0cddb07f92'),
(1780, 0, 'template/menu_buttons_ver.html', '876a131fa9a681beac9179ac1fb30375'),
(1781, 0, 'template/menu_custom_hor.html', '914d0b5d742b6c76bd5cbf73e4c2d96d'),
(1782, 0, 'template/menu_custom_hor_sys_cmts_item_actions.html', '3e01dbbf7db40e02fa851fba1222cc55'),
(1783, 0, 'template/menu_custom_item.html', '5ac77ed26e0ee6076db7eb8ee7adb9a9'),
(1784, 0, 'template/menu_custom_item_addon.html', '3dbca91606fec46702bbac4fd2d4008f'),
(1785, 0, 'template/menu_custom_item_more.html', 'd9598da43b70902467ce08f4af5f8605'),
(1786, 0, 'template/menu_custom_ver.html', '198c6147fc03471141b6c64fc3c0b0ed'),
(1787, 0, 'template/menu_empty.html', '68b329da9893e34099c7d8ad5cb9c940'),
(1788, 0, 'template/menu_floating_blocks.html', 'bdc0f79291484e92d8d5e1df23557205'),
(1789, 0, 'template/menu_floating_blocks_big.html', '02d48b81402675054b7c8ea50dde905a'),
(1790, 0, 'template/menu_floating_blocks_dash.html', '628ee44289044022f74d29f6161e2bc3'),
(1791, 0, 'template/menu_floating_blocks_wide.html', '94e8514d8e1970521103d8ff26709d5d'),
(1792, 0, 'template/menu_footer.html', 'b8aa53f8af4df98f40ebcdc056b6db12'),
(1793, 0, 'template/menu_footer_subitems.html', 'ba570100cd2c933f55dc2ac5aaa971c2'),
(1794, 0, 'template/menu_horizontal.html', 'ee89ba03efc1d7ebfe33bef59f08e672'),
(1795, 0, 'template/menu_icon.html', '5b4f738d35a2379e89722b1883a55689'),
(1796, 0, 'template/menu_inline.html', 'b86ee1e39547991353216a0f68c80d4f'),
(1797, 0, 'template/menu_inline_sbtn.html', 'f64bab8ea65375cd3c5ff52f9609fa13'),
(1798, 0, 'template/menu_interactive.html', 'd0fcdcedb67497927a54a7bf29aa7c74'),
(1799, 0, 'template/menu_interactive_vertical.html', '873e1ec5d660cf30d6c03e5ea61f0f11'),
(1800, 0, 'template/menu_item_addon.html', '12b20ca784d7c397a417697ff70d3bad'),
(1801, 0, 'template/menu_item_addon_middle.html', '51599616eadcfe3aa59acfbde86e5701'),
(1802, 0, 'template/menu_item_addon_small.html', 'db880667ac1e336ccf5d91be8c974b2c'),
(1803, 0, 'template/menu_item_dashboard_manage_tools_addon.html', '88b94d87a40f34258cd42789799442cd'),
(1804, 0, 'template/menu_item_more.html', 'd9598da43b70902467ce08f4af5f8605'),
(1805, 0, 'template/menu_item_more_popup.html', 'dc14d83d3587b3aa169f26411070495d'),
(1806, 0, 'template/menu_loading.html', '97a2f89a9032756e1fd1371a7742d297'),
(1807, 0, 'template/menu_main.html', '551fd6cff6307f66e2db11d3a8420191'),
(1808, 0, 'template/menu_main_in_panel.html', '4355a6508090081d5326a7c14b28a682'),
(1809, 0, 'template/menu_main_submenu.html', '822ecf14bbdefba414dd588497159167'),
(1810, 0, 'template/menu_main_submenu_more_auto.html', '1a06f0e66311fe8a43fd716b6561ac69'),
(1811, 0, 'template/menu_meta_item.html', '04dddb6dfd9b5ab7b9d639fc201e095b'),
(1812, 0, 'template/menu_more_auto.html', 'b5f0bf4b3bd2e4fd7ae6b1aa089f58ba'),
(1813, 0, 'template/menu_multilevel.html', '6d36f2e3f52db401e4cec320692d48b6'),
(1814, 0, 'template/menu_multilevel_subitems.html', '5eee3661f754295578510fd931b49237'),
(1815, 0, 'template/menu_panel.html', '7dfcfc49bf109fec14fcb9f033911a92'),
(1816, 0, 'template/menu_profile_followings.html', 'baf75c6c3d6df78657b0008151f02325'),
(1817, 0, 'template/menu_profile_followings_subitems.html', '96ecd1df3064ebea384e89a1e391a0eb'),
(1818, 0, 'template/menu_switch_language_title.html', 'a0962b164ab3f2f80bea599d4037d163'),
(1819, 0, 'template/menu_toolbar.html', 'e666db5da7fc4e1d2e04961fa5f95910'),
(1820, 0, 'template/menu_vertical.html', 'cb1cb9a6217ad0bb0c5b044fa98862a8'),
(1821, 0, 'template/menu_vertical_lite.html', '93ef0c1028cbef837f3f6f23ea617e70'),
(1822, 0, 'template/menu_vertical_more_less.html', '4e843c175aac9e3407940a7123ffbd87'),
(1823, 0, 'template/messageBox.html', '70c1e1bc5aa2f14e5b9ce097e90adf28'),
(1824, 0, 'template/metatags_keywords_cloud.html', '64ed7d8d67dc774c53b180b406e55fb0'),
(1825, 0, 'template/metatags_keywords_list.html', '3d10a29b9f05ed77ebdfc42e0e93e296'),
(1826, 0, 'template/page_150.html', '1a1f2e1ff554dbbe39468de846e13422'),
(1827, 0, 'template/page_2.html', 'c21dfac42353c1d84c870df1ed6f38cb'),
(1828, 0, 'template/page_22.html', '31ee289c43c6b4885299382153986e99'),
(1829, 0, 'template/page_44.html', '5fc11a0053782167f566fad44e07a1ed'),
(1830, 0, 'template/page_50.html', 'a1950e1e72086dce071e0fa0f014035d'),
(1831, 0, 'template/page_54.html', '2b9f919bc23ed514c6bcf657d8ee9e81'),
(1832, 0, 'template/page_56.html', '15a1131d4359a2c840a37d0bc3acee3e'),
(1833, 0, 'template/page_58.html', '3076c0147bcb71d03f39b0eb5e576f5f'),
(1834, 0, 'template/paginate.html', '19a7f5508e5203b4fbbbaaf1ea9d5b3c'),
(1835, 0, 'template/paginate_block.html', 'd557514b5ba9057f250c328f24f19722'),
(1836, 0, 'template/paginate_btn.html', '05b2a11e91ecdf32d98fc2d5496f2887'),
(1837, 0, 'template/popup_box.html', '01e0a7ee9a8c0ff16c19cefba122061b'),
(1838, 0, 'template/popup_chain.html', 'a6ae8ecc994d45c5dd609b249185edfb'),
(1839, 0, 'template/popup_content_indent.html', '6c013c4de92162ac4ac61a31c3ee0ed0'),
(1840, 0, 'template/popup_image.html', '1a933667fdad1758dd2ed24fbcb4656e'),
(1841, 0, 'template/popup_inline.html', 'a2af58b4e97f3191aa416adffdc9a1c2'),
(1842, 0, 'template/popup_loading.html', '254680aeb1b0d4f0b3199d16bf9add56'),
(1843, 0, 'template/popup_slide.html', '50a2a1eb4f6d75bdbae9ef08db43177b'),
(1844, 0, 'template/popup_trans.html', 'e3b32019611a22f4006565a45a21064e'),
(1845, 0, 'template/popup_trans_alert_cnt.html', '1a1295c1c3583dfd42276a7353395207'),
(1846, 0, 'template/popup_trans_confirm_cnt.html', '62e84c92adc533ab6b80825c4c43620c'),
(1847, 0, 'template/popup_trans_prompt_cnt.html', 'e115e0d10b9295cf26be7d83e74e3295'),
(1848, 0, 'template/privacy_group_custom.html', '251da693a32efff000674f8413903d71'),
(1849, 0, 'template/privacy_group_custom_select_popup.html', '4ff9fd6f461e2a97863c675446607850'),
(1850, 0, 'template/privacy_icon.html', '88b12530f63739fff9d83b1a299514b5'),
(1851, 0, 'template/privacy_memberships_value.html', '00801c564ab66b67e1a6c42375a532d9'),
(1852, 0, 'template/privacy_users_select_list.html', '5d36902b95dfc4d8ccb8e295f743ba44'),
(1853, 0, 'template/profile_avatar.html', '3977546bf49f9ae45338fe1c179aadfd'),
(1854, 0, 'template/profile_avatar_switcher.html', '44a4af0116e8709fd7ba1b96d4a09b4e'),
(1855, 0, 'template/profile_membership_stats.html', '4d49afc16c7ef1dbc827b2bd6d48099a'),
(1856, 0, 'template/profile_stats.html', '4ce2506e544b96932438e0e3b1be1add'),
(1857, 0, 'template/profile_switch_row.html', 'fb7b2f26599432b107854d172f72ca83'),
(1858, 0, 'template/profile_unit.html', 'e644188090e4245474b3d851ec279028'),
(1859, 0, 'template/profile_unit_wo_info.html', '2751f5a50255c2847a9458447b4e0373'),
(1860, 0, 'template/profile_unit_wo_info_links.html', 'a7a0a62488b648cbda8d474a585bdf78'),
(1861, 0, 'template/pt_application.html', '8d28955819aa2080a7cf0b15890142a9'),
(1862, 0, 'template/pt_standard.html', '4a179328aa7ba3fa1c224781c06d6052'),
(1863, 0, 'template/pt_wo_hf.html', '4227f518688c7e735d9eb46fbee3009a'),
(1864, 0, 'template/reCaptcha.html', '47f97d50a990160b3a2406a6372731f0'),
(1865, 0, 'template/recommendation_block.html', 'e338ea61714e45aa7828cd727e88b351'),
(1866, 0, 'template/redirect.html', 'abc9dda68bf570daceb7bce668df5041'),
(1867, 0, 'template/report_by_list.html', '164acef6b4a7f3f70c12b76206e867d0'),
(1868, 0, 'template/report_by_list_with_comments.html', 'dcf8d7655cfb381e83e1b6d0cc47b259'),
(1869, 0, 'template/report_do_report.html', '73c023a891cf5934e54c09e7cfddf679'),
(1870, 0, 'template/report_do_report_form.html', 'daeb1caf045bc494e871f43421087788'),
(1871, 0, 'template/report_do_report_label.html', 'bef181769e182a1167f6f106fd2f0a7e'),
(1872, 0, 'template/report_element_block.html', 'bdf1aabb0bedcae3cf2b2ffe26ce2bd3'),
(1873, 0, 'template/report_element_inline.html', '7c78606f5a85bd843557f6ccb612b5cf'),
(1874, 0, 'template/reviews_rating_block.html', 'c61daae293f463f865a36853a1c55a47'),
(1875, 0, 'template/review_content.html', '8e80e86540f9a3aa9041c415f6e23223'),
(1876, 0, 'template/review_mood_form_field.html', 'afccc7eefec472b5e99c21f8ad3ae0b0'),
(1877, 0, 'template/review_mood_legend.html', '42ea8b8218889d481a27714e10239492'),
(1878, 0, 'template/rss_holder.html', '423effe37cd5309f89e1cef701e97dca'),
(1879, 0, 'template/score_by_list.html', '4b507006b75f06cdb2f4c76f9b101fc8'),
(1880, 0, 'template/score_counter.html', '3ab8678909f9a7ceb09643e6647b6607'),
(1881, 0, 'template/score_counter_label.html', '355bd7d305ecbe4ee7431d254a25fb46'),
(1882, 0, 'template/score_counter_wrapper.html', '858c7bceadfa60447ccdd6f76af324c6'),
(1883, 0, 'template/score_do_vote_label.html', '718426de0c11a915623147945b074d5d'),
(1884, 0, 'template/score_element_block.html', 'cae25f186c113c055a6137e9292021ba'),
(1885, 0, 'template/score_element_inline.html', '7131bda79e639340404c61ad565046be'),
(1886, 0, 'template/score_legend.html', '7f5c90e03ba411f67718edbb5da43961'),
(1887, 0, 'template/scripts/BxBaseAccountForms.php', '6a660ad2ea24818cc2393744289b9349'),
(1888, 0, 'template/scripts/BxBaseAcl.php', '49ac5f8afe24583fc29ed54b65f3269a'),
(1889, 0, 'template/scripts/BxBaseAclServices.php', 'a54006f1685e207c5010e55be9964b9f'),
(1890, 0, 'template/scripts/BxBaseAuditGrid.php', 'e20022db7cdc309fe73d87d3693dddcc'),
(1891, 0, 'template/scripts/BxBaseAuditServices.php', 'dcf8d378dba9df26f6b2dfd3fb8bcd79'),
(1892, 0, 'template/scripts/BxBaseCalendar.php', '00b106c6331189838732baf1ef345c11'),
(1893, 0, 'template/scripts/BxBaseCaptchaHCaptcha.php', '62a7d39da22fd48ce6249c2b7afdb822'),
(1894, 0, 'template/scripts/BxBaseCaptchaReCAPTCHAInvisible.php', 'f0a0853170c360caae3147ddfd0ac637'),
(1895, 0, 'template/scripts/BxBaseCaptchaReCAPTCHANew.php', '6d57567438311fb0cb28242e65d55c70'),
(1896, 0, 'template/scripts/BxBaseCategory.php', '9012cdb48a9f75677695419e5fea9512'),
(1897, 0, 'template/scripts/BxBaseChartServices.php', 'c2b58ef63cde773b437c2763635fc08c'),
(1898, 0, 'template/scripts/BxBaseCmts.php', '558eee4f7c9d8df48b77e322d5642f6a'),
(1899, 0, 'template/scripts/BxBaseCmtsForm.php', '504ab430d10767cfe80f06dab10ecb76'),
(1900, 0, 'template/scripts/BxBaseCmtsGridAdministration.php', '094c83cb50f7de46d7708013e0e07901'),
(1901, 0, 'template/scripts/BxBaseCmtsMenuActions.php', '324f811fc6edec9ac234a943417c9e50'),
(1902, 0, 'template/scripts/BxBaseCmtsMenuManage.php', 'd254721884ab377795a2bc96793972ec'),
(1903, 0, 'template/scripts/BxBaseCmtsMenuUnitMeta.php', '63c515905e1581575350e43cc86a1b95'),
(1904, 0, 'template/scripts/BxBaseCmtsNotes.php', '55bd48aaea2c966588affc5c272f3256'),
(1905, 0, 'template/scripts/BxBaseCmtsPageView.php', '14c242b62a8e3a596d9c11557815c3ad'),
(1906, 0, 'template/scripts/BxBaseCmtsReviews.php', '20aa87198e071f47c6fc1514b1dc1144'),
(1907, 0, 'template/scripts/BxBaseCmtsReviewsForm.php', '604bf19abb46a1efebf88c54c0dab351'),
(1908, 0, 'template/scripts/BxBaseCmtsScore.php', 'ed3527a94f4564baeb3a53596176a2b9'),
(1909, 0, 'template/scripts/BxBaseCmtsServices.php', '8852f23fc595a0059a0382faea18c085'),
(1910, 0, 'template/scripts/BxBaseCmtsUploaderHTML5.php', 'ae4803ef821249219388f74bf812c9af'),
(1911, 0, 'template/scripts/BxBaseCmtsVoteLikes.php', 'f6842651fa2a77f22ef7fa727017086d'),
(1912, 0, 'template/scripts/BxBaseCmtsVoteReactions.php', '4f3cc8db36d1f34bb438db126f319462'),
(1913, 0, 'template/scripts/BxBaseConfig.php', '0fbb52b089dc84153773efce41a181f3'),
(1914, 0, 'template/scripts/BxBaseConnection.php', '0b48628dc3fcb61c18f6977150afce89'),
(1915, 0, 'template/scripts/BxBaseCover.php', 'f7a910a71e689465260e993f5f00d989'),
(1916, 0, 'template/scripts/BxBaseDashboardServices.php', 'bd7e98dc560853df33c2d08fe7371b6a'),
(1917, 0, 'template/scripts/BxBaseEditorQuill.php', '5599a11b0763297b14161f8ed2a78e98'),
(1918, 0, 'template/scripts/BxBaseEmbedEmbedly.php', 'af36f88ff62a845d0bc8a74660f02638'),
(1919, 0, 'template/scripts/BxBaseEmbedIframely.php', '5cbf5f3c0e933edc5dae22ed27b2952e'),
(1920, 0, 'template/scripts/BxBaseEmbedOembed.php', '893e70b43553ed234a775a843cbd4e26'),
(1921, 0, 'template/scripts/BxBaseEmbedSystem.php', 'd3096b438aaf73b053d66c0981de9915'),
(1922, 0, 'template/scripts/BxBaseFavorite.php', '48cc5bf2d4567e88f844f701f8179559'),
(1923, 0, 'template/scripts/BxBaseFavoriteServices.php', 'bd353c7ef049b7c3b4a9635d2264f5c7'),
(1924, 0, 'template/scripts/BxBaseFeature.php', '2d13736e45d200a215b908cb8ce7822c'),
(1925, 0, 'template/scripts/BxBaseFeatureServices.php', 'e9ecc0d20ce065a0219ab9ad239a1ea6'),
(1926, 0, 'template/scripts/BxBaseFileHandler.php', '5f2630d5c4b25db0994d279790bf5e33'),
(1927, 0, 'template/scripts/BxBaseFileHandlerCodeViewer.php', 'ecfb2850a6be810b9e9b4c5a99641f36'),
(1928, 0, 'template/scripts/BxBaseFileHandlerGoogleViewer.php', '6dfbe0b5e20ea0e7d6c32f16c72fdb04'),
(1929, 0, 'template/scripts/BxBaseFileHandlerImagesViewer.php', '947bc71410ebfe0e8941d26039331f74'),
(1930, 0, 'template/scripts/BxBaseFileHandlerMsViewer.php', '65191e9cc0d469184ca9e552b16eff94'),
(1931, 0, 'template/scripts/BxBaseFileHandlerSoundsViewer.php', '395abe3973836c83aab4f2a7fa41e9c3'),
(1932, 0, 'template/scripts/BxBaseFileHandlerVideosViewer.php', '9a516288ee4cb9f1fff6d2a873a560f0'),
(1933, 0, 'template/scripts/BxBaseFormAccount.php', 'a2f4a438e73254c01b3d1a0465d666cd'),
(1934, 0, 'template/scripts/BxBaseFormConfirmEmail.php', '0496835845c4b178036e09922f65f2db'),
(1935, 0, 'template/scripts/BxBaseFormConfirmPhone.php', '426d674f910db8a925a51216e7e7eb87'),
(1936, 0, 'template/scripts/BxBaseFormForgotPassword.php', '671dd5de157ed093021cde6f69b99c84'),
(1937, 0, 'template/scripts/BxBaseFormLogin.php', '87b8eb12dd291cb3b31ac9be4345ef88'),
(1938, 0, 'template/scripts/BxBaseFormProfile.php', 'c1df00be9515e444fb54b1b745d7b6c2'),
(1939, 0, 'template/scripts/BxBaseFormView.php', '04eb42bb153a1a5147d8e52a93e41d59'),
(1940, 0, 'template/scripts/BxBaseFormWiki.php', '543b3d1584871ead136a985d3368a8a0'),
(1941, 0, 'template/scripts/BxBaseFunctions.php', '9d8e8e2c89f5ca8efb68625a4d3fa964'),
(1942, 0, 'template/scripts/BxBaseGrid.php', 'fa77352d0eb99f45cfae372aade4ed05'),
(1943, 0, 'template/scripts/BxBaseImageServices.php', 'fb618ad5ceeb893f4eb99b5e368b61e6'),
(1944, 0, 'template/scripts/BxBaseInformer.php', '5bb4578c2d79d3e383af2237263d0591'),
(1945, 0, 'template/scripts/BxBaseLabel.php', 'c7ceab0d3df2fbca47aa02b81a81d730'),
(1946, 0, 'template/scripts/BxBaseLabelForm.php', '0d7dcbcb100eefe997275ef91c35a7e6'),
(1947, 0, 'template/scripts/BxBaseLabelsServices.php', '922a80fcd8c1e839ecccc7c63af1d290'),
(1948, 0, 'template/scripts/BxBaseLanguagesServices.php', 'add5dc762194175778c93d74e81b18da'),
(1949, 0, 'template/scripts/BxBaseLiveUpdates.php', '8052ae0de280e83c37233eb0a0048724'),
(1950, 0, 'template/scripts/BxBaseLiveUpdatesServices.php', '878439277b7bb4a5bf2d8194b7d8ac20'),
(1951, 0, 'template/scripts/BxBaseMenu.php', '07236641a815d50e73424c94ceec35fd'),
(1952, 0, 'template/scripts/BxBaseMenuAccountDashboard.php', '272abfbd02b15fd292c443c8f66c9366'),
(1953, 0, 'template/scripts/BxBaseMenuAccountNotifications.php', '71e0c6c74870df73aaf8fca24316e508'),
(1954, 0, 'template/scripts/BxBaseMenuAccountPopup.php', '690ea71d0663327b17223f6d4417636c'),
(1955, 0, 'template/scripts/BxBaseMenuAddRelation.php', 'b8c010bd53aee6d0af55745bdd7a1fbf'),
(1956, 0, 'template/scripts/BxBaseMenuCreatePost.php', '1a51bc4ac63d2c6430f537a1f94250cf'),
(1957, 0, 'template/scripts/BxBaseMenuCustom.php', '7a1f678c116323622e38d356a2a0cce7'),
(1958, 0, 'template/scripts/BxBaseMenuDashboardContentManage.php', '634d580351a2e14cdfab89e0ba499675'),
(1959, 0, 'template/scripts/BxBaseMenuDashboardManageTools.php', '7445e4521fc06677bdd056baf8e6d1c2'),
(1960, 0, 'template/scripts/BxBaseMenuDashboardReportsManage.php', 'b91da3c9f53c62340093f61a4d29f0b0'),
(1961, 0, 'template/scripts/BxBaseMenuFooter.php', 'cc51c047f0608c8d03a3a0ebf69f2679'),
(1962, 0, 'template/scripts/BxBaseMenuHomepage.php', 'faa3d42237760c8f15dd56b369ab9cb5'),
(1963, 0, 'template/scripts/BxBaseMenuInteractive.php', 'd063af11583c4de3449d9c591a21f867'),
(1964, 0, 'template/scripts/BxBaseMenuManage.php', '297bf3b42f53cbadc2c1f2ae3add9416'),
(1965, 0, 'template/scripts/BxBaseMenuMoreAuto.php', '176e33d16c1eeaf54b7a774f299f7e74'),
(1966, 0, 'template/scripts/BxBaseMenuPanel.php', '475b05f3bd308406be403a0382d33afb'),
(1967, 0, 'template/scripts/BxBaseMenuProfileAdd.php', '643eb573b86637a1ecf29151d512710d'),
(1968, 0, 'template/scripts/BxBaseMenuProfileFollowings.php', 'd69181ecfccdf05cb753cfeb49fed66e'),
(1969, 0, 'template/scripts/BxBaseMenuProfileStats.php', '5a8e98257943910b2ddae0ec00fb49ba'),
(1970, 0, 'template/scripts/BxBaseMenuSetAclLevel.php', '57e9a6bcb3a39d2147f81699bb4e18c5'),
(1971, 0, 'template/scripts/BxBaseMenuSetBadges.php', 'cff70b9f2f95844b4aff7d913febfdfe'),
(1972, 0, 'template/scripts/BxBaseMenuSite.php', '6b2d4e8e9f750050ab431e6777656eb5'),
(1973, 0, 'template/scripts/BxBaseMenuSocialSharing.php', 'a7d9a5e4b4b26e3cff6310b10d3528ca'),
(1974, 0, 'template/scripts/BxBaseMenuSubmenu.php', 'cfcb3ca001c6c9f52f2e02dbda708b3e'),
(1975, 0, 'template/scripts/BxBaseMenuSubmenuWithAddons.php', '61a49f092dc2d204a745163425396fbb'),
(1976, 0, 'template/scripts/BxBaseMenuSwitchLanguage.php', '6a0b25b6cdd5894d0923871f1b40a67f'),
(1977, 0, 'template/scripts/BxBaseMenuSwitchTemplate.php', '2690ac143508a91977f03f0e3b63f5fc'),
(1978, 0, 'template/scripts/BxBaseMenuTagsCloud.php', '99110ad81ba8861f42a6089c27c31395'),
(1979, 0, 'template/scripts/BxBaseMenuToolbar.php', '8532896b89eedd841cf3fe7f4256e05d'),
(1980, 0, 'template/scripts/BxBaseMenuUnitMeta.php', '556b102f12082a7e155cf31286395219'),
(1981, 0, 'template/scripts/BxBaseMenuWiki.php', '4f71b922163157fd65224bed30b53c6a'),
(1982, 0, 'template/scripts/BxBaseMetatags.php', '67b34b815cad4fd987d583c9918c2bcf'),
(1983, 0, 'template/scripts/BxBasePage.php', 'd1035021acb541cc565a75210811a4c7'),
(1984, 0, 'template/scripts/BxBasePageAccount.php', '1d605de8bb32945d3edc27cdbf4b8779'),
(1985, 0, 'template/scripts/BxBasePageConnections.php', 'e6697ed5bbed57e13b747afb89434ac9'),
(1986, 0, 'template/scripts/BxBasePageDashboard.php', '634c4ea7b9adf5847492bcb74de97a26'),
(1987, 0, 'template/scripts/BxBasePageHome.php', '93f8000d0ac64802ea6e10442e8f0eb8'),
(1988, 0, 'template/scripts/BxBasePagesSearchResult.php', '92ea5b10ddcd3a40b92f60595ed2f666'),
(1989, 0, 'template/scripts/BxBasePageWiki.php', 'd7e2c59141499d8c7b502d0e7d80c765'),
(1990, 0, 'template/scripts/BxBasePaginate.php', 'a9c21d0089291e8b8b6391ff570e7874'),
(1991, 0, 'template/scripts/BxBasePaymentsServices.php', 'e2c36166724cd62bcd1720f51aaf1fb4'),
(1992, 0, 'template/scripts/BxBasePlayerHTML5.php', '3870bd25135c7ba91bf284b5800eb43f'),
(1993, 0, 'template/scripts/BxBasePrivacy.php', '78fccf8a5f78eaf37786350a56285db0'),
(1994, 0, 'template/scripts/BxBasePrivacyFormGroupCustom.php', '081a8409bfb9cca5381ec134704c036e'),
(1995, 0, 'template/scripts/BxBaseProfileSearchResult.php', '226df67d4623e6b4307167124d1972fb'),
(1996, 0, 'template/scripts/BxBasePushOneSignal.php', '532b088fac378e810e0a9f77209964e4'),
(1997, 0, 'template/scripts/BxBaseRecommendation.php', '32a934ea06bc7feeabff5aa049acd4f0'),
(1998, 0, 'template/scripts/BxBaseRecommendationProfile.php', '4034b3d867ff674435083d05647a9bc8'),
(1999, 0, 'template/scripts/BxBaseReport.php', '6e8d7f594311bf9e49748502e8063455'),
(2000, 0, 'template/scripts/BxBaseReportServices.php', 'dd4cbd3bfb160cf883170bb3bbd48ce6'),
(2001, 0, 'template/scripts/BxBaseReportsGrid.php', '801081aa2a7226ffad49c6d4987d0bc5'),
(2002, 0, 'template/scripts/BxBaseRss.php', '7770728256525c113499cdfb9f7047db'),
(2003, 0, 'template/scripts/BxBaseScore.php', '92a9ddf9b58406b3597abcda621e4d97'),
(2004, 0, 'template/scripts/BxBaseScoreServices.php', '05838e8b0ebd2f65f22561becc73cdec'),
(2005, 0, 'template/scripts/BxBaseSearch.php', '3673dd98899aa380f1c6ada71a94b63c'),
(2006, 0, 'template/scripts/BxBaseSearchExtended.php', '0e5fb50f9d02bd4cfbdc2ed227a94311'),
(2007, 0, 'template/scripts/BxBaseSearchExtendedCmts.php', '5fcd213b364b3a780a8ccdf64fde0f2f'),
(2008, 0, 'template/scripts/BxBaseSearchExtendedForm.php', 'f005150709d7acfd7e394ee371d95321'),
(2009, 0, 'template/scripts/BxBaseSearchExtendedFormCmts.php', '45523e984ee9967fb3ded0e34fa5eb94'),
(2010, 0, 'template/scripts/BxBaseSearchExtendedServices.php', '2eca326bbb91fa8a0ffad0c54b776a92'),
(2011, 0, 'template/scripts/BxBaseSearchResult.php', 'b5ab2f4b29ddbeddf74275cbd334579a'),
(2012, 0, 'template/scripts/BxBaseServiceAccount.php', 'a55d6915c28ca5f2e864abf765a7c8f1'),
(2013, 0, 'template/scripts/BxBaseServiceCategory.php', 'b4417187b7bc7da559a6a59b2946e750'),
(2014, 0, 'template/scripts/BxBaseServiceConnections.php', 'bb8f32a223c755b7c18d019fd0b2d116'),
(2015, 0, 'template/scripts/BxBaseServiceContent.php', '954f30410d3d89e806b7f62b08cefdd6'),
(2016, 0, 'template/scripts/BxBaseServiceGrid.php', 'ccaaf08a97f2201b21d836f8d213ad4c'),
(2017, 0, 'template/scripts/BxBaseServiceLogin.php', 'ad5f8c4482066fe98c63e41fb65427de'),
(2018, 0, 'template/scripts/BxBaseServiceMetatags.php', '48d536e4ae26df3d22040db2d235775a'),
(2019, 0, 'template/scripts/BxBaseServicePages.php', '2d04746a89750a9b7c4f8a2b77c0691d'),
(2020, 0, 'template/scripts/BxBaseServiceProfiles.php', '58c9b4a8780d2df907b23a61edf0d298'),
(2021, 0, 'template/scripts/BxBaseServiceRecommendations.php', '1a6a936ccb1751188e4931b8f1a37cc2'),
(2022, 0, 'template/scripts/BxBaseServices.php', 'd12ce668eb76eb77d058d2d7e3d1b401'),
(2023, 0, 'template/scripts/BxBaseServiceWiki.php', 'a8a86d2651868025af0fa413518b705d'),
(2024, 0, 'template/scripts/BxBaseTemplateServices.php', '912b8fcb1581154d3303a84318fe1eee'),
(2025, 0, 'template/scripts/BxBaseUploaderCrop.php', 'ee1acef6f8fc0cb7863bab2a56ee6e6e'),
(2026, 0, 'template/scripts/BxBaseUploaderHTML5.php', '464823681115ea370a0f0443462f5bff'),
(2027, 0, 'template/scripts/BxBaseUploaderRecordVideo.php', '951f97f7f61741131d6e8073f42a4d57'),
(2028, 0, 'template/scripts/BxBaseUploaderServices.php', 'fafd9910bf3257d6d13fc503051a374c'),
(2029, 0, 'template/scripts/BxBaseUploaderSimple.php', '24cf8dbe1c884684f292e3930954726a'),
(2030, 0, 'template/scripts/BxBaseView.php', '4caea9abd162b5cd9e288659fe3b43dd'),
(2031, 0, 'template/scripts/BxBaseVote.php', 'e48a552f90e6f3510bbce13c843498cd'),
(2032, 0, 'template/scripts/BxBaseVoteLikes.php', '6001ad4059a57c1e02a8e15d45189f85'),
(2033, 0, 'template/scripts/BxBaseVoteReactions.php', '1a7328e38aa5b0366083cdd2e395a207'),
(2034, 0, 'template/scripts/BxBaseVoteReactionsMenuDo.php', 'b814ee12b3bd4f0356862635efccd1f0'),
(2035, 0, 'template/scripts/BxBaseVoteServices.php', 'befe3497a17ea10acd6cd97a604425bb'),
(2036, 0, 'template/scripts/BxBaseVoteStars.php', '152b2e2d2db94b974d86ff9d14eab3e2'),
(2037, 0, 'template/scripts_templ/BxTemplAccountForms.php', '6b34ecb6e3755b72c63a20d3cc7835ed'),
(2038, 0, 'template/scripts_templ/BxTemplAcl.php', '3649342976ffb254d76184bcf214fcd1'),
(2039, 0, 'template/scripts_templ/BxTemplAclServices.php', 'e4085b90f500ecab57b926c6cc0f2942'),
(2040, 0, 'template/scripts_templ/BxTemplAuditGrid.php', 'a9442500a1b372a21a422ecc130bba00'),
(2041, 0, 'template/scripts_templ/BxTemplAuditServices.php', '2ef2ef9a7dced851dccff7ccfbdafccb'),
(2042, 0, 'template/scripts_templ/BxTemplCalendar.php', '073b4c04664b227e322396de40bf2c23'),
(2043, 0, 'template/scripts_templ/BxTemplCaptchaHCaptcha.php', '16533266b3524218b038280fba23674a'),
(2044, 0, 'template/scripts_templ/BxTemplCaptchaReCAPTCHAInvisible.php', '1d1c8a5f862e1c2ca4864efe25563322'),
(2045, 0, 'template/scripts_templ/BxTemplCaptchaReCAPTCHANew.php', 'bb50cf74546e845bd109c949846531a1'),
(2046, 0, 'template/scripts_templ/BxTemplCategory.php', '8d0dedcf9e1e718dcef7a2d2c7fef68b'),
(2047, 0, 'template/scripts_templ/BxTemplChartServices.php', '65698eea4e776cd6077a8d11a2e2830d'),
(2048, 0, 'template/scripts_templ/BxTemplCmts.php', '7b3e85a0ccd5f9791ad1ee82e6b41c99'),
(2049, 0, 'template/scripts_templ/BxTemplCmtsForm.php', 'b72310e844051e5337bb6bd297760d2e'),
(2050, 0, 'template/scripts_templ/BxTemplCmtsGridAdministration.php', '590cd922a4b3ef1f8f60a2262072e38b'),
(2051, 0, 'template/scripts_templ/BxTemplCmtsMenuActions.php', '5e934cf1f8979e080472011a492108b9'),
(2052, 0, 'template/scripts_templ/BxTemplCmtsMenuManage.php', '6b6a40b820200648c3083a5f37912a35'),
(2053, 0, 'template/scripts_templ/BxTemplCmtsMenuUnitMeta.php', 'd2883815ddea6d35b4ae8477ce78cf2f'),
(2054, 0, 'template/scripts_templ/BxTemplCmtsNotes.php', '69627858c681e4e1e07f5f49eaa9712d'),
(2055, 0, 'template/scripts_templ/BxTemplCmtsPageView.php', '55f01fb440b88a1617ef59e79366b823'),
(2056, 0, 'template/scripts_templ/BxTemplCmtsReviews.php', 'c3f4c41cabde68d743aa1387c26239d1'),
(2057, 0, 'template/scripts_templ/BxTemplCmtsReviewsForm.php', '18d9bc1e8f9a9cf9f0738f5da1c4b5bb'),
(2058, 0, 'template/scripts_templ/BxTemplCmtsScore.php', '35cf65686767a008d4e44b61287a729d'),
(2059, 0, 'template/scripts_templ/BxTemplCmtsServices.php', '07d1e58873b453e5ea6a58c41660b642'),
(2060, 0, 'template/scripts_templ/BxTemplCmtsUploaderHTML5.php', 'd5f1066e9aa05af4ffdeafe77ff881f4'),
(2061, 0, 'template/scripts_templ/BxTemplCmtsVoteLikes.php', '58ecddded950f6b0453cfea6539639e4'),
(2062, 0, 'template/scripts_templ/BxTemplCmtsVoteReactions.php', 'cf76a73ca339e6340e1b18fe39ae94dd'),
(2063, 0, 'template/scripts_templ/BxTemplConfig.php', '646c2b7be6cf9bf8ecce00f708efaa9f'),
(2064, 0, 'template/scripts_templ/BxTemplConnection.php', '4d7bf2801e8c7fabdc7805f6f03ce44a'),
(2065, 0, 'template/scripts_templ/BxTemplCover.php', '561f1bb4179c1535e11601e8db820c05'),
(2066, 0, 'template/scripts_templ/BxTemplDashboardServices.php', 'ec1cf033d339461fbfbd3294eb5ace28'),
(2067, 0, 'template/scripts_templ/BxTemplEditorQuill.php', '68b01efb090ee1414684421ffcd9211c'),
(2068, 0, 'template/scripts_templ/BxTemplEmbedEmbedly.php', '3a15f63292e16cee6e41f30043f6fc61'),
(2069, 0, 'template/scripts_templ/BxTemplEmbedIframely.php', '53b2d7f8c592ef91fa305bf2bcb29b9e'),
(2070, 0, 'template/scripts_templ/BxTemplEmbedOembed.php', '9b651fa8db4965952906b65cde9c4a0a'),
(2071, 0, 'template/scripts_templ/BxTemplEmbedSystem.php', 'a7642a941e15f445f892fd1fbef07056'),
(2072, 0, 'template/scripts_templ/BxTemplFavorite.php', '66b8b43a0495e03367a42eb6d0cfe259'),
(2073, 0, 'template/scripts_templ/BxTemplFavoriteServices.php', 'f584f74b5a9117b67fc926f0481f3d80'),
(2074, 0, 'template/scripts_templ/BxTemplFeature.php', '1fe3cc00b6bd060750f5d9dc48980a55'),
(2075, 0, 'template/scripts_templ/BxTemplFeatureServices.php', '790d60d496998c446e489ed3f5222986'),
(2076, 0, 'template/scripts_templ/BxTemplFileHandlerCodeViewer.php', '0f128bb3821aed989ab10178e6d5ec45'),
(2077, 0, 'template/scripts_templ/BxTemplFileHandlerGoogleViewer.php', '34d19a2765cf5c0fa685dafa1e276d52'),
(2078, 0, 'template/scripts_templ/BxTemplFileHandlerImagesViewer.php', 'f0cbfd691b386bfb7622a17a582f3fde'),
(2079, 0, 'template/scripts_templ/BxTemplFileHandlerMsViewer.php', 'd70b875a9181b82d875480eb678b0aa9'),
(2080, 0, 'template/scripts_templ/BxTemplFileHandlerSoundsViewer.php', '5c0006d10cc5a5f75c34e415c35e48ed'),
(2081, 0, 'template/scripts_templ/BxTemplFileHandlerVideosViewer.php', '726e15edcbf2801721d1916443b3deb1'),
(2082, 0, 'template/scripts_templ/BxTemplFormAccount.php', '88d1640a1bd03f176192993533275275'),
(2083, 0, 'template/scripts_templ/BxTemplFormConfirmEmail.php', '6fff000e5baeac93cfa222396e9b7214'),
(2084, 0, 'template/scripts_templ/BxTemplFormConfirmPhone.php', 'fdf2a7c39b9a9b1cf868c49224a1b5a9'),
(2085, 0, 'template/scripts_templ/BxTemplFormForgotPassword.php', '33dcf8a6f3a04e03c2bc55ae21c5f04b'),
(2086, 0, 'template/scripts_templ/BxTemplFormLogin.php', 'd1a1f17c0e29a11b5fe34a10174445ee'),
(2087, 0, 'template/scripts_templ/BxTemplFormProfile.php', 'cb40a4070827147aed8362b3fa7ad62f'),
(2088, 0, 'template/scripts_templ/BxTemplFormView.php', '2af6d1ea5a6e62a69fa22ac66f5c3255'),
(2089, 0, 'template/scripts_templ/BxTemplFormWiki.php', '703b5cc1f6fa9536bb8400060e05797f'),
(2090, 0, 'template/scripts_templ/BxTemplFunctions.php', '05307518e96e11a071b74b09272a4a94'),
(2091, 0, 'template/scripts_templ/BxTemplGrid.php', '6b017c50e5a37842b1e1cc082f8c1838'),
(2092, 0, 'template/scripts_templ/BxTemplImageServices.php', '3bc5662e8d55034ce500b38d75730c0d'),
(2093, 0, 'template/scripts_templ/BxTemplInformer.php', '252db39b0756ab67f00c78cf7743cdfe'),
(2094, 0, 'template/scripts_templ/BxTemplLabel.php', '8e25f3f206e3e133d0cabb82f3a5c679'),
(2095, 0, 'template/scripts_templ/BxTemplLabelForm.php', '39162f9bf6cc4e9c47e40a4603dd5302'),
(2096, 0, 'template/scripts_templ/BxTemplLabelsServices.php', '9c126ac50cd143677f531a527256c968'),
(2097, 0, 'template/scripts_templ/BxTemplLanguagesServices.php', '3c2886108da13b8bd3798dc27a047542'),
(2098, 0, 'template/scripts_templ/BxTemplLiveUpdates.php', '46015d72d20c1194df43cff396ac559c'),
(2099, 0, 'template/scripts_templ/BxTemplLiveUpdatesServices.php', 'ae7d6d8eb37f01c5efa960974be096d5'),
(2100, 0, 'template/scripts_templ/BxTemplMenu.php', '338f1c6b420c281c88fc76400dc0fc17'),
(2101, 0, 'template/scripts_templ/BxTemplMenuAccountDashboard.php', '6f105eb8a1dc0c8fdd05a1881182d8ad'),
(2102, 0, 'template/scripts_templ/BxTemplMenuAccountNotifications.php', 'bf53c9e35ac8f60a63f88f2e677aaff0'),
(2103, 0, 'template/scripts_templ/BxTemplMenuAccountPopup.php', '9420bb5f869b1b02c01e1f8692ed4a9f'),
(2104, 0, 'template/scripts_templ/BxTemplMenuAddRelation.php', '2a2c8f59f5da72e6a3b10da3a8c21154'),
(2105, 0, 'template/scripts_templ/BxTemplMenuCreatePost.php', '015b3dc0b0afc6c0ce149013db5f0d1b'),
(2106, 0, 'template/scripts_templ/BxTemplMenuCustom.php', 'fc1c32f603d4ea64b8042756d592f020'),
(2107, 0, 'template/scripts_templ/BxTemplMenuDashboardContentManage.php', '60e8058c6e57dea5b50146f091533ca2'),
(2108, 0, 'template/scripts_templ/BxTemplMenuDashboardManageTools.php', '6a9a8fe7b0eaab043a7c5c696ca55819'),
(2109, 0, 'template/scripts_templ/BxTemplMenuDashboardReportsManage.php', '2ab38d4c7411c86c446b761e0770c69e'),
(2110, 0, 'template/scripts_templ/BxTemplMenuDropdownSite.php', 'a7c0985b2cfc0b559cfb7f5843c741f0'),
(2111, 0, 'template/scripts_templ/BxTemplMenuFooter.php', '3e739abd04a6ec33aa91957b1e0d7dc3'),
(2112, 0, 'template/scripts_templ/BxTemplMenuHomepage.php', 'f683e3c2b4d367a0dd2622acb681fd98'),
(2113, 0, 'template/scripts_templ/BxTemplMenuInteractive.php', 'f670816d02d9f7ed97adc143c5fb7a9e'),
(2114, 0, 'template/scripts_templ/BxTemplMenuManage.php', 'a45d120f121f91d28aa4fe67a6da04e1'),
(2115, 0, 'template/scripts_templ/BxTemplMenuMoreAuto.php', 'f6ecd95e60005b9b7dfa64c10543b40f'),
(2116, 0, 'template/scripts_templ/BxTemplMenuPanel.php', '0303778b6eb6cb2096e56d92e91c4fbf'),
(2117, 0, 'template/scripts_templ/BxTemplMenuProfileAdd.php', '4c36a3ea19821e64013c1733d2a41e91'),
(2118, 0, 'template/scripts_templ/BxTemplMenuProfileFollowings.php', '3d1e70275373d511ef61a30bac10e182'),
(2119, 0, 'template/scripts_templ/BxTemplMenuProfileStats.php', 'a02d3076a0c18391b99df0bf1f3b2a03'),
(2120, 0, 'template/scripts_templ/BxTemplMenuSetAclLevel.php', '07f115c6e1761550b6ace7a820eece8a'),
(2121, 0, 'template/scripts_templ/BxTemplMenuSetBadges.php', '3a02a58eff17b67b24498a5f1df56f76'),
(2122, 0, 'template/scripts_templ/BxTemplMenuSite.php', '02374671185be3d55ed486e2253823ea'),
(2123, 0, 'template/scripts_templ/BxTemplMenuSocialSharing.php', 'e33cc1569cf0309c02df40264c792783'),
(2124, 0, 'template/scripts_templ/BxTemplMenuSubmenu.php', '737e51604e9f882723a6d54145a4c482'),
(2125, 0, 'template/scripts_templ/BxTemplMenuSubmenuWithAddons.php', '3b0cc75df8adada0a6f613dce0185aab'),
(2126, 0, 'template/scripts_templ/BxTemplMenuSwitchLanguage.php', 'c8ff003074ed588f64fe4d374689952e'),
(2127, 0, 'template/scripts_templ/BxTemplMenuSwitchTemplate.php', '640317b22c7c5e30b6609e2866b5389b'),
(2128, 0, 'template/scripts_templ/BxTemplMenuToolbar.php', 'df2b9489fd156d36c8a8abe65952aeeb'),
(2129, 0, 'template/scripts_templ/BxTemplMenuUnitMeta.php', '08cf4a271d4caf72a3241adf9ed1803c'),
(2130, 0, 'template/scripts_templ/BxTemplMenuWiki.php', '1bb82f5582933594fc2daab40154fd4c'),
(2131, 0, 'template/scripts_templ/BxTemplMetatags.php', '210adf7ce9dcd30f201ad842ab19cfa6'),
(2132, 0, 'template/scripts_templ/BxTemplName.php', 'a5401c6f43d92793b224ada7218398b0'),
(2133, 0, 'template/scripts_templ/BxTemplPage.php', '07bc96391eef7128a1a69ac3f8b34707'),
(2134, 0, 'template/scripts_templ/BxTemplPageAccount.php', '73cae62fc0e6de0a5c23092a81f56a49'),
(2135, 0, 'template/scripts_templ/BxTemplPageConnections.php', 'acd574db514e97238de8766bd1c9b122'),
(2136, 0, 'template/scripts_templ/BxTemplPageDashboard.php', 'a8e9c59ab9bcdf27aab7e87a64abe3a8'),
(2137, 0, 'template/scripts_templ/BxTemplPageHome.php', '32e0b54002efda920f512d1912079611'),
(2138, 0, 'template/scripts_templ/BxTemplPagesSearchResult.php', '2f71397ec7f10558380a4f0e57253e2f'),
(2139, 0, 'template/scripts_templ/BxTemplPageWiki.php', '704781bbda411d9d4ec7a16b05b30e61'),
(2140, 0, 'template/scripts_templ/BxTemplPaginate.php', 'cd2b544e8442241abe58e8d74e2d1a59'),
(2141, 0, 'template/scripts_templ/BxTemplPaymentsServices.php', '6648ce8c2eb926fed0194ede46ebbf35'),
(2142, 0, 'template/scripts_templ/BxTemplPlayerHtml5.php', '24ea4e88dc83ee744fd1343365dc2ffb'),
(2143, 0, 'template/scripts_templ/BxTemplPrivacy.php', '87941eb8ea89974c8981fed610353553'),
(2144, 0, 'template/scripts_templ/BxTemplPrivacyFormGroupCustom.php', '7e8110b80c42a8aa96b1187fbb270a26'),
(2145, 0, 'template/scripts_templ/BxTemplProfileSearchResult.php', 'ff30cc9f17b841e4ee471aa08d32393f'),
(2146, 0, 'template/scripts_templ/BxTemplPushOneSignal.php', 'e674bc900647ba13b8be240fffda896b'),
(2147, 0, 'template/scripts_templ/BxTemplRecommendation.php', '7d0f853ac076dac80ce5f2ff2adb805e'),
(2148, 0, 'template/scripts_templ/BxTemplRecommendationProfile.php', '473fe5d21dd2fc2c3587284bc371f0f7'),
(2149, 0, 'template/scripts_templ/BxTemplReport.php', 'fa3bad3beaac7334c5a1d2654c061119'),
(2150, 0, 'template/scripts_templ/BxTemplReportServices.php', '613431db2de815f162f198c0e1f4f8b4'),
(2151, 0, 'template/scripts_templ/BxTemplReportsGrid.php', '33ba0d8fc964c642ca112d90b4ac9c46'),
(2152, 0, 'template/scripts_templ/BxTemplRss.php', 'e88a2875894f1d2f1707b76b667c055f'),
(2153, 0, 'template/scripts_templ/BxTemplScore.php', 'ad6d3e0e796f09eb14b14d4c1909e5fc'),
(2154, 0, 'template/scripts_templ/BxTemplScoreServices.php', 'f6d46c98ab48af5ca777989102e04ed3'),
(2155, 0, 'template/scripts_templ/BxTemplSearch.php', '0043a913b2afeae5ac41d8371e9116f8'),
(2156, 0, 'template/scripts_templ/BxTemplSearchExtended.php', 'a1867c4b7e83ebc39d97df6385b94979'),
(2157, 0, 'template/scripts_templ/BxTemplSearchExtendedCmts.php', '7e743573a0585f5d5e292f385f5655eb'),
(2158, 0, 'template/scripts_templ/BxTemplSearchExtendedForm.php', '339aa1b837332cdd2b31fc3f0dabeb0b'),
(2159, 0, 'template/scripts_templ/BxTemplSearchExtendedFormCmts.php', '07a2837ae0ed115909d20d3042110613'),
(2160, 0, 'template/scripts_templ/BxTemplSearchExtendedServices.php', 'e17ede34ac5862164b629bf98596b157'),
(2161, 0, 'template/scripts_templ/BxTemplSearchResult.php', '1fb18852d14731ecff28a737dd9aedf7'),
(2162, 0, 'template/scripts_templ/BxTemplServiceAccount.php', '4eea50ceb1ac606f3b0fa4b7305cf3cb'),
(2163, 0, 'template/scripts_templ/BxTemplServiceCategory.php', '896186caf5e797dd7c613dee85b1c874'),
(2164, 0, 'template/scripts_templ/BxTemplServiceConnections.php', '7ca2dfb5f885d4c660bc031939cbfe37'),
(2165, 0, 'template/scripts_templ/BxTemplServiceContent.php', 'b91767fc639a9fd9c0869d83fb667944'),
(2166, 0, 'template/scripts_templ/BxTemplServiceGrid.php', 'e766388f5654dc42419ecde7d8aace07'),
(2167, 0, 'template/scripts_templ/BxTemplServiceLogin.php', '47c295ee5076ab6d6fc73e9375f88569'),
(2168, 0, 'template/scripts_templ/BxTemplServiceMetatags.php', '1bb303d066b189bfd42dab5dc6ba62ab'),
(2169, 0, 'template/scripts_templ/BxTemplServicePages.php', 'f9543705eb6dba4316115ccf4f99608e'),
(2170, 0, 'template/scripts_templ/BxTemplServiceProfiles.php', '02af51fd59440e0b54f1f4e7c50d2918'),
(2171, 0, 'template/scripts_templ/BxTemplServiceRecommendations.php', '4c9be93219e972991ac64c806c9d392f'),
(2172, 0, 'template/scripts_templ/BxTemplServices.php', '77554d91dc18b2463fd5e77bbafa0560'),
(2173, 0, 'template/scripts_templ/BxTemplServiceWiki.php', '1dc2fb64d03c42fa28bb2c94975ae7e1'),
(2174, 0, 'template/scripts_templ/BxTemplTemplateServices.php', 'cf9f64ad507872ed6eac992222eec617'),
(2175, 0, 'template/scripts_templ/BxTemplUploaderCrop.php', '25f46c8be41cf1ec1b1ba32f79ef7e3f'),
(2176, 0, 'template/scripts_templ/BxTemplUploaderHTML5.php', '3296fd3f32c7f4c92d0131f1beae95c8'),
(2177, 0, 'template/scripts_templ/BxTemplUploaderRecordVideo.php', '38b2d8f11c6d508806bee46c4c8537ab'),
(2178, 0, 'template/scripts_templ/BxTemplUploaderServices.php', '9d68bc50ab1ef4f3782eb2b488dad878'),
(2179, 0, 'template/scripts_templ/BxTemplView.php', 'a87729c652479a392b8318dd9bcac97d'),
(2180, 0, 'template/scripts_templ/BxTemplVote.php', '10ae695742d99b4d4b7dd30c69ad7a60'),
(2181, 0, 'template/scripts_templ/BxTemplVoteLikes.php', '17cff03e357800e84b46ec9963faa47d'),
(2182, 0, 'template/scripts_templ/BxTemplVoteReactions.php', '0291f97fa49f473fb2f0037d323495e9'),
(2183, 0, 'template/scripts_templ/BxTemplVoteReactionsMenuDo.php', '328fc87fbe5c45b3aa2221c609fd2702'),
(2184, 0, 'template/scripts_templ/BxTemplVoteServices.php', '37c2ccc2f42420a5d703a87f696d5fdd'),
(2185, 0, 'template/scripts_templ/BxTemplVoteStars.php', '46eaa86b7f7434e20ce6feebe19c7a32'),
(2186, 0, 'template/search.html', 'b478cd5e776f4d90aab4c28c36612456'),
(2187, 0, 'template/search_extended_results.html', '82c2cc7d4918f1abf342ac06230b85a3'),
(2188, 0, 'template/search_pages_results.html', '0c3c2fcac78ca14a0ca1abf123cc063b'),
(2189, 0, 'template/search_pages_results_live.html', '53641b4bbc5febbe25ac192c75c5c53d'),
(2190, 0, 'template/search_result.html', '94cc7b6923df21216442fc306c2b9fb6'),
(2191, 0, 'template/search_result_block.html', '5c843f25f9c94b5c9d7a81976c411e85'),
(2192, 0, 'template/unit_meta_item.html', 'ee70a53b6f1bd0620e1382c7c160d81a'),
(2193, 0, 'template/unit_meta_item_ex.html', 'f6828b0b5fbf00d4b203e2af5b48d186'),
(2194, 0, 'template/uploader_button_crop.html', '4ebb6c6313a24846cd53f56cf89a9166'),
(2195, 0, 'template/uploader_button_crop_js.html', 'd285661b07971ef4d8bcca41776f3736'),
(2196, 0, 'template/uploader_button_html5.html', '74358228054dc59e4467bd1db4d9c49f'),
(2197, 0, 'template/uploader_button_html5_js.html', '18f2df9c8ee2cc96936dde2cc7f9be83'),
(2198, 0, 'template/uploader_button_record_video.html', '385ff32d767843c8a48453f0a0528cf0'),
(2199, 0, 'template/uploader_button_record_video_js.html', 'f9a8efb474f257dbe0299e74de03ade9'),
(2200, 0, 'template/uploader_form_crop.html', 'b671717ada951d20b72011640046932c'),
(2201, 0, 'template/view_by_list.html', '6b638d5b50feebc2c7dcfe6b82c77873'),
(2202, 0, 'template/uploader_form_html5.html', '0ff85ef216135d9dce06e2cc59e222c1'),
(2203, 0, 'template/uploader_form_record_video.html', '5a0890772195e55d4042e5965f577d3a'),
(2204, 0, 'template/uploader_nested_form_wrapper.html', '15924d7c25bf8022a7c355ab0067b506'),
(2205, 0, 'template/view_counter.html', '9a3adfed29bab442fa1ac355737c871b'),
(2206, 0, 'template/view_counter_label.html', 'adca3fd195495a7e1a1c6e9a9eb29ee0'),
(2207, 0, 'template/view_do_view_label.html', '718426de0c11a915623147945b074d5d'),
(2208, 0, 'template/view_element_block.html', 'ac1b958db0ff92c0c4aa99ec9d3c0928'),
(2209, 0, 'template/view_element_inline.html', '4c76e225e406f15c7d42e8a4bfede949'),
(2210, 0, 'template/vote_by_list.html', '00e59da7319a0f79305d327e0f6c0f1a'),
(2211, 0, 'template/vote_by_list_reactions.html', 'fe377f860b34ece2ed59012e3f27bb07'),
(2212, 0, 'template/vote_by_summary_reactions.html', '35b6f1b848311f7919ec7d1a7e672ddf'),
(2213, 0, 'template/vote_counter.html', '2a385ec80e828aca397615e993e14ea9'),
(2214, 0, 'template/vote_counter_label_likes.html', 'be8efbfd6fdb4826c2a804b6475a81d2'),
(2215, 0, 'template/vote_counter_label_reactions.html', 'fb35b7e7b80587b4699acd8b2d355282'),
(2216, 0, 'template/vote_counter_wrapper_reactions.html', '2244323ee509205268e90e4dcbabaf00'),
(2217, 0, 'template/vote_do_vote_label_likes.html', '718426de0c11a915623147945b074d5d'),
(2218, 0, 'template/vote_do_vote_label_reactions.html', '98eb172550a49ca7302e1b1c78ace51d'),
(2219, 0, 'template/vote_do_vote_stars.html', '7707175cd2557ac5c2a7df72938c993b'),
(2220, 0, 'template/vote_element_block.html', '298f8ed4682995ebe1553dba9ec9f3d6'),
(2221, 0, 'template/vote_element_inline.html', 'be96f81f142c477cedd1048c67699e3e'),
(2222, 0, 'template/vote_legend.html', '6cdfb1b99a7225b5bc4f28f8ad6f69bf'),
(2223, 0, 'template/wiki_add_block.html', '15079d01a6cccd98c5c430c9fd6a5bb8'),
(2224, 0, 'template/wiki_content.html', 'ed0931b41406997a367219101e9fc672'),
(2225, 0, 'template/wiki_contents.html', '1c7998b6eaf8e5ac0eb8ccd61df342b8'),
(2226, 0, 'template/wiki_controls.html', '058eb216cba21556632c43d012a9fd14'),
(2227, 0, 'template/wiki_create_page.html', '95ea6fd9d6984bceb53c3182b1a4bcdc'),
(2228, 0, 'template/wiki_create_page_form.html', '99a68cc9bc2ed0c6adb01a63743867c9'),
(2229, 0, 'template/wiki_delete_version.html', '3d8ba903e81208b7484b0b07f3497154'),
(2230, 0, 'template/wiki_form.html', '6682cb726dfe6fd7c382a24aeaab7fdd'),
(2231, 0, 'template/wiki_history.html', 'c0e8d298bb7820c3f7982f8d48e7b393'),
(2232, 0, 'template/wiki_msg.html', '818b41b89acef0da9a146f237b65e24c'),
(2233, 0, 'template/wiki_page_contents.html', '6d6c55b3775d69f5c4efe9f465cf0605'),
(2234, 0, 'template/wiki_translations_missing.html', '5d7ab3405ca1e341f54ca80432a4524e'),
(2235, 0, 'template/wiki_translations_outdated.html', 'b54036e5ff24e7b48448742f8f2d595b'),
(2236, 0, 'template/wiki_uploader_file.html', 'd4befbec3adf967a23208a0342f6a96c'),
(2237, 0, 'template/_footer.html', '86b7edd4bcf2b2250da773c0dae984ba'),
(2238, 0, 'template/_header.html', 'c353e7f6b0b9f16b6fe20219a2ca05ca'),
(2239, 0, 'template/_header_js.html', 'c2d438a6153ee5d83120762928c674de'),
(2240, 0, 'template/_header_js_custom.html', 'f3ba54707ef927bcc2a8447166153099'),
(2241, 0, 'template/_header_js_spinner.html', '7cd813b7dfbf2fd1bdb36087a1b43bc1'),
(2242, 0, 'template/_header_js_toolbar.html', '1f921a75cc2c50731085d630781c9533'),
(2243, 0, 'template/_header_meta.html', 'a183ce6e3187d49850523a574e173102'),
(2244, 0, 'template/_layout_align_columns.html', '20bd7e2510ddf6478710d1d5c1b0774b'),
(2245, 0, 'template/_page_content_beg.html', '043eb5193c40eef255b82d53fbeaa307'),
(2246, 0, 'template/_page_content_end.html', '2cbf9c8b399bd5401d025fb496738c51'),
(2247, 0, 'template/_page_cover.html', '3208ec3e10e415a9a9a74581eee8b11f'),
(2248, 0, 'template/_page_submenu.html', '2ea17e5767ce728757076c7eaf30d4c7'),
(2249, 0, 'template/_page_toolbar.html', 'bc3ae1bb72b425927a219824bbaf305f'),
(2250, 0, 'template/_page_toolbar_search.html', 'e2354fa67d65c7b50bcd5f905e383943'),
(2251, 0, 'template/_row_1_column.html', 'da22358af9251e85849ae522d10a3a00'),
(2252, 0, 'template/_row_1_column_dump.html', '238065f2993689155e2762e8dc7b72fa'),
(2253, 0, 'template/_row_1_column_half.html', '2bd7bf6ada7ed0a6476710d73f884158'),
(2254, 0, 'template/_row_1_column_thin.html', 'cd0cd6c1d013bc6c5399c47714825068'),
(2255, 0, 'template/_sub_footer.html', 'cc636a9f5ac0dcff136321841822aa8b'),
(2256, 0, 'template/_sub_header.html', 'ef80302551bb0a97f05eb42cba40c5fd'),
(2257, 0, 'cmts.php', '7003e08cc45aeb85d01a0385f4e2af4b'),
(2258, 0, 'conn.php', 'f5e9d715be53f3837abd374efc2b1edd'),
(2259, 0, 'get_rss_feed.php', '10bda15192a0c8a338b8aac20e006f58');
INSERT INTO `sys_modules_file_tracks` VALUES
(2260, 0, 'grid.php', '866b313a8f92a3841624802d7c57d3fd'),
(2261, 0, 'gzip_loader.php', '2073306d5e8f6c4d6dcbc59b0eceb7d4'),
(2262, 0, 'image_transcoder.php', '87a7dd623842d32b38d4023abaf775d6'),
(2263, 0, 'index.php', 'e36ace7602363b4388f392104ccee5cd'),
(2264, 0, 'logout.php', '9db911284f206d025d5d7a06f76f2d0a'),
(2265, 0, 'member.php', 'ba17336b793d5a38bd34539d5b7a0862'),
(2266, 0, 'menu.php', '85d2df5d441f2c1ca8d6e90912b5655e'),
(2267, 0, 'page.php', '7ba983cf74bf2bad08a25fc8d9c0217b'),
(2268, 0, 'searchKeyword.php', '11473c32c75a0b771ee9a727acfa63d3'),
(2269, 0, 'searchKeywordContent.php', '77f62599eaafdc6833d5d4505202648b'),
(2270, 0, 'splash.php', 'b8677f4c307f4f16553c0e6843b80f01'),
(2271, 0, 'storage.php', '0c69791a3eb45b1f905e62f5c85e8bd6'),
(2272, 0, 'storage_uploader.php', 'dc49d30961beb459ccfa6404d1762b86'),
(2273, 0, 'vote.php', '304708f43b1698228f2c4922aa4f467c'),
(2274, 0, 'modules/index.php', '579f4aa940eba43e33540cc5f305f791'),
(2275, 0, 'README.md', 'ac8c15ce4c2896da3b0acdbf66412788'),
(2276, 0, 'license.txt', 'f146f007a5f9e79eaf1179930d013bc8');

-- --------------------------------------------------------

--
-- Table structure for table `sys_modules_relations`
--

CREATE TABLE `sys_modules_relations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `on_install` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `on_uninstall` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `on_enable` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `on_disable` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_auths`
--

CREATE TABLE `sys_objects_auths` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Title` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Link` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `OnClick` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Icon` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Style` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_captcha`
--

CREATE TABLE `sys_objects_captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `sys_objects_captcha`
--

INSERT INTO `sys_objects_captcha` VALUES
(1, 'sys_recaptcha_new', 'reCAPTCHA', 'BxTemplCaptchaReCAPTCHANew', ''),
(2, 'sys_recaptcha_invisible', 'reCAPTCHA Invisible', 'BxTemplCaptchaReCAPTCHAInvisible', ''),
(3, 'sys_hcaptcha', 'hCaptcha', 'BxTemplCaptchaHCaptcha', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_category`
--

CREATE TABLE `sys_objects_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `search_object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `form_object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `list_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `join` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `where` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`),
  UNIQUE KEY `form_object` (`form_object`,`list_name`(127))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_chart`
--

CREATE TABLE `sys_objects_chart` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_date_ts` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_date_dt` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `column_date` int(11) NOT NULL DEFAULT '0',
  `column_count` int(11) NOT NULL DEFAULT '1',
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `query` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `order` int(11) NOT NULL,
  `class_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `class_file` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `sys_objects_chart`
--

INSERT INTO `sys_objects_chart` VALUES
(1, 'sys_accounts_growth', '_sys_chart_accounts_growth', 'sys_accounts', 'added', '', '', 0, 1, '', '', '', 1, 1, 'BxDolChartGrowth', ''),
(2, 'sys_accounts_growth_speed', '_sys_chart_accounts_growth_speed', 'sys_accounts', 'added', '', '', 0, 1, '', '', '', 1, 1, 'BxDolChartGrowthSpeed', ''),
(3, 'bx_persons_growth', '_bx_persons_chart_growth', 'bx_persons_data', 'added', '', '', 0, 1, '', '', 'SELECT {field_date_formatted} AS `period`, COUNT(*) AS {object} FROM {table} LEFT JOIN `sys_profiles` AS `tp` ON {table}.`id` = `tp`.`content_id` AND `tp`.`type`=''bx_persons'' WHERE 1 AND `tp`.`status`=''active'' {where_inteval} GROUP BY `period` ORDER BY {table}.{field_date} ASC', 1, 2, 'BxDolChartGrowth', ''),
(4, 'bx_persons_growth_speed', '_bx_persons_chart_growth_speed', 'bx_persons_data', 'added', '', '', 0, 1, '', '', 'SELECT {field_date_formatted} AS `period`, COUNT(*) AS {object} FROM {table} LEFT JOIN `sys_profiles` AS `tp` ON {table}.`id` = `tp`.`content_id` AND `tp`.`type`=''bx_persons'' WHERE 1 AND `tp`.`status`=''active'' {where_inteval} GROUP BY `period` ORDER BY {table}.{field_date} ASC', 1, 3, 'BxDolChartGrowthSpeed', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_cmts`
--

CREATE TABLE `sys_objects_cmts` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Table` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `CharsPostMin` int(10) NOT NULL,
  `CharsPostMax` int(10) NOT NULL,
  `CharsDisplayMax` int(10) NOT NULL,
  `Html` smallint(1) NOT NULL,
  `PerView` smallint(6) NOT NULL,
  `PerViewReplies` smallint(6) NOT NULL,
  `BrowseType` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `IsBrowseSwitch` smallint(1) NOT NULL,
  `PostFormPosition` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `NumberOfLevels` smallint(6) NOT NULL,
  `IsDisplaySwitch` smallint(1) NOT NULL,
  `IsRatable` smallint(1) NOT NULL,
  `ViewingThreshold` smallint(6) NOT NULL,
  `IsOn` smallint(1) NOT NULL,
  `RootStylePrefix` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'cmt',
  `BaseUrl` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ObjectVote` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ObjectReaction` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ObjectScore` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ObjectReport` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `TriggerTable` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `TriggerFieldId` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `TriggerFieldAuthor` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `TriggerFieldTitle` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `TriggerFieldComments` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ClassName` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ClassFile` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `sys_objects_cmts`
--

INSERT INTO `sys_objects_cmts` VALUES
(1, 'sys_agents_automators', 'system', 'sys_agents_automators_messages', 1, 5000, 1000, 0, 9999, 3, 'tail', 1, 'bottom', 1, 1, 1, -3, 1, 'cmt', 'agents.php?page=automators&id={object_id}', '', '', '', '', 'sys_agents_automators', 'id', '', '', 'messages', 'BxDolStudioAgentsAutomatorsCmts', ''),
(2, 'sys_agents_assistants_chats', 'system', 'sys_agents_assistants_chats_messages', 1, 5000, 1000, 0, 9999, 3, 'tail', 1, 'bottom', 1, 1, 1, -3, 1, 'cmt', 'agents.php?page=assistants&aid={assistant_id}', '', '', '', '', 'sys_agents_assistants_chats', 'id', '', '', 'messages', 'BxDolStudioAgentsAsstChatsCmts', ''),
(3, 'bx_persons', 'bx_persons', 'bx_persons_cmts', 1, 5000, 1000, 3, 5, 3, 'tail', 1, 'bottom', 1, 1, 1, -3, 1, 'cmt', 'page.php?i=view-persons-profile&id={object_id}', '', '', '', '', 'bx_persons_data', 'id', 'author', 'fullname', 'comments', 'BxPersonsCmts', 'modules/boonex/persons/classes/BxPersonsCmts.php'),
(4, 'bx_persons_notes', 'bx_persons', 'bx_persons_cmts_notes', 1, 5000, 1000, 0, 5, 3, 'tail', 1, 'bottom', 1, 1, 1, -3, 1, 'cmt', 'page.php?i=view-post&id={object_id}', '', '', '', '', 'bx_persons_data', 'id', 'author', 'fullname', '', 'BxTemplCmtsNotes', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_connection`
--

CREATE TABLE `sys_objects_connection` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_initiator` tinyint(4) NOT NULL DEFAULT '1',
  `profile_content` tinyint(4) NOT NULL DEFAULT '0',
  `type` enum('one-way','mutual') COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `sys_objects_connection`
--

INSERT INTO `sys_objects_connection` VALUES
(1, 'sys_profiles_friends', 'sys_profiles_conn_friends', 1, 1, 'mutual', '', ''),
(2, 'sys_profiles_subscriptions', 'sys_profiles_conn_subscriptions', 1, 1, 'one-way', '', ''),
(3, 'sys_profiles_relations', 'sys_profiles_conn_relations', 1, 1, 'mutual', 'BxDolRelation', ''),
(4, 'sys_profiles_bans', 'sys_profiles_conn_bans', 1, 1, 'one-way', 'BxDolBan', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_content_info`
--

CREATE TABLE `sys_objects_content_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alert_unit` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alert_action_add` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alert_action_update` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alert_action_delete` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `class_file` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `alert_add` (`alert_unit`,`alert_action_add`),
  UNIQUE KEY `alert_update` (`alert_unit`,`alert_action_update`),
  UNIQUE KEY `alert_delete` (`alert_unit`,`alert_action_delete`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `sys_objects_content_info`
--

INSERT INTO `sys_objects_content_info` VALUES
(1, 'bx_persons', '_bx_persons', 'bx_persons', 'added', 'edited', 'deleted', '', ''),
(2, 'bx_persons_cmts', '_bx_persons_cmts', 'bx_persons', 'commentPost', 'commentUpdated', 'commentRemoved', 'BxDolContentInfoCmts', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_editor`
--

CREATE TABLE `sys_objects_editor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `skin` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_objects_editor`
--

INSERT INTO `sys_objects_editor` VALUES
(1, 'sys_quill', 'Quill', 'snow', 'BxTemplEditorQuill', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_embeds`
--

CREATE TABLE `sys_objects_embeds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `sys_objects_embeds`
--

INSERT INTO `sys_objects_embeds` VALUES
(1, 'sys_system', 'System', 'BxTemplEmbedSystem', ''),
(2, 'sys_embedly', 'Embedly', 'BxTemplEmbedEmbedly', ''),
(3, 'sys_iframely', 'Iframely', 'BxTemplEmbedIframely', ''),
(4, 'sys_oembed', 'Oembed', 'BxTemplEmbedOembed', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_favorite`
--

CREATE TABLE `sys_objects_favorite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `table_track` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `table_lists` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pruning` int(11) NOT NULL DEFAULT '31536000',
  `is_on` tinyint(4) NOT NULL DEFAULT '1',
  `is_undo` tinyint(4) NOT NULL DEFAULT '1',
  `is_public` tinyint(4) NOT NULL DEFAULT '1',
  `base_url` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `trigger_table` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_field_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_field_author` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_field_count` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `class_file` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_objects_favorite`
--

INSERT INTO `sys_objects_favorite` VALUES
(1, 'bx_persons', 'bx_persons_favorites_track', '', 31536000, 1, 1, 0, 'page.php?i=view-persons-profile&id={object_id}', 'bx_persons_data', 'id', 'author', 'favorites', 'BxPersonsFavorite', 'modules/boonex/persons/classes/BxPersonsFavorite.php');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_feature`
--

CREATE TABLE `sys_objects_feature` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `is_on` tinyint(4) NOT NULL DEFAULT '1',
  `is_undo` tinyint(4) NOT NULL DEFAULT '1',
  `base_url` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `trigger_table` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_field_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_field_author` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_field_flag` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `class_file` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_objects_feature`
--

INSERT INTO `sys_objects_feature` VALUES
(1, 'bx_persons', 'bx_persons', 1, 1, 'page.php?i=view-persons-profile&id={object_id}', 'bx_persons_data', 'id', 'author', 'featured', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_file_handlers`
--

CREATE TABLE `sys_objects_file_handlers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `preg_ext` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(4) NOT NULL,
  `order` int(11) NOT NULL,
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `sys_objects_file_handlers`
--

INSERT INTO `sys_objects_file_handlers` VALUES
(1, 'sys_ms_viewer', '_sys_file_handlers_ms_viewer', '/\\.(doc|docx|xls|xlsx|ppt|pptx)$/i', 1, 1, 'BxTemplFileHandlerMsViewer', ''),
(2, 'sys_google_viewer', '_sys_file_handlers_google_viewer', '/\\.(pdf|doc|docx|xls|xlsx|ppt|pptx|ai|svg|ps|tif|tiff)$/i', 1, 2, 'BxTemplFileHandlerGoogleViewer', ''),
(3, 'sys_images_viewer', '_sys_file_handlers_images_viewer', '/\\.(jpg|jpeg|png|gif|webp)$/i', 1, 3, 'BxTemplFileHandlerImagesViewer', ''),
(4, 'sys_code_viewer', '_sys_file_handlers_code_viewer', '/\\.(1st|aspx|asp|json|js|jsp|java|php|xml|html|htm|rdf|xsd|xsl|xslt|sax|rss|cfm|js|asm|pl|prl|bas|b|vbs|fs|src|cs|ws|cgi|bat|py|c|cpp|cc|cp|h|hh|cxx|hxx|c++|m|lua|swift|sh|as|cob|tpl|lsp|x|cmd|rb|cbl|pas|pp|vb|f|perl|jl|lol|bal|pli|css|less|sass|saas|bcc|coffee|jade|j|tea|c#|sas|diff|pro|for|sh|bsh|bash|twig|csh|lisp|lsp|cobol|pl|d|git|rb|hrl|cr|inp|a|go|as3|m|sql|md|txt|csv)$/i', 1, 4, 'BxTemplFileHandlerCodeViewer', ''),
(5, 'sys_sounds_viewer', '_sys_file_handlers_sounds_viewer', '/\\.(mp3|m4a|m4b|wma|wav|3gp)$/i', 1, 5, 'BxTemplFileHandlerSoundsViewer', ''),
(6, 'sys_videos_viewer', '_sys_file_handlers_videos_viewer', '/\\.(avi|flv|mpg|mpeg|wmv|mp4|m4v|mov|qt|divx|xvid|3gp|3g2|webm|mkv|ogv|ogg|rm|rmvb|asf|drc|ts)$/i', 1, 5, 'BxTemplFileHandlerVideosViewer', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_form`
--

CREATE TABLE `sys_objects_form` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `form_attrs` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `submit_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uri` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uri_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `deletable` tinyint(4) NOT NULL DEFAULT '1',
  `active` tinyint(4) NOT NULL DEFAULT '0',
  `parent_form` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=20 ;

--
-- Dumping data for table `sys_objects_form`
--

INSERT INTO `sys_objects_form` VALUES
(1, 'sys_login', 'system', '_sys_form_login', 'member.php', 'a:3:{s:2:"id";s:14:"sys-form-login";s:6:"action";s:10:"member.php";s:8:"onsubmit";s:31:"return validateLoginForm(this);";}', 'a:3:{i:0;s:4:"role";i:1;s:10:"do_sendsms";i:2;s:12:"do_checkcode";}', '', '', '', '', 'a:1:{s:14:"checker_helper";s:24:"BxFormLoginCheckerHelper";}', 0, 1, '', 'BxTemplFormLogin', ''),
(2, 'sys_account', 'system', '_sys_form_account', '', '', 'a:2:{i:0;s:10:"do_publish";i:1;s:9:"do_submit";}', 'sys_accounts', 'id', '', '', 'a:1:{s:14:"checker_helper";s:26:"BxFormAccountCheckerHelper";}', 0, 1, '', 'BxTemplFormAccount', ''),
(3, 'sys_profile', 'system', '_sys_form_profile', '', '', 'do_submit', 'sys_profiles', 'id', '', '', '', 0, 1, '', 'BxTemplFormProfile', ''),
(4, 'sys_forgot_password', 'system', '_sys_form_forgot_password', '', '', 'do_submit', '', '', '', '', 'a:1:{s:14:"checker_helper";s:33:"BxFormForgotPasswordCheckerHelper";}', 0, 1, '', 'BxTemplFormForgotPassword', ''),
(5, 'sys_confirm_email', 'system', '_sys_form_confirm_email', '', '', 'do_submit', '', '', '', '', 'a:1:{s:14:"checker_helper";s:31:"BxFormConfirmEmailCheckerHelper";}', 0, 1, '', 'BxTemplFormConfirmEmail', ''),
(6, 'sys_confirm_phone', 'system', '_sys_form_confirm_phone', '', '', 'a:2:{i:0;s:9:"do_submit";i:1;s:10:"do_sendsms";}', '', '', '', '', 'a:1:{s:14:"checker_helper";s:31:"BxFormConfirmPhoneCheckerHelper";}', 0, 1, '', 'BxTemplFormConfirmPhone', ''),
(7, 'sys_unsubscribe', 'system', '_sys_form_unsubscribe', '', '', 'do_submit', 'sys_accounts', 'id', '', '', '', 0, 1, '', 'BxTemplFormAccount', ''),
(8, 'sys_comment', 'system', '_sys_form_comment', 'cmts.php', 'a:3:{s:2:"id";s:20:"cmt-%s-form-%s-%d-%d";s:4:"name";s:20:"cmt-%s-form-%s-%d-%d";s:5:"class";s:14:"cmt-post-reply";}', 'cmt_submit', '', 'cmt_id', '', '', '', 0, 1, '', 'BxTemplCmtsForm', ''),
(9, 'sys_agents_comment', 'system', '_sys_form_agents_comment', 'cmts.php', 'a:3:{s:2:"id";s:20:"cmt-%s-form-%s-%d-%d";s:4:"name";s:20:"cmt-%s-form-%s-%d-%d";s:5:"class";s:14:"cmt-post-reply";}', 'cmt_submit', '', 'cmt_id', '', '', '', 0, 1, '', 'BxTemplCmtsForm', ''),
(10, 'sys_review', 'system', '_sys_form_review', 'cmts.php', 'a:3:{s:2:"id";s:20:"cmt-%s-form-%s-%d-%d";s:4:"name";s:20:"cmt-%s-form-%s-%d-%d";s:5:"class";s:14:"cmt-post-reply";}', 'cmt_submit', '', 'cmt_id', '', '', '', 0, 1, '', 'BxTemplCmtsReviewsForm', ''),
(11, 'sys_report', 'system', '_sys_form_report', 'report.php', 'a:3:{s:2:"id";s:0:"";s:4:"name";s:0:"";s:5:"class";s:17:"bx-report-do-form";}', 'submit', '', 'id', '', '', '', 0, 1, '', '', ''),
(12, 'sys_favorite', 'system', '_sys_form_favorite', 'favorite.php', 'a:3:{s:2:"id";s:0:"";s:4:"name";s:0:"";s:5:"class";s:19:"bx-favorite-do-form";}', 'submit', '', 'id', '', '', '', 0, 1, '', '', ''),
(13, 'sys_privacy_group_custom', 'system', '_sys_form_ps_group_custom', 'privacy.php', '', 'do_submit', 'sys_privacy_groups_custom', 'id', '', '', '', 0, 1, '', 'BxTemplPrivacyFormGroupCustom', ''),
(14, 'sys_labels', 'system', '_sys_form_labels', 'label.php', '', 'do_submit', '', '', '', '', '', 0, 1, '', 'BxTemplLabelForm', ''),
(15, 'sys_wiki', 'system', '_sys_form_wiki', '', '', 'do_submit', 'sys_pages_wiki_blocks', 'id', '', '', '', 0, 1, '', 'BxTemplFormWiki', ''),
(16, 'sys_manage', 'system', '_sys_form_manage', '', '', 'a:2:{i:0;s:7:"do_send";i:1;s:9:"do_submit";}', '', '', '', '', '', 0, 1, '', '', ''),
(17, 'sys_acl', 'system', '_sys_form_acl', '', '', 'do_submit', '', '', '', '', '', 0, 1, '', '', ''),
(18, 'bx_person', 'bx_persons', '_bx_persons_form_profile', '', 'a:1:{s:7:"enctype";s:19:"multipart/form-data";}', 'do_submit', 'bx_persons_data', 'id', '', '', '', 0, 1, '', 'BxPersonsFormEntry', 'modules/boonex/persons/classes/BxPersonsFormEntry.php'),
(19, 'bx_person_skills', 'bx_persons', '_bx_persons_skills_form_profile', '', 'a:1:{s:7:"enctype";s:19:"multipart/form-data";}', 'do_submit', 'bx_persons_skills', 'skill_id', '', '', '', 0, 1, 'bx_person', 'BxDolFormNested', 'inc/classes/BxDolFormNested.php');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_grid`
--

CREATE TABLE `sys_objects_grid` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_type` enum('Array','Sql') COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_order` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_active` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_get_field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'order_field',
  `order_get_dir` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'order_dir',
  `paginate_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `paginate_per_page` int(11) NOT NULL DEFAULT '10',
  `paginate_simple` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paginate_get_start` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `paginate_get_per_page` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filter_fields` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `filter_fields_translatable` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `filter_mode` enum('like','fulltext','auto') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'auto',
  `filter_get` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'filter',
  `sorting_fields` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `sorting_fields_translatable` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `visible_for_levels` int(11) NOT NULL DEFAULT '2147483647',
  `responsive` tinyint(4) NOT NULL DEFAULT '1',
  `show_total_count` tinyint(4) NOT NULL DEFAULT '0',
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=45 ;

--
-- Dumping data for table `sys_objects_grid`
--

INSERT INTO `sys_objects_grid` VALUES
(1, 'sys_studio_lang_keys', 'Sql', 'SELECT `tlk`.`ID` AS `id`, `tlk`.`Key` AS `key`, `tlc`.`Name` AS `module`, `tls`.`String` AS `string` FROM `sys_localization_keys` AS `tlk` LEFT JOIN `sys_localization_categories` AS `tlc` ON `tlk`.`IDCategory`=`tlc`.`ID` LEFT JOIN `sys_localization_strings` AS `tls` ON `tlk`.`ID`=`tls`.`IDKey` WHERE `tls`.`IDLanguage`=''%d''', 'sys_localization_keys', 'id', '', '', 'order_field', 'order_dir', '', 20, NULL, 'start', '', 'key,string', '', 'like', 'filter', 'key,module,string', '', 2147483647, 1, 0, 'BxTemplStudioPolyglotKeys', ''),
(2, 'sys_studio_lang_etemplates', 'Sql', 'SELECT * FROM `sys_email_templates` WHERE 1 ', 'sys_email_templates', 'ID', '', '', 'order_field', 'order_dir', '', 20, NULL, 'start', '', 'Module', 'NameSystem,Subject,Body', 'auto', 'filter', 'Module', 'NameSystem', 2147483647, 1, 0, 'BxTemplStudioPolyglotEtemplates', ''),
(3, 'sys_studio_roles', 'Sql', 'SELECT * FROM `sys_std_roles` WHERE 1 ', 'sys_std_roles', 'id', 'order', 'active', 'order_field', 'order_dir', '', 100, NULL, 'start', '', 'name', 'title,description', 'auto', 'filter', '', '', 2147483647, 1, 0, 'BxTemplStudioRolesLevels', ''),
(4, 'sys_studio_roles_actions', 'Sql', 'SELECT *, ''0'' AS `active` FROM `sys_std_roles_actions` WHERE 1 ', 'sys_std_roles_actions', 'id', '', 'active', 'order_field', 'order_dir', '', 20, NULL, 'start', '', 'name', 'title,description', 'auto', 'filter', '', '', 2147483647, 1, 0, 'BxTemplStudioRolesActions', ''),
(5, 'sys_studio_acl', 'Sql', 'SELECT * FROM `sys_acl_levels` WHERE 1 ', 'sys_acl_levels', 'ID', 'Order', 'Active', 'order_field', 'order_dir', '', 100, NULL, 'start', '', 'Description', 'Name', 'auto', 'filter', '', '', 2147483647, 1, 0, 'BxTemplStudioPermissionsLevels', ''),
(6, 'sys_studio_acl_actions', 'Sql', 'SELECT *, ''0'' AS `Active` FROM `sys_acl_actions` WHERE 1 ', 'sys_acl_actions', 'ID', '', 'Active', 'order_field', 'order_dir', '', 20, NULL, 'start', '', 'Module,Name', 'Title,Desc', 'auto', 'filter', 'Module,Name', 'Title,Desc', 2147483647, 1, 0, 'BxTemplStudioPermissionsActions', ''),
(7, 'sys_studio_nav_menus', 'Sql', 'SELECT `tm`.*, `tms`.`title` AS `set_title`, `tmt`.`title` AS `template_title` FROM `sys_objects_menu` AS `tm` LEFT JOIN `sys_menu_sets` AS `tms` ON `tm`.`set_name`=`tms`.`set_name` LEFT JOIN `sys_menu_templates` AS `tmt` ON `tm`.`template_id`=`tmt`.`id` WHERE 1 ', 'sys_objects_menu', 'id', '', 'active', 'order_field', 'order_dir', '', 100, NULL, 'start', '', '', 'tm`.`title,tms`.`title,tmt`.`title', 'auto', 'filter', '', '', 2147483647, 1, 0, 'BxTemplStudioNavigationMenus', ''),
(8, 'sys_studio_nav_sets', 'Sql', 'SELECT * FROM `sys_menu_sets` WHERE 1 ', 'sys_menu_sets', 'set_name', '', '', 'order_field', 'order_dir', '', 100, NULL, 'start', '', '', 'title', 'auto', 'filter', '', '', 2147483647, 1, 0, 'BxTemplStudioNavigationSets', ''),
(9, 'sys_studio_nav_items', 'Sql', 'SELECT * FROM `sys_menu_items` WHERE 1 ', 'sys_menu_items', 'id', 'order', 'active', 'order_field', 'order_dir', '', 100, NULL, 'start_it', '', 'link', 'title_system', 'like', 'filter', '', '', 2147483647, 1, 0, 'BxTemplStudioNavigationItems', ''),
(10, 'sys_studio_nav_import', 'Sql', 'SELECT * FROM `sys_menu_items` WHERE 1 AND `copyable`=''1'' ', 'sys_menu_items', 'id', '', '', 'order_field', 'order_dir', '', 5, NULL, 'start_im', '', 'link', 'title_system', 'like', 'filter', '', '', 2147483647, 1, 0, 'BxTemplStudioNavigationImport', ''),
(11, 'sys_studio_forms', 'Sql', 'SELECT * FROM `sys_objects_form` WHERE 1 ', 'sys_objects_form', 'id', 'module,title', 'active', 'order_field', 'order_dir', '', 100, NULL, 'start', '', 'module', 'title', 'like', 'filter', 'module', 'title', 2147483647, 1, 0, 'BxTemplStudioFormsForms', ''),
(12, 'sys_studio_forms_displays', 'Sql', 'SELECT `td`.`id` AS `id`, `td`.`object` AS `object`, `td`.`display_name` AS `display_name`, `td`.`title` AS `display_title`, `td`.`module` AS `module`, `tf`.`title` AS `form_title` FROM `sys_form_displays` AS `td` LEFT JOIN `sys_objects_form` AS `tf` ON `td`.`object`=`tf`.`object` WHERE 1 ', 'sys_form_displays', 'id', 'module,object,display_title', '', 'order_field', 'order_dir', '', 100, NULL, 'start', '', 'td`.`module', 'td`.`title', 'like', 'filter', 'module', 'display_title,form_title', 2147483647, 1, 0, 'BxTemplStudioFormsDisplays', ''),
(13, 'sys_studio_forms_fields', 'Sql', 'SELECT `tdi`.`id` AS `id`, `ti`.`caption_system` AS `caption_system`, `ti`.`caption` AS `caption`, `ti`.`type` AS `type`, `ti`.`module` AS `module`, `tdi`.`visible_for_levels` AS `visible_for_levels`, `tdi`.`active` AS `active`, `ti`.`editable` AS `editable`, `ti`.`deletable` AS `deletable`, `tdi`.`order` AS `order` FROM `sys_form_display_inputs` AS `tdi` LEFT JOIN `sys_form_inputs` AS `ti` ON `tdi`.`input_name`=`ti`.`name` AND `ti`.`object`=? WHERE 1 AND `tdi`.`display_name`=?', 'sys_form_display_inputs', 'id', 'order', 'active', 'order_field', 'order_dir', '', 100, NULL, 'start', '', 'ti`.`type', 'ti`.`caption_system', 'like', 'filter', '', '', 2147483647, 1, 0, 'BxTemplStudioFormsFields', ''),
(14, 'sys_studio_forms_pre_lists', 'Sql', 'SELECT * FROM `sys_form_pre_lists` WHERE 1 ', 'sys_form_pre_lists', 'id', '', '', 'order_field', 'order_dir', '', 100, NULL, 'start', '', 'module,key', 'title', 'auto', 'filter', 'module', 'title', 2147483647, 1, 0, 'BxTemplStudioFormsPreLists', ''),
(15, 'sys_studio_forms_pre_values', 'Sql', 'SELECT * FROM `sys_form_pre_values` WHERE 1 ', 'sys_form_pre_values', 'id', 'Order', '', 'order_field', 'order_dir', '', 1000, NULL, 'start', '', 'Key,Value', 'LKey,LKey2', 'auto', 'filter', '', '', 2147483647, 1, 0, 'BxTemplStudioFormsPreValues', ''),
(16, 'sys_studio_search_forms', 'Sql', 'SELECT * FROM `sys_objects_search_extended` WHERE 1 ', 'sys_objects_search_extended', 'id', 'module,title', 'active', 'order_field', 'order_dir', '', 100, NULL, 'start', '', 'module', 'title', 'like', 'filter', 'module', 'title', 2147483647, 1, 0, 'BxTemplStudioFormsSearchForms', ''),
(17, 'sys_studio_search_forms_fields', 'Sql', 'SELECT * FROM `sys_search_extended_fields` WHERE 1 AND `object`=?', 'sys_search_extended_fields', 'id', 'order', 'active', 'order_field', 'order_dir', '', 100, NULL, 'start', '', 'type', 'caption', 'like', 'filter', '', '', 2147483647, 1, 0, 'BxTemplStudioFormsSearchFields', ''),
(18, 'sys_studio_search_forms_sortable_fields', 'Sql', 'SELECT * FROM `sys_search_extended_sorting_fields` WHERE 1 AND `object`=?', 'sys_search_extended_sorting_fields', 'id', 'order', 'active', 'order_field', 'order_dir', '', 100, NULL, 'start', '', 'type', 'caption', 'like', 'filter', '', '', 2147483647, 1, 0, 'BxTemplStudioFormsSearchSortableFields', ''),
(19, 'sys_studio_labels', 'Sql', 'SELECT * FROM `sys_labels` WHERE 1 ', 'sys_labels', 'id', 'order', '', 'order_field', 'order_dir', '', 1000, NULL, 'start', '', 'value', '', 'like', 'filter', 'value', '', 2147483647, 1, 0, 'BxTemplStudioFormsLabels', ''),
(20, 'sys_studio_categories', 'Sql', 'SELECT * FROM `sys_categories` WHERE 1 ', 'sys_categories', 'id', 'added', 'status', 'order_field', 'order_dir', '', 20, NULL, 'start', '', 'value', '', 'like', 'filter', '', '', 2147483647, 1, 0, 'BxTemplStudioFormsCategories', ''),
(21, 'sys_studio_groups_roles', 'Sql', 'SELECT * FROM `sys_form_pre_values` WHERE 1 ', 'sys_form_pre_values', 'id', 'Order', '', 'order_field', 'order_dir', '', 20, NULL, 'start', '', '', 'LKey', 'like', 'filter', '', '', 2147483647, 1, 0, 'BxTemplStudioFormsGroupsRoles', ''),
(22, 'sys_audit_administration', 'Sql', 'SELECT * FROM `sys_audit` WHERE 1 ', 'sys_audit', 'id', 'added', '', 'order_field', 'order_dir', '', 20, NULL, 'start', '', 'value', '', 'like', 'filter', 'content_module,profile_id,content_id,author_id,context_profile_id,added', 'action_lang_key', 2147483647, 1, 0, 'BxTemplAuditGrid', ''),
(23, 'sys_badges_administration', 'Sql', 'SELECT * FROM `sys_badges` WHERE 1 ', 'sys_badges', 'id', 'added', '', 'order_field', 'order_dir', '', 20, NULL, 'start', '', 'text', '', 'like', 'filter', '', '', 2147483647, 1, 0, 'BxTemplStudioBadgesGrid', ''),
(24, 'sys_reports_administration', 'Sql', 'WHERE 1 ', '', 'id', 'date', '', 'order_field', 'order_dir', '', 20, NULL, 'start', '', 'text,type', '', 'like', 'filter', '', '', 2147483647, 1, 0, 'BxTemplReportsGrid', ''),
(25, 'sys_cmts_administration', 'Sql', '', 'sys_cmts_ids', 'cmt_id', 'cmt_time', 'status_admin', 'order_field', 'order_dir', '', 20, NULL, 'start', '', 'cmt_text,email', '', 'like', 'filter', 'reports', '', 192, 1, 0, 'BxTemplCmtsGridAdministration', ''),
(26, 'sys_studio_strg_files', 'Sql', 'SELECT * FROM `sys_files` WHERE 1 ', 'sys_files', 'id', '', '', 'order_field', 'order_dir', '', 20, NULL, 'start', '', 'file_name,mime_type', '', 'auto', 'filter', 'file_name,added', '', 2147483647, 1, 0, 'BxTemplStudioStoragesFiles', ''),
(27, 'sys_studio_strg_images', 'Sql', 'SELECT * FROM `sys_images` WHERE 1 ', 'sys_images', 'id', '', '', 'order_field', 'order_dir', '', 20, NULL, 'start', '', 'file_name', '', 'auto', 'filter', 'file_name,added', '', 2147483647, 1, 0, 'BxTemplStudioStoragesImages', ''),
(28, 'sys_grid_connections', 'Sql', 'SELECT `p`.`id`, `c`.`added`, `c`.`mutual` FROM `sys_profiles` AS `p` INNER JOIN `sys_accounts` AS `a` ON (`a`.`id` = `p`.`account_id`) {join_connections}', 'sys_profiles', 'id', 'c`.`added', '', 'order_field', 'order_dir', '', 10, NULL, 'start', '', 'name,email', '', 'auto', 'filter', '', '', 2147483647, 0, 0, 'BxDolGridConnections', ''),
(29, 'sys_grid_connections_requests', 'Sql', 'SELECT `p`.`id`, `c`.`added`, `c`.`mutual` FROM `sys_profiles` AS `p` INNER JOIN `sys_accounts` AS `a` ON (`a`.`id` = `p`.`account_id`) {join_connections}', 'sys_profiles', 'id', 'c`.`added', '', 'order_field', 'order_dir', '', 10, NULL, 'start', '', 'name,email', '', 'auto', 'filter', '', '', 2147483647, 0, 0, 'BxDolGridConnectionsRequests', ''),
(30, 'sys_grid_subscriptions', 'Sql', 'SELECT `p`.`id`, `c`.`added` FROM `sys_profiles` AS `p` INNER JOIN `sys_accounts` AS `a` ON (`a`.`id` = `p`.`account_id`) {join_connections}', 'sys_profiles', 'id', 'c`.`added', '', 'order_field', 'order_dir', '', 10, NULL, 'start', '', 'name,email', '', 'auto', 'filter', '', '', 2147483647, 0, 0, 'BxDolGridSubscriptions', ''),
(31, 'sys_grid_subscribed_me', 'Sql', 'SELECT `p`.`id`, `c`.`added` FROM `sys_profiles` AS `p` INNER JOIN `sys_accounts` AS `a` ON (`a`.`id` = `p`.`account_id`) {join_connections}', 'sys_profiles', 'id', 'c`.`added', '', 'order_field', 'order_dir', '', 10, NULL, 'start', '', 'name,email', '', 'auto', 'filter', '', '', 2147483647, 0, 0, 'BxDolGridSubscribedMe', ''),
(32, 'sys_grid_relations', 'Sql', 'SELECT `p`.`id`, `c`.`relation`, `c`.`mutual`, `c`.`added` FROM `sys_profiles` AS `p` INNER JOIN `sys_accounts` AS `a` ON (`a`.`id` = `p`.`account_id`) {join_connections}', 'sys_profiles', 'id', 'c`.`added', '', 'order_field', 'order_dir', '', 10, NULL, 'start', '', 'name,email', '', 'auto', 'filter', '', '', 2147483647, 1, 0, 'BxDolGridRelations', ''),
(33, 'sys_grid_related_me', 'Sql', 'SELECT `p`.`id`, `c`.`relation`, `c`.`mutual`, `c`.`added` FROM `sys_profiles` AS `p` INNER JOIN `sys_accounts` AS `a` ON (`a`.`id` = `p`.`account_id`) {join_connections}', 'sys_profiles', 'id', 'c`.`added', '', 'order_field', 'order_dir', '', 10, NULL, 'start', '', 'name,email', '', 'auto', 'filter', '', '', 2147483647, 1, 0, 'BxDolGridRelatedMe', ''),
(34, 'sys_queues', 'Array', '', '', 'id', '', '', 'order_field', 'order_dir', '', 10, NULL, 'start', '', '', '', 'auto', 'filter', '', '', 128, 0, 0, 'BxDolGridQueues', ''),
(35, 'sys_studio_api_origins', 'Sql', 'SELECT * FROM `sys_api_origins` WHERE 1 ', 'sys_api_origins', 'id', 'order', '', 'order_field', 'order_dir', '', 20, NULL, 'start', '', 'url', '', 'like', 'filter', '', '', 2147483647, 1, 0, 'BxDolStudioApiOrigins', ''),
(36, 'sys_studio_api_keys', 'Sql', 'SELECT * FROM `sys_api_keys` WHERE 1 ', 'sys_api_keys', 'id', 'order', '', 'order_field', 'order_dir', '', 20, NULL, 'start', '', 'key,title', '', 'like', 'filter', '', '', 2147483647, 1, 0, 'BxDolStudioApiKeys', ''),
(37, 'sys_studio_agents_automators', 'Sql', 'SELECT * FROM `sys_agents_automators` WHERE 1 ', 'sys_agents_automators', 'id', 'added', 'active', 'order_field', 'order_dir', '', 20, NULL, 'start', '', '', '', 'like', 'filter', '', '', 2147483647, 1, 0, 'BxTemplStudioAgentsAutomators', ''),
(38, 'sys_studio_agents_helpers', 'Sql', 'SELECT * FROM `sys_agents_helpers` WHERE 1 ', 'sys_agents_helpers', 'id', 'added', 'active', 'order_field', 'order_dir', '', 20, NULL, 'start', '', '', '', 'like', 'filter', '', '', 2147483647, 1, 1, 'BxTemplStudioAgentsHelpers', ''),
(39, 'sys_studio_agents_assistants', 'Sql', 'SELECT * FROM `sys_agents_assistants` WHERE 1 ', 'sys_agents_assistants', 'id', 'added', 'active', 'order_field', 'order_dir', '', 20, NULL, 'start', '', '', '', 'like', 'filter', '', '', 2147483647, 1, 1, 'BxTemplStudioAgentsAssistants', ''),
(40, 'sys_studio_agents_assistants_chats', 'Sql', 'SELECT * FROM `sys_agents_assistants_chats` WHERE 1 ', 'sys_agents_assistants_chats', 'id', 'added', '', 'order_field', 'order_dir', '', 20, NULL, 'start', '', '', '', 'like', 'filter', '', '', 2147483647, 1, 1, 'BxTemplStudioAgentsAsstChats', ''),
(41, 'sys_studio_agents_assistants_files', 'Sql', 'SELECT * FROM `sys_agents_assistants_files` WHERE 1 ', 'sys_agents_assistants_files', 'id', 'added', '', 'order_field', 'order_dir', '', 20, NULL, 'start', '', '', '', 'like', 'filter', '', '', 2147483647, 1, 1, 'BxTemplStudioAgentsAsstFiles', ''),
(42, 'sys_studio_agents_providers', 'Sql', 'SELECT `tp`.*, `tpt`.`title` AS `provider_type` FROM `sys_agents_providers` AS `tp` LEFT JOIN `sys_agents_provider_types` AS `tpt` ON `tp`.`type_id`=`tpt`.`id` WHERE 1 ', 'sys_agents_providers', 'id', 'order', 'active', 'order_field', 'order_dir', '', 100, NULL, 'start', '', 'tp`.`title,tpt`.`name,tpt`.`title', '', 'like', 'filter', '', '', 2147483647, 1, 0, 'BxTemplStudioAgentsProviders', ''),
(43, 'bx_persons_administration', 'Sql', 'SELECT `td`.*, `ta`.`email` AS `account`, `ta`.`logged` AS `last_online`, `tp`.`status` AS `status`, `tp`.`id` as `profile_id` FROM `bx_persons_data` AS `td` LEFT JOIN `sys_profiles` AS `tp` ON `td`.`id`=`tp`.`content_id` AND `tp`.`type`=''bx_persons'' LEFT JOIN `sys_accounts` AS `ta` ON `tp`.`account_id`=`ta`.`id` WHERE 1 ', 'bx_persons_data', 'id', 'last_online', 'status', 'order_field', 'order_dir', '', 20, NULL, 'start', '', 'fullname,email', '', 'like', 'filter', 'reports', '', 192, 1, 0, 'BxPersonsGridAdministration', 'modules/boonex/persons/classes/BxPersonsGridAdministration.php'),
(44, 'bx_persons_common', 'Sql', 'SELECT `td`.*, `ta`.`email` AS `account`, `ta`.`logged` AS `last_online`, `tp`.`status` AS `status` FROM `bx_persons_data` AS `td` LEFT JOIN `sys_profiles` AS `tp` ON `td`.`id`=`tp`.`content_id` AND `tp`.`type`=''bx_persons'' LEFT JOIN `sys_accounts` AS `ta` ON `tp`.`account_id`=`ta`.`id` WHERE 1 ', 'bx_persons_data', 'id', 'last_online', 'status', 'order_field', 'order_dir', '', 20, NULL, 'start', '', 'fullname', '', 'like', 'filter', '', '', 2147483647, 1, 0, 'BxPersonsGridCommon', 'modules/boonex/persons/classes/BxPersonsGridCommon.php');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_live_updates`
--

CREATE TABLE `sys_objects_live_updates` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `init` tinyint(4) NOT NULL DEFAULT '0',
  `frequency` tinyint(4) NOT NULL DEFAULT '1',
  `service_call` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `sys_objects_live_updates`
--

INSERT INTO `sys_objects_live_updates` VALUES
(1, 'sys_payments_cart', 0, 1, 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:21:"get_live_updates_cart";s:6:"params";a:3:{i:0;a:2:{s:11:"menu_object";s:18:"sys_toolbar_member";s:9:"menu_item";s:7:"account";}i:1;a:2:{s:11:"menu_object";s:25:"sys_account_notifications";s:9:"menu_item";s:4:"cart";}i:2;s:7:"{count}";}s:5:"class";s:21:"TemplPaymentsServices";}', 1),
(2, 'sys_payments_orders', 0, 1, 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:23:"get_live_updates_orders";s:6:"params";a:3:{i:0;a:2:{s:11:"menu_object";s:18:"sys_toolbar_member";s:9:"menu_item";s:7:"account";}i:1;a:2:{s:11:"menu_object";s:25:"sys_account_notifications";s:9:"menu_item";s:6:"orders";}i:2;s:7:"{count}";}s:5:"class";s:21:"TemplPaymentsServices";}', 1),
(3, 'sys_payments_invoices', 0, 1, 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:25:"get_live_updates_invoices";s:6:"params";a:3:{i:0;a:2:{s:11:"menu_object";s:18:"sys_toolbar_member";s:9:"menu_item";s:7:"account";}i:1;a:2:{s:11:"menu_object";s:25:"sys_account_notifications";s:9:"menu_item";s:8:"invoices";}i:2;s:7:"{count}";}s:5:"class";s:21:"TemplPaymentsServices";}', 1),
(4, 'bx_persons_friend_requests', 0, 1, 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:40:"get_live_updates_unconfirmed_connections";s:6:"params";a:5:{i:0;s:10:"bx_persons";i:1;s:20:"sys_profiles_friends";i:2;a:2:{s:11:"menu_object";s:18:"sys_toolbar_member";s:9:"menu_item";s:7:"account";}i:3;a:2:{s:11:"menu_object";s:25:"sys_account_notifications";s:9:"menu_item";s:29:"notifications-friend-requests";}i:4;s:7:"{count}";}s:5:"class";s:23:"TemplServiceConnections";}', 1),
(5, 'bx_persons_friend_requests_new', 0, 1, 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:44:"get_live_updates_unconfirmed_connections_new";s:6:"params";a:5:{i:0;s:10:"bx_persons";i:1;s:20:"sys_profiles_friends";i:2;a:0:{}i:3;a:0:{}i:4;s:7:"{count}";}s:5:"class";s:23:"TemplServiceConnections";}', 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_location_field`
--

CREATE TABLE `sys_objects_location_field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `sys_objects_location_field`
--

INSERT INTO `sys_objects_location_field` VALUES
(1, 'sys_google', 'system', '_sys_location_field_google', 'BxDolLocationFieldGoogle', ''),
(2, 'sys_plain', 'system', '_sys_location_field_plain', 'BxDolLocationFieldNominatim', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_location_map`
--

CREATE TABLE `sys_objects_location_map` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `sys_objects_location_map`
--

INSERT INTO `sys_objects_location_map` VALUES
(1, 'sys_google_static', 'system', '_sys_location_map_google_static', 'BxDolLocationMapGoogleStatic', ''),
(2, 'sys_leaflet', 'system', '_sys_location_map_leaflet', 'BxDolLocationMapLeaflet', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_logs`
--

CREATE TABLE `sys_objects_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logs_storage` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `sys_objects_logs`
--

INSERT INTO `sys_objects_logs` VALUES
(1, 'sys_debug', 'system', 'Auto', '_sys_log_debug', 1, '', ''),
(2, 'sys_sms', 'system', 'Auto', '_sys_log_sms', 1, '', ''),
(3, 'sys_push', 'system', 'Auto', '_sys_log_push', 1, '', ''),
(4, 'sys_payments', 'system', 'Auto', '_sys_log_payments', 1, '', ''),
(5, 'sys_cron_jobs', 'system', 'Auto', '_sys_log_cron_jobs', 0, '', ''),
(6, 'sys_transcoder', 'system', 'Auto', '_sys_log_transcoder', 1, '', ''),
(7, 'sys_background_jobs', 'system', 'Auto', '_sys_log_background_jobs', 1, '', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_menu`
--

CREATE TABLE `sys_objects_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `set_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `template_id` int(11) NOT NULL,
  `config_api` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `persistent` tinyint(4) NOT NULL DEFAULT '0',
  `deletable` tinyint(4) NOT NULL DEFAULT '1',
  `active` tinyint(4) NOT NULL DEFAULT '0',
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=52 ;

--
-- Dumping data for table `sys_objects_menu`
--

INSERT INTO `sys_objects_menu` VALUES
(1, 'sys_site', '_sys_menu_title_main', 'sys_site', 'system', 28, '', 0, 0, 1, 'BxTemplMenuSite', ''),
(2, 'sys_site_in_panel', '_sys_menu_title_main_in_panel', 'sys_site', 'system', 31, '', 0, 0, 1, 'BxTemplMenuSite', ''),
(3, 'sys_application', '_sys_menu_title_application', 'sys_application', 'system', 28, '', 0, 0, 1, 'BxTemplMenuSite', ''),
(4, 'sys_homepage', '_sys_menu_title_homepage', 'sys_homepage', 'system', 7, '', 0, 0, 1, 'BxTemplMenuHomepage', ''),
(5, 'sys_homepage_submenu', '_sys_menu_title_homepage_submenu', 'sys_homepage_submenu', 'system', 8, '', 0, 0, 1, '', ''),
(6, 'sys_site_submenu', '_sys_menu_title_submenu', 'sys_site', 'system', 1, '', 0, 0, 1, 'BxTemplMenuSubmenu', ''),
(7, 'sys_site_manage', '_sys_menu_title_manage', '', 'system', 1, '', 0, 0, 1, 'BxTemplMenuManage', ''),
(8, 'sys_site_panel', '_sys_menu_title_panel', 'sys_site_panel', 'system', 30, '', 0, 0, 1, 'BxTemplMenuPanel', ''),
(9, 'sys_footer', '_sys_menu_title_footer', 'sys_footer', 'system', 2, '', 0, 0, 1, 'BxTemplMenuFooter', ''),
(10, 'sys_toolbar_site', '_sys_menu_title_toolbar_site', 'sys_toolbar_site', 'system', 5, '', 0, 0, 1, 'BxTemplMenuToolbar', ''),
(11, 'sys_toolbar_member', '_sys_menu_title_toolbar_member', 'sys_toolbar_member', 'system', 5, '', 0, 0, 1, 'BxTemplMenuToolbar', ''),
(12, 'sys_add_content', '_sys_menu_title_add_content', 'sys_add_content_links', 'system', 29, '', 0, 0, 1, 'BxTemplMenuSite', ''),
(13, 'sys_add_profile', '_sys_menu_title_add_profile', 'sys_add_profile_links', 'system', 14, '', 0, 0, 1, 'BxTemplMenuProfileAdd', ''),
(14, 'sys_add_profile_vertical', '_sys_menu_title_add_profile_vertical', 'sys_add_profile_links', 'system', 6, '', 0, 0, 1, 'BxTemplMenuProfileAdd', ''),
(15, 'sys_account_dashboard', '_sys_menu_title_account_dashboard', 'sys_account_dashboard', 'system', 8, '', 0, 0, 1, 'BxTemplMenuAccountDashboard', ''),
(16, 'sys_account_dashboard_manage_tools', '_sys_menu_title_account_dashboard_manage_tools', 'sys_account_dashboard_manage_tools', 'system', 24, '', 0, 0, 1, 'BxTemplMenuDashboardManageTools', ''),
(17, 'sys_account_settings_submenu', '_sys_menu_title_account_settings', 'sys_account_settings', 'system', 8, '', 0, 0, 1, '', ''),
(18, 'sys_profiles_create', '_sys_menu_title_profiles_create', 'sys_profiles_create', 'system', 4, '', 0, 0, 1, '', ''),
(19, 'sys_cmts_item_manage', '_sys_menu_title_cmts_item_manage', 'sys_cmts_item_manage', 'system', 20, '', 0, 0, 1, 'BxTemplCmtsMenuManage', ''),
(20, 'sys_cmts_item_actions', '_sys_menu_title_cmts_item_actions', 'sys_cmts_item_actions', 'system', 15, '', 0, 0, 1, 'BxTemplCmtsMenuActions', ''),
(21, 'sys_cmts_item_counters', '_sys_menu_title_cmts_item_counters', 'sys_cmts_item_counters', 'system', 15, '', 0, 0, 1, 'BxTemplCmtsMenuActions', ''),
(22, 'sys_cmts_item_meta', '_sys_menu_title_cmts_item_meta', 'sys_cmts_item_meta', 'system', 15, '', 0, 0, 1, 'BxTemplCmtsMenuUnitMeta', ''),
(23, 'sys_account_popup', '_sys_menu_title_account_popup', 'sys_account_popup', 'system', 12, '', 0, 0, 1, 'BxTemplMenuAccountPopup', ''),
(24, 'sys_account_notifications', '_sys_menu_title_account_notifications', 'sys_account_notifications', 'system', 19, '', 0, 0, 1, 'BxTemplMenuAccountNotifications', ''),
(25, 'sys_profile_stats', '_sys_menu_title_profile_stats', 'sys_profile_stats', 'system', 21, '', 0, 0, 1, 'BxTemplMenuProfileStats', ''),
(26, 'sys_tags_cloud', '_sys_menu_title_tags_cloud', '', 'system', 21, '', 0, 0, 1, 'BxBaseMenuTagsCloud', ''),
(27, 'sys_profile_followings', '_sys_menu_title_profile_followings', 'sys_profile_followings', 'system', 27, '', 0, 0, 1, 'BxTemplMenuProfileFollowings', ''),
(28, 'sys_switch_language_popup', '_sys_menu_title_switch_language_popup', 'sys_switch_language', 'system', 6, '', 0, 0, 1, 'BxTemplMenuSwitchLanguage', ''),
(29, 'sys_switch_language_inline', '_sys_menu_title_switch_language_inline', 'sys_switch_language', 'system', 3, '', 0, 0, 1, 'BxTemplMenuSwitchLanguage', ''),
(30, 'sys_switch_template', '_sys_menu_title_switch_template', 'sys_switch_template', 'system', 6, '', 0, 0, 1, 'BxTemplMenuSwitchTemplate', ''),
(31, 'sys_set_acl_level', '_sys_menu_title_set_acl_level', '', 'system', 6, '', 0, 0, 1, 'BxTemplMenuSetAclLevel', ''),
(32, 'sys_set_badges', '_sys_menu_title_set_badges', '', 'system', 6, '', 0, 0, 1, 'BxTemplMenuSetBadges', ''),
(33, 'sys_social_sharing', '_sys_menu_title_social_sharing', 'sys_social_sharing', 'system', 23, '', 0, 0, 1, 'BxTemplMenuSocialSharing', ''),
(34, 'sys_create_post', '_sys_menu_title_create_post', 'sys_add_content_links', 'system', 15, '', 0, 0, 1, 'BxTemplMenuCreatePost', ''),
(35, 'sys_dashboard_content', '_sys_menu_title_dashboard_content_manage', 'sys_dashboard_content_manage', 'system', 15, '', 0, 0, 1, 'BxTemplMenuDashboardContentManage', ''),
(36, 'sys_dashboard_reports', '_sys_menu_title_dashboard_reports_manage', 'sys_dashboard_reports_manage', 'system', 15, '', 0, 0, 1, 'BxTemplMenuDashboardReportsManage', ''),
(37, 'sys_add_relation', '_sys_menu_title_add_relation', '', 'system', 6, '', 0, 0, 1, 'BxTemplMenuAddRelation', ''),
(38, 'sys_vote_reactions_do', '_sys_menu_title_vote_reactions_do', '', 'system', 3, '', 0, 0, 1, 'BxTemplVoteReactionsMenuDo', ''),
(39, 'sys_wiki', '_sys_menu_title_wiki', 'sys_wiki', 'system', 6, '', 0, 0, 1, 'BxTemplMenuWiki', ''),
(40, 'sys_favorite_list', '_sys_menu_title_favorite_list', 'sys_favorite_list', 'system', 9, '', 0, 0, 1, '', ''),
(41, 'sys_con_submenu', '_sys_menu_title_con_submenu', 'sys_con_submenu', 'system', 8, '', 0, 0, 1, 'BxTemplMenuSubmenuWithAddons', ''),
(42, 'sys_studio_account_popup', '_sys_menu_title_studio_account_popup', 'sys_studio_account_popup', 'system', 4, '', 0, 0, 1, 'BxTemplStudioMenuAccountPopup', ''),
(43, 'bx_artificer_sidebar_site', '_bx_artificer_menu_title_sidebar_site', 'sys_site', 'bx_artificer', 1624, '', 0, 0, 1, 'BxTemplMenuSidebarSite', ''),
(44, 'bx_persons_view_actions', '_bx_persons_menu_title_view_profile_actions', 'bx_persons_view_actions', 'bx_persons', 9, '', 0, 0, 1, 'BxPersonsMenuViewActions', 'modules/boonex/persons/classes/BxPersonsMenuViewActions.php'),
(45, 'bx_persons_view_actions_more', '_bx_persons_menu_title_view_profile_actions_more', 'bx_persons_view_actions_more', 'bx_persons', 6, '', 0, 0, 1, 'BxPersonsMenuViewActions', 'modules/boonex/persons/classes/BxPersonsMenuViewActions.php'),
(46, 'bx_persons_view_actions_all', '_sys_menu_title_view_actions', 'bx_persons_view_actions_all', 'bx_persons', 15, '', 1, 0, 1, 'BxPersonsMenuViewActionsAll', 'modules/boonex/persons/classes/BxPersonsMenuViewActionsAll.php'),
(47, 'bx_persons_view_meta', '_bx_persons_menu_title_view_profile_meta', 'bx_persons_view_meta', 'bx_persons', 15, '', 0, 0, 1, 'BxPersonsMenuViewMeta', 'modules/boonex/persons/classes/BxPersonsMenuViewMeta.php'),
(48, 'bx_persons_submenu', '_bx_persons_menu_title_submenu', 'bx_persons_submenu', 'bx_persons', 8, '', 0, 0, 1, '', ''),
(49, 'bx_persons_view_submenu', '_bx_persons_menu_title_view_profile_submenu', 'bx_persons_view_submenu', 'bx_persons', 18, '', 0, 0, 1, 'BxPersonsMenuView', 'modules/boonex/persons/classes/BxPersonsMenuView.php'),
(50, 'bx_persons_snippet_meta', '_sys_menu_title_snippet_meta', 'bx_persons_snippet_meta', 'bx_persons', 15, '', 0, 0, 1, 'BxPersonsMenuSnippetMeta', 'modules/boonex/persons/classes/BxPersonsMenuSnippetMeta.php'),
(51, 'bx_persons_menu_manage_tools', '_bx_persons_menu_title_manage_tools', 'bx_persons_menu_manage_tools', 'bx_persons', 6, '', 0, 0, 1, 'BxPersonsMenuManageTools', 'modules/boonex/persons/classes/BxPersonsMenuManageTools.php');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_metatags`
--

CREATE TABLE `sys_objects_metatags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `table_keywords` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `table_locations` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `table_mentions` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `sys_objects_metatags`
--

INSERT INTO `sys_objects_metatags` VALUES
(1, 'sys_cmts', '', 'sys_cmts_meta_keywords', '', 'sys_cmts_meta_mentions', '', ''),
(2, 'bx_persons', 'bx_persons', 'bx_persons_meta_keywords', 'bx_persons_meta_locations', 'bx_persons_meta_mentions', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_page`
--

CREATE TABLE `sys_objects_page` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `author` int(11) NOT NULL DEFAULT '0',
  `added` int(11) NOT NULL DEFAULT '0',
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uri` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_system` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cover` tinyint(4) NOT NULL DEFAULT '1',
  `cover_image` int(11) NOT NULL DEFAULT '0',
  `cover_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_id` int(11) NOT NULL DEFAULT '1',
  `layout_id` int(11) NOT NULL,
  `sticky_columns` tinyint(4) NOT NULL DEFAULT '0',
  `submenu` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `visible_for_levels` int(11) NOT NULL DEFAULT '2147483647',
  `visible_for_levels_editable` tinyint(4) NOT NULL DEFAULT '1',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_info` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_keywords` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_robots` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cache_lifetime` int(11) NOT NULL DEFAULT '0',
  `cache_editable` tinyint(4) NOT NULL DEFAULT '1',
  `inj_head` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `inj_footer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `config_api` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `deletable` tinyint(1) NOT NULL,
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`),
  UNIQUE KEY `uri` (`uri`(191))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=61 ;

--
-- Dumping data for table `sys_objects_page`
--

INSERT INTO `sys_objects_page` VALUES
(1, 0, 0, 'sys_home', 'home', '_sys_page_title_system_home', '_sys_page_title_home', 'system', 2, 0, '', 1, 13, 1, 'sys_homepage_submenu', 2147483647, 1, 'page.php?i=home', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageHome', ''),
(2, 0, 0, 'sys_about', 'about', '_sys_page_title_system_about', '_sys_page_title_about', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=about', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(3, 0, 0, 'sys_terms', 'terms', '_sys_page_title_system_terms', '_sys_page_title_terms', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=terms', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(4, 0, 0, 'sys_privacy', 'privacy', '_sys_page_title_system_privacy', '_sys_page_title_privacy', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=privacy', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(5, 0, 0, 'sys_explore', 'explore', '_sys_page_title_sys_explore', '_sys_page_title_explore', 'system', 1, 0, '', 1, 5, 0, 'sys_homepage_submenu', 2147483647, 1, 'page.php?i=explore', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageHome', ''),
(6, 0, 0, 'sys_updates', 'updates', '_sys_page_title_sys_updates', '_sys_page_title_updates', 'system', 1, 0, '', 1, 5, 0, 'sys_homepage_submenu', 2147483647, 1, 'page.php?i=updates', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageHome', ''),
(7, 0, 0, 'sys_trends', 'trends', '_sys_page_title_sys_trends', '_sys_page_title_trends', 'system', 1, 0, '', 1, 5, 0, 'sys_homepage_submenu', 2147483647, 1, 'page.php?i=trends', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageHome', ''),
(8, 0, 0, 'sys_dashboard', 'dashboard', '_sys_page_title_system_dashboard', '_sys_page_title_dashboard', 'system', 1, 0, '', 1, 12, 0, '', 2147483646, 1, 'page.php?i=dashboard', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageDashboard', ''),
(9, 0, 0, 'sys_dashboard_content', 'dashboard-content', '_sys_page_title_system_dashboard_content', '_sys_page_title_dashboard_content', 'system', 1, 0, '', 1, 12, 0, '', 2147483646, 1, 'page.php?i=dashboard-content', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageDashboard', ''),
(10, 0, 0, 'sys_dashboard_reports', 'dashboard-reports', '_sys_page_title_system_dashboard_reports', '_sys_page_title_dashboard_reports', 'system', 1, 0, '', 1, 12, 0, '', 2147483646, 1, 'page.php?i=dashboard-reports', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageDashboard', ''),
(11, 0, 0, 'sys_dashboard_audit', 'dashboard-audit', '_sys_page_title_system_dashboard_audit', '_sys_page_title_dashboard_audit', 'system', 1, 0, '', 1, 12, 0, '', 2147483646, 1, 'page.php?i=dashboard-audit', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageDashboard', ''),
(12, 0, 0, 'sys_create_account', 'create-account', '_sys_page_title_system_create_account', '_sys_page_title_create_account', 'system', 1, 0, '', 1, 18, 0, '', 2147483647, 1, 'page.php?i=create-account', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(13, 0, 0, 'sys_login', 'login', '_sys_page_title_system_login', '_sys_page_title_login', 'system', 0, 0, '', 1, 18, 0, '', 2147483647, 1, 'page.php?i=login', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(14, 0, 0, 'sys_login_step2', 'login-step2', '_sys_page_title_system_login_step2', '_sys_page_title_login_step2', 'system', 1, 0, '', 1, 18, 0, '', 2147483647, 1, 'page.php?i=login-step2', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(15, 0, 0, 'sys_login_step3', 'login-step3', '_sys_page_title_system_login_step3', '_sys_page_title_login_step3', 'system', 1, 0, '', 1, 18, 0, '', 2147483647, 1, 'page.php?i=login-step3', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(16, 0, 0, 'sys_logout', 'logout', '', '_sys_page_title_logout', 'system', 0, 0, '', 1, 18, 0, '', 2147483647, 0, 'page.php?i=logout', '', '', '', '', '', 0, 0, '', '', '', 0, '', ''),
(17, 0, 0, 'sys_forgot_password', 'forgot-password', '_sys_page_title_system_forgot_password', '_sys_page_title_forgot_password', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=forgot-password', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(18, 0, 0, 'sys_confirm_email', 'confirm-email', '_sys_page_title_system_confirm_email', '_sys_page_title_confirm_email', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=confirm-email', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(19, 0, 0, 'sys_confirm_phone', 'confirm-phone', '_sys_page_title_system_confirm_phone', '_sys_page_title_confirm_phone', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=confirm-phone', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(20, 0, 0, 'sys_account_settings_email', 'account-settings-email', '_sys_page_title_system_account_settings_email', '_sys_page_title_account_settings_email', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'member.php', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageAccount', ''),
(21, 0, 0, 'sys_account_settings_pwd', 'account-settings-password', '_sys_page_title_system_account_settings_pwd', '_sys_page_title_account_settings_pwd', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=account-settings-pwd', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageAccount', ''),
(22, 0, 0, 'sys_account_settings_info', 'account-settings-info', '_sys_page_title_system_account_settings_info', '_sys_page_title_account_settings_info', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=account-settings-info', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageAccount', ''),
(23, 0, 0, 'sys_account_settings_delete', 'account-settings-delete', '_sys_page_title_system_account_settings_delete', '_sys_page_title_account_settings_delete', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=account-settings-delete', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageAccount', ''),
(24, 0, 0, 'sys_account_profile_switcher', 'account-profile-switcher', '_sys_page_title_system_account_profile_switcher', '_sys_page_title_account_profile_switcher', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=account-profile-switcher', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageAccount', ''),
(25, 0, 0, 'sys_profile_settings_cfilter', 'profile-settings-cfilter', '_sys_page_title_system_profile_settings_cfilter', '_sys_page_title_profile_settings_cfilter', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=profile-settings-cfilter', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(26, 0, 0, 'sys_unsubscribe_notifications', 'unsubscribe-notifications', '_sys_page_title_system_unsubscribe_notifications', '_sys_page_title_unsubscribe_notifications', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=unsubscribe-notifications', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(27, 0, 0, 'sys_unsubscribe_news', 'unsubscribe-news', '_sys_page_title_system_unsubscribe_news', '_sys_page_title_unsubscribe_news', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=unsubscribe-news', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(28, 0, 0, 'sys_std_dashboard', '', '_sys_page_title_system_studio_dashboard', '_sys_page_title_studio_dashboard', 'system', 1, 0, '', 1, 4, 0, '', 2147483647, 1, '', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(29, 0, 0, 'sys_cmts_view', 'cmts-view', '_sys_page_title_system_cmts_view', '_cmt_page_view_header', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=cmts-view', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplCmtsPageView', ''),
(30, 0, 0, 'sys_cmts_administration', 'cmts-administration', '_sys_page_title_system_cmts_administration', '_sys_page_title_cmts_administration', 'system', 1, 0, '', 1, 5, 0, '', 192, 1, 'page.php?i=cmts-administration', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(31, 0, 0, 'sys_audit', 'audit-administration', '_sys_page_title_system_audit_administration', '_sys_page_title_audit_administration', 'system', 1, 0, '', 1, 5, 0, '', 192, 1, 'page.php?i=audit-administration', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(32, 0, 0, 'sys_search_keyword', 'search-keyword', '_sys_page_title_system_search_keyword', '_sys_page_title_search_keyword', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'searchKeyword.php', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(33, 0, 0, 'sys_redirect', 'redirect', '', '_sys_page_title_redirect', 'system', 0, 0, '', 1, 18, 0, '', 2147483647, 1, 'page.php?i=redirect', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(34, 0, 0, 'sys_sub_wiki_pages_list', 'wiki-pages-list', '', '_sys_page_title_wiki_pages_list', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, '', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(35, 0, 0, 'sys_sub_wiki_page_contents', 'wiki-page-contents', '', '_sys_page_title_wiki_page_contents', 'system', 1, 0, '', 1, 5, 0, '', 2147483647, 1, '', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(36, 0, 0, 'sys_con_friends', 'friends', '_sys_page_title_system_con_friends', '_sys_page_title_con_friends', 'system', 1, 0, '', 1, 12, 0, '', 2147483646, 1, 'page.php?i=friends', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageConnections', ''),
(37, 0, 0, 'sys_con_friend_requests', 'friend-requests', '_sys_page_title_system_con_friend_requests', '_sys_page_title_con_friend_requests', 'system', 1, 0, '', 1, 12, 0, '', 2147483646, 1, 'page.php?i=friend-requests', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageConnections', ''),
(38, 0, 0, 'sys_con_friend_requested', 'sent-friend-requests', '_sys_page_title_system_con_friend_requested', '_sys_page_title_con_friend_requested', 'system', 1, 0, '', 1, 12, 0, '', 2147483646, 1, 'page.php?i=sent-friend-requests', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageConnections', ''),
(39, 0, 0, 'sys_con_following', 'following', '_sys_page_title_system_con_following', '_sys_page_title_con_following', 'system', 1, 0, '', 1, 12, 0, '', 2147483646, 1, 'page.php?i=following', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageConnections', ''),
(40, 0, 0, 'sys_con_followers', 'followers', '_sys_page_title_system_con_followers', '_sys_page_title_con_followers', 'system', 1, 0, '', 1, 12, 0, '', 2147483646, 1, 'page.php?i=followers', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageConnections', ''),
(41, 0, 0, 'sys_recom_friends', 'friend-suggestions', '_sys_page_title_system_recom_friends', '_sys_page_title_recom_friends', 'system', 1, 0, '', 1, 12, 0, '', 2147483646, 1, 'page.php?i=friend-suggestions', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageConnections', ''),
(42, 0, 0, 'sys_recom_subscriptions', 'follow-suggestions', '_sys_page_title_system_recom_subscriptions', '_sys_page_title_recom_subscriptions', 'system', 1, 0, '', 1, 12, 0, '', 2147483646, 1, 'page.php?i=follow-suggestions', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxTemplPageConnections', ''),
(43, 0, 0, 'bx_persons_create_profile', 'create-persons-profile', '_bx_persons_page_title_sys_create_profile', '_bx_persons_page_title_create_profile', 'bx_persons', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=create-persons-profile', '', '', '', '', '', 0, 1, '', '', '', 0, '', ''),
(44, 0, 0, 'bx_persons_view_profile', 'view-persons-profile', '_bx_persons_page_title_sys_view_profile', '_bx_persons_page_title_view_profile', 'bx_persons', 1, 0, '', 1, 7, 0, '', 2147483647, 1, 'page.php?i=view-persons-profile', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageEntry', 'modules/boonex/persons/classes/BxPersonsPageEntry.php'),
(45, 0, 0, 'bx_persons_view_profile_closed', 'view-person-profile-closed', '_bx_persons_page_title_sys_view_profile_closed', '_bx_persons_page_title_view_profile', 'bx_persons', 1, 0, '', 1, 10, 0, '', 2147483647, 1, 'page.php?i=view-person-profile', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageEntry', 'modules/boonex/persons/classes/BxPersonsPageEntry.php'),
(46, 0, 0, 'bx_persons_edit_profile', 'edit-persons-profile', '_bx_persons_page_title_sys_edit_profile', '_bx_persons_page_title_edit_profile', 'bx_persons', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=edit-persons-profile', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageEntry', 'modules/boonex/persons/classes/BxPersonsPageEntry.php'),
(47, 0, 0, 'bx_persons_delete_profile', 'delete-persons-profile', '_bx_persons_page_title_sys_delete_profile', '_bx_persons_page_title_delete_profile', 'bx_persons', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=delete-persons-profile', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageEntry', 'modules/boonex/persons/classes/BxPersonsPageEntry.php'),
(48, 0, 0, 'bx_persons_profile_info', 'persons-profile-info', '_bx_persons_page_title_sys_profile_info', '_bx_persons_page_title_profile_info', 'bx_persons', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=persons-profile-info', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageEntry', 'modules/boonex/persons/classes/BxPersonsPageEntry.php'),
(49, 0, 0, 'bx_persons_profile_friends', 'persons-profile-friends', '_bx_persons_page_title_sys_profile_friends', '_bx_persons_page_title_profile_friends', 'bx_persons', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=persons-profile-friends', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageEntry', 'modules/boonex/persons/classes/BxPersonsPageEntry.php'),
(50, 0, 0, 'bx_persons_friend_requests', 'persons-friend-requests', '_bx_persons_page_title_sys_friend_requests', '_bx_persons_page_title_friend_requests', 'bx_persons', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=persons-friend-requests', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageEntry', 'modules/boonex/persons/classes/BxPersonsPageEntry.php'),
(51, 0, 0, 'bx_persons_profile_favorites', 'persons-profile-favorites', '_bx_persons_page_title_sys_profile_favorites', '_bx_persons_page_title_profile_favorites', 'bx_persons', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=persons-profile-favorites', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageBrowse', 'modules/boonex/persons/classes/BxPersonsPageBrowse.php'),
(52, 0, 0, 'bx_persons_profile_subscriptions', 'persons-profile-subscriptions', '_bx_persons_page_title_sys_profile_subscriptions', '_bx_persons_page_title_profile_subscriptions', 'bx_persons', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=persons-profile-subscriptions', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageEntry', 'modules/boonex/persons/classes/BxPersonsPageEntry.php'),
(53, 0, 0, 'bx_persons_profile_relations', 'persons-profile-relations', '_bx_persons_page_title_sys_profile_relations', '_bx_persons_page_title_profile_relations', 'bx_persons', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=persons-profile-relations', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageEntry', 'modules/boonex/persons/classes/BxPersonsPageEntry.php'),
(54, 0, 0, 'bx_persons_profile_comments', 'persons-profile-comments', '_bx_persons_page_title_sys_profile_comments', '_bx_persons_page_title_profile_comments', 'bx_persons', 1, 0, '', 1, 5, 0, '', 2147483647, 1, '', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageEntry', 'modules/boonex/persons/classes/BxPersonsPageEntry.php'),
(55, 0, 0, 'bx_persons_home', 'persons-home', '_bx_persons_page_title_sys_recent', '_bx_persons_page_title_recent', 'bx_persons', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=persons-home', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageBrowse', 'modules/boonex/persons/classes/BxPersonsPageBrowse.php'),
(56, 0, 0, 'bx_persons_active', 'persons-active', '_bx_persons_page_title_sys_active', '_bx_persons_page_title_active', 'bx_persons', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=persons-active', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageBrowse', 'modules/boonex/persons/classes/BxPersonsPageBrowse.php'),
(57, 0, 0, 'bx_persons_online', 'persons-online', '_bx_persons_page_title_sys_online', '_bx_persons_page_title_online', 'bx_persons', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=persons-online', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageBrowse', 'modules/boonex/persons/classes/BxPersonsPageBrowse.php'),
(58, 0, 0, 'bx_persons_search', 'persons-search', '_bx_persons_page_title_sys_entries_search', '_bx_persons_page_title_entries_search', 'bx_persons', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=persons-search', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageBrowse', 'modules/boonex/persons/classes/BxPersonsPageBrowse.php'),
(59, 0, 0, 'bx_persons_manage', 'persons-manage', '_bx_persons_page_title_sys_manage', '_bx_persons_page_title_manage', 'bx_persons', 1, 0, '', 1, 5, 0, '', 2147483647, 1, 'page.php?i=persons-manage', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageBrowse', 'modules/boonex/persons/classes/BxPersonsPageBrowse.php'),
(60, 0, 0, 'bx_persons_administration', 'persons-administration', '_bx_persons_page_title_sys_manage_administration', '_bx_persons_page_title_manage', 'bx_persons', 1, 0, '', 1, 5, 0, '', 192, 1, 'page.php?i=persons-administration', '', '', '', '', '', 0, 1, '', '', '', 0, 'BxPersonsPageBrowse', 'modules/boonex/persons/classes/BxPersonsPageBrowse.php');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_payments`
--

CREATE TABLE `sys_objects_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uri` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`),
  UNIQUE KEY `uri` (`uri`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_player`
--

CREATE TABLE `sys_objects_player` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `skin` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_objects_player`
--

INSERT INTO `sys_objects_player` VALUES
(1, 'sys_html5', 'HTML5', '', 'BxTemplPlayerHtml5', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_privacy`
--

CREATE TABLE `sys_objects_privacy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `module` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `action` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_group` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `spaces` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'all',
  `table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table_field_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table_field_author` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`),
  UNIQUE KEY `action` (`module`,`action`(127))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `sys_objects_privacy`
--

INSERT INTO `sys_objects_privacy` VALUES
(1, 'sys_form_inputs_allow_view_to', 'system', 'view', '_sys_privacy_forms_input_allow_view_to', '3', 'all', 'sys_form_inputs_privacy', 'id', 'author_id', '', ''),
(2, 'bx_persons_allow_view_to', 'bx_persons', 'view', '_bx_persons_form_profile_input_allow_view_to', '3', '', 'bx_persons_data', 'id', 'author', 'BxPersonsPrivacy', 'modules/boonex/persons/classes/BxPersonsPrivacy.php'),
(3, 'bx_persons_allow_post_to', 'bx_persons', 'post', '_bx_persons_form_profile_input_allow_post_to', '5', '', 'bx_persons_data', 'id', 'author', 'BxPersonsPrivacyPost', 'modules/boonex/persons/classes/BxPersonsPrivacyPost.php'),
(4, 'bx_persons_allow_contact_to', 'bx_persons', 'contact', '_bx_persons_form_profile_input_allow_contact_to', '3', '', 'bx_persons_data', 'id', 'author', 'BxPersonsPrivacyContact', 'modules/boonex/persons/classes/BxPersonsPrivacyContact.php');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_push`
--

CREATE TABLE `sys_objects_push` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_objects_push`
--

INSERT INTO `sys_objects_push` VALUES
(1, 'sys_onesignal', 'OneSignal', 'BxTemplPushOneSignal', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_recommendation`
--

CREATE TABLE `sys_objects_recommendation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `module` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `connection` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_info` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `countable` tinyint(4) NOT NULL DEFAULT '1',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `class_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `class_file` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `sys_objects_recommendation`
--

INSERT INTO `sys_objects_recommendation` VALUES
(1, 'sys_friends', 'system', 'sys_profiles_friends', '', 1, 1, 'BxTemplRecommendationProfile', ''),
(2, 'sys_subscriptions', 'system', 'sys_profiles_subscriptions', '', 1, 1, 'BxTemplRecommendationProfile', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_report`
--

CREATE TABLE `sys_objects_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table_main` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `table_track` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pruning` int(11) NOT NULL DEFAULT '31536000',
  `is_on` tinyint(4) NOT NULL DEFAULT '1',
  `base_url` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `object_comment` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_table` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_field_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_field_author` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_field_count` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `class_file` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `sys_objects_report`
--

INSERT INTO `sys_objects_report` VALUES
(1, 'sys_cmts', 'system', 'sys_cmts_reports', 'sys_cmts_reports_track', 31536000, 1, '', '', 'sys_cmts_ids', 'id', 'author_id', 'reports', '', ''),
(2, 'bx_persons', 'bx_persons', 'bx_persons_reports', 'bx_persons_reports_track', 31536000, 1, 'page.php?i=view-persons-profile&id={object_id}', 'bx_persons_notes', 'bx_persons_data', 'id', 'author', 'reports', 'BxPersonsReport', 'modules/boonex/persons/classes/BxPersonsReport.php');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_rss`
--

CREATE TABLE `sys_objects_rss` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `class_file` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `sys_objects_rss`
--

INSERT INTO `sys_objects_rss` VALUES
(1, 'sys_boonex', 'BxDolRssBoonEx', ''),
(2, 'sys_page_block', 'BxDolRssPageBlock', ''),
(3, 'sys_studio_page_help', 'BxDolStudioRssPageHelp', ''),
(4, 'sys_studio_module_help', 'BxDolStudioRssModuleHelp', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_score`
--

CREATE TABLE `sys_objects_score` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `table_main` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table_track` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_timeout` int(11) NOT NULL DEFAULT '0',
  `pruning` int(11) NOT NULL DEFAULT '31536000',
  `is_undo` tinyint(1) NOT NULL DEFAULT '0',
  `is_on` tinyint(1) NOT NULL DEFAULT '1',
  `trigger_table` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `trigger_field_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `trigger_field_author` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `trigger_field_score` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `trigger_field_cup` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `trigger_field_cdown` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `class_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `class_file` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `sys_objects_score`
--

INSERT INTO `sys_objects_score` VALUES
(1, 'sys_cmts', 'system', 'sys_cmts_scores', 'sys_cmts_scores_track', 604800, 31536000, 0, 0, 'sys_cmts_ids', 'id', 'author_id', 'score', 'sc_up', 'sc_down', 'BxTemplCmtsScore', ''),
(2, 'bx_persons', 'bx_persons', 'bx_persons_scores', 'bx_persons_scores_track', 604800, 31536000, 0, 0, 'bx_persons_data', 'id', 'author', 'score', 'sc_up', 'sc_down', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_search`
--

CREATE TABLE `sys_objects_search` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ObjectName` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Order` int(11) NOT NULL,
  `GlobalSearch` tinyint(4) NOT NULL DEFAULT '1',
  `ClassName` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ClassPath` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `sys_objects_search`
--

INSERT INTO `sys_objects_search` VALUES
(1, 'sys_pages', '_sys_pages', 1, 1, 'BxTemplPagesSearchResult', ''),
(2, 'bx_persons', '_bx_persons', 2, 1, 'BxPersonsSearchResult', 'modules/boonex/persons/classes/BxPersonsSearchResult.php'),
(3, 'bx_persons_cmts', '_bx_persons_cmts', 3, 1, 'BxPersonsCmtsSearchResult', 'modules/boonex/persons/classes/BxPersonsCmtsSearchResult.php');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_search_extended`
--

CREATE TABLE `sys_objects_search_extended` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `object_content_info` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `filter` tinyint(4) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '0',
  `class_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `sys_objects_search_extended`
--

INSERT INTO `sys_objects_search_extended` VALUES
(1, 'bx_persons', 'bx_persons', 'bx_persons', '_bx_persons_search_extended', 0, 1, '', ''),
(2, 'bx_persons_cmts', 'bx_persons_cmts', 'bx_persons', '_bx_persons_search_extended_cmts', 0, 1, 'BxTemplSearchExtendedCmts', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_sms`
--

CREATE TABLE `sys_objects_sms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_objects_sms`
--

INSERT INTO `sys_objects_sms` VALUES
(1, 'sys_twilio', 'Twilio', 'BxDolSmsTwilio', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_storage`
--

CREATE TABLE `sys_objects_storage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `engine` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `token_life` int(11) NOT NULL,
  `cache_control` int(11) NOT NULL,
  `levels` tinyint(4) NOT NULL,
  `table_files` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext_mode` enum('allow-deny','deny-allow') COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext_allow` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext_deny` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `quota_size` int(11) NOT NULL,
  `current_size` int(11) NOT NULL,
  `quota_number` int(11) NOT NULL,
  `current_number` int(11) NOT NULL,
  `max_file_size` int(11) NOT NULL,
  `ts` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=14 ;

--
-- Dumping data for table `sys_objects_storage`
--

INSERT INTO `sys_objects_storage` VALUES
(1, 'sys_images', 'Local', '', 360, 2592000, 0, 'sys_images', 'allow-deny', '{image},svg', '', 0, 0, 0, 0, 0, 0),
(2, 'sys_images_custom', 'Local', '', 360, 2592000, 0, 'sys_images_custom', 'allow-deny', '{image},svg', '', 0, 0, 0, 0, 0, 0),
(3, 'sys_images_resized', 'Local', '', 360, 2592000, 0, 'sys_images_resized', 'allow-deny', '{image},svg', '', 0, 0, 0, 0, 0, 0),
(4, 'sys_cmts_images', 'Local', '', 360, 2592000, 3, 'sys_cmts_images', 'allow-deny', '{image}', '', 0, 0, 0, 0, 0, 0),
(5, 'sys_cmts_images_preview', 'Local', '', 360, 2592000, 3, 'sys_cmts_images_preview', 'allow-deny', '{image}', '', 0, 0, 0, 0, 0, 0),
(6, 'sys_transcoder_queue_files', 'Local', '', 3600, 2592000, 0, 'sys_transcoder_queue_files', 'allow-deny', 'avi,flv,mpg,mpeg,wmv,mp4,m4v,mov,divx,xvid,3gp,webm,jpg', '', 0, 0, 0, 0, 0, 0),
(7, 'sys_files', 'Local', '', 360, 2592000, 3, 'sys_files', 'deny-allow', '', '{dangerous}', 0, 0, 0, 0, 0, 0),
(8, 'sys_images_editor', 'Local', '', 360, 2592000, 3, 'sys_images_editor', 'allow-deny', '{image}', '', 0, 0, 0, 0, 0, 0),
(9, 'sys_images_editor_resized', 'Local', '', 360, 2592000, 3, 'sys_images_editor_resized', 'allow-deny', '{image}', '', 0, 0, 0, 0, 0, 0),
(10, 'sys_wiki_files', 'Local', '', 360, 2592000, 3, 'sys_wiki_files', 'allow-deny', '{image}', '', 0, 0, 0, 0, 0, 0),
(11, 'sys_wiki_images_resized', 'Local', '', 360, 2592000, 3, 'sys_wiki_images_resized', 'allow-deny', '{image}', '', 0, 0, 0, 0, 0, 0),
(12, 'bx_persons_pictures', 'Local', '', 360, 2592000, 3, 'bx_persons_pictures', 'allow-deny', '{image}', '', 0, 0, 0, 0, 0, 0),
(13, 'bx_persons_pictures_resized', 'Local', '', 360, 2592000, 3, 'bx_persons_pictures_resized', 'allow-deny', '{image}', '', 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_transcoder`
--

CREATE TABLE `sys_objects_transcoder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `storage_object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_type` enum('Folder','Storage','Proxy') COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `private` enum('auto','yes','no') COLLATE utf8mb4_unicode_ci NOT NULL,
  `atime_tracking` int(11) NOT NULL,
  `atime_pruning` int(11) NOT NULL,
  `ts` int(11) NOT NULL DEFAULT '0',
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=24 ;

--
-- Dumping data for table `sys_objects_transcoder`
--

INSERT INTO `sys_objects_transcoder` VALUES
(1, 'sys_image_resize', 'sys_images_resized', 'Storage', 'a:2:{s:6:"object";s:10:"sys_images";s:14:"disable_retina";b:1;}', 'no', 0, 0, 0, '', ''),
(2, 'sys_icon_apple', 'sys_images_resized', 'Storage', 'a:2:{s:6:"object";s:10:"sys_images";s:14:"disable_retina";b:1;}', 'no', 0, 0, 0, '', ''),
(3, 'sys_icon_android', 'sys_images_resized', 'Storage', 'a:2:{s:6:"object";s:10:"sys_images";s:14:"disable_retina";b:1;}', 'no', 0, 0, 0, '', ''),
(4, 'sys_icon_android_splash', 'sys_images_resized', 'Storage', 'a:2:{s:6:"object";s:10:"sys_images";s:14:"disable_retina";b:1;}', 'no', 0, 0, 0, '', ''),
(5, 'sys_icon_facebook', 'sys_images_resized', 'Storage', 'a:2:{s:6:"object";s:10:"sys_images";s:14:"disable_retina";b:1;}', 'no', 0, 0, 0, '', ''),
(6, 'sys_icon_favicon', 'sys_images_resized', 'Storage', 'a:1:{s:6:"object";s:10:"sys_images";}', 'no', 0, 0, 0, '', ''),
(7, 'sys_cover', 'sys_images_resized', 'Storage', 'a:1:{s:6:"object";s:10:"sys_images";}', 'no', 0, 0, 0, '', ''),
(8, 'sys_cover_unit_profile', 'sys_images_resized', 'Storage', 'a:1:{s:6:"object";s:10:"sys_images";}', 'no', 0, 0, 0, '', ''),
(9, 'sys_cover_preview', 'sys_images_resized', 'Storage', 'a:1:{s:6:"object";s:10:"sys_images";}', 'no', 1, 2592000, 0, '', ''),
(10, 'sys_builder_page_preview', 'sys_images_resized', 'Storage', 'a:1:{s:6:"object";s:10:"sys_images";}', 'no', 1, 2592000, 0, '', ''),
(11, 'sys_builder_page_embed', 'sys_images_resized', 'Storage', 'a:1:{s:6:"object";s:10:"sys_images";}', 'no', 1, 2592000, 0, '', ''),
(12, 'sys_cmts_images_preview', 'sys_cmts_images_preview', 'Storage', 'a:1:{s:6:"object";s:15:"sys_cmts_images";}', 'no', 1, 2592000, 0, '', ''),
(13, 'sys_custom_images', 'sys_images_resized', 'Storage', 'a:1:{s:6:"object";s:17:"sys_images_custom";}', 'no', 1, 2592000, 0, '', ''),
(14, 'sys_images_editor', 'sys_images_editor_resized', 'Storage', 'a:1:{s:6:"object";s:17:"sys_images_editor";}', 'no', 1, 2592000, 0, '', ''),
(15, 'sys_wiki_images_preview', 'sys_wiki_images_resized', 'Storage', 'a:1:{s:6:"object";s:14:"sys_wiki_files";}', 'no', 1, 2592000, 0, '', ''),
(16, 'bx_persons_icon', 'bx_persons_pictures_resized', 'Storage', 'a:1:{s:6:"object";s:19:"bx_persons_pictures";}', 'no', 1, 2592000, 0, '', ''),
(17, 'bx_persons_thumb', 'bx_persons_pictures_resized', 'Storage', 'a:1:{s:6:"object";s:19:"bx_persons_pictures";}', 'no', 1, 2592000, 0, '', ''),
(18, 'bx_persons_avatar', 'bx_persons_pictures_resized', 'Storage', 'a:1:{s:6:"object";s:19:"bx_persons_pictures";}', 'no', 1, 2592000, 0, '', ''),
(19, 'bx_persons_avatar_big', 'bx_persons_pictures_resized', 'Storage', 'a:1:{s:6:"object";s:19:"bx_persons_pictures";}', 'no', 1, 2592000, 0, '', ''),
(20, 'bx_persons_picture', 'bx_persons_pictures_resized', 'Storage', 'a:1:{s:6:"object";s:19:"bx_persons_pictures";}', 'no', 1, 2592000, 0, '', ''),
(21, 'bx_persons_cover', 'bx_persons_pictures_resized', 'Storage', 'a:1:{s:6:"object";s:19:"bx_persons_pictures";}', 'no', 1, 2592000, 0, '', ''),
(22, 'bx_persons_cover_thumb', 'bx_persons_pictures_resized', 'Storage', 'a:1:{s:6:"object";s:19:"bx_persons_pictures";}', 'no', 1, 2592000, 0, '', ''),
(23, 'bx_persons_gallery', 'bx_persons_pictures_resized', 'Storage', 'a:1:{s:6:"object";s:19:"bx_persons_pictures";}', 'no', 1, 2592000, 0, '', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_uploader`
--

CREATE TABLE `sys_objects_uploader` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(4) NOT NULL,
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=10 ;

--
-- Dumping data for table `sys_objects_uploader`
--

INSERT INTO `sys_objects_uploader` VALUES
(1, 'sys_html5', 1, 'BxTemplUploaderHTML5', ''),
(2, 'sys_video_recording', 1, 'BxTemplUploaderVideoRecording', ''),
(3, 'sys_crop', 1, 'BxTemplUploaderCrop', ''),
(4, 'sys_cmts_html5', 1, 'BxTemplCmtsUploaderHTML5', ''),
(5, 'sys_settings_html5', 1, 'BxTemplStudioSettingsUploaderHTML5', ''),
(6, 'sys_builder_page_html5', 1, 'BxTemplStudioBuilderPageUploaderHTML5', ''),
(7, 'sys_std_crop_cover', 1, 'BxTemplStudioUploaderCropCover', ''),
(8, 'bx_persons_cover_crop', 1, 'BxPersonsUploaderCoverCrop', 'modules/boonex/persons/classes/BxPersonsUploaderCoverCrop.php'),
(9, 'bx_persons_picture_crop', 1, 'BxPersonsUploaderPictureCrop', 'modules/boonex/persons/classes/BxPersonsUploaderPictureCrop.php');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_view`
--

CREATE TABLE `sys_objects_view` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table_track` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `period` int(11) NOT NULL DEFAULT '86400',
  `pruning` int(11) NOT NULL DEFAULT '31536000',
  `is_on` tinyint(4) NOT NULL DEFAULT '1',
  `trigger_table` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_field_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_field_author` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_field_count` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `class_file` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_objects_view`
--

INSERT INTO `sys_objects_view` VALUES
(1, 'bx_persons', 'bx_persons', 'bx_persons_views_track', 86400, 31536000, 1, 'bx_persons_data', 'id', 'author', 'views', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_vote`
--

CREATE TABLE `sys_objects_vote` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `TableMain` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `TableTrack` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `PostTimeout` int(11) NOT NULL DEFAULT '0',
  `MinValue` tinyint(4) NOT NULL DEFAULT '1',
  `MaxValue` tinyint(4) NOT NULL DEFAULT '5',
  `Pruning` int(11) NOT NULL DEFAULT '31536000',
  `IsUndo` tinyint(1) NOT NULL DEFAULT '0',
  `IsOn` tinyint(1) NOT NULL DEFAULT '1',
  `TriggerTable` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `TriggerFieldId` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `TriggerFieldAuthor` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `TriggerFieldRate` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `TriggerFieldRateCount` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ClassName` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ClassFile` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `sys_objects_vote`
--

INSERT INTO `sys_objects_vote` VALUES
(1, 'sys_cmts', 'system', 'sys_cmts_votes', 'sys_cmts_votes_track', 604800, 1, 1, 31536000, 0, 1, 'sys_cmts_ids', 'id', 'author_id', 'rate', 'votes', 'BxTemplCmtsVoteLikes', ''),
(2, 'sys_cmts_reactions', 'system', 'sys_cmts_reactions', 'sys_cmts_reactions_track', 604800, 1, 1, 31536000, 1, 1, 'sys_cmts_ids', 'id', 'author_id', 'rrate', 'rvotes', 'BxTemplCmtsVoteReactions', ''),
(3, 'sys_form_fields_votes', 'system', 'sys_form_fields_votes', 'sys_form_fields_votes_track', 604800, 1, 1, 31536000, 0, 1, 'sys_form_fields_ids', 'id', 'author_id', 'rate', 'votes', '', ''),
(4, 'sys_form_fields_reaction', 'system', 'sys_form_fields_reaction', 'sys_form_fields_reaction_track', 604800, 1, 1, 31536000, 1, 1, 'sys_form_fields_ids', 'id', 'author_id', 'rrate', 'rvotes', 'BxTemplVoteReactions', ''),
(5, 'bx_persons', 'bx_persons', 'bx_persons_votes', 'bx_persons_votes_track', 604800, 1, 1, 31536000, 0, 1, 'bx_persons_data', 'id', '', 'rate', 'votes', 'BxPersonsVote', 'modules/boonex/persons/classes/BxPersonsVote.php');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_wiki`
--

CREATE TABLE `sys_objects_wiki` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uri` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `override_class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`),
  UNIQUE KEY `uri` (`uri`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_objects_wiki`
--

INSERT INTO `sys_objects_wiki` VALUES
(1, 'system', 'sys', '_sys_wiki_system_title', 'system', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_options`
--

CREATE TABLE `sys_options` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) unsigned NOT NULL DEFAULT '0',
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `caption` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `info` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('value','digit','text','code','checkbox','select','combobox','file','image','list','rlist','rgb','rgba','datetime') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'digit',
  `extra` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `check` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `check_params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `check_error` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `order` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `category_id` (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=290 ;

--
-- Dumping data for table `sys_options`
--

INSERT INTO `sys_options` VALUES
(1, 1, 'sys_cron_time', '_adm_stg_cpt_option_sys_cron_time', '', '0', 'digit', '', '', '', '', 2),
(2, 1, 'sys_upgrade_channel', '_adm_stg_cpt_option_sys_upgrade_channel', '', 'stable', 'select', 'stable,beta', '', '', '', 4),
(3, 1, 'sys_revision', '_adm_stg_cpt_option_sys_revision', '', '3', 'digit', '', '', '', '', 5),
(4, 1, 'sys_eq_time', '_adm_stg_cpt_option_sys_eq_time', '', '0', 'digit', '', '', '', '', 6),
(5, 1, 'sys_push_queue_time', '_adm_stg_cpt_option_sys_push_queue_time', '', '0', 'digit', '', '', '', '', 7),
(6, 1, 'sys_ftp_login', '_adm_stg_cpt_option_sys_ftp_login', '', '', 'digit', '', '', '', '', 10),
(7, 1, 'sys_ftp_password', '_adm_stg_cpt_option_sys_ftp_password', '', '', 'digit', '', '', '', '', 11),
(8, 1, 'sys_ftp_dir', '_adm_stg_cpt_option_sys_ftp_dir', '', '', 'digit', '', '', '', '', 12),
(9, 1, 'sys_template_cache_image_enable', '_adm_stg_cpt_option_sys_template_cache_image_enable', '', '', 'checkbox', '', '', '', '', 20),
(10, 1, 'sys_template_cache_image_max_size', '_adm_stg_cpt_option_sys_template_cache_image_max_size', '', '5', 'digit', '', 'Segment', 'a:2:{s:3:"min";i:1;s:3:"max";i:10;}', '_adm_stg_cpt_option_sys_template_cache_image_max_size_err', 21),
(11, 1, 'sys_email_attachable_email_templates', '_adm_stg_cpt_option_sys_email_attachable_email_templates', '', '', 'digit', '', '', '', '', 31),
(12, 1, 'sys_redirect_after_account_added', '_adm_stg_cpt_option_sys_redirect_after_account_added', '', 'page.php?i=account-profile-switcher&register=1', 'digit', '', '', '', '', 40),
(13, 1, 'sys_redirect_after_email_confirmation', '_adm_stg_cpt_option_sys_redirect_after_email_confirmation', '', '', 'digit', '', '', '', '', 41),
(14, 1, 'sys_editor_default', '_adm_stg_cpt_option_sys_editor_default', '', 'sys_quill', 'digit', '', '', '', '', 50),
(15, 1, 'sys_player_default', '_adm_stg_cpt_option_sys_player_default', '', 'sys_html5', 'digit', '', '', '', '', 55),
(16, 1, 'sys_player_default_format', '_adm_stg_cpt_option_sys_player_default_quality', '', 'sd', 'select', 'sd,hd', '', '', '', 56),
(17, 1, 'sys_live_updates_interval', '_adm_stg_cpt_option_sys_live_updates_interval', '', '10000', 'digit', '', '', '', '', 60),
(18, 1, 'sys_quill_insert_as_plain_text', '_adm_stg_cpt_option_sys_quill_insert_as_plain_text', '', '', 'checkbox', '', '', '', '', 65),
(19, 1, 'sys_quill_allow_empty_tags', '_adm_stg_cpt_option_sys_quill_allow_empty_tags', '', 'on', 'checkbox', '', '', '', '', 66),
(20, 1, 'sys_quill_allowed_tags_mini', '_adm_stg_cpt_option_sys_quill_allowed_tags_mini', '', '', 'digit', '', '', '', '', 67),
(21, 1, 'sys_quill_allowed_tags_standard', '_adm_stg_cpt_option_sys_quill_allowed_tags_standard', '', '', 'digit', '', '', '', '', 68),
(22, 1, 'sys_quill_allowed_tags_full', '_adm_stg_cpt_option_sys_quill_allowed_tags_full', '', '', 'digit', '', '', '', '', 69),
(23, 1, 'sys_quill_toolbar_mini', '_adm_stg_cpt_option_sys_quill_toolbar_mini', '', '[''bold'',''italic'',''underline'',''clean'',{''list'':''ordered''}, {''list'':''bullet''},{ ''align'':''''},{''align'':''center''},{''align'':''right''},''blockquote'',''link'',''image'',''embed'']', 'digit', '', '', '', '', 70),
(24, 1, 'sys_quill_toolbar_standard', '_adm_stg_cpt_option_sys_quill_toolbar_standard', '', '[''bold'',''italic'',''underline'',''clean'',{ ''header'': [1, 2, 3, 4, 5, 6, false] },{''list'':''ordered''}, {''list'':''bullet''},{''indent'': ''-1''},{''indent'': ''+1''},{ ''align'':''''},{''align'':''center''},{''align'':''right''},{''align'':''justify''},''blockquote'',''link'',''image'',''embed'',''emoji'']', 'digit', '', '', '', '', 73),
(25, 1, 'sys_quill_toolbar_full', '_adm_stg_cpt_option_sys_quill_toolbar_full', '', '[{ ''header'': [1, 2, 3, 4, 5, 6, false] },''bold'',''italic'',''underline'',''clean''],[{ ''align'': [] },{''list'':''ordered''}, {''list'':''bullet''},{''indent'': ''-1''},{''indent'': ''+1''},''blockquote'',{ ''color'': [] }, { ''background'': [] },{ ''direction'': ''rtl'' },''link'',''image'',''embed'',''code-block'',''emoji'',''show-html'']', 'digit', '', '', '', '', 76),
(26, 1, 'sys_search_keyword_min_len', '_adm_stg_cpt_option_sys_search_keyword_min_len', '', '1', 'digit', '', '', '', '', 80),
(27, 1, 'sys_relations_enable', '_adm_stg_cpt_option_sys_relations_enable', '', '', 'checkbox', '', '', '', '', 90),
(28, 1, 'sys_relations', '_adm_stg_cpt_option_sys_relations', '', 'bx_persons_bx_persons', 'list', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:21:"get_options_relations";s:6:"params";a:0:{}s:5:"class";s:13:"TemplServices";}', '', '', '', 91),
(29, 1, 'enable_gd', '_adm_stg_cpt_option_enable_gd', '', 'on', 'checkbox', '', '', '', '', 100),
(30, 1, 'sys_transcoder_queue_storage', '_adm_stg_cpt_option_sys_transcoder_queue_storage', '', '', 'checkbox', '', '', '', '', 105),
(31, 1, 'sys_session_lifetime_in_min', '_adm_stg_cpt_option_sys_session_lifetime_in_min', '', '129600', 'digit', '', '', '', '', 110),
(32, 1, 'sys_session_auth', '_adm_stg_cpt_option_sys_session_auth', '', '', 'checkbox', '', '', '', '', 112),
(33, 1, 'sys_account_activation_letter', '_adm_stg_cpt_option_sys_account_activation_letter', '', '', 'checkbox', '', '', '', '', 120),
(34, 1, 'sys_logs_storage_default', '_adm_stg_cpt_option_sys_logs_storage_default', '', 'Folder', 'select', 'Folder,PHPLog,STDErr', '', '', '', 130),
(35, 1, 'sys_default_socket_timeout', '_adm_stg_cpt_option_sys_default_socket_timeout', '', '30', 'digit', '', '', '', '', 140),
(36, 1, 'sys_default_curl_timeout', '_adm_stg_cpt_option_sys_default_curl_timeout', '', '300', 'digit', '', '', '', '', 141),
(37, 1, 'sys_curl_ssl_allow_untrusted', '_adm_stg_cpt_option_sys_ssl_allow_untrusted', '', '', 'checkbox', '', '', '', '', 145),
(38, 1, 'sys_csp_frame_ancestors', '_adm_stg_cpt_option_sys_csp_frame_ancestors', '', '*', 'digit', '', '', '', '', 150),
(39, 1, 'sys_x_frame_options', '_adm_stg_cpt_option_sys_x_frame_options', '', 'SAMEORIGIN', 'select', 'Off,SAMEORIGIN,DENY', '', '', '', 151),
(40, 1, 'sys_samesite_cookies', '_adm_stg_cpt_option_sys_samesite_cookies', '', 'Lax', 'select', 'None,Lax,Strict', '', '', '', 152),
(41, 1, 'sys_notify_to_approve_by_role', '_adm_stg_cpt_option_sys_notify_to_approve_by_role', '', '', 'checkbox', '', '', '', '', 160),
(42, 1, 'sys_fixed_header', '_adm_stg_cpt_option_sys_fixed_header', '', '', 'checkbox', '', '', '', '', 170),
(43, 1, 'sys_css_media_classes', '_adm_stg_cpt_option_sys_css_media_classes', '', '{"phone":"(max-width:720px)","phone2":"(min-width:533px) and (max-width:720px)","tablet":"(min-width:720px) and (max-width:1280px)","tablet2":"(min-width:1024px) and (max-width:1280px)","desktop":"(min-width:1280px)"}', 'digit', '', '', '', '', 180),
(44, 1, 'sys_css_tailwind_default', '_adm_stg_cpt_option_sys_css_tailwind_default', '', 'tailwind.min.css', 'select', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:27:"get_options_taiwind_default";s:5:"class";s:13:"TemplServices";}', '', '', '', 181),
(45, 1, 'sys_css_icons_default', '_adm_stg_cpt_option_sys_css_icons_default', '', 'icons.css', 'digit', '', '', '', '', 182),
(46, 1, 'sys_files_ext_images', '_adm_stg_cpt_option_sys_files_ext_images', '', 'jpg,jpeg,jpe,gif,png,webp', 'digit', '', '', '', '', 200),
(47, 1, 'sys_files_ext_video', '_adm_stg_cpt_option_sys_files_ext_video', '', 'avi,flv,mpg,mpeg,wmv,mp4,m4v,mov,qt,divx,xvid,3gp,3g2,webm,mkv,ogv,ogg,rm,rmvb,asf,drc,ts', 'digit', '', '', '', '', 210),
(48, 1, 'sys_files_ext_audio', '_adm_stg_cpt_option_sys_files_ext_audio', '', 'mp3,m4a,m4b,wma,wav,3gp', 'digit', '', '', '', '', 220),
(49, 1, 'sys_files_ext_imagevideo', '_adm_stg_cpt_option_sys_files_ext_imagevideo', '', 'jpg,jpeg,jpe,gif,png,svg,webp,avi,flv,mpg,mpeg,wmv,mp4,m4v,mov,qt,divx,xvid,3gp,3g2,webm,mkv,ogv,ogg,rm,rmvb,asf,drc,ts', 'digit', '', '', '', '', 230),
(50, 1, 'sys_files_ext_dangerous', '_adm_stg_cpt_option_sys_files_ext_dangerous', '', 'action,apk,app,bat,bin,cmd,com,command,cpl,csh,exe,gadget,inf,ins,inx,ipa,isu,job,jse,ksh,lnk,msc,msi,msp,mst,osx,out,paf,pif,prg,ps1,reg,rgs,run,sct,shb,shs,u3p,vb,vbe,vbs,vbscript,workflow,ws,wsf', 'digit', '', '', '', '', 240),
(51, 1, 'sys_viewport_meta_tag', '_adm_stg_cpt_option_sys_viewport_meta_tag', '', 'width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0', 'digit', '', '', '', '', 250),
(52, 1, 'sys_form_lpc_enable', '_adm_stg_cpt_option_sys_form_lpc_enable', '', 'on', 'checkbox', '', '', '', '', 260),
(53, 1, 'sys_std_show_header_left', '_adm_stg_cpt_option_sys_std_show_header_left', '', '', 'checkbox', '', '', '', '', 270),
(54, 1, 'sys_std_show_header_left_search', '_adm_stg_cpt_option_sys_std_show_header_left_search', '', '', 'checkbox', '', '', '', '', 271),
(55, 1, 'sys_std_show_header_center', '_adm_stg_cpt_option_sys_std_show_header_center', '', 'on', 'checkbox', '', '', '', '', 275),
(56, 1, 'sys_std_show_header_right', '_adm_stg_cpt_option_sys_std_show_header_right', '', 'on', 'checkbox', '', '', '', '', 280),
(57, 1, 'sys_std_show_header_right_search', '_adm_stg_cpt_option_sys_std_show_header_right_search', '', 'on', 'checkbox', '', '', '', '', 281),
(58, 1, 'sys_std_show_header_right_site', '_adm_stg_cpt_option_sys_std_show_header_right_site', '', '', 'checkbox', '', '', '', '', 282),
(59, 1, 'sys_std_show_launcher_left', '_adm_stg_cpt_option_sys_std_show_launcher_left', '', '', 'checkbox', '', '', '', '', 285),
(60, 1, 'sys_embed_microlink_key', '_adm_stg_cpt_option_sys_embed_microlink_key', '', '', 'digit', '', '', '', '', 300),
(61, 2, 'site_email_html_template_header', '_adm_stg_cpt_option_site_email_html_template_header', '', '<html>\r\n    <head></head>\r\n    <body bgcolor="#fff" style="margin:0; padding:0;">\r\n        <div style="background-color:#fff;">\r\n            <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">\r\n                <tr><td valign="top">\r\n                    <div style="color:#333; padding:20px; font:14px Helvetica, Arial, sans-serif;">\r\n                        <div style="border-bottom:2px solid #eee; padding-bottom:10px; margin-bottom:20px; font-weight:bold; font-size:22px; color:#999;">{site_name}</div>', 'text', '', '', '', '', 1),
(62, 2, 'site_email_html_template_footer', '_adm_stg_cpt_option_site_email_html_template_footer', '', '\r\n                    </div>\r\n                </td></tr>\r\n                <tr><td valign="top">\r\n                    <div style="color:#999; padding:0 20px 20px 20px; font:11px Helvetica, Arial, sans-serif;">\r\n                        <div style="border-top:2px solid #eee; padding-top:10px;">{about_us}&nbsp;&nbsp;&nbsp;{unsubscribe}</div>\r\n                    </div>\r\n                </td></tr>\r\n            </table>\r\n        </div>\r\n    </body>\r\n</html>', 'text', '', '', '', '', 2),
(63, 2, 'sys_site_icon', '', '', '0', 'digit', '', '', '', '', 15),
(64, 2, 'sys_site_icon_svg', '', '', '0', 'digit', '', '', '', '', 16),
(65, 2, 'sys_site_icon_apple', '', '', '0', 'digit', '', '', '', '', 17),
(66, 2, 'sys_site_icon_android', '', '', '0', 'digit', '', '', '', '', 18),
(67, 2, 'sys_site_icon_android_splash', '', '', '0', 'digit', '', '', '', '', 19),
(68, 2, 'sys_site_logo', '', '', '0', 'digit', '', '', '', '', 20),
(69, 2, 'sys_site_logo_alt', '_adm_dsg_txt_alt_text', '', '0', 'text', '', '', '', '', 21),
(70, 2, 'sys_site_logo_aspect_ratio', '_adm_stg_cpt_option_sys_site_logo_aspect_ratio', '', '', 'digit', '', '', '', '', 22),
(71, 2, 'sys_site_splash_code', '', '', '<style>\r\n    /*--- Splash ---*/\r\n  	.bx-page {\r\n        position: relative;\r\n  	}\r\n	.bx-header {\r\n        position: relative;\r\n      	display: -webkit-flex;\r\n        display: flex;\r\n        -webkit-align-items: center;\r\n        align-items: center;\r\n      	justify-content: center;\r\n      	-webkit-justify-content: center;\r\n        height: 4rem;\r\n        border-bottom: 1px solid rgba(0, 0, 0, 0.1);\r\n      	font-weight: 700;\r\n      	font-size: 2rem;\r\n    }\r\n    .bx-splash {\r\n        position: relative;\r\n        display: -webkit-flex;\r\n        display: flex;\r\n      	-webkit-align-items: center;\r\n        align-items: center;\r\n      	min-height: 100vh;\r\n    }\r\n    .bx-spl-preload {\r\n        position: absolute;\r\n\r\n        top: 0px;\r\n        left: 0px;\r\n        width: 1px;\r\n        height: 1px;\r\n\r\n        overflow: hidden;\r\n    }\r\n    .bx-spl-line {\r\n      	position: relative;\r\n        display: -webkit-flex;\r\n        display: flex;\r\n        -webkit-align-items: stretch;\r\n        align-items: stretch;\r\n    }\r\n  	.bx-media-phone .bx-spl-line {\r\n      	-webkit-flex-direction: column;\r\n      	flex-direction: column;\r\n    }\r\n  	.bx-spl-cell {\r\n      	position: relative;\r\n  	}\r\n  	.bx-media-phone .bx-spl-cell {\r\n      	-webkit-basis: 100% !important; \r\n      	flex-basis: 100% !important;\r\n      	width: 100% !important;\r\n  	}\r\n    .bx-spl-line.bx-spl-l1 .bx-spl-cell {\r\n      	display: -webkit-flex;\r\n        display: flex;\r\n        -webkit-align-items: center;\r\n        align-items: center;\r\n    }\r\n  	.bx-spl-line.bx-spl-l1 .bx-spl-cell.bx-spl-c1 {\r\n        -webkit-flex: 1 1 70%; \r\n        flex:  1 1 70%;\r\n      	width: 70%;\r\n    }\r\n  	.bx-media-phone .bx-spl-line.bx-spl-l1 .bx-spl-cell.bx-spl-c1 {\r\n      	text-align: center;\r\n  	}\r\n  	.bx-spl-line.bx-spl-l1 .bx-spl-cell.bx-spl-c2 {\r\n        -webkit-flex: 0 0 30%; \r\n        flex:  0 1 30%;\r\n      	-webkit-justify-content: center;\r\n        justify-content: center;\r\n      	width: 30%;\r\n    }\r\n    .bx-spl-line.bx-spl-l1 .bx-spl-image {\r\n      	max-width: 100%;\r\n    }\r\n    .bx-spl-line.bx-spl-l2 .bx-spl-cell {\r\n        -webkit-flex: 1 1 33%; \r\n        flex:  1 1 33%;\r\n      	width: 33%;\r\n    }\r\n  	.bx-media-phone .bx-spl-line.bx-spl-l2 .bx-spl-cell {\r\n      	text-align: center;\r\n  	}\r\n    .bx-spl-line.bx-spl-l2 .bx-spl-cicon {\r\n		position: relative;\r\n      	display: -webkit-flex;\r\n        display: flex;\r\n        -webkit-align-items: flex-start;\r\n        align-items: flex-start;\r\n      	justify-content: flex-start;\r\n      	-webkit-justify-content: flex-start;\r\n    }\r\n    .bx-media-phone .bx-spl-line.bx-spl-l2 .bx-spl-cicon {\r\n      	justify-content: center;\r\n      	-webkit-justify-content: center;\r\n    }\r\n    .bx-spl-line.bx-spl-l2 .bx-spl-cicon .animation {\r\n        width: 4.25rem;\r\n        height: 4.25rem;\r\n    }\r\n</style>\r\n<div class="bx-page bx-def-color-bg-page">\r\n  <div class="bx-header">__logo__</div>\r\n  <div class="bx-splash">\r\n      <div class="bx-splash-cnt bx-def-page-width bx-def-centered bx-def-padding-leftright">\r\n          <div class="bx-spl-preload">\r\n            <img src="<bx_image_url:spl-image-main.svg />">\r\n          </div>\r\n          <div class="bx-spl-line bx-spl-l1">\r\n            <div class="bx-spl-cell bx-spl-c1">\r\n              <div class="bx-spl-ccnt bx-def-padding">\r\n                <div class="bx-spl-title bx-def-font-h1 bx-def-font-semibold"><bx_text:_sys_txt_splash_title /></div>\r\n                <div class="bx-spl-slogan bx-def-padding-sec-top bx-def-padding-bottom bx-def-font-grayed"><bx_text:_sys_txt_splash_slogan /></div>\r\n                <div class="bx-spl-image bx-def-padding-top">\r\n                  <img class="bx-spl-image" src="<bx_image_url:spl-image-main.svg />" />\r\n                </div>\r\n              </div>\r\n            </div>\r\n            <div class="bx-spl-cell bx-spl-c2 bx-hide-when-logged-in">\r\n              <div class="bx-spl-ccnt bx-def-padding">__join_form_in_box__</div>\r\n            </div>\r\n          </div>\r\n          <div class="bx-spl-line bx-spl-l2 bx-def-padding">\r\n            <div class="bx-spl-cell bx-spl-c1">\r\n              <div class="bx-spl-ccnt bx-def-padding">\r\n                <div class="bx-spl-cicon connect"><div class="animation"></div></div>\r\n                <div class="bx-spl-ctitle bx-def-padding-sec-topbottom bx-def-font-h2"><bx_text:_sys_txt_splash_connect /></div>\r\n                <div class="bx-spl-ctext bx-def-font-grayed"><bx_text:_sys_txt_splash_connect_text /></div>\r\n              </div>\r\n            </div>\r\n            <div class="bx-spl-cell bx-spl-c2">\r\n              <div class="bx-spl-ccnt bx-def-padding">\r\n                <div class="bx-spl-cicon share"><div class="animation"></div></div>\r\n                <div class="bx-spl-ctitle bx-def-padding-sec-topbottom bx-def-font-h2"><bx_text:_sys_txt_splash_share /></div>\r\n                <div class="bx-spl-ctext bx-def-font-grayed"><bx_text:_sys_txt_splash_share_text /></div>\r\n              </div>\r\n            </div>\r\n            <div class="bx-spl-cell bx-spl-c3">\r\n              <div class="bx-spl-ccnt bx-def-padding">\r\n                <div class="bx-spl-cicon create"><div class="animation"></div></div>\r\n                <div class="bx-spl-ctitle bx-def-padding-sec-topbottom bx-def-font-h2"><bx_text:_sys_txt_splash_create /></div>\r\n                <div class="bx-spl-ctext bx-def-font-grayed"><bx_text:_sys_txt_splash_create_text /></div>\r\n              </div>\r\n            </div>\r\n          </div>\r\n      </div>\r\n  </div>\r\n</div>\r\n<script>\r\n  var animConnect = bodymovin.loadAnimation({\r\n    container: $(''.bx-spl-cicon.connect .animation'').get(0),\r\n    path: ''<bx_image_url:spl-icon-connect.json />'',\r\n    renderer: ''svg'',\r\n    loop: true,\r\n    autoplay: true,\r\n  });\r\n  var animShare = bodymovin.loadAnimation({\r\n    container: $(''.bx-spl-cicon.share .animation'').get(0),\r\n    path: ''<bx_image_url:spl-icon-share.json />'',\r\n    renderer: ''svg'',\r\n    loop: true,\r\n    autoplay: true,\r\n  });\r\n  var animCreate = bodymovin.loadAnimation({\r\n    container: $(''.bx-spl-cicon.create .animation'').get(0),\r\n    path: ''<bx_image_url:spl-icon-create.json />'',\r\n    renderer: ''svg'',\r\n    loop: true,\r\n    autoplay: true,\r\n  });\r\n</script>', 'text', '', '', '', '', 25),
(72, 2, 'sys_site_splash_enabled', '', '', '', 'checkbox', '', '', '', '', 26),
(73, 2, 'sys_site_cover_common', '', '', '0', 'digit', '', '', '', '', 27),
(74, 2, 'sys_unit_cover_profile', '', '', '0', 'digit', '', '', '', '', 28),
(75, 2, 'sys_site_cover_disabled', '', '', '', 'checkbox', '', '', '', '', 29),
(76, 3, 'lang_default', '_adm_stg_cpt_option_lang_default', '', 'en', 'select', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:13:"get_languages";s:6:"params";a:2:{i:0;b:0;i:1;b:1;}s:5:"class";s:22:"TemplLanguagesServices";}', '', '', '', 1),
(77, 3, 'lang_subst_from_en', '_adm_stg_cpt_option_lang_subst_from_en', '', 'on', 'checkbox', '', '', '', '', 2),
(78, 3, 'sys_format_date', '_adm_stg_cpt_option_sys_format_date', '', 'D MMM YYYY', 'digit', '', '', '', '', 3),
(79, 3, 'sys_format_time', '_adm_stg_cpt_option_sys_format_time', '', 'HH:mm', 'digit', '', '', '', '', 4),
(80, 3, 'sys_format_datetime', '_adm_stg_cpt_option_sys_format_datetime', '', 'D MMM YYYY h:mm:ss a', 'digit', '', '', '', '', 5),
(81, 3, 'sys_format_timeago', '_adm_stg_cpt_option_sys_format_timeago', '', '432000', 'digit', '', '', '', '', 6),
(82, 3, 'sys_format_input_24h', '_adm_stg_cpt_option_sys_format_input_24h', '', 'on', 'checkbox', '', '', '', '', 24),
(83, 4, 'template', '_adm_stg_cpt_option_template', '', 'artificer', 'select', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:13:"get_templates";s:5:"class";s:21:"TemplTemplateServices";}', 'Template', '', '_adm_stg_err_option_template', 1),
(84, 4, 'sys_pt_default_visitor', '_adm_stg_cpt_option_sys_pt_default_visitor', '', '3', 'select', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:14:"get_page_types";s:5:"class";s:21:"TemplTemplateServices";}', '', '', '', 10),
(85, 4, 'sys_pt_default_member', '_adm_stg_cpt_option_sys_pt_default_member', '', '3', 'select', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:14:"get_page_types";s:5:"class";s:21:"TemplTemplateServices";}', '', '', '', 11),
(86, 5, 'site_title', '_adm_stg_cpt_option_site_title', '_adm_stg_inf_option_site_title', '[[site_name]]', 'digit', '', '', '', '', 1),
(87, 5, 'site_email', '_adm_stg_cpt_option_site_email', '_adm_stg_inf_option_site_email', '[[admin_email]]', 'digit', '', '', '', '', 2),
(88, 5, 'site_email_notify', '_adm_stg_cpt_option_site_email_notify', '_adm_stg_inf_option_site_email_notify', '[[site_email]]', 'digit', '', '', '', '', 3),
(89, 5, 'site_tour_home', '_adm_stg_cpt_option_site_tour_home', '_adm_stg_inf_option_site_tour_home', 'on', 'checkbox', '', '', '', '', 6),
(90, 5, 'site_tour_studio', '_adm_stg_cpt_option_site_tour_studio', '_adm_stg_inf_option_site_tour_studio', 'on', 'checkbox', '', '', '', '', 7),
(91, 5, 'sys_autoupdate', '_adm_stg_cpt_option_sys_autoupdate', '_adm_stg_inf_option_sys_autoupdate', 'on', 'checkbox', '', '', '', '', 10),
(92, 5, 'sys_autoupdate_force_modified_files', '_adm_stg_cpt_option_sys_autoupdate_force_modified_files', '_adm_stg_inf_option_sys_autoupdate_force_modified_files', '', 'checkbox', '', '', '', '', 12),
(93, 5, 'smart_app_banner', '_adm_stg_cpt_option_smart_app_banner', '_adm_stg_inf_option_smart_app_banner', '', 'checkbox', '', '', '', '', 14),
(94, 5, 'smart_app_banner_ios_app_id', '_adm_stg_cpt_option_smart_app_banner_ios_app_id', '_adm_stg_inf_option_smart_app_banner_ios_app_id', '', 'digit', '', '', '', '', 15),
(95, 5, 'sys_per_page_search_keyword_single', '_adm_stg_cpt_option_sys_per_page_search_keyword_single', '_adm_stg_inf_option_sys_per_page_search_keyword_single', '24', 'digit', '', '', '', '', 20),
(96, 5, 'sys_per_page_search_keyword_plural', '_adm_stg_cpt_option_sys_per_page_search_keyword_plural', '_adm_stg_inf_option_sys_per_page_search_keyword_plural', '3', 'digit', '', '', '', '', 21),
(97, 5, 'sys_live_search_limit', '_adm_stg_cpt_option_sys_live_search_limit', '_adm_stg_inf_option_sys_live_search_limit', '5', 'digit', '', '', '', '', 22),
(98, 5, 'sys_profiles_search_limit', '_adm_stg_cpt_option_sys_profiles_search_limit', '_adm_stg_inf_option_sys_profiles_search_limit', '20', 'digit', '', '', '', '', 23),
(99, 5, 'sys_metatags_hashtags_only', '_adm_stg_cpt_option_sys_metatags_hashtags_only', '', '', 'checkbox', '', '', '', '', 30),
(100, 5, 'sys_metatags_hashtags_max', '_adm_stg_cpt_option_sys_metatags_hashtags_max', '', '9', 'digit', '', '', '', '', 31),
(101, 5, 'sys_metatags_mentions_max', '_adm_stg_cpt_option_sys_metatags_mentions_max', '', '9', 'digit', '', '', '', '', 32),
(102, 5, 'sys_attach_links_max', '_adm_stg_cpt_option_sys_attach_links_max', '', '0', 'digit', '', '', '', '', 35),
(103, 5, 'sys_profile_bot', '_adm_stg_cpt_option_sys_profile_bot', '_adm_stg_inf_option_sys_profile_bot', '2', 'select', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:23:"get_options_profile_bot";s:5:"class";s:13:"TemplServices";}', '', '', '', 40),
(104, 5, 'sys_enable_post_to_context_for_privacy', '_adm_stg_cpt_option_sys_enable_post_to_context_for_privacy', '', '', 'checkbox', '', '', '', '', 50),
(105, 5, 'sys_hide_post_to_context_for_privacy', '_adm_stg_cpt_option_sys_hide_post_to_context_for_privacy', '', '', 'list', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:44:"get_options_module_list_for_privacy_selector";s:5:"class";s:13:"TemplServices";}', '', '', '', 51),
(106, 5, 'sys_treat_cxt_in_cxt_as_cnt', '_adm_stg_cpt_option_sys_treat_cxt_in_cxt_as_cnt', '', 'on', 'checkbox', '', '', '', '', 52),
(107, 5, 'sys_check_fan_in_parent_context', '_adm_stg_cpt_option_sys_check_fan_in_parent_context', '', 'on', 'checkbox', '', '', '', '', 55),
(108, 5, 'sys_vote_reactions_quick_mode', '_adm_stg_cpt_option_sys_vote_reactions_quick_mode', '', 'on', 'checkbox', '', '', '', '', 60),
(109, 5, 'sys_cmts_enable_auto_approve', '_adm_stg_cpt_option_sys_cmts_enable_auto_approve', '', 'on', 'checkbox', '', '', '', '', 70),
(110, 5, 'sys_create_post_form_preloading_list', '_adm_stg_cpt_option_sys_create_post_form_preloading_list', '_adm_stg_inf_option_sys_create_post_form_preloading_list', '', 'list', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:44:"get_options_create_post_form_preloading_list";s:5:"class";s:13:"TemplServices";}', '', '', '', 80),
(111, 6, 'sys_oauth_key', '_adm_stg_cpt_option_sys_oauth_key', '', '', 'digit', '', '', '', '', 20),
(112, 6, 'sys_oauth_secret', '_adm_stg_cpt_option_sys_oauth_secret', '', '', 'digit', '', '', '', '', 21),
(113, 6, 'currency_code', '_adm_stg_cpt_option_currency_code', '', 'USD', 'select', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:33:"get_options_currency_code_default";s:5:"class";s:21:"TemplPaymentsServices";}', 'Avail', '', '_adm_stg_err_option_currency_code', 30),
(114, 6, 'currency_sign', '_adm_stg_cpt_option_currency_sign', '', '&#36;', 'select', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:33:"get_options_currency_sign_default";s:5:"class";s:21:"TemplPaymentsServices";}', 'Avail', '', '_adm_stg_err_option_currency_sign', 31),
(115, 6, 'sys_default_payment', '_adm_stg_cpt_option_sys_default_payment', '', '', 'select', 'a:3:{s:6:"module";s:6:"system";s:6:"method";s:12:"get_payments";s:5:"class";s:21:"Tem