<?php
/**
 * DefaultProviderCollection.php
 *
 * @package Embera
 * @author Michael Pratt <yo@michael-pratt.com>
 * @link   http://www.michael-pratt.com/
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Embera\ProviderCollection;

/**
 * Basically its a wrapper for the ProvidercollectionAdapter but defines the
 * default providers supported by the library
 */
class DefaultProviderCollection extends ProviderCollectionAdapter
{
    /** inline {@inheritdoc} */
    public function __construct(array $config = [])
    {
        parent::__construct($config);
        $this->registerProvider([
            'Acast',
            'ActBlue',
            'Adilo',
            'Adways',
            'Afreecatv',
            'Altru',
            'Altium',
            'Amtraker',
            'Animoto',
            'AnnieMusic',
            'Apester',
            'Archivos',
            'Assemblrworld',
            'Audioboom',
            'Audiocom',
            'AudioClip',
            'Audiomack',
            'Audiomeans',
            'BeautifulAI',
            'Behance',
            'BeamsFm',
            'Biqnetwork',
            'Bitchute',
            'BlackfireIO',
            'Blogcast',
            'BlueskySocial',
            'Bookingmood',
            'Buttondown',
            'Bumper',
            'Bunny',
            'Canva',
            'Ceros',
            'Celero',
            'ChartBlocks',
            'Chroco',
            'CircuitLab',
            'Clyp',
            'CodeHS',
            'Codepoints',
            'CodeSandbox',
            'Commaful',
            'Coub',
            'Crumbs',
            'Cueup',
            'Curated',
            'Dadan',
            'Datawrapper',
            'DailyMotion',
            'Dalexni',
            'Deseretnews',
            'Deviantart',
            'Didacte',
            'Digiteka',
            'DocDroid',
            'Docswell',
            'DreamBroker',
            'EchoesHQ',
            'Embedery',
            'Ethfiddle',
            'EventLive',
            'Everviz',
            'Facebook',
            'Fader',
            'FaithLifeTV',
            'Figma',
            'Fitapp',
            'FITE',
            'Flickr',
            'Flourish',
            'FlowHubOrg',
            'Framer',
            'Framatube',
            'Fooday',
            'Genially',
            'GeographUk',
            'GeographCI',
            'GetShow',
            'GettyImages',
            'Giphy',
            'GloriaTV',
            'Gong',
            'Gmetri',
            'Grain',
            'Gumlet',
            'Gyazo',
            'Hash',
            'Hearthis',
            'Heyzine',
            'HiHaHo',
            'HippoVideo',
            'Hopvue',
            'Huffduffer',
            'Ideamapper',
            'iFixit',
            'IHeartRadio',
            'Imgur',
            'Infogram',
            'Infoveave',
            'Injurymap',
            'InsightTimer',
            'Instagram',
            'InsticatorContentEngagementUnit',
            'Issuu',
            'ItabtechInfosys',
            'ItemisCreate',
            'Jovian',
            'KakaoTV',
            'Kickstarter',
            'KirimEmail',
            'Kit',
            'Kurozora',
            'Kooapp',
            'Knacki',
            'LearningApps',
            'Libsyn',
            'Lineplace',
            'Livestream',
            'LocalVoicesNetwork',
            'Loom',
            'LottieFiles',
            'Ludus',
            'Lumiere',
            'Matterport',
            'MediaLab',
            'Mediastream',
            'MedienArchivKuenste',
            'MermaidInk',
            'Miro',
            'MixCloud',
            'Mixpanel',
            'MusicboxManiacs',
            'MySQLVisualExplain',
            'Namchey',
            'Nanoo',
            'NaturalAtlas',
            'NDLA',
            'Nebula',
            'NeetoRecord',
            'Nfb',
            'NFTndx',
            'Odysee',
            'OmnyStudio',
            'OraTV',
            'Orbitvu',
            'Origits',
            'Outplayed',
            'OverflowIO',
            'Pandavideo',
            'Pastery',
            'PeerTubeTV',
            'Piggy',
            'Pikasso',
            'Pinpoll',
            'Pinterest',
            'Pitchhub',
            'Playbuzz',
            'Plusdocs',
            'Podbean',
            'Polldaddy',
            'Portfolium',
            'Prezi',
            'Quartr',
            'QTpi',
            'RadioPublic',
            'Rcvis',
            'Reddit',
            'ReleaseWire',
            'Render',
            'Replit',
            'ReverbNation',
            'RoosterTeeth',
            'Rumble',
            'RunKit',
            'SapoVideos',
            'Sbedit',
            'Scenes',
            'ScreenNine',
            'Screencast',
            'ScribbleMaps',
            'Scribd',
            'SendToNews',
            'Shoudio',
            'ShowTheWay',
            'Sketchfab',
            'SlateApp',
            'Slideshare',
            'SmashNotes',
            'Smugmug',
            'SocialExplorer',
            'SongLink',
            'SoundCloud',
            'SpeakerDeck',
            'Spotify',
            'Spotlightr',
            'Spreaker',
            'SproutVideo',
            'Spyke',
            'StandfordDigitalRepository',
            'Streamable',
            'Streamio',
            'Sudomemo',
            'Sutori',
            'Sway',
            'Synthesia',
            'Ted',
            'TheNewYorkTimes',
            'ThreeQ',
            'Tickcounter',
            'TikTok',
            'Toornament',
            'TonicAudio',
            'Trackspace',
            'TrinityAudio',
            'Tumblr',
            'Tuxx',
            'Tvcf',
            'Twinmotion',
            'Twitter',
            'UAPod',
            'UniversitePantheonSorbonne',
            'UpecPod',
            'UstreamTV',
            'Ustudio',
            'Verse',
            'VidMount',
            'Videfit',
            'Vidyard',
            'Vimeo',
            'Viously',
            'Viostream',
            'Vlipsy',
            'Vizdom',
            'VouchFor',
            'WaveVideo',
            'Wecandeo',
            'Webcrumbs',
            'Web3IsGoingJustGreat',
            'WolframCloud',
            'VoxSnap',
            'Whimsical',
            'Wistia',
            'Wizer',
            'Wokwi',
            'Wordpress',
            'Wordwall',
            'Youtube',
            'Yumpu',
            'Zeplin',
            'Zingsoft',
            'Zoomable',
        ]);
    }
}
