
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `unmark20252`
--

-- --------------------------------------------------------

--
-- Table structure for table `labels`
--

CREATE TABLE `labels` (
  `label_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The auto-incremented key.',
  `smart_label_id` bigint(20) unsigned DEFAULT NULL COMMENT 'If a smart label, the label_id to use if a match is found.',
  `user_id` bigint(20) unsigned DEFAULT NULL COMMENT 'If a label but owned by a user, place the users.user_id here.',
  `name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'The name of the label.',
  `slug` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'The slug of the label.',
  `order` tinyint(3) unsigned DEFAULT NULL COMMENT 'The order to sort static system level labels.',
  `domain` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'The hostname of the domain to match. Keep in all lowercase.',
  `path` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'The path to find to for smartlabels to match. If null, just match host.',
  `smart_key` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'MD5 checksum of domain and path for lookup purposes.',
  `active` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1 is active, 0 if not. Defaults to 1.',
  `created_on` datetime NOT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'The last datetime this record was updated.',
  PRIMARY KEY (`label_id`),
  UNIQUE KEY `slug` (`slug`),
  KEY `smart_label_id` (`smart_label_id`),
  KEY `user_id` (`user_id`),
  KEY `smart_key` (`smart_key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=29 ;

--
-- Dumping data for table `labels`
--

INSERT INTO `labels` VALUES
(1, NULL, NULL, 'Unlabeled', 'unlabeled', 7, NULL, NULL, NULL, 1, '[[regtime]]', '[[regtime]]'),
(2, NULL, NULL, 'Read', 'read', 1, NULL, NULL, NULL, 1, '[[regtime]]', '[[regtime]]'),
(3, NULL, NULL, 'Watch', 'watch', 2, NULL, NULL, NULL, 1, '[[regtime]]', '[[regtime]]'),
(4, NULL, NULL, 'Listen', 'listen', 3, NULL, NULL, NULL, 1, '[[regtime]]', '[[regtime]]'),
(5, NULL, NULL, 'Buy', 'buy', 4, NULL, NULL, NULL, 1, '[[regtime]]', '[[regtime]]'),
(6, NULL, NULL, 'Eat & Drink', 'eat-drink', 5, NULL, NULL, NULL, 1, '[[regtime]]', '[[regtime]]'),
(7, NULL, NULL, 'Do', 'do', 6, NULL, NULL, NULL, 1, '[[regtime]]', '[[regtime]]'),
(8, 2, NULL, NULL, NULL, NULL, 'php.net', NULL, '5f810408ddbbd6d349b4be4766f41a37', 1, '[[regtime]]', '[[regtime]]'),
(9, 2, NULL, NULL, NULL, NULL, 'api.rubyonrails.org', NULL, '3935396372b71360fe67f2825e35114a', 1, '[[regtime]]', '[[regtime]]'),
(10, 2, NULL, NULL, NULL, NULL, 'ruby-doc.org', NULL, 'de44fc67b4e28fccda493635961574a5', 1, '[[regtime]]', '[[regtime]]'),
(11, 2, NULL, NULL, NULL, NULL, 'docs.jquery.com', NULL, '438f1fc8a34908d3a7381f8f9a31ab5a', 1, '[[regtime]]', '[[regtime]]'),
(12, 2, NULL, NULL, NULL, NULL, 'codeigniter.com', NULL, 'fe85ebca2c736539cf150aef9fab836d', 1, '[[regtime]]', '[[regtime]]'),
(13, 2, NULL, NULL, NULL, NULL, 'css-tricks.com', NULL, '6afd0d355149c21e8bcaea3f7b0cf7a8', 1, '[[regtime]]', '[[regtime]]'),
(14, 2, NULL, NULL, NULL, NULL, 'developer.apple.com', NULL, 'ee57526d93b7ebe634d687fcb04860c6', 1, '[[regtime]]', '[[regtime]]'),
(15, 3, NULL, NULL, NULL, NULL, 'youtube.com', NULL, '14dd5266c70789bdc806364df4586335', 1, '[[regtime]]', '[[regtime]]'),
(16, 3, NULL, NULL, NULL, NULL, 'viddler.com', NULL, '5e806612294d7f46548befd5b9f1f955', 1, '[[regtime]]', '[[regtime]]'),
(17, 3, NULL, NULL, NULL, NULL, 'devour.com', NULL, '1f9afab29da814fb55beaed94e3f74fa', 1, '[[regtime]]', '[[regtime]]'),
(18, 3, NULL, NULL, NULL, NULL, 'ted.com', NULL, '551f340ad8573abca89b89b982ee8021', 1, '[[regtime]]', '[[regtime]]'),
(19, 3, NULL, NULL, NULL, NULL, 'vimeo.com', NULL, '6040c1ecb3ba58fb545282cfae168f49', 1, '[[regtime]]', '[[regtime]]'),
(20, 5, NULL, NULL, NULL, NULL, 'svpply.com', NULL, '9906390718573aaf1218566ad93a6e9d', 1, '[[regtime]]', '[[regtime]]'),
(21, 5, NULL, NULL, NULL, NULL, 'amazon.com', NULL, 'a2a8283864386ca04a5694e8b58759e6', 1, '[[regtime]]', '[[regtime]]'),
(22, 5, NULL, NULL, NULL, NULL, 'fab.com', NULL, '88f463885d5d05d8b59caa992f6d3d91', 1, '[[regtime]]', '[[regtime]]'),
(23, 5, NULL, NULL, NULL, NULL, 'zappos.com', NULL, '23273aceb9e64e2105056b3d246c251f', 1, '[[regtime]]', '[[regtime]]'),
(24, 6, NULL, NULL, NULL, NULL, 'simplyrecipes.com', NULL, '963a735ec0768c767d9cf0a5fb52d47e', 1, '[[regtime]]', '[[regtime]]'),
(25, 6, NULL, NULL, NULL, NULL, 'allrecipes.com', NULL, 'efa5f18bdc3f468350c015c318ac125b', 1, '[[regtime]]', '[[regtime]]'),
(26, 6, NULL, NULL, NULL, NULL, 'epicurious.com', NULL, 'd68a91e3f9d2d43067dd26652b7acbc8', 1, '[[regtime]]', '[[regtime]]'),
(27, 6, NULL, NULL, NULL, NULL, 'foodnetwork.com', NULL, 'e3337470ff3cc159070bd281d56c6ad7', 1, '[[regtime]]', '[[regtime]]'),
(28, 6, NULL, NULL, NULL, NULL, 'food.com', NULL, '55c0705031bbbff4a62888a9b3a07961', 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `marks`
--

CREATE TABLE `marks` (
  `mark_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The auto-incremented id for marks.',
  `title` varchar(150) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The title from the page being bookmarked.',
  `url` text COLLATE utf8_unicode_ci NOT NULL COMMENT 'The full url from the page being bookmarked.',
  `url_key` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'The MD5 checksum of the url for lookup purposes.',
  `embed` text COLLATE utf8_unicode_ci COMMENT 'The embedded content that could appear on the mark''s info page.',
  `embed_processed` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1 = yes, 0 if not. Defaults to 0.',
  `created_on` datetime NOT NULL COMMENT 'The datetime this record was created.',
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'The last datetime this record was updated.',
  PRIMARY KEY (`mark_id`),
  UNIQUE KEY `url_key` (`url_key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `marks`
--

INSERT INTO `marks` VALUES
(1, 'Step 1: Learn how to add marks to Unmark', 'https://www.notion.so/cdevroe/Unmark-Help-How-to-add-bookmarks-cd5893f118ed40cd8400275e49f40d51', 'daec78812c5e08a1a5206a4d991169a0', NULL, 0, '[[regtime]]', '[[regtime]]'),
(2, 'Step 2: Watch a video walkthrough of Unmark', 'https://www.notion.so/cdevroe/Unmark-Help-Video-walkthrough-of-Unmark-UI-e5efd1ed5eaf42298e67fb087e476f33', '18c0f0b5c5cbc6fa5476be7e39a35570', NULL, 0, '[[regtime]]', '[[regtime]]'),
(3, 'Step 3: Discover new bookmarks', 'https://www.notion.so/cdevroe/Unmark-Help-Discover-featured-bookmarks-2091a6b3871c4b29a209b72d5c3e9bca', '584ca0feef7b27a4903533b7582e5f2c', NULL, 0, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE `migrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` VALUES
(2014112501);

-- --------------------------------------------------------

--
-- Table structure for table `plain_sessions`
--

CREATE TABLE `plain_sessions` (
  `session_id` varchar(40) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Unique session identifier',
  `session_data` text COLLATE utf8_unicode_ci NOT NULL COMMENT 'Serialized session data',
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Last updated at',
  PRIMARY KEY (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tags`
--

CREATE TABLE `tags` (
  `tag_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The auto-incremented key fro tags.',
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The tag name.',
  `slug` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The tag slug name.',
  PRIMARY KEY (`tag_id`),
  UNIQUE KEY `slug` (`slug`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tokens`
--

CREATE TABLE `tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Token ID auto generated',
  `user_id` bigint(20) unsigned DEFAULT NULL COMMENT 'User ID that token belongs to',
  `token_type` enum('FORGOT_PASSWORD') COLLATE utf8_unicode_ci NOT NULL COMMENT 'Token type enum',
  `token_value` varchar(64) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Generated token',
  `created_on` datetime NOT NULL COMMENT 'Creation date',
  `valid_until` datetime NOT NULL COMMENT 'Expiration date',
  `active` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Active flag',
  `used_on` datetime DEFAULT NULL COMMENT 'Date when token was successfully used',
  PRIMARY KEY (`token_id`),
  UNIQUE KEY `token_value_UNIQUE` (`token_value`),
  KEY `token_type_user_id_active_IDX` (`token_type`,`user_id`,`active`),
  KEY `tokens_user_id_FK` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `user_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `user_token` varchar(62) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Unique user token.',
  `active` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1 = active, 0 = inactive',
  `admin` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1 = admin, 0 = admin',
  `created_on` datetime NOT NULL COMMENT 'The datetime the account was created',
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `user_token` (`user_token`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `users`
--

INSERT INTO `users` VALUES
(1, '[[admin_email]]', '[[admin_pass]]', '[[user_token]]', 1, 0, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `users_to_marks`
--

CREATE TABLE `users_to_marks` (
  `users_to_mark_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The auto-incremented key.',
  `mark_id` bigint(20) unsigned NOT NULL COMMENT 'The mark_id from marks.mark_id.',
  `mark_title` text COLLATE utf8_unicode_ci COMMENT 'An optional user-specific mark title.',
  `user_id` bigint(20) unsigned NOT NULL COMMENT 'The user_id from users.user_id',
  `label_id` bigint(20) unsigned NOT NULL DEFAULT '1' COMMENT 'The label_id from labels.label_id.',
  `notes` text COLLATE utf8_unicode_ci,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Set to 1 for active, 0 for inactive.',
  `created_on` datetime NOT NULL COMMENT 'The datetime this record was created.',
  `archived_on` datetime DEFAULT NULL COMMENT 'The datetime this mark was archived. NULL = not archived.',
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'The last datetime this record was updated.',
  PRIMARY KEY (`users_to_mark_id`),
  KEY `mark_id` (`mark_id`),
  KEY `user_id` (`user_id`),
  KEY `label_id` (`label_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `users_to_marks`
--

INSERT INTO `users_to_marks` VALUES
(1, 1, NULL, 1, 2, NULL, 1, '[[regtime]]', NULL, '[[regtime]]'),
(2, 2, NULL, 1, 3, NULL, 1, '[[regtime]]', NULL, '[[regtime]]'),
(3, 3, NULL, 1, 7, NULL, 1, '[[regtime]]', NULL, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `user_marks_to_tags`
--

CREATE TABLE `user_marks_to_tags` (
  `user_marks_to_tag_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The auto-incremented key.',
  `tag_id` bigint(20) unsigned NOT NULL COMMENT 'The tag id from tags.tag_id',
  `user_id` bigint(20) unsigned NOT NULL COMMENT 'The user id from users.user_id',
  `users_to_mark_id` bigint(20) unsigned NOT NULL COMMENT 'The user mark id from users_to_marks.users_to_mark_id',
  PRIMARY KEY (`user_marks_to_tag_id`),
  KEY `users_to_mark_id` (`users_to_mark_id`),
  KEY `tag_id` (`tag_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `labels`
--
ALTER TABLE `labels`
  ADD CONSTRAINT `FK_label_smart_label_id` FOREIGN KEY (`smart_label_id`) REFERENCES `labels` (`label_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_label_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tokens`
--
ALTER TABLE `tokens`
  ADD CONSTRAINT `tokens_user_id_FK` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `users_to_marks`
--
ALTER TABLE `users_to_marks`
  ADD CONSTRAINT `FK_utm_label_id` FOREIGN KEY (`label_id`) REFERENCES `labels` (`label_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_utm_mark_id` FOREIGN KEY (`mark_id`) REFERENCES `marks` (`mark_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_utm_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `user_marks_to_tags`
--
ALTER TABLE `user_marks_to_tags`
  ADD CONSTRAINT `FK_umtt_mark_id` FOREIGN KEY (`users_to_mark_id`) REFERENCES `users_to_marks` (`users_to_mark_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_umtt_tag_id` FOREIGN KEY (`tag_id`) REFERENCES `tags` (`tag_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_umtt_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
