<?php
/**
 * @file
 * Definition of views_handler_field_user_link_edit.
 */

/**
 * Field handler to present a link to user edit.
 *
 * @ingroup views_field_handlers
 */
class views_handler_field_user_link_edit extends views_handler_field_user_link {
  function render_link($data, $values) {
    // Build a pseudo account object to be able to check the access.
    /** @var User $account */
    $account = entity_create('user', array());
    $account->uid = $data;

    if ($data && user_edit_access($account)) {
      $this->options['alter']['make_link'] = TRUE;

      $text = !empty($this->options['text']) ? $this->options['text'] : t('Edit');

      $this->options['alter']['path'] = "user/$data/edit";
      $this->options['alter']['query'] = backdrop_get_destination();

      return $text;
    }
  }
}
