<?php

/**
 * @copyright Copyright (C) 2016 Usha Singhai Neo Informatique Pvt. Ltd
 * @license https://www.gnu.org/licenses/gpl.html
 */
namespace products\utils;

use usni\UsniAdaptor;
/**
 * DownloadUtil class file.
 * 
 * @package products\utils
 */
class DownloadUtil
{
    /**
     * Get download types
     * @return array
     */
    public static function getDownloadTypes()
    {
        return [
            'file' => UsniAdaptor::t('application', 'File'),
            'image' => UsniAdaptor::t('application', 'Image'),
            'video' => UsniAdaptor::t('application', 'Video'),
        ];
    }
    
    /**
     * Get download options.
     * @return array
     */
    public static function getOptions()
    {
        return [
                    'download'      => UsniAdaptor::t('application', 'Download'),
                    'sendviamail'   => UsniAdaptor::t('application', 'Send via mail'),
               ];
    }
    
    /**
     * Get downloads.
     * @param array $downloads
     * @return string
     */
    public static function getdownloads($downloads)
    {
        $content  = null;
        if(is_array($downloads))
        {
            foreach($downloads as $download)
            {
                $url      = UsniAdaptor::createUrl('catalog/products/download/download', ['id' => $download['id']]);
                $content .= Html::a($download['name'], $url) . str_repeat('&nbsp', 3);
            }
        }
        else
        {
            $url        = UsniAdaptor::createUrl('catalog/products/download/download', ['id' => $downloads['id']]);
            $content    = Html::a($downloads['name'], $url) . str_repeat('&nbsp', 3);
        }
        return $content;
    }
}