<?php  //[STAMP] 8df679dfa8a55f46f1cc36fbc7320b9b
namespace _generated;

// This class was automatically generated by build task
// You should not change it manually as it will be overwritten on next build
// @codingStandardsIgnoreFile

trait UnitTesterActions
{
    /**
     * @return \Codeception\Scenario
     */
    abstract protected function getScenario();

    
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Handles and checks exception called inside callback function.
     * Either exception class name or exception instance should be provided.
     *
     * ```php
     * <?php
     * $I->expectException(MyException::class, function() {
     *     $this->doSomethingBad();
     * });
     *
     * $I->expectException(new MyException(), function() {
     *     $this->doSomethingBad();
     * });
     * ```
     * If you want to check message or exception code, you can pass them with exception instance:
     * ```php
     * <?php
     * // will check that exception MyException is thrown with "Don't do bad things" message
     * $I->expectException(new MyException("Don't do bad things"), function() {
     *     $this->doSomethingBad();
     * });
     * ```
     *
     * @deprecated Use expectThrowable() instead
     * @param \Exception|string $exception
     * @param callable $callback
     * @see \Codeception\Module\Asserts::expectException()
     */
    public function expectException($exception, $callback) {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('expectException', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Handles and checks throwables (Exceptions/Errors) called inside the callback function.
     * Either throwable class name or throwable instance should be provided.
     *
     * ```php
     * <?php
     * $I->expectThrowable(MyThrowable::class, function() {
     *     $this->doSomethingBad();
     * });
     *
     * $I->expectThrowable(new MyException(), function() {
     *     $this->doSomethingBad();
     * });
     * ```
     * If you want to check message or throwable code, you can pass them with throwable instance:
     * ```php
     * <?php
     * // will check that throwable MyError is thrown with "Don't do bad things" message
     * $I->expectThrowable(new MyError("Don't do bad things"), function() {
     *     $this->doSomethingBad();
     * });
     * ```
     *
     * @param \Throwable|string $throwable
     * @param callable $callback
     * @see \Codeception\Module\Asserts::expectThrowable()
     */
    public function expectThrowable($throwable, $callback) {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('expectThrowable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file does not exist.
     *
     * @param string $filename
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertFileNotExists()
     */
    public function assertFileNotExists($filename, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileNotExists', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a value is greater than or equal to another value.
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertGreaterOrEquals()
     */
    public function assertGreaterOrEquals($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertGreaterOrEquals', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is empty.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsEmpty()
     */
    public function assertIsEmpty($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsEmpty', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a value is smaller than or equal to another value.
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertLessOrEquals()
     */
    public function assertLessOrEquals($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertLessOrEquals', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string does not match a given regular expression.
     *
     * @param string $pattern
     * @param string $string
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNotRegExp()
     */
    public function assertNotRegExp($pattern, $string, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotRegExp', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string matches a given regular expression.
     *
     * @param string $pattern
     * @param string $string
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertRegExp()
     */
    public function assertRegExp($pattern, $string, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertRegExp', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Evaluates a PHPUnit\Framework\Constraint matcher object.
     *
     * @param $value
     * @param Constraint $constraint
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertThatItsNot()
     */
    public function assertThatItsNot($value, $constraint, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertThatItsNot', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that an array has a specified key.
     *
     * @param int|string $key
     * @param array|ArrayAccess $array
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertArrayHasKey()
     */
    public function assertArrayHasKey($key, $array, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertArrayHasKey', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that an array does not have a specified key.
     *
     * @param int|string $key
     * @param array|ArrayAccess $array
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertArrayNotHasKey()
     */
    public function assertArrayNotHasKey($key, $array, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertArrayNotHasKey', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a class has a specified attribute.
     *
     * @param string $attributeName
     * @param string $className
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertClassHasAttribute()
     */
    public function assertClassHasAttribute($attributeName, $className, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertClassHasAttribute', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a class has a specified static attribute.
     *
     * @param string $attributeName
     * @param string $className
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertClassHasStaticAttribute()
     */
    public function assertClassHasStaticAttribute($attributeName, $className, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertClassHasStaticAttribute', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a class does not have a specified attribute.
     *
     * @param string $attributeName
     * @param string $className
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertClassNotHasAttribute()
     */
    public function assertClassNotHasAttribute($attributeName, $className, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertClassNotHasAttribute', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a class does not have a specified static attribute.
     *
     * @param string $attributeName
     * @param string $className
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertClassNotHasStaticAttribute()
     */
    public function assertClassNotHasStaticAttribute($attributeName, $className, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertClassNotHasStaticAttribute', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a haystack contains a needle.
     *
     * @param $needle
     * @param $haystack
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertContains()
     */
    public function assertContains($needle, $haystack, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertContains', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * @param $needle
     * @param $haystack
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertContainsEquals()
     */
    public function assertContainsEquals($needle, $haystack, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertContainsEquals', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a haystack contains only values of a given type.
     *
     * @param string $type
     * @param $haystack
     * @param bool|null $isNativeType
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertContainsOnly()
     */
    public function assertContainsOnly($type, $haystack, $isNativeType = NULL, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertContainsOnly', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a haystack contains only instances of a given class name.
     *
     * @param string $className
     * @param $haystack
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertContainsOnlyInstancesOf()
     */
    public function assertContainsOnlyInstancesOf($className, $haystack, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertContainsOnlyInstancesOf', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts the number of elements of an array, Countable or Traversable.
     *
     * @param int $expectedCount
     * @param Countable|iterable $haystack
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertCount()
     */
    public function assertCount($expectedCount, $haystack, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertCount', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a directory does not exist.
     *
     * @param string $directory
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertDirectoryDoesNotExist()
     */
    public function assertDirectoryDoesNotExist($directory, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertDirectoryDoesNotExist', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a directory exists.
     *
     * @param string $directory
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertDirectoryExists()
     */
    public function assertDirectoryExists($directory, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertDirectoryExists', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a directory exists and is not readable.
     *
     * @param string $directory
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertDirectoryIsNotReadable()
     */
    public function assertDirectoryIsNotReadable($directory, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertDirectoryIsNotReadable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a directory exists and is not writable.
     *
     * @param string $directory
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertDirectoryIsNotWritable()
     */
    public function assertDirectoryIsNotWritable($directory, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertDirectoryIsNotWritable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a directory exists and is readable.
     *
     * @param string $directory
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertDirectoryIsReadable()
     */
    public function assertDirectoryIsReadable($directory, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertDirectoryIsReadable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a directory exists and is writable.
     *
     * @param string $directory
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertDirectoryIsWritable()
     */
    public function assertDirectoryIsWritable($directory, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertDirectoryIsWritable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string does not match a given regular expression.
     *
     * @param string $pattern
     * @param string $string
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertDoesNotMatchRegularExpression()
     */
    public function assertDoesNotMatchRegularExpression($pattern, $string, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertDoesNotMatchRegularExpression', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is empty.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertEmpty()
     */
    public function assertEmpty($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertEmpty', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables are equal.
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertEquals()
     */
    public function assertEquals($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertEquals', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables are equal (canonicalizing).
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertEqualsCanonicalizing()
     */
    public function assertEqualsCanonicalizing($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertEqualsCanonicalizing', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables are equal (ignoring case).
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertEqualsIgnoringCase()
     */
    public function assertEqualsIgnoringCase($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertEqualsIgnoringCase', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables are equal (with delta).
     *
     * @param $expected
     * @param $actual
     * @param float $delta
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertEqualsWithDelta()
     */
    public function assertEqualsWithDelta($expected, $actual, $delta, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertEqualsWithDelta', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a condition is false.
     *
     * @param $condition
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertFalse()
     */
    public function assertFalse($condition, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFalse', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file does not exist.
     *
     * @param string $filename
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertFileDoesNotExist()
     */
    public function assertFileDoesNotExist($filename, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileDoesNotExist', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of one file is equal to the contents of another file.
     *
     * @param string $expected
     * @param string $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertFileEquals()
     */
    public function assertFileEquals($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileEquals', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of one file is equal to the contents of another file (canonicalizing).
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertFileEqualsCanonicalizing()
     */
    public function assertFileEqualsCanonicalizing($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileEqualsCanonicalizing', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of one file is equal to the contents of another file (ignoring case).
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertFileEqualsIgnoringCase()
     */
    public function assertFileEqualsIgnoringCase($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileEqualsIgnoringCase', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file exists.
     *
     * @param string $filename
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertFileExists()
     */
    public function assertFileExists($filename, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileExists', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file exists and is not readable.
     *
     * @param string $file
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertFileIsNotReadable()
     */
    public function assertFileIsNotReadable($file, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileIsNotReadable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file exists and is not writable.
     *
     * @param string $file
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertFileIsNotWritable()
     */
    public function assertFileIsNotWritable($file, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileIsNotWritable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file exists and is readable.
     *
     * @param string $file
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertFileIsReadable()
     */
    public function assertFileIsReadable($file, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileIsReadable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file exists and is writable.
     *
     * @param string $file
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertFileIsWritable()
     */
    public function assertFileIsWritable($file, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileIsWritable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of one file is not equal to the contents of another file.
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertFileNotEquals()
     */
    public function assertFileNotEquals($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileNotEquals', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of one file is not equal to the contents of another file (canonicalizing).
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertFileNotEqualsCanonicalizing()
     */
    public function assertFileNotEqualsCanonicalizing($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileNotEqualsCanonicalizing', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of one file is not equal to the contents of another file (ignoring case).
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertFileNotEqualsIgnoringCase()
     */
    public function assertFileNotEqualsIgnoringCase($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFileNotEqualsIgnoringCase', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is finite.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertFinite()
     */
    public function assertFinite($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertFinite', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a value is greater than another value.
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertGreaterThan()
     */
    public function assertGreaterThan($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertGreaterThan', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a value is greater than or equal to another value.
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertGreaterThanOrEqual()
     */
    public function assertGreaterThanOrEqual($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertGreaterThanOrEqual', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is infinite.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertInfinite()
     */
    public function assertInfinite($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertInfinite', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of a given type.
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertInstanceOf()
     */
    public function assertInstanceOf($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertInstanceOf', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type array.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsArray()
     */
    public function assertIsArray($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsArray', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type bool.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsBool()
     */
    public function assertIsBool($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsBool', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type callable.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsCallable()
     */
    public function assertIsCallable($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsCallable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type resource and is closed.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsClosedResource()
     */
    public function assertIsClosedResource($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsClosedResource', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type float.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsFloat()
     */
    public function assertIsFloat($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsFloat', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type int.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsInt()
     */
    public function assertIsInt($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsInt', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type iterable.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsIterable()
     */
    public function assertIsIterable($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsIterable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type array.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsNotArray()
     */
    public function assertIsNotArray($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotArray', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type bool.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsNotBool()
     */
    public function assertIsNotBool($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotBool', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type callable.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsNotCallable()
     */
    public function assertIsNotCallable($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotCallable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type resource.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsNotClosedResource()
     */
    public function assertIsNotClosedResource($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotClosedResource', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type float.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsNotFloat()
     */
    public function assertIsNotFloat($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotFloat', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type int.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsNotInt()
     */
    public function assertIsNotInt($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotInt', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type iterable.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsNotIterable()
     */
    public function assertIsNotIterable($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotIterable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type numeric.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsNotNumeric()
     */
    public function assertIsNotNumeric($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotNumeric', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type object.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsNotObject()
     */
    public function assertIsNotObject($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotObject', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file/dir exists and is not readable.
     *
     * @param string $filename
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsNotReadable()
     */
    public function assertIsNotReadable($filename, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotReadable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type resource.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsNotResource()
     */
    public function assertIsNotResource($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotResource', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type scalar.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsNotScalar()
     */
    public function assertIsNotScalar($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotScalar', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of type string.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsNotString()
     */
    public function assertIsNotString($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotString', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file/dir exists and is not writable.
     *
     * @param $filename
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsNotWritable()
     */
    public function assertIsNotWritable($filename, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNotWritable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type numeric.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsNumeric()
     */
    public function assertIsNumeric($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsNumeric', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type object.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsObject()
     */
    public function assertIsObject($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsObject', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file/dir is readable.
     *
     * @param $filename
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsReadable()
     */
    public function assertIsReadable($filename, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsReadable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type resource.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsResource()
     */
    public function assertIsResource($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsResource', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type scalar.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsScalar()
     */
    public function assertIsScalar($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsScalar', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is of type string.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsString()
     */
    public function assertIsString($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsString', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a file/dir exists and is writable.
     *
     * @param $filename
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertIsWritable()
     */
    public function assertIsWritable($filename, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertIsWritable', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string is a valid JSON string.
     *
     * @param string $actualJson
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertJson()
     */
    public function assertJson($actualJson, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertJson', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two JSON files are equal.
     *
     * @param string $expectedFile
     * @param string $actualFile
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertJsonFileEqualsJsonFile()
     */
    public function assertJsonFileEqualsJsonFile($expectedFile, $actualFile, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertJsonFileEqualsJsonFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two JSON files are not equal.
     *
     * @param string $expectedFile
     * @param string $actualFile
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertJsonFileNotEqualsJsonFile()
     */
    public function assertJsonFileNotEqualsJsonFile($expectedFile, $actualFile, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertJsonFileNotEqualsJsonFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the generated JSON encoded object and the content of the given file are equal.
     *
     * @param string $expectedFile
     * @param string $actualJson
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertJsonStringEqualsJsonFile()
     */
    public function assertJsonStringEqualsJsonFile($expectedFile, $actualJson, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertJsonStringEqualsJsonFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two given JSON encoded objects or arrays are equal.
     *
     * @param string $expectedJson
     * @param string $actualJson
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertJsonStringEqualsJsonString()
     */
    public function assertJsonStringEqualsJsonString($expectedJson, $actualJson, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertJsonStringEqualsJsonString', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the generated JSON encoded object and the content of the given file are not equal.
     *
     * @param string $expectedFile
     * @param string $actualJson
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertJsonStringNotEqualsJsonFile()
     */
    public function assertJsonStringNotEqualsJsonFile($expectedFile, $actualJson, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertJsonStringNotEqualsJsonFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two given JSON encoded objects or arrays are not equal.
     *
     * @param string $expectedJson
     * @param string $actualJson
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertJsonStringNotEqualsJsonString()
     */
    public function assertJsonStringNotEqualsJsonString($expectedJson, $actualJson, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertJsonStringNotEqualsJsonString', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a value is smaller than another value.
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertLessThan()
     */
    public function assertLessThan($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertLessThan', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a value is smaller than or equal to another value.
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertLessThanOrEqual()
     */
    public function assertLessThanOrEqual($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertLessThanOrEqual', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string matches a given regular expression.
     *
     * @param string $pattern
     * @param string $string
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertMatchesRegularExpression()
     */
    public function assertMatchesRegularExpression($pattern, $string, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertMatchesRegularExpression', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is nan.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNan()
     */
    public function assertNan($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNan', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a haystack does not contain a needle.
     *
     * @param $needle
     * @param $haystack
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNotContains()
     */
    public function assertNotContains($needle, $haystack, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotContains', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     *
     * @see \Codeception\Module\AbstractAsserts::assertNotContainsEquals()
     */
    public function assertNotContainsEquals($needle, $haystack, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotContainsEquals', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a haystack does not contain only values of a given type.
     *
     * @param string $type
     * @param $haystack
     * @param bool|null $isNativeType
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNotContainsOnly()
     */
    public function assertNotContainsOnly($type, $haystack, $isNativeType = NULL, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotContainsOnly', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts the number of elements of an array, Countable or Traversable.
     *
     * @param int $expectedCount
     * @param Countable|iterable $haystack
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNotCount()
     */
    public function assertNotCount($expectedCount, $haystack, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotCount', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not empty.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNotEmpty()
     */
    public function assertNotEmpty($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotEmpty', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables are not equal.
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNotEquals()
     */
    public function assertNotEquals($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotEquals', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables are not equal (canonicalizing).
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNotEqualsCanonicalizing()
     */
    public function assertNotEqualsCanonicalizing($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotEqualsCanonicalizing', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables are not equal (ignoring case).
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNotEqualsIgnoringCase()
     */
    public function assertNotEqualsIgnoringCase($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotEqualsIgnoringCase', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables are not equal (with delta).
     *
     * @param $expected
     * @param $actual
     * @param float $delta
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNotEqualsWithDelta()
     */
    public function assertNotEqualsWithDelta($expected, $actual, $delta, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotEqualsWithDelta', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a condition is not false.
     *
     * @param $condition
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNotFalse()
     */
    public function assertNotFalse($condition, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotFalse', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not of a given type.
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNotInstanceOf()
     */
    public function assertNotInstanceOf($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotInstanceOf', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is not null.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNotNull()
     */
    public function assertNotNull($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotNull', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables do not have the same type and value.
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNotSame()
     */
    public function assertNotSame($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotSame', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Assert that the size of two arrays (or `Countable` or `Traversable` objects) is not the same.
     *
     * @param Countable|iterable $expected
     * @param Countable|iterable $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNotSameSize()
     */
    public function assertNotSameSize($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotSameSize', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a condition is not true.
     *
     * @param $condition
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNotTrue()
     */
    public function assertNotTrue($condition, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNotTrue', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a variable is null.
     *
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertNull()
     */
    public function assertNull($actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertNull', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that an object has a specified attribute.
     *
     * @param string $attributeName
     * @param object $object
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertObjectHasAttribute()
     */
    public function assertObjectHasAttribute($attributeName, $object, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertObjectHasAttribute', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that an object does not have a specified attribute.
     *
     * @param string $attributeName
     * @param object $object
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertObjectNotHasAttribute()
     */
    public function assertObjectNotHasAttribute($attributeName, $object, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertObjectNotHasAttribute', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two variables have the same type and value.
     *
     * @param $expected
     * @param $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertSame()
     */
    public function assertSame($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertSame', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Assert that the size of two arrays (or `Countable` or `Traversable` objects) is the same.
     *
     * @param Countable|iterable $expected
     * @param Countable|iterable $actual
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertSameSize()
     */
    public function assertSameSize($expected, $actual, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertSameSize', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * @param string $needle
     * @param string $haystack
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringContainsString()
     */
    public function assertStringContainsString($needle, $haystack, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringContainsString', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     *
     * @see \Codeception\Module\AbstractAsserts::assertStringContainsStringIgnoringCase()
     */
    public function assertStringContainsStringIgnoringCase($needle, $haystack, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringContainsStringIgnoringCase', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string ends not with a given suffix.
     *
     * @param string $suffix
     * @param string $string
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringEndsNotWith()
     */
    public function assertStringEndsNotWith($suffix, $string, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringEndsNotWith', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string ends with a given suffix.
     *
     * @param string $suffix
     * @param string $string
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringEndsWith()
     */
    public function assertStringEndsWith($suffix, $string, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringEndsWith', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of a string is equal to the contents of a file.
     *
     * @param string $expectedFile
     * @param string $actualString
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringEqualsFile()
     */
    public function assertStringEqualsFile($expectedFile, $actualString, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringEqualsFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of a string is equal to the contents of a file (canonicalizing).
     *
     * @param string $expectedFile
     * @param string $actualString
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringEqualsFileCanonicalizing()
     */
    public function assertStringEqualsFileCanonicalizing($expectedFile, $actualString, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringEqualsFileCanonicalizing', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of a string is equal to the contents of a file (ignoring case).
     *
     * @param string $expectedFile
     * @param string $actualString
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringEqualsFileIgnoringCase()
     */
    public function assertStringEqualsFileIgnoringCase($expectedFile, $actualString, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringEqualsFileIgnoringCase', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string matches a given format string.
     *
     * @param string $format
     * @param string $string
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringMatchesFormat()
     */
    public function assertStringMatchesFormat($format, $string, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringMatchesFormat', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string matches a given format file.
     *
     * @param string $formatFile
     * @param string $string
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringMatchesFormatFile()
     */
    public function assertStringMatchesFormatFile($formatFile, $string, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringMatchesFormatFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * @param string $needle
     * @param string $haystack
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringNotContainsString()
     */
    public function assertStringNotContainsString($needle, $haystack, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringNotContainsString', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * @param string $needle
     * @param string $haystack
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringNotContainsStringIgnoringCase()
     */
    public function assertStringNotContainsStringIgnoringCase($needle, $haystack, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringNotContainsStringIgnoringCase', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of a string is not equal to the contents of a file.
     *
     * @param string $expectedFile
     * @param string $actualString
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringNotEqualsFile()
     */
    public function assertStringNotEqualsFile($expectedFile, $actualString, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringNotEqualsFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of a string is not equal to the contents of a file (canonicalizing).
     * @param string $expectedFile
     * @param string $actualString
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringNotEqualsFileCanonicalizing()
     */
    public function assertStringNotEqualsFileCanonicalizing($expectedFile, $actualString, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringNotEqualsFileCanonicalizing', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that the contents of a string is not equal to the contents of a file (ignoring case).
     *
     * @param string $expectedFile
     * @param string $actualString
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringNotEqualsFileIgnoringCase()
     */
    public function assertStringNotEqualsFileIgnoringCase($expectedFile, $actualString, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringNotEqualsFileIgnoringCase', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string does not match a given format string.
     *
     * @param string $format
     * @param string $string
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringNotMatchesFormat()
     */
    public function assertStringNotMatchesFormat($format, $string, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringNotMatchesFormat', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string does not match a given format string.
     *
     * @param string $formatFile
     * @param string $string
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringNotMatchesFormatFile()
     */
    public function assertStringNotMatchesFormatFile($formatFile, $string, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringNotMatchesFormatFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string starts not with a given prefix.
     *
     * @param string $prefix
     * @param string $string
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringStartsNotWith()
     */
    public function assertStringStartsNotWith($prefix, $string, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringStartsNotWith', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a string starts with a given prefix.
     *
     * @param string $prefix
     * @param string $string
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertStringStartsWith()
     */
    public function assertStringStartsWith($prefix, $string, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertStringStartsWith', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Evaluates a PHPUnit\Framework\Constraint matcher object.
     *
     * @param $value
     * @param Constraint $constraint
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertThat()
     */
    public function assertThat($value, $constraint, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertThat', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that a condition is true.
     *
     * @param $condition
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertTrue()
     */
    public function assertTrue($condition, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertTrue', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two XML files are equal.
     *
     * @param string $expectedFile
     * @param string $actualFile
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertXmlFileEqualsXmlFile()
     */
    public function assertXmlFileEqualsXmlFile($expectedFile, $actualFile, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertXmlFileEqualsXmlFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two XML files are not equal.
     *
     * @param string $expectedFile
     * @param string $actualFile
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertXmlFileNotEqualsXmlFile()
     */
    public function assertXmlFileNotEqualsXmlFile($expectedFile, $actualFile, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertXmlFileNotEqualsXmlFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two XML documents are equal.
     *
     * @param string $expectedFile
     * @param DOMDocument|string $actualXml
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertXmlStringEqualsXmlFile()
     */
    public function assertXmlStringEqualsXmlFile($expectedFile, $actualXml, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertXmlStringEqualsXmlFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two XML documents are equal.
     *
     * @param DOMDocument|string $expectedXml
     * @param DOMDocument|string $actualXml
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertXmlStringEqualsXmlString()
     */
    public function assertXmlStringEqualsXmlString($expectedXml, $actualXml, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertXmlStringEqualsXmlString', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two XML documents are not equal.
     *
     * @param string $expectedFile
     * @param DOMDocument|string $actualXml
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertXmlStringNotEqualsXmlFile()
     */
    public function assertXmlStringNotEqualsXmlFile($expectedFile, $actualXml, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertXmlStringNotEqualsXmlFile', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that two XML documents are not equal.
     *
     * @param DOMDocument|string $expectedXml
     * @param DOMDocument|string $actualXml
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::assertXmlStringNotEqualsXmlString()
     */
    public function assertXmlStringNotEqualsXmlString($expectedXml, $actualXml, $message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('assertXmlStringNotEqualsXmlString', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Fails a test with the given message.
     *
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::fail()
     */
    public function fail($message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('fail', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Mark the test as incomplete.
     *
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::markTestIncomplete()
     */
    public function markTestIncomplete($message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('markTestIncomplete', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Mark the test as skipped.
     *
     * @param string $message
     * @see \Codeception\Module\AbstractAsserts::markTestSkipped()
     */
    public function markTestSkipped($message = "") {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('markTestSkipped', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     @throws ModuleException
     * @see \Codeception\Module\Phiremock::takeConnection()
     */
    public function takeConnection($name): \Codeception\Module\Phiremock {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('takeConnection', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     @throws ClientExceptionInterface
     * @see \Codeception\Module\Phiremock::expectARequestToRemoteServiceWithAResponse()
     */
    public function expectARequestToRemoteServiceWithAResponse($expectation): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('expectARequestToRemoteServiceWithAResponse', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     @throws ClientExceptionInterface
     * @see \Codeception\Module\Phiremock::haveACleanSetupInRemoteService()
     */
    public function haveACleanSetupInRemoteService(): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('haveACleanSetupInRemoteService', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     @throws ClientExceptionInterface
     * @see \Codeception\Module\Phiremock::dontExpectRequestsInRemoteService()
     */
    public function dontExpectRequestsInRemoteService(): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('dontExpectRequestsInRemoteService', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     @throws ClientExceptionInterface
     * @see \Codeception\Module\Phiremock::haveCleanScenariosInRemoteService()
     */
    public function haveCleanScenariosInRemoteService(): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('haveCleanScenariosInRemoteService', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * @deprecated Name is confusing, sounds like an assertion
     * @throws ClientExceptionInterface
     * @see \Codeception\Module\Phiremock::didNotReceiveRequestsInRemoteService()
     */
    public function didNotReceiveRequestsInRemoteService(): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('didNotReceiveRequestsInRemoteService', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     @throws ClientExceptionInterface
     * @see \Codeception\Module\Phiremock::dontHaveLoggedRequestsToRemoteService()
     */
    public function dontHaveLoggedRequestsToRemoteService(): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('dontHaveLoggedRequestsToRemoteService', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * @throws ClientExceptionInterface
     * @throws Exception
     * @see \Codeception\Module\Phiremock::seeRemoteServiceReceived()
     */
    public function seeRemoteServiceReceived($times, $builder): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeRemoteServiceReceived', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * @throws ClientExceptionInterface
     * @throws Exception
     * @see \Codeception\Module\Phiremock::seeRemoteServiceReceived()
     */
    public function canSeeRemoteServiceReceived($times, $builder): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeRemoteServiceReceived', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     @throws ClientExceptionInterface
     * @see \Codeception\Module\Phiremock::grabRequestsMadeToRemoteService()
     */
    public function grabRequestsMadeToRemoteService($builder): array {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('grabRequestsMadeToRemoteService', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     @throws ClientExceptionInterface
     * @see \Codeception\Module\Phiremock::setScenarioState()
     */
    public function setScenarioState($name, $state): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('setScenarioState', func_get_args()));
    }
}
